/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 155;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 139,
  Feature_isGFX6Bit = 61,
  Feature_isGFX6GFX7Bit = 12,
  Feature_isGFX6GFX7GFX10Bit = 136,
  Feature_isGFX7OnlyBit = 104,
  Feature_isGFX7GFX10GFX11Bit = 118,
  Feature_isGFX7GFX8GFX9Bit = 56,
  Feature_isGFX6GFX7GFX8GFX9Bit = 78,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 151,
  Feature_isNotGFX12PlusBit = 26,
  Feature_isGFX8GFX9GFX10GFX11Bit = 28,
  Feature_isGFX7PlusBit = 18,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 29,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 67,
  Feature_isGFX90APlusBit = 49,
  Feature_isNotGFX90APlusBit = 30,
  Feature_isGFX908orGFX90ABit = 50,
  Feature_isGFX940PlusBit = 51,
  Feature_isNotGFX940PlusBit = 62,
  Feature_HasGFX950InstsBit = 35,
  Feature_isGFX8GFX9Bit = 21,
  Feature_isGFX10OnlyBit = 20,
  Feature_isGFX10PlusBit = 9,
  Feature_isGFX9GFX10Bit = 68,
  Feature_isGFX11OnlyBit = 75,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 76,
  Feature_isGFX12PlusBit = 3,
  Feature_isGFX12PlusNot12_50Bit = 73,
  Feature_isGFX125xOnlyBit = 36,
  Feature_isGFX1250PlusBit = 8,
  Feature_isNotGFX1250PlusBit = 5,
  Feature_HasIEEEMinimumMaximumInstsBit = 23,
  Feature_HasMinimum3Maximum3F32Bit = 27,
  Feature_HasMinimum3Maximum3F16Bit = 32,
  Feature_HasMin3Max3PKF16Bit = 42,
  Feature_HasMinimum3Maximum3PKF16Bit = 43,
  Feature_HasFlatAddressSpaceBit = 106,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 124,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 132,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 123,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 113,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 114,
  Feature_HasLdsAtomicAddF64Bit = 154,
  Feature_HasFlatGlobalInstsBit = 108,
  Feature_HasFlatScratchInstsBit = 111,
  Feature_HasD16LoadStoreBit = 116,
  Feature_HasFlatScratchSVSModeBit = 112,
  Feature_HasFlatGVSModeBit = 107,
  Feature_HasGFX10_BEncodingBit = 60,
  Feature_HasUnpackedD16VMemBit = 130,
  Feature_HasPackedD16VMemBit = 131,
  Feature_HasUnrestrictedSOffsetBit = 128,
  Feature_D16PreservesUnusedBitsBit = 109,
  Feature_LDSRequiresM0InitBit = 146,
  Feature_NotLDSRequiresM0InitBit = 147,
  Feature_HasMTBUFInstsBit = 134,
  Feature_HasFormattedMUBUFInstsBit = 129,
  Feature_HasExportInstsBit = 11,
  Feature_HasLDSFPAtomicAddF32Bit = 153,
  Feature_HasAddNoCarryInstsBit = 77,
  Feature_NotHasAddNoCarryInstsBit = 144,
  Feature_HasXNACKEnabledBit = 103,
  Feature_Has16BitInstsBit = 13,
  Feature_NotHasTrue16BitInstsBit = 14,
  Feature_UseRealTrue16InstsBit = 15,
  Feature_NotUseRealTrue16InstsBit = 74,
  Feature_UseFakeTrue16InstsBit = 16,
  Feature_HasVOP3PInstsBit = 94,
  Feature_HasMed3_16Bit = 145,
  Feature_HasMinMaxDenormModesBit = 138,
  Feature_NotHasMinMaxDenormModesBit = 140,
  Feature_HasSDWABit = 72,
  Feature_HasPackedFP32OpsBit = 54,
  Feature_HasAddMinMaxInstsBit = 88,
  Feature_HasPkAddMinMaxInstsBit = 99,
  Feature_HasPkMinMax3InstsBit = 100,
  Feature_HasSGetShaderCyclesInstBit = 7,
  Feature_HasImageInstsBit = 10,
  Feature_HasIntClampBit = 83,
  Feature_HasMadMixInstsBit = 95,
  Feature_HasScalarStoresBit = 57,
  Feature_has16BankLDSBit = 63,
  Feature_has32BankLDSBit = 31,
  Feature_HasFmaMixInstsBit = 97,
  Feature_HasFmaMixBF16InstsBit = 98,
  Feature_HasDLInstsBit = 22,
  Feature_HasFmacF64InstBit = 143,
  Feature_HasDot1InstsBit = 47,
  Feature_HasDot2InstsBit = 44,
  Feature_HasDot3InstsBit = 82,
  Feature_HasDot4InstsBit = 81,
  Feature_HasDot5InstsBit = 79,
  Feature_HasDot6InstsBit = 80,
  Feature_HasDot7InstsBit = 46,
  Feature_HasDot8InstsBit = 101,
  Feature_HasDot9InstsBit = 39,
  Feature_HasDot10InstsBit = 45,
  Feature_HasDot11InstsBit = 102,
  Feature_HasGetWaveIdInstBit = 59,
  Feature_HasMAIInstsBit = 48,
  Feature_HasSMemRealTimeBit = 58,
  Feature_HasSMemTimeInstBit = 55,
  Feature_HasShaderCyclesRegisterBit = 105,
  Feature_HasShaderCyclesHiLoRegistersBit = 65,
  Feature_HasFP8InstsBit = 53,
  Feature_HasFP8ConversionInstsBit = 70,
  Feature_HasFP8E5M3InstsBit = 84,
  Feature_NotHasFP8E5M3InstsBit = 85,
  Feature_HasMadMacF32InstsBit = 24,
  Feature_HasFmaLegacy32Bit = 25,
  Feature_HasAtomicDsPkAdd16InstsBit = 152,
  Feature_HasAtomicFlatPkAdd16InstsBit = 126,
  Feature_HasAtomicFaddRtnInstsBit = 121,
  Feature_HasAtomicFaddNoRtnInstsBit = 119,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 120,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 122,
  Feature_HasFlatAtomicFaddF32InstBit = 125,
  Feature_EnableFlatScratchBit = 110,
  Feature_DisableFlatScratchBit = 133,
  Feature_HasUnalignedAccessModeBit = 150,
  Feature_HasMADIntraFwdBugBit = 90,
  Feature_HasNotMADIntraFwdBugBit = 89,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_NotHasSALUFloatInstsBit = 135,
  Feature_HasPseudoScalarTransBit = 40,
  Feature_HasBitOp3InstsBit = 92,
  Feature_HasTanhInstsBit = 17,
  Feature_HasTensorCvtLutInstsBit = 38,
  Feature_HasTransposeLoadF4F6InstsBit = 117,
  Feature_HasPrngInstBit = 19,
  Feature_Has64BitLiteralsBit = 66,
  Feature_HasFP6BF6ConversionScaleInstsBit = 33,
  Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit = 34,
  Feature_HasCvtPkF16F32InstBit = 91,
  Feature_HasF32ToF16BF16ConversionSRInstsBit = 93,
  Feature_HasGDSBit = 148,
  Feature_HasCvtFP8VOP1BugBit = 69,
  Feature_HasNoCvtFP8VOP1BugBit = 71,
  Feature_HasAtomicCSubNoRtnInstsBit = 115,
  Feature_HasXF32InstsBit = 52,
  Feature_HasVmemPrefInstsBit = 127,
  Feature_HasAshrPkInstsBit = 41,
  Feature_HasLshlAddU64InstBit = 87,
  Feature_HasMadU32InstBit = 86,
  Feature_HasLdsBarrierArriveAtomicBit = 149,
  Feature_HasSetPrioIncWgInstBit = 6,
  Feature_FP16DenormalsBit = 142,
  Feature_FP64DenormalsBit = 141,
  Feature_NoFP32DenormalsBit = 96,
  Feature_IEEEModeDisabledBit = 137,
  Feature_isWave32Bit = 37,
  Feature_isWave64Bit = 64,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX7GFX10GFX11Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (!Subtarget->hasGFX940Insts())
    Features.set(Feature_isNotGFX940PlusBit);
  if (Subtarget->hasGFX950Insts())
    Features.set(Feature_HasGFX950InstsBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12 && !Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX12PlusNot12_50Bit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX125xOnlyBit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX1250PlusBit);
  if (!Subtarget->hasGFX1250Insts())
    Features.set(Feature_isNotGFX1250PlusBit);
  if (Subtarget->hasIEEEMinimumMaximumInsts())
    Features.set(Feature_HasIEEEMinimumMaximumInstsBit);
  if (Subtarget->hasMinimum3Maximum3F32())
    Features.set(Feature_HasMinimum3Maximum3F32Bit);
  if (Subtarget->hasMinimum3Maximum3F16())
    Features.set(Feature_HasMinimum3Maximum3F16Bit);
  if (Subtarget->hasMin3Max3PKF16())
    Features.set(Feature_HasMin3Max3PKF16Bit);
  if (Subtarget->hasMinimum3Maximum3PKF16())
    Features.set(Feature_HasMinimum3Maximum3PKF16Bit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasFlatGVSMode())
    Features.set(Feature_HasFlatGVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasMTBUFInsts())
    Features.set(Feature_HasMTBUFInstsBit);
  if (Subtarget->hasFormattedMUBUFInsts())
    Features.set(Feature_HasFormattedMUBUFInstsBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (!Subtarget->useRealTrue16Insts())
    Features.set(Feature_NotUseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasSDWA())
    Features.set(Feature_HasSDWABit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasAddMinMaxInsts())
    Features.set(Feature_HasAddMinMaxInstsBit);
  if (Subtarget->hasPkAddMinMaxInsts())
    Features.set(Feature_HasPkAddMinMaxInstsBit);
  if (Subtarget->hasPkMinMax3Insts())
    Features.set(Feature_HasPkMinMax3InstsBit);
  if (Subtarget->hasSGetShaderCyclesInst())
    Features.set(Feature_HasSGetShaderCyclesInstBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasFmaMixBF16Insts())
    Features.set(Feature_HasFmaMixBF16InstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8Insts())
    Features.set(Feature_HasFP8InstsBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_HasFP8E5M3InstsBit);
  if (!Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_NotHasFP8E5M3InstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (!Subtarget->hasSALUFloatInsts())
    Features.set(Feature_NotHasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasBitOp3Insts())
    Features.set(Feature_HasBitOp3InstsBit);
  if (Subtarget->hasTanhInsts())
    Features.set(Feature_HasTanhInstsBit);
  if (Subtarget->hasTensorCvtLutInsts())
    Features.set(Feature_HasTensorCvtLutInstsBit);
  if (Subtarget->hasTransposeLoadF4F6Insts())
    Features.set(Feature_HasTransposeLoadF4F6InstsBit);
  if (Subtarget->hasPrngInst())
    Features.set(Feature_HasPrngInstBit);
  if (Subtarget->has64BitLiterals())
    Features.set(Feature_Has64BitLiteralsBit);
  if (Subtarget->hasFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasF16BF16ToFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasCvtPkF16F32Inst())
    Features.set(Feature_HasCvtPkF16F32InstBit);
  if (Subtarget->hasF32ToF16BF16ConversionSRInsts())
    Features.set(Feature_HasF32ToF16BF16ConversionSRInstsBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->hasXF32Insts())
    Features.set(Feature_HasXF32InstsBit);
  if (Subtarget->hasVmemPrefInsts())
    Features.set(Feature_HasVmemPrefInstsBit);
  if (Subtarget->hasAshrPkInsts())
    Features.set(Feature_HasAshrPkInstsBit);
  if (Subtarget->hasLshlAddU64Inst())
    Features.set(Feature_HasLshlAddU64InstBit);
  if (Subtarget->hasMadU32Inst())
    Features.set(Feature_HasMadU32InstBit);
  if (Subtarget->hasLdsBarrierArriveAtomic())
    Features.set(Feature_HasLdsBarrierArriveAtomicBit);
  if (Subtarget->hasSetPrioIncWgInst())
    Features.set(Feature_HasSetPrioIncWgInstBit);
  if (Subtarget->isWave32())
    Features.set(Feature_isWave32Bit);
  if (Subtarget->isWave64())
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().IEEE)
    Features.set(Feature_IEEEModeDisabledBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_D16PreservesUnusedBits,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddMinMaxInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAshrPkInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicDsPkAdd16Insts,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasBitOp3Insts,
  GIFBS_HasCvtPkF16F32Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasF16BF16ToFP6BF6ConversionScaleInsts,
  GIFBS_HasF32ToF16BF16ConversionSRInsts,
  GIFBS_HasFP6BF6ConversionScaleInsts,
  GIFBS_HasFP8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGVSMode,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasFormattedMUBUFInsts,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGFX950Insts,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIEEEMinimumMaximumInsts,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasLshlAddU64Inst,
  GIFBS_HasMAIInsts,
  GIFBS_HasMTBUFInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMadU32Inst,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasMinimum3Maximum3F32,
  GIFBS_HasMinimum3Maximum3PKF16,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPkAddMinMaxInsts,
  GIFBS_HasPkMinMax3Insts,
  GIFBS_HasPrngInst,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSGetShaderCyclesInst,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasSetPrioIncWgInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasTanhInsts,
  GIFBS_HasTensorCvtLutInsts,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasVmemPrefInsts,
  GIFBS_HasXF32Insts,
  GIFBS_HasXNACKEnabled,
  GIFBS_IEEEModeDisabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_NotUseRealTrue16Insts,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX1250Plus,
  GIFBS_isGFX125xOnly,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX12PlusNot12_50,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX10GFX11,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX1250Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX940Plus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_D16PreservesUnusedBits_DisableFlatScratch,
  GIFBS_D16PreservesUnusedBits_HasFlatGVSMode,
  GIFBS_D16PreservesUnusedBits_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_HasFlatGVSMode,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGVSMode,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatGVSMode,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFlatPkAdd16Insts_HasFlatGVSMode,
  GIFBS_HasBitOp3Insts_isGFX940Plus,
  GIFBS_HasCvtFP8VOP1Bug_HasFP8ConversionInsts,
  GIFBS_HasD16LoadStore_HasFlatGVSMode,
  GIFBS_HasD16LoadStore_HasFlatGlobalInsts,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasDot9Insts_NotHasTrue16BitInsts,
  GIFBS_HasDot9Insts_UseFakeTrue16Insts,
  GIFBS_HasDot9Insts_UseRealTrue16Insts,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasSDWA,
  GIFBS_HasFP8ConversionInsts_isGFX125xOnly,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX12PlusNot12_50,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8Insts_isGFX90APlus,
  GIFBS_HasFlatAddressSpace_HasFlatGVSMode,
  GIFBS_HasFlatAddressSpace_NotUseRealTrue16Insts,
  GIFBS_HasFlatAtomicFaddF32Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGVSMode_NotUseRealTrue16Insts,
  GIFBS_HasFlatGVSMode_isGFX12Only,
  GIFBS_HasFlatGVSMode_isGFX12Plus,
  GIFBS_HasFlatGVSMode_isGFX7GFX10GFX11,
  GIFBS_HasFlatGlobalInsts_NotUseRealTrue16Insts,
  GIFBS_HasFmaMixBF16Insts_UseRealTrue16Insts,
  GIFBS_HasFmaMixInsts_NotUseRealTrue16Insts,
  GIFBS_HasFmaMixInsts_UseRealTrue16Insts,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasGFX950Insts_isGFX90APlus,
  GIFBS_HasIEEEMinimumMaximumInsts_NotHasTrue16BitInsts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseFakeTrue16Insts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseRealTrue16Insts,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasLdsBarrierArriveAtomic_isGFX1250Plus,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMAIInsts_isGFX90APlus,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMed3_16_NotHasTrue16BitInsts,
  GIFBS_HasMed3_16_UseFakeTrue16Insts,
  GIFBS_HasMed3_16_UseRealTrue16Insts,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasTanhInsts_UseFakeTrue16Insts,
  GIFBS_HasTanhInsts_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isWave32,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasVOP3PInsts_IEEEModeDisabled,
  GIFBS_HasVOP3PInsts_NotUseRealTrue16Insts,
  GIFBS_HasVOP3PInsts_UseFakeTrue16Insts,
  GIFBS_HasVOP3PInsts_UseRealTrue16Insts,
  GIFBS_HasXF32Insts_isGFX90APlus,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX125xOnly,
  GIFBS_NotHasTrue16BitInsts_isGFX9GFX10,
  GIFBS_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_NotHasTrue16BitInsts_isNotGFX9Plus,
  GIFBS_NotLDSRequiresM0Init_NotUseRealTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_UseRealTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotUseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseFakeTrue16Insts_isGFX10Plus,
  GIFBS_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_UseFakeTrue16Insts_isGFX125xOnly,
  GIFBS_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_UseRealTrue16Insts_isGFX10Plus,
  GIFBS_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_UseRealTrue16Insts_isGFX125xOnly,
  GIFBS_UseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseRealTrue16Insts_isGFX9Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX1250Plus_isWave32,
  GIFBS_isGFX125xOnly_isWave32,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave64,
  GIFBS_isGFX90APlus_isGFX908orGFX90A,
  GIFBS_isGFX90APlus_isGFX940Plus,
  GIFBS_D16PreservesUnusedBits_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_D16PreservesUnusedBits_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_NotUseRealTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseRealTrue16Insts,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_HasTanhInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX1250Plus,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasBitOp3Insts_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_HasBitOp3Insts_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasNoCvtFP8VOP1Bug_HasSDWA,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_HasTransposeLoadF4F6Insts_isGFX1250Plus_isWave32,
  GIFBS_D16PreservesUnusedBits_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_HasFlatGVSMode_UseRealTrue16Insts,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_NotUseRealTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseRealTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_NotHasTrue16BitInsts_isGFX9Plus,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_D16PreservesUnusedBitsBit, },
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddMinMaxInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAshrPkInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasBitOp3InstsBit, },
  {Feature_HasCvtPkF16F32InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit, },
  {Feature_HasF32ToF16BF16ConversionSRInstsBit, },
  {Feature_HasFP6BF6ConversionScaleInstsBit, },
  {Feature_HasFP8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasFormattedMUBUFInstsBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGFX950InstsBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasLshlAddU64InstBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMTBUFInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMadU32InstBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasMinimum3Maximum3F32Bit, },
  {Feature_HasMinimum3Maximum3PKF16Bit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPkAddMinMaxInstsBit, },
  {Feature_HasPkMinMax3InstsBit, },
  {Feature_HasPrngInstBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSGetShaderCyclesInstBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasSetPrioIncWgInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasTanhInstsBit, },
  {Feature_HasTensorCvtLutInstsBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasVmemPrefInstsBit, },
  {Feature_HasXF32InstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_IEEEModeDisabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_NotUseRealTrue16InstsBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX1250PlusBit, },
  {Feature_isGFX125xOnlyBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX12PlusNot12_50Bit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX10GFX11Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX1250PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX940PlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_DisableFlatScratchBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatGVSModeBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasBitOp3InstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_HasFP8ConversionInstsBit, },
  {Feature_HasD16LoadStoreBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasD16LoadStoreBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasDot9InstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusNot12_50Bit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGVSModeBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12OnlyBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX7GFX10GFX11Bit, },
  {Feature_HasFlatGlobalInstsBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_HasFmaMixBF16InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasGFX950InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasLdsBarrierArriveAtomicBit, Feature_isGFX1250PlusBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMAIInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMed3_16Bit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasTanhInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasTanhInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isWave32Bit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasVOP3PInstsBit, Feature_IEEEModeDisabledBit, },
  {Feature_HasVOP3PInstsBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasXF32InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9GFX10Bit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isNotGFX9PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseRealTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotUseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX125xOnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave64Bit, },
  {Feature_isGFX90APlusBit, Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, Feature_isGFX940PlusBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasTanhInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX1250PlusBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasNoCvtFP8VOP1BugBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_NotUseRealTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_global_saddr_cpol,
  GICP_gi_global_saddr_cpol_m0,
  GICP_gi_global_saddr_glc,
  GICP_gi_global_saddr_no_ioffset,
  GICP_gi_global_saddr_no_ioffset_m0,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex32,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectGlobalSAddrCPol, // gi_global_saddr_cpol
  &AMDGPUInstructionSelector::selectGlobalSAddrCPolM0, // gi_global_saddr_cpol_m0
  &AMDGPUInstructionSelector::selectGlobalSAddrGLC, // gi_global_saddr_glc
  &AMDGPUInstructionSelector::selectGlobalSAddrNoIOffset, // gi_global_saddr_no_ioffset
  &AMDGPUInstructionSelector::selectGlobalSAddrNoIOffsetM0, // gi_global_saddr_no_ioffset_m0
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex32, // gi_swmmacindex32
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_16734,
  GICXXPred_MI_Predicate_anonymous_16737,
  GICXXPred_MI_Predicate_anonymous_16738,
  GICXXPred_MI_Predicate_anonymous_16739,
  GICXXPred_MI_Predicate_anonymous_16740,
  GICXXPred_MI_Predicate_anonymous_16741,
  GICXXPred_MI_Predicate_anonymous_16744,
  GICXXPred_MI_Predicate_anonymous_16745,
  GICXXPred_MI_Predicate_anonymous_16746,
  GICXXPred_MI_Predicate_anonymous_16747,
  GICXXPred_MI_Predicate_anonymous_16748,
  GICXXPred_MI_Predicate_anonymous_16749,
  GICXXPred_MI_Predicate_anonymous_16750,
  GICXXPred_MI_Predicate_anonymous_16751,
  GICXXPred_MI_Predicate_anonymous_16752,
  GICXXPred_MI_Predicate_anonymous_16753,
  GICXXPred_MI_Predicate_anonymous_16754,
  GICXXPred_MI_Predicate_anonymous_16755,
  GICXXPred_MI_Predicate_anonymous_16756,
  GICXXPred_MI_Predicate_anonymous_16757,
  GICXXPred_MI_Predicate_anonymous_16758,
  GICXXPred_MI_Predicate_anonymous_16759,
  GICXXPred_MI_Predicate_anonymous_16760,
  GICXXPred_MI_Predicate_anonymous_16761,
  GICXXPred_MI_Predicate_anonymous_16762,
  GICXXPred_MI_Predicate_anonymous_16763,
  GICXXPred_MI_Predicate_anonymous_16764,
  GICXXPred_MI_Predicate_anonymous_16765,
  GICXXPred_MI_Predicate_anonymous_16766,
  GICXXPred_MI_Predicate_anonymous_16767,
  GICXXPred_MI_Predicate_anonymous_16768,
  GICXXPred_MI_Predicate_anonymous_16769,
  GICXXPred_MI_Predicate_anonymous_16770,
  GICXXPred_MI_Predicate_anonymous_16771,
  GICXXPred_MI_Predicate_anonymous_16772,
  GICXXPred_MI_Predicate_anonymous_16773,
  GICXXPred_MI_Predicate_anonymous_16774,
  GICXXPred_MI_Predicate_anonymous_16775,
  GICXXPred_MI_Predicate_anonymous_16776,
  GICXXPred_MI_Predicate_anonymous_16777,
  GICXXPred_MI_Predicate_anonymous_16778,
  GICXXPred_MI_Predicate_anonymous_16779,
  GICXXPred_MI_Predicate_anonymous_16780,
  GICXXPred_MI_Predicate_anonymous_16781,
  GICXXPred_MI_Predicate_anonymous_16782,
  GICXXPred_MI_Predicate_anonymous_16783,
  GICXXPred_MI_Predicate_anonymous_16784,
  GICXXPred_MI_Predicate_anonymous_16785,
  GICXXPred_MI_Predicate_anonymous_16786,
  GICXXPred_MI_Predicate_anonymous_16787,
  GICXXPred_MI_Predicate_anonymous_16797,
  GICXXPred_MI_Predicate_anonymous_16809,
  GICXXPred_MI_Predicate_anonymous_21436,
  GICXXPred_MI_Predicate_anonymous_22728,
  GICXXPred_MI_Predicate_anonymous_22730,
  GICXXPred_MI_Predicate_anonymous_22734,
  GICXXPred_MI_Predicate_anonymous_22736,
  GICXXPred_MI_Predicate_anonymous_23079,
  GICXXPred_MI_Predicate_anonymous_23141,
  GICXXPred_MI_Predicate_anonymous_23143,
  GICXXPred_MI_Predicate_anonymous_23145,
  GICXXPred_MI_Predicate_anonymous_23147,
  GICXXPred_MI_Predicate_anonymous_23149,
  GICXXPred_MI_Predicate_anonymous_23153,
  GICXXPred_MI_Predicate_anonymous_23155,
  GICXXPred_MI_Predicate_anonymous_23157,
  GICXXPred_MI_Predicate_anonymous_23159,
  GICXXPred_MI_Predicate_anonymous_23161,
  GICXXPred_MI_Predicate_anonymous_23427,
  GICXXPred_MI_Predicate_anonymous_23429,
  GICXXPred_MI_Predicate_anonymous_23885,
  GICXXPred_MI_Predicate_anonymous_24485,
  GICXXPred_MI_Predicate_anonymous_24488,
  GICXXPred_MI_Predicate_anonymous_24491,
  GICXXPred_MI_Predicate_anonymous_24493,
  GICXXPred_MI_Predicate_anonymous_24496,
  GICXXPred_MI_Predicate_anonymous_24498,
  GICXXPred_MI_Predicate_anonymous_24501,
  GICXXPred_MI_Predicate_anonymous_24504,
  GICXXPred_MI_Predicate_anonymous_24507,
  GICXXPred_MI_Predicate_anonymous_24511,
  GICXXPred_MI_Predicate_anonymous_24514,
  GICXXPred_MI_Predicate_anonymous_24516,
  GICXXPred_MI_Predicate_anonymous_24518,
  GICXXPred_MI_Predicate_anonymous_24520,
  GICXXPred_MI_Predicate_anonymous_24522,
  GICXXPred_MI_Predicate_anonymous_24975,
  GICXXPred_MI_Predicate_anonymous_25880,
  GICXXPred_MI_Predicate_anonymous_25883,
  GICXXPred_MI_Predicate_anonymous_25885,
  GICXXPred_MI_Predicate_anonymous_25887,
  GICXXPred_MI_Predicate_anonymous_25889,
  GICXXPred_MI_Predicate_anonymous_25891,
  GICXXPred_MI_Predicate_anonymous_25893,
  GICXXPred_MI_Predicate_anonymous_26186,
  GICXXPred_MI_Predicate_anonymous_26189,
  GICXXPred_MI_Predicate_anonymous_26192,
  GICXXPred_MI_Predicate_anonymous_26195,
  GICXXPred_MI_Predicate_anonymous_27702,
  GICXXPred_MI_Predicate_anonymous_27704,
  GICXXPred_MI_Predicate_anonymous_27708,
  GICXXPred_MI_Predicate_anonymous_27710,
  GICXXPred_MI_Predicate_anonymous_27712,
  GICXXPred_MI_Predicate_anonymous_27714,
  GICXXPred_MI_Predicate_anonymous_27718,
  GICXXPred_MI_Predicate_anonymous_27720,
  GICXXPred_MI_Predicate_anonymous_27722,
  GICXXPred_MI_Predicate_anonymous_27724,
  GICXXPred_MI_Predicate_anonymous_27726,
  GICXXPred_MI_Predicate_anonymous_27728,
  GICXXPred_MI_Predicate_anonymous_27730,
  GICXXPred_MI_Predicate_anonymous_27732,
  GICXXPred_MI_Predicate_anonymous_27736,
  GICXXPred_MI_Predicate_anonymous_27738,
  GICXXPred_MI_Predicate_anonymous_27740,
  GICXXPred_MI_Predicate_anonymous_27742,
  GICXXPred_MI_Predicate_anonymous_27746,
  GICXXPred_MI_Predicate_anonymous_27748,
  GICXXPred_MI_Predicate_anonymous_27752,
  GICXXPred_MI_Predicate_anonymous_27754,
  GICXXPred_MI_Predicate_anonymous_27756,
  GICXXPred_MI_Predicate_anonymous_27758,
  GICXXPred_MI_Predicate_anonymous_27762,
  GICXXPred_MI_Predicate_anonymous_27764,
  GICXXPred_MI_Predicate_anonymous_27766,
  GICXXPred_MI_Predicate_anonymous_27768,
  GICXXPred_MI_Predicate_anonymous_27770,
  GICXXPred_MI_Predicate_anonymous_27772,
  GICXXPred_MI_Predicate_anonymous_27774,
  GICXXPred_MI_Predicate_anonymous_27776,
  GICXXPred_MI_Predicate_anonymous_27780,
  GICXXPred_MI_Predicate_anonymous_27782,
  GICXXPred_MI_Predicate_anonymous_27784,
  GICXXPred_MI_Predicate_anonymous_27786,
  GICXXPred_MI_Predicate_anonymous_27790,
  GICXXPred_MI_Predicate_anonymous_27792,
  GICXXPred_MI_Predicate_anonymous_27794,
  GICXXPred_MI_Predicate_anonymous_27796,
  GICXXPred_MI_Predicate_anonymous_27798,
  GICXXPred_MI_Predicate_anonymous_27800,
  GICXXPred_MI_Predicate_anonymous_27804,
  GICXXPred_MI_Predicate_anonymous_27806,
  GICXXPred_MI_Predicate_anonymous_27808,
  GICXXPred_MI_Predicate_anonymous_27810,
  GICXXPred_MI_Predicate_anonymous_27812,
  GICXXPred_MI_Predicate_anonymous_27814,
  GICXXPred_MI_Predicate_anonymous_27818,
  GICXXPred_MI_Predicate_anonymous_27820,
  GICXXPred_MI_Predicate_anonymous_27824,
  GICXXPred_MI_Predicate_anonymous_27826,
  GICXXPred_MI_Predicate_anonymous_27828,
  GICXXPred_MI_Predicate_anonymous_27830,
  GICXXPred_MI_Predicate_anonymous_27850,
  GICXXPred_MI_Predicate_anonymous_27852,
  GICXXPred_MI_Predicate_anonymous_27886,
  GICXXPred_MI_Predicate_anonymous_27888,
  GICXXPred_MI_Predicate_anonymous_27908,
  GICXXPred_MI_Predicate_anonymous_27910,
  GICXXPred_MI_Predicate_anonymous_27948,
  GICXXPred_MI_Predicate_anonymous_27950,
  GICXXPred_MI_Predicate_anonymous_27954,
  GICXXPred_MI_Predicate_anonymous_27956,
  GICXXPred_MI_Predicate_anonymous_27958,
  GICXXPred_MI_Predicate_anonymous_27960,
  GICXXPred_MI_Predicate_anonymous_27962,
  GICXXPred_MI_Predicate_anonymous_27964,
  GICXXPred_MI_Predicate_anonymous_27966,
  GICXXPred_MI_Predicate_anonymous_27968,
  GICXXPred_MI_Predicate_anonymous_27972,
  GICXXPred_MI_Predicate_anonymous_27974,
  GICXXPred_MI_Predicate_anonymous_27976,
  GICXXPred_MI_Predicate_anonymous_27978,
  GICXXPred_MI_Predicate_anonymous_27982,
  GICXXPred_MI_Predicate_anonymous_27984,
  GICXXPred_MI_Predicate_anonymous_27986,
  GICXXPred_MI_Predicate_anonymous_27988,
  GICXXPred_MI_Predicate_anonymous_27990,
  GICXXPred_MI_Predicate_anonymous_27992,
  GICXXPred_MI_Predicate_anonymous_27996,
  GICXXPred_MI_Predicate_anonymous_27998,
  GICXXPred_MI_Predicate_anonymous_28000,
  GICXXPred_MI_Predicate_anonymous_28002,
  GICXXPred_MI_Predicate_anonymous_28004,
  GICXXPred_MI_Predicate_anonymous_28006,
  GICXXPred_MI_Predicate_anonymous_28008,
  GICXXPred_MI_Predicate_anonymous_28010,
  GICXXPred_MI_Predicate_anonymous_28012,
  GICXXPred_MI_Predicate_anonymous_28014,
  GICXXPred_MI_Predicate_anonymous_28018,
  GICXXPred_MI_Predicate_anonymous_28020,
  GICXXPred_MI_Predicate_anonymous_28022,
  GICXXPred_MI_Predicate_anonymous_28024,
  GICXXPred_MI_Predicate_anonymous_28026,
  GICXXPred_MI_Predicate_anonymous_28028,
  GICXXPred_MI_Predicate_anonymous_28030,
  GICXXPred_MI_Predicate_anonymous_28032,
  GICXXPred_MI_Predicate_anonymous_40372,
  GICXXPred_MI_Predicate_anonymous_40377,
  GICXXPred_MI_Predicate_anonymous_40379,
  GICXXPred_MI_Predicate_anonymous_40828,
  GICXXPred_MI_Predicate_anonymous_40830,
  GICXXPred_MI_Predicate_anonymous_40877,
  GICXXPred_MI_Predicate_anonymous_40902,
  GICXXPred_MI_Predicate_anonymous_40903,
  GICXXPred_MI_Predicate_anonymous_40906,
  GICXXPred_MI_Predicate_anonymous_40909,
  GICXXPred_MI_Predicate_anonymous_40912,
  GICXXPred_MI_Predicate_anonymous_40916,
  GICXXPred_MI_Predicate_anonymous_40919,
  GICXXPred_MI_Predicate_anonymous_40922,
  GICXXPred_MI_Predicate_anonymous_40924,
  GICXXPred_MI_Predicate_anonymous_40925,
  GICXXPred_MI_Predicate_anonymous_40931,
  GICXXPred_MI_Predicate_anonymous_40933,
  GICXXPred_MI_Predicate_anonymous_40941,
  GICXXPred_MI_Predicate_anonymous_40946,
  GICXXPred_MI_Predicate_anonymous_40950,
  GICXXPred_MI_Predicate_anonymous_40954,
  GICXXPred_MI_Predicate_anonymous_40964,
  GICXXPred_MI_Predicate_anonymous_41124,
  GICXXPred_MI_Predicate_anonymous_41127,
  GICXXPred_MI_Predicate_anonymous_41142,
  GICXXPred_MI_Predicate_anonymous_41207,
  GICXXPred_MI_Predicate_anonymous_41209,
  GICXXPred_MI_Predicate_anonymous_41263,
  GICXXPred_MI_Predicate_anonymous_41295,
  GICXXPred_MI_Predicate_anonymous_41297,
  GICXXPred_MI_Predicate_anonymous_41326,
  GICXXPred_MI_Predicate_anonymous_41328,
  GICXXPred_MI_Predicate_anonymous_41330,
  GICXXPred_MI_Predicate_anonymous_41332,
  GICXXPred_MI_Predicate_anonymous_41334,
  GICXXPred_MI_Predicate_anonymous_41364,
  GICXXPred_MI_Predicate_anonymous_41366,
  GICXXPred_MI_Predicate_bf16_fpround,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_prefetch_flat,
  GICXXPred_MI_Predicate_prefetch_global,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_16734: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16737: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16738: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16739: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16740: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16741: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16744: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16745: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16746: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16747: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16748: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16749: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16750: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16751: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16752: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16753: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16754: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16755: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16756: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16757: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16758: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16759: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16760: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16761: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16762: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16763: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16764: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16765: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16766: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16767: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16768: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16769: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16770: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16771: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16772: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16773: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16774: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16775: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16776: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16777: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16778: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16779: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16780: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16781: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16782: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16783: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16784: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16785: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16786: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16787: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16797: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16809: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21436: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22728: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22730: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22734: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22736: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23079: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23141: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23143: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23145: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23147: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23149: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23153: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23155: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23157: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23159: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23161: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23427: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23429: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23885: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24485: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24485 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24488: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24488 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24491: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24491 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24493: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24493 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24496: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24496 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24498: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24498 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24501: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24501 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24504: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24504 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24507: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24507 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24511: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24511 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24514: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24514 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24516: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24516 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24518: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24518 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24520: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24520 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24522: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24522 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24975: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24975 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_25880: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25883: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25885: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25887: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25889: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25891: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25893: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_26186: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26186 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26189: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26189 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26192: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26192 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26195: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26195 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_27702: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27704: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27708: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27710: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27712: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27714: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27718: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27720: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27722: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27724: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27726: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27728: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27730: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27732: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27736: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27738: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27740: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27742: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27746: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27748: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27752: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27754: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27756: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27758: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27762: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27764: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27766: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27768: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27770: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27772: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27774: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27776: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27780: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27782: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27784: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27786: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27790: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27792: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27794: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27796: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27798: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27800: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27804: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27806: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27808: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27810: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27812: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27814: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27818: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27820: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27824: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27826: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27828: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27830: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27850: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27852: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27886: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27888: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27908: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27910: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27948: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27950: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27954: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27956: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27958: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27960: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27962: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27964: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27966: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27968: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27972: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27974: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27976: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27978: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27982: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27984: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27986: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27988: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27990: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27992: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27996: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27998: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28000: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28002: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28004: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28006: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28008: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28010: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28012: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28014: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28018: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28020: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28022: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28024: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28026: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28028: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28030: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_28032: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_40372: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40377: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40379: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40828: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40830: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40877: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40902: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40903: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40906: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40909: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40912: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40916: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40919: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40922: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40924: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40925: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40931: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40933: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40941: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40946: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40950: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40954: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40964: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41124: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41127: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41142: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41207: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41209: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41263: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_41263 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_41295: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41297: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41326: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_41326 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_41328: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41330: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41332: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41334: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41364: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41366: {
    return true;
  }
  case GICXXPred_MI_Predicate_bf16_fpround: {
    return false;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_prefetch_flat: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::FLAT_ADDRESS;
      
  }
  case GICXXPred_MI_Predicate_prefetch_global: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::GLOBAL_ADDRESS ||
                ((*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::CONSTANT_ADDRESS &&
                 !Subtarget->hasSafeSmemPrefetch());
      
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI) && Subtarget->hasSafeSmemPrefetch();
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool AMDGPUInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_MFMALdScaleModifierOp,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_SupportedRoundMode,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_MFMALdScaleModifierOp: {
    
      return isUInt<2>(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_SupportedRoundMode: {
    
      return Imm == (int)RoundingMode::TowardZero ||
             Imm == (int)RoundingMode::NearestTiesToEven ||
             Imm == (int)RoundingMode::TowardPositive ||
             Imm == (int)RoundingMode::TowardNegative;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastFPImm32,
  GICR_renderBitcastFPImm64,
  GICR_renderDstSelToOpSel3XFormXForm,
  GICR_renderDstSelToOpSelXForm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderPrefetchLoc,
  GICR_renderRoundMode,
  GICR_renderScaledMAIIntrinsicOperand,
  GICR_renderSrcAndDstSelToOpSelXForm_0_0,
  GICR_renderSrcAndDstSelToOpSelXForm_0_1,
  GICR_renderSrcAndDstSelToOpSelXForm_1_0,
  GICR_renderSrcAndDstSelToOpSelXForm_1_1,
  GICR_renderSrcAndDstSelToOpSelXForm_2_0,
  GICR_renderSrcSelToOpSelXForm,
  GICR_renderTruncTImm,
  GICR_renderVOP3PModsNeg,
  GICR_renderVOP3PModsNegAbs,
  GICR_renderVOP3PModsNegs,
  GICR_renderZextBoolTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastFPImm32,
  &AMDGPUInstructionSelector::renderBitcastFPImm64,
  &AMDGPUInstructionSelector::renderDstSelToOpSel3XFormXForm,
  &AMDGPUInstructionSelector::renderDstSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderPrefetchLoc,
  &AMDGPUInstructionSelector::renderRoundMode,
  &AMDGPUInstructionSelector::renderScaledMAIIntrinsicOperand,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_2_0,
  &AMDGPUInstructionSelector::renderSrcSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderTruncTImm,
  &AMDGPUInstructionSelector::renderVOP3PModsNeg,
  &AMDGPUInstructionSelector::renderVOP3PModsNegAbs,
  &AMDGPUInstructionSelector::renderVOP3PModsNegs,
  &AMDGPUInstructionSelector::renderZextBoolTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(4048), /*)*//*default:*//*Label 176*/ GIMT_Encode4(832058),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(15990),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(39554),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(40177), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(40615),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(42589),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(58658), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     74 */ /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(65933), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(65988), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(69491), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    138 */ /*TargetOpcode::G_INTRINSIC_FPTRUNC_ROUND*//*Label 9*/ GIMT_Encode4(78655),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(78850), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 11*/ GIMT_Encode4(79178),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ GIMT_Encode4(79506),
     /*    166 */ /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 13*/ GIMT_Encode4(79667),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 14*/ GIMT_Encode4(79725),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ GIMT_Encode4(150940),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ GIMT_Encode4(158042), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 17*/ GIMT_Encode4(165686), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ GIMT_Encode4(202992),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ GIMT_Encode4(204118),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ GIMT_Encode4(206830),
     /*    218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ GIMT_Encode4(209842),
     /*    222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ GIMT_Encode4(212854), GIMT_Encode4(0),
     /*    230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ GIMT_Encode4(215866),
     /*    234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ GIMT_Encode4(218878),
     /*    238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ GIMT_Encode4(221890),
     /*    242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ GIMT_Encode4(224902),
     /*    246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ GIMT_Encode4(227914),
     /*    250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ GIMT_Encode4(230926),
     /*    254 */ /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 29*/ GIMT_Encode4(233938), GIMT_Encode4(0),
     /*    262 */ /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 30*/ GIMT_Encode4(236119),
     /*    266 */ /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 31*/ GIMT_Encode4(239389), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    278 */ /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 32*/ GIMT_Encode4(242659),
     /*    282 */ /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 33*/ GIMT_Encode4(245671), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 34*/ GIMT_Encode4(248683),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 35*/ GIMT_Encode4(248702), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(249715),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(271282),
     /*    322 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(278644),
     /*    326 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(314060),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(317204),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(317775), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(318066),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(318766), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(319026), GIMT_Encode4(0),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(320202),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(323517),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(325201),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(326511), GIMT_Encode4(0),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(327821),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(328119), GIMT_Encode4(0),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(328232),
     /*    410 */ /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(329824), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(333987), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(334269),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(334378),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(334487),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(334875),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(335201),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(335589), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(335915),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(337273),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(337637),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(339023),
     /*    546 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(340892), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    562 */ /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(341838), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    574 */ /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(341956), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    586 */ /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(342179), GIMT_Encode4(0),
     /*    594 */ /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(342402), GIMT_Encode4(0),
     /*    602 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(342765),
     /*    606 */ /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(344507),
     /*    610 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(344907),
     /*    614 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(346217),
     /*    618 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(346943),
     /*    622 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(347669),
     /*    626 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(348402), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    638 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(349135),
     /*    642 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(349884),
     /*    646 */ /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(350779),
     /*    650 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(351110),
     /*    654 */ /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(352578),
     /*    658 */ /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(424357),
     /*    662 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(496136),
     /*    666 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(567915),
     /*    670 */ /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(639694),
     /*    674 */ /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(641809),
     /*    678 */ /*TargetOpcode::G_FMINIMUMNUM*//*Label 86*/ GIMT_Encode4(643924),
     /*    682 */ /*TargetOpcode::G_FMAXIMUMNUM*//*Label 87*/ GIMT_Encode4(644352), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    698 */ /*TargetOpcode::G_GET_FPMODE*//*Label 88*/ GIMT_Encode4(644780), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_PTR_ADD*//*Label 89*/ GIMT_Encode4(644904), GIMT_Encode4(0),
     /*    726 */ /*TargetOpcode::G_SMIN*//*Label 90*/ GIMT_Encode4(645428),
     /*    730 */ /*TargetOpcode::G_SMAX*//*Label 91*/ GIMT_Encode4(652394),
     /*    734 */ /*TargetOpcode::G_UMIN*//*Label 92*/ GIMT_Encode4(659528),
     /*    738 */ /*TargetOpcode::G_UMAX*//*Label 93*/ GIMT_Encode4(666494),
     /*    742 */ /*TargetOpcode::G_ABS*//*Label 94*/ GIMT_Encode4(673460), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    754 */ /*TargetOpcode::G_BR*//*Label 95*/ GIMT_Encode4(673597), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    802 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 96*/ GIMT_Encode4(673631), GIMT_Encode4(0),
     /*    810 */ /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 97*/ GIMT_Encode4(673730),
     /*    814 */ /*TargetOpcode::G_CTPOP*//*Label 98*/ GIMT_Encode4(673832),
     /*    818 */ /*TargetOpcode::G_BSWAP*//*Label 99*/ GIMT_Encode4(674047),
     /*    822 */ /*TargetOpcode::G_BITREVERSE*//*Label 100*/ GIMT_Encode4(675745),
     /*    826 */ /*TargetOpcode::G_FCEIL*//*Label 101*/ GIMT_Encode4(675993), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    874 */ /*TargetOpcode::G_FSQRT*//*Label 102*/ GIMT_Encode4(676321),
     /*    878 */ /*TargetOpcode::G_FFLOOR*//*Label 103*/ GIMT_Encode4(676613), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    914 */ /*TargetOpcode::G_STRICT_FADD*//*Label 104*/ GIMT_Encode4(677127),
     /*    918 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 105*/ GIMT_Encode4(678089),
     /*    922 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 106*/ GIMT_Encode4(678453), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    934 */ /*TargetOpcode::G_STRICT_FMA*//*Label 107*/ GIMT_Encode4(679721), GIMT_Encode4(0),
     /*    942 */ /*TargetOpcode::G_STRICT_FLDEXP*//*Label 108*/ GIMT_Encode4(680767), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15654 */ /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 109*/ GIMT_Encode4(681130),
     /*  15658 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 110*/ GIMT_Encode4(683934),
     /*  15662 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 111*/ GIMT_Encode4(686318),
     /*  15666 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 112*/ GIMT_Encode4(688702),
     /*  15670 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 113*/ GIMT_Encode4(692996),
     /*  15674 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 114*/ GIMT_Encode4(693613),
     /*  15678 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 115*/ GIMT_Encode4(695997),
     /*  15682 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 116*/ GIMT_Encode4(699639),
     /*  15686 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 117*/ GIMT_Encode4(703255),
     /*  15690 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 118*/ GIMT_Encode4(706871),
     /*  15694 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 119*/ GIMT_Encode4(709255),
     /*  15698 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 120*/ GIMT_Encode4(711639),
     /*  15702 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 121*/ GIMT_Encode4(714023),
     /*  15706 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 122*/ GIMT_Encode4(716407),
     /*  15710 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 123*/ GIMT_Encode4(718791),
     /*  15714 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 124*/ GIMT_Encode4(722335),
     /*  15718 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 125*/ GIMT_Encode4(724719),
     /*  15722 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 126*/ GIMT_Encode4(727103),
     /*  15726 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 127*/ GIMT_Encode4(729487),
     /*  15730 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 128*/ GIMT_Encode4(744859),
     /*  15734 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 129*/ GIMT_Encode4(749863),
     /*  15738 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 130*/ GIMT_Encode4(757608),
     /*  15742 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 131*/ GIMT_Encode4(760176),
     /*  15746 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 132*/ GIMT_Encode4(760782),
     /*  15750 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 133*/ GIMT_Encode4(761388),
     /*  15754 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 134*/ GIMT_Encode4(761994),
     /*  15758 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 135*/ GIMT_Encode4(762600),
     /*  15762 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 136*/ GIMT_Encode4(765120),
     /*  15766 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 137*/ GIMT_Encode4(765726),
     /*  15770 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 138*/ GIMT_Encode4(766332),
     /*  15774 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 139*/ GIMT_Encode4(766938),
     /*  15778 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 140*/ GIMT_Encode4(767544),
     /*  15782 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 141*/ GIMT_Encode4(782852),
     /*  15786 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 142*/ GIMT_Encode4(783454),
     /*  15790 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 143*/ GIMT_Encode4(788442),
     /*  15794 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 144*/ GIMT_Encode4(796035), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15810 */ /*AMDGPU::G_AMDGPU_CLAMP*//*Label 145*/ GIMT_Encode4(796637), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15822 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 146*/ GIMT_Encode4(798350),
     /*  15826 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 147*/ GIMT_Encode4(798395),
     /*  15830 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 148*/ GIMT_Encode4(798440),
     /*  15834 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 149*/ GIMT_Encode4(798485),
     /*  15838 */ /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 150*/ GIMT_Encode4(798530),
     /*  15842 */ /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 151*/ GIMT_Encode4(798560),
     /*  15846 */ /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 152*/ GIMT_Encode4(798662),
     /*  15850 */ /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 153*/ GIMT_Encode4(798761),
     /*  15854 */ /*AMDGPU::G_AMDGPU_FMED3*//*Label 154*/ GIMT_Encode4(798834),
     /*  15858 */ /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 155*/ GIMT_Encode4(799194), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15882 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI*//*Label 156*/ GIMT_Encode4(799267),
     /*  15886 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI_I8*//*Label 157*/ GIMT_Encode4(800471),
     /*  15890 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI_U8*//*Label 158*/ GIMT_Encode4(801675),
     /*  15894 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO*//*Label 159*/ GIMT_Encode4(802879),
     /*  15898 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO_I8*//*Label 160*/ GIMT_Encode4(804083),
     /*  15902 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO_U8*//*Label 161*/ GIMT_Encode4(805287), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15914 */ /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 162*/ GIMT_Encode4(806491), GIMT_Encode4(0),
     /*  15922 */ /*AMDGPU::G_AMDGPU_SMED3*//*Label 163*/ GIMT_Encode4(806541),
     /*  15926 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 164*/ GIMT_Encode4(806847),
     /*  15930 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 165*/ GIMT_Encode4(809149),
     /*  15934 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 166*/ GIMT_Encode4(809287),
     /*  15938 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 167*/ GIMT_Encode4(809425),
     /*  15942 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 168*/ GIMT_Encode4(809563),
     /*  15946 */ /*AMDGPU::G_AMDGPU_S_BUFFER_PREFETCH*//*Label 169*/ GIMT_Encode4(809701), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15958 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 170*/ GIMT_Encode4(809808),
     /*  15962 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 171*/ GIMT_Encode4(815388),
     /*  15966 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 172*/ GIMT_Encode4(820817),
     /*  15970 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 173*/ GIMT_Encode4(826381),
     /*  15974 */ /*AMDGPU::G_AMDGPU_UMED3*//*Label 174*/ GIMT_Encode4(831722), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15986 */ /*AMDGPU::G_AMDGPU_WHOLE_WAVE_FUNC_SETUP*//*Label 175*/ GIMT_Encode4(832028),
     /*  15990 */ // Label 0: @15990
     /*  15990 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 182*/ GIMT_Encode4(39553),
     /*  16001 */ /*GILLT_s1*//*Label 177*/ GIMT_Encode4(16021),
     /*  16005 */ /*GILLT_s16*//*Label 178*/ GIMT_Encode4(16140),
     /*  16009 */ /*GILLT_s32*//*Label 179*/ GIMT_Encode4(17131),
     /*  16013 */ /*GILLT_s64*//*Label 180*/ GIMT_Encode4(38812),
     /*  16017 */ /*GILLT_v2s16*//*Label 181*/ GIMT_Encode4(39283),
     /*  16021 */ // Label 177: @16021
     /*  16021 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(16139),
     /*  16026 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  16029 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  16032 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(16060), // Rule ID 8132 //
     /*  16037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  16040 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  16044 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  16048 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  16048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  16051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  16053 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16055 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  16058 */     GIR_RootConstrainSelectedInstOperands,
     /*  16059 */     // GIR_Coverage, 8132,
     /*  16059 */     GIR_EraseRootFromParent_Done,
     /*  16060 */   // Label 184: @16060
     /*  16060 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(16088), // Rule ID 8139 //
     /*  16065 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  16068 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  16072 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  16076 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  16076 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  16079 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  16081 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16083 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  16086 */     GIR_RootConstrainSelectedInstOperands,
     /*  16087 */     // GIR_Coverage, 8139,
     /*  16087 */     GIR_EraseRootFromParent_Done,
     /*  16088 */   // Label 185: @16088
     /*  16088 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(16113), // Rule ID 8130 //
     /*  16093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  16096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  16100 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  16100 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  16105 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  16111 */     GIR_RootConstrainSelectedInstOperands,
     /*  16112 */     // GIR_Coverage, 8130,
     /*  16112 */     GIR_Done,
     /*  16113 */   // Label 186: @16113
     /*  16113 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(16138), // Rule ID 8137 //
     /*  16118 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  16121 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  16125 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  16125 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  16130 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  16136 */     GIR_RootConstrainSelectedInstOperands,
     /*  16137 */     // GIR_Coverage, 8137,
     /*  16137 */     GIR_Done,
     /*  16138 */   // Label 187: @16138
     /*  16138 */   GIM_Reject,
     /*  16139 */ // Label 183: @16139
     /*  16139 */ GIM_Reject,
     /*  16140 */ // Label 178: @16140
     /*  16140 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(17130),
     /*  16145 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  16148 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  16151 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(16203), // Rule ID 7593 //
     /*  16156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16160 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16164 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  16168 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16172 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16176 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  16180 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16184 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40372),
     /*  16188 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16190 */     // (add:{ *:[i16] } (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40372>>), i16:{ *:[i16] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  16190 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  16193 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16195 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  16199 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  16201 */     GIR_RootConstrainSelectedInstOperands,
     /*  16202 */     // GIR_Coverage, 7593,
     /*  16202 */     GIR_EraseRootFromParent_Done,
     /*  16203 */   // Label 189: @16203
     /*  16203 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(16255), // Rule ID 11878 //
     /*  16208 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16212 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16216 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  16220 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16228 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  16232 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16236 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40372),
     /*  16240 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16242 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$val, (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40372>>))  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  16242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  16245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16247 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  16251 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  16253 */     GIR_RootConstrainSelectedInstOperands,
     /*  16254 */     // GIR_Coverage, 11878,
     /*  16254 */     GIR_EraseRootFromParent_Done,
     /*  16255 */   // Label 190: @16255
     /*  16255 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(16298), // Rule ID 2638 //
     /*  16260 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
     /*  16263 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16267 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16271 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16275 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16279 */     // MIs[1] Operand 1
     /*  16279 */     // No operand predicates
     /*  16279 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16281 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
     /*  16281 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  16284 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16286 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16288 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16293 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16296 */     GIR_RootConstrainSelectedInstOperands,
     /*  16297 */     // GIR_Coverage, 2638,
     /*  16297 */     GIR_EraseRootFromParent_Done,
     /*  16298 */   // Label 191: @16298
     /*  16298 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(16350), // Rule ID 2810 //
     /*  16303 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16306 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16310 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16314 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16318 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16322 */     // MIs[1] Operand 1
     /*  16322 */     // No operand predicates
     /*  16322 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16324 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16324 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  16327 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16329 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16332 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16334 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16337 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16345 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16348 */     GIR_RootConstrainSelectedInstOperands,
     /*  16349 */     // GIR_Coverage, 2810,
     /*  16349 */     GIR_EraseRootFromParent_Done,
     /*  16350 */   // Label 192: @16350
     /*  16350 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(16402), // Rule ID 2813 //
     /*  16355 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16358 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16362 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16366 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16370 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16374 */     // MIs[1] Operand 1
     /*  16374 */     // No operand predicates
     /*  16374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16376 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 bf16 f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16376 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  16379 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16381 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16384 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16386 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16389 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16394 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16397 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16400 */     GIR_RootConstrainSelectedInstOperands,
     /*  16401 */     // GIR_Coverage, 2813,
     /*  16401 */     GIR_EraseRootFromParent_Done,
     /*  16402 */   // Label 193: @16402
     /*  16402 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(16454), // Rule ID 2816 //
     /*  16407 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16410 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16414 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16418 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16422 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16426 */     // MIs[1] Operand 1
     /*  16426 */     // No operand predicates
     /*  16426 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16428 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16428 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  16431 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16433 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16436 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16438 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16441 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16446 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16452 */     GIR_RootConstrainSelectedInstOperands,
     /*  16453 */     // GIR_Coverage, 2816,
     /*  16453 */     GIR_EraseRootFromParent_Done,
     /*  16454 */   // Label 194: @16454
     /*  16454 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(16504), // Rule ID 2681 //
     /*  16459 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  16462 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16466 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16470 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16474 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16478 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16482 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16484 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16484 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  16487 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16489 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16493 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16497 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16499 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16502 */     GIR_RootConstrainSelectedInstOperands,
     /*  16503 */     // GIR_Coverage, 2681,
     /*  16503 */     GIR_EraseRootFromParent_Done,
     /*  16504 */   // Label 195: @16504
     /*  16504 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(16566), // Rule ID 2682 //
     /*  16509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16512 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16524 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16528 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16532 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16534 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  16537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16539 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16542 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16549 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16553 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16556 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16558 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16561 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16564 */     GIR_RootConstrainSelectedInstOperands,
     /*  16565 */     // GIR_Coverage, 2682,
     /*  16565 */     GIR_EraseRootFromParent_Done,
     /*  16566 */   // Label 196: @16566
     /*  16566 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(16628), // Rule ID 2683 //
     /*  16571 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16574 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16578 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16582 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16586 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16590 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16594 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16596 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16596 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  16599 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16601 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16604 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16608 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16611 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16615 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16618 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16620 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16623 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16626 */     GIR_RootConstrainSelectedInstOperands,
     /*  16627 */     // GIR_Coverage, 2683,
     /*  16627 */     GIR_EraseRootFromParent_Done,
     /*  16628 */   // Label 197: @16628
     /*  16628 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(16690), // Rule ID 2684 //
     /*  16633 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16636 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16640 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16644 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16648 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16652 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16656 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16658 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16658 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  16661 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16663 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16673 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16677 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16680 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16682 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16685 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16688 */     GIR_RootConstrainSelectedInstOperands,
     /*  16689 */     // GIR_Coverage, 2684,
     /*  16689 */     GIR_EraseRootFromParent_Done,
     /*  16690 */   // Label 198: @16690
     /*  16690 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(16740), // Rule ID 9201 //
     /*  16695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  16698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16710 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16714 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16718 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16720 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16720 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  16723 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16725 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16729 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16733 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16735 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16738 */     GIR_RootConstrainSelectedInstOperands,
     /*  16739 */     // GIR_Coverage, 9201,
     /*  16739 */     GIR_EraseRootFromParent_Done,
     /*  16740 */   // Label 199: @16740
     /*  16740 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(16802), // Rule ID 9202 //
     /*  16745 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16748 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16752 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16756 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16760 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16764 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16768 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16770 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16770 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  16773 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16775 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16778 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16782 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16785 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16789 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16792 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16794 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16797 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16800 */     GIR_RootConstrainSelectedInstOperands,
     /*  16801 */     // GIR_Coverage, 9202,
     /*  16801 */     GIR_EraseRootFromParent_Done,
     /*  16802 */   // Label 200: @16802
     /*  16802 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(16864), // Rule ID 9203 //
     /*  16807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16810 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16814 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16818 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16822 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16826 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16830 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16832 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16832 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  16835 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16837 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16840 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16844 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16847 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16851 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16854 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16856 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16859 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16862 */     GIR_RootConstrainSelectedInstOperands,
     /*  16863 */     // GIR_Coverage, 9203,
     /*  16863 */     GIR_EraseRootFromParent_Done,
     /*  16864 */   // Label 201: @16864
     /*  16864 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(16926), // Rule ID 9204 //
     /*  16869 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16872 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16876 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16880 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16884 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16888 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16892 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16894 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16894 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  16897 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16899 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16902 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16906 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16909 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16913 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16916 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16918 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16921 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16924 */     GIR_RootConstrainSelectedInstOperands,
     /*  16925 */     // GIR_Coverage, 9204,
     /*  16925 */     GIR_EraseRootFromParent_Done,
     /*  16926 */   // Label 202: @16926
     /*  16926 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(16985), // Rule ID 1105 //
     /*  16931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16938 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16945 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16952 */     // (add:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  16952 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
     /*  16955 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16957 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  16962 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  16967 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  16972 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  16977 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16980 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16983 */     GIR_RootConstrainSelectedInstOperands,
     /*  16984 */     // GIR_Coverage, 1105,
     /*  16984 */     GIR_EraseRootFromParent_Done,
     /*  16985 */   // Label 203: @16985
     /*  16985 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(17044), // Rule ID 1106 //
     /*  16990 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  16993 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16997 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17004 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17011 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  17011 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_t16_e64),
     /*  17014 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17016 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  17021 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  17026 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  17031 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  17036 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17039 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17042 */     GIR_RootConstrainSelectedInstOperands,
     /*  17043 */     // GIR_Coverage, 1106,
     /*  17043 */     GIR_EraseRootFromParent_Done,
     /*  17044 */   // Label 204: @17044
     /*  17044 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(17103), // Rule ID 1107 //
     /*  17049 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  17052 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17056 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17063 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17070 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  17070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_fake16_e64),
     /*  17073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17075 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  17080 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  17085 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  17090 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  17095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17101 */     GIR_RootConstrainSelectedInstOperands,
     /*  17102 */     // GIR_Coverage, 1107,
     /*  17102 */     GIR_EraseRootFromParent_Done,
     /*  17103 */   // Label 205: @17103
     /*  17103 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(17129), // Rule ID 944 //
     /*  17108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  17111 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17115 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  17115 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
     /*  17118 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17120 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  17122 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  17124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17127 */     GIR_RootConstrainSelectedInstOperands,
     /*  17128 */     // GIR_Coverage, 944,
     /*  17128 */     GIR_EraseRootFromParent_Done,
     /*  17129 */   // Label 206: @17129
     /*  17129 */   GIM_Reject,
     /*  17130 */ // Label 188: @17130
     /*  17130 */ GIM_Reject,
     /*  17131 */ // Label 179: @17131
     /*  17131 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(38811),
     /*  17136 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  17139 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17142 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(17647), // Rule ID 9323 //
     /*  17147 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17150 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17152 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17156 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17160 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17164 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17167 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17172 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17176 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17180 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17182 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17186 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17190 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17194 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17198 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17202 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17206 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17210 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17214 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17218 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17222 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17226 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17230 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17234 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17238 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17240 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17244 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17248 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17251 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17256 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17260 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17264 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17266 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17270 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17274 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17278 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17282 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17286 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17290 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17294 */     // MIs[7] src0
     /*  17294 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17299 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17303 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17314 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17318 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17322 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17326 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17330 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17334 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17338 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17342 */     // MIs[9] src1
     /*  17342 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17347 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17351 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17362 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17366 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17370 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17374 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17378 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17380 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17384 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17388 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  17391 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17396 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17400 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  17404 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17406 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17410 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17414 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  17418 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17422 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  17426 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17430 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17434 */     // MIs[13] src0
     /*  17434 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17439 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  17443 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  17454 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  17458 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17462 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  17466 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17470 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  17474 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17478 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17482 */     // MIs[15] src1
     /*  17482 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17487 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  17491 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17502 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  17506 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17510 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17514 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17518 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  17520 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  17524 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17528 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  17531 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17536 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17540 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  17544 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  17546 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  17550 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17554 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17558 */     // MIs[18] src0
     /*  17558 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17563 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17574 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  17578 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17582 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17586 */     // MIs[19] src1
     /*  17586 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17591 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  17602 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17604 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17604 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17607 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17609 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17612 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17616 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17619 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17623 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  17630 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17636 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17642 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17645 */     GIR_RootConstrainSelectedInstOperands,
     /*  17646 */     // GIR_Coverage, 9323,
     /*  17646 */     GIR_EraseRootFromParent_Done,
     /*  17647 */   // Label 208: @17647
     /*  17647 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(18152), // Rule ID 9322 //
     /*  17652 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17655 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17657 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17661 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17665 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17669 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17672 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17677 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17681 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17685 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17687 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17691 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17695 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17699 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17703 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17707 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17711 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17715 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17719 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17723 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17727 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17731 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17735 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17739 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17743 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17745 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17749 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17753 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17756 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17761 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17765 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17769 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17771 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17775 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17779 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17783 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17787 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17791 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17795 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17799 */     // MIs[7] src0
     /*  17799 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17804 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17808 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17819 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17823 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17827 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17831 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17835 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17839 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17843 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17847 */     // MIs[9] src1
     /*  17847 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17852 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17856 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17867 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17871 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17875 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17879 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17883 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17885 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17889 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17893 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  17896 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17901 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17905 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  17909 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17911 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17915 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17919 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  17923 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17927 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  17931 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17935 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17939 */     // MIs[13] src0
     /*  17939 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17944 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  17948 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  17959 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  17963 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17967 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  17971 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17975 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  17979 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17983 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17987 */     // MIs[15] src1
     /*  17987 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17992 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  17996 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18007 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  18011 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18015 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18019 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18023 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  18025 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  18029 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18033 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  18036 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18041 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18045 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  18049 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  18051 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  18055 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18059 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18063 */     // MIs[18] src0
     /*  18063 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18068 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18079 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  18083 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18087 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18091 */     // MIs[19] src1
     /*  18091 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18096 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  18107 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18109 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18109 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18112 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18114 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18117 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18124 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18128 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18131 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  18135 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18144 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18147 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18150 */     GIR_RootConstrainSelectedInstOperands,
     /*  18151 */     // GIR_Coverage, 9322,
     /*  18151 */     GIR_EraseRootFromParent_Done,
     /*  18152 */   // Label 209: @18152
     /*  18152 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(18657), // Rule ID 9321 //
     /*  18157 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18160 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18162 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18166 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18170 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18174 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18177 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18182 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18186 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18190 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18192 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18196 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18200 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18204 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18208 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18212 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18216 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18220 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18224 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18228 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18232 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18236 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18240 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18244 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18248 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18250 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18254 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18258 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  18261 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18266 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18270 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  18274 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18276 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  18280 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18284 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  18288 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18292 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  18296 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18300 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18304 */     // MIs[7] src0
     /*  18304 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18309 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  18313 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  18324 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  18328 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18332 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  18336 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18340 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  18344 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18348 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18352 */     // MIs[9] src1
     /*  18352 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18357 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  18361 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18372 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  18376 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18380 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  18384 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18388 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  18390 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  18394 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18398 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18402 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18406 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18408 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  18412 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18416 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18419 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18424 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18428 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18432 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18434 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18438 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18442 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18446 */     // MIs[13] src0
     /*  18446 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18451 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18462 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18466 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18470 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18474 */     // MIs[14] src1
     /*  18474 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18479 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18490 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  18494 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18498 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18501 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18506 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18510 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18514 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18516 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18520 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18524 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18528 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18532 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18536 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18540 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18544 */     // MIs[17] src0
     /*  18544 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18549 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  18553 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18564 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18568 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18572 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18576 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18580 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18584 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18588 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18592 */     // MIs[19] src1
     /*  18592 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18597 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  18601 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18612 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18614 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18626 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18629 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18636 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  18640 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18643 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18652 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18655 */     GIR_RootConstrainSelectedInstOperands,
     /*  18656 */     // GIR_Coverage, 9321,
     /*  18656 */     GIR_EraseRootFromParent_Done,
     /*  18657 */   // Label 210: @18657
     /*  18657 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(19162), // Rule ID 9320 //
     /*  18662 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18665 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18667 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18671 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18675 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18679 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18682 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18687 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18691 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18695 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18697 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18701 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18705 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18709 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18713 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18717 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18721 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18725 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18729 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18733 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18737 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18741 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18745 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18749 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18753 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18755 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18759 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18763 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  18766 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18771 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18775 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  18779 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18781 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  18785 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18789 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  18793 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18797 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  18801 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18805 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18809 */     // MIs[7] src0
     /*  18809 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18814 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  18818 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  18829 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  18833 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18837 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  18841 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18845 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  18849 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18853 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18857 */     // MIs[9] src1
     /*  18857 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18862 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  18866 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18877 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  18881 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18885 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  18889 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18893 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  18895 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  18899 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18903 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18907 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18911 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18913 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  18917 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18921 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18924 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18929 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18933 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18937 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18939 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18943 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18947 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18951 */     // MIs[13] src0
     /*  18951 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18956 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18967 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18971 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18975 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18979 */     // MIs[14] src1
     /*  18979 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18984 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18995 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  18999 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19003 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19006 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19011 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19015 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19019 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19021 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19025 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19029 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19033 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19037 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19041 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19045 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19049 */     // MIs[17] src0
     /*  19049 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19054 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  19058 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19069 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19073 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19077 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19081 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19085 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19089 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19093 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19097 */     // MIs[19] src1
     /*  19097 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19102 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  19106 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19117 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19119 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19119 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19122 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19127 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19131 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19134 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  19145 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19148 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19151 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19154 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19157 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19160 */     GIR_RootConstrainSelectedInstOperands,
     /*  19161 */     // GIR_Coverage, 9320,
     /*  19161 */     GIR_EraseRootFromParent_Done,
     /*  19162 */   // Label 211: @19162
     /*  19162 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(19667), // Rule ID 9319 //
     /*  19167 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19170 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19172 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19176 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19180 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19184 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19187 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19192 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19196 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19200 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19202 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19206 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19210 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19214 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19218 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19222 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19226 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19230 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19234 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19238 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19242 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19246 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19250 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19254 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19258 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19260 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19264 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19268 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19272 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19276 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19278 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19282 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19286 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  19289 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19294 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19298 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  19302 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19304 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19308 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19312 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  19316 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19320 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  19324 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19328 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19332 */     // MIs[8] src0
     /*  19332 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19337 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  19341 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  19352 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  19356 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19360 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19364 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19368 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19372 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19376 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19380 */     // MIs[10] src1
     /*  19380 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19385 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  19389 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19400 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  19404 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19408 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19412 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19416 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  19418 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  19422 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19426 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  19429 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19434 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19438 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  19442 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  19444 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  19448 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19452 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19456 */     // MIs[13] src0
     /*  19456 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19461 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19472 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  19476 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19480 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19484 */     // MIs[14] src1
     /*  19484 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19489 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  19500 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19504 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19508 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19511 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19516 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19520 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19524 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19526 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19530 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19534 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19538 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19542 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19546 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19550 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19554 */     // MIs[17] src0
     /*  19554 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19559 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19563 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19574 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19578 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19582 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19586 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19590 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19594 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19598 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19602 */     // MIs[19] src1
     /*  19602 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19607 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19611 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19622 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19624 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19629 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19632 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19636 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19639 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19643 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19646 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  19650 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19659 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19665 */     GIR_RootConstrainSelectedInstOperands,
     /*  19666 */     // GIR_Coverage, 9319,
     /*  19666 */     GIR_EraseRootFromParent_Done,
     /*  19667 */   // Label 212: @19667
     /*  19667 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(20172), // Rule ID 9318 //
     /*  19672 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19675 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19677 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19681 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19685 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19689 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19692 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19697 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19701 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19705 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19707 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19711 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19715 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19719 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19723 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19727 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19731 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19735 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19739 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19743 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19747 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19751 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19755 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19759 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19763 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19765 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19769 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19773 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19777 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19781 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19783 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19787 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19791 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  19794 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19799 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19803 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  19807 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19809 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19813 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19817 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  19821 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19825 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  19829 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19833 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19837 */     // MIs[8] src0
     /*  19837 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19842 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  19846 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  19857 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  19861 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19865 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19869 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19873 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19877 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19881 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19885 */     // MIs[10] src1
     /*  19885 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19890 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  19894 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19905 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  19909 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19913 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19917 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19921 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  19923 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  19927 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19931 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  19934 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19939 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19943 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  19947 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  19949 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  19953 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19957 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19961 */     // MIs[13] src0
     /*  19961 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19966 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19977 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  19981 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19985 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19989 */     // MIs[14] src1
     /*  19989 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19994 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  20005 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  20009 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20013 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  20016 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20021 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20025 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  20029 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  20031 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  20035 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20039 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  20043 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20047 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  20051 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20055 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20059 */     // MIs[17] src0
     /*  20059 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20064 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  20068 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20079 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  20083 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20087 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  20091 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20095 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  20099 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20103 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20107 */     // MIs[19] src1
     /*  20107 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20112 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  20116 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  20127 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20129 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20129 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20132 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20134 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20137 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  20141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20144 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  20148 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20151 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  20155 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20158 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20161 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20164 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20167 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20170 */     GIR_RootConstrainSelectedInstOperands,
     /*  20171 */     // GIR_Coverage, 9318,
     /*  20171 */     GIR_EraseRootFromParent_Done,
     /*  20172 */   // Label 213: @20172
     /*  20172 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(20677), // Rule ID 9317 //
     /*  20177 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20180 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20182 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20186 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20190 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20194 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  20197 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20202 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20206 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  20210 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20212 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20216 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20220 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20224 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20228 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  20232 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  20236 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20240 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20244 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20248 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  20252 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  20256 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20260 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20264 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20268 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  20270 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20274 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20278 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20282 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20286 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  20288 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20292 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20296 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20300 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20304 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  20306 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  20310 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20314 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  20317 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20322 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20326 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  20330 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20332 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  20336 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20340 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20344 */     // MIs[8] src0
     /*  20344 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20349 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  20360 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  20364 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20368 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20372 */     // MIs[9] src1
     /*  20372 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20377 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20388 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  20392 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20396 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  20399 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20404 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20408 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  20412 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  20414 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  20418 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20422 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20426 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20430 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20434 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20438 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20442 */     // MIs[12] src0
     /*  20442 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20447 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20451 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20462 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  20466 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20470 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20474 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20478 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20482 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20486 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20490 */     // MIs[14] src1
     /*  20490 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20495 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  20499 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  20510 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  20514 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20518 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  20521 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20526 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20530 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  20534 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  20536 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  20540 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20544 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  20548 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20552 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  20556 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20560 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20564 */     // MIs[17] src0
     /*  20564 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20569 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  20573 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20584 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  20588 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20592 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  20596 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20600 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  20604 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20608 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20612 */     // MIs[19] src1
     /*  20612 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20617 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  20621 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  20632 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20634 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20634 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20637 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20642 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  20646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20649 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  20653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20656 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  20660 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20663 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20666 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20675 */     GIR_RootConstrainSelectedInstOperands,
     /*  20676 */     // GIR_Coverage, 9317,
     /*  20676 */     GIR_EraseRootFromParent_Done,
     /*  20677 */   // Label 214: @20677
     /*  20677 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(21182), // Rule ID 9316 //
     /*  20682 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20685 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20687 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20691 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20695 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20699 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  20702 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20707 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20711 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  20715 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20717 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20721 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20725 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20729 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20733 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  20737 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  20741 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20745 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20749 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20753 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  20757 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  20761 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20765 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20769 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20773 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  20775 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20779 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20783 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20787 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20791 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  20793 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20797 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20801 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20805 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20809 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  20811 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  20815 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20819 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  20822 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20827 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20831 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  20835 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20837 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  20841 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20845 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20849 */     // MIs[8] src0
     /*  20849 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20854 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  20865 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  20869 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20873 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20877 */     // MIs[9] src1
     /*  20877 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20882 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20893 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  20897 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20901 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  20904 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20909 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20913 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  20917 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  20919 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  20923 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20927 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20931 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20935 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20939 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20943 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20947 */     // MIs[12] src0
     /*  20947 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20952 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20956 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20967 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  20971 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20975 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20979 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20983 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20987 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20991 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20995 */     // MIs[14] src1
     /*  20995 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  21000 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  21004 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  21015 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  21019 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21023 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  21026 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21031 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21035 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  21039 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  21041 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  21045 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21049 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  21053 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21057 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  21061 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21065 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21069 */     // MIs[17] src0
     /*  21069 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21074 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  21078 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  21089 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  21093 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21097 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  21101 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21105 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  21109 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21113 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21117 */     // MIs[19] src1
     /*  21117 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  21122 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  21126 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  21137 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21139 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21139 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21142 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21144 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21147 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  21151 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21154 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  21158 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21161 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  21165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21168 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21177 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21180 */     GIR_RootConstrainSelectedInstOperands,
     /*  21181 */     // GIR_Coverage, 9316,
     /*  21181 */     GIR_EraseRootFromParent_Done,
     /*  21182 */   // Label 215: @21182
     /*  21182 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(21687), // Rule ID 9315 //
     /*  21187 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21190 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21192 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21196 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21200 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21204 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21208 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21212 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21214 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21218 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21222 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21225 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21230 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21234 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21238 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21240 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21244 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21248 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21252 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21256 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21260 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21264 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21268 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21272 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21276 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21287 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21291 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21295 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21299 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21303 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21307 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21311 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21315 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21319 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21323 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21334 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21338 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21342 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21346 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21350 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21352 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21356 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21360 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  21363 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21368 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21372 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  21376 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21378 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21382 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21386 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  21390 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21394 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  21398 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21402 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21406 */     // MIs[10] src0
     /*  21406 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21411 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  21415 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  21426 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  21430 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21434 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  21438 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21442 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  21446 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21450 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21454 */     // MIs[12] src1
     /*  21454 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21459 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  21463 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21474 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  21478 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21482 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21486 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21490 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  21492 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  21496 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21500 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  21503 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21508 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21512 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  21516 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  21518 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  21522 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21526 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21530 */     // MIs[15] src0
     /*  21530 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21535 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21546 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  21550 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21554 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21558 */     // MIs[16] src1
     /*  21558 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21563 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  21574 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21578 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21582 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21585 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21590 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21594 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21598 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21600 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21604 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21608 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21612 */     // MIs[18] src0
     /*  21612 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21617 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21621 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21625 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21629 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21633 */     // MIs[19] src1
     /*  21633 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21638 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21642 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21644 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21644 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21647 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21659 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21663 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  21670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21673 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21676 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21679 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21682 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21685 */     GIR_RootConstrainSelectedInstOperands,
     /*  21686 */     // GIR_Coverage, 9315,
     /*  21686 */     GIR_EraseRootFromParent_Done,
     /*  21687 */   // Label 216: @21687
     /*  21687 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(22192), // Rule ID 9314 //
     /*  21692 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21695 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21697 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21701 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21705 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21709 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21713 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21717 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21719 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21723 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21727 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21730 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21735 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21739 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21743 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21745 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21749 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21753 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21757 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21761 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21765 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21769 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21773 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21777 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21781 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21792 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21796 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21800 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21804 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21808 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21812 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21816 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21820 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21824 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21828 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21839 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21843 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21847 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21851 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21855 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21857 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21861 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21865 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  21868 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21873 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21877 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  21881 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21883 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21887 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21891 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  21895 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21899 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  21903 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21907 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21911 */     // MIs[10] src0
     /*  21911 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21916 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  21920 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  21931 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  21935 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21939 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  21943 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21947 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  21951 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21955 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21959 */     // MIs[12] src1
     /*  21959 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21964 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  21968 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21979 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  21983 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21987 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21991 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21995 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  21997 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  22001 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22005 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  22008 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22013 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22017 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  22021 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  22023 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  22027 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22031 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22035 */     // MIs[15] src0
     /*  22035 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22040 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22051 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  22055 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22059 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22063 */     // MIs[16] src1
     /*  22063 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22068 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  22079 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22083 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22087 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22090 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22095 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22099 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22103 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22105 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22109 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22113 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22117 */     // MIs[18] src0
     /*  22117 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22122 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22126 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22130 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22134 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22138 */     // MIs[19] src1
     /*  22138 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22143 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22147 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22149 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22149 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22152 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22154 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22157 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  22161 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22164 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  22168 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22171 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  22175 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22178 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22181 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22184 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22187 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22190 */     GIR_RootConstrainSelectedInstOperands,
     /*  22191 */     // GIR_Coverage, 9314,
     /*  22191 */     GIR_EraseRootFromParent_Done,
     /*  22192 */   // Label 217: @22192
     /*  22192 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(22697), // Rule ID 9313 //
     /*  22197 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22200 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22202 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22218 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22222 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22228 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22232 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  22235 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22240 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22244 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  22248 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22250 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  22254 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22258 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22262 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22266 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22270 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22274 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22278 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22282 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  22286 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  22297 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  22301 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22305 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22309 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22313 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  22317 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22321 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22325 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22329 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  22333 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  22344 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  22348 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22352 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22356 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22360 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22362 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  22366 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22370 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22374 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22378 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22380 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  22384 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22388 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22391 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22396 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22400 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22404 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22406 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22410 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22414 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22418 */     // MIs[10] src0
     /*  22418 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22423 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22434 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22438 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22442 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22446 */     // MIs[11] src1
     /*  22446 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22451 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22462 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  22466 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22470 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22473 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22478 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22482 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22486 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22488 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22492 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22496 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22500 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22504 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22508 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22512 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22516 */     // MIs[14] src0
     /*  22516 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22521 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  22525 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22536 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22540 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22544 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22548 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22552 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22556 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22560 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22564 */     // MIs[16] src1
     /*  22564 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22569 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  22573 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22584 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22588 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22592 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22595 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22600 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22604 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22608 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22610 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22614 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22618 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22622 */     // MIs[18] src0
     /*  22622 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22627 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22631 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22635 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22639 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22643 */     // MIs[19] src1
     /*  22643 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22648 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22652 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22654 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22659 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  22666 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22669 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  22673 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22676 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  22680 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22683 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22689 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22695 */     GIR_RootConstrainSelectedInstOperands,
     /*  22696 */     // GIR_Coverage, 9313,
     /*  22696 */     GIR_EraseRootFromParent_Done,
     /*  22697 */   // Label 218: @22697
     /*  22697 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(23202), // Rule ID 9312 //
     /*  22702 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22705 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22707 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22711 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22715 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22719 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22723 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22727 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22729 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22733 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22737 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  22740 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22745 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22749 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  22753 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22755 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  22759 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22763 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22767 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22771 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22775 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22779 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22783 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22787 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  22791 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  22802 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  22806 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22810 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22814 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22818 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  22822 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22826 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22830 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22834 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  22838 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  22849 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  22853 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22857 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22861 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22865 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22867 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  22871 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22875 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22879 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22883 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22885 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  22889 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22893 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22896 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22901 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22905 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22909 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22911 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22915 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22919 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22923 */     // MIs[10] src0
     /*  22923 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22928 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22939 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22943 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22947 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22951 */     // MIs[11] src1
     /*  22951 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22956 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22967 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  22971 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22975 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22978 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22983 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22987 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22991 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22993 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22997 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23001 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23005 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23009 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23013 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23017 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23021 */     // MIs[14] src0
     /*  23021 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  23026 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  23030 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23041 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23045 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23049 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23053 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23057 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23061 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23065 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23069 */     // MIs[16] src1
     /*  23069 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23074 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  23078 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23089 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23093 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23097 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23100 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23105 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23109 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23113 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23115 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23119 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23123 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23127 */     // MIs[18] src0
     /*  23127 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  23132 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23136 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23140 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23144 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23148 */     // MIs[19] src1
     /*  23148 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23153 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23157 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23159 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23159 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23162 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23164 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  23171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  23178 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23181 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  23185 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23191 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23197 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23200 */     GIR_RootConstrainSelectedInstOperands,
     /*  23201 */     // GIR_Coverage, 9312,
     /*  23201 */     GIR_EraseRootFromParent_Done,
     /*  23202 */   // Label 219: @23202
     /*  23202 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(23707), // Rule ID 9311 //
     /*  23207 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23210 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23212 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23224 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23228 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23232 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23234 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23238 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23242 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23246 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23250 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23252 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23256 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23260 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  23263 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23268 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23272 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  23276 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23278 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23282 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23286 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  23290 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23294 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  23298 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23302 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23306 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23310 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  23314 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  23325 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  23329 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23333 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23337 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23341 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  23345 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23349 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  23353 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23357 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  23361 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23372 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  23376 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23380 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23384 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23388 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  23390 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  23394 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23398 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  23401 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23406 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23410 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  23414 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  23416 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  23420 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23424 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23428 */     // MIs[10] src0
     /*  23428 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23433 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23444 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  23448 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23452 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23456 */     // MIs[11] src1
     /*  23456 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23461 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  23472 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23476 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23480 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23483 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23488 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23492 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23496 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23498 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23502 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23506 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23510 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23514 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23518 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23522 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23526 */     // MIs[14] src0
     /*  23526 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23531 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23535 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23546 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23550 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23554 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23558 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23562 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23566 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23570 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23574 */     // MIs[16] src1
     /*  23574 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23579 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23583 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23594 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23598 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23602 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23605 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23610 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23614 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23618 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23620 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23624 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23628 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23632 */     // MIs[18] src0
     /*  23632 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23637 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23641 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23645 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23649 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23653 */     // MIs[19] src1
     /*  23653 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23658 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23662 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23664 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23664 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23667 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23672 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23676 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23679 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  23683 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23686 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  23690 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23693 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23696 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23699 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23702 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23705 */     GIR_RootConstrainSelectedInstOperands,
     /*  23706 */     // GIR_Coverage, 9311,
     /*  23706 */     GIR_EraseRootFromParent_Done,
     /*  23707 */   // Label 220: @23707
     /*  23707 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(24212), // Rule ID 9310 //
     /*  23712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23715 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23717 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23721 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23725 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23729 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23733 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23737 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23739 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23743 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23747 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23751 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23755 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23757 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23761 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23765 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  23768 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23773 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23777 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  23781 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23783 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23787 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23791 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  23795 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23799 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  23803 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23807 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23811 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23815 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  23819 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  23830 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  23834 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23838 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23842 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23846 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  23850 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23854 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  23858 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23862 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  23866 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23877 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  23881 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23885 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23889 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23893 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  23895 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  23899 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23903 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  23906 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23911 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23915 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  23919 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  23921 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  23925 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23929 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23933 */     // MIs[10] src0
     /*  23933 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23938 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23949 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  23953 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23957 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23961 */     // MIs[11] src1
     /*  23961 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23966 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  23977 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23981 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23985 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23988 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23993 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23997 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  24001 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  24003 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  24007 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24011 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  24015 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24019 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  24023 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24027 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  24031 */     // MIs[14] src0
     /*  24031 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24036 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  24040 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  24051 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  24055 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24059 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  24063 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24067 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  24071 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24075 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24079 */     // MIs[16] src1
     /*  24079 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  24084 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  24088 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  24099 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  24103 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24107 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24110 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24115 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24119 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24123 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24125 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24129 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24133 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  24137 */     // MIs[18] src0
     /*  24137 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24142 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  24146 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24150 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24154 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  24158 */     // MIs[19] src1
     /*  24158 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  24163 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  24167 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24169 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  24172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24177 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  24181 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  24188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24191 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  24195 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24198 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24201 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24204 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24207 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24210 */     GIR_RootConstrainSelectedInstOperands,
     /*  24211 */     // GIR_Coverage, 9310,
     /*  24211 */     GIR_EraseRootFromParent_Done,
     /*  24212 */   // Label 221: @24212
     /*  24212 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(24717), // Rule ID 9309 //
     /*  24217 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  24220 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24234 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  24238 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24242 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24244 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  24248 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24252 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24256 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24260 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  24262 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  24266 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24270 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24274 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24278 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  24280 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24284 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24288 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  24291 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24296 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24300 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  24304 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24306 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24310 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24314 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  24318 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24322 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  24333 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  24337 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24341 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24345 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  24349 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  24360 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  24364 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24368 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  24371 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24376 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24380 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  24384 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  24386 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  24390 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24394 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24398 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  24402 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24406 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24410 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24414 */     // MIs[9] src0
     /*  24414 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24419 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  24423 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  24434 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  24438 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24442 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24446 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24450 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24454 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24458 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24462 */     // MIs[11] src1
     /*  24462 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24467 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  24471 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  24482 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  24486 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24490 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24493 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24498 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  24502 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  24506 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  24508 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  24512 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24516 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  24520 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24524 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  24528 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24532 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  24536 */     // MIs[14] src0
     /*  24536 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24541 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  24545 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  24556 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  24560 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24564 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  24568 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24572 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  24576 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24580 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24584 */     // MIs[16] src1
     /*  24584 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24589 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  24593 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  24604 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  24608 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24612 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24615 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24620 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24624 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24628 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24630 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24634 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24638 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  24642 */     // MIs[18] src0
     /*  24642 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24647 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  24651 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24655 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24659 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  24663 */     // MIs[19] src1
     /*  24663 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24668 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  24672 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24674 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24674 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  24677 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24679 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24682 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  24686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24689 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  24693 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24696 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  24700 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24703 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24706 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24709 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24712 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24715 */     GIR_RootConstrainSelectedInstOperands,
     /*  24716 */     // GIR_Coverage, 9309,
     /*  24716 */     GIR_EraseRootFromParent_Done,
     /*  24717 */   // Label 222: @24717
     /*  24717 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(25222), // Rule ID 2924 //
     /*  24722 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  24725 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24727 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24731 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24735 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24739 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  24743 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24747 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24749 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  24753 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24757 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24761 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24765 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  24767 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  24771 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24775 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24779 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24783 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  24785 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  24789 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24793 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  24796 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24801 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24805 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  24809 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24811 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24815 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24819 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  24823 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24827 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  24838 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  24842 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24846 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24850 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  24854 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  24865 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  24869 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24873 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  24876 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24881 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24885 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  24889 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  24891 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  24895 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24899 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24903 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  24907 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24911 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24915 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24919 */     // MIs[9] src0
     /*  24919 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24924 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  24928 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  24939 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  24943 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24947 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24951 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24955 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24959 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24963 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24967 */     // MIs[11] src1
     /*  24967 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24972 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  24976 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  24987 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  24991 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24995 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24998 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  25003 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  25007 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  25011 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  25013 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25017 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25021 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  25025 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25029 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  25033 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25037 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  25041 */     // MIs[14] src0
     /*  25041 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  25046 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  25050 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  25061 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  25065 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25069 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  25073 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25077 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  25081 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25085 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  25089 */     // MIs[16] src1
     /*  25089 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  25094 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  25098 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  25109 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  25113 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25117 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  25120 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  25125 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25129 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  25133 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  25135 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  25139 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25143 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  25147 */     // MIs[18] src0
     /*  25147 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  25152 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  25156 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  25160 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25164 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  25168 */     // MIs[19] src1
     /*  25168 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  25173 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  25177 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25179 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25179 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  25182 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25184 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25187 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  25191 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25194 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  25198 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25201 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  25205 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25208 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25211 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25214 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25220 */     GIR_RootConstrainSelectedInstOperands,
     /*  25221 */     // GIR_Coverage, 2924,
     /*  25221 */     GIR_EraseRootFromParent_Done,
     /*  25222 */   // Label 223: @25222
     /*  25222 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(25703), // Rule ID 10603 //
     /*  25227 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25230 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25232 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25236 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25240 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25244 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25247 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25252 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25256 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25260 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25262 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25266 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25270 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25274 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25278 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25282 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25286 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25290 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25294 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25298 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25302 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25306 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25310 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25314 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25318 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25320 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25324 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25328 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25331 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25336 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25340 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25344 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25346 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25350 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25354 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25358 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25362 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25366 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25370 */     // MIs[7] src0
     /*  25370 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25375 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25379 */     // MIs[6] Operand 2
     /*  25379 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25390 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25394 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25398 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25402 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25406 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25410 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25414 */     // MIs[9] src1
     /*  25414 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25419 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25423 */     // MIs[8] Operand 2
     /*  25423 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25434 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25438 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25442 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25446 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25450 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25452 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25456 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25460 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  25463 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25468 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25472 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  25476 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25478 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25482 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25486 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  25490 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  25494 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25498 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25502 */     // MIs[13] src0
     /*  25502 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25507 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  25511 */     // MIs[12] Operand 2
     /*  25511 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  25522 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  25526 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25530 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  25534 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  25538 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25542 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25546 */     // MIs[15] src1
     /*  25546 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25551 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  25555 */     // MIs[14] Operand 2
     /*  25555 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25566 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  25570 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25574 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25578 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  25582 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  25584 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  25588 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25592 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  25595 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25600 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25604 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  25608 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  25610 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  25614 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25618 */     // MIs[18] src0
     /*  25618 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25623 */     // MIs[18] Operand 2
     /*  25623 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25634 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  25638 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25642 */     // MIs[19] src1
     /*  25642 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25647 */     // MIs[19] Operand 2
     /*  25647 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  25658 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25660 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25675 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25679 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25682 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  25686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25689 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25695 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25698 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25701 */     GIR_RootConstrainSelectedInstOperands,
     /*  25702 */     // GIR_Coverage, 10603,
     /*  25702 */     GIR_EraseRootFromParent_Done,
     /*  25703 */   // Label 224: @25703
     /*  25703 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(26184), // Rule ID 10602 //
     /*  25708 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25711 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25713 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25717 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25721 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25725 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25728 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25733 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25737 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25741 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25743 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25747 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25751 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25755 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25759 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25763 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25767 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25771 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25775 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25779 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25783 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25787 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25791 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25795 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25799 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25801 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25805 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25809 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25812 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25817 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25821 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25825 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25827 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25831 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25835 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25839 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25843 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25847 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25851 */     // MIs[7] src0
     /*  25851 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25856 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25860 */     // MIs[6] Operand 2
     /*  25860 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25871 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25875 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25879 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25883 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25887 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25891 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25895 */     // MIs[9] src1
     /*  25895 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25900 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25904 */     // MIs[8] Operand 2
     /*  25904 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25915 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25919 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25923 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25927 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25931 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25933 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25937 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25941 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  25944 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25949 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25953 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  25957 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25959 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25963 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25967 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  25971 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  25975 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25979 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25983 */     // MIs[13] src0
     /*  25983 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25988 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  25992 */     // MIs[12] Operand 2
     /*  25992 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  26003 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  26007 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26011 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  26015 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  26019 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26023 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26027 */     // MIs[15] src1
     /*  26027 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26032 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  26036 */     // MIs[14] Operand 2
     /*  26036 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26047 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  26051 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26055 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26059 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  26063 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  26065 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  26069 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26073 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  26076 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26081 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26085 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  26089 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  26091 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  26095 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26099 */     // MIs[18] src0
     /*  26099 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26104 */     // MIs[18] Operand 2
     /*  26104 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26115 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  26119 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26123 */     // MIs[19] src1
     /*  26123 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26128 */     // MIs[19] Operand 2
     /*  26128 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  26139 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26141 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26141 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26144 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26146 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26149 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26153 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26156 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26160 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  26167 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26170 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26176 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26179 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26182 */     GIR_RootConstrainSelectedInstOperands,
     /*  26183 */     // GIR_Coverage, 10602,
     /*  26183 */     GIR_EraseRootFromParent_Done,
     /*  26184 */   // Label 225: @26184
     /*  26184 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(26665), // Rule ID 10601 //
     /*  26189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26192 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26198 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26206 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26209 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26214 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26218 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26222 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26228 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26232 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26236 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26240 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26244 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26248 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26252 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26256 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26260 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26264 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26268 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26272 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26276 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26280 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26282 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26286 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26290 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  26293 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26298 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26302 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  26306 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26308 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  26312 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26316 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  26320 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  26324 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26328 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  26332 */     // MIs[7] src0
     /*  26332 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26337 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  26341 */     // MIs[6] Operand 2
     /*  26341 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  26352 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  26356 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26360 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  26364 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  26368 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26372 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  26376 */     // MIs[9] src1
     /*  26376 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26381 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  26385 */     // MIs[8] Operand 2
     /*  26385 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  26396 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  26400 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26404 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  26408 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26412 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  26414 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  26418 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26422 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26426 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26430 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26432 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  26436 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26440 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26443 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26448 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26452 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26456 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26458 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26462 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26466 */     // MIs[13] src0
     /*  26466 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26471 */     // MIs[13] Operand 2
     /*  26471 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26482 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26486 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26490 */     // MIs[14] src1
     /*  26490 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26495 */     // MIs[14] Operand 2
     /*  26495 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26506 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  26510 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26514 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26517 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26522 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26526 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26530 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26532 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26536 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26540 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26544 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26548 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26552 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26556 */     // MIs[17] src0
     /*  26556 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26561 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  26565 */     // MIs[16] Operand 2
     /*  26565 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26576 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26580 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26584 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26588 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26592 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26596 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26600 */     // MIs[19] src1
     /*  26600 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26605 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  26609 */     // MIs[18] Operand 2
     /*  26609 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26620 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26622 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26622 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26625 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26627 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26630 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26634 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26637 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26644 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  26648 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26651 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26657 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26660 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26663 */     GIR_RootConstrainSelectedInstOperands,
     /*  26664 */     // GIR_Coverage, 10601,
     /*  26664 */     GIR_EraseRootFromParent_Done,
     /*  26665 */   // Label 226: @26665
     /*  26665 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(27146), // Rule ID 10600 //
     /*  26670 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26673 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26675 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26679 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26683 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26687 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26690 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26695 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26699 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26703 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26705 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26709 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26713 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26717 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26721 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26725 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26729 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26733 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26737 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26741 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26745 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26749 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26753 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26757 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26761 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26763 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26767 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26771 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  26774 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26779 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26783 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  26787 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26789 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  26793 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26797 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  26801 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  26805 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26809 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  26813 */     // MIs[7] src0
     /*  26813 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26818 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  26822 */     // MIs[6] Operand 2
     /*  26822 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  26833 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  26837 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26841 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  26845 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  26849 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26853 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  26857 */     // MIs[9] src1
     /*  26857 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26862 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  26866 */     // MIs[8] Operand 2
     /*  26866 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  26877 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  26881 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26885 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  26889 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26893 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  26895 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  26899 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26903 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26907 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26911 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26913 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  26917 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26921 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26924 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26929 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26933 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26937 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26939 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26943 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26947 */     // MIs[13] src0
     /*  26947 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26952 */     // MIs[13] Operand 2
     /*  26952 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26963 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26967 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26971 */     // MIs[14] src1
     /*  26971 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26976 */     // MIs[14] Operand 2
     /*  26976 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26987 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  26991 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26995 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26998 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27003 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27007 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27011 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27013 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27017 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27021 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27025 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27029 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27033 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27037 */     // MIs[17] src0
     /*  27037 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27042 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  27046 */     // MIs[16] Operand 2
     /*  27046 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27057 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27061 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27065 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27069 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27073 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27077 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27081 */     // MIs[19] src1
     /*  27081 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27086 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  27090 */     // MIs[18] Operand 2
     /*  27090 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27101 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27103 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27108 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27115 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27118 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27122 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27125 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  27129 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27132 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27135 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27144 */     GIR_RootConstrainSelectedInstOperands,
     /*  27145 */     // GIR_Coverage, 10600,
     /*  27145 */     GIR_EraseRootFromParent_Done,
     /*  27146 */   // Label 227: @27146
     /*  27146 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(27627), // Rule ID 10599 //
     /*  27151 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27154 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27160 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27164 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27168 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27171 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27176 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27180 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27184 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27186 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27190 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27194 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27198 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27202 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27206 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27210 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27214 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27218 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27222 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27226 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27230 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27234 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27238 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27242 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27244 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27248 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27252 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27256 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27260 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27262 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27266 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27270 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  27273 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27278 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27282 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  27286 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27288 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27292 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27296 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  27300 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  27304 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27308 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  27312 */     // MIs[8] src0
     /*  27312 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27317 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  27321 */     // MIs[7] Operand 2
     /*  27321 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  27332 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  27336 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27340 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  27344 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  27348 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27352 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27356 */     // MIs[10] src1
     /*  27356 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27361 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  27365 */     // MIs[9] Operand 2
     /*  27365 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27376 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  27380 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27384 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27388 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  27392 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  27394 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27398 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27402 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  27405 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27410 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27414 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  27418 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  27420 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  27424 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27428 */     // MIs[13] src0
     /*  27428 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27433 */     // MIs[13] Operand 2
     /*  27433 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27444 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  27448 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27452 */     // MIs[14] src1
     /*  27452 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27457 */     // MIs[14] Operand 2
     /*  27457 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  27468 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27472 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27476 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27479 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27484 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27488 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27492 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27494 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27498 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27502 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27506 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27510 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27514 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27518 */     // MIs[17] src0
     /*  27518 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27523 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27527 */     // MIs[16] Operand 2
     /*  27527 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27538 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27542 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27546 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27550 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27554 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27558 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27562 */     // MIs[19] src1
     /*  27562 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27567 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27571 */     // MIs[18] Operand 2
     /*  27571 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27582 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27584 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27584 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27587 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27589 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27596 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27599 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27603 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27606 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  27610 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27613 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27616 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27622 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27625 */     GIR_RootConstrainSelectedInstOperands,
     /*  27626 */     // GIR_Coverage, 10599,
     /*  27626 */     GIR_EraseRootFromParent_Done,
     /*  27627 */   // Label 228: @27627
     /*  27627 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(28108), // Rule ID 10598 //
     /*  27632 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27635 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27637 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27641 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27645 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27649 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27652 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27657 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27661 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27665 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27667 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27671 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27675 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27679 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27683 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27687 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27691 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27695 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27699 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27703 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27707 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27711 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27715 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27719 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27723 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27725 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27729 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27733 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27737 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27741 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27743 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27747 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27751 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  27754 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27759 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27763 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  27767 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27769 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27773 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27777 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  27781 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  27785 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27789 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  27793 */     // MIs[8] src0
     /*  27793 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27798 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  27802 */     // MIs[7] Operand 2
     /*  27802 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  27813 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  27817 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27821 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  27825 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  27829 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27833 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27837 */     // MIs[10] src1
     /*  27837 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27842 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  27846 */     // MIs[9] Operand 2
     /*  27846 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27857 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  27861 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27865 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27869 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  27873 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  27875 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  27879 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27883 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  27886 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27891 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27895 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  27899 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  27901 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  27905 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27909 */     // MIs[13] src0
     /*  27909 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27914 */     // MIs[13] Operand 2
     /*  27914 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27925 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  27929 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27933 */     // MIs[14] src1
     /*  27933 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27938 */     // MIs[14] Operand 2
     /*  27938 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  27949 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27953 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27957 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27960 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27965 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27969 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27973 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27975 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27979 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27983 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27987 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27991 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27995 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27999 */     // MIs[17] src0
     /*  27999 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28004 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28008 */     // MIs[16] Operand 2
     /*  28008 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28019 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28023 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28027 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28031 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28035 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28039 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28043 */     // MIs[19] src1
     /*  28043 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28048 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  28052 */     // MIs[18] Operand 2
     /*  28052 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  28063 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28065 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28065 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28068 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28070 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28073 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  28077 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  28084 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28087 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  28091 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28094 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28097 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28100 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28103 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28106 */     GIR_RootConstrainSelectedInstOperands,
     /*  28107 */     // GIR_Coverage, 10598,
     /*  28107 */     GIR_EraseRootFromParent_Done,
     /*  28108 */   // Label 229: @28108
     /*  28108 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(28589), // Rule ID 10597 //
     /*  28113 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28116 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28118 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28122 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28126 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28130 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  28133 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28138 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28142 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  28146 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28148 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28152 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28156 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  28160 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28164 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  28168 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  28172 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28176 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28180 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  28184 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  28188 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  28192 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28196 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28200 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28204 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  28206 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  28210 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28214 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28218 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  28222 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  28224 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28228 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28232 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28236 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28240 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  28242 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  28246 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28250 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  28253 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28258 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28262 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  28266 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28268 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  28272 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28276 */     // MIs[8] src0
     /*  28276 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28281 */     // MIs[8] Operand 2
     /*  28281 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  28292 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  28296 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28300 */     // MIs[9] src1
     /*  28300 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28305 */     // MIs[9] Operand 2
     /*  28305 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28316 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  28320 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28324 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  28327 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28332 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28336 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  28340 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  28342 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  28346 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28350 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28354 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28358 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28362 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28366 */     // MIs[12] src0
     /*  28366 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28371 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28375 */     // MIs[11] Operand 2
     /*  28375 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28386 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  28390 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28394 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28398 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28402 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28406 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28410 */     // MIs[14] src1
     /*  28410 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28415 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  28419 */     // MIs[13] Operand 2
     /*  28419 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  28430 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  28434 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28438 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  28441 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28446 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  28450 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  28454 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  28456 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  28460 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28464 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  28468 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  28472 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28476 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28480 */     // MIs[17] src0
     /*  28480 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28485 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28489 */     // MIs[16] Operand 2
     /*  28489 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28500 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28504 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28508 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28512 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28516 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28520 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28524 */     // MIs[19] src1
     /*  28524 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28529 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  28533 */     // MIs[18] Operand 2
     /*  28533 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  28544 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28546 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28546 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28549 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28551 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  28558 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28561 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  28565 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28568 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  28572 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28575 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28578 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28581 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28584 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28587 */     GIR_RootConstrainSelectedInstOperands,
     /*  28588 */     // GIR_Coverage, 10597,
     /*  28588 */     GIR_EraseRootFromParent_Done,
     /*  28589 */   // Label 230: @28589
     /*  28589 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(29070), // Rule ID 10596 //
     /*  28594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28597 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28599 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28603 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28607 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28611 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  28614 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28619 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28623 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  28627 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28629 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28633 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28637 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  28641 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28645 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  28649 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  28653 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28657 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28661 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  28665 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  28669 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  28673 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28677 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28681 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28685 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  28687 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  28691 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28695 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28699 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  28703 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  28705 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28709 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28713 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28717 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28721 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  28723 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  28727 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28731 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  28734 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28739 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28743 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  28747 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28749 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  28753 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28757 */     // MIs[8] src0
     /*  28757 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28762 */     // MIs[8] Operand 2
     /*  28762 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  28773 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  28777 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28781 */     // MIs[9] src1
     /*  28781 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28786 */     // MIs[9] Operand 2
     /*  28786 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28797 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  28801 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28805 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  28808 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28813 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28817 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  28821 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  28823 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  28827 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28831 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28835 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28839 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28843 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28847 */     // MIs[12] src0
     /*  28847 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28852 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28856 */     // MIs[11] Operand 2
     /*  28856 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28867 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  28871 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28875 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28879 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28883 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28887 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28891 */     // MIs[14] src1
     /*  28891 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28896 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  28900 */     // MIs[13] Operand 2
     /*  28900 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  28911 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  28915 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28919 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  28922 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28927 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  28931 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  28935 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  28937 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  28941 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28945 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  28949 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  28953 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28957 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28961 */     // MIs[17] src0
     /*  28961 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28966 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28970 */     // MIs[16] Operand 2
     /*  28970 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28981 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28985 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28989 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28993 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28997 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29001 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29005 */     // MIs[19] src1
     /*  29005 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29010 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  29014 */     // MIs[18] Operand 2
     /*  29014 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  29025 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29027 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29027 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29030 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29032 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29035 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  29039 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  29046 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29049 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  29053 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29056 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29059 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29062 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29065 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29068 */     GIR_RootConstrainSelectedInstOperands,
     /*  29069 */     // GIR_Coverage, 10596,
     /*  29069 */     GIR_EraseRootFromParent_Done,
     /*  29070 */   // Label 231: @29070
     /*  29070 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(29551), // Rule ID 10595 //
     /*  29075 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29078 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29080 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29084 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29088 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29092 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29096 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29100 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29102 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29106 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29110 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29113 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29118 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29122 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29126 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29128 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29132 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29136 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29140 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29144 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29148 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29152 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29156 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29160 */     // MIs[3] Operand 2
     /*  29160 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29171 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29175 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29179 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29183 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29187 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29191 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29195 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29199 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29203 */     // MIs[5] Operand 2
     /*  29203 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29214 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29218 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29222 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29226 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29230 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29232 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29236 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29240 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  29243 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29248 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29252 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  29256 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29258 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29262 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29266 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  29270 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  29274 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29278 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  29282 */     // MIs[10] src0
     /*  29282 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29287 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  29291 */     // MIs[9] Operand 2
     /*  29291 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  29302 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  29306 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29310 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  29314 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  29318 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29322 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29326 */     // MIs[12] src1
     /*  29326 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29331 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  29335 */     // MIs[11] Operand 2
     /*  29335 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29346 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  29350 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29354 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29358 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  29362 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  29364 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29368 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29372 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  29375 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29380 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29384 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  29388 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  29390 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  29394 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29398 */     // MIs[15] src0
     /*  29398 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29403 */     // MIs[15] Operand 2
     /*  29403 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29414 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  29418 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29422 */     // MIs[16] src1
     /*  29422 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29427 */     // MIs[16] Operand 2
     /*  29427 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  29438 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29442 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29446 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29449 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29454 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29458 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29462 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29464 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29468 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29472 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29476 */     // MIs[18] src0
     /*  29476 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29481 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29485 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29489 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29493 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29497 */     // MIs[19] src1
     /*  29497 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29502 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29506 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29508 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29508 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29511 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29513 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29516 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29520 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29523 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  29527 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29530 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  29534 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29537 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29540 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29543 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29549 */     GIR_RootConstrainSelectedInstOperands,
     /*  29550 */     // GIR_Coverage, 10595,
     /*  29550 */     GIR_EraseRootFromParent_Done,
     /*  29551 */   // Label 232: @29551
     /*  29551 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(30032), // Rule ID 10594 //
     /*  29556 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29559 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29565 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29569 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29573 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29577 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29581 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29583 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29587 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29591 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29594 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29599 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29603 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29607 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29609 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29613 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29617 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29621 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29625 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29629 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29633 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29637 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29641 */     // MIs[3] Operand 2
     /*  29641 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29652 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29656 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29660 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29664 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29668 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29672 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29676 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29680 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29684 */     // MIs[5] Operand 2
     /*  29684 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29695 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29699 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29703 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29707 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29711 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29713 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29717 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29721 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  29724 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29729 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29733 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  29737 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29739 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29743 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29747 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  29751 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  29755 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29759 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  29763 */     // MIs[10] src0
     /*  29763 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29768 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  29772 */     // MIs[9] Operand 2
     /*  29772 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  29783 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  29787 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29791 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  29795 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  29799 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29803 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29807 */     // MIs[12] src1
     /*  29807 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29812 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  29816 */     // MIs[11] Operand 2
     /*  29816 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29827 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  29831 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29835 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29839 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  29843 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  29845 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  29849 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29853 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  29856 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29861 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29865 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  29869 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  29871 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  29875 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29879 */     // MIs[15] src0
     /*  29879 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29884 */     // MIs[15] Operand 2
     /*  29884 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29895 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  29899 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29903 */     // MIs[16] src1
     /*  29903 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29908 */     // MIs[16] Operand 2
     /*  29908 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  29919 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29923 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29927 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29930 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29935 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29939 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29943 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29945 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29949 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29953 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29957 */     // MIs[18] src0
     /*  29957 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29962 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29966 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29970 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29974 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29978 */     // MIs[19] src1
     /*  29978 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29983 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29987 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29989 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29989 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29992 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29994 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30001 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30011 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  30015 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30018 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30021 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30027 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30030 */     GIR_RootConstrainSelectedInstOperands,
     /*  30031 */     // GIR_Coverage, 10594,
     /*  30031 */     GIR_EraseRootFromParent_Done,
     /*  30032 */   // Label 233: @30032
     /*  30032 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(30513), // Rule ID 10593 //
     /*  30037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30040 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30042 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30046 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30050 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30054 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30058 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30062 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30064 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30068 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30072 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  30075 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30080 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30084 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  30088 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30090 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  30094 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30098 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30102 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  30106 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30110 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30114 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30118 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  30122 */     // MIs[3] Operand 2
     /*  30122 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  30133 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  30137 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30141 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30145 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30149 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30153 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30157 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  30161 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  30165 */     // MIs[5] Operand 2
     /*  30165 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  30176 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  30180 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30184 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30188 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30192 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  30194 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  30198 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30202 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30206 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30210 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30212 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  30216 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30220 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30223 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30228 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30232 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30236 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30238 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30242 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30246 */     // MIs[10] src0
     /*  30246 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30251 */     // MIs[10] Operand 2
     /*  30251 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30262 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30266 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30270 */     // MIs[11] src1
     /*  30270 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30275 */     // MIs[11] Operand 2
     /*  30275 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30286 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  30290 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30294 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30297 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30302 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30306 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30310 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30312 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30316 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30320 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30324 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30328 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30332 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30336 */     // MIs[14] src0
     /*  30336 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30341 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  30345 */     // MIs[13] Operand 2
     /*  30345 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30356 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30360 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30364 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30368 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30372 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30376 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30380 */     // MIs[16] src1
     /*  30380 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30385 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  30389 */     // MIs[15] Operand 2
     /*  30389 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30400 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30404 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30408 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30411 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30416 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30420 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30424 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30426 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30430 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30434 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30438 */     // MIs[18] src0
     /*  30438 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30443 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30447 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30451 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30455 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30459 */     // MIs[19] src1
     /*  30459 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30464 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30468 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30470 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30470 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30473 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30475 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30478 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30482 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30485 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30489 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  30496 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30499 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30502 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30505 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30508 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30511 */     GIR_RootConstrainSelectedInstOperands,
     /*  30512 */     // GIR_Coverage, 10593,
     /*  30512 */     GIR_EraseRootFromParent_Done,
     /*  30513 */   // Label 234: @30513
     /*  30513 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(30994), // Rule ID 10592 //
     /*  30518 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30521 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30523 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30527 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30531 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30535 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30539 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30543 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30545 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30549 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30553 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  30556 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30561 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30565 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  30569 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30571 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  30575 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30579 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30583 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  30587 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30591 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30595 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30599 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  30603 */     // MIs[3] Operand 2
     /*  30603 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  30614 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  30618 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30622 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30626 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30630 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30634 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30638 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  30642 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  30646 */     // MIs[5] Operand 2
     /*  30646 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  30657 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  30661 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30665 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30669 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30673 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  30675 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  30679 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30683 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30687 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30691 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30693 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  30697 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30701 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30704 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30709 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30713 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30717 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30719 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30723 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30727 */     // MIs[10] src0
     /*  30727 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30732 */     // MIs[10] Operand 2
     /*  30732 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30743 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30747 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30751 */     // MIs[11] src1
     /*  30751 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30756 */     // MIs[11] Operand 2
     /*  30756 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30767 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  30771 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30775 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30778 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30783 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30787 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30791 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30793 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30797 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30801 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30805 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30809 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30813 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30817 */     // MIs[14] src0
     /*  30817 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30822 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  30826 */     // MIs[13] Operand 2
     /*  30826 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30837 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30841 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30845 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30849 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30853 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30857 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30861 */     // MIs[16] src1
     /*  30861 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30866 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  30870 */     // MIs[15] Operand 2
     /*  30870 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30881 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30885 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30889 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30892 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30897 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30901 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30905 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30907 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30911 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30915 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30919 */     // MIs[18] src0
     /*  30919 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30924 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30928 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30932 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30936 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30940 */     // MIs[19] src1
     /*  30940 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30945 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30949 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30951 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30951 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30954 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30956 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30959 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30963 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30973 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  30977 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30980 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30983 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30986 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30989 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30992 */     GIR_RootConstrainSelectedInstOperands,
     /*  30993 */     // GIR_Coverage, 10592,
     /*  30993 */     GIR_EraseRootFromParent_Done,
     /*  30994 */   // Label 235: @30994
     /*  30994 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(31475), // Rule ID 10591 //
     /*  30999 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31002 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31004 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31008 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31012 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31016 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31020 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31024 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31026 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31030 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31034 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31038 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31042 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31044 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31048 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31052 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  31055 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31060 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31064 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  31068 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31070 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  31074 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31078 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31082 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31086 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31090 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31094 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31098 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  31102 */     // MIs[4] Operand 2
     /*  31102 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  31113 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  31117 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31121 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31125 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  31129 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31133 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  31137 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31141 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  31145 */     // MIs[6] Operand 2
     /*  31145 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31156 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  31160 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31164 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31168 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  31172 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  31174 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  31178 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31182 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  31185 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31190 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31194 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  31198 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  31200 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  31204 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31208 */     // MIs[10] src0
     /*  31208 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31213 */     // MIs[10] Operand 2
     /*  31213 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31224 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  31228 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31232 */     // MIs[11] src1
     /*  31232 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31237 */     // MIs[11] Operand 2
     /*  31237 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  31248 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31252 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31256 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31259 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31264 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31268 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31272 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31274 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31278 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31282 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31286 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31290 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31294 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31298 */     // MIs[14] src0
     /*  31298 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31303 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31307 */     // MIs[13] Operand 2
     /*  31307 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31318 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31322 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31326 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31330 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31334 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31338 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31342 */     // MIs[16] src1
     /*  31342 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31347 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31351 */     // MIs[15] Operand 2
     /*  31351 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31362 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31366 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31370 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31373 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31378 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31382 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31386 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31388 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31392 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31396 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31400 */     // MIs[18] src0
     /*  31400 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31405 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31409 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31413 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31417 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31421 */     // MIs[19] src1
     /*  31421 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31426 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31430 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31432 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31437 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31440 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31444 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  31451 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  31458 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31461 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31464 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31467 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31470 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31473 */     GIR_RootConstrainSelectedInstOperands,
     /*  31474 */     // GIR_Coverage, 10591,
     /*  31474 */     GIR_EraseRootFromParent_Done,
     /*  31475 */   // Label 236: @31475
     /*  31475 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(31956), // Rule ID 10590 //
     /*  31480 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31483 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31485 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31489 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31493 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31497 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31501 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31505 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31507 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31511 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31515 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31519 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31523 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31525 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31529 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31533 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  31536 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31541 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31545 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  31549 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31551 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  31555 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31559 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31563 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31567 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31571 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31575 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31579 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  31583 */     // MIs[4] Operand 2
     /*  31583 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  31594 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  31598 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31602 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31606 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  31610 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31614 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  31618 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31622 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  31626 */     // MIs[6] Operand 2
     /*  31626 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31637 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  31641 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31645 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31649 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  31653 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  31655 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  31659 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31663 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  31666 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31671 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31675 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  31679 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  31681 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  31685 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31689 */     // MIs[10] src0
     /*  31689 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31694 */     // MIs[10] Operand 2
     /*  31694 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31705 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  31709 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31713 */     // MIs[11] src1
     /*  31713 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31718 */     // MIs[11] Operand 2
     /*  31718 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  31729 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31733 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31737 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31740 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31745 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31749 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31753 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31755 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31759 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31763 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31767 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31771 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31775 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31779 */     // MIs[14] src0
     /*  31779 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31784 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31788 */     // MIs[13] Operand 2
     /*  31788 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31799 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31803 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31807 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31811 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31815 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31819 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31823 */     // MIs[16] src1
     /*  31823 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31828 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31832 */     // MIs[15] Operand 2
     /*  31832 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31843 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31847 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31851 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31854 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31859 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31863 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31867 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31869 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31873 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31877 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31881 */     // MIs[18] src0
     /*  31881 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31886 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31890 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31894 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31898 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31902 */     // MIs[19] src1
     /*  31902 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31907 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31911 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31913 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31913 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31916 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31918 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31921 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31925 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  31932 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31935 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  31939 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31942 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31945 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31948 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31951 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31954 */     GIR_RootConstrainSelectedInstOperands,
     /*  31955 */     // GIR_Coverage, 10590,
     /*  31955 */     GIR_EraseRootFromParent_Done,
     /*  31956 */   // Label 237: @31956
     /*  31956 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(32437), // Rule ID 10589 //
     /*  31961 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31964 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31970 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31974 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31978 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31982 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31986 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31988 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31992 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31996 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32000 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32004 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32006 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32010 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32014 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32018 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32022 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  32024 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  32028 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32032 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  32035 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32040 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32044 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  32048 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32050 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32054 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32058 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  32062 */     // MIs[5] Operand 2
     /*  32062 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  32073 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  32077 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32081 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  32085 */     // MIs[6] Operand 2
     /*  32085 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  32096 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  32100 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32104 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  32107 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32112 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32116 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  32120 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  32122 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  32126 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32130 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  32134 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  32138 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32142 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  32146 */     // MIs[9] src0
     /*  32146 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32151 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  32155 */     // MIs[8] Operand 2
     /*  32155 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  32166 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  32170 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32174 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  32178 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  32182 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32186 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  32190 */     // MIs[11] src1
     /*  32190 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32195 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  32199 */     // MIs[10] Operand 2
     /*  32199 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  32210 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  32214 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32218 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  32221 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32226 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  32230 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  32234 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  32236 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  32240 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32244 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  32248 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  32252 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32256 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  32260 */     // MIs[14] src0
     /*  32260 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32265 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  32269 */     // MIs[13] Operand 2
     /*  32269 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  32280 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  32284 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32288 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  32292 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  32296 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32300 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  32304 */     // MIs[16] src1
     /*  32304 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32309 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  32313 */     // MIs[15] Operand 2
     /*  32313 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  32324 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  32328 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32332 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  32335 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32340 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  32344 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  32348 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  32350 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  32354 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32358 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  32362 */     // MIs[18] src0
     /*  32362 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32367 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  32371 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  32375 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32379 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  32383 */     // MIs[19] src1
     /*  32383 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32388 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  32392 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  32394 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32394 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  32397 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32399 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32402 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  32406 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32409 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  32413 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32416 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  32420 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32423 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32426 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32429 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32432 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32435 */     GIR_RootConstrainSelectedInstOperands,
     /*  32436 */     // GIR_Coverage, 10589,
     /*  32436 */     GIR_EraseRootFromParent_Done,
     /*  32437 */   // Label 238: @32437
     /*  32437 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(32918), // Rule ID 2940 //
     /*  32442 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  32445 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  32447 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32451 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32455 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32459 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32463 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32467 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32469 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32473 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32477 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32481 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32485 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32487 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32491 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32495 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32499 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32503 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  32505 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  32509 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32513 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  32516 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32521 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32525 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  32529 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32531 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32535 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32539 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  32543 */     // MIs[5] Operand 2
     /*  32543 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  32554 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  32558 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32562 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  32566 */     // MIs[6] Operand 2
     /*  32566 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  32577 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  32581 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32585 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  32588 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32593 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32597 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  32601 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  32603 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  32607 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32611 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  32615 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  32619 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32623 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  32627 */     // MIs[9] src0
     /*  32627 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32632 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  32636 */     // MIs[8] Operand 2
     /*  32636 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  32647 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  32651 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32655 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  32659 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  32663 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32667 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  32671 */     // MIs[11] src1
     /*  32671 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32676 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  32680 */     // MIs[10] Operand 2
     /*  32680 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  32691 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  32695 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32699 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  32702 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32707 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  32711 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  32715 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  32717 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  32721 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32725 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  32729 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  32733 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32737 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  32741 */     // MIs[14] src0
     /*  32741 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32746 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  32750 */     // MIs[13] Operand 2
     /*  32750 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  32761 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  32765 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32769 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  32773 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  32777 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32781 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  32785 */     // MIs[16] src1
     /*  32785 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32790 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  32794 */     // MIs[15] Operand 2
     /*  32794 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  32805 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  32809 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32813 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  32816 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32821 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  32825 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  32829 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  32831 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  32835 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32839 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  32843 */     // MIs[18] src0
     /*  32843 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32848 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  32852 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  32856 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32860 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  32864 */     // MIs[19] src1
     /*  32864 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32869 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  32873 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  32875 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32875 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  32878 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32880 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32883 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  32887 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32890 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  32894 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32897 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  32901 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32904 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32907 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32910 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32913 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32916 */     GIR_RootConstrainSelectedInstOperands,
     /*  32917 */     // GIR_Coverage, 2940,
     /*  32917 */     GIR_EraseRootFromParent_Done,
     /*  32918 */   // Label 239: @32918
     /*  32918 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(33141), // Rule ID 9246 //
     /*  32923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32930 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32934 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32938 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32941 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32946 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32950 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32954 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32956 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32960 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32964 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32968 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32972 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  32983 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32987 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32991 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32995 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32999 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  33010 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33014 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33018 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33022 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33026 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33028 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  33032 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33036 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33039 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33044 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33048 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33052 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33054 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33058 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33062 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33066 */     // MIs[6] src0
     /*  33066 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33071 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33075 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33079 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33083 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33087 */     // MIs[7] src1
     /*  33087 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33092 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33096 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33098 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33103 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33106 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33110 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33113 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33117 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33120 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  33124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33127 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33130 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33133 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33136 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33139 */     GIR_RootConstrainSelectedInstOperands,
     /*  33140 */     // GIR_Coverage, 9246,
     /*  33140 */     GIR_EraseRootFromParent_Done,
     /*  33141 */   // Label 240: @33141
     /*  33141 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(33364), // Rule ID 9247 //
     /*  33146 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33149 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33153 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33157 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33161 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33164 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33169 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33173 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33177 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33179 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33183 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33187 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33191 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33195 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  33206 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  33210 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33214 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33218 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33222 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  33233 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33237 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33241 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33245 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33249 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33251 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  33255 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33259 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33262 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33267 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33271 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33275 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33277 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33281 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33285 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33289 */     // MIs[6] src0
     /*  33289 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33294 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33298 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33302 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33306 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33310 */     // MIs[7] src1
     /*  33310 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33315 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33319 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33321 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33321 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33324 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33336 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33340 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33343 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  33347 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33350 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33353 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33356 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33359 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33362 */     GIR_RootConstrainSelectedInstOperands,
     /*  33363 */     // GIR_Coverage, 9247,
     /*  33363 */     GIR_EraseRootFromParent_Done,
     /*  33364 */   // Label 241: @33364
     /*  33364 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(33587), // Rule ID 2916 //
     /*  33369 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33372 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33376 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33380 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33384 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33388 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33392 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33394 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33398 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33402 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33405 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33410 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33414 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33418 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33420 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33424 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33428 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33432 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33436 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33440 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33444 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33448 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33452 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33456 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33460 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33464 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33468 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33471 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33476 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33480 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33484 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33486 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33490 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33494 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33498 */     // MIs[6] src0
     /*  33498 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33503 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  33514 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33518 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33522 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33526 */     // MIs[7] src1
     /*  33526 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33531 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  33542 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33544 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33549 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33556 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33559 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33563 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33566 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  33570 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33573 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33579 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33582 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33585 */     GIR_RootConstrainSelectedInstOperands,
     /*  33586 */     // GIR_Coverage, 2916,
     /*  33586 */     GIR_EraseRootFromParent_Done,
     /*  33587 */   // Label 242: @33587
     /*  33587 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(33810), // Rule ID 9245 //
     /*  33592 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33595 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33599 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33603 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33607 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33611 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33615 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33617 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33621 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33625 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33628 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33633 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33637 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33641 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33643 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33647 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33651 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33655 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33659 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33663 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33667 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33671 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33675 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33679 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33683 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33687 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33691 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33694 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33699 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33703 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33707 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33709 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33713 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33717 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33721 */     // MIs[6] src0
     /*  33721 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33726 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  33737 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33741 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33745 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33749 */     // MIs[7] src1
     /*  33749 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33754 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  33765 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33767 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33767 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33770 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33772 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33775 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33779 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33782 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33786 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33789 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  33793 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33796 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33799 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33802 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33805 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33808 */     GIR_RootConstrainSelectedInstOperands,
     /*  33809 */     // GIR_Coverage, 9245,
     /*  33809 */     GIR_EraseRootFromParent_Done,
     /*  33810 */   // Label 243: @33810
     /*  33810 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(34025), // Rule ID 9278 //
     /*  33815 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33818 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33822 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33830 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33833 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33838 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33842 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33846 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33848 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33852 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33856 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33860 */     // MIs[2] Operand 2
     /*  33860 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  33871 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  33875 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33879 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33883 */     // MIs[3] Operand 2
     /*  33883 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  33894 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33898 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33902 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33906 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33910 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33912 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  33916 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33920 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33923 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33928 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33932 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33936 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33938 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33942 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33946 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33950 */     // MIs[6] src0
     /*  33950 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33955 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33959 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33963 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33967 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33971 */     // MIs[7] src1
     /*  33971 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33976 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33980 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33982 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33982 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33985 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33987 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33990 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33994 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  34001 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  34008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34011 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34014 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34017 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34020 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34023 */     GIR_RootConstrainSelectedInstOperands,
     /*  34024 */     // GIR_Coverage, 9278,
     /*  34024 */     GIR_EraseRootFromParent_Done,
     /*  34025 */   // Label 244: @34025
     /*  34025 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(34240), // Rule ID 9279 //
     /*  34030 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34033 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34037 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34041 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34045 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34048 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34053 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34057 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34061 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34063 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34067 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34071 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34075 */     // MIs[2] Operand 2
     /*  34075 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  34086 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  34090 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34094 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34098 */     // MIs[3] Operand 2
     /*  34098 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  34109 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  34113 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34117 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34121 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34125 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  34127 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  34131 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34135 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34138 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34143 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34147 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34151 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34153 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34157 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34161 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  34165 */     // MIs[6] src0
     /*  34165 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34170 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  34174 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34178 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34182 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  34186 */     // MIs[7] src1
     /*  34186 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34191 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  34195 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34197 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34197 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34200 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34202 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34205 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34209 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34212 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  34216 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34219 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  34223 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34226 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34229 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34232 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34235 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34238 */     GIR_RootConstrainSelectedInstOperands,
     /*  34239 */     // GIR_Coverage, 9279,
     /*  34239 */     GIR_EraseRootFromParent_Done,
     /*  34240 */   // Label 245: @34240
     /*  34240 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(34455), // Rule ID 2920 //
     /*  34245 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34248 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34260 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34264 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34268 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34270 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34274 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34278 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  34281 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34286 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34290 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34294 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  34296 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34300 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34304 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34308 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  34312 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  34316 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  34320 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34324 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34328 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34332 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  34336 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34340 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34344 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34347 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34352 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34356 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34360 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34362 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34366 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34370 */     // MIs[6] src0
     /*  34370 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34375 */     // MIs[6] Operand 2
     /*  34375 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  34386 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34390 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34394 */     // MIs[7] src1
     /*  34394 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  34399 */     // MIs[7] Operand 2
     /*  34399 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  34410 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34412 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34412 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34415 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34417 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  34424 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34427 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  34431 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34434 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  34438 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34441 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34444 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34447 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34450 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34453 */     GIR_RootConstrainSelectedInstOperands,
     /*  34454 */     // GIR_Coverage, 2920,
     /*  34454 */     GIR_EraseRootFromParent_Done,
     /*  34455 */   // Label 246: @34455
     /*  34455 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(34670), // Rule ID 9277 //
     /*  34460 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34463 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34467 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34471 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34475 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34479 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34483 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34485 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34489 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34493 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  34496 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34501 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34505 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34509 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  34511 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34515 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34519 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34523 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  34527 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  34531 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  34535 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34539 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34543 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34547 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  34551 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34555 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34559 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34562 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34567 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34571 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34575 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34577 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34581 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34585 */     // MIs[6] src0
     /*  34585 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34590 */     // MIs[6] Operand 2
     /*  34590 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  34601 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34605 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34609 */     // MIs[7] src1
     /*  34609 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  34614 */     // MIs[7] Operand 2
     /*  34614 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  34625 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34627 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34627 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34630 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34632 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34635 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  34639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34642 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  34646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34649 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  34653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34659 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34668 */     GIR_RootConstrainSelectedInstOperands,
     /*  34669 */     // GIR_Coverage, 9277,
     /*  34669 */     GIR_EraseRootFromParent_Done,
     /*  34670 */   // Label 247: @34670
     /*  34670 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(34735), // Rule ID 2728 //
     /*  34675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  34678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34682 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34686 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  34690 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34694 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34698 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34700 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  34704 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  34708 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
     /*  34712 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  34716 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34718 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_24508>>, i32:{ *:[i32] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_24507>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  34721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34723 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34727 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  34731 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34733 */     GIR_RootConstrainSelectedInstOperands,
     /*  34734 */     // GIR_Coverage, 2728,
     /*  34734 */     GIR_EraseRootFromParent_Done,
     /*  34735 */   // Label 248: @34735
     /*  34735 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(34800), // Rule ID 9213 //
     /*  34740 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  34743 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34747 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
     /*  34751 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34755 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  34759 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34763 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34767 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34769 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  34773 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  34777 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  34781 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34783 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:9:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_24508>>)<<P:9:Predicate_anonymous_24507>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34783 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  34786 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34792 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  34796 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34798 */     GIR_RootConstrainSelectedInstOperands,
     /*  34799 */     // GIR_Coverage, 9213,
     /*  34799 */     GIR_EraseRootFromParent_Done,
     /*  34800 */   // Label 249: @34800
     /*  34800 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(34853), // Rule ID 8288 //
     /*  34805 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34809 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34813 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34817 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34821 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34825 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  34829 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  34833 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16755),
     /*  34837 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34839 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_16755>>  =>  (S_BFM_B32:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  34839 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_BFM_B32),
     /*  34842 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34844 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  34848 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34851 */     GIR_RootConstrainSelectedInstOperands,
     /*  34852 */     // GIR_Coverage, 8288,
     /*  34852 */     GIR_EraseRootFromParent_Done,
     /*  34853 */   // Label 250: @34853
     /*  34853 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(34906), // Rule ID 8290 //
     /*  34858 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34862 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34866 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34870 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34874 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34878 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  34882 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  34886 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  34890 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34892 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_23147>>  =>  (V_BFM_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  34892 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFM_B32_e64),
     /*  34895 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34897 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  34901 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34904 */     GIR_RootConstrainSelectedInstOperands,
     /*  34905 */     // GIR_Coverage, 8290,
     /*  34905 */     GIR_EraseRootFromParent_Done,
     /*  34906 */   // Label 251: @34906
     /*  34906 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(35016), // Rule ID 8091 //
     /*  34911 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34915 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34919 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  34923 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  34927 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34931 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34935 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34937 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34941 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  34945 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34949 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34953 */     // MIs[2] Operand 1
     /*  34953 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  34958 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34962 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34966 */     // MIs[3] src0
     /*  34966 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34971 */     // MIs[3] src1
     /*  34971 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34976 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  34980 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34984 */     // MIs[4] src1
     /*  34984 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34989 */     // MIs[4] src0
     /*  34989 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34994 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  34996 */     // (add:{ *:[i32] } (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34996 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34999 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35001 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35005 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  35009 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35011 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35014 */     GIR_RootConstrainSelectedInstOperands,
     /*  35015 */     // GIR_Coverage, 8091,
     /*  35015 */     GIR_EraseRootFromParent_Done,
     /*  35016 */   // Label 252: @35016
     /*  35016 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(35126), // Rule ID 11930 //
     /*  35021 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35025 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35029 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  35033 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  35037 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35041 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35045 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35047 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35051 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  35055 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35059 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  35063 */     // MIs[2] Operand 1
     /*  35063 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  35068 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35072 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35076 */     // MIs[3] src0
     /*  35076 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35081 */     // MIs[3] src1
     /*  35081 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  35086 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  35090 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35094 */     // MIs[4] src1
     /*  35094 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  35099 */     // MIs[4] src0
     /*  35099 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35104 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  35106 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35115 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  35119 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35124 */     GIR_RootConstrainSelectedInstOperands,
     /*  35125 */     // GIR_Coverage, 11930,
     /*  35125 */     GIR_EraseRootFromParent_Done,
     /*  35126 */   // Label 253: @35126
     /*  35126 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(35219), // Rule ID 2718 //
     /*  35131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35138 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35142 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35146 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35150 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35154 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35156 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  35160 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  35164 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35168 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35172 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35176 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  35180 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35184 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  35188 */     // MIs[3] Operand 1
     /*  35188 */     // No operand predicates
     /*  35188 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  35192 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  35196 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24485),
     /*  35200 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35202 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24486>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24485>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  35202 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  35205 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35207 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35215 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35217 */     GIR_RootConstrainSelectedInstOperands,
     /*  35218 */     // GIR_Coverage, 2718,
     /*  35218 */     GIR_EraseRootFromParent_Done,
     /*  35219 */   // Label 254: @35219
     /*  35219 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(35312), // Rule ID 9206 //
     /*  35224 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35227 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35231 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  35235 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35239 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35243 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35247 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35251 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35253 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  35257 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  35261 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35265 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35269 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35273 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  35277 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35281 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  35285 */     // MIs[3] Operand 1
     /*  35285 */     // No operand predicates
     /*  35285 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  35289 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24485),
     /*  35293 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35295 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24486>>)<<P:1:Predicate_anonymous_24485>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  35295 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  35298 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35300 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35304 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35308 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35310 */     GIR_RootConstrainSelectedInstOperands,
     /*  35311 */     // GIR_Coverage, 9206,
     /*  35311 */     GIR_EraseRootFromParent_Done,
     /*  35312 */   // Label 255: @35312
     /*  35312 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(35367), // Rule ID 8022 //
     /*  35317 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35321 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35325 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35329 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35332 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  35337 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35341 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35345 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35347 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  35350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35360 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35362 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35365 */     GIR_RootConstrainSelectedInstOperands,
     /*  35366 */     // GIR_Coverage, 8022,
     /*  35366 */     GIR_EraseRootFromParent_Done,
     /*  35367 */   // Label 256: @35367
     /*  35367 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(35422), // Rule ID 8024 //
     /*  35372 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35376 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35380 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35384 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35387 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  35392 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35396 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35400 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35402 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35402 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  35405 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35407 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35411 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35415 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35417 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35420 */     GIR_RootConstrainSelectedInstOperands,
     /*  35421 */     // GIR_Coverage, 8024,
     /*  35421 */     GIR_EraseRootFromParent_Done,
     /*  35422 */   // Label 257: @35422
     /*  35422 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(35487), // Rule ID 82 //
     /*  35427 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35430 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35434 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35438 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35442 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35446 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35450 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35452 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35457 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  35461 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35465 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  35469 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35471 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35471 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  35474 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35476 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35480 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35482 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35485 */     GIR_RootConstrainSelectedInstOperands,
     /*  35486 */     // GIR_Coverage, 82,
     /*  35486 */     GIR_EraseRootFromParent_Done,
     /*  35487 */   // Label 258: @35487
     /*  35487 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(35552), // Rule ID 83 //
     /*  35492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35495 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35507 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35511 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35515 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35517 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35522 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  35526 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35530 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  35534 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35536 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35536 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  35539 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35545 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35547 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35550 */     GIR_RootConstrainSelectedInstOperands,
     /*  35551 */     // GIR_Coverage, 83,
     /*  35551 */     GIR_EraseRootFromParent_Done,
     /*  35552 */   // Label 259: @35552
     /*  35552 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(35617), // Rule ID 84 //
     /*  35557 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35560 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35564 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35568 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35572 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35576 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35580 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35582 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35587 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  35591 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35595 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  35599 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35601 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35601 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  35604 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35606 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35610 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35612 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35615 */     GIR_RootConstrainSelectedInstOperands,
     /*  35616 */     // GIR_Coverage, 84,
     /*  35616 */     GIR_EraseRootFromParent_Done,
     /*  35617 */   // Label 260: @35617
     /*  35617 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(35682), // Rule ID 85 //
     /*  35622 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35625 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35637 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35641 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35645 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35647 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35652 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  35656 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35660 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  35664 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35666 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35666 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  35669 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35671 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35675 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35677 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35680 */     GIR_RootConstrainSelectedInstOperands,
     /*  35681 */     // GIR_Coverage, 85,
     /*  35681 */     GIR_EraseRootFromParent_Done,
     /*  35682 */   // Label 261: @35682
     /*  35682 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(35765), // Rule ID 8090 //
     /*  35687 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35691 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35695 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35699 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35703 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35707 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35709 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35713 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35717 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35721 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35725 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35729 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35733 */     // MIs[3] src0
     /*  35733 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35738 */     // MIs[3] src1
     /*  35738 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35743 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35745 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35745 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35748 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35750 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35754 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35758 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35760 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35763 */     GIR_RootConstrainSelectedInstOperands,
     /*  35764 */     // GIR_Coverage, 8090,
     /*  35764 */     GIR_EraseRootFromParent_Done,
     /*  35765 */   // Label 262: @35765
     /*  35765 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(35848), // Rule ID 11923 //
     /*  35770 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35774 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35778 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35782 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35786 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35790 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35792 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35796 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35800 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35804 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35808 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35812 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35816 */     // MIs[3] src1
     /*  35816 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35821 */     // MIs[3] src0
     /*  35821 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35826 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35828 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35828 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35831 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35833 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35837 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35841 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35843 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35846 */     GIR_RootConstrainSelectedInstOperands,
     /*  35847 */     // GIR_Coverage, 11923,
     /*  35847 */     GIR_EraseRootFromParent_Done,
     /*  35848 */   // Label 263: @35848
     /*  35848 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(35931), // Rule ID 11924 //
     /*  35853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35857 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35861 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35865 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35869 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35873 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35875 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35879 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35883 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35887 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35891 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35895 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35899 */     // MIs[3] src0
     /*  35899 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35904 */     // MIs[3] src1
     /*  35904 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35909 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35911 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35911 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35914 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35916 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35920 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35924 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35926 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35929 */     GIR_RootConstrainSelectedInstOperands,
     /*  35930 */     // GIR_Coverage, 11924,
     /*  35930 */     GIR_EraseRootFromParent_Done,
     /*  35931 */   // Label 264: @35931
     /*  35931 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(36014), // Rule ID 11925 //
     /*  35936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35940 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35944 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35948 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35952 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35956 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35958 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35962 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35966 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35970 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35974 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35978 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35982 */     // MIs[3] src1
     /*  35982 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35987 */     // MIs[3] src0
     /*  35987 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35992 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35994 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35994 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35997 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35999 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  36003 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  36007 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36009 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36012 */     GIR_RootConstrainSelectedInstOperands,
     /*  36013 */     // GIR_Coverage, 11925,
     /*  36013 */     GIR_EraseRootFromParent_Done,
     /*  36014 */   // Label 265: @36014
     /*  36014 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(36079), // Rule ID 9119 //
     /*  36019 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36022 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36026 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36030 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36034 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36038 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36042 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36046 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36048 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36053 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  36057 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  36061 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36063 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36063 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  36066 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36068 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36072 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36074 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36077 */     GIR_RootConstrainSelectedInstOperands,
     /*  36078 */     // GIR_Coverage, 9119,
     /*  36078 */     GIR_EraseRootFromParent_Done,
     /*  36079 */   // Label 266: @36079
     /*  36079 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(36144), // Rule ID 9120 //
     /*  36084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36087 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36091 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36095 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36099 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36103 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36107 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36111 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36113 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36118 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  36122 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  36126 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36128 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36128 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  36131 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36133 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36137 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36139 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36142 */     GIR_RootConstrainSelectedInstOperands,
     /*  36143 */     // GIR_Coverage, 9120,
     /*  36143 */     GIR_EraseRootFromParent_Done,
     /*  36144 */   // Label 267: @36144
     /*  36144 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(36209), // Rule ID 9121 //
     /*  36149 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36152 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36156 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36160 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36164 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36168 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36172 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36176 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36178 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36183 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  36187 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  36191 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36193 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36193 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  36196 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36198 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36202 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36204 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36207 */     GIR_RootConstrainSelectedInstOperands,
     /*  36208 */     // GIR_Coverage, 9121,
     /*  36208 */     GIR_EraseRootFromParent_Done,
     /*  36209 */   // Label 268: @36209
     /*  36209 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(36274), // Rule ID 9122 //
     /*  36214 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36217 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36221 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36225 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36229 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36233 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36237 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36241 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36243 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36248 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  36252 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  36256 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36258 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36258 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  36261 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36263 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36267 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36269 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36272 */     GIR_RootConstrainSelectedInstOperands,
     /*  36273 */     // GIR_Coverage, 9122,
     /*  36273 */     GIR_EraseRootFromParent_Done,
     /*  36274 */   // Label 269: @36274
     /*  36274 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(36329), // Rule ID 11879 //
     /*  36279 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36283 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36287 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  36291 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  36294 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  36299 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36303 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  36307 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36309 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3290:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36309 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  36312 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  36318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  36322 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36324 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36327 */     GIR_RootConstrainSelectedInstOperands,
     /*  36328 */     // GIR_Coverage, 11879,
     /*  36328 */     GIR_EraseRootFromParent_Done,
     /*  36329 */   // Label 270: @36329
     /*  36329 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(36384), // Rule ID 11881 //
     /*  36334 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36338 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36342 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  36346 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  36349 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  36354 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36358 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  36362 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36364 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36364 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  36367 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36369 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  36373 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  36377 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36379 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36382 */     GIR_RootConstrainSelectedInstOperands,
     /*  36383 */     // GIR_Coverage, 11881,
     /*  36383 */     GIR_EraseRootFromParent_Done,
     /*  36384 */   // Label 271: @36384
     /*  36384 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(36467), // Rule ID 11926 //
     /*  36389 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36393 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36397 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36401 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36405 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36409 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36411 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36415 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36419 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36423 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36427 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36431 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36435 */     // MIs[3] src0
     /*  36435 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36440 */     // MIs[3] src1
     /*  36440 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36445 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36447 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  36456 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  36460 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36462 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36465 */     GIR_RootConstrainSelectedInstOperands,
     /*  36466 */     // GIR_Coverage, 11926,
     /*  36466 */     GIR_EraseRootFromParent_Done,
     /*  36467 */   // Label 272: @36467
     /*  36467 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(36550), // Rule ID 11927 //
     /*  36472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36484 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36488 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36492 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36494 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36498 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36502 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36506 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36510 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36514 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36518 */     // MIs[3] src1
     /*  36518 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36523 */     // MIs[3] src0
     /*  36523 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36528 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36530 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36530 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36533 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36535 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  36539 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  36543 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36545 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36548 */     GIR_RootConstrainSelectedInstOperands,
     /*  36549 */     // GIR_Coverage, 11927,
     /*  36549 */     GIR_EraseRootFromParent_Done,
     /*  36550 */   // Label 273: @36550
     /*  36550 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(36633), // Rule ID 11928 //
     /*  36555 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36559 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36563 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36567 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36571 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36575 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36577 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36581 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36585 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36589 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36593 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36597 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36601 */     // MIs[3] src0
     /*  36601 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36606 */     // MIs[3] src1
     /*  36606 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36611 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36613 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36613 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36616 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36618 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  36622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  36626 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36631 */     GIR_RootConstrainSelectedInstOperands,
     /*  36632 */     // GIR_Coverage, 11928,
     /*  36632 */     GIR_EraseRootFromParent_Done,
     /*  36633 */   // Label 274: @36633
     /*  36633 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(36716), // Rule ID 11929 //
     /*  36638 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36642 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36646 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36650 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36654 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36658 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36660 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36664 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36668 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36672 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36676 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36680 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36684 */     // MIs[3] src1
     /*  36684 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36689 */     // MIs[3] src0
     /*  36689 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36694 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36696 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36701 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  36705 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  36709 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36711 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36714 */     GIR_RootConstrainSelectedInstOperands,
     /*  36715 */     // GIR_Coverage, 11929,
     /*  36715 */     GIR_EraseRootFromParent_Done,
     /*  36716 */   // Label 275: @36716
     /*  36716 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(36881), // Rule ID 9221 //
     /*  36721 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  36724 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36728 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:17:z
     /*  36732 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36736 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36740 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36744 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36748 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36752 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36754 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
     /*  36758 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
     /*  36762 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  36766 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36768 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:17:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:17:x, i32:{ *:[i32] }:$src1:$pred:17:y)<<P:Predicate_anonymous_24508>>)<<P:17:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36768 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36771 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36775 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36780 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36782 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36785 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36789 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36794 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36798 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36801 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36804 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36807 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36812 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36817 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36822 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36825 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36828 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  36832 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36837 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36842 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36846 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36850 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36853 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36856 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36858 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36861 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36863 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36870 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36875 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36880 */     // GIR_Coverage, 9221,
     /*  36880 */     GIR_EraseRootFromParent_Done,
     /*  36881 */   // Label 276: @36881
     /*  36881 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(37046), // Rule ID 9225 //
     /*  36886 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  36889 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36893 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:20:z
     /*  36897 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36901 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36905 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36909 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36913 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36917 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36919 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
     /*  36923 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
     /*  36927 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  36931 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36933 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:20:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:20:x, i32:{ *:[i32] }:$src1:$pred:20:y)<<P:Predicate_anonymous_24508>>)<<P:20:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36933 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36936 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36940 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36945 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36947 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36950 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36954 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36959 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36963 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36966 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36969 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36972 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36977 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36982 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36987 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36990 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36993 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36997 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37002 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37007 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37011 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37015 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37018 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37021 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37028 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37035 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37040 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37045 */     // GIR_Coverage, 9225,
     /*  37045 */     GIR_EraseRootFromParent_Done,
     /*  37046 */   // Label 277: @37046
     /*  37046 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(37111), // Rule ID 2721 //
     /*  37051 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37054 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37058 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37062 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  37066 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37070 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37074 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37076 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  37080 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  37084 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
     /*  37088 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24491),
     /*  37092 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37094 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24489>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_24491>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37094 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  37097 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37099 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37103 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37107 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37109 */     GIR_RootConstrainSelectedInstOperands,
     /*  37110 */     // GIR_Coverage, 2721,
     /*  37110 */     GIR_EraseRootFromParent_Done,
     /*  37111 */   // Label 278: @37111
     /*  37111 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(37276), // Rule ID 2747 //
     /*  37116 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37119 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37123 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37127 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37131 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37135 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37139 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37141 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
     /*  37145 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
     /*  37149 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:17:z
     /*  37153 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37157 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  37161 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37163 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:17:x, i32:{ *:[i32] }:$src1:$pred:17:y)<<P:Predicate_anonymous_24508>>, VGPR_32:{ *:[i32] }:$src2:$pred:17:z)<<P:17:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37163 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37166 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37170 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37175 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37177 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37180 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37184 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37189 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37193 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37196 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37199 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37202 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37207 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37212 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37217 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37220 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37223 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37227 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37232 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37237 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37241 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37245 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37248 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37251 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37253 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37256 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37258 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37265 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37270 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37275 */     // GIR_Coverage, 2747,
     /*  37275 */     GIR_EraseRootFromParent_Done,
     /*  37276 */   // Label 279: @37276
     /*  37276 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(37441), // Rule ID 2756 //
     /*  37281 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37284 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37288 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37292 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37296 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37300 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37304 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37306 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
     /*  37310 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
     /*  37314 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:20:z
     /*  37318 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37322 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  37326 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37328 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:20:x, i32:{ *:[i32] }:$src1:$pred:20:y)<<P:Predicate_anonymous_24508>>, VGPR_32:{ *:[i32] }:$src2:$pred:20:z)<<P:20:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37328 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37331 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37335 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37340 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37342 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37345 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37349 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37354 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37358 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37361 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37364 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37367 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37372 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37377 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37382 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37385 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37388 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37392 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37397 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37402 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37406 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37410 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37413 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37416 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37418 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37421 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37423 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37430 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37435 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37440 */     // GIR_Coverage, 2756,
     /*  37440 */     GIR_EraseRootFromParent_Done,
     /*  37441 */   // Label 280: @37441
     /*  37441 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(37602), // Rule ID 2746 //
     /*  37446 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37449 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37453 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37457 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37461 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37465 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37469 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37471 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  37475 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  37479 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:16:z
     /*  37483 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  37487 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37489 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24508>>, i32:{ *:[i32] }:$src2:$pred:16:z)<<P:16:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37489 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37492 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37496 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37501 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37503 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37506 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37510 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37515 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37519 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37522 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37525 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37528 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37533 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37538 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37543 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37546 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37549 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37553 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37558 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37563 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37567 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37571 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37574 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37577 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37579 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37582 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37584 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37591 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37596 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37601 */     // GIR_Coverage, 2746,
     /*  37601 */     GIR_EraseRootFromParent_Done,
     /*  37602 */   // Label 281: @37602
     /*  37602 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(37763), // Rule ID 2755 //
     /*  37607 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37610 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37614 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37618 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37622 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37626 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37630 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37632 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  37636 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  37640 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:19:z
     /*  37644 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  37648 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37650 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_24508>>, i32:{ *:[i32] }:$src2:$pred:19:z)<<P:19:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37650 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37653 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37657 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37662 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37664 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37667 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37671 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37676 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37680 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37683 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37686 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37689 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37694 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37699 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37704 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37707 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37710 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37714 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37719 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37724 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37728 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37732 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37735 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37738 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37740 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37743 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37745 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37752 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37757 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37762 */     // GIR_Coverage, 2755,
     /*  37762 */     GIR_EraseRootFromParent_Done,
     /*  37763 */   // Label 282: @37763
     /*  37763 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(37828), // Rule ID 2717 //
     /*  37768 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37771 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37775 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37779 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  37783 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37787 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37791 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37793 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  37797 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  37801 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  37805 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24485),
     /*  37809 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37811 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24486>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24485>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37811 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  37814 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37816 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37820 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37824 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37826 */     GIR_RootConstrainSelectedInstOperands,
     /*  37827 */     // GIR_Coverage, 2717,
     /*  37827 */     GIR_EraseRootFromParent_Done,
     /*  37828 */   // Label 283: @37828
     /*  37828 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(37893), // Rule ID 2727 //
     /*  37833 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37836 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37840 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37844 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37848 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37852 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37856 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37858 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  37862 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  37866 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
     /*  37870 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24504),
     /*  37874 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37876 */     // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24505>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_24504>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37876 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  37879 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37881 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37885 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37889 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37891 */     GIR_RootConstrainSelectedInstOperands,
     /*  37892 */     // GIR_Coverage, 2727,
     /*  37892 */     GIR_EraseRootFromParent_Done,
     /*  37893 */   // Label 284: @37893
     /*  37893 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(37933), // Rule ID 7591 //
     /*  37898 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37902 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37906 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37910 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37914 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40372),
     /*  37918 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37920 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40372>>, i32:{ *:[i32] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  37920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  37929 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  37931 */     GIR_RootConstrainSelectedInstOperands,
     /*  37932 */     // GIR_Coverage, 7591,
     /*  37932 */     GIR_EraseRootFromParent_Done,
     /*  37933 */   // Label 285: @37933
     /*  37933 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(37998), // Rule ID 9207 //
     /*  37938 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37945 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
     /*  37949 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37953 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  37957 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37961 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37965 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37967 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  37971 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  37975 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24491),
     /*  37979 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37981 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24489>>)<<P:3:Predicate_anonymous_24491>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37981 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  37984 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37986 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37990 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37994 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37996 */     GIR_RootConstrainSelectedInstOperands,
     /*  37997 */     // GIR_Coverage, 9207,
     /*  37997 */     GIR_EraseRootFromParent_Done,
     /*  37998 */   // Label 286: @37998
     /*  37998 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(38159), // Rule ID 9220 //
     /*  38003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  38006 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38010 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:16:z
     /*  38014 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38018 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38022 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38026 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38030 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38032 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  38036 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  38040 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  38044 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38046 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:16:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24508>>)<<P:16:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  38046 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  38049 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  38053 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38058 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  38060 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  38063 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  38067 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38072 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  38076 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  38079 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  38082 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  38085 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38090 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  38095 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  38100 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  38103 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  38106 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38110 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38115 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38120 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38124 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38128 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  38131 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  38134 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  38136 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  38139 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  38141 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  38148 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38153 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38158 */     // GIR_Coverage, 9220,
     /*  38158 */     GIR_EraseRootFromParent_Done,
     /*  38159 */   // Label 287: @38159
     /*  38159 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(38320), // Rule ID 9224 //
     /*  38164 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  38167 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38171 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:19:z
     /*  38175 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38179 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38183 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38187 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38191 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38193 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  38197 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  38201 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24507),
     /*  38205 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38207 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:19:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_24508>>)<<P:19:Predicate_anonymous_24507>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  38207 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  38210 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  38214 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38219 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  38221 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  38224 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  38228 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38233 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  38237 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  38240 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  38243 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  38246 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38251 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  38256 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  38261 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  38264 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  38267 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  38271 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38276 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38281 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38285 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38289 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  38292 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  38295 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  38297 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  38300 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  38302 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  38309 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38314 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38319 */     // GIR_Coverage, 9224,
     /*  38319 */     GIR_EraseRootFromParent_Done,
     /*  38320 */   // Label 288: @38320
     /*  38320 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(38385), // Rule ID 9205 //
     /*  38325 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  38328 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38332 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  38336 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38340 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  38344 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38348 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38352 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38354 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  38358 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  38362 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24485),
     /*  38366 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38368 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24486>>)<<P:1:Predicate_anonymous_24485>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  38368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  38371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38373 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38381 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38383 */     GIR_RootConstrainSelectedInstOperands,
     /*  38384 */     // GIR_Coverage, 9205,
     /*  38384 */     GIR_EraseRootFromParent_Done,
     /*  38385 */   // Label 289: @38385
     /*  38385 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(38450), // Rule ID 9212 //
     /*  38390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  38393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38397 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
     /*  38401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  38409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38413 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38417 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38419 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  38423 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  38427 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24504),
     /*  38431 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38433 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24505>>)<<P:8:Predicate_anonymous_24504>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  38433 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  38436 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38438 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38446 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38448 */     GIR_RootConstrainSelectedInstOperands,
     /*  38449 */     // GIR_Coverage, 9212,
     /*  38449 */     GIR_EraseRootFromParent_Done,
     /*  38450 */   // Label 290: @38450
     /*  38450 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(38490), // Rule ID 11877 //
     /*  38455 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38459 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38463 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38467 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38471 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40372),
     /*  38475 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38477 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$val, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40372>>)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  38477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38482 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  38486 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  38488 */     GIR_RootConstrainSelectedInstOperands,
     /*  38489 */     // GIR_Coverage, 11877,
     /*  38489 */     GIR_EraseRootFromParent_Done,
     /*  38490 */   // Label 291: @38490
     /*  38490 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(38534), // Rule ID 8283 //
     /*  38495 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38507 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38511 */     // MIs[1] Operand 1
     /*  38511 */     // No operand predicates
     /*  38511 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16755),
     /*  38515 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38517 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_16755>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38517 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  38520 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  38522 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38524 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38529 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  38532 */     GIR_RootConstrainSelectedInstOperands,
     /*  38533 */     // GIR_Coverage, 8283,
     /*  38533 */     GIR_EraseRootFromParent_Done,
     /*  38534 */   // Label 292: @38534
     /*  38534 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(38581), // Rule ID 8284 //
     /*  38539 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38542 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38546 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38550 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38554 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38558 */     // MIs[1] Operand 1
     /*  38558 */     // No operand predicates
     /*  38558 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  38562 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38564 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23147>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  38567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38569 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38571 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38579 */     GIR_RootConstrainSelectedInstOperands,
     /*  38580 */     // GIR_Coverage, 8284,
     /*  38580 */     GIR_EraseRootFromParent_Done,
     /*  38581 */   // Label 293: @38581
     /*  38581 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(38636), // Rule ID 8285 //
     /*  38586 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
     /*  38589 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38593 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38597 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38601 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38605 */     // MIs[1] Operand 1
     /*  38605 */     // No operand predicates
     /*  38605 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  38609 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38611 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23147>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38611 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  38617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38619 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38624 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38626 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38634 */     GIR_RootConstrainSelectedInstOperands,
     /*  38635 */     // GIR_Coverage, 8285,
     /*  38635 */     GIR_EraseRootFromParent_Done,
     /*  38636 */   // Label 294: @38636
     /*  38636 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(38670), // Rule ID 43 //
     /*  38641 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38645 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38649 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38653 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16755),
     /*  38657 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16755>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  38657 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
     /*  38662 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38668 */     GIR_RootConstrainSelectedInstOperands,
     /*  38669 */     // GIR_Coverage, 43,
     /*  38669 */     GIR_Done,
     /*  38670 */   // Label 295: @38670
     /*  38670 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(38700), // Rule ID 2599 //
     /*  38675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38682 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  38686 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23147>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38686 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
     /*  38689 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38691 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38693 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38695 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38698 */     GIR_RootConstrainSelectedInstOperands,
     /*  38699 */     // GIR_Coverage, 2599,
     /*  38699 */     GIR_EraseRootFromParent_Done,
     /*  38700 */   // Label 296: @38700
     /*  38700 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(38738), // Rule ID 2601 //
     /*  38705 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  38708 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38712 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  38716 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23147>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38716 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
     /*  38722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38724 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38729 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38731 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38733 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38736 */     GIR_RootConstrainSelectedInstOperands,
     /*  38737 */     // GIR_Coverage, 2601,
     /*  38737 */     GIR_EraseRootFromParent_Done,
     /*  38738 */   // Label 297: @38738
     /*  38738 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(38774), // Rule ID 841 //
     /*  38743 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38747 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38751 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38755 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38759 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38761 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38761 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38764 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38770 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38772 */     GIR_RootConstrainSelectedInstOperands,
     /*  38773 */     // GIR_Coverage, 841,
     /*  38773 */     GIR_EraseRootFromParent_Done,
     /*  38774 */   // Label 298: @38774
     /*  38774 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(38810), // Rule ID 9134 //
     /*  38779 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38783 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38787 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38791 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38795 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38797 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38806 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  38808 */     GIR_RootConstrainSelectedInstOperands,
     /*  38809 */     // GIR_Coverage, 9134,
     /*  38809 */     GIR_EraseRootFromParent_Done,
     /*  38810 */   // Label 299: @38810
     /*  38810 */   GIM_Reject,
     /*  38811 */ // Label 207: @38811
     /*  38811 */ GIM_Reject,
     /*  38812 */ // Label 180: @38812
     /*  38812 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(39282),
     /*  38817 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  38820 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  38823 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(38889), // Rule ID 2749 //
     /*  38828 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  38831 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38835 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38839 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38843 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38846 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38851 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38855 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38859 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38861 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38861 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38864 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38867 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38869 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38874 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38878 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38882 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  38884 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38887 */     GIR_RootConstrainSelectedInstOperands,
     /*  38888 */     // GIR_Coverage, 2749,
     /*  38888 */     GIR_EraseRootFromParent_Done,
     /*  38889 */   // Label 301: @38889
     /*  38889 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(38955), // Rule ID 2758 //
     /*  38894 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  38897 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38901 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38905 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38909 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38912 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38917 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38921 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38925 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38927 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38927 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38930 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  38933 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38935 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38940 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38944 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38948 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  38950 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38953 */     GIR_RootConstrainSelectedInstOperands,
     /*  38954 */     // GIR_Coverage, 2758,
     /*  38954 */     GIR_EraseRootFromParent_Done,
     /*  38955 */   // Label 302: @38955
     /*  38955 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(39021), // Rule ID 9222 //
     /*  38960 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  38963 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38967 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38971 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38975 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38978 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38983 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38987 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38991 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38993 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38993 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38996 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38999 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39001 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  39006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  39010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  39014 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39016 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39019 */     GIR_RootConstrainSelectedInstOperands,
     /*  39020 */     // GIR_Coverage, 9222,
     /*  39020 */     GIR_EraseRootFromParent_Done,
     /*  39021 */   // Label 303: @39021
     /*  39021 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(39087), // Rule ID 9226 //
     /*  39026 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  39029 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39033 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39037 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  39041 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  39044 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  39049 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39053 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  39057 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39059 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3291:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  39059 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  39062 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  39065 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39067 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  39072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  39076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  39080 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39082 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39085 */     GIR_RootConstrainSelectedInstOperands,
     /*  39086 */     // GIR_Coverage, 9226,
     /*  39086 */     GIR_EraseRootFromParent_Done,
     /*  39087 */   // Label 304: @39087
     /*  39087 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(39156), // Rule ID 2730 //
     /*  39092 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  39095 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39099 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39103 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39107 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39111 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39115 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39117 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  39121 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  39125 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  39129 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
     /*  39133 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24511),
     /*  39137 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39139 */     // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24512>>, i64:{ *:[i64] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_24511>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  39139 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  39142 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39144 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  39148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  39152 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  39154 */     GIR_RootConstrainSelectedInstOperands,
     /*  39155 */     // GIR_Coverage, 2730,
     /*  39155 */     GIR_EraseRootFromParent_Done,
     /*  39156 */   // Label 305: @39156
     /*  39156 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(39225), // Rule ID 9214 //
     /*  39161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  39164 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39168 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
     /*  39172 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39176 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39180 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39184 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39188 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39190 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  39194 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  39198 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  39202 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24511),
     /*  39206 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39208 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:10:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24512>>)<<P:10:Predicate_anonymous_24511>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  39208 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  39211 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39213 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  39217 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  39221 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39223 */     GIR_RootConstrainSelectedInstOperands,
     /*  39224 */     // GIR_Coverage, 9214,
     /*  39224 */     GIR_EraseRootFromParent_Done,
     /*  39225 */   // Label 306: @39225
     /*  39225 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(39255), // Rule ID 1435 //
     /*  39230 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39234 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23147),
     /*  39238 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23147>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39238 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
     /*  39243 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  39249 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39253 */     GIR_RootConstrainSelectedInstOperands,
     /*  39254 */     // GIR_Coverage, 1435,
     /*  39254 */     GIR_Done,
     /*  39255 */   // Label 307: @39255
     /*  39255 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(39281), // Rule ID 1437 //
     /*  39260 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39264 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16755),
     /*  39268 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16755>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39268 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
     /*  39273 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39279 */     GIR_RootConstrainSelectedInstOperands,
     /*  39280 */     // GIR_Coverage, 1437,
     /*  39280 */     GIR_Done,
     /*  39281 */   // Label 308: @39281
     /*  39281 */   GIM_Reject,
     /*  39282 */ // Label 300: @39282
     /*  39282 */ GIM_Reject,
     /*  39283 */ // Label 181: @39283
     /*  39283 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(39552),
     /*  39288 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39291 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39294 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39298 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(39394), // Rule ID 9188 //
     /*  39303 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39307 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  39311 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39315 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39319 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39321 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39328 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39335 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39342 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  39342 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  39345 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39347 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
     /*  39352 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
     /*  39357 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
     /*  39362 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
     /*  39367 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
     /*  39372 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
     /*  39377 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39380 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39383 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39386 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39389 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39392 */     GIR_RootConstrainSelectedInstOperands,
     /*  39393 */     // GIR_Coverage, 9188,
     /*  39393 */     GIR_EraseRootFromParent_Done,
     /*  39394 */   // Label 310: @39394
     /*  39394 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(39490), // Rule ID 1166 //
     /*  39399 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39403 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  39407 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39411 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39415 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39417 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39424 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39431 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39438 */     // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  39438 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  39441 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39443 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39448 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39453 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39458 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39463 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
     /*  39468 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
     /*  39473 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39476 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39479 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39482 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39485 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39488 */     GIR_RootConstrainSelectedInstOperands,
     /*  39489 */     // GIR_Coverage, 1166,
     /*  39489 */     GIR_EraseRootFromParent_Done,
     /*  39490 */   // Label 311: @39490
     /*  39490 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(39551), // Rule ID 1177 //
     /*  39495 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39502 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39509 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  39509 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
     /*  39512 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39514 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39519 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39524 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39529 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39534 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39537 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39540 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39543 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39549 */     GIR_RootConstrainSelectedInstOperands,
     /*  39550 */     // GIR_Coverage, 1177,
     /*  39550 */     GIR_EraseRootFromParent_Done,
     /*  39551 */   // Label 312: @39551
     /*  39551 */   GIM_Reject,
     /*  39552 */ // Label 309: @39552
     /*  39552 */ GIM_Reject,
     /*  39553 */ // Label 182: @39553
     /*  39553 */ GIM_Reject,
     /*  39554 */ // Label 1: @39554
     /*  39554 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 318*/ GIMT_Encode4(40176),
     /*  39565 */ /*GILLT_s1*//*Label 313*/ GIMT_Encode4(39585),
     /*  39569 */ /*GILLT_s16*//*Label 314*/ GIMT_Encode4(39704),
     /*  39573 */ /*GILLT_s32*//*Label 315*/ GIMT_Encode4(39920),
     /*  39577 */ /*GILLT_s64*//*Label 316*/ GIMT_Encode4(40035),
     /*  39581 */ /*GILLT_v2s16*//*Label 317*/ GIMT_Encode4(40104),
     /*  39585 */ // Label 313: @39585
     /*  39585 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(39703),
     /*  39590 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  39593 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  39596 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(39624), // Rule ID 8133 //
     /*  39601 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  39604 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39608 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  39612 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  39612 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  39615 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39617 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39619 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39622 */     GIR_RootConstrainSelectedInstOperands,
     /*  39623 */     // GIR_Coverage, 8133,
     /*  39623 */     GIR_EraseRootFromParent_Done,
     /*  39624 */   // Label 320: @39624
     /*  39624 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(39652), // Rule ID 8140 //
     /*  39629 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39632 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39636 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  39640 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  39640 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  39643 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39645 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39647 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39650 */     GIR_RootConstrainSelectedInstOperands,
     /*  39651 */     // GIR_Coverage, 8140,
     /*  39651 */     GIR_EraseRootFromParent_Done,
     /*  39652 */   // Label 321: @39652
     /*  39652 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(39677), // Rule ID 8131 //
     /*  39657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  39660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39664 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39664 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  39669 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39675 */     GIR_RootConstrainSelectedInstOperands,
     /*  39676 */     // GIR_Coverage, 8131,
     /*  39676 */     GIR_Done,
     /*  39677 */   // Label 322: @39677
     /*  39677 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(39702), // Rule ID 8138 //
     /*  39682 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39685 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39689 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39689 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  39694 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39700 */     GIR_RootConstrainSelectedInstOperands,
     /*  39701 */     // GIR_Coverage, 8138,
     /*  39701 */     GIR_Done,
     /*  39702 */   // Label 323: @39702
     /*  39702 */   GIM_Reject,
     /*  39703 */ // Label 319: @39703
     /*  39703 */ GIM_Reject,
     /*  39704 */ // Label 314: @39704
     /*  39704 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(39919),
     /*  39709 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  39712 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  39715 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(39774), // Rule ID 1108 //
     /*  39720 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  39723 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39727 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39734 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39741 */     // (sub:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  39744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39746 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39751 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39756 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39761 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39766 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39769 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39772 */     GIR_RootConstrainSelectedInstOperands,
     /*  39773 */     // GIR_Coverage, 1108,
     /*  39773 */     GIR_EraseRootFromParent_Done,
     /*  39774 */   // Label 325: @39774
     /*  39774 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(39833), // Rule ID 1109 //
     /*  39779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  39782 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  39786 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39793 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39800 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39800 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  39803 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39805 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39810 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39815 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39820 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39825 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39831 */     GIR_RootConstrainSelectedInstOperands,
     /*  39832 */     // GIR_Coverage, 1109,
     /*  39832 */     GIR_EraseRootFromParent_Done,
     /*  39833 */   // Label 326: @39833
     /*  39833 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(39892), // Rule ID 1110 //
     /*  39838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  39841 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39845 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39852 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39859 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39859 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  39862 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39864 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39869 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39874 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39879 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39884 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39887 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39890 */     GIR_RootConstrainSelectedInstOperands,
     /*  39891 */     // GIR_Coverage, 1110,
     /*  39891 */     GIR_EraseRootFromParent_Done,
     /*  39892 */   // Label 327: @39892
     /*  39892 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(39918), // Rule ID 945 //
     /*  39897 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  39900 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39904 */     // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39904 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  39907 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39909 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39911 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39913 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39916 */     GIR_RootConstrainSelectedInstOperands,
     /*  39917 */     // GIR_Coverage, 945,
     /*  39917 */     GIR_EraseRootFromParent_Done,
     /*  39918 */   // Label 328: @39918
     /*  39918 */   GIM_Reject,
     /*  39919 */ // Label 324: @39919
     /*  39919 */ GIM_Reject,
     /*  39920 */ // Label 315: @39920
     /*  39920 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(40034),
     /*  39925 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  39928 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  39931 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(39965), // Rule ID 44 //
     /*  39936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39940 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39944 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39948 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16756),
     /*  39952 */     // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16756>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  39952 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  39957 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39963 */     GIR_RootConstrainSelectedInstOperands,
     /*  39964 */     // GIR_Coverage, 44,
     /*  39964 */     GIR_Done,
     /*  39965 */   // Label 330: @39965
     /*  39965 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(39995), // Rule ID 2600 //
     /*  39970 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  39973 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39977 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23149),
     /*  39981 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23149>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  39981 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  39984 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39986 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39988 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39990 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39993 */     GIR_RootConstrainSelectedInstOperands,
     /*  39994 */     // GIR_Coverage, 2600,
     /*  39994 */     GIR_EraseRootFromParent_Done,
     /*  39995 */   // Label 331: @39995
     /*  39995 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(40033), // Rule ID 2602 //
     /*  40000 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  40003 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40007 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23149),
     /*  40011 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23149>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  40011 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  40014 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  40017 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40019 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  40024 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40026 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  40028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40031 */     GIR_RootConstrainSelectedInstOperands,
     /*  40032 */     // GIR_Coverage, 2602,
     /*  40032 */     GIR_EraseRootFromParent_Done,
     /*  40033 */   // Label 332: @40033
     /*  40033 */   GIM_Reject,
     /*  40034 */ // Label 329: @40034
     /*  40034 */ GIM_Reject,
     /*  40035 */ // Label 316: @40035
     /*  40035 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(40103),
     /*  40040 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  40043 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  40046 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(40076), // Rule ID 1436 //
     /*  40051 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  40055 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23149),
     /*  40059 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23149>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40059 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
     /*  40064 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  40070 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40074 */     GIR_RootConstrainSelectedInstOperands,
     /*  40075 */     // GIR_Coverage, 1436,
     /*  40075 */     GIR_Done,
     /*  40076 */   // Label 334: @40076
     /*  40076 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(40102), // Rule ID 1438 //
     /*  40081 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40085 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16756),
     /*  40089 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16756>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40089 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
     /*  40094 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40100 */     GIR_RootConstrainSelectedInstOperands,
     /*  40101 */     // GIR_Coverage, 1438,
     /*  40101 */     GIR_Done,
     /*  40102 */   // Label 335: @40102
     /*  40102 */   GIM_Reject,
     /*  40103 */ // Label 333: @40103
     /*  40103 */ GIM_Reject,
     /*  40104 */ // Label 317: @40104
     /*  40104 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(40175), // Rule ID 1185 //
     /*  40109 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40112 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40115 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40119 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40126 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40133 */   // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  40133 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
     /*  40136 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40138 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40143 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40148 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40153 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40158 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40161 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40164 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40167 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40170 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40173 */   GIR_RootConstrainSelectedInstOperands,
     /*  40174 */   // GIR_Coverage, 1185,
     /*  40174 */   GIR_EraseRootFromParent_Done,
     /*  40175 */ // Label 336: @40175
     /*  40175 */ GIM_Reject,
     /*  40176 */ // Label 318: @40176
     /*  40176 */ GIM_Reject,
     /*  40177 */ // Label 2: @40177
     /*  40177 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 341*/ GIMT_Encode4(40614),
     /*  40188 */ /*GILLT_s16*//*Label 337*/ GIMT_Encode4(40204),
     /*  40192 */ /*GILLT_s32*//*Label 338*/ GIMT_Encode4(40378),
     /*  40196 */ /*GILLT_s64*//*Label 339*/ GIMT_Encode4(40479),
     /*  40200 */ /*GILLT_v2s16*//*Label 340*/ GIMT_Encode4(40542),
     /*  40204 */ // Label 337: @40204
     /*  40204 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(40377),
     /*  40209 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  40212 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  40215 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(40274), // Rule ID 907 //
     /*  40220 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only),
     /*  40223 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40227 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  40234 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  40241 */     // (mul:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_opsel_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40241 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_opsel_e64),
     /*  40244 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40246 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40251 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40256 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40261 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40266 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40269 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40272 */     GIR_RootConstrainSelectedInstOperands,
     /*  40273 */     // GIR_Coverage, 907,
     /*  40273 */     GIR_EraseRootFromParent_Done,
     /*  40274 */   // Label 343: @40274
     /*  40274 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(40330), // Rule ID 908 //
     /*  40279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  40282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  40286 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40293 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40300 */     // (mul:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40300 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
     /*  40303 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40305 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40310 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40315 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40320 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40325 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40328 */     GIR_RootConstrainSelectedInstOperands,
     /*  40329 */     // GIR_Coverage, 908,
     /*  40329 */     GIR_EraseRootFromParent_Done,
     /*  40330 */   // Label 344: @40330
     /*  40330 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(40353), // Rule ID 906 //
     /*  40335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
     /*  40338 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40342 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40342 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
     /*  40347 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40351 */     GIR_RootConstrainSelectedInstOperands,
     /*  40352 */     // GIR_Coverage, 906,
     /*  40352 */     GIR_Done,
     /*  40353 */   // Label 345: @40353
     /*  40353 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(40376), // Rule ID 909 //
     /*  40358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  40361 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40365 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40365 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_fake16_e64),
     /*  40370 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40374 */     GIR_RootConstrainSelectedInstOperands,
     /*  40375 */     // GIR_Coverage, 909,
     /*  40375 */     GIR_Done,
     /*  40376 */   // Label 346: @40376
     /*  40376 */   GIM_Reject,
     /*  40377 */ // Label 342: @40377
     /*  40377 */ GIM_Reject,
     /*  40378 */ // Label 338: @40378
     /*  40378 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(40478),
     /*  40383 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  40386 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  40389 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(40409), // Rule ID 81 //
     /*  40394 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40398 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16763),
     /*  40402 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16763>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40402 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
     /*  40407 */     GIR_RootConstrainSelectedInstOperands,
     /*  40408 */     // GIR_Coverage, 81,
     /*  40408 */     GIR_Done,
     /*  40409 */   // Label 348: @40409
     /*  40409 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(40443), // Rule ID 973 //
     /*  40414 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40418 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23079),
     /*  40422 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  40429 */     // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23079>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  40432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40434 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40439 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  40441 */     GIR_RootConstrainSelectedInstOperands,
     /*  40442 */     // GIR_Coverage, 973,
     /*  40442 */     GIR_EraseRootFromParent_Done,
     /*  40443 */   // Label 349: @40443
     /*  40443 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(40477), // Rule ID 9174 //
     /*  40448 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40452 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23079),
     /*  40456 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  40463 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_23079>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40463 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  40466 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40468 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40473 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  40475 */     GIR_RootConstrainSelectedInstOperands,
     /*  40476 */     // GIR_Coverage, 9174,
     /*  40476 */     GIR_EraseRootFromParent_Done,
     /*  40477 */   // Label 350: @40477
     /*  40477 */   GIM_Reject,
     /*  40478 */ // Label 347: @40478
     /*  40478 */ GIM_Reject,
     /*  40479 */ // Label 339: @40479
     /*  40479 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(40541),
     /*  40484 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  40487 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  40490 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(40513), // Rule ID 51 //
     /*  40495 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
     /*  40498 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40502 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16763),
     /*  40506 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16763>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40506 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
     /*  40511 */     GIR_RootConstrainSelectedInstOperands,
     /*  40512 */     // GIR_Coverage, 51,
     /*  40512 */     GIR_Done,
     /*  40513 */   // Label 352: @40513
     /*  40513 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(40540), // Rule ID 840 //
     /*  40518 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX1250Plus),
     /*  40521 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  40525 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23079),
     /*  40529 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23079>>  =>  (V_MUL_U64_e64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40529 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_U64_e64),
     /*  40534 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40538 */     GIR_RootConstrainSelectedInstOperands,
     /*  40539 */     // GIR_Coverage, 840,
     /*  40539 */     GIR_Done,
     /*  40540 */   // Label 353: @40540
     /*  40540 */   GIM_Reject,
     /*  40541 */ // Label 351: @40541
     /*  40541 */ GIM_Reject,
     /*  40542 */ // Label 340: @40542
     /*  40542 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(40613), // Rule ID 1178 //
     /*  40547 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40550 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40553 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40557 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40564 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40571 */   // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  40571 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
     /*  40574 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40576 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40581 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40586 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40591 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40596 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40599 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40602 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40605 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40608 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40611 */   GIR_RootConstrainSelectedInstOperands,
     /*  40612 */   // GIR_Coverage, 1178,
     /*  40612 */   GIR_EraseRootFromParent_Done,
     /*  40613 */ // Label 354: @40613
     /*  40613 */ GIM_Reject,
     /*  40614 */ // Label 341: @40614
     /*  40614 */ GIM_Reject,
     /*  40615 */ // Label 3: @40615
     /*  40615 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 362*/ GIMT_Encode4(42588),
     /*  40626 */ /*GILLT_s1*//*Label 355*/ GIMT_Encode4(40666),
     /*  40630 */ /*GILLT_s16*//*Label 356*/ GIMT_Encode4(40729),
     /*  40634 */ /*GILLT_s32*//*Label 357*/ GIMT_Encode4(40946),
     /*  40638 */ /*GILLT_s64*//*Label 358*/ GIMT_Encode4(41576),
     /*  40642 */ /*GILLT_v2s16*//*Label 359*/ GIMT_Encode4(42173),
     /*  40646 */ /*GILLT_v2s32*//*Label 360*/ GIMT_Encode4(42324), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  40662 */ /*GILLT_v4s16*//*Label 361*/ GIMT_Encode4(42465),
     /*  40666 */ // Label 355: @40666
     /*  40666 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(40728),
     /*  40671 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  40674 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  40677 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(40702), // Rule ID 8127 //
     /*  40682 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  40685 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40689 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40689 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  40694 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40700 */     GIR_RootConstrainSelectedInstOperands,
     /*  40701 */     // GIR_Coverage, 8127,
     /*  40701 */     GIR_Done,
     /*  40702 */   // Label 364: @40702
     /*  40702 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(40727), // Rule ID 8134 //
     /*  40707 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  40710 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40714 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40714 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  40719 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40725 */     GIR_RootConstrainSelectedInstOperands,
     /*  40726 */     // GIR_Coverage, 8134,
     /*  40726 */     GIR_Done,
     /*  40727 */   // Label 365: @40727
     /*  40727 */   GIM_Reject,
     /*  40728 */ // Label 363: @40728
     /*  40728 */ GIM_Reject,
     /*  40729 */ // Label 356: @40729
     /*  40729 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(40945),
     /*  40734 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  40737 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  40740 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(40791), // Rule ID 9190 //
     /*  40745 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40749 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40753 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40757 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40761 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40765 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40769 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  40773 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40775 */     // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40775 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40778 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40780 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40782 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40786 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40789 */     GIR_RootConstrainSelectedInstOperands,
     /*  40790 */     // GIR_Coverage, 9190,
     /*  40790 */     GIR_EraseRootFromParent_Done,
     /*  40791 */   // Label 367: @40791
     /*  40791 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(40842), // Rule ID 1984 //
     /*  40796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40812 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40816 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40820 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  40824 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40826 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40826 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40829 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40831 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40833 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40837 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40840 */     GIR_RootConstrainSelectedInstOperands,
     /*  40841 */     // GIR_Coverage, 1984,
     /*  40841 */     GIR_EraseRootFromParent_Done,
     /*  40842 */   // Label 368: @40842
     /*  40842 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(40865), // Rule ID 2632 //
     /*  40847 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotUseRealTrue16Insts),
     /*  40850 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40854 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  40854 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40859 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40863 */     GIR_RootConstrainSelectedInstOperands,
     /*  40864 */     // GIR_Coverage, 2632,
     /*  40864 */     GIR_Done,
     /*  40865 */   // Label 369: @40865
     /*  40865 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(40921), // Rule ID 938 //
     /*  40870 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40873 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  40877 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40884 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40891 */     // (and:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_AND_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40891 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
     /*  40894 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40896 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40901 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40906 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40911 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40916 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40919 */     GIR_RootConstrainSelectedInstOperands,
     /*  40920 */     // GIR_Coverage, 938,
     /*  40920 */     GIR_EraseRootFromParent_Done,
     /*  40921 */   // Label 370: @40921
     /*  40921 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(40944), // Rule ID 939 //
     /*  40926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40929 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40933 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40933 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_fake16_e64),
     /*  40938 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40942 */     GIR_RootConstrainSelectedInstOperands,
     /*  40943 */     // GIR_Coverage, 939,
     /*  40943 */     GIR_Done,
     /*  40944 */   // Label 371: @40944
     /*  40944 */   GIM_Reject,
     /*  40945 */ // Label 366: @40945
     /*  40945 */ GIM_Reject,
     /*  40946 */ // Label 357: @40946
     /*  40946 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(41575),
     /*  40951 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  40954 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  40957 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(41032), // Rule ID 11931 //
     /*  40962 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40966 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40970 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  40974 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40978 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40982 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40984 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40988 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40992 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40996 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41000 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41002 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  41006 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41010 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41014 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41016 */     // (and:{ *:[i32] } (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_23157>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41016 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41019 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41021 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  41023 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41026 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41030 */     GIR_RootConstrainSelectedInstOperands,
     /*  41031 */     // GIR_Coverage, 11931,
     /*  41031 */     GIR_EraseRootFromParent_Done,
     /*  41032 */   // Label 373: @41032
     /*  41032 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(41107), // Rule ID 11932 //
     /*  41037 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41049 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41053 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41057 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41059 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41063 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41067 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41071 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41075 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41077 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  41081 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41085 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41089 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41091 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_23157>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41091 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41094 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41096 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  41098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41101 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41105 */     GIR_RootConstrainSelectedInstOperands,
     /*  41106 */     // GIR_Coverage, 11932,
     /*  41106 */     GIR_EraseRootFromParent_Done,
     /*  41107 */   // Label 374: @41107
     /*  41107 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(41182), // Rule ID 8292 //
     /*  41112 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41116 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41120 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  41124 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41128 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41132 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41134 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41138 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41142 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41146 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41150 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41152 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  41156 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41160 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41164 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41166 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>)<<P:Predicate_anonymous_23157>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41166 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41169 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41171 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  41173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41180 */     GIR_RootConstrainSelectedInstOperands,
     /*  41181 */     // GIR_Coverage, 8292,
     /*  41181 */     GIR_EraseRootFromParent_Done,
     /*  41182 */   // Label 375: @41182
     /*  41182 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(41257), // Rule ID 8293 //
     /*  41187 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41191 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41195 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41199 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41203 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41207 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41209 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41213 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41217 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41221 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41225 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41227 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  41231 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41235 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41239 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41241 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>)<<P:Predicate_anonymous_23157>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41241 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41244 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41246 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  41248 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41251 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41255 */     GIR_RootConstrainSelectedInstOperands,
     /*  41256 */     // GIR_Coverage, 8293,
     /*  41256 */     GIR_EraseRootFromParent_Done,
     /*  41257 */   // Label 376: @41257
     /*  41257 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(41310), // Rule ID 11898 //
     /*  41262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41266 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41270 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41274 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41278 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41282 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41284 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41288 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41292 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41294 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })<<P:Predicate_not_oneuse>>, i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23157>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$z)
     /*  41294 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41297 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41299 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  41303 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41306 */     GIR_RootToRootCopy, /*OpIdx*/2, // z
     /*  41308 */     GIR_RootConstrainSelectedInstOperands,
     /*  41309 */     // GIR_Coverage, 11898,
     /*  41309 */     GIR_EraseRootFromParent_Done,
     /*  41310 */   // Label 377: @41310
     /*  41310 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(41363), // Rule ID 8029 //
     /*  41315 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41319 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41323 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41327 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41331 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41335 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41337 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41341 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41345 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41347 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })<<P:Predicate_not_oneuse>>)<<P:Predicate_anonymous_23157>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$z)
     /*  41347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  41356 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41359 */     GIR_RootToRootCopy, /*OpIdx*/1, // z
     /*  41361 */     GIR_RootConstrainSelectedInstOperands,
     /*  41362 */     // GIR_Coverage, 8029,
     /*  41362 */     GIR_EraseRootFromParent_Done,
     /*  41363 */   // Label 378: @41363
     /*  41363 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(41414), // Rule ID 9115 //
     /*  41368 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41372 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41376 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41380 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41384 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41388 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41392 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  41396 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41398 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41398 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  41401 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41403 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  41405 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41409 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41412 */     GIR_RootConstrainSelectedInstOperands,
     /*  41413 */     // GIR_Coverage, 9115,
     /*  41413 */     GIR_EraseRootFromParent_Done,
     /*  41414 */   // Label 379: @41414
     /*  41414 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(41465), // Rule ID 64 //
     /*  41419 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41423 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41427 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41431 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41435 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41439 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41443 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  41447 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41449 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41449 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  41452 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41454 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  41456 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41460 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41463 */     GIR_RootConstrainSelectedInstOperands,
     /*  41464 */     // GIR_Coverage, 64,
     /*  41464 */     GIR_EraseRootFromParent_Done,
     /*  41465 */   // Label 380: @41465
     /*  41465 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(41528), // Rule ID 8291 //
     /*  41470 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41474 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41478 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  41482 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41486 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41490 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  41494 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  41498 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask),
     /*  41502 */     // MIs[2] Operand 1
     /*  41502 */     // No operand predicates
     /*  41502 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41506 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41508 */     // (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$rshift), (imm:{ *:[i32] })<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask)<<P:Predicate_anonymous_23157>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, ?:{ *:[i32] }:$rshift, (IMMPopCount:{ *:[i32] } ?:{ *:[i32] }:$mask))
     /*  41508 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41511 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41513 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  41517 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rshift
     /*  41521 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderPopcntImm), // mask
     /*  41526 */     GIR_RootConstrainSelectedInstOperands,
     /*  41527 */     // GIR_Coverage, 8291,
     /*  41527 */     GIR_EraseRootFromParent_Done,
     /*  41528 */   // Label 381: @41528
     /*  41528 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(41554), // Rule ID 52 //
     /*  41533 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41537 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  41541 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16764>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41541 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  41546 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  41552 */     GIR_RootConstrainSelectedInstOperands,
     /*  41553 */     // GIR_Coverage, 52,
     /*  41553 */     GIR_Done,
     /*  41554 */   // Label 382: @41554
     /*  41554 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(41574), // Rule ID 837 //
     /*  41559 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41563 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41563 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  41568 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  41572 */     GIR_RootConstrainSelectedInstOperands,
     /*  41573 */     // GIR_Coverage, 837,
     /*  41573 */     GIR_Done,
     /*  41574 */   // Label 383: @41574
     /*  41574 */   GIM_Reject,
     /*  41575 */ // Label 372: @41575
     /*  41575 */ GIM_Reject,
     /*  41576 */ // Label 358: @41576
     /*  41576 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(42172),
     /*  41581 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  41584 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  41587 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(41815), // Rule ID 11899 //
     /*  41592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41596 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  41608 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  41612 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41614 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41618 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41622 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41624 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })<<P:Predicate_not_oneuse>>, i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23157>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
     /*  41624 */     GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /*  41627 */     GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41631 */     GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41636 */     GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
     /*  41642 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41647 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41652 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /*  41655 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41659 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41664 */     GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
     /*  41670 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41675 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41680 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  41683 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41687 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41692 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  41695 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/0,
     /*  41698 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /*  41701 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
     /*  41703 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  41706 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41710 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41715 */     GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
     /*  41721 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41726 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41731 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  41734 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41738 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41743 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
     /*  41749 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41754 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41759 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41762 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41766 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41771 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  41774 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  41777 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  41780 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  41782 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  41785 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  41787 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41790 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
     /*  41793 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  41796 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
     /*  41799 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41804 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41809 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41814 */     // GIR_Coverage, 11899,
     /*  41814 */     GIR_EraseRootFromParent_Done,
     /*  41815 */   // Label 385: @41815
     /*  41815 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(42043), // Rule ID 8030 //
     /*  41820 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41824 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41828 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41832 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  41836 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  41840 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41842 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41846 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23157),
     /*  41850 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41852 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })<<P:Predicate_not_oneuse>>)<<P:Predicate_anonymous_23157>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
     /*  41852 */     GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /*  41855 */     GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41859 */     GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41864 */     GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
     /*  41870 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41875 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41880 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /*  41883 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41887 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41892 */     GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
     /*  41898 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41903 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41908 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  41911 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41915 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41920 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  41923 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/0,
     /*  41926 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /*  41929 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
     /*  41931 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  41934 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41938 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41943 */     GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
     /*  41949 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41954 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41959 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  41962 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41966 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41971 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
     /*  41977 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41982 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41987 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41990 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41994 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41999 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  42002 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  42005 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  42008 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  42010 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  42013 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  42015 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42018 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
     /*  42021 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  42024 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
     /*  42027 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  42032 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42037 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42042 */     // GIR_Coverage, 8030,
     /*  42042 */     GIR_EraseRootFromParent_Done,
     /*  42043 */   // Label 386: @42043
     /*  42043 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(42094), // Rule ID 9116 //
     /*  42048 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42052 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42056 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42060 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  42064 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  42068 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42072 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42076 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42078 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42078 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42081 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42083 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42085 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42089 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42092 */     GIR_RootConstrainSelectedInstOperands,
     /*  42093 */     // GIR_Coverage, 9116,
     /*  42093 */     GIR_EraseRootFromParent_Done,
     /*  42094 */   // Label 387: @42094
     /*  42094 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(42145), // Rule ID 65 //
     /*  42099 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42103 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42107 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42111 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  42115 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  42119 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42123 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42127 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42129 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42129 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42132 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42134 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42140 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42143 */     GIR_RootConstrainSelectedInstOperands,
     /*  42144 */     // GIR_Coverage, 65,
     /*  42144 */     GIR_EraseRootFromParent_Done,
     /*  42145 */   // Label 388: @42145
     /*  42145 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(42171), // Rule ID 53 //
     /*  42150 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42154 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42158 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16764>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42158 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  42163 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42169 */     GIR_RootConstrainSelectedInstOperands,
     /*  42170 */     // GIR_Coverage, 53,
     /*  42170 */     GIR_Done,
     /*  42171 */   // Label 389: @42171
     /*  42171 */   GIM_Reject,
     /*  42172 */ // Label 384: @42172
     /*  42172 */ GIM_Reject,
     /*  42173 */ // Label 359: @42173
     /*  42173 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(42323),
     /*  42178 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42181 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42184 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(42243), // Rule ID 9191 //
     /*  42189 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42193 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42197 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42201 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42205 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42209 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42213 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42219 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42221 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42225 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42227 */     // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  42227 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  42230 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42232 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42234 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42238 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42241 */     GIR_RootConstrainSelectedInstOperands,
     /*  42242 */     // GIR_Coverage, 9191,
     /*  42242 */     GIR_EraseRootFromParent_Done,
     /*  42243 */   // Label 391: @42243
     /*  42243 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(42302), // Rule ID 1985 //
     /*  42248 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42260 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42264 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42268 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42272 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42278 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42280 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42284 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42286 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  42286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  42289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42291 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42293 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42297 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42300 */     GIR_RootConstrainSelectedInstOperands,
     /*  42301 */     // GIR_Coverage, 1985,
     /*  42301 */     GIR_EraseRootFromParent_Done,
     /*  42302 */   // Label 392: @42302
     /*  42302 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(42322), // Rule ID 2635 //
     /*  42307 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42311 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
     /*  42311 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  42316 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42320 */     GIR_RootConstrainSelectedInstOperands,
     /*  42321 */     // GIR_Coverage, 2635,
     /*  42321 */     GIR_Done,
     /*  42322 */   // Label 393: @42322
     /*  42322 */   GIM_Reject,
     /*  42323 */ // Label 390: @42323
     /*  42323 */ GIM_Reject,
     /*  42324 */ // Label 360: @42324
     /*  42324 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(42464),
     /*  42329 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42332 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42335 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42339 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42343 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(42394), // Rule ID 9193 //
     /*  42348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42356 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42360 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42364 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42368 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42374 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42376 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42378 */     // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  42378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42383 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42385 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42389 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42392 */     GIR_RootConstrainSelectedInstOperands,
     /*  42393 */     // GIR_Coverage, 9193,
     /*  42393 */     GIR_EraseRootFromParent_Done,
     /*  42394 */   // Label 395: @42394
     /*  42394 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(42445), // Rule ID 1987 //
     /*  42399 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42403 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42407 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42411 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42415 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42419 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42425 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42427 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42429 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  42429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42434 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42436 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42440 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42443 */     GIR_RootConstrainSelectedInstOperands,
     /*  42444 */     // GIR_Coverage, 1987,
     /*  42444 */     GIR_EraseRootFromParent_Done,
     /*  42445 */   // Label 396: @42445
     /*  42445 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(42463), // Rule ID 1969 //
     /*  42450 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$x, v2i32:{ *:[v2i32] }:$y)<<P:Predicate_anonymous_16764>>  =>  (S_AND_B64:{ *:[v2i32] }:{ *:[i1] } SReg_64:{ *:[v2i32] }:$x, SReg_64:{ *:[v2i32] }:$y)
     /*  42450 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  42455 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42461 */     GIR_RootConstrainSelectedInstOperands,
     /*  42462 */     // GIR_Coverage, 1969,
     /*  42462 */     GIR_Done,
     /*  42463 */   // Label 397: @42463
     /*  42463 */   GIM_Reject,
     /*  42464 */ // Label 394: @42464
     /*  42464 */ GIM_Reject,
     /*  42465 */ // Label 361: @42465
     /*  42465 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(42587),
     /*  42470 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42473 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42476 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16764),
     /*  42480 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42484 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(42535), // Rule ID 9192 //
     /*  42489 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42493 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42497 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42501 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42505 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42509 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42515 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42517 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42519 */     // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  42519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42524 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42530 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42533 */     GIR_RootConstrainSelectedInstOperands,
     /*  42534 */     // GIR_Coverage, 9192,
     /*  42534 */     GIR_EraseRootFromParent_Done,
     /*  42535 */   // Label 399: @42535
     /*  42535 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(42586), // Rule ID 1986 //
     /*  42540 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42544 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42548 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42552 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42556 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42560 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42566 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42568 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42570 */     // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_16764>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  42570 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42573 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42575 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42577 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42581 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42584 */     GIR_RootConstrainSelectedInstOperands,
     /*  42585 */     // GIR_Coverage, 1986,
     /*  42585 */     GIR_EraseRootFromParent_Done,
     /*  42586 */   // Label 400: @42586
     /*  42586 */   GIM_Reject,
     /*  42587 */ // Label 398: @42587
     /*  42587 */ GIM_Reject,
     /*  42588 */ // Label 362: @42588
     /*  42588 */ GIM_Reject,
     /*  42589 */ // Label 4: @42589
     /*  42589 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 408*/ GIMT_Encode4(58657),
     /*  42600 */ /*GILLT_s1*//*Label 401*/ GIMT_Encode4(42640),
     /*  42604 */ /*GILLT_s16*//*Label 402*/ GIMT_Encode4(42703),
     /*  42608 */ /*GILLT_s32*//*Label 403*/ GIMT_Encode4(42920),
     /*  42612 */ /*GILLT_s64*//*Label 404*/ GIMT_Encode4(48597),
     /*  42616 */ /*GILLT_v2s16*//*Label 405*/ GIMT_Encode4(58242),
     /*  42620 */ /*GILLT_v2s32*//*Label 406*/ GIMT_Encode4(58393), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  42636 */ /*GILLT_v4s16*//*Label 407*/ GIMT_Encode4(58534),
     /*  42640 */ // Label 401: @42640
     /*  42640 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(42702),
     /*  42645 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  42648 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  42651 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(42676), // Rule ID 8128 //
     /*  42656 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  42659 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42663 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  42663 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
     /*  42668 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42674 */     GIR_RootConstrainSelectedInstOperands,
     /*  42675 */     // GIR_Coverage, 8128,
     /*  42675 */     GIR_Done,
     /*  42676 */   // Label 410: @42676
     /*  42676 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(42701), // Rule ID 8135 //
     /*  42681 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  42684 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42688 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  42688 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
     /*  42693 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42699 */     GIR_RootConstrainSelectedInstOperands,
     /*  42700 */     // GIR_Coverage, 8135,
     /*  42700 */     GIR_Done,
     /*  42701 */   // Label 411: @42701
     /*  42701 */   GIM_Reject,
     /*  42702 */ // Label 409: @42702
     /*  42702 */ GIM_Reject,
     /*  42703 */ // Label 402: @42703
     /*  42703 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(42919),
     /*  42708 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  42711 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  42714 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(42765), // Rule ID 9194 //
     /*  42719 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42723 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42727 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42731 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  42735 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  42739 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42743 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16765),
     /*  42747 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42749 */     // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_16765>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  42749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  42752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42754 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42756 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42760 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42763 */     GIR_RootConstrainSelectedInstOperands,
     /*  42764 */     // GIR_Coverage, 9194,
     /*  42764 */     GIR_EraseRootFromParent_Done,
     /*  42765 */   // Label 413: @42765
     /*  42765 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(42816), // Rule ID 1988 //
     /*  42770 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42774 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42778 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42782 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  42786 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  42790 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42794 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16765),
     /*  42798 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42800 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_16765>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  42800 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  42803 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42805 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42807 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42811 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42814 */     GIR_RootConstrainSelectedInstOperands,
     /*  42815 */     // GIR_Coverage, 1988,
     /*  42815 */     GIR_EraseRootFromParent_Done,
     /*  42816 */   // Label 414: @42816
     /*  42816 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(42839), // Rule ID 2633 //
     /*  42821 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotUseRealTrue16Insts),
     /*  42824 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42828 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  42828 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  42833 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42837 */     GIR_RootConstrainSelectedInstOperands,
     /*  42838 */     // GIR_Coverage, 2633,
     /*  42838 */     GIR_Done,
     /*  42839 */   // Label 415: @42839
     /*  42839 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(42895), // Rule ID 940 //
     /*  42844 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  42847 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  42851 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  42858 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  42865 */     // (or:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_OR_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  42865 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
     /*  42868 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42870 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  42875 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  42880 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  42885 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  42890 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42893 */     GIR_RootConstrainSelectedInstOperands,
     /*  42894 */     // GIR_Coverage, 940,
     /*  42894 */     GIR_EraseRootFromParent_Done,
     /*  42895 */   // Label 416: @42895
     /*  42895 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(42918), // Rule ID 941 //
     /*  42900 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  42903 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42907 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  42907 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_fake16_e64),
     /*  42912 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42916 */     GIR_RootConstrainSelectedInstOperands,
     /*  42917 */     // GIR_Coverage, 941,
     /*  42917 */     GIR_Done,
     /*  42918 */   // Label 417: @42918
     /*  42918 */   GIM_Reject,
     /*  42919 */ // Label 412: @42919
     /*  42919 */ GIM_Reject,
     /*  42920 */ // Label 403: @42920
     /*  42920 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(48596),
     /*  42925 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  42928 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  42931 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(43112), // Rule ID 9229 //
     /*  42936 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  42939 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42943 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42947 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42951 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42955 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42959 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  42963 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  42967 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42971 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42975 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  42979 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  42983 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  42987 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  42991 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42995 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  42999 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  43003 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  43014 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43018 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43022 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43026 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43030 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43034 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43038 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43042 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  43046 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  43050 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  43054 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43058 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  43062 */     // MIs[6] src2
     /*  43062 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43067 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  43071 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  43075 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  43079 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  43081 */     // (or:{ *:[i32] } (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43081 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  43084 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43086 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43089 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  43093 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43096 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  43100 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43103 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43107 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43110 */     GIR_RootConstrainSelectedInstOperands,
     /*  43111 */     // GIR_Coverage, 9229,
     /*  43111 */     GIR_EraseRootFromParent_Done,
     /*  43112 */   // Label 419: @43112
     /*  43112 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(43293), // Rule ID 2855 //
     /*  43117 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43124 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43128 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43132 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43136 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43140 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43144 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43148 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43152 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43156 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  43160 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  43164 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43168 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43172 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43176 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  43180 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  43184 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  43188 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43192 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43196 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43200 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43204 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43208 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43212 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43216 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  43220 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  43224 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  43228 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43232 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  43236 */     // MIs[6] src2
     /*  43236 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43241 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  43245 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  43249 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  43260 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  43262 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43262 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  43265 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43267 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43270 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src0
     /*  43274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43277 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  43281 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43288 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43291 */     GIR_RootConstrainSelectedInstOperands,
     /*  43292 */     // GIR_Coverage, 2855,
     /*  43292 */     GIR_EraseRootFromParent_Done,
     /*  43293 */   // Label 420: @43293
     /*  43293 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(43461), // Rule ID 9230 //
     /*  43298 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43301 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43305 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43309 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43313 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43317 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43321 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  43325 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43329 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43333 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43337 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43341 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
     /*  43345 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/3, GIMT_Encode8(255),
     /*  43356 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43360 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43364 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43368 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43372 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  43376 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43380 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43384 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43388 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  43392 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43396 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43400 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43404 */     // MIs[5] src2
     /*  43404 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43409 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  43413 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  43424 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*  43428 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  43430 */     // (or:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43430 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  43433 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43435 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43438 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  43442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43445 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src1
     /*  43449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*  43456 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43459 */     GIR_RootConstrainSelectedInstOperands,
     /*  43460 */     // GIR_Coverage, 9230,
     /*  43460 */     GIR_EraseRootFromParent_Done,
     /*  43461 */   // Label 421: @43461
     /*  43461 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(43629), // Rule ID 2856 //
     /*  43466 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43469 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43473 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43477 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43481 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43485 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43489 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43493 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43497 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43501 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43505 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  43509 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  43513 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43517 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43521 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43525 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
     /*  43529 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/3, GIMT_Encode8(255),
     /*  43540 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  43544 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43548 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43552 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43556 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43560 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  43564 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43568 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43572 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43576 */     // MIs[5] src2
     /*  43576 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43581 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  43585 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  43596 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  43598 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }), (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43598 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  43601 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43603 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43606 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  43610 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43613 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  43617 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43620 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43624 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43627 */     GIR_RootConstrainSelectedInstOperands,
     /*  43628 */     // GIR_Coverage, 2856,
     /*  43628 */     GIR_EraseRootFromParent_Done,
     /*  43629 */   // Label 422: @43629
     /*  43629 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(43776), // Rule ID 11889 //
     /*  43634 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43638 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43642 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43646 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43650 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43654 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43658 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43662 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43666 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43670 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  43674 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43678 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43682 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43686 */     // MIs[3] x
     /*  43686 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43691 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  43695 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43697 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43697 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43700 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43704 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43709 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  43713 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43718 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43721 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43725 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43730 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  43734 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43739 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43742 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43746 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43751 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43755 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43760 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43763 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43765 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43768 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43771 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43774 */     GIR_RootConstrainSelectedInstOperands,
     /*  43775 */     // GIR_Coverage, 11889,
     /*  43775 */     GIR_EraseRootFromParent_Done,
     /*  43776 */   // Label 423: @43776
     /*  43776 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(43923), // Rule ID 11888 //
     /*  43781 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43785 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43789 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43793 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43797 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43801 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43805 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43809 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43813 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43817 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  43821 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43825 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43829 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43833 */     // MIs[3] x
     /*  43833 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43838 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  43842 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43844 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43844 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43847 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43851 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43856 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  43860 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43865 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43868 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43872 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43877 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  43881 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43886 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43889 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43893 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43898 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43902 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43907 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43910 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43912 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43915 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43918 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43921 */     GIR_RootConstrainSelectedInstOperands,
     /*  43922 */     // GIR_Coverage, 11888,
     /*  43922 */     GIR_EraseRootFromParent_Done,
     /*  43923 */   // Label 424: @43923
     /*  43923 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(44070), // Rule ID 11887 //
     /*  43928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43932 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43936 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43940 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43944 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43948 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43952 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43956 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43960 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43964 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  43968 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43972 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43976 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43980 */     // MIs[3] x
     /*  43980 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43985 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  43989 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43991 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43991 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43994 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43998 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44003 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44007 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44012 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44015 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44019 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44024 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  44028 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44033 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44036 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44040 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44045 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44049 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44054 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44057 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44059 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44062 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44065 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44068 */     GIR_RootConstrainSelectedInstOperands,
     /*  44069 */     // GIR_Coverage, 11887,
     /*  44069 */     GIR_EraseRootFromParent_Done,
     /*  44070 */   // Label 425: @44070
     /*  44070 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(44217), // Rule ID 11886 //
     /*  44075 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44079 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44083 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44087 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44091 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44095 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44099 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44103 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44107 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44111 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  44115 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44119 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44123 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  44127 */     // MIs[3] x
     /*  44127 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44132 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  44136 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44138 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44138 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44141 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44145 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44150 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44154 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44159 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44162 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44166 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44171 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  44175 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44180 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44183 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44187 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44192 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44196 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44201 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44204 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44206 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44209 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44212 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44215 */     GIR_RootConstrainSelectedInstOperands,
     /*  44216 */     // GIR_Coverage, 11886,
     /*  44216 */     GIR_EraseRootFromParent_Done,
     /*  44217 */   // Label 426: @44217
     /*  44217 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(44364), // Rule ID 11883 //
     /*  44222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44226 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44234 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44238 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44242 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44246 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44250 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44254 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44258 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44262 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44266 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44270 */     // MIs[3] x
     /*  44270 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44275 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44279 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  44283 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44285 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44285 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44288 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44292 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44297 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44301 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44306 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44309 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44313 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44318 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44322 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44327 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44330 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44334 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44339 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44343 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44348 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44351 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44353 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44356 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44359 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44362 */     GIR_RootConstrainSelectedInstOperands,
     /*  44363 */     // GIR_Coverage, 11883,
     /*  44363 */     GIR_EraseRootFromParent_Done,
     /*  44364 */   // Label 427: @44364
     /*  44364 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(44511), // Rule ID 11885 //
     /*  44369 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44373 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44377 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44381 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44385 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44389 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44393 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44397 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44401 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44405 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44409 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44413 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44417 */     // MIs[3] x
     /*  44417 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44422 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44426 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  44430 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44432 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44432 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44435 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44439 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44444 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44448 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44453 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44456 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44460 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44465 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44469 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44474 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44477 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44481 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44486 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44490 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44495 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44498 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44500 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44503 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44506 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44509 */     GIR_RootConstrainSelectedInstOperands,
     /*  44510 */     // GIR_Coverage, 11885,
     /*  44510 */     GIR_EraseRootFromParent_Done,
     /*  44511 */   // Label 428: @44511
     /*  44511 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(44658), // Rule ID 8026 //
     /*  44516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44520 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44524 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44528 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44532 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44536 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44540 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44544 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44548 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44552 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44556 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44560 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44564 */     // MIs[3] x
     /*  44564 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44569 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44573 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  44577 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44579 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44579 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44582 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44586 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44591 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44595 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44600 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44603 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44607 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44612 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44616 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44621 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44624 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44628 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44633 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44637 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44642 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44645 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44647 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44650 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44653 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44656 */     GIR_RootConstrainSelectedInstOperands,
     /*  44657 */     // GIR_Coverage, 8026,
     /*  44657 */     GIR_EraseRootFromParent_Done,
     /*  44658 */   // Label 429: @44658
     /*  44658 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(44805), // Rule ID 11884 //
     /*  44663 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44667 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44671 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44675 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44679 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44683 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44687 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44691 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44695 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44699 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44703 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44707 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44711 */     // MIs[3] x
     /*  44711 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44716 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44720 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  44724 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44726 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44726 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44729 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44733 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44738 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44742 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44747 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44750 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44754 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44759 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44763 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44768 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44771 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44775 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44780 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44784 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44794 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44797 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44800 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44803 */     GIR_RootConstrainSelectedInstOperands,
     /*  44804 */     // GIR_Coverage, 11884,
     /*  44804 */     GIR_EraseRootFromParent_Done,
     /*  44805 */   // Label 430: @44805
     /*  44805 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(44898), // Rule ID 2724 //
     /*  44810 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  44813 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44817 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44821 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  44825 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44829 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44833 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  44835 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  44839 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44843 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44847 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44851 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44855 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  44859 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44863 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  44867 */     // MIs[3] Operand 1
     /*  44867 */     // No operand predicates
     /*  44867 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  44871 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
     /*  44875 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24496),
     /*  44879 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44881 */     // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24486>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_24496>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  44881 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  44884 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44886 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  44890 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  44894 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  44896 */     GIR_RootConstrainSelectedInstOperands,
     /*  44897 */     // GIR_Coverage, 2724,
     /*  44897 */     GIR_EraseRootFromParent_Done,
     /*  44898 */   // Label 431: @44898
     /*  44898 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(44991), // Rule ID 9209 //
     /*  44903 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  44906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44910 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
     /*  44914 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  44918 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  44922 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44926 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44930 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  44932 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  44936 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44940 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44944 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44948 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44952 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  44956 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44960 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  44964 */     // MIs[3] Operand 1
     /*  44964 */     // No operand predicates
     /*  44964 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  44968 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24496),
     /*  44972 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44974 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24486>>)<<P:5:Predicate_anonymous_24496>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  44974 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  44977 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44979 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  44983 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  44987 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  44989 */     GIR_RootConstrainSelectedInstOperands,
     /*  44990 */     // GIR_Coverage, 9209,
     /*  44990 */     GIR_EraseRootFromParent_Done,
     /*  44991 */   // Label 432: @44991
     /*  44991 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(45176), // Rule ID 11945 //
     /*  44996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45000 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45016 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45020 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45024 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45028 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45032 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45036 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45040 */     // MIs[3] x
     /*  45040 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45045 */     // MIs[3] z
     /*  45045 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45050 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45054 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45056 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45056 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45059 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45063 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45068 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45072 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45077 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45080 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45084 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45089 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45093 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45098 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45101 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45105 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45110 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45114 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45119 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45122 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45126 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45131 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45135 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45140 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45143 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45147 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45152 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45155 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45158 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45160 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45163 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45165 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45168 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45171 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45174 */     GIR_RootConstrainSelectedInstOperands,
     /*  45175 */     // GIR_Coverage, 11945,
     /*  45175 */     GIR_EraseRootFromParent_Done,
     /*  45176 */   // Label 433: @45176
     /*  45176 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(45361), // Rule ID 11946 //
     /*  45181 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45185 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45189 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45193 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45197 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45201 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45205 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45209 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45213 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45217 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45221 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45225 */     // MIs[3] z
     /*  45225 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45230 */     // MIs[3] x
     /*  45230 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45235 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45239 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45241 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45241 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45244 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45248 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45253 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45257 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45262 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45265 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45269 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45274 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45278 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45283 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45286 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45290 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45295 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45299 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45304 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45307 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45311 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45316 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45320 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45325 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45328 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45332 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45337 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45340 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45343 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45345 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45348 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45350 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45353 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45356 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45359 */     GIR_RootConstrainSelectedInstOperands,
     /*  45360 */     // GIR_Coverage, 11946,
     /*  45360 */     GIR_EraseRootFromParent_Done,
     /*  45361 */   // Label 434: @45361
     /*  45361 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(45546), // Rule ID 11947 //
     /*  45366 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45370 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45374 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45378 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45382 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45386 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45390 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45394 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45398 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45402 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45406 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45410 */     // MIs[3] x
     /*  45410 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45415 */     // MIs[3] z
     /*  45415 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45420 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45424 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45426 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45426 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45429 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45433 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45438 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45442 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45447 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45450 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45454 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45459 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  45463 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45468 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45471 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45475 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45480 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45484 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45489 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45492 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45496 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45501 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  45505 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45510 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45513 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45517 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45522 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45525 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45528 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45530 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45533 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45535 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45538 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45541 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45544 */     GIR_RootConstrainSelectedInstOperands,
     /*  45545 */     // GIR_Coverage, 11947,
     /*  45545 */     GIR_EraseRootFromParent_Done,
     /*  45546 */   // Label 435: @45546
     /*  45546 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(45731), // Rule ID 11948 //
     /*  45551 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45555 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45559 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45563 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45567 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45571 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45575 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45579 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45583 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45587 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45591 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45595 */     // MIs[3] z
     /*  45595 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45600 */     // MIs[3] x
     /*  45600 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45605 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45609 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45611 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45611 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45614 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45618 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45623 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45627 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45632 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45635 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45639 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45644 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  45648 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45653 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45656 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45660 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45665 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45669 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45674 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45677 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45681 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45686 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  45690 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45695 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45698 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45702 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45707 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45710 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45713 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45720 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45723 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45726 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45729 */     GIR_RootConstrainSelectedInstOperands,
     /*  45730 */     // GIR_Coverage, 11948,
     /*  45730 */     GIR_EraseRootFromParent_Done,
     /*  45731 */   // Label 436: @45731
     /*  45731 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(45916), // Rule ID 11941 //
     /*  45736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45740 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45744 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45748 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45752 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45756 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  45760 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45764 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45768 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45772 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45776 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45780 */     // MIs[3] x
     /*  45780 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45785 */     // MIs[3] z
     /*  45785 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45790 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45794 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45796 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45796 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45799 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45803 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45808 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  45812 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45817 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45820 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45824 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45829 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45833 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45838 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45841 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45845 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45850 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  45854 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45859 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45862 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45866 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45871 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45875 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45880 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45883 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45887 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45892 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45895 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45898 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45905 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45908 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45911 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45914 */     GIR_RootConstrainSelectedInstOperands,
     /*  45915 */     // GIR_Coverage, 11941,
     /*  45915 */     GIR_EraseRootFromParent_Done,
     /*  45916 */   // Label 437: @45916
     /*  45916 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(46101), // Rule ID 11942 //
     /*  45921 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45925 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45929 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45933 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45937 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45941 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  45945 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45949 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45953 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45957 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45961 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45965 */     // MIs[3] z
     /*  45965 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45970 */     // MIs[3] x
     /*  45970 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45975 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  45979 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45981 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45981 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45984 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45988 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45993 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  45997 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46002 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46005 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46009 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46014 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  46018 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46023 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46026 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46030 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46035 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46039 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46044 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46047 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46051 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46056 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  46060 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46065 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46068 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46072 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46077 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46080 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46083 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46085 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46088 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46090 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46093 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46096 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46099 */     GIR_RootConstrainSelectedInstOperands,
     /*  46100 */     // GIR_Coverage, 11942,
     /*  46100 */     GIR_EraseRootFromParent_Done,
     /*  46101 */   // Label 438: @46101
     /*  46101 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(46286), // Rule ID 11943 //
     /*  46106 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46110 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46114 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46118 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46122 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46126 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  46130 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46134 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46138 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46142 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  46146 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46150 */     // MIs[3] x
     /*  46150 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  46155 */     // MIs[3] z
     /*  46155 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46160 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  46164 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46166 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46166 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46169 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46173 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46178 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46182 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46187 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46190 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46194 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46199 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  46203 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46208 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46211 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46215 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46220 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46224 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46229 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46232 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46236 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46241 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  46245 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46250 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46253 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46257 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46262 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46265 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46268 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46270 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46273 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46275 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46278 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46281 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46284 */     GIR_RootConstrainSelectedInstOperands,
     /*  46285 */     // GIR_Coverage, 11943,
     /*  46285 */     GIR_EraseRootFromParent_Done,
     /*  46286 */   // Label 439: @46286
     /*  46286 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(46471), // Rule ID 11944 //
     /*  46291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46295 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46311 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  46315 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46319 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46323 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46327 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  46331 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46335 */     // MIs[3] z
     /*  46335 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46340 */     // MIs[3] x
     /*  46340 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  46345 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  46349 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46351 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46351 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46354 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46358 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46363 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46367 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46372 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46375 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46379 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46384 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  46388 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46393 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46396 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46400 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46405 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46409 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46414 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46417 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46421 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46426 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  46430 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46435 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46438 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46442 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46447 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46450 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46453 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46455 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46458 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46460 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46463 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46466 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46469 */     GIR_RootConstrainSelectedInstOperands,
     /*  46470 */     // GIR_Coverage, 11944,
     /*  46470 */     GIR_EraseRootFromParent_Done,
     /*  46471 */   // Label 440: @46471
     /*  46471 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(46656), // Rule ID 11935 //
     /*  46476 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46480 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46484 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46488 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46492 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46496 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46500 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46504 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46508 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46512 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46516 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46520 */     // MIs[3] x
     /*  46520 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46525 */     // MIs[3] z
     /*  46525 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46530 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  46534 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46536 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46536 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46539 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46543 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46548 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46552 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46557 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46560 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46564 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46569 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  46573 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46578 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46581 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46585 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46590 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46594 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46599 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46602 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46606 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46611 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  46615 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46620 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46623 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46627 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46632 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46635 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46638 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46640 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46643 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46645 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46648 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46651 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46654 */     GIR_RootConstrainSelectedInstOperands,
     /*  46655 */     // GIR_Coverage, 11935,
     /*  46655 */     GIR_EraseRootFromParent_Done,
     /*  46656 */   // Label 441: @46656
     /*  46656 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(46841), // Rule ID 11936 //
     /*  46661 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46665 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46669 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46673 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46677 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46681 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46685 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46689 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46693 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46697 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46701 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46705 */     // MIs[3] z
     /*  46705 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46710 */     // MIs[3] x
     /*  46710 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46715 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  46719 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46721 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46721 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46724 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46728 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46733 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46737 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46742 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46745 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46749 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46754 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  46758 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46763 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46766 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46770 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46775 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46779 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46784 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46787 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46791 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46796 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  46800 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46805 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46808 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46812 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46817 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46820 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46823 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46825 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46828 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46830 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46833 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46836 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46839 */     GIR_RootConstrainSelectedInstOperands,
     /*  46840 */     // GIR_Coverage, 11936,
     /*  46840 */     GIR_EraseRootFromParent_Done,
     /*  46841 */   // Label 442: @46841
     /*  46841 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(47026), // Rule ID 11939 //
     /*  46846 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46850 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46854 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46858 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46862 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46866 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46870 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46874 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46878 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46882 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46886 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46890 */     // MIs[3] x
     /*  46890 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46895 */     // MIs[3] z
     /*  46895 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46900 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  46904 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46906 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46906 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46909 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46913 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46918 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46922 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46927 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46930 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46934 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46939 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  46943 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46948 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46951 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46955 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46960 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46964 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46969 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46972 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46976 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46981 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  46985 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46990 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46993 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46997 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47002 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  47005 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  47008 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  47010 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  47013 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  47015 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  47018 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  47021 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  47024 */     GIR_RootConstrainSelectedInstOperands,
     /*  47025 */     // GIR_Coverage, 11939,
     /*  47025 */     GIR_EraseRootFromParent_Done,
     /*  47026 */   // Label 443: @47026
     /*  47026 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(47211), // Rule ID 11940 //
     /*  47031 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47035 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  47039 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47043 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  47047 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  47051 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  47055 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47059 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  47063 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  47067 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  47071 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  47075 */     // MIs[3] z
     /*  47075 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  47080 */     // MIs[3] x
     /*  47080 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  47085 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  47089 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  47091 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  47091 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  47094 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47098 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47103 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  47107 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47112 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  47115 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47119 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47124 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  47128 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47133 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  47136 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47140 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47145 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  47149 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47154 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  47157 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47161 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47166 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  47170 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47175 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  47178 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  47182 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47187 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  47190 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  47193 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  47195 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  47198 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  47200 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  47203 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  47206 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  47209 */     GIR_RootConstrainSelectedInstOperands,
     /*  47210 */     // GIR_Coverage, 11940,
     /*  47210 */     GIR_EraseRootFromParent_Done,
     /*  47211 */   // Label 444: @47211
     /*  47211 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(47396), // Rule ID 8295 //
     /*  47216 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47220 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  47224 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47228 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  47232 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  47236 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  47240 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47244 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  47248 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  47252 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  47256 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  47260 */     // MIs[3] x
     /*  47260 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  47265 */     // MIs[3] z
     /*  47265 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  47270 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23159),
     /*  47274 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  47276 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_23159>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  47