// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#include "qwaylandcompositorxdgshell_p.h"

QT_BEGIN_NAMESPACE
/*!
    \qmlmodule QtWayland.Compositor.XdgShell
    \title Qt Wayland XdgShell Extension
    \ingroup qmlmodules
    \brief Provides a Qt API for the XdgShell shell extension.

    \section2 Summary
    XdgShell is a shell extension providing window system features typical to
    desktop systems.

    XdgShell corresponds to the Wayland interface, \c xdg_shell.

    \section2 Usage
    To use this module, import it like this:
    \code
    import QtWayland.Compositor.XdgShell
    \endcode
*/
QT_END_NAMESPACE

#include "moc_qwaylandcompositorxdgshell_p.cpp"
