// ui/ozone/public/mojom/gesture_properties_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace ui {
namespace ozone {
namespace mojom {

class GesturePropertiesServiceProxy;

template <typename ImplRefTraits>
class GesturePropertiesServiceStub;

class GesturePropertiesServiceRequestValidator;
class GesturePropertiesServiceResponseValidator;


class  GesturePropertiesService
    : public GesturePropertiesServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = GesturePropertiesServiceInterfaceBase;
  using Proxy_ = GesturePropertiesServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GesturePropertiesServiceStub<ImplRefTraits>;

  using RequestValidator_ = GesturePropertiesServiceRequestValidator;
  using ResponseValidator_ = GesturePropertiesServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kListDevicesMinVersion = 0,
    kListPropertiesMinVersion = 0,
    kGetPropertyMinVersion = 0,
    kSetPropertyMinVersion = 0,
  };
  virtual ~GesturePropertiesService() {}


  using ListDevicesCallback = base::OnceCallback<void(const base::flat_map<int32_t, std::string>&)>;
  
  virtual void ListDevices(ListDevicesCallback callback) = 0;


  using ListPropertiesCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void ListProperties(int32_t device_id, ListPropertiesCallback callback) = 0;


  using GetPropertyCallback = base::OnceCallback<void(bool, GesturePropValuePtr)>;
  
  virtual void GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) = 0;


  using SetPropertyCallback = base::OnceCallback<void(SetGesturePropErrorCode)>;
  
  virtual void SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) = 0;
};



class  GesturePropertiesServiceProxy
    : public GesturePropertiesService {
 public:
  using InterfaceType = GesturePropertiesService;

  explicit GesturePropertiesServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ListDevices(ListDevicesCallback callback) final;
  
  void ListProperties(int32_t device_id, ListPropertiesCallback callback) final;
  
  void GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) final;
  
  void SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GesturePropertiesServiceStubDispatch {
 public:
  static bool Accept(GesturePropertiesService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GesturePropertiesService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GesturePropertiesService>>
class GesturePropertiesServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GesturePropertiesServiceStub() {}
  ~GesturePropertiesServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GesturePropertiesServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GesturePropertiesServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GesturePropertiesServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GesturePropertiesServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  GesturePropValue {
 public:
  using DataView = GesturePropValueDataView;
  using Data_ = internal::GesturePropValue_Data;
  using Tag = Data_::GesturePropValue_Tag;

  static GesturePropValuePtr New() {
    return GesturePropValuePtr(base::in_place);
  }
  // Construct an instance holding |ints|.
  static GesturePropValuePtr
  NewInts(
      std::vector<int32_t> ints) {
    auto result = GesturePropValuePtr(base::in_place);
    result->set_ints(std::move(ints));
    return result;
  }
  // Construct an instance holding |shorts|.
  static GesturePropValuePtr
  NewShorts(
      std::vector<int16_t> shorts) {
    auto result = GesturePropValuePtr(base::in_place);
    result->set_shorts(std::move(shorts));
    return result;
  }
  // Construct an instance holding |bools|.
  static GesturePropValuePtr
  NewBools(
      std::vector<bool> bools) {
    auto result = GesturePropValuePtr(base::in_place);
    result->set_bools(std::move(bools));
    return result;
  }
  // Construct an instance holding |str|.
  static GesturePropValuePtr
  NewStr(
      const std::string& str) {
    auto result = GesturePropValuePtr(base::in_place);
    result->set_str(std::move(str));
    return result;
  }
  // Construct an instance holding |reals|.
  static GesturePropValuePtr
  NewReals(
      std::vector<double> reals) {
    auto result = GesturePropValuePtr(base::in_place);
    result->set_reals(std::move(reals));
    return result;
  }

  template <typename U>
  static GesturePropValuePtr From(const U& u) {
    return mojo::TypeConverter<GesturePropValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GesturePropValue>::Convert(*this);
  }

  GesturePropValue();
  ~GesturePropValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GesturePropValuePtr>
  GesturePropValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GesturePropValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_ints() const { return tag_ == Tag::INTS; }

  
  std::vector<int32_t>& get_ints() const {
    DCHECK(tag_ == Tag::INTS);
    return *(data_.ints);
  }

  
  void set_ints(
      std::vector<int32_t> ints);
  
  bool is_shorts() const { return tag_ == Tag::SHORTS; }

  
  std::vector<int16_t>& get_shorts() const {
    DCHECK(tag_ == Tag::SHORTS);
    return *(data_.shorts);
  }

  
  void set_shorts(
      std::vector<int16_t> shorts);
  
  bool is_bools() const { return tag_ == Tag::BOOLS; }

  
  std::vector<bool>& get_bools() const {
    DCHECK(tag_ == Tag::BOOLS);
    return *(data_.bools);
  }

  
  void set_bools(
      std::vector<bool> bools);
  
  bool is_str() const { return tag_ == Tag::STR; }

  
  std::string& get_str() const {
    DCHECK(tag_ == Tag::STR);
    return *(data_.str);
  }

  
  void set_str(
      const std::string& str);
  
  bool is_reals() const { return tag_ == Tag::REALS; }

  
  std::vector<double>& get_reals() const {
    DCHECK(tag_ == Tag::REALS);
    return *(data_.reals);
  }

  
  void set_reals(
      std::vector<double> reals);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GesturePropValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GesturePropValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    std::vector<int32_t>* ints;
    std::vector<int16_t>* shorts;
    std::vector<bool>* bools;
    std::string* str;
    std::vector<double>* reals;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
GesturePropValuePtr GesturePropValue::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::INTS:
      rv->set_ints(mojo::Clone(*data_.ints));
      break;
    case Tag::SHORTS:
      rv->set_shorts(mojo::Clone(*data_.shorts));
      break;
    case Tag::BOOLS:
      rv->set_bools(mojo::Clone(*data_.bools));
      break;
    case Tag::STR:
      rv->set_str(mojo::Clone(*data_.str));
      break;
    case Tag::REALS:
      rv->set_reals(mojo::Clone(*data_.reals));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GesturePropValue>::value>::type*>
bool GesturePropValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::INTS:
      return mojo::Equals(*(data_.ints), *(other.data_.ints));
    case Tag::SHORTS:
      return mojo::Equals(*(data_.shorts), *(other.data_.shorts));
    case Tag::BOOLS:
      return mojo::Equals(*(data_.bools), *(other.data_.bools));
    case Tag::STR:
      return mojo::Equals(*(data_.str), *(other.data_.str));
    case Tag::REALS:
      return mojo::Equals(*(data_.reals), *(other.data_.reals));
  }

  return false;
}


}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {


template <>
struct  UnionTraits<::ui::ozone::mojom::GesturePropValue::DataView,
                                        ::ui::ozone::mojom::GesturePropValuePtr> {
  static bool IsNull(const ::ui::ozone::mojom::GesturePropValuePtr& input) { return !input; }
  static void SetToNull(::ui::ozone::mojom::GesturePropValuePtr* output) { output->reset(); }

  static ::ui::ozone::mojom::GesturePropValue::Tag GetTag(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->which();
  }

  static const std::vector<int32_t>& ints(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_ints();
  }

  static const std::vector<int16_t>& shorts(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_shorts();
  }

  static const std::vector<bool>& bools(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_bools();
  }

  static const std::string& str(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_str();
  }

  static const std::vector<double>& reals(const ::ui::ozone::mojom::GesturePropValuePtr& input) {
    return input->get_reals();
  }

  static bool Read(::ui::ozone::mojom::GesturePropValue::DataView input, ::ui::ozone::mojom::GesturePropValuePtr* output);
};

}  // namespace mojo

#endif  // UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_H_