// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class ResourceLoadInfoNotifierProxy;

template <typename ImplRefTraits>
class ResourceLoadInfoNotifierStub;

class ResourceLoadInfoNotifierRequestValidator;


class BLINK_COMMON_EXPORT ResourceLoadInfoNotifier
    : public ResourceLoadInfoNotifierInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ResourceLoadInfoNotifierInterfaceBase;
  using Proxy_ = ResourceLoadInfoNotifierProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceLoadInfoNotifierStub<ImplRefTraits>;

  using RequestValidator_ = ResourceLoadInfoNotifierRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyResourceRedirectReceivedMinVersion = 0,
    kNotifyResourceResponseReceivedMinVersion = 0,
    kNotifyResourceTransferSizeUpdatedMinVersion = 0,
    kNotifyResourceLoadCompletedMinVersion = 0,
    kNotifyResourceLoadCanceledMinVersion = 0,
    kCloneMinVersion = 0,
  };
  virtual ~ResourceLoadInfoNotifier() {}

  
  virtual void NotifyResourceRedirectReceived(const ::net::RedirectInfo& redirect_info, ::network::mojom::URLResponseHeadPtr redirect_response) = 0;

  
  virtual void NotifyResourceResponseReceived(::blink::mojom::ResourceLoadInfoPtr resource_load_info, ::network::mojom::URLResponseHeadPtr head, int32_t previews_state) = 0;

  
  virtual void NotifyResourceTransferSizeUpdated(int32_t request_id, int32_t transfer_size_diff) = 0;

  
  virtual void NotifyResourceLoadCompleted(::blink::mojom::ResourceLoadInfoPtr resource_load_info, const ::network::URLLoaderCompletionStatus& status) = 0;

  
  virtual void NotifyResourceLoadCanceled(int32_t request_id) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<ResourceLoadInfoNotifier> pending_resource_load_info_notifier) = 0;
};



class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierProxy
    : public ResourceLoadInfoNotifier {
 public:
  using InterfaceType = ResourceLoadInfoNotifier;

  explicit ResourceLoadInfoNotifierProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyResourceRedirectReceived(const ::net::RedirectInfo& redirect_info, ::network::mojom::URLResponseHeadPtr redirect_response) final;
  
  void NotifyResourceResponseReceived(::blink::mojom::ResourceLoadInfoPtr resource_load_info, ::network::mojom::URLResponseHeadPtr head, int32_t previews_state) final;
  
  void NotifyResourceTransferSizeUpdated(int32_t request_id, int32_t transfer_size_diff) final;
  
  void NotifyResourceLoadCompleted(::blink::mojom::ResourceLoadInfoPtr resource_load_info, const ::network::URLLoaderCompletionStatus& status) final;
  
  void NotifyResourceLoadCanceled(int32_t request_id) final;
  
  void Clone(::mojo::PendingReceiver<ResourceLoadInfoNotifier> pending_resource_load_info_notifier) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierStubDispatch {
 public:
  static bool Accept(ResourceLoadInfoNotifier* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceLoadInfoNotifier* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceLoadInfoNotifier>>
class ResourceLoadInfoNotifierStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceLoadInfoNotifierStub() {}
  ~ResourceLoadInfoNotifierStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceLoadInfoNotifierStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceLoadInfoNotifierStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ResourceLoadInfoNotifierRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_H_