// third_party/blink/public/mojom/input/input_handler.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "cc/mojom/overscroll_behavior.mojom-shared-internal.h"
#include "cc/mojom/touch_action.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/gesture_event.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/selection_menu/selection_menu_behavior.mojom-shared-internal.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared-internal.h"
#include "ui/events/mojom/event.mojom-shared-internal.h"
#include "ui/events/mojom/event_constants.mojom-shared-internal.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/range/mojom/range.mojom-shared-internal.h"
#include "ui/latency/mojom/latency_info.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace blink {
namespace mojom {
namespace internal {
class KeyData_Data;
class PointerData_Data;
class WheelData_Data;
class MouseData_Data;
class ScrollUpdate_Data;
class ScrollData_Data;
class PinchBeginData_Data;
class PinchUpdateData_Data;
class PinchEndData_Data;
class FlingData_Data;
class TapData_Data;
class GestureData_Data;
class TouchPoint_Data;
class TouchData_Data;
class Event_Data;
class DidOverscrollParams_Data;
class TouchActionOptional_Data;
class EditCommand_Data;

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) KeyData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(KeyData_Data));
      new (data()) KeyData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    KeyData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<KeyData_Data>(index_);
    }
    KeyData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t dom_key;
  int32_t dom_code;
  int32_t windows_key_code;
  int32_t native_key_code;
  uint8_t is_system_key : 1;
  uint8_t is_browser_shortcut : 1;
  uint8_t pad5_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> text;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> unmodified_text;

 private:
  KeyData_Data();
  ~KeyData_Data() = delete;
};
static_assert(sizeof(KeyData_Data) == 48,
              "Bad sizeof(KeyData_Data)");
// Used by KeyData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct KeyData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  KeyData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~KeyData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    KeyData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    KeyData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PointerData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PointerData_Data));
      new (data()) PointerData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PointerData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PointerData_Data>(index_);
    }
    PointerData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t pointer_id;
  float force;
  int32_t tilt_x;
  int32_t tilt_y;
  float tangential_pressure;
  int32_t twist;
  int32_t button;
  int32_t pointer_type;
  int32_t movement_x;
  int32_t movement_y;
  uint8_t is_raw_movement_event : 1;
  uint8_t pad10_[7];
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> widget_position;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> screen_position;
  mojo::internal::Pointer<internal::MouseData_Data> mouse_data;

 private:
  PointerData_Data();
  ~PointerData_Data() = delete;
};
static_assert(sizeof(PointerData_Data) == 80,
              "Bad sizeof(PointerData_Data)");
// Used by PointerData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PointerData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PointerData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PointerData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PointerData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PointerData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) WheelData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WheelData_Data));
      new (data()) WheelData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WheelData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WheelData_Data>(index_);
    }
    WheelData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float delta_x;
  float delta_y;
  float wheel_ticks_x;
  float wheel_ticks_y;
  float acceleration_ratio_x;
  float acceleration_ratio_y;
  uint8_t phase;
  uint8_t momentum_phase;
  uint8_t event_action;
  uint8_t delta_units;
  int32_t cancelable;

 private:
  WheelData_Data();
  ~WheelData_Data() = delete;
};
static_assert(sizeof(WheelData_Data) == 40,
              "Bad sizeof(WheelData_Data)");
// Used by WheelData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WheelData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WheelData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WheelData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    WheelData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WheelData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) MouseData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MouseData_Data));
      new (data()) MouseData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MouseData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MouseData_Data>(index_);
    }
    MouseData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t click_count;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::WheelData_Data> wheel_data;

 private:
  MouseData_Data();
  ~MouseData_Data() = delete;
};
static_assert(sizeof(MouseData_Data) == 24,
              "Bad sizeof(MouseData_Data)");
// Used by MouseData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MouseData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MouseData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MouseData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    MouseData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MouseData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ScrollUpdate_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ScrollUpdate_Data));
      new (data()) ScrollUpdate_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ScrollUpdate_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ScrollUpdate_Data>(index_);
    }
    ScrollUpdate_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float velocity_x;
  float velocity_y;

 private:
  ScrollUpdate_Data();
  ~ScrollUpdate_Data() = delete;
};
static_assert(sizeof(ScrollUpdate_Data) == 16,
              "Bad sizeof(ScrollUpdate_Data)");
// Used by ScrollUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ScrollUpdate_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ScrollData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ScrollData_Data));
      new (data()) ScrollData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ScrollData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ScrollData_Data>(index_);
    }
    ScrollData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float delta_x;
  float delta_y;
  int32_t delta_units;
  uint8_t target_viewport : 1;
  uint8_t synthetic : 1;
  uint8_t pad4_[3];
  int32_t inertial_phase;
  int32_t pointer_count;
  mojo::internal::Pointer<internal::ScrollUpdate_Data> update_details;

 private:
  ScrollData_Data();
  ~ScrollData_Data() = delete;
};
static_assert(sizeof(ScrollData_Data) == 40,
              "Bad sizeof(ScrollData_Data)");
// Used by ScrollData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ScrollData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PinchBeginData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PinchBeginData_Data));
      new (data()) PinchBeginData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PinchBeginData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PinchBeginData_Data>(index_);
    }
    PinchBeginData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t needs_wheel_event : 1;
  uint8_t padfinal_[7];

 private:
  PinchBeginData_Data();
  ~PinchBeginData_Data() = delete;
};
static_assert(sizeof(PinchBeginData_Data) == 16,
              "Bad sizeof(PinchBeginData_Data)");
// Used by PinchBeginData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PinchBeginData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PinchBeginData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PinchBeginData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PinchBeginData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PinchBeginData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PinchUpdateData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PinchUpdateData_Data));
      new (data()) PinchUpdateData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PinchUpdateData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PinchUpdateData_Data>(index_);
    }
    PinchUpdateData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float scale;
  uint8_t zoom_disabled : 1;
  uint8_t needs_wheel_event : 1;
  uint8_t padfinal_[3];

 private:
  PinchUpdateData_Data();
  ~PinchUpdateData_Data() = delete;
};
static_assert(sizeof(PinchUpdateData_Data) == 16,
              "Bad sizeof(PinchUpdateData_Data)");
// Used by PinchUpdateData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PinchUpdateData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PinchUpdateData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PinchUpdateData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PinchUpdateData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PinchUpdateData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PinchEndData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PinchEndData_Data));
      new (data()) PinchEndData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PinchEndData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PinchEndData_Data>(index_);
    }
    PinchEndData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t needs_wheel_event : 1;
  uint8_t padfinal_[7];

 private:
  PinchEndData_Data();
  ~PinchEndData_Data() = delete;
};
static_assert(sizeof(PinchEndData_Data) == 16,
              "Bad sizeof(PinchEndData_Data)");
// Used by PinchEndData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PinchEndData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PinchEndData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PinchEndData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PinchEndData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PinchEndData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) FlingData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FlingData_Data));
      new (data()) FlingData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FlingData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FlingData_Data>(index_);
    }
    FlingData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float velocity_x;
  float velocity_y;
  uint8_t target_viewport : 1;
  uint8_t prevent_boosting : 1;
  uint8_t padfinal_[7];

 private:
  FlingData_Data();
  ~FlingData_Data() = delete;
};
static_assert(sizeof(FlingData_Data) == 24,
              "Bad sizeof(FlingData_Data)");
// Used by FlingData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FlingData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FlingData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FlingData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    FlingData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FlingData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TapData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TapData_Data));
      new (data()) TapData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TapData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TapData_Data>(index_);
    }
    TapData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t tap_count;
  uint8_t needs_wheel_event : 1;
  uint8_t padfinal_[3];

 private:
  TapData_Data();
  ~TapData_Data() = delete;
};
static_assert(sizeof(TapData_Data) == 16,
              "Bad sizeof(TapData_Data)");
// Used by TapData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TapData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TapData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TapData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TapData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TapData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) GestureData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GestureData_Data));
      new (data()) GestureData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GestureData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GestureData_Data>(index_);
    }
    GestureData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> screen_position;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> widget_position;
  int32_t source_device;
  uint8_t is_source_touch_event_set_non_blocking : 1;
  uint8_t pad3_[3];
  int32_t primary_pointer_type;
  int32_t unique_touch_event_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> contact_size;
  mojo::internal::Pointer<internal::ScrollData_Data> scroll_data;
  mojo::internal::Pointer<internal::PinchBeginData_Data> pinch_begin_data;
  mojo::internal::Pointer<internal::PinchUpdateData_Data> pinch_update_data;
  mojo::internal::Pointer<internal::PinchEndData_Data> pinch_end_data;
  mojo::internal::Pointer<internal::TapData_Data> tap_data;
  mojo::internal::Pointer<internal::FlingData_Data> fling_data;

 private:
  GestureData_Data();
  ~GestureData_Data() = delete;
};
static_assert(sizeof(GestureData_Data) == 96,
              "Bad sizeof(GestureData_Data)");
// Used by GestureData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GestureData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GestureData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GestureData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    GestureData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GestureData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TouchPoint_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TouchPoint_Data));
      new (data()) TouchPoint_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TouchPoint_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TouchPoint_Data>(index_);
    }
    TouchPoint_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t state;
  float radius_x;
  float radius_y;
  float rotation_angle;
  mojo::internal::Pointer<internal::PointerData_Data> pointer_data;

 private:
  TouchPoint_Data();
  ~TouchPoint_Data() = delete;
};
static_assert(sizeof(TouchPoint_Data) == 32,
              "Bad sizeof(TouchPoint_Data)");
// Used by TouchPoint::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TouchPoint_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TouchPoint_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TouchPoint_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TouchPoint_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TouchPoint_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TouchData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TouchData_Data));
      new (data()) TouchData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TouchData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TouchData_Data>(index_);
    }
    TouchData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cancelable;
  uint8_t moved_beyond_slop_region : 1;
  uint8_t touch_start_or_first_move : 1;
  uint8_t hovering : 1;
  uint8_t pad3_[3];
  uint32_t unique_touch_event_id;
  uint8_t pad4_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::TouchPoint_Data>>> touches;

 private:
  TouchData_Data();
  ~TouchData_Data() = delete;
};
static_assert(sizeof(TouchData_Data) == 32,
              "Bad sizeof(TouchData_Data)");
// Used by TouchData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TouchData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TouchData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TouchData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TouchData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TouchData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) Event_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Event_Data));
      new (data()) Event_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Event_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Event_Data>(index_);
    }
    Event_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t modifiers;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> timestamp;
  mojo::internal::Pointer<::ui::mojom::internal::LatencyInfo_Data> latency;
  mojo::internal::Pointer<internal::KeyData_Data> key_data;
  mojo::internal::Pointer<internal::PointerData_Data> pointer_data;
  mojo::internal::Pointer<internal::GestureData_Data> gesture_data;
  mojo::internal::Pointer<internal::TouchData_Data> touch_data;

 private:
  Event_Data();
  ~Event_Data() = delete;
};
static_assert(sizeof(Event_Data) == 64,
              "Bad sizeof(Event_Data)");
// Used by Event::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Event_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Event_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Event_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    Event_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Event_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DidOverscrollParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DidOverscrollParams_Data));
      new (data()) DidOverscrollParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DidOverscrollParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DidOverscrollParams_Data>(index_);
    }
    DidOverscrollParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> accumulated_overscroll;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> latest_overscroll_delta;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> current_fling_velocity;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> causal_event_viewport_point;
  mojo::internal::Pointer<::cc::mojom::internal::OverscrollBehavior_Data> overscroll_behavior;

 private:
  DidOverscrollParams_Data();
  ~DidOverscrollParams_Data() = delete;
};
static_assert(sizeof(DidOverscrollParams_Data) == 48,
              "Bad sizeof(DidOverscrollParams_Data)");
// Used by DidOverscrollParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DidOverscrollParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DidOverscrollParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DidOverscrollParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DidOverscrollParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DidOverscrollParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TouchActionOptional_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(TouchActionOptional_Data));
      new (data()) TouchActionOptional_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    TouchActionOptional_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<TouchActionOptional_Data>(index_);
    }
    TouchActionOptional_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t touch_action;
  uint8_t padfinal_[4];

 private:
  TouchActionOptional_Data();
  ~TouchActionOptional_Data() = delete;
};
static_assert(sizeof(TouchActionOptional_Data) == 16,
              "Bad sizeof(TouchActionOptional_Data)");
// Used by TouchActionOptional::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TouchActionOptional_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TouchActionOptional_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TouchActionOptional_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    TouchActionOptional_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TouchActionOptional_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) EditCommand_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(EditCommand_Data));
      new (data()) EditCommand_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    EditCommand_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<EditCommand_Data>(index_);
    }
    EditCommand_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> value;

 private:
  EditCommand_Data();
  ~EditCommand_Data() = delete;
};
static_assert(sizeof(EditCommand_Data) == 24,
              "Bad sizeof(EditCommand_Data)");
// Used by EditCommand::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EditCommand_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EditCommand_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EditCommand_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    EditCommand_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EditCommand_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_SHARED_INTERNAL_H_