// third_party/blink/public/mojom/hid/hid.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/hid/hid.mojom-shared-internal.h"
#include "services/device/public/mojom/hid.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class VendorAndProductDataView;

class HidDeviceFilterDataView;

class DeviceIdFilterDataView;
class UsageFilterDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::VendorAndProductDataView> {
  using Data = ::blink::mojom::internal::VendorAndProduct_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HidDeviceFilterDataView> {
  using Data = ::blink::mojom::internal::HidDeviceFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DeviceIdFilterDataView> {
  using Data = ::blink::mojom::internal::DeviceIdFilter_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::UsageFilterDataView> {
  using Data = ::blink::mojom::internal::UsageFilter_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class HidServiceInterfaceBase {};

using HidServicePtrDataView =
    mojo::InterfacePtrDataView<HidServiceInterfaceBase>;
using HidServiceRequestDataView =
    mojo::InterfaceRequestDataView<HidServiceInterfaceBase>;
using HidServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidServiceInterfaceBase>;
using HidServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidServiceInterfaceBase>;


class VendorAndProductDataView {
 public:
  VendorAndProductDataView() {}

  VendorAndProductDataView(
      internal::VendorAndProduct_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t vendor() const {
    return data_->vendor;
  }
  uint16_t product() const {
    return data_->product;
  }
 private:
  internal::VendorAndProduct_Data* data_ = nullptr;
};



class HidDeviceFilterDataView {
 public:
  HidDeviceFilterDataView() {}

  HidDeviceFilterDataView(
      internal::HidDeviceFilter_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdsDataView(
      DeviceIdFilterDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DeviceIdFilterDataView, UserType>(),
    "Attempting to read the optional `device_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceIds` instead "
    "of `ReadDeviceIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->device_ids.is_null() ? &data_->device_ids : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::DeviceIdFilterDataView>(
        pointer, output, context_);
  }
  inline void GetUsageDataView(
      UsageFilterDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUsage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::UsageFilterDataView, UserType>(),
    "Attempting to read the optional `usage` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUsage` instead "
    "of `ReadUsage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->usage.is_null() ? &data_->usage : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::UsageFilterDataView>(
        pointer, output, context_);
  }
 private:
  internal::HidDeviceFilter_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DeviceIdFilterDataView {
 public:
  using Tag = internal::DeviceIdFilter_Data::DeviceIdFilter_Tag;

  DeviceIdFilterDataView() {}

  DeviceIdFilterDataView(
      internal::DeviceIdFilter_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_vendor() const { return data_->tag == Tag::VENDOR; }
  uint16_t vendor() const {
    DCHECK(is_vendor());
    return data_->data.f_vendor;
  }
  bool is_vendor_and_product() const { return data_->tag == Tag::VENDOR_AND_PRODUCT; }
  inline void GetVendorAndProductDataView(
      VendorAndProductDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVendorAndProduct(UserType* output) {
    
    DCHECK(is_vendor_and_product());
    return mojo::internal::Deserialize<::blink::mojom::VendorAndProductDataView>(
        data_->data.f_vendor_and_product.Get(), output, context_);
  }

 private:
  internal::DeviceIdFilter_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class UsageFilterDataView {
 public:
  using Tag = internal::UsageFilter_Data::UsageFilter_Tag;

  UsageFilterDataView() {}

  UsageFilterDataView(
      internal::UsageFilter_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_page() const { return data_->tag == Tag::PAGE; }
  uint16_t page() const {
    DCHECK(is_page());
    return data_->data.f_page;
  }
  bool is_usage_and_page() const { return data_->tag == Tag::USAGE_AND_PAGE; }
  inline void GetUsageAndPageDataView(
      ::device::mojom::HidUsageAndPageDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUsageAndPage(UserType* output) {
    
    DCHECK(is_usage_and_page());
    return mojo::internal::Deserialize<::device::mojom::HidUsageAndPageDataView>(
        data_->data.f_usage_and_page.Get(), output, context_);
  }

 private:
  internal::UsageFilter_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::VendorAndProductDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VendorAndProductDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::VendorAndProduct_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->vendor = Traits::vendor(input);
    (*output)->product = Traits::product(input);
  }

  static bool Deserialize(::blink::mojom::internal::VendorAndProduct_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::VendorAndProductDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HidDeviceFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HidDeviceFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::HidDeviceFilter_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
    typename decltype((*output)->device_ids)::BufferWriter device_ids_writer;
    device_ids_writer.AllocateInline(buffer, &(*output)->device_ids);
    mojo::internal::Serialize<::blink::mojom::DeviceIdFilterDataView>(
        in_device_ids, buffer, &device_ids_writer, true, context);
    decltype(Traits::usage(input)) in_usage = Traits::usage(input);
    typename decltype((*output)->usage)::BufferWriter usage_writer;
    usage_writer.AllocateInline(buffer, &(*output)->usage);
    mojo::internal::Serialize<::blink::mojom::UsageFilterDataView>(
        in_usage, buffer, &usage_writer, true, context);
  }

  static bool Deserialize(::blink::mojom::internal::HidDeviceFilter_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HidDeviceFilterDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeviceIdFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DeviceIdFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DeviceIdFilter_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::DeviceIdFilter_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::DeviceIdFilterDataView::Tag::VENDOR: {
        decltype(Traits::vendor(input))
            in_vendor = Traits::vendor(input);
        result->data.f_vendor = in_vendor;
        break;
      }
      case ::blink::mojom::DeviceIdFilterDataView::Tag::VENDOR_AND_PRODUCT: {
        decltype(Traits::vendor_and_product(input))
            in_vendor_and_product = Traits::vendor_and_product(input);
        typename decltype(result->data.f_vendor_and_product)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::VendorAndProductDataView>(
            in_vendor_and_product, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null vendor_and_product in DeviceIdFilter union");
        result->data.f_vendor_and_product.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::DeviceIdFilter_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DeviceIdFilterDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UsageFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::UsageFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::UsageFilter_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::UsageFilter_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::UsageFilterDataView::Tag::PAGE: {
        decltype(Traits::page(input))
            in_page = Traits::page(input);
        result->data.f_page = in_page;
        break;
      }
      case ::blink::mojom::UsageFilterDataView::Tag::USAGE_AND_PAGE: {
        decltype(Traits::usage_and_page(input))
            in_usage_and_page = Traits::usage_and_page(input);
        typename decltype(result->data.f_usage_and_page)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView>(
            in_usage_and_page, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null usage_and_page in UsageFilter union");
        result->data.f_usage_and_page.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::UsageFilter_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UsageFilterDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



inline void HidDeviceFilterDataView::GetDeviceIdsDataView(
    DeviceIdFilterDataView* output) {
  auto pointer = &data_->device_ids;
  *output = DeviceIdFilterDataView(pointer, context_);
}
inline void HidDeviceFilterDataView::GetUsageDataView(
    UsageFilterDataView* output) {
  auto pointer = &data_->usage;
  *output = UsageFilterDataView(pointer, context_);
}


inline void DeviceIdFilterDataView::GetVendorAndProductDataView(
    VendorAndProductDataView* output) {
  DCHECK(is_vendor_and_product());
  *output = VendorAndProductDataView(data_->data.f_vendor_and_product.Get(), context_);
}

inline void UsageFilterDataView::GetUsageAndPageDataView(
    ::device::mojom::HidUsageAndPageDataView* output) {
  DCHECK(is_usage_and_page());
  *output = ::device::mojom::HidUsageAndPageDataView(data_->data.f_usage_and_page.Get(), context_);
}


}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_