// third_party/blink/public/mojom/appcache/appcache_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_APPCACHE_APPCACHE_INFO_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_APPCACHE_APPCACHE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/appcache/appcache_info.mojom-shared.h"
#include "third_party/blink/public/mojom/appcache/appcache_info.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT AppCacheInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AppCacheInfo, T>::value>;
  using DataView = AppCacheInfoDataView;
  using Data_ = internal::AppCacheInfo_Data;

  template <typename... Args>
  static AppCacheInfoPtr New(Args&&... args) {
    return AppCacheInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppCacheInfoPtr From(const U& u) {
    return mojo::TypeConverter<AppCacheInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AppCacheInfo>::Convert(*this);
  }


  AppCacheInfo();

  AppCacheInfo(
      const ::GURL& manifest_url,
      ::base::Time creation_time,
      ::base::Time last_update_time,
      ::base::Time last_access_time,
      ::base::Time token_expires,
      int64_t cache_id,
      int64_t group_id,
      AppCacheStatus status,
      int64_t response_sizes,
      int64_t padding_sizes,
      bool is_complete,
      int64_t manifest_parser_version,
      const std::string& manifest_scope);

  ~AppCacheInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppCacheInfoPtr>
  AppCacheInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AppCacheInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AppCacheInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AppCacheInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AppCacheInfo_UnserializedMessageContext<
            UserType, AppCacheInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AppCacheInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return AppCacheInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AppCacheInfo_UnserializedMessageContext<
            UserType, AppCacheInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AppCacheInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL manifest_url;
  
  ::base::Time creation_time;
  
  ::base::Time last_update_time;
  
  ::base::Time last_access_time;
  
  ::base::Time token_expires;
  
  int64_t cache_id;
  
  int64_t group_id;
  
  AppCacheStatus status;
  
  int64_t response_sizes;
  
  int64_t padding_sizes;
  
  bool is_complete;
  
  int64_t manifest_parser_version;
  
  std::string manifest_scope;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AppCacheInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AppCacheInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AppCacheInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AppCacheInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AppCacheInfoPtr AppCacheInfo::Clone() const {
  return New(
      mojo::Clone(manifest_url),
      mojo::Clone(creation_time),
      mojo::Clone(last_update_time),
      mojo::Clone(last_access_time),
      mojo::Clone(token_expires),
      mojo::Clone(cache_id),
      mojo::Clone(group_id),
      mojo::Clone(status),
      mojo::Clone(response_sizes),
      mojo::Clone(padding_sizes),
      mojo::Clone(is_complete),
      mojo::Clone(manifest_parser_version),
      mojo::Clone(manifest_scope)
  );
}

template <typename T, AppCacheInfo::EnableIfSame<T>*>
bool AppCacheInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest_url, other_struct.manifest_url))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->last_update_time, other_struct.last_update_time))
    return false;
  if (!mojo::Equals(this->last_access_time, other_struct.last_access_time))
    return false;
  if (!mojo::Equals(this->token_expires, other_struct.token_expires))
    return false;
  if (!mojo::Equals(this->cache_id, other_struct.cache_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->response_sizes, other_struct.response_sizes))
    return false;
  if (!mojo::Equals(this->padding_sizes, other_struct.padding_sizes))
    return false;
  if (!mojo::Equals(this->is_complete, other_struct.is_complete))
    return false;
  if (!mojo::Equals(this->manifest_parser_version, other_struct.manifest_parser_version))
    return false;
  if (!mojo::Equals(this->manifest_scope, other_struct.manifest_scope))
    return false;
  return true;
}

template <typename T, AppCacheInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.manifest_url, rhs.manifest_url))
    return true;
  if (std::less<>{}(rhs.manifest_url, lhs.manifest_url))
    return false;
  if (std::less<>{}(lhs.creation_time, rhs.creation_time))
    return true;
  if (std::less<>{}(rhs.creation_time, lhs.creation_time))
    return false;
  if (std::less<>{}(lhs.last_update_time, rhs.last_update_time))
    return true;
  if (std::less<>{}(rhs.last_update_time, lhs.last_update_time))
    return false;
  if (std::less<>{}(lhs.last_access_time, rhs.last_access_time))
    return true;
  if (std::less<>{}(rhs.last_access_time, lhs.last_access_time))
    return false;
  if (std::less<>{}(lhs.token_expires, rhs.token_expires))
    return true;
  if (std::less<>{}(rhs.token_expires, lhs.token_expires))
    return false;
  if (std::less<>{}(lhs.cache_id, rhs.cache_id))
    return true;
  if (std::less<>{}(rhs.cache_id, lhs.cache_id))
    return false;
  if (std::less<>{}(lhs.group_id, rhs.group_id))
    return true;
  if (std::less<>{}(rhs.group_id, lhs.group_id))
    return false;
  if (std::less<>{}(lhs.status, rhs.status))
    return true;
  if (std::less<>{}(rhs.status, lhs.status))
    return false;
  if (std::less<>{}(lhs.response_sizes, rhs.response_sizes))
    return true;
  if (std::less<>{}(rhs.response_sizes, lhs.response_sizes))
    return false;
  if (std::less<>{}(lhs.padding_sizes, rhs.padding_sizes))
    return true;
  if (std::less<>{}(rhs.padding_sizes, lhs.padding_sizes))
    return false;
  if (std::less<>{}(lhs.is_complete, rhs.is_complete))
    return true;
  if (std::less<>{}(rhs.is_complete, lhs.is_complete))
    return false;
  if (std::less<>{}(lhs.manifest_parser_version, rhs.manifest_parser_version))
    return true;
  if (std::less<>{}(rhs.manifest_parser_version, lhs.manifest_parser_version))
    return false;
  if (std::less<>{}(lhs.manifest_scope, rhs.manifest_scope))
    return true;
  if (std::less<>{}(rhs.manifest_scope, lhs.manifest_scope))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AppCacheInfo::DataView,
                                         ::blink::mojom::AppCacheInfoPtr> {
  static bool IsNull(const ::blink::mojom::AppCacheInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AppCacheInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AppCacheInfo::manifest_url)& manifest_url(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->manifest_url;
  }

  static const decltype(::blink::mojom::AppCacheInfo::creation_time)& creation_time(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->creation_time;
  }

  static const decltype(::blink::mojom::AppCacheInfo::last_update_time)& last_update_time(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->last_update_time;
  }

  static const decltype(::blink::mojom::AppCacheInfo::last_access_time)& last_access_time(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->last_access_time;
  }

  static const decltype(::blink::mojom::AppCacheInfo::token_expires)& token_expires(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->token_expires;
  }

  static decltype(::blink::mojom::AppCacheInfo::cache_id) cache_id(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->cache_id;
  }

  static decltype(::blink::mojom::AppCacheInfo::group_id) group_id(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->group_id;
  }

  static decltype(::blink::mojom::AppCacheInfo::status) status(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->status;
  }

  static decltype(::blink::mojom::AppCacheInfo::response_sizes) response_sizes(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->response_sizes;
  }

  static decltype(::blink::mojom::AppCacheInfo::padding_sizes) padding_sizes(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->padding_sizes;
  }

  static decltype(::blink::mojom::AppCacheInfo::is_complete) is_complete(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->is_complete;
  }

  static decltype(::blink::mojom::AppCacheInfo::manifest_parser_version) manifest_parser_version(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->manifest_parser_version;
  }

  static const decltype(::blink::mojom::AppCacheInfo::manifest_scope)& manifest_scope(
      const ::blink::mojom::AppCacheInfoPtr& input) {
    return input->manifest_scope;
  }

  static bool Read(::blink::mojom::AppCacheInfo::DataView input, ::blink::mojom::AppCacheInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_APPCACHE_APPCACHE_INFO_MOJOM_H_