// media/mojo/mojom/media_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"
#include "gpu/ipc/common/mailbox_holder.mojom-blink.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"
#include "ui/gl/mojom/hdr_metadata.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/mojo/mojom/video_frame_metadata_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct media_mojom_internal_VideoRotation_DataHashFn {
  static unsigned GetHash(const ::media::mojom::VideoRotation& value) {
    using utype = std::underlying_type<::media::mojom::VideoRotation>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::media::mojom::VideoRotation& left, const ::media::mojom::VideoRotation& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::media::mojom::VideoRotation>
    : public GenericHashTraits<::media::mojom::VideoRotation> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::media::mojom::VideoRotation& value) {
    return value == static_cast<::media::mojom::VideoRotation>(-1000000);
  }
  static void ConstructDeletedValue(::media::mojom::VideoRotation& slot, bool) {
    slot = static_cast<::media::mojom::VideoRotation>(-1000001);
  }
  static bool IsDeletedValue(const ::media::mojom::VideoRotation& value) {
    return value == static_cast<::media::mojom::VideoRotation>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct media_mojom_internal_CopyMode_DataHashFn {
  static unsigned GetHash(const ::media::mojom::CopyMode& value) {
    using utype = std::underlying_type<::media::mojom::CopyMode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::media::mojom::CopyMode& left, const ::media::mojom::CopyMode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::media::mojom::CopyMode>
    : public GenericHashTraits<::media::mojom::CopyMode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::media::mojom::CopyMode& value) {
    return value == static_cast<::media::mojom::CopyMode>(-1000000);
  }
  static void ConstructDeletedValue(::media::mojom::CopyMode& slot, bool) {
    slot = static_cast<::media::mojom::CopyMode>(-1000001);
  }
  static bool IsDeletedValue(const ::media::mojom::CopyMode& value) {
    return value == static_cast<::media::mojom::CopyMode>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {
namespace blink {






class BLINK_PLATFORM_EXPORT VideoTransformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoTransformation, T>::value>;
  using DataView = VideoTransformationDataView;
  using Data_ = internal::VideoTransformation_Data;

  template <typename... Args>
  static VideoTransformationPtr New(Args&&... args) {
    return VideoTransformationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoTransformationPtr From(const U& u) {
    return mojo::TypeConverter<VideoTransformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoTransformation>::Convert(*this);
  }


  VideoTransformation();

  VideoTransformation(
      VideoRotation rotation,
      bool mirrored);

  ~VideoTransformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoTransformationPtr>
  VideoTransformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoTransformation::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoTransformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VideoTransformation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoTransformation_UnserializedMessageContext<
            UserType, VideoTransformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoTransformation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VideoRotation rotation;
  
  bool mirrored;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoTransformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EncryptionPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncryptionPattern, T>::value>;
  using DataView = EncryptionPatternDataView;
  using Data_ = internal::EncryptionPattern_Data;

  template <typename... Args>
  static EncryptionPatternPtr New(Args&&... args) {
    return EncryptionPatternPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncryptionPatternPtr From(const U& u) {
    return mojo::TypeConverter<EncryptionPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncryptionPattern>::Convert(*this);
  }


  EncryptionPattern();

  EncryptionPattern(
      uint32_t crypt_byte_block,
      uint32_t skip_byte_block);

  ~EncryptionPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncryptionPatternPtr>
  EncryptionPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncryptionPattern::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncryptionPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncryptionPattern_UnserializedMessageContext<
            UserType, EncryptionPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EncryptionPattern::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return EncryptionPattern::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncryptionPattern_UnserializedMessageContext<
            UserType, EncryptionPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncryptionPattern::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t crypt_byte_block;
  
  uint32_t skip_byte_block;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoColorSpace, T>::value>;
  using DataView = VideoColorSpaceDataView;
  using Data_ = internal::VideoColorSpace_Data;
  using PrimaryID = VideoColorSpace_PrimaryID;
  using TransferID = VideoColorSpace_TransferID;
  using MatrixID = VideoColorSpace_MatrixID;
  using RangeID = VideoColorSpace_RangeID;

  template <typename... Args>
  static VideoColorSpacePtr New(Args&&... args) {
    return VideoColorSpacePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<VideoColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoColorSpace>::Convert(*this);
  }


  VideoColorSpace();

  VideoColorSpace(
      VideoColorSpace::PrimaryID primaries,
      VideoColorSpace::TransferID transfer,
      VideoColorSpace::MatrixID matrix,
      VideoColorSpace::RangeID range);

  ~VideoColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoColorSpacePtr>
  VideoColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoColorSpace::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VideoColorSpace::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoColorSpace_UnserializedMessageContext<
            UserType, VideoColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoColorSpace::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VideoColorSpace::PrimaryID primaries;
  
  VideoColorSpace::TransferID transfer;
  
  VideoColorSpace::MatrixID matrix;
  
  VideoColorSpace::RangeID range;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class BLINK_PLATFORM_EXPORT EosVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EosVideoFrameData, T>::value>;
  using DataView = EosVideoFrameDataDataView;
  using Data_ = internal::EosVideoFrameData_Data;

  template <typename... Args>
  static EosVideoFrameDataPtr New(Args&&... args) {
    return EosVideoFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EosVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<EosVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EosVideoFrameData>::Convert(*this);
  }


  EosVideoFrameData();

  ~EosVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EosVideoFrameDataPtr>
  EosVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EosVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EosVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return EosVideoFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EosVideoFrameData_UnserializedMessageContext<
            UserType, EosVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EosVideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class BLINK_PLATFORM_EXPORT PredictionTargets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionTargets, T>::value>;
  using DataView = PredictionTargetsDataView;
  using Data_ = internal::PredictionTargets_Data;

  template <typename... Args>
  static PredictionTargetsPtr New(Args&&... args) {
    return PredictionTargetsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionTargetsPtr From(const U& u) {
    return mojo::TypeConverter<PredictionTargetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionTargets>::Convert(*this);
  }


  PredictionTargets();

  PredictionTargets(
      uint32_t frames_decoded,
      uint32_t frames_dropped,
      uint32_t frames_power_efficient);

  ~PredictionTargets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionTargetsPtr>
  PredictionTargetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionTargets::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionTargets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PredictionTargets::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionTargets_UnserializedMessageContext<
            UserType, PredictionTargets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionTargets::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t frames_decoded;
  
  uint32_t frames_dropped;
  
  uint32_t frames_power_efficient;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionTargets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PipelineDecoderInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineDecoderInfo, T>::value>;
  using DataView = PipelineDecoderInfoDataView;
  using Data_ = internal::PipelineDecoderInfo_Data;

  template <typename... Args>
  static PipelineDecoderInfoPtr New(Args&&... args) {
    return PipelineDecoderInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineDecoderInfoPtr From(const U& u) {
    return mojo::TypeConverter<PipelineDecoderInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineDecoderInfo>::Convert(*this);
  }


  PipelineDecoderInfo();

  PipelineDecoderInfo(
      const WTF::String& decoder_name,
      bool is_platform_decoder,
      bool has_decrypting_demuxer_stream);

  ~PipelineDecoderInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineDecoderInfoPtr>
  PipelineDecoderInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineDecoderInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineDecoderInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineDecoderInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineDecoderInfo_UnserializedMessageContext<
            UserType, PipelineDecoderInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PipelineDecoderInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PipelineDecoderInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineDecoderInfo_UnserializedMessageContext<
            UserType, PipelineDecoderInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineDecoderInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String decoder_name;
  
  bool is_platform_decoder;
  
  bool has_decrypting_demuxer_stream;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineDecoderInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineDecoderInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineDecoderInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineDecoderInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT VideoFrameData {
 public:
  using DataView = VideoFrameDataDataView;
  using Data_ = internal::VideoFrameData_Data;
  using Tag = Data_::VideoFrameData_Tag;

  static VideoFrameDataPtr New() {
    return VideoFrameDataPtr(base::in_place);
  }
  // Construct an instance holding |eos_data|.
  static VideoFrameDataPtr
  NewEosData(
      EosVideoFrameDataPtr eos_data) {
    auto result = VideoFrameDataPtr(base::in_place);
    result->set_eos_data(std::move(eos_data));
    return result;
  }
  // Construct an instance holding |shared_buffer_data|.
  static VideoFrameDataPtr
  NewSharedBufferData(
      SharedBufferVideoFrameDataPtr shared_buffer_data) {
    auto result = VideoFrameDataPtr(base::in_place);
    result->set_shared_buffer_data(std::move(shared_buffer_data));
    return result;
  }
  // Construct an instance holding |dmabuf_data|.
  static VideoFrameDataPtr
  NewDmabufData(
      DmabufVideoFrameDataPtr dmabuf_data) {
    auto result = VideoFrameDataPtr(base::in_place);
    result->set_dmabuf_data(std::move(dmabuf_data));
    return result;
  }
  // Construct an instance holding |gpu_memory_buffer_data|.
  static VideoFrameDataPtr
  NewGpuMemoryBufferData(
      GpuMemoryBufferVideoFrameDataPtr gpu_memory_buffer_data) {
    auto result = VideoFrameDataPtr(base::in_place);
    result->set_gpu_memory_buffer_data(std::move(gpu_memory_buffer_data));
    return result;
  }
  // Construct an instance holding |mailbox_data|.
  static VideoFrameDataPtr
  NewMailboxData(
      MailboxVideoFrameDataPtr mailbox_data) {
    auto result = VideoFrameDataPtr(base::in_place);
    result->set_mailbox_data(std::move(mailbox_data));
    return result;
  }

  template <typename U>
  static VideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameData>::Convert(*this);
  }

  VideoFrameData();
  ~VideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoFrameDataPtr>
  VideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoFrameData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_eos_data() const { return tag_ == Tag::EOS_DATA; }

  
  EosVideoFrameDataPtr& get_eos_data() const {
    DCHECK(tag_ == Tag::EOS_DATA);
    return *(data_.eos_data);
  }

  
  void set_eos_data(
      EosVideoFrameDataPtr eos_data);
  
  bool is_shared_buffer_data() const { return tag_ == Tag::SHARED_BUFFER_DATA; }

  
  SharedBufferVideoFrameDataPtr& get_shared_buffer_data() const {
    DCHECK(tag_ == Tag::SHARED_BUFFER_DATA);
    return *(data_.shared_buffer_data);
  }

  
  void set_shared_buffer_data(
      SharedBufferVideoFrameDataPtr shared_buffer_data);
  
  bool is_dmabuf_data() const { return tag_ == Tag::DMABUF_DATA; }

  
  DmabufVideoFrameDataPtr& get_dmabuf_data() const {
    DCHECK(tag_ == Tag::DMABUF_DATA);
    return *(data_.dmabuf_data);
  }

  
  void set_dmabuf_data(
      DmabufVideoFrameDataPtr dmabuf_data);
  
  bool is_gpu_memory_buffer_data() const { return tag_ == Tag::GPU_MEMORY_BUFFER_DATA; }

  
  GpuMemoryBufferVideoFrameDataPtr& get_gpu_memory_buffer_data() const {
    DCHECK(tag_ == Tag::GPU_MEMORY_BUFFER_DATA);
    return *(data_.gpu_memory_buffer_data);
  }

  
  void set_gpu_memory_buffer_data(
      GpuMemoryBufferVideoFrameDataPtr gpu_memory_buffer_data);
  
  bool is_mailbox_data() const { return tag_ == Tag::MAILBOX_DATA; }

  
  MailboxVideoFrameDataPtr& get_mailbox_data() const {
    DCHECK(tag_ == Tag::MAILBOX_DATA);
    return *(data_.mailbox_data);
  }

  
  void set_mailbox_data(
      MailboxVideoFrameDataPtr mailbox_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    EosVideoFrameDataPtr* eos_data;
    SharedBufferVideoFrameDataPtr* shared_buffer_data;
    DmabufVideoFrameDataPtr* dmabuf_data;
    GpuMemoryBufferVideoFrameDataPtr* gpu_memory_buffer_data;
    MailboxVideoFrameDataPtr* mailbox_data;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};









class BLINK_PLATFORM_EXPORT AudioDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDecoderConfig, T>::value>;
  using DataView = AudioDecoderConfigDataView;
  using Data_ = internal::AudioDecoderConfig_Data;

  template <typename... Args>
  static AudioDecoderConfigPtr New(Args&&... args) {
    return AudioDecoderConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<AudioDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDecoderConfig>::Convert(*this);
  }


  AudioDecoderConfig();

  AudioDecoderConfig(
      AudioCodec codec,
      AudioCodecProfile profile,
      SampleFormat sample_format,
      ChannelLayout channel_layout,
      int32_t samples_per_second,
      WTF::Vector<uint8_t> extra_data,
      ::base::TimeDelta seek_preroll,
      int32_t codec_delay,
      EncryptionScheme encryption_scheme);

  ~AudioDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDecoderConfigPtr>
  AudioDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDecoderConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AudioDecoderConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDecoderConfig_UnserializedMessageContext<
            UserType, AudioDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDecoderConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  AudioCodec codec;
  
  AudioCodecProfile profile;
  
  SampleFormat sample_format;
  
  ChannelLayout channel_layout;
  
  int32_t samples_per_second;
  
  WTF::Vector<uint8_t> extra_data;
  
  ::base::TimeDelta seek_preroll;
  
  int32_t codec_delay;
  
  EncryptionScheme encryption_scheme;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoDecoderConfig, T>::value>;
  using DataView = VideoDecoderConfigDataView;
  using Data_ = internal::VideoDecoderConfig_Data;

  template <typename... Args>
  static VideoDecoderConfigPtr New(Args&&... args) {
    return VideoDecoderConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoDecoderConfig>::Convert(*this);
  }


  VideoDecoderConfig();

  VideoDecoderConfig(
      VideoCodec codec,
      VideoCodecProfile profile,
      uint32_t level,
      bool has_alpha,
      VideoTransformationPtr transformation,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      WTF::Vector<uint8_t> extra_data,
      EncryptionScheme encryption_scheme,
      VideoColorSpacePtr color_space_info,
      ::gl::mojom::blink::HDRMetadataPtr hdr_metadata);

  ~VideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoDecoderConfigPtr>
  VideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoDecoderConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VideoDecoderConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VideoCodec codec;
  
  VideoCodecProfile profile;
  
  uint32_t level;
  
  bool has_alpha;
  
  VideoTransformationPtr transformation;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  WTF::Vector<uint8_t> extra_data;
  
  EncryptionScheme encryption_scheme;
  
  VideoColorSpacePtr color_space_info;
  
  ::gl::mojom::blink::HDRMetadataPtr hdr_metadata;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VideoDecoderConfig);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT DecryptConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecryptConfig, T>::value>;
  using DataView = DecryptConfigDataView;
  using Data_ = internal::DecryptConfig_Data;

  template <typename... Args>
  static DecryptConfigPtr New(Args&&... args) {
    return DecryptConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecryptConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecryptConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecryptConfig>::Convert(*this);
  }


  DecryptConfig();

  DecryptConfig(
      EncryptionScheme encryption_scheme,
      const WTF::String& key_id,
      const WTF::String& iv,
      WTF::Vector<SubsampleEntryPtr> subsamples,
      EncryptionPatternPtr encryption_pattern);

  ~DecryptConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecryptConfigPtr>
  DecryptConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecryptConfig::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecryptConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DecryptConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  EncryptionScheme encryption_scheme;
  
  WTF::String key_id;
  
  WTF::String iv;
  
  WTF::Vector<SubsampleEntryPtr> subsamples;
  
  EncryptionPatternPtr encryption_pattern;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DecryptConfig);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderBuffer, T>::value>;
  using DataView = DecoderBufferDataView;
  using Data_ = internal::DecoderBuffer_Data;

  template <typename... Args>
  static DecoderBufferPtr New(Args&&... args) {
    return DecoderBufferPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBuffer>::Convert(*this);
  }


  DecoderBuffer();

  DecoderBuffer(
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      bool is_end_of_stream,
      uint32_t data_size,
      bool is_key_frame,
      WTF::Vector<uint8_t> side_data,
      DecryptConfigPtr decrypt_config,
      ::base::TimeDelta front_discard,
      ::base::TimeDelta back_discard);

  ~DecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderBufferPtr>
  DecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBuffer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderBuffer_UnserializedMessageContext<
            UserType, DecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DecoderBuffer::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderBuffer_UnserializedMessageContext<
            UserType, DecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::base::TimeDelta duration;
  
  bool is_end_of_stream;
  
  uint32_t data_size;
  
  bool is_key_frame;
  
  WTF::Vector<uint8_t> side_data;
  
  DecryptConfigPtr decrypt_config;
  
  ::base::TimeDelta front_discard;
  
  ::base::TimeDelta back_discard;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DecoderBuffer);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AudioBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioBuffer, T>::value>;
  using DataView = AudioBufferDataView;
  using Data_ = internal::AudioBuffer_Data;

  template <typename... Args>
  static AudioBufferPtr New(Args&&... args) {
    return AudioBufferPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioBufferPtr From(const U& u) {
    return mojo::TypeConverter<AudioBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioBuffer>::Convert(*this);
  }


  AudioBuffer();

  AudioBuffer(
      SampleFormat sample_format,
      ChannelLayout channel_layout,
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      bool end_of_stream,
      ::base::TimeDelta timestamp,
      WTF::Vector<uint8_t> data);

  ~AudioBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioBufferPtr>
  AudioBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioBuffer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AudioBuffer::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioBuffer_UnserializedMessageContext<
            UserType, AudioBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioBuffer::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  SampleFormat sample_format;
  
  ChannelLayout channel_layout;
  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  bool end_of_stream;
  
  ::base::TimeDelta timestamp;
  
  WTF::Vector<uint8_t> data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AudioDataS16 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDataS16, T>::value>;
  using DataView = AudioDataS16DataView;
  using Data_ = internal::AudioDataS16_Data;

  template <typename... Args>
  static AudioDataS16Ptr New(Args&&... args) {
    return AudioDataS16Ptr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDataS16Ptr From(const U& u) {
    return mojo::TypeConverter<AudioDataS16Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDataS16>::Convert(*this);
  }


  AudioDataS16();

  AudioDataS16(
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      WTF::Vector<int16_t> data);

  ~AudioDataS16();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDataS16Ptr>
  AudioDataS16Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDataS16::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDataS16::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDataS16_UnserializedMessageContext<
            UserType, AudioDataS16::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AudioDataS16::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AudioDataS16::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDataS16_UnserializedMessageContext<
            UserType, AudioDataS16::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDataS16::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  WTF::Vector<int16_t> data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameMetadata, T>::value>;
  using DataView = VideoFrameMetadataDataView;
  using Data_ = internal::VideoFrameMetadata_Data;

  template <typename... Args>
  static VideoFrameMetadataPtr New(Args&&... args) {
    return VideoFrameMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameMetadata>::Convert(*this);
  }


  VideoFrameMetadata();

  VideoFrameMetadata(
      bool allow_overlay,
      base::Optional<::base::TimeTicks> capture_begin_time,
      base::Optional<::base::TimeTicks> capture_end_time,
      bool has_capture_counter,
      int32_t capture_counter,
      const base::Optional<::gfx::Rect>& capture_update_rect,
      bool has_copy_mode,
      CopyMode copy_mode,
      bool end_of_stream,
      base::Optional<::base::TimeDelta> frame_duration,
      bool has_frame_rate,
      double frame_rate,
      bool interactive_content,
      base::Optional<::base::TimeTicks> reference_time,
      bool read_lock_fences_enabled,
      bool has_rotation,
      VideoRotation rotation,
      bool texture_owner,
      bool wants_promotion_hint,
      bool protected_video,
      bool hw_protected,
      const base::Optional<::base::UnguessableToken>& overlay_plane_id,
      bool power_efficient,
      bool has_device_scale_factor,
      double device_scale_factor,
      bool has_page_scale_factor,
      double page_scale_factor,
      bool has_root_scroll_offset_x,
      double root_scroll_offset_x,
      bool has_root_scroll_offset_y,
      double root_scroll_offset_y,
      bool has_top_controls_visible_height,
      double top_controls_visible_height,
      base::Optional<::base::TimeTicks> decode_begin_time,
      base::Optional<::base::TimeTicks> decode_end_time,
      base::Optional<::base::TimeDelta> processing_time,
      bool has_rtp_timestamp,
      double rtp_timestamp,
      base::Optional<::base::TimeTicks> receive_time,
      base::Optional<::base::TimeDelta> wallclock_frame_duration);

  ~VideoFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameMetadataPtr>
  VideoFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VideoFrameMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool allow_overlay;
  
  base::Optional<::base::TimeTicks> capture_begin_time;
  
  base::Optional<::base::TimeTicks> capture_end_time;
  
  bool has_capture_counter;
  
  int32_t capture_counter;
  
  base::Optional<::gfx::Rect> capture_update_rect;
  
  bool has_copy_mode;
  
  CopyMode copy_mode;
  
  bool end_of_stream;
  
  base::Optional<::base::TimeDelta> frame_duration;
  
  bool has_frame_rate;
  
  double frame_rate;
  
  bool interactive_content;
  
  base::Optional<::base::TimeTicks> reference_time;
  
  bool read_lock_fences_enabled;
  
  bool has_rotation;
  
  VideoRotation rotation;
  
  bool texture_owner;
  
  bool wants_promotion_hint;
  
  bool protected_video;
  
  bool hw_protected;
  
  base::Optional<::base::UnguessableToken> overlay_plane_id;
  
  bool power_efficient;
  
  bool has_device_scale_factor;
  
  double device_scale_factor;
  
  bool has_page_scale_factor;
  
  double page_scale_factor;
  
  bool has_root_scroll_offset_x;
  
  double root_scroll_offset_x;
  
  bool has_root_scroll_offset_y;
  
  double root_scroll_offset_y;
  
  bool has_top_controls_visible_height;
  
  double top_controls_visible_height;
  
  base::Optional<::base::TimeTicks> decode_begin_time;
  
  base::Optional<::base::TimeTicks> decode_end_time;
  
  base::Optional<::base::TimeDelta> processing_time;
  
  bool has_rtp_timestamp;
  
  double rtp_timestamp;
  
  base::Optional<::base::TimeTicks> receive_time;
  
  base::Optional<::base::TimeDelta> wallclock_frame_duration;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT VideoFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrame, T>::value>;
  using DataView = VideoFrameDataView;
  using Data_ = internal::VideoFrame_Data;

  template <typename... Args>
  static VideoFramePtr New(Args&&... args) {
    return VideoFramePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFramePtr From(const U& u) {
    return mojo::TypeConverter<VideoFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrame>::Convert(*this);
  }


  VideoFrame();

  VideoFrame(
      VideoPixelFormat format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      ::base::TimeDelta timestamp,
      VideoFrameDataPtr data,
      const ::media::VideoFrameMetadata& metadata,
      const ::gfx::ColorSpace& color_space,
      ::gl::mojom::blink::HDRMetadataPtr hdr_metadata);

  ~VideoFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFramePtr>
  VideoFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrame::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VideoFrame::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VideoPixelFormat format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  ::base::TimeDelta timestamp;
  
  VideoFrameDataPtr data;
  
  ::media::VideoFrameMetadata metadata;
  
  ::gfx::ColorSpace color_space;
  
  ::gl::mojom::blink::HDRMetadataPtr hdr_metadata;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VideoFrame);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT SharedBufferVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedBufferVideoFrameData, T>::value>;
  using DataView = SharedBufferVideoFrameDataDataView;
  using Data_ = internal::SharedBufferVideoFrameData_Data;

  template <typename... Args>
  static SharedBufferVideoFrameDataPtr New(Args&&... args) {
    return SharedBufferVideoFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedBufferVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<SharedBufferVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedBufferVideoFrameData>::Convert(*this);
  }


  SharedBufferVideoFrameData();

  SharedBufferVideoFrameData(
      ::mojo::ScopedSharedBufferHandle frame_data,
      uint64_t frame_data_size,
      WTF::Vector<int32_t> strides,
      WTF::Vector<uint32_t> offsets);

  ~SharedBufferVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedBufferVideoFrameDataPtr>
  SharedBufferVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedBufferVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedBufferVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedBufferVideoFrameData_UnserializedMessageContext<
            UserType, SharedBufferVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SharedBufferVideoFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SharedBufferVideoFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedBufferVideoFrameData_UnserializedMessageContext<
            UserType, SharedBufferVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedBufferVideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::ScopedSharedBufferHandle frame_data;
  
  uint64_t frame_data_size;
  
  WTF::Vector<int32_t> strides;
  
  WTF::Vector<uint32_t> offsets;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SharedBufferVideoFrameData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DmabufVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DmabufVideoFrameData, T>::value>;
  using DataView = DmabufVideoFrameDataDataView;
  using Data_ = internal::DmabufVideoFrameData_Data;

  template <typename... Args>
  static DmabufVideoFrameDataPtr New(Args&&... args) {
    return DmabufVideoFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DmabufVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<DmabufVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DmabufVideoFrameData>::Convert(*this);
  }


  DmabufVideoFrameData();

  explicit DmabufVideoFrameData(
      WTF::Vector<::mojo::PlatformHandle> dmabuf_fds);

  ~DmabufVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DmabufVideoFrameDataPtr>
  DmabufVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DmabufVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DmabufVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DmabufVideoFrameData_UnserializedMessageContext<
            UserType, DmabufVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DmabufVideoFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DmabufVideoFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DmabufVideoFrameData_UnserializedMessageContext<
            UserType, DmabufVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DmabufVideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<::mojo::PlatformHandle> dmabuf_fds;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DmabufVideoFrameData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GpuMemoryBufferVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuMemoryBufferVideoFrameData, T>::value>;
  using DataView = GpuMemoryBufferVideoFrameDataDataView;
  using Data_ = internal::GpuMemoryBufferVideoFrameData_Data;

  template <typename... Args>
  static GpuMemoryBufferVideoFrameDataPtr New(Args&&... args) {
    return GpuMemoryBufferVideoFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuMemoryBufferVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferVideoFrameData>::Convert(*this);
  }


  GpuMemoryBufferVideoFrameData();

  GpuMemoryBufferVideoFrameData(
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle,
      WTF::Vector<::gpu::MailboxHolder> mailbox_holder);

  ~GpuMemoryBufferVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuMemoryBufferVideoFrameDataPtr>
  GpuMemoryBufferVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuMemoryBufferVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuMemoryBufferVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<GpuMemoryBufferVideoFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return GpuMemoryBufferVideoFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuMemoryBufferVideoFrameData_UnserializedMessageContext<
            UserType, GpuMemoryBufferVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuMemoryBufferVideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle;
  
  WTF::Vector<::gpu::MailboxHolder> mailbox_holder;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(GpuMemoryBufferVideoFrameData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT MailboxVideoFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MailboxVideoFrameData, T>::value>;
  using DataView = MailboxVideoFrameDataDataView;
  using Data_ = internal::MailboxVideoFrameData_Data;

  template <typename... Args>
  static MailboxVideoFrameDataPtr New(Args&&... args) {
    return MailboxVideoFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MailboxVideoFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<MailboxVideoFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MailboxVideoFrameData>::Convert(*this);
  }


  MailboxVideoFrameData();

  MailboxVideoFrameData(
      WTF::Vector<::gpu::MailboxHolder> mailbox_holder,
      ::gpu::mojom::blink::VulkanYCbCrInfoPtr ycbcr_data);

  ~MailboxVideoFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MailboxVideoFrameDataPtr>
  MailboxVideoFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MailboxVideoFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MailboxVideoFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MailboxVideoFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MailboxVideoFrameData_UnserializedMessageContext<
            UserType, MailboxVideoFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MailboxVideoFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MailboxVideoFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MailboxVideoFrameData_UnserializedMessageContext<
            UserType, MailboxVideoFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MailboxVideoFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<::gpu::MailboxHolder> mailbox_holder;
  
  ::gpu::mojom::blink::VulkanYCbCrInfoPtr ycbcr_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(MailboxVideoFrameData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MailboxVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MailboxVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MailboxVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MailboxVideoFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PipelineStatistics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PipelineStatistics, T>::value>;
  using DataView = PipelineStatisticsDataView;
  using Data_ = internal::PipelineStatistics_Data;

  template <typename... Args>
  static PipelineStatisticsPtr New(Args&&... args) {
    return PipelineStatisticsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PipelineStatisticsPtr From(const U& u) {
    return mojo::TypeConverter<PipelineStatisticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PipelineStatistics>::Convert(*this);
  }


  PipelineStatistics();

  PipelineStatistics(
      uint64_t audio_bytes_decoded,
      uint64_t video_bytes_decoded,
      uint32_t video_frames_decoded,
      uint32_t video_frames_dropped,
      int64_t audio_memory_usage,
      int64_t video_memory_usage);

  ~PipelineStatistics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PipelineStatisticsPtr>
  PipelineStatisticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PipelineStatistics::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PipelineStatistics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PipelineStatistics::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PipelineStatistics_UnserializedMessageContext<
            UserType, PipelineStatistics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PipelineStatistics::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t audio_bytes_decoded;
  
  uint64_t video_bytes_decoded;
  
  uint32_t video_frames_decoded;
  
  uint32_t video_frames_dropped;
  
  int64_t audio_memory_usage;
  
  int64_t video_memory_usage;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PipelineStatistics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PredictionFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PredictionFeatures, T>::value>;
  using DataView = PredictionFeaturesDataView;
  using Data_ = internal::PredictionFeatures_Data;

  template <typename... Args>
  static PredictionFeaturesPtr New(Args&&... args) {
    return PredictionFeaturesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PredictionFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<PredictionFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PredictionFeatures>::Convert(*this);
  }


  PredictionFeatures();

  PredictionFeatures(
      VideoCodecProfile profile,
      const ::gfx::Size& video_size,
      double frames_per_sec,
      const WTF::String& key_system,
      bool use_hw_secure_codecs);

  ~PredictionFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PredictionFeaturesPtr>
  PredictionFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PredictionFeatures::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PredictionFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PredictionFeatures::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PredictionFeatures_UnserializedMessageContext<
            UserType, PredictionFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PredictionFeatures::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VideoCodecProfile profile;
  
  ::gfx::Size video_size;
  
  double frames_per_sec;
  
  WTF::String key_system;
  
  bool use_hw_secure_codecs;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT Status {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Status, T>::value>;
  using DataView = StatusDataView;
  using Data_ = internal::Status_Data;

  template <typename... Args>
  static StatusPtr New(Args&&... args) {
    return StatusPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StatusPtr From(const U& u) {
    return mojo::TypeConverter<StatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Status>::Convert(*this);
  }


  Status();

  Status(
      StatusCode code,
      const WTF::String& message,
      WTF::Vector<::base::Value> frames,
      WTF::Vector<StatusPtr> causes,
      base::Optional<::base::Value> data);

  ~Status();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StatusPtr>
  StatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Status::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Status::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Status::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Status_UnserializedMessageContext<
            UserType, Status::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Status::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Status::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Status_UnserializedMessageContext<
            UserType, Status::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Status::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  StatusCode code;
  
  WTF::String message;
  
  WTF::Vector<::base::Value> frames;
  
  WTF::Vector<StatusPtr> causes;
  
  base::Optional<::base::Value> data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(Status);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
VideoFrameDataPtr VideoFrameData::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::EOS_DATA:
      rv->set_eos_data(mojo::Clone(*data_.eos_data));
      break;
    case Tag::SHARED_BUFFER_DATA:
      rv->set_shared_buffer_data(mojo::Clone(*data_.shared_buffer_data));
      break;
    case Tag::DMABUF_DATA:
      rv->set_dmabuf_data(mojo::Clone(*data_.dmabuf_data));
      break;
    case Tag::GPU_MEMORY_BUFFER_DATA:
      rv->set_gpu_memory_buffer_data(mojo::Clone(*data_.gpu_memory_buffer_data));
      break;
    case Tag::MAILBOX_DATA:
      rv->set_mailbox_data(mojo::Clone(*data_.mailbox_data));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoFrameData>::value>::type*>
bool VideoFrameData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::EOS_DATA:
      return mojo::Equals(*(data_.eos_data), *(other.data_.eos_data));
    case Tag::SHARED_BUFFER_DATA:
      return mojo::Equals(*(data_.shared_buffer_data), *(other.data_.shared_buffer_data));
    case Tag::DMABUF_DATA:
      return mojo::Equals(*(data_.dmabuf_data), *(other.data_.dmabuf_data));
    case Tag::GPU_MEMORY_BUFFER_DATA:
      return mojo::Equals(*(data_.gpu_memory_buffer_data), *(other.data_.gpu_memory_buffer_data));
    case Tag::MAILBOX_DATA:
      return mojo::Equals(*(data_.mailbox_data), *(other.data_.mailbox_data));
  }

  return false;
}
template <typename StructPtrType>
VideoTransformationPtr VideoTransformation::Clone() const {
  return New(
      mojo::Clone(rotation),
      mojo::Clone(mirrored)
  );
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool VideoTransformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->mirrored, other_struct.mirrored))
    return false;
  return true;
}

template <typename T, VideoTransformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.rotation, rhs.rotation))
    return true;
  if (std::less<>{}(rhs.rotation, lhs.rotation))
    return false;
  if (std::less<>{}(lhs.mirrored, rhs.mirrored))
    return true;
  if (std::less<>{}(rhs.mirrored, lhs.mirrored))
    return false;
  return false;
}
template <typename StructPtrType>
EncryptionPatternPtr EncryptionPattern::Clone() const {
  return New(
      mojo::Clone(crypt_byte_block),
      mojo::Clone(skip_byte_block)
  );
}

template <typename T, EncryptionPattern::EnableIfSame<T>*>
bool EncryptionPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->crypt_byte_block, other_struct.crypt_byte_block))
    return false;
  if (!mojo::Equals(this->skip_byte_block, other_struct.skip_byte_block))
    return false;
  return true;
}

template <typename T, EncryptionPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.crypt_byte_block, rhs.crypt_byte_block))
    return true;
  if (std::less<>{}(rhs.crypt_byte_block, lhs.crypt_byte_block))
    return false;
  if (std::less<>{}(lhs.skip_byte_block, rhs.skip_byte_block))
    return true;
  if (std::less<>{}(rhs.skip_byte_block, lhs.skip_byte_block))
    return false;
  return false;
}
template <typename StructPtrType>
VideoColorSpacePtr VideoColorSpace::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(transfer),
      mojo::Clone(matrix),
      mojo::Clone(range)
  );
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool VideoColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->transfer, other_struct.transfer))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  return true;
}

template <typename T, VideoColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.primaries, rhs.primaries))
    return true;
  if (std::less<>{}(rhs.primaries, lhs.primaries))
    return false;
  if (std::less<>{}(lhs.transfer, rhs.transfer))
    return true;
  if (std::less<>{}(rhs.transfer, lhs.transfer))
    return false;
  if (std::less<>{}(lhs.matrix, rhs.matrix))
    return true;
  if (std::less<>{}(rhs.matrix, lhs.matrix))
    return false;
  if (std::less<>{}(lhs.range, rhs.range))
    return true;
  if (std::less<>{}(rhs.range, lhs.range))
    return false;
  return false;
}
template <typename StructPtrType>
AudioDecoderConfigPtr AudioDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile),
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(samples_per_second),
      mojo::Clone(extra_data),
      mojo::Clone(seek_preroll),
      mojo::Clone(codec_delay),
      mojo::Clone(encryption_scheme)
  );
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool AudioDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->samples_per_second, other_struct.samples_per_second))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->seek_preroll, other_struct.seek_preroll))
    return false;
  if (!mojo::Equals(this->codec_delay, other_struct.codec_delay))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  return true;
}

template <typename T, AudioDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.codec, rhs.codec))
    return true;
  if (std::less<>{}(rhs.codec, lhs.codec))
    return false;
  if (std::less<>{}(lhs.profile, rhs.profile))
    return true;
  if (std::less<>{}(rhs.profile, lhs.profile))
    return false;
  if (std::less<>{}(lhs.sample_format, rhs.sample_format))
    return true;
  if (std::less<>{}(rhs.sample_format, lhs.sample_format))
    return false;
  if (std::less<>{}(lhs.channel_layout, rhs.channel_layout))
    return true;
  if (std::less<>{}(rhs.channel_layout, lhs.channel_layout))
    return false;
  if (std::less<>{}(lhs.samples_per_second, rhs.samples_per_second))
    return true;
  if (std::less<>{}(rhs.samples_per_second, lhs.samples_per_second))
    return false;
  if (std::less<>{}(lhs.extra_data, rhs.extra_data))
    return true;
  if (std::less<>{}(rhs.extra_data, lhs.extra_data))
    return false;
  if (std::less<>{}(lhs.seek_preroll, rhs.seek_preroll))
    return true;
  if (std::less<>{}(rhs.seek_preroll, lhs.seek_preroll))
    return false;
  if (std::less<>{}(lhs.codec_delay, rhs.codec_delay))
    return true;
  if (std::less<>{}(rhs.codec_delay, lhs.codec_delay))
    return false;
  if (std::less<>{}(lhs.encryption_scheme, rhs.encryption_scheme))
    return true;
  if (std::less<>{}(rhs.encryption_scheme, lhs.encryption_scheme))
    return false;
  return false;
}
template <typename StructPtrType>
VideoDecoderConfigPtr VideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile),
      mojo::Clone(level),
      mojo::Clone(has_alpha),
      mojo::Clone(transformation),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(color_space_info),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool VideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->level, other_struct.level))
    return false;
  if (!mojo::Equals(this->has_alpha, other_struct.has_alpha))
    return false;
  if (!mojo::Equals(this->transformation, other_struct.transformation))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->color_space_info, other_struct.color_space_info))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.codec, rhs.codec))
    return true;
  if (std::less<>{}(rhs.codec, lhs.codec))
    return false;
  if (std::less<>{}(lhs.profile, rhs.profile))
    return true;
  if (std::less<>{}(rhs.profile, lhs.profile))
    return false;
  if (std::less<>{}(lhs.level, rhs.level))
    return true;
  if (std::less<>{}(rhs.level, lhs.level))
    return false;
  if (std::less<>{}(lhs.has_alpha, rhs.has_alpha))
    return true;
  if (std::less<>{}(rhs.has_alpha, lhs.has_alpha))
    return false;
  if (std::less<>{}(lhs.transformation, rhs.transformation))
    return true;
  if (std::less<>{}(rhs.transformation, lhs.transformation))
    return false;
  if (std::less<>{}(lhs.coded_size, rhs.coded_size))
    return true;
  if (std::less<>{}(rhs.coded_size, lhs.coded_size))
    return false;
  if (std::less<>{}(lhs.visible_rect, rhs.visible_rect))
    return true;
  if (std::less<>{}(rhs.visible_rect, lhs.visible_rect))
    return false;
  if (std::less<>{}(lhs.natural_size, rhs.natural_size))
    return true;
  if (std::less<>{}(rhs.natural_size, lhs.natural_size))
    return false;
  if (std::less<>{}(lhs.extra_data, rhs.extra_data))
    return true;
  if (std::less<>{}(rhs.extra_data, lhs.extra_data))
    return false;
  if (std::less<>{}(lhs.encryption_scheme, rhs.encryption_scheme))
    return true;
  if (std::less<>{}(rhs.encryption_scheme, lhs.encryption_scheme))
    return false;
  if (std::less<>{}(lhs.color_space_info, rhs.color_space_info))
    return true;
  if (std::less<>{}(rhs.color_space_info, lhs.color_space_info))
    return false;
  if (std::less<>{}(lhs.hdr_metadata, rhs.hdr_metadata))
    return true;
  if (std::less<>{}(rhs.hdr_metadata, lhs.hdr_metadata))
    return false;
  return false;
}
template <typename StructPtrType>
DecryptConfigPtr DecryptConfig::Clone() const {
  return New(
      mojo::Clone(encryption_scheme),
      mojo::Clone(key_id),
      mojo::Clone(iv),
      mojo::Clone(subsamples),
      mojo::Clone(encryption_pattern)
  );
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool DecryptConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->iv, other_struct.iv))
    return false;
  if (!mojo::Equals(this->subsamples, other_struct.subsamples))
    return false;
  if (!mojo::Equals(this->encryption_pattern, other_struct.encryption_pattern))
    return false;
  return true;
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.encryption_scheme, rhs.encryption_scheme))
    return true;
  if (std::less<>{}(rhs.encryption_scheme, lhs.encryption_scheme))
    return false;
  if (std::less<>{}(lhs.key_id, rhs.key_id))
    return true;
  if (std::less<>{}(rhs.key_id, lhs.key_id))
    return false;
  if (std::less<>{}(lhs.iv, rhs.iv))
    return true;
  if (std::less<>{}(rhs.iv, lhs.iv))
    return false;
  if (std::less<>{}(lhs.subsamples, rhs.subsamples))
    return true;
  if (std::less<>{}(rhs.subsamples, lhs.subsamples))
    return false;
  if (std::less<>{}(lhs.encryption_pattern, rhs.encryption_pattern))
    return true;
  if (std::less<>{}(rhs.encryption_pattern, lhs.encryption_pattern))
    return false;
  return false;
}
template <typename StructPtrType>
DecoderBufferPtr DecoderBuffer::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(duration),
      mojo::Clone(is_end_of_stream),
      mojo::Clone(data_size),
      mojo::Clone(is_key_frame),
      mojo::Clone(side_data),
      mojo::Clone(decrypt_config),
      mojo::Clone(front_discard),
      mojo::Clone(back_discard)
  );
}

template <typename T, DecoderBuffer::EnableIfSame<T>*>
bool DecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->is_end_of_stream, other_struct.is_end_of_stream))
    return false;
  if (!mojo::Equals(this->data_size, other_struct.data_size))
    return false;
  if (!mojo::Equals(this->is_key_frame, other_struct.is_key_frame))
    return false;
  if (!mojo::Equals(this->side_data, other_struct.side_data))
    return false;
  if (!mojo::Equals(this->decrypt_config, other_struct.decrypt_config))
    return false;
  if (!mojo::Equals(this->front_discard, other_struct.front_discard))
    return false;
  if (!mojo::Equals(this->back_discard, other_struct.back_discard))
    return false;
  return true;
}

template <typename T, DecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.duration, rhs.duration))
    return true;
  if (std::less<>{}(rhs.duration, lhs.duration))
    return false;
  if (std::less<>{}(lhs.is_end_of_stream, rhs.is_end_of_stream))
    return true;
  if (std::less<>{}(rhs.is_end_of_stream, lhs.is_end_of_stream))
    return false;
  if (std::less<>{}(lhs.data_size, rhs.data_size))
    return true;
  if (std::less<>{}(rhs.data_size, lhs.data_size))
    return false;
  if (std::less<>{}(lhs.is_key_frame, rhs.is_key_frame))
    return true;
  if (std::less<>{}(rhs.is_key_frame, lhs.is_key_frame))
    return false;
  if (std::less<>{}(lhs.side_data, rhs.side_data))
    return true;
  if (std::less<>{}(rhs.side_data, lhs.side_data))
    return false;
  if (std::less<>{}(lhs.decrypt_config, rhs.decrypt_config))
    return true;
  if (std::less<>{}(rhs.decrypt_config, lhs.decrypt_config))
    return false;
  if (std::less<>{}(lhs.front_discard, rhs.front_discard))
    return true;
  if (std::less<>{}(rhs.front_discard, lhs.front_discard))
    return false;
  if (std::less<>{}(lhs.back_discard, rhs.back_discard))
    return true;
  if (std::less<>{}(rhs.back_discard, lhs.back_discard))
    return false;
  return false;
}
template <typename StructPtrType>
AudioBufferPtr AudioBuffer::Clone() const {
  return New(
      mojo::Clone(sample_format),
      mojo::Clone(channel_layout),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(end_of_stream),
      mojo::Clone(timestamp),
      mojo::Clone(data)
  );
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool AudioBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sample_format, other_struct.sample_format))
    return false;
  if (!mojo::Equals(this->channel_layout, other_struct.channel_layout))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.sample_format, rhs.sample_format))
    return true;
  if (std::less<>{}(rhs.sample_format, lhs.sample_format))
    return false;
  if (std::less<>{}(lhs.channel_layout, rhs.channel_layout))
    return true;
  if (std::less<>{}(rhs.channel_layout, lhs.channel_layout))
    return false;
  if (std::less<>{}(lhs.channel_count, rhs.channel_count))
    return true;
  if (std::less<>{}(rhs.channel_count, lhs.channel_count))
    return false;
  if (std::less<>{}(lhs.sample_rate, rhs.sample_rate))
    return true;
  if (std::less<>{}(rhs.sample_rate, lhs.sample_rate))
    return false;
  if (std::less<>{}(lhs.frame_count, rhs.frame_count))
    return true;
  if (std::less<>{}(rhs.frame_count, lhs.frame_count))
    return false;
  if (std::less<>{}(lhs.end_of_stream, rhs.end_of_stream))
    return true;
  if (std::less<>{}(rhs.end_of_stream, lhs.end_of_stream))
    return false;
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  return false;
}
template <typename StructPtrType>
AudioDataS16Ptr AudioDataS16::Clone() const {
  return New(
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(data)
  );
}

template <typename T, AudioDataS16::EnableIfSame<T>*>
bool AudioDataS16::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioDataS16::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.channel_count, rhs.channel_count))
    return true;
  if (std::less<>{}(rhs.channel_count, lhs.channel_count))
    return false;
  if (std::less<>{}(lhs.sample_rate, rhs.sample_rate))
    return true;
  if (std::less<>{}(rhs.sample_rate, lhs.sample_rate))
    return false;
  if (std::less<>{}(lhs.frame_count, rhs.frame_count))
    return true;
  if (std::less<>{}(rhs.frame_count, lhs.frame_count))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameMetadataPtr VideoFrameMetadata::Clone() const {
  return New(
      mojo::Clone(allow_overlay),
      mojo::Clone(capture_begin_time),
      mojo::Clone(capture_end_time),
      mojo::Clone(has_capture_counter),
      mojo::Clone(capture_counter),
      mojo::Clone(capture_update_rect),
      mojo::Clone(has_copy_mode),
      mojo::Clone(copy_mode),
      mojo::Clone(end_of_stream),
      mojo::Clone(frame_duration),
      mojo::Clone(has_frame_rate),
      mojo::Clone(frame_rate),
      mojo::Clone(interactive_content),
      mojo::Clone(reference_time),
      mojo::Clone(read_lock_fences_enabled),
      mojo::Clone(has_rotation),
      mojo::Clone(rotation),
      mojo::Clone(texture_owner),
      mojo::Clone(wants_promotion_hint),
      mojo::Clone(protected_video),
      mojo::Clone(hw_protected),
      mojo::Clone(overlay_plane_id),
      mojo::Clone(power_efficient),
      mojo::Clone(has_device_scale_factor),
      mojo::Clone(device_scale_factor),
      mojo::Clone(has_page_scale_factor),
      mojo::Clone(page_scale_factor),
      mojo::Clone(has_root_scroll_offset_x),
      mojo::Clone(root_scroll_offset_x),
      mojo::Clone(has_root_scroll_offset_y),
      mojo::Clone(root_scroll_offset_y),
      mojo::Clone(has_top_controls_visible_height),
      mojo::Clone(top_controls_visible_height),
      mojo::Clone(decode_begin_time),
      mojo::Clone(decode_end_time),
      mojo::Clone(processing_time),
      mojo::Clone(has_rtp_timestamp),
      mojo::Clone(rtp_timestamp),
      mojo::Clone(receive_time),
      mojo::Clone(wallclock_frame_duration)
  );
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool VideoFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_overlay, other_struct.allow_overlay))
    return false;
  if (!mojo::Equals(this->capture_begin_time, other_struct.capture_begin_time))
    return false;
  if (!mojo::Equals(this->capture_end_time, other_struct.capture_end_time))
    return false;
  if (!mojo::Equals(this->has_capture_counter, other_struct.has_capture_counter))
    return false;
  if (!mojo::Equals(this->capture_counter, other_struct.capture_counter))
    return false;
  if (!mojo::Equals(this->capture_update_rect, other_struct.capture_update_rect))
    return false;
  if (!mojo::Equals(this->has_copy_mode, other_struct.has_copy_mode))
    return false;
  if (!mojo::Equals(this->copy_mode, other_struct.copy_mode))
    return false;
  if (!mojo::Equals(this->end_of_stream, other_struct.end_of_stream))
    return false;
  if (!mojo::Equals(this->frame_duration, other_struct.frame_duration))
    return false;
  if (!mojo::Equals(this->has_frame_rate, other_struct.has_frame_rate))
    return false;
  if (!mojo::Equals(this->frame_rate, other_struct.frame_rate))
    return false;
  if (!mojo::Equals(this->interactive_content, other_struct.interactive_content))
    return false;
  if (!mojo::Equals(this->reference_time, other_struct.reference_time))
    return false;
  if (!mojo::Equals(this->read_lock_fences_enabled, other_struct.read_lock_fences_enabled))
    return false;
  if (!mojo::Equals(this->has_rotation, other_struct.has_rotation))
    return false;
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->texture_owner, other_struct.texture_owner))
    return false;
  if (!mojo::Equals(this->wants_promotion_hint, other_struct.wants_promotion_hint))
    return false;
  if (!mojo::Equals(this->protected_video, other_struct.protected_video))
    return false;
  if (!mojo::Equals(this->hw_protected, other_struct.hw_protected))
    return false;
  if (!mojo::Equals(this->overlay_plane_id, other_struct.overlay_plane_id))
    return false;
  if (!mojo::Equals(this->power_efficient, other_struct.power_efficient))
    return false;
  if (!mojo::Equals(this->has_device_scale_factor, other_struct.has_device_scale_factor))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->has_page_scale_factor, other_struct.has_page_scale_factor))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_x, other_struct.has_root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_x, other_struct.root_scroll_offset_x))
    return false;
  if (!mojo::Equals(this->has_root_scroll_offset_y, other_struct.has_root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->root_scroll_offset_y, other_struct.root_scroll_offset_y))
    return false;
  if (!mojo::Equals(this->has_top_controls_visible_height, other_struct.has_top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height, other_struct.top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->decode_begin_time, other_struct.decode_begin_time))
    return false;
  if (!mojo::Equals(this->decode_end_time, other_struct.decode_end_time))
    return false;
  if (!mojo::Equals(this->processing_time, other_struct.processing_time))
    return false;
  if (!mojo::Equals(this->has_rtp_timestamp, other_struct.has_rtp_timestamp))
    return false;
  if (!mojo::Equals(this->rtp_timestamp, other_struct.rtp_timestamp))
    return false;
  if (!mojo::Equals(this->receive_time, other_struct.receive_time))
    return false;
  if (!mojo::Equals(this->wallclock_frame_duration, other_struct.wallclock_frame_duration))
    return false;
  return true;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.allow_overlay, rhs.allow_overlay))
    return true;
  if (std::less<>{}(rhs.allow_overlay, lhs.allow_overlay))
    return false;
  if (std::less<>{}(lhs.capture_begin_time, rhs.capture_begin_time))
    return true;
  if (std::less<>{}(rhs.capture_begin_time, lhs.capture_begin_time))
    return false;
  if (std::less<>{}(lhs.capture_end_time, rhs.capture_end_time))
    return true;
  if (std::less<>{}(rhs.capture_end_time, lhs.capture_end_time))
    return false;
  if (std::less<>{}(lhs.has_capture_counter, rhs.has_capture_counter))
    return true;
  if (std::less<>{}(rhs.has_capture_counter, lhs.has_capture_counter))
    return false;
  if (std::less<>{}(lhs.capture_counter, rhs.capture_counter))
    return true;
  if (std::less<>{}(rhs.capture_counter, lhs.capture_counter))
    return false;
  if (std::less<>{}(lhs.capture_update_rect, rhs.capture_update_rect))
    return true;
  if (std::less<>{}(rhs.capture_update_rect, lhs.capture_update_rect))
    return false;
  if (std::less<>{}(lhs.has_copy_mode, rhs.has_copy_mode))
    return true;
  if (std::less<>{}(rhs.has_copy_mode, lhs.has_copy_mode))
    return false;
  if (std::less<>{}(lhs.copy_mode, rhs.copy_mode))
    return true;
  if (std::less<>{}(rhs.copy_mode, lhs.copy_mode))
    return false;
  if (std::less<>{}(lhs.end_of_stream, rhs.end_of_stream))
    return true;
  if (std::less<>{}(rhs.end_of_stream, lhs.end_of_stream))
    return false;
  if (std::less<>{}(lhs.frame_duration, rhs.frame_duration))
    return true;
  if (std::less<>{}(rhs.frame_duration, lhs.frame_duration))
    return false;
  if (std::less<>{}(lhs.has_frame_rate, rhs.has_frame_rate))
    return true;
  if (std::less<>{}(rhs.has_frame_rate, lhs.has_frame_rate))
    return false;
  if (std::less<>{}(lhs.frame_rate, rhs.frame_rate))
    return true;
  if (std::less<>{}(rhs.frame_rate, lhs.frame_rate))
    return false;
  if (std::less<>{}(lhs.interactive_content, rhs.interactive_content))
    return true;
  if (std::less<>{}(rhs.interactive_content, lhs.interactive_content))
    return false;
  if (std::less<>{}(lhs.reference_time, rhs.reference_time))
    return true;
  if (std::less<>{}(rhs.reference_time, lhs.reference_time))
    return false;
  if (std::less<>{}(lhs.read_lock_fences_enabled, rhs.read_lock_fences_enabled))
    return true;
  if (std::less<>{}(rhs.read_lock_fences_enabled, lhs.read_lock_fences_enabled))
    return false;
  if (std::less<>{}(lhs.has_rotation, rhs.has_rotation))
    return true;
  if (std::less<>{}(rhs.has_rotation, lhs.has_rotation))
    return false;
  if (std::less<>{}(lhs.rotation, rhs.rotation))
    return true;
  if (std::less<>{}(rhs.rotation, lhs.rotation))
    return false;
  if (std::less<>{}(lhs.texture_owner, rhs.texture_owner))
    return true;
  if (std::less<>{}(rhs.texture_owner, lhs.texture_owner))
    return false;
  if (std::less<>{}(lhs.wants_promotion_hint, rhs.wants_promotion_hint))
    return true;
  if (std::less<>{}(rhs.wants_promotion_hint, lhs.wants_promotion_hint))
    return false;
  if (std::less<>{}(lhs.protected_video, rhs.protected_video))
    return true;
  if (std::less<>{}(rhs.protected_video, lhs.protected_video))
    return false;
  if (std::less<>{}(lhs.hw_protected, rhs.hw_protected))
    return true;
  if (std::less<>{}(rhs.hw_protected, lhs.hw_protected))
    return false;
  if (std::less<>{}(lhs.overlay_plane_id, rhs.overlay_plane_id))
    return true;
  if (std::less<>{}(rhs.overlay_plane_id, lhs.overlay_plane_id))
    return false;
  if (std::less<>{}(lhs.power_efficient, rhs.power_efficient))
    return true;
  if (std::less<>{}(rhs.power_efficient, lhs.power_efficient))
    return false;
  if (std::less<>{}(lhs.has_device_scale_factor, rhs.has_device_scale_factor))
    return true;
  if (std::less<>{}(rhs.has_device_scale_factor, lhs.has_device_scale_factor))
    return false;
  if (std::less<>{}(lhs.device_scale_factor, rhs.device_scale_factor))
    return true;
  if (std::less<>{}(rhs.device_scale_factor, lhs.device_scale_factor))
    return false;
  if (std::less<>{}(lhs.has_page_scale_factor, rhs.has_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.has_page_scale_factor, lhs.has_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.has_root_scroll_offset_x, rhs.has_root_scroll_offset_x))
    return true;
  if (std::less<>{}(rhs.has_root_scroll_offset_x, lhs.has_root_scroll_offset_x))
    return false;
  if (std::less<>{}(lhs.root_scroll_offset_x, rhs.root_scroll_offset_x))
    return true;
  if (std::less<>{}(rhs.root_scroll_offset_x, lhs.root_scroll_offset_x))
    return false;
  if (std::less<>{}(lhs.has_root_scroll_offset_y, rhs.has_root_scroll_offset_y))
    return true;
  if (std::less<>{}(rhs.has_root_scroll_offset_y, lhs.has_root_scroll_offset_y))
    return false;
  if (std::less<>{}(lhs.root_scroll_offset_y, rhs.root_scroll_offset_y))
    return true;
  if (std::less<>{}(rhs.root_scroll_offset_y, lhs.root_scroll_offset_y))
    return false;
  if (std::less<>{}(lhs.has_top_controls_visible_height, rhs.has_top_controls_visible_height))
    return true;
  if (std::less<>{}(rhs.has_top_controls_visible_height, lhs.has_top_controls_visible_height))
    return false;
  if (std::less<>{}(lhs.top_controls_visible_height, rhs.top_controls_visible_height))
    return true;
  if (std::less<>{}(rhs.top_controls_visible_height, lhs.top_controls_visible_height))
    return false;
  if (std::less<>{}(lhs.decode_begin_time, rhs.decode_begin_time))
    return true;
  if (std::less<>{}(rhs.decode_begin_time, lhs.decode_begin_time))
    return false;
  if (std::less<>{}(lhs.decode_end_time, rhs.decode_end_time))
    return true;
  if (std::less<>{}(rhs.decode_end_time, lhs.decode_end_time))
    return false;
  if (std::less<>{}(lhs.processing_time, rhs.processing_time))
    return true;
  if (std::less<>{}(rhs.processing_time, lhs.processing_time))
    return false;
  if (std::less<>{}(lhs.has_rtp_timestamp, rhs.has_rtp_timestamp))
    return true;
  if (std::less<>{}(rhs.has_rtp_timestamp, lhs.has_rtp_timestamp))
    return false;
  if (std::less<>{}(lhs.rtp_timestamp, rhs.rtp_timestamp))
    return true;
  if (std::less<>{}(rhs.rtp_timestamp, lhs.rtp_timestamp))
    return false;
  if (std::less<>{}(lhs.receive_time, rhs.receive_time))
    return true;
  if (std::less<>{}(rhs.receive_time, lhs.receive_time))
    return false;
  if (std::less<>{}(lhs.wallclock_frame_duration, rhs.wallclock_frame_duration))
    return true;
  if (std::less<>{}(rhs.wallclock_frame_duration, lhs.wallclock_frame_duration))
    return false;
  return false;
}
template <typename StructPtrType>
VideoFramePtr VideoFrame::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(timestamp),
      mojo::Clone(data),
      mojo::Clone(metadata),
      mojo::Clone(color_space),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool VideoFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.format, rhs.format))
    return true;
  if (std::less<>{}(rhs.format, lhs.format))
    return false;
  if (std::less<>{}(lhs.coded_size, rhs.coded_size))
    return true;
  if (std::less<>{}(rhs.coded_size, lhs.coded_size))
    return false;
  if (std::less<>{}(lhs.visible_rect, rhs.visible_rect))
    return true;
  if (std::less<>{}(rhs.visible_rect, lhs.visible_rect))
    return false;
  if (std::less<>{}(lhs.natural_size, rhs.natural_size))
    return true;
  if (std::less<>{}(rhs.natural_size, lhs.natural_size))
    return false;
  if (std::less<>{}(lhs.timestamp, rhs.timestamp))
    return true;
  if (std::less<>{}(rhs.timestamp, lhs.timestamp))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  if (std::less<>{}(lhs.metadata, rhs.metadata))
    return true;
  if (std::less<>{}(rhs.metadata, lhs.metadata))
    return false;
  if (std::less<>{}(lhs.color_space, rhs.color_space))
    return true;
  if (std::less<>{}(rhs.color_space, lhs.color_space))
    return false;
  if (std::less<>{}(lhs.hdr_metadata, rhs.hdr_metadata))
    return true;
  if (std::less<>{}(rhs.hdr_metadata, lhs.hdr_metadata))
    return false;
  return false;
}
template <typename StructPtrType>
EosVideoFrameDataPtr EosVideoFrameData::Clone() const {
  return New(
  );
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool EosVideoFrameData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EosVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
SharedBufferVideoFrameDataPtr SharedBufferVideoFrameData::Clone() const {
  return New(
      mojo::Clone(frame_data),
      mojo::Clone(frame_data_size),
      mojo::Clone(strides),
      mojo::Clone(offsets)
  );
}

template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>*>
bool SharedBufferVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_data, other_struct.frame_data))
    return false;
  if (!mojo::Equals(this->frame_data_size, other_struct.frame_data_size))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  if (!mojo::Equals(this->offsets, other_struct.offsets))
    return false;
  return true;
}

template <typename T, SharedBufferVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_data, rhs.frame_data))
    return true;
  if (std::less<>{}(rhs.frame_data, lhs.frame_data))
    return false;
  if (std::less<>{}(lhs.frame_data_size, rhs.frame_data_size))
    return true;
  if (std::less<>{}(rhs.frame_data_size, lhs.frame_data_size))
    return false;
  if (std::less<>{}(lhs.strides, rhs.strides))
    return true;
  if (std::less<>{}(rhs.strides, lhs.strides))
    return false;
  if (std::less<>{}(lhs.offsets, rhs.offsets))
    return true;
  if (std::less<>{}(rhs.offsets, lhs.offsets))
    return false;
  return false;
}
template <typename StructPtrType>
DmabufVideoFrameDataPtr DmabufVideoFrameData::Clone() const {
  return New(
      mojo::Clone(dmabuf_fds)
  );
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>*>
bool DmabufVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dmabuf_fds, other_struct.dmabuf_fds))
    return false;
  return true;
}

template <typename T, DmabufVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.dmabuf_fds, rhs.dmabuf_fds))
    return true;
  if (std::less<>{}(rhs.dmabuf_fds, lhs.dmabuf_fds))
    return false;
  return false;
}
template <typename StructPtrType>
GpuMemoryBufferVideoFrameDataPtr GpuMemoryBufferVideoFrameData::Clone() const {
  return New(
      mojo::Clone(gpu_memory_buffer_handle),
      mojo::Clone(mailbox_holder)
  );
}

template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>*>
bool GpuMemoryBufferVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gpu_memory_buffer_handle, other_struct.gpu_memory_buffer_handle))
    return false;
  if (!mojo::Equals(this->mailbox_holder, other_struct.mailbox_holder))
    return false;
  return true;
}

template <typename T, GpuMemoryBufferVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.gpu_memory_buffer_handle, rhs.gpu_memory_buffer_handle))
    return true;
  if (std::less<>{}(rhs.gpu_memory_buffer_handle, lhs.gpu_memory_buffer_handle))
    return false;
  if (std::less<>{}(lhs.mailbox_holder, rhs.mailbox_holder))
    return true;
  if (std::less<>{}(rhs.mailbox_holder, lhs.mailbox_holder))
    return false;
  return false;
}
template <typename StructPtrType>
MailboxVideoFrameDataPtr MailboxVideoFrameData::Clone() const {
  return New(
      mojo::Clone(mailbox_holder),
      mojo::Clone(ycbcr_data)
  );
}

template <typename T, MailboxVideoFrameData::EnableIfSame<T>*>
bool MailboxVideoFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox_holder, other_struct.mailbox_holder))
    return false;
  if (!mojo::Equals(this->ycbcr_data, other_struct.ycbcr_data))
    return false;
  return true;
}

template <typename T, MailboxVideoFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mailbox_holder, rhs.mailbox_holder))
    return true;
  if (std::less<>{}(rhs.mailbox_holder, lhs.mailbox_holder))
    return false;
  if (std::less<>{}(lhs.ycbcr_data, rhs.ycbcr_data))
    return true;
  if (std::less<>{}(rhs.ycbcr_data, lhs.ycbcr_data))
    return false;
  return false;
}
template <typename StructPtrType>
PipelineStatisticsPtr PipelineStatistics::Clone() const {
  return New(
      mojo::Clone(audio_bytes_decoded),
      mojo::Clone(video_bytes_decoded),
      mojo::Clone(video_frames_decoded),
      mojo::Clone(video_frames_dropped),
      mojo::Clone(audio_memory_usage),
      mojo::Clone(video_memory_usage)
  );
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool PipelineStatistics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_bytes_decoded, other_struct.audio_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_bytes_decoded, other_struct.video_bytes_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_decoded, other_struct.video_frames_decoded))
    return false;
  if (!mojo::Equals(this->video_frames_dropped, other_struct.video_frames_dropped))
    return false;
  if (!mojo::Equals(this->audio_memory_usage, other_struct.audio_memory_usage))
    return false;
  if (!mojo::Equals(this->video_memory_usage, other_struct.video_memory_usage))
    return false;
  return true;
}

template <typename T, PipelineStatistics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.audio_bytes_decoded, rhs.audio_bytes_decoded))
    return true;
  if (std::less<>{}(rhs.audio_bytes_decoded, lhs.audio_bytes_decoded))
    return false;
  if (std::less<>{}(lhs.video_bytes_decoded, rhs.video_bytes_decoded))
    return true;
  if (std::less<>{}(rhs.video_bytes_decoded, lhs.video_bytes_decoded))
    return false;
  if (std::less<>{}(lhs.video_frames_decoded, rhs.video_frames_decoded))
    return true;
  if (std::less<>{}(rhs.video_frames_decoded, lhs.video_frames_decoded))
    return false;
  if (std::less<>{}(lhs.video_frames_dropped, rhs.video_frames_dropped))
    return true;
  if (std::less<>{}(rhs.video_frames_dropped, lhs.video_frames_dropped))
    return false;
  if (std::less<>{}(lhs.audio_memory_usage, rhs.audio_memory_usage))
    return true;
  if (std::less<>{}(rhs.audio_memory_usage, lhs.audio_memory_usage))
    return false;
  if (std::less<>{}(lhs.video_memory_usage, rhs.video_memory_usage))
    return true;
  if (std::less<>{}(rhs.video_memory_usage, lhs.video_memory_usage))
    return false;
  return false;
}
template <typename StructPtrType>
PredictionFeaturesPtr PredictionFeatures::Clone() const {
  return New(
      mojo::Clone(profile),
      mojo::Clone(video_size),
      mojo::Clone(frames_per_sec),
      mojo::Clone(key_system),
      mojo::Clone(use_hw_secure_codecs)
  );
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool PredictionFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->video_size, other_struct.video_size))
    return false;
  if (!mojo::Equals(this->frames_per_sec, other_struct.frames_per_sec))
    return false;
  if (!mojo::Equals(this->key_system, other_struct.key_system))
    return false;
  if (!mojo::Equals(this->use_hw_secure_codecs, other_struct.use_hw_secure_codecs))
    return false;
  return true;
}

template <typename T, PredictionFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.profile, rhs.profile))
    return true;
  if (std::less<>{}(rhs.profile, lhs.profile))
    return false;
  if (std::less<>{}(lhs.video_size, rhs.video_size))
    return true;
  if (std::less<>{}(rhs.video_size, lhs.video_size))
    return false;
  if (std::less<>{}(lhs.frames_per_sec, rhs.frames_per_sec))
    return true;
  if (std::less<>{}(rhs.frames_per_sec, lhs.frames_per_sec))
    return false;
  if (std::less<>{}(lhs.key_system, rhs.key_system))
    return true;
  if (std::less<>{}(rhs.key_system, lhs.key_system))
    return false;
  if (std::less<>{}(lhs.use_hw_secure_codecs, rhs.use_hw_secure_codecs))
    return true;
  if (std::less<>{}(rhs.use_hw_secure_codecs, lhs.use_hw_secure_codecs))
    return false;
  return false;
}
template <typename StructPtrType>
PredictionTargetsPtr PredictionTargets::Clone() const {
  return New(
      mojo::Clone(frames_decoded),
      mojo::Clone(frames_dropped),
      mojo::Clone(frames_power_efficient)
  );
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool PredictionTargets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frames_decoded, other_struct.frames_decoded))
    return false;
  if (!mojo::Equals(this->frames_dropped, other_struct.frames_dropped))
    return false;
  if (!mojo::Equals(this->frames_power_efficient, other_struct.frames_power_efficient))
    return false;
  return true;
}

template <typename T, PredictionTargets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frames_decoded, rhs.frames_decoded))
    return true;
  if (std::less<>{}(rhs.frames_decoded, lhs.frames_decoded))
    return false;
  if (std::less<>{}(lhs.frames_dropped, rhs.frames_dropped))
    return true;
  if (std::less<>{}(rhs.frames_dropped, lhs.frames_dropped))
    return false;
  if (std::less<>{}(lhs.frames_power_efficient, rhs.frames_power_efficient))
    return true;
  if (std::less<>{}(rhs.frames_power_efficient, lhs.frames_power_efficient))
    return false;
  return false;
}
template <typename StructPtrType>
PipelineDecoderInfoPtr PipelineDecoderInfo::Clone() const {
  return New(
      mojo::Clone(decoder_name),
      mojo::Clone(is_platform_decoder),
      mojo::Clone(has_decrypting_demuxer_stream)
  );
}

template <typename T, PipelineDecoderInfo::EnableIfSame<T>*>
bool PipelineDecoderInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoder_name, other_struct.decoder_name))
    return false;
  if (!mojo::Equals(this->is_platform_decoder, other_struct.is_platform_decoder))
    return false;
  if (!mojo::Equals(this->has_decrypting_demuxer_stream, other_struct.has_decrypting_demuxer_stream))
    return false;
  return true;
}

template <typename T, PipelineDecoderInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.decoder_name, rhs.decoder_name))
    return true;
  if (std::less<>{}(rhs.decoder_name, lhs.decoder_name))
    return false;
  if (std::less<>{}(lhs.is_platform_decoder, rhs.is_platform_decoder))
    return true;
  if (std::less<>{}(rhs.is_platform_decoder, lhs.is_platform_decoder))
    return false;
  if (std::less<>{}(lhs.has_decrypting_demuxer_stream, rhs.has_decrypting_demuxer_stream))
    return true;
  if (std::less<>{}(rhs.has_decrypting_demuxer_stream, lhs.has_decrypting_demuxer_stream))
    return false;
  return false;
}
template <typename StructPtrType>
StatusPtr Status::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(message),
      mojo::Clone(frames),
      mojo::Clone(causes),
      mojo::Clone(data)
  );
}

template <typename T, Status::EnableIfSame<T>*>
bool Status::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->frames, other_struct.frames))
    return false;
  if (!mojo::Equals(this->causes, other_struct.causes))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, Status::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.code, rhs.code))
    return true;
  if (std::less<>{}(rhs.code, lhs.code))
    return false;
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  if (std::less<>{}(lhs.frames, rhs.frames))
    return true;
  if (std::less<>{}(rhs.frames, lhs.frames))
    return false;
  if (std::less<>{}(lhs.causes, rhs.causes))
    return true;
  if (std::less<>{}(rhs.causes, lhs.causes))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoTransformation::DataView,
                                         ::media::mojom::blink::VideoTransformationPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoTransformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoTransformationPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoTransformation::rotation) rotation(
      const ::media::mojom::blink::VideoTransformationPtr& input) {
    return input->rotation;
  }

  static decltype(::media::mojom::blink::VideoTransformation::mirrored) mirrored(
      const ::media::mojom::blink::VideoTransformationPtr& input) {
    return input->mirrored;
  }

  static bool Read(::media::mojom::blink::VideoTransformation::DataView input, ::media::mojom::blink::VideoTransformationPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EncryptionPattern::DataView,
                                         ::media::mojom::blink::EncryptionPatternPtr> {
  static bool IsNull(const ::media::mojom::blink::EncryptionPatternPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EncryptionPatternPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::EncryptionPattern::crypt_byte_block) crypt_byte_block(
      const ::media::mojom::blink::EncryptionPatternPtr& input) {
    return input->crypt_byte_block;
  }

  static decltype(::media::mojom::blink::EncryptionPattern::skip_byte_block) skip_byte_block(
      const ::media::mojom::blink::EncryptionPatternPtr& input) {
    return input->skip_byte_block;
  }

  static bool Read(::media::mojom::blink::EncryptionPattern::DataView input, ::media::mojom::blink::EncryptionPatternPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoColorSpace::DataView,
                                         ::media::mojom::blink::VideoColorSpacePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoColorSpacePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoColorSpacePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoColorSpace::primaries) primaries(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->primaries;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::transfer) transfer(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->transfer;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::matrix) matrix(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->matrix;
  }

  static decltype(::media::mojom::blink::VideoColorSpace::range) range(
      const ::media::mojom::blink::VideoColorSpacePtr& input) {
    return input->range;
  }

  static bool Read(::media::mojom::blink::VideoColorSpace::DataView input, ::media::mojom::blink::VideoColorSpacePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioDecoderConfig::DataView,
                                         ::media::mojom::blink::AudioDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::AudioDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioDecoderConfig::codec) codec(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::profile) profile(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::sample_format) sample_format(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::channel_layout) channel_layout(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::samples_per_second) samples_per_second(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->samples_per_second;
  }

  static const decltype(::media::mojom::blink::AudioDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static const decltype(::media::mojom::blink::AudioDecoderConfig::seek_preroll)& seek_preroll(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->seek_preroll;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::codec_delay) codec_delay(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->codec_delay;
  }

  static decltype(::media::mojom::blink::AudioDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::AudioDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static bool Read(::media::mojom::blink::AudioDecoderConfig::DataView input, ::media::mojom::blink::AudioDecoderConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoDecoderConfig::DataView,
                                         ::media::mojom::blink::VideoDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoDecoderConfig::codec) codec(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::profile) profile(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::level) level(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->level;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::has_alpha) has_alpha(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->has_alpha;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::transformation)& transformation(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->transformation;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::coded_size)& coded_size(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::visible_rect)& visible_rect(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::natural_size)& natural_size(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::extra_data)& extra_data(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::mojom::blink::VideoDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::color_space_info)& color_space_info(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->color_space_info;
  }

  static const decltype(::media::mojom::blink::VideoDecoderConfig::hdr_metadata)& hdr_metadata(
      const ::media::mojom::blink::VideoDecoderConfigPtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::blink::VideoDecoderConfig::DataView input, ::media::mojom::blink::VideoDecoderConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DecryptConfig::DataView,
                                         ::media::mojom::blink::DecryptConfigPtr> {
  static bool IsNull(const ::media::mojom::blink::DecryptConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecryptConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::DecryptConfig::encryption_scheme) encryption_scheme(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::key_id)& key_id(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->key_id;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::iv)& iv(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->iv;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::subsamples)& subsamples(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->subsamples;
  }

  static const decltype(::media::mojom::blink::DecryptConfig::encryption_pattern)& encryption_pattern(
      const ::media::mojom::blink::DecryptConfigPtr& input) {
    return input->encryption_pattern;
  }

  static bool Read(::media::mojom::blink::DecryptConfig::DataView input, ::media::mojom::blink::DecryptConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DecoderBuffer::DataView,
                                         ::media::mojom::blink::DecoderBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::DecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::DecoderBuffer::timestamp)& timestamp(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::blink::DecoderBuffer::duration)& duration(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->duration;
  }

  static decltype(::media::mojom::blink::DecoderBuffer::is_end_of_stream) is_end_of_stream(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->is_end_of_stream;
  }

  static decltype(::media::mojom::blink::DecoderBuffer::data_size) data_size(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->data_size;
  }

  static decltype(::media::mojom::blink::DecoderBuffer::is_key_frame) is_key_frame(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->is_key_frame;
  }

  static const decltype(::media::mojom::blink::DecoderBuffer::side_data)& side_data(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->side_data;
  }

  static const decltype(::media::mojom::blink::DecoderBuffer::decrypt_config)& decrypt_config(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->decrypt_config;
  }

  static const decltype(::media::mojom::blink::DecoderBuffer::front_discard)& front_discard(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->front_discard;
  }

  static const decltype(::media::mojom::blink::DecoderBuffer::back_discard)& back_discard(
      const ::media::mojom::blink::DecoderBufferPtr& input) {
    return input->back_discard;
  }

  static bool Read(::media::mojom::blink::DecoderBuffer::DataView input, ::media::mojom::blink::DecoderBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioBuffer::DataView,
                                         ::media::mojom::blink::AudioBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::AudioBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioBufferPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioBuffer::sample_format) sample_format(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->sample_format;
  }

  static decltype(::media::mojom::blink::AudioBuffer::channel_layout) channel_layout(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->channel_layout;
  }

  static decltype(::media::mojom::blink::AudioBuffer::channel_count) channel_count(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::blink::AudioBuffer::sample_rate) sample_rate(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::blink::AudioBuffer::frame_count) frame_count(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->frame_count;
  }

  static decltype(::media::mojom::blink::AudioBuffer::end_of_stream) end_of_stream(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::blink::AudioBuffer::timestamp)& timestamp(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::blink::AudioBuffer::data)& data(
      const ::media::mojom::blink::AudioBufferPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::blink::AudioBuffer::DataView input, ::media::mojom::blink::AudioBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::AudioDataS16::DataView,
                                         ::media::mojom::blink::AudioDataS16Ptr> {
  static bool IsNull(const ::media::mojom::blink::AudioDataS16Ptr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioDataS16Ptr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioDataS16::channel_count) channel_count(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::blink::AudioDataS16::sample_rate) sample_rate(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::blink::AudioDataS16::frame_count) frame_count(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->frame_count;
  }

  static const decltype(::media::mojom::blink::AudioDataS16::data)& data(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::blink::AudioDataS16::DataView input, ::media::mojom::blink::AudioDataS16Ptr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoFrameMetadata::DataView,
                                         ::media::mojom::blink::VideoFrameMetadataPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFrameMetadataPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoFrameMetadata::allow_overlay) allow_overlay(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->allow_overlay;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_begin_time)& capture_begin_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_begin_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_end_time)& capture_end_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_end_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_capture_counter) has_capture_counter(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_capture_counter;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::capture_counter) capture_counter(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_counter;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::capture_update_rect)& capture_update_rect(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->capture_update_rect;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_copy_mode) has_copy_mode(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_copy_mode;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::copy_mode) copy_mode(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->copy_mode;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::end_of_stream) end_of_stream(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->end_of_stream;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::frame_duration)& frame_duration(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->frame_duration;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_frame_rate) has_frame_rate(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_frame_rate;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::frame_rate) frame_rate(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->frame_rate;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::interactive_content) interactive_content(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->interactive_content;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::reference_time)& reference_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->reference_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::read_lock_fences_enabled) read_lock_fences_enabled(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->read_lock_fences_enabled;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_rotation) has_rotation(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_rotation;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::rotation) rotation(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->rotation;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::texture_owner) texture_owner(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->texture_owner;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::wants_promotion_hint) wants_promotion_hint(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->wants_promotion_hint;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::protected_video) protected_video(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->protected_video;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::hw_protected) hw_protected(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->hw_protected;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::overlay_plane_id)& overlay_plane_id(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->overlay_plane_id;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::power_efficient) power_efficient(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->power_efficient;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_device_scale_factor) has_device_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_device_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::device_scale_factor) device_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_page_scale_factor) has_page_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_page_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::page_scale_factor) page_scale_factor(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_root_scroll_offset_x) has_root_scroll_offset_x(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_x;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::root_scroll_offset_x) root_scroll_offset_x(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_x;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_root_scroll_offset_y) has_root_scroll_offset_y(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_root_scroll_offset_y;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::root_scroll_offset_y) root_scroll_offset_y(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->root_scroll_offset_y;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_top_controls_visible_height) has_top_controls_visible_height(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_top_controls_visible_height;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::top_controls_visible_height) top_controls_visible_height(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->top_controls_visible_height;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::decode_begin_time)& decode_begin_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->decode_begin_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::decode_end_time)& decode_end_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->decode_end_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::processing_time)& processing_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->processing_time;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::has_rtp_timestamp) has_rtp_timestamp(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->has_rtp_timestamp;
  }

  static decltype(::media::mojom::blink::VideoFrameMetadata::rtp_timestamp) rtp_timestamp(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->rtp_timestamp;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::receive_time)& receive_time(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->receive_time;
  }

  static const decltype(::media::mojom::blink::VideoFrameMetadata::wallclock_frame_duration)& wallclock_frame_duration(
      const ::media::mojom::blink::VideoFrameMetadataPtr& input) {
    return input->wallclock_frame_duration;
  }

  static bool Read(::media::mojom::blink::VideoFrameMetadata::DataView input, ::media::mojom::blink::VideoFrameMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoFrame::DataView,
                                         ::media::mojom::blink::VideoFramePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFramePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFramePtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::VideoFrame::format) format(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->format;
  }

  static const decltype(::media::mojom::blink::VideoFrame::coded_size)& coded_size(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::blink::VideoFrame::visible_rect)& visible_rect(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::mojom::blink::VideoFrame::natural_size)& natural_size(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::mojom::blink::VideoFrame::timestamp)& timestamp(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->timestamp;
  }

  static  decltype(::media::mojom::blink::VideoFrame::data)& data(
       ::media::mojom::blink::VideoFramePtr& input) {
    return input->data;
  }

  static const decltype(::media::mojom::blink::VideoFrame::metadata)& metadata(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->metadata;
  }

  static const decltype(::media::mojom::blink::VideoFrame::color_space)& color_space(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->color_space;
  }

  static const decltype(::media::mojom::blink::VideoFrame::hdr_metadata)& hdr_metadata(
      const ::media::mojom::blink::VideoFramePtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::mojom::blink::VideoFrame::DataView input, ::media::mojom::blink::VideoFramePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::EosVideoFrameData::DataView,
                                         ::media::mojom::blink::EosVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::EosVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::EosVideoFrameDataPtr* output) { output->reset(); }

  static bool Read(::media::mojom::blink::EosVideoFrameData::DataView input, ::media::mojom::blink::EosVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SharedBufferVideoFrameData::DataView,
                                         ::media::mojom::blink::SharedBufferVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::SharedBufferVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SharedBufferVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::SharedBufferVideoFrameData::frame_data)& frame_data(
       ::media::mojom::blink::SharedBufferVideoFrameDataPtr& input) {
    return input->frame_data;
  }

  static decltype(::media::mojom::blink::SharedBufferVideoFrameData::frame_data_size) frame_data_size(
      const ::media::mojom::blink::SharedBufferVideoFrameDataPtr& input) {
    return input->frame_data_size;
  }

  static const decltype(::media::mojom::blink::SharedBufferVideoFrameData::strides)& strides(
      const ::media::mojom::blink::SharedBufferVideoFrameDataPtr& input) {
    return input->strides;
  }

  static const decltype(::media::mojom::blink::SharedBufferVideoFrameData::offsets)& offsets(
      const ::media::mojom::blink::SharedBufferVideoFrameDataPtr& input) {
    return input->offsets;
  }

  static bool Read(::media::mojom::blink::SharedBufferVideoFrameData::DataView input, ::media::mojom::blink::SharedBufferVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DmabufVideoFrameData::DataView,
                                         ::media::mojom::blink::DmabufVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::DmabufVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DmabufVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::DmabufVideoFrameData::dmabuf_fds)& dmabuf_fds(
       ::media::mojom::blink::DmabufVideoFrameDataPtr& input) {
    return input->dmabuf_fds;
  }

  static bool Read(::media::mojom::blink::DmabufVideoFrameData::DataView input, ::media::mojom::blink::DmabufVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::GpuMemoryBufferVideoFrameData::DataView,
                                         ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::GpuMemoryBufferVideoFrameData::gpu_memory_buffer_handle)& gpu_memory_buffer_handle(
       ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr& input) {
    return input->gpu_memory_buffer_handle;
  }

  static const decltype(::media::mojom::blink::GpuMemoryBufferVideoFrameData::mailbox_holder)& mailbox_holder(
      const ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr& input) {
    return input->mailbox_holder;
  }

  static bool Read(::media::mojom::blink::GpuMemoryBufferVideoFrameData::DataView input, ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::MailboxVideoFrameData::DataView,
                                         ::media::mojom::blink::MailboxVideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::MailboxVideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::MailboxVideoFrameDataPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::MailboxVideoFrameData::mailbox_holder)& mailbox_holder(
      const ::media::mojom::blink::MailboxVideoFrameDataPtr& input) {
    return input->mailbox_holder;
  }

  static const decltype(::media::mojom::blink::MailboxVideoFrameData::ycbcr_data)& ycbcr_data(
      const ::media::mojom::blink::MailboxVideoFrameDataPtr& input) {
    return input->ycbcr_data;
  }

  static bool Read(::media::mojom::blink::MailboxVideoFrameData::DataView input, ::media::mojom::blink::MailboxVideoFrameDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PipelineStatistics::DataView,
                                         ::media::mojom::blink::PipelineStatisticsPtr> {
  static bool IsNull(const ::media::mojom::blink::PipelineStatisticsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PipelineStatisticsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PipelineStatistics::audio_bytes_decoded) audio_bytes_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->audio_bytes_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_bytes_decoded) video_bytes_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_bytes_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_frames_decoded) video_frames_decoded(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_frames_decoded;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_frames_dropped) video_frames_dropped(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_frames_dropped;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::audio_memory_usage) audio_memory_usage(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->audio_memory_usage;
  }

  static decltype(::media::mojom::blink::PipelineStatistics::video_memory_usage) video_memory_usage(
      const ::media::mojom::blink::PipelineStatisticsPtr& input) {
    return input->video_memory_usage;
  }

  static bool Read(::media::mojom::blink::PipelineStatistics::DataView input, ::media::mojom::blink::PipelineStatisticsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PredictionFeatures::DataView,
                                         ::media::mojom::blink::PredictionFeaturesPtr> {
  static bool IsNull(const ::media::mojom::blink::PredictionFeaturesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PredictionFeaturesPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PredictionFeatures::profile) profile(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->profile;
  }

  static const decltype(::media::mojom::blink::PredictionFeatures::video_size)& video_size(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->video_size;
  }

  static decltype(::media::mojom::blink::PredictionFeatures::frames_per_sec) frames_per_sec(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->frames_per_sec;
  }

  static const decltype(::media::mojom::blink::PredictionFeatures::key_system)& key_system(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->key_system;
  }

  static decltype(::media::mojom::blink::PredictionFeatures::use_hw_secure_codecs) use_hw_secure_codecs(
      const ::media::mojom::blink::PredictionFeaturesPtr& input) {
    return input->use_hw_secure_codecs;
  }

  static bool Read(::media::mojom::blink::PredictionFeatures::DataView input, ::media::mojom::blink::PredictionFeaturesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PredictionTargets::DataView,
                                         ::media::mojom::blink::PredictionTargetsPtr> {
  static bool IsNull(const ::media::mojom::blink::PredictionTargetsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PredictionTargetsPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PredictionTargets::frames_decoded) frames_decoded(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_decoded;
  }

  static decltype(::media::mojom::blink::PredictionTargets::frames_dropped) frames_dropped(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_dropped;
  }

  static decltype(::media::mojom::blink::PredictionTargets::frames_power_efficient) frames_power_efficient(
      const ::media::mojom::blink::PredictionTargetsPtr& input) {
    return input->frames_power_efficient;
  }

  static bool Read(::media::mojom::blink::PredictionTargets::DataView input, ::media::mojom::blink::PredictionTargetsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PipelineDecoderInfo::DataView,
                                         ::media::mojom::blink::PipelineDecoderInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::PipelineDecoderInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PipelineDecoderInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::PipelineDecoderInfo::decoder_name)& decoder_name(
      const ::media::mojom::blink::PipelineDecoderInfoPtr& input) {
    return input->decoder_name;
  }

  static decltype(::media::mojom::blink::PipelineDecoderInfo::is_platform_decoder) is_platform_decoder(
      const ::media::mojom::blink::PipelineDecoderInfoPtr& input) {
    return input->is_platform_decoder;
  }

  static decltype(::media::mojom::blink::PipelineDecoderInfo::has_decrypting_demuxer_stream) has_decrypting_demuxer_stream(
      const ::media::mojom::blink::PipelineDecoderInfoPtr& input) {
    return input->has_decrypting_demuxer_stream;
  }

  static bool Read(::media::mojom::blink::PipelineDecoderInfo::DataView input, ::media::mojom::blink::PipelineDecoderInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::Status::DataView,
                                         ::media::mojom::blink::StatusPtr> {
  static bool IsNull(const ::media::mojom::blink::StatusPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::StatusPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::Status::code) code(
      const ::media::mojom::blink::StatusPtr& input) {
    return input->code;
  }

  static const decltype(::media::mojom::blink::Status::message)& message(
      const ::media::mojom::blink::StatusPtr& input) {
    return input->message;
  }

  static const decltype(::media::mojom::blink::Status::frames)& frames(
      const ::media::mojom::blink::StatusPtr& input) {
    return input->frames;
  }

  static const decltype(::media::mojom::blink::Status::causes)& causes(
      const ::media::mojom::blink::StatusPtr& input) {
    return input->causes;
  }

  static const decltype(::media::mojom::blink::Status::data)& data(
      const ::media::mojom::blink::StatusPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::blink::Status::DataView input, ::media::mojom::blink::StatusPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::VideoFrameData::DataView,
                                        ::media::mojom::blink::VideoFrameDataPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFrameDataPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFrameDataPtr* output) { output->reset(); }

  static ::media::mojom::blink::VideoFrameData::Tag GetTag(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->which();
  }

  static const ::media::mojom::blink::EosVideoFrameDataPtr& eos_data(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_eos_data();
  }

  static  ::media::mojom::blink::SharedBufferVideoFrameDataPtr& shared_buffer_data( ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_shared_buffer_data();
  }

  static  ::media::mojom::blink::DmabufVideoFrameDataPtr& dmabuf_data( ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_dmabuf_data();
  }

  static  ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr& gpu_memory_buffer_data( ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_gpu_memory_buffer_data();
  }

  static const ::media::mojom::blink::MailboxVideoFrameDataPtr& mailbox_data(const ::media::mojom::blink::VideoFrameDataPtr& input) {
    return input->get_mailbox_data();
  }

  static bool Read(::media::mojom::blink::VideoFrameData::DataView input, ::media::mojom::blink::VideoFrameDataPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_H_