// components/web_package/mojom/web_bundle_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-shared.h"
#include "components/web_package/mojom/web_bundle_parser.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace web_package {
namespace mojom {

class WebBundleParserFactoryProxy;

template <typename ImplRefTraits>
class WebBundleParserFactoryStub;

class WebBundleParserFactoryRequestValidator;


class  WebBundleParserFactory
    : public WebBundleParserFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBundleParserFactoryInterfaceBase;
  using Proxy_ = WebBundleParserFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBundleParserFactoryStub<ImplRefTraits>;

  using RequestValidator_ = WebBundleParserFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetParserForFileMinVersion = 0,
    kGetParserForDataSourceMinVersion = 0,
  };
  virtual ~WebBundleParserFactory() {}

  
  virtual void GetParserForFile(::mojo::PendingReceiver<WebBundleParser> receiver, ::base::File file) = 0;

  
  virtual void GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, ::mojo::PendingRemote<BundleDataSource> data_source) = 0;
};

class WebBundleParserProxy;

template <typename ImplRefTraits>
class WebBundleParserStub;

class WebBundleParserRequestValidator;
class WebBundleParserResponseValidator;


class  WebBundleParser
    : public WebBundleParserInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBundleParserInterfaceBase;
  using Proxy_ = WebBundleParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBundleParserStub<ImplRefTraits>;

  using RequestValidator_ = WebBundleParserRequestValidator;
  using ResponseValidator_ = WebBundleParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseMetadataMinVersion = 0,
    kParseResponseMinVersion = 0,
  };
  virtual ~WebBundleParser() {}


  using ParseMetadataCallback = base::OnceCallback<void(BundleMetadataPtr, BundleMetadataParseErrorPtr)>;
  
  virtual void ParseMetadata(ParseMetadataCallback callback) = 0;


  using ParseResponseCallback = base::OnceCallback<void(BundleResponsePtr, BundleResponseParseErrorPtr)>;
  
  virtual void ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) = 0;
};

class BundleDataSourceProxy;

template <typename ImplRefTraits>
class BundleDataSourceStub;

class BundleDataSourceRequestValidator;
class BundleDataSourceResponseValidator;


class  BundleDataSource
    : public BundleDataSourceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BundleDataSourceInterfaceBase;
  using Proxy_ = BundleDataSourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BundleDataSourceStub<ImplRefTraits>;

  using RequestValidator_ = BundleDataSourceRequestValidator;
  using ResponseValidator_ = BundleDataSourceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
  };
  virtual ~BundleDataSource() {}


  using ReadCallback = base::OnceCallback<void(const base::Optional<std::vector<uint8_t>>&)>;
  
  virtual void Read(uint64_t offset, uint64_t length, ReadCallback callback) = 0;
};



class  WebBundleParserFactoryProxy
    : public WebBundleParserFactory {
 public:
  using InterfaceType = WebBundleParserFactory;

  explicit WebBundleParserFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetParserForFile(::mojo::PendingReceiver<WebBundleParser> receiver, ::base::File file) final;
  
  void GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, ::mojo::PendingRemote<BundleDataSource> data_source) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebBundleParserProxy
    : public WebBundleParser {
 public:
  using InterfaceType = WebBundleParser;

  explicit WebBundleParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ParseMetadata(ParseMetadataCallback callback) final;
  
  void ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BundleDataSourceProxy
    : public BundleDataSource {
 public:
  using InterfaceType = BundleDataSource;

  explicit BundleDataSourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(uint64_t offset, uint64_t length, ReadCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebBundleParserFactoryStubDispatch {
 public:
  static bool Accept(WebBundleParserFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBundleParserFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBundleParserFactory>>
class WebBundleParserFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBundleParserFactoryStub() {}
  ~WebBundleParserFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebBundleParserStubDispatch {
 public:
  static bool Accept(WebBundleParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBundleParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBundleParser>>
class WebBundleParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBundleParserStub() {}
  ~WebBundleParserStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBundleParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BundleDataSourceStubDispatch {
 public:
  static bool Accept(BundleDataSource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BundleDataSource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BundleDataSource>>
class BundleDataSourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BundleDataSourceStub() {}
  ~BundleDataSourceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BundleDataSourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BundleDataSourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebBundleParserFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebBundleParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BundleDataSourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebBundleParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BundleDataSourceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  BundleResponseParseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponseParseError, T>::value>;
  using DataView = BundleResponseParseErrorDataView;
  using Data_ = internal::BundleResponseParseError_Data;

  template <typename... Args>
  static BundleResponseParseErrorPtr New(Args&&... args) {
    return BundleResponseParseErrorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponseParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<BundleResponseParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponseParseError>::Convert(*this);
  }


  BundleResponseParseError();

  BundleResponseParseError(
      BundleParseErrorType type,
      const std::string& message);

  ~BundleResponseParseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponseParseErrorPtr>
  BundleResponseParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseParseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponseParseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponseParseError_UnserializedMessageContext<
            UserType, BundleResponseParseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleResponseParseError::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleResponseParseError::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponseParseError_UnserializedMessageContext<
            UserType, BundleResponseParseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponseParseError::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  BundleParseErrorType type;
  
  std::string message;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponseParseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  BundleResponseLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponseLocation, T>::value>;
  using DataView = BundleResponseLocationDataView;
  using Data_ = internal::BundleResponseLocation_Data;

  template <typename... Args>
  static BundleResponseLocationPtr New(Args&&... args) {
    return BundleResponseLocationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponseLocationPtr From(const U& u) {
    return mojo::TypeConverter<BundleResponseLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponseLocation>::Convert(*this);
  }


  BundleResponseLocation();

  BundleResponseLocation(
      uint64_t offset,
      uint64_t length);

  ~BundleResponseLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponseLocationPtr>
  BundleResponseLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponseLocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponseLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponseLocation_UnserializedMessageContext<
            UserType, BundleResponseLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleResponseLocation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleResponseLocation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponseLocation_UnserializedMessageContext<
            UserType, BundleResponseLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponseLocation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t offset;
  
  uint64_t length;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponseLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  BundleMetadataParseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleMetadataParseError, T>::value>;
  using DataView = BundleMetadataParseErrorDataView;
  using Data_ = internal::BundleMetadataParseError_Data;

  template <typename... Args>
  static BundleMetadataParseErrorPtr New(Args&&... args) {
    return BundleMetadataParseErrorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleMetadataParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<BundleMetadataParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleMetadataParseError>::Convert(*this);
  }


  BundleMetadataParseError();

  BundleMetadataParseError(
      BundleParseErrorType type,
      const ::GURL& fallback_url,
      const std::string& message);

  ~BundleMetadataParseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleMetadataParseErrorPtr>
  BundleMetadataParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadataParseError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleMetadataParseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleMetadataParseError_UnserializedMessageContext<
            UserType, BundleMetadataParseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleMetadataParseError::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleMetadataParseError::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleMetadataParseError_UnserializedMessageContext<
            UserType, BundleMetadataParseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleMetadataParseError::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  BundleParseErrorType type;
  
  ::GURL fallback_url;
  
  std::string message;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  BundleMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleMetadata, T>::value>;
  using DataView = BundleMetadataDataView;
  using Data_ = internal::BundleMetadata_Data;

  template <typename... Args>
  static BundleMetadataPtr New(Args&&... args) {
    return BundleMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleMetadataPtr From(const U& u) {
    return mojo::TypeConverter<BundleMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleMetadata>::Convert(*this);
  }


  BundleMetadata();

  BundleMetadata(
      const ::GURL& primary_url,
      base::flat_map<::GURL, BundleIndexValuePtr> requests,
      const ::GURL& manifest_url,
      std::vector<AugmentedCertificatePtr> authorities,
      std::vector<VouchedSubsetPtr> vouched_subsets);

  ~BundleMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleMetadataPtr>
  BundleMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleMetadata_UnserializedMessageContext<
            UserType, BundleMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleMetadata_UnserializedMessageContext<
            UserType, BundleMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL primary_url;
  
  base::flat_map<::GURL, BundleIndexValuePtr> requests;
  
  ::GURL manifest_url;
  
  std::vector<AugmentedCertificatePtr> authorities;
  
  std::vector<VouchedSubsetPtr> vouched_subsets;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BundleMetadata);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleIndexValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleIndexValue, T>::value>;
  using DataView = BundleIndexValueDataView;
  using Data_ = internal::BundleIndexValue_Data;

  template <typename... Args>
  static BundleIndexValuePtr New(Args&&... args) {
    return BundleIndexValuePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleIndexValuePtr From(const U& u) {
    return mojo::TypeConverter<BundleIndexValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleIndexValue>::Convert(*this);
  }


  BundleIndexValue();

  BundleIndexValue(
      const std::string& variants_value,
      std::vector<BundleResponseLocationPtr> response_locations);

  ~BundleIndexValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleIndexValuePtr>
  BundleIndexValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleIndexValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleIndexValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleIndexValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleIndexValue_UnserializedMessageContext<
            UserType, BundleIndexValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleIndexValue::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleIndexValue::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleIndexValue_UnserializedMessageContext<
            UserType, BundleIndexValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleIndexValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string variants_value;
  
  std::vector<BundleResponseLocationPtr> response_locations;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BundleIndexValue);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleIndexValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleIndexValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleIndexValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleIndexValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  AugmentedCertificate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AugmentedCertificate, T>::value>;
  using DataView = AugmentedCertificateDataView;
  using Data_ = internal::AugmentedCertificate_Data;

  template <typename... Args>
  static AugmentedCertificatePtr New(Args&&... args) {
    return AugmentedCertificatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AugmentedCertificatePtr From(const U& u) {
    return mojo::TypeConverter<AugmentedCertificatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AugmentedCertificate>::Convert(*this);
  }


  AugmentedCertificate();

  AugmentedCertificate(
      std::vector<uint8_t> cert,
      base::Optional<std::vector<uint8_t>> ocsp,
      base::Optional<std::vector<uint8_t>> sct);

  ~AugmentedCertificate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AugmentedCertificatePtr>
  AugmentedCertificatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AugmentedCertificate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AugmentedCertificate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AugmentedCertificate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AugmentedCertificate_UnserializedMessageContext<
            UserType, AugmentedCertificate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AugmentedCertificate::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return AugmentedCertificate::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AugmentedCertificate_UnserializedMessageContext<
            UserType, AugmentedCertificate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AugmentedCertificate::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<uint8_t> cert;
  
  base::Optional<std::vector<uint8_t>> ocsp;
  
  base::Optional<std::vector<uint8_t>> sct;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AugmentedCertificate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AugmentedCertificate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AugmentedCertificate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AugmentedCertificate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VouchedSubset {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VouchedSubset, T>::value>;
  using DataView = VouchedSubsetDataView;
  using Data_ = internal::VouchedSubset_Data;

  template <typename... Args>
  static VouchedSubsetPtr New(Args&&... args) {
    return VouchedSubsetPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VouchedSubsetPtr From(const U& u) {
    return mojo::TypeConverter<VouchedSubsetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VouchedSubset>::Convert(*this);
  }


  VouchedSubset();

  VouchedSubset(
      uint64_t authority,
      std::vector<uint8_t> sig,
      std::vector<uint8_t> raw_signed,
      SignedSubsetPtr parsed_signed);

  ~VouchedSubset();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VouchedSubsetPtr>
  VouchedSubsetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VouchedSubset::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VouchedSubset::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VouchedSubset::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VouchedSubset_UnserializedMessageContext<
            UserType, VouchedSubset::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VouchedSubset::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VouchedSubset::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VouchedSubset_UnserializedMessageContext<
            UserType, VouchedSubset::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VouchedSubset::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t authority;
  
  std::vector<uint8_t> sig;
  
  std::vector<uint8_t> raw_signed;
  
  SignedSubsetPtr parsed_signed;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VouchedSubset);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VouchedSubset::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VouchedSubset::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VouchedSubset::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VouchedSubset::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SignedSubset {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignedSubset, T>::value>;
  using DataView = SignedSubsetDataView;
  using Data_ = internal::SignedSubset_Data;

  template <typename... Args>
  static SignedSubsetPtr New(Args&&... args) {
    return SignedSubsetPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignedSubsetPtr From(const U& u) {
    return mojo::TypeConverter<SignedSubsetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignedSubset>::Convert(*this);
  }


  SignedSubset();

  SignedSubset(
      const ::GURL& validity_url,
      std::vector<uint8_t> auth_sha256,
      uint64_t date,
      uint64_t expires,
      base::flat_map<::GURL, SubsetHashesValuePtr> subset_hashes);

  ~SignedSubset();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignedSubsetPtr>
  SignedSubsetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignedSubset::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignedSubset::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignedSubset::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignedSubset_UnserializedMessageContext<
            UserType, SignedSubset::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SignedSubset::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SignedSubset::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignedSubset_UnserializedMessageContext<
            UserType, SignedSubset::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignedSubset::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL validity_url;
  
  std::vector<uint8_t> auth_sha256;
  
  uint64_t date;
  
  uint64_t expires;
  
  base::flat_map<::GURL, SubsetHashesValuePtr> subset_hashes;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SignedSubset);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignedSubset::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignedSubset::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignedSubset::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignedSubset::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SubsetHashesValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubsetHashesValue, T>::value>;
  using DataView = SubsetHashesValueDataView;
  using Data_ = internal::SubsetHashesValue_Data;

  template <typename... Args>
  static SubsetHashesValuePtr New(Args&&... args) {
    return SubsetHashesValuePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubsetHashesValuePtr From(const U& u) {
    return mojo::TypeConverter<SubsetHashesValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubsetHashesValue>::Convert(*this);
  }


  SubsetHashesValue();

  SubsetHashesValue(
      const std::string& variants_value,
      std::vector<ResourceIntegrityPtr> resource_integrities);

  ~SubsetHashesValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubsetHashesValuePtr>
  SubsetHashesValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubsetHashesValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubsetHashesValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubsetHashesValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubsetHashesValue_UnserializedMessageContext<
            UserType, SubsetHashesValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SubsetHashesValue::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SubsetHashesValue::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubsetHashesValue_UnserializedMessageContext<
            UserType, SubsetHashesValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubsetHashesValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string variants_value;
  
  std::vector<ResourceIntegrityPtr> resource_integrities;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SubsetHashesValue);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubsetHashesValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubsetHashesValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubsetHashesValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubsetHashesValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ResourceIntegrity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceIntegrity, T>::value>;
  using DataView = ResourceIntegrityDataView;
  using Data_ = internal::ResourceIntegrity_Data;

  template <typename... Args>
  static ResourceIntegrityPtr New(Args&&... args) {
    return ResourceIntegrityPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceIntegrityPtr From(const U& u) {
    return mojo::TypeConverter<ResourceIntegrityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceIntegrity>::Convert(*this);
  }


  ResourceIntegrity();

  ResourceIntegrity(
      std::vector<uint8_t> header_sha256,
      const std::string& payload_integrity_header);

  ~ResourceIntegrity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceIntegrityPtr>
  ResourceIntegrityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceIntegrity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceIntegrity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceIntegrity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceIntegrity_UnserializedMessageContext<
            UserType, ResourceIntegrity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ResourceIntegrity::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ResourceIntegrity::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceIntegrity_UnserializedMessageContext<
            UserType, ResourceIntegrity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceIntegrity::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<uint8_t> header_sha256;
  
  std::string payload_integrity_header;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceIntegrity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceIntegrity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceIntegrity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceIntegrity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundleResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundleResponse, T>::value>;
  using DataView = BundleResponseDataView;
  using Data_ = internal::BundleResponse_Data;

  template <typename... Args>
  static BundleResponsePtr New(Args&&... args) {
    return BundleResponsePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundleResponsePtr From(const U& u) {
    return mojo::TypeConverter<BundleResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundleResponse>::Convert(*this);
  }


  BundleResponse();

  BundleResponse(
      int32_t response_code,
      const base::flat_map<std::string, std::string>& response_headers,
      uint64_t payload_offset,
      uint64_t payload_length);

  ~BundleResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundleResponsePtr>
  BundleResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BundleResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundleResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundleResponse_UnserializedMessageContext<
            UserType, BundleResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BundleResponse::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BundleResponse::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundleResponse_UnserializedMessageContext<
            UserType, BundleResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundleResponse::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t response_code;
  
  base::flat_map<std::string, std::string> response_headers;
  
  uint64_t payload_offset;
  
  uint64_t payload_length;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundleResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BundleMetadataParseErrorPtr BundleMetadataParseError::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(fallback_url),
      mojo::Clone(message)
  );
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>*>
bool BundleMetadataParseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->fallback_url, other_struct.fallback_url))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, BundleMetadataParseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.fallback_url, rhs.fallback_url))
    return true;
  if (std::less<>{}(rhs.fallback_url, lhs.fallback_url))
    return false;
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponseParseErrorPtr BundleResponseParseError::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(message)
  );
}

template <typename T, BundleResponseParseError::EnableIfSame<T>*>
bool BundleResponseParseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, BundleResponseParseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.message, rhs.message))
    return true;
  if (std::less<>{}(rhs.message, lhs.message))
    return false;
  return false;
}
template <typename StructPtrType>
BundleMetadataPtr BundleMetadata::Clone() const {
  return New(
      mojo::Clone(primary_url),
      mojo::Clone(requests),
      mojo::Clone(manifest_url),
      mojo::Clone(authorities),
      mojo::Clone(vouched_subsets)
  );
}

template <typename T, BundleMetadata::EnableIfSame<T>*>
bool BundleMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_url, other_struct.primary_url))
    return false;
  if (!mojo::Equals(this->requests, other_struct.requests))
    return false;
  if (!mojo::Equals(this->manifest_url, other_struct.manifest_url))
    return false;
  if (!mojo::Equals(this->authorities, other_struct.authorities))
    return false;
  if (!mojo::Equals(this->vouched_subsets, other_struct.vouched_subsets))
    return false;
  return true;
}

template <typename T, BundleMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.primary_url, rhs.primary_url))
    return true;
  if (std::less<>{}(rhs.primary_url, lhs.primary_url))
    return false;
  if (std::less<>{}(lhs.requests, rhs.requests))
    return true;
  if (std::less<>{}(rhs.requests, lhs.requests))
    return false;
  if (std::less<>{}(lhs.manifest_url, rhs.manifest_url))
    return true;
  if (std::less<>{}(rhs.manifest_url, lhs.manifest_url))
    return false;
  if (std::less<>{}(lhs.authorities, rhs.authorities))
    return true;
  if (std::less<>{}(rhs.authorities, lhs.authorities))
    return false;
  if (std::less<>{}(lhs.vouched_subsets, rhs.vouched_subsets))
    return true;
  if (std::less<>{}(rhs.vouched_subsets, lhs.vouched_subsets))
    return false;
  return false;
}
template <typename StructPtrType>
BundleIndexValuePtr BundleIndexValue::Clone() const {
  return New(
      mojo::Clone(variants_value),
      mojo::Clone(response_locations)
  );
}

template <typename T, BundleIndexValue::EnableIfSame<T>*>
bool BundleIndexValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->variants_value, other_struct.variants_value))
    return false;
  if (!mojo::Equals(this->response_locations, other_struct.response_locations))
    return false;
  return true;
}

template <typename T, BundleIndexValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.variants_value, rhs.variants_value))
    return true;
  if (std::less<>{}(rhs.variants_value, lhs.variants_value))
    return false;
  if (std::less<>{}(lhs.response_locations, rhs.response_locations))
    return true;
  if (std::less<>{}(rhs.response_locations, lhs.response_locations))
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponseLocationPtr BundleResponseLocation::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(length)
  );
}

template <typename T, BundleResponseLocation::EnableIfSame<T>*>
bool BundleResponseLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  return true;
}

template <typename T, BundleResponseLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  return false;
}
template <typename StructPtrType>
AugmentedCertificatePtr AugmentedCertificate::Clone() const {
  return New(
      mojo::Clone(cert),
      mojo::Clone(ocsp),
      mojo::Clone(sct)
  );
}

template <typename T, AugmentedCertificate::EnableIfSame<T>*>
bool AugmentedCertificate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cert, other_struct.cert))
    return false;
  if (!mojo::Equals(this->ocsp, other_struct.ocsp))
    return false;
  if (!mojo::Equals(this->sct, other_struct.sct))
    return false;
  return true;
}

template <typename T, AugmentedCertificate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cert, rhs.cert))
    return true;
  if (std::less<>{}(rhs.cert, lhs.cert))
    return false;
  if (std::less<>{}(lhs.ocsp, rhs.ocsp))
    return true;
  if (std::less<>{}(rhs.ocsp, lhs.ocsp))
    return false;
  if (std::less<>{}(lhs.sct, rhs.sct))
    return true;
  if (std::less<>{}(rhs.sct, lhs.sct))
    return false;
  return false;
}
template <typename StructPtrType>
VouchedSubsetPtr VouchedSubset::Clone() const {
  return New(
      mojo::Clone(authority),
      mojo::Clone(sig),
      mojo::Clone(raw_signed),
      mojo::Clone(parsed_signed)
  );
}

template <typename T, VouchedSubset::EnableIfSame<T>*>
bool VouchedSubset::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->authority, other_struct.authority))
    return false;
  if (!mojo::Equals(this->sig, other_struct.sig))
    return false;
  if (!mojo::Equals(this->raw_signed, other_struct.raw_signed))
    return false;
  if (!mojo::Equals(this->parsed_signed, other_struct.parsed_signed))
    return false;
  return true;
}

template <typename T, VouchedSubset::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.authority, rhs.authority))
    return true;
  if (std::less<>{}(rhs.authority, lhs.authority))
    return false;
  if (std::less<>{}(lhs.sig, rhs.sig))
    return true;
  if (std::less<>{}(rhs.sig, lhs.sig))
    return false;
  if (std::less<>{}(lhs.raw_signed, rhs.raw_signed))
    return true;
  if (std::less<>{}(rhs.raw_signed, lhs.raw_signed))
    return false;
  if (std::less<>{}(lhs.parsed_signed, rhs.parsed_signed))
    return true;
  if (std::less<>{}(rhs.parsed_signed, lhs.parsed_signed))
    return false;
  return false;
}
template <typename StructPtrType>
SignedSubsetPtr SignedSubset::Clone() const {
  return New(
      mojo::Clone(validity_url),
      mojo::Clone(auth_sha256),
      mojo::Clone(date),
      mojo::Clone(expires),
      mojo::Clone(subset_hashes)
  );
}

template <typename T, SignedSubset::EnableIfSame<T>*>
bool SignedSubset::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->validity_url, other_struct.validity_url))
    return false;
  if (!mojo::Equals(this->auth_sha256, other_struct.auth_sha256))
    return false;
  if (!mojo::Equals(this->date, other_struct.date))
    return false;
  if (!mojo::Equals(this->expires, other_struct.expires))
    return false;
  if (!mojo::Equals(this->subset_hashes, other_struct.subset_hashes))
    return false;
  return true;
}

template <typename T, SignedSubset::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.validity_url, rhs.validity_url))
    return true;
  if (std::less<>{}(rhs.validity_url, lhs.validity_url))
    return false;
  if (std::less<>{}(lhs.auth_sha256, rhs.auth_sha256))
    return true;
  if (std::less<>{}(rhs.auth_sha256, lhs.auth_sha256))
    return false;
  if (std::less<>{}(lhs.date, rhs.date))
    return true;
  if (std::less<>{}(rhs.date, lhs.date))
    return false;
  if (std::less<>{}(lhs.expires, rhs.expires))
    return true;
  if (std::less<>{}(rhs.expires, lhs.expires))
    return false;
  if (std::less<>{}(lhs.subset_hashes, rhs.subset_hashes))
    return true;
  if (std::less<>{}(rhs.subset_hashes, lhs.subset_hashes))
    return false;
  return false;
}
template <typename StructPtrType>
SubsetHashesValuePtr SubsetHashesValue::Clone() const {
  return New(
      mojo::Clone(variants_value),
      mojo::Clone(resource_integrities)
  );
}

template <typename T, SubsetHashesValue::EnableIfSame<T>*>
bool SubsetHashesValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->variants_value, other_struct.variants_value))
    return false;
  if (!mojo::Equals(this->resource_integrities, other_struct.resource_integrities))
    return false;
  return true;
}

template <typename T, SubsetHashesValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.variants_value, rhs.variants_value))
    return true;
  if (std::less<>{}(rhs.variants_value, lhs.variants_value))
    return false;
  if (std::less<>{}(lhs.resource_integrities, rhs.resource_integrities))
    return true;
  if (std::less<>{}(rhs.resource_integrities, lhs.resource_integrities))
    return false;
  return false;
}
template <typename StructPtrType>
ResourceIntegrityPtr ResourceIntegrity::Clone() const {
  return New(
      mojo::Clone(header_sha256),
      mojo::Clone(payload_integrity_header)
  );
}

template <typename T, ResourceIntegrity::EnableIfSame<T>*>
bool ResourceIntegrity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header_sha256, other_struct.header_sha256))
    return false;
  if (!mojo::Equals(this->payload_integrity_header, other_struct.payload_integrity_header))
    return false;
  return true;
}

template <typename T, ResourceIntegrity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.header_sha256, rhs.header_sha256))
    return true;
  if (std::less<>{}(rhs.header_sha256, lhs.header_sha256))
    return false;
  if (std::less<>{}(lhs.payload_integrity_header, rhs.payload_integrity_header))
    return true;
  if (std::less<>{}(rhs.payload_integrity_header, lhs.payload_integrity_header))
    return false;
  return false;
}
template <typename StructPtrType>
BundleResponsePtr BundleResponse::Clone() const {
  return New(
      mojo::Clone(response_code),
      mojo::Clone(response_headers),
      mojo::Clone(payload_offset),
      mojo::Clone(payload_length)
  );
}

template <typename T, BundleResponse::EnableIfSame<T>*>
bool BundleResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_code, other_struct.response_code))
    return false;
  if (!mojo::Equals(this->response_headers, other_struct.response_headers))
    return false;
  if (!mojo::Equals(this->payload_offset, other_struct.payload_offset))
    return false;
  if (!mojo::Equals(this->payload_length, other_struct.payload_length))
    return false;
  return true;
}

template <typename T, BundleResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.response_code, rhs.response_code))
    return true;
  if (std::less<>{}(rhs.response_code, lhs.response_code))
    return false;
  if (std::less<>{}(lhs.response_headers, rhs.response_headers))
    return true;
  if (std::less<>{}(rhs.response_headers, lhs.response_headers))
    return false;
  if (std::less<>{}(lhs.payload_offset, rhs.payload_offset))
    return true;
  if (std::less<>{}(rhs.payload_offset, lhs.payload_offset))
    return false;
  if (std::less<>{}(lhs.payload_length, rhs.payload_length))
    return true;
  if (std::less<>{}(rhs.payload_length, lhs.payload_length))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace web_package

namespace mojo {


template <>
struct  StructTraits<::web_package::mojom::BundleMetadataParseError::DataView,
                                         ::web_package::mojom::BundleMetadataParseErrorPtr> {
  static bool IsNull(const ::web_package::mojom::BundleMetadataParseErrorPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleMetadataParseErrorPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleMetadataParseError::type) type(
      const ::web_package::mojom::BundleMetadataParseErrorPtr& input) {
    return input->type;
  }

  static const decltype(::web_package::mojom::BundleMetadataParseError::fallback_url)& fallback_url(
      const ::web_package::mojom::BundleMetadataParseErrorPtr& input) {
    return input->fallback_url;
  }

  static const decltype(::web_package::mojom::BundleMetadataParseError::message)& message(
      const ::web_package::mojom::BundleMetadataParseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::web_package::mojom::BundleMetadataParseError::DataView input, ::web_package::mojom::BundleMetadataParseErrorPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponseParseError::DataView,
                                         ::web_package::mojom::BundleResponseParseErrorPtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponseParseErrorPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponseParseErrorPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponseParseError::type) type(
      const ::web_package::mojom::BundleResponseParseErrorPtr& input) {
    return input->type;
  }

  static const decltype(::web_package::mojom::BundleResponseParseError::message)& message(
      const ::web_package::mojom::BundleResponseParseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::web_package::mojom::BundleResponseParseError::DataView input, ::web_package::mojom::BundleResponseParseErrorPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleMetadata::DataView,
                                         ::web_package::mojom::BundleMetadataPtr> {
  static bool IsNull(const ::web_package::mojom::BundleMetadataPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleMetadataPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::BundleMetadata::primary_url)& primary_url(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->primary_url;
  }

  static const decltype(::web_package::mojom::BundleMetadata::requests)& requests(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->requests;
  }

  static const decltype(::web_package::mojom::BundleMetadata::manifest_url)& manifest_url(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->manifest_url;
  }

  static const decltype(::web_package::mojom::BundleMetadata::authorities)& authorities(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->authorities;
  }

  static const decltype(::web_package::mojom::BundleMetadata::vouched_subsets)& vouched_subsets(
      const ::web_package::mojom::BundleMetadataPtr& input) {
    return input->vouched_subsets;
  }

  static bool Read(::web_package::mojom::BundleMetadata::DataView input, ::web_package::mojom::BundleMetadataPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleIndexValue::DataView,
                                         ::web_package::mojom::BundleIndexValuePtr> {
  static bool IsNull(const ::web_package::mojom::BundleIndexValuePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleIndexValuePtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::BundleIndexValue::variants_value)& variants_value(
      const ::web_package::mojom::BundleIndexValuePtr& input) {
    return input->variants_value;
  }

  static const decltype(::web_package::mojom::BundleIndexValue::response_locations)& response_locations(
      const ::web_package::mojom::BundleIndexValuePtr& input) {
    return input->response_locations;
  }

  static bool Read(::web_package::mojom::BundleIndexValue::DataView input, ::web_package::mojom::BundleIndexValuePtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponseLocation::DataView,
                                         ::web_package::mojom::BundleResponseLocationPtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponseLocationPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponseLocationPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponseLocation::offset) offset(
      const ::web_package::mojom::BundleResponseLocationPtr& input) {
    return input->offset;
  }

  static decltype(::web_package::mojom::BundleResponseLocation::length) length(
      const ::web_package::mojom::BundleResponseLocationPtr& input) {
    return input->length;
  }

  static bool Read(::web_package::mojom::BundleResponseLocation::DataView input, ::web_package::mojom::BundleResponseLocationPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::AugmentedCertificate::DataView,
                                         ::web_package::mojom::AugmentedCertificatePtr> {
  static bool IsNull(const ::web_package::mojom::AugmentedCertificatePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::AugmentedCertificatePtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::AugmentedCertificate::cert)& cert(
      const ::web_package::mojom::AugmentedCertificatePtr& input) {
    return input->cert;
  }

  static const decltype(::web_package::mojom::AugmentedCertificate::ocsp)& ocsp(
      const ::web_package::mojom::AugmentedCertificatePtr& input) {
    return input->ocsp;
  }

  static const decltype(::web_package::mojom::AugmentedCertificate::sct)& sct(
      const ::web_package::mojom::AugmentedCertificatePtr& input) {
    return input->sct;
  }

  static bool Read(::web_package::mojom::AugmentedCertificate::DataView input, ::web_package::mojom::AugmentedCertificatePtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::VouchedSubset::DataView,
                                         ::web_package::mojom::VouchedSubsetPtr> {
  static bool IsNull(const ::web_package::mojom::VouchedSubsetPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::VouchedSubsetPtr* output) { output->reset(); }

  static decltype(::web_package::mojom::VouchedSubset::authority) authority(
      const ::web_package::mojom::VouchedSubsetPtr& input) {
    return input->authority;
  }

  static const decltype(::web_package::mojom::VouchedSubset::sig)& sig(
      const ::web_package::mojom::VouchedSubsetPtr& input) {
    return input->sig;
  }

  static const decltype(::web_package::mojom::VouchedSubset::raw_signed)& raw_signed(
      const ::web_package::mojom::VouchedSubsetPtr& input) {
    return input->raw_signed;
  }

  static const decltype(::web_package::mojom::VouchedSubset::parsed_signed)& parsed_signed(
      const ::web_package::mojom::VouchedSubsetPtr& input) {
    return input->parsed_signed;
  }

  static bool Read(::web_package::mojom::VouchedSubset::DataView input, ::web_package::mojom::VouchedSubsetPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::SignedSubset::DataView,
                                         ::web_package::mojom::SignedSubsetPtr> {
  static bool IsNull(const ::web_package::mojom::SignedSubsetPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SignedSubsetPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::SignedSubset::validity_url)& validity_url(
      const ::web_package::mojom::SignedSubsetPtr& input) {
    return input->validity_url;
  }

  static const decltype(::web_package::mojom::SignedSubset::auth_sha256)& auth_sha256(
      const ::web_package::mojom::SignedSubsetPtr& input) {
    return input->auth_sha256;
  }

  static decltype(::web_package::mojom::SignedSubset::date) date(
      const ::web_package::mojom::SignedSubsetPtr& input) {
    return input->date;
  }

  static decltype(::web_package::mojom::SignedSubset::expires) expires(
      const ::web_package::mojom::SignedSubsetPtr& input) {
    return input->expires;
  }

  static const decltype(::web_package::mojom::SignedSubset::subset_hashes)& subset_hashes(
      const ::web_package::mojom::SignedSubsetPtr& input) {
    return input->subset_hashes;
  }

  static bool Read(::web_package::mojom::SignedSubset::DataView input, ::web_package::mojom::SignedSubsetPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::SubsetHashesValue::DataView,
                                         ::web_package::mojom::SubsetHashesValuePtr> {
  static bool IsNull(const ::web_package::mojom::SubsetHashesValuePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::SubsetHashesValuePtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::SubsetHashesValue::variants_value)& variants_value(
      const ::web_package::mojom::SubsetHashesValuePtr& input) {
    return input->variants_value;
  }

  static const decltype(::web_package::mojom::SubsetHashesValue::resource_integrities)& resource_integrities(
      const ::web_package::mojom::SubsetHashesValuePtr& input) {
    return input->resource_integrities;
  }

  static bool Read(::web_package::mojom::SubsetHashesValue::DataView input, ::web_package::mojom::SubsetHashesValuePtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::ResourceIntegrity::DataView,
                                         ::web_package::mojom::ResourceIntegrityPtr> {
  static bool IsNull(const ::web_package::mojom::ResourceIntegrityPtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::ResourceIntegrityPtr* output) { output->reset(); }

  static const decltype(::web_package::mojom::ResourceIntegrity::header_sha256)& header_sha256(
      const ::web_package::mojom::ResourceIntegrityPtr& input) {
    return input->header_sha256;
  }

  static const decltype(::web_package::mojom::ResourceIntegrity::payload_integrity_header)& payload_integrity_header(
      const ::web_package::mojom::ResourceIntegrityPtr& input) {
    return input->payload_integrity_header;
  }

  static bool Read(::web_package::mojom::ResourceIntegrity::DataView input, ::web_package::mojom::ResourceIntegrityPtr* output);
};


template <>
struct  StructTraits<::web_package::mojom::BundleResponse::DataView,
                                         ::web_package::mojom::BundleResponsePtr> {
  static bool IsNull(const ::web_package::mojom::BundleResponsePtr& input) { return !input; }
  static void SetToNull(::web_package::mojom::BundleResponsePtr* output) { output->reset(); }

  static decltype(::web_package::mojom::BundleResponse::response_code) response_code(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->response_code;
  }

  static const decltype(::web_package::mojom::BundleResponse::response_headers)& response_headers(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->response_headers;
  }

  static decltype(::web_package::mojom::BundleResponse::payload_offset) payload_offset(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->payload_offset;
  }

  static decltype(::web_package::mojom::BundleResponse::payload_length) payload_length(
      const ::web_package::mojom::BundleResponsePtr& input) {
    return input->payload_length;
  }

  static bool Read(::web_package::mojom::BundleResponse::DataView input, ::web_package::mojom::BundleResponsePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_H_