// components/web_cache/public/mojom/web_cache.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/web_cache/public/mojom/web_cache.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/web_cache/public/mojom/web_cache.mojom-params-data.h"
#include "components/web_cache/public/mojom/web_cache.mojom-shared-message-ids.h"

#include "components/web_cache/public/mojom/web_cache.mojom-import-headers.h"


#ifndef COMPONENTS_WEB_CACHE_PUBLIC_MOJOM_WEB_CACHE_MOJOM_JUMBO_H_
#define COMPONENTS_WEB_CACHE_PUBLIC_MOJOM_WEB_CACHE_MOJOM_JUMBO_H_
#endif
namespace web_cache {
namespace mojom {
const char WebCache::Name_[] = "web_cache.mojom.WebCache";

WebCacheProxy::WebCacheProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebCacheProxy::SetCacheCapacity(
    uint64_t in_capacity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_cache::mojom::WebCache::SetCacheCapacity", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("capacity", base::NumberToString(in_capacity));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebCache_SetCacheCapacity_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::web_cache::mojom::internal::WebCache_SetCacheCapacity_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->capacity = in_capacity;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebCache::Name_);
  message.set_method_name("SetCacheCapacity");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebCacheProxy::ClearCache(
    bool in_on_navigation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "web_cache::mojom::WebCache::ClearCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("on_navigation", in_on_navigation);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebCache_ClearCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::web_cache::mojom::internal::WebCache_ClearCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->on_navigation = in_on_navigation;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebCache::Name_);
  message.set_method_name("ClearCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebCacheStubDispatch::Accept(
    WebCache* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebCache_SetCacheCapacity_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_cache::mojom::WebCache::SetCacheCapacity",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_cache::mojom::WebCache::SetCacheCapacity");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebCache_SetCacheCapacity_Params_Data* params =
          reinterpret_cast<internal::WebCache_SetCacheCapacity_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_capacity{};
      WebCache_SetCacheCapacity_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_capacity = input_data_view.capacity();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebCache::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCacheCapacity(
std::move(p_capacity));
      return true;
    }
    case internal::kWebCache_ClearCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)web_cache::mojom::WebCache::ClearCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)web_cache::mojom::WebCache::ClearCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebCache_ClearCache_Params_Data* params =
          reinterpret_cast<internal::WebCache_ClearCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_on_navigation{};
      WebCache_ClearCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_on_navigation = input_data_view.on_navigation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebCache::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCache(
std::move(p_on_navigation));
      return true;
    }
  }
  return false;
}

// static
bool WebCacheStubDispatch::AcceptWithResponder(
    WebCache* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebCache_SetCacheCapacity_Name: {
      break;
    }
    case internal::kWebCache_ClearCache_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebCacheValidationInfo[] = {
    {internal::kWebCache_SetCacheCapacity_Name,
     {&internal::WebCache_SetCacheCapacity_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebCache_ClearCache_Name,
     {&internal::WebCache_ClearCache_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebCacheRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::web_cache::mojom::WebCache::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebCacheValidationInfo);
}

}  // namespace mojom
}  // namespace web_cache

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif