// ----------------------------------------------------------------------------
//
//  Copyright (C) 2018-2019 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JLR4FILT_H
#define __JLR4FILT_H


#include <zita-jclient.h>
#include <stdint.h>
#include "lr4filter.h"
#include "delay.h"


class Jlr4chan
{
private:

    friend class Jlr4filt;
    
    Jlr4chan (void);
    ~Jlr4chan (void);
    
    volatile int16_t   _nreq;
    volatile int16_t   _nack;
    int16_t            _mode;
    int16_t            _inp;
    float              _hpf, _hps;
    float              _lpf, _lps;
    Lr4filter          _hpfilt;
    Lr4filter          _lpfilt;
    float              _gain;
    int32_t            _delay;
    Delay              _dproc;
};


class Jlr4filt : public Jclient
{
public:

    Jlr4filt (const char *client_name, const char *server_name,
	      int ninp, int nout, float maxdel);
    virtual ~Jlr4filt (void);

    enum {  MAXINP = 100, MAXOUT = 100 };

    void set_filter (int inp, int out, float hpf, float hps, float lpf, float lps);
    void set_delay (int out, float delay);
    void set_gain (int out, float gain);

private:

    enum { HPF = 1, LPF = 2 };
    
    void init (float maxdel);
    int  jack_process (int nframes);

    Jlr4chan  *_chanpar;
    int32_t    _maxdel; 
};


#endif
