/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2024 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone.io                             **
**             Date: 01.01.2013                                           **
***************************************************************************/

#include "toolsoundspatialization_parameters.h"
#include "contextmanager.h"

void ToolSoundSpatialization_parameters::loadConfiguration()
{
    // Pattern description
    _pattern = getToolValue("pattern", 0).toInt();
    _divisionNumber = getToolValue("divisions", 1).toInt();
    _spreading = getToolValue("spreading", 100).toInt();
    _filling = getToolValue("filling", 100).toInt();
    _offset = getToolValue("offset", 50).toInt();
    
    // Flip / flop
    _flip = getToolValue("flip", false).toBool();
    _flop = getToolValue("flop", false).toBool();
}

void ToolSoundSpatialization_parameters::saveConfiguration()
{
    // Pattern description
    setToolValue("pattern", _pattern);
    setToolValue("divisions", _divisionNumber);
    setToolValue("spreading", _spreading);
    setToolValue("filling", _filling);
    setToolValue("offset", _offset);
    
    // Flip / flop
    setToolValue("flip", _flip);
    setToolValue("flop", _flop);
}
