/* Environment.c generated by valac 0.56.17, the Vala compiler
 * generated from Environment.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

VALA_EXTERN PlankXdgSessionClass plank_session_class;
PlankXdgSessionClass plank_session_class = 0;
VALA_EXTERN PlankXdgSessionDesktop plank_session_desktop;
PlankXdgSessionDesktop plank_session_desktop = 0U;
VALA_EXTERN PlankXdgSessionType plank_session_type;
PlankXdgSessionType plank_session_type = 0;

static PlankXdgSessionDesktop plank_xdg_session_desktop_from_single_string (const gchar* s);
VALA_EXTERN PlankXdgSessionClass plank_get_xdg_session_class (void);
VALA_EXTERN PlankXdgSessionDesktop plank_get_xdg_session_desktop (void);
VALA_EXTERN PlankXdgSessionType plank_get_xdg_session_type (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

PlankXdgSessionClass
plank_xdg_session_class_from_string (const gchar* s)
{
	PlankXdgSessionClass _result_ = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	PlankXdgSessionClass result;
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("greeter")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_CLASS_GREETER;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("lock-screen")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_CLASS_LOCK_SCREEN;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("background")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_CLASS_BACKGROUND;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_CLASS_USER;
				break;
			}
		}
	}
	result = _result_;
	return result;
}

static GType
plank_xdg_session_class_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_XDG_SESSION_CLASS_USER, "PLANK_XDG_SESSION_CLASS_USER", "user"}, {PLANK_XDG_SESSION_CLASS_GREETER, "PLANK_XDG_SESSION_CLASS_GREETER", "greeter"}, {PLANK_XDG_SESSION_CLASS_LOCK_SCREEN, "PLANK_XDG_SESSION_CLASS_LOCK_SCREEN", "lock-screen"}, {PLANK_XDG_SESSION_CLASS_BACKGROUND, "PLANK_XDG_SESSION_CLASS_BACKGROUND", "background"}, {0, NULL, NULL}};
	GType plank_xdg_session_class_type_id;
	plank_xdg_session_class_type_id = g_enum_register_static ("PlankXdgSessionClass", values);
	return plank_xdg_session_class_type_id;
}

GType
plank_xdg_session_class_get_type (void)
{
	static volatile gsize plank_xdg_session_class_type_id__once = 0;
	if (g_once_init_enter (&plank_xdg_session_class_type_id__once)) {
		GType plank_xdg_session_class_type_id;
		plank_xdg_session_class_type_id = plank_xdg_session_class_get_type_once ();
		g_once_init_leave (&plank_xdg_session_class_type_id__once, plank_xdg_session_class_type_id);
	}
	return plank_xdg_session_class_type_id__once;
}

static PlankXdgSessionDesktop
plank_xdg_session_desktop_from_single_string (const gchar* s)
{
	PlankXdgSessionDesktop _result_ = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	PlankXdgSessionDesktop result;
	g_return_val_if_fail (s != NULL, 0U);
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("gnome")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_GNOME;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("gnome-xorg")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_GNOME;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("ubuntu")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_UBUNTU;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ubuntu-xorg")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_UBUNTU;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("kde")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_KDE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("lxde")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_LXDE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("mate")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_MATE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("razor")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_RAZOR;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("rox")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_ROX;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("tde")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_TDE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("unity")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_UNITY;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("xfce")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_XFCE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("ede")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_EDE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("cinnamon")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_CINNAMON;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("pantheon")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_PANTHEON;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("old")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_DESKTOP_OLD;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_result_ = 0;
				break;
			}
		}
	}
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

PlankXdgSessionDesktop
plank_xdg_session_desktop_from_string (const gchar* s)
{
	PlankXdgSessionDesktop _result_ = 0U;
	PlankXdgSessionDesktop result;
	g_return_val_if_fail (s != NULL, 0U);
	_result_ = 0;
	if (string_contains (s, ";")) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		_tmp1_ = _tmp0_ = g_strsplit (s, ";", 0);
		{
			gchar** e_collection = NULL;
			gint e_collection_length1 = 0;
			gint _e_collection_size_ = 0;
			gint e_it = 0;
			e_collection = _tmp1_;
			e_collection_length1 = _vala_array_length (_tmp0_);
			for (e_it = 0; e_it < e_collection_length1; e_it = e_it + 1) {
				const gchar* e = NULL;
				e = e_collection[e_it];
				{
					const gchar* _tmp2_;
					_tmp2_ = e;
					if (_tmp2_ != NULL) {
						const gchar* _tmp3_;
						_tmp3_ = e;
						_result_ |= plank_xdg_session_desktop_from_single_string (_tmp3_);
					}
				}
			}
			e_collection = (_vala_array_free (e_collection, e_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	} else {
		_result_ = plank_xdg_session_desktop_from_single_string (s);
	}
	result = _result_;
	return result;
}

static GType
plank_xdg_session_desktop_get_type_once (void)
{
	static const GFlagsValue values[] = {{PLANK_XDG_SESSION_DESKTOP_GNOME, "PLANK_XDG_SESSION_DESKTOP_GNOME", "gnome"}, {PLANK_XDG_SESSION_DESKTOP_KDE, "PLANK_XDG_SESSION_DESKTOP_KDE", "kde"}, {PLANK_XDG_SESSION_DESKTOP_LXDE, "PLANK_XDG_SESSION_DESKTOP_LXDE", "lxde"}, {PLANK_XDG_SESSION_DESKTOP_MATE, "PLANK_XDG_SESSION_DESKTOP_MATE", "mate"}, {PLANK_XDG_SESSION_DESKTOP_RAZOR, "PLANK_XDG_SESSION_DESKTOP_RAZOR", "razor"}, {PLANK_XDG_SESSION_DESKTOP_ROX, "PLANK_XDG_SESSION_DESKTOP_ROX", "rox"}, {PLANK_XDG_SESSION_DESKTOP_TDE, "PLANK_XDG_SESSION_DESKTOP_TDE", "tde"}, {PLANK_XDG_SESSION_DESKTOP_UNITY, "PLANK_XDG_SESSION_DESKTOP_UNITY", "unity"}, {PLANK_XDG_SESSION_DESKTOP_XFCE, "PLANK_XDG_SESSION_DESKTOP_XFCE", "xfce"}, {PLANK_XDG_SESSION_DESKTOP_EDE, "PLANK_XDG_SESSION_DESKTOP_EDE", "ede"}, {PLANK_XDG_SESSION_DESKTOP_CINNAMON, "PLANK_XDG_SESSION_DESKTOP_CINNAMON", "cinnamon"}, {PLANK_XDG_SESSION_DESKTOP_PANTHEON, "PLANK_XDG_SESSION_DESKTOP_PANTHEON", "pantheon"}, {PLANK_XDG_SESSION_DESKTOP_OLD, "PLANK_XDG_SESSION_DESKTOP_OLD", "old"}, {PLANK_XDG_SESSION_DESKTOP_UBUNTU, "PLANK_XDG_SESSION_DESKTOP_UBUNTU", "ubuntu"}, {0, NULL, NULL}};
	GType plank_xdg_session_desktop_type_id;
	plank_xdg_session_desktop_type_id = g_flags_register_static ("PlankXdgSessionDesktop", values);
	return plank_xdg_session_desktop_type_id;
}

GType
plank_xdg_session_desktop_get_type (void)
{
	static volatile gsize plank_xdg_session_desktop_type_id__once = 0;
	if (g_once_init_enter (&plank_xdg_session_desktop_type_id__once)) {
		GType plank_xdg_session_desktop_type_id;
		plank_xdg_session_desktop_type_id = plank_xdg_session_desktop_get_type_once ();
		g_once_init_leave (&plank_xdg_session_desktop_type_id__once, plank_xdg_session_desktop_type_id);
	}
	return plank_xdg_session_desktop_type_id__once;
}

PlankXdgSessionType
plank_xdg_session_type_from_string (const gchar* s)
{
	PlankXdgSessionType _result_ = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	PlankXdgSessionType result;
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("tty")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_TYPE_TTY;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("x11")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_TYPE_X11;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("wayland")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_TYPE_WAYLAND;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("mir")))) {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_TYPE_MIR;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_result_ = PLANK_XDG_SESSION_TYPE_UNSPECIFIED;
				break;
			}
		}
	}
	result = _result_;
	return result;
}

static GType
plank_xdg_session_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_XDG_SESSION_TYPE_UNSPECIFIED, "PLANK_XDG_SESSION_TYPE_UNSPECIFIED", "unspecified"}, {PLANK_XDG_SESSION_TYPE_TTY, "PLANK_XDG_SESSION_TYPE_TTY", "tty"}, {PLANK_XDG_SESSION_TYPE_X11, "PLANK_XDG_SESSION_TYPE_X11", "x11"}, {PLANK_XDG_SESSION_TYPE_WAYLAND, "PLANK_XDG_SESSION_TYPE_WAYLAND", "wayland"}, {PLANK_XDG_SESSION_TYPE_MIR, "PLANK_XDG_SESSION_TYPE_MIR", "mir"}, {0, NULL, NULL}};
	GType plank_xdg_session_type_type_id;
	plank_xdg_session_type_type_id = g_enum_register_static ("PlankXdgSessionType", values);
	return plank_xdg_session_type_type_id;
}

GType
plank_xdg_session_type_get_type (void)
{
	static volatile gsize plank_xdg_session_type_type_id__once = 0;
	if (g_once_init_enter (&plank_xdg_session_type_type_id__once)) {
		GType plank_xdg_session_type_type_id;
		plank_xdg_session_type_type_id = plank_xdg_session_type_get_type_once ();
		g_once_init_leave (&plank_xdg_session_type_type_id__once, plank_xdg_session_type_type_id);
	}
	return plank_xdg_session_type_type_id__once;
}

void
plank_environment_initialize (void)
{
	plank_session_class = plank_get_xdg_session_class ();
	plank_session_desktop = plank_get_xdg_session_desktop ();
	plank_session_type = plank_get_xdg_session_type ();
}

gboolean
plank_environment_is_session_class (PlankXdgSessionClass type)
{
	gboolean result;
	result = type == plank_session_class;
	return result;
}

gboolean
plank_environment_is_session_desktop (PlankXdgSessionDesktop type)
{
	gboolean result;
	result = (plank_session_desktop & type) == type;
	return result;
}

gboolean
plank_environment_is_session_type (PlankXdgSessionType type)
{
	gboolean result;
	result = type == plank_session_type;
	return result;
}

PlankXdgSessionClass
plank_get_xdg_session_class (void)
{
	const gchar* _result_ = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	PlankXdgSessionClass result;
	_tmp0_ = g_getenv ("XDG_SESSION_CLASS");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = _result_;
		result = plank_xdg_session_class_from_string (_tmp2_);
		return result;
	}
	g_warning ("Environment.vala:165: XDG_SESSION_CLASS not set in this environment!");
	result = PLANK_XDG_SESSION_CLASS_USER;
	return result;
}

PlankXdgSessionDesktop
plank_get_xdg_session_desktop (void)
{
	const gchar* _result_ = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	PlankXdgSessionDesktop result;
	_tmp0_ = g_getenv ("XDG_SESSION_DESKTOP");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = g_getenv ("XDG_CURRENT_DESKTOP");
		_result_ = _tmp2_;
	}
	_tmp3_ = _result_;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = g_getenv ("DESKTOP_SESSION");
		_result_ = _tmp4_;
	}
	_tmp5_ = _result_;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = _result_;
		result = plank_xdg_session_desktop_from_string (_tmp6_);
		return result;
	}
	g_warning ("Environment.vala:183: Neither of XDG_SESSION_DESKTOP, XDG_CURRENT_DESK" \
"TOP or DESKTOP_SESSION is set in this environment!");
	result = PLANK_XDG_SESSION_DESKTOP_GNOME;
	return result;
}

PlankXdgSessionType
plank_get_xdg_session_type (void)
{
	const gchar* _result_ = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GdkScreen* _tmp3_;
	PlankXdgSessionType result;
	_tmp0_ = g_getenv ("XDG_SESSION_TYPE");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = _result_;
		result = plank_xdg_session_type_from_string (_tmp2_);
		return result;
	}
	g_warning ("Environment.vala:196: XDG_SESSION_TYPE not set in this environment!");
	_tmp3_ = gdk_screen_get_default ();
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_x11_screen_get_type ())) {
		result = PLANK_XDG_SESSION_TYPE_X11;
		return result;
	}
	g_error ("Environment.vala:201: XdgSessionType could not be determined!");
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

