/* Theme.c generated by valac 0.56.17, the Vala compiler
 * generated from Theme.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "gtk-compat.h"
#include <stdarg.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_THEME_0_PROPERTY,
	PLANK_THEME_TOP_ROUNDNESS_PROPERTY,
	PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY,
	PLANK_THEME_LINE_WIDTH_PROPERTY,
	PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY,
	PLANK_THEME_FILL_START_COLOR_PROPERTY,
	PLANK_THEME_FILL_END_COLOR_PROPERTY,
	PLANK_THEME_INNER_STROKE_COLOR_PROPERTY,
	PLANK_THEME_NUM_PROPERTIES
};
static GParamSpec* plank_theme_properties[PLANK_THEME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _PlankThemePrivate {
	gint _TopRoundness;
	gint _BottomRoundness;
	gint _LineWidth;
	PlankColor _OuterStrokeColor;
	PlankColor _FillStartColor;
	PlankColor _FillEndColor;
	PlankColor _InnerStrokeColor;
	GFile* theme_folder;
	GtkStyleContext* style_context;
};

static gint PlankTheme_private_offset;
static gpointer plank_theme_parent_class = NULL;

static void plank_theme_update_style_context (PlankTheme* self,
                                       const gchar* theme_name);
static void plank_theme_gtk_theme_name_changed (PlankTheme* self,
                                         GObject* o,
                                         GParamSpec* p);
static void plank_theme_real_reset_properties (PlankPreferences* base);
static void plank_theme_real_verify (PlankPreferences* base,
                              const gchar* prop);
static GFile* plank_theme_get_default_theme_folder (void);
static GFile* plank_theme_get_gtk_theme_folder (void);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static GObject * plank_theme_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _plank_theme_gtk_theme_name_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void plank_theme_finalize (GObject * obj);
static GType plank_theme_get_type_once (void);
static void _vala_plank_theme_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_plank_theme_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
plank_theme_get_instance_private (PlankTheme* self)
{
	return G_STRUCT_MEMBER_P (self, PlankTheme_private_offset);
}

GtkStyleContext*
plank_theme_create_style_context (GType widget_type,
                                  GtkStyleContext* parent_style,
                                  GtkCssProvider* provider,
                                  const gchar* object_name,
                                  const gchar* first_class,
                                  ...)
{
	GtkWidgetPath* path = NULL;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkWidgetPath* _tmp5_;
	GtkWidgetPath* _tmp7_;
	va_list name_list = {0};
	GtkStyleContext* _tmp14_;
	GtkWidgetPath* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkStyleContext* result;
	g_return_val_if_fail (provider != NULL, NULL);
	g_return_val_if_fail (first_class != NULL, NULL);
	_tmp0_ = gtk_style_context_new ();
	style = _tmp0_;
	_tmp1_ = style;
	gtk_style_context_set_parent (_tmp1_, parent_style);
	if (parent_style != NULL) {
		GtkWidgetPath* _tmp2_;
		GtkWidgetPath* _tmp3_;
		_tmp2_ = gtk_style_context_get_path (parent_style);
		_tmp3_ = gtk_widget_path_copy (_tmp2_);
		_gtk_widget_path_unref0 (path);
		path = _tmp3_;
	} else {
		GtkWidgetPath* _tmp4_;
		_tmp4_ = gtk_widget_path_new ();
		_gtk_widget_path_unref0 (path);
		path = _tmp4_;
	}
	_tmp5_ = path;
	gtk_widget_path_append_type (_tmp5_, widget_type);
	if (object_name != NULL) {
		GtkWidgetPath* _tmp6_;
		_tmp6_ = path;
		plank_compat_gtk_widget_path_iter_set_object_name (_tmp6_, -1, object_name);
	}
	_tmp7_ = path;
	gtk_widget_path_iter_add_class (_tmp7_, -1, first_class);
	va_start (name_list, first_class);
	{
		const gchar* name = NULL;
		const gchar* _tmp8_;
		_tmp8_ = va_arg (name_list, const gchar*);
		name = _tmp8_;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				const gchar* _tmp11_;
				GtkWidgetPath* _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp9_) {
					const gchar* _tmp10_;
					_tmp10_ = va_arg (name_list, const gchar*);
					name = _tmp10_;
				}
				_tmp9_ = FALSE;
				_tmp11_ = name;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = path;
				_tmp13_ = name;
				gtk_widget_path_iter_add_class (_tmp12_, -1, _tmp13_);
			}
		}
	}
	_tmp14_ = style;
	_tmp15_ = path;
	gtk_style_context_set_path (_tmp14_, _tmp15_);
	_tmp16_ = style;
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_SETTINGS);
	result = style;
	va_end (name_list);
	_gtk_widget_path_unref0 (path);
	return result;
}

PlankTheme*
plank_theme_construct (GType object_type)
{
	PlankTheme * self = NULL;
	GFile* _tmp0_;
	self = (PlankTheme*) plank_preferences_construct (object_type);
	_tmp0_ = plank_theme_get_theme_folder (PLANK_THEME_DEFAULT_NAME);
	_g_object_unref0 (self->priv->theme_folder);
	self->priv->theme_folder = _tmp0_;
	return self;
}

PlankTheme*
plank_theme_construct_with_name (GType object_type,
                                 const gchar* name)
{
	PlankTheme * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PlankTheme*) plank_preferences_construct (object_type);
	_tmp0_ = plank_theme_get_theme_folder (name);
	_g_object_unref0 (self->priv->theme_folder);
	self->priv->theme_folder = _tmp0_;
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_theme_update_style_context (PlankTheme* self,
                                  const gchar* theme_name)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	g_return_if_fail (self != NULL);
	if (theme_name != NULL) {
		GtkCssProvider* _tmp0_;
		GtkCssProvider* _tmp1_;
		_tmp0_ = gtk_css_provider_get_named (theme_name, NULL);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (provider);
		provider = _tmp1_;
	} else {
		GtkCssProvider* _tmp2_;
		GtkCssProvider* _tmp3_;
		_tmp2_ = gtk_css_provider_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (provider);
		provider = _tmp3_;
	}
	_tmp4_ = provider;
	_tmp5_ = plank_theme_create_style_context (gtk_icon_view_get_type (), NULL, _tmp4_, "iconview", GTK_STYLE_CLASS_VIEW, NULL);
	_g_object_unref0 (self->priv->style_context);
	self->priv->style_context = _tmp5_;
	_tmp6_ = self->priv->style_context;
	gtk_style_context_set_state (_tmp6_, GTK_STATE_FLAG_FOCUSED | GTK_STATE_FLAG_SELECTED);
	_g_object_unref0 (provider);
}

static void
plank_theme_gtk_theme_name_changed (PlankTheme* self,
                                    GObject* o,
                                    GParamSpec* p)
{
	gchar* theme_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GParamSpecBoolean* _tmp2_;
	GParamSpecBoolean* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (p != NULL);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (o, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	theme_name = _tmp1_;
	plank_theme_update_style_context (self, theme_name);
	_tmp2_ = (GParamSpecBoolean*) g_param_spec_boolean ("theme-changed", "theme-changed", "theme-changed", TRUE, G_PARAM_READABLE);
	_tmp3_ = _tmp2_;
	g_object_notify ((GObject*) self, (GParamSpec*) _tmp3_);
	_g_param_spec_unref0 (_tmp3_);
	_g_free0 (theme_name);
}

GtkStyleContext*
plank_theme_get_style_context (PlankTheme* self)
{
	GtkStyleContext* _tmp0_;
	GtkStyleContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->style_context;
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_theme_real_reset_properties (PlankPreferences* base)
{
	PlankTheme * self;
	PlankColor _tmp0_ = {0};
	PlankColor _tmp1_ = {0};
	PlankColor _tmp2_ = {0};
	PlankColor _tmp3_ = {0};
	self = (PlankTheme*) base;
	plank_theme_set_TopRoundness (self, 6);
	plank_theme_set_BottomRoundness (self, 6);
	plank_theme_set_LineWidth (self, 1);
	_tmp0_.red = 0.1647;
	_tmp0_.green = 0.1647;
	_tmp0_.blue = 0.1647;
	_tmp0_.alpha = 1.0;
	plank_theme_set_OuterStrokeColor (self, &_tmp0_);
	_tmp1_.red = 0.1647;
	_tmp1_.green = 0.1647;
	_tmp1_.blue = 0.1647;
	_tmp1_.alpha = 1.0;
	plank_theme_set_FillStartColor (self, &_tmp1_);
	_tmp2_.red = 0.3176;
	_tmp2_.green = 0.3176;
	_tmp2_.blue = 0.3176;
	_tmp2_.alpha = 1.0;
	plank_theme_set_FillEndColor (self, &_tmp2_);
	_tmp3_.red = 1.0;
	_tmp3_.green = 1.0;
	_tmp3_.blue = 1.0;
	_tmp3_.alpha = 1.0;
	plank_theme_set_InnerStrokeColor (self, &_tmp3_);
}

/**
 * Loads a theme for the renderer to use.
 *
 * @param type the type of theme to load
 */
void
plank_theme_load (PlankTheme* self,
                  const gchar* type)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->theme_folder;
	if (_tmp0_ == NULL) {
		plank_preferences_reset_properties ((PlankPreferences*) self);
		return;
	}
	_tmp1_ = self->priv->theme_folder;
	_tmp2_ = g_strdup_printf ("%s.theme", type);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	plank_preferences_init_from_file ((PlankPreferences*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
}

/**
 * Returns the top offset.
 *
 * @return the top offset
 */
gint
plank_theme_get_top_offset (PlankTheme* self)
{
	gint _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_LineWidth;
	result = 2 * _tmp0_;
	return result;
}

/**
 * Returns the bottom offset.
 *
 * @return the bottom offset
 */
gint
plank_theme_get_bottom_offset (PlankTheme* self)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_BottomRoundness;
	if (_tmp1_ > 0) {
		gint _tmp2_;
		_tmp2_ = self->priv->_LineWidth;
		_tmp0_ = 2 * _tmp2_;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

/**
 * Draws a background onto the surface.
 *
 * @param surface the surface to draw on
 */
void
plank_theme_draw_background (PlankTheme* self,
                             PlankSurface* surface)
{
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_pattern_t* gradient = NULL;
	gint width = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint height = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_;
	gint bottom_offset = 0;
	cairo_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	PlankColor _tmp13_;
	PlankColor _tmp14_;
	PlankColor _tmp15_;
	PlankColor _tmp16_;
	cairo_pattern_t* _tmp17_;
	PlankColor _tmp18_;
	PlankColor _tmp19_;
	PlankColor _tmp20_;
	PlankColor _tmp21_;
	cairo_t* _tmp22_;
	cairo_pattern_t* _tmp23_;
	cairo_t* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	PlankColor _tmp34_;
	PlankColor _tmp35_;
	PlankColor _tmp36_;
	PlankColor _tmp37_;
	cairo_t* _tmp38_;
	gint _tmp39_;
	cairo_t* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	cairo_pattern_t* _tmp43_;
	cairo_pattern_t* _tmp44_;
	PlankColor _tmp45_;
	PlankColor _tmp46_;
	PlankColor _tmp47_;
	gint _tmp48_ = 0;
	gint _tmp49_;
	cairo_pattern_t* _tmp52_;
	PlankColor _tmp53_;
	PlankColor _tmp54_;
	PlankColor _tmp55_;
	gint _tmp56_ = 0;
	gint _tmp57_;
	cairo_pattern_t* _tmp60_;
	PlankColor _tmp61_;
	PlankColor _tmp62_;
	PlankColor _tmp63_;
	cairo_pattern_t* _tmp64_;
	PlankColor _tmp65_;
	PlankColor _tmp66_;
	PlankColor _tmp67_;
	cairo_t* _tmp68_;
	cairo_pattern_t* _tmp69_;
	cairo_t* _tmp70_;
	cairo_t* _tmp71_;
	cairo_t* _tmp72_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	_tmp0_ = plank_surface_get_Context (surface);
	_tmp1_ = _tmp0_;
	cr = _tmp1_;
	_tmp2_ = plank_surface_get_Width (surface);
	_tmp3_ = _tmp2_;
	width = _tmp3_;
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	height = _tmp5_;
	_tmp7_ = self->priv->_BottomRoundness;
	if (_tmp7_ > 0) {
		gint _tmp8_;
		_tmp8_ = self->priv->_LineWidth;
		_tmp6_ = _tmp8_;
	} else {
		gint _tmp9_;
		_tmp9_ = self->priv->_LineWidth;
		_tmp6_ = -_tmp9_;
	}
	bottom_offset = _tmp6_;
	_tmp10_ = cr;
	cairo_save (_tmp10_);
	_tmp11_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) height);
	_cairo_pattern_destroy0 (gradient);
	gradient = _tmp11_;
	_tmp12_ = gradient;
	_tmp13_ = self->priv->_FillStartColor;
	_tmp14_ = self->priv->_FillStartColor;
	_tmp15_ = self->priv->_FillStartColor;
	_tmp16_ = self->priv->_FillStartColor;
	cairo_pattern_add_color_stop_rgba (_tmp12_, (gdouble) 0, _tmp13_.red, _tmp14_.green, _tmp15_.blue, _tmp16_.alpha);
	_tmp17_ = gradient;
	_tmp18_ = self->priv->_FillEndColor;
	_tmp19_ = self->priv->_FillEndColor;
	_tmp20_ = self->priv->_FillEndColor;
	_tmp21_ = self->priv->_FillEndColor;
	cairo_pattern_add_color_stop_rgba (_tmp17_, (gdouble) 1, _tmp18_.red, _tmp19_.green, _tmp20_.blue, _tmp21_.alpha);
	_tmp22_ = cr;
	_tmp23_ = gradient;
	cairo_set_source (_tmp22_, _tmp23_);
	_tmp24_ = cr;
	_tmp25_ = self->priv->_LineWidth;
	_tmp26_ = self->priv->_LineWidth;
	_tmp27_ = self->priv->_LineWidth;
	_tmp28_ = self->priv->_LineWidth;
	_tmp29_ = self->priv->_TopRoundness;
	_tmp30_ = self->priv->_BottomRoundness;
	_tmp31_ = self->priv->_LineWidth;
	plank_theme_draw_rounded_rect (_tmp24_, _tmp25_ / 2.0, _tmp26_ / 2.0, (gdouble) (width - _tmp27_), (height - (_tmp28_ / 2.0)) - (bottom_offset / 2.0), (gdouble) _tmp29_, (gdouble) _tmp30_, (gdouble) _tmp31_);
	_tmp32_ = cr;
	cairo_fill_preserve (_tmp32_);
	_tmp33_ = cr;
	_tmp34_ = self->priv->_OuterStrokeColor;
	_tmp35_ = self->priv->_OuterStrokeColor;
	_tmp36_ = self->priv->_OuterStrokeColor;
	_tmp37_ = self->priv->_OuterStrokeColor;
	cairo_set_source_rgba (_tmp33_, _tmp34_.red, _tmp35_.green, _tmp36_.blue, _tmp37_.alpha);
	_tmp38_ = cr;
	_tmp39_ = self->priv->_LineWidth;
	cairo_set_line_width (_tmp38_, (gdouble) _tmp39_);
	_tmp40_ = cr;
	cairo_stroke (_tmp40_);
	_tmp41_ = self->priv->_LineWidth;
	_tmp42_ = self->priv->_LineWidth;
	_tmp43_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (2 * _tmp41_), (gdouble) 0, (gdouble) ((height - (2 * _tmp42_)) - bottom_offset));
	_cairo_pattern_destroy0 (gradient);
	gradient = _tmp43_;
	_tmp44_ = gradient;
	_tmp45_ = self->priv->_InnerStrokeColor;
	_tmp46_ = self->priv->_InnerStrokeColor;
	_tmp47_ = self->priv->_InnerStrokeColor;
	cairo_pattern_add_color_stop_rgba (_tmp44_, (gdouble) 0, _tmp45_.red, _tmp46_.green, _tmp47_.blue, 0.5);
	_tmp49_ = self->priv->_TopRoundness;
	if (_tmp49_ > 0) {
		gint _tmp50_;
		_tmp50_ = self->priv->_TopRoundness;
		_tmp48_ = _tmp50_;
	} else {
		gint _tmp51_;
		_tmp51_ = self->priv->_LineWidth;
		_tmp48_ = _tmp51_;
	}
	_tmp52_ = gradient;
	_tmp53_ = self->priv->_InnerStrokeColor;
	_tmp54_ = self->priv->_InnerStrokeColor;
	_tmp55_ = self->priv->_InnerStrokeColor;
	cairo_pattern_add_color_stop_rgba (_tmp52_, _tmp48_ / ((gdouble) height), _tmp53_.red, _tmp54_.green, _tmp55_.blue, 0.12);
	_tmp57_ = self->priv->_BottomRoundness;
	if (_tmp57_ > 0) {
		gint _tmp58_;
		_tmp58_ = self->priv->_BottomRoundness;
		_tmp56_ = _tmp58_;
	} else {
		gint _tmp59_;
		_tmp59_ = self->priv->_LineWidth;
		_tmp56_ = _tmp59_;
	}
	_tmp60_ = gradient;
	_tmp61_ = self->priv->_InnerStrokeColor;
	_tmp62_ = self->priv->_InnerStrokeColor;
	_tmp63_ = self->priv->_InnerStrokeColor;
	cairo_pattern_add_color_stop_rgba (_tmp60_, 1 - (_tmp56_ / ((gdouble) height)), _tmp61_.red, _tmp62_.green, _tmp63_.blue, 0.08);
	_tmp64_ = gradient;
	_tmp65_ = self->priv->_InnerStrokeColor;
	_tmp66_ = self->priv->_InnerStrokeColor;
	_tmp67_ = self->priv->_InnerStrokeColor;
	cairo_pattern_add_color_stop_rgba (_tmp64_, (gdouble) 1, _tmp65_.red, _tmp66_.green, _tmp67_.blue, 0.19);
	_tmp68_ = cr;
	_tmp69_ = gradient;
	cairo_set_source (_tmp68_, _tmp69_);
	_tmp70_ = cr;
	plank_theme_draw_inner_rect (self, _tmp70_, width, height);
	_tmp71_ = cr;
	cairo_stroke (_tmp71_);
	_tmp72_ = cr;
	cairo_restore (_tmp72_);
	_cairo_pattern_destroy0 (gradient);
}

/**
 * Similar to draw_rounded_rect, but moves in to avoid a containing rounded rect's lines.
 *
 * @param cr the context to draw with
 * @param width the width of the rect
 * @param height the height of the rect
 */
void
plank_theme_draw_inner_rect (PlankTheme* self,
                             cairo_t* cr,
                             gint width,
                             gint height)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint bottom_offset = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp1_ = self->priv->_BottomRoundness;
	if (_tmp1_ > 0) {
		gint _tmp2_;
		_tmp2_ = self->priv->_LineWidth;
		_tmp0_ = _tmp2_;
	} else {
		gint _tmp3_;
		_tmp3_ = self->priv->_LineWidth;
		_tmp0_ = -_tmp3_;
	}
	bottom_offset = _tmp0_;
	_tmp4_ = self->priv->_LineWidth;
	_tmp5_ = self->priv->_LineWidth;
	_tmp6_ = self->priv->_LineWidth;
	_tmp7_ = self->priv->_LineWidth;
	_tmp8_ = self->priv->_TopRoundness;
	_tmp9_ = self->priv->_LineWidth;
	_tmp10_ = self->priv->_BottomRoundness;
	_tmp11_ = self->priv->_LineWidth;
	_tmp12_ = self->priv->_LineWidth;
	plank_theme_draw_rounded_rect (cr, (3 * _tmp4_) / 2.0, (3 * _tmp5_) / 2.0, (gdouble) (width - (3 * _tmp6_)), (height - ((3 * _tmp7_) / 2.0)) - ((3 * bottom_offset) / 2.0), (gdouble) (_tmp8_ - _tmp9_), (gdouble) (_tmp10_ - _tmp11_), (gdouble) _tmp12_);
}

/**
 * Draws a rounded rectangle.  If compositing is disabled, just draws a normal rectangle.
 *
 * @param cr the context to draw with
 * @param x the x location of the rect
 * @param y the y location of the rect
 * @param width the width of the rect
 * @param height the height of the rect
 * @param top_radius the roundedness of the top edge
 * @param bottom_radius the roundedness of the bottom edge
 * @param line_width the line-width of the rect
 */
void
plank_theme_draw_rounded_rect (cairo_t* cr,
                               gdouble x,
                               gdouble y,
                               gdouble width,
                               gdouble height,
                               gdouble top_radius,
                               gdouble bottom_radius,
                               gdouble line_width)
{
	gdouble min_size = 0.0;
	GdkScreen* _tmp0_;
	g_return_if_fail (cr != NULL);
	min_size = MIN (width, height);
	top_radius = CLAMP (top_radius, 0.0, min_size);
	bottom_radius = CLAMP (bottom_radius, 0.0, min_size - top_radius);
	_tmp0_ = gdk_screen_get_default ();
	if (!gdk_screen_is_composited (_tmp0_)) {
		bottom_radius = 0.0;
		top_radius = bottom_radius;
	}
	if (top_radius == 0.0) {
		cairo_move_to (cr, x - (line_width / 2.0), y);
	} else {
		cairo_move_to (cr, x + top_radius, y);
	}
	cairo_arc (cr, (x + width) - top_radius, y + top_radius, top_radius, -G_PI_2, (gdouble) 0);
	cairo_arc (cr, (x + width) - bottom_radius, (y + height) - bottom_radius, bottom_radius, (gdouble) 0, G_PI_2);
	cairo_arc (cr, x + bottom_radius, (y + height) - bottom_radius, bottom_radius, G_PI_2, G_PI);
	cairo_arc (cr, x + top_radius, y + top_radius, top_radius, G_PI, -G_PI_2);
	cairo_close_path (cr);
}

/**
 * Draws a rounded horizontal line.
 *
 * @param cr the context to draw with
 * @param x the x location of the line
 * @param y the y location of the line
 * @param width the width of the line
 * @param height the height of the line
 * @param is_round_left weather the left is round or not
 * @param is_round_right weather the right is round or not
 * @param stroke filling style of the outline
 * @param fill filling style of the inner area
 */
void
plank_theme_draw_rounded_line (cairo_t* cr,
                               gdouble x,
                               gdouble y,
                               gdouble width,
                               gdouble height,
                               gboolean is_round_left,
                               gboolean is_round_right,
                               cairo_pattern_t* stroke,
                               cairo_pattern_t* fill)
{
	gdouble _tmp0_ = 0.0;
	gdouble left_radius = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble right_radius = 0.0;
	g_return_if_fail (cr != NULL);
	if (height > width) {
		y = y + floor ((height - width) / 2.0);
		height = width;
	}
	height = 2.0 * floor (height / 2.0);
	if (is_round_left) {
		_tmp0_ = height / 2.0;
	} else {
		_tmp0_ = 0.0;
	}
	left_radius = _tmp0_;
	if (is_round_right) {
		_tmp1_ = height / 2.0;
	} else {
		_tmp1_ = 0.0;
	}
	right_radius = _tmp1_;
	cairo_move_to (cr, (x + width) - right_radius, y);
	cairo_line_to (cr, x + left_radius, y);
	if (is_round_left) {
		cairo_arc_negative (cr, x + left_radius, y + left_radius, left_radius, -G_PI_2, G_PI_2);
	} else {
		cairo_line_to (cr, x, y + height);
	}
	cairo_line_to (cr, (x + width) - right_radius, y + height);
	if (is_round_right) {
		cairo_arc_negative (cr, (x + width) - right_radius, y + right_radius, right_radius, G_PI_2, -G_PI_2);
	} else {
		cairo_line_to (cr, x + width, y);
	}
	cairo_close_path (cr);
	if (fill != NULL) {
		cairo_set_source (cr, fill);
		cairo_fill_preserve (cr);
	}
	if (stroke != NULL) {
		cairo_set_source (cr, stroke);
	}
	cairo_stroke (cr);
}

/**
 * {@inheritDoc}
 */
static void
plank_theme_real_verify (PlankPreferences* base,
                         const gchar* prop)
{
	PlankTheme * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	self = (PlankTheme*) base;
	g_return_if_fail (prop != NULL);
	PLANK_PREFERENCES_CLASS (plank_theme_parent_class)->verify (G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_PREFERENCES, PlankPreferences), prop);
	_tmp0_ = prop;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("TopRoundness")))) {
		switch (0) {
			default:
			{
				gint _tmp3_;
				_tmp3_ = self->priv->_TopRoundness;
				if (_tmp3_ < 0) {
					plank_theme_set_TopRoundness (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("BottomRoundness")))) {
		switch (0) {
			default:
			{
				gint _tmp4_;
				_tmp4_ = self->priv->_BottomRoundness;
				if (_tmp4_ < 0) {
					plank_theme_set_BottomRoundness (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("LineWidth")))) {
		switch (0) {
			default:
			{
				gint _tmp5_;
				_tmp5_ = self->priv->_LineWidth;
				if (_tmp5_ < 0) {
					plank_theme_set_LineWidth (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("OuterStrokeColor")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("FillStartColor")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("FillEndColor")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("InnerStrokeColor")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

/**
 * Get a sorted array of all available theme-names
 *
 * @return array containing all available theme-names
 */
gchar**
plank_theme_get_theme_list (gint* result_length1)
{
	GeeHashSet* list = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp31_;
	GeeHashSet* _tmp32_;
	gint _tmp33_ = 0;
	gpointer* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, PLANK_THEME_DEFAULT_NAME);
	_tmp2_ = list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, PLANK_THEME_GTK_THEME_NAME);
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileInfo* info = NULL;
		_tmp3_ = plank_paths_get_AppThemeFolder ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_enumerate_children (_tmp4_, "standard::name,standard::type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp6_ = NULL;
			GFileEnumerator* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GFileInfo* _tmp12_;
			GeeHashSet* _tmp14_;
			GFileInfo* _tmp15_;
			const gchar* _tmp16_;
			_tmp7_ = enumerator;
			_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (info);
			info = _tmp9_;
			_tmp10_ = info;
			if (!(_tmp10_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				break;
			}
			_tmp12_ = info;
			if (g_file_info_get_is_hidden (_tmp12_)) {
				_tmp11_ = TRUE;
			} else {
				GFileInfo* _tmp13_;
				_tmp13_ = info;
				_tmp11_ = g_file_info_get_file_type (_tmp13_) != G_FILE_TYPE_DIRECTORY;
			}
			if (_tmp11_) {
				_g_object_unref0 (_tmp6_);
				continue;
			}
			_tmp14_ = list;
			_tmp15_ = info;
			_tmp16_ = g_file_info_get_name (_tmp15_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp16_);
			_g_object_unref0 (_tmp6_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFileEnumerator* _tmp19_;
		GFileInfo* info = NULL;
		_tmp17_ = plank_paths_get_ThemeFolder ();
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_enumerate_children (_tmp18_, "standard::name,standard::type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp20_ = NULL;
			GFileEnumerator* _tmp21_;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
			GFileInfo* _tmp24_;
			gboolean _tmp25_ = FALSE;
			GFileInfo* _tmp26_;
			GeeHashSet* _tmp28_;
			GFileInfo* _tmp29_;
			const gchar* _tmp30_;
			_tmp21_ = enumerator;
			_tmp22_ = g_file_enumerator_next_file (_tmp21_, NULL, &_inner_error0_);
			_tmp20_ = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch1_g_error;
			}
			_tmp23_ = _tmp20_;
			_tmp20_ = NULL;
			_g_object_unref0 (info);
			info = _tmp23_;
			_tmp24_ = info;
			if (!(_tmp24_ != NULL)) {
				_g_object_unref0 (_tmp20_);
				break;
			}
			_tmp26_ = info;
			if (g_file_info_get_is_hidden (_tmp26_)) {
				_tmp25_ = TRUE;
			} else {
				GFileInfo* _tmp27_;
				_tmp27_ = info;
				_tmp25_ = g_file_info_get_file_type (_tmp27_) != G_FILE_TYPE_DIRECTORY;
			}
			if (_tmp25_) {
				_g_object_unref0 (_tmp20_);
				continue;
			}
			_tmp28_ = list;
			_tmp29_ = info;
			_tmp30_ = g_file_info_get_name (_tmp29_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp30_);
			_g_object_unref0 (_tmp20_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp31_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp31_;
	_tmp32_ = list;
	gee_array_list_add_all (_result_, (GeeCollection*) _tmp32_);
	gee_list_sort ((GeeList*) _result_, NULL, NULL, NULL);
	_tmp34_ = gee_collection_to_array ((GeeCollection*) _result_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_object_unref0 (_result_);
	_g_object_unref0 (list);
	return result;
}

/**
 * Try to get an already existing folder located in the
 * themes folder while prefering the user's themes folder.
 * If there is no folder found we fallback to the "Default" theme.
 * If even that folder doesn't exist return NULL (and use built-in defaults)
 *
 * @param name the basename of the folder
 * @return {@link GLib.File} the folder of the theme or NULL
 */
GFile*
plank_theme_get_theme_folder (const gchar* name)
{
	GFile* folder = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GFile* _tmp12_;
	GFile* _tmp14_;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	if (g_strcmp0 (name, PLANK_THEME_DEFAULT_NAME) == 0) {
		GFile* _tmp0_;
		_tmp0_ = plank_theme_get_default_theme_folder ();
		result = _tmp0_;
		return result;
	}
	if (g_strcmp0 (name, PLANK_THEME_GTK_THEME_NAME) == 0) {
		GFile* _tmp1_;
		_tmp1_ = plank_theme_get_gtk_theme_folder ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = plank_paths_get_AppThemeFolder ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp3_, name);
	_g_object_unref0 (folder);
	folder = _tmp4_;
	_tmp6_ = folder;
	if (g_file_query_exists (_tmp6_, NULL)) {
		GFile* _tmp7_;
		_tmp7_ = folder;
		_tmp5_ = g_file_query_file_type (_tmp7_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = folder;
		return result;
	}
	_tmp8_ = plank_paths_get_ThemeFolder ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_child (_tmp9_, name);
	_g_object_unref0 (folder);
	folder = _tmp10_;
	_tmp12_ = folder;
	if (g_file_query_exists (_tmp12_, NULL)) {
		GFile* _tmp13_;
		_tmp13_ = folder;
		_tmp11_ = g_file_query_file_type (_tmp13_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = folder;
		return result;
	}
	g_warning ("Theme.vala:450: %s not found, falling back to %s.", name, PLANK_THEME_DEFAULT_NAME);
	_tmp14_ = plank_theme_get_default_theme_folder ();
	result = _tmp14_;
	_g_object_unref0 (folder);
	return result;
}

static GFile*
plank_theme_get_default_theme_folder (void)
{
	GFile* folder = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* result;
	_tmp0_ = plank_paths_get_ThemeFolder ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, PLANK_THEME_DEFAULT_NAME);
	_g_object_unref0 (folder);
	folder = _tmp2_;
	_tmp4_ = folder;
	if (g_file_query_exists (_tmp4_, NULL)) {
		GFile* _tmp5_;
		_tmp5_ = folder;
		_tmp3_ = g_file_query_file_type (_tmp5_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = folder;
		return result;
	}
	_tmp6_ = folder;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	g_warning ("Theme.vala:465: %s is not a folder fallback to the built-in defaults!", _tmp8_);
	_g_free0 (_tmp8_);
	result = NULL;
	_g_object_unref0 (folder);
	return result;
}

static GFile*
plank_theme_get_gtk_theme_folder (void)
{
	GFile* folder = NULL;
	const gchar* exec_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* name = NULL;
	GtkSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	const gchar* _tmp51_;
	GFile* result;
	_tmp0_ = plank_paths_get_AppName ();
	_tmp1_ = _tmp0_;
	exec_name = _tmp1_;
	_tmp2_ = gtk_settings_get_default ();
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	name = _tmp4_;
	_tmp5_ = plank_paths_get_DataHomeFolder ();
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = g_strdup_printf ("themes/%s", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_child (_tmp6_, _tmp9_);
	_g_object_unref0 (folder);
	folder = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = folder;
	if (g_file_query_exists (_tmp11_, NULL)) {
		GFile* _tmp12_;
		const gchar* _tmp13_;
		GFile* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		const gchar* _tmp18_;
		_tmp12_ = folder;
		_tmp13_ = exec_name;
		_tmp14_ = g_file_get_child (_tmp12_, _tmp13_);
		_g_object_unref0 (folder);
		folder = _tmp14_;
		_tmp16_ = folder;
		if (g_file_query_exists (_tmp16_, NULL)) {
			GFile* _tmp17_;
			_tmp17_ = folder;
			_tmp15_ = g_file_query_file_type (_tmp17_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			result = folder;
			_g_free0 (name);
			return result;
		}
		_tmp18_ = name;
		g_warning ("Theme.vala:484: Currently selected gtk+ theme '%s' does not provide a " \
"dock theme, fallback to the built-in defaults!", _tmp18_);
		result = NULL;
		_g_free0 (name);
		_g_object_unref0 (folder);
		return result;
	}
	_tmp19_ = plank_paths_get_HomeFolder ();
	_tmp20_ = _tmp19_;
	_tmp21_ = name;
	_tmp22_ = g_strdup_printf (".themes/%s", _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_file_get_child (_tmp20_, _tmp23_);
	_g_object_unref0 (folder);
	folder = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = folder;
	if (g_file_query_exists (_tmp25_, NULL)) {
		GFile* _tmp26_;
		const gchar* _tmp27_;
		GFile* _tmp28_;
		gboolean _tmp29_ = FALSE;
		GFile* _tmp30_;
		const gchar* _tmp32_;
		_tmp26_ = folder;
		_tmp27_ = exec_name;
		_tmp28_ = g_file_get_child (_tmp26_, _tmp27_);
		_g_object_unref0 (folder);
		folder = _tmp28_;
		_tmp30_ = folder;
		if (g_file_query_exists (_tmp30_, NULL)) {
			GFile* _tmp31_;
			_tmp31_ = folder;
			_tmp29_ = g_file_query_file_type (_tmp31_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			result = folder;
			_g_free0 (name);
			return result;
		}
		_tmp32_ = name;
		g_warning ("Theme.vala:496: Currently selected gtk+ theme '%s' does not provide a " \
"dock theme, fallback to the built-in defaults!", _tmp32_);
		result = NULL;
		_g_free0 (name);
		_g_object_unref0 (folder);
		return result;
	}
	{
		GeeArrayList* _datafolder_list = NULL;
		GeeArrayList* _tmp33_;
		GeeArrayList* _tmp34_;
		gint _datafolder_size = 0;
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _datafolder_index = 0;
		_tmp33_ = plank_paths_get_DataDirFolders ();
		_tmp34_ = _tmp33_;
		_datafolder_list = _tmp34_;
		_tmp35_ = _datafolder_list;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_datafolder_size = _tmp37_;
		_datafolder_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			GFile* datafolder = NULL;
			GeeArrayList* _tmp40_;
			gpointer _tmp41_;
			GFile* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			GFile* _tmp47_;
			gboolean _tmp48_ = FALSE;
			GFile* _tmp49_;
			_datafolder_index = _datafolder_index + 1;
			_tmp38_ = _datafolder_index;
			_tmp39_ = _datafolder_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _datafolder_list;
			_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _datafolder_index);
			datafolder = (GFile*) _tmp41_;
			_tmp42_ = datafolder;
			_tmp43_ = name;
			_tmp44_ = exec_name;
			_tmp45_ = g_strdup_printf ("themes/%s/%s", _tmp43_, _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_file_get_child (_tmp42_, _tmp46_);
			_g_object_unref0 (folder);
			folder = _tmp47_;
			_g_free0 (_tmp46_);
			_tmp49_ = folder;
			if (g_file_query_exists (_tmp49_, NULL)) {
				GFile* _tmp50_;
				_tmp50_ = folder;
				_tmp48_ = g_file_query_file_type (_tmp50_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				result = folder;
				_g_object_unref0 (datafolder);
				_g_free0 (name);
				return result;
			}
			_g_object_unref0 (datafolder);
		}
	}
	_tmp51_ = name;
	g_warning ("Theme.vala:508: Currently selected gtk+ theme '%s' does not provide a " \
"dock theme, fallback to the built-in defaults!", _tmp51_);
	result = NULL;
	_g_free0 (name);
	_g_object_unref0 (folder);
	return result;
}

gint
plank_theme_get_TopRoundness (PlankTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_TopRoundness;
	return result;
}

void
plank_theme_set_TopRoundness (PlankTheme* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_theme_get_TopRoundness (self);
	if (old_value != value) {
		self->priv->_TopRoundness = value;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_TOP_ROUNDNESS_PROPERTY]);
	}
}

gint
plank_theme_get_BottomRoundness (PlankTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_BottomRoundness;
	return result;
}

void
plank_theme_set_BottomRoundness (PlankTheme* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_theme_get_BottomRoundness (self);
	if (old_value != value) {
		self->priv->_BottomRoundness = value;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY]);
	}
}

gint
plank_theme_get_LineWidth (PlankTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_LineWidth;
	return result;
}

void
plank_theme_set_LineWidth (PlankTheme* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_theme_get_LineWidth (self);
	if (old_value != value) {
		self->priv->_LineWidth = value;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_LINE_WIDTH_PROPERTY]);
	}
}

void
plank_theme_get_OuterStrokeColor (PlankTheme* self,
                                  PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_OuterStrokeColor;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
plank_theme_set_OuterStrokeColor (PlankTheme* self,
                                  PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_theme_get_OuterStrokeColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_OuterStrokeColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY]);
	}
}

void
plank_theme_get_FillStartColor (PlankTheme* self,
                                PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_FillStartColor;
	*result = _tmp0_;
	return;
}

void
plank_theme_set_FillStartColor (PlankTheme* self,
                                PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_theme_get_FillStartColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_FillStartColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_FILL_START_COLOR_PROPERTY]);
	}
}

void
plank_theme_get_FillEndColor (PlankTheme* self,
                              PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_FillEndColor;
	*result = _tmp0_;
	return;
}

void
plank_theme_set_FillEndColor (PlankTheme* self,
                              PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_theme_get_FillEndColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_FillEndColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_FILL_END_COLOR_PROPERTY]);
	}
}

void
plank_theme_get_InnerStrokeColor (PlankTheme* self,
                                  PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_InnerStrokeColor;
	*result = _tmp0_;
	return;
}

void
plank_theme_set_InnerStrokeColor (PlankTheme* self,
                                  PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_theme_get_InnerStrokeColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_InnerStrokeColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_theme_properties[PLANK_THEME_INNER_STROKE_COLOR_PROPERTY]);
	}
}

static void
_plank_theme_gtk_theme_name_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	plank_theme_gtk_theme_name_changed ((PlankTheme*) self, _sender, pspec);
}

static GObject *
plank_theme_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankTheme * self;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	gchar* theme_name = NULL;
	GtkSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkSettings* _tmp5_;
	parent_class = G_OBJECT_CLASS (plank_theme_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_THEME, PlankTheme);
	_tmp0_ = gtk_settings_get_default ();
	gtk_settings = _tmp0_;
	_tmp1_ = gtk_settings;
	g_object_get (_tmp1_, "gtk-theme-name", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	theme_name = _tmp3_;
	_tmp4_ = theme_name;
	plank_theme_update_style_context (self, _tmp4_);
	_tmp5_ = gtk_settings;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::gtk-theme-name", (GCallback) _plank_theme_gtk_theme_name_changed_g_object_notify, self, 0);
	_g_free0 (theme_name);
	return obj;
}

static void
plank_theme_class_init (PlankThemeClass * klass,
                        gpointer klass_data)
{
	plank_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankTheme_private_offset);
	((PlankPreferencesClass *) klass)->reset_properties = (void (*) (PlankPreferences*)) plank_theme_real_reset_properties;
	((PlankPreferencesClass *) klass)->verify = (void (*) (PlankPreferences*, const gchar*)) plank_theme_real_verify;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_theme_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_theme_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_theme_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_TOP_ROUNDNESS_PROPERTY, plank_theme_properties[PLANK_THEME_TOP_ROUNDNESS_PROPERTY] = g_param_spec_int ("TopRoundness", "top-roundness", "The roundness of the top corners.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY, plank_theme_properties[PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY] = g_param_spec_int ("BottomRoundness", "bottom-roundness", "The roundness of the bottom corners.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_LINE_WIDTH_PROPERTY, plank_theme_properties[PLANK_THEME_LINE_WIDTH_PROPERTY] = g_param_spec_int ("LineWidth", "line-width", "The thickness (in pixels) of lines drawn.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY, plank_theme_properties[PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY] = g_param_spec_boxed ("OuterStrokeColor", "outer-stroke-color", "The color (RGBA) of the outer stroke.", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_FILL_START_COLOR_PROPERTY, plank_theme_properties[PLANK_THEME_FILL_START_COLOR_PROPERTY] = g_param_spec_boxed ("FillStartColor", "fill-start-color", "The starting color (RGBA) of the fill gradient.", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_FILL_END_COLOR_PROPERTY, plank_theme_properties[PLANK_THEME_FILL_END_COLOR_PROPERTY] = g_param_spec_boxed ("FillEndColor", "fill-end-color", "The ending color (RGBA) of the fill gradient.", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_THEME_INNER_STROKE_COLOR_PROPERTY, plank_theme_properties[PLANK_THEME_INNER_STROKE_COLOR_PROPERTY] = g_param_spec_boxed ("InnerStrokeColor", "inner-stroke-color", "The color (RGBA) of the inner stroke.", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
plank_theme_instance_init (PlankTheme * self,
                           gpointer klass)
{
	self->priv = plank_theme_get_instance_private (self);
}

static void
plank_theme_finalize (GObject * obj)
{
	PlankTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_THEME, PlankTheme);
	_g_object_unref0 (self->priv->theme_folder);
	_g_object_unref0 (self->priv->style_context);
	G_OBJECT_CLASS (plank_theme_parent_class)->finalize (obj);
}

/**
 * A themed renderer for windows.
 */
static GType
plank_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankTheme), 0, (GInstanceInitFunc) plank_theme_instance_init, NULL };
	GType plank_theme_type_id;
	plank_theme_type_id = g_type_register_static (PLANK_TYPE_PREFERENCES, "PlankTheme", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankTheme_private_offset = g_type_add_instance_private (plank_theme_type_id, sizeof (PlankThemePrivate));
	return plank_theme_type_id;
}

GType
plank_theme_get_type (void)
{
	static volatile gsize plank_theme_type_id__once = 0;
	if (g_once_init_enter (&plank_theme_type_id__once)) {
		GType plank_theme_type_id;
		plank_theme_type_id = plank_theme_get_type_once ();
		g_once_init_leave (&plank_theme_type_id__once, plank_theme_type_id);
	}
	return plank_theme_type_id__once;
}

static void
_vala_plank_theme_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PlankTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_THEME, PlankTheme);
	switch (property_id) {
		case PLANK_THEME_TOP_ROUNDNESS_PROPERTY:
		g_value_set_int (value, plank_theme_get_TopRoundness (self));
		break;
		case PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY:
		g_value_set_int (value, plank_theme_get_BottomRoundness (self));
		break;
		case PLANK_THEME_LINE_WIDTH_PROPERTY:
		g_value_set_int (value, plank_theme_get_LineWidth (self));
		break;
		case PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_theme_get_OuterStrokeColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case PLANK_THEME_FILL_START_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_theme_get_FillStartColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case PLANK_THEME_FILL_END_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_theme_get_FillEndColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case PLANK_THEME_INNER_STROKE_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_theme_get_InnerStrokeColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_theme_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PlankTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_THEME, PlankTheme);
	switch (property_id) {
		case PLANK_THEME_TOP_ROUNDNESS_PROPERTY:
		plank_theme_set_TopRoundness (self, g_value_get_int (value));
		break;
		case PLANK_THEME_BOTTOM_ROUNDNESS_PROPERTY:
		plank_theme_set_BottomRoundness (self, g_value_get_int (value));
		break;
		case PLANK_THEME_LINE_WIDTH_PROPERTY:
		plank_theme_set_LineWidth (self, g_value_get_int (value));
		break;
		case PLANK_THEME_OUTER_STROKE_COLOR_PROPERTY:
		plank_theme_set_OuterStrokeColor (self, g_value_get_boxed (value));
		break;
		case PLANK_THEME_FILL_START_COLOR_PROPERTY:
		plank_theme_set_FillStartColor (self, g_value_get_boxed (value));
		break;
		case PLANK_THEME_FILL_END_COLOR_PROPERTY:
		plank_theme_set_FillEndColor (self, g_value_get_boxed (value));
		break;
		case PLANK_THEME_INNER_STROKE_COLOR_PROPERTY:
		plank_theme_set_InnerStrokeColor (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

