// python wrapper for vtkPVAxesActor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVAxesActor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVAxesActor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVAxesActor_ClassNew(); }


static PyObject *
PyvtkPVAxesActor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVAxesActor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVAxesActor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVAxesActor *tempr = vtkPVAxesActor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVAxesActor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVAxesActor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVAxesActor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVAxesActor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkPropCollection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPropCollection"))
  {
    if (ap.IsBound())
    {
      op->GetActors(temp0);
    }
    else
    {
      op->vtkPVAxesActor::GetActors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_RenderOpaqueGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderOpaqueGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkViewport *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkViewport"))
  {
    int tempr = (ap.IsBound() ?
      op->RenderOpaqueGeometry(temp0) :
      op->vtkPVAxesActor::RenderOpaqueGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_RenderTranslucentPolygonalGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderTranslucentPolygonalGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkViewport *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkViewport"))
  {
    int tempr = (ap.IsBound() ?
      op->RenderTranslucentPolygonalGeometry(temp0) :
      op->vtkPVAxesActor::RenderTranslucentPolygonalGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_HasTranslucentPolygonalGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasTranslucentPolygonalGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->HasTranslucentPolygonalGeometry() :
      op->vtkPVAxesActor::HasTranslucentPolygonalGeometry());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_ShallowCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShallowCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkProp *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProp"))
  {
    if (ap.IsBound())
    {
      op->ShallowCopy(temp0);
    }
    else
    {
      op->vtkPVAxesActor::ShallowCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkPVAxesActor::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetBounds(temp0);
    }
    else
    {
      op->vtkPVAxesActor::GetBounds(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_GetBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBounds() :
      op->vtkPVAxesActor::GetBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_GetBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVAxesActor_GetBounds_s1(self, args);
    case 0:
      return PyvtkPVAxesActor_GetBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetBounds");
  return nullptr;
}


static PyObject *
PyvtkPVAxesActor_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkPVAxesActor::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetRedrawMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRedrawMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetRedrawMTime() :
      op->vtkPVAxesActor::GetRedrawMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetTotalLength_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTotalLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const size_t size0 = 3;
  float temp0[3];
  float save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetTotalLength(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetTotalLength(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetTotalLength_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTotalLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  float temp1;
  float temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTotalLength(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesActor::SetTotalLength(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetTotalLength(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVAxesActor_SetTotalLength_s1(self, args);
    case 3:
      return PyvtkPVAxesActor_SetTotalLength_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTotalLength");
  return nullptr;
}


static PyObject *
PyvtkPVAxesActor_GetTotalLength(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTotalLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float *tempr = (ap.IsBound() ?
      op->GetTotalLength() :
      op->vtkPVAxesActor::GetTotalLength());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetNormalizedShaftLength_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedShaftLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const size_t size0 = 3;
  float temp0[3];
  float save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetNormalizedShaftLength(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetNormalizedShaftLength(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetNormalizedShaftLength_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedShaftLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  float temp1;
  float temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedShaftLength(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesActor::SetNormalizedShaftLength(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetNormalizedShaftLength(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVAxesActor_SetNormalizedShaftLength_s1(self, args);
    case 3:
      return PyvtkPVAxesActor_SetNormalizedShaftLength_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNormalizedShaftLength");
  return nullptr;
}


static PyObject *
PyvtkPVAxesActor_GetNormalizedShaftLength(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedShaftLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float *tempr = (ap.IsBound() ?
      op->GetNormalizedShaftLength() :
      op->vtkPVAxesActor::GetNormalizedShaftLength());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetNormalizedTipLength_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedTipLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const size_t size0 = 3;
  float temp0[3];
  float save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetNormalizedTipLength(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetNormalizedTipLength(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetNormalizedTipLength_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedTipLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  float temp1;
  float temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedTipLength(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesActor::SetNormalizedTipLength(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVAxesActor_SetNormalizedTipLength(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVAxesActor_SetNormalizedTipLength_s1(self, args);
    case 3:
      return PyvtkPVAxesActor_SetNormalizedTipLength_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetNormalizedTipLength");
  return nullptr;
}


static PyObject *
PyvtkPVAxesActor_GetNormalizedTipLength(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedTipLength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float *tempr = (ap.IsBound() ?
      op->GetNormalizedTipLength() :
      op->vtkPVAxesActor::GetNormalizedTipLength());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetConeResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConeResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConeResolution(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetConeResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeResolutionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeResolutionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConeResolutionMinValue() :
      op->vtkPVAxesActor::GetConeResolutionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeResolutionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeResolutionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConeResolutionMaxValue() :
      op->vtkPVAxesActor::GetConeResolutionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConeResolution() :
      op->vtkPVAxesActor::GetConeResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetSphereResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSphereResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSphereResolution(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetSphereResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereResolutionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereResolutionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSphereResolutionMinValue() :
      op->vtkPVAxesActor::GetSphereResolutionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereResolutionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereResolutionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSphereResolutionMaxValue() :
      op->vtkPVAxesActor::GetSphereResolutionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSphereResolution() :
      op->vtkPVAxesActor::GetSphereResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetCylinderResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCylinderResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCylinderResolution(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetCylinderResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderResolutionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderResolutionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCylinderResolutionMinValue() :
      op->vtkPVAxesActor::GetCylinderResolutionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderResolutionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderResolutionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCylinderResolutionMaxValue() :
      op->vtkPVAxesActor::GetCylinderResolutionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCylinderResolution() :
      op->vtkPVAxesActor::GetCylinderResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetConeRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConeRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConeRadius(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetConeRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeRadiusMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeRadiusMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetConeRadiusMinValue() :
      op->vtkPVAxesActor::GetConeRadiusMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeRadiusMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeRadiusMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetConeRadiusMaxValue() :
      op->vtkPVAxesActor::GetConeRadiusMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetConeRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetConeRadius() :
      op->vtkPVAxesActor::GetConeRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetSphereRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSphereRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSphereRadius(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetSphereRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereRadiusMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereRadiusMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetSphereRadiusMinValue() :
      op->vtkPVAxesActor::GetSphereRadiusMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereRadiusMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereRadiusMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetSphereRadiusMaxValue() :
      op->vtkPVAxesActor::GetSphereRadiusMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetSphereRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSphereRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetSphereRadius() :
      op->vtkPVAxesActor::GetSphereRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetCylinderRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCylinderRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCylinderRadius(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetCylinderRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderRadiusMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderRadiusMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetCylinderRadiusMinValue() :
      op->vtkPVAxesActor::GetCylinderRadiusMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderRadiusMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderRadiusMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetCylinderRadiusMaxValue() :
      op->vtkPVAxesActor::GetCylinderRadiusMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetCylinderRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCylinderRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetCylinderRadius() :
      op->vtkPVAxesActor::GetCylinderRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetXAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisLabelPosition(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetXAxisLabelPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisLabelPositionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisLabelPositionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetXAxisLabelPositionMinValue() :
      op->vtkPVAxesActor::GetXAxisLabelPositionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisLabelPositionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisLabelPositionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetXAxisLabelPositionMaxValue() :
      op->vtkPVAxesActor::GetXAxisLabelPositionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetXAxisLabelPosition() :
      op->vtkPVAxesActor::GetXAxisLabelPosition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetYAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYAxisLabelPosition(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetYAxisLabelPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisLabelPositionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisLabelPositionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetYAxisLabelPositionMinValue() :
      op->vtkPVAxesActor::GetYAxisLabelPositionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisLabelPositionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisLabelPositionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetYAxisLabelPositionMaxValue() :
      op->vtkPVAxesActor::GetYAxisLabelPositionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetYAxisLabelPosition() :
      op->vtkPVAxesActor::GetYAxisLabelPosition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetZAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZAxisLabelPosition(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetZAxisLabelPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisLabelPositionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisLabelPositionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetZAxisLabelPositionMinValue() :
      op->vtkPVAxesActor::GetZAxisLabelPositionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisLabelPositionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisLabelPositionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetZAxisLabelPositionMaxValue() :
      op->vtkPVAxesActor::GetZAxisLabelPositionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisLabelPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisLabelPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetZAxisLabelPosition() :
      op->vtkPVAxesActor::GetZAxisLabelPosition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetShaftType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShaftType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShaftType(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetShaftType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetShaftTypeToCylinder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShaftTypeToCylinder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetShaftTypeToCylinder();
    }
    else
    {
      op->vtkPVAxesActor::SetShaftTypeToCylinder();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetShaftTypeToLine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShaftTypeToLine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetShaftTypeToLine();
    }
    else
    {
      op->vtkPVAxesActor::SetShaftTypeToLine();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetShaftTypeToUserDefined(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShaftTypeToUserDefined");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetShaftTypeToUserDefined();
    }
    else
    {
      op->vtkPVAxesActor::SetShaftTypeToUserDefined();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetTipType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTipType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTipType(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetTipType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetTipTypeToCone(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTipTypeToCone");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetTipTypeToCone();
    }
    else
    {
      op->vtkPVAxesActor::SetTipTypeToCone();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetTipTypeToSphere(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTipTypeToSphere");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetTipTypeToSphere();
    }
    else
    {
      op->vtkPVAxesActor::SetTipTypeToSphere();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetTipTypeToUserDefined(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTipTypeToUserDefined");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetTipTypeToUserDefined();
    }
    else
    {
      op->vtkPVAxesActor::SetTipTypeToUserDefined();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetUserDefinedTip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserDefinedTip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkPolyData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPolyData"))
  {
    if (ap.IsBound())
    {
      op->SetUserDefinedTip(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetUserDefinedTip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetUserDefinedTip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUserDefinedTip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPolyData *tempr = (ap.IsBound() ?
      op->GetUserDefinedTip() :
      op->vtkPVAxesActor::GetUserDefinedTip());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetUserDefinedShaft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserDefinedShaft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  vtkPolyData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPolyData"))
  {
    if (ap.IsBound())
    {
      op->SetUserDefinedShaft(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetUserDefinedShaft(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetUserDefinedShaft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUserDefinedShaft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPolyData *tempr = (ap.IsBound() ?
      op->GetUserDefinedShaft() :
      op->vtkPVAxesActor::GetUserDefinedShaft());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisTipProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisTipProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetXAxisTipProperty() :
      op->vtkPVAxesActor::GetXAxisTipProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisTipProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisTipProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetYAxisTipProperty() :
      op->vtkPVAxesActor::GetYAxisTipProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisTipProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisTipProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetZAxisTipProperty() :
      op->vtkPVAxesActor::GetZAxisTipProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisShaftProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisShaftProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetXAxisShaftProperty() :
      op->vtkPVAxesActor::GetXAxisShaftProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisShaftProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisShaftProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetYAxisShaftProperty() :
      op->vtkPVAxesActor::GetYAxisShaftProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisShaftProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisShaftProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetZAxisShaftProperty() :
      op->vtkPVAxesActor::GetZAxisShaftProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisLabelProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisLabelProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetXAxisLabelProperty() :
      op->vtkPVAxesActor::GetXAxisLabelProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisLabelProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisLabelProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetYAxisLabelProperty() :
      op->vtkPVAxesActor::GetYAxisLabelProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisLabelProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisLabelProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProperty *tempr = (ap.IsBound() ?
      op->GetZAxisLabelProperty() :
      op->vtkPVAxesActor::GetZAxisLabelProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetXAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetXAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetXAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetXAxisVisibility() :
      op->vtkPVAxesActor::GetXAxisVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetYAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetYAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetYAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetYAxisVisibility() :
      op->vtkPVAxesActor::GetYAxisVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetZAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetZAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_GetZAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZAxisVisibility() :
      op->vtkPVAxesActor::GetZAxisVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetXAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetXAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetYAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetYAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesActor_SetZAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesActor *op = static_cast<vtkPVAxesActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesActor::SetZAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVAxesActor_Methods[] = {
  {"IsTypeOf", PyvtkPVAxesActor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVAxesActor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVAxesActor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVAxesActor\nC++: static vtkPVAxesActor *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVAxesActor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVAxesActor\nC++: vtkPVAxesActor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVAxesActor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVAxesActor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetActors", PyvtkPVAxesActor_GetActors, METH_VARARGS,
   "GetActors(self, __a:vtkPropCollection) -> None\nC++: void GetActors(vtkPropCollection *) override;\n\nFor some exporters and other other operations we must be able to\ncollect all the actors or volumes. These methods are used in that\nprocess.\n"},
  {"RenderOpaqueGeometry", PyvtkPVAxesActor_RenderOpaqueGeometry, METH_VARARGS,
   "RenderOpaqueGeometry(self, viewport:vtkViewport) -> int\nC++: int RenderOpaqueGeometry(vtkViewport *viewport) override;\n\nSupport the standard render methods.\n"},
  {"RenderTranslucentPolygonalGeometry", PyvtkPVAxesActor_RenderTranslucentPolygonalGeometry, METH_VARARGS,
   "RenderTranslucentPolygonalGeometry(self, viewport:vtkViewport)\n    -> int\nC++: int RenderTranslucentPolygonalGeometry(vtkViewport *viewport)\n     override;\n\n"},
  {"HasTranslucentPolygonalGeometry", PyvtkPVAxesActor_HasTranslucentPolygonalGeometry, METH_VARARGS,
   "HasTranslucentPolygonalGeometry(self) -> int\nC++: int HasTranslucentPolygonalGeometry() override;\n\nWARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE DO NOT\nUSE THESE METHODS OUTSIDE OF THE RENDERING PROCESS Does this prop\nhave some translucent polygonal geometry? This method is called\nduring the rendering process to know if there is some translucent\npolygonal geometry. A simple prop that has some translucent\npolygonal geometry will return true. A composite prop (like\nvtkAssembly) that has at least one sub-prop that has some\ntranslucent polygonal geometry will return true. Default\nimplementation return false.\n"},
  {"ShallowCopy", PyvtkPVAxesActor_ShallowCopy, METH_VARARGS,
   "ShallowCopy(self, prop:vtkProp) -> None\nC++: void ShallowCopy(vtkProp *prop) override;\n\nShallow copy of an axes actor. Overloads the virtual vtkProp\nmethod.\n"},
  {"ReleaseGraphicsResources", PyvtkPVAxesActor_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, __a:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *) override;\n\nRelease any graphics resources that are being consumed by this\nactor. The parameter window could be used to determine which\ngraphic resources to release.\n"},
  {"GetBounds", PyvtkPVAxesActor_GetBounds, METH_VARARGS,
   "GetBounds(self, bounds:[float, float, float, float, float, float])\n     -> None\nC++: void GetBounds(double bounds[6])\nGetBounds(self) -> (float, float, float, float, float, float)\nC++: double *GetBounds() override;\n\nGet the bounds for this Actor as (Xmin,Xmax,Ymin,Ymax,Zmin,Zmax).\n(The method GetBounds(double bounds[6]) is available from the\nsuperclass.)\n"},
  {"GetMTime", PyvtkPVAxesActor_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nGet the actors mtime plus consider its properties and texture if\nset.\n"},
  {"GetRedrawMTime", PyvtkPVAxesActor_GetRedrawMTime, METH_VARARGS,
   "GetRedrawMTime(self) -> int\nC++: vtkMTimeType GetRedrawMTime() override;\n\nReturn the mtime of anything that would cause the rendered image\nto appear differently. Usually this involves checking the mtime\nof the prop plus anything else it depends on such as properties,\ntextures etc.\n"},
  {"SetTotalLength", PyvtkPVAxesActor_SetTotalLength, METH_VARARGS,
   "SetTotalLength(self, v:[float, float, float]) -> None\nC++: void SetTotalLength(float v[3])\nSetTotalLength(self, x:float, y:float, z:float) -> None\nC++: void SetTotalLength(float x, float y, float z)\n\nSet the total length of the axes in 3 dimensions.\n"},
  {"GetTotalLength", PyvtkPVAxesActor_GetTotalLength, METH_VARARGS,
   "GetTotalLength(self) -> (float, float, float)\nC++: virtual float *GetTotalLength()\n\n"},
  {"SetNormalizedShaftLength", PyvtkPVAxesActor_SetNormalizedShaftLength, METH_VARARGS,
   "SetNormalizedShaftLength(self, v:[float, float, float]) -> None\nC++: void SetNormalizedShaftLength(float v[3])\nSetNormalizedShaftLength(self, x:float, y:float, z:float) -> None\nC++: void SetNormalizedShaftLength(float x, float y, float z)\n\nSet the normalized (0-1) length of the shaft.\n"},
  {"GetNormalizedShaftLength", PyvtkPVAxesActor_GetNormalizedShaftLength, METH_VARARGS,
   "GetNormalizedShaftLength(self) -> (float, float, float)\nC++: virtual float *GetNormalizedShaftLength()\n\n"},
  {"SetNormalizedTipLength", PyvtkPVAxesActor_SetNormalizedTipLength, METH_VARARGS,
   "SetNormalizedTipLength(self, v:[float, float, float]) -> None\nC++: void SetNormalizedTipLength(float v[3])\nSetNormalizedTipLength(self, x:float, y:float, z:float) -> None\nC++: void SetNormalizedTipLength(float x, float y, float z)\n\nSet the normalized (0-1) length of the tip.\n"},
  {"GetNormalizedTipLength", PyvtkPVAxesActor_GetNormalizedTipLength, METH_VARARGS,
   "GetNormalizedTipLength(self) -> (float, float, float)\nC++: virtual float *GetNormalizedTipLength()\n\n"},
  {"SetConeResolution", PyvtkPVAxesActor_SetConeResolution, METH_VARARGS,
   "SetConeResolution(self, _arg:int) -> None\nC++: virtual void SetConeResolution(int _arg)\n\nSet/get the resolution of the pieces of the axes actor\n"},
  {"GetConeResolutionMinValue", PyvtkPVAxesActor_GetConeResolutionMinValue, METH_VARARGS,
   "GetConeResolutionMinValue(self) -> int\nC++: virtual int GetConeResolutionMinValue()\n\n"},
  {"GetConeResolutionMaxValue", PyvtkPVAxesActor_GetConeResolutionMaxValue, METH_VARARGS,
   "GetConeResolutionMaxValue(self) -> int\nC++: virtual int GetConeResolutionMaxValue()\n\n"},
  {"GetConeResolution", PyvtkPVAxesActor_GetConeResolution, METH_VARARGS,
   "GetConeResolution(self) -> int\nC++: virtual int GetConeResolution()\n\n"},
  {"SetSphereResolution", PyvtkPVAxesActor_SetSphereResolution, METH_VARARGS,
   "SetSphereResolution(self, _arg:int) -> None\nC++: virtual void SetSphereResolution(int _arg)\n\n"},
  {"GetSphereResolutionMinValue", PyvtkPVAxesActor_GetSphereResolutionMinValue, METH_VARARGS,
   "GetSphereResolutionMinValue(self) -> int\nC++: virtual int GetSphereResolutionMinValue()\n\n"},
  {"GetSphereResolutionMaxValue", PyvtkPVAxesActor_GetSphereResolutionMaxValue, METH_VARARGS,
   "GetSphereResolutionMaxValue(self) -> int\nC++: virtual int GetSphereResolutionMaxValue()\n\n"},
  {"GetSphereResolution", PyvtkPVAxesActor_GetSphereResolution, METH_VARARGS,
   "GetSphereResolution(self) -> int\nC++: virtual int GetSphereResolution()\n\n"},
  {"SetCylinderResolution", PyvtkPVAxesActor_SetCylinderResolution, METH_VARARGS,
   "SetCylinderResolution(self, _arg:int) -> None\nC++: virtual void SetCylinderResolution(int _arg)\n\n"},
  {"GetCylinderResolutionMinValue", PyvtkPVAxesActor_GetCylinderResolutionMinValue, METH_VARARGS,
   "GetCylinderResolutionMinValue(self) -> int\nC++: virtual int GetCylinderResolutionMinValue()\n\n"},
  {"GetCylinderResolutionMaxValue", PyvtkPVAxesActor_GetCylinderResolutionMaxValue, METH_VARARGS,
   "GetCylinderResolutionMaxValue(self) -> int\nC++: virtual int GetCylinderResolutionMaxValue()\n\n"},
  {"GetCylinderResolution", PyvtkPVAxesActor_GetCylinderResolution, METH_VARARGS,
   "GetCylinderResolution(self) -> int\nC++: virtual int GetCylinderResolution()\n\n"},
  {"SetConeRadius", PyvtkPVAxesActor_SetConeRadius, METH_VARARGS,
   "SetConeRadius(self, _arg:float) -> None\nC++: virtual void SetConeRadius(float _arg)\n\nSet/get the radius of the pieces of the axes actor\n"},
  {"GetConeRadiusMinValue", PyvtkPVAxesActor_GetConeRadiusMinValue, METH_VARARGS,
   "GetConeRadiusMinValue(self) -> float\nC++: virtual float GetConeRadiusMinValue()\n\n"},
  {"GetConeRadiusMaxValue", PyvtkPVAxesActor_GetConeRadiusMaxValue, METH_VARARGS,
   "GetConeRadiusMaxValue(self) -> float\nC++: virtual float GetConeRadiusMaxValue()\n\n"},
  {"GetConeRadius", PyvtkPVAxesActor_GetConeRadius, METH_VARARGS,
   "GetConeRadius(self) -> float\nC++: virtual float GetConeRadius()\n\n"},
  {"SetSphereRadius", PyvtkPVAxesActor_SetSphereRadius, METH_VARARGS,
   "SetSphereRadius(self, _arg:float) -> None\nC++: virtual void SetSphereRadius(float _arg)\n\n"},
  {"GetSphereRadiusMinValue", PyvtkPVAxesActor_GetSphereRadiusMinValue, METH_VARARGS,
   "GetSphereRadiusMinValue(self) -> float\nC++: virtual float GetSphereRadiusMinValue()\n\n"},
  {"GetSphereRadiusMaxValue", PyvtkPVAxesActor_GetSphereRadiusMaxValue, METH_VARARGS,
   "GetSphereRadiusMaxValue(self) -> float\nC++: virtual float GetSphereRadiusMaxValue()\n\n"},
  {"GetSphereRadius", PyvtkPVAxesActor_GetSphereRadius, METH_VARARGS,
   "GetSphereRadius(self) -> float\nC++: virtual float GetSphereRadius()\n\n"},
  {"SetCylinderRadius", PyvtkPVAxesActor_SetCylinderRadius, METH_VARARGS,
   "SetCylinderRadius(self, _arg:float) -> None\nC++: virtual void SetCylinderRadius(float _arg)\n\n"},
  {"GetCylinderRadiusMinValue", PyvtkPVAxesActor_GetCylinderRadiusMinValue, METH_VARARGS,
   "GetCylinderRadiusMinValue(self) -> float\nC++: virtual float GetCylinderRadiusMinValue()\n\n"},
  {"GetCylinderRadiusMaxValue", PyvtkPVAxesActor_GetCylinderRadiusMaxValue, METH_VARARGS,
   "GetCylinderRadiusMaxValue(self) -> float\nC++: virtual float GetCylinderRadiusMaxValue()\n\n"},
  {"GetCylinderRadius", PyvtkPVAxesActor_GetCylinderRadius, METH_VARARGS,
   "GetCylinderRadius(self) -> float\nC++: virtual float GetCylinderRadius()\n\n"},
  {"SetXAxisLabelPosition", PyvtkPVAxesActor_SetXAxisLabelPosition, METH_VARARGS,
   "SetXAxisLabelPosition(self, _arg:float) -> None\nC++: virtual void SetXAxisLabelPosition(float _arg)\n\nSet/get the positions of the axis labels\n"},
  {"GetXAxisLabelPositionMinValue", PyvtkPVAxesActor_GetXAxisLabelPositionMinValue, METH_VARARGS,
   "GetXAxisLabelPositionMinValue(self) -> float\nC++: virtual float GetXAxisLabelPositionMinValue()\n\n"},
  {"GetXAxisLabelPositionMaxValue", PyvtkPVAxesActor_GetXAxisLabelPositionMaxValue, METH_VARARGS,
   "GetXAxisLabelPositionMaxValue(self) -> float\nC++: virtual float GetXAxisLabelPositionMaxValue()\n\n"},
  {"GetXAxisLabelPosition", PyvtkPVAxesActor_GetXAxisLabelPosition, METH_VARARGS,
   "GetXAxisLabelPosition(self) -> float\nC++: virtual float GetXAxisLabelPosition()\n\n"},
  {"SetYAxisLabelPosition", PyvtkPVAxesActor_SetYAxisLabelPosition, METH_VARARGS,
   "SetYAxisLabelPosition(self, _arg:float) -> None\nC++: virtual void SetYAxisLabelPosition(float _arg)\n\n"},
  {"GetYAxisLabelPositionMinValue", PyvtkPVAxesActor_GetYAxisLabelPositionMinValue, METH_VARARGS,
   "GetYAxisLabelPositionMinValue(self) -> float\nC++: virtual float GetYAxisLabelPositionMinValue()\n\n"},
  {"GetYAxisLabelPositionMaxValue", PyvtkPVAxesActor_GetYAxisLabelPositionMaxValue, METH_VARARGS,
   "GetYAxisLabelPositionMaxValue(self) -> float\nC++: virtual float GetYAxisLabelPositionMaxValue()\n\n"},
  {"GetYAxisLabelPosition", PyvtkPVAxesActor_GetYAxisLabelPosition, METH_VARARGS,
   "GetYAxisLabelPosition(self) -> float\nC++: virtual float GetYAxisLabelPosition()\n\n"},
  {"SetZAxisLabelPosition", PyvtkPVAxesActor_SetZAxisLabelPosition, METH_VARARGS,
   "SetZAxisLabelPosition(self, _arg:float) -> None\nC++: virtual void SetZAxisLabelPosition(float _arg)\n\n"},
  {"GetZAxisLabelPositionMinValue", PyvtkPVAxesActor_GetZAxisLabelPositionMinValue, METH_VARARGS,
   "GetZAxisLabelPositionMinValue(self) -> float\nC++: virtual float GetZAxisLabelPositionMinValue()\n\n"},
  {"GetZAxisLabelPositionMaxValue", PyvtkPVAxesActor_GetZAxisLabelPositionMaxValue, METH_VARARGS,
   "GetZAxisLabelPositionMaxValue(self) -> float\nC++: virtual float GetZAxisLabelPositionMaxValue()\n\n"},
  {"GetZAxisLabelPosition", PyvtkPVAxesActor_GetZAxisLabelPosition, METH_VARARGS,
   "GetZAxisLabelPosition(self) -> float\nC++: virtual float GetZAxisLabelPosition()\n\n"},
  {"SetShaftType", PyvtkPVAxesActor_SetShaftType, METH_VARARGS,
   "SetShaftType(self, type:int) -> None\nC++: void SetShaftType(int type)\n\nSet the type of the shaft to a cylinder, line, or user defined\ngeometry.\n"},
  {"SetShaftTypeToCylinder", PyvtkPVAxesActor_SetShaftTypeToCylinder, METH_VARARGS,
   "SetShaftTypeToCylinder(self) -> None\nC++: void SetShaftTypeToCylinder()\n\n"},
  {"SetShaftTypeToLine", PyvtkPVAxesActor_SetShaftTypeToLine, METH_VARARGS,
   "SetShaftTypeToLine(self) -> None\nC++: void SetShaftTypeToLine()\n\n"},
  {"SetShaftTypeToUserDefined", PyvtkPVAxesActor_SetShaftTypeToUserDefined, METH_VARARGS,
   "SetShaftTypeToUserDefined(self) -> None\nC++: void SetShaftTypeToUserDefined()\n\n"},
  {"SetTipType", PyvtkPVAxesActor_SetTipType, METH_VARARGS,
   "SetTipType(self, type:int) -> None\nC++: void SetTipType(int type)\n\nSet the type of the tip to a cone, sphere, or user defined\ngeometry.\n"},
  {"SetTipTypeToCone", PyvtkPVAxesActor_SetTipTypeToCone, METH_VARARGS,
   "SetTipTypeToCone(self) -> None\nC++: void SetTipTypeToCone()\n\n"},
  {"SetTipTypeToSphere", PyvtkPVAxesActor_SetTipTypeToSphere, METH_VARARGS,
   "SetTipTypeToSphere(self) -> None\nC++: void SetTipTypeToSphere()\n\n"},
  {"SetTipTypeToUserDefined", PyvtkPVAxesActor_SetTipTypeToUserDefined, METH_VARARGS,
   "SetTipTypeToUserDefined(self) -> None\nC++: void SetTipTypeToUserDefined()\n\n"},
  {"SetUserDefinedTip", PyvtkPVAxesActor_SetUserDefinedTip, METH_VARARGS,
   "SetUserDefinedTip(self, __a:vtkPolyData) -> None\nC++: void SetUserDefinedTip(vtkPolyData *)\n\nSet the user defined tip polydata.\n"},
  {"GetUserDefinedTip", PyvtkPVAxesActor_GetUserDefinedTip, METH_VARARGS,
   "GetUserDefinedTip(self) -> vtkPolyData\nC++: virtual vtkPolyData *GetUserDefinedTip()\n\n"},
  {"SetUserDefinedShaft", PyvtkPVAxesActor_SetUserDefinedShaft, METH_VARARGS,
   "SetUserDefinedShaft(self, __a:vtkPolyData) -> None\nC++: void SetUserDefinedShaft(vtkPolyData *)\n\nSet the user defined shaft polydata.\n"},
  {"GetUserDefinedShaft", PyvtkPVAxesActor_GetUserDefinedShaft, METH_VARARGS,
   "GetUserDefinedShaft(self) -> vtkPolyData\nC++: virtual vtkPolyData *GetUserDefinedShaft()\n\n"},
  {"GetXAxisTipProperty", PyvtkPVAxesActor_GetXAxisTipProperty, METH_VARARGS,
   "GetXAxisTipProperty(self) -> vtkProperty\nC++: vtkProperty *GetXAxisTipProperty()\n\nGet the tip properties.\n"},
  {"GetYAxisTipProperty", PyvtkPVAxesActor_GetYAxisTipProperty, METH_VARARGS,
   "GetYAxisTipProperty(self) -> vtkProperty\nC++: vtkProperty *GetYAxisTipProperty()\n\n"},
  {"GetZAxisTipProperty", PyvtkPVAxesActor_GetZAxisTipProperty, METH_VARARGS,
   "GetZAxisTipProperty(self) -> vtkProperty\nC++: vtkProperty *GetZAxisTipProperty()\n\n"},
  {"GetXAxisShaftProperty", PyvtkPVAxesActor_GetXAxisShaftProperty, METH_VARARGS,
   "GetXAxisShaftProperty(self) -> vtkProperty\nC++: vtkProperty *GetXAxisShaftProperty()\n\nGet the shaft properties.\n"},
  {"GetYAxisShaftProperty", PyvtkPVAxesActor_GetYAxisShaftProperty, METH_VARARGS,
   "GetYAxisShaftProperty(self) -> vtkProperty\nC++: vtkProperty *GetYAxisShaftProperty()\n\n"},
  {"GetZAxisShaftProperty", PyvtkPVAxesActor_GetZAxisShaftProperty, METH_VARARGS,
   "GetZAxisShaftProperty(self) -> vtkProperty\nC++: vtkProperty *GetZAxisShaftProperty()\n\n"},
  {"GetXAxisLabelProperty", PyvtkPVAxesActor_GetXAxisLabelProperty, METH_VARARGS,
   "GetXAxisLabelProperty(self) -> vtkProperty\nC++: vtkProperty *GetXAxisLabelProperty()\n\nGet the label properties.\n"},
  {"GetYAxisLabelProperty", PyvtkPVAxesActor_GetYAxisLabelProperty, METH_VARARGS,
   "GetYAxisLabelProperty(self) -> vtkProperty\nC++: vtkProperty *GetYAxisLabelProperty()\n\n"},
  {"GetZAxisLabelProperty", PyvtkPVAxesActor_GetZAxisLabelProperty, METH_VARARGS,
   "GetZAxisLabelProperty(self) -> vtkProperty\nC++: vtkProperty *GetZAxisLabelProperty()\n\n"},
  {"SetXAxisVisibility", PyvtkPVAxesActor_SetXAxisVisibility, METH_VARARGS,
   "SetXAxisVisibility(self, _arg:bool) -> None\nC++: virtual void SetXAxisVisibility(bool _arg)\n\nGet/Set the visibitity for each individual axis.\n"},
  {"GetXAxisVisibility", PyvtkPVAxesActor_GetXAxisVisibility, METH_VARARGS,
   "GetXAxisVisibility(self) -> bool\nC++: virtual bool GetXAxisVisibility()\n\n"},
  {"SetYAxisVisibility", PyvtkPVAxesActor_SetYAxisVisibility, METH_VARARGS,
   "SetYAxisVisibility(self, _arg:bool) -> None\nC++: virtual void SetYAxisVisibility(bool _arg)\n\n"},
  {"GetYAxisVisibility", PyvtkPVAxesActor_GetYAxisVisibility, METH_VARARGS,
   "GetYAxisVisibility(self) -> bool\nC++: virtual bool GetYAxisVisibility()\n\n"},
  {"SetZAxisVisibility", PyvtkPVAxesActor_SetZAxisVisibility, METH_VARARGS,
   "SetZAxisVisibility(self, _arg:bool) -> None\nC++: virtual void SetZAxisVisibility(bool _arg)\n\n"},
  {"GetZAxisVisibility", PyvtkPVAxesActor_GetZAxisVisibility, METH_VARARGS,
   "GetZAxisVisibility(self) -> bool\nC++: virtual bool GetZAxisVisibility()\n\n"},
  {"SetXAxisLabelText", PyvtkPVAxesActor_SetXAxisLabelText, METH_VARARGS,
   "SetXAxisLabelText(self, _arg:str) -> None\nC++: virtual void SetXAxisLabelText(const char *_arg)\n\nSet the label text.\n"},
  {"SetYAxisLabelText", PyvtkPVAxesActor_SetYAxisLabelText, METH_VARARGS,
   "SetYAxisLabelText(self, _arg:str) -> None\nC++: virtual void SetYAxisLabelText(const char *_arg)\n\n"},
  {"SetZAxisLabelText", PyvtkPVAxesActor_SetZAxisLabelText, METH_VARARGS,
   "SetZAxisLabelText(self, _arg:str) -> None\nC++: virtual void SetZAxisLabelText(const char *_arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVAxesActor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("total_length"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetTotalLength(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetTotalLength(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetTotalLength(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTotalLength/SetTotalLength\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_shaft_length"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetNormalizedShaftLength(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetNormalizedShaftLength(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetNormalizedShaftLength(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizedShaftLength/SetNormalizedShaftLength\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_tip_length"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetNormalizedTipLength(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetNormalizedTipLength(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetNormalizedTipLength(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizedTipLength/SetNormalizedTipLength\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cone_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetConeResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetConeResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetConeResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConeResolution/SetConeResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sphere_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetSphereResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetSphereResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetSphereResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSphereResolution/SetSphereResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cylinder_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetCylinderResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetCylinderResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetCylinderResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCylinderResolution/SetCylinderResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cone_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetConeRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetConeRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetConeRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConeRadius/SetConeRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sphere_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetSphereRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetSphereRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetSphereRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSphereRadius/SetSphereRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cylinder_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetCylinderRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetCylinderRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetCylinderRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCylinderRadius/SetCylinderRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_label_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetXAxisLabelPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetXAxisLabelPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetXAxisLabelPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXAxisLabelPosition/SetXAxisLabelPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_label_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetYAxisLabelPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetYAxisLabelPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetYAxisLabelPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYAxisLabelPosition/SetYAxisLabelPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_label_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetZAxisLabelPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetZAxisLabelPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetZAxisLabelPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZAxisLabelPosition/SetZAxisLabelPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shaft_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetShaftType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetShaftType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShaftType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tip_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetTipType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetTipType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTipType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_defined_tip"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetUserDefinedTip(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetUserDefinedTip(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetUserDefinedTip(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUserDefinedTip/SetUserDefinedTip\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_defined_shaft"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetUserDefinedShaft(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetUserDefinedShaft(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetUserDefinedShaft(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUserDefinedShaft/SetUserDefinedShaft\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetXAxisVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetXAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetXAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXAxisVisibility/SetXAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetYAxisVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetYAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetYAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYAxisVisibility/SetYAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetZAxisVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetZAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetZAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZAxisVisibility/SetZAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetXAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetXAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetXAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetYAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetYAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetYAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesActor_SetZAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesActor_SetZAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetZAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("redraw_m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetRedrawMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRedrawMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_tip_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetXAxisTipProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetXAxisTipProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_tip_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetYAxisTipProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetYAxisTipProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_tip_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetZAxisTipProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetZAxisTipProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_shaft_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetXAxisShaftProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetXAxisShaftProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_shaft_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetYAxisShaftProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetYAxisShaftProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_shaft_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetZAxisShaftProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetZAxisShaftProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_label_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetXAxisLabelProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetXAxisLabelProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_label_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetYAxisLabelProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetYAxisLabelProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_label_property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesActor_GetZAxisLabelProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetZAxisLabelProperty\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVAxesActor_Doc =
  "vtkPVAxesActor - a 3D axes representation\n\n"
  "Superclass: vtkProp3D\n\n"
  "vtkPVAxesActor is used to represent 3D axes in the scene. The user\n"
  "can define the geometry to use for the shaft and the tip, and the\n"
  "user can set the text for the three axes. The text will follow the\n"
  "camera.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVAxesActor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVAxesActor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVAxesActor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVAxesActor_StaticNew()
{
  return vtkPVAxesActor::New();
}

PyObject *PyvtkPVAxesActor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVAxesActor_Type, PyvtkPVAxesActor_Methods,
    "vtkPVAxesActor",
 &PyvtkPVAxesActor_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkProp3D");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 6; c++)
  {
    static const struct { const char *name; int value; }
      constants[6] = {
        { "CYLINDER_SHAFT", vtkPVAxesActor::CYLINDER_SHAFT },
        { "LINE_SHAFT", vtkPVAxesActor::LINE_SHAFT },
        { "USER_DEFINED_SHAFT", vtkPVAxesActor::USER_DEFINED_SHAFT },
        { "CONE_TIP", vtkPVAxesActor::CONE_TIP },
        { "SPHERE_TIP", vtkPVAxesActor::SPHERE_TIP },
        { "USER_DEFINED_TIP", vtkPVAxesActor::USER_DEFINED_TIP },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVAxesActor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVAxesActor(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVAxesActor_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVAxesActor", o) != 0)
  {
    Py_DECREF(o);
  }

}

