#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAMRCutPlane_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRGaussianPulseSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRResampleFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRSliceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRToMultiBlockFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageToAMR_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParallelAMRUtilities_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersAMRCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAMRCutPlane_Init(csi);
  vtkAMRGaussianPulseSource_Init(csi);
  vtkAMRResampleFilter_Init(csi);
  vtkAMRSliceFilter_Init(csi);
  vtkAMRToMultiBlockFilter_Init(csi);
  vtkImageToAMR_Init(csi);
  vtkParallelAMRUtilities_Init(csi);
}
