/* TerminalView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TerminalView.vala, do not modify */

/* Copyright 2024 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <vte/vte.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite.h>

#define TERMINAL_TERMINAL_VIEW_TAB_HISTORY_MAX_ITEMS 20
#define TERMINAL_MAIN_WINDOW_ACTION_PREFIX "win."
#define TERMINAL_MAIN_WINDOW_ACTION_RESTORE_CLOSED_TAB "action-restore-closed-tab"
#define TERMINAL_MAIN_WINDOW_ACTION_CLOSE_OTHER_TABS "action_close_other_tabs"
#define TERMINAL_MAIN_WINDOW_ACTION_CLOSE_TABS_TO_RIGHT "action_close_tabs_to_right"
#define TERMINAL_MAIN_WINDOW_ACTION_CLOSE_TAB "action-close-tab"
#define TERMINAL_MAIN_WINDOW_ACTION_MOVE_TAB_TO_NEW_WINDOW "action-move-tab-to-new-window"
#define TERMINAL_MAIN_WINDOW_ACTION_DUPLICATE_TAB "action-duplicate-tab"
#define TERMINAL_MAIN_WINDOW_ACTION_TAB_RELOAD "action-tab_reload"
#define TERMINAL_MAIN_WINDOW_ACTION_NEW_TAB_AT "action-new-tab-at"
#define TERMINAL_MAIN_WINDOW_ACTION_TAB_ACTIVE_SHELL "action-tab_active_shell"
#define TERMINAL_MAIN_WINDOW_ACTION_NEW_TAB "action-term_widgetnew-tab"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_TYPE_TERMINAL_VIEW (terminal_terminal_view_get_type ())
#define TERMINAL_TERMINAL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView))
#define TERMINAL_TERMINAL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalViewClass))
#define TERMINAL_IS_TERMINAL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_VIEW))
#define TERMINAL_IS_TERMINAL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_VIEW))
#define TERMINAL_TERMINAL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalViewClass))

typedef struct _TerminalTerminalView TerminalTerminalView;
typedef struct _TerminalTerminalViewClass TerminalTerminalViewClass;
typedef struct _TerminalTerminalViewPrivate TerminalTerminalViewPrivate;

#define TERMINAL_TYPE_MAIN_WINDOW (terminal_main_window_get_type ())
#define TERMINAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow))
#define TERMINAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))
#define TERMINAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))

typedef struct _TerminalMainWindow TerminalMainWindow;
typedef struct _TerminalMainWindowClass TerminalMainWindowClass;
enum  {
	TERMINAL_TERMINAL_VIEW_0_PROPERTY,
	TERMINAL_TERMINAL_VIEW_N_PAGES_PROPERTY,
	TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY,
	TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY,
	TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY,
	TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY,
	TERMINAL_TERMINAL_VIEW_NUM_PROPERTIES
};
static GParamSpec* terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_NUM_PROPERTIES];
typedef enum  {
	TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST
} TerminalTerminalViewTargetType;

#define TERMINAL_TERMINAL_VIEW_TYPE_TARGET_TYPE (terminal_terminal_view_target_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TERMINAL_TYPE_APPLICATION (terminal_application_get_type ())
#define TERMINAL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplication))
#define TERMINAL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))
#define TERMINAL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))

typedef struct _TerminalApplication TerminalApplication;
typedef struct _TerminalApplicationClass TerminalApplicationClass;

#define TERMINAL_TYPE_TERMINAL_WIDGET (terminal_terminal_widget_get_type ())
#define TERMINAL_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget))
#define TERMINAL_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))
#define TERMINAL_IS_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_IS_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_TERMINAL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))

typedef struct _TerminalTerminalWidget TerminalTerminalWidget;
typedef struct _TerminalTerminalWidgetClass TerminalTerminalWidgetClass;
typedef struct _TerminalTerminalWidgetPrivate TerminalTerminalWidgetPrivate;
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
enum  {
	TERMINAL_TERMINAL_VIEW_NEW_TAB_REQUESTED_SIGNAL,
	TERMINAL_TERMINAL_VIEW_TAB_DUPLICATED_SIGNAL,
	TERMINAL_TERMINAL_VIEW_NUM_SIGNALS
};
static guint terminal_terminal_view_signals[TERMINAL_TERMINAL_VIEW_NUM_SIGNALS] = {0};

struct _TerminalTerminalView {
	GtkBox parent_instance;
	TerminalTerminalViewPrivate * priv;
};

struct _TerminalTerminalViewClass {
	GtkBoxClass parent_class;
};

struct _TerminalTerminalViewPrivate {
	TerminalMainWindow* _main_window;
	HdyTabView* _tab_view;
	HdyTabBar* tab_bar;
	HdyTabPage* _tab_menu_target;
	GtkCssProvider* style_provider;
	GtkMenuButton* tab_history_button;
};

struct _TerminalTerminalWidget {
	VteTerminal parent_instance;
	TerminalTerminalWidgetPrivate * priv;
	gchar* terminal_id;
	HdyTabPage* tab;
	gchar* link_uri;
	gint default_size;
	gboolean last_key_was_return;
};

struct _TerminalTerminalWidgetClass {
	VteTerminalClass parent_class;
};

static gint TerminalTerminalView_private_offset;
static gpointer terminal_terminal_view_parent_class = NULL;

VALA_EXTERN GType terminal_terminal_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalView, g_object_unref)
VALA_EXTERN GType terminal_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalMainWindow, g_object_unref)
VALA_EXTERN GType terminal_terminal_view_target_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TerminalTerminalView* terminal_terminal_view_new (TerminalMainWindow* window);
VALA_EXTERN TerminalTerminalView* terminal_terminal_view_construct (GType object_type,
                                                        TerminalMainWindow* window);
VALA_EXTERN void terminal_terminal_view_make_restorable (TerminalTerminalView* self,
                                             const gchar* path);
VALA_EXTERN void terminal_terminal_view_close_tab (TerminalTerminalView* self);
VALA_EXTERN HdyTabPage* terminal_terminal_view_get_tab_menu_target (TerminalTerminalView* self);
VALA_EXTERN HdyTabView* terminal_terminal_view_get_tab_view (TerminalTerminalView* self);
VALA_EXTERN void terminal_terminal_view_close_tabs_to_right (TerminalTerminalView* self);
VALA_EXTERN void terminal_terminal_view_close_other_tabs (TerminalTerminalView* self);
VALA_EXTERN void terminal_terminal_view_cycle_tabs (TerminalTerminalView* self,
                                        HdyNavigationDirection direction);
VALA_EXTERN HdyTabPage* terminal_terminal_view_get_selected_page (TerminalTerminalView* self);
VALA_EXTERN gint terminal_terminal_view_get_n_pages (TerminalTerminalView* self);
VALA_EXTERN void terminal_terminal_view_set_selected_page (TerminalTerminalView* self,
                                               HdyTabPage* value);
VALA_EXTERN void terminal_terminal_view_transfer_tab_to_new_window (TerminalTerminalView* self);
VALA_EXTERN TerminalMainWindow* terminal_terminal_view_get_main_window (TerminalTerminalView* self);
VALA_EXTERN GType terminal_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalApplication, g_object_unref)
VALA_EXTERN TerminalApplication* terminal_main_window_get_app (TerminalMainWindow* self);
VALA_EXTERN TerminalMainWindow* terminal_main_window_new (TerminalApplication* app,
                                              gboolean recreate_tabs);
VALA_EXTERN TerminalMainWindow* terminal_main_window_construct (GType object_type,
                                                    TerminalApplication* app,
                                                    gboolean recreate_tabs);
VALA_EXTERN TerminalTerminalView* terminal_main_window_get_notebook (TerminalMainWindow* self);
static void terminal_terminal_view_tab_view_setup_menu (TerminalTerminalView* self,
                                                 HdyTabPage* page);
static void terminal_terminal_view_set_tab_menu_target (TerminalTerminalView* self,
                                                 HdyTabPage* value);
VALA_EXTERN GSimpleAction* terminal_utils_action_from_group (const gchar* action_name,
                                                 GSimpleActionGroup* action_group);
VALA_EXTERN GSimpleActionGroup* terminal_main_window_get_actions (TerminalMainWindow* self);
VALA_EXTERN GType terminal_terminal_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalWidget, g_object_unref)
VALA_EXTERN void terminal_terminal_view_after_tab_restored (TerminalTerminalView* self,
                                                TerminalTerminalWidget* term);
static GMenu* terminal_terminal_view_create_menu_model (TerminalTerminalView* self);
static void terminal_terminal_view_drag_received (TerminalTerminalView* self,
                                           GtkWidget* w,
                                           GdkDragContext* ctx,
                                           gint x,
                                           gint y,
                                           GtkSelectionData* data,
                                           guint info,
                                           guint time);
static GVariant* _variant_new1 (const gchar* value);
static void terminal_terminal_view_on_extra_drag_data_received (TerminalTerminalView* self,
                                                         HdyTabBar* tab_bar,
                                                         HdyTabPage* page,
                                                         GdkDragContext* ctx,
                                                         GtkSelectionData* data,
                                                         guint info,
                                                         guint time);
static GVariant* _variant_new2 (const gchar* value);
static void terminal_terminal_view_set_main_window (TerminalTerminalView* self,
                                             TerminalMainWindow* value);
static void terminal_terminal_view_set_tab_view (TerminalTerminalView* self,
                                          HdyTabView* value);
static GObject * terminal_terminal_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _terminal_terminal_view_tab_view_setup_menu_hdy_tab_view_setup_menu (HdyTabView* _sender,
                                                                          HdyTabPage* page,
                                                                          gpointer self);
static void _terminal_terminal_view_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          gint x,
                                                                          gint y,
                                                                          GtkSelectionData* selection_data,
                                                                          guint info,
                                                                          guint time_,
                                                                          gpointer self);
static void _terminal_terminal_view_on_extra_drag_data_received_hdy_tab_bar_extra_drag_data_received (HdyTabBar* _sender,
                                                                                               HdyTabPage* page,
                                                                                               GdkDragContext* context,
                                                                                               GtkSelectionData* data,
                                                                                               guint info,
                                                                                               guint time,
                                                                                               gpointer self);
static void terminal_terminal_view_finalize (GObject * obj);
static GType terminal_terminal_view_get_type_once (void);
static void _vala_terminal_terminal_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_terminal_terminal_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
terminal_terminal_view_get_instance_private (TerminalTerminalView* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalTerminalView_private_offset);
}

static GType
terminal_terminal_view_target_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST, "TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST", "uri-list"}, {0, NULL, NULL}};
	GType terminal_terminal_view_target_type_type_id;
	terminal_terminal_view_target_type_type_id = g_enum_register_static ("TerminalTerminalViewTargetType", values);
	return terminal_terminal_view_target_type_type_id;
}

GType
terminal_terminal_view_target_type_get_type (void)
{
	static volatile gsize terminal_terminal_view_target_type_type_id__once = 0;
	if (g_once_init_enter (&terminal_terminal_view_target_type_type_id__once)) {
		GType terminal_terminal_view_target_type_type_id;
		terminal_terminal_view_target_type_type_id = terminal_terminal_view_target_type_get_type_once ();
		g_once_init_leave (&terminal_terminal_view_target_type_type_id__once, terminal_terminal_view_target_type_type_id);
	}
	return terminal_terminal_view_target_type_type_id__once;
}

TerminalTerminalView*
terminal_terminal_view_construct (GType object_type,
                                  TerminalMainWindow* window)
{
	TerminalTerminalView * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (TerminalTerminalView*) g_object_new (object_type, "main-window", window, NULL);
	return self;
}

TerminalTerminalView*
terminal_terminal_view_new (TerminalMainWindow* window)
{
	return terminal_terminal_view_construct (TERMINAL_TYPE_TERMINAL_VIEW, window);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
terminal_terminal_view_make_restorable (TerminalTerminalView* self,
                                        const gchar* path)
{
	GtkMenuButton* _tmp0_;
	GMenuModel* _tmp1_;
	GMenuModel* _tmp2_;
	GMenu* menu = NULL;
	GtkMenuButton* _tmp6_;
	GMenuModel* _tmp7_;
	GMenuModel* _tmp8_;
	GMenu* _tmp9_;
	gint position_in_menu = 0;
	gboolean path_in_menu = FALSE;
	gint i = 0;
	GMenu* _tmp20_;
	GMenu* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->tab_history_button;
	_tmp1_ = gtk_menu_button_get_menu_model (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkMenuButton* _tmp3_;
		GMenu* _tmp4_;
		GMenu* _tmp5_;
		_tmp3_ = self->priv->tab_history_button;
		_tmp4_ = g_menu_new ();
		_tmp5_ = _tmp4_;
		gtk_menu_button_set_menu_model (_tmp3_, (GMenuModel*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->tab_history_button;
	_tmp7_ = gtk_menu_button_get_menu_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_menu_get_type (), GMenu));
	menu = _tmp9_;
	position_in_menu = -1;
	path_in_menu = FALSE;
	{
		gboolean _tmp10_ = FALSE;
		i = 0;
		_tmp10_ = TRUE;
		while (TRUE) {
			GMenu* _tmp12_;
			GMenu* _tmp13_;
			const GVariantType* _tmp14_;
			GVariant* _tmp15_;
			GVariant* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_;
			if (!_tmp10_) {
				gint _tmp11_;
				_tmp11_ = i;
				i = _tmp11_ + 1;
			}
			_tmp10_ = FALSE;
			_tmp12_ = menu;
			if (!(i < g_menu_model_get_n_items ((GMenuModel*) _tmp12_))) {
				break;
			}
			_tmp13_ = menu;
			_tmp14_ = G_VARIANT_TYPE_STRING;
			_tmp15_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp13_, i, G_MENU_ATTRIBUTE_TARGET, _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_variant_get_string (_tmp16_, NULL);
			_tmp18_ = g_strcmp0 (path, _tmp17_) == 0;
			_g_variant_unref0 (_tmp16_);
			if (_tmp18_) {
				path_in_menu = TRUE;
				position_in_menu = i;
				break;
			}
		}
	}
	if (path_in_menu) {
		GMenu* _tmp19_;
		_tmp19_ = menu;
		g_menu_remove (_tmp19_, position_in_menu);
	}
	_tmp20_ = menu;
	if (g_menu_model_get_n_items ((GMenuModel*) _tmp20_) >= TERMINAL_TERMINAL_VIEW_TAB_HISTORY_MAX_ITEMS) {
		GMenu* _tmp21_;
		_tmp21_ = menu;
		g_menu_remove (_tmp21_, TERMINAL_TERMINAL_VIEW_TAB_HISTORY_MAX_ITEMS - 1);
	}
	_tmp22_ = menu;
	_tmp23_ = g_strdup_printf ("%s::%s", TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_RESTORE_CLOSED_TAB, path);
	_tmp24_ = _tmp23_;
	g_menu_prepend (_tmp22_, path, _tmp24_);
	_g_free0 (_tmp24_);
	_g_object_unref0 (menu);
}

void
terminal_terminal_view_close_tab (TerminalTerminalView* self)
{
	HdyTabPage* _tmp0_ = NULL;
	HdyTabPage* _tmp1_;
	HdyTabPage* target = NULL;
	HdyTabPage* _tmp5_;
	HdyTabPage* _tmp6_;
	HdyTabView* _tmp7_;
	HdyTabPage* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_tab_menu_target;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		HdyTabView* _tmp2_;
		HdyTabPage* _tmp3_;
		HdyTabPage* _tmp4_;
		_tmp2_ = self->priv->_tab_view;
		_tmp3_ = hdy_tab_view_get_selected_page (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	target = _tmp5_;
	_tmp6_ = target;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (target);
		return;
	}
	_tmp7_ = self->priv->_tab_view;
	_tmp8_ = target;
	hdy_tab_view_close_page (_tmp7_, _tmp8_);
	_g_object_unref0 (target);
}

void
terminal_terminal_view_close_tabs_to_right (TerminalTerminalView* self)
{
	HdyTabPage* _tmp0_ = NULL;
	HdyTabPage* _tmp1_;
	HdyTabPage* target = NULL;
	HdyTabPage* _tmp5_;
	HdyTabPage* _tmp6_;
	HdyTabView* _tmp7_;
	HdyTabPage* _tmp8_;
	HdyTabView* _tmp9_;
	HdyTabPage* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_tab_menu_target;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		HdyTabView* _tmp2_;
		HdyTabPage* _tmp3_;
		HdyTabPage* _tmp4_;
		_tmp2_ = self->priv->_tab_view;
		_tmp3_ = hdy_tab_view_get_selected_page (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	target = _tmp5_;
	_tmp6_ = target;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (target);
		return;
	}
	_tmp7_ = self->priv->_tab_view;
	_tmp8_ = target;
	hdy_tab_view_close_pages_after (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->_tab_view;
	_tmp10_ = target;
	hdy_tab_view_set_selected_page (_tmp9_, _tmp10_);
	_g_object_unref0 (target);
}

void
terminal_terminal_view_close_other_tabs (TerminalTerminalView* self)
{
	HdyTabPage* _tmp0_ = NULL;
	HdyTabPage* _tmp1_;
	HdyTabPage* target = NULL;
	HdyTabPage* _tmp5_;
	HdyTabPage* _tmp6_;
	HdyTabView* _tmp7_;
	HdyTabPage* _tmp8_;
	HdyTabView* _tmp9_;
	HdyTabPage* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_tab_menu_target;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		HdyTabView* _tmp2_;
		HdyTabPage* _tmp3_;
		HdyTabPage* _tmp4_;
		_tmp2_ = self->priv->_tab_view;
		_tmp3_ = hdy_tab_view_get_selected_page (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	target = _tmp5_;
	_tmp6_ = target;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (target);
		return;
	}
	_tmp7_ = self->priv->_tab_view;
	_tmp8_ = target;
	hdy_tab_view_close_other_pages (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->_tab_view;
	_tmp10_ = target;
	hdy_tab_view_set_selected_page (_tmp9_, _tmp10_);
	_g_object_unref0 (target);
}

void
terminal_terminal_view_cycle_tabs (TerminalTerminalView* self,
                                   HdyNavigationDirection direction)
{
	gint pos = 0;
	HdyTabView* _tmp0_;
	HdyTabPage* _tmp1_;
	HdyTabPage* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	HdyTabView* _tmp8_;
	HdyTabPage* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tab_view;
	_tmp1_ = terminal_terminal_view_get_selected_page (self);
	_tmp2_ = _tmp1_;
	pos = hdy_tab_view_get_page_position (_tmp0_, _tmp2_);
	if (direction == HDY_NAVIGATION_DIRECTION_FORWARD) {
		_tmp3_ = pos + 1;
	} else {
		_tmp3_ = pos - 1;
	}
	pos = _tmp3_;
	_tmp4_ = terminal_terminal_view_get_n_pages (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = terminal_terminal_view_get_n_pages (self);
	_tmp7_ = _tmp6_;
	pos = (pos + _tmp5_) % _tmp7_;
	_tmp8_ = self->priv->_tab_view;
	_tmp9_ = hdy_tab_view_get_nth_page (_tmp8_, pos);
	terminal_terminal_view_set_selected_page (self, _tmp9_);
}

void
terminal_terminal_view_transfer_tab_to_new_window (TerminalTerminalView* self)
{
	HdyTabPage* _tmp0_ = NULL;
	HdyTabPage* _tmp1_;
	HdyTabPage* target = NULL;
	HdyTabPage* _tmp5_;
	HdyTabPage* _tmp6_;
	TerminalMainWindow* new_window = NULL;
	TerminalMainWindow* _tmp7_;
	TerminalApplication* _tmp8_;
	TerminalApplication* _tmp9_;
	TerminalMainWindow* _tmp10_;
	HdyTabView* _tmp11_;
	HdyTabPage* _tmp12_;
	TerminalMainWindow* _tmp13_;
	TerminalTerminalView* _tmp14_;
	TerminalTerminalView* _tmp15_;
	HdyTabView* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_tab_menu_target;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		HdyTabView* _tmp2_;
		HdyTabPage* _tmp3_;
		HdyTabPage* _tmp4_;
		_tmp2_ = self->priv->_tab_view;
		_tmp3_ = hdy_tab_view_get_selected_page (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	target = _tmp5_;
	_tmp6_ = target;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (target);
		return;
	}
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = terminal_main_window_get_app (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = terminal_main_window_new (_tmp9_, FALSE);
	g_object_ref_sink (_tmp10_);
	new_window = _tmp10_;
	_tmp11_ = self->priv->_tab_view;
	_tmp12_ = target;
	_tmp13_ = new_window;
	_tmp14_ = terminal_main_window_get_notebook (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_->priv->_tab_view;
	hdy_tab_view_transfer_page (_tmp11_, _tmp12_, _tmp16_, 0);
	_g_object_unref0 (new_window);
	_g_object_unref0 (target);
}

static void
terminal_terminal_view_tab_view_setup_menu (TerminalTerminalView* self,
                                            HdyTabPage* page)
{
	GSimpleAction* close_other_tabs_action = NULL;
	TerminalMainWindow* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* close_tabs_to_right_action = NULL;
	TerminalMainWindow* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GSimpleAction* _tmp7_;
	gint _tmp8_ = 0;
	gint page_position = 0;
	gboolean _tmp10_ = FALSE;
	GSimpleAction* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GSimpleAction* _tmp19_;
	g_return_if_fail (self != NULL);
	terminal_terminal_view_set_tab_menu_target (self, page);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = terminal_main_window_get_actions (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = terminal_utils_action_from_group (TERMINAL_MAIN_WINDOW_ACTION_CLOSE_OTHER_TABS, _tmp2_);
	close_other_tabs_action = _tmp3_;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = terminal_main_window_get_actions (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = terminal_utils_action_from_group (TERMINAL_MAIN_WINDOW_ACTION_CLOSE_TABS_TO_RIGHT, _tmp6_);
	close_tabs_to_right_action = _tmp7_;
	if (page != NULL) {
		HdyTabView* _tmp9_;
		_tmp9_ = self->priv->_tab_view;
		_tmp8_ = hdy_tab_view_get_page_position (_tmp9_, page);
	} else {
		_tmp8_ = -1;
	}
	page_position = _tmp8_;
	if (page != NULL) {
		HdyTabView* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->priv->_tab_view;
		_tmp12_ = hdy_tab_view_get_n_pages (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp10_ = _tmp13_ > 1;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp14_ = close_other_tabs_action;
	g_simple_action_set_enabled (_tmp14_, _tmp10_);
	if (page != NULL) {
		HdyTabView* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = self->priv->_tab_view;
		_tmp17_ = hdy_tab_view_get_n_pages (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp15_ = page_position != (_tmp18_ - 1);
	} else {
		_tmp15_ = FALSE;
	}
	_tmp19_ = close_tabs_to_right_action;
	g_simple_action_set_enabled (_tmp19_, _tmp15_);
	_g_object_unref0 (close_tabs_to_right_action);
	_g_object_unref0 (close_other_tabs_action);
}

void
terminal_terminal_view_after_tab_restored (TerminalTerminalView* self,
                                           TerminalTerminalWidget* term)
{
	GMenu* menu = NULL;
	GtkMenuButton* _tmp0_;
	GMenuModel* _tmp1_;
	GMenuModel* _tmp2_;
	GMenu* _tmp3_;
	GMenu* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (term != NULL);
	_tmp0_ = self->priv->tab_history_button;
	_tmp1_ = gtk_menu_button_get_menu_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_menu_get_type (), GMenu));
	menu = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GMenu* _tmp6_;
				const gchar* _tmp7_;
				GMenu* _tmp8_;
				const GVariantType* _tmp9_;
				GVariant* _tmp10_;
				GVariant* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = menu;
				if (!(i < g_menu_model_get_n_items ((GMenuModel*) _tmp6_))) {
					break;
				}
				_tmp7_ = term->terminal_id;
				_tmp8_ = menu;
				_tmp9_ = G_VARIANT_TYPE_STRING;
				_tmp10_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp8_, i, G_MENU_ATTRIBUTE_TARGET, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_variant_get_string (_tmp11_, NULL);
				_tmp13_ = g_strcmp0 (_tmp7_, _tmp12_) == 0;
				_g_variant_unref0 (_tmp11_);
				if (_tmp13_) {
					GMenu* _tmp14_;
					_tmp14_ = menu;
					g_menu_remove (_tmp14_, i);
					break;
				}
			}
		}
	}
	_tmp15_ = menu;
	if (g_menu_model_get_n_items ((GMenuModel*) _tmp15_) == 0) {
		GtkMenuButton* _tmp16_;
		_tmp16_ = self->priv->tab_history_button;
		gtk_menu_button_set_menu_model (_tmp16_, NULL);
	}
	_g_object_unref0 (menu);
}

static GMenu*
terminal_terminal_view_create_menu_model (TerminalTerminalView* self)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GMenu* close_tab_section = NULL;
	GMenu* _tmp1_;
	GMenu* open_tab_section = NULL;
	GMenu* _tmp2_;
	GMenu* reload_section = NULL;
	GMenu* _tmp3_;
	GMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_tmp1_ = g_menu_new ();
	close_tab_section = _tmp1_;
	g_menu_append (close_tab_section, _ ("Close Tabs to the Right"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_CLOSE_TABS_TO_RIGHT);
	g_menu_append (close_tab_section, _ ("Close Other Tabs"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_CLOSE_OTHER_TABS);
	g_menu_append (close_tab_section, _ ("Close Tab"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_CLOSE_TAB);
	_tmp2_ = g_menu_new ();
	open_tab_section = _tmp2_;
	g_menu_append (open_tab_section, _ ("Open in New Window"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_MOVE_TAB_TO_NEW_WINDOW);
	g_menu_append (open_tab_section, _ ("Duplicate Tab"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_DUPLICATE_TAB);
	_tmp3_ = g_menu_new ();
	reload_section = _tmp3_;
	g_menu_append (reload_section, _ ("Reload"), TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_TAB_RELOAD);
	g_menu_append_section (menu, NULL, (GMenuModel*) open_tab_section);
	g_menu_append_section (menu, NULL, (GMenuModel*) close_tab_section);
	g_menu_append_section (menu, NULL, (GMenuModel*) reload_section);
	result = menu;
	_g_object_unref0 (reload_section);
	_g_object_unref0 (open_tab_section);
	_g_object_unref0 (close_tab_section);
	return result;
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
terminal_terminal_view_drag_received (TerminalTerminalView* self,
                                      GtkWidget* w,
                                      GdkDragContext* ctx,
                                      gint x,
                                      gint y,
                                      GtkSelectionData* data,
                                      guint info,
                                      guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (data != NULL);
	if (info == ((guint) TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST)) {
		gchar** uris = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint uris_length1;
		gint _uris_size_;
		GSimpleAction* new_tab_action = NULL;
		TerminalMainWindow* _tmp2_;
		GSimpleActionGroup* _tmp3_;
		GSimpleActionGroup* _tmp4_;
		GSimpleAction* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
		uris = _tmp1_;
		uris_length1 = _vala_array_length (_tmp0_);
		_uris_size_ = uris_length1;
		_tmp2_ = self->priv->_main_window;
		_tmp3_ = terminal_main_window_get_actions (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = terminal_utils_action_from_group (TERMINAL_MAIN_WINDOW_ACTION_NEW_TAB_AT, _tmp4_);
		new_tab_action = _tmp5_;
		_tmp6_ = uris;
		_tmp6__length1 = uris_length1;
		{
			gchar** uri_collection = NULL;
			gint uri_collection_length1 = 0;
			gint _uri_collection_size_ = 0;
			gint uri_it = 0;
			uri_collection = _tmp6_;
			uri_collection_length1 = _tmp6__length1;
			for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
				gchar* _tmp7_;
				gchar* uri = NULL;
				_tmp7_ = g_strdup (uri_collection[uri_it]);
				uri = _tmp7_;
				{
					GFile* file = NULL;
					const gchar* _tmp8_;
					GFile* _tmp9_;
					gchar* scheme = NULL;
					GFile* _tmp10_;
					gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_;
					GFileType type = 0;
					GFile* _tmp15_;
					gchar* path = NULL;
					GSimpleAction* _tmp22_;
					const gchar* _tmp23_;
					GVariant* _tmp24_;
					_tmp8_ = uri;
					_tmp9_ = g_file_new_for_uri (_tmp8_);
					file = _tmp9_;
					_tmp10_ = file;
					_tmp11_ = g_file_get_uri_scheme (_tmp10_);
					scheme = _tmp11_;
					_tmp13_ = scheme;
					if (g_strcmp0 (_tmp13_, "file") != 0) {
						const gchar* _tmp14_;
						_tmp14_ = scheme;
						_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						_g_free0 (scheme);
						_g_object_unref0 (file);
						_g_free0 (uri);
						_g_object_unref0 (new_tab_action);
						uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_tmp15_ = file;
					type = g_file_query_file_type (_tmp15_, G_FILE_QUERY_INFO_NONE, NULL);
					if (type == G_FILE_TYPE_DIRECTORY) {
						GFile* _tmp16_;
						gchar* _tmp17_;
						_tmp16_ = file;
						_tmp17_ = g_file_get_path (_tmp16_);
						_g_free0 (path);
						path = _tmp17_;
					} else {
						if (type == G_FILE_TYPE_REGULAR) {
							GFile* _tmp18_;
							GFile* _tmp19_;
							GFile* _tmp20_;
							gchar* _tmp21_;
							_tmp18_ = file;
							_tmp19_ = g_file_get_parent (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = g_file_get_path (_tmp20_);
							_g_free0 (path);
							path = _tmp21_;
							_g_object_unref0 (_tmp20_);
						} else {
							_g_free0 (path);
							_g_free0 (scheme);
							_g_object_unref0 (file);
							_g_free0 (uri);
							continue;
						}
					}
					_tmp22_ = new_tab_action;
					_tmp23_ = path;
					_tmp24_ = _variant_new1 (_tmp23_);
					g_signal_emit_by_name (_tmp22_, "activate", _tmp24_);
					_g_variant_unref0 (_tmp24_);
					_g_free0 (path);
					_g_free0 (scheme);
					_g_object_unref0 (file);
					_g_free0 (uri);
				}
			}
		}
		_g_object_unref0 (new_tab_action);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	gtk_drag_finish (ctx, TRUE, FALSE, (guint32) time);
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
terminal_terminal_view_on_extra_drag_data_received (TerminalTerminalView* self,
                                                    HdyTabBar* tab_bar,
                                                    HdyTabPage* page,
                                                    GdkDragContext* ctx,
                                                    GtkSelectionData* data,
                                                    guint info,
                                                    guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab_bar != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (data != NULL);
	if (info == ((guint) TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST)) {
		gchar** uris = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint uris_length1;
		gint _uris_size_;
		GSimpleAction* active_shell_action = NULL;
		TerminalMainWindow* _tmp2_;
		GSimpleActionGroup* _tmp3_;
		GSimpleActionGroup* _tmp4_;
		GSimpleAction* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
		uris = _tmp1_;
		uris_length1 = _vala_array_length (_tmp0_);
		_uris_size_ = uris_length1;
		_tmp2_ = self->priv->_main_window;
		_tmp3_ = terminal_main_window_get_actions (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = terminal_utils_action_from_group (TERMINAL_MAIN_WINDOW_ACTION_TAB_ACTIVE_SHELL, _tmp4_);
		active_shell_action = _tmp5_;
		_tmp6_ = uris;
		_tmp6__length1 = uris_length1;
		{
			gchar** uri_collection = NULL;
			gint uri_collection_length1 = 0;
			gint _uri_collection_size_ = 0;
			gint uri_it = 0;
			uri_collection = _tmp6_;
			uri_collection_length1 = _tmp6__length1;
			for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
				gchar* _tmp7_;
				gchar* uri = NULL;
				_tmp7_ = g_strdup (uri_collection[uri_it]);
				uri = _tmp7_;
				{
					GFile* file = NULL;
					const gchar* _tmp8_;
					GFile* _tmp9_;
					gchar* scheme = NULL;
					GFile* _tmp10_;
					gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_;
					GFileType type = 0;
					GFile* _tmp15_;
					gchar* path = NULL;
					GSimpleAction* _tmp22_;
					const gchar* _tmp23_;
					GVariant* _tmp24_;
					_tmp8_ = uri;
					_tmp9_ = g_file_new_for_uri (_tmp8_);
					file = _tmp9_;
					_tmp10_ = file;
					_tmp11_ = g_file_get_uri_scheme (_tmp10_);
					scheme = _tmp11_;
					_tmp13_ = scheme;
					if (g_strcmp0 (_tmp13_, "file") != 0) {
						const gchar* _tmp14_;
						_tmp14_ = scheme;
						_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						_g_free0 (scheme);
						_g_object_unref0 (file);
						_g_free0 (uri);
						_g_object_unref0 (active_shell_action);
						uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_tmp15_ = file;
					type = g_file_query_file_type (_tmp15_, G_FILE_QUERY_INFO_NONE, NULL);
					if (type == G_FILE_TYPE_DIRECTORY) {
						GFile* _tmp16_;
						gchar* _tmp17_;
						_tmp16_ = file;
						_tmp17_ = g_file_get_path (_tmp16_);
						_g_free0 (path);
						path = _tmp17_;
					} else {
						if (type == G_FILE_TYPE_REGULAR) {
							GFile* _tmp18_;
							GFile* _tmp19_;
							GFile* _tmp20_;
							gchar* _tmp21_;
							_tmp18_ = file;
							_tmp19_ = g_file_get_parent (_tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = g_file_get_path (_tmp20_);
							_g_free0 (path);
							path = _tmp21_;
							_g_object_unref0 (_tmp20_);
						} else {
							_g_free0 (path);
							_g_free0 (scheme);
							_g_object_unref0 (file);
							_g_free0 (uri);
							continue;
						}
					}
					_tmp22_ = active_shell_action;
					_tmp23_ = path;
					_tmp24_ = _variant_new2 (_tmp23_);
					g_signal_emit_by_name (_tmp22_, "activate", _tmp24_);
					_g_variant_unref0 (_tmp24_);
					_g_free0 (path);
					_g_free0 (scheme);
					_g_object_unref0 (file);
					_g_free0 (uri);
				}
			}
		}
		_g_object_unref0 (active_shell_action);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	gtk_drag_finish (ctx, TRUE, FALSE, (guint32) time);
}

gint
terminal_terminal_view_get_n_pages (TerminalTerminalView* self)
{
	gint result;
	HdyTabView* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_tab_view;
	_tmp1_ = hdy_tab_view_get_n_pages (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

HdyTabPage*
terminal_terminal_view_get_selected_page (TerminalTerminalView* self)
{
	HdyTabPage* result;
	HdyTabView* _tmp0_;
	HdyTabPage* _tmp1_;
	HdyTabPage* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tab_view;
	_tmp1_ = hdy_tab_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
terminal_terminal_view_set_selected_page (TerminalTerminalView* self,
                                          HdyTabPage* value)
{
	HdyTabView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tab_view;
	hdy_tab_view_set_selected_page (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY]);
}

TerminalMainWindow*
terminal_terminal_view_get_main_window (TerminalTerminalView* self)
{
	TerminalMainWindow* result;
	TerminalMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}

static void
terminal_terminal_view_set_main_window (TerminalTerminalView* self,
                                        TerminalMainWindow* value)
{
	TerminalMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_view_get_main_window (self);
	if (old_value != value) {
		self->priv->_main_window = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY]);
	}
}

HdyTabView*
terminal_terminal_view_get_tab_view (TerminalTerminalView* self)
{
	HdyTabView* result;
	HdyTabView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tab_view;
	result = _tmp0_;
	return result;
}

static void
terminal_terminal_view_set_tab_view (TerminalTerminalView* self,
                                     HdyTabView* value)
{
	HdyTabView* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_view_get_tab_view (self);
	if (old_value != value) {
		HdyTabView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tab_view);
		self->priv->_tab_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY]);
	}
}

HdyTabPage*
terminal_terminal_view_get_tab_menu_target (TerminalTerminalView* self)
{
	HdyTabPage* result;
	HdyTabPage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tab_menu_target;
	result = _tmp0_;
	return result;
}

static void
terminal_terminal_view_set_tab_menu_target (TerminalTerminalView* self,
                                            HdyTabPage* value)
{
	HdyTabPage* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_view_get_tab_menu_target (self);
	if (old_value != value) {
		HdyTabPage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tab_menu_target);
		self->priv->_tab_menu_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY]);
	}
}

static void
_terminal_terminal_view_tab_view_setup_menu_hdy_tab_view_setup_menu (HdyTabView* _sender,
                                                                     HdyTabPage* page,
                                                                     gpointer self)
{
	terminal_terminal_view_tab_view_setup_menu ((TerminalTerminalView*) self, page);
}

static void
_terminal_terminal_view_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                     GdkDragContext* context,
                                                                     gint x,
                                                                     gint y,
                                                                     GtkSelectionData* selection_data,
                                                                     guint info,
                                                                     guint time_,
                                                                     gpointer self)
{
	terminal_terminal_view_drag_received ((TerminalTerminalView*) self, _sender, context, x, y, selection_data, info, time_);
}

static void
_terminal_terminal_view_on_extra_drag_data_received_hdy_tab_bar_extra_drag_data_received (HdyTabBar* _sender,
                                                                                          HdyTabPage* page,
                                                                                          GdkDragContext* context,
                                                                                          GtkSelectionData* data,
                                                                                          guint info,
                                                                                          guint time,
                                                                                          gpointer self)
{
	terminal_terminal_view_on_extra_drag_data_received ((TerminalTerminalView*) self, _sender, page, context, data, info, time);
}

static GObject *
terminal_terminal_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalTerminalView * self;
	GtkApplication* app_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	HdyTabView* _tmp2_ = NULL;
	HdyTabView* _tmp3_;
	HdyTabView* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	HdyTabView* _tmp7_;
	GtkButton* new_tab_button = NULL;
	GtkApplication* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkImage* _tmp16_;
	gchar* _tmp17_;
	GtkMenuButton* _tmp18_ = NULL;
	GtkButton* _tmp19_;
	GtkWidget* _tmp20_;
	GtkMenuButton* _tmp21_;
	GtkWidget* _tmp22_;
	HdyTabView* _tmp23_;
	HdyTabView* _tmp24_;
	HdyTabBar* _tmp25_ = NULL;
	GtkCssProvider* _tmp26_;
	GdkScreen* _tmp27_;
	GtkCssProvider* _tmp28_;
	GtkTargetEntry uris = {0};
	GtkTargetEntry _tmp29_ = {0};
	GtkButton* _tmp30_;
	GtkTargetEntry _tmp31_;
	GtkTargetEntry* _tmp32_;
	GtkTargetEntry* _tmp33_;
	gint _tmp33__length1;
	GtkButton* _tmp34_;
	HdyTabBar* _tmp35_;
	GtkTargetEntry _tmp36_;
	GtkTargetEntry* _tmp37_;
	GtkTargetEntry* _tmp38_;
	gint _tmp38__length1;
	GtkTargetList* _tmp39_;
	GtkTargetList* _tmp40_;
	HdyTabBar* _tmp41_;
	HdyTabBar* _tmp42_;
	HdyTabView* _tmp43_;
	parent_class = G_OBJECT_CLASS (terminal_terminal_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	app_instance = _tmp1_;
	_tmp2_ = hdy_tab_view_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	terminal_terminal_view_set_tab_view (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_tab_view;
	_tmp5_ = terminal_terminal_view_create_menu_model (self);
	_tmp6_ = _tmp5_;
	hdy_tab_view_set_menu_model (_tmp4_, (GMenuModel*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_tab_view;
	g_signal_connect_object (_tmp7_, "setup-menu", (GCallback) _terminal_terminal_view_tab_view_setup_menu_hdy_tab_view_setup_menu, self, 0);
	_tmp8_ = app_instance;
	_tmp10_ = _tmp9_ = gtk_application_get_accels_for_action (_tmp8_, TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_NEW_TAB);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _vala_array_length (_tmp9_);
	_tmp12_ = granite_markup_accel_tooltip (_tmp11_, (gint) _vala_array_length (_tmp9_), _ ("New Tab"));
	_tmp13_ = g_strdup (TERMINAL_MAIN_WINDOW_ACTION_PREFIX TERMINAL_MAIN_WINDOW_ACTION_NEW_TAB);
	_tmp14_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_button_set_relief (_tmp14_, GTK_RELIEF_NONE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp14_, _tmp12_);
	_g_free0 (_tmp12_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	new_tab_button = _tmp15_;
	_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = g_strdup (_ ("Closed Tabs"));
	_tmp18_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp18_, (GtkWidget*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _tmp17_);
	_g_free0 (_tmp17_);
	gtk_menu_button_set_use_popover (_tmp18_, FALSE);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->tab_history_button);
	self->priv->tab_history_button = _tmp18_;
	_tmp19_ = new_tab_button;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	_tmp21_ = self->priv->tab_history_button;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = self->priv->_tab_view;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_tmp25_ = hdy_tab_bar_new ();
	hdy_tab_bar_set_autohide (_tmp25_, FALSE);
	hdy_tab_bar_set_expand_tabs (_tmp25_, FALSE);
	hdy_tab_bar_set_inverted (_tmp25_, TRUE);
	hdy_tab_bar_set_start_action_widget (_tmp25_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	hdy_tab_bar_set_end_action_widget (_tmp25_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	hdy_tab_bar_set_view (_tmp25_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->tab_bar);
	self->priv->tab_bar = _tmp25_;
	_tmp26_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->style_provider);
	self->priv->style_provider = _tmp26_;
	_tmp27_ = gdk_screen_get_default ();
	_tmp28_ = self->priv->style_provider;
	gtk_style_context_add_provider_for_screen (_tmp27_, (GtkStyleProvider*) _tmp28_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp29_.target = "text/uri-list";
	_tmp29_.flags = (guint) 0;
	_tmp29_.info = (guint) TERMINAL_TERMINAL_VIEW_TARGET_TYPE_URI_LIST;
	uris = _tmp29_;
	_tmp30_ = new_tab_button;
	_tmp31_ = uris;
	_tmp32_ = g_new0 (GtkTargetEntry, 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) _tmp30_, GTK_DEST_DEFAULT_ALL, _tmp33_, (gint) 1, GDK_ACTION_COPY);
	_tmp33_ = (g_free (_tmp33_), NULL);
	_tmp34_ = new_tab_button;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "drag-data-received", (GCallback) _terminal_terminal_view_drag_received_gtk_widget_drag_data_received, self, 0);
	_tmp35_ = self->priv->tab_bar;
	_tmp36_ = uris;
	_tmp37_ = g_new0 (GtkTargetEntry, 1);
	_tmp37_[0] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 1;
	_tmp39_ = gtk_target_list_new (_tmp38_, 1);
	_tmp40_ = _tmp39_;
	hdy_tab_bar_set_extra_drag_dest_targets (_tmp35_, _tmp40_);
	_gtk_target_list_unref0 (_tmp40_);
	_tmp38_ = (g_free (_tmp38_), NULL);
	_tmp41_ = self->priv->tab_bar;
	g_signal_connect_object (_tmp41_, "extra-drag-data-received", (GCallback) _terminal_terminal_view_on_extra_drag_data_received_hdy_tab_bar_extra_drag_data_received, self, 0);
	_tmp42_ = self->priv->tab_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->_tab_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
	_g_object_unref0 (new_tab_button);
	_g_object_unref0 (app_instance);
	return obj;
}

static void
terminal_terminal_view_class_init (TerminalTerminalViewClass * klass,
                                   gpointer klass_data)
{
	terminal_terminal_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalTerminalView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_terminal_terminal_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_terminal_terminal_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = terminal_terminal_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_terminal_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_VIEW_N_PAGES_PROPERTY, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_N_PAGES_PROPERTY] = g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY] = g_param_spec_object ("selected-page", "selected-page", "selected-page", hdy_tab_page_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY] = g_param_spec_object ("main-window", "main-window", "main-window", TERMINAL_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY] = g_param_spec_object ("tab-view", "tab-view", "tab-view", hdy_tab_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY, terminal_terminal_view_properties[TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY] = g_param_spec_object ("tab-menu-target", "tab-menu-target", "tab-menu-target", hdy_tab_page_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	terminal_terminal_view_signals[TERMINAL_TERMINAL_VIEW_NEW_TAB_REQUESTED_SIGNAL] = g_signal_new ("new-tab-requested", TERMINAL_TYPE_TERMINAL_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	terminal_terminal_view_signals[TERMINAL_TERMINAL_VIEW_TAB_DUPLICATED_SIGNAL] = g_signal_new ("tab-duplicated", TERMINAL_TYPE_TERMINAL_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, hdy_tab_page_get_type ());
}

static void
terminal_terminal_view_instance_init (TerminalTerminalView * self,
                                      gpointer klass)
{
	self->priv = terminal_terminal_view_get_instance_private (self);
	self->priv->_tab_menu_target = NULL;
}

static void
terminal_terminal_view_finalize (GObject * obj)
{
	TerminalTerminalView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView);
	_g_object_unref0 (self->priv->_tab_view);
	_g_object_unref0 (self->priv->tab_bar);
	_g_object_unref0 (self->priv->_tab_menu_target);
	_g_object_unref0 (self->priv->style_provider);
	_g_object_unref0 (self->priv->tab_history_button);
	G_OBJECT_CLASS (terminal_terminal_view_parent_class)->finalize (obj);
}

static GType
terminal_terminal_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalTerminalViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_terminal_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalTerminalView), 0, (GInstanceInitFunc) terminal_terminal_view_instance_init, NULL };
	GType terminal_terminal_view_type_id;
	terminal_terminal_view_type_id = g_type_register_static (gtk_box_get_type (), "TerminalTerminalView", &g_define_type_info, 0);
	TerminalTerminalView_private_offset = g_type_add_instance_private (terminal_terminal_view_type_id, sizeof (TerminalTerminalViewPrivate));
	return terminal_terminal_view_type_id;
}

GType
terminal_terminal_view_get_type (void)
{
	static volatile gsize terminal_terminal_view_type_id__once = 0;
	if (g_once_init_enter (&terminal_terminal_view_type_id__once)) {
		GType terminal_terminal_view_type_id;
		terminal_terminal_view_type_id = terminal_terminal_view_get_type_once ();
		g_once_init_leave (&terminal_terminal_view_type_id__once, terminal_terminal_view_type_id);
	}
	return terminal_terminal_view_type_id__once;
}

static void
_vala_terminal_terminal_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	TerminalTerminalView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView);
	switch (property_id) {
		case TERMINAL_TERMINAL_VIEW_N_PAGES_PROPERTY:
		g_value_set_int (value, terminal_terminal_view_get_n_pages (self));
		break;
		case TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY:
		g_value_set_object (value, terminal_terminal_view_get_selected_page (self));
		break;
		case TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY:
		g_value_set_object (value, terminal_terminal_view_get_main_window (self));
		break;
		case TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY:
		g_value_set_object (value, terminal_terminal_view_get_tab_view (self));
		break;
		case TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY:
		g_value_set_object (value, terminal_terminal_view_get_tab_menu_target (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_terminal_terminal_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	TerminalTerminalView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView);
	switch (property_id) {
		case TERMINAL_TERMINAL_VIEW_SELECTED_PAGE_PROPERTY:
		terminal_terminal_view_set_selected_page (self, g_value_get_object (value));
		break;
		case TERMINAL_TERMINAL_VIEW_MAIN_WINDOW_PROPERTY:
		terminal_terminal_view_set_main_window (self, g_value_get_object (value));
		break;
		case TERMINAL_TERMINAL_VIEW_TAB_VIEW_PROPERTY:
		terminal_terminal_view_set_tab_view (self, g_value_get_object (value));
		break;
		case TERMINAL_TERMINAL_VIEW_TAB_MENU_TARGET_PROPERTY:
		terminal_terminal_view_set_tab_menu_target (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

