/* Interfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>   
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */
/*
 * Code based on budgie-desktop:
 * https://github.com/solus-project/budgie-desktop
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AG_TYPE_SESSION_MANAGER (ag_session_manager_get_type ())
#define AG_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_SESSION_MANAGER, AgSessionManager))
#define AG_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_SESSION_MANAGER))
#define AG_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_SESSION_MANAGER, AgSessionManagerIface))

typedef struct _AgSessionManager AgSessionManager;
typedef struct _AgSessionManagerIface AgSessionManagerIface;

#define AG_TYPE_SESSION_MANAGER_PROXY (ag_session_manager_proxy_get_type ())
typedef GDBusProxy AgSessionManagerProxy;
typedef GDBusProxyClass AgSessionManagerProxyClass;
typedef struct _AgSessionManagerRegisterClientReadyData AgSessionManagerRegisterClientReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AG_TYPE_SESSION_CLIENT (ag_session_client_get_type ())
#define AG_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_SESSION_CLIENT, AgSessionClient))
#define AG_IS_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_SESSION_CLIENT))
#define AG_SESSION_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), AG_TYPE_SESSION_CLIENT, AgSessionClientIface))

typedef struct _AgSessionClient AgSessionClient;
typedef struct _AgSessionClientIface AgSessionClientIface;

#define AG_TYPE_SESSION_CLIENT_PROXY (ag_session_client_proxy_get_type ())
enum  {
	AG_SESSION_CLIENT_STOP_SIGNAL,
	AG_SESSION_CLIENT_QUERY_END_SESSION_SIGNAL,
	AG_SESSION_CLIENT_END_SESSION_SIGNAL,
	AG_SESSION_CLIENT_CANCEL_END_SESSION_SIGNAL,
	AG_SESSION_CLIENT_NUM_SIGNALS
};
static guint ag_session_client_signals[AG_SESSION_CLIENT_NUM_SIGNALS] = {0};
typedef GDBusProxy AgSessionClientProxy;
typedef GDBusProxyClass AgSessionClientProxyClass;

struct _AgSessionManagerIface {
	GTypeInterface parent_iface;
	void (*register_client) (AgSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*register_client_finish) (AgSessionManager* self, GAsyncResult* _res_, GError** error);
};

struct _AgSessionManagerRegisterClientReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* app_id;
	gchar* client_start_id;
};

struct _AgSessionClientIface {
	GTypeInterface parent_iface;
	void (*end_session_response) (AgSessionClient* self, gboolean is_ok, const gchar* reason, GError** error);
};

VALA_EXTERN GType ag_session_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_session_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType ag_session_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgSessionManager, g_object_unref)
VALA_EXTERN void ag_session_manager_register_client (AgSessionManager* self,
                                         const gchar* app_id,
                                         const gchar* client_start_id,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN char* ag_session_manager_register_client_finish (AgSessionManager* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static GType ag_session_manager_get_type_once (void);
static void ag_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void ag_session_manager_proxy_register_client_async (AgSessionManager* self,
                                                     const gchar* app_id,
                                                     const gchar* client_start_id,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static char* ag_session_manager_proxy_register_client_finish (AgSessionManager* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ag_session_manager_proxy_ag_session_manager_interface_init (AgSessionManagerIface* iface);
static void _dbus_ag_session_manager_register_client (AgSessionManager* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_ag_session_manager_register_client_ready (GObject * source_object,
                                                     GAsyncResult * _res_,
                                                     gpointer _user_data_);
static void ag_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* ag_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean ag_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _ag_session_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType ag_session_client_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint ag_session_client_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType ag_session_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgSessionClient, g_object_unref)
VALA_EXTERN void ag_session_client_end_session_response (AgSessionClient* self,
                                             gboolean is_ok,
                                             const gchar* reason,
                                             GError** error);
static GType ag_session_client_get_type_once (void);
static void ag_session_client_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_ag_session_client_stop (AgSessionClient* self,
                                          GVariant* parameters);
static void _dbus_handle_ag_session_client_query_end_session (AgSessionClient* self,
                                                       GVariant* parameters);
static void _dbus_handle_ag_session_client_end_session (AgSessionClient* self,
                                                 GVariant* parameters);
static void _dbus_handle_ag_session_client_cancel_end_session (AgSessionClient* self,
                                                        GVariant* parameters);
static void ag_session_client_proxy_end_session_response (AgSessionClient* self,
                                                   gboolean is_ok,
                                                   const gchar* reason,
                                                   GError** error);
static void ag_session_client_proxy_ag_session_client_interface_init (AgSessionClientIface* iface);
static void _dbus_ag_session_client_end_session_response (AgSessionClient* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void ag_session_client_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* ag_session_client_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean ag_session_client_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_ag_session_client_stop (GObject* _sender,
                                   gpointer* _data);
static void _dbus_ag_session_client_query_end_session (GObject* _sender,
                                                guint flags,
                                                gpointer* _data);
static void _dbus_ag_session_client_end_session (GObject* _sender,
                                          guint flags,
                                          gpointer* _data);
static void _dbus_ag_session_client_cancel_end_session (GObject* _sender,
                                                 gpointer* _data);
static void _ag_session_client_unregister_object (gpointer user_data);

static const GDBusArgInfo _ag_session_manager_dbus_arg_info_register_client_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _ag_session_manager_dbus_arg_info_register_client_client_start_id = {-1, "client_start_id", "s", NULL};
static const GDBusArgInfo _ag_session_manager_dbus_arg_info_register_client_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _ag_session_manager_dbus_arg_info_register_client_in[] = {&_ag_session_manager_dbus_arg_info_register_client_app_id, &_ag_session_manager_dbus_arg_info_register_client_client_start_id, NULL};
static const GDBusArgInfo * const _ag_session_manager_dbus_arg_info_register_client_out[] = {&_ag_session_manager_dbus_arg_info_register_client_result, NULL};
static const GDBusMethodInfo _ag_session_manager_dbus_method_info_register_client = {-1, "RegisterClient", (GDBusArgInfo **) (&_ag_session_manager_dbus_arg_info_register_client_in), (GDBusArgInfo **) (&_ag_session_manager_dbus_arg_info_register_client_out), NULL};
static const GDBusMethodInfo * const _ag_session_manager_dbus_method_info[] = {&_ag_session_manager_dbus_method_info_register_client, NULL};
static const GDBusSignalInfo * const _ag_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _ag_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _ag_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_ag_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_ag_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_ag_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _ag_session_manager_dbus_interface_vtable = {ag_session_manager_dbus_interface_method_call, ag_session_manager_dbus_interface_get_property, ag_session_manager_dbus_interface_set_property};
static const GDBusArgInfo _ag_session_client_dbus_arg_info_end_session_response_is_ok = {-1, "is_ok", "b", NULL};
static const GDBusArgInfo _ag_session_client_dbus_arg_info_end_session_response_reason = {-1, "reason", "s", NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_end_session_response_in[] = {&_ag_session_client_dbus_arg_info_end_session_response_is_ok, &_ag_session_client_dbus_arg_info_end_session_response_reason, NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_end_session_response_out[] = {NULL};
static const GDBusMethodInfo _ag_session_client_dbus_method_info_end_session_response = {-1, "EndSessionResponse", (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_end_session_response_in), (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_end_session_response_out), NULL};
static const GDBusMethodInfo * const _ag_session_client_dbus_method_info[] = {&_ag_session_client_dbus_method_info_end_session_response, NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_stop[] = {NULL};
static const GDBusSignalInfo _ag_session_client_dbus_signal_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_stop), NULL};
static const GDBusArgInfo _ag_session_client_dbus_arg_info_query_end_session_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_query_end_session[] = {&_ag_session_client_dbus_arg_info_query_end_session_flags, NULL};
static const GDBusSignalInfo _ag_session_client_dbus_signal_info_query_end_session = {-1, "QueryEndSession", (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_query_end_session), NULL};
static const GDBusArgInfo _ag_session_client_dbus_arg_info_end_session_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_end_session[] = {&_ag_session_client_dbus_arg_info_end_session_flags, NULL};
static const GDBusSignalInfo _ag_session_client_dbus_signal_info_end_session = {-1, "EndSession", (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_end_session), NULL};
static const GDBusArgInfo * const _ag_session_client_dbus_arg_info_cancel_end_session[] = {NULL};
static const GDBusSignalInfo _ag_session_client_dbus_signal_info_cancel_end_session = {-1, "CancelEndSession", (GDBusArgInfo **) (&_ag_session_client_dbus_arg_info_cancel_end_session), NULL};
static const GDBusSignalInfo * const _ag_session_client_dbus_signal_info[] = {&_ag_session_client_dbus_signal_info_stop, &_ag_session_client_dbus_signal_info_query_end_session, &_ag_session_client_dbus_signal_info_end_session, &_ag_session_client_dbus_signal_info_cancel_end_session, NULL};
static const GDBusPropertyInfo * const _ag_session_client_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _ag_session_client_dbus_interface_info = {-1, "org.gnome.SessionManager.ClientPrivate", (GDBusMethodInfo **) (&_ag_session_client_dbus_method_info), (GDBusSignalInfo **) (&_ag_session_client_dbus_signal_info), (GDBusPropertyInfo **) (&_ag_session_client_dbus_property_info), NULL};
static const GDBusInterfaceVTable _ag_session_client_dbus_interface_vtable = {ag_session_client_dbus_interface_method_call, ag_session_client_dbus_interface_get_property, ag_session_client_dbus_interface_set_property};

void
ag_session_manager_register_client (AgSessionManager* self,
                                    const gchar* app_id,
                                    const gchar* client_start_id,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	AgSessionManagerIface* _iface_;
	_iface_ = AG_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->register_client) {
		_iface_->register_client (self, app_id, client_start_id, _callback_, _user_data_);
	}
}

char*
ag_session_manager_register_client_finish (AgSessionManager* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	AgSessionManagerIface* _iface_;
	_iface_ = AG_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->register_client_finish) {
		return _iface_->register_client_finish (self, _res_, error);
	}
	return NULL;
}

static void
ag_session_manager_default_init (AgSessionManagerIface * iface,
                                 gpointer iface_data)
{
}

static GType
ag_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgSessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ag_session_manager_type_id;
	ag_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "AgSessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ag_session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (ag_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ag_session_manager_proxy_get_type);
	g_type_set_qdata (ag_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (ag_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_ag_session_manager_dbus_interface_info));
	g_type_set_qdata (ag_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ag_session_manager_register_object);
	return ag_session_manager_type_id;
}

GType
ag_session_manager_get_type (void)
{
	static volatile gsize ag_session_manager_type_id__once = 0;
	if (g_once_init_enter (&ag_session_manager_type_id__once)) {
		GType ag_session_manager_type_id;
		ag_session_manager_type_id = ag_session_manager_get_type_once ();
		g_once_init_leave (&ag_session_manager_type_id__once, ag_session_manager_type_id);
	}
	return ag_session_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AgSessionManagerProxy, ag_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (AG_TYPE_SESSION_MANAGER, ag_session_manager_proxy_ag_session_manager_interface_init) )
static void
ag_session_manager_proxy_class_init (AgSessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = ag_session_manager_proxy_g_signal;
}

static void
ag_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
ag_session_manager_proxy_init (AgSessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_ag_session_manager_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
ag_session_manager_proxy_register_client_async (AgSessionManager* self,
                                                const gchar* app_id,
                                                const gchar* client_start_id,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "RegisterClient");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (client_start_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static char*
ag_session_manager_proxy_register_client_finish (AgSessionManager* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp0_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
ag_session_manager_proxy_ag_session_manager_interface_init (AgSessionManagerIface* iface)
{
	iface->register_client = ag_session_manager_proxy_register_client_async;
	iface->register_client_finish = ag_session_manager_proxy_register_client_finish;
}

static void
_dbus_ag_session_manager_register_client (AgSessionManager* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AgSessionManagerRegisterClientReadyData* _ready_data;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AgSessionManagerRegisterClientReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->client_start_id = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	ag_session_manager_register_client (self, _ready_data->app_id, _ready_data->client_start_id, (GAsyncReadyCallback) _dbus_ag_session_manager_register_client_ready, _ready_data);
	_error:
	;
}

static void
_dbus_ag_session_manager_register_client_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_)
{
	AgSessionManagerRegisterClientReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = ag_session_manager_register_client_finish ((AgSessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->client_start_id);
	g_slice_free (AgSessionManagerRegisterClientReadyData, _ready_data);
}

static void
ag_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RegisterClient") == 0) {
		_dbus_ag_session_manager_register_client (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
ag_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
ag_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
ag_session_manager_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ag_session_manager_dbus_interface_info), &_ag_session_manager_dbus_interface_vtable, data, _ag_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_ag_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
ag_session_client_end_session_response (AgSessionClient* self,
                                        gboolean is_ok,
                                        const gchar* reason,
                                        GError** error)
{
	AgSessionClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = AG_SESSION_CLIENT_GET_INTERFACE (self);
	if (_iface_->end_session_response) {
		_iface_->end_session_response (self, is_ok, reason, error);
	}
}

static void
ag_session_client_default_init (AgSessionClientIface * iface,
                                gpointer iface_data)
{
	ag_session_client_signals[AG_SESSION_CLIENT_STOP_SIGNAL] = g_signal_new ("stop", AG_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	ag_session_client_signals[AG_SESSION_CLIENT_QUERY_END_SESSION_SIGNAL] = g_signal_new ("query-end-session", AG_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	ag_session_client_signals[AG_SESSION_CLIENT_END_SESSION_SIGNAL] = g_signal_new ("end-session", AG_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	ag_session_client_signals[AG_SESSION_CLIENT_CANCEL_END_SESSION_SIGNAL] = g_signal_new ("cancel-end-session", AG_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
ag_session_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgSessionClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_session_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType ag_session_client_type_id;
	ag_session_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "AgSessionClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (ag_session_client_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (ag_session_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ag_session_client_proxy_get_type);
	g_type_set_qdata (ag_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.ClientPrivate");
	g_type_set_qdata (ag_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_ag_session_client_dbus_interface_info));
	g_type_set_qdata (ag_session_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ag_session_client_register_object);
	return ag_session_client_type_id;
}

GType
ag_session_client_get_type (void)
{
	static volatile gsize ag_session_client_type_id__once = 0;
	if (g_once_init_enter (&ag_session_client_type_id__once)) {
		GType ag_session_client_type_id;
		ag_session_client_type_id = ag_session_client_get_type_once ();
		g_once_init_leave (&ag_session_client_type_id__once, ag_session_client_type_id);
	}
	return ag_session_client_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AgSessionClientProxy, ag_session_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (AG_TYPE_SESSION_CLIENT, ag_session_client_proxy_ag_session_client_interface_init) )
static void
ag_session_client_proxy_class_init (AgSessionClientProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = ag_session_client_proxy_g_signal;
}

static void
_dbus_handle_ag_session_client_stop (AgSessionClient* self,
                                     GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "stop");
}

static void
_dbus_handle_ag_session_client_query_end_session (AgSessionClient* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "query-end-session", flags);
}

static void
_dbus_handle_ag_session_client_end_session (AgSessionClient* self,
                                            GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	g_signal_emit_by_name (self, "end-session", flags);
}

static void
_dbus_handle_ag_session_client_cancel_end_session (AgSessionClient* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "cancel-end-session");
}

static void
ag_session_client_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "Stop") == 0) {
		_dbus_handle_ag_session_client_stop ((AgSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "QueryEndSession") == 0) {
		_dbus_handle_ag_session_client_query_end_session ((AgSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "EndSession") == 0) {
		_dbus_handle_ag_session_client_end_session ((AgSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "CancelEndSession") == 0) {
		_dbus_handle_ag_session_client_cancel_end_session ((AgSessionClient*) proxy, parameters);
	}
}

static void
ag_session_client_proxy_init (AgSessionClientProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_ag_session_client_dbus_interface_info));
}

static void
ag_session_client_proxy_end_session_response (AgSessionClient* self,
                                              gboolean is_ok,
                                              const gchar* reason,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.ClientPrivate", "EndSessionResponse");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_ok));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
ag_session_client_proxy_ag_session_client_interface_init (AgSessionClientIface* iface)
{
	iface->end_session_response = ag_session_client_proxy_end_session_response;
}

static void
_dbus_ag_session_client_end_session_response (AgSessionClient* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean is_ok = FALSE;
	GVariant* _tmp5_;
	gchar* reason = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	is_ok = g_variant_get_boolean (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	ag_session_client_end_session_response (self, is_ok, reason, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (reason);
	;
}

static void
ag_session_client_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EndSessionResponse") == 0) {
		_dbus_ag_session_client_end_session_response (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
ag_session_client_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
ag_session_client_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_ag_session_client_stop (GObject* _sender,
                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "Stop", _arguments, NULL);
}

static void
_dbus_ag_session_client_query_end_session (GObject* _sender,
                                           guint flags,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "QueryEndSession", _arguments, NULL);
}

static void
_dbus_ag_session_client_end_session (GObject* _sender,
                                     guint flags,
                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "EndSession", _arguments, NULL);
}

static void
_dbus_ag_session_client_cancel_end_session (GObject* _sender,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "CancelEndSession", _arguments, NULL);
}

guint
ag_session_client_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ag_session_client_dbus_interface_info), &_ag_session_client_dbus_interface_vtable, data, _ag_session_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "stop", (GCallback) _dbus_ag_session_client_stop, data);
	g_signal_connect (object, "query-end-session", (GCallback) _dbus_ag_session_client_query_end_session, data);
	g_signal_connect (object, "end-session", (GCallback) _dbus_ag_session_client_end_session, data);
	g_signal_connect (object, "cancel-end-session", (GCallback) _dbus_ag_session_client_cancel_end_session, data);
	return result;
}

static void
_ag_session_client_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ag_session_client_stop, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ag_session_client_query_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ag_session_client_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ag_session_client_cancel_end_session, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

