/* IconRenderer.c generated by valac 0.56.18, the Vala compiler
 * generated from IconRenderer.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <string.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <granite.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_ICON_RENDERER (files_icon_renderer_get_type ())
#define FILES_ICON_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ICON_RENDERER, FilesIconRenderer))
#define FILES_ICON_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ICON_RENDERER, FilesIconRendererClass))
#define FILES_IS_ICON_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ICON_RENDERER))
#define FILES_IS_ICON_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ICON_RENDERER))
#define FILES_ICON_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ICON_RENDERER, FilesIconRendererClass))

typedef struct _FilesIconRenderer FilesIconRenderer;
typedef struct _FilesIconRendererClass FilesIconRendererClass;
typedef struct _FilesIconRendererPrivate FilesIconRendererPrivate;

#define FILES_TYPE_CLIPBOARD_MANAGER (files_clipboard_manager_get_type ())
#define FILES_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager))
#define FILES_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))
#define FILES_IS_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_IS_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_CLIPBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))

typedef struct _FilesClipboardManager FilesClipboardManager;
typedef struct _FilesClipboardManagerClass FilesClipboardManagerClass;
enum  {
	FILES_ICON_RENDERER_0_PROPERTY,
	FILES_ICON_RENDERER_LPAD_PROPERTY,
	FILES_ICON_RENDERER_DROP_FILE_PROPERTY,
	FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY,
	FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY,
	FILES_ICON_RENDERER_FILE_PROPERTY,
	FILES_ICON_RENDERER_NUM_PROPERTIES
};
static GParamSpec* files_icon_renderer_properties[FILES_ICON_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FilesIconRenderer {
	GtkCellRenderer parent_instance;
	FilesIconRendererPrivate * priv;
	GdkRectangle hover_helper_rect;
	GdkRectangle hover_rect;
};

struct _FilesIconRendererClass {
	GtkCellRendererClass parent_class;
};

struct _FilesIconRendererPrivate {
	gint _lpad;
	FilesFile* _drop_file;
	gboolean _show_emblems;
	gint h_overlap;
	gint v_overlap;
	gint helper_size;
	FilesZoomLevel _zoom_level;
	FilesFile* _file;
	FilesIconSize icon_size;
	gint icon_scale;
	FilesClipboardManager* clipboard;
};

static gint FilesIconRenderer_private_offset;
static gpointer files_icon_renderer_parent_class = NULL;

VALA_EXTERN GType files_icon_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesIconRenderer, g_object_unref)
VALA_EXTERN GType files_clipboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesClipboardManager, g_object_unref)
static void files_icon_renderer_real_render (GtkCellRenderer* base,
                                      cairo_t* cr,
                                      GtkWidget* widget,
                                      GdkRectangle* background_area,
                                      GdkRectangle* cell_area,
                                      GtkCellRendererState flags);
VALA_EXTERN FilesFile* files_icon_renderer_get_file (FilesIconRenderer* self);
static GdkPixbuf* files_icon_renderer_get_pixbuf (FilesIconRenderer* self);
VALA_EXTERN FilesFile* files_icon_renderer_get_drop_file (FilesIconRenderer* self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN gboolean files_clipboard_manager_has_cutted_file (FilesClipboardManager* self,
                                                  FilesFile* file);
VALA_EXTERN gboolean files_icon_renderer_get_show_emblems (FilesIconRenderer* self);
VALA_EXTERN FilesZoomLevel files_icon_renderer_get_zoom_level (FilesIconRenderer* self);
static void files_icon_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                   GtkWidget* widget,
                                                   gint* minimum_size,
                                                   gint* natural_size);
VALA_EXTERN gint files_icon_renderer_get_lpad (FilesIconRenderer* self);
static void files_icon_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                    GtkWidget* widget,
                                                    gint* minimum_size,
                                                    gint* natural_size);
static void files_icon_renderer_real_get_size (GtkCellRenderer* base,
                                        GtkWidget* widget,
                                        GdkRectangle* cell_area,
                                        gint* x_offset,
                                        gint* y_offset,
                                        gint* width,
                                        gint* height);
VALA_EXTERN FilesIconRenderer* files_icon_renderer_new (void);
VALA_EXTERN FilesIconRenderer* files_icon_renderer_construct (GType object_type);
VALA_EXTERN void files_icon_renderer_set_lpad (FilesIconRenderer* self,
                                   gint value);
VALA_EXTERN void files_icon_renderer_set_drop_file (FilesIconRenderer* self,
                                        FilesFile* value);
VALA_EXTERN void files_icon_renderer_set_show_emblems (FilesIconRenderer* self,
                                           gboolean value);
VALA_EXTERN void files_icon_renderer_set_zoom_level (FilesIconRenderer* self,
                                         FilesZoomLevel value);
VALA_EXTERN void files_icon_renderer_set_file (FilesIconRenderer* self,
                                   FilesFile* value);
static GObject * files_icon_renderer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
VALA_EXTERN FilesClipboardManager* files_clipboard_manager_get_for_display (GdkDisplay* display);
static void files_icon_renderer_finalize (GObject * obj);
static GType files_icon_renderer_get_type_once (void);
static void _vala_files_icon_renderer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_files_icon_renderer_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_icon_renderer_get_instance_private (FilesIconRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, FilesIconRenderer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
files_icon_renderer_real_render (GtkCellRenderer* base,
                                 cairo_t* cr,
                                 GtkWidget* widget,
                                 GdkRectangle* background_area,
                                 GdkRectangle* cell_area,
                                 GtkCellRendererState flags)
{
	FilesIconRenderer * self;
	gboolean _tmp0_ = FALSE;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	gboolean is_rtl = FALSE;
	GdkPixbuf* pb = NULL;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkRectangle pix_rect = {0};
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	GdkRectangle _tmp22_;
	GdkRectangle _tmp23_;
	GdkRectangle draw_rect = {0};
	GdkRectangle _tmp24_;
	GdkRectangle _tmp25_ = {0};
	gboolean _tmp26_;
	gchar* special_icon_name = NULL;
	gchar* suffix = NULL;
	gchar* _tmp27_;
	gboolean is_drop_file = FALSE;
	FilesFile* _tmp28_;
	FilesFile* _tmp29_;
	FilesFile* _tmp30_;
	FilesFile* _tmp31_;
	FilesFile* _tmp32_;
	const gchar* _tmp50_;
	FilesClipboardManager* _tmp59_;
	FilesFile* _tmp60_;
	FilesFile* _tmp61_;
	FilesFile* _tmp65_;
	FilesFile* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GtkStyleContext* style_context = NULL;
	GtkContainer* _tmp74_;
	GtkStyleContext* _tmp75_;
	GtkStyleContext* _tmp76_;
	GtkStyleContext* _tmp77_;
	gboolean prelit = FALSE;
	gboolean selected = FALSE;
	GtkStateFlags state = 0U;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_;
	gboolean _tmp80_;
	FilesFile* _tmp85_;
	FilesFile* _tmp86_;
	gint x_pad = 0;
	GdkRectangle _tmp89_;
	gint y_pad = 0;
	GdkRectangle _tmp90_;
	GtkStyleContext* _tmp91_;
	GdkRectangle _tmp92_;
	GdkRectangle _tmp93_;
	GtkStyleContext* _tmp94_;
	GdkPixbuf* _tmp95_;
	GdkRectangle _tmp96_;
	GdkRectangle _tmp97_;
	GtkStyleContext* _tmp98_;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp130_;
	self = (FilesIconRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp1_ = files_icon_renderer_get_file (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = files_icon_renderer_get_pixbuf (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (gtk_widget_get_scale_factor (widget) != self->priv->icon_scale) {
		FilesFile* _tmp5_;
		FilesFile* _tmp6_;
		self->priv->icon_scale = gtk_widget_get_scale_factor (widget);
		_tmp5_ = files_icon_renderer_get_file (self);
		_tmp6_ = _tmp5_;
		files_file_update_icon (_tmp6_, (gint) self->priv->icon_size, self->priv->icon_scale);
	}
	is_rtl = gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL;
	_tmp7_ = files_icon_renderer_get_pixbuf (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	pb = _tmp9_;
	memset (&pix_rect, 0, sizeof (GdkRectangle));
	_tmp10_ = files_icon_renderer_get_pixbuf (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
	_tmp13_ = _tmp12_;
	pix_rect.width = _tmp13_ / self->priv->icon_scale;
	_tmp14_ = files_icon_renderer_get_pixbuf (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
	_tmp17_ = _tmp16_;
	pix_rect.height = _tmp17_ / self->priv->icon_scale;
	_tmp18_ = *cell_area;
	_tmp19_ = *cell_area;
	_tmp20_ = pix_rect;
	pix_rect.x = _tmp18_.x + ((_tmp19_.width - _tmp20_.width) / 2);
	_tmp21_ = *cell_area;
	_tmp22_ = *cell_area;
	_tmp23_ = pix_rect;
	pix_rect.y = _tmp21_.y + ((_tmp22_.height - _tmp23_.height) / 2);
	memset (&draw_rect, 0, sizeof (GdkRectangle));
	_tmp24_ = pix_rect;
	_tmp26_ = gdk_rectangle_intersect (cell_area, &_tmp24_, &_tmp25_);
	draw_rect = _tmp25_;
	if (!_tmp26_) {
		_g_object_unref0 (pb);
		return;
	}
	special_icon_name = NULL;
	_tmp27_ = g_strdup ("");
	suffix = _tmp27_;
	_tmp28_ = files_icon_renderer_get_file (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->_drop_file;
	is_drop_file = _tmp29_ == _tmp30_;
	_tmp31_ = files_icon_renderer_get_file (self);
	_tmp32_ = _tmp31_;
	if (_tmp32_->is_directory) {
		gchar** names = NULL;
		FilesFile* _tmp33_;
		FilesFile* _tmp34_;
		GIcon* _tmp35_;
		gchar** _tmp36_;
		gchar** _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gint names_length1;
		gint _names_size_;
		gchar** _tmp39_;
		gint _tmp39__length1;
		gboolean _tmp44_ = FALSE;
		gboolean expanded = FALSE;
		_tmp33_ = files_icon_renderer_get_file (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_->icon;
		_tmp37_ = _tmp36_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_themed_icon_get_type (), GThemedIcon));
		_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup2 (_tmp37_, _vala_array_length (_tmp36_)) : _tmp37_;
		_tmp38__length1 = _vala_array_length (_tmp36_);
		names = _tmp38_;
		names_length1 = _tmp38__length1;
		_names_size_ = names_length1;
		_tmp39_ = names;
		_tmp39__length1 = names_length1;
		if (_tmp39__length1 > 0) {
			gchar** _tmp40_;
			gint _tmp40__length1;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp40_ = names;
			_tmp40__length1 = names_length1;
			_tmp41_ = _tmp40_[0];
			_tmp42_ = g_strdup (_tmp41_);
			_g_free0 (special_icon_name);
			special_icon_name = _tmp42_;
		} else {
			gchar* _tmp43_;
			_tmp43_ = g_strdup ("folder");
			_g_free0 (special_icon_name);
			special_icon_name = _tmp43_;
		}
		if ((flags & GTK_CELL_RENDERER_EXPANDED) > 0) {
			_tmp44_ = TRUE;
		} else {
			FilesFile* _tmp45_;
			FilesFile* _tmp46_;
			_tmp45_ = files_icon_renderer_get_file (self);
			_tmp46_ = _tmp45_;
			_tmp44_ = _tmp46_->is_expanded;
		}
		expanded = _tmp44_;
		if (expanded) {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("-open");
			_g_free0 (suffix);
			suffix = _tmp47_;
		} else {
			if (is_drop_file) {
				gchar* _tmp48_;
				_tmp48_ = g_strdup ("-drag-accept");
				_g_free0 (suffix);
				suffix = _tmp48_;
			}
		}
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	} else {
		if (is_drop_file) {
			gchar* _tmp49_;
			_tmp49_ = g_strdup ("system-run");
			_g_free0 (special_icon_name);
			special_icon_name = _tmp49_;
		}
	}
	if (is_drop_file) {
		flags = flags | GTK_CELL_RENDERER_PRELIT;
	}
	_tmp50_ = special_icon_name;
	if (_tmp50_ != NULL) {
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		FilesIconInfo* nicon = NULL;
		const gchar* _tmp54_;
		FilesIconInfo* _tmp55_;
		FilesIconInfo* _tmp56_;
		_tmp51_ = special_icon_name;
		_tmp52_ = suffix;
		_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
		_g_free0 (special_icon_name);
		special_icon_name = _tmp53_;
		_tmp54_ = special_icon_name;
		_tmp55_ = files_icon_info_lookup_from_name (_tmp54_, (gint) self->priv->icon_size, self->priv->icon_scale);
		nicon = _tmp55_;
		_tmp56_ = nicon;
		if (_tmp56_ != NULL) {
			FilesIconInfo* _tmp57_;
			GdkPixbuf* _tmp58_;
			_tmp57_ = nicon;
			_tmp58_ = files_icon_info_get_pixbuf_nodefault (_tmp57_);
			_g_object_unref0 (pb);
			pb = _tmp58_;
		} else {
			_g_free0 (special_icon_name);
			special_icon_name = NULL;
		}
		_g_object_unref0 (nicon);
	}
	_tmp59_ = self->priv->clipboard;
	_tmp60_ = files_icon_renderer_get_file (self);
	_tmp61_ = _tmp60_;
	if (files_clipboard_manager_has_cutted_file (_tmp59_, _tmp61_)) {
		GdkPixbuf* _tmp62_;
		GdkPixbuf* _tmp63_;
		GdkPixbuf* _tmp64_;
		_tmp62_ = files_icon_renderer_get_pixbuf (self);
		_tmp63_ = _tmp62_;
		_tmp64_ = pf_pixbuf_utils_lucent (_tmp63_, (guint) 50);
		_g_object_unref0 (pb);
		pb = _tmp64_;
	}
	_tmp65_ = files_icon_renderer_get_file (self);
	_tmp66_ = _tmp65_;
	_tmp67_ = files_file_get_is_hidden (_tmp66_);
	_tmp68_ = _tmp67_;
	if (_tmp68_) {
		GdkPixbuf* _tmp69_;
		GdkPixbuf* _tmp70_;
		GdkPixbuf* _tmp71_;
		GdkPixbuf* _tmp72_;
		GdkPixbuf* _tmp73_;
		_tmp69_ = files_icon_renderer_get_pixbuf (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = pf_pixbuf_utils_lucent (_tmp70_, (guint) 75);
		_g_object_unref0 (pb);
		pb = _tmp71_;
		_tmp72_ = pb;
		_tmp73_ = pf_pixbuf_utils_darken (_tmp72_, (guint8) 150, (guint8) 200);
		_g_object_unref0 (pb);
		pb = _tmp73_;
	}
	_tmp74_ = gtk_widget_get_parent (widget);
	_tmp75_ = gtk_widget_get_style_context ((GtkWidget*) _tmp74_);
	_tmp76_ = _g_object_ref0 (_tmp75_);
	style_context = _tmp76_;
	_tmp77_ = style_context;
	gtk_style_context_save (_tmp77_);
	prelit = (flags & GTK_CELL_RENDERER_PRELIT) > 0;
	selected = (flags & GTK_CELL_RENDERER_SELECTED) > 0;
	state = GTK_STATE_FLAG_NORMAL;
	_tmp79_ = gtk_widget_get_sensitive (widget);
	_tmp80_ = _tmp79_;
	if (!_tmp80_) {
		_tmp78_ = TRUE;
	} else {
		gboolean _tmp81_;
		gboolean _tmp82_;
		_tmp81_ = gtk_cell_renderer_get_sensitive ((GtkCellRenderer*) self);
		_tmp82_ = _tmp81_;
		_tmp78_ = !_tmp82_;
	}
	if (_tmp78_) {
		state |= GTK_STATE_FLAG_INSENSITIVE;
	} else {
		if (selected) {
			state = GTK_STATE_FLAG_SELECTED;
			state |= gtk_widget_get_state_flags (widget);
		}
		if (prelit) {
			GdkPixbuf* _tmp83_;
			GdkPixbuf* _tmp84_;
			_tmp83_ = pb;
			_tmp84_ = pf_pixbuf_utils_lighten (_tmp83_);
			_g_object_unref0 (pb);
			pb = _tmp84_;
		}
	}
	_tmp85_ = files_icon_renderer_get_file (self);
	_tmp86_ = _tmp85_;
	if (files_file_is_image (_tmp86_)) {
		GtkStyleContext* _tmp87_;
		GtkStyleContext* _tmp88_;
		_tmp87_ = style_context;
		gtk_style_context_add_class (_tmp87_, GRANITE_STYLE_CLASS_CHECKERBOARD);
		_tmp88_ = style_context;
		gtk_style_context_add_class (_tmp88_, GRANITE_STYLE_CLASS_CARD);
	}
	cairo_scale (cr, 1.0 / self->priv->icon_scale, 1.0 / self->priv->icon_scale);
	_tmp89_ = draw_rect;
	x_pad = (((gint) self->priv->icon_size) - _tmp89_.width) / 2;
	_tmp90_ = draw_rect;
	y_pad = (((gint) self->priv->icon_size) - _tmp90_.height) / 2;
	_tmp91_ = style_context;
	_tmp92_ = draw_rect;
	_tmp93_ = draw_rect;
	gtk_render_background (_tmp91_, cr, (gdouble) ((_tmp92_.x - x_pad) * self->priv->icon_scale), (gdouble) ((_tmp93_.y - y_pad) * self->priv->icon_scale), (gdouble) (((gint) self->priv->icon_size) * self->priv->icon_scale), (gdouble) (((gint) self->priv->icon_size) * self->priv->icon_scale));
	_tmp94_ = style_context;
	_tmp95_ = pb;
	_tmp96_ = draw_rect;
	_tmp97_ = draw_rect;
	gtk_render_icon (_tmp94_, cr, _tmp95_, (gdouble) (_tmp96_.x * self->priv->icon_scale), (gdouble) (_tmp97_.y * self->priv->icon_scale));
	_tmp98_ = style_context;
	gtk_style_context_restore (_tmp98_);
	if (selected) {
		_tmp100_ = TRUE;
	} else {
		_tmp100_ = prelit;
	}
	if (_tmp100_) {
		FilesFile* _tmp101_;
		FilesFile* _tmp102_;
		FilesFile* _tmp103_;
		_tmp101_ = files_icon_renderer_get_file (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = self->priv->_drop_file;
		_tmp99_ = _tmp102_ != _tmp103_;
	} else {
		_tmp99_ = FALSE;
	}
	if (_tmp99_) {
		gboolean _tmp104_ = FALSE;
		GdkRectangle helper_rect = {0};
		GdkRectangle _tmp108_ = {0};
		const gchar* _tmp109_;
		_g_free0 (special_icon_name);
		special_icon_name = NULL;
		if (selected) {
			_tmp104_ = prelit;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			gchar* _tmp105_;
			_tmp105_ = g_strdup ("selection-remove");
			_g_free0 (special_icon_name);
			special_icon_name = _tmp105_;
		} else {
			if (selected) {
				gchar* _tmp106_;
				_tmp106_ = g_strdup ("selection-checked");
				_g_free0 (special_icon_name);
				special_icon_name = _tmp106_;
			} else {
				if (prelit) {
					gchar* _tmp107_;
					_tmp107_ = g_strdup ("selection-add");
					_g_free0 (special_icon_name);
					special_icon_name = _tmp107_;
				}
			}
		}
		_tmp108_.x = 0;
		_tmp108_.y = 0;
		_tmp108_.width = 1;
		_tmp108_.height = 1;
		helper_rect = _tmp108_;
		_tmp109_ = special_icon_name;
		if (_tmp109_ != NULL) {
			FilesIconInfo* nicon = NULL;
			const gchar* _tmp110_;
			FilesIconInfo* _tmp111_;
			GdkPixbuf* pix = NULL;
			FilesIconInfo* _tmp112_;
			GdkPixbuf* _tmp115_;
			helper_rect.width = self->priv->helper_size;
			helper_rect.height = self->priv->helper_size;
			_tmp110_ = special_icon_name;
			_tmp111_ = files_icon_info_lookup_from_name (_tmp110_, self->priv->helper_size, self->priv->icon_scale);
			nicon = _tmp111_;
			pix = NULL;
			_tmp112_ = nicon;
			if (_tmp112_ != NULL) {
				FilesIconInfo* _tmp113_;
				GdkPixbuf* _tmp114_;
				_tmp113_ = nicon;
				_tmp114_ = files_icon_info_get_pixbuf_nodefault (_tmp113_);
				_g_object_unref0 (pix);
				pix = _tmp114_;
			}
			_tmp115_ = pix;
			if (_tmp115_ != NULL) {
				GdkRectangle _tmp122_;
				GdkRectangle _tmp123_;
				GtkStyleContext* _tmp124_;
				GdkPixbuf* _tmp125_;
				GdkRectangle _tmp126_;
				GdkRectangle _tmp127_;
				if (is_rtl) {
					GdkRectangle _tmp116_;
					GdkRectangle _tmp117_;
					GdkRectangle _tmp118_;
					GdkRectangle _tmp119_;
					_tmp116_ = *cell_area;
					_tmp117_ = *cell_area;
					_tmp118_ = draw_rect;
					_tmp119_ = draw_rect;
					helper_rect.x = MIN ((_tmp116_.x + _tmp117_.width) - self->priv->helper_size, ((_tmp118_.x + _tmp119_.width) + x_pad) - self->priv->h_overlap);
				} else {
					GdkRectangle _tmp120_;
					GdkRectangle _tmp121_;
					_tmp120_ = *cell_area;
					_tmp121_ = draw_rect;
					helper_rect.x = MAX (_tmp120_.x, ((_tmp121_.x - x_pad) - self->priv->helper_size) + self->priv->h_overlap);
				}
				_tmp122_ = *cell_area;
				_tmp123_ = draw_rect;
				helper_rect.y = MAX (_tmp122_.y, ((_tmp123_.y - y_pad) - self->priv->helper_size) + self->priv->v_overlap);
				_tmp124_ = style_context;
				_tmp125_ = pix;
				_tmp126_ = helper_rect;
				_tmp127_ = helper_rect;
				gtk_render_icon (_tmp124_, cr, _tmp125_, (gdouble) (_tmp126_.x * self->priv->icon_scale), (gdouble) (_tmp127_.y * self->priv->icon_scale));
			}
			_g_object_unref0 (pix);
			_g_object_unref0 (nicon);
		}
		if (prelit) {
			GdkRectangle _tmp128_;
			GdkRectangle _tmp129_;
			_tmp128_ = *cell_area;
			self->hover_rect = _tmp128_;
			_tmp129_ = helper_rect;
			self->hover_helper_rect = _tmp129_;
		}
	}
	_tmp130_ = self->priv->_show_emblems;
	if (_tmp130_) {
		gint emblem_size = 0;
		gint pos = 0;
		GdkRectangle emblem_area = {0};
		FilesFile* _tmp131_;
		FilesFile* _tmp132_;
		GList* _tmp133_;
		emblem_size = (gint) FILES_ICON_SIZE_EMBLEM;
		pos = 0;
		memset (&emblem_area, 0, sizeof (GdkRectangle));
		_tmp131_ = files_icon_renderer_get_file (self);
		_tmp132_ = _tmp131_;
		_tmp133_ = _tmp132_->emblems_list;
		{
			GList* emblem_collection = NULL;
			GList* emblem_it = NULL;
			emblem_collection = _tmp133_;
			for (emblem_it = emblem_collection; emblem_it != NULL; emblem_it = emblem_it->next) {
				gchar* _tmp134_;
				gchar* emblem = NULL;
				_tmp134_ = g_strdup ((const gchar*) emblem_it->data);
				emblem = _tmp134_;
				{
					FilesZoomLevel _tmp135_;
					FilesZoomLevel _tmp136_;
					GdkPixbuf* pix = NULL;
					FilesIconInfo* nicon = NULL;
					const gchar* _tmp137_;
					FilesIconInfo* _tmp138_;
					FilesIconInfo* _tmp139_;
					FilesIconInfo* _tmp140_;
					GdkPixbuf* _tmp141_;
					GdkPixbuf* _tmp142_;
					GdkRectangle _tmp149_;
					GdkRectangle _tmp150_;
					GdkRectangle _tmp151_;
					GdkRectangle _tmp152_;
					GdkRectangle _tmp153_;
					GdkRectangle _tmp154_;
					GtkStyleContext* _tmp155_;
					GdkPixbuf* _tmp156_;
					GdkRectangle _tmp157_;
					GdkRectangle _tmp158_;
					gint _tmp159_;
					_tmp135_ = files_icon_renderer_get_zoom_level (self);
					_tmp136_ = _tmp135_;
					if ((pos - 1) > ((gint) _tmp136_)) {
						_g_free0 (emblem);
						break;
					}
					pix = NULL;
					_tmp137_ = emblem;
					_tmp138_ = files_icon_info_lookup_from_name (_tmp137_, emblem_size, self->priv->icon_scale);
					nicon = _tmp138_;
					_tmp139_ = nicon;
					if (_tmp139_ == NULL) {
						_g_object_unref0 (nicon);
						_g_object_unref0 (pix);
						_g_free0 (emblem);
						continue;
					}
					_tmp140_ = nicon;
					_tmp141_ = files_icon_info_get_pixbuf_nodefault (_tmp140_);
					_g_object_unref0 (pix);
					pix = _tmp141_;
					_tmp142_ = pix;
					if (_tmp142_ == NULL) {
						_g_object_unref0 (nicon);
						_g_object_unref0 (pix);
						_g_free0 (emblem);
						continue;
					}
					if (!is_rtl) {
						GdkRectangle _tmp143_;
						GdkRectangle _tmp144_;
						GdkRectangle _tmp145_;
						GdkRectangle _tmp146_;
						_tmp143_ = *cell_area;
						_tmp144_ = *cell_area;
						_tmp145_ = draw_rect;
						_tmp146_ = draw_rect;
						emblem_area.x = MIN ((_tmp143_.x + _tmp144_.width) - self->priv->helper_size, ((_tmp145_.x + _tmp146_.width) + x_pad) - self->priv->h_overlap);
					} else {
						GdkRectangle _tmp147_;
						GdkRectangle _tmp148_;
						_tmp147_ = *cell_area;
						_tmp148_ = draw_rect;
						emblem_area.x = MAX (_tmp147_.x, ((_tmp148_.x - x_pad) - self->priv->helper_size) + self->priv->h_overlap);
					}
					_tmp149_ = *cell_area;
					_tmp150_ = *cell_area;
					_tmp151_ = draw_rect;
					_tmp152_ = draw_rect;
					emblem_area.y = MIN ((_tmp149_.y + _tmp150_.height) - emblem_size, ((_tmp151_.y + _tmp152_.height) + y_pad) - self->priv->v_overlap);
					_tmp153_ = *cell_area;
					_tmp154_ = emblem_area;
					emblem_area.y = MAX (_tmp153_.y, _tmp154_.y - (emblem_size * pos));
					_tmp155_ = style_context;
					_tmp156_ = pix;
					_tmp157_ = emblem_area;
					_tmp158_ = emblem_area;
					gtk_render_icon (_tmp155_, cr, _tmp156_, (gdouble) (_tmp157_.x * self->priv->icon_scale), (gdouble) (_tmp158_.y * self->priv->icon_scale));
					_tmp159_ = pos;
					pos = _tmp159_ + 1;
					_g_object_unref0 (nicon);
					_g_object_unref0 (pix);
					_g_free0 (emblem);
				}
			}
		}
	}
	_g_object_unref0 (style_context);
	_g_free0 (suffix);
	_g_free0 (special_icon_name);
	_g_object_unref0 (pb);
}

static void
files_icon_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                              GtkWidget* widget,
                                              gint* minimum_size,
                                              gint* natural_size)
{
	FilesIconRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint _tmp0_;
	self = (FilesIconRenderer*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->_lpad;
	_vala_minimum_size = ((((gint) self->priv->icon_size) + FILES_ICON_SIZE_EMBLEM) - self->priv->h_overlap) + _tmp0_;
	_vala_natural_size = _vala_minimum_size;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
files_icon_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                               GtkWidget* widget,
                                               gint* minimum_size,
                                               gint* natural_size)
{
	FilesIconRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	self = (FilesIconRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_natural_size = (((gint) self->priv->icon_size) + FILES_ICON_SIZE_EMBLEM) - self->priv->v_overlap;
	_vala_minimum_size = _vala_natural_size;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
files_icon_renderer_real_get_size (GtkCellRenderer* base,
                                   GtkWidget* widget,
                                   GdkRectangle* cell_area,
                                   gint* x_offset,
                                   gint* y_offset,
                                   gint* width,
                                   gint* height)
{
	FilesIconRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint mw = 0;
	gint nw = 0;
	gint mh = 0;
	gint nh = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = (FilesIconRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, widget, &_tmp0_, &_tmp1_);
	mw = _tmp0_;
	nw = _tmp1_;
	gtk_cell_renderer_get_preferred_height ((GtkCellRenderer*) self, widget, &_tmp2_, &_tmp3_);
	mh = _tmp2_;
	nh = _tmp3_;
	_vala_width = nw;
	_vala_height = nh;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

FilesIconRenderer*
files_icon_renderer_construct (GType object_type)
{
	FilesIconRenderer * self = NULL;
	self = (FilesIconRenderer*) g_object_new (object_type, NULL);
	return self;
}

FilesIconRenderer*
files_icon_renderer_new (void)
{
	return files_icon_renderer_construct (FILES_TYPE_ICON_RENDERER);
}

gint
files_icon_renderer_get_lpad (FilesIconRenderer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_lpad;
	return result;
}

void
files_icon_renderer_set_lpad (FilesIconRenderer* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_icon_renderer_get_lpad (self);
	if (old_value != value) {
		self->priv->_lpad = value;
		g_object_notify_by_pspec ((GObject *) self, files_icon_renderer_properties[FILES_ICON_RENDERER_LPAD_PROPERTY]);
	}
}

FilesFile*
files_icon_renderer_get_drop_file (FilesIconRenderer* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drop_file;
	result = _tmp0_;
	return result;
}

void
files_icon_renderer_set_drop_file (FilesIconRenderer* self,
                                   FilesFile* value)
{
	FilesFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_icon_renderer_get_drop_file (self);
	if (old_value != value) {
		FilesFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drop_file);
		self->priv->_drop_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_icon_renderer_properties[FILES_ICON_RENDERER_DROP_FILE_PROPERTY]);
	}
}

gboolean
files_icon_renderer_get_show_emblems (FilesIconRenderer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_emblems;
	return result;
}

void
files_icon_renderer_set_show_emblems (FilesIconRenderer* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_icon_renderer_get_show_emblems (self);
	if (old_value != value) {
		self->priv->_show_emblems = value;
		g_object_notify_by_pspec ((GObject *) self, files_icon_renderer_properties[FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY]);
	}
}

FilesZoomLevel
files_icon_renderer_get_zoom_level (FilesIconRenderer* self)
{
	FilesZoomLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_zoom_level;
	return result;
}

void
files_icon_renderer_set_zoom_level (FilesIconRenderer* self,
                                    FilesZoomLevel value)
{
	FilesIconSize _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	self->priv->_zoom_level = value;
	self->priv->icon_size = files_zoom_level_to_icon_size (value);
	if (self->priv->_zoom_level <= FILES_ZOOM_LEVEL_NORMAL) {
		_tmp0_ = FILES_ICON_SIZE_EMBLEM;
	} else {
		_tmp0_ = FILES_ICON_SIZE_LARGE_EMBLEM;
	}
	self->priv->helper_size = (gint) _tmp0_;
	self->priv->h_overlap = MAX (12, self->priv->helper_size / 2);
	self->priv->v_overlap = self->priv->h_overlap;
	g_object_notify_by_pspec ((GObject *) self, files_icon_renderer_properties[FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY]);
}

FilesFile*
files_icon_renderer_get_file (FilesIconRenderer* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

void
files_icon_renderer_set_file (FilesIconRenderer* self,
                              FilesFile* value)
{
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
	_tmp1_ = self->priv->_file;
	if (_tmp1_ != NULL) {
		FilesFile* _tmp2_;
		_tmp2_ = self->priv->_file;
		files_file_update_icon (_tmp2_, (gint) self->priv->icon_size, self->priv->icon_scale);
	}
	g_object_notify_by_pspec ((GObject *) self, files_icon_renderer_properties[FILES_ICON_RENDERER_FILE_PROPERTY]);
}

static GdkPixbuf*
files_icon_renderer_get_pixbuf (FilesIconRenderer* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_ = NULL;
	FilesFile* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_file;
	if (_tmp1_ != NULL) {
		FilesFile* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = self->priv->_file;
		_tmp3_ = _tmp2_->pix;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static GObject *
files_icon_renderer_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesIconRenderer * self;
	GdkDisplay* _tmp0_;
	FilesClipboardManager* _tmp1_;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_ = {0};
	parent_class = G_OBJECT_CLASS (files_icon_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ICON_RENDERER, FilesIconRenderer);
	files_icon_renderer_set_lpad (self, 6);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = files_clipboard_manager_get_for_display (_tmp0_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp1_;
	_tmp2_.x = 0;
	_tmp2_.y = 0;
	_tmp2_.width = (gint) FILES_ICON_SIZE_NORMAL;
	_tmp2_.height = (gint) FILES_ICON_SIZE_NORMAL;
	self->hover_rect = _tmp2_;
	_tmp3_.x = 0;
	_tmp3_.y = 0;
	_tmp3_.width = (gint) FILES_ICON_SIZE_EMBLEM;
	_tmp3_.height = (gint) FILES_ICON_SIZE_EMBLEM;
	self->hover_helper_rect = _tmp3_;
	return obj;
}

static void
files_icon_renderer_class_init (FilesIconRendererClass * klass,
                                gpointer klass_data)
{
	files_icon_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesIconRenderer_private_offset);
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) files_icon_renderer_real_render;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) files_icon_renderer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) files_icon_renderer_real_get_preferred_height;
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) files_icon_renderer_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_icon_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_icon_renderer_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_icon_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_icon_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_RENDERER_LPAD_PROPERTY, files_icon_renderer_properties[FILES_ICON_RENDERER_LPAD_PROPERTY] = g_param_spec_int ("lpad", "lpad", "lpad", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_RENDERER_DROP_FILE_PROPERTY, files_icon_renderer_properties[FILES_ICON_RENDERER_DROP_FILE_PROPERTY] = g_param_spec_object ("drop-file", "drop-file", "drop-file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY, files_icon_renderer_properties[FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY] = g_param_spec_boolean ("show-emblems", "show-emblems", "show-emblems", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY, files_icon_renderer_properties[FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY] = g_param_spec_enum ("zoom-level", "zoom-level", "zoom-level", FILES_TYPE_ZOOM_LEVEL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_RENDERER_FILE_PROPERTY, files_icon_renderer_properties[FILES_ICON_RENDERER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_icon_renderer_instance_init (FilesIconRenderer * self,
                                   gpointer klass)
{
	self->priv = files_icon_renderer_get_instance_private (self);
	self->priv->_lpad = 0;
	self->priv->_show_emblems = FALSE;
	self->priv->_zoom_level = FILES_ZOOM_LEVEL_NORMAL;
	self->priv->icon_scale = 1;
}

static void
files_icon_renderer_finalize (GObject * obj)
{
	FilesIconRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ICON_RENDERER, FilesIconRenderer);
	_g_object_unref0 (self->priv->_drop_file);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->clipboard);
	G_OBJECT_CLASS (files_icon_renderer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_icon_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesIconRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_icon_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesIconRenderer), 0, (GInstanceInitFunc) files_icon_renderer_instance_init, NULL };
	GType files_icon_renderer_type_id;
	files_icon_renderer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "FilesIconRenderer", &g_define_type_info, 0);
	FilesIconRenderer_private_offset = g_type_add_instance_private (files_icon_renderer_type_id, sizeof (FilesIconRendererPrivate));
	return files_icon_renderer_type_id;
}

GType
files_icon_renderer_get_type (void)
{
	static volatile gsize files_icon_renderer_type_id__once = 0;
	if (g_once_init_enter (&files_icon_renderer_type_id__once)) {
		GType files_icon_renderer_type_id;
		files_icon_renderer_type_id = files_icon_renderer_get_type_once ();
		g_once_init_leave (&files_icon_renderer_type_id__once, files_icon_renderer_type_id);
	}
	return files_icon_renderer_type_id__once;
}

static void
_vala_files_icon_renderer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FilesIconRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ICON_RENDERER, FilesIconRenderer);
	switch (property_id) {
		case FILES_ICON_RENDERER_LPAD_PROPERTY:
		g_value_set_int (value, files_icon_renderer_get_lpad (self));
		break;
		case FILES_ICON_RENDERER_DROP_FILE_PROPERTY:
		g_value_set_object (value, files_icon_renderer_get_drop_file (self));
		break;
		case FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY:
		g_value_set_boolean (value, files_icon_renderer_get_show_emblems (self));
		break;
		case FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY:
		g_value_set_enum (value, files_icon_renderer_get_zoom_level (self));
		break;
		case FILES_ICON_RENDERER_FILE_PROPERTY:
		g_value_set_object (value, files_icon_renderer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_icon_renderer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FilesIconRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ICON_RENDERER, FilesIconRenderer);
	switch (property_id) {
		case FILES_ICON_RENDERER_LPAD_PROPERTY:
		files_icon_renderer_set_lpad (self, g_value_get_int (value));
		break;
		case FILES_ICON_RENDERER_DROP_FILE_PROPERTY:
		files_icon_renderer_set_drop_file (self, g_value_get_object (value));
		break;
		case FILES_ICON_RENDERER_SHOW_EMBLEMS_PROPERTY:
		files_icon_renderer_set_show_emblems (self, g_value_get_boolean (value));
		break;
		case FILES_ICON_RENDERER_ZOOM_LEVEL_PROPERTY:
		files_icon_renderer_set_zoom_level (self, g_value_get_enum (value));
		break;
		case FILES_ICON_RENDERER_FILE_PROPERTY:
		files_icon_renderer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

