/* SourceView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2013 Mario Guerriero <mefrio.g@gmail.com>
*               2017–2020 elementary, Inc. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "codecore.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <pango/pango.h>
#include <granite.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#define SCRATCH_WIDGETS_SOURCE_VIEW_THROTTLE_MS ((guint) 400)
#define SCRATCH_WIDGETS_SOURCE_VIEW_SCROLL_THRESHOLD 1.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_WIDGETS_SOURCE_VIEW_0_PROPERTY,
	SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY,
	SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY,
	SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY,
	SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY,
	SCRATCH_WIDGETS_SOURCE_VIEW_NUM_PROPERTIES
};
static GParamSpec* scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
typedef struct _Block49Data Block49Data;
typedef struct _Block50Data Block50Data;
typedef struct _Block51Data Block51Data;
enum  {
	SCRATCH_WIDGETS_SOURCE_VIEW_STYLE_CHANGED_SIGNAL,
	SCRATCH_WIDGETS_SOURCE_VIEW_SELECTION_CHANGED_SIGNAL,
	SCRATCH_WIDGETS_SOURCE_VIEW_NUM_SIGNALS
};
static guint scratch_widgets_source_view_signals[SCRATCH_WIDGETS_SOURCE_VIEW_NUM_SIGNALS] = {0};

struct _ScratchWidgetsSourceViewPrivate {
	GFile* _location;
	ScratchFolderManagerProjectFolderItem* _project;
	gchar* font;
	guint selection_changed_timer;
	guint size_allocate_timer;
	GtkTextIter last_select_start_iter;
	GtkTextIter last_select_end_iter;
	gchar* selected_text;
	ScratchWidgetsGitGutterRenderer* git_diff_gutter_renderer;
	ScratchWidgetsNavMarkGutterRenderer* navmark_gutter_renderer;
	gdouble total_delta;
	guint refresh_timeout_id;
};

struct _Block49Data {
	int _ref_count_;
	ScratchWidgetsSourceView* self;
	GtkTextIter end_iter;
};

struct _Block50Data {
	int _ref_count_;
	ScratchWidgetsSourceView* self;
	GtkTextIter iter;
};

struct _Block51Data {
	int _ref_count_;
	ScratchWidgetsSourceView* self;
	GtkAllocation allocation;
};

static gint ScratchWidgetsSourceView_private_offset;
static gpointer scratch_widgets_source_view_parent_class = NULL;

static gboolean scratch_widgets_source_view_get_current_line (ScratchWidgetsSourceView* self,
                                                       GtkTextIter* start,
                                                       GtkTextIter* end);
static void scratch_widgets_source_view_restore_settings (ScratchWidgetsSourceView* self);
static void scratch_widgets_source_view_update_draw_spaces (ScratchWidgetsSourceView* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gint scratch_widgets_source_view_get_selected_line_count (ScratchWidgetsSourceView* self);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static GtkTextIter* _vala_GtkTextIter_copy (GtkTextIter* self);
static gint ___lambda104_ (ScratchWidgetsSourceView* self,
                    const gchar* a,
                    const gchar* b);
static gint ____lambda104__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static gboolean __lambda37_ (Block49Data* _data49_);
static gboolean ___lambda37__gsource_func (gpointer self);
static void scratch_widgets_source_view_goto_nearest_mark (ScratchWidgetsSourceView* self,
                                                    gboolean before);
static void scratch_widgets_source_view_on_context_menu (ScratchWidgetsSourceView* self,
                                                  GtkMenu* menu);
static void _scratch_widgets_source_view_sort_selected_lines_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                              gpointer self);
static void ___lambda105_ (ScratchWidgetsSourceView* self);
static void ____lambda105__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static gint scratch_widgets_source_view_calculate_bottom_margin (gint height_in_px);
static void scratch_widgets_source_view_on_mark_set (ScratchWidgetsSourceView* self,
                                              GtkTextIter* loc,
                                              GtkTextMark* mar);
static gboolean scratch_widgets_source_view_selection_changed_event (ScratchWidgetsSourceView* self);
static gboolean _scratch_widgets_source_view_selection_changed_event_gsource_func (gpointer self);
static void scratch_widgets_source_view_on_mark_deleted (ScratchWidgetsSourceView* self,
                                                  GtkTextMark* mark);
static gboolean __lambda35_ (ScratchWidgetsSourceView* self);
static gboolean ___lambda35__gsource_func (gpointer self);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gboolean _scratch_widgets_source_view_cursor_position___lambda39_ (Block50Data* _data50_);
static gboolean __scratch_widgets_source_view_cursor_position___lambda39__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static GObject * scratch_widgets_source_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _scratch_widgets_source_view_on_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                                        GtkTextIter* location,
                                                                        GtkTextMark* mark,
                                                                        gpointer self);
static void _scratch_widgets_source_view_on_mark_deleted_gtk_text_buffer_mark_deleted (GtkTextBuffer* _sender,
                                                                                GtkTextMark* mark,
                                                                                gpointer self);
static void _scratch_widgets_source_view_restore_settings_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _scratch_widgets_source_view_restore_settings_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static gboolean _scratch_widgets_source_view___lambda106_ (ScratchWidgetsSourceView* self,
                                                    GdkEventScroll* key_event);
static gboolean __scratch_widgets_source_view___lambda106__gtk_widget_scroll_event (GtkWidget* _sender,
                                                                             GdkEventScroll* event,
                                                                             gpointer self);
static void _scratch_widgets_source_view___lambda107_ (ScratchWidgetsSourceView* self);
static void __scratch_widgets_source_view___lambda107__gtk_text_view_cut_clipboard (GtkTextView* _sender,
                                                                             gpointer self);
static void _scratch_widgets_source_view___lambda108_ (ScratchWidgetsSourceView* self);
static void __scratch_widgets_source_view___lambda108__gtk_text_view_copy_clipboard (GtkTextView* _sender,
                                                                              gpointer self);
static void _scratch_widgets_source_view_on_context_menu_gtk_text_view_populate_popup (GtkTextView* _sender,
                                                                                GtkMenu* popup,
                                                                                gpointer self);
static void _scratch_widgets_source_view___lambda109_ (ScratchWidgetsSourceView* self,
                                                GtkAllocation* allocation);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static gboolean ___lambda110_ (Block51Data* _data51_);
static gboolean ____lambda110__gsource_func (gpointer self);
static void __scratch_widgets_source_view___lambda109__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                          GtkAllocation* allocation,
                                                                          gpointer self);
static void scratch_widgets_source_view_finalize (GObject * obj);
static GType scratch_widgets_source_view_get_type_once (void);
static void _vala_scratch_widgets_source_view_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_scratch_widgets_source_view_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_widgets_source_view_get_instance_private (ScratchWidgetsSourceView* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchWidgetsSourceView_private_offset);
}

ScratchWidgetsSourceView*
scratch_widgets_source_view_construct (GType object_type)
{
	ScratchWidgetsSourceView * self = NULL;
	self = (ScratchWidgetsSourceView*) g_object_new (object_type, "show-line-numbers", TRUE, "smart-backspace", TRUE, "smart-home-end", GTK_SOURCE_SMART_HOME_END_BEFORE, "wrap-mode", GTK_WRAP_WORD, NULL);
	return self;
}

ScratchWidgetsSourceView*
scratch_widgets_source_view_new (void)
{
	return scratch_widgets_source_view_construct (SCRATCH_WIDGETS_TYPE_SOURCE_VIEW);
}

static gboolean
scratch_widgets_source_view_get_current_line (ScratchWidgetsSourceView* self,
                                              GtkTextIter* start,
                                              GtkTextIter* end)
{
	GtkTextIter _vala_start = {0};
	GtkTextIter _vala_end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "cursor-position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp6_, _tmp5_);
	_vala_start = _tmp6_;
	gtk_text_iter_backward_chars (&_vala_start, gtk_text_iter_get_line_offset (&_vala_start));
	_tmp7_ = _vala_start;
	_vala_end = _tmp7_;
	gtk_text_iter_forward_line (&_vala_end);
	_tmp8_ = _vala_end;
	result = !gtk_text_iter_equal (&_vala_start, &_tmp8_);
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
	return result;
}

void
scratch_widgets_source_view_change_syntax_highlight_from_file (ScratchWidgetsSourceView* self,
                                                               GFile* file)
{
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		gchar* mime_type = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkSourceLanguageManager* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		GtkSourceLanguage* _tmp9_;
		_tmp0_ = g_file_query_info (file, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_file_info_get_attribute_as_string (info, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_content_type_get_mime_type (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		mime_type = _tmp4_;
		_tmp5_ = self->manager;
		_tmp6_ = g_file_get_path (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = mime_type;
		_tmp9_ = gtk_source_language_manager_guess_language (_tmp5_, _tmp7_, _tmp8_);
		scratch_widgets_source_view_set_language (self, _tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (mime_type);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("SourceView.vala:224: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = g_file_get_basename (file);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "CMakeLists.txt") == 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		GtkSourceLanguageManager* _tmp15_;
		GtkSourceLanguage* _tmp16_;
		_tmp15_ = self->manager;
		_tmp16_ = gtk_source_language_manager_get_language (_tmp15_, "cmake");
		scratch_widgets_source_view_set_language (self, _tmp16_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
scratch_widgets_source_view_restore_settings (ScratchWidgetsSourceView* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GtkSourceBuffer* source_buffer = NULL;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	GtkSourceBuffer* _tmp7_;
	GSettings* _tmp8_;
	GtkSourceSpaceDrawer* _tmp9_;
	GtkSourceSpaceDrawer* _tmp10_;
	GSettings* _tmp11_;
	GtkSourceSpaceDrawer* _tmp20_;
	GtkSourceSpaceDrawer* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GSettings* _tmp24_;
	gchar* font_css = NULL;
	const gchar* _tmp31_;
	PangoFontDescription* _tmp32_;
	PangoFontDescription* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GSettings* _tmp41_;
	ScratchWidgetsGitGutterRenderer* _tmp63_;
	GtkSourceBuffer* _tmp64_;
	GtkSourceStyleScheme* _tmp65_;
	GtkSourceStyleScheme* _tmp66_;
	GtkSourceBuffer* _tmp67_;
	GtkSourceStyleScheme* _tmp68_;
	GtkSourceStyleScheme* _tmp69_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_settings;
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, g_settings_get_boolean (_tmp0_, "auto-indent"));
	_tmp1_ = scratch_settings;
	gtk_source_view_set_show_right_margin ((GtkSourceView*) self, g_settings_get_boolean (_tmp1_, "show-right-margin"));
	_tmp2_ = scratch_settings;
	gtk_source_view_set_right_margin_position ((GtkSourceView*) self, (guint) g_settings_get_int (_tmp2_, "right-margin-position"));
	_tmp3_ = scratch_settings;
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, g_settings_get_boolean (_tmp3_, "spaces-instead-of-tabs"));
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_source_buffer_get_type (), GtkSourceBuffer));
	source_buffer = _tmp6_;
	_tmp7_ = source_buffer;
	_tmp8_ = scratch_settings;
	gtk_source_buffer_set_highlight_matching_brackets (_tmp7_, g_settings_get_boolean (_tmp8_, "highlight-matching-brackets"));
	_tmp9_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
	_tmp10_ = _tmp9_;
	gtk_source_space_drawer_set_enable_matrix (_tmp10_, FALSE);
	_tmp11_ = scratch_settings;
	switch ((ScratchScratchDrawSpacesState) g_settings_get_enum (_tmp11_, "draw-spaces")) {
		case SCRATCH_SCRATCH_DRAW_SPACES_STATE_ALWAYS:
		{
			GtkSourceSpaceDrawer* _tmp12_;
			GtkSourceSpaceDrawer* _tmp13_;
			_tmp12_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
			_tmp13_ = _tmp12_;
			gtk_source_space_drawer_set_types_for_locations (_tmp13_, GTK_SOURCE_SPACE_LOCATION_ALL, GTK_SOURCE_SPACE_TYPE_SPACE | GTK_SOURCE_SPACE_TYPE_TAB);
			break;
		}
		case SCRATCH_SCRATCH_DRAW_SPACES_STATE_FOR_SELECTION:
		case SCRATCH_SCRATCH_DRAW_SPACES_STATE_CURRENT:
		{
			GtkSourceSpaceDrawer* _tmp14_;
			GtkSourceSpaceDrawer* _tmp15_;
			GtkSourceSpaceDrawer* _tmp16_;
			GtkSourceSpaceDrawer* _tmp17_;
			_tmp14_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
			_tmp15_ = _tmp14_;
			gtk_source_space_drawer_set_types_for_locations (_tmp15_, GTK_SOURCE_SPACE_LOCATION_ALL, GTK_SOURCE_SPACE_TYPE_NONE);
			_tmp16_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
			_tmp17_ = _tmp16_;
			gtk_source_space_drawer_set_types_for_locations (_tmp17_, GTK_SOURCE_SPACE_LOCATION_TRAILING, GTK_SOURCE_SPACE_TYPE_SPACE | GTK_SOURCE_SPACE_TYPE_TAB);
			break;
		}
		default:
		{
			GtkSourceSpaceDrawer* _tmp18_;
			GtkSourceSpaceDrawer* _tmp19_;
			_tmp18_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
			_tmp19_ = _tmp18_;
			gtk_source_space_drawer_set_types_for_locations (_tmp19_, GTK_SOURCE_SPACE_LOCATION_ALL, GTK_SOURCE_SPACE_TYPE_NONE);
			break;
		}
	}
	_tmp20_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
	_tmp21_ = _tmp20_;
	gtk_source_space_drawer_set_enable_matrix (_tmp21_, TRUE);
	scratch_widgets_source_view_update_draw_spaces (self);
	_tmp22_ = scratch_settings;
	gtk_source_view_set_tab_width ((GtkSourceView*) self, (guint) g_settings_get_int (_tmp22_, "indent-width"));
	_tmp23_ = scratch_settings;
	if (g_settings_get_boolean (_tmp23_, "line-wrap")) {
		gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	} else {
		gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_NONE);
	}
	_tmp24_ = scratch_settings;
	if (g_settings_get_boolean (_tmp24_, "use-system-font")) {
		GApplication* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp25_ = g_application_get_default ();
		_tmp26_ = scratch_application_get_default_font (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (self->priv->font);
		self->priv->font = _tmp28_;
	} else {
		GSettings* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = scratch_settings;
		_tmp30_ = g_settings_get_string (_tmp29_, "font");
		_g_free0 (self->priv->font);
		self->priv->font = _tmp30_;
	}
	_tmp31_ = self->priv->font;
	_tmp32_ = pango_font_description_from_string (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = scratch_utils_pango_font_description_to_css (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strjoin (" ", ".view {", _tmp35_, "}", NULL);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	__vala_PangoFontDescription_free0 (_tmp33_);
	font_css = _tmp37_;
	{
		GtkCssProvider* _tmp38_;
		_tmp38_ = self->font_css_provider;
		gtk_css_provider_load_from_data (_tmp38_, font_css, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_critical ("SourceView.vala:296: %s", _tmp40_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (font_css);
		_g_object_unref0 (source_buffer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp41_ = scratch_settings;
	if (g_settings_get_boolean (_tmp41_, "follow-system-style")) {
		gboolean system_prefers_dark = FALSE;
		GraniteSettings* _tmp42_;
		GraniteSettingsColorScheme _tmp43_;
		GraniteSettingsColorScheme _tmp44_;
		_tmp42_ = granite_settings_get_default ();
		_tmp43_ = granite_settings_get_prefers_color_scheme (_tmp42_);
		_tmp44_ = _tmp43_;
		system_prefers_dark = _tmp44_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK;
		if (system_prefers_dark) {
			GtkSourceBuffer* _tmp45_;
			GtkSourceStyleSchemeManager* _tmp46_;
			GtkSourceStyleScheme* _tmp47_;
			_tmp45_ = source_buffer;
			_tmp46_ = self->style_scheme_manager;
			_tmp47_ = gtk_source_style_scheme_manager_get_scheme (_tmp46_, "elementary-dark");
			gtk_source_buffer_set_style_scheme (_tmp45_, _tmp47_);
		} else {
			GtkSourceBuffer* _tmp48_;
			GtkSourceStyleSchemeManager* _tmp49_;
			GtkSourceStyleScheme* _tmp50_;
			_tmp48_ = source_buffer;
			_tmp49_ = self->style_scheme_manager;
			_tmp50_ = gtk_source_style_scheme_manager_get_scheme (_tmp49_, "elementary-light");
			gtk_source_buffer_set_style_scheme (_tmp48_, _tmp50_);
		}
	} else {
		GtkSourceStyleScheme* scheme = NULL;
		GtkSourceStyleSchemeManager* _tmp51_;
		GSettings* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		GtkSourceStyleScheme* _tmp55_;
		GtkSourceStyleScheme* _tmp56_;
		GtkSourceStyleScheme* _tmp57_;
		GtkSourceStyleScheme* _tmp58_ = NULL;
		GtkSourceStyleScheme* _tmp59_;
		GtkSourceBuffer* _tmp62_;
		_tmp51_ = self->style_scheme_manager;
		_tmp52_ = scratch_settings;
		_tmp53_ = g_settings_get_string (_tmp52_, "style-scheme");
		_tmp54_ = _tmp53_;
		_tmp55_ = gtk_source_style_scheme_manager_get_scheme (_tmp51_, _tmp54_);
		_tmp56_ = _g_object_ref0 (_tmp55_);
		_tmp57_ = _tmp56_;
		_g_free0 (_tmp54_);
		scheme = _tmp57_;
		_tmp59_ = scheme;
		_tmp58_ = _tmp59_;
		if (_tmp58_ == NULL) {
			GtkSourceStyleSchemeManager* _tmp60_;
			GtkSourceStyleScheme* _tmp61_;
			_tmp60_ = self->style_scheme_manager;
			_tmp61_ = gtk_source_style_scheme_manager_get_scheme (_tmp60_, "classic");
			_tmp58_ = _tmp61_;
		}
		_tmp62_ = source_buffer;
		gtk_source_buffer_set_style_scheme (_tmp62_, _tmp58_);
		_g_object_unref0 (scheme);
	}
	_tmp63_ = self->priv->git_diff_gutter_renderer;
	_tmp64_ = source_buffer;
	_tmp65_ = gtk_source_buffer_get_style_scheme (_tmp64_);
	_tmp66_ = _tmp65_;
	scratch_widgets_git_gutter_renderer_set_style_scheme (_tmp63_, _tmp66_);
	_tmp67_ = source_buffer;
	_tmp68_ = gtk_source_buffer_get_style_scheme (_tmp67_);
	_tmp69_ = _tmp68_;
	g_signal_emit (self, scratch_widgets_source_view_signals[SCRATCH_WIDGETS_SOURCE_VIEW_STYLE_CHANGED_SIGNAL], 0, _tmp69_);
	_g_free0 (font_css);
	_g_object_unref0 (source_buffer);
}

void
scratch_widgets_source_view_go_to_line (ScratchWidgetsSourceView* self,
                                        gint line,
                                        gint offset)
{
	GtkTextIter it = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkTextIter _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_iter_at_line (_tmp1_, &_tmp2_, line - 1);
	it = _tmp2_;
	if (offset == -1) {
		_tmp3_ = 0;
	} else {
		_tmp3_ = offset;
	}
	gtk_text_iter_forward_chars (&it, _tmp3_);
	_tmp4_ = it;
	gtk_text_view_scroll_to_iter ((GtkTextView*) self, &_tmp4_, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = it;
	gtk_text_buffer_place_cursor (_tmp6_, &_tmp7_);
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
scratch_widgets_source_view_get_selected_text (ScratchWidgetsSourceView* self,
                                               gboolean replace_new_line)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* selected = NULL;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = start;
	_tmp7_ = end;
	_tmp8_ = gtk_text_buffer_get_text (_tmp5_, &_tmp6_, &_tmp7_, TRUE);
	selected = _tmp8_;
	if (replace_new_line) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = selected;
		_tmp10_ = string_chomp (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_replace (_tmp11_, "\n", " ");
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		result = _tmp13_;
		_g_free0 (selected);
		return result;
	}
	result = selected;
	return result;
}

static gint
scratch_widgets_source_view_get_selected_line_count (ScratchWidgetsSourceView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = end;
	if (!gtk_text_iter_equal (&start, &_tmp4_)) {
		gchar* selected = NULL;
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextIter _tmp7_;
		GtkTextIter _tmp8_;
		gchar* _tmp9_;
		gchar** lines = NULL;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint lines_length1;
		gint _lines_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = start;
		_tmp8_ = end;
		_tmp9_ = gtk_text_buffer_get_text (_tmp6_, &_tmp7_, &_tmp8_, TRUE);
		selected = _tmp9_;
		_tmp10_ = selected;
		_tmp12_ = _tmp11_ = g_regex_split_simple ("\\R", _tmp10_, 0, 0);
		lines = _tmp12_;
		lines_length1 = _vala_array_length (_tmp11_);
		_lines_size_ = lines_length1;
		_tmp13_ = lines;
		_tmp13__length1 = lines_length1;
		result = _tmp13__length1;
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (selected);
		return result;
	}
	result = 0;
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static GtkTextIter*
_vala_GtkTextIter_copy (GtkTextIter* self)
{
	return g_boxed_copy (gtk_text_iter_get_type (), self);
}

static gpointer
__vala_GtkTextIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTextIter_copy (self) : NULL;
}

void
scratch_widgets_source_view_duplicate_selection (ScratchWidgetsSourceView* self)
{
	GtkTextIter* start = NULL;
	GtkTextIter* end = NULL;
	gint selection_start_offset = 0;
	gint selection_end_offset = 0;
	gint start_line = 0;
	gint end_line = 0;
	gchar* selection = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkTextBuffer* _tmp60_;
	GtkTextBuffer* _tmp61_;
	const gchar* _tmp62_;
	gboolean _tmp63_ = FALSE;
	g_return_if_fail (self != NULL);
	start = NULL;
	end = NULL;
	selection_start_offset = 0;
	selection_end_offset = 0;
	_tmp0_ = scratch_widgets_source_view_get_selected_text (self, TRUE);
	selection = _tmp0_;
	_tmp1_ = selection;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkTextBuffer* _tmp2_;
		GtkTextBuffer* _tmp3_;
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_;
		GtkTextIter* _tmp7_;
		GtkTextIter _tmp8_;
		GtkTextIter* _tmp9_;
		GtkTextIter* _tmp10_;
		GtkTextIter* _tmp11_;
		GtkTextIter* _tmp32_;
		GtkTextIter* _tmp33_;
		_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp3_ = _tmp2_;
		gtk_text_buffer_get_selection_bounds (_tmp3_, &_tmp4_, &_tmp5_);
		__vala_GtkTextIter_free0 (start);
		_tmp6_ = _tmp4_;
		_tmp7_ = __vala_GtkTextIter_copy0 (&_tmp6_);
		start = _tmp7_;
		__vala_GtkTextIter_free0 (end);
		_tmp8_ = _tmp5_;
		_tmp9_ = __vala_GtkTextIter_copy0 (&_tmp8_);
		end = _tmp9_;
		_tmp10_ = start;
		start_line = gtk_text_iter_get_line (_tmp10_);
		_tmp11_ = end;
		end_line = gtk_text_iter_get_line (_tmp11_);
		if (start_line != end_line) {
			GtkTextBuffer* _tmp12_;
			GtkTextBuffer* _tmp13_;
			GtkTextIter _tmp14_ = {0};
			GtkTextIter _tmp15_;
			GtkTextIter* _tmp16_;
			GtkTextBuffer* _tmp17_;
			GtkTextBuffer* _tmp18_;
			GtkTextIter _tmp19_ = {0};
			GtkTextIter _tmp20_;
			GtkTextIter* _tmp21_;
			GtkTextIter* _tmp22_;
			GtkTextBuffer* _tmp23_;
			GtkTextBuffer* _tmp24_;
			GtkTextIter* _tmp25_;
			GtkTextIter* _tmp26_;
			GtkTextIter _tmp27_;
			GtkTextIter _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp13_ = _tmp12_;
			gtk_text_buffer_get_iter_at_line (_tmp13_, &_tmp14_, start_line);
			__vala_GtkTextIter_free0 (start);
			_tmp15_ = _tmp14_;
			_tmp16_ = __vala_GtkTextIter_copy0 (&_tmp15_);
			start = _tmp16_;
			_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp18_ = _tmp17_;
			gtk_text_buffer_get_iter_at_line (_tmp18_, &_tmp19_, end_line);
			__vala_GtkTextIter_free0 (end);
			_tmp20_ = _tmp19_;
			_tmp21_ = __vala_GtkTextIter_copy0 (&_tmp20_);
			end = _tmp21_;
			_tmp22_ = end;
			gtk_text_iter_forward_to_line_end (_tmp22_);
			_tmp23_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = start;
			_tmp26_ = end;
			_tmp27_ = *_tmp25_;
			_tmp28_ = *_tmp26_;
			_tmp29_ = gtk_text_buffer_get_text (_tmp24_, &_tmp27_, &_tmp28_, TRUE);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat ("\n", _tmp30_, NULL);
			_g_free0 (selection);
			selection = _tmp31_;
			_g_free0 (_tmp30_);
		}
		_tmp32_ = start;
		selection_start_offset = gtk_text_iter_get_offset (_tmp32_);
		_tmp33_ = end;
		selection_end_offset = gtk_text_iter_get_offset (_tmp33_);
	} else {
		GtkTextBuffer* _tmp34_;
		GtkTextBuffer* _tmp35_;
		GtkTextBuffer* _tmp36_;
		GtkTextBuffer* _tmp37_;
		GtkTextMark* _tmp38_;
		GtkTextIter _tmp39_ = {0};
		GtkTextIter _tmp40_;
		GtkTextIter* _tmp41_;
		GtkTextIter* _tmp42_;
		GtkTextIter* _tmp43_;
		GtkTextIter* _tmp44_;
		GtkTextIter* _tmp45_;
		GtkTextIter* _tmp46_;
		GtkTextIter* _tmp47_;
		GtkTextIter* _tmp48_;
		GtkTextIter* _tmp49_;
		GtkTextBuffer* _tmp51_;
		GtkTextBuffer* _tmp52_;
		GtkTextIter* _tmp53_;
		GtkTextIter* _tmp54_;
		GtkTextIter _tmp55_;
		GtkTextIter _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp34_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = gtk_text_buffer_get_insert (_tmp37_);
		gtk_text_buffer_get_iter_at_mark (_tmp35_, &_tmp39_, _tmp38_);
		__vala_GtkTextIter_free0 (start);
		_tmp40_ = _tmp39_;
		_tmp41_ = __vala_GtkTextIter_copy0 (&_tmp40_);
		start = _tmp41_;
		_tmp42_ = start;
		_tmp43_ = start;
		gtk_text_iter_backward_chars (_tmp42_, gtk_text_iter_get_line_offset (_tmp43_));
		_tmp44_ = start;
		_tmp45_ = gtk_text_iter_copy (_tmp44_);
		__vala_GtkTextIter_free0 (end);
		end = _tmp45_;
		_tmp46_ = end;
		_tmp47_ = end;
		gtk_text_iter_forward_chars (_tmp46_, gtk_text_iter_get_chars_in_line (_tmp47_));
		_tmp48_ = end;
		_tmp49_ = start;
		if (gtk_text_iter_get_line (_tmp48_) != gtk_text_iter_get_line (_tmp49_)) {
			GtkTextIter* _tmp50_;
			_tmp50_ = end;
			gtk_text_iter_backward_char (_tmp50_);
		}
		_tmp51_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = start;
		_tmp54_ = end;
		_tmp55_ = *_tmp53_;
		_tmp56_ = *_tmp54_;
		_tmp57_ = gtk_text_buffer_get_text (_tmp52_, &_tmp55_, &_tmp56_, TRUE);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strconcat ("\n", _tmp58_, NULL);
		_g_free0 (selection);
		selection = _tmp59_;
		_g_free0 (_tmp58_);
	}
	_tmp60_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = selection;
	gtk_text_buffer_insert (_tmp61_, end, _tmp62_, -1);
	if (selection_start_offset > 0) {
		_tmp63_ = TRUE;
	} else {
		_tmp63_ = selection_end_offset > 0;
	}
	if (_tmp63_) {
		GtkTextBuffer* _tmp64_;
		GtkTextBuffer* _tmp65_;
		GtkTextIter _tmp66_ = {0};
		GtkTextIter _tmp67_;
		GtkTextIter* _tmp68_;
		GtkTextBuffer* _tmp69_;
		GtkTextBuffer* _tmp70_;
		GtkTextIter _tmp71_ = {0};
		GtkTextIter _tmp72_;
		GtkTextIter* _tmp73_;
		GtkTextBuffer* _tmp74_;
		GtkTextBuffer* _tmp75_;
		GtkTextIter* _tmp76_;
		GtkTextIter* _tmp77_;
		GtkTextIter _tmp78_;
		GtkTextIter _tmp79_;
		_tmp64_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp65_ = _tmp64_;
		gtk_text_buffer_get_iter_at_offset (_tmp65_, &_tmp66_, selection_start_offset);
		__vala_GtkTextIter_free0 (start);
		_tmp67_ = _tmp66_;
		_tmp68_ = __vala_GtkTextIter_copy0 (&_tmp67_);
		start = _tmp68_;
		_tmp69_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp70_ = _tmp69_;
		gtk_text_buffer_get_iter_at_offset (_tmp70_, &_tmp71_, selection_end_offset);
		__vala_GtkTextIter_free0 (end);
		_tmp72_ = _tmp71_;
		_tmp73_ = __vala_GtkTextIter_copy0 (&_tmp72_);
		end = _tmp73_;
		_tmp74_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp75_ = _tmp74_;
		_tmp76_ = start;
		_tmp77_ = end;
		_tmp78_ = *_tmp76_;
		_tmp79_ = *_tmp77_;
		gtk_text_buffer_select_range (_tmp75_, &_tmp78_, &_tmp79_);
	}
	_g_free0 (selection);
	__vala_GtkTextIter_free0 (end);
	__vala_GtkTextIter_free0 (start);
}

static gint
___lambda104_ (ScratchWidgetsSourceView* self,
               const gchar* a,
               const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_utf8_collate (a, b);
	return result;
}

static gint
____lambda104__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ___lambda104_ ((ScratchWidgetsSourceView*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
scratch_widgets_source_view_sort_selected_lines (ScratchWidgetsSourceView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = end;
	if (!gtk_text_iter_equal (&start, &_tmp4_)) {
		gboolean end_included = FALSE;
		gchar* selected = NULL;
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextIter _tmp7_;
		GtkTextIter _tmp8_;
		gchar* _tmp9_;
		gchar** lines = NULL;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint lines_length1;
		gint _lines_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		GeeArrayList* line_array = NULL;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp34_;
		gchar* sorted = NULL;
		GeeArrayList* _tmp50_;
		gint _tmp51_ = 0;
		gpointer* _tmp52_;
		gchar** _tmp53_;
		gint _tmp53__length1;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GtkTextBuffer* _tmp56_;
		GtkTextBuffer* _tmp57_;
		GtkTextBuffer* _tmp58_;
		GtkTextBuffer* _tmp59_;
		GtkTextBuffer* _tmp60_;
		GtkTextBuffer* _tmp61_;
		const gchar* _tmp62_;
		GtkTextBuffer* _tmp63_;
		GtkTextBuffer* _tmp64_;
		if (!gtk_text_iter_starts_line (&start)) {
			gtk_text_iter_backward_chars (&start, gtk_text_iter_get_line_offset (&start));
		}
		if (!gtk_text_iter_starts_line (&end)) {
			gtk_text_iter_forward_line (&end);
		}
		end_included = gtk_text_iter_is_end (&end);
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = start;
		_tmp8_ = end;
		_tmp9_ = gtk_text_buffer_get_text (_tmp6_, &_tmp7_, &_tmp8_, TRUE);
		selected = _tmp9_;
		_tmp10_ = selected;
		_tmp12_ = _tmp11_ = g_regex_split_simple ("(\\R)", _tmp10_, 0, 0);
		lines = _tmp12_;
		lines_length1 = _vala_array_length (_tmp11_);
		_lines_size_ = lines_length1;
		_tmp13_ = lines;
		_tmp13__length1 = lines_length1;
		if (_tmp13__length1 <= 3) {
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (selected);
			return;
		}
		_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		line_array = _tmp14_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gchar** _tmp16_;
					gint _tmp16__length1;
					gchar** _tmp17_;
					gint _tmp17__length1;
					if (!_tmp15_) {
						i += 2;
					}
					_tmp15_ = FALSE;
					_tmp16_ = lines;
					_tmp16__length1 = lines_length1;
					if (!(i < _tmp16__length1)) {
						break;
					}
					_tmp17_ = lines;
					_tmp17__length1 = lines_length1;
					if ((i + 1) <= (_tmp17__length1 - 1)) {
						GeeArrayList* _tmp18_;
						gchar** _tmp19_;
						gint _tmp19__length1;
						const gchar* _tmp20_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp18_ = line_array;
						_tmp19_ = lines;
						_tmp19__length1 = lines_length1;
						_tmp20_ = _tmp19_[i];
						_tmp21_ = lines;
						_tmp21__length1 = lines_length1;
						_tmp22_ = _tmp21_[i + 1];
						_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
						_tmp24_ = _tmp23_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp24_);
						_g_free0 (_tmp24_);
					} else {
						gboolean _tmp25_ = FALSE;
						gchar** _tmp26_;
						gint _tmp26__length1;
						_tmp26_ = lines;
						_tmp26__length1 = lines_length1;
						if (i == (_tmp26__length1 - 1)) {
							_tmp25_ = end_included;
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							GeeArrayList* _tmp27_;
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp27_ = line_array;
							_tmp28_ = lines;
							_tmp28__length1 = lines_length1;
							_tmp29_ = _tmp28_[i];
							_tmp30_ = lines;
							_tmp30__length1 = lines_length1;
							_tmp31_ = _tmp30_[i - 1];
							_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
							_tmp33_ = _tmp32_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp33_);
							_g_free0 (_tmp33_);
						} else {
							break;
						}
					}
				}
			}
		}
		_tmp34_ = line_array;
		gee_list_sort ((GeeList*) _tmp34_, ____lambda104__gcompare_data_func, g_object_ref (self), g_object_unref);
		if (end_included) {
			gchar* orig_end = NULL;
			GeeArrayList* _tmp35_;
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			const gchar* _tmp40_;
			_tmp35_ = line_array;
			_tmp36_ = line_array;
			_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp38_ - 1);
			orig_end = (gchar*) _tmp39_;
			_tmp40_ = orig_end;
			if (g_regex_match_simple ("\\R", _tmp40_, 0, 0)) {
				GeeArrayList* _tmp41_;
				GeeArrayList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				const gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				_tmp41_ = line_array;
				_tmp42_ = line_array;
				_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = orig_end;
				_tmp47_ = _tmp46_ = g_regex_split_simple ("\\R", _tmp45_, 0, 0);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _vala_array_length (_tmp46_);
				_tmp49_ = _tmp48_[0];
				gee_abstract_list_set ((GeeAbstractList*) _tmp41_, _tmp44_ - 1, _tmp49_);
				_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (orig_end);
		}
		_tmp50_ = line_array;
		_tmp52_ = gee_collection_to_array ((GeeCollection*) _tmp50_, &_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp53__length1 = _tmp51_;
		_tmp54_ = _vala_g_strjoinv ("", _tmp53_, (gint) _tmp51_);
		_tmp55_ = _tmp54_;
		_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
		sorted = _tmp55_;
		_tmp56_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp57_ = _tmp56_;
		gtk_text_buffer_begin_user_action (_tmp57_);
		_tmp58_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp59_ = _tmp58_;
		gtk_text_buffer_delete (_tmp59_, &start, &end);
		_tmp60_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp61_ = _tmp60_;
		_tmp62_ = sorted;
		gtk_text_buffer_insert_at_cursor (_tmp61_, _tmp62_, -1);
		_tmp63_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp64_ = _tmp63_;
		gtk_text_buffer_end_user_action (_tmp64_);
		_g_free0 (sorted);
		_g_object_unref0 (line_array);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (selected);
	}
}

void
scratch_widgets_source_view_clear_selected_lines (ScratchWidgetsSourceView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gboolean has_selection = FALSE;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_begin_user_action (_tmp1_);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_buffer_get_has_selection (_tmp3_);
	_tmp5_ = _tmp4_;
	has_selection = _tmp5_;
	if (has_selection) {
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
		_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp7_ = _tmp6_;
		gtk_text_buffer_delete_selection (_tmp7_, TRUE, TRUE);
	}
	scratch_widgets_source_view_get_current_line (self, &_tmp8_, &_tmp9_);
	start = _tmp8_;
	end = _tmp9_;
	gtk_text_iter_backward_char (&end);
	if (!has_selection) {
		GtkTextIter _tmp11_;
		_tmp11_ = start;
		_tmp10_ = gtk_text_iter_equal (&end, &_tmp11_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gtk_text_iter_forward_char (&end);
	}
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	gtk_text_buffer_delete (_tmp13_, &start, &end);
	_tmp14_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp15_ = _tmp14_;
	gtk_text_buffer_end_user_action (_tmp15_);
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		ScratchWidgetsSourceView* self;
		self = _data49_->self;
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gboolean
__lambda37_ (Block49Data* _data49_)
{
	ScratchWidgetsSourceView* self;
	GtkTextIter _tmp0_;
	gboolean result;
	self = _data49_->self;
	_tmp0_ = _data49_->end_iter;
	gtk_text_view_scroll_to_iter ((GtkTextView*) self, &_tmp0_, 0.25, FALSE, (gdouble) 0, (gdouble) 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda37_ (self);
	return result;
}

void
scratch_widgets_source_view_select_range (ScratchWidgetsSourceView* self,
                                          SelectionRange* range)
{
	Block49Data* _data49_;
	SelectionRange _tmp0_;
	GtkTextIter start_iter = {0};
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	SelectionRange _tmp4_;
	SelectionRange _tmp5_;
	GtkTextIter* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter _tmp9_;
	SelectionRange _tmp10_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextIter _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = *range;
	if (_tmp0_.start_line < 0) {
		block49_data_unref (_data49_);
		_data49_ = NULL;
		return;
	}
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_start_iter (_tmp2_, &_tmp3_);
	start_iter = _tmp3_;
	_tmp4_ = *range;
	gtk_text_iter_set_line (&start_iter, _tmp4_.start_line - 1);
	_tmp5_ = *range;
	if (_tmp5_.start_column > 0) {
		SelectionRange _tmp6_;
		_tmp6_ = *range;
		gtk_text_iter_set_visible_line_offset (&start_iter, _tmp6_.start_column - 1);
	}
	_tmp7_ = gtk_text_iter_copy (&start_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = *_tmp8_;
	__vala_GtkTextIter_free0 (_tmp8_);
	_data49_->end_iter = _tmp9_;
	_tmp10_ = *range;
	if (_tmp10_.end_line > 0) {
		SelectionRange _tmp11_;
		SelectionRange _tmp12_;
		_tmp11_ = *range;
		gtk_text_iter_set_line (&_data49_->end_iter, _tmp11_.end_line - 1);
		_tmp12_ = *range;
		if (_tmp12_.end_column > 0) {
			SelectionRange _tmp13_;
			_tmp13_ = *range;
			gtk_text_iter_set_visible_line_offset (&_data49_->end_iter, _tmp13_.end_column - 1);
		}
	}
	_tmp14_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = start_iter;
	_tmp17_ = _data49_->end_iter;
	gtk_text_buffer_select_range (_tmp15_, &_tmp16_, &_tmp17_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda37__gsource_func, block49_data_ref (_data49_), block49_data_unref);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

void
scratch_widgets_source_view_set_text (ScratchWidgetsSourceView* self,
                                      const gchar* text,
                                      gboolean opening)
{
	GtkSourceBuffer* source_buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp4_;
	GtkTextIter* start = NULL;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_;
	GtkTextIter* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextIter* _tmp13_;
	GtkTextIter _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_source_buffer_get_type (), GtkSourceBuffer));
	source_buffer = _tmp2_;
	if (opening) {
		GtkSourceBuffer* _tmp3_;
		_tmp3_ = source_buffer;
		gtk_source_buffer_begin_not_undoable_action (_tmp3_);
	}
	_tmp4_ = source_buffer;
	g_object_set ((GtkTextBuffer*) _tmp4_, "text", text, NULL);
	if (opening) {
		GtkSourceBuffer* _tmp5_;
		_tmp5_ = source_buffer;
		gtk_source_buffer_end_not_undoable_action (_tmp5_);
	}
	start = NULL;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	gtk_text_buffer_get_start_iter (_tmp7_, &_tmp8_);
	__vala_GtkTextIter_free0 (start);
	_tmp9_ = _tmp8_;
	_tmp10_ = __vala_GtkTextIter_copy0 (&_tmp9_);
	start = _tmp10_;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = start;
	_tmp14_ = *_tmp13_;
	gtk_text_buffer_place_cursor (_tmp12_, &_tmp14_);
	__vala_GtkTextIter_free0 (start);
	_g_object_unref0 (source_buffer);
}

gchar*
scratch_widgets_source_view_get_text (ScratchWidgetsSourceView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "text", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
scratch_widgets_source_view_add_mark_at_cursor (ScratchWidgetsSourceView* self)
{
	GtkTextIter* cur_iter = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	GtkTextIter* _tmp6_;
	gint cur_line = 0;
	GtkTextIter* _tmp7_;
	ScratchWidgetsNavMarkGutterRenderer* _tmp8_;
	g_return_if_fail (self != NULL);
	cur_iter = NULL;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_widgets_source_view_get_cursor_position (self);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp4_, _tmp3_);
	__vala_GtkTextIter_free0 (cur_iter);
	_tmp5_ = _tmp4_;
	_tmp6_ = __vala_GtkTextIter_copy0 (&_tmp5_);
	cur_iter = _tmp6_;
	_tmp7_ = cur_iter;
	cur_line = gtk_text_iter_get_line (_tmp7_);
	_tmp8_ = self->priv->navmark_gutter_renderer;
	scratch_widgets_nav_mark_gutter_renderer_add_mark_at_line (_tmp8_, cur_line);
	__vala_GtkTextIter_free0 (cur_iter);
}

void
scratch_widgets_source_view_goto_previous_mark (ScratchWidgetsSourceView* self)
{
	g_return_if_fail (self != NULL);
	scratch_widgets_source_view_goto_nearest_mark (self, TRUE);
}

void
scratch_widgets_source_view_goto_next_mark (ScratchWidgetsSourceView* self)
{
	g_return_if_fail (self != NULL);
	scratch_widgets_source_view_goto_nearest_mark (self, FALSE);
}

static void
scratch_widgets_source_view_goto_nearest_mark (ScratchWidgetsSourceView* self,
                                               gboolean before)
{
	GtkTextIter* start = NULL;
	GtkTextIter* end = NULL;
	gint line = 0;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextIter _tmp5_;
	GtkTextIter* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp2_ = scratch_widgets_source_view_get_current_line (self, &_tmp0_, &_tmp1_);
	__vala_GtkTextIter_free0 (start);
	_tmp3_ = _tmp0_;
	_tmp4_ = __vala_GtkTextIter_copy0 (&_tmp3_);
	start = _tmp4_;
	__vala_GtkTextIter_free0 (end);
	_tmp5_ = _tmp1_;
	_tmp6_ = __vala_GtkTextIter_copy0 (&_tmp5_);
	end = _tmp6_;
	if (_tmp2_) {
		ScratchWidgetsNavMarkGutterRenderer* _tmp7_;
		GtkTextIter* _tmp8_;
		gint _tmp9_ = 0;
		GtkTextIter* iter = NULL;
		GtkTextBuffer* _tmp10_;
		GtkTextBuffer* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_;
		GtkTextIter* _tmp14_;
		GtkTextIter* _tmp15_;
		_tmp7_ = self->priv->navmark_gutter_renderer;
		_tmp8_ = start;
		scratch_widgets_nav_mark_gutter_renderer_get_nearest_marked_line (_tmp7_, gtk_text_iter_get_line (_tmp8_), before, &_tmp9_);
		line = _tmp9_;
		_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp11_ = _tmp10_;
		gtk_text_buffer_get_iter_at_line (_tmp11_, &_tmp12_, line);
		__vala_GtkTextIter_free0 (iter);
		_tmp13_ = _tmp12_;
		_tmp14_ = __vala_GtkTextIter_copy0 (&_tmp13_);
		iter = _tmp14_;
		_tmp15_ = iter;
		if (_tmp15_ != NULL) {
			GtkTextIter* _tmp16_;
			_tmp16_ = iter;
			scratch_widgets_source_view_set_cursor_position (self, gtk_text_iter_get_offset (_tmp16_));
		}
		__vala_GtkTextIter_free0 (iter);
	}
	__vala_GtkTextIter_free0 (end);
	__vala_GtkTextIter_free0 (start);
}

static void
scratch_widgets_source_view_update_draw_spaces (ScratchWidgetsSourceView* self)
{
	GtkTextIter doc_start = {0};
	GtkTextIter doc_end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gboolean selection = FALSE;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextIter _tmp12_ = {0};
	GtkTextIter _tmp13_ = {0};
	gboolean _tmp14_;
	ScratchScratchDrawSpacesState draw_spaces_state = 0;
	GSettings* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	doc_start = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_end_iter (_tmp4_, &_tmp5_);
	doc_end = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = doc_start;
	_tmp9_ = doc_end;
	gtk_text_buffer_remove_tag_by_name (_tmp7_, "draw_spaces", &_tmp8_, &_tmp9_);
	_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp11_ = _tmp10_;
	_tmp14_ = gtk_text_buffer_get_selection_bounds (_tmp11_, &_tmp12_, &_tmp13_);
	start = _tmp12_;
	end = _tmp13_;
	selection = _tmp14_;
	_tmp15_ = scratch_settings;
	draw_spaces_state = (ScratchScratchDrawSpacesState) g_settings_get_enum (_tmp15_, "draw-spaces");
	if (selection) {
		_tmp16_ = (((SCRATCH_SCRATCH_DRAW_SPACES_STATE_FOR_SELECTION | SCRATCH_SCRATCH_DRAW_SPACES_STATE_CURRENT) | SCRATCH_SCRATCH_DRAW_SPACES_STATE_ALWAYS) & draw_spaces_state) == draw_spaces_state;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GtkTextBuffer* _tmp17_;
		GtkTextBuffer* _tmp18_;
		GtkTextIter _tmp19_;
		GtkTextIter _tmp20_;
		_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = start;
		_tmp20_ = end;
		gtk_text_buffer_apply_tag_by_name (_tmp18_, "draw_spaces", &_tmp19_, &_tmp20_);
		return;
	}
	if (draw_spaces_state == SCRATCH_SCRATCH_DRAW_SPACES_STATE_CURRENT) {
		GtkTextIter _tmp22_ = {0};
		GtkTextIter _tmp23_ = {0};
		gboolean _tmp24_;
		_tmp24_ = scratch_widgets_source_view_get_current_line (self, &_tmp22_, &_tmp23_);
		start = _tmp22_;
		end = _tmp23_;
		_tmp21_ = _tmp24_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GtkTextBuffer* _tmp25_;
		GtkTextBuffer* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextIter _tmp28_;
		_tmp25_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = start;
		_tmp28_ = end;
		gtk_text_buffer_apply_tag_by_name (_tmp26_, "draw_spaces", &_tmp27_, &_tmp28_);
	}
}

static void
_scratch_widgets_source_view_sort_selected_lines_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                         gpointer self)
{
	scratch_widgets_source_view_sort_selected_lines ((ScratchWidgetsSourceView*) self);
}

static void
___lambda105_ (ScratchWidgetsSourceView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	scratch_comment_toggler_toggle_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_source_buffer_get_type (), GtkSourceBuffer));
}

static void
____lambda105__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	___lambda105_ ((ScratchWidgetsSourceView*) self);
}

static void
scratch_widgets_source_view_on_context_menu (ScratchWidgetsSourceView* self,
                                             GtkMenu* menu)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkMenuItem* sort_item = NULL;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GraniteAccelLabel* _tmp6_;
	GraniteAccelLabel* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* add_edit_item = NULL;
	gchar* _tmp10_;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GraniteAccelLabel* _tmp16_;
	GraniteAccelLabel* _tmp17_;
	GtkMenuItem* _tmp18_;
	GtkMenuItem* previous_edit_item = NULL;
	ScratchWidgetsNavMarkGutterRenderer* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gchar* _tmp22_;
	GtkMenuItem* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_;
	GtkMenuItem* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GraniteAccelLabel* _tmp28_;
	GraniteAccelLabel* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* next_edit_item = NULL;
	ScratchWidgetsNavMarkGutterRenderer* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gchar* _tmp34_;
	GtkMenuItem* _tmp35_ = NULL;
	GtkMenuItem* _tmp36_;
	GtkMenuItem* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GraniteAccelLabel* _tmp40_;
	GraniteAccelLabel* _tmp41_;
	GtkMenuItem* _tmp42_;
	ScratchWidgetsNavMarkGutterRenderer* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	GtkTextBuffer* _tmp50_;
	GtkTextBuffer* _tmp51_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_mark (_tmp1_, "insert");
	gtk_text_view_scroll_mark_onscreen ((GtkTextView*) self, _tmp2_);
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp3_);
	sort_item = _tmp3_;
	_tmp4_ = sort_item;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, scratch_widgets_source_view_get_selected_line_count (self) > 1);
	_tmp5_ = sort_item;
	_tmp6_ = granite_accel_label_new_from_action_name (_ ("Sort Selected Lines"), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_SORT_LINES);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = sort_item;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) _scratch_widgets_source_view_sort_selected_lines_gtk_menu_item_activate, self, 0);
	_tmp9_ = sort_item;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) _tmp9_);
	_tmp10_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_ADD_MARK);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp11_, _tmp10_);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	add_edit_item = _tmp11_;
	_tmp12_ = add_edit_item;
	_tmp13_ = add_edit_item;
	_tmp14_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = granite_accel_label_new_from_action_name (_ ("Mark Current Line"), _tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = add_edit_item;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->navmark_gutter_renderer;
	_tmp20_ = scratch_widgets_nav_mark_gutter_renderer_get_has_marks (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_PREVIOUS_MARK);
	_tmp23_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, _tmp21_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp23_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	previous_edit_item = _tmp23_;
	_tmp24_ = previous_edit_item;
	_tmp25_ = previous_edit_item;
	_tmp26_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = granite_accel_label_new_from_action_name (_ ("Goto Previous Edit Mark"), _tmp27_);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = previous_edit_item;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->navmark_gutter_renderer;
	_tmp32_ = scratch_widgets_nav_mark_gutter_renderer_get_has_marks (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_NEXT_MARK);
	_tmp35_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, _tmp33_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp35_, _tmp34_);
	_g_free0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	next_edit_item = _tmp35_;
	_tmp36_ = next_edit_item;
	_tmp37_ = next_edit_item;
	_tmp38_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = granite_accel_label_new_from_action_name (_ ("Goto Next Edit Mark"), _tmp39_);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = next_edit_item;
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->navmark_gutter_renderer;
	_tmp44_ = scratch_widgets_nav_mark_gutter_renderer_get_has_marks (_tmp43_);
	_tmp45_ = _tmp44_;
	if (!_tmp45_) {
		GtkMenuItem* _tmp46_;
		GtkMenuItem* _tmp47_;
		GtkMenuItem* _tmp48_;
		GtkMenuItem* _tmp49_;
		_tmp46_ = previous_edit_item;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp46_, "");
		_tmp47_ = previous_edit_item;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp47_, FALSE);
		_tmp48_ = next_edit_item;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp48_, "");
		_tmp49_ = next_edit_item;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp49_, FALSE);
	}
	_tmp50_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp51_ = _tmp50_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, gtk_source_buffer_get_type ())) {
		gboolean can_comment = FALSE;
		GtkTextBuffer* _tmp52_;
		GtkTextBuffer* _tmp53_;
		GtkSourceLanguage* _tmp54_;
		GtkMenuItem* comment_item = NULL;
		GtkMenuItem* _tmp55_;
		GtkMenuItem* _tmp56_;
		GtkMenuItem* _tmp57_;
		GraniteAccelLabel* _tmp58_;
		GraniteAccelLabel* _tmp59_;
		GtkMenuItem* _tmp60_;
		GtkMenuItem* _tmp61_;
		_tmp52_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = gtk_source_buffer_get_language (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_source_buffer_get_type (), GtkSourceBuffer));
		can_comment = scratch_comment_toggler_language_has_comments (_tmp54_);
		_tmp55_ = (GtkMenuItem*) gtk_menu_item_new ();
		g_object_ref_sink (_tmp55_);
		comment_item = _tmp55_;
		_tmp56_ = comment_item;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, can_comment);
		_tmp57_ = comment_item;
		_tmp58_ = granite_accel_label_new_from_action_name (_ ("Toggle Comment"), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_COMMENT);
		g_object_ref_sink (_tmp58_);
		_tmp59_ = _tmp58_;
		gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp59_);
		_g_object_unref0 (_tmp59_);
		_tmp60_ = comment_item;
		g_signal_connect_object (_tmp60_, "activate", (GCallback) ____lambda105__gtk_menu_item_activate, self, 0);
		_tmp61_ = comment_item;
		gtk_container_add ((GtkContainer*) menu, (GtkWidget*) _tmp61_);
		_g_object_unref0 (comment_item);
	}
	gtk_widget_show_all ((GtkWidget*) menu);
	_g_object_unref0 (next_edit_item);
	_g_object_unref0 (previous_edit_item);
	_g_object_unref0 (add_edit_item);
	_g_object_unref0 (sort_item);
}

static gint
scratch_widgets_source_view_calculate_bottom_margin (gint height_in_px)
{
	static const gint LINES_TO_KEEP = 3;
	static const gdouble PT_TO_PX = 1.6667;
	gdouble px_per_line = 0.0;
	ScratchMainWindow* last_window = NULL;
	GApplication* _tmp0_;
	ScratchMainWindow* _tmp1_;
	ScratchMainWindow* _tmp2_;
	gint result;
	px_per_line = 10 * PT_TO_PX;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = scratch_application_get_last_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	last_window = _tmp1_;
	_tmp2_ = last_window;
	if (_tmp2_ != NULL) {
		ScratchMainWindow* _tmp3_;
		_tmp3_ = last_window;
		px_per_line = scratch_main_window_get_current_font_size (_tmp3_) * PT_TO_PX;
	}
	result = (gint) (height_in_px - (LINES_TO_KEEP * px_per_line));
	_g_object_unref0 (last_window);
	return result;
}

static gboolean
_scratch_widgets_source_view_selection_changed_event_gsource_func (gpointer self)
{
	gboolean result;
	result = scratch_widgets_source_view_selection_changed_event ((ScratchWidgetsSourceView*) self);
	return result;
}

static void
scratch_widgets_source_view_on_mark_set (ScratchWidgetsSourceView* self,
                                         GtkTextIter* loc,
                                         GtkTextMark* mar)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loc != NULL);
	g_return_if_fail (mar != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp5_ = self->priv->last_select_start_iter;
	if (gtk_text_iter_equal (&start, &_tmp5_)) {
		GtkTextIter _tmp6_;
		_tmp6_ = self->priv->last_select_end_iter;
		_tmp4_ = gtk_text_iter_equal (&end, &_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		return;
	}
	_tmp7_ = start;
	gtk_text_iter_assign (&self->priv->last_select_start_iter, &_tmp7_);
	_tmp8_ = end;
	gtk_text_iter_assign (&self->priv->last_select_end_iter, &_tmp8_);
	scratch_widgets_source_view_update_draw_spaces (self);
	if (self->priv->selection_changed_timer != ((guint) 0)) {
		g_source_remove (self->priv->selection_changed_timer);
		self->priv->selection_changed_timer = (guint) 0;
	}
	self->priv->selection_changed_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, SCRATCH_WIDGETS_SOURCE_VIEW_THROTTLE_MS, _scratch_widgets_source_view_selection_changed_event_gsource_func, g_object_ref (self), g_object_unref);
}

static void
scratch_widgets_source_view_on_mark_deleted (ScratchWidgetsSourceView* self,
                                             GtkTextMark* mark)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mark != NULL);
	_tmp0_ = gtk_text_mark_get_name (mark);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = name;
		_tmp2_ = g_str_has_prefix (_tmp4_, "NavMark");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ScratchWidgetsNavMarkGutterRenderer* _tmp5_;
		g_warning ("SourceView.vala:688: NavMark deleted");
		_tmp5_ = self->priv->navmark_gutter_renderer;
		scratch_widgets_nav_mark_gutter_renderer_remove_mark (_tmp5_, mark);
	}
	_g_free0 (name);
}

static gboolean
scratch_widgets_source_view_selection_changed_event (ScratchWidgetsSourceView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* prev_selected_text = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = self->priv->selected_text;
	_tmp5_ = g_strdup (_tmp4_);
	prev_selected_text = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text (_tmp7_, &_tmp8_, &_tmp9_, TRUE);
	_g_free0 (self->priv->selected_text);
	self->priv->selected_text = _tmp10_;
	_tmp11_ = self->priv->selected_text;
	_tmp12_ = prev_selected_text;
	if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		_tmp13_ = start;
		_tmp14_ = end;
		g_signal_emit (self, scratch_widgets_source_view_signals[SCRATCH_WIDGETS_SOURCE_VIEW_SELECTION_CHANGED_SIGNAL], 0, &_tmp13_, &_tmp14_);
	}
	self->priv->selection_changed_timer = (guint) 0;
	result = FALSE;
	_g_free0 (prev_selected_text);
	return result;
}

static gboolean
__lambda35_ (ScratchWidgetsSourceView* self)
{
	gboolean _tmp0_ = FALSE;
	ScratchFolderManagerProjectFolderItem* _tmp1_;
	ScratchWidgetsNavMarkGutterRenderer* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean result;
	self->priv->refresh_timeout_id = (guint) 0;
	_tmp1_ = self->priv->_project;
	if (_tmp1_ != NULL) {
		ScratchFolderManagerProjectFolderItem* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_project;
		_tmp3_ = scratch_folder_manager_project_folder_item_get_is_git_repo (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ScratchWidgetsGitGutterRenderer* _tmp5_;
		GeeHashMap* _tmp6_;
		ScratchFolderManagerProjectFolderItem* _tmp7_;
		ScratchWidgetsGitGutterRenderer* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ScratchWidgetsGitGutterRenderer* _tmp12_;
		_tmp5_ = self->priv->git_diff_gutter_renderer;
		_tmp6_ = _tmp5_->line_status_map;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp6_);
		_tmp7_ = self->priv->_project;
		_tmp8_ = self->priv->git_diff_gutter_renderer;
		_tmp9_ = self->priv->_location;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		scratch_folder_manager_project_folder_item_refresh_diff (_tmp7_, &_tmp8_->line_status_map, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->git_diff_gutter_renderer;
		gtk_source_gutter_renderer_queue_draw ((GtkSourceGutterRenderer*) _tmp12_);
	}
	_tmp13_ = self->priv->navmark_gutter_renderer;
	_tmp14_ = scratch_widgets_nav_mark_gutter_renderer_get_has_marks (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		ScratchWidgetsNavMarkGutterRenderer* _tmp16_;
		_tmp16_ = self->priv->navmark_gutter_renderer;
		gtk_source_gutter_renderer_queue_draw ((GtkSourceGutterRenderer*) _tmp16_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda35__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda35_ ((ScratchWidgetsSourceView*) self);
	return result;
}

void
scratch_widgets_source_view_schedule_refresh (ScratchWidgetsSourceView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->refresh_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->refresh_timeout_id);
	}
	self->priv->refresh_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, ___lambda35__gsource_func, g_object_ref (self), g_object_unref);
}

GFile*
scratch_widgets_source_view_get_location (ScratchWidgetsSourceView* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

void
scratch_widgets_source_view_set_location (ScratchWidgetsSourceView* self,
                                          GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_source_view_get_location (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY]);
	}
}

ScratchFolderManagerProjectFolderItem*
scratch_widgets_source_view_get_project (ScratchWidgetsSourceView* self)
{
	ScratchFolderManagerProjectFolderItem* result;
	ScratchFolderManagerProjectFolderItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project;
	result = _tmp0_;
	return result;
}

void
scratch_widgets_source_view_set_project (ScratchWidgetsSourceView* self,
                                         ScratchFolderManagerProjectFolderItem* value)
{
	ScratchFolderManagerProjectFolderItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_source_view_get_project (self);
	if (old_value != value) {
		ScratchFolderManagerProjectFolderItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_project);
		self->priv->_project = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY]);
	}
}

GtkSourceLanguage*
scratch_widgets_source_view_get_language (ScratchWidgetsSourceView* self)
{
	GtkSourceLanguage* result;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	GtkSourceLanguage* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_source_buffer_get_language (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_source_buffer_get_type (), GtkSourceBuffer));
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
scratch_widgets_source_view_set_language (ScratchWidgetsSourceView* self,
                                          GtkSourceLanguage* value)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_source_buffer_set_language (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_source_buffer_get_type (), GtkSourceBuffer), value);
	g_object_notify_by_pspec ((GObject *) self, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY]);
}

gint
scratch_widgets_source_view_get_cursor_position (ScratchWidgetsSourceView* self)
{
	gint result;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		ScratchWidgetsSourceView* self;
		self = _data50_->self;
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
_scratch_widgets_source_view_cursor_position___lambda39_ (Block50Data* _data50_)
{
	ScratchWidgetsSourceView* self;
	GtkTextIter _tmp0_;
	gboolean result;
	self = _data50_->self;
	_tmp0_ = _data50_->iter;
	gtk_text_view_scroll_to_iter ((GtkTextView*) self, &_tmp0_, 0.25, FALSE, (gdouble) 0, (gdouble) 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__scratch_widgets_source_view_cursor_position___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = _scratch_widgets_source_view_cursor_position___lambda39_ (self);
	return result;
}

void
scratch_widgets_source_view_set_cursor_position (ScratchWidgetsSourceView* self,
                                                 gint value)
{
	Block50Data* _data50_;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_;
	g_return_if_fail (self != NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp2_, value);
	_data50_->iter = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data50_->iter;
	gtk_text_buffer_place_cursor (_tmp4_, &_tmp5_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __scratch_widgets_source_view_cursor_position___lambda39__gsource_func, block50_data_ref (_data50_), block50_data_unref);
	block50_data_unref (_data50_);
	_data50_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
_scratch_widgets_source_view_on_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                                   GtkTextIter* location,
                                                                   GtkTextMark* mark,
                                                                   gpointer self)
{
	scratch_widgets_source_view_on_mark_set ((ScratchWidgetsSourceView*) self, location, mark);
}

static void
_scratch_widgets_source_view_on_mark_deleted_gtk_text_buffer_mark_deleted (GtkTextBuffer* _sender,
                                                                           GtkTextMark* mark,
                                                                           gpointer self)
{
	scratch_widgets_source_view_on_mark_deleted ((ScratchWidgetsSourceView*) self, mark);
}

static void
_scratch_widgets_source_view_restore_settings_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	scratch_widgets_source_view_restore_settings ((ScratchWidgetsSourceView*) self);
}

static void
_scratch_widgets_source_view_restore_settings_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	scratch_widgets_source_view_restore_settings ((ScratchWidgetsSourceView*) self);
}

static gboolean
_scratch_widgets_source_view___lambda106_ (ScratchWidgetsSourceView* self,
                                           GdkEventScroll* key_event)
{
	gboolean handled = FALSE;
	gboolean result;
	g_return_val_if_fail (key_event != NULL, FALSE);
	handled = FALSE;
	if ((key_event->state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		self->priv->total_delta = self->priv->total_delta + key_event->delta_y;
		if (self->priv->total_delta < (-SCRATCH_WIDGETS_SOURCE_VIEW_SCROLL_THRESHOLD)) {
			GActionGroup* _tmp0_;
			_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
			g_action_group_activate_action (_tmp0_, SCRATCH_MAIN_WINDOW_ACTION_ZOOM_IN, NULL);
			self->priv->total_delta = 0.0;
		} else {
			if (self->priv->total_delta > SCRATCH_WIDGETS_SOURCE_VIEW_SCROLL_THRESHOLD) {
				GActionGroup* _tmp1_;
				_tmp1_ = gtk_widget_get_action_group ((GtkWidget*) self, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
				g_action_group_activate_action (_tmp1_, SCRATCH_MAIN_WINDOW_ACTION_ZOOM_OUT, NULL);
				self->priv->total_delta = 0.0;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__scratch_widgets_source_view___lambda106__gtk_widget_scroll_event (GtkWidget* _sender,
                                                                    GdkEventScroll* event,
                                                                    gpointer self)
{
	gboolean result;
	result = _scratch_widgets_source_view___lambda106_ ((ScratchWidgetsSourceView*) self, event);
	return result;
}

static void
_scratch_widgets_source_view___lambda107_ (ScratchWidgetsSourceView* self)
{
	GSettings* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = scratch_settings;
	if (!g_settings_get_boolean (_tmp0_, "smart-cut-copy")) {
		return;
	}
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_buffer_get_has_selection (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkTextIter iter_start = {0};
		GtkTextIter iter_end = {0};
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_ = {0};
		gboolean _tmp7_;
		_tmp7_ = scratch_widgets_source_view_get_current_line (self, &_tmp5_, &_tmp6_);
		iter_start = _tmp5_;
		iter_end = _tmp6_;
		if (_tmp7_) {
			GtkClipboard* clipboard = NULL;
			GdkDisplay* _tmp8_;
			GtkClipboard* _tmp9_;
			GtkClipboard* _tmp10_;
			gchar* cut_text = NULL;
			GtkTextIter _tmp11_;
			gchar* _tmp12_;
			GtkTextBuffer* _tmp13_;
			GtkTextBuffer* _tmp14_;
			GtkClipboard* _tmp15_;
			const gchar* _tmp16_;
			GtkTextBuffer* _tmp17_;
			GtkTextBuffer* _tmp18_;
			GtkTextIter _tmp19_;
			GtkTextIter _tmp20_;
			GtkTextBuffer* _tmp21_;
			GtkTextBuffer* _tmp22_;
			_tmp8_ = gtk_widget_get_display ((GtkWidget*) self);
			_tmp9_ = gtk_clipboard_get_for_display (_tmp8_, GDK_SELECTION_CLIPBOARD);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			clipboard = _tmp10_;
			_tmp11_ = iter_end;
			_tmp12_ = gtk_text_iter_get_slice (&iter_start, &_tmp11_);
			cut_text = _tmp12_;
			_tmp13_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp14_ = _tmp13_;
			gtk_text_buffer_begin_user_action (_tmp14_);
			_tmp15_ = clipboard;
			_tmp16_ = cut_text;
			gtk_clipboard_set_text (_tmp15_, _tmp16_, -1);
			_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = iter_start;
			_tmp20_ = iter_end;
			g_signal_emit_by_name (_tmp18_, "delete-range", &_tmp19_, &_tmp20_);
			_tmp21_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp22_ = _tmp21_;
			gtk_text_buffer_end_user_action (_tmp22_);
			_g_free0 (cut_text);
			_g_object_unref0 (clipboard);
		}
	}
}

static void
__scratch_widgets_source_view___lambda107__gtk_text_view_cut_clipboard (GtkTextView* _sender,
                                                                        gpointer self)
{
	_scratch_widgets_source_view___lambda107_ ((ScratchWidgetsSourceView*) self);
}

static void
_scratch_widgets_source_view___lambda108_ (ScratchWidgetsSourceView* self)
{
	GSettings* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = scratch_settings;
	if (!g_settings_get_boolean (_tmp0_, "smart-cut-copy")) {
		return;
	}
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_buffer_get_has_selection (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkTextIter iter_start = {0};
		GtkTextIter iter_end = {0};
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_ = {0};
		gboolean _tmp7_;
		_tmp7_ = scratch_widgets_source_view_get_current_line (self, &_tmp5_, &_tmp6_);
		iter_start = _tmp5_;
		iter_end = _tmp6_;
		if (_tmp7_) {
			GtkClipboard* clipboard = NULL;
			GdkDisplay* _tmp8_;
			GtkClipboard* _tmp9_;
			GtkClipboard* _tmp10_;
			gchar* copy_text = NULL;
			GtkTextIter _tmp11_;
			gchar* _tmp12_;
			GtkClipboard* _tmp13_;
			const gchar* _tmp14_;
			_tmp8_ = gtk_widget_get_display ((GtkWidget*) self);
			_tmp9_ = gtk_clipboard_get_for_display (_tmp8_, GDK_SELECTION_CLIPBOARD);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			clipboard = _tmp10_;
			_tmp11_ = iter_end;
			_tmp12_ = gtk_text_iter_get_slice (&iter_start, &_tmp11_);
			copy_text = _tmp12_;
			_tmp13_ = clipboard;
			_tmp14_ = copy_text;
			gtk_clipboard_set_text (_tmp13_, _tmp14_, -1);
			_g_free0 (copy_text);
			_g_object_unref0 (clipboard);
		}
	}
}

static void
__scratch_widgets_source_view___lambda108__gtk_text_view_copy_clipboard (GtkTextView* _sender,
                                                                         gpointer self)
{
	_scratch_widgets_source_view___lambda108_ ((ScratchWidgetsSourceView*) self);
}

static void
_scratch_widgets_source_view_on_context_menu_gtk_text_view_populate_popup (GtkTextView* _sender,
                                                                           GtkMenu* popup,
                                                                           gpointer self)
{
	scratch_widgets_source_view_on_context_menu ((ScratchWidgetsSourceView*) self, popup);
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		ScratchWidgetsSourceView* self;
		self = _data51_->self;
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static gboolean
___lambda110_ (Block51Data* _data51_)
{
	ScratchWidgetsSourceView* self;
	GtkAllocation _tmp0_;
	gboolean result;
	self = _data51_->self;
	self->priv->size_allocate_timer = (guint) 0;
	_tmp0_ = _data51_->allocation;
	gtk_text_view_set_bottom_margin ((GtkTextView*) self, scratch_widgets_source_view_calculate_bottom_margin (_tmp0_.height));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda110__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda110_ (self);
	return result;
}

static void
_scratch_widgets_source_view___lambda109_ (ScratchWidgetsSourceView* self,
                                           GtkAllocation* allocation)
{
	Block51Data* _data51_;
	GtkAllocation _tmp0_;
	g_return_if_fail (allocation != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = *allocation;
	_data51_->allocation = _tmp0_;
	if (self->priv->size_allocate_timer == ((guint) 0)) {
		self->priv->size_allocate_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, SCRATCH_WIDGETS_SOURCE_VIEW_THROTTLE_MS, ____lambda110__gsource_func, block51_data_ref (_data51_), block51_data_unref);
	}
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

static void
__scratch_widgets_source_view___lambda109__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                     GtkAllocation* allocation,
                                                                     gpointer self)
{
	_scratch_widgets_source_view___lambda109_ ((ScratchWidgetsSourceView*) self, allocation);
}

static GObject *
scratch_widgets_source_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchWidgetsSourceView * self;
	GtkSourceSpaceDrawer* _tmp0_;
	GtkSourceSpaceDrawer* _tmp1_;
	GtkSourceLanguageManager* _tmp2_;
	GtkSourceLanguageManager* _tmp3_;
	GtkSourceStyleSchemeManager* _tmp4_;
	GtkCssProvider* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkCssProvider* _tmp7_;
	GtkSourceBuffer* source_buffer = NULL;
	GtkSourceBuffer* _tmp8_;
	GtkSourceBuffer* _tmp9_;
	GtkSourceBuffer* _tmp10_;
	GtkSourceBuffer* _tmp11_;
	GtkSourceBuffer* _tmp12_;
	GtkSourceTag* draw_spaces_tag = NULL;
	GtkSourceTag* _tmp13_;
	GtkSourceTag* _tmp14_;
	GtkSourceBuffer* _tmp15_;
	GtkTextTagTable* _tmp16_;
	GtkTextTagTable* _tmp17_;
	GtkSourceTag* _tmp18_;
	ScratchWidgetsGitGutterRenderer* _tmp19_;
	GtkSourceBuffer* _tmp20_;
	ScratchWidgetsNavMarkGutterRenderer* _tmp21_;
	GtkSourceGutter* _tmp22_;
	ScratchWidgetsGitGutterRenderer* _tmp23_;
	GtkSourceGutter* _tmp24_;
	ScratchWidgetsNavMarkGutterRenderer* _tmp25_;
	GtkTextTag* _tmp26_;
	GtkTextTag* _tmp27_;
	GtkTextTag* _tmp28_;
	GdkRGBA _tmp29_ = {0};
	GtkTextTag* _tmp30_;
	GtkTextTag* _tmp31_;
	GtkSourceBuffer* _tmp32_;
	GtkTextTagTable* _tmp33_;
	GtkTextTagTable* _tmp34_;
	GtkTextTag* _tmp35_;
	GtkSourceBuffer* _tmp36_;
	GtkTextTagTable* _tmp37_;
	GtkTextTagTable* _tmp38_;
	GtkTextTag* _tmp39_;
	GSettings* _tmp40_;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp41_;
	GraniteSettings* _tmp42_;
	GraniteSettings* _tmp43_;
	parent_class = G_OBJECT_CLASS (scratch_widgets_source_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceView);
	_tmp0_ = gtk_source_view_get_space_drawer ((GtkSourceView*) self);
	_tmp1_ = _tmp0_;
	gtk_source_space_drawer_set_enable_matrix (_tmp1_, TRUE);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_tmp2_ = gtk_source_language_manager_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->manager);
	self->manager = _tmp3_;
	_tmp4_ = gtk_source_style_scheme_manager_new ();
	_g_object_unref0 (self->style_scheme_manager);
	self->style_scheme_manager = _tmp4_;
	_tmp5_ = gtk_css_provider_new ();
	_g_object_unref0 (self->font_css_provider);
	self->font_css_provider = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp7_ = self->font_css_provider;
	gtk_style_context_add_provider (_tmp6_, (GtkStyleProvider*) _tmp7_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp8_ = gtk_source_buffer_new (NULL);
	source_buffer = _tmp8_;
	_tmp9_ = source_buffer;
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) _tmp9_);
	_tmp10_ = source_buffer;
	gtk_source_buffer_set_highlight_syntax (_tmp10_, TRUE);
	_tmp11_ = source_buffer;
	g_signal_connect_object ((GtkTextBuffer*) _tmp11_, "mark-set", (GCallback) _scratch_widgets_source_view_on_mark_set_gtk_text_buffer_mark_set, self, 0);
	_tmp12_ = source_buffer;
	g_signal_connect_object ((GtkTextBuffer*) _tmp12_, "mark-deleted", (GCallback) _scratch_widgets_source_view_on_mark_deleted_gtk_text_buffer_mark_deleted, self, 0);
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, TRUE);
	_tmp13_ = (GtkSourceTag*) gtk_source_tag_new ("draw_spaces");
	draw_spaces_tag = _tmp13_;
	_tmp14_ = draw_spaces_tag;
	g_object_set (_tmp14_, "draw-spaces", TRUE, NULL);
	_tmp15_ = source_buffer;
	_tmp16_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = draw_spaces_tag;
	gtk_text_tag_table_add (_tmp17_, (GtkTextTag*) _tmp18_);
	_tmp19_ = scratch_widgets_git_gutter_renderer_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->git_diff_gutter_renderer);
	self->priv->git_diff_gutter_renderer = _tmp19_;
	_tmp20_ = source_buffer;
	_tmp21_ = scratch_widgets_nav_mark_gutter_renderer_new ((GtkTextBuffer*) _tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->navmark_gutter_renderer);
	self->priv->navmark_gutter_renderer = _tmp21_;
	_tmp22_ = gtk_source_view_get_gutter ((GtkSourceView*) self, GTK_TEXT_WINDOW_LEFT);
	_tmp23_ = self->priv->git_diff_gutter_renderer;
	gtk_source_gutter_insert (_tmp22_, (GtkSourceGutterRenderer*) _tmp23_, 10);
	_tmp24_ = gtk_source_view_get_gutter ((GtkSourceView*) self, GTK_TEXT_WINDOW_LEFT);
	_tmp25_ = self->priv->navmark_gutter_renderer;
	gtk_source_gutter_insert (_tmp24_, (GtkSourceGutterRenderer*) _tmp25_, -48);
	gtk_source_view_set_smart_home_end ((GtkSourceView*) self, GTK_SOURCE_SMART_HOME_END_AFTER);
	_tmp26_ = gtk_text_tag_new ("warning_bg");
	_g_object_unref0 (self->warning_tag);
	self->warning_tag = _tmp26_;
	_tmp27_ = self->warning_tag;
	g_object_set (_tmp27_, "underline", PANGO_UNDERLINE_ERROR, NULL);
	_tmp28_ = self->warning_tag;
	memset (&_tmp29_, 0, sizeof (GdkRGBA));
	_tmp29_.red = 0.13;
	_tmp29_.green = 0.55;
	_tmp29_.blue = 0.13;
	_tmp29_.alpha = 1.0;
	g_object_set (_tmp28_, "underline-rgba", &_tmp29_, NULL);
	_tmp30_ = gtk_text_tag_new ("error_bg");
	_g_object_unref0 (self->error_tag);
	self->error_tag = _tmp30_;
	_tmp31_ = self->error_tag;
	g_object_set (_tmp31_, "underline", PANGO_UNDERLINE_ERROR, NULL);
	_tmp32_ = source_buffer;
	_tmp33_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = self->error_tag;
	gtk_text_tag_table_add (_tmp34_, _tmp35_);
	_tmp36_ = source_buffer;
	_tmp37_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->warning_tag;
	gtk_text_tag_table_add (_tmp38_, _tmp39_);
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
	scratch_widgets_source_view_restore_settings (self);
	_tmp40_ = scratch_settings;
	g_signal_connect_object (_tmp40_, "changed", (GCallback) _scratch_widgets_source_view_restore_settings_g_settings_changed, self, 0);
	_tmp41_ = granite_settings_get_default ();
	_tmp42_ = _g_object_ref0 (_tmp41_);
	granite_settings = _tmp42_;
	_tmp43_ = granite_settings;
	g_signal_connect_object ((GObject*) _tmp43_, "notify::prefers-color-scheme", (GCallback) _scratch_widgets_source_view_restore_settings_g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __scratch_widgets_source_view___lambda106__gtk_widget_scroll_event, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "cut-clipboard", (GCallback) __scratch_widgets_source_view___lambda107__gtk_text_view_cut_clipboard, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "copy-clipboard", (GCallback) __scratch_widgets_source_view___lambda108__gtk_text_view_copy_clipboard, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "populate-popup", (GCallback) _scratch_widgets_source_view_on_context_menu_gtk_text_view_populate_popup, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __scratch_widgets_source_view___lambda109__gtk_widget_size_allocate, self, 0);
	_g_object_unref0 (granite_settings);
	_g_object_unref0 (draw_spaces_tag);
	_g_object_unref0 (source_buffer);
	return obj;
}

static void
scratch_widgets_source_view_class_init (ScratchWidgetsSourceViewClass * klass,
                                        gpointer klass_data)
{
	scratch_widgets_source_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchWidgetsSourceView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_widgets_source_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_widgets_source_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_widgets_source_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_widgets_source_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY] = g_param_spec_object ("project", "project", "project", SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY] = g_param_spec_object ("language", "language", "language", gtk_source_language_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY, scratch_widgets_source_view_properties[SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY] = g_param_spec_int ("cursor-position", "cursor-position", "cursor-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	scratch_widgets_source_view_signals[SCRATCH_WIDGETS_SOURCE_VIEW_STYLE_CHANGED_SIGNAL] = g_signal_new ("style-changed", SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_source_style_scheme_get_type ());
	scratch_widgets_source_view_signals[SCRATCH_WIDGETS_SOURCE_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOXED, G_TYPE_NONE, 2, gtk_text_iter_get_type (), gtk_text_iter_get_type ());
}

static void
scratch_widgets_source_view_instance_init (ScratchWidgetsSourceView * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = scratch_widgets_source_view_get_instance_private (self);
	self->priv->_project = NULL;
	self->priv->selection_changed_timer = (guint) 0;
	self->priv->size_allocate_timer = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->selected_text = _tmp0_;
	self->priv->total_delta = (gdouble) 0;
	self->priv->refresh_timeout_id = (guint) 0;
}

static void
scratch_widgets_source_view_finalize (GObject * obj)
{
	ScratchWidgetsSourceView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceView);
	_g_object_unref0 (self->manager);
	_g_object_unref0 (self->style_scheme_manager);
	_g_object_unref0 (self->font_css_provider);
	_g_object_unref0 (self->warning_tag);
	_g_object_unref0 (self->error_tag);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->_project);
	_g_free0 (self->priv->font);
	_g_free0 (self->priv->selected_text);
	_g_object_unref0 (self->priv->git_diff_gutter_renderer);
	_g_object_unref0 (self->priv->navmark_gutter_renderer);
	G_OBJECT_CLASS (scratch_widgets_source_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_widgets_source_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchWidgetsSourceViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_widgets_source_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchWidgetsSourceView), 0, (GInstanceInitFunc) scratch_widgets_source_view_instance_init, NULL };
	GType scratch_widgets_source_view_type_id;
	scratch_widgets_source_view_type_id = g_type_register_static (gtk_source_view_get_type (), "ScratchWidgetsSourceView", &g_define_type_info, 0);
	ScratchWidgetsSourceView_private_offset = g_type_add_instance_private (scratch_widgets_source_view_type_id, sizeof (ScratchWidgetsSourceViewPrivate));
	return scratch_widgets_source_view_type_id;
}

GType
scratch_widgets_source_view_get_type (void)
{
	static gsize scratch_widgets_source_view_type_id__once = 0;
	if (g_once_init_enter (&scratch_widgets_source_view_type_id__once)) {
		GType scratch_widgets_source_view_type_id;
		scratch_widgets_source_view_type_id = scratch_widgets_source_view_get_type_once ();
		g_once_init_leave (&scratch_widgets_source_view_type_id__once, scratch_widgets_source_view_type_id);
	}
	return scratch_widgets_source_view_type_id__once;
}

static void
_vala_scratch_widgets_source_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ScratchWidgetsSourceView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceView);
	switch (property_id) {
		case SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY:
		g_value_set_object (value, scratch_widgets_source_view_get_location (self));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY:
		g_value_set_object (value, scratch_widgets_source_view_get_project (self));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY:
		g_value_set_object (value, scratch_widgets_source_view_get_language (self));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY:
		g_value_set_int (value, scratch_widgets_source_view_get_cursor_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_widgets_source_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ScratchWidgetsSourceView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceView);
	switch (property_id) {
		case SCRATCH_WIDGETS_SOURCE_VIEW_LOCATION_PROPERTY:
		scratch_widgets_source_view_set_location (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_PROJECT_PROPERTY:
		scratch_widgets_source_view_set_project (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_LANGUAGE_PROPERTY:
		scratch_widgets_source_view_set_language (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_SOURCE_VIEW_CURSOR_POSITION_PROPERTY:
		scratch_widgets_source_view_set_cursor_position (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

