// Common interface for low-level video codecs. Not to be confused
// with VideoEncoder (which is a higher-level orchestration class).

#ifndef _VIDEO_CODEC_INTERFACE_H
#define _VIDEO_CODEC_INTERFACE_H 1

#include <stdint.h>
#include <string>

#include <movit/image_format.h>

#include "print_latency.h"

class Mux;

class VideoCodecInterface {
public:
	// Called after the last frame. Will block; once this returns,
	// the last data is flushed.
	virtual ~VideoCodecInterface() {}

	// Must be called before first frame. Does not take ownership.
	virtual void add_mux(Mux *mux) = 0;

	// <data> is taken to be raw NV12 data of WIDTHxHEIGHT resolution.
	// Does not block.
	virtual void add_frame(int64_t pts, int64_t duration, movit::YCbCrLumaCoefficients ycbcr_coefficients, const uint8_t *data, const ReceivedTimestamps &received_ts) = 0;

	virtual std::string get_global_headers() const = 0;
};

#endif  // !defined(_VIDEO_CODEC_INTERFACE_H)
