/* Generated by wayland-scanner 1.23.1 */

#ifndef TABLET_UNSTABLE_V2_SERVER_PROTOCOL_H
#define TABLET_UNSTABLE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_tablet_unstable_v2 The tablet_unstable_v2 protocol
 * Wayland protocol for graphics tablets
 *
 * @section page_desc_tablet_unstable_v2 Description
 *
 * This description provides a high-level overview of the interplay between
 * the interfaces defined this protocol. For details, see the protocol
 * specification.
 *
 * More than one tablet may exist, and device-specifics matter. Tablets are
 * not represented by a single virtual device like wl_pointer. A client
 * binds to the tablet manager object which is just a proxy object. From
 * that, the client requests wp_tablet_manager.get_tablet_seat(wl_seat)
 * and that returns the actual interface that has all the tablets. With
 * this indirection, we can avoid merging wp_tablet into the actual Wayland
 * protocol, a long-term benefit.
 *
 * The wp_tablet_seat sends a "tablet added" event for each tablet
 * connected. That event is followed by descriptive events about the
 * hardware; currently that includes events for name, vid/pid and
 * a wp_tablet.path event that describes a local path. This path can be
 * used to uniquely identify a tablet or get more information through
 * libwacom. Emulated or nested tablets can skip any of those, e.g. a
 * virtual tablet may not have a vid/pid. The sequence of descriptive
 * events is terminated by a wp_tablet.done event to signal that a client
 * may now finalize any initialization for that tablet.
 *
 * Events from tablets require a tool in proximity. Tools are also managed
 * by the tablet seat; a "tool added" event is sent whenever a tool is new
 * to the compositor. That event is followed by a number of descriptive
 * events about the hardware; currently that includes capabilities,
 * hardware id and serial number, and tool type. Similar to the tablet
 * interface, a wp_tablet_tool.done event is sent to terminate that initial
 * sequence.
 *
 * Any event from a tool happens on the wp_tablet_tool interface. When the
 * tool gets into proximity of the tablet, a proximity_in event is sent on
 * the wp_tablet_tool interface, listing the tablet and the surface. That
 * event is followed by a motion event with the coordinates. After that,
 * it's the usual motion, axis, button, etc. events. The protocol's
 * serialisation means events are grouped by wp_tablet_tool.frame events.
 *
 * Two special events (that don't exist in X) are down and up. They signal
 * "tip touching the surface". For tablets without real proximity
 * detection, the sequence is: proximity_in, motion, down, frame.
 *
 * When the tool leaves proximity, a proximity_out event is sent. If any
 * button is still down, a button release event is sent before this
 * proximity event. These button events are sent in the same frame as the
 * proximity event to signal to the client that the buttons were held when
 * the tool left proximity.
 *
 * If the tool moves out of the surface but stays in proximity (i.e.
 * between windows), compositor-specific grab policies apply. This usually
 * means that the proximity-out is delayed until all buttons are released.
 *
 * Moving a tool physically from one tablet to the other has no real effect
 * on the protocol, since we already have the tool object from the "tool
 * added" event. All the information is already there and the proximity
 * events on both tablets are all a client needs to reconstruct what
 * happened.
 *
 * Some extra axes are normalized, i.e. the client knows the range as
 * specified in the protocol (e.g. [0, 65535]), the granularity however is
 * unknown. The current normalized axes are pressure, distance, and slider.
 *
 * Other extra axes are in physical units as specified in the protocol.
 * The current extra axes with physical units are tilt, rotation and
 * wheel rotation.
 *
 * Since tablets work independently of the pointer controlled by the mouse,
 * the focus handling is independent too and controlled by proximity.
 * The wp_tablet_tool.set_cursor request sets a tool-specific cursor.
 * This cursor surface may be the same as the mouse cursor, and it may be
 * the same across tools but it is possible to be more fine-grained. For
 * example, a client may set different cursors for the pen and eraser.
 *
 * Tools are generally independent of tablets and it is
 * compositor-specific policy when a tool can be removed. Common approaches
 * will likely include some form of removing a tool when all tablets the
 * tool was used on are removed.
 *
 * Disclaimer: This protocol extension has been marked stable. This copy is
 * no longer used and only retained for backwards compatibility. The
 * canonical version can be found in the stable/ directory.
 *
 * @section page_ifaces_tablet_unstable_v2 Interfaces
 * - @subpage page_iface_zwp_tablet_manager_v2 - controller object for graphic tablet devices
 * - @subpage page_iface_zwp_tablet_seat_v2 - controller object for graphic tablet devices of a seat
 * - @subpage page_iface_zwp_tablet_tool_v2 - a physical tablet tool
 * - @subpage page_iface_zwp_tablet_v2 - graphics tablet device
 * - @subpage page_iface_zwp_tablet_pad_ring_v2 - pad ring
 * - @subpage page_iface_zwp_tablet_pad_strip_v2 - pad strip
 * - @subpage page_iface_zwp_tablet_pad_group_v2 - a set of buttons, rings and strips
 * - @subpage page_iface_zwp_tablet_pad_v2 - a set of buttons, rings and strips
 * @section page_copyright_tablet_unstable_v2 Copyright
 * <pre>
 *
 * Copyright 2014 © Stephen "Lyude" Chandler Paul
 * Copyright 2015-2016 © Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct wl_surface;
struct zwp_tablet_manager_v2;
struct zwp_tablet_pad_group_v2;
struct zwp_tablet_pad_ring_v2;
struct zwp_tablet_pad_strip_v2;
struct zwp_tablet_pad_v2;
struct zwp_tablet_seat_v2;
struct zwp_tablet_tool_v2;
struct zwp_tablet_v2;

#ifndef ZWP_TABLET_MANAGER_V2_INTERFACE
#define ZWP_TABLET_MANAGER_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_manager_v2 zwp_tablet_manager_v2
 * @section page_iface_zwp_tablet_manager_v2_desc Description
 *
 * An object that provides access to the graphics tablets available on this
 * system. All tablets are associated with a seat, to get access to the
 * actual tablets, use wp_tablet_manager.get_tablet_seat.
 * @section page_iface_zwp_tablet_manager_v2_api API
 * See @ref iface_zwp_tablet_manager_v2.
 */
/**
 * @defgroup iface_zwp_tablet_manager_v2 The zwp_tablet_manager_v2 interface
 *
 * An object that provides access to the graphics tablets available on this
 * system. All tablets are associated with a seat, to get access to the
 * actual tablets, use wp_tablet_manager.get_tablet_seat.
 */
extern const struct wl_interface zwp_tablet_manager_v2_interface;
#endif
#ifndef ZWP_TABLET_SEAT_V2_INTERFACE
#define ZWP_TABLET_SEAT_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_seat_v2 zwp_tablet_seat_v2
 * @section page_iface_zwp_tablet_seat_v2_desc Description
 *
 * An object that provides access to the graphics tablets available on this
 * seat. After binding to this interface, the compositor sends a set of
 * wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
 * @section page_iface_zwp_tablet_seat_v2_api API
 * See @ref iface_zwp_tablet_seat_v2.
 */
/**
 * @defgroup iface_zwp_tablet_seat_v2 The zwp_tablet_seat_v2 interface
 *
 * An object that provides access to the graphics tablets available on this
 * seat. After binding to this interface, the compositor sends a set of
 * wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
 */
extern const struct wl_interface zwp_tablet_seat_v2_interface;
#endif
#ifndef ZWP_TABLET_TOOL_V2_INTERFACE
#define ZWP_TABLET_TOOL_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_tool_v2 zwp_tablet_tool_v2
 * @section page_iface_zwp_tablet_tool_v2_desc Description
 *
 * An object that represents a physical tool that has been, or is
 * currently in use with a tablet in this seat. Each wp_tablet_tool
 * object stays valid until the client destroys it; the compositor
 * reuses the wp_tablet_tool object to indicate that the object's
 * respective physical tool has come into proximity of a tablet again.
 *
 * A wp_tablet_tool object's relation to a physical tool depends on the
 * tablet's ability to report serial numbers. If the tablet supports
 * this capability, then the object represents a specific physical tool
 * and can be identified even when used on multiple tablets.
 *
 * A tablet tool has a number of static characteristics, e.g. tool type,
 * hardware_serial and capabilities. These capabilities are sent in an
 * event sequence after the wp_tablet_seat.tool_added event before any
 * actual events from this tool. This initial event sequence is
 * terminated by a wp_tablet_tool.done event.
 *
 * Tablet tool events are grouped by wp_tablet_tool.frame events.
 * Any events received before a wp_tablet_tool.frame event should be
 * considered part of the same hardware state change.
 * @section page_iface_zwp_tablet_tool_v2_api API
 * See @ref iface_zwp_tablet_tool_v2.
 */
/**
 * @defgroup iface_zwp_tablet_tool_v2 The zwp_tablet_tool_v2 interface
 *
 * An object that represents a physical tool that has been, or is
 * currently in use with a tablet in this seat. Each wp_tablet_tool
 * object stays valid until the client destroys it; the compositor
 * reuses the wp_tablet_tool object to indicate that the object's
 * respective physical tool has come into proximity of a tablet again.
 *
 * A wp_tablet_tool object's relation to a physical tool depends on the
 * tablet's ability to report serial numbers. If the tablet supports
 * this capability, then the object represents a specific physical tool
 * and can be identified even when used on multiple tablets.
 *
 * A tablet tool has a number of static characteristics, e.g. tool type,
 * hardware_serial and capabilities. These capabilities are sent in an
 * event sequence after the wp_tablet_seat.tool_added event before any
 * actual events from this tool. This initial event sequence is
 * terminated by a wp_tablet_tool.done event.
 *
 * Tablet tool events are grouped by wp_tablet_tool.frame events.
 * Any events received before a wp_tablet_tool.frame event should be
 * considered part of the same hardware state change.
 */
extern const struct wl_interface zwp_tablet_tool_v2_interface;
#endif
#ifndef ZWP_TABLET_V2_INTERFACE
#define ZWP_TABLET_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_v2 zwp_tablet_v2
 * @section page_iface_zwp_tablet_v2_desc Description
 *
 * The wp_tablet interface represents one graphics tablet device. The
 * tablet interface itself does not generate events; all events are
 * generated by wp_tablet_tool objects when in proximity above a tablet.
 *
 * A tablet has a number of static characteristics, e.g. device name and
 * pid/vid. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.tablet_added event. This initial event sequence is
 * terminated by a wp_tablet.done event.
 * @section page_iface_zwp_tablet_v2_api API
 * See @ref iface_zwp_tablet_v2.
 */
/**
 * @defgroup iface_zwp_tablet_v2 The zwp_tablet_v2 interface
 *
 * The wp_tablet interface represents one graphics tablet device. The
 * tablet interface itself does not generate events; all events are
 * generated by wp_tablet_tool objects when in proximity above a tablet.
 *
 * A tablet has a number of static characteristics, e.g. device name and
 * pid/vid. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.tablet_added event. This initial event sequence is
 * terminated by a wp_tablet.done event.
 */
extern const struct wl_interface zwp_tablet_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_RING_V2_INTERFACE
#define ZWP_TABLET_PAD_RING_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_ring_v2 zwp_tablet_pad_ring_v2
 * @section page_iface_zwp_tablet_pad_ring_v2_desc Description
 *
 * A circular interaction area, such as the touch ring on the Wacom Intuos
 * Pro series tablets.
 *
 * Events on a ring are logically grouped by the wl_tablet_pad_ring.frame
 * event.
 * @section page_iface_zwp_tablet_pad_ring_v2_api API
 * See @ref iface_zwp_tablet_pad_ring_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_ring_v2 The zwp_tablet_pad_ring_v2 interface
 *
 * A circular interaction area, such as the touch ring on the Wacom Intuos
 * Pro series tablets.
 *
 * Events on a ring are logically grouped by the wl_tablet_pad_ring.frame
 * event.
 */
extern const struct wl_interface zwp_tablet_pad_ring_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_STRIP_V2_INTERFACE
#define ZWP_TABLET_PAD_STRIP_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_strip_v2 zwp_tablet_pad_strip_v2
 * @section page_iface_zwp_tablet_pad_strip_v2_desc Description
 *
 * A linear interaction area, such as the strips found in Wacom Cintiq
 * models.
 *
 * Events on a strip are logically grouped by the wl_tablet_pad_strip.frame
 * event.
 * @section page_iface_zwp_tablet_pad_strip_v2_api API
 * See @ref iface_zwp_tablet_pad_strip_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_strip_v2 The zwp_tablet_pad_strip_v2 interface
 *
 * A linear interaction area, such as the strips found in Wacom Cintiq
 * models.
 *
 * Events on a strip are logically grouped by the wl_tablet_pad_strip.frame
 * event.
 */
extern const struct wl_interface zwp_tablet_pad_strip_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_GROUP_V2_INTERFACE
#define ZWP_TABLET_PAD_GROUP_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_group_v2 zwp_tablet_pad_group_v2
 * @section page_iface_zwp_tablet_pad_group_v2_desc Description
 *
 * A pad group describes a distinct (sub)set of buttons, rings and strips
 * present in the tablet. The criteria of this grouping is usually positional,
 * eg. if a tablet has buttons on the left and right side, 2 groups will be
 * presented. The physical arrangement of groups is undisclosed and may
 * change on the fly.
 *
 * Pad groups will announce their features during pad initialization. Between
 * the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done, the
 * pad group will announce the buttons, rings and strips contained in it,
 * plus the number of supported modes.
 *
 * Modes are a mechanism to allow multiple groups of actions for every element
 * in the pad group. The number of groups and available modes in each is
 * persistent across device plugs. The current mode is user-switchable, it
 * will be announced through the wp_tablet_pad_group.mode_switch event both
 * whenever it is switched, and after wp_tablet_pad.enter.
 *
 * The current mode logically applies to all elements in the pad group,
 * although it is at clients' discretion whether to actually perform different
 * actions, and/or issue the respective .set_feedback requests to notify the
 * compositor. See the wp_tablet_pad_group.mode_switch event for more details.
 * @section page_iface_zwp_tablet_pad_group_v2_api API
 * See @ref iface_zwp_tablet_pad_group_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_group_v2 The zwp_tablet_pad_group_v2 interface
 *
 * A pad group describes a distinct (sub)set of buttons, rings and strips
 * present in the tablet. The criteria of this grouping is usually positional,
 * eg. if a tablet has buttons on the left and right side, 2 groups will be
 * presented. The physical arrangement of groups is undisclosed and may
 * change on the fly.
 *
 * Pad groups will announce their features during pad initialization. Between
 * the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done, the
 * pad group will announce the buttons, rings and strips contained in it,
 * plus the number of supported modes.
 *
 * Modes are a mechanism to allow multiple groups of actions for every element
 * in the pad group. The number of groups and available modes in each is
 * persistent across device plugs. The current mode is user-switchable, it
 * will be announced through the wp_tablet_pad_group.mode_switch event both
 * whenever it is switched, and after wp_tablet_pad.enter.
 *
 * The current mode logically applies to all elements in the pad group,
 * although it is at clients' discretion whether to actually perform different
 * actions, and/or issue the respective .set_feedback requests to notify the
 * compositor. See the wp_tablet_pad_group.mode_switch event for more details.
 */
extern const struct wl_interface zwp_tablet_pad_group_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_V2_INTERFACE
#define ZWP_TABLET_PAD_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_v2 zwp_tablet_pad_v2
 * @section page_iface_zwp_tablet_pad_v2_desc Description
 *
 * A pad device is a set of buttons, rings and strips
 * usually physically present on the tablet device itself. Some
 * exceptions exist where the pad device is physically detached, e.g. the
 * Wacom ExpressKey Remote.
 *
 * Pad devices have no axes that control the cursor and are generally
 * auxiliary devices to the tool devices used on the tablet surface.
 *
 * A pad device has a number of static characteristics, e.g. the number
 * of rings. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.pad_added event before any actual events from this pad.
 * This initial event sequence is terminated by a wp_tablet_pad.done
 * event.
 *
 * All pad features (buttons, rings and strips) are logically divided into
 * groups and all pads have at least one group. The available groups are
 * notified through the wp_tablet_pad.group event; the compositor will
 * emit one event per group before emitting wp_tablet_pad.done.
 *
 * Groups may have multiple modes. Modes allow clients to map multiple
 * actions to a single pad feature. Only one mode can be active per group,
 * although different groups may have different active modes.
 * @section page_iface_zwp_tablet_pad_v2_api API
 * See @ref iface_zwp_tablet_pad_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_v2 The zwp_tablet_pad_v2 interface
 *
 * A pad device is a set of buttons, rings and strips
 * usually physically present on the tablet device itself. Some
 * exceptions exist where the pad device is physically detached, e.g. the
 * Wacom ExpressKey Remote.
 *
 * Pad devices have no axes that control the cursor and are generally
 * auxiliary devices to the tool devices used on the tablet surface.
 *
 * A pad device has a number of static characteristics, e.g. the number
 * of rings. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.pad_added event before any actual events from this pad.
 * This initial event sequence is terminated by a wp_tablet_pad.done
 * event.
 *
 * All pad features (buttons, rings and strips) are logically divided into
 * groups and all pads have at least one group. The available groups are
 * notified through the wp_tablet_pad.group event; the compositor will
 * emit one event per group before emitting wp_tablet_pad.done.
 *
 * Groups may have multiple modes. Modes allow clients to map multiple
 * actions to a single pad feature. Only one mode can be active per group,
 * although different groups may have different active modes.
 */
extern const struct wl_interface zwp_tablet_pad_v2_interface;
#endif

/**
 * @ingroup iface_zwp_tablet_manager_v2
 * @struct zwp_tablet_manager_v2_interface
 */
struct zwp_tablet_manager_v2_interface {
	/**
	 * get the tablet seat
	 *
	 * Get the wp_tablet_seat object for the given seat. This object
	 * provides access to all graphics tablets in this seat.
	 * @param seat The wl_seat object to retrieve the tablets for
	 */
	void (*get_tablet_seat)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t tablet_seat,
				struct wl_resource *seat);
	/**
	 * release the memory for the tablet manager object
	 *
	 * Destroy the wp_tablet_manager object. Objects created from
	 * this object are unaffected and should be destroyed separately.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zwp_tablet_manager_v2
 */
#define ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_manager_v2
 */
#define ZWP_TABLET_MANAGER_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_seat_v2
 * @struct zwp_tablet_seat_v2_interface
 */
struct zwp_tablet_seat_v2_interface {
	/**
	 * release the memory for the tablet seat object
	 *
	 * Destroy the wp_tablet_seat object. Objects created from this
	 * object are unaffected and should be destroyed separately.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_SEAT_V2_TABLET_ADDED 0
#define ZWP_TABLET_SEAT_V2_TOOL_ADDED 1
#define ZWP_TABLET_SEAT_V2_PAD_ADDED 2

/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_TABLET_ADDED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_TOOL_ADDED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_PAD_ADDED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_seat_v2
 * Sends an tablet_added event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id the newly added graphics tablet
 */
static inline void
zwp_tablet_seat_v2_send_tablet_added(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWP_TABLET_SEAT_V2_TABLET_ADDED, id);
}

/**
 * @ingroup iface_zwp_tablet_seat_v2
 * Sends an tool_added event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id the newly added tablet tool
 */
static inline void
zwp_tablet_seat_v2_send_tool_added(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWP_TABLET_SEAT_V2_TOOL_ADDED, id);
}

/**
 * @ingroup iface_zwp_tablet_seat_v2
 * Sends an pad_added event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id the newly added pad
 */
static inline void
zwp_tablet_seat_v2_send_pad_added(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWP_TABLET_SEAT_V2_PAD_ADDED, id);
}

#ifndef ZWP_TABLET_TOOL_V2_TYPE_ENUM
#define ZWP_TABLET_TOOL_V2_TYPE_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * a physical tool type
 *
 * Describes the physical type of a tool. The physical type of a tool
 * generally defines its base usage.
 *
 * The mouse tool represents a mouse-shaped tool that is not a relative
 * device but bound to the tablet's surface, providing absolute
 * coordinates.
 *
 * The lens tool is a mouse-shaped tool with an attached lens to
 * provide precision focus.
 */
enum zwp_tablet_tool_v2_type {
	/**
	 * Pen
	 */
	ZWP_TABLET_TOOL_V2_TYPE_PEN = 0x140,
	/**
	 * Eraser
	 */
	ZWP_TABLET_TOOL_V2_TYPE_ERASER = 0x141,
	/**
	 * Brush
	 */
	ZWP_TABLET_TOOL_V2_TYPE_BRUSH = 0x142,
	/**
	 * Pencil
	 */
	ZWP_TABLET_TOOL_V2_TYPE_PENCIL = 0x143,
	/**
	 * Airbrush
	 */
	ZWP_TABLET_TOOL_V2_TYPE_AIRBRUSH = 0x144,
	/**
	 * Finger
	 */
	ZWP_TABLET_TOOL_V2_TYPE_FINGER = 0x145,
	/**
	 * Mouse
	 */
	ZWP_TABLET_TOOL_V2_TYPE_MOUSE = 0x146,
	/**
	 * Lens
	 */
	ZWP_TABLET_TOOL_V2_TYPE_LENS = 0x147,
};
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Validate a zwp_tablet_tool_v2 type value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_tool_v2_type
 */
static inline bool
zwp_tablet_tool_v2_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_TOOL_V2_TYPE_PEN:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_ERASER:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_BRUSH:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_PENCIL:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_AIRBRUSH:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_FINGER:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_MOUSE:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_TYPE_LENS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_TOOL_V2_TYPE_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM
#define ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * capability flags for a tool
 *
 * Describes extra capabilities on a tablet.
 *
 * Any tool must provide x and y values, extra axes are
 * device-specific.
 */
enum zwp_tablet_tool_v2_capability {
	/**
	 * Tilt axes
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_TILT = 1,
	/**
	 * Pressure axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_PRESSURE = 2,
	/**
	 * Distance axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_DISTANCE = 3,
	/**
	 * Z-rotation axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_ROTATION = 4,
	/**
	 * Slider axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_SLIDER = 5,
	/**
	 * Wheel axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_WHEEL = 6,
};
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Validate a zwp_tablet_tool_v2 capability value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_tool_v2_capability
 */
static inline bool
zwp_tablet_tool_v2_capability_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_TOOL_V2_CAPABILITY_TILT:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_CAPABILITY_PRESSURE:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_CAPABILITY_DISTANCE:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_CAPABILITY_ROTATION:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_CAPABILITY_SLIDER:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_CAPABILITY_WHEEL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM
#define ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * physical button state
 *
 * Describes the physical state of a button that produced the button event.
 */
enum zwp_tablet_tool_v2_button_state {
	/**
	 * button is not pressed
	 */
	ZWP_TABLET_TOOL_V2_BUTTON_STATE_RELEASED = 0,
	/**
	 * button is pressed
	 */
	ZWP_TABLET_TOOL_V2_BUTTON_STATE_PRESSED = 1,
};
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Validate a zwp_tablet_tool_v2 button_state value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_tool_v2_button_state
 */
static inline bool
zwp_tablet_tool_v2_button_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_TOOL_V2_BUTTON_STATE_RELEASED:
		return version >= 1;
	case ZWP_TABLET_TOOL_V2_BUTTON_STATE_PRESSED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_ERROR_ENUM
#define ZWP_TABLET_TOOL_V2_ERROR_ENUM
enum zwp_tablet_tool_v2_error {
	/**
	 * given wl_surface has another role
	 */
	ZWP_TABLET_TOOL_V2_ERROR_ROLE = 0,
};
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Validate a zwp_tablet_tool_v2 error value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_tool_v2_error
 */
static inline bool
zwp_tablet_tool_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_TOOL_V2_ERROR_ROLE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_TOOL_V2_ERROR_ENUM */

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * @struct zwp_tablet_tool_v2_interface
 */
struct zwp_tablet_tool_v2_interface {
	/**
	 * set the tablet tool's surface
	 *
	 * Sets the surface of the cursor used for this tool on the given
	 * tablet. This request only takes effect if the tool is in
	 * proximity of one of the requesting client's surfaces or the
	 * surface parameter is the current pointer surface. If there was a
	 * previous surface set with this request it is replaced. If
	 * surface is NULL, the cursor image is hidden.
	 *
	 * The parameters hotspot_x and hotspot_y define the position of
	 * the pointer surface relative to the pointer location. Its
	 * top-left corner is always at (x, y) - (hotspot_x, hotspot_y),
	 * where (x, y) are the coordinates of the pointer location, in
	 * surface-local coordinates.
	 *
	 * On surface.attach requests to the pointer surface, hotspot_x and
	 * hotspot_y are decremented by the x and y parameters passed to
	 * the request. Attach must be confirmed by wl_surface.commit as
	 * usual.
	 *
	 * The hotspot can also be updated by passing the currently set
	 * pointer surface to this request with new values for hotspot_x
	 * and hotspot_y.
	 *
	 * The current and pending input regions of the wl_surface are
	 * cleared, and wl_surface.set_input_region is ignored until the
	 * wl_surface is no longer used as the cursor. When the use as a
	 * cursor ends, the current and pending input regions become
	 * undefined, and the wl_surface is unmapped.
	 *
	 * This request gives the surface the role of a wp_tablet_tool
	 * cursor. A surface may only ever be used as the cursor surface
	 * for one wp_tablet_tool. If the surface already has another role
	 * or has previously been used as cursor surface for a different
	 * tool, a protocol error is raised.
	 * @param serial serial of the proximity_in event
	 * @param hotspot_x surface-local x coordinate
	 * @param hotspot_y surface-local y coordinate
	 */
	void (*set_cursor)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t serial,
			   struct wl_resource *surface,
			   int32_t hotspot_x,
			   int32_t hotspot_y);
	/**
	 * destroy the tool object
	 *
	 * This destroys the client's resource for this tool object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_TOOL_V2_TYPE 0
#define ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL 1
#define ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM 2
#define ZWP_TABLET_TOOL_V2_CAPABILITY 3
#define ZWP_TABLET_TOOL_V2_DONE 4
#define ZWP_TABLET_TOOL_V2_REMOVED 5
#define ZWP_TABLET_TOOL_V2_PROXIMITY_IN 6
#define ZWP_TABLET_TOOL_V2_PROXIMITY_OUT 7
#define ZWP_TABLET_TOOL_V2_DOWN 8
#define ZWP_TABLET_TOOL_V2_UP 9
#define ZWP_TABLET_TOOL_V2_MOTION 10
#define ZWP_TABLET_TOOL_V2_PRESSURE 11
#define ZWP_TABLET_TOOL_V2_DISTANCE 12
#define ZWP_TABLET_TOOL_V2_TILT 13
#define ZWP_TABLET_TOOL_V2_ROTATION 14
#define ZWP_TABLET_TOOL_V2_SLIDER 15
#define ZWP_TABLET_TOOL_V2_WHEEL 16
#define ZWP_TABLET_TOOL_V2_BUTTON 17
#define ZWP_TABLET_TOOL_V2_FRAME 18

/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_CAPABILITY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_REMOVED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PROXIMITY_IN_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PROXIMITY_OUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_UP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PRESSURE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DISTANCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_TILT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_ROTATION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_SLIDER_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_WHEEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_SET_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an type event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tool_type the physical tool type
 */
static inline void
zwp_tablet_tool_v2_send_type(struct wl_resource *resource_, uint32_t tool_type)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_TYPE, tool_type);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an hardware_serial event to the client owning the resource.
 * @param resource_ The client's resource
 * @param hardware_serial_hi the unique serial number of the tool, most significant bits
 * @param hardware_serial_lo the unique serial number of the tool, least significant bits
 */
static inline void
zwp_tablet_tool_v2_send_hardware_serial(struct wl_resource *resource_, uint32_t hardware_serial_hi, uint32_t hardware_serial_lo)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL, hardware_serial_hi, hardware_serial_lo);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an hardware_id_wacom event to the client owning the resource.
 * @param resource_ The client's resource
 * @param hardware_id_hi the hardware id, most significant bits
 * @param hardware_id_lo the hardware id, least significant bits
 */
static inline void
zwp_tablet_tool_v2_send_hardware_id_wacom(struct wl_resource *resource_, uint32_t hardware_id_hi, uint32_t hardware_id_lo)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM, hardware_id_hi, hardware_id_lo);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an capability event to the client owning the resource.
 * @param resource_ The client's resource
 * @param capability the capability
 */
static inline void
zwp_tablet_tool_v2_send_capability(struct wl_resource *resource_, uint32_t capability)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_CAPABILITY, capability);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_tool_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_DONE);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_tool_v2_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_REMOVED);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an proximity_in event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tablet The tablet the tool is in proximity of
 * @param surface The current surface the tablet tool is over
 */
static inline void
zwp_tablet_tool_v2_send_proximity_in(struct wl_resource *resource_, uint32_t serial, struct wl_resource *tablet, struct wl_resource *surface)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_PROXIMITY_IN, serial, tablet, surface);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an proximity_out event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_tool_v2_send_proximity_out(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_PROXIMITY_OUT);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an down event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_tool_v2_send_down(struct wl_resource *resource_, uint32_t serial)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_DOWN, serial);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an up event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_tool_v2_send_up(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_UP);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an motion event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x surface-local x coordinate
 * @param y surface-local y coordinate
 */
static inline void
zwp_tablet_tool_v2_send_motion(struct wl_resource *resource_, wl_fixed_t x, wl_fixed_t y)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_MOTION, x, y);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an pressure event to the client owning the resource.
 * @param resource_ The client's resource
 * @param pressure The current pressure value
 */
static inline void
zwp_tablet_tool_v2_send_pressure(struct wl_resource *resource_, uint32_t pressure)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_PRESSURE, pressure);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an distance event to the client owning the resource.
 * @param resource_ The client's resource
 * @param distance The current distance value
 */
static inline void
zwp_tablet_tool_v2_send_distance(struct wl_resource *resource_, uint32_t distance)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_DISTANCE, distance);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an tilt event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tilt_x The current value of the X tilt axis
 * @param tilt_y The current value of the Y tilt axis
 */
static inline void
zwp_tablet_tool_v2_send_tilt(struct wl_resource *resource_, wl_fixed_t tilt_x, wl_fixed_t tilt_y)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_TILT, tilt_x, tilt_y);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an rotation event to the client owning the resource.
 * @param resource_ The client's resource
 * @param degrees The current rotation of the Z axis
 */
static inline void
zwp_tablet_tool_v2_send_rotation(struct wl_resource *resource_, wl_fixed_t degrees)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_ROTATION, degrees);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an slider event to the client owning the resource.
 * @param resource_ The client's resource
 * @param position The current position of slider
 */
static inline void
zwp_tablet_tool_v2_send_slider(struct wl_resource *resource_, int32_t position)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_SLIDER, position);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an wheel event to the client owning the resource.
 * @param resource_ The client's resource
 * @param degrees The wheel delta in degrees
 * @param clicks The wheel delta in discrete clicks
 */
static inline void
zwp_tablet_tool_v2_send_wheel(struct wl_resource *resource_, wl_fixed_t degrees, int32_t clicks)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_WHEEL, degrees, clicks);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an button event to the client owning the resource.
 * @param resource_ The client's resource
 * @param button The button whose state has changed
 * @param state Whether the button was pressed or released
 */
static inline void
zwp_tablet_tool_v2_send_button(struct wl_resource *resource_, uint32_t serial, uint32_t button, uint32_t state)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_BUTTON, serial, button, state);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * Sends an frame event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time The time of the event with millisecond granularity
 */
static inline void
zwp_tablet_tool_v2_send_frame(struct wl_resource *resource_, uint32_t time)
{
	wl_resource_post_event(resource_, ZWP_TABLET_TOOL_V2_FRAME, time);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * @struct zwp_tablet_v2_interface
 */
struct zwp_tablet_v2_interface {
	/**
	 * destroy the tablet object
	 *
	 * This destroys the client's resource for this tablet object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_V2_NAME 0
#define ZWP_TABLET_V2_ID 1
#define ZWP_TABLET_V2_PATH 2
#define ZWP_TABLET_V2_DONE 3
#define ZWP_TABLET_V2_REMOVED 4

/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_ID_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_PATH_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_v2
 * Sends an name event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name the device name
 */
static inline void
zwp_tablet_v2_send_name(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, ZWP_TABLET_V2_NAME, name);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * Sends an id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param vid USB vendor id
 * @param pid USB product id
 */
static inline void
zwp_tablet_v2_send_id(struct wl_resource *resource_, uint32_t vid, uint32_t pid)
{
	wl_resource_post_event(resource_, ZWP_TABLET_V2_ID, vid, pid);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * Sends an path event to the client owning the resource.
 * @param resource_ The client's resource
 * @param path path to local device
 */
static inline void
zwp_tablet_v2_send_path(struct wl_resource *resource_, const char *path)
{
	wl_resource_post_event(resource_, ZWP_TABLET_V2_PATH, path);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_V2_DONE);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_v2_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_V2_REMOVED);
}

#ifndef ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM
#define ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * ring axis source
 *
 * Describes the source types for ring events. This indicates to the
 * client how a ring event was physically generated; a client may
 * adjust the user interface accordingly. For example, events
 * from a "finger" source may trigger kinetic scrolling.
 */
enum zwp_tablet_pad_ring_v2_source {
	/**
	 * finger
	 */
	ZWP_TABLET_PAD_RING_V2_SOURCE_FINGER = 1,
};
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * Validate a zwp_tablet_pad_ring_v2 source value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_pad_ring_v2_source
 */
static inline bool
zwp_tablet_pad_ring_v2_source_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_PAD_RING_V2_SOURCE_FINGER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * @struct zwp_tablet_pad_ring_v2_interface
 */
struct zwp_tablet_pad_ring_v2_interface {
	/**
	 * set compositor feedback
	 *
	 * Request that the compositor use the provided feedback string
	 * associated with this ring. This request should be issued
	 * immediately after a wp_tablet_pad_group.mode_switch event from
	 * the corresponding group is received, or whenever the ring is
	 * mapped to a different action. See
	 * wp_tablet_pad_group.mode_switch for more details.
	 *
	 * Clients are encouraged to provide context-aware descriptions for
	 * the actions associated with the ring; compositors may use this
	 * information to offer visual feedback about the button layout
	 * (eg. on-screen displays).
	 *
	 * The provided string 'description' is a UTF-8 encoded string to
	 * be associated with this ring, and is considered user-visible;
	 * general internationalization rules apply.
	 *
	 * The serial argument will be that of the last
	 * wp_tablet_pad_group.mode_switch event received for the group of
	 * this ring. Requests providing other serials than the most recent
	 * one will be ignored.
	 * @param description ring description
	 * @param serial serial of the mode switch event
	 */
	void (*set_feedback)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *description,
			     uint32_t serial);
	/**
	 * destroy the ring object
	 *
	 * This destroys the client's resource for this ring object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_PAD_RING_V2_SOURCE 0
#define ZWP_TABLET_PAD_RING_V2_ANGLE 1
#define ZWP_TABLET_PAD_RING_V2_STOP 2
#define ZWP_TABLET_PAD_RING_V2_FRAME 3

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_ANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * Sends an source event to the client owning the resource.
 * @param resource_ The client's resource
 * @param source the event source
 */
static inline void
zwp_tablet_pad_ring_v2_send_source(struct wl_resource *resource_, uint32_t source)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_RING_V2_SOURCE, source);
}

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * Sends an angle event to the client owning the resource.
 * @param resource_ The client's resource
 * @param degrees the current angle in degrees
 */
static inline void
zwp_tablet_pad_ring_v2_send_angle(struct wl_resource *resource_, wl_fixed_t degrees)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_RING_V2_ANGLE, degrees);
}

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * Sends an stop event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_ring_v2_send_stop(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_RING_V2_STOP);
}

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * Sends an frame event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 */
static inline void
zwp_tablet_pad_ring_v2_send_frame(struct wl_resource *resource_, uint32_t time)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_RING_V2_FRAME, time);
}

#ifndef ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM
#define ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * strip axis source
 *
 * Describes the source types for strip events. This indicates to the
 * client how a strip event was physically generated; a client may
 * adjust the user interface accordingly. For example, events
 * from a "finger" source may trigger kinetic scrolling.
 */
enum zwp_tablet_pad_strip_v2_source {
	/**
	 * finger
	 */
	ZWP_TABLET_PAD_STRIP_V2_SOURCE_FINGER = 1,
};
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * Validate a zwp_tablet_pad_strip_v2 source value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_pad_strip_v2_source
 */
static inline bool
zwp_tablet_pad_strip_v2_source_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_PAD_STRIP_V2_SOURCE_FINGER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * @struct zwp_tablet_pad_strip_v2_interface
 */
struct zwp_tablet_pad_strip_v2_interface {
	/**
	 * set compositor feedback
	 *
	 * Requests the compositor to use the provided feedback string
	 * associated with this strip. This request should be issued
	 * immediately after a wp_tablet_pad_group.mode_switch event from
	 * the corresponding group is received, or whenever the strip is
	 * mapped to a different action. See
	 * wp_tablet_pad_group.mode_switch for more details.
	 *
	 * Clients are encouraged to provide context-aware descriptions for
	 * the actions associated with the strip, and compositors may use
	 * this information to offer visual feedback about the button
	 * layout (eg. on-screen displays).
	 *
	 * The provided string 'description' is a UTF-8 encoded string to
	 * be associated with this ring, and is considered user-visible;
	 * general internationalization rules apply.
	 *
	 * The serial argument will be that of the last
	 * wp_tablet_pad_group.mode_switch event received for the group of
	 * this strip. Requests providing other serials than the most
	 * recent one will be ignored.
	 * @param description strip description
	 * @param serial serial of the mode switch event
	 */
	void (*set_feedback)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *description,
			     uint32_t serial);
	/**
	 * destroy the strip object
	 *
	 * This destroys the client's resource for this strip object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_PAD_STRIP_V2_SOURCE 0
#define ZWP_TABLET_PAD_STRIP_V2_POSITION 1
#define ZWP_TABLET_PAD_STRIP_V2_STOP 2
#define ZWP_TABLET_PAD_STRIP_V2_FRAME 3

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * Sends an source event to the client owning the resource.
 * @param resource_ The client's resource
 * @param source the event source
 */
static inline void
zwp_tablet_pad_strip_v2_send_source(struct wl_resource *resource_, uint32_t source)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_STRIP_V2_SOURCE, source);
}

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * Sends an position event to the client owning the resource.
 * @param resource_ The client's resource
 * @param position the current position
 */
static inline void
zwp_tablet_pad_strip_v2_send_position(struct wl_resource *resource_, uint32_t position)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_STRIP_V2_POSITION, position);
}

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * Sends an stop event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_strip_v2_send_stop(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_STRIP_V2_STOP);
}

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * Sends an frame event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 */
static inline void
zwp_tablet_pad_strip_v2_send_frame(struct wl_resource *resource_, uint32_t time)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_STRIP_V2_FRAME, time);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * @struct zwp_tablet_pad_group_v2_interface
 */
struct zwp_tablet_pad_group_v2_interface {
	/**
	 * destroy the pad object
	 *
	 * Destroy the wp_tablet_pad_group object. Objects created from
	 * this object are unaffected and should be destroyed separately.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_PAD_GROUP_V2_BUTTONS 0
#define ZWP_TABLET_PAD_GROUP_V2_RING 1
#define ZWP_TABLET_PAD_GROUP_V2_STRIP 2
#define ZWP_TABLET_PAD_GROUP_V2_MODES 3
#define ZWP_TABLET_PAD_GROUP_V2_DONE 4
#define ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH 5

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_BUTTONS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_RING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_STRIP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_MODES_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an buttons event to the client owning the resource.
 * @param resource_ The client's resource
 * @param buttons buttons in this group
 */
static inline void
zwp_tablet_pad_group_v2_send_buttons(struct wl_resource *resource_, struct wl_array *buttons)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_BUTTONS, buttons);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an ring event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_group_v2_send_ring(struct wl_resource *resource_, struct wl_resource *ring)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_RING, ring);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an strip event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_group_v2_send_strip(struct wl_resource *resource_, struct wl_resource *strip)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_STRIP, strip);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an modes event to the client owning the resource.
 * @param resource_ The client's resource
 * @param modes the number of modes
 */
static inline void
zwp_tablet_pad_group_v2_send_modes(struct wl_resource *resource_, uint32_t modes)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_MODES, modes);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_group_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_DONE);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * Sends an mode_switch event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time the time of the event with millisecond granularity
 * @param mode the new mode of the pad
 */
static inline void
zwp_tablet_pad_group_v2_send_mode_switch(struct wl_resource *resource_, uint32_t time, uint32_t serial, uint32_t mode)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH, time, serial, mode);
}

#ifndef ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM
#define ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_v2
 * physical button state
 *
 * Describes the physical state of a button that caused the button
 * event.
 */
enum zwp_tablet_pad_v2_button_state {
	/**
	 * the button is not pressed
	 */
	ZWP_TABLET_PAD_V2_BUTTON_STATE_RELEASED = 0,
	/**
	 * the button is pressed
	 */
	ZWP_TABLET_PAD_V2_BUTTON_STATE_PRESSED = 1,
};
/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Validate a zwp_tablet_pad_v2 button_state value.
 *
 * @return true on success, false on error.
 * @ref zwp_tablet_pad_v2_button_state
 */
static inline bool
zwp_tablet_pad_v2_button_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_TABLET_PAD_V2_BUTTON_STATE_RELEASED:
		return version >= 1;
	case ZWP_TABLET_PAD_V2_BUTTON_STATE_PRESSED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * @struct zwp_tablet_pad_v2_interface
 */
struct zwp_tablet_pad_v2_interface {
	/**
	 * set compositor feedback
	 *
	 * Requests the compositor to use the provided feedback string
	 * associated with this button. This request should be issued
	 * immediately after a wp_tablet_pad_group.mode_switch event from
	 * the corresponding group is received, or whenever a button is
	 * mapped to a different action. See
	 * wp_tablet_pad_group.mode_switch for more details.
	 *
	 * Clients are encouraged to provide context-aware descriptions for
	 * the actions associated with each button, and compositors may use
	 * this information to offer visual feedback on the button layout
	 * (e.g. on-screen displays).
	 *
	 * Button indices start at 0. Setting the feedback string on a
	 * button that is reserved by the compositor (i.e. not belonging to
	 * any wp_tablet_pad_group) does not generate an error but the
	 * compositor is free to ignore the request.
	 *
	 * The provided string 'description' is a UTF-8 encoded string to
	 * be associated with this ring, and is considered user-visible;
	 * general internationalization rules apply.
	 *
	 * The serial argument will be that of the last
	 * wp_tablet_pad_group.mode_switch event received for the group of
	 * this button. Requests providing other serials than the most
	 * recent one will be ignored.
	 * @param button button index
	 * @param description button description
	 * @param serial serial of the mode switch event
	 */
	void (*set_feedback)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t button,
			     const char *description,
			     uint32_t serial);
	/**
	 * destroy the pad object
	 *
	 * Destroy the wp_tablet_pad object. Objects created from this
	 * object are unaffected and should be destroyed separately.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_TABLET_PAD_V2_GROUP 0
#define ZWP_TABLET_PAD_V2_PATH 1
#define ZWP_TABLET_PAD_V2_BUTTONS 2
#define ZWP_TABLET_PAD_V2_DONE 3
#define ZWP_TABLET_PAD_V2_BUTTON 4
#define ZWP_TABLET_PAD_V2_ENTER 5
#define ZWP_TABLET_PAD_V2_LEAVE 6
#define ZWP_TABLET_PAD_V2_REMOVED 7

/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_GROUP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_PATH_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_BUTTONS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an group event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_v2_send_group(struct wl_resource *resource_, struct wl_resource *pad_group)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_GROUP, pad_group);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an path event to the client owning the resource.
 * @param resource_ The client's resource
 * @param path path to local device
 */
static inline void
zwp_tablet_pad_v2_send_path(struct wl_resource *resource_, const char *path)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_PATH, path);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an buttons event to the client owning the resource.
 * @param resource_ The client's resource
 * @param buttons the number of buttons
 */
static inline void
zwp_tablet_pad_v2_send_buttons(struct wl_resource *resource_, uint32_t buttons)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_BUTTONS, buttons);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_DONE);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an button event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time the time of the event with millisecond granularity
 * @param button the index of the button that changed state
 */
static inline void
zwp_tablet_pad_v2_send_button(struct wl_resource *resource_, uint32_t time, uint32_t button, uint32_t state)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_BUTTON, time, button, state);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the enter event
 * @param tablet the tablet the pad is attached to
 * @param surface surface the pad is focused on
 */
static inline void
zwp_tablet_pad_v2_send_enter(struct wl_resource *resource_, uint32_t serial, struct wl_resource *tablet, struct wl_resource *surface)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_ENTER, serial, tablet, surface);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the leave event
 * @param surface surface the pad is no longer focused on
 */
static inline void
zwp_tablet_pad_v2_send_leave(struct wl_resource *resource_, uint32_t serial, struct wl_resource *surface)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_LEAVE, serial, surface);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_tablet_pad_v2_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_TABLET_PAD_V2_REMOVED);
}

#ifdef  __cplusplus
}
#endif

#endif
