pub struct ProcessManager;

impl magpie_platform::processes::ProcessManager for ProcessManager {
    fn new() -> Self
    where
        Self: Sized,
    {
        Self {}
    }

    fn terminate_processes(&self, pids: Vec<u32>) {
        for pid in pids {
            unsafe {
                libc::kill(pid as i32, libc::SIGTERM);
            }
        }
    }

    fn kill_processes(&self, pids: Vec<u32>) {
        for pid in pids {
            unsafe {
                libc::kill(pid as i32, libc::SIGKILL);
            }
        }
    }
}
