/* ExportFreemind.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportFreemind.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libxml/parser.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_FREEMIND (export_freemind_get_type ())
#define EXPORT_FREEMIND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_FREEMIND, ExportFreemind))
#define EXPORT_FREEMIND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_FREEMIND, ExportFreemindClass))
#define IS_EXPORT_FREEMIND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_FREEMIND))
#define IS_EXPORT_FREEMIND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_FREEMIND))
#define EXPORT_FREEMIND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_FREEMIND, ExportFreemindClass))

typedef struct _ExportFreemind ExportFreemind;
typedef struct _ExportFreemindClass ExportFreemindClass;
typedef struct _ExportFreemindPrivate ExportFreemindPrivate;
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CONNECTIONS (connections_get_type ())
#define CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTIONS, Connections))
#define CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTIONS, ConnectionsClass))
#define IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTIONS))
#define IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTIONS))
#define CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTIONS, ConnectionsClass))

typedef struct _Connections Connections;
typedef struct _ConnectionsClass ConnectionsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _connections_unref0(var) ((var == NULL) ? NULL : (var = (connections_unref (var), NULL)))

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_LINK_TYPE (link_type_get_type ())
#define LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE, LinkType))
#define IS_LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE))
#define LINK_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LINK_TYPE, LinkTypeIface))

typedef struct _LinkType LinkType;
typedef struct _LinkTypeIface LinkTypeIface;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_NODE_LINK_INFO (node_link_info_get_type ())
typedef struct _NodeLinkInfo NodeLinkInfo;
#define _node_link_unref0(var) ((var == NULL) ? NULL : (var = (node_link_unref (var), NULL)))

#define TYPE_LAYOUTS (layouts_get_type ())
#define LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUTS, Layouts))
#define LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUTS, LayoutsClass))
#define IS_LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUTS))
#define IS_LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUTS))
#define LAYOUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUTS, LayoutsClass))

typedef struct _Layouts Layouts;
typedef struct _LayoutsClass LayoutsClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

#define TYPE_LINK_TYPE_CURVED (link_type_curved_get_type ())
#define LINK_TYPE_CURVED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE_CURVED, LinkTypeCurved))
#define LINK_TYPE_CURVED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_TYPE_CURVED, LinkTypeCurvedClass))
#define IS_LINK_TYPE_CURVED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE_CURVED))
#define IS_LINK_TYPE_CURVED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_TYPE_CURVED))
#define LINK_TYPE_CURVED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_TYPE_CURVED, LinkTypeCurvedClass))

typedef struct _LinkTypeCurved LinkTypeCurved;
typedef struct _LinkTypeCurvedClass LinkTypeCurvedClass;

#define TYPE_LINK_TYPE_STRAIGHT (link_type_straight_get_type ())
#define LINK_TYPE_STRAIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraight))
#define LINK_TYPE_STRAIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraightClass))
#define IS_LINK_TYPE_STRAIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE_STRAIGHT))
#define IS_LINK_TYPE_STRAIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_TYPE_STRAIGHT))
#define LINK_TYPE_STRAIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_TYPE_STRAIGHT, LinkTypeStraightClass))

typedef struct _LinkTypeStraight LinkTypeStraight;
typedef struct _LinkTypeStraightClass LinkTypeStraightClass;

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportFreemind {
	Export parent_instance;
	ExportFreemindPrivate * priv;
};

struct _ExportFreemindClass {
	ExportClass parent_class;
};

struct _LinkTypeIface {
	GTypeInterface parent_iface;
	gchar* (*name) (LinkType* self);
	gchar* (*display_name) (LinkType* self);
	gchar* (*icon_name) (LinkType* self);
	void (*draw) (LinkType* self, cairo_t* ctx, Node* from_node, Node* to_node, gdouble from_x, gdouble from_y, gdouble to_x, gdouble to_y, gdouble* fx, gdouble* fy, gdouble* tx, gdouble* ty);
};

struct _NodeLinkInfo {
	gchar* id_str;
	Node* node;
};

static gpointer export_freemind_parent_class = NULL;
VALA_EXTERN gchar* minder_version;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_freemind_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportFreemind, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportFreemind* export_freemind_new (void);
VALA_EXTERN ExportFreemind* export_freemind_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_freemind_real_export (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static xmlNode* export_freemind_export_map (ExportFreemind* self,
                                     DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static xmlNode* export_freemind_export_node (ExportFreemind* self,
                                      Node* node,
                                      DrawArea* da);
VALA_EXTERN gint node_id (Node* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
VALA_EXTERN NodeLink* node_get_linked_node (Node* self);
VALA_EXTERN gint node_link_get_node_id (NodeLink* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gboolean node_is_in_sequence (Node* self);
VALA_EXTERN gboolean node_get_group (Node* self);
static xmlNode* export_freemind_export_cloud (ExportFreemind* self,
                                       Node* node,
                                       DrawArea* da);
static xmlNode* export_freemind_export_edge (ExportFreemind* self,
                                      Node* node,
                                      DrawArea* da);
static xmlNode* export_freemind_export_font (ExportFreemind* self,
                                      Node* node,
                                      DrawArea* da);
VALA_EXTERN const gchar* node_get_note (Node* self);
static xmlNode* export_freemind_export_note (ExportFreemind* self,
                                      Node* node);
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN gpointer connections_ref (gpointer instance);
VALA_EXTERN void connections_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_connections (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_connections (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_connections (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_connections (const GValue* value);
VALA_EXTERN GType connections_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connections, connections_unref)
VALA_EXTERN Connections* draw_area_get_connections (DrawArea* self);
VALA_EXTERN Connection* connections_get_attached_connection (Connections* self,
                                                 Node* node,
                                                 gint index);
VALA_EXTERN Node* connection_get_from_node (Connection* self);
static xmlNode* export_freemind_export_arrowlink (ExportFreemind* self,
                                           Connection* conn,
                                           DrawArea* da);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN GType link_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkType, g_object_unref)
VALA_EXTERN LinkType* style_get_link_type (Style* self);
VALA_EXTERN gchar* link_type_name (LinkType* self);
VALA_EXTERN gint* style_get_link_width (Style* self);
VALA_EXTERN PangoFontDescription* style_get_node_font (Style* self);
VALA_EXTERN gchar* utils_markdown_to_html (const gchar* md,
                               const gchar* tag);
VALA_EXTERN GdkRGBA* connection_get_color (Connection* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN Node* connection_get_to_node (Connection* self);
VALA_EXTERN Style* connection_get_style (Connection* self);
VALA_EXTERN const gchar* style_get_connection_arrow (Style* self);
static gboolean export_freemind_real_import (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static void export_freemind_import_map (ExportFreemind* self,
                                 DrawArea* da,
                                 xmlNode* n);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN GType node_link_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeLinkInfo* node_link_info_dup (const NodeLinkInfo* self);
VALA_EXTERN void node_link_info_free (NodeLinkInfo* self);
VALA_EXTERN void node_link_info_copy (const NodeLinkInfo* self,
                          NodeLinkInfo* dest);
VALA_EXTERN void node_link_info_destroy (NodeLinkInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NodeLinkInfo, node_link_info_destroy)
static void _node_link_info_free0_ (gpointer var);
static void _vala_NodeLinkInfo_free_function_content_of (gpointer data);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN Node* export_freemind_import_node (ExportFreemind* self,
                                   xmlNode* n,
                                   DrawArea* da,
                                   Node* parent,
                                   GeeHashMap* color_map,
                                   GeeHashMap* id_map,
                                   GArray* link_ids,
                                   GArray* to_nodes);
VALA_EXTERN void draw_area_position_root_node (DrawArea* self,
                                   Node* node);
VALA_EXTERN NodeLink* node_link_new_for_local (gint id);
VALA_EXTERN NodeLink* node_link_construct_for_local (GType object_type,
                                         gint id);
VALA_EXTERN void node_set_linked_node (Node* self,
                           NodeLink* value);
VALA_EXTERN Node* draw_area_get_node (DrawArea* self,
                          GArray* nodes,
                          gint id);
VALA_EXTERN void connections_complete_connection (Connections* self,
                                      gint index,
                                      Node* to_node);
VALA_EXTERN GType layouts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layouts, g_object_unref)
VALA_EXTERN Layouts* draw_area_get_layouts (DrawArea* self);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* layouts_get_default (Layouts* self);
VALA_EXTERN Node* node_new (DrawArea* da,
                Layout* layout);
VALA_EXTERN Node* node_construct (GType object_type,
                      DrawArea* da,
                      Layout* layout);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN Style* styles_get_style_for_level (Styles* self,
                                   guint level,
                                   Style* alternative);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN void formatted_text_insert_text (FormattedText* self,
                                 gint index,
                                 const gchar* str);
VALA_EXTERN void node_set_folded (Node* self,
                      gboolean value);
VALA_EXTERN void node_link_info_init (NodeLinkInfo *self,
                          const gchar* id,
                          Node* n);
VALA_EXTERN void node_set_link_color (Node* self,
                          GdkRGBA* value);
VALA_EXTERN GdkRGBA* theme_next_color (Theme* self);
VALA_EXTERN void node_set_side (Node* self,
                    NodeSide value);
VALA_EXTERN void node_set_sequence (Node* self,
                        gboolean value);
static void export_freemind_import_edge (ExportFreemind* self,
                                  xmlNode* n,
                                  Node* node);
static void export_freemind_import_font (ExportFreemind* self,
                                  xmlNode* n,
                                  Node* node);
static void export_freemind_import_cloud (ExportFreemind* self,
                                   xmlNode* n,
                                   Node* node);
static void export_freemind_import_arrowlink (ExportFreemind* self,
                                       xmlNode* n,
                                       DrawArea* da,
                                       Node* from_node,
                                       GArray* to_nodes);
static void export_freemind_import_richcontent (ExportFreemind* self,
                                         xmlNode* n,
                                         DrawArea* da,
                                         Node* node);
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
VALA_EXTERN LinkTypeCurved* link_type_curved_new (void);
VALA_EXTERN LinkTypeCurved* link_type_curved_construct (GType object_type);
VALA_EXTERN GType link_type_curved_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkTypeCurved, g_object_unref)
VALA_EXTERN void style_set_link_type (Style* self,
                          LinkType* value);
VALA_EXTERN LinkTypeStraight* link_type_straight_new (void);
VALA_EXTERN LinkTypeStraight* link_type_straight_construct (GType object_type);
VALA_EXTERN GType link_type_straight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkTypeStraight, g_object_unref)
VALA_EXTERN void style_set_link_width (Style* self,
                           gint* value);
VALA_EXTERN void node_set_group (Node* self,
                     gboolean value);
VALA_EXTERN Connection* connection_new (DrawArea* da,
                            Node* from_node);
VALA_EXTERN Connection* connection_construct (GType object_type,
                                  DrawArea* da,
                                  Node* from_node);
VALA_EXTERN void style_set_connection_arrow (Style* self,
                                 const gchar* value);
VALA_EXTERN void connections_add_connection (Connections* self,
                                 Connection* conn);
VALA_EXTERN void html_to_markdown_reset (gboolean ext);
VALA_EXTERN gchar* html_to_markdown_parse_xml (xmlNode* n);
VALA_EXTERN void node_set_note (Node* self,
                    const gchar* value);
static GType export_freemind_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportFreemind*
export_freemind_construct (GType object_type)
{
	ExportFreemind* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".mm");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportFreemind*) export_construct (object_type, "freemind", _ ("Freemind"), _tmp2_, (gint) 1, TRUE, TRUE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportFreemind*
export_freemind_new (void)
{
	return export_freemind_construct (TYPE_EXPORT_FREEMIND);
}

static gboolean
export_freemind_real_export (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportFreemind * self;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlNode* _tmp1_;
	gboolean result;
	self = (ExportFreemind*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = xmlNewDoc ((xmlChar*) "1.0");
	doc = _tmp0_;
	_tmp1_ = export_freemind_export_map (self, da);
	xmlDocSetRootElement (doc, _tmp1_);
	xmlSaveFormatFile (fname, doc, 1);
	_xmlFreeDoc0 (doc);
	result = FALSE;
	return result;
}

static xmlNode*
export_freemind_export_map (ExportFreemind* self,
                            DrawArea* da)
{
	xmlNode* map = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	xmlNode* _tmp8_;
	GArray* nodes = NULL;
	GArray* _tmp9_;
	xmlNode* _tmp17_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "map");
	map = _tmp0_;
	_tmp1_ = map;
	xmlNewProp (_tmp1_, (xmlChar*) "version", (xmlChar*) "1.0.1");
	_tmp2_ = map;
	_tmp3_ = g_strconcat (_ ("Generated by Minder"), " ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = minder_version;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = xmlNewComment ((xmlChar*) _tmp7_);
	xmlAddChild (_tmp2_, _tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_tmp9_ = draw_area_get_nodes (da);
	nodes = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				GArray* _tmp12_;
				xmlNode* _tmp13_;
				GArray* _tmp14_;
				Node* _tmp15_;
				xmlNode* _tmp16_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = nodes;
				if (!(((guint) i) < _tmp12_->len)) {
					break;
				}
				_tmp13_ = map;
				_tmp14_ = nodes;
				_tmp15_ = g_array_index (_tmp14_, Node*, (guint) i);
				_tmp16_ = export_freemind_export_node (self, _tmp15_, da);
				xmlAddChild (_tmp13_, _tmp16_);
			}
		}
	}
	_tmp17_ = map;
	result = _tmp17_;
	_g_array_unref0 (nodes);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static xmlNode*
export_freemind_export_node (ExportFreemind* self,
                             Node* node,
                             DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	xmlNode* _tmp6_;
	CanvasText* _tmp7_;
	CanvasText* _tmp8_;
	FormattedText* _tmp9_;
	FormattedText* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	NodeLink* _tmp13_;
	NodeLink* _tmp14_;
	xmlNode* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GdkRGBA* _tmp29_;
	GdkRGBA* _tmp30_;
	const gchar* _tmp37_ = NULL;
	NodeSide _tmp38_;
	NodeSide _tmp39_;
	xmlNode* _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	xmlNode* _tmp46_;
	xmlNode* _tmp47_;
	xmlNode* _tmp48_;
	xmlNode* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gint index = 0;
	Connection* conn = NULL;
	xmlNode* _tmp77_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "node");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = g_strdup_printf ("%i", node_id (node));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("id_", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	xmlNewProp (_tmp1_, (xmlChar*) "ID", (xmlChar*) _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = n;
	_tmp7_ = node_get_name (node);
	_tmp8_ = _tmp7_;
	_tmp9_ = canvas_text_get_text (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = formatted_text_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	xmlNewProp (_tmp6_, (xmlChar*) "TEXT", (xmlChar*) _tmp12_);
	_tmp13_ = node_get_linked_node (node);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		xmlNode* _tmp15_;
		NodeLink* _tmp16_;
		NodeLink* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp15_ = n;
		_tmp16_ = node_get_linked_node (node);
		_tmp17_ = _tmp16_;
		_tmp18_ = node_link_get_node_id (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("#id_", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		xmlNewProp (_tmp15_, (xmlChar*) "LINK", (xmlChar*) _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
	}
	_tmp24_ = n;
	_tmp25_ = node_get_folded (node);
	_tmp26_ = _tmp25_;
	_tmp27_ = bool_to_string (_tmp26_);
	_tmp28_ = _tmp27_;
	xmlNewProp (_tmp24_, (xmlChar*) "FOLDED", (xmlChar*) _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = node_get_link_color (node);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		xmlNode* _tmp31_;
		GdkRGBA* _tmp32_;
		GdkRGBA* _tmp33_;
		GdkRGBA _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = n;
		_tmp32_ = node_get_link_color (node);
		_tmp33_ = _tmp32_;
		_tmp34_ = *_tmp33_;
		_tmp35_ = utils_color_from_rgba (&_tmp34_);
		_tmp36_ = _tmp35_;
		xmlNewProp (_tmp31_, (xmlChar*) "COLOR", (xmlChar*) _tmp36_);
		_g_free0 (_tmp36_);
	}
	_tmp38_ = node_get_side (node);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NODE_SIDE_LEFT) {
		_tmp37_ = "left";
	} else {
		_tmp37_ = "right";
	}
	_tmp40_ = n;
	xmlNewProp (_tmp40_, (xmlChar*) "POSITION", (xmlChar*) _tmp37_);
	if (node_is_in_sequence (node)) {
		xmlNode* _tmp41_;
		_tmp41_ = n;
		xmlNewProp (_tmp41_, (xmlChar*) "NUMBERED", (xmlChar*) "true");
	}
	_tmp42_ = node_get_group (node);
	_tmp43_ = _tmp42_;
	if (_tmp43_) {
		xmlNode* _tmp44_;
		xmlNode* _tmp45_;
		_tmp44_ = n;
		_tmp45_ = export_freemind_export_cloud (self, node, da);
		xmlAddChild (_tmp44_, _tmp45_);
	}
	_tmp46_ = n;
	_tmp47_ = export_freemind_export_edge (self, node, da);
	xmlAddChild (_tmp46_, _tmp47_);
	_tmp48_ = n;
	_tmp49_ = export_freemind_export_font (self, node, da);
	xmlAddChild (_tmp48_, _tmp49_);
	_tmp50_ = node_get_note (node);
	_tmp51_ = _tmp50_;
	if (g_strcmp0 (_tmp51_, "") != 0) {
		xmlNode* _tmp52_;
		xmlNode* _tmp53_;
		_tmp52_ = n;
		_tmp53_ = export_freemind_export_note (self, node);
		xmlAddChild (_tmp52_, _tmp53_);
	}
	index = 0;
	conn = NULL;
	while (TRUE) {
		Connections* _tmp54_;
		Connections* _tmp55_;
		Node* _tmp56_;
		gint _tmp57_;
		Connection* _tmp58_;
		Connection* _tmp59_;
		gboolean _tmp60_;
		Connection* _tmp61_;
		Node* _tmp62_;
		Node* _tmp63_;
		_tmp54_ = draw_area_get_connections (da);
		_tmp55_ = _tmp54_;
		_tmp56_ = node;
		_tmp57_ = index;
		index = _tmp57_ + 1;
		_tmp58_ = connections_get_attached_connection (_tmp55_, _tmp56_, _tmp57_);
		_g_object_unref0 (conn);
		conn = _tmp58_;
		_tmp59_ = conn;
		_tmp60_ = !(_tmp59_ != NULL);
		_connections_unref0 (_tmp55_);
		if (_tmp60_) {
			break;
		}
		_tmp61_ = conn;
		_tmp62_ = connection_get_from_node (_tmp61_);
		_tmp63_ = _tmp62_;
		if (_tmp63_ == node) {
			xmlNode* _tmp64_;
			Connection* _tmp65_;
			xmlNode* _tmp66_;
			_tmp64_ = n;
			_tmp65_ = conn;
			_tmp66_ = export_freemind_export_arrowlink (self, _tmp65_, da);
			xmlAddChild (_tmp64_, _tmp66_);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				GArray* _tmp69_;
				GArray* _tmp70_;
				gboolean _tmp71_;
				xmlNode* _tmp72_;
				GArray* _tmp73_;
				GArray* _tmp74_;
				Node* _tmp75_;
				xmlNode* _tmp76_;
				if (!_tmp67_) {
					gint _tmp68_;
					_tmp68_ = i;
					i = _tmp68_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp69_ = node_children (node);
				_tmp70_ = _tmp69_;
				_tmp71_ = !(((guint) i) < _tmp70_->len);
				_g_array_unref0 (_tmp70_);
				if (_tmp71_) {
					break;
				}
				_tmp72_ = n;
				_tmp73_ = node_children (node);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_array_index (_tmp74_, Node*, (guint) i);
				_tmp76_ = export_freemind_export_node (self, _tmp75_, da);
				xmlAddChild (_tmp72_, _tmp76_);
				_g_array_unref0 (_tmp74_);
			}
		}
	}
	_tmp77_ = n;
	result = _tmp77_;
	_g_object_unref0 (conn);
	return result;
}

static xmlNode*
export_freemind_export_cloud (ExportFreemind* self,
                              Node* node,
                              DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "cloud");
	n = _tmp0_;
	result = n;
	return result;
}

static xmlNode*
export_freemind_export_edge (ExportFreemind* self,
                             Node* node,
                             DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	const gchar* _tmp1_ = NULL;
	Style* _tmp2_;
	Style* _tmp3_;
	LinkType* _tmp4_;
	LinkType* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	xmlNode* _tmp9_;
	GdkRGBA* _tmp10_;
	GdkRGBA* _tmp11_;
	xmlNode* _tmp18_;
	Style* _tmp19_;
	Style* _tmp20_;
	gint* _tmp21_;
	gint* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	xmlNode* _tmp25_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "edge");
	n = _tmp0_;
	_tmp2_ = node_get_style (node);
	_tmp3_ = _tmp2_;
	_tmp4_ = style_get_link_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = link_type_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "curved") == 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		_tmp1_ = "bezier";
	} else {
		_tmp1_ = "linear";
	}
	_tmp9_ = n;
	xmlNewProp (_tmp9_, (xmlChar*) "STYLE", (xmlChar*) _tmp1_);
	_tmp10_ = node_get_link_color (node);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		xmlNode* _tmp12_;
		GdkRGBA* _tmp13_;
		GdkRGBA* _tmp14_;
		GdkRGBA _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp12_ = n;
		_tmp13_ = node_get_link_color (node);
		_tmp14_ = _tmp13_;
		_tmp15_ = *_tmp14_;
		_tmp16_ = utils_color_from_rgba (&_tmp15_);
		_tmp17_ = _tmp16_;
		xmlNewProp (_tmp12_, (xmlChar*) "COLOR", (xmlChar*) _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = n;
	_tmp19_ = node_get_style (node);
	_tmp20_ = _tmp19_;
	_tmp21_ = style_get_link_width (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf ("%i", *_tmp22_);
	_tmp24_ = _tmp23_;
	xmlNewProp (_tmp18_, (xmlChar*) "WIDTH", (xmlChar*) _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = n;
	result = _tmp25_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static xmlNode*
export_freemind_export_font (ExportFreemind* self,
                             Node* node,
                             DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	Style* _tmp2_;
	Style* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp5_;
	const gchar* _tmp6_;
	xmlNode* _tmp7_;
	Style* _tmp8_;
	Style* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoFontDescription* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	CanvasText* _tmp15_;
	CanvasText* _tmp16_;
	FormattedText* _tmp17_;
	FormattedText* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	xmlNode* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	CanvasText* _tmp36_;
	CanvasText* _tmp37_;
	FormattedText* _tmp38_;
	FormattedText* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	xmlNode* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	xmlNode* _tmp56_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "font");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = node_get_style (node);
	_tmp3_ = _tmp2_;
	_tmp4_ = style_get_node_font (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = pango_font_description_get_family (_tmp5_);
	xmlNewProp (_tmp1_, (xmlChar*) "NAME", (xmlChar*) _tmp6_);
	_tmp7_ = n;
	_tmp8_ = node_get_style (node);
	_tmp9_ = _tmp8_;
	_tmp10_ = style_get_node_font (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", pango_font_description_get_size (_tmp11_) / PANGO_SCALE);
	_tmp13_ = _tmp12_;
	xmlNewProp (_tmp7_, (xmlChar*) "SIZE", (xmlChar*) _tmp13_);
	_g_free0 (_tmp13_);
	_tmp15_ = node_get_name (node);
	_tmp16_ = _tmp15_;
	_tmp17_ = canvas_text_get_text (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = formatted_text_get_text (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_substring (_tmp20_, (glong) 0, (glong) 3);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strcmp0 (_tmp22_, "<b>") == 0;
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		_tmp14_ = TRUE;
	} else {
		CanvasText* _tmp24_;
		CanvasText* _tmp25_;
		FormattedText* _tmp26_;
		FormattedText* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = node_get_name (node);
		_tmp25_ = _tmp24_;
		_tmp26_ = canvas_text_get_text (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = formatted_text_get_text (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = string_substring (_tmp29_, (glong) 0, (glong) 6);
		_tmp31_ = _tmp30_;
		_tmp14_ = g_strcmp0 (_tmp31_, "<i><b>") == 0;
		_g_free0 (_tmp31_);
	}
	_tmp32_ = n;
	_tmp33_ = bool_to_string (_tmp14_);
	_tmp34_ = _tmp33_;
	xmlNewProp (_tmp32_, (xmlChar*) "BOLD", (xmlChar*) _tmp34_);
	_g_free0 (_tmp34_);
	_tmp36_ = node_get_name (node);
	_tmp37_ = _tmp36_;
	_tmp38_ = canvas_text_get_text (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = formatted_text_get_text (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_substring (_tmp41_, (glong) 0, (glong) 3);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strcmp0 (_tmp43_, "<i>") == 0;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		_tmp35_ = TRUE;
	} else {
		CanvasText* _tmp45_;
		CanvasText* _tmp46_;
		FormattedText* _tmp47_;
		FormattedText* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp45_ = node_get_name (node);
		_tmp46_ = _tmp45_;
		_tmp47_ = canvas_text_get_text (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = formatted_text_get_text (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = string_substring (_tmp50_, (glong) 0, (glong) 6);
		_tmp52_ = _tmp51_;
		_tmp35_ = g_strcmp0 (_tmp52_, "<b><i>") == 0;
		_g_free0 (_tmp52_);
	}
	_tmp53_ = n;
	_tmp54_ = bool_to_string (_tmp35_);
	_tmp55_ = _tmp54_;
	xmlNewProp (_tmp53_, (xmlChar*) "ITALIC", (xmlChar*) _tmp55_);
	_g_free0 (_tmp55_);
	_tmp56_ = n;
	result = _tmp56_;
	return result;
}

static xmlNode*
export_freemind_export_note (ExportFreemind* self,
                             Node* node)
{
	xmlNode* rc = NULL;
	xmlNode* _tmp0_;
	xmlNode* html = NULL;
	xmlNode* _tmp1_;
	xmlNode* head = NULL;
	xmlNode* _tmp2_;
	gchar* note_html = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	xmlDoc* note_doc = NULL;
	gint _tmp6_;
	gint _tmp7_;
	xmlDoc* _tmp8_;
	xmlNode* body = NULL;
	xmlNode* _tmp9_;
	xmlNode* _tmp10_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "richcontent");
	rc = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "html");
	html = _tmp1_;
	_tmp2_ = xmlNewNode (NULL, (xmlChar*) "head");
	head = _tmp2_;
	_tmp3_ = node_get_note (node);
	_tmp4_ = _tmp3_;
	_tmp5_ = utils_markdown_to_html (_tmp4_, "body");
	note_html = _tmp5_;
	_tmp6_ = strlen (note_html);
	_tmp7_ = _tmp6_;
	_tmp8_ = xmlParseMemory (note_html, _tmp7_);
	note_doc = _tmp8_;
	_tmp9_ = xmlDocGetRootElement (note_doc);
	_tmp10_ = xmlCopyNode (_tmp9_, 1);
	body = _tmp10_;
	xmlAddChild (html, head);
	xmlAddChild (html, body);
	xmlNewProp (rc, (xmlChar*) "TYPE", (xmlChar*) "NOTE");
	xmlAddChild (rc, html);
	_xmlFreeDoc0 (note_doc);
	result = rc;
	_g_free0 (note_html);
	return result;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static xmlNode*
export_freemind_export_arrowlink (ExportFreemind* self,
                                  Connection* conn,
                                  DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	xmlNode* _tmp17_;
	Node* _tmp18_;
	Node* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	Style* _tmp26_;
	Style* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	xmlNode* _tmp34_;
	const gchar* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	Style* _tmp37_;
	Style* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	xmlNode* _tmp45_;
	xmlNode* _tmp46_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conn != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "arrowlink");
	n = _tmp0_;
	_tmp1_ = connection_get_color (conn);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		xmlNode* _tmp3_;
		GdkRGBA* _tmp4_;
		GdkRGBA* _tmp5_;
		GdkRGBA _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = n;
		_tmp4_ = connection_get_color (conn);
		_tmp5_ = _tmp4_;
		_tmp6_ = *_tmp5_;
		_tmp7_ = utils_color_from_rgba (&_tmp6_);
		_tmp8_ = _tmp7_;
		xmlNewProp (_tmp3_, (xmlChar*) "COLOR", (xmlChar*) _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		xmlNode* _tmp9_;
		Theme* _tmp10_;
		Theme* _tmp11_;
		GdkRGBA* _tmp12_;
		GdkRGBA* _tmp13_;
		GdkRGBA _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp9_ = n;
		_tmp10_ = draw_area_get_theme (da);
		_tmp11_ = _tmp10_;
		_tmp12_ = theme_get_color (_tmp11_, "connection_background");
		_tmp13_ = _tmp12_;
		_tmp14_ = *_tmp13_;
		_tmp15_ = utils_color_from_rgba (&_tmp14_);
		_tmp16_ = _tmp15_;
		xmlNewProp (_tmp9_, (xmlChar*) "COLOR", (xmlChar*) _tmp16_);
		_g_free0 (_tmp16_);
		__vala_GdkRGBA_free0 (_tmp13_);
		_g_object_unref0 (_tmp11_);
	}
	_tmp17_ = n;
	_tmp18_ = connection_get_to_node (conn);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%i", node_id (_tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("id_", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	xmlNewProp (_tmp17_, (xmlChar*) "DESTINATION", (xmlChar*) _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp26_ = connection_get_style (conn);
	_tmp27_ = _tmp26_;
	_tmp28_ = style_get_connection_arrow (_tmp27_);
	_tmp29_ = _tmp28_;
	if (g_strcmp0 (_tmp29_, "none") == 0) {
		_tmp25_ = TRUE;
	} else {
		Style* _tmp30_;
		Style* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp30_ = connection_get_style (conn);
		_tmp31_ = _tmp30_;
		_tmp32_ = style_get_connection_arrow (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp25_ = g_strcmp0 (_tmp33_, "fromto") == 0;
	}
	if (_tmp25_) {
		_tmp24_ = "None";
	} else {
		_tmp24_ = "Default";
	}
	_tmp34_ = n;
	xmlNewProp (_tmp34_, (xmlChar*) "STARTARROW", (xmlChar*) _tmp24_);
	_tmp37_ = connection_get_style (conn);
	_tmp38_ = _tmp37_;
	_tmp39_ = style_get_connection_arrow (_tmp38_);
	_tmp40_ = _tmp39_;
	if (g_strcmp0 (_tmp40_, "none") == 0) {
		_tmp36_ = TRUE;
	} else {
		Style* _tmp41_;
		Style* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp41_ = connection_get_style (conn);
		_tmp42_ = _tmp41_;
		_tmp43_ = style_get_connection_arrow (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp36_ = g_strcmp0 (_tmp44_, "tofrom") == 0;
	}
	if (_tmp36_) {
		_tmp35_ = "None";
	} else {
		_tmp35_ = "Default";
	}
	_tmp45_ = n;
	xmlNewProp (_tmp45_, (xmlChar*) "ENDARROW", (xmlChar*) _tmp35_);
	_tmp46_ = n;
	result = _tmp46_;
	return result;
}

static gboolean
export_freemind_real_import (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportFreemind * self;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlDoc* _tmp2_;
	xmlNode* _tmp3_;
	xmlDoc* _tmp4_;
	gboolean result;
	self = (ExportFreemind*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = xmlReadFile (fname, NULL, (gint) (XML_PARSE_HUGE | XML_PARSE_RECOVER));
	doc = _tmp0_;
	_tmp1_ = doc;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = doc;
	_tmp3_ = xmlDocGetRootElement (_tmp2_);
	export_freemind_import_map (self, da, _tmp3_);
	gtk_widget_queue_draw ((GtkWidget*) da);
	_tmp4_ = doc;
	_xmlFreeDoc0 (_tmp4_);
	result = TRUE;
	return result;
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static void
_node_link_info_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (node_link_info_free (var), NULL));
}

static void
_vala_NodeLinkInfo_free_function_content_of (gpointer data)
{
	NodeLinkInfo* self;
	self = *((NodeLinkInfo**) data);
	_node_link_info_free0_ (self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
export_freemind_import_map (ExportFreemind* self,
                            DrawArea* da,
                            xmlNode* n)
{
	GeeHashMap* color_map = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* id_map = NULL;
	GeeHashMap* _tmp1_;
	GArray* link_ids = NULL;
	GArray* _tmp2_;
	GArray* to_nodes = NULL;
	GArray* _tmp3_;
	gchar* v = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_rgba_get_type (), (GBoxedCopyFunc) _vala_GdkRGBA_copy, (GDestroyNotify) _vala_GdkRGBA_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	color_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	id_map = _tmp1_;
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (NodeLinkInfo*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_NodeLinkInfo_free_function_content_of);
	link_ids = _tmp2_;
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	to_nodes = _tmp3_;
	_tmp4_ = (gchar*) xmlGetProp (n, (xmlChar*) "version");
	v = _tmp4_;
	_tmp5_ = v;
	if (_tmp5_ != NULL) {
	}
	{
		xmlNode* it = NULL;
		xmlNode* _tmp6_;
		_tmp6_ = n->children;
		it = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp10_;
				xmlNode* _tmp11_;
				if (!_tmp7_) {
					xmlNode* _tmp8_;
					xmlNode* _tmp9_;
					_tmp8_ = it;
					_tmp9_ = _tmp8_->next;
					it = _tmp9_;
				}
				_tmp7_ = FALSE;
				_tmp10_ = it;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = it;
				if (_tmp11_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = it;
					_tmp13_ = _tmp12_->name;
					if (g_strcmp0 (_tmp13_, "node") == 0) {
						Node* root = NULL;
						xmlNode* _tmp14_;
						GeeHashMap* _tmp15_;
						GeeHashMap* _tmp16_;
						GArray* _tmp17_;
						GArray* _tmp18_;
						Node* _tmp19_;
						Node* _tmp20_;
						GArray* _tmp21_;
						GArray* _tmp22_;
						Node* _tmp23_;
						Node* _tmp24_;
						_tmp14_ = it;
						_tmp15_ = color_map;
						_tmp16_ = id_map;
						_tmp17_ = link_ids;
						_tmp18_ = to_nodes;
						_tmp19_ = export_freemind_import_node (self, _tmp14_, da, NULL, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
						root = _tmp19_;
						_tmp20_ = root;
						draw_area_position_root_node (da, _tmp20_);
						_tmp21_ = draw_area_get_nodes (da);
						_tmp22_ = _tmp21_;
						_tmp23_ = root;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						g_array_append_val (_tmp22_, _tmp24_);
						_g_array_unref0 (_tmp22_);
						_g_object_unref0 (root);
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				GArray* _tmp27_;
				GArray* _tmp28_;
				Node* _tmp29_;
				GeeHashMap* _tmp30_;
				GArray* _tmp31_;
				const gchar* _tmp32_;
				gpointer _tmp33_;
				NodeLink* _tmp34_;
				NodeLink* _tmp35_;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = link_ids;
				if (!(((guint) i) < _tmp27_->len)) {
					break;
				}
				_tmp28_ = link_ids;
				_tmp29_ = (*g_array_index (_tmp28_, NodeLinkInfo*, (guint) i)).node;
				_tmp30_ = id_map;
				_tmp31_ = link_ids;
				_tmp32_ = (*g_array_index (_tmp31_, NodeLinkInfo*, (guint) i)).id_str;
				_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp32_);
				_tmp34_ = node_link_new_for_local ((gint) ((gintptr) _tmp33_));
				_tmp35_ = _tmp34_;
				node_set_linked_node (_tmp29_, _tmp35_);
				_node_link_unref0 (_tmp35_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp36_ = FALSE;
			_tmp36_ = TRUE;
			while (TRUE) {
				GArray* _tmp38_;
				GeeHashMap* _tmp39_;
				GArray* _tmp40_;
				const gchar* _tmp41_;
				if (!_tmp36_) {
					gint _tmp37_;
					_tmp37_ = i;
					i = _tmp37_ + 1;
				}
				_tmp36_ = FALSE;
				_tmp38_ = to_nodes;
				if (!(((guint) i) < _tmp38_->len)) {
					break;
				}
				_tmp39_ = id_map;
				_tmp40_ = to_nodes;
				_tmp41_ = g_array_index (_tmp40_, gchar*, (guint) i);
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp39_, _tmp41_)) {
					Node* to_node = NULL;
					GArray* _tmp42_;
					GArray* _tmp43_;
					GeeHashMap* _tmp44_;
					GArray* _tmp45_;
					const gchar* _tmp46_;
					gpointer _tmp47_;
					Node* _tmp48_;
					Node* _tmp49_;
					Node* _tmp50_;
					_tmp42_ = draw_area_get_nodes (da);
					_tmp43_ = _tmp42_;
					_tmp44_ = id_map;
					_tmp45_ = to_nodes;
					_tmp46_ = g_array_index (_tmp45_, gchar*, (guint) i);
					_tmp47_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp44_, _tmp46_);
					_tmp48_ = draw_area_get_node (da, _tmp43_, (gint) ((gintptr) _tmp47_));
					_tmp49_ = _tmp48_;
					_g_array_unref0 (_tmp43_);
					to_node = _tmp49_;
					_tmp50_ = to_node;
					if (_tmp50_ != NULL) {
						Connections* _tmp51_;
						Connections* _tmp52_;
						Node* _tmp53_;
						_tmp51_ = draw_area_get_connections (da);
						_tmp52_ = _tmp51_;
						_tmp53_ = to_node;
						connections_complete_connection (_tmp52_, i, _tmp53_);
						_connections_unref0 (_tmp52_);
					}
					_g_object_unref0 (to_node);
				}
			}
		}
	}
	_g_free0 (v);
	_g_array_unref0 (to_nodes);
	_g_array_unref0 (link_ids);
	_g_object_unref0 (id_map);
	_g_object_unref0 (color_map);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gpointer
_node_link_info_dup0 (gpointer self)
{
	return self ? node_link_info_dup (self) : NULL;
}

Node*
export_freemind_import_node (ExportFreemind* self,
                             xmlNode* n,
                             DrawArea* da,
                             Node* parent,
                             GeeHashMap* color_map,
                             GeeHashMap* id_map,
                             GArray* link_ids,
                             GArray* to_nodes)
{
	Node* node = NULL;
	Layouts* _tmp0_;
	Layouts* _tmp1_;
	Layout* _tmp2_;
	Layout* _tmp3_;
	Node* _tmp4_;
	Node* _tmp5_;
	gint _tmp6_ = 0;
	Node* _tmp7_;
	Styles* _tmp8_;
	Style* _tmp9_;
	Style* _tmp10_;
	gchar* i = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* t = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* f = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* l = NULL;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	gchar* c = NULL;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* p = NULL;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* num = NULL;
	gchar* _tmp61_;
	gboolean _tmp62_ = FALSE;
	const gchar* _tmp63_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (color_map != NULL, NULL);
	g_return_val_if_fail (id_map != NULL, NULL);
	g_return_val_if_fail (link_ids != NULL, NULL);
	g_return_val_if_fail (to_nodes != NULL, NULL);
	_tmp0_ = draw_area_get_layouts (da);
	_tmp1_ = _tmp0_;
	_tmp2_ = layouts_get_default (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_new (da, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	node = _tmp5_;
	if (parent == NULL) {
		_tmp6_ = 0;
	} else {
		_tmp6_ = 1;
	}
	_tmp7_ = node;
	_tmp8_ = style_inspector_styles;
	_tmp9_ = styles_get_style_for_level (_tmp8_, (guint) _tmp6_, NULL);
	_tmp10_ = _tmp9_;
	node_set_style (_tmp7_, _tmp10_);
	_style_unref0 (_tmp10_);
	_tmp11_ = (gchar*) xmlGetProp (n, (xmlChar*) "ID");
	i = _tmp11_;
	_tmp12_ = i;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		Node* _tmp14_;
		_tmp13_ = i;
		_tmp14_ = node;
		gee_abstract_map_set ((GeeAbstractMap*) id_map, _tmp13_, (gpointer) ((gintptr) node_id (_tmp14_)));
	}
	_tmp15_ = (gchar*) xmlGetProp (n, (xmlChar*) "TEXT");
	t = _tmp15_;
	_tmp16_ = t;
	if (_tmp16_ != NULL) {
		Node* _tmp17_;
		CanvasText* _tmp18_;
		CanvasText* _tmp19_;
		FormattedText* _tmp20_;
		FormattedText* _tmp21_;
		const gchar* _tmp22_;
		_tmp17_ = node;
		_tmp18_ = node_get_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = canvas_text_get_text (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = t;
		formatted_text_insert_text (_tmp21_, 0, _tmp22_);
	}
	_tmp23_ = (gchar*) xmlGetProp (n, (xmlChar*) "FOLDED");
	f = _tmp23_;
	_tmp24_ = f;
	if (_tmp24_ != NULL) {
		Node* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = node;
		_tmp26_ = f;
		node_set_folded (_tmp25_, bool_parse (_tmp26_));
	}
	_tmp27_ = (gchar*) xmlGetProp (n, (xmlChar*) "LINK");
	l = _tmp27_;
	_tmp29_ = l;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp30_ = l;
		_tmp31_ = string_substring (_tmp30_, (glong) 0, (glong) 1);
		_tmp32_ = _tmp31_;
		_tmp28_ = g_strcmp0 (_tmp32_, "#") == 0;
		_g_free0 (_tmp32_);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		Node* _tmp36_;
		NodeLinkInfo _tmp37_ = {0};
		NodeLinkInfo _tmp38_;
		NodeLinkInfo* _tmp39_;
		_tmp33_ = l;
		_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
		_tmp35_ = _tmp34_;
		_tmp36_ = node;
		node_link_info_init (&_tmp37_, _tmp35_, _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _node_link_info_dup0 (&_tmp38_);
		g_array_append_val (link_ids, _tmp39_);
		node_link_info_destroy (&_tmp38_);
		_g_free0 (_tmp35_);
	}
	_tmp40_ = (gchar*) xmlGetProp (n, (xmlChar*) "COLOR");
	c = _tmp40_;
	_tmp41_ = c;
	if (_tmp41_ != NULL) {
		const gchar* _tmp42_;
		_tmp42_ = c;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) color_map, _tmp42_)) {
			Node* _tmp43_;
			const gchar* _tmp44_;
			gpointer _tmp45_;
			GdkRGBA* _tmp46_;
			_tmp43_ = node;
			_tmp44_ = c;
			_tmp45_ = gee_abstract_map_get ((GeeAbstractMap*) color_map, _tmp44_);
			_tmp46_ = (GdkRGBA*) _tmp45_;
			node_set_link_color (_tmp43_, _tmp46_);
			__vala_GdkRGBA_free0 (_tmp46_);
		} else {
			Node* _tmp47_;
			Theme* _tmp48_;
			Theme* _tmp49_;
			GdkRGBA* _tmp50_;
			GdkRGBA* _tmp51_;
			const gchar* _tmp52_;
			Node* _tmp53_;
			GdkRGBA* _tmp54_;
			GdkRGBA* _tmp55_;
			_tmp47_ = node;
			_tmp48_ = draw_area_get_theme (da);
			_tmp49_ = _tmp48_;
			_tmp50_ = theme_next_color (_tmp49_);
			_tmp51_ = _tmp50_;
			node_set_link_color (_tmp47_, _tmp51_);
			__vala_GdkRGBA_free0 (_tmp51_);
			_g_object_unref0 (_tmp49_);
			_tmp52_ = c;
			_tmp53_ = node;
			_tmp54_ = node_get_link_color (_tmp53_);
			_tmp55_ = _tmp54_;
			gee_abstract_map_set ((GeeAbstractMap*) color_map, _tmp52_, _tmp55_);
		}
	}
	_tmp56_ = (gchar*) xmlGetProp (n, (xmlChar*) "POSITION");
	p = _tmp56_;
	_tmp57_ = p;
	if (_tmp57_ != NULL) {
		NodeSide _tmp58_ = 0;
		const gchar* _tmp59_;
		Node* _tmp60_;
		_tmp59_ = p;
		if (g_strcmp0 (_tmp59_, "left") == 0) {
			_tmp58_ = NODE_SIDE_LEFT;
		} else {
			_tmp58_ = NODE_SIDE_RIGHT;
		}
		_tmp60_ = node;
		node_set_side (_tmp60_, _tmp58_);
	}
	_tmp61_ = (gchar*) xmlGetProp (n, (xmlChar*) "NUMBERED");
	num = _tmp61_;
	_tmp63_ = num;
	if (_tmp63_ != NULL) {
		_tmp62_ = parent != NULL;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		const gchar* _tmp64_;
		_tmp64_ = num;
		node_set_sequence (parent, bool_parse (_tmp64_));
	}
	{
		xmlNode* it = NULL;
		xmlNode* _tmp65_;
		_tmp65_ = n->children;
		it = _tmp65_;
		{
			gboolean _tmp66_ = FALSE;
			_tmp66_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp69_;
				xmlNode* _tmp70_;
				if (!_tmp66_) {
					xmlNode* _tmp67_;
					xmlNode* _tmp68_;
					_tmp67_ = it;
					_tmp68_ = _tmp67_->next;
					it = _tmp68_;
				}
				_tmp66_ = FALSE;
				_tmp69_ = it;
				if (!(_tmp69_ != NULL)) {
					break;
				}
				_tmp70_ = it;
				if (_tmp70_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					GQuark _tmp75_ = 0U;
					static GQuark _tmp74_label0 = 0;
					static GQuark _tmp74_label1 = 0;
					static GQuark _tmp74_label2 = 0;
					static GQuark _tmp74_label3 = 0;
					static GQuark _tmp74_label4 = 0;
					static GQuark _tmp74_label5 = 0;
					static GQuark _tmp74_label6 = 0;
					_tmp71_ = it;
					_tmp72_ = _tmp71_->name;
					_tmp73_ = _tmp72_;
					_tmp75_ = (NULL == _tmp73_) ? 0 : g_quark_from_string (_tmp73_);
					if (_tmp75_ == ((0 != _tmp74_label0) ? _tmp74_label0 : (_tmp74_label0 = g_quark_from_static_string ("node")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp76_;
								Node* _tmp77_;
								Node* _tmp78_;
								Node* _tmp79_;
								_tmp76_ = it;
								_tmp77_ = node;
								_tmp78_ = export_freemind_import_node (self, _tmp76_, da, _tmp77_, color_map, id_map, link_ids, to_nodes);
								_tmp79_ = _tmp78_;
								_g_object_unref0 (_tmp79_);
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label1) ? _tmp74_label1 : (_tmp74_label1 = g_quark_from_static_string ("edge")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp80_;
								Node* _tmp81_;
								_tmp80_ = it;
								_tmp81_ = node;
								export_freemind_import_edge (self, _tmp80_, _tmp81_);
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label2) ? _tmp74_label2 : (_tmp74_label2 = g_quark_from_static_string ("font")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp82_;
								Node* _tmp83_;
								_tmp82_ = it;
								_tmp83_ = node;
								export_freemind_import_font (self, _tmp82_, _tmp83_);
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label3) ? _tmp74_label3 : (_tmp74_label3 = g_quark_from_static_string ("icon")))) {
						switch (0) {
							default:
							{
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label4) ? _tmp74_label4 : (_tmp74_label4 = g_quark_from_static_string ("cloud")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp84_;
								Node* _tmp85_;
								_tmp84_ = it;
								_tmp85_ = node;
								export_freemind_import_cloud (self, _tmp84_, _tmp85_);
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label5) ? _tmp74_label5 : (_tmp74_label5 = g_quark_from_static_string ("arrowlink")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp86_;
								Node* _tmp87_;
								_tmp86_ = it;
								_tmp87_ = node;
								export_freemind_import_arrowlink (self, _tmp86_, da, _tmp87_, to_nodes);
								break;
							}
						}
					} else if (_tmp75_ == ((0 != _tmp74_label6) ? _tmp74_label6 : (_tmp74_label6 = g_quark_from_static_string ("richcontent")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp88_;
								Node* _tmp89_;
								_tmp88_ = it;
								_tmp89_ = node;
								export_freemind_import_richcontent (self, _tmp88_, da, _tmp89_);
								break;
							}
						}
					}
				}
			}
		}
	}
	if (parent != NULL) {
		Node* _tmp90_;
		Theme* _tmp91_;
		Theme* _tmp92_;
		_tmp90_ = node;
		_tmp91_ = draw_area_get_theme (da);
		_tmp92_ = _tmp91_;
		node_attach (_tmp90_, parent, -1, _tmp92_, TRUE);
		_g_object_unref0 (_tmp92_);
	}
	result = node;
	_g_free0 (num);
	_g_free0 (p);
	_g_free0 (c);
	_g_free0 (l);
	_g_free0 (f);
	_g_free0 (t);
	_g_free0 (i);
	return result;
}

static void
export_freemind_import_edge (ExportFreemind* self,
                             xmlNode* n,
                             Node* node)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* c = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* w = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "STYLE");
	s = _tmp0_;
	_tmp1_ = s;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GQuark _tmp5_ = 0U;
		static GQuark _tmp4_label0 = 0;
		static GQuark _tmp4_label1 = 0;
		_tmp2_ = s;
		_tmp3_ = _tmp2_;
		_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
		if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("bezier")))) {
			switch (0) {
				default:
				{
					Style* _tmp6_;
					Style* _tmp7_;
					LinkTypeCurved* _tmp8_;
					LinkTypeCurved* _tmp9_;
					_tmp6_ = node_get_style (node);
					_tmp7_ = _tmp6_;
					_tmp8_ = link_type_curved_new ();
					_tmp9_ = _tmp8_;
					style_set_link_type (_tmp7_, (LinkType*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("linear")))) {
			switch (0) {
				default:
				{
					Style* _tmp10_;
					Style* _tmp11_;
					LinkTypeStraight* _tmp12_;
					LinkTypeStraight* _tmp13_;
					_tmp10_ = node_get_style (node);
					_tmp11_ = _tmp10_;
					_tmp12_ = link_type_straight_new ();
					_tmp13_ = _tmp12_;
					style_set_link_type (_tmp11_, (LinkType*) _tmp13_);
					_g_object_unref0 (_tmp13_);
					break;
				}
			}
		}
	}
	_tmp14_ = (gchar*) xmlGetProp (n, (xmlChar*) "COLOR");
	c = _tmp14_;
	_tmp15_ = c;
	if (_tmp15_ != NULL) {
	}
	_tmp16_ = (gchar*) xmlGetProp (n, (xmlChar*) "WIDTH");
	w = _tmp16_;
	_tmp17_ = w;
	if (_tmp17_ != NULL) {
		Style* _tmp18_;
		Style* _tmp19_;
		const gchar* _tmp20_;
		gint _tmp21_;
		_tmp18_ = node_get_style (node);
		_tmp19_ = _tmp18_;
		_tmp20_ = w;
		_tmp21_ = atoi (_tmp20_);
		style_set_link_width (_tmp19_, &_tmp21_);
	}
	_g_free0 (w);
	_g_free0 (c);
	_g_free0 (s);
}

static void
export_freemind_import_font (ExportFreemind* self,
                             xmlNode* n,
                             Node* node)
{
	gchar* f = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* s = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* b = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* i = NULL;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "NAME");
	f = _tmp0_;
	_tmp1_ = f;
	if (_tmp1_ != NULL) {
		Style* _tmp2_;
		Style* _tmp3_;
		PangoFontDescription* _tmp4_;
		PangoFontDescription* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = node_get_style (node);
		_tmp3_ = _tmp2_;
		_tmp4_ = style_get_node_font (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = f;
		pango_font_description_set_family (_tmp5_, _tmp6_);
	}
	_tmp7_ = (gchar*) xmlGetProp (n, (xmlChar*) "SIZE");
	s = _tmp7_;
	_tmp8_ = s;
	if (_tmp8_ != NULL) {
		Style* _tmp9_;
		Style* _tmp10_;
		PangoFontDescription* _tmp11_;
		PangoFontDescription* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_ = node_get_style (node);
		_tmp10_ = _tmp9_;
		_tmp11_ = style_get_node_font (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = s;
		pango_font_description_set_size (_tmp12_, atoi (_tmp13_) * PANGO_SCALE);
	}
	_tmp14_ = (gchar*) xmlGetProp (n, (xmlChar*) "BOLD");
	b = _tmp14_;
	_tmp15_ = b;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		_tmp16_ = b;
		if (bool_parse (_tmp16_)) {
			CanvasText* _tmp17_;
			CanvasText* _tmp18_;
			FormattedText* _tmp19_;
			FormattedText* _tmp20_;
			CanvasText* _tmp21_;
			CanvasText* _tmp22_;
			FormattedText* _tmp23_;
			FormattedText* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp17_ = node_get_name (node);
			_tmp18_ = _tmp17_;
			_tmp19_ = canvas_text_get_text (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = node_get_name (node);
			_tmp22_ = _tmp21_;
			_tmp23_ = canvas_text_get_text (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = formatted_text_get_text (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat ("<b>", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, "</b>", NULL);
			_tmp30_ = _tmp29_;
			formatted_text_insert_text (_tmp20_, 0, _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
		}
	}
	_tmp31_ = (gchar*) xmlGetProp (n, (xmlChar*) "ITALIC");
	i = _tmp31_;
	_tmp32_ = i;
	if (_tmp32_ != NULL) {
		const gchar* _tmp33_;
		_tmp33_ = i;
		if (bool_parse (_tmp33_)) {
			CanvasText* _tmp34_;
			CanvasText* _tmp35_;
			FormattedText* _tmp36_;
			FormattedText* _tmp37_;
			CanvasText* _tmp38_;
			CanvasText* _tmp39_;
			FormattedText* _tmp40_;
			FormattedText* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp34_ = node_get_name (node);
			_tmp35_ = _tmp34_;
			_tmp36_ = canvas_text_get_text (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = node_get_name (node);
			_tmp39_ = _tmp38_;
			_tmp40_ = canvas_text_get_text (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = formatted_text_get_text (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat ("<i>", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp45_, "</i>", NULL);
			_tmp47_ = _tmp46_;
			formatted_text_insert_text (_tmp37_, 0, _tmp47_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp45_);
		}
	}
	_g_free0 (i);
	_g_free0 (b);
	_g_free0 (s);
	_g_free0 (f);
}

static void
export_freemind_import_cloud (ExportFreemind* self,
                              xmlNode* n,
                              Node* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	node_set_group (node, TRUE);
}

static void
export_freemind_import_arrowlink (ExportFreemind* self,
                                  xmlNode* n,
                                  DrawArea* da,
                                  Node* from_node,
                                  GArray* to_nodes)
{
	Connection* conn = NULL;
	Connection* _tmp0_;
	gchar* start_arrow = NULL;
	gchar* _tmp1_;
	gchar* end_arrow = NULL;
	gchar* _tmp2_;
	gchar* c = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* d = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* sa = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* ea = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GQuark _tmp22_ = 0U;
	static GQuark _tmp21_label0 = 0;
	static GQuark _tmp21_label1 = 0;
	static GQuark _tmp21_label2 = 0;
	static GQuark _tmp21_label3 = 0;
	Connections* _tmp35_;
	Connections* _tmp36_;
	Connection* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (from_node != NULL);
	g_return_if_fail (to_nodes != NULL);
	_tmp0_ = connection_new (da, from_node);
	conn = _tmp0_;
	_tmp1_ = g_strdup ("None");
	start_arrow = _tmp1_;
	_tmp2_ = g_strdup ("None");
	end_arrow = _tmp2_;
	_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "COLOR");
	c = _tmp3_;
	_tmp4_ = c;
	if (_tmp4_ != NULL) {
	}
	_tmp5_ = (gchar*) xmlGetProp (n, (xmlChar*) "DESTINATION");
	d = _tmp5_;
	_tmp6_ = d;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = d;
		_tmp8_ = g_strdup (_tmp7_);
		g_array_append_val (to_nodes, _tmp8_);
	}
	_tmp9_ = (gchar*) xmlGetProp (n, (xmlChar*) "STARTARROW");
	sa = _tmp9_;
	_tmp10_ = sa;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = sa;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (start_arrow);
		start_arrow = _tmp12_;
	}
	_tmp13_ = (gchar*) xmlGetProp (n, (xmlChar*) "ENDARROW");
	ea = _tmp13_;
	_tmp14_ = ea;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = ea;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (end_arrow);
		end_arrow = _tmp16_;
	}
	_tmp17_ = start_arrow;
	_tmp18_ = end_arrow;
	_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
	g_free (_tmp20_);
	if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("NoneNone")))) {
		switch (0) {
			default:
			{
				Connection* _tmp23_;
				Style* _tmp24_;
				Style* _tmp25_;
				_tmp23_ = conn;
				_tmp24_ = connection_get_style (_tmp23_);
				_tmp25_ = _tmp24_;
				style_set_connection_arrow (_tmp25_, "none");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("NoneDefault")))) {
		switch (0) {
			default:
			{
				Connection* _tmp26_;
				Style* _tmp27_;
				Style* _tmp28_;
				_tmp26_ = conn;
				_tmp27_ = connection_get_style (_tmp26_);
				_tmp28_ = _tmp27_;
				style_set_connection_arrow (_tmp28_, "fromto");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string ("DefaultNone")))) {
		switch (0) {
			default:
			{
				Connection* _tmp29_;
				Style* _tmp30_;
				Style* _tmp31_;
				_tmp29_ = conn;
				_tmp30_ = connection_get_style (_tmp29_);
				_tmp31_ = _tmp30_;
				style_set_connection_arrow (_tmp31_, "tofrom");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string ("DefaultDefault")))) {
		switch (0) {
			default:
			{
				Connection* _tmp32_;
				Style* _tmp33_;
				Style* _tmp34_;
				_tmp32_ = conn;
				_tmp33_ = connection_get_style (_tmp32_);
				_tmp34_ = _tmp33_;
				style_set_connection_arrow (_tmp34_, "both");
				break;
			}
		}
	}
	_tmp35_ = draw_area_get_connections (da);
	_tmp36_ = _tmp35_;
	_tmp37_ = conn;
	connections_add_connection (_tmp36_, _tmp37_);
	_connections_unref0 (_tmp36_);
	_g_free0 (ea);
	_g_free0 (sa);
	_g_free0 (d);
	_g_free0 (c);
	_g_free0 (end_arrow);
	_g_free0 (start_arrow);
	_g_object_unref0 (conn);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
export_freemind_import_richcontent (ExportFreemind* self,
                                    xmlNode* n,
                                    DrawArea* da,
                                    Node* node)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "TYPE");
	t = _tmp0_;
	_tmp2_ = t;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = t;
		_tmp1_ = g_strcmp0 (_tmp3_, "NOTE") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			xmlNode* it = NULL;
			xmlNode* _tmp4_;
			_tmp4_ = n->children;
			it = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					xmlNode* _tmp8_;
					gboolean _tmp9_ = FALSE;
					xmlNode* _tmp10_;
					if (!_tmp5_) {
						xmlNode* _tmp6_;
						xmlNode* _tmp7_;
						_tmp6_ = it;
						_tmp7_ = _tmp6_->next;
						it = _tmp7_;
					}
					_tmp5_ = FALSE;
					_tmp8_ = it;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp10_ = it;
					if (_tmp10_->type == XML_ELEMENT_NODE) {
						xmlNode* _tmp11_;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp11_ = it;
						_tmp12_ = _tmp11_->name;
						_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
						_tmp14_ = _tmp13_;
						_tmp9_ = g_strcmp0 (_tmp14_, "html") == 0;
						_g_free0 (_tmp14_);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						xmlNode* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						html_to_markdown_reset (TRUE);
						_tmp15_ = it;
						_tmp16_ = html_to_markdown_parse_xml (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = string_strip (_tmp17_);
						_tmp19_ = _tmp18_;
						node_set_note (node, _tmp19_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp17_);
					}
				}
			}
		}
	}
	_g_free0 (t);
}

static void
export_freemind_class_init (ExportFreemindClass * klass,
                            gpointer klass_data)
{
	export_freemind_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_freemind_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_freemind_real_import;
}

static void
export_freemind_instance_init (ExportFreemind * self,
                               gpointer klass)
{
}

static GType
export_freemind_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportFreemindClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_freemind_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportFreemind), 0, (GInstanceInitFunc) export_freemind_instance_init, NULL };
	GType export_freemind_type_id;
	export_freemind_type_id = g_type_register_static (TYPE_EXPORT, "ExportFreemind", &g_define_type_info, 0);
	return export_freemind_type_id;
}

GType
export_freemind_get_type (void)
{
	static volatile gsize export_freemind_type_id__once = 0;
	if (g_once_init_enter (&export_freemind_type_id__once)) {
		GType export_freemind_type_id;
		export_freemind_type_id = export_freemind_get_type_once ();
		g_once_init_leave (&export_freemind_type_id__once, export_freemind_type_id);
	}
	return export_freemind_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

