/* ImageEditor.c generated by valac 0.56.18, the Vala compiler
 * generated from ImageEditor.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#define IMAGE_EDITOR_MIN_WIDTH ((gdouble) 50)
#define IMAGE_EDITOR_CROP_WIDTH 8
#define NODE_IMAGE_EDIT_WIDTH 600
#define NODE_IMAGE_EDIT_HEIGHT 600
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_IMAGE_EDITOR (image_editor_get_type ())
#define IMAGE_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_EDITOR, ImageEditor))
#define IMAGE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_EDITOR, ImageEditorClass))
#define IS_IMAGE_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_EDITOR))
#define IS_IMAGE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_EDITOR))
#define IMAGE_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_EDITOR, ImageEditorClass))

typedef struct _ImageEditor ImageEditor;
typedef struct _ImageEditorClass ImageEditorClass;
typedef struct _ImageEditorPrivate ImageEditorPrivate;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _image_manager_unref0(var) ((var == NULL) ? NULL : (var = (image_manager_unref (var), NULL)))
#define _node_image_unref0(var) ((var == NULL) ? NULL : (var = (node_image_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block22Data Block22Data;
#define _image_editor_unref0(var) ((var == NULL) ? NULL : (var = (image_editor_unref (var), NULL)))
typedef struct _Block23Data Block23Data;
typedef struct _ParamSpecImageEditor ParamSpecImageEditor;
enum  {
	IMAGE_EDITOR_CHANGED_SIGNAL,
	IMAGE_EDITOR_NUM_SIGNALS
};
static guint image_editor_signals[IMAGE_EDITOR_NUM_SIGNALS] = {0};

struct _ImageEditor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImageEditorPrivate * priv;
};

struct _ImageEditorClass {
	GTypeClass parent_class;
	void (*finalize) (ImageEditor *self);
};

struct _ImageEditorPrivate {
	GtkPopover* _popover;
	ImageManager* _im;
	GtkDrawingArea* _da;
	Node* _node;
	NodeImage* _image;
	GtkButton* _paste;
	gint _crop_target;
	gdouble _last_x;
	gdouble _last_y;
	GdkRectangle* _crop_points;
	gint _crop_points_length1;
	gint __crop_points_size_;
	GdkCursorType* _crop_cursors;
	gint _crop_cursors_length1;
	gint __crop_cursors_size_;
	GtkLabel* _status_cursor;
	GtkLabel* _status_crop;
};

struct _Block22Data {
	int _ref_count_;
	ImageEditor* self;
	GtkDrawingArea* da;
	ImageManager* im;
};

struct _Block23Data {
	int _ref_count_;
	ImageEditor* self;
	DrawArea* da;
	ImageManager* im;
};

struct _ParamSpecImageEditor {
	GParamSpec parent_instance;
};

static gint ImageEditor_private_offset;
static gpointer image_editor_parent_class = NULL;

VALA_EXTERN gpointer image_editor_ref (gpointer instance);
VALA_EXTERN void image_editor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_editor (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_image_editor (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_image_editor (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_image_editor (const GValue* value);
VALA_EXTERN GType image_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageEditor, image_editor_unref)
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN ImageEditor* image_editor_new (DrawArea* da);
VALA_EXTERN ImageEditor* image_editor_construct (GType object_type,
                                     DrawArea* da);
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN void image_editor_create_ui (ImageEditor* self,
                             DrawArea* da,
                             ImageManager* im);
VALA_EXTERN void image_editor_edit_image (ImageEditor* self,
                              ImageManager* im,
                              Node* node,
                              gdouble x,
                              gdouble y);
VALA_EXTERN NodeImage* node_get_image (Node* self);
VALA_EXTERN gint node_image_get_id (NodeImage* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_node_width (Style* self);
VALA_EXTERN NodeImage* node_image_new (ImageManager* im,
                           gint id,
                           gint width);
VALA_EXTERN NodeImage* node_image_construct (GType object_type,
                                 ImageManager* im,
                                 gint id,
                                 gint width);
VALA_EXTERN gboolean node_image_get_valid (NodeImage* self);
VALA_EXTERN gint node_image_get_crop_x (NodeImage* self);
VALA_EXTERN void node_image_set_crop_x (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_y (NodeImage* self);
VALA_EXTERN void node_image_set_crop_y (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_w (NodeImage* self);
VALA_EXTERN void node_image_set_crop_w (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_h (NodeImage* self);
VALA_EXTERN void node_image_set_crop_h (NodeImage* self,
                            gint value);
VALA_EXTERN cairo_surface_t* node_image_get_surface (NodeImage* self);
static void image_editor_set_crop_points (ImageEditor* self);
VALA_EXTERN void utils_show_popover (GtkPopover* popover);
static gboolean image_editor_initialize (ImageEditor* self,
                                  NodeImage* ni);
static void image_editor_set_cursor_location (ImageEditor* self,
                                       gint x,
                                       gint y);
static void image_editor_set_crop_target (ImageEditor* self,
                                   gdouble x,
                                   gdouble y);
static void image_editor_adjust_crop_points (ImageEditor* self,
                                      gint diffx,
                                      gint diffy);
VALA_EXTERN GtkDrawingArea* image_editor_create_drawing_area (ImageEditor* self,
                                                  ImageManager* im);
static GtkBox* image_editor_create_status_area (ImageEditor* self);
static GtkBox* image_editor_create_buttons (ImageEditor* self,
                                     DrawArea* da,
                                     ImageManager* im);
static gboolean __lambda64_ (ImageEditor* self,
                      GdkEventKey* e);
static void image_editor_action_copy (ImageEditor* self);
static void image_editor_action_paste (ImageEditor* self);
static void image_editor_action_cut (ImageEditor* self);
static void image_editor_action_apply (ImageEditor* self);
static void image_editor_action_cancel (ImageEditor* self);
static void image_editor_action_delete (ImageEditor* self);
static gboolean ___lambda64__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static gboolean __lambda65_ (ImageEditor* self,
                      GdkEventCrossing* e);
static void image_editor_update_ui (ImageEditor* self);
static gboolean ___lambda65__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gboolean __lambda58_ (ImageEditor* self,
                      cairo_t* ctx);
static void image_editor_draw_image (ImageEditor* self,
                              cairo_t* ctx);
static gboolean ___lambda58__gtk_widget_draw (GtkWidget* _sender,
                                       cairo_t* cr,
                                       gpointer self);
static gboolean __lambda59_ (ImageEditor* self,
                      GdkEventButton* e);
static gboolean ___lambda59__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda60_ (Block22Data* _data22_,
                      GdkEventMotion* e);
static void image_editor_set_cursor (ImageEditor* self,
                              GdkCursorType* type);
static gboolean ___lambda60__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                      GdkEventMotion* event,
                                                      gpointer self);
static gboolean __lambda61_ (ImageEditor* self,
                      GdkEventButton* e);
static gboolean ___lambda61__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void __lambda62_ (Block22Data* _data22_,
                  GdkDragContext* ctx,
                  gint x,
                  gint y,
                  GtkSelectionData* data,
                  guint info,
                  guint t);
VALA_EXTERN NodeImage* node_image_new_from_uri (ImageManager* im,
                                    const gchar* uri,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_uri (GType object_type,
                                          ImageManager* im,
                                          const gchar* uri,
                                          gint width);
static void ___lambda62__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
VALA_EXTERN gchar* utils_tooltip_with_accel (const gchar* tooltip,
                                 const gchar* accel);
static void __lambda63_ (Block23Data* _data23_);
VALA_EXTERN gint image_manager_choose_image (ImageManager* self,
                                 GtkWindow* parent);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _image_editor_action_cancel_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _image_editor_action_apply_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
static void _image_editor_action_copy_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self);
static void _image_editor_action_cut_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void _image_editor_action_paste_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
static void _image_editor_action_delete_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static gboolean _gdk_cursor_type_equal (const GdkCursorType * s1,
                                 const GdkCursorType * s2);
static void image_editor_draw_crop_point (ImageEditor* self,
                                   cairo_t* ctx,
                                   GdkRectangle* crop);
static void image_editor_remove_image (ImageEditor* self,
                                ImageManager* im);
VALA_EXTERN void node_set_image (Node* self,
                     ImageManager* im,
                     NodeImage* ni);
VALA_EXTERN void utils_hide_popover (GtkPopover* popover);
static void image_editor_set_image (ImageEditor* self,
                             ImageManager* im);
VALA_EXTERN void node_image_set_width (NodeImage* self,
                           gint width);
static gboolean image_editor_image_pasteable (ImageEditor* self);
VALA_EXTERN gchar* image_manager_get_file (ImageManager* self,
                               gint id);
VALA_EXTERN NodeImage* node_image_new_from_pixbuf (ImageManager* im,
                                       GdkPixbuf* buf,
                                       gint width);
VALA_EXTERN NodeImage* node_image_construct_from_pixbuf (GType object_type,
                                             ImageManager* im,
                                             GdkPixbuf* buf,
                                             gint width);
static void g_cclosure_user_marshal_VOID__NODE_IMAGE (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void image_editor_finalize (ImageEditor * obj);
static GType image_editor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GtkTargetEntry IMAGE_EDITOR_DRAG_TARGETS[1] = {{"text/uri-list", (guint) 0, (guint) 0}};

static inline gpointer
image_editor_get_instance_private (ImageEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ImageEditor_private_offset);
}

static gpointer
_image_manager_ref0 (gpointer self)
{
	return self ? image_manager_ref (self) : NULL;
}

ImageEditor*
image_editor_construct (GType object_type,
                        DrawArea* da)
{
	ImageEditor* self = NULL;
	ImageManager* _tmp0_;
	ImageManager* _tmp1_;
	ImageManager* _tmp2_;
	GdkRectangle* _tmp3_;
	GdkCursorType* _tmp4_;
	GdkCursorType* _tmp10_;
	gint _tmp10__length1;
	GdkCursorType* _tmp11_;
	gint _tmp11__length1;
	GdkCursorType* _tmp12_;
	gint _tmp12__length1;
	GdkCursorType* _tmp13_;
	gint _tmp13__length1;
	GdkCursorType* _tmp14_;
	gint _tmp14__length1;
	GdkCursorType* _tmp15_;
	gint _tmp15__length1;
	GdkCursorType* _tmp16_;
	gint _tmp16__length1;
	GdkCursorType* _tmp17_;
	gint _tmp17__length1;
	ImageManager* _tmp18_;
	ImageManager* _tmp19_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (ImageEditor*) g_type_create_instance (object_type);
	_tmp0_ = draw_area_get_image_manager (da);
	_tmp1_ = _tmp0_;
	_tmp2_ = _image_manager_ref0 (_tmp1_);
	_image_manager_unref0 (self->priv->_im);
	self->priv->_im = _tmp2_;
	_tmp3_ = g_new0 (GdkRectangle, 9);
	self->priv->_crop_points = (g_free (self->priv->_crop_points), NULL);
	self->priv->_crop_points = _tmp3_;
	self->priv->_crop_points_length1 = 9;
	self->priv->__crop_points_size_ = self->priv->_crop_points_length1;
	_tmp4_ = g_new0 (GdkCursorType, 8);
	self->priv->_crop_cursors = (g_free (self->priv->_crop_cursors), NULL);
	self->priv->_crop_cursors = _tmp4_;
	self->priv->_crop_cursors_length1 = 8;
	self->priv->__crop_cursors_size_ = self->priv->_crop_cursors_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GdkRectangle* _tmp7_;
				gint _tmp7__length1;
				GdkRectangle* _tmp8_;
				gint _tmp8__length1;
				GdkRectangle _tmp9_ = {0};
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->_crop_points;
				_tmp7__length1 = self->priv->_crop_points_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->_crop_points;
				_tmp8__length1 = self->priv->_crop_points_length1;
				_tmp9_.x = 0;
				_tmp9_.y = 0;
				_tmp9_.width = IMAGE_EDITOR_CROP_WIDTH;
				_tmp9_.height = IMAGE_EDITOR_CROP_WIDTH;
				_tmp8_[i] = _tmp9_;
			}
		}
	}
	_tmp10_ = self->priv->_crop_cursors;
	_tmp10__length1 = self->priv->_crop_cursors_length1;
	_tmp10_[0] = GDK_TOP_LEFT_CORNER;
	_tmp11_ = self->priv->_crop_cursors;
	_tmp11__length1 = self->priv->_crop_cursors_length1;
	_tmp11_[1] = GDK_SB_V_DOUBLE_ARROW;
	_tmp12_ = self->priv->_crop_cursors;
	_tmp12__length1 = self->priv->_crop_cursors_length1;
	_tmp12_[2] = GDK_TOP_RIGHT_CORNER;
	_tmp13_ = self->priv->_crop_cursors;
	_tmp13__length1 = self->priv->_crop_cursors_length1;
	_tmp13_[3] = GDK_SB_H_DOUBLE_ARROW;
	_tmp14_ = self->priv->_crop_cursors;
	_tmp14__length1 = self->priv->_crop_cursors_length1;
	_tmp14_[4] = GDK_SB_H_DOUBLE_ARROW;
	_tmp15_ = self->priv->_crop_cursors;
	_tmp15__length1 = self->priv->_crop_cursors_length1;
	_tmp15_[5] = GDK_TOP_RIGHT_CORNER;
	_tmp16_ = self->priv->_crop_cursors;
	_tmp16__length1 = self->priv->_crop_cursors_length1;
	_tmp16_[6] = GDK_SB_V_DOUBLE_ARROW;
	_tmp17_ = self->priv->_crop_cursors;
	_tmp17__length1 = self->priv->_crop_cursors_length1;
	_tmp17_[7] = GDK_TOP_LEFT_CORNER;
	_tmp18_ = draw_area_get_image_manager (da);
	_tmp19_ = _tmp18_;
	image_editor_create_ui (self, da, _tmp19_);
	return self;
}

ImageEditor*
image_editor_new (DrawArea* da)
{
	return image_editor_construct (TYPE_IMAGE_EDITOR, da);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
image_editor_edit_image (ImageEditor* self,
                         ImageManager* im,
                         Node* node,
                         gdouble x,
                         gdouble y)
{
	gint int_x = 0;
	gint int_y = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	GtkPopover* _tmp1_;
	GdkRectangle _tmp2_;
	Node* _tmp3_;
	NodeImage* _tmp4_;
	NodeImage* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	Node* _tmp8_;
	Style* _tmp9_;
	Style* _tmp10_;
	gint* _tmp11_;
	gint* _tmp12_;
	NodeImage* _tmp13_;
	NodeImage* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (im != NULL);
	g_return_if_fail (node != NULL);
	int_x = (gint) x;
	int_y = (gint) y;
	_tmp0_.x = int_x;
	_tmp0_.y = int_y;
	_tmp0_.width = 1;
	_tmp0_.height = 1;
	rect = _tmp0_;
	_tmp1_ = self->priv->_popover;
	_tmp2_ = rect;
	g_object_set (_tmp1_, "pointing-to", &_tmp2_, NULL);
	_tmp3_ = _g_object_ref0 (node);
	_g_object_unref0 (self->priv->_node);
	self->priv->_node = _tmp3_;
	_tmp4_ = node_get_image (node);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_image_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_node;
	_tmp9_ = node_get_style (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = style_get_node_width (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = node_image_new (im, _tmp7_, *_tmp12_);
	_node_image_unref0 (self->priv->_image);
	self->priv->_image = _tmp13_;
	_tmp14_ = self->priv->_image;
	_tmp15_ = node_image_get_valid (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		NodeImage* _tmp17_;
		NodeImage* _tmp18_;
		NodeImage* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		NodeImage* _tmp22_;
		NodeImage* _tmp23_;
		NodeImage* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		NodeImage* _tmp27_;
		NodeImage* _tmp28_;
		NodeImage* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		NodeImage* _tmp32_;
		NodeImage* _tmp33_;
		NodeImage* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		GtkDrawingArea* _tmp37_;
		NodeImage* _tmp38_;
		NodeImage* _tmp39_;
		cairo_surface_t* _tmp40_;
		cairo_surface_t* _tmp41_;
		GtkDrawingArea* _tmp42_;
		NodeImage* _tmp43_;
		NodeImage* _tmp44_;
		cairo_surface_t* _tmp45_;
		cairo_surface_t* _tmp46_;
		GdkRectangle* _tmp47_;
		gint _tmp47__length1;
		NodeImage* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		GdkRectangle* _tmp51_;
		gint _tmp51__length1;
		NodeImage* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		GtkDrawingArea* _tmp55_;
		GtkPopover* _tmp56_;
		_tmp17_ = self->priv->_image;
		_tmp18_ = node_get_image (node);
		_tmp19_ = _tmp18_;
		_tmp20_ = node_image_get_crop_x (_tmp19_);
		_tmp21_ = _tmp20_;
		node_image_set_crop_x (_tmp17_, _tmp21_);
		_tmp22_ = self->priv->_image;
		_tmp23_ = node_get_image (node);
		_tmp24_ = _tmp23_;
		_tmp25_ = node_image_get_crop_y (_tmp24_);
		_tmp26_ = _tmp25_;
		node_image_set_crop_y (_tmp22_, _tmp26_);
		_tmp27_ = self->priv->_image;
		_tmp28_ = node_get_image (node);
		_tmp29_ = _tmp28_;
		_tmp30_ = node_image_get_crop_w (_tmp29_);
		_tmp31_ = _tmp30_;
		node_image_set_crop_w (_tmp27_, _tmp31_);
		_tmp32_ = self->priv->_image;
		_tmp33_ = node_get_image (node);
		_tmp34_ = _tmp33_;
		_tmp35_ = node_image_get_crop_h (_tmp34_);
		_tmp36_ = _tmp35_;
		node_image_set_crop_h (_tmp32_, _tmp36_);
		_tmp37_ = self->priv->_da;
		_tmp38_ = node_get_image (node);
		_tmp39_ = _tmp38_;
		_tmp40_ = node_image_get_surface (_tmp39_);
		_tmp41_ = _tmp40_;
		g_object_set ((GtkWidget*) _tmp37_, "width-request", cairo_image_surface_get_width (_tmp41_), NULL);
		_cairo_surface_destroy0 (_tmp41_);
		_tmp42_ = self->priv->_da;
		_tmp43_ = node_get_image (node);
		_tmp44_ = _tmp43_;
		_tmp45_ = node_image_get_surface (_tmp44_);
		_tmp46_ = _tmp45_;
		g_object_set ((GtkWidget*) _tmp42_, "height-request", cairo_image_surface_get_height (_tmp46_), NULL);
		_cairo_surface_destroy0 (_tmp46_);
		_tmp47_ = self->priv->_crop_points;
		_tmp47__length1 = self->priv->_crop_points_length1;
		_tmp48_ = self->priv->_image;
		_tmp49_ = node_image_get_crop_w (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp47_[8].width = _tmp50_;
		_tmp51_ = self->priv->_crop_points;
		_tmp51__length1 = self->priv->_crop_points_length1;
		_tmp52_ = self->priv->_image;
		_tmp53_ = node_image_get_crop_h (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp51_[8].height = _tmp54_;
		image_editor_set_crop_points (self);
		_tmp55_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp55_);
		_tmp56_ = self->priv->_popover;
		utils_show_popover (_tmp56_);
	}
}

static gpointer
_node_image_ref0 (gpointer self)
{
	return self ? node_image_ref (self) : NULL;
}

static gboolean
image_editor_initialize (ImageEditor* self,
                         NodeImage* ni)
{
	NodeImage* _tmp0_;
	NodeImage* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	NodeImage* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ni != NULL, FALSE);
	_tmp0_ = _node_image_ref0 (ni);
	_node_image_unref0 (self->priv->_image);
	self->priv->_image = _tmp0_;
	_tmp1_ = self->priv->_image;
	_tmp2_ = node_image_get_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkDrawingArea* _tmp4_;
		NodeImage* _tmp5_;
		cairo_surface_t* _tmp6_;
		cairo_surface_t* _tmp7_;
		GtkDrawingArea* _tmp8_;
		NodeImage* _tmp9_;
		cairo_surface_t* _tmp10_;
		cairo_surface_t* _tmp11_;
		GdkRectangle* _tmp12_;
		gint _tmp12__length1;
		NodeImage* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		GdkRectangle* _tmp16_;
		gint _tmp16__length1;
		NodeImage* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GtkDrawingArea* _tmp20_;
		_tmp4_ = self->priv->_da;
		_tmp5_ = self->priv->_image;
		_tmp6_ = node_image_get_surface (_tmp5_);
		_tmp7_ = _tmp6_;
		g_object_set ((GtkWidget*) _tmp4_, "width-request", cairo_image_surface_get_width (_tmp7_), NULL);
		_cairo_surface_destroy0 (_tmp7_);
		_tmp8_ = self->priv->_da;
		_tmp9_ = self->priv->_image;
		_tmp10_ = node_image_get_surface (_tmp9_);
		_tmp11_ = _tmp10_;
		g_object_set ((GtkWidget*) _tmp8_, "height-request", cairo_image_surface_get_height (_tmp11_), NULL);
		_cairo_surface_destroy0 (_tmp11_);
		_tmp12_ = self->priv->_crop_points;
		_tmp12__length1 = self->priv->_crop_points_length1;
		_tmp13_ = self->priv->_image;
		_tmp14_ = node_image_get_crop_w (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp12_[8].width = _tmp15_;
		_tmp16_ = self->priv->_crop_points;
		_tmp16__length1 = self->priv->_crop_points_length1;
		_tmp17_ = self->priv->_image;
		_tmp18_ = node_image_get_crop_h (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp16_[8].height = _tmp19_;
		image_editor_set_crop_points (self);
		image_editor_set_cursor_location (self, 0, 0);
		_tmp20_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp20_);
	}
	_tmp21_ = self->priv->_image;
	_tmp22_ = node_image_get_valid (_tmp21_);
	_tmp23_ = _tmp22_;
	result = _tmp23_;
	return result;
}

static void
image_editor_set_crop_points (ImageEditor* self)
{
	gint x0 = 0;
	NodeImage* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint x1 = 0;
	NodeImage* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NodeImage* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint x2 = 0;
	NodeImage* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NodeImage* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint y0 = 0;
	NodeImage* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint y1 = 0;
	NodeImage* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	NodeImage* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint y2 = 0;
	NodeImage* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	NodeImage* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GdkRectangle* _tmp30_;
	gint _tmp30__length1;
	GdkRectangle* _tmp31_;
	gint _tmp31__length1;
	GdkRectangle* _tmp32_;
	gint _tmp32__length1;
	GdkRectangle* _tmp33_;
	gint _tmp33__length1;
	GdkRectangle* _tmp34_;
	gint _tmp34__length1;
	GdkRectangle* _tmp35_;
	gint _tmp35__length1;
	GdkRectangle* _tmp36_;
	gint _tmp36__length1;
	GdkRectangle* _tmp37_;
	gint _tmp37__length1;
	GdkRectangle* _tmp38_;
	gint _tmp38__length1;
	GdkRectangle* _tmp39_;
	gint _tmp39__length1;
	GdkRectangle* _tmp40_;
	gint _tmp40__length1;
	GdkRectangle* _tmp41_;
	gint _tmp41__length1;
	GdkRectangle* _tmp42_;
	gint _tmp42__length1;
	GdkRectangle* _tmp43_;
	gint _tmp43__length1;
	GdkRectangle* _tmp44_;
	gint _tmp44__length1;
	GdkRectangle* _tmp45_;
	gint _tmp45__length1;
	GdkRectangle* _tmp46_;
	gint _tmp46__length1;
	GdkRectangle* _tmp47_;
	gint _tmp47__length1;
	GdkRectangle* _tmp48_;
	gint _tmp48__length1;
	NodeImage* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GdkRectangle* _tmp52_;
	gint _tmp52__length1;
	NodeImage* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GtkLabel* _tmp56_;
	GdkRectangle* _tmp57_;
	gint _tmp57__length1;
	GdkRectangle _tmp58_;
	GdkRectangle* _tmp59_;
	gint _tmp59__length1;
	GdkRectangle _tmp60_;
	GdkRectangle* _tmp61_;
	gint _tmp61__length1;
	GdkRectangle _tmp62_;
	GdkRectangle* _tmp63_;
	gint _tmp63__length1;
	GdkRectangle _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_image;
	_tmp1_ = node_image_get_crop_x (_tmp0_);
	_tmp2_ = _tmp1_;
	x0 = _tmp2_;
	_tmp3_ = self->priv->_image;
	_tmp4_ = node_image_get_crop_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_image;
	_tmp7_ = node_image_get_crop_w (_tmp6_);
	_tmp8_ = _tmp7_;
	x1 = (_tmp5_ + (_tmp8_ / 2)) - (IMAGE_EDITOR_CROP_WIDTH / 2);
	_tmp9_ = self->priv->_image;
	_tmp10_ = node_image_get_crop_x (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_image;
	_tmp13_ = node_image_get_crop_w (_tmp12_);
	_tmp14_ = _tmp13_;
	x2 = (_tmp11_ + _tmp14_) - IMAGE_EDITOR_CROP_WIDTH;
	_tmp15_ = self->priv->_image;
	_tmp16_ = node_image_get_crop_y (_tmp15_);
	_tmp17_ = _tmp16_;
	y0 = _tmp17_;
	_tmp18_ = self->priv->_image;
	_tmp19_ = node_image_get_crop_y (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->_image;
	_tmp22_ = node_image_get_crop_h (_tmp21_);
	_tmp23_ = _tmp22_;
	y1 = (_tmp20_ + (_tmp23_ / 2)) - (IMAGE_EDITOR_CROP_WIDTH / 2);
	_tmp24_ = self->priv->_image;
	_tmp25_ = node_image_get_crop_y (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->_image;
	_tmp28_ = node_image_get_crop_h (_tmp27_);
	_tmp29_ = _tmp28_;
	y2 = (_tmp26_ + _tmp29_) - IMAGE_EDITOR_CROP_WIDTH;
	_tmp30_ = self->priv->_crop_points;
	_tmp30__length1 = self->priv->_crop_points_length1;
	_tmp30_[0].x = x0;
	_tmp31_ = self->priv->_crop_points;
	_tmp31__length1 = self->priv->_crop_points_length1;
	_tmp31_[0].y = y0;
	_tmp32_ = self->priv->_crop_points;
	_tmp32__length1 = self->priv->_crop_points_length1;
	_tmp32_[1].x = x1;
	_tmp33_ = self->priv->_crop_points;
	_tmp33__length1 = self->priv->_crop_points_length1;
	_tmp33_[1].y = y0;
	_tmp34_ = self->priv->_crop_points;
	_tmp34__length1 = self->priv->_crop_points_length1;
	_tmp34_[2].x = x2;
	_tmp35_ = self->priv->_crop_points;
	_tmp35__length1 = self->priv->_crop_points_length1;
	_tmp35_[2].y = y0;
	_tmp36_ = self->priv->_crop_points;
	_tmp36__length1 = self->priv->_crop_points_length1;
	_tmp36_[3].x = x0;
	_tmp37_ = self->priv->_crop_points;
	_tmp37__length1 = self->priv->_crop_points_length1;
	_tmp37_[3].y = y1;
	_tmp38_ = self->priv->_crop_points;
	_tmp38__length1 = self->priv->_crop_points_length1;
	_tmp38_[4].x = x2;
	_tmp39_ = self->priv->_crop_points;
	_tmp39__length1 = self->priv->_crop_points_length1;
	_tmp39_[4].y = y1;
	_tmp40_ = self->priv->_crop_points;
	_tmp40__length1 = self->priv->_crop_points_length1;
	_tmp40_[5].x = x0;
	_tmp41_ = self->priv->_crop_points;
	_tmp41__length1 = self->priv->_crop_points_length1;
	_tmp41_[5].y = y2;
	_tmp42_ = self->priv->_crop_points;
	_tmp42__length1 = self->priv->_crop_points_length1;
	_tmp42_[6].x = x1;
	_tmp43_ = self->priv->_crop_points;
	_tmp43__length1 = self->priv->_crop_points_length1;
	_tmp43_[6].y = y2;
	_tmp44_ = self->priv->_crop_points;
	_tmp44__length1 = self->priv->_crop_points_length1;
	_tmp44_[7].x = x2;
	_tmp45_ = self->priv->_crop_points;
	_tmp45__length1 = self->priv->_crop_points_length1;
	_tmp45_[7].y = y2;
	_tmp46_ = self->priv->_crop_points;
	_tmp46__length1 = self->priv->_crop_points_length1;
	_tmp46_[8].x = x0;
	_tmp47_ = self->priv->_crop_points;
	_tmp47__length1 = self->priv->_crop_points_length1;
	_tmp47_[8].y = y0;
	_tmp48_ = self->priv->_crop_points;
	_tmp48__length1 = self->priv->_crop_points_length1;
	_tmp49_ = self->priv->_image;
	_tmp50_ = node_image_get_crop_w (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp48_[8].width = _tmp51_;
	_tmp52_ = self->priv->_crop_points;
	_tmp52__length1 = self->priv->_crop_points_length1;
	_tmp53_ = self->priv->_image;
	_tmp54_ = node_image_get_crop_h (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp52_[8].height = _tmp55_;
	_tmp56_ = self->priv->_status_crop;
	_tmp57_ = self->priv->_crop_points;
	_tmp57__length1 = self->priv->_crop_points_length1;
	_tmp58_ = _tmp57_[8];
	_tmp59_ = self->priv->_crop_points;
	_tmp59__length1 = self->priv->_crop_points_length1;
	_tmp60_ = _tmp59_[8];
	_tmp61_ = self->priv->_crop_points;
	_tmp61__length1 = self->priv->_crop_points_length1;
	_tmp62_ = _tmp61_[8];
	_tmp63_ = self->priv->_crop_points;
	_tmp63__length1 = self->priv->_crop_points_length1;
	_tmp64_ = _tmp63_[8];
	_tmp65_ = g_strdup_printf (_ ("Crop Area: %d,%d %3dx%3d"), _tmp58_.x, _tmp60_.y, _tmp62_.width, _tmp64_.height);
	_tmp66_ = _tmp65_;
	gtk_label_set_label (_tmp56_, _tmp66_);
	_g_free0 (_tmp66_);
}

static void
image_editor_set_crop_target (ImageEditor* self,
                              gdouble x,
                              gdouble y)
{
	gint int_x = 0;
	gint int_y = 0;
	GdkRectangle cursor = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle tmp = {0};
	gint i = 0;
	GdkRectangle* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	int_x = (gint) x;
	int_y = (gint) y;
	_tmp0_.x = int_x;
	_tmp0_.y = int_y;
	_tmp0_.width = 1;
	_tmp0_.height = 1;
	cursor = _tmp0_;
	i = 0;
	_tmp1_ = self->priv->_crop_points;
	_tmp1__length1 = self->priv->_crop_points_length1;
	{
		GdkRectangle* crop_point_collection = NULL;
		gint crop_point_collection_length1 = 0;
		gint _crop_point_collection_size_ = 0;
		gint crop_point_it = 0;
		crop_point_collection = _tmp1_;
		crop_point_collection_length1 = _tmp1__length1;
		for (crop_point_it = 0; crop_point_it < crop_point_collection_length1; crop_point_it = crop_point_it + 1) {
			GdkRectangle crop_point = {0};
			crop_point = crop_point_collection[crop_point_it];
			{
				GdkRectangle _tmp2_;
				GdkRectangle _tmp3_ = {0};
				gboolean _tmp4_;
				gint _tmp5_;
				_tmp2_ = cursor;
				_tmp4_ = gdk_rectangle_intersect (&crop_point, &_tmp2_, &_tmp3_);
				tmp = _tmp3_;
				if (_tmp4_) {
					self->priv->_crop_target = i;
					return;
				}
				_tmp5_ = i;
				i = _tmp5_ + 1;
			}
		}
	}
	self->priv->_crop_target = -1;
}

static void
image_editor_adjust_crop_points (ImageEditor* self,
                                 gint diffx,
                                 gint diffy)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_crop_target != -1) {
		gint x = 0;
		NodeImage* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint y = 0;
		NodeImage* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint w = 0;
		NodeImage* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint h = 0;
		NodeImage* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp0_ = self->priv->_image;
		_tmp1_ = node_image_get_crop_x (_tmp0_);
		_tmp2_ = _tmp1_;
		x = _tmp2_;
		_tmp3_ = self->priv->_image;
		_tmp4_ = node_image_get_crop_y (_tmp3_);
		_tmp5_ = _tmp4_;
		y = _tmp5_;
		_tmp6_ = self->priv->_image;
		_tmp7_ = node_image_get_crop_w (_tmp6_);
		_tmp8_ = _tmp7_;
		w = _tmp8_;
		_tmp9_ = self->priv->_image;
		_tmp10_ = node_image_get_crop_h (_tmp9_);
		_tmp11_ = _tmp10_;
		h = _tmp11_;
		switch (self->priv->_crop_target) {
			case 0:
			{
				x += diffx;
				y += diffy;
				w -= diffx;
				h -= diffy;
				break;
			}
			case 1:
			{
				y += diffy;
				h -= diffy;
				break;
			}
			case 2:
			{
				y += diffy;
				w += diffx;
				h -= diffy;
				break;
			}
			case 3:
			{
				x += diffx;
				w -= diffx;
				break;
			}
			case 4:
			{
				w += diffx;
				break;
			}
			case 5:
			{
				x += diffx;
				w -= diffx;
				h += diffy;
				break;
			}
			case 6:
			{
				h += diffy;
				break;
			}
			case 7:
			{
				w += diffx;
				h += diffy;
				break;
			}
			case 8:
			{
				x += diffx;
				y += diffy;
				break;
			}
			default:
			break;
		}
		if (x >= 0) {
			GtkDrawingArea* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp14_ = self->priv->_da;
			g_object_get ((GtkWidget*) _tmp14_, "width-request", &_tmp15_, NULL);
			_tmp16_ = _tmp15_;
			_tmp13_ = (x + w) <= _tmp16_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = ((gdouble) w) >= IMAGE_EDITOR_MIN_WIDTH;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			NodeImage* _tmp17_;
			NodeImage* _tmp18_;
			_tmp17_ = self->priv->_image;
			node_image_set_crop_x (_tmp17_, x);
			_tmp18_ = self->priv->_image;
			node_image_set_crop_w (_tmp18_, w);
		}
		if (y >= 0) {
			GtkDrawingArea* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp21_ = self->priv->_da;
			g_object_get ((GtkWidget*) _tmp21_, "height-request", &_tmp22_, NULL);
			_tmp23_ = _tmp22_;
			_tmp20_ = (y + h) <= _tmp23_;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = ((gdouble) h) >= IMAGE_EDITOR_MIN_WIDTH;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			NodeImage* _tmp24_;
			NodeImage* _tmp25_;
			_tmp24_ = self->priv->_image;
			node_image_set_crop_y (_tmp24_, y);
			_tmp25_ = self->priv->_image;
			node_image_set_crop_h (_tmp25_, h);
		}
		image_editor_set_crop_points (self);
	}
}

static gboolean
__lambda64_ (ImageEditor* self,
             GdkEventKey* e)
{
	gboolean control = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	control = (gboolean) (e->state & GDK_CONTROL_MASK);
	if (control) {
		switch (e->keyval) {
			case 99:
			{
				image_editor_action_copy (self);
				break;
			}
			case 118:
			{
				image_editor_action_paste (self);
				break;
			}
			case 120:
			{
				image_editor_action_cut (self);
				break;
			}
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (e->keyval) {
			case 65293:
			{
				image_editor_action_apply (self);
				break;
			}
			case 65307:
			{
				image_editor_action_cancel (self);
				break;
			}
			case 65535:
			{
				image_editor_action_delete (self);
				break;
			}
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda64__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda64_ ((ImageEditor*) self, event);
	return result;
}

static gboolean
__lambda65_ (ImageEditor* self,
             GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	image_editor_update_ui (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda65__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda65_ ((ImageEditor*) self, event);
	return result;
}

void
image_editor_create_ui (ImageEditor* self,
                        DrawArea* da,
                        ImageManager* im)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp1_;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkBox* status = NULL;
	GtkBox* _tmp4_;
	GtkBox* buttons = NULL;
	GtkBox* _tmp5_;
	GtkDrawingArea* _tmp6_;
	GtkPopover* _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (im != NULL);
	_tmp0_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) da);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_popover);
	self->priv->_popover = _tmp0_;
	_tmp1_ = self->priv->_popover;
	gtk_popover_set_modal (_tmp1_, TRUE);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	gtk_container_set_border_width ((GtkContainer*) box, (guint) 5);
	_tmp3_ = image_editor_create_drawing_area (self, im);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp3_;
	_tmp4_ = image_editor_create_status_area (self);
	status = _tmp4_;
	_tmp5_ = image_editor_create_buttons (self, da, im);
	buttons = _tmp5_;
	_tmp6_ = self->priv->_da;
	gtk_box_pack_start (box, (GtkWidget*) _tmp6_, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) status, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) buttons, FALSE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) box);
	_tmp7_ = self->priv->_popover;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) box);
	_tmp8_ = self->priv->_popover;
	g_signal_connect ((GtkWidget*) _tmp8_, "key-press-event", (GCallback) ___lambda64__gtk_widget_key_press_event, self);
	_tmp9_ = self->priv->_popover;
	g_signal_connect ((GtkWidget*) _tmp9_, "enter-notify-event", (GCallback) ___lambda65__gtk_widget_enter_notify_event, self);
	image_editor_update_ui (self);
	_g_object_unref0 (buttons);
	_g_object_unref0 (status);
	_g_object_unref0 (box);
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		ImageEditor* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->da);
		_image_manager_unref0 (_data22_->im);
		_image_editor_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static gboolean
__lambda58_ (ImageEditor* self,
             cairo_t* ctx)
{
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	image_editor_draw_image (self, ctx);
	result = FALSE;
	return result;
}

static gboolean
___lambda58__gtk_widget_draw (GtkWidget* _sender,
                              cairo_t* cr,
                              gpointer self)
{
	gboolean result;
	result = __lambda58_ ((ImageEditor*) self, cr);
	return result;
}

static gboolean
__lambda59_ (ImageEditor* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	image_editor_set_crop_target (self, e->x, e->y);
	if (self->priv->_crop_target == 8) {
		GdkWindow* win = NULL;
		GtkDrawingArea* _tmp0_;
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		GdkWindow* _tmp3_;
		GtkPopover* _tmp4_;
		GdkDisplay* _tmp5_;
		GdkCursor* _tmp6_;
		GdkCursor* _tmp7_;
		_tmp0_ = self->priv->_da;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		win = _tmp2_;
		_tmp3_ = win;
		_tmp4_ = self->priv->_popover;
		_tmp5_ = gtk_widget_get_display ((GtkWidget*) _tmp4_);
		_tmp6_ = gdk_cursor_new_from_name (_tmp5_, "grabbing");
		_tmp7_ = _tmp6_;
		gdk_window_set_cursor (_tmp3_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (win);
	}
	self->priv->_last_x = e->x;
	self->priv->_last_y = e->y;
	result = FALSE;
	return result;
}

static gboolean
___lambda59__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda59_ ((ImageEditor*) self, event);
	return result;
}

static gboolean
__lambda60_ (Block22Data* _data22_,
             GdkEventMotion* e)
{
	ImageEditor* self;
	gint int_x = 0;
	gint int_y = 0;
	gboolean result;
	self = _data22_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	if (self->priv->_crop_target == -1) {
		gboolean _tmp0_ = FALSE;
		image_editor_set_crop_target (self, e->x, e->y);
		if (self->priv->_crop_target >= 0) {
			_tmp0_ = self->priv->_crop_target < 8;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GdkCursorType* _tmp1_;
			gint _tmp1__length1;
			GdkCursorType _tmp2_;
			_tmp1_ = self->priv->_crop_cursors;
			_tmp1__length1 = self->priv->_crop_cursors_length1;
			_tmp2_ = _tmp1_[self->priv->_crop_target];
			image_editor_set_cursor (self, &_tmp2_);
		} else {
			image_editor_set_cursor (self, NULL);
		}
		self->priv->_crop_target = -1;
	} else {
		image_editor_adjust_crop_points (self, (gint) (e->x - self->priv->_last_x), (gint) (e->y - self->priv->_last_y));
		gtk_widget_queue_draw ((GtkWidget*) _data22_->da);
	}
	self->priv->_last_x = e->x;
	self->priv->_last_y = e->y;
	int_x = (gint) e->x;
	int_y = (gint) e->y;
	image_editor_set_cursor_location (self, int_x, int_y);
	result = FALSE;
	return result;
}

static gboolean
___lambda60__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                             GdkEventMotion* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda60_ (self, event);
	return result;
}

static gboolean
__lambda61_ (ImageEditor* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->_crop_target = -1;
	image_editor_set_cursor (self, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda61__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda61_ ((ImageEditor*) self, event);
	return result;
}

static void
__lambda62_ (Block22Data* _data22_,
             GdkDragContext* ctx,
             gint x,
             gint y,
             GtkSelectionData* data,
             guint info,
             guint t)
{
	ImageEditor* self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_;
	self = _data22_->self;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _vala_array_length (_tmp0_) == 1;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp3_) {
		NodeImage* ni = NULL;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		Node* _tmp8_;
		Style* _tmp9_;
		Style* _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		NodeImage* _tmp13_;
		NodeImage* _tmp14_;
		gboolean _tmp15_ = FALSE;
		NodeImage* _tmp16_;
		_tmp5_ = _tmp4_ = gtk_selection_data_get_uris (data);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _vala_array_length (_tmp4_);
		_tmp7_ = _tmp6_[0];
		_tmp8_ = self->priv->_node;
		_tmp9_ = node_get_style (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = style_get_node_width (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = node_image_new_from_uri (_data22_->im, _tmp7_, *_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		ni = _tmp14_;
		_tmp16_ = ni;
		if (_tmp16_ != NULL) {
			NodeImage* _tmp17_;
			_tmp17_ = ni;
			_tmp15_ = image_editor_initialize (self, _tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			gtk_drag_finish (ctx, TRUE, FALSE, (guint32) t);
		}
		_node_image_unref0 (ni);
	}
}

static void
___lambda62__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
	__lambda62_ (self, context, x, y, selection_data, info, time_);
}

GtkDrawingArea*
image_editor_create_drawing_area (ImageEditor* self,
                                  ImageManager* im)
{
	Block22Data* _data22_;
	ImageManager* _tmp0_;
	GtkDrawingArea* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkDrawingArea* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (im != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = image_editor_ref (self);
	_tmp0_ = _image_manager_ref0 (im);
	_image_manager_unref0 (_data22_->im);
	_data22_->im = _tmp0_;
	_tmp1_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp1_);
	_data22_->da = _tmp1_;
	g_object_set ((GtkWidget*) _data22_->da, "width-request", NODE_IMAGE_EDIT_WIDTH, NULL);
	g_object_set ((GtkWidget*) _data22_->da, "height-request", NODE_IMAGE_EDIT_HEIGHT, NULL);
	gtk_widget_add_events ((GtkWidget*) _data22_->da, (gint) (((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_BUTTON1_MOTION_MASK) | GDK_POINTER_MOTION_MASK));
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _data22_->da);
	gtk_style_context_add_class (_tmp2_, "canvas");
	g_signal_connect ((GtkWidget*) _data22_->da, "draw", (GCallback) ___lambda58__gtk_widget_draw, self);
	g_signal_connect ((GtkWidget*) _data22_->da, "button-press-event", (GCallback) ___lambda59__gtk_widget_button_press_event, self);
	g_signal_connect_data ((GtkWidget*) _data22_->da, "motion-notify-event", (GCallback) ___lambda60__gtk_widget_motion_notify_event, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	g_signal_connect ((GtkWidget*) _data22_->da, "button-release-event", (GCallback) ___lambda61__gtk_widget_button_release_event, self);
	gtk_drag_dest_set ((GtkWidget*) _data22_->da, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, IMAGE_EDITOR_DRAG_TARGETS, (gint) G_N_ELEMENTS (IMAGE_EDITOR_DRAG_TARGETS), GDK_ACTION_COPY);
	g_signal_connect_data ((GtkWidget*) _data22_->da, "drag-data-received", (GCallback) ___lambda62__gtk_widget_drag_data_received, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data22_->da);
	result = _tmp3_;
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}

static GtkBox*
image_editor_create_status_area (ImageEditor* self)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	gtk_box_set_homogeneous (box, TRUE);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_status_cursor);
	self->priv->_status_cursor = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_status_crop);
	self->priv->_status_crop = _tmp2_;
	_tmp3_ = self->priv->_status_cursor;
	gtk_box_pack_start (box, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->priv->_status_crop;
	gtk_box_pack_start (box, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	result = box;
	return result;
}

static void
image_editor_set_cursor_location (ImageEditor* self,
                                  gint x,
                                  gint y)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_status_cursor;
	_tmp1_ = g_strdup_printf (_ ("Cursor: %3d,%3d"), x, y);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ImageEditor* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->da);
		_image_manager_unref0 (_data23_->im);
		_image_editor_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
__lambda63_ (Block23Data* _data23_)
{
	ImageEditor* self;
	GtkWindow* win = NULL;
	GtkWidget* _tmp0_;
	GtkWindow* _tmp1_;
	gint id = 0;
	GtkWindow* _tmp2_;
	self = _data23_->self;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) _data23_->da);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	win = _tmp1_;
	_tmp2_ = win;
	id = image_manager_choose_image (_data23_->im, _tmp2_);
	if (id != -1) {
		NodeImage* ni = NULL;
		Node* _tmp3_;
		Style* _tmp4_;
		Style* _tmp5_;
		gint* _tmp6_;
		gint* _tmp7_;
		NodeImage* _tmp8_;
		NodeImage* _tmp9_;
		_tmp3_ = self->priv->_node;
		_tmp4_ = node_get_style (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = style_get_node_width (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = node_image_new (_data23_->im, id, *_tmp7_);
		ni = _tmp8_;
		_tmp9_ = ni;
		if (_tmp9_ != NULL) {
			NodeImage* _tmp10_;
			_tmp10_ = ni;
			image_editor_initialize (self, _tmp10_);
		}
		_node_image_unref0 (ni);
	}
	_g_object_unref0 (win);
}

static void
___lambda63__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda63_ (self);
}

static void
_image_editor_action_cancel_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	image_editor_action_cancel ((ImageEditor*) self);
}

static void
_image_editor_action_apply_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	image_editor_action_apply ((ImageEditor*) self);
}

static void
_image_editor_action_copy_gtk_button_clicked (GtkButton* _sender,
                                              gpointer self)
{
	image_editor_action_copy ((ImageEditor*) self);
}

static void
_image_editor_action_cut_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	image_editor_action_cut ((ImageEditor*) self);
}

static void
_image_editor_action_paste_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	image_editor_action_paste ((ImageEditor*) self);
}

static void
_image_editor_action_delete_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	image_editor_action_delete ((ImageEditor*) self);
}

static GtkBox*
image_editor_create_buttons (ImageEditor* self,
                             DrawArea* da,
                             ImageManager* im)
{
	Block23Data* _data23_;
	DrawArea* _tmp0_;
	ImageManager* _tmp1_;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkButton* cancel = NULL;
	GtkButton* _tmp3_;
	GtkButton* apply = NULL;
	GtkButton* _tmp4_;
	GtkButton* open = NULL;
	GtkButton* _tmp5_;
	GtkButton* copy = NULL;
	GtkButton* _tmp6_;
	GtkButton* cut = NULL;
	GtkButton* _tmp7_;
	GtkButton* paste = NULL;
	GtkButton* _tmp8_;
	GtkButton* del = NULL;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (im != NULL, NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = image_editor_ref (self);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (_data23_->da);
	_data23_->da = _tmp0_;
	_tmp1_ = _image_manager_ref0 (im);
	_image_manager_unref0 (_data23_->im);
	_data23_->im = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp3_);
	cancel = _tmp3_;
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_ ("Apply"));
	g_object_ref_sink (_tmp4_);
	apply = _tmp4_;
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("folder-open-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp5_);
	open = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-copy-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp6_);
	copy = _tmp6_;
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-cut-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp7_);
	cut = _tmp7_;
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-paste-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp8_);
	paste = _tmp8_;
	_tmp9_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp9_);
	del = _tmp9_;
	_tmp10_ = _g_object_ref0 (paste);
	_g_object_unref0 (self->priv->_paste);
	self->priv->_paste = _tmp10_;
	_tmp11_ = utils_tooltip_with_accel (_ ("Change Image"), "<Control>o");
	_tmp12_ = _tmp11_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) open, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = utils_tooltip_with_accel (_ ("Copy Image to Clipboard"), "<Control>c");
	_tmp14_ = _tmp13_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) copy, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = utils_tooltip_with_accel (_ ("Cut Image to Clipboard"), "<Control>x");
	_tmp16_ = _tmp15_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) cut, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = utils_tooltip_with_accel (_ ("Paste Image from Clipboard"), "<Control>v");
	_tmp18_ = _tmp17_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) paste, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = utils_tooltip_with_accel (_ ("Remove Image"), "Delete");
	_tmp20_ = _tmp19_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) del, _tmp20_);
	_g_free0 (_tmp20_);
	g_signal_connect_data (open, "clicked", (GCallback) ___lambda63__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	g_signal_connect (cancel, "clicked", (GCallback) _image_editor_action_cancel_gtk_button_clicked, self);
	g_signal_connect (apply, "clicked", (GCallback) _image_editor_action_apply_gtk_button_clicked, self);
	g_signal_connect (copy, "clicked", (GCallback) _image_editor_action_copy_gtk_button_clicked, self);
	g_signal_connect (cut, "clicked", (GCallback) _image_editor_action_cut_gtk_button_clicked, self);
	g_signal_connect (paste, "clicked", (GCallback) _image_editor_action_paste_gtk_button_clicked, self);
	g_signal_connect (del, "clicked", (GCallback) _image_editor_action_delete_gtk_button_clicked, self);
	gtk_box_pack_start (box, (GtkWidget*) open, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) paste, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) del, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) copy, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) cut, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (box, (GtkWidget*) apply, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (box, (GtkWidget*) cancel, FALSE, FALSE, (guint) 0);
	result = box;
	_g_object_unref0 (del);
	_g_object_unref0 (paste);
	_g_object_unref0 (cut);
	_g_object_unref0 (copy);
	_g_object_unref0 (open);
	_g_object_unref0 (apply);
	_g_object_unref0 (cancel);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return result;
}

static gboolean
_gdk_cursor_type_equal (const GdkCursorType * s1,
                        const GdkCursorType * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
image_editor_set_cursor (ImageEditor* self,
                         GdkCursorType* type)
{
	GdkWindow* win = NULL;
	GtkDrawingArea* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkCursor* cursor = NULL;
	GdkWindow* _tmp3_;
	GdkCursor* _tmp4_;
	GdkCursor* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	win = _tmp2_;
	_tmp3_ = win;
	_tmp4_ = gdk_window_get_cursor (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	cursor = _tmp5_;
	if (type == NULL) {
		GdkWindow* _tmp6_;
		_tmp6_ = win;
		gdk_window_set_cursor (_tmp6_, NULL);
	} else {
		gboolean _tmp7_ = FALSE;
		GdkCursor* _tmp8_;
		_tmp8_ = cursor;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			GdkCursor* _tmp9_;
			GdkCursorType _tmp10_;
			GdkCursorType _tmp11_;
			_tmp9_ = cursor;
			_tmp10_ = gdk_cursor_get_cursor_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp7_ = _gdk_cursor_type_equal (&_tmp11_, type) != TRUE;
		}
		if (_tmp7_) {
			GdkWindow* _tmp12_;
			GtkPopover* _tmp13_;
			GdkDisplay* _tmp14_;
			GdkCursor* _tmp15_;
			GdkCursor* _tmp16_;
			_tmp12_ = win;
			_tmp13_ = self->priv->_popover;
			_tmp14_ = gtk_widget_get_display ((GtkWidget*) _tmp13_);
			_tmp15_ = gdk_cursor_new_for_display (_tmp14_, *type);
			_tmp16_ = _tmp15_;
			gdk_window_set_cursor (_tmp12_, _tmp16_);
			_g_object_unref0 (_tmp16_);
		}
	}
	_g_object_unref0 (cursor);
	_g_object_unref0 (win);
}

static void
image_editor_draw_image (ImageEditor* self,
                         cairo_t* ctx)
{
	NodeImage* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	GtkDrawingArea* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkDrawingArea* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NodeImage* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NodeImage* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	NodeImage* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	NodeImage* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	NodeImage* _tmp21_;
	cairo_surface_t* _tmp22_;
	cairo_surface_t* _tmp23_;
	NodeImage* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	NodeImage* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	NodeImage* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	NodeImage* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->_image;
	_tmp1_ = node_image_get_surface (_tmp0_);
	_tmp2_ = _tmp1_;
	cairo_set_source_surface (ctx, _tmp2_, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (_tmp2_);
	cairo_paint (ctx);
	cairo_set_source_rgba (ctx, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.8);
	_tmp3_ = self->priv->_da;
	g_object_get ((GtkWidget*) _tmp3_, "width-request", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_da;
	g_object_get ((GtkWidget*) _tmp6_, "height-request", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	cairo_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp8_);
	cairo_fill (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	_tmp9_ = self->priv->_image;
	_tmp10_ = node_image_get_crop_x (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_image;
	_tmp13_ = node_image_get_crop_y (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_image;
	_tmp16_ = node_image_get_crop_w (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_image;
	_tmp19_ = node_image_get_crop_h (_tmp18_);
	_tmp20_ = _tmp19_;
	cairo_rectangle (ctx, (gdouble) _tmp11_, (gdouble) _tmp14_, (gdouble) _tmp17_, (gdouble) _tmp20_);
	cairo_fill (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	_tmp21_ = self->priv->_image;
	_tmp22_ = node_image_get_surface (_tmp21_);
	_tmp23_ = _tmp22_;
	cairo_set_source_surface (ctx, _tmp23_, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (_tmp23_);
	_tmp24_ = self->priv->_image;
	_tmp25_ = node_image_get_crop_x (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->_image;
	_tmp28_ = node_image_get_crop_y (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->_image;
	_tmp31_ = node_image_get_crop_w (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->_image;
	_tmp34_ = node_image_get_crop_h (_tmp33_);
	_tmp35_ = _tmp34_;
	cairo_rectangle (ctx, (gdouble) _tmp26_, (gdouble) _tmp29_, (gdouble) _tmp32_, (gdouble) _tmp35_);
	cairo_fill (ctx);
	cairo_set_line_width (ctx, (gdouble) 1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp36_ = FALSE;
			_tmp36_ = TRUE;
			while (TRUE) {
				GdkRectangle* _tmp38_;
				gint _tmp38__length1;
				GdkRectangle _tmp39_;
				if (!_tmp36_) {
					gint _tmp37_;
					_tmp37_ = i;
					i = _tmp37_ + 1;
				}
				_tmp36_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				_tmp38_ = self->priv->_crop_points;
				_tmp38__length1 = self->priv->_crop_points_length1;
				_tmp39_ = _tmp38_[i];
				image_editor_draw_crop_point (self, ctx, &_tmp39_);
			}
		}
	}
}

static void
image_editor_draw_crop_point (ImageEditor* self,
                              cairo_t* ctx,
                              GdkRectangle* crop)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (crop != NULL);
	cairo_set_source_rgb (ctx, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp0_ = *crop;
	_tmp1_ = *crop;
	_tmp2_ = *crop;
	_tmp3_ = *crop;
	cairo_rectangle (ctx, (gdouble) _tmp0_.x, (gdouble) _tmp1_.y, (gdouble) _tmp2_.width, (gdouble) _tmp3_.width);
	cairo_fill (ctx);
	cairo_set_source_rgb (ctx, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp4_ = *crop;
	_tmp5_ = *crop;
	_tmp6_ = *crop;
	_tmp7_ = *crop;
	cairo_rectangle (ctx, (gdouble) _tmp4_.x, (gdouble) _tmp5_.y, (gdouble) _tmp6_.width, (gdouble) _tmp7_.width);
	cairo_stroke (ctx);
}

static void
image_editor_remove_image (ImageEditor* self,
                           ImageManager* im)
{
	NodeImage* orig_image = NULL;
	Node* _tmp0_;
	NodeImage* _tmp1_;
	NodeImage* _tmp2_;
	NodeImage* _tmp3_;
	Node* _tmp4_;
	GtkPopover* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (im != NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = node_get_image (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _node_image_ref0 (_tmp2_);
	orig_image = _tmp3_;
	_tmp4_ = self->priv->_node;
	node_set_image (_tmp4_, im, NULL);
	g_signal_emit (self, image_editor_signals[IMAGE_EDITOR_CHANGED_SIGNAL], 0, orig_image);
	_tmp5_ = self->priv->_popover;
	utils_hide_popover (_tmp5_);
	_node_image_unref0 (orig_image);
}

static void
image_editor_set_image (ImageEditor* self,
                        ImageManager* im)
{
	NodeImage* orig_image = NULL;
	Node* _tmp0_;
	NodeImage* _tmp1_;
	NodeImage* _tmp2_;
	NodeImage* _tmp3_;
	NodeImage* _tmp4_;
	Node* _tmp5_;
	Style* _tmp6_;
	Style* _tmp7_;
	gint* _tmp8_;
	gint* _tmp9_;
	Node* _tmp10_;
	NodeImage* _tmp11_;
	GtkPopover* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (im != NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = node_get_image (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _node_image_ref0 (_tmp2_);
	orig_image = _tmp3_;
	_tmp4_ = self->priv->_image;
	_tmp5_ = self->priv->_node;
	_tmp6_ = node_get_style (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = style_get_node_width (_tmp7_);
	_tmp9_ = _tmp8_;
	node_image_set_width (_tmp4_, *_tmp9_);
	_tmp10_ = self->priv->_node;
	_tmp11_ = self->priv->_image;
	node_set_image (_tmp10_, im, _tmp11_);
	g_signal_emit (self, image_editor_signals[IMAGE_EDITOR_CHANGED_SIGNAL], 0, orig_image);
	_tmp12_ = self->priv->_popover;
	utils_hide_popover (_tmp12_);
	_node_image_unref0 (orig_image);
}

static gboolean
image_editor_image_pasteable (ImageEditor* self)
{
	GtkClipboard* clipboard = NULL;
	GtkPopover* _tmp0_;
	GdkDisplay* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_popover;
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
	_tmp2_ = gtk_clipboard_get_default (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	result = gtk_clipboard_wait_is_image_available (clipboard);
	_g_object_unref0 (clipboard);
	return result;
}

static void
image_editor_update_ui (ImageEditor* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_paste;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, image_editor_image_pasteable (self));
}

static void
image_editor_action_copy (ImageEditor* self)
{
	gchar* fname = NULL;
	ImageManager* _tmp0_;
	Node* _tmp1_;
	NodeImage* _tmp2_;
	NodeImage* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_im;
	_tmp1_ = self->priv->_node;
	_tmp2_ = node_get_image (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_image_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = image_manager_get_file (_tmp0_, _tmp5_);
	fname = _tmp6_;
	_tmp7_ = fname;
	if (_tmp7_ != NULL) {
		{
			GdkPixbuf* buf = NULL;
			const gchar* _tmp8_;
			GdkPixbuf* _tmp9_;
			GtkClipboard* clipboard = NULL;
			GtkPopover* _tmp10_;
			GdkDisplay* _tmp11_;
			GtkClipboard* _tmp12_;
			GtkClipboard* _tmp13_;
			GtkClipboard* _tmp14_;
			GtkClipboard* _tmp15_;
			GdkPixbuf* _tmp16_;
			_tmp8_ = fname;
			_tmp9_ = gdk_pixbuf_new_from_file (_tmp8_, &_inner_error0_);
			buf = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp10_ = self->priv->_popover;
			_tmp11_ = gtk_widget_get_display ((GtkWidget*) _tmp10_);
			_tmp12_ = gtk_clipboard_get_default (_tmp11_);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			clipboard = _tmp13_;
			_tmp14_ = clipboard;
			gtk_clipboard_clear (_tmp14_);
			_tmp15_ = clipboard;
			_tmp16_ = buf;
			gtk_clipboard_set_image (_tmp15_, _tmp16_);
			image_editor_update_ui (self);
			_g_object_unref0 (clipboard);
			_g_object_unref0 (buf);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (fname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (fname);
}

static void
image_editor_action_cut (ImageEditor* self)
{
	ImageManager* _tmp0_;
	g_return_if_fail (self != NULL);
	image_editor_action_copy (self);
	_tmp0_ = self->priv->_im;
	image_editor_remove_image (self, _tmp0_);
}

static void
image_editor_action_paste (ImageEditor* self)
{
	g_return_if_fail (self != NULL);
	if (image_editor_image_pasteable (self)) {
		GtkClipboard* clipboard = NULL;
		GtkPopover* _tmp0_;
		GdkDisplay* _tmp1_;
		GtkClipboard* _tmp2_;
		GtkClipboard* _tmp3_;
		GdkPixbuf* buf = NULL;
		GtkClipboard* _tmp4_;
		GdkPixbuf* _tmp5_;
		NodeImage* image = NULL;
		ImageManager* _tmp6_;
		GdkPixbuf* _tmp7_;
		Node* _tmp8_;
		Style* _tmp9_;
		Style* _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		NodeImage* _tmp13_;
		NodeImage* _tmp14_;
		NodeImage* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		NodeImage* _tmp18_;
		NodeImage* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		NodeImage* _tmp22_;
		NodeImage* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		NodeImage* _tmp26_;
		NodeImage* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		NodeImage* _tmp30_;
		NodeImage* _tmp31_;
		GtkDrawingArea* _tmp32_;
		_tmp0_ = self->priv->_popover;
		_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
		_tmp2_ = gtk_clipboard_get_default (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		clipboard = _tmp3_;
		_tmp4_ = clipboard;
		_tmp5_ = gtk_clipboard_wait_for_image (_tmp4_);
		buf = _tmp5_;
		_tmp6_ = self->priv->_im;
		_tmp7_ = buf;
		_tmp8_ = self->priv->_node;
		_tmp9_ = node_get_style (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = style_get_node_width (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = node_image_new_from_pixbuf (_tmp6_, _tmp7_, *_tmp12_);
		image = _tmp13_;
		_tmp14_ = image;
		_tmp15_ = self->priv->_image;
		_tmp16_ = node_image_get_crop_x (_tmp15_);
		_tmp17_ = _tmp16_;
		node_image_set_crop_x (_tmp14_, _tmp17_);
		_tmp18_ = image;
		_tmp19_ = self->priv->_image;
		_tmp20_ = node_image_get_crop_y (_tmp19_);
		_tmp21_ = _tmp20_;
		node_image_set_crop_y (_tmp18_, _tmp21_);
		_tmp22_ = image;
		_tmp23_ = self->priv->_image;
		_tmp24_ = node_image_get_crop_w (_tmp23_);
		_tmp25_ = _tmp24_;
		node_image_set_crop_w (_tmp22_, _tmp25_);
		_tmp26_ = image;
		_tmp27_ = self->priv->_image;
		_tmp28_ = node_image_get_crop_h (_tmp27_);
		_tmp29_ = _tmp28_;
		node_image_set_crop_h (_tmp26_, _tmp29_);
		_tmp30_ = image;
		_tmp31_ = _node_image_ref0 (_tmp30_);
		_node_image_unref0 (self->priv->_image);
		self->priv->_image = _tmp31_;
		_tmp32_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp32_);
		_node_image_unref0 (image);
		_g_object_unref0 (buf);
		_g_object_unref0 (clipboard);
	} else {
		image_editor_update_ui (self);
	}
}

static void
image_editor_action_delete (ImageEditor* self)
{
	ImageManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_im;
	image_editor_remove_image (self, _tmp0_);
}

static void
image_editor_action_cancel (ImageEditor* self)
{
	GtkPopover* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_popover;
	utils_hide_popover (_tmp0_);
}

static void
image_editor_action_apply (ImageEditor* self)
{
	ImageManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_im;
	image_editor_set_image (self, _tmp0_);
}

static void
g_cclosure_user_marshal_VOID__NODE_IMAGE (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__NODE_IMAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__NODE_IMAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__NODE_IMAGE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_node_image (param_values + 1), data2);
}

static void
value_image_editor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_image_editor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		image_editor_unref (value->data[0].v_pointer);
	}
}

static void
value_image_editor_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = image_editor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_image_editor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_image_editor_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImageEditor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = image_editor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_image_editor_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	ImageEditor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = image_editor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_image_editor (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecImageEditor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IMAGE_EDITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_image_editor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_EDITOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_image_editor (GValue* value,
                        gpointer v_object)
{
	ImageEditor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_EDITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMAGE_EDITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		image_editor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_editor_unref (old);
	}
}

void
value_take_image_editor (GValue* value,
                         gpointer v_object)
{
	ImageEditor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_EDITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMAGE_EDITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_editor_unref (old);
	}
}

static void
image_editor_class_init (ImageEditorClass * klass,
                         gpointer klass_data)
{
	image_editor_parent_class = g_type_class_peek_parent (klass);
	((ImageEditorClass *) klass)->finalize = image_editor_finalize;
	g_type_class_adjust_private_offset (klass, &ImageEditor_private_offset);
	image_editor_signals[IMAGE_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_IMAGE_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__NODE_IMAGE, G_TYPE_NONE, 1, TYPE_NODE_IMAGE);
}

static void
image_editor_instance_init (ImageEditor * self,
                            gpointer klass)
{
	self->priv = image_editor_get_instance_private (self);
	self->priv->_crop_target = -1;
	self->ref_count = 1;
}

static void
image_editor_finalize (ImageEditor * obj)
{
	ImageEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMAGE_EDITOR, ImageEditor);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_popover);
	_image_manager_unref0 (self->priv->_im);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_node);
	_node_image_unref0 (self->priv->_image);
	_g_object_unref0 (self->priv->_paste);
	self->priv->_crop_points = (g_free (self->priv->_crop_points), NULL);
	self->priv->_crop_cursors = (g_free (self->priv->_crop_cursors), NULL);
	_g_object_unref0 (self->priv->_status_cursor);
	_g_object_unref0 (self->priv->_status_crop);
}

static GType
image_editor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_image_editor_init, value_image_editor_free_value, value_image_editor_copy_value, value_image_editor_peek_pointer, "p", value_image_editor_collect_value, "p", value_image_editor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImageEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) image_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImageEditor), 0, (GInstanceInitFunc) image_editor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType image_editor_type_id;
	image_editor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImageEditor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ImageEditor_private_offset = g_type_add_instance_private (image_editor_type_id, sizeof (ImageEditorPrivate));
	return image_editor_type_id;
}

GType
image_editor_get_type (void)
{
	static volatile gsize image_editor_type_id__once = 0;
	if (g_once_init_enter (&image_editor_type_id__once)) {
		GType image_editor_type_id;
		image_editor_type_id = image_editor_get_type_once ();
		g_once_init_leave (&image_editor_type_id__once, image_editor_type_id);
	}
	return image_editor_type_id__once;
}

gpointer
image_editor_ref (gpointer instance)
{
	ImageEditor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
image_editor_unref (gpointer instance)
{
	ImageEditor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMAGE_EDITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

