/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 33;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtMBit = 10,
  Feature_HasStdExtMOrZmmulBit = 9,
  Feature_HasStdExtABit = 11,
  Feature_HasStdExtFBit = 1,
  Feature_HasStdExtDBit = 2,
  Feature_HasStdExtZfhBit = 4,
  Feature_HasStdExtZfhOrZfhminBit = 6,
  Feature_HasStdExtZbaBit = 20,
  Feature_NotHasStdExtZbaBit = 8,
  Feature_HasStdExtZbbBit = 18,
  Feature_HasStdExtZbcBit = 22,
  Feature_HasStdExtZbeBit = 23,
  Feature_HasStdExtZbfBit = 25,
  Feature_HasStdExtZbpBit = 16,
  Feature_HasStdExtZbrBit = 24,
  Feature_HasStdExtZbsBit = 13,
  Feature_HasStdExtZbtBit = 17,
  Feature_HasStdExtZbbOrZbpBit = 14,
  Feature_HasStdExtZbkxBit = 26,
  Feature_HasStdExtZbpOrZbkbBit = 15,
  Feature_HasStdExtZbbOrZbkbBit = 19,
  Feature_HasStdExtZbbOrZbpOrZbkbBit = 12,
  Feature_HasStdExtZbcOrZbkcBit = 21,
  Feature_HasStdExtZkndBit = 27,
  Feature_HasStdExtZkneBit = 29,
  Feature_HasStdExtZkndOrZkneBit = 28,
  Feature_HasStdExtZknhBit = 30,
  Feature_HasStdExtZksedBit = 31,
  Feature_HasStdExtZkshBit = 32,
  Feature_HasVInstructionsBit = 3,
  Feature_HasVInstructionsAnyFBit = 5,
  Feature_IsRV64Bit = 7,
  Feature_IsRV32Bit = 0,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtM() || Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (Subtarget->hasStdExtZfh() || Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhOrZfhminBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbe())
    Features.set(Feature_HasStdExtZbeBit);
  if (Subtarget->hasStdExtZbf())
    Features.set(Feature_HasStdExtZbfBit);
  if (Subtarget->hasStdExtZbp())
    Features.set(Feature_HasStdExtZbpBit);
  if (Subtarget->hasStdExtZbr())
    Features.set(Feature_HasStdExtZbrBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbt())
    Features.set(Feature_HasStdExtZbtBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbp())
    Features.set(Feature_HasStdExtZbbOrZbpBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbp() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbpOrZbkbBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbp() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbpOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 32;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasStdExtA,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtM,
  GIFBS_HasStdExtMOrZmmul,
  GIFBS_HasStdExtZbb,
  GIFBS_HasStdExtZbbOrZbpOrZbkb,
  GIFBS_HasStdExtZbc,
  GIFBS_HasStdExtZbcOrZbkc,
  GIFBS_HasStdExtZbkx,
  GIFBS_HasStdExtZbp,
  GIFBS_HasStdExtZbpOrZbkb,
  GIFBS_HasStdExtZbr,
  GIFBS_HasStdExtZbs,
  GIFBS_HasStdExtZbt,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtZknh,
  GIFBS_HasStdExtZksed,
  GIFBS_HasStdExtZksh,
  GIFBS_HasVInstructions,
  GIFBS_HasVInstructionsAnyF,
  GIFBS_IsRV64,
  GIFBS_HasStdExtA_IsRV64,
  GIFBS_HasStdExtD_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtD_IsRV32,
  GIFBS_HasStdExtD_IsRV64,
  GIFBS_HasStdExtF_IsRV32,
  GIFBS_HasStdExtZba_IsRV64,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64,
  GIFBS_HasStdExtZbbOrZbp_IsRV32,
  GIFBS_HasStdExtZbbOrZbp_IsRV64,
  GIFBS_HasStdExtZbp_IsRV32,
  GIFBS_HasStdExtZbp_IsRV64,
  GIFBS_HasStdExtZbpOrZbkb_IsRV32,
  GIFBS_HasStdExtZbpOrZbkb_IsRV64,
  GIFBS_HasStdExtZbr_IsRV64,
  GIFBS_HasStdExtZknd_IsRV32,
  GIFBS_HasStdExtZknd_IsRV64,
  GIFBS_HasStdExtZkndOrZkne_IsRV64,
  GIFBS_HasStdExtZkne_IsRV32,
  GIFBS_HasStdExtZkne_IsRV64,
  GIFBS_HasStdExtZknh_IsRV32,
  GIFBS_HasStdExtZknh_IsRV64,
  GIFBS_IsRV64_NotHasStdExtZba,
  GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbpOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbpBit, },
  {Feature_HasStdExtZbpOrZbkbBit, },
  {Feature_HasStdExtZbrBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZbtBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbpBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbpBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbpBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbpBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbpOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbpOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbrBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_BCLRMask = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_BSETINVMask,
  GIPFP_I64_Predicate_byteselect,
  GIPFP_I64_Predicate_c_lui_imm,
  GIPFP_I64_Predicate_immzero,
  GIPFP_I64_Predicate_rnum,
  GIPFP_I64_Predicate_shfl_uimm,
  GIPFP_I64_Predicate_simm10_lsb0000nonzero,
  GIPFP_I64_Predicate_simm12,
  GIPFP_I64_Predicate_simm12_lsb0,
  GIPFP_I64_Predicate_simm12_lsb00000,
  GIPFP_I64_Predicate_simm12_plus1,
  GIPFP_I64_Predicate_simm5,
  GIPFP_I64_Predicate_simm5_plus1,
  GIPFP_I64_Predicate_simm5_plus1_nonzero,
  GIPFP_I64_Predicate_simm6,
  GIPFP_I64_Predicate_simm6nonzero,
  GIPFP_I64_Predicate_simm9_lsb0,
  GIPFP_I64_Predicate_uimm10_lsb00nonzero,
  GIPFP_I64_Predicate_uimm5,
  GIPFP_I64_Predicate_uimm6gt32,
  GIPFP_I64_Predicate_uimm7_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb000,
  GIPFP_I64_Predicate_uimm9_lsb000,
  GIPFP_I64_Predicate_uimmlog2xlen,
  GIPFP_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_BCLRMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(~Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_BSETINVMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                 (isUInt<5>(Imm) ||
                                  (Imm >= 0xfffe0 && Imm <= 0xfffff));
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immzero: {
    return (Imm == 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shfl_uimm: {
    
  if (Subtarget->is64Bit())
    return isUInt<5>(Imm);
  return isUInt<4>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12: {
    return isInt<12>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_plus1: {
    return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5: {
    return isInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6gt32: {
    
  return isUInt<6>(Imm) && Imm > 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlen: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm);
  return isUInt<5>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlennonzero: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm) && (Imm != 0);
  return isUInt<5>(Imm) && (Imm != 0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/45, 223, /*)*//*default:*//*Label 73*/ 159142,
    /*TargetOpcode::G_ADD*//*Label 0*/ 183,
    /*TargetOpcode::G_SUB*//*Label 1*/ 2201,
    /*TargetOpcode::G_MUL*//*Label 2*/ 4745,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 6810,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 8760,
    /*TargetOpcode::G_SREM*//*Label 5*/ 10710,
    /*TargetOpcode::G_UREM*//*Label 6*/ 12660, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 14610,
    /*TargetOpcode::G_OR*//*Label 8*/ 18106,
    /*TargetOpcode::G_XOR*//*Label 9*/ 23820, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 10*/ 28144, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 11*/ 28245,
    /*TargetOpcode::G_LOAD*//*Label 12*/ 28277, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 13*/ 31028, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 14*/ 35589,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 15*/ 37002,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 16*/ 37707,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 17*/ 38412,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 18*/ 39486,
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 19*/ 40191,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 20*/ 41115,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 21*/ 41820,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 22*/ 42525,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 23*/ 43230,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 24*/ 43935,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 25*/ 44640, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 26*/ 45345, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 27*/ 45528,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 28*/ 48867,
    /*TargetOpcode::G_ANYEXT*//*Label 29*/ 50484, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 30*/ 52605, 0,
    /*TargetOpcode::G_ZEXT*//*Label 31*/ 54726,
    /*TargetOpcode::G_SHL*//*Label 32*/ 56847,
    /*TargetOpcode::G_LSHR*//*Label 33*/ 58896,
    /*TargetOpcode::G_ASHR*//*Label 34*/ 60945, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 35*/ 62931, 0,
    /*TargetOpcode::G_ICMP*//*Label 36*/ 63044,
    /*TargetOpcode::G_FCMP*//*Label 37*/ 87863,
    /*TargetOpcode::G_SELECT*//*Label 38*/ 94300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 39*/ 95709,
    /*TargetOpcode::G_SMULH*//*Label 40*/ 97659,
    /*TargetOpcode::G_UADDSAT*//*Label 41*/ 99609,
    /*TargetOpcode::G_SADDSAT*//*Label 42*/ 101492,
    /*TargetOpcode::G_USUBSAT*//*Label 43*/ 103375,
    /*TargetOpcode::G_SSUBSAT*//*Label 44*/ 105258, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 45*/ 107141,
    /*TargetOpcode::G_FSUB*//*Label 46*/ 108433,
    /*TargetOpcode::G_FMUL*//*Label 47*/ 109725,
    /*TargetOpcode::G_FMA*//*Label 48*/ 111017, 0,
    /*TargetOpcode::G_FDIV*//*Label 49*/ 125640, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 50*/ 126932,
    /*TargetOpcode::G_FPEXT*//*Label 51*/ 128104,
    /*TargetOpcode::G_FPTRUNC*//*Label 52*/ 128184,
    /*TargetOpcode::G_FPTOSI*//*Label 53*/ 129032,
    /*TargetOpcode::G_FPTOUI*//*Label 54*/ 132062,
    /*TargetOpcode::G_SITOFP*//*Label 55*/ 135092,
    /*TargetOpcode::G_UITOFP*//*Label 56*/ 138165,
    /*TargetOpcode::G_FABS*//*Label 57*/ 141238,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 58*/ 142410, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 59*/ 145172,
    /*TargetOpcode::G_FMAXNUM*//*Label 60*/ 146464, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 61*/ 147756,
    /*TargetOpcode::G_SMAX*//*Label 62*/ 149706,
    /*TargetOpcode::G_UMIN*//*Label 63*/ 151656,
    /*TargetOpcode::G_UMAX*//*Label 64*/ 153606, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 65*/ 155556, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 66*/ 155569, 0,
    /*TargetOpcode::G_CTLZ*//*Label 67*/ 155626, 0,
    /*TargetOpcode::G_CTPOP*//*Label 68*/ 155683,
    /*TargetOpcode::G_BSWAP*//*Label 69*/ 155740, 0, 0, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 70*/ 155797, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 71*/ 157040,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 72*/ 158946,
    // Label 0: @183
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 98*/ 2200,
    /*GILLT_s32*//*Label 74*/ 220,
    /*GILLT_s64*//*Label 75*/ 286, 0,
    /*GILLT_nxv1s8*//*Label 76*/ 352,
    /*GILLT_nxv1s16*//*Label 77*/ 436,
    /*GILLT_nxv1s32*//*Label 78*/ 520,
    /*GILLT_nxv1s64*//*Label 79*/ 604, 0,
    /*GILLT_nxv2s8*//*Label 80*/ 688,
    /*GILLT_nxv2s16*//*Label 81*/ 772,
    /*GILLT_nxv2s32*//*Label 82*/ 856,
    /*GILLT_nxv2s64*//*Label 83*/ 940, 0,
    /*GILLT_nxv4s8*//*Label 84*/ 1024,
    /*GILLT_nxv4s16*//*Label 85*/ 1108,
    /*GILLT_nxv4s32*//*Label 86*/ 1192,
    /*GILLT_nxv4s64*//*Label 87*/ 1276, 0,
    /*GILLT_nxv8s8*//*Label 88*/ 1360,
    /*GILLT_nxv8s16*//*Label 89*/ 1444,
    /*GILLT_nxv8s32*//*Label 90*/ 1528,
    /*GILLT_nxv8s64*//*Label 91*/ 1612, 0,
    /*GILLT_nxv16s8*//*Label 92*/ 1696,
    /*GILLT_nxv16s16*//*Label 93*/ 1780,
    /*GILLT_nxv16s32*//*Label 94*/ 1864, 0,
    /*GILLT_nxv32s8*//*Label 95*/ 1948,
    /*GILLT_nxv32s16*//*Label 96*/ 2032, 0,
    /*GILLT_nxv64s8*//*Label 97*/ 2116,
    // Label 74: @220
    GIM_Try, /*On fail goto*//*Label 99*/ 285,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 100*/ 271, // Rule ID 55912 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55912,
        GIR_Done,
      // Label 100: @271
      GIM_Try, /*On fail goto*//*Label 101*/ 284, // Rule ID 55910 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55910,
        GIR_Done,
      // Label 101: @284
      GIM_Reject,
    // Label 99: @285
    GIM_Reject,
    // Label 75: @286
    GIM_Try, /*On fail goto*//*Label 102*/ 351,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 103*/ 337, // Rule ID 55911 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55911,
        GIR_Done,
      // Label 103: @337
      GIM_Try, /*On fail goto*//*Label 104*/ 350, // Rule ID 55909 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55909,
        GIR_Done,
      // Label 104: @350
      GIM_Reject,
    // Label 102: @351
    GIM_Reject,
    // Label 76: @352
    GIM_Try, /*On fail goto*//*Label 105*/ 435,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 106*/ 404, // Rule ID 46447 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46447,
        GIR_Done,
      // Label 106: @404
      GIM_Try, /*On fail goto*//*Label 107*/ 434, // Rule ID 46448 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46448,
        GIR_Done,
      // Label 107: @434
      GIM_Reject,
    // Label 105: @435
    GIM_Reject,
    // Label 77: @436
    GIM_Try, /*On fail goto*//*Label 108*/ 519,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 109*/ 488, // Rule ID 46715 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46715,
        GIR_Done,
      // Label 109: @488
      GIM_Try, /*On fail goto*//*Label 110*/ 518, // Rule ID 46716 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46716,
        GIR_Done,
      // Label 110: @518
      GIM_Reject,
    // Label 108: @519
    GIM_Reject,
    // Label 78: @520
    GIM_Try, /*On fail goto*//*Label 111*/ 603,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 112*/ 572, // Rule ID 46723 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46723,
        GIR_Done,
      // Label 112: @572
      GIM_Try, /*On fail goto*//*Label 113*/ 602, // Rule ID 46724 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46724,
        GIR_Done,
      // Label 113: @602
      GIM_Reject,
    // Label 111: @603
    GIM_Reject,
    // Label 79: @604
    GIM_Try, /*On fail goto*//*Label 114*/ 687,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 115*/ 656, // Rule ID 46739 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46739,
        GIR_Done,
      // Label 115: @656
      GIM_Try, /*On fail goto*//*Label 116*/ 686, // Rule ID 46740 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46740,
        GIR_Done,
      // Label 116: @686
      GIM_Reject,
    // Label 114: @687
    GIM_Reject,
    // Label 80: @688
    GIM_Try, /*On fail goto*//*Label 117*/ 771,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 118*/ 740, // Rule ID 46707 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46707,
        GIR_Done,
      // Label 118: @740
      GIM_Try, /*On fail goto*//*Label 119*/ 770, // Rule ID 46708 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46708,
        GIR_Done,
      // Label 119: @770
      GIM_Reject,
    // Label 117: @771
    GIM_Reject,
    // Label 81: @772
    GIM_Try, /*On fail goto*//*Label 120*/ 855,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 121*/ 824, // Rule ID 46719 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46719,
        GIR_Done,
      // Label 121: @824
      GIM_Try, /*On fail goto*//*Label 122*/ 854, // Rule ID 46720 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46720,
        GIR_Done,
      // Label 122: @854
      GIM_Reject,
    // Label 120: @855
    GIM_Reject,
    // Label 82: @856
    GIM_Try, /*On fail goto*//*Label 123*/ 939,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 124*/ 908, // Rule ID 46735 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46735,
        GIR_Done,
      // Label 124: @908
      GIM_Try, /*On fail goto*//*Label 125*/ 938, // Rule ID 46736 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46736,
        GIR_Done,
      // Label 125: @938
      GIM_Reject,
    // Label 123: @939
    GIM_Reject,
    // Label 83: @940
    GIM_Try, /*On fail goto*//*Label 126*/ 1023,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 127*/ 992, // Rule ID 46779 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46779,
        GIR_Done,
      // Label 127: @992
      GIM_Try, /*On fail goto*//*Label 128*/ 1022, // Rule ID 46780 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46780,
        GIR_Done,
      // Label 128: @1022
      GIM_Reject,
    // Label 126: @1023
    GIM_Reject,
    // Label 84: @1024
    GIM_Try, /*On fail goto*//*Label 129*/ 1107,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 130*/ 1076, // Rule ID 46711 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46711,
        GIR_Done,
      // Label 130: @1076
      GIM_Try, /*On fail goto*//*Label 131*/ 1106, // Rule ID 46712 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46712,
        GIR_Done,
      // Label 131: @1106
      GIM_Reject,
    // Label 129: @1107
    GIM_Reject,
    // Label 85: @1108
    GIM_Try, /*On fail goto*//*Label 132*/ 1191,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 133*/ 1160, // Rule ID 46731 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46731,
        GIR_Done,
      // Label 133: @1160
      GIM_Try, /*On fail goto*//*Label 134*/ 1190, // Rule ID 46732 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46732,
        GIR_Done,
      // Label 134: @1190
      GIM_Reject,
    // Label 132: @1191
    GIM_Reject,
    // Label 86: @1192
    GIM_Try, /*On fail goto*//*Label 135*/ 1275,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 136*/ 1244, // Rule ID 46767 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46767,
        GIR_Done,
      // Label 136: @1244
      GIM_Try, /*On fail goto*//*Label 137*/ 1274, // Rule ID 46768 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46768,
        GIR_Done,
      // Label 137: @1274
      GIM_Reject,
    // Label 135: @1275
    GIM_Reject,
    // Label 87: @1276
    GIM_Try, /*On fail goto*//*Label 138*/ 1359,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 139*/ 1328, // Rule ID 46783 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46783,
        GIR_Done,
      // Label 139: @1328
      GIM_Try, /*On fail goto*//*Label 140*/ 1358, // Rule ID 46784 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46784,
        GIR_Done,
      // Label 140: @1358
      GIM_Reject,
    // Label 138: @1359
    GIM_Reject,
    // Label 88: @1360
    GIM_Try, /*On fail goto*//*Label 141*/ 1443,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 142*/ 1412, // Rule ID 46727 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46727,
        GIR_Done,
      // Label 142: @1412
      GIM_Try, /*On fail goto*//*Label 143*/ 1442, // Rule ID 46728 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46728,
        GIR_Done,
      // Label 143: @1442
      GIM_Reject,
    // Label 141: @1443
    GIM_Reject,
    // Label 89: @1444
    GIM_Try, /*On fail goto*//*Label 144*/ 1527,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 145*/ 1496, // Rule ID 46755 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46755,
        GIR_Done,
      // Label 145: @1496
      GIM_Try, /*On fail goto*//*Label 146*/ 1526, // Rule ID 46756 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46756,
        GIR_Done,
      // Label 146: @1526
      GIM_Reject,
    // Label 144: @1527
    GIM_Reject,
    // Label 90: @1528
    GIM_Try, /*On fail goto*//*Label 147*/ 1611,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 148*/ 1580, // Rule ID 46771 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46771,
        GIR_Done,
      // Label 148: @1580
      GIM_Try, /*On fail goto*//*Label 149*/ 1610, // Rule ID 46772 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46772,
        GIR_Done,
      // Label 149: @1610
      GIM_Reject,
    // Label 147: @1611
    GIM_Reject,
    // Label 91: @1612
    GIM_Try, /*On fail goto*//*Label 150*/ 1695,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 151*/ 1664, // Rule ID 46787 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46787,
        GIR_Done,
      // Label 151: @1664
      GIM_Try, /*On fail goto*//*Label 152*/ 1694, // Rule ID 46788 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46788,
        GIR_Done,
      // Label 152: @1694
      GIM_Reject,
    // Label 150: @1695
    GIM_Reject,
    // Label 92: @1696
    GIM_Try, /*On fail goto*//*Label 153*/ 1779,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 154*/ 1748, // Rule ID 46743 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46743,
        GIR_Done,
      // Label 154: @1748
      GIM_Try, /*On fail goto*//*Label 155*/ 1778, // Rule ID 46744 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46744,
        GIR_Done,
      // Label 155: @1778
      GIM_Reject,
    // Label 153: @1779
    GIM_Reject,
    // Label 93: @1780
    GIM_Try, /*On fail goto*//*Label 156*/ 1863,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 157*/ 1832, // Rule ID 46759 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46759,
        GIR_Done,
      // Label 157: @1832
      GIM_Try, /*On fail goto*//*Label 158*/ 1862, // Rule ID 46760 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46760,
        GIR_Done,
      // Label 158: @1862
      GIM_Reject,
    // Label 156: @1863
    GIM_Reject,
    // Label 94: @1864
    GIM_Try, /*On fail goto*//*Label 159*/ 1947,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 160*/ 1916, // Rule ID 46775 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46775,
        GIR_Done,
      // Label 160: @1916
      GIM_Try, /*On fail goto*//*Label 161*/ 1946, // Rule ID 46776 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46776,
        GIR_Done,
      // Label 161: @1946
      GIM_Reject,
    // Label 159: @1947
    GIM_Reject,
    // Label 95: @1948
    GIM_Try, /*On fail goto*//*Label 162*/ 2031,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 163*/ 2000, // Rule ID 46747 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46747,
        GIR_Done,
      // Label 163: @2000
      GIM_Try, /*On fail goto*//*Label 164*/ 2030, // Rule ID 46748 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46748,
        GIR_Done,
      // Label 164: @2030
      GIM_Reject,
    // Label 162: @2031
    GIM_Reject,
    // Label 96: @2032
    GIM_Try, /*On fail goto*//*Label 165*/ 2115,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 166*/ 2084, // Rule ID 46763 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46763,
        GIR_Done,
      // Label 166: @2084
      GIM_Try, /*On fail goto*//*Label 167*/ 2114, // Rule ID 46764 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46764,
        GIR_Done,
      // Label 167: @2114
      GIM_Reject,
    // Label 165: @2115
    GIM_Reject,
    // Label 97: @2116
    GIM_Try, /*On fail goto*//*Label 168*/ 2199,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 169*/ 2168, // Rule ID 46751 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46751,
        GIR_Done,
      // Label 169: @2168
      GIM_Try, /*On fail goto*//*Label 170*/ 2198, // Rule ID 46752 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46752,
        GIR_Done,
      // Label 170: @2198
      GIM_Reject,
    // Label 168: @2199
    GIM_Reject,
    // Label 98: @2200
    GIM_Reject,
    // Label 1: @2201
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 195*/ 4744,
    /*GILLT_s32*//*Label 171*/ 2238,
    /*GILLT_s64*//*Label 172*/ 2567, 0,
    /*GILLT_nxv1s8*//*Label 173*/ 2896,
    /*GILLT_nxv1s16*//*Label 174*/ 2980,
    /*GILLT_nxv1s32*//*Label 175*/ 3064,
    /*GILLT_nxv1s64*//*Label 176*/ 3148, 0,
    /*GILLT_nxv2s8*//*Label 177*/ 3232,
    /*GILLT_nxv2s16*//*Label 178*/ 3316,
    /*GILLT_nxv2s32*//*Label 179*/ 3400,
    /*GILLT_nxv2s64*//*Label 180*/ 3484, 0,
    /*GILLT_nxv4s8*//*Label 181*/ 3568,
    /*GILLT_nxv4s16*//*Label 182*/ 3652,
    /*GILLT_nxv4s32*//*Label 183*/ 3736,
    /*GILLT_nxv4s64*//*Label 184*/ 3820, 0,
    /*GILLT_nxv8s8*//*Label 185*/ 3904,
    /*GILLT_nxv8s16*//*Label 186*/ 3988,
    /*GILLT_nxv8s32*//*Label 187*/ 4072,
    /*GILLT_nxv8s64*//*Label 188*/ 4156, 0,
    /*GILLT_nxv16s8*//*Label 189*/ 4240,
    /*GILLT_nxv16s16*//*Label 190*/ 4324,
    /*GILLT_nxv16s32*//*Label 191*/ 4408, 0,
    /*GILLT_nxv32s8*//*Label 192*/ 4492,
    /*GILLT_nxv32s16*//*Label 193*/ 4576, 0,
    /*GILLT_nxv64s8*//*Label 194*/ 4660,
    // Label 171: @2238
    GIM_Try, /*On fail goto*//*Label 196*/ 2566,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 197*/ 2326, // Rule ID 56003 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (setcc:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, SETUGE:{ *:[Other] }))  =>  (ADDI:{ *:[i32] } (SLTU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLTU,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56003,
        GIR_Done,
      // Label 197: @2326
      GIM_Try, /*On fail goto*//*Label 198*/ 2400, // Rule ID 56005 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (setcc:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, SETULE:{ *:[Other] }))  =>  (ADDI:{ *:[i32] } (SLTU:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), -1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLTU,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56005,
        GIR_Done,
      // Label 198: @2400
      GIM_Try, /*On fail goto*//*Label 199*/ 2474, // Rule ID 56007 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (setcc:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, SETGE:{ *:[Other] }))  =>  (ADDI:{ *:[i32] } (SLT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLT,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56007,
        GIR_Done,
      // Label 199: @2474
      GIM_Try, /*On fail goto*//*Label 200*/ 2548, // Rule ID 56009 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (setcc:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, SETLE:{ *:[Other] }))  =>  (ADDI:{ *:[i32] } (SLT:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), -1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLT,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56009,
        GIR_Done,
      // Label 200: @2548
      GIM_Try, /*On fail goto*//*Label 201*/ 2565, // Rule ID 55914 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55914,
        GIR_Done,
      // Label 201: @2565
      GIM_Reject,
    // Label 196: @2566
    GIM_Reject,
    // Label 172: @2567
    GIM_Try, /*On fail goto*//*Label 202*/ 2895,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 203*/ 2655, // Rule ID 56002 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (setcc:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, SETUGE:{ *:[Other] }))  =>  (ADDI:{ *:[i64] } (SLTU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLTU,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56002,
        GIR_Done,
      // Label 203: @2655
      GIM_Try, /*On fail goto*//*Label 204*/ 2729, // Rule ID 56004 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (setcc:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, SETULE:{ *:[Other] }))  =>  (ADDI:{ *:[i64] } (SLTU:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), -1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLTU,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56004,
        GIR_Done,
      // Label 204: @2729
      GIM_Try, /*On fail goto*//*Label 205*/ 2803, // Rule ID 56006 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (setcc:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, SETGE:{ *:[Other] }))  =>  (ADDI:{ *:[i64] } (SLT:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLT,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56006,
        GIR_Done,
      // Label 205: @2803
      GIM_Try, /*On fail goto*//*Label 206*/ 2877, // Rule ID 56008 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (setcc:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, SETLE:{ *:[Other] }))  =>  (ADDI:{ *:[i64] } (SLT:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), -1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLT,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rs2
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56008,
        GIR_Done,
      // Label 206: @2877
      GIM_Try, /*On fail goto*//*Label 207*/ 2894, // Rule ID 55913 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55913,
        GIR_Done,
      // Label 207: @2894
      GIM_Reject,
    // Label 202: @2895
    GIM_Reject,
    // Label 173: @2896
    GIM_Try, /*On fail goto*//*Label 208*/ 2979,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 209*/ 2948, // Rule ID 46833 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46833,
        GIR_Done,
      // Label 209: @2948
      GIM_Try, /*On fail goto*//*Label 210*/ 2978, // Rule ID 46834 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46834,
        GIR_Done,
      // Label 210: @2978
      GIM_Reject,
    // Label 208: @2979
    GIM_Reject,
    // Label 174: @2980
    GIM_Try, /*On fail goto*//*Label 211*/ 3063,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 212*/ 3032, // Rule ID 46845 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46845,
        GIR_Done,
      // Label 212: @3032
      GIM_Try, /*On fail goto*//*Label 213*/ 3062, // Rule ID 46846 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46846,
        GIR_Done,
      // Label 213: @3062
      GIM_Reject,
    // Label 211: @3063
    GIM_Reject,
    // Label 175: @3064
    GIM_Try, /*On fail goto*//*Label 214*/ 3147,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 215*/ 3116, // Rule ID 46853 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46853,
        GIR_Done,
      // Label 215: @3116
      GIM_Try, /*On fail goto*//*Label 216*/ 3146, // Rule ID 46854 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46854,
        GIR_Done,
      // Label 216: @3146
      GIM_Reject,
    // Label 214: @3147
    GIM_Reject,
    // Label 176: @3148
    GIM_Try, /*On fail goto*//*Label 217*/ 3231,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 218*/ 3200, // Rule ID 46869 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46869,
        GIR_Done,
      // Label 218: @3200
      GIM_Try, /*On fail goto*//*Label 219*/ 3230, // Rule ID 46870 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46870,
        GIR_Done,
      // Label 219: @3230
      GIM_Reject,
    // Label 217: @3231
    GIM_Reject,
    // Label 177: @3232
    GIM_Try, /*On fail goto*//*Label 220*/ 3315,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 221*/ 3284, // Rule ID 46837 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46837,
        GIR_Done,
      // Label 221: @3284
      GIM_Try, /*On fail goto*//*Label 222*/ 3314, // Rule ID 46838 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46838,
        GIR_Done,
      // Label 222: @3314
      GIM_Reject,
    // Label 220: @3315
    GIM_Reject,
    // Label 178: @3316
    GIM_Try, /*On fail goto*//*Label 223*/ 3399,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 224*/ 3368, // Rule ID 46849 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46849,
        GIR_Done,
      // Label 224: @3368
      GIM_Try, /*On fail goto*//*Label 225*/ 3398, // Rule ID 46850 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46850,
        GIR_Done,
      // Label 225: @3398
      GIM_Reject,
    // Label 223: @3399
    GIM_Reject,
    // Label 179: @3400
    GIM_Try, /*On fail goto*//*Label 226*/ 3483,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 227*/ 3452, // Rule ID 46865 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46865,
        GIR_Done,
      // Label 227: @3452
      GIM_Try, /*On fail goto*//*Label 228*/ 3482, // Rule ID 46866 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46866,
        GIR_Done,
      // Label 228: @3482
      GIM_Reject,
    // Label 226: @3483
    GIM_Reject,
    // Label 180: @3484
    GIM_Try, /*On fail goto*//*Label 229*/ 3567,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 230*/ 3536, // Rule ID 46909 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46909,
        GIR_Done,
      // Label 230: @3536
      GIM_Try, /*On fail goto*//*Label 231*/ 3566, // Rule ID 46910 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46910,
        GIR_Done,
      // Label 231: @3566
      GIM_Reject,
    // Label 229: @3567
    GIM_Reject,
    // Label 181: @3568
    GIM_Try, /*On fail goto*//*Label 232*/ 3651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 233*/ 3620, // Rule ID 46841 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46841,
        GIR_Done,
      // Label 233: @3620
      GIM_Try, /*On fail goto*//*Label 234*/ 3650, // Rule ID 46842 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46842,
        GIR_Done,
      // Label 234: @3650
      GIM_Reject,
    // Label 232: @3651
    GIM_Reject,
    // Label 182: @3652
    GIM_Try, /*On fail goto*//*Label 235*/ 3735,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 236*/ 3704, // Rule ID 46861 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46861,
        GIR_Done,
      // Label 236: @3704
      GIM_Try, /*On fail goto*//*Label 237*/ 3734, // Rule ID 46862 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46862,
        GIR_Done,
      // Label 237: @3734
      GIM_Reject,
    // Label 235: @3735
    GIM_Reject,
    // Label 183: @3736
    GIM_Try, /*On fail goto*//*Label 238*/ 3819,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 239*/ 3788, // Rule ID 46897 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46897,
        GIR_Done,
      // Label 239: @3788
      GIM_Try, /*On fail goto*//*Label 240*/ 3818, // Rule ID 46898 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46898,
        GIR_Done,
      // Label 240: @3818
      GIM_Reject,
    // Label 238: @3819
    GIM_Reject,
    // Label 184: @3820
    GIM_Try, /*On fail goto*//*Label 241*/ 3903,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 242*/ 3872, // Rule ID 46913 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46913,
        GIR_Done,
      // Label 242: @3872
      GIM_Try, /*On fail goto*//*Label 243*/ 3902, // Rule ID 46914 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46914,
        GIR_Done,
      // Label 243: @3902
      GIM_Reject,
    // Label 241: @3903
    GIM_Reject,
    // Label 185: @3904
    GIM_Try, /*On fail goto*//*Label 244*/ 3987,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 245*/ 3956, // Rule ID 46857 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46857,
        GIR_Done,
      // Label 245: @3956
      GIM_Try, /*On fail goto*//*Label 246*/ 3986, // Rule ID 46858 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46858,
        GIR_Done,
      // Label 246: @3986
      GIM_Reject,
    // Label 244: @3987
    GIM_Reject,
    // Label 186: @3988
    GIM_Try, /*On fail goto*//*Label 247*/ 4071,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 248*/ 4040, // Rule ID 46885 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46885,
        GIR_Done,
      // Label 248: @4040
      GIM_Try, /*On fail goto*//*Label 249*/ 4070, // Rule ID 46886 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46886,
        GIR_Done,
      // Label 249: @4070
      GIM_Reject,
    // Label 247: @4071
    GIM_Reject,
    // Label 187: @4072
    GIM_Try, /*On fail goto*//*Label 250*/ 4155,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 251*/ 4124, // Rule ID 46901 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46901,
        GIR_Done,
      // Label 251: @4124
      GIM_Try, /*On fail goto*//*Label 252*/ 4154, // Rule ID 46902 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46902,
        GIR_Done,
      // Label 252: @4154
      GIM_Reject,
    // Label 250: @4155
    GIM_Reject,
    // Label 188: @4156
    GIM_Try, /*On fail goto*//*Label 253*/ 4239,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 254*/ 4208, // Rule ID 46917 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46917,
        GIR_Done,
      // Label 254: @4208
      GIM_Try, /*On fail goto*//*Label 255*/ 4238, // Rule ID 46918 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46918,
        GIR_Done,
      // Label 255: @4238
      GIM_Reject,
    // Label 253: @4239
    GIM_Reject,
    // Label 189: @4240
    GIM_Try, /*On fail goto*//*Label 256*/ 4323,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 257*/ 4292, // Rule ID 46873 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46873,
        GIR_Done,
      // Label 257: @4292
      GIM_Try, /*On fail goto*//*Label 258*/ 4322, // Rule ID 46874 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46874,
        GIR_Done,
      // Label 258: @4322
      GIM_Reject,
    // Label 256: @4323
    GIM_Reject,
    // Label 190: @4324
    GIM_Try, /*On fail goto*//*Label 259*/ 4407,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 260*/ 4376, // Rule ID 46889 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46889,
        GIR_Done,
      // Label 260: @4376
      GIM_Try, /*On fail goto*//*Label 261*/ 4406, // Rule ID 46890 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46890,
        GIR_Done,
      // Label 261: @4406
      GIM_Reject,
    // Label 259: @4407
    GIM_Reject,
    // Label 191: @4408
    GIM_Try, /*On fail goto*//*Label 262*/ 4491,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 263*/ 4460, // Rule ID 46905 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46905,
        GIR_Done,
      // Label 263: @4460
      GIM_Try, /*On fail goto*//*Label 264*/ 4490, // Rule ID 46906 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46906,
        GIR_Done,
      // Label 264: @4490
      GIM_Reject,
    // Label 262: @4491
    GIM_Reject,
    // Label 192: @4492
    GIM_Try, /*On fail goto*//*Label 265*/ 4575,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 266*/ 4544, // Rule ID 46877 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46877,
        GIR_Done,
      // Label 266: @4544
      GIM_Try, /*On fail goto*//*Label 267*/ 4574, // Rule ID 46878 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46878,
        GIR_Done,
      // Label 267: @4574
      GIM_Reject,
    // Label 265: @4575
    GIM_Reject,
    // Label 193: @4576
    GIM_Try, /*On fail goto*//*Label 268*/ 4659,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 269*/ 4628, // Rule ID 46893 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46893,
        GIR_Done,
      // Label 269: @4628
      GIM_Try, /*On fail goto*//*Label 270*/ 4658, // Rule ID 46894 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46894,
        GIR_Done,
      // Label 270: @4658
      GIM_Reject,
    // Label 268: @4659
    GIM_Reject,
    // Label 194: @4660
    GIM_Try, /*On fail goto*//*Label 271*/ 4743,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 272*/ 4712, // Rule ID 46881 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46881,
        GIR_Done,
      // Label 272: @4712
      GIM_Try, /*On fail goto*//*Label 273*/ 4742, // Rule ID 46882 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46882,
        GIR_Done,
      // Label 273: @4742
      GIM_Reject,
    // Label 271: @4743
    GIM_Reject,
    // Label 195: @4744
    GIM_Reject,
    // Label 2: @4745
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 298*/ 6809,
    /*GILLT_s32*//*Label 274*/ 4782,
    /*GILLT_s64*//*Label 275*/ 4814, 0,
    /*GILLT_nxv1s8*//*Label 276*/ 4961,
    /*GILLT_nxv1s16*//*Label 277*/ 5045,
    /*GILLT_nxv1s32*//*Label 278*/ 5129,
    /*GILLT_nxv1s64*//*Label 279*/ 5213, 0,
    /*GILLT_nxv2s8*//*Label 280*/ 5297,
    /*GILLT_nxv2s16*//*Label 281*/ 5381,
    /*GILLT_nxv2s32*//*Label 282*/ 5465,
    /*GILLT_nxv2s64*//*Label 283*/ 5549, 0,
    /*GILLT_nxv4s8*//*Label 284*/ 5633,
    /*GILLT_nxv4s16*//*Label 285*/ 5717,
    /*GILLT_nxv4s32*//*Label 286*/ 5801,
    /*GILLT_nxv4s64*//*Label 287*/ 5885, 0,
    /*GILLT_nxv8s8*//*Label 288*/ 5969,
    /*GILLT_nxv8s16*//*Label 289*/ 6053,
    /*GILLT_nxv8s32*//*Label 290*/ 6137,
    /*GILLT_nxv8s64*//*Label 291*/ 6221, 0,
    /*GILLT_nxv16s8*//*Label 292*/ 6305,
    /*GILLT_nxv16s16*//*Label 293*/ 6389,
    /*GILLT_nxv16s32*//*Label 294*/ 6473, 0,
    /*GILLT_nxv32s8*//*Label 295*/ 6557,
    /*GILLT_nxv32s16*//*Label 296*/ 6641, 0,
    /*GILLT_nxv64s8*//*Label 297*/ 6725,
    // Label 274: @4782
    GIM_Try, /*On fail goto*//*Label 299*/ 4813, // Rule ID 56109 //
      GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56109,
      GIR_Done,
    // Label 299: @4813
    GIM_Reject,
    // Label 275: @4814
    GIM_Try, /*On fail goto*//*Label 300*/ 4960,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 301*/ 4940, // Rule ID 56131 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::MULHU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56131,
        GIR_Done,
      // Label 301: @4940
      GIM_Try, /*On fail goto*//*Label 302*/ 4959, // Rule ID 56108 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56108,
        GIR_Done,
      // Label 302: @4959
      GIM_Reject,
    // Label 300: @4960
    GIM_Reject,
    // Label 276: @4961
    GIM_Try, /*On fail goto*//*Label 303*/ 5044,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 304*/ 5013, // Rule ID 50999 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50999,
        GIR_Done,
      // Label 304: @5013
      GIM_Try, /*On fail goto*//*Label 305*/ 5043, // Rule ID 51000 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51000,
        GIR_Done,
      // Label 305: @5043
      GIM_Reject,
    // Label 303: @5044
    GIM_Reject,
    // Label 277: @5045
    GIM_Try, /*On fail goto*//*Label 306*/ 5128,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 307*/ 5097, // Rule ID 51011 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51011,
        GIR_Done,
      // Label 307: @5097
      GIM_Try, /*On fail goto*//*Label 308*/ 5127, // Rule ID 51012 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51012,
        GIR_Done,
      // Label 308: @5127
      GIM_Reject,
    // Label 306: @5128
    GIM_Reject,
    // Label 278: @5129
    GIM_Try, /*On fail goto*//*Label 309*/ 5212,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 310*/ 5181, // Rule ID 51019 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51019,
        GIR_Done,
      // Label 310: @5181
      GIM_Try, /*On fail goto*//*Label 311*/ 5211, // Rule ID 51020 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51020,
        GIR_Done,
      // Label 311: @5211
      GIM_Reject,
    // Label 309: @5212
    GIM_Reject,
    // Label 279: @5213
    GIM_Try, /*On fail goto*//*Label 312*/ 5296,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 313*/ 5265, // Rule ID 51035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51035,
        GIR_Done,
      // Label 313: @5265
      GIM_Try, /*On fail goto*//*Label 314*/ 5295, // Rule ID 51036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51036,
        GIR_Done,
      // Label 314: @5295
      GIM_Reject,
    // Label 312: @5296
    GIM_Reject,
    // Label 280: @5297
    GIM_Try, /*On fail goto*//*Label 315*/ 5380,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 316*/ 5349, // Rule ID 51003 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51003,
        GIR_Done,
      // Label 316: @5349
      GIM_Try, /*On fail goto*//*Label 317*/ 5379, // Rule ID 51004 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51004,
        GIR_Done,
      // Label 317: @5379
      GIM_Reject,
    // Label 315: @5380
    GIM_Reject,
    // Label 281: @5381
    GIM_Try, /*On fail goto*//*Label 318*/ 5464,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 319*/ 5433, // Rule ID 51015 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51015,
        GIR_Done,
      // Label 319: @5433
      GIM_Try, /*On fail goto*//*Label 320*/ 5463, // Rule ID 51016 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51016,
        GIR_Done,
      // Label 320: @5463
      GIM_Reject,
    // Label 318: @5464
    GIM_Reject,
    // Label 282: @5465
    GIM_Try, /*On fail goto*//*Label 321*/ 5548,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 322*/ 5517, // Rule ID 51031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51031,
        GIR_Done,
      // Label 322: @5517
      GIM_Try, /*On fail goto*//*Label 323*/ 5547, // Rule ID 51032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51032,
        GIR_Done,
      // Label 323: @5547
      GIM_Reject,
    // Label 321: @5548
    GIM_Reject,
    // Label 283: @5549
    GIM_Try, /*On fail goto*//*Label 324*/ 5632,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 325*/ 5601, // Rule ID 51075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51075,
        GIR_Done,
      // Label 325: @5601
      GIM_Try, /*On fail goto*//*Label 326*/ 5631, // Rule ID 51076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51076,
        GIR_Done,
      // Label 326: @5631
      GIM_Reject,
    // Label 324: @5632
    GIM_Reject,
    // Label 284: @5633
    GIM_Try, /*On fail goto*//*Label 327*/ 5716,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 328*/ 5685, // Rule ID 51007 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51007,
        GIR_Done,
      // Label 328: @5685
      GIM_Try, /*On fail goto*//*Label 329*/ 5715, // Rule ID 51008 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51008,
        GIR_Done,
      // Label 329: @5715
      GIM_Reject,
    // Label 327: @5716
    GIM_Reject,
    // Label 285: @5717
    GIM_Try, /*On fail goto*//*Label 330*/ 5800,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 331*/ 5769, // Rule ID 51027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51027,
        GIR_Done,
      // Label 331: @5769
      GIM_Try, /*On fail goto*//*Label 332*/ 5799, // Rule ID 51028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51028,
        GIR_Done,
      // Label 332: @5799
      GIM_Reject,
    // Label 330: @5800
    GIM_Reject,
    // Label 286: @5801
    GIM_Try, /*On fail goto*//*Label 333*/ 5884,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 334*/ 5853, // Rule ID 51063 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51063,
        GIR_Done,
      // Label 334: @5853
      GIM_Try, /*On fail goto*//*Label 335*/ 5883, // Rule ID 51064 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51064,
        GIR_Done,
      // Label 335: @5883
      GIM_Reject,
    // Label 333: @5884
    GIM_Reject,
    // Label 287: @5885
    GIM_Try, /*On fail goto*//*Label 336*/ 5968,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 337*/ 5937, // Rule ID 51079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51079,
        GIR_Done,
      // Label 337: @5937
      GIM_Try, /*On fail goto*//*Label 338*/ 5967, // Rule ID 51080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51080,
        GIR_Done,
      // Label 338: @5967
      GIM_Reject,
    // Label 336: @5968
    GIM_Reject,
    // Label 288: @5969
    GIM_Try, /*On fail goto*//*Label 339*/ 6052,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 340*/ 6021, // Rule ID 51023 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51023,
        GIR_Done,
      // Label 340: @6021
      GIM_Try, /*On fail goto*//*Label 341*/ 6051, // Rule ID 51024 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51024,
        GIR_Done,
      // Label 341: @6051
      GIM_Reject,
    // Label 339: @6052
    GIM_Reject,
    // Label 289: @6053
    GIM_Try, /*On fail goto*//*Label 342*/ 6136,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 343*/ 6105, // Rule ID 51051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51051,
        GIR_Done,
      // Label 343: @6105
      GIM_Try, /*On fail goto*//*Label 344*/ 6135, // Rule ID 51052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51052,
        GIR_Done,
      // Label 344: @6135
      GIM_Reject,
    // Label 342: @6136
    GIM_Reject,
    // Label 290: @6137
    GIM_Try, /*On fail goto*//*Label 345*/ 6220,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 346*/ 6189, // Rule ID 51067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51067,
        GIR_Done,
      // Label 346: @6189
      GIM_Try, /*On fail goto*//*Label 347*/ 6219, // Rule ID 51068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51068,
        GIR_Done,
      // Label 347: @6219
      GIM_Reject,
    // Label 345: @6220
    GIM_Reject,
    // Label 291: @6221
    GIM_Try, /*On fail goto*//*Label 348*/ 6304,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 349*/ 6273, // Rule ID 51083 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51083,
        GIR_Done,
      // Label 349: @6273
      GIM_Try, /*On fail goto*//*Label 350*/ 6303, // Rule ID 51084 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51084,
        GIR_Done,
      // Label 350: @6303
      GIM_Reject,
    // Label 348: @6304
    GIM_Reject,
    // Label 292: @6305
    GIM_Try, /*On fail goto*//*Label 351*/ 6388,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 352*/ 6357, // Rule ID 51039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51039,
        GIR_Done,
      // Label 352: @6357
      GIM_Try, /*On fail goto*//*Label 353*/ 6387, // Rule ID 51040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51040,
        GIR_Done,
      // Label 353: @6387
      GIM_Reject,
    // Label 351: @6388
    GIM_Reject,
    // Label 293: @6389
    GIM_Try, /*On fail goto*//*Label 354*/ 6472,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 355*/ 6441, // Rule ID 51055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51055,
        GIR_Done,
      // Label 355: @6441
      GIM_Try, /*On fail goto*//*Label 356*/ 6471, // Rule ID 51056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51056,
        GIR_Done,
      // Label 356: @6471
      GIM_Reject,
    // Label 354: @6472
    GIM_Reject,
    // Label 294: @6473
    GIM_Try, /*On fail goto*//*Label 357*/ 6556,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 358*/ 6525, // Rule ID 51071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51071,
        GIR_Done,
      // Label 358: @6525
      GIM_Try, /*On fail goto*//*Label 359*/ 6555, // Rule ID 51072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51072,
        GIR_Done,
      // Label 359: @6555
      GIM_Reject,
    // Label 357: @6556
    GIM_Reject,
    // Label 295: @6557
    GIM_Try, /*On fail goto*//*Label 360*/ 6640,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 361*/ 6609, // Rule ID 51043 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51043,
        GIR_Done,
      // Label 361: @6609
      GIM_Try, /*On fail goto*//*Label 362*/ 6639, // Rule ID 51044 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51044,
        GIR_Done,
      // Label 362: @6639
      GIM_Reject,
    // Label 360: @6640
    GIM_Reject,
    // Label 296: @6641
    GIM_Try, /*On fail goto*//*Label 363*/ 6724,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 364*/ 6693, // Rule ID 51059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51059,
        GIR_Done,
      // Label 364: @6693
      GIM_Try, /*On fail goto*//*Label 365*/ 6723, // Rule ID 51060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51060,
        GIR_Done,
      // Label 365: @6723
      GIM_Reject,
    // Label 363: @6724
    GIM_Reject,
    // Label 297: @6725
    GIM_Try, /*On fail goto*//*Label 366*/ 6808,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 367*/ 6777, // Rule ID 51047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51047,
        GIR_Done,
      // Label 367: @6777
      GIM_Try, /*On fail goto*//*Label 368*/ 6807, // Rule ID 51048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51048,
        GIR_Done,
      // Label 368: @6807
      GIM_Reject,
    // Label 366: @6808
    GIM_Reject,
    // Label 298: @6809
    GIM_Reject,
    // Label 3: @6810
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 393*/ 8759,
    /*GILLT_s32*//*Label 369*/ 6847,
    /*GILLT_s64*//*Label 370*/ 6879, 0,
    /*GILLT_nxv1s8*//*Label 371*/ 6911,
    /*GILLT_nxv1s16*//*Label 372*/ 6995,
    /*GILLT_nxv1s32*//*Label 373*/ 7079,
    /*GILLT_nxv1s64*//*Label 374*/ 7163, 0,
    /*GILLT_nxv2s8*//*Label 375*/ 7247,
    /*GILLT_nxv2s16*//*Label 376*/ 7331,
    /*GILLT_nxv2s32*//*Label 377*/ 7415,
    /*GILLT_nxv2s64*//*Label 378*/ 7499, 0,
    /*GILLT_nxv4s8*//*Label 379*/ 7583,
    /*GILLT_nxv4s16*//*Label 380*/ 7667,
    /*GILLT_nxv4s32*//*Label 381*/ 7751,
    /*GILLT_nxv4s64*//*Label 382*/ 7835, 0,
    /*GILLT_nxv8s8*//*Label 383*/ 7919,
    /*GILLT_nxv8s16*//*Label 384*/ 8003,
    /*GILLT_nxv8s32*//*Label 385*/ 8087,
    /*GILLT_nxv8s64*//*Label 386*/ 8171, 0,
    /*GILLT_nxv16s8*//*Label 387*/ 8255,
    /*GILLT_nxv16s16*//*Label 388*/ 8339,
    /*GILLT_nxv16s32*//*Label 389*/ 8423, 0,
    /*GILLT_nxv32s8*//*Label 390*/ 8507,
    /*GILLT_nxv32s16*//*Label 391*/ 8591, 0,
    /*GILLT_nxv64s8*//*Label 392*/ 8675,
    // Label 369: @6847
    GIM_Try, /*On fail goto*//*Label 394*/ 6878, // Rule ID 56117 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56117,
      GIR_Done,
    // Label 394: @6878
    GIM_Reject,
    // Label 370: @6879
    GIM_Try, /*On fail goto*//*Label 395*/ 6910, // Rule ID 56116 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56116,
      GIR_Done,
    // Label 395: @6910
    GIM_Reject,
    // Label 371: @6911
    GIM_Try, /*On fail goto*//*Label 396*/ 6994,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 397*/ 6963, // Rule ID 51351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51351,
        GIR_Done,
      // Label 397: @6963
      GIM_Try, /*On fail goto*//*Label 398*/ 6993, // Rule ID 51352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51352,
        GIR_Done,
      // Label 398: @6993
      GIM_Reject,
    // Label 396: @6994
    GIM_Reject,
    // Label 372: @6995
    GIM_Try, /*On fail goto*//*Label 399*/ 7078,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 400*/ 7047, // Rule ID 51363 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51363,
        GIR_Done,
      // Label 400: @7047
      GIM_Try, /*On fail goto*//*Label 401*/ 7077, // Rule ID 51364 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51364,
        GIR_Done,
      // Label 401: @7077
      GIM_Reject,
    // Label 399: @7078
    GIM_Reject,
    // Label 373: @7079
    GIM_Try, /*On fail goto*//*Label 402*/ 7162,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 403*/ 7131, // Rule ID 51371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51371,
        GIR_Done,
      // Label 403: @7131
      GIM_Try, /*On fail goto*//*Label 404*/ 7161, // Rule ID 51372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51372,
        GIR_Done,
      // Label 404: @7161
      GIM_Reject,
    // Label 402: @7162
    GIM_Reject,
    // Label 374: @7163
    GIM_Try, /*On fail goto*//*Label 405*/ 7246,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 406*/ 7215, // Rule ID 51387 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51387,
        GIR_Done,
      // Label 406: @7215
      GIM_Try, /*On fail goto*//*Label 407*/ 7245, // Rule ID 51388 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51388,
        GIR_Done,
      // Label 407: @7245
      GIM_Reject,
    // Label 405: @7246
    GIM_Reject,
    // Label 375: @7247
    GIM_Try, /*On fail goto*//*Label 408*/ 7330,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 409*/ 7299, // Rule ID 51355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51355,
        GIR_Done,
      // Label 409: @7299
      GIM_Try, /*On fail goto*//*Label 410*/ 7329, // Rule ID 51356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51356,
        GIR_Done,
      // Label 410: @7329
      GIM_Reject,
    // Label 408: @7330
    GIM_Reject,
    // Label 376: @7331
    GIM_Try, /*On fail goto*//*Label 411*/ 7414,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 412*/ 7383, // Rule ID 51367 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51367,
        GIR_Done,
      // Label 412: @7383
      GIM_Try, /*On fail goto*//*Label 413*/ 7413, // Rule ID 51368 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51368,
        GIR_Done,
      // Label 413: @7413
      GIM_Reject,
    // Label 411: @7414
    GIM_Reject,
    // Label 377: @7415
    GIM_Try, /*On fail goto*//*Label 414*/ 7498,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 415*/ 7467, // Rule ID 51383 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51383,
        GIR_Done,
      // Label 415: @7467
      GIM_Try, /*On fail goto*//*Label 416*/ 7497, // Rule ID 51384 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51384,
        GIR_Done,
      // Label 416: @7497
      GIM_Reject,
    // Label 414: @7498
    GIM_Reject,
    // Label 378: @7499
    GIM_Try, /*On fail goto*//*Label 417*/ 7582,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 418*/ 7551, // Rule ID 51427 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51427,
        GIR_Done,
      // Label 418: @7551
      GIM_Try, /*On fail goto*//*Label 419*/ 7581, // Rule ID 51428 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51428,
        GIR_Done,
      // Label 419: @7581
      GIM_Reject,
    // Label 417: @7582
    GIM_Reject,
    // Label 379: @7583
    GIM_Try, /*On fail goto*//*Label 420*/ 7666,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 421*/ 7635, // Rule ID 51359 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51359,
        GIR_Done,
      // Label 421: @7635
      GIM_Try, /*On fail goto*//*Label 422*/ 7665, // Rule ID 51360 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51360,
        GIR_Done,
      // Label 422: @7665
      GIM_Reject,
    // Label 420: @7666
    GIM_Reject,
    // Label 380: @7667
    GIM_Try, /*On fail goto*//*Label 423*/ 7750,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 424*/ 7719, // Rule ID 51379 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51379,
        GIR_Done,
      // Label 424: @7719
      GIM_Try, /*On fail goto*//*Label 425*/ 7749, // Rule ID 51380 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51380,
        GIR_Done,
      // Label 425: @7749
      GIM_Reject,
    // Label 423: @7750
    GIM_Reject,
    // Label 381: @7751
    GIM_Try, /*On fail goto*//*Label 426*/ 7834,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 427*/ 7803, // Rule ID 51415 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51415,
        GIR_Done,
      // Label 427: @7803
      GIM_Try, /*On fail goto*//*Label 428*/ 7833, // Rule ID 51416 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51416,
        GIR_Done,
      // Label 428: @7833
      GIM_Reject,
    // Label 426: @7834
    GIM_Reject,
    // Label 382: @7835
    GIM_Try, /*On fail goto*//*Label 429*/ 7918,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 430*/ 7887, // Rule ID 51431 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51431,
        GIR_Done,
      // Label 430: @7887
      GIM_Try, /*On fail goto*//*Label 431*/ 7917, // Rule ID 51432 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51432,
        GIR_Done,
      // Label 431: @7917
      GIM_Reject,
    // Label 429: @7918
    GIM_Reject,
    // Label 383: @7919
    GIM_Try, /*On fail goto*//*Label 432*/ 8002,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 433*/ 7971, // Rule ID 51375 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51375,
        GIR_Done,
      // Label 433: @7971
      GIM_Try, /*On fail goto*//*Label 434*/ 8001, // Rule ID 51376 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51376,
        GIR_Done,
      // Label 434: @8001
      GIM_Reject,
    // Label 432: @8002
    GIM_Reject,
    // Label 384: @8003
    GIM_Try, /*On fail goto*//*Label 435*/ 8086,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 436*/ 8055, // Rule ID 51403 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51403,
        GIR_Done,
      // Label 436: @8055
      GIM_Try, /*On fail goto*//*Label 437*/ 8085, // Rule ID 51404 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51404,
        GIR_Done,
      // Label 437: @8085
      GIM_Reject,
    // Label 435: @8086
    GIM_Reject,
    // Label 385: @8087
    GIM_Try, /*On fail goto*//*Label 438*/ 8170,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 439*/ 8139, // Rule ID 51419 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51419,
        GIR_Done,
      // Label 439: @8139
      GIM_Try, /*On fail goto*//*Label 440*/ 8169, // Rule ID 51420 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51420,
        GIR_Done,
      // Label 440: @8169
      GIM_Reject,
    // Label 438: @8170
    GIM_Reject,
    // Label 386: @8171
    GIM_Try, /*On fail goto*//*Label 441*/ 8254,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 442*/ 8223, // Rule ID 51435 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51435,
        GIR_Done,
      // Label 442: @8223
      GIM_Try, /*On fail goto*//*Label 443*/ 8253, // Rule ID 51436 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51436,
        GIR_Done,
      // Label 443: @8253
      GIM_Reject,
    // Label 441: @8254
    GIM_Reject,
    // Label 387: @8255
    GIM_Try, /*On fail goto*//*Label 444*/ 8338,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 445*/ 8307, // Rule ID 51391 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51391,
        GIR_Done,
      // Label 445: @8307
      GIM_Try, /*On fail goto*//*Label 446*/ 8337, // Rule ID 51392 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51392,
        GIR_Done,
      // Label 446: @8337
      GIM_Reject,
    // Label 444: @8338
    GIM_Reject,
    // Label 388: @8339
    GIM_Try, /*On fail goto*//*Label 447*/ 8422,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 448*/ 8391, // Rule ID 51407 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51407,
        GIR_Done,
      // Label 448: @8391
      GIM_Try, /*On fail goto*//*Label 449*/ 8421, // Rule ID 51408 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51408,
        GIR_Done,
      // Label 449: @8421
      GIM_Reject,
    // Label 447: @8422
    GIM_Reject,
    // Label 389: @8423
    GIM_Try, /*On fail goto*//*Label 450*/ 8506,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 451*/ 8475, // Rule ID 51423 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51423,
        GIR_Done,
      // Label 451: @8475
      GIM_Try, /*On fail goto*//*Label 452*/ 8505, // Rule ID 51424 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51424,
        GIR_Done,
      // Label 452: @8505
      GIM_Reject,
    // Label 450: @8506
    GIM_Reject,
    // Label 390: @8507
    GIM_Try, /*On fail goto*//*Label 453*/ 8590,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 454*/ 8559, // Rule ID 51395 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51395,
        GIR_Done,
      // Label 454: @8559
      GIM_Try, /*On fail goto*//*Label 455*/ 8589, // Rule ID 51396 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51396,
        GIR_Done,
      // Label 455: @8589
      GIM_Reject,
    // Label 453: @8590
    GIM_Reject,
    // Label 391: @8591
    GIM_Try, /*On fail goto*//*Label 456*/ 8674,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 457*/ 8643, // Rule ID 51411 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51411,
        GIR_Done,
      // Label 457: @8643
      GIM_Try, /*On fail goto*//*Label 458*/ 8673, // Rule ID 51412 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51412,
        GIR_Done,
      // Label 458: @8673
      GIM_Reject,
    // Label 456: @8674
    GIM_Reject,
    // Label 392: @8675
    GIM_Try, /*On fail goto*//*Label 459*/ 8758,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 460*/ 8727, // Rule ID 51399 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51399,
        GIR_Done,
      // Label 460: @8727
      GIM_Try, /*On fail goto*//*Label 461*/ 8757, // Rule ID 51400 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51400,
        GIR_Done,
      // Label 461: @8757
      GIM_Reject,
    // Label 459: @8758
    GIM_Reject,
    // Label 393: @8759
    GIM_Reject,
    // Label 4: @8760
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 486*/ 10709,
    /*GILLT_s32*//*Label 462*/ 8797,
    /*GILLT_s64*//*Label 463*/ 8829, 0,
    /*GILLT_nxv1s8*//*Label 464*/ 8861,
    /*GILLT_nxv1s16*//*Label 465*/ 8945,
    /*GILLT_nxv1s32*//*Label 466*/ 9029,
    /*GILLT_nxv1s64*//*Label 467*/ 9113, 0,
    /*GILLT_nxv2s8*//*Label 468*/ 9197,
    /*GILLT_nxv2s16*//*Label 469*/ 9281,
    /*GILLT_nxv2s32*//*Label 470*/ 9365,
    /*GILLT_nxv2s64*//*Label 471*/ 9449, 0,
    /*GILLT_nxv4s8*//*Label 472*/ 9533,
    /*GILLT_nxv4s16*//*Label 473*/ 9617,
    /*GILLT_nxv4s32*//*Label 474*/ 9701,
    /*GILLT_nxv4s64*//*Label 475*/ 9785, 0,
    /*GILLT_nxv8s8*//*Label 476*/ 9869,
    /*GILLT_nxv8s16*//*Label 477*/ 9953,
    /*GILLT_nxv8s32*//*Label 478*/ 10037,
    /*GILLT_nxv8s64*//*Label 479*/ 10121, 0,
    /*GILLT_nxv16s8*//*Label 480*/ 10205,
    /*GILLT_nxv16s16*//*Label 481*/ 10289,
    /*GILLT_nxv16s32*//*Label 482*/ 10373, 0,
    /*GILLT_nxv32s8*//*Label 483*/ 10457,
    /*GILLT_nxv32s16*//*Label 484*/ 10541, 0,
    /*GILLT_nxv64s8*//*Label 485*/ 10625,
    // Label 462: @8797
    GIM_Try, /*On fail goto*//*Label 487*/ 8828, // Rule ID 56119 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56119,
      GIR_Done,
    // Label 487: @8828
    GIM_Reject,
    // Label 463: @8829
    GIM_Try, /*On fail goto*//*Label 488*/ 8860, // Rule ID 56118 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56118,
      GIR_Done,
    // Label 488: @8860
    GIM_Reject,
    // Label 464: @8861
    GIM_Try, /*On fail goto*//*Label 489*/ 8944,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 490*/ 8913, // Rule ID 51263 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51263,
        GIR_Done,
      // Label 490: @8913
      GIM_Try, /*On fail goto*//*Label 491*/ 8943, // Rule ID 51264 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51264,
        GIR_Done,
      // Label 491: @8943
      GIM_Reject,
    // Label 489: @8944
    GIM_Reject,
    // Label 465: @8945
    GIM_Try, /*On fail goto*//*Label 492*/ 9028,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 493*/ 8997, // Rule ID 51275 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51275,
        GIR_Done,
      // Label 493: @8997
      GIM_Try, /*On fail goto*//*Label 494*/ 9027, // Rule ID 51276 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51276,
        GIR_Done,
      // Label 494: @9027
      GIM_Reject,
    // Label 492: @9028
    GIM_Reject,
    // Label 466: @9029
    GIM_Try, /*On fail goto*//*Label 495*/ 9112,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 496*/ 9081, // Rule ID 51283 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51283,
        GIR_Done,
      // Label 496: @9081
      GIM_Try, /*On fail goto*//*Label 497*/ 9111, // Rule ID 51284 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51284,
        GIR_Done,
      // Label 497: @9111
      GIM_Reject,
    // Label 495: @9112
    GIM_Reject,
    // Label 467: @9113
    GIM_Try, /*On fail goto*//*Label 498*/ 9196,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 499*/ 9165, // Rule ID 51299 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51299,
        GIR_Done,
      // Label 499: @9165
      GIM_Try, /*On fail goto*//*Label 500*/ 9195, // Rule ID 51300 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51300,
        GIR_Done,
      // Label 500: @9195
      GIM_Reject,
    // Label 498: @9196
    GIM_Reject,
    // Label 468: @9197
    GIM_Try, /*On fail goto*//*Label 501*/ 9280,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 502*/ 9249, // Rule ID 51267 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51267,
        GIR_Done,
      // Label 502: @9249
      GIM_Try, /*On fail goto*//*Label 503*/ 9279, // Rule ID 51268 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51268,
        GIR_Done,
      // Label 503: @9279
      GIM_Reject,
    // Label 501: @9280
    GIM_Reject,
    // Label 469: @9281
    GIM_Try, /*On fail goto*//*Label 504*/ 9364,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 505*/ 9333, // Rule ID 51279 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51279,
        GIR_Done,
      // Label 505: @9333
      GIM_Try, /*On fail goto*//*Label 506*/ 9363, // Rule ID 51280 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51280,
        GIR_Done,
      // Label 506: @9363
      GIM_Reject,
    // Label 504: @9364
    GIM_Reject,
    // Label 470: @9365
    GIM_Try, /*On fail goto*//*Label 507*/ 9448,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 508*/ 9417, // Rule ID 51295 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51295,
        GIR_Done,
      // Label 508: @9417
      GIM_Try, /*On fail goto*//*Label 509*/ 9447, // Rule ID 51296 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51296,
        GIR_Done,
      // Label 509: @9447
      GIM_Reject,
    // Label 507: @9448
    GIM_Reject,
    // Label 471: @9449
    GIM_Try, /*On fail goto*//*Label 510*/ 9532,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 511*/ 9501, // Rule ID 51339 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51339,
        GIR_Done,
      // Label 511: @9501
      GIM_Try, /*On fail goto*//*Label 512*/ 9531, // Rule ID 51340 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51340,
        GIR_Done,
      // Label 512: @9531
      GIM_Reject,
    // Label 510: @9532
    GIM_Reject,
    // Label 472: @9533
    GIM_Try, /*On fail goto*//*Label 513*/ 9616,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 514*/ 9585, // Rule ID 51271 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51271,
        GIR_Done,
      // Label 514: @9585
      GIM_Try, /*On fail goto*//*Label 515*/ 9615, // Rule ID 51272 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51272,
        GIR_Done,
      // Label 515: @9615
      GIM_Reject,
    // Label 513: @9616
    GIM_Reject,
    // Label 473: @9617
    GIM_Try, /*On fail goto*//*Label 516*/ 9700,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 517*/ 9669, // Rule ID 51291 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51291,
        GIR_Done,
      // Label 517: @9669
      GIM_Try, /*On fail goto*//*Label 518*/ 9699, // Rule ID 51292 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51292,
        GIR_Done,
      // Label 518: @9699
      GIM_Reject,
    // Label 516: @9700
    GIM_Reject,
    // Label 474: @9701
    GIM_Try, /*On fail goto*//*Label 519*/ 9784,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 520*/ 9753, // Rule ID 51327 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51327,
        GIR_Done,
      // Label 520: @9753
      GIM_Try, /*On fail goto*//*Label 521*/ 9783, // Rule ID 51328 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51328,
        GIR_Done,
      // Label 521: @9783
      GIM_Reject,
    // Label 519: @9784
    GIM_Reject,
    // Label 475: @9785
    GIM_Try, /*On fail goto*//*Label 522*/ 9868,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 523*/ 9837, // Rule ID 51343 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51343,
        GIR_Done,
      // Label 523: @9837
      GIM_Try, /*On fail goto*//*Label 524*/ 9867, // Rule ID 51344 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51344,
        GIR_Done,
      // Label 524: @9867
      GIM_Reject,
    // Label 522: @9868
    GIM_Reject,
    // Label 476: @9869
    GIM_Try, /*On fail goto*//*Label 525*/ 9952,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 526*/ 9921, // Rule ID 51287 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51287,
        GIR_Done,
      // Label 526: @9921
      GIM_Try, /*On fail goto*//*Label 527*/ 9951, // Rule ID 51288 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51288,
        GIR_Done,
      // Label 527: @9951
      GIM_Reject,
    // Label 525: @9952
    GIM_Reject,
    // Label 477: @9953
    GIM_Try, /*On fail goto*//*Label 528*/ 10036,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 529*/ 10005, // Rule ID 51315 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51315,
        GIR_Done,
      // Label 529: @10005
      GIM_Try, /*On fail goto*//*Label 530*/ 10035, // Rule ID 51316 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51316,
        GIR_Done,
      // Label 530: @10035
      GIM_Reject,
    // Label 528: @10036
    GIM_Reject,
    // Label 478: @10037
    GIM_Try, /*On fail goto*//*Label 531*/ 10120,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 532*/ 10089, // Rule ID 51331 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51331,
        GIR_Done,
      // Label 532: @10089
      GIM_Try, /*On fail goto*//*Label 533*/ 10119, // Rule ID 51332 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51332,
        GIR_Done,
      // Label 533: @10119
      GIM_Reject,
    // Label 531: @10120
    GIM_Reject,
    // Label 479: @10121
    GIM_Try, /*On fail goto*//*Label 534*/ 10204,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 535*/ 10173, // Rule ID 51347 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51347,
        GIR_Done,
      // Label 535: @10173
      GIM_Try, /*On fail goto*//*Label 536*/ 10203, // Rule ID 51348 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51348,
        GIR_Done,
      // Label 536: @10203
      GIM_Reject,
    // Label 534: @10204
    GIM_Reject,
    // Label 480: @10205
    GIM_Try, /*On fail goto*//*Label 537*/ 10288,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 538*/ 10257, // Rule ID 51303 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51303,
        GIR_Done,
      // Label 538: @10257
      GIM_Try, /*On fail goto*//*Label 539*/ 10287, // Rule ID 51304 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51304,
        GIR_Done,
      // Label 539: @10287
      GIM_Reject,
    // Label 537: @10288
    GIM_Reject,
    // Label 481: @10289
    GIM_Try, /*On fail goto*//*Label 540*/ 10372,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 541*/ 10341, // Rule ID 51319 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51319,
        GIR_Done,
      // Label 541: @10341
      GIM_Try, /*On fail goto*//*Label 542*/ 10371, // Rule ID 51320 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51320,
        GIR_Done,
      // Label 542: @10371
      GIM_Reject,
    // Label 540: @10372
    GIM_Reject,
    // Label 482: @10373
    GIM_Try, /*On fail goto*//*Label 543*/ 10456,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 544*/ 10425, // Rule ID 51335 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51335,
        GIR_Done,
      // Label 544: @10425
      GIM_Try, /*On fail goto*//*Label 545*/ 10455, // Rule ID 51336 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51336,
        GIR_Done,
      // Label 545: @10455
      GIM_Reject,
    // Label 543: @10456
    GIM_Reject,
    // Label 483: @10457
    GIM_Try, /*On fail goto*//*Label 546*/ 10540,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 547*/ 10509, // Rule ID 51307 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51307,
        GIR_Done,
      // Label 547: @10509
      GIM_Try, /*On fail goto*//*Label 548*/ 10539, // Rule ID 51308 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51308,
        GIR_Done,
      // Label 548: @10539
      GIM_Reject,
    // Label 546: @10540
    GIM_Reject,
    // Label 484: @10541
    GIM_Try, /*On fail goto*//*Label 549*/ 10624,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 550*/ 10593, // Rule ID 51323 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51323,
        GIR_Done,
      // Label 550: @10593
      GIM_Try, /*On fail goto*//*Label 551*/ 10623, // Rule ID 51324 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51324,
        GIR_Done,
      // Label 551: @10623
      GIM_Reject,
    // Label 549: @10624
    GIM_Reject,
    // Label 485: @10625
    GIM_Try, /*On fail goto*//*Label 552*/ 10708,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 553*/ 10677, // Rule ID 51311 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51311,
        GIR_Done,
      // Label 553: @10677
      GIM_Try, /*On fail goto*//*Label 554*/ 10707, // Rule ID 51312 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51312,
        GIR_Done,
      // Label 554: @10707
      GIM_Reject,
    // Label 552: @10708
    GIM_Reject,
    // Label 486: @10709
    GIM_Reject,
    // Label 5: @10710
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 579*/ 12659,
    /*GILLT_s32*//*Label 555*/ 10747,
    /*GILLT_s64*//*Label 556*/ 10779, 0,
    /*GILLT_nxv1s8*//*Label 557*/ 10811,
    /*GILLT_nxv1s16*//*Label 558*/ 10895,
    /*GILLT_nxv1s32*//*Label 559*/ 10979,
    /*GILLT_nxv1s64*//*Label 560*/ 11063, 0,
    /*GILLT_nxv2s8*//*Label 561*/ 11147,
    /*GILLT_nxv2s16*//*Label 562*/ 11231,
    /*GILLT_nxv2s32*//*Label 563*/ 11315,
    /*GILLT_nxv2s64*//*Label 564*/ 11399, 0,
    /*GILLT_nxv4s8*//*Label 565*/ 11483,
    /*GILLT_nxv4s16*//*Label 566*/ 11567,
    /*GILLT_nxv4s32*//*Label 567*/ 11651,
    /*GILLT_nxv4s64*//*Label 568*/ 11735, 0,
    /*GILLT_nxv8s8*//*Label 569*/ 11819,
    /*GILLT_nxv8s16*//*Label 570*/ 11903,
    /*GILLT_nxv8s32*//*Label 571*/ 11987,
    /*GILLT_nxv8s64*//*Label 572*/ 12071, 0,
    /*GILLT_nxv16s8*//*Label 573*/ 12155,
    /*GILLT_nxv16s16*//*Label 574*/ 12239,
    /*GILLT_nxv16s32*//*Label 575*/ 12323, 0,
    /*GILLT_nxv32s8*//*Label 576*/ 12407,
    /*GILLT_nxv32s16*//*Label 577*/ 12491, 0,
    /*GILLT_nxv64s8*//*Label 578*/ 12575,
    // Label 555: @10747
    GIM_Try, /*On fail goto*//*Label 580*/ 10778, // Rule ID 56121 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56121,
      GIR_Done,
    // Label 580: @10778
    GIM_Reject,
    // Label 556: @10779
    GIM_Try, /*On fail goto*//*Label 581*/ 10810, // Rule ID 56120 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56120,
      GIR_Done,
    // Label 581: @10810
    GIM_Reject,
    // Label 557: @10811
    GIM_Try, /*On fail goto*//*Label 582*/ 10894,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 583*/ 10863, // Rule ID 51527 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51527,
        GIR_Done,
      // Label 583: @10863
      GIM_Try, /*On fail goto*//*Label 584*/ 10893, // Rule ID 51528 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51528,
        GIR_Done,
      // Label 584: @10893
      GIM_Reject,
    // Label 582: @10894
    GIM_Reject,
    // Label 558: @10895
    GIM_Try, /*On fail goto*//*Label 585*/ 10978,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 586*/ 10947, // Rule ID 51539 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51539,
        GIR_Done,
      // Label 586: @10947
      GIM_Try, /*On fail goto*//*Label 587*/ 10977, // Rule ID 51540 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51540,
        GIR_Done,
      // Label 587: @10977
      GIM_Reject,
    // Label 585: @10978
    GIM_Reject,
    // Label 559: @10979
    GIM_Try, /*On fail goto*//*Label 588*/ 11062,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 589*/ 11031, // Rule ID 51547 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51547,
        GIR_Done,
      // Label 589: @11031
      GIM_Try, /*On fail goto*//*Label 590*/ 11061, // Rule ID 51548 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51548,
        GIR_Done,
      // Label 590: @11061
      GIM_Reject,
    // Label 588: @11062
    GIM_Reject,
    // Label 560: @11063
    GIM_Try, /*On fail goto*//*Label 591*/ 11146,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 592*/ 11115, // Rule ID 51563 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51563,
        GIR_Done,
      // Label 592: @11115
      GIM_Try, /*On fail goto*//*Label 593*/ 11145, // Rule ID 51564 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51564,
        GIR_Done,
      // Label 593: @11145
      GIM_Reject,
    // Label 591: @11146
    GIM_Reject,
    // Label 561: @11147
    GIM_Try, /*On fail goto*//*Label 594*/ 11230,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 595*/ 11199, // Rule ID 51531 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51531,
        GIR_Done,
      // Label 595: @11199
      GIM_Try, /*On fail goto*//*Label 596*/ 11229, // Rule ID 51532 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51532,
        GIR_Done,
      // Label 596: @11229
      GIM_Reject,
    // Label 594: @11230
    GIM_Reject,
    // Label 562: @11231
    GIM_Try, /*On fail goto*//*Label 597*/ 11314,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 598*/ 11283, // Rule ID 51543 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51543,
        GIR_Done,
      // Label 598: @11283
      GIM_Try, /*On fail goto*//*Label 599*/ 11313, // Rule ID 51544 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51544,
        GIR_Done,
      // Label 599: @11313
      GIM_Reject,
    // Label 597: @11314
    GIM_Reject,
    // Label 563: @11315
    GIM_Try, /*On fail goto*//*Label 600*/ 11398,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 601*/ 11367, // Rule ID 51559 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51559,
        GIR_Done,
      // Label 601: @11367
      GIM_Try, /*On fail goto*//*Label 602*/ 11397, // Rule ID 51560 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51560,
        GIR_Done,
      // Label 602: @11397
      GIM_Reject,
    // Label 600: @11398
    GIM_Reject,
    // Label 564: @11399
    GIM_Try, /*On fail goto*//*Label 603*/ 11482,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 604*/ 11451, // Rule ID 51603 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51603,
        GIR_Done,
      // Label 604: @11451
      GIM_Try, /*On fail goto*//*Label 605*/ 11481, // Rule ID 51604 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51604,
        GIR_Done,
      // Label 605: @11481
      GIM_Reject,
    // Label 603: @11482
    GIM_Reject,
    // Label 565: @11483
    GIM_Try, /*On fail goto*//*Label 606*/ 11566,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 607*/ 11535, // Rule ID 51535 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51535,
        GIR_Done,
      // Label 607: @11535
      GIM_Try, /*On fail goto*//*Label 608*/ 11565, // Rule ID 51536 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51536,
        GIR_Done,
      // Label 608: @11565
      GIM_Reject,
    // Label 606: @11566
    GIM_Reject,
    // Label 566: @11567
    GIM_Try, /*On fail goto*//*Label 609*/ 11650,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 610*/ 11619, // Rule ID 51555 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51555,
        GIR_Done,
      // Label 610: @11619
      GIM_Try, /*On fail goto*//*Label 611*/ 11649, // Rule ID 51556 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51556,
        GIR_Done,
      // Label 611: @11649
      GIM_Reject,
    // Label 609: @11650
    GIM_Reject,
    // Label 567: @11651
    GIM_Try, /*On fail goto*//*Label 612*/ 11734,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 613*/ 11703, // Rule ID 51591 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51591,
        GIR_Done,
      // Label 613: @11703
      GIM_Try, /*On fail goto*//*Label 614*/ 11733, // Rule ID 51592 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51592,
        GIR_Done,
      // Label 614: @11733
      GIM_Reject,
    // Label 612: @11734
    GIM_Reject,
    // Label 568: @11735
    GIM_Try, /*On fail goto*//*Label 615*/ 11818,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 616*/ 11787, // Rule ID 51607 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51607,
        GIR_Done,
      // Label 616: @11787
      GIM_Try, /*On fail goto*//*Label 617*/ 11817, // Rule ID 51608 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51608,
        GIR_Done,
      // Label 617: @11817
      GIM_Reject,
    // Label 615: @11818
    GIM_Reject,
    // Label 569: @11819
    GIM_Try, /*On fail goto*//*Label 618*/ 11902,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 619*/ 11871, // Rule ID 51551 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51551,
        GIR_Done,
      // Label 619: @11871
      GIM_Try, /*On fail goto*//*Label 620*/ 11901, // Rule ID 51552 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51552,
        GIR_Done,
      // Label 620: @11901
      GIM_Reject,
    // Label 618: @11902
    GIM_Reject,
    // Label 570: @11903
    GIM_Try, /*On fail goto*//*Label 621*/ 11986,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 622*/ 11955, // Rule ID 51579 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51579,
        GIR_Done,
      // Label 622: @11955
      GIM_Try, /*On fail goto*//*Label 623*/ 11985, // Rule ID 51580 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51580,
        GIR_Done,
      // Label 623: @11985
      GIM_Reject,
    // Label 621: @11986
    GIM_Reject,
    // Label 571: @11987
    GIM_Try, /*On fail goto*//*Label 624*/ 12070,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 625*/ 12039, // Rule ID 51595 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51595,
        GIR_Done,
      // Label 625: @12039
      GIM_Try, /*On fail goto*//*Label 626*/ 12069, // Rule ID 51596 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51596,
        GIR_Done,
      // Label 626: @12069
      GIM_Reject,
    // Label 624: @12070
    GIM_Reject,
    // Label 572: @12071
    GIM_Try, /*On fail goto*//*Label 627*/ 12154,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 628*/ 12123, // Rule ID 51611 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51611,
        GIR_Done,
      // Label 628: @12123
      GIM_Try, /*On fail goto*//*Label 629*/ 12153, // Rule ID 51612 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51612,
        GIR_Done,
      // Label 629: @12153
      GIM_Reject,
    // Label 627: @12154
    GIM_Reject,
    // Label 573: @12155
    GIM_Try, /*On fail goto*//*Label 630*/ 12238,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 631*/ 12207, // Rule ID 51567 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51567,
        GIR_Done,
      // Label 631: @12207
      GIM_Try, /*On fail goto*//*Label 632*/ 12237, // Rule ID 51568 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51568,
        GIR_Done,
      // Label 632: @12237
      GIM_Reject,
    // Label 630: @12238
    GIM_Reject,
    // Label 574: @12239
    GIM_Try, /*On fail goto*//*Label 633*/ 12322,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 634*/ 12291, // Rule ID 51583 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51583,
        GIR_Done,
      // Label 634: @12291
      GIM_Try, /*On fail goto*//*Label 635*/ 12321, // Rule ID 51584 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51584,
        GIR_Done,
      // Label 635: @12321
      GIM_Reject,
    // Label 633: @12322
    GIM_Reject,
    // Label 575: @12323
    GIM_Try, /*On fail goto*//*Label 636*/ 12406,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 637*/ 12375, // Rule ID 51599 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51599,
        GIR_Done,
      // Label 637: @12375
      GIM_Try, /*On fail goto*//*Label 638*/ 12405, // Rule ID 51600 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51600,
        GIR_Done,
      // Label 638: @12405
      GIM_Reject,
    // Label 636: @12406
    GIM_Reject,
    // Label 576: @12407
    GIM_Try, /*On fail goto*//*Label 639*/ 12490,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 640*/ 12459, // Rule ID 51571 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51571,
        GIR_Done,
      // Label 640: @12459
      GIM_Try, /*On fail goto*//*Label 641*/ 12489, // Rule ID 51572 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51572,
        GIR_Done,
      // Label 641: @12489
      GIM_Reject,
    // Label 639: @12490
    GIM_Reject,
    // Label 577: @12491
    GIM_Try, /*On fail goto*//*Label 642*/ 12574,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 643*/ 12543, // Rule ID 51587 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51587,
        GIR_Done,
      // Label 643: @12543
      GIM_Try, /*On fail goto*//*Label 644*/ 12573, // Rule ID 51588 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51588,
        GIR_Done,
      // Label 644: @12573
      GIM_Reject,
    // Label 642: @12574
    GIM_Reject,
    // Label 578: @12575
    GIM_Try, /*On fail goto*//*Label 645*/ 12658,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 646*/ 12627, // Rule ID 51575 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51575,
        GIR_Done,
      // Label 646: @12627
      GIM_Try, /*On fail goto*//*Label 647*/ 12657, // Rule ID 51576 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51576,
        GIR_Done,
      // Label 647: @12657
      GIM_Reject,
    // Label 645: @12658
    GIM_Reject,
    // Label 579: @12659
    GIM_Reject,
    // Label 6: @12660
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 672*/ 14609,
    /*GILLT_s32*//*Label 648*/ 12697,
    /*GILLT_s64*//*Label 649*/ 12729, 0,
    /*GILLT_nxv1s8*//*Label 650*/ 12761,
    /*GILLT_nxv1s16*//*Label 651*/ 12845,
    /*GILLT_nxv1s32*//*Label 652*/ 12929,
    /*GILLT_nxv1s64*//*Label 653*/ 13013, 0,
    /*GILLT_nxv2s8*//*Label 654*/ 13097,
    /*GILLT_nxv2s16*//*Label 655*/ 13181,
    /*GILLT_nxv2s32*//*Label 656*/ 13265,
    /*GILLT_nxv2s64*//*Label 657*/ 13349, 0,
    /*GILLT_nxv4s8*//*Label 658*/ 13433,
    /*GILLT_nxv4s16*//*Label 659*/ 13517,
    /*GILLT_nxv4s32*//*Label 660*/ 13601,
    /*GILLT_nxv4s64*//*Label 661*/ 13685, 0,
    /*GILLT_nxv8s8*//*Label 662*/ 13769,
    /*GILLT_nxv8s16*//*Label 663*/ 13853,
    /*GILLT_nxv8s32*//*Label 664*/ 13937,
    /*GILLT_nxv8s64*//*Label 665*/ 14021, 0,
    /*GILLT_nxv16s8*//*Label 666*/ 14105,
    /*GILLT_nxv16s16*//*Label 667*/ 14189,
    /*GILLT_nxv16s32*//*Label 668*/ 14273, 0,
    /*GILLT_nxv32s8*//*Label 669*/ 14357,
    /*GILLT_nxv32s16*//*Label 670*/ 14441, 0,
    /*GILLT_nxv64s8*//*Label 671*/ 14525,
    // Label 648: @12697
    GIM_Try, /*On fail goto*//*Label 673*/ 12728, // Rule ID 56123 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56123,
      GIR_Done,
    // Label 673: @12728
    GIM_Reject,
    // Label 649: @12729
    GIM_Try, /*On fail goto*//*Label 674*/ 12760, // Rule ID 56122 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56122,
      GIR_Done,
    // Label 674: @12760
    GIM_Reject,
    // Label 650: @12761
    GIM_Try, /*On fail goto*//*Label 675*/ 12844,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 676*/ 12813, // Rule ID 51439 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51439,
        GIR_Done,
      // Label 676: @12813
      GIM_Try, /*On fail goto*//*Label 677*/ 12843, // Rule ID 51440 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51440,
        GIR_Done,
      // Label 677: @12843
      GIM_Reject,
    // Label 675: @12844
    GIM_Reject,
    // Label 651: @12845
    GIM_Try, /*On fail goto*//*Label 678*/ 12928,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 679*/ 12897, // Rule ID 51451 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51451,
        GIR_Done,
      // Label 679: @12897
      GIM_Try, /*On fail goto*//*Label 680*/ 12927, // Rule ID 51452 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51452,
        GIR_Done,
      // Label 680: @12927
      GIM_Reject,
    // Label 678: @12928
    GIM_Reject,
    // Label 652: @12929
    GIM_Try, /*On fail goto*//*Label 681*/ 13012,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 682*/ 12981, // Rule ID 51459 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51459,
        GIR_Done,
      // Label 682: @12981
      GIM_Try, /*On fail goto*//*Label 683*/ 13011, // Rule ID 51460 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51460,
        GIR_Done,
      // Label 683: @13011
      GIM_Reject,
    // Label 681: @13012
    GIM_Reject,
    // Label 653: @13013
    GIM_Try, /*On fail goto*//*Label 684*/ 13096,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 685*/ 13065, // Rule ID 51475 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51475,
        GIR_Done,
      // Label 685: @13065
      GIM_Try, /*On fail goto*//*Label 686*/ 13095, // Rule ID 51476 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51476,
        GIR_Done,
      // Label 686: @13095
      GIM_Reject,
    // Label 684: @13096
    GIM_Reject,
    // Label 654: @13097
    GIM_Try, /*On fail goto*//*Label 687*/ 13180,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 688*/ 13149, // Rule ID 51443 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51443,
        GIR_Done,
      // Label 688: @13149
      GIM_Try, /*On fail goto*//*Label 689*/ 13179, // Rule ID 51444 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51444,
        GIR_Done,
      // Label 689: @13179
      GIM_Reject,
    // Label 687: @13180
    GIM_Reject,
    // Label 655: @13181
    GIM_Try, /*On fail goto*//*Label 690*/ 13264,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 691*/ 13233, // Rule ID 51455 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51455,
        GIR_Done,
      // Label 691: @13233
      GIM_Try, /*On fail goto*//*Label 692*/ 13263, // Rule ID 51456 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51456,
        GIR_Done,
      // Label 692: @13263
      GIM_Reject,
    // Label 690: @13264
    GIM_Reject,
    // Label 656: @13265
    GIM_Try, /*On fail goto*//*Label 693*/ 13348,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 694*/ 13317, // Rule ID 51471 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51471,
        GIR_Done,
      // Label 694: @13317
      GIM_Try, /*On fail goto*//*Label 695*/ 13347, // Rule ID 51472 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51472,
        GIR_Done,
      // Label 695: @13347
      GIM_Reject,
    // Label 693: @13348
    GIM_Reject,
    // Label 657: @13349
    GIM_Try, /*On fail goto*//*Label 696*/ 13432,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 697*/ 13401, // Rule ID 51515 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51515,
        GIR_Done,
      // Label 697: @13401
      GIM_Try, /*On fail goto*//*Label 698*/ 13431, // Rule ID 51516 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51516,
        GIR_Done,
      // Label 698: @13431
      GIM_Reject,
    // Label 696: @13432
    GIM_Reject,
    // Label 658: @13433
    GIM_Try, /*On fail goto*//*Label 699*/ 13516,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 700*/ 13485, // Rule ID 51447 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51447,
        GIR_Done,
      // Label 700: @13485
      GIM_Try, /*On fail goto*//*Label 701*/ 13515, // Rule ID 51448 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51448,
        GIR_Done,
      // Label 701: @13515
      GIM_Reject,
    // Label 699: @13516
    GIM_Reject,
    // Label 659: @13517
    GIM_Try, /*On fail goto*//*Label 702*/ 13600,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 703*/ 13569, // Rule ID 51467 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51467,
        GIR_Done,
      // Label 703: @13569
      GIM_Try, /*On fail goto*//*Label 704*/ 13599, // Rule ID 51468 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51468,
        GIR_Done,
      // Label 704: @13599
      GIM_Reject,
    // Label 702: @13600
    GIM_Reject,
    // Label 660: @13601
    GIM_Try, /*On fail goto*//*Label 705*/ 13684,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 706*/ 13653, // Rule ID 51503 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51503,
        GIR_Done,
      // Label 706: @13653
      GIM_Try, /*On fail goto*//*Label 707*/ 13683, // Rule ID 51504 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51504,
        GIR_Done,
      // Label 707: @13683
      GIM_Reject,
    // Label 705: @13684
    GIM_Reject,
    // Label 661: @13685
    GIM_Try, /*On fail goto*//*Label 708*/ 13768,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 709*/ 13737, // Rule ID 51519 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51519,
        GIR_Done,
      // Label 709: @13737
      GIM_Try, /*On fail goto*//*Label 710*/ 13767, // Rule ID 51520 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51520,
        GIR_Done,
      // Label 710: @13767
      GIM_Reject,
    // Label 708: @13768
    GIM_Reject,
    // Label 662: @13769
    GIM_Try, /*On fail goto*//*Label 711*/ 13852,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 712*/ 13821, // Rule ID 51463 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51463,
        GIR_Done,
      // Label 712: @13821
      GIM_Try, /*On fail goto*//*Label 713*/ 13851, // Rule ID 51464 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51464,
        GIR_Done,
      // Label 713: @13851
      GIM_Reject,
    // Label 711: @13852
    GIM_Reject,
    // Label 663: @13853
    GIM_Try, /*On fail goto*//*Label 714*/ 13936,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 715*/ 13905, // Rule ID 51491 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51491,
        GIR_Done,
      // Label 715: @13905
      GIM_Try, /*On fail goto*//*Label 716*/ 13935, // Rule ID 51492 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51492,
        GIR_Done,
      // Label 716: @13935
      GIM_Reject,
    // Label 714: @13936
    GIM_Reject,
    // Label 664: @13937
    GIM_Try, /*On fail goto*//*Label 717*/ 14020,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 718*/ 13989, // Rule ID 51507 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51507,
        GIR_Done,
      // Label 718: @13989
      GIM_Try, /*On fail goto*//*Label 719*/ 14019, // Rule ID 51508 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51508,
        GIR_Done,
      // Label 719: @14019
      GIM_Reject,
    // Label 717: @14020
    GIM_Reject,
    // Label 665: @14021
    GIM_Try, /*On fail goto*//*Label 720*/ 14104,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 721*/ 14073, // Rule ID 51523 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51523,
        GIR_Done,
      // Label 721: @14073
      GIM_Try, /*On fail goto*//*Label 722*/ 14103, // Rule ID 51524 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51524,
        GIR_Done,
      // Label 722: @14103
      GIM_Reject,
    // Label 720: @14104
    GIM_Reject,
    // Label 666: @14105
    GIM_Try, /*On fail goto*//*Label 723*/ 14188,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 724*/ 14157, // Rule ID 51479 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51479,
        GIR_Done,
      // Label 724: @14157
      GIM_Try, /*On fail goto*//*Label 725*/ 14187, // Rule ID 51480 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51480,
        GIR_Done,
      // Label 725: @14187
      GIM_Reject,
    // Label 723: @14188
    GIM_Reject,
    // Label 667: @14189
    GIM_Try, /*On fail goto*//*Label 726*/ 14272,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 727*/ 14241, // Rule ID 51495 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51495,
        GIR_Done,
      // Label 727: @14241
      GIM_Try, /*On fail goto*//*Label 728*/ 14271, // Rule ID 51496 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51496,
        GIR_Done,
      // Label 728: @14271
      GIM_Reject,
    // Label 726: @14272
    GIM_Reject,
    // Label 668: @14273
    GIM_Try, /*On fail goto*//*Label 729*/ 14356,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 730*/ 14325, // Rule ID 51511 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51511,
        GIR_Done,
      // Label 730: @14325
      GIM_Try, /*On fail goto*//*Label 731*/ 14355, // Rule ID 51512 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51512,
        GIR_Done,
      // Label 731: @14355
      GIM_Reject,
    // Label 729: @14356
    GIM_Reject,
    // Label 669: @14357
    GIM_Try, /*On fail goto*//*Label 732*/ 14440,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 733*/ 14409, // Rule ID 51483 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51483,
        GIR_Done,
      // Label 733: @14409
      GIM_Try, /*On fail goto*//*Label 734*/ 14439, // Rule ID 51484 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51484,
        GIR_Done,
      // Label 734: @14439
      GIM_Reject,
    // Label 732: @14440
    GIM_Reject,
    // Label 670: @14441
    GIM_Try, /*On fail goto*//*Label 735*/ 14524,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 736*/ 14493, // Rule ID 51499 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51499,
        GIR_Done,
      // Label 736: @14493
      GIM_Try, /*On fail goto*//*Label 737*/ 14523, // Rule ID 51500 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51500,
        GIR_Done,
      // Label 737: @14523
      GIM_Reject,
    // Label 735: @14524
    GIM_Reject,
    // Label 671: @14525
    GIM_Try, /*On fail goto*//*Label 738*/ 14608,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 739*/ 14577, // Rule ID 51487 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51487,
        GIR_Done,
      // Label 739: @14577
      GIM_Try, /*On fail goto*//*Label 740*/ 14607, // Rule ID 51488 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51488,
        GIR_Done,
      // Label 740: @14607
      GIM_Reject,
    // Label 738: @14608
    GIM_Reject,
    // Label 672: @14609
    GIM_Reject,
    // Label 7: @14610
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 772*/ 18105,
    /*GILLT_s32*//*Label 741*/ 14647,
    /*GILLT_s64*//*Label 742*/ 15117,
    /*GILLT_nxv1s1*//*Label 743*/ 15669,
    /*GILLT_nxv1s8*//*Label 744*/ 15753,
    /*GILLT_nxv1s16*//*Label 745*/ 15837,
    /*GILLT_nxv1s32*//*Label 746*/ 15921,
    /*GILLT_nxv1s64*//*Label 747*/ 16005,
    /*GILLT_nxv2s1*//*Label 748*/ 16089,
    /*GILLT_nxv2s8*//*Label 749*/ 16173,
    /*GILLT_nxv2s16*//*Label 750*/ 16257,
    /*GILLT_nxv2s32*//*Label 751*/ 16341,
    /*GILLT_nxv2s64*//*Label 752*/ 16425,
    /*GILLT_nxv4s1*//*Label 753*/ 16509,
    /*GILLT_nxv4s8*//*Label 754*/ 16593,
    /*GILLT_nxv4s16*//*Label 755*/ 16677,
    /*GILLT_nxv4s32*//*Label 756*/ 16761,
    /*GILLT_nxv4s64*//*Label 757*/ 16845,
    /*GILLT_nxv8s1*//*Label 758*/ 16929,
    /*GILLT_nxv8s8*//*Label 759*/ 17013,
    /*GILLT_nxv8s16*//*Label 760*/ 17097,
    /*GILLT_nxv8s32*//*Label 761*/ 17181,
    /*GILLT_nxv8s64*//*Label 762*/ 17265,
    /*GILLT_nxv16s1*//*Label 763*/ 17349,
    /*GILLT_nxv16s8*//*Label 764*/ 17433,
    /*GILLT_nxv16s16*//*Label 765*/ 17517,
    /*GILLT_nxv16s32*//*Label 766*/ 17601,
    /*GILLT_nxv32s1*//*Label 767*/ 17685,
    /*GILLT_nxv32s8*//*Label 768*/ 17769,
    /*GILLT_nxv32s16*//*Label 769*/ 17853,
    /*GILLT_nxv64s1*//*Label 770*/ 17937,
    /*GILLT_nxv64s8*//*Label 771*/ 18021,
    // Label 741: @14647
    GIM_Try, /*On fail goto*//*Label 773*/ 15116,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 774*/ 14761, // Rule ID 56717 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), -1:{ *:[i32] }), 1:{ *:[i32] })  =>  (XORI:{ *:[i32] } (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::BEXTI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56717,
        GIR_Done,
      // Label 774: @14761
      GIM_Try, /*On fail goto*//*Label 775*/ 14821, // Rule ID 56715 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56715,
        GIR_Done,
      // Label 775: @14821
      GIM_Try, /*On fail goto*//*Label 776*/ 14874, // Rule ID 56699 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56699,
        GIR_Done,
      // Label 776: @14874
      GIM_Try, /*On fail goto*//*Label 777*/ 14927, // Rule ID 62348 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62348,
        GIR_Done,
      // Label 777: @14927
      GIM_Try, /*On fail goto*//*Label 778*/ 14980, // Rule ID 62358 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62358,
        GIR_Done,
      // Label 778: @14980
      GIM_Try, /*On fail goto*//*Label 779*/ 15033, // Rule ID 56679 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56679,
        GIR_Done,
      // Label 779: @15033
      GIM_Try, /*On fail goto*//*Label 780*/ 15061, // Rule ID 56846 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbp_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56846,
        GIR_Done,
      // Label 780: @15061
      GIM_Try, /*On fail goto*//*Label 781*/ 15098, // Rule ID 55922 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55922,
        GIR_Done,
      // Label 781: @15098
      GIM_Try, /*On fail goto*//*Label 782*/ 15115, // Rule ID 55920 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55920,
        GIR_Done,
      // Label 782: @15115
      GIM_Reject,
    // Label 773: @15116
    GIM_Reject,
    // Label 742: @15117
    GIM_Try, /*On fail goto*//*Label 783*/ 15668,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 784*/ 15231, // Rule ID 56716 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (xor:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), -1:{ *:[i64] }), 1:{ *:[i64] })  =>  (XORI:{ *:[i64] } (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::BEXTI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56716,
        GIR_Done,
      // Label 784: @15231
      GIM_Try, /*On fail goto*//*Label 785*/ 15291, // Rule ID 56714 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56714,
        GIR_Done,
      // Label 785: @15291
      GIM_Try, /*On fail goto*//*Label 786*/ 15344, // Rule ID 56698 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56698,
        GIR_Done,
      // Label 786: @15344
      GIM_Try, /*On fail goto*//*Label 787*/ 15397, // Rule ID 62347 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62347,
        GIR_Done,
      // Label 787: @15397
      GIM_Try, /*On fail goto*//*Label 788*/ 15450, // Rule ID 62357 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62357,
        GIR_Done,
      // Label 788: @15450
      GIM_Try, /*On fail goto*//*Label 789*/ 15503, // Rule ID 56678 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56678,
        GIR_Done,
      // Label 789: @15503
      GIM_Try, /*On fail goto*//*Label 790*/ 15553, // Rule ID 56080 //
        GIM_CheckFeatures, GIFBS_IsRV64_NotHasStdExtZba,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::SRLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56080,
        GIR_Done,
      // Label 790: @15553
      GIM_Try, /*On fail goto*//*Label 791*/ 15581, // Rule ID 56847 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbp_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56847,
        GIR_Done,
      // Label 791: @15581
      GIM_Try, /*On fail goto*//*Label 792*/ 15613, // Rule ID 56912 //
        GIM_CheckFeatures, GIFBS_HasStdExtZba_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADD_UW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56912,
        GIR_Done,
      // Label 792: @15613
      GIM_Try, /*On fail goto*//*Label 793*/ 15650, // Rule ID 55921 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55921,
        GIR_Done,
      // Label 793: @15650
      GIM_Try, /*On fail goto*//*Label 794*/ 15667, // Rule ID 55919 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55919,
        GIR_Done,
      // Label 794: @15667
      GIM_Reject,
    // Label 783: @15668
    GIM_Reject,
    // Label 743: @15669
    GIM_Try, /*On fail goto*//*Label 795*/ 15752,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 796*/ 15721, // Rule ID 52925 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52925,
        GIR_Done,
      // Label 796: @15721
      GIM_Try, /*On fail goto*//*Label 797*/ 15751, // Rule ID 52926 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52926,
        GIR_Done,
      // Label 797: @15751
      GIM_Reject,
    // Label 795: @15752
    GIM_Reject,
    // Label 744: @15753
    GIM_Try, /*On fail goto*//*Label 798*/ 15836,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 799*/ 15805, // Rule ID 47887 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47887,
        GIR_Done,
      // Label 799: @15805
      GIM_Try, /*On fail goto*//*Label 800*/ 15835, // Rule ID 47888 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47888,
        GIR_Done,
      // Label 800: @15835
      GIM_Reject,
    // Label 798: @15836
    GIM_Reject,
    // Label 745: @15837
    GIM_Try, /*On fail goto*//*Label 801*/ 15920,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 802*/ 15889, // Rule ID 47899 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47899,
        GIR_Done,
      // Label 802: @15889
      GIM_Try, /*On fail goto*//*Label 803*/ 15919, // Rule ID 47900 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47900,
        GIR_Done,
      // Label 803: @15919
      GIM_Reject,
    // Label 801: @15920
    GIM_Reject,
    // Label 746: @15921
    GIM_Try, /*On fail goto*//*Label 804*/ 16004,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 805*/ 15973, // Rule ID 47907 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47907,
        GIR_Done,
      // Label 805: @15973
      GIM_Try, /*On fail goto*//*Label 806*/ 16003, // Rule ID 47908 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47908,
        GIR_Done,
      // Label 806: @16003
      GIM_Reject,
    // Label 804: @16004
    GIM_Reject,
    // Label 747: @16005
    GIM_Try, /*On fail goto*//*Label 807*/ 16088,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 808*/ 16057, // Rule ID 47923 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47923,
        GIR_Done,
      // Label 808: @16057
      GIM_Try, /*On fail goto*//*Label 809*/ 16087, // Rule ID 47924 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47924,
        GIR_Done,
      // Label 809: @16087
      GIM_Reject,
    // Label 807: @16088
    GIM_Reject,
    // Label 748: @16089
    GIM_Try, /*On fail goto*//*Label 810*/ 16172,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 811*/ 16141, // Rule ID 52943 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52943,
        GIR_Done,
      // Label 811: @16141
      GIM_Try, /*On fail goto*//*Label 812*/ 16171, // Rule ID 52944 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52944,
        GIR_Done,
      // Label 812: @16171
      GIM_Reject,
    // Label 810: @16172
    GIM_Reject,
    // Label 749: @16173
    GIM_Try, /*On fail goto*//*Label 813*/ 16256,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 814*/ 16225, // Rule ID 47891 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47891,
        GIR_Done,
      // Label 814: @16225
      GIM_Try, /*On fail goto*//*Label 815*/ 16255, // Rule ID 47892 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47892,
        GIR_Done,
      // Label 815: @16255
      GIM_Reject,
    // Label 813: @16256
    GIM_Reject,
    // Label 750: @16257
    GIM_Try, /*On fail goto*//*Label 816*/ 16340,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 817*/ 16309, // Rule ID 47903 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47903,
        GIR_Done,
      // Label 817: @16309
      GIM_Try, /*On fail goto*//*Label 818*/ 16339, // Rule ID 47904 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47904,
        GIR_Done,
      // Label 818: @16339
      GIM_Reject,
    // Label 816: @16340
    GIM_Reject,
    // Label 751: @16341
    GIM_Try, /*On fail goto*//*Label 819*/ 16424,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 820*/ 16393, // Rule ID 47919 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47919,
        GIR_Done,
      // Label 820: @16393
      GIM_Try, /*On fail goto*//*Label 821*/ 16423, // Rule ID 47920 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47920,
        GIR_Done,
      // Label 821: @16423
      GIM_Reject,
    // Label 819: @16424
    GIM_Reject,
    // Label 752: @16425
    GIM_Try, /*On fail goto*//*Label 822*/ 16508,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 823*/ 16477, // Rule ID 47963 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47963,
        GIR_Done,
      // Label 823: @16477
      GIM_Try, /*On fail goto*//*Label 824*/ 16507, // Rule ID 47964 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47964,
        GIR_Done,
      // Label 824: @16507
      GIM_Reject,
    // Label 822: @16508
    GIM_Reject,
    // Label 753: @16509
    GIM_Try, /*On fail goto*//*Label 825*/ 16592,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 826*/ 16561, // Rule ID 52961 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52961,
        GIR_Done,
      // Label 826: @16561
      GIM_Try, /*On fail goto*//*Label 827*/ 16591, // Rule ID 52962 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52962,
        GIR_Done,
      // Label 827: @16591
      GIM_Reject,
    // Label 825: @16592
    GIM_Reject,
    // Label 754: @16593
    GIM_Try, /*On fail goto*//*Label 828*/ 16676,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 829*/ 16645, // Rule ID 47895 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47895,
        GIR_Done,
      // Label 829: @16645
      GIM_Try, /*On fail goto*//*Label 830*/ 16675, // Rule ID 47896 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47896,
        GIR_Done,
      // Label 830: @16675
      GIM_Reject,
    // Label 828: @16676
    GIM_Reject,
    // Label 755: @16677
    GIM_Try, /*On fail goto*//*Label 831*/ 16760,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 832*/ 16729, // Rule ID 47915 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47915,
        GIR_Done,
      // Label 832: @16729
      GIM_Try, /*On fail goto*//*Label 833*/ 16759, // Rule ID 47916 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47916,
        GIR_Done,
      // Label 833: @16759
      GIM_Reject,
    // Label 831: @16760
    GIM_Reject,
    // Label 756: @16761
    GIM_Try, /*On fail goto*//*Label 834*/ 16844,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 835*/ 16813, // Rule ID 47951 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47951,
        GIR_Done,
      // Label 835: @16813
      GIM_Try, /*On fail goto*//*Label 836*/ 16843, // Rule ID 47952 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47952,
        GIR_Done,
      // Label 836: @16843
      GIM_Reject,
    // Label 834: @16844
    GIM_Reject,
    // Label 757: @16845
    GIM_Try, /*On fail goto*//*Label 837*/ 16928,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 838*/ 16897, // Rule ID 47967 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47967,
        GIR_Done,
      // Label 838: @16897
      GIM_Try, /*On fail goto*//*Label 839*/ 16927, // Rule ID 47968 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47968,
        GIR_Done,
      // Label 839: @16927
      GIM_Reject,
    // Label 837: @16928
    GIM_Reject,
    // Label 758: @16929
    GIM_Try, /*On fail goto*//*Label 840*/ 17012,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 841*/ 16981, // Rule ID 52979 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52979,
        GIR_Done,
      // Label 841: @16981
      GIM_Try, /*On fail goto*//*Label 842*/ 17011, // Rule ID 52980 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52980,
        GIR_Done,
      // Label 842: @17011
      GIM_Reject,
    // Label 840: @17012
    GIM_Reject,
    // Label 759: @17013
    GIM_Try, /*On fail goto*//*Label 843*/ 17096,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 844*/ 17065, // Rule ID 47911 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47911,
        GIR_Done,
      // Label 844: @17065
      GIM_Try, /*On fail goto*//*Label 845*/ 17095, // Rule ID 47912 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47912,
        GIR_Done,
      // Label 845: @17095
      GIM_Reject,
    // Label 843: @17096
    GIM_Reject,
    // Label 760: @17097
    GIM_Try, /*On fail goto*//*Label 846*/ 17180,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 847*/ 17149, // Rule ID 47939 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47939,
        GIR_Done,
      // Label 847: @17149
      GIM_Try, /*On fail goto*//*Label 848*/ 17179, // Rule ID 47940 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47940,
        GIR_Done,
      // Label 848: @17179
      GIM_Reject,
    // Label 846: @17180
    GIM_Reject,
    // Label 761: @17181
    GIM_Try, /*On fail goto*//*Label 849*/ 17264,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 850*/ 17233, // Rule ID 47955 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47955,
        GIR_Done,
      // Label 850: @17233
      GIM_Try, /*On fail goto*//*Label 851*/ 17263, // Rule ID 47956 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47956,
        GIR_Done,
      // Label 851: @17263
      GIM_Reject,
    // Label 849: @17264
    GIM_Reject,
    // Label 762: @17265
    GIM_Try, /*On fail goto*//*Label 852*/ 17348,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 853*/ 17317, // Rule ID 47971 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47971,
        GIR_Done,
      // Label 853: @17317
      GIM_Try, /*On fail goto*//*Label 854*/ 17347, // Rule ID 47972 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47972,
        GIR_Done,
      // Label 854: @17347
      GIM_Reject,
    // Label 852: @17348
    GIM_Reject,
    // Label 763: @17349
    GIM_Try, /*On fail goto*//*Label 855*/ 17432,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 856*/ 17401, // Rule ID 52997 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52997,
        GIR_Done,
      // Label 856: @17401
      GIM_Try, /*On fail goto*//*Label 857*/ 17431, // Rule ID 52998 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52998,
        GIR_Done,
      // Label 857: @17431
      GIM_Reject,
    // Label 855: @17432
    GIM_Reject,
    // Label 764: @17433
    GIM_Try, /*On fail goto*//*Label 858*/ 17516,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 859*/ 17485, // Rule ID 47927 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47927,
        GIR_Done,
      // Label 859: @17485
      GIM_Try, /*On fail goto*//*Label 860*/ 17515, // Rule ID 47928 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47928,
        GIR_Done,
      // Label 860: @17515
      GIM_Reject,
    // Label 858: @17516
    GIM_Reject,
    // Label 765: @17517
    GIM_Try, /*On fail goto*//*Label 861*/ 17600,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 862*/ 17569, // Rule ID 47943 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47943,
        GIR_Done,
      // Label 862: @17569
      GIM_Try, /*On fail goto*//*Label 863*/ 17599, // Rule ID 47944 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47944,
        GIR_Done,
      // Label 863: @17599
      GIM_Reject,
    // Label 861: @17600
    GIM_Reject,
    // Label 766: @17601
    GIM_Try, /*On fail goto*//*Label 864*/ 17684,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 865*/ 17653, // Rule ID 47959 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47959,
        GIR_Done,
      // Label 865: @17653
      GIM_Try, /*On fail goto*//*Label 866*/ 17683, // Rule ID 47960 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47960,
        GIR_Done,
      // Label 866: @17683
      GIM_Reject,
    // Label 864: @17684
    GIM_Reject,
    // Label 767: @17685
    GIM_Try, /*On fail goto*//*Label 867*/ 17768,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 868*/ 17737, // Rule ID 53015 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53015,
        GIR_Done,
      // Label 868: @17737
      GIM_Try, /*On fail goto*//*Label 869*/ 17767, // Rule ID 53016 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53016,
        GIR_Done,
      // Label 869: @17767
      GIM_Reject,
    // Label 867: @17768
    GIM_Reject,
    // Label 768: @17769
    GIM_Try, /*On fail goto*//*Label 870*/ 17852,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 871*/ 17821, // Rule ID 47931 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47931,
        GIR_Done,
      // Label 871: @17821
      GIM_Try, /*On fail goto*//*Label 872*/ 17851, // Rule ID 47932 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47932,
        GIR_Done,
      // Label 872: @17851
      GIM_Reject,
    // Label 870: @17852
    GIM_Reject,
    // Label 769: @17853
    GIM_Try, /*On fail goto*//*Label 873*/ 17936,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 874*/ 17905, // Rule ID 47947 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47947,
        GIR_Done,
      // Label 874: @17905
      GIM_Try, /*On fail goto*//*Label 875*/ 17935, // Rule ID 47948 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47948,
        GIR_Done,
      // Label 875: @17935
      GIM_Reject,
    // Label 873: @17936
    GIM_Reject,
    // Label 770: @17937
    GIM_Try, /*On fail goto*//*Label 876*/ 18020,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 877*/ 17989, // Rule ID 53033 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53033,
        GIR_Done,
      // Label 877: @17989
      GIM_Try, /*On fail goto*//*Label 878*/ 18019, // Rule ID 53034 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53034,
        GIR_Done,
      // Label 878: @18019
      GIM_Reject,
    // Label 876: @18020
    GIM_Reject,
    // Label 771: @18021
    GIM_Try, /*On fail goto*//*Label 879*/ 18104,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 880*/ 18073, // Rule ID 47935 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47935,
        GIR_Done,
      // Label 880: @18073
      GIM_Try, /*On fail goto*//*Label 881*/ 18103, // Rule ID 47936 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47936,
        GIR_Done,
      // Label 881: @18103
      GIM_Reject,
    // Label 879: @18104
    GIM_Reject,
    // Label 772: @18105
    GIM_Reject,
    // Label 8: @18106
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 913*/ 23819,
    /*GILLT_s32*//*Label 882*/ 18143,
    /*GILLT_s64*//*Label 883*/ 19763,
    /*GILLT_nxv1s1*//*Label 884*/ 21383,
    /*GILLT_nxv1s8*//*Label 885*/ 21467,
    /*GILLT_nxv1s16*//*Label 886*/ 21551,
    /*GILLT_nxv1s32*//*Label 887*/ 21635,
    /*GILLT_nxv1s64*//*Label 888*/ 21719,
    /*GILLT_nxv2s1*//*Label 889*/ 21803,
    /*GILLT_nxv2s8*//*Label 890*/ 21887,
    /*GILLT_nxv2s16*//*Label 891*/ 21971,
    /*GILLT_nxv2s32*//*Label 892*/ 22055,
    /*GILLT_nxv2s64*//*Label 893*/ 22139,
    /*GILLT_nxv4s1*//*Label 894*/ 22223,
    /*GILLT_nxv4s8*//*Label 895*/ 22307,
    /*GILLT_nxv4s16*//*Label 896*/ 22391,
    /*GILLT_nxv4s32*//*Label 897*/ 22475,
    /*GILLT_nxv4s64*//*Label 898*/ 22559,
    /*GILLT_nxv8s1*//*Label 899*/ 22643,
    /*GILLT_nxv8s8*//*Label 900*/ 22727,
    /*GILLT_nxv8s16*//*Label 901*/ 22811,
    /*GILLT_nxv8s32*//*Label 902*/ 22895,
    /*GILLT_nxv8s64*//*Label 903*/ 22979,
    /*GILLT_nxv16s1*//*Label 904*/ 23063,
    /*GILLT_nxv16s8*//*Label 905*/ 23147,
    /*GILLT_nxv16s16*//*Label 906*/ 23231,
    /*GILLT_nxv16s32*//*Label 907*/ 23315,
    /*GILLT_nxv32s1*//*Label 908*/ 23399,
    /*GILLT_nxv32s8*//*Label 909*/ 23483,
    /*GILLT_nxv32s16*//*Label 910*/ 23567,
    /*GILLT_nxv64s1*//*Label 911*/ 23651,
    /*GILLT_nxv64s8*//*Label 912*/ 23735,
    // Label 882: @18143
    GIM_Try, /*On fail goto*//*Label 914*/ 19762,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 915*/ 18252, // Rule ID 56836 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56836,
        GIR_Done,
      // Label 915: @18252
      GIM_Try, /*On fail goto*//*Label 916*/ 18347, // Rule ID 62392 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62392,
        GIR_Done,
      // Label 916: @18347
      GIM_Try, /*On fail goto*//*Label 917*/ 18442, // Rule ID 62394 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }), (shl:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62394,
        GIR_Done,
      // Label 917: @18442
      GIM_Try, /*On fail goto*//*Label 918*/ 18537, // Rule ID 56838 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 255:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56838,
        GIR_Done,
      // Label 918: @18537
      GIM_Try, /*On fail goto*//*Label 919*/ 18611, // Rule ID 56843 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 16:{ *:[i32] }))  =>  (PACKU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56843,
        GIR_Done,
      // Label 919: @18611
      GIM_Try, /*On fail goto*//*Label 920*/ 18685, // Rule ID 56839 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56839,
        GIR_Done,
      // Label 920: @18685
      GIM_Try, /*On fail goto*//*Label 921*/ 18759, // Rule ID 62399 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 16:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 4294901760:{ *:[i32] }))  =>  (PACKU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62399,
        GIR_Done,
      // Label 921: @18759
      GIM_Try, /*On fail goto*//*Label 922*/ 18833, // Rule ID 62395 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] }))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62395,
        GIR_Done,
      // Label 922: @18833
      GIM_Try, /*On fail goto*//*Label 923*/ 18929, // Rule ID 62364 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62364,
        GIR_Done,
      // Label 923: @18929
      GIM_Try, /*On fail goto*//*Label 924*/ 19025, // Rule ID 56771 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56771,
        GIR_Done,
      // Label 924: @19025
      GIM_Try, /*On fail goto*//*Label 925*/ 19121, // Rule ID 62368 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62368,
        GIR_Done,
      // Label 925: @19121
      GIM_Try, /*On fail goto*//*Label 926*/ 19217, // Rule ID 62366 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62366,
        GIR_Done,
      // Label 926: @19217
      GIM_Try, /*On fail goto*//*Label 927*/ 19313, // Rule ID 62370 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62370,
        GIR_Done,
      // Label 927: @19313
      GIM_Try, /*On fail goto*//*Label 928*/ 19409, // Rule ID 62374 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62374,
        GIR_Done,
      // Label 928: @19409
      GIM_Try, /*On fail goto*//*Label 929*/ 19505, // Rule ID 62372 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62372,
        GIR_Done,
      // Label 929: @19505
      GIM_Try, /*On fail goto*//*Label 930*/ 19601, // Rule ID 62376 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62376,
        GIR_Done,
      // Label 930: @19601
      GIM_Try, /*On fail goto*//*Label 931*/ 19654, // Rule ID 62350 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62350,
        GIR_Done,
      // Label 931: @19654
      GIM_Try, /*On fail goto*//*Label 932*/ 19707, // Rule ID 56681 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56681,
        GIR_Done,
      // Label 932: @19707
      GIM_Try, /*On fail goto*//*Label 933*/ 19744, // Rule ID 55918 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55918,
        GIR_Done,
      // Label 933: @19744
      GIM_Try, /*On fail goto*//*Label 934*/ 19761, // Rule ID 55916 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55916,
        GIR_Done,
      // Label 934: @19761
      GIM_Reject,
    // Label 914: @19762
    GIM_Reject,
    // Label 883: @19763
    GIM_Try, /*On fail goto*//*Label 935*/ 21382,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 936*/ 19872, // Rule ID 56835 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] }), 65535:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56835,
        GIR_Done,
      // Label 936: @19872
      GIM_Try, /*On fail goto*//*Label 937*/ 19967, // Rule ID 62391 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }), (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] }), 65535:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62391,
        GIR_Done,
      // Label 937: @19967
      GIM_Try, /*On fail goto*//*Label 938*/ 20062, // Rule ID 62393 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }), (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 255:{ *:[i64] }), 8:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62393,
        GIR_Done,
      // Label 938: @20062
      GIM_Try, /*On fail goto*//*Label 939*/ 20157, // Rule ID 56837 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 255:{ *:[i64] }), 8:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56837,
        GIR_Done,
      // Label 939: @20157
      GIM_Try, /*On fail goto*//*Label 940*/ 20231, // Rule ID 56844 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -4294967296,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -4294967296:{ *:[i64] }), (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }))  =>  (PACKU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56844,
        GIR_Done,
      // Label 940: @20231
      GIM_Try, /*On fail goto*//*Label 941*/ 20305, // Rule ID 56840 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))  =>  (PACK:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56840,
        GIR_Done,
      // Label 941: @20305
      GIM_Try, /*On fail goto*//*Label 942*/ 20379, // Rule ID 62400 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -4294967296,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -4294967296:{ *:[i64] }))  =>  (PACKU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62400,
        GIR_Done,
      // Label 942: @20379
      GIM_Try, /*On fail goto*//*Label 943*/ 20453, // Rule ID 62396 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }))  =>  (PACK:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62396,
        GIR_Done,
      // Label 943: @20453
      GIM_Try, /*On fail goto*//*Label 944*/ 20549, // Rule ID 62363 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62363,
        GIR_Done,
      // Label 944: @20549
      GIM_Try, /*On fail goto*//*Label 945*/ 20645, // Rule ID 56770 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56770,
        GIR_Done,
      // Label 945: @20645
      GIM_Try, /*On fail goto*//*Label 946*/ 20741, // Rule ID 62367 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62367,
        GIR_Done,
      // Label 946: @20741
      GIM_Try, /*On fail goto*//*Label 947*/ 20837, // Rule ID 62365 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62365,
        GIR_Done,
      // Label 947: @20837
      GIM_Try, /*On fail goto*//*Label 948*/ 20933, // Rule ID 62369 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62369,
        GIR_Done,
      // Label 948: @20933
      GIM_Try, /*On fail goto*//*Label 949*/ 21029, // Rule ID 62373 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62373,
        GIR_Done,
      // Label 949: @21029
      GIM_Try, /*On fail goto*//*Label 950*/ 21125, // Rule ID 62371 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62371,
        GIR_Done,
      // Label 950: @21125
      GIM_Try, /*On fail goto*//*Label 951*/ 21221, // Rule ID 62375 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62375,
        GIR_Done,
      // Label 951: @21221
      GIM_Try, /*On fail goto*//*Label 952*/ 21274, // Rule ID 62349 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62349,
        GIR_Done,
      // Label 952: @21274
      GIM_Try, /*On fail goto*//*Label 953*/ 21327, // Rule ID 56680 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56680,
        GIR_Done,
      // Label 953: @21327
      GIM_Try, /*On fail goto*//*Label 954*/ 21364, // Rule ID 55917 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55917,
        GIR_Done,
      // Label 954: @21364
      GIM_Try, /*On fail goto*//*Label 955*/ 21381, // Rule ID 55915 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (OR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55915,
        GIR_Done,
      // Label 955: @21381
      GIM_Reject,
    // Label 935: @21382
    GIM_Reject,
    // Label 884: @21383
    GIM_Try, /*On fail goto*//*Label 956*/ 21466,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 957*/ 21435, // Rule ID 52927 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52927,
        GIR_Done,
      // Label 957: @21435
      GIM_Try, /*On fail goto*//*Label 958*/ 21465, // Rule ID 52928 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52928,
        GIR_Done,
      // Label 958: @21465
      GIM_Reject,
    // Label 956: @21466
    GIM_Reject,
    // Label 885: @21467
    GIM_Try, /*On fail goto*//*Label 959*/ 21550,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 960*/ 21519, // Rule ID 48019 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48019,
        GIR_Done,
      // Label 960: @21519
      GIM_Try, /*On fail goto*//*Label 961*/ 21549, // Rule ID 48020 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48020,
        GIR_Done,
      // Label 961: @21549
      GIM_Reject,
    // Label 959: @21550
    GIM_Reject,
    // Label 886: @21551
    GIM_Try, /*On fail goto*//*Label 962*/ 21634,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 963*/ 21603, // Rule ID 48031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48031,
        GIR_Done,
      // Label 963: @21603
      GIM_Try, /*On fail goto*//*Label 964*/ 21633, // Rule ID 48032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48032,
        GIR_Done,
      // Label 964: @21633
      GIM_Reject,
    // Label 962: @21634
    GIM_Reject,
    // Label 887: @21635
    GIM_Try, /*On fail goto*//*Label 965*/ 21718,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 966*/ 21687, // Rule ID 48039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48039,
        GIR_Done,
      // Label 966: @21687
      GIM_Try, /*On fail goto*//*Label 967*/ 21717, // Rule ID 48040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48040,
        GIR_Done,
      // Label 967: @21717
      GIM_Reject,
    // Label 965: @21718
    GIM_Reject,
    // Label 888: @21719
    GIM_Try, /*On fail goto*//*Label 968*/ 21802,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 969*/ 21771, // Rule ID 48055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48055,
        GIR_Done,
      // Label 969: @21771
      GIM_Try, /*On fail goto*//*Label 970*/ 21801, // Rule ID 48056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48056,
        GIR_Done,
      // Label 970: @21801
      GIM_Reject,
    // Label 968: @21802
    GIM_Reject,
    // Label 889: @21803
    GIM_Try, /*On fail goto*//*Label 971*/ 21886,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 972*/ 21855, // Rule ID 52945 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52945,
        GIR_Done,
      // Label 972: @21855
      GIM_Try, /*On fail goto*//*Label 973*/ 21885, // Rule ID 52946 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52946,
        GIR_Done,
      // Label 973: @21885
      GIM_Reject,
    // Label 971: @21886
    GIM_Reject,
    // Label 890: @21887
    GIM_Try, /*On fail goto*//*Label 974*/ 21970,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 975*/ 21939, // Rule ID 48023 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48023,
        GIR_Done,
      // Label 975: @21939
      GIM_Try, /*On fail goto*//*Label 976*/ 21969, // Rule ID 48024 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48024,
        GIR_Done,
      // Label 976: @21969
      GIM_Reject,
    // Label 974: @21970
    GIM_Reject,
    // Label 891: @21971
    GIM_Try, /*On fail goto*//*Label 977*/ 22054,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 978*/ 22023, // Rule ID 48035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48035,
        GIR_Done,
      // Label 978: @22023
      GIM_Try, /*On fail goto*//*Label 979*/ 22053, // Rule ID 48036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48036,
        GIR_Done,
      // Label 979: @22053
      GIM_Reject,
    // Label 977: @22054
    GIM_Reject,
    // Label 892: @22055
    GIM_Try, /*On fail goto*//*Label 980*/ 22138,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 981*/ 22107, // Rule ID 48051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48051,
        GIR_Done,
      // Label 981: @22107
      GIM_Try, /*On fail goto*//*Label 982*/ 22137, // Rule ID 48052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48052,
        GIR_Done,
      // Label 982: @22137
      GIM_Reject,
    // Label 980: @22138
    GIM_Reject,
    // Label 893: @22139
    GIM_Try, /*On fail goto*//*Label 983*/ 22222,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 984*/ 22191, // Rule ID 48095 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48095,
        GIR_Done,
      // Label 984: @22191
      GIM_Try, /*On fail goto*//*Label 985*/ 22221, // Rule ID 48096 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48096,
        GIR_Done,
      // Label 985: @22221
      GIM_Reject,
    // Label 983: @22222
    GIM_Reject,
    // Label 894: @22223
    GIM_Try, /*On fail goto*//*Label 986*/ 22306,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 987*/ 22275, // Rule ID 52963 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52963,
        GIR_Done,
      // Label 987: @22275
      GIM_Try, /*On fail goto*//*Label 988*/ 22305, // Rule ID 52964 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52964,
        GIR_Done,
      // Label 988: @22305
      GIM_Reject,
    // Label 986: @22306
    GIM_Reject,
    // Label 895: @22307
    GIM_Try, /*On fail goto*//*Label 989*/ 22390,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 990*/ 22359, // Rule ID 48027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48027,
        GIR_Done,
      // Label 990: @22359
      GIM_Try, /*On fail goto*//*Label 991*/ 22389, // Rule ID 48028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48028,
        GIR_Done,
      // Label 991: @22389
      GIM_Reject,
    // Label 989: @22390
    GIM_Reject,
    // Label 896: @22391
    GIM_Try, /*On fail goto*//*Label 992*/ 22474,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 993*/ 22443, // Rule ID 48047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48047,
        GIR_Done,
      // Label 993: @22443
      GIM_Try, /*On fail goto*//*Label 994*/ 22473, // Rule ID 48048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48048,
        GIR_Done,
      // Label 994: @22473
      GIM_Reject,
    // Label 992: @22474
    GIM_Reject,
    // Label 897: @22475
    GIM_Try, /*On fail goto*//*Label 995*/ 22558,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 996*/ 22527, // Rule ID 48083 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48083,
        GIR_Done,
      // Label 996: @22527
      GIM_Try, /*On fail goto*//*Label 997*/ 22557, // Rule ID 48084 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48084,
        GIR_Done,
      // Label 997: @22557
      GIM_Reject,
    // Label 995: @22558
    GIM_Reject,
    // Label 898: @22559
    GIM_Try, /*On fail goto*//*Label 998*/ 22642,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 999*/ 22611, // Rule ID 48099 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48099,
        GIR_Done,
      // Label 999: @22611
      GIM_Try, /*On fail goto*//*Label 1000*/ 22641, // Rule ID 48100 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48100,
        GIR_Done,
      // Label 1000: @22641
      GIM_Reject,
    // Label 998: @22642
    GIM_Reject,
    // Label 899: @22643
    GIM_Try, /*On fail goto*//*Label 1001*/ 22726,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1002*/ 22695, // Rule ID 52981 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52981,
        GIR_Done,
      // Label 1002: @22695
      GIM_Try, /*On fail goto*//*Label 1003*/ 22725, // Rule ID 52982 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52982,
        GIR_Done,
      // Label 1003: @22725
      GIM_Reject,
    // Label 1001: @22726
    GIM_Reject,
    // Label 900: @22727
    GIM_Try, /*On fail goto*//*Label 1004*/ 22810,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1005*/ 22779, // Rule ID 48043 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48043,
        GIR_Done,
      // Label 1005: @22779
      GIM_Try, /*On fail goto*//*Label 1006*/ 22809, // Rule ID 48044 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48044,
        GIR_Done,
      // Label 1006: @22809
      GIM_Reject,
    // Label 1004: @22810
    GIM_Reject,
    // Label 901: @22811
    GIM_Try, /*On fail goto*//*Label 1007*/ 22894,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1008*/ 22863, // Rule ID 48071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48071,
        GIR_Done,
      // Label 1008: @22863
      GIM_Try, /*On fail goto*//*Label 1009*/ 22893, // Rule ID 48072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48072,
        GIR_Done,
      // Label 1009: @22893
      GIM_Reject,
    // Label 1007: @22894
    GIM_Reject,
    // Label 902: @22895
    GIM_Try, /*On fail goto*//*Label 1010*/ 22978,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1011*/ 22947, // Rule ID 48087 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48087,
        GIR_Done,
      // Label 1011: @22947
      GIM_Try, /*On fail goto*//*Label 1012*/ 22977, // Rule ID 48088 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48088,
        GIR_Done,
      // Label 1012: @22977
      GIM_Reject,
    // Label 1010: @22978
    GIM_Reject,
    // Label 903: @22979
    GIM_Try, /*On fail goto*//*Label 1013*/ 23062,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1014*/ 23031, // Rule ID 48103 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48103,
        GIR_Done,
      // Label 1014: @23031
      GIM_Try, /*On fail goto*//*Label 1015*/ 23061, // Rule ID 48104 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48104,
        GIR_Done,
      // Label 1015: @23061
      GIM_Reject,
    // Label 1013: @23062
    GIM_Reject,
    // Label 904: @23063
    GIM_Try, /*On fail goto*//*Label 1016*/ 23146,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1017*/ 23115, // Rule ID 52999 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52999,
        GIR_Done,
      // Label 1017: @23115
      GIM_Try, /*On fail goto*//*Label 1018*/ 23145, // Rule ID 53000 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53000,
        GIR_Done,
      // Label 1018: @23145
      GIM_Reject,
    // Label 1016: @23146
    GIM_Reject,
    // Label 905: @23147
    GIM_Try, /*On fail goto*//*Label 1019*/ 23230,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1020*/ 23199, // Rule ID 48059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48059,
        GIR_Done,
      // Label 1020: @23199
      GIM_Try, /*On fail goto*//*Label 1021*/ 23229, // Rule ID 48060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48060,
        GIR_Done,
      // Label 1021: @23229
      GIM_Reject,
    // Label 1019: @23230
    GIM_Reject,
    // Label 906: @23231
    GIM_Try, /*On fail goto*//*Label 1022*/ 23314,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1023*/ 23283, // Rule ID 48075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48075,
        GIR_Done,
      // Label 1023: @23283
      GIM_Try, /*On fail goto*//*Label 1024*/ 23313, // Rule ID 48076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48076,
        GIR_Done,
      // Label 1024: @23313
      GIM_Reject,
    // Label 1022: @23314
    GIM_Reject,
    // Label 907: @23315
    GIM_Try, /*On fail goto*//*Label 1025*/ 23398,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1026*/ 23367, // Rule ID 48091 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48091,
        GIR_Done,
      // Label 1026: @23367
      GIM_Try, /*On fail goto*//*Label 1027*/ 23397, // Rule ID 48092 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48092,
        GIR_Done,
      // Label 1027: @23397
      GIM_Reject,
    // Label 1025: @23398
    GIM_Reject,
    // Label 908: @23399
    GIM_Try, /*On fail goto*//*Label 1028*/ 23482,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1029*/ 23451, // Rule ID 53017 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53017,
        GIR_Done,
      // Label 1029: @23451
      GIM_Try, /*On fail goto*//*Label 1030*/ 23481, // Rule ID 53018 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53018,
        GIR_Done,
      // Label 1030: @23481
      GIM_Reject,
    // Label 1028: @23482
    GIM_Reject,
    // Label 909: @23483
    GIM_Try, /*On fail goto*//*Label 1031*/ 23566,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1032*/ 23535, // Rule ID 48063 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48063,
        GIR_Done,
      // Label 1032: @23535
      GIM_Try, /*On fail goto*//*Label 1033*/ 23565, // Rule ID 48064 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48064,
        GIR_Done,
      // Label 1033: @23565
      GIM_Reject,
    // Label 1031: @23566
    GIM_Reject,
    // Label 910: @23567
    GIM_Try, /*On fail goto*//*Label 1034*/ 23650,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1035*/ 23619, // Rule ID 48079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48079,
        GIR_Done,
      // Label 1035: @23619
      GIM_Try, /*On fail goto*//*Label 1036*/ 23649, // Rule ID 48080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48080,
        GIR_Done,
      // Label 1036: @23649
      GIM_Reject,
    // Label 1034: @23650
    GIM_Reject,
    // Label 911: @23651
    GIM_Try, /*On fail goto*//*Label 1037*/ 23734,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1038*/ 23703, // Rule ID 53035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53035,
        GIR_Done,
      // Label 1038: @23703
      GIM_Try, /*On fail goto*//*Label 1039*/ 23733, // Rule ID 53036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53036,
        GIR_Done,
      // Label 1039: @23733
      GIM_Reject,
    // Label 1037: @23734
    GIM_Reject,
    // Label 912: @23735
    GIM_Try, /*On fail goto*//*Label 1040*/ 23818,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1041*/ 23787, // Rule ID 48067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48067,
        GIR_Done,
      // Label 1041: @23787
      GIM_Try, /*On fail goto*//*Label 1042*/ 23817, // Rule ID 48068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48068,
        GIR_Done,
      // Label 1042: @23817
      GIM_Reject,
    // Label 1040: @23818
    GIM_Reject,
    // Label 913: @23819
    GIM_Reject,
    // Label 9: @23820
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 1074*/ 28143,
    /*GILLT_s32*//*Label 1043*/ 23857,
    /*GILLT_s64*//*Label 1044*/ 24782,
    /*GILLT_nxv1s1*//*Label 1045*/ 25707,
    /*GILLT_nxv1s8*//*Label 1046*/ 25791,
    /*GILLT_nxv1s16*//*Label 1047*/ 25875,
    /*GILLT_nxv1s32*//*Label 1048*/ 25959,
    /*GILLT_nxv1s64*//*Label 1049*/ 26043,
    /*GILLT_nxv2s1*//*Label 1050*/ 26127,
    /*GILLT_nxv2s8*//*Label 1051*/ 26211,
    /*GILLT_nxv2s16*//*Label 1052*/ 26295,
    /*GILLT_nxv2s32*//*Label 1053*/ 26379,
    /*GILLT_nxv2s64*//*Label 1054*/ 26463,
    /*GILLT_nxv4s1*//*Label 1055*/ 26547,
    /*GILLT_nxv4s8*//*Label 1056*/ 26631,
    /*GILLT_nxv4s16*//*Label 1057*/ 26715,
    /*GILLT_nxv4s32*//*Label 1058*/ 26799,
    /*GILLT_nxv4s64*//*Label 1059*/ 26883,
    /*GILLT_nxv8s1*//*Label 1060*/ 26967,
    /*GILLT_nxv8s8*//*Label 1061*/ 27051,
    /*GILLT_nxv8s16*//*Label 1062*/ 27135,
    /*GILLT_nxv8s32*//*Label 1063*/ 27219,
    /*GILLT_nxv8s64*//*Label 1064*/ 27303,
    /*GILLT_nxv16s1*//*Label 1065*/ 27387,
    /*GILLT_nxv16s8*//*Label 1066*/ 27471,
    /*GILLT_nxv16s16*//*Label 1067*/ 27555,
    /*GILLT_nxv16s32*//*Label 1068*/ 27639,
    /*GILLT_nxv32s1*//*Label 1069*/ 27723,
    /*GILLT_nxv32s8*//*Label 1070*/ 27807,
    /*GILLT_nxv32s16*//*Label 1071*/ 27891,
    /*GILLT_nxv64s1*//*Label 1072*/ 27975,
    /*GILLT_nxv64s8*//*Label 1073*/ 28059,
    // Label 1043: @23857
    GIM_Try, /*On fail goto*//*Label 1075*/ 24781,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1076*/ 23924, // Rule ID 62354 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs2)  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62354,
        GIR_Done,
      // Label 1076: @23924
      GIM_Try, /*On fail goto*//*Label 1077*/ 23985, // Rule ID 62352 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62352,
        GIR_Done,
      // Label 1077: @23985
      GIM_Try, /*On fail goto*//*Label 1078*/ 24046, // Rule ID 56683 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56683,
        GIR_Done,
      // Label 1078: @24046
      GIM_Try, /*On fail goto*//*Label 1079*/ 24129, // Rule ID 56773 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs3), GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs3)  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56773,
        GIR_Done,
      // Label 1079: @24129
      GIM_Try, /*On fail goto*//*Label 1080*/ 24212, // Rule ID 62378 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, GPR:{ *:[i32] }:$rs1), GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs3)  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62378,
        GIR_Done,
      // Label 1080: @24212
      GIM_Try, /*On fail goto*//*Label 1081*/ 24295, // Rule ID 62380 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs3)), GPR:{ *:[i32] }:$rs3)  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62380,
        GIR_Done,
      // Label 1081: @24295
      GIM_Try, /*On fail goto*//*Label 1082*/ 24378, // Rule ID 62382 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, GPR:{ *:[i32] }:$rs1)), GPR:{ *:[i32] }:$rs3)  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62382,
        GIR_Done,
      // Label 1082: @24378
      GIM_Try, /*On fail goto*//*Label 1083*/ 24461, // Rule ID 62384 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs3), GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62384,
        GIR_Done,
      // Label 1083: @24461
      GIM_Try, /*On fail goto*//*Label 1084*/ 24544, // Rule ID 62386 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, GPR:{ *:[i32] }:$rs1), GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62386,
        GIR_Done,
      // Label 1084: @24544
      GIM_Try, /*On fail goto*//*Label 1085*/ 24627, // Rule ID 62388 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs3)))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62388,
        GIR_Done,
      // Label 1085: @24627
      GIM_Try, /*On fail goto*//*Label 1086*/ 24710, // Rule ID 62390 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs3, GPR:{ *:[i32] }:$rs1)))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62390,
        GIR_Done,
      // Label 1086: @24710
      GIM_Try, /*On fail goto*//*Label 1087*/ 24755, // Rule ID 55926 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55926,
        GIR_Done,
      // Label 1087: @24755
      GIM_Try, /*On fail goto*//*Label 1088*/ 24780, // Rule ID 55924 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (XOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55924,
        GIR_Done,
      // Label 1088: @24780
      GIM_Reject,
    // Label 1075: @24781
    GIM_Reject,
    // Label 1044: @24782
    GIM_Try, /*On fail goto*//*Label 1089*/ 25706,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1090*/ 24849, // Rule ID 62353 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62353,
        GIR_Done,
      // Label 1090: @24849
      GIM_Try, /*On fail goto*//*Label 1091*/ 24910, // Rule ID 62351 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62351,
        GIR_Done,
      // Label 1091: @24910
      GIM_Try, /*On fail goto*//*Label 1092*/ 24971, // Rule ID 56682 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56682,
        GIR_Done,
      // Label 1092: @24971
      GIM_Try, /*On fail goto*//*Label 1093*/ 25054, // Rule ID 56772 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs3), GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs3)  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56772,
        GIR_Done,
      // Label 1093: @25054
      GIM_Try, /*On fail goto*//*Label 1094*/ 25137, // Rule ID 62377 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, GPR:{ *:[i64] }:$rs1), GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs3)  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62377,
        GIR_Done,
      // Label 1094: @25137
      GIM_Try, /*On fail goto*//*Label 1095*/ 25220, // Rule ID 62379 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs3)), GPR:{ *:[i64] }:$rs3)  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62379,
        GIR_Done,
      // Label 1095: @25220
      GIM_Try, /*On fail goto*//*Label 1096*/ 25303, // Rule ID 62381 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs3
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, GPR:{ *:[i64] }:$rs1)), GPR:{ *:[i64] }:$rs3)  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62381,
        GIR_Done,
      // Label 1096: @25303
      GIM_Try, /*On fail goto*//*Label 1097*/ 25386, // Rule ID 62383 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs3), GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62383,
        GIR_Done,
      // Label 1097: @25386
      GIM_Try, /*On fail goto*//*Label 1098*/ 25469, // Rule ID 62385 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, GPR:{ *:[i64] }:$rs1), GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62385,
        GIR_Done,
      // Label 1098: @25469
      GIM_Try, /*On fail goto*//*Label 1099*/ 25552, // Rule ID 62387 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs3)))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62387,
        GIR_Done,
      // Label 1099: @25552
      GIM_Try, /*On fail goto*//*Label 1100*/ 25635, // Rule ID 62389 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] rs3
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs3, GPR:{ *:[i64] }:$rs1)))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62389,
        GIR_Done,
      // Label 1100: @25635
      GIM_Try, /*On fail goto*//*Label 1101*/ 25680, // Rule ID 55925 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55925,
        GIR_Done,
      // Label 1101: @25680
      GIM_Try, /*On fail goto*//*Label 1102*/ 25705, // Rule ID 55923 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (XOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55923,
        GIR_Done,
      // Label 1102: @25705
      GIM_Reject,
    // Label 1089: @25706
    GIM_Reject,
    // Label 1045: @25707
    GIM_Try, /*On fail goto*//*Label 1103*/ 25790,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1104*/ 25759, // Rule ID 52929 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52929,
        GIR_Done,
      // Label 1104: @25759
      GIM_Try, /*On fail goto*//*Label 1105*/ 25789, // Rule ID 52930 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52930,
        GIR_Done,
      // Label 1105: @25789
      GIM_Reject,
    // Label 1103: @25790
    GIM_Reject,
    // Label 1046: @25791
    GIM_Try, /*On fail goto*//*Label 1106*/ 25874,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1107*/ 25843, // Rule ID 48151 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48151,
        GIR_Done,
      // Label 1107: @25843
      GIM_Try, /*On fail goto*//*Label 1108*/ 25873, // Rule ID 48152 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48152,
        GIR_Done,
      // Label 1108: @25873
      GIM_Reject,
    // Label 1106: @25874
    GIM_Reject,
    // Label 1047: @25875
    GIM_Try, /*On fail goto*//*Label 1109*/ 25958,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1110*/ 25927, // Rule ID 48163 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48163,
        GIR_Done,
      // Label 1110: @25927
      GIM_Try, /*On fail goto*//*Label 1111*/ 25957, // Rule ID 48164 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48164,
        GIR_Done,
      // Label 1111: @25957
      GIM_Reject,
    // Label 1109: @25958
    GIM_Reject,
    // Label 1048: @25959
    GIM_Try, /*On fail goto*//*Label 1112*/ 26042,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1113*/ 26011, // Rule ID 48171 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48171,
        GIR_Done,
      // Label 1113: @26011
      GIM_Try, /*On fail goto*//*Label 1114*/ 26041, // Rule ID 48172 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48172,
        GIR_Done,
      // Label 1114: @26041
      GIM_Reject,
    // Label 1112: @26042
    GIM_Reject,
    // Label 1049: @26043
    GIM_Try, /*On fail goto*//*Label 1115*/ 26126,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1116*/ 26095, // Rule ID 48187 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48187,
        GIR_Done,
      // Label 1116: @26095
      GIM_Try, /*On fail goto*//*Label 1117*/ 26125, // Rule ID 48188 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48188,
        GIR_Done,
      // Label 1117: @26125
      GIM_Reject,
    // Label 1115: @26126
    GIM_Reject,
    // Label 1050: @26127
    GIM_Try, /*On fail goto*//*Label 1118*/ 26210,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1119*/ 26179, // Rule ID 52947 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52947,
        GIR_Done,
      // Label 1119: @26179
      GIM_Try, /*On fail goto*//*Label 1120*/ 26209, // Rule ID 52948 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52948,
        GIR_Done,
      // Label 1120: @26209
      GIM_Reject,
    // Label 1118: @26210
    GIM_Reject,
    // Label 1051: @26211
    GIM_Try, /*On fail goto*//*Label 1121*/ 26294,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1122*/ 26263, // Rule ID 48155 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48155,
        GIR_Done,
      // Label 1122: @26263
      GIM_Try, /*On fail goto*//*Label 1123*/ 26293, // Rule ID 48156 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48156,
        GIR_Done,
      // Label 1123: @26293
      GIM_Reject,
    // Label 1121: @26294
    GIM_Reject,
    // Label 1052: @26295
    GIM_Try, /*On fail goto*//*Label 1124*/ 26378,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1125*/ 26347, // Rule ID 48167 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48167,
        GIR_Done,
      // Label 1125: @26347
      GIM_Try, /*On fail goto*//*Label 1126*/ 26377, // Rule ID 48168 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48168,
        GIR_Done,
      // Label 1126: @26377
      GIM_Reject,
    // Label 1124: @26378
    GIM_Reject,
    // Label 1053: @26379
    GIM_Try, /*On fail goto*//*Label 1127*/ 26462,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1128*/ 26431, // Rule ID 48183 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48183,
        GIR_Done,
      // Label 1128: @26431
      GIM_Try, /*On fail goto*//*Label 1129*/ 26461, // Rule ID 48184 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48184,
        GIR_Done,
      // Label 1129: @26461
      GIM_Reject,
    // Label 1127: @26462
    GIM_Reject,
    // Label 1054: @26463
    GIM_Try, /*On fail goto*//*Label 1130*/ 26546,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1131*/ 26515, // Rule ID 48227 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48227,
        GIR_Done,
      // Label 1131: @26515
      GIM_Try, /*On fail goto*//*Label 1132*/ 26545, // Rule ID 48228 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48228,
        GIR_Done,
      // Label 1132: @26545
      GIM_Reject,
    // Label 1130: @26546
    GIM_Reject,
    // Label 1055: @26547
    GIM_Try, /*On fail goto*//*Label 1133*/ 26630,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1134*/ 26599, // Rule ID 52965 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52965,
        GIR_Done,
      // Label 1134: @26599
      GIM_Try, /*On fail goto*//*Label 1135*/ 26629, // Rule ID 52966 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52966,
        GIR_Done,
      // Label 1135: @26629
      GIM_Reject,
    // Label 1133: @26630
    GIM_Reject,
    // Label 1056: @26631
    GIM_Try, /*On fail goto*//*Label 1136*/ 26714,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1137*/ 26683, // Rule ID 48159 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48159,
        GIR_Done,
      // Label 1137: @26683
      GIM_Try, /*On fail goto*//*Label 1138*/ 26713, // Rule ID 48160 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48160,
        GIR_Done,
      // Label 1138: @26713
      GIM_Reject,
    // Label 1136: @26714
    GIM_Reject,
    // Label 1057: @26715
    GIM_Try, /*On fail goto*//*Label 1139*/ 26798,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1140*/ 26767, // Rule ID 48179 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48179,
        GIR_Done,
      // Label 1140: @26767
      GIM_Try, /*On fail goto*//*Label 1141*/ 26797, // Rule ID 48180 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48180,
        GIR_Done,
      // Label 1141: @26797
      GIM_Reject,
    // Label 1139: @26798
    GIM_Reject,
    // Label 1058: @26799
    GIM_Try, /*On fail goto*//*Label 1142*/ 26882,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1143*/ 26851, // Rule ID 48215 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48215,
        GIR_Done,
      // Label 1143: @26851
      GIM_Try, /*On fail goto*//*Label 1144*/ 26881, // Rule ID 48216 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48216,
        GIR_Done,
      // Label 1144: @26881
      GIM_Reject,
    // Label 1142: @26882
    GIM_Reject,
    // Label 1059: @26883
    GIM_Try, /*On fail goto*//*Label 1145*/ 26966,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1146*/ 26935, // Rule ID 48231 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48231,
        GIR_Done,
      // Label 1146: @26935
      GIM_Try, /*On fail goto*//*Label 1147*/ 26965, // Rule ID 48232 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48232,
        GIR_Done,
      // Label 1147: @26965
      GIM_Reject,
    // Label 1145: @26966
    GIM_Reject,
    // Label 1060: @26967
    GIM_Try, /*On fail goto*//*Label 1148*/ 27050,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1149*/ 27019, // Rule ID 52983 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52983,
        GIR_Done,
      // Label 1149: @27019
      GIM_Try, /*On fail goto*//*Label 1150*/ 27049, // Rule ID 52984 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52984,
        GIR_Done,
      // Label 1150: @27049
      GIM_Reject,
    // Label 1148: @27050
    GIM_Reject,
    // Label 1061: @27051
    GIM_Try, /*On fail goto*//*Label 1151*/ 27134,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1152*/ 27103, // Rule ID 48175 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48175,
        GIR_Done,
      // Label 1152: @27103
      GIM_Try, /*On fail goto*//*Label 1153*/ 27133, // Rule ID 48176 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48176,
        GIR_Done,
      // Label 1153: @27133
      GIM_Reject,
    // Label 1151: @27134
    GIM_Reject,
    // Label 1062: @27135
    GIM_Try, /*On fail goto*//*Label 1154*/ 27218,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1155*/ 27187, // Rule ID 48203 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48203,
        GIR_Done,
      // Label 1155: @27187
      GIM_Try, /*On fail goto*//*Label 1156*/ 27217, // Rule ID 48204 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48204,
        GIR_Done,
      // Label 1156: @27217
      GIM_Reject,
    // Label 1154: @27218
    GIM_Reject,
    // Label 1063: @27219
    GIM_Try, /*On fail goto*//*Label 1157*/ 27302,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1158*/ 27271, // Rule ID 48219 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48219,
        GIR_Done,
      // Label 1158: @27271
      GIM_Try, /*On fail goto*//*Label 1159*/ 27301, // Rule ID 48220 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48220,
        GIR_Done,
      // Label 1159: @27301
      GIM_Reject,
    // Label 1157: @27302
    GIM_Reject,
    // Label 1064: @27303
    GIM_Try, /*On fail goto*//*Label 1160*/ 27386,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1161*/ 27355, // Rule ID 48235 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48235,
        GIR_Done,
      // Label 1161: @27355
      GIM_Try, /*On fail goto*//*Label 1162*/ 27385, // Rule ID 48236 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48236,
        GIR_Done,
      // Label 1162: @27385
      GIM_Reject,
    // Label 1160: @27386
    GIM_Reject,
    // Label 1065: @27387
    GIM_Try, /*On fail goto*//*Label 1163*/ 27470,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1164*/ 27439, // Rule ID 53001 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53001,
        GIR_Done,
      // Label 1164: @27439
      GIM_Try, /*On fail goto*//*Label 1165*/ 27469, // Rule ID 53002 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53002,
        GIR_Done,
      // Label 1165: @27469
      GIM_Reject,
    // Label 1163: @27470
    GIM_Reject,
    // Label 1066: @27471
    GIM_Try, /*On fail goto*//*Label 1166*/ 27554,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1167*/ 27523, // Rule ID 48191 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48191,
        GIR_Done,
      // Label 1167: @27523
      GIM_Try, /*On fail goto*//*Label 1168*/ 27553, // Rule ID 48192 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48192,
        GIR_Done,
      // Label 1168: @27553
      GIM_Reject,
    // Label 1166: @27554
    GIM_Reject,
    // Label 1067: @27555
    GIM_Try, /*On fail goto*//*Label 1169*/ 27638,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1170*/ 27607, // Rule ID 48207 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48207,
        GIR_Done,
      // Label 1170: @27607
      GIM_Try, /*On fail goto*//*Label 1171*/ 27637, // Rule ID 48208 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48208,
        GIR_Done,
      // Label 1171: @27637
      GIM_Reject,
    // Label 1169: @27638
    GIM_Reject,
    // Label 1068: @27639
    GIM_Try, /*On fail goto*//*Label 1172*/ 27722,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1173*/ 27691, // Rule ID 48223 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48223,
        GIR_Done,
      // Label 1173: @27691
      GIM_Try, /*On fail goto*//*Label 1174*/ 27721, // Rule ID 48224 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48224,
        GIR_Done,
      // Label 1174: @27721
      GIM_Reject,
    // Label 1172: @27722
    GIM_Reject,
    // Label 1069: @27723
    GIM_Try, /*On fail goto*//*Label 1175*/ 27806,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1176*/ 27775, // Rule ID 53019 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53019,
        GIR_Done,
      // Label 1176: @27775
      GIM_Try, /*On fail goto*//*Label 1177*/ 27805, // Rule ID 53020 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53020,
        GIR_Done,
      // Label 1177: @27805
      GIM_Reject,
    // Label 1175: @27806
    GIM_Reject,
    // Label 1070: @27807
    GIM_Try, /*On fail goto*//*Label 1178*/ 27890,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1179*/ 27859, // Rule ID 48195 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48195,
        GIR_Done,
      // Label 1179: @27859
      GIM_Try, /*On fail goto*//*Label 1180*/ 27889, // Rule ID 48196 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48196,
        GIR_Done,
      // Label 1180: @27889
      GIM_Reject,
    // Label 1178: @27890
    GIM_Reject,
    // Label 1071: @27891
    GIM_Try, /*On fail goto*//*Label 1181*/ 27974,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1182*/ 27943, // Rule ID 48211 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48211,
        GIR_Done,
      // Label 1182: @27943
      GIM_Try, /*On fail goto*//*Label 1183*/ 27973, // Rule ID 48212 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48212,
        GIR_Done,
      // Label 1183: @27973
      GIM_Reject,
    // Label 1181: @27974
    GIM_Reject,
    // Label 1072: @27975
    GIM_Try, /*On fail goto*//*Label 1184*/ 28058,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1185*/ 28027, // Rule ID 53037 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53037,
        GIR_Done,
      // Label 1185: @28027
      GIM_Try, /*On fail goto*//*Label 1186*/ 28057, // Rule ID 53038 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53038,
        GIR_Done,
      // Label 1186: @28057
      GIM_Reject,
    // Label 1184: @28058
    GIM_Reject,
    // Label 1073: @28059
    GIM_Try, /*On fail goto*//*Label 1187*/ 28142,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1188*/ 28111, // Rule ID 48199 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48199,
        GIR_Done,
      // Label 1188: @28111
      GIM_Try, /*On fail goto*//*Label 1189*/ 28141, // Rule ID 48200 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48200,
        GIR_Done,
      // Label 1189: @28141
      GIM_Reject,
    // Label 1187: @28142
    GIM_Reject,
    // Label 1074: @28143
    GIM_Reject,
    // Label 10: @28144
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1192*/ 28244,
    /*GILLT_s32*//*Label 1190*/ 28152,
    /*GILLT_s64*//*Label 1191*/ 28198,
    // Label 1190: @28152
    GIM_Try, /*On fail goto*//*Label 1193*/ 28197,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1194*/ 28177, // Rule ID 56488 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (FMV_W_X:{ *:[f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_W_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56488,
        GIR_Done,
      // Label 1194: @28177
      GIM_Try, /*On fail goto*//*Label 1195*/ 28196, // Rule ID 56489 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FMV_X_W:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56489,
        GIR_Done,
      // Label 1195: @28196
      GIM_Reject,
    // Label 1193: @28197
    GIM_Reject,
    // Label 1191: @28198
    GIM_Try, /*On fail goto*//*Label 1196*/ 28243,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1197*/ 28223, // Rule ID 56650 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f64] } GPR:{ *:[i64] }:$rs1)  =>  (FMV_D_X:{ *:[f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_D_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56650,
        GIR_Done,
      // Label 1197: @28223
      GIM_Try, /*On fail goto*//*Label 1198*/ 28242, // Rule ID 56651 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
        // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)  =>  (FMV_X_D:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56651,
        GIR_Done,
      // Label 1198: @28242
      GIM_Reject,
    // Label 1196: @28243
    GIM_Reject,
    // Label 1192: @28244
    GIM_Reject,
    // Label 11: @28245
    GIM_Try, /*On fail goto*//*Label 1199*/ 28276, // Rule ID 56102 //
      GIM_CheckFeatures, GIFBS_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (CSRRS:{ *:[i64] } 3072:{ *:[i64] }, X0:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CSRRS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddImm, /*InsnID*/0, /*Imm*/3072,
      GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 56102,
      GIR_Done,
    // Label 1199: @28276
    GIM_Reject,
    // Label 12: @28277
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/3, 32, /*)*//*default:*//*Label 1229*/ 31027,
    /*GILLT_nxv1s1*//*Label 1200*/ 28312,
    /*GILLT_nxv1s8*//*Label 1201*/ 28403,
    /*GILLT_nxv1s16*//*Label 1202*/ 28494,
    /*GILLT_nxv1s32*//*Label 1203*/ 28661,
    /*GILLT_nxv1s64*//*Label 1204*/ 28828,
    /*GILLT_nxv2s1*//*Label 1205*/ 28919,
    /*GILLT_nxv2s8*//*Label 1206*/ 29010,
    /*GILLT_nxv2s16*//*Label 1207*/ 29101,
    /*GILLT_nxv2s32*//*Label 1208*/ 29268,
    /*GILLT_nxv2s64*//*Label 1209*/ 29359,
    /*GILLT_nxv4s1*//*Label 1210*/ 29450,
    /*GILLT_nxv4s8*//*Label 1211*/ 29541,
    /*GILLT_nxv4s16*//*Label 1212*/ 29632,
    /*GILLT_nxv4s32*//*Label 1213*/ 29723,
    /*GILLT_nxv4s64*//*Label 1214*/ 29814,
    /*GILLT_nxv8s1*//*Label 1215*/ 29905,
    /*GILLT_nxv8s8*//*Label 1216*/ 29996,
    /*GILLT_nxv8s16*//*Label 1217*/ 30049,
    /*GILLT_nxv8s32*//*Label 1218*/ 30140,
    /*GILLT_nxv8s64*//*Label 1219*/ 30231,
    /*GILLT_nxv16s1*//*Label 1220*/ 30322,
    /*GILLT_nxv16s8*//*Label 1221*/ 30413,
    /*GILLT_nxv16s16*//*Label 1222*/ 30466,
    /*GILLT_nxv16s32*//*Label 1223*/ 30557,
    /*GILLT_nxv32s1*//*Label 1224*/ 30648,
    /*GILLT_nxv32s8*//*Label 1225*/ 30739,
    /*GILLT_nxv32s16*//*Label 1226*/ 30792,
    /*GILLT_nxv64s1*//*Label 1227*/ 30883,
    /*GILLT_nxv64s8*//*Label 1228*/ 30974,
    // Label 1200: @28312
    GIM_Try, /*On fail goto*//*Label 1230*/ 28402,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1231*/ 28363, // Rule ID 46443 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B1:{ *:[nxv1i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46443,
        GIR_Done,
      // Label 1231: @28363
      GIM_Try, /*On fail goto*//*Label 1232*/ 28401, // Rule ID 46444 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B1:{ *:[nxv1i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46444,
        GIR_Done,
      // Label 1232: @28401
      GIM_Reject,
    // Label 1230: @28402
    GIM_Reject,
    // Label 1201: @28403
    GIM_Try, /*On fail goto*//*Label 1233*/ 28493,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1234*/ 28454, // Rule ID 46435 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF8:{ *:[nxv1i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46435,
        GIR_Done,
      // Label 1234: @28454
      GIM_Try, /*On fail goto*//*Label 1235*/ 28492, // Rule ID 46436 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF8:{ *:[nxv1i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46436,
        GIR_Done,
      // Label 1235: @28492
      GIM_Reject,
    // Label 1233: @28493
    GIM_Reject,
    // Label 1202: @28494
    GIM_Try, /*On fail goto*//*Label 1236*/ 28660,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1237*/ 28545, // Rule ID 46551 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1i16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46551,
        GIR_Done,
      // Label 1237: @28545
      GIM_Try, /*On fail goto*//*Label 1238*/ 28583, // Rule ID 46552 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1i16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46552,
        GIR_Done,
      // Label 1238: @28583
      GIM_Try, /*On fail goto*//*Label 1239*/ 28621, // Rule ID 46563 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1f16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46563,
        GIR_Done,
      // Label 1239: @28621
      GIM_Try, /*On fail goto*//*Label 1240*/ 28659, // Rule ID 46564 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1f16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46564,
        GIR_Done,
      // Label 1240: @28659
      GIM_Reject,
    // Label 1236: @28660
    GIM_Reject,
    // Label 1203: @28661
    GIM_Try, /*On fail goto*//*Label 1241*/ 28827,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1242*/ 28712, // Rule ID 46559 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1i32] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46559,
        GIR_Done,
      // Label 1242: @28712
      GIM_Try, /*On fail goto*//*Label 1243*/ 28750, // Rule ID 46560 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46560,
        GIR_Done,
      // Label 1243: @28750
      GIM_Try, /*On fail goto*//*Label 1244*/ 28788, // Rule ID 46571 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1f32] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46571,
        GIR_Done,
      // Label 1244: @28788
      GIM_Try, /*On fail goto*//*Label 1245*/ 28826, // Rule ID 46572 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1f32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46572,
        GIR_Done,
      // Label 1245: @28826
      GIM_Reject,
    // Label 1241: @28827
    GIM_Reject,
    // Label 1204: @28828
    GIM_Try, /*On fail goto*//*Label 1246*/ 28918,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1247*/ 28860, // Rule ID 46583 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46583,
        GIR_Done,
      // Label 1247: @28860
      GIM_Try, /*On fail goto*//*Label 1248*/ 28879, // Rule ID 46584 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46584,
        GIR_Done,
      // Label 1248: @28879
      GIM_Try, /*On fail goto*//*Label 1249*/ 28898, // Rule ID 46595 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46595,
        GIR_Done,
      // Label 1249: @28898
      GIM_Try, /*On fail goto*//*Label 1250*/ 28917, // Rule ID 46596 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46596,
        GIR_Done,
      // Label 1250: @28917
      GIM_Reject,
    // Label 1246: @28918
    GIM_Reject,
    // Label 1205: @28919
    GIM_Try, /*On fail goto*//*Label 1251*/ 29009,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1252*/ 28970, // Rule ID 46683 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B2:{ *:[nxv2i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46683,
        GIR_Done,
      // Label 1252: @28970
      GIM_Try, /*On fail goto*//*Label 1253*/ 29008, // Rule ID 46684 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B2:{ *:[nxv2i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46684,
        GIR_Done,
      // Label 1253: @29008
      GIM_Reject,
    // Label 1251: @29009
    GIM_Reject,
    // Label 1206: @29010
    GIM_Try, /*On fail goto*//*Label 1254*/ 29100,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1255*/ 29061, // Rule ID 46543 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF4:{ *:[nxv2i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46543,
        GIR_Done,
      // Label 1255: @29061
      GIM_Try, /*On fail goto*//*Label 1256*/ 29099, // Rule ID 46544 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF4:{ *:[nxv2i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46544,
        GIR_Done,
      // Label 1256: @29099
      GIM_Reject,
    // Label 1254: @29100
    GIM_Reject,
    // Label 1207: @29101
    GIM_Try, /*On fail goto*//*Label 1257*/ 29267,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1258*/ 29152, // Rule ID 46555 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2i16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46555,
        GIR_Done,
      // Label 1258: @29152
      GIM_Try, /*On fail goto*//*Label 1259*/ 29190, // Rule ID 46556 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2i16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46556,
        GIR_Done,
      // Label 1259: @29190
      GIM_Try, /*On fail goto*//*Label 1260*/ 29228, // Rule ID 46567 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2f16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46567,
        GIR_Done,
      // Label 1260: @29228
      GIM_Try, /*On fail goto*//*Label 1261*/ 29266, // Rule ID 46568 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2f16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46568,
        GIR_Done,
      // Label 1261: @29266
      GIM_Reject,
    // Label 1257: @29267
    GIM_Reject,
    // Label 1208: @29268
    GIM_Try, /*On fail goto*//*Label 1262*/ 29358,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1263*/ 29300, // Rule ID 46579 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46579,
        GIR_Done,
      // Label 1263: @29300
      GIM_Try, /*On fail goto*//*Label 1264*/ 29319, // Rule ID 46580 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46580,
        GIR_Done,
      // Label 1264: @29319
      GIM_Try, /*On fail goto*//*Label 1265*/ 29338, // Rule ID 46591 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46591,
        GIR_Done,
      // Label 1265: @29338
      GIM_Try, /*On fail goto*//*Label 1266*/ 29357, // Rule ID 46592 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46592,
        GIR_Done,
      // Label 1266: @29357
      GIM_Reject,
    // Label 1262: @29358
    GIM_Reject,
    // Label 1209: @29359
    GIM_Try, /*On fail goto*//*Label 1267*/ 29449,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1268*/ 29391, // Rule ID 46635 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46635,
        GIR_Done,
      // Label 1268: @29391
      GIM_Try, /*On fail goto*//*Label 1269*/ 29410, // Rule ID 46636 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46636,
        GIR_Done,
      // Label 1269: @29410
      GIM_Try, /*On fail goto*//*Label 1270*/ 29429, // Rule ID 46671 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46671,
        GIR_Done,
      // Label 1270: @29429
      GIM_Try, /*On fail goto*//*Label 1271*/ 29448, // Rule ID 46672 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46672,
        GIR_Done,
      // Label 1271: @29448
      GIM_Reject,
    // Label 1267: @29449
    GIM_Reject,
    // Label 1210: @29450
    GIM_Try, /*On fail goto*//*Label 1272*/ 29540,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1273*/ 29501, // Rule ID 46687 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B4:{ *:[nxv4i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46687,
        GIR_Done,
      // Label 1273: @29501
      GIM_Try, /*On fail goto*//*Label 1274*/ 29539, // Rule ID 46688 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B4:{ *:[nxv4i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46688,
        GIR_Done,
      // Label 1274: @29539
      GIM_Reject,
    // Label 1272: @29540
    GIM_Reject,
    // Label 1211: @29541
    GIM_Try, /*On fail goto*//*Label 1275*/ 29631,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1276*/ 29592, // Rule ID 46547 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF2:{ *:[nxv4i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46547,
        GIR_Done,
      // Label 1276: @29592
      GIM_Try, /*On fail goto*//*Label 1277*/ 29630, // Rule ID 46548 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF2:{ *:[nxv4i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46548,
        GIR_Done,
      // Label 1277: @29630
      GIM_Reject,
    // Label 1275: @29631
    GIM_Reject,
    // Label 1212: @29632
    GIM_Try, /*On fail goto*//*Label 1278*/ 29722,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1279*/ 29664, // Rule ID 46575 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46575,
        GIR_Done,
      // Label 1279: @29664
      GIM_Try, /*On fail goto*//*Label 1280*/ 29683, // Rule ID 46576 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46576,
        GIR_Done,
      // Label 1280: @29683
      GIM_Try, /*On fail goto*//*Label 1281*/ 29702, // Rule ID 46587 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46587,
        GIR_Done,
      // Label 1281: @29702
      GIM_Try, /*On fail goto*//*Label 1282*/ 29721, // Rule ID 46588 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46588,
        GIR_Done,
      // Label 1282: @29721
      GIM_Reject,
    // Label 1278: @29722
    GIM_Reject,
    // Label 1213: @29723
    GIM_Try, /*On fail goto*//*Label 1283*/ 29813,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1284*/ 29755, // Rule ID 46623 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46623,
        GIR_Done,
      // Label 1284: @29755
      GIM_Try, /*On fail goto*//*Label 1285*/ 29774, // Rule ID 46624 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46624,
        GIR_Done,
      // Label 1285: @29774
      GIM_Try, /*On fail goto*//*Label 1286*/ 29793, // Rule ID 46659 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46659,
        GIR_Done,
      // Label 1286: @29793
      GIM_Try, /*On fail goto*//*Label 1287*/ 29812, // Rule ID 46660 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46660,
        GIR_Done,
      // Label 1287: @29812
      GIM_Reject,
    // Label 1283: @29813
    GIM_Reject,
    // Label 1214: @29814
    GIM_Try, /*On fail goto*//*Label 1288*/ 29904,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1289*/ 29846, // Rule ID 46639 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46639,
        GIR_Done,
      // Label 1289: @29846
      GIM_Try, /*On fail goto*//*Label 1290*/ 29865, // Rule ID 46640 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46640,
        GIR_Done,
      // Label 1290: @29865
      GIM_Try, /*On fail goto*//*Label 1291*/ 29884, // Rule ID 46675 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46675,
        GIR_Done,
      // Label 1291: @29884
      GIM_Try, /*On fail goto*//*Label 1292*/ 29903, // Rule ID 46676 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46676,
        GIR_Done,
      // Label 1292: @29903
      GIM_Reject,
    // Label 1288: @29904
    GIM_Reject,
    // Label 1215: @29905
    GIM_Try, /*On fail goto*//*Label 1293*/ 29995,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1294*/ 29956, // Rule ID 46691 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B8:{ *:[nxv8i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46691,
        GIR_Done,
      // Label 1294: @29956
      GIM_Try, /*On fail goto*//*Label 1295*/ 29994, // Rule ID 46692 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B8:{ *:[nxv8i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46692,
        GIR_Done,
      // Label 1295: @29994
      GIM_Reject,
    // Label 1293: @29995
    GIM_Reject,
    // Label 1216: @29996
    GIM_Try, /*On fail goto*//*Label 1296*/ 30048,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1297*/ 30028, // Rule ID 46439 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE8_V:{ *:[nxv8i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46439,
        GIR_Done,
      // Label 1297: @30028
      GIM_Try, /*On fail goto*//*Label 1298*/ 30047, // Rule ID 46440 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE8_V:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46440,
        GIR_Done,
      // Label 1298: @30047
      GIM_Reject,
    // Label 1296: @30048
    GIM_Reject,
    // Label 1217: @30049
    GIM_Try, /*On fail goto*//*Label 1299*/ 30139,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1300*/ 30081, // Rule ID 46611 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46611,
        GIR_Done,
      // Label 1300: @30081
      GIM_Try, /*On fail goto*//*Label 1301*/ 30100, // Rule ID 46612 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46612,
        GIR_Done,
      // Label 1301: @30100
      GIM_Try, /*On fail goto*//*Label 1302*/ 30119, // Rule ID 46647 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46647,
        GIR_Done,
      // Label 1302: @30119
      GIM_Try, /*On fail goto*//*Label 1303*/ 30138, // Rule ID 46648 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46648,
        GIR_Done,
      // Label 1303: @30138
      GIM_Reject,
    // Label 1299: @30139
    GIM_Reject,
    // Label 1218: @30140
    GIM_Try, /*On fail goto*//*Label 1304*/ 30230,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1305*/ 30172, // Rule ID 46627 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46627,
        GIR_Done,
      // Label 1305: @30172
      GIM_Try, /*On fail goto*//*Label 1306*/ 30191, // Rule ID 46628 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46628,
        GIR_Done,
      // Label 1306: @30191
      GIM_Try, /*On fail goto*//*Label 1307*/ 30210, // Rule ID 46663 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46663,
        GIR_Done,
      // Label 1307: @30210
      GIM_Try, /*On fail goto*//*Label 1308*/ 30229, // Rule ID 46664 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46664,
        GIR_Done,
      // Label 1308: @30229
      GIM_Reject,
    // Label 1304: @30230
    GIM_Reject,
    // Label 1219: @30231
    GIM_Try, /*On fail goto*//*Label 1309*/ 30321,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1310*/ 30263, // Rule ID 46643 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46643,
        GIR_Done,
      // Label 1310: @30263
      GIM_Try, /*On fail goto*//*Label 1311*/ 30282, // Rule ID 46644 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46644,
        GIR_Done,
      // Label 1311: @30282
      GIM_Try, /*On fail goto*//*Label 1312*/ 30301, // Rule ID 46679 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46679,
        GIR_Done,
      // Label 1312: @30301
      GIM_Try, /*On fail goto*//*Label 1313*/ 30320, // Rule ID 46680 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46680,
        GIR_Done,
      // Label 1313: @30320
      GIM_Reject,
    // Label 1309: @30321
    GIM_Reject,
    // Label 1220: @30322
    GIM_Try, /*On fail goto*//*Label 1314*/ 30412,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1315*/ 30373, // Rule ID 46695 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B16:{ *:[nxv16i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46695,
        GIR_Done,
      // Label 1315: @30373
      GIM_Try, /*On fail goto*//*Label 1316*/ 30411, // Rule ID 46696 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B16:{ *:[nxv16i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46696,
        GIR_Done,
      // Label 1316: @30411
      GIM_Reject,
    // Label 1314: @30412
    GIM_Reject,
    // Label 1221: @30413
    GIM_Try, /*On fail goto*//*Label 1317*/ 30465,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1318*/ 30445, // Rule ID 46599 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE8_V:{ *:[nxv16i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46599,
        GIR_Done,
      // Label 1318: @30445
      GIM_Try, /*On fail goto*//*Label 1319*/ 30464, // Rule ID 46600 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE8_V:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46600,
        GIR_Done,
      // Label 1319: @30464
      GIM_Reject,
    // Label 1317: @30465
    GIM_Reject,
    // Label 1222: @30466
    GIM_Try, /*On fail goto*//*Label 1320*/ 30556,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1321*/ 30498, // Rule ID 46615 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46615,
        GIR_Done,
      // Label 1321: @30498
      GIM_Try, /*On fail goto*//*Label 1322*/ 30517, // Rule ID 46616 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46616,
        GIR_Done,
      // Label 1322: @30517
      GIM_Try, /*On fail goto*//*Label 1323*/ 30536, // Rule ID 46651 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46651,
        GIR_Done,
      // Label 1323: @30536
      GIM_Try, /*On fail goto*//*Label 1324*/ 30555, // Rule ID 46652 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46652,
        GIR_Done,
      // Label 1324: @30555
      GIM_Reject,
    // Label 1320: @30556
    GIM_Reject,
    // Label 1223: @30557
    GIM_Try, /*On fail goto*//*Label 1325*/ 30647,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1326*/ 30589, // Rule ID 46631 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46631,
        GIR_Done,
      // Label 1326: @30589
      GIM_Try, /*On fail goto*//*Label 1327*/ 30608, // Rule ID 46632 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46632,
        GIR_Done,
      // Label 1327: @30608
      GIM_Try, /*On fail goto*//*Label 1328*/ 30627, // Rule ID 46667 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46667,
        GIR_Done,
      // Label 1328: @30627
      GIM_Try, /*On fail goto*//*Label 1329*/ 30646, // Rule ID 46668 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46668,
        GIR_Done,
      // Label 1329: @30646
      GIM_Reject,
    // Label 1325: @30647
    GIM_Reject,
    // Label 1224: @30648
    GIM_Try, /*On fail goto*//*Label 1330*/ 30738,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1331*/ 30699, // Rule ID 46699 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B32:{ *:[nxv32i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46699,
        GIR_Done,
      // Label 1331: @30699
      GIM_Try, /*On fail goto*//*Label 1332*/ 30737, // Rule ID 46700 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B32:{ *:[nxv32i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46700,
        GIR_Done,
      // Label 1332: @30737
      GIM_Reject,
    // Label 1330: @30738
    GIM_Reject,
    // Label 1225: @30739
    GIM_Try, /*On fail goto*//*Label 1333*/ 30791,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1334*/ 30771, // Rule ID 46603 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE8_V:{ *:[nxv32i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46603,
        GIR_Done,
      // Label 1334: @30771
      GIM_Try, /*On fail goto*//*Label 1335*/ 30790, // Rule ID 46604 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE8_V:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46604,
        GIR_Done,
      // Label 1335: @30790
      GIM_Reject,
    // Label 1333: @30791
    GIM_Reject,
    // Label 1226: @30792
    GIM_Try, /*On fail goto*//*Label 1336*/ 30882,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1337*/ 30824, // Rule ID 46619 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46619,
        GIR_Done,
      // Label 1337: @30824
      GIM_Try, /*On fail goto*//*Label 1338*/ 30843, // Rule ID 46620 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46620,
        GIR_Done,
      // Label 1338: @30843
      GIM_Try, /*On fail goto*//*Label 1339*/ 30862, // Rule ID 46655 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46655,
        GIR_Done,
      // Label 1339: @30862
      GIM_Try, /*On fail goto*//*Label 1340*/ 30881, // Rule ID 46656 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46656,
        GIR_Done,
      // Label 1340: @30881
      GIM_Reject,
    // Label 1336: @30882
    GIM_Reject,
    // Label 1227: @30883
    GIM_Try, /*On fail goto*//*Label 1341*/ 30973,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1342*/ 30934, // Rule ID 46703 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B64:{ *:[nxv64i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46703,
        GIR_Done,
      // Label 1342: @30934
      GIM_Try, /*On fail goto*//*Label 1343*/ 30972, // Rule ID 46704 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B64:{ *:[nxv64i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46704,
        GIR_Done,
      // Label 1343: @30972
      GIM_Reject,
    // Label 1341: @30973
    GIM_Reject,
    // Label 1228: @30974
    GIM_Try, /*On fail goto*//*Label 1344*/ 31026,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1345*/ 31006, // Rule ID 46607 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE8_V:{ *:[nxv64i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46607,
        GIR_Done,
      // Label 1345: @31006
      GIM_Try, /*On fail goto*//*Label 1346*/ 31025, // Rule ID 46608 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE8_V:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46608,
        GIR_Done,
      // Label 1346: @31025
      GIM_Reject,
    // Label 1344: @31026
    GIM_Reject,
    // Label 1229: @31027
    GIM_Reject,
    // Label 13: @31028
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 32, /*)*//*default:*//*Label 1379*/ 35588,
    /*GILLT_s16*//*Label 1347*/ 31066,
    /*GILLT_s32*//*Label 1348*/ 31833,
    /*GILLT_s64*//*Label 1349*/ 32474,
    /*GILLT_nxv1s1*//*Label 1350*/ 32989,
    /*GILLT_nxv1s8*//*Label 1351*/ 33076,
    /*GILLT_nxv1s16*//*Label 1352*/ 33163,
    /*GILLT_nxv1s32*//*Label 1353*/ 33326,
    /*GILLT_nxv1s64*//*Label 1354*/ 33489,
    /*GILLT_nxv2s1*//*Label 1355*/ 33576,
    /*GILLT_nxv2s8*//*Label 1356*/ 33663,
    /*GILLT_nxv2s16*//*Label 1357*/ 33750,
    /*GILLT_nxv2s32*//*Label 1358*/ 33913,
    /*GILLT_nxv2s64*//*Label 1359*/ 34000,
    /*GILLT_nxv4s1*//*Label 1360*/ 34087,
    /*GILLT_nxv4s8*//*Label 1361*/ 34174,
    /*GILLT_nxv4s16*//*Label 1362*/ 34261,
    /*GILLT_nxv4s32*//*Label 1363*/ 34348,
    /*GILLT_nxv4s64*//*Label 1364*/ 34435,
    /*GILLT_nxv8s1*//*Label 1365*/ 34522,
    /*GILLT_nxv8s8*//*Label 1366*/ 34609,
    /*GILLT_nxv8s16*//*Label 1367*/ 34658,
    /*GILLT_nxv8s32*//*Label 1368*/ 34745,
    /*GILLT_nxv8s64*//*Label 1369*/ 34832,
    /*GILLT_nxv16s1*//*Label 1370*/ 34919,
    /*GILLT_nxv16s8*//*Label 1371*/ 35006,
    /*GILLT_nxv16s16*//*Label 1372*/ 35055,
    /*GILLT_nxv16s32*//*Label 1373*/ 35142,
    /*GILLT_nxv32s1*//*Label 1374*/ 35229,
    /*GILLT_nxv32s8*//*Label 1375*/ 35316,
    /*GILLT_nxv32s16*//*Label 1376*/ 35365,
    /*GILLT_nxv64s1*//*Label 1377*/ 35452,
    /*GILLT_nxv64s8*//*Label 1378*/ 35539,
    // Label 1347: @31066
    GIM_Try, /*On fail goto*//*Label 1380*/ 31832,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1381*/ 31138, // Rule ID 55661 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55661,
        GIR_Done,
      // Label 1381: @31138
      GIM_Try, /*On fail goto*//*Label 1382*/ 31201, // Rule ID 55662 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55662,
        GIR_Done,
      // Label 1382: @31201
      GIM_Try, /*On fail goto*//*Label 1383*/ 31264, // Rule ID 55667 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv2f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55667,
        GIR_Done,
      // Label 1383: @31264
      GIM_Try, /*On fail goto*//*Label 1384*/ 31327, // Rule ID 55668 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv2f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55668,
        GIR_Done,
      // Label 1384: @31327
      GIM_Try, /*On fail goto*//*Label 1385*/ 31390, // Rule ID 55679 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv4f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M1 VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55679,
        GIR_Done,
      // Label 1385: @31390
      GIM_Try, /*On fail goto*//*Label 1386*/ 31453, // Rule ID 55680 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VR:{ *:[nxv4f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M1 VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55680,
        GIR_Done,
      // Label 1386: @31453
      GIM_Try, /*On fail goto*//*Label 1387*/ 31516, // Rule ID 55697 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv8f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M2 VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55697,
        GIR_Done,
      // Label 1387: @31516
      GIM_Try, /*On fail goto*//*Label 1388*/ 31579, // Rule ID 55698 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv8f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M2 VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55698,
        GIR_Done,
      // Label 1388: @31579
      GIM_Try, /*On fail goto*//*Label 1389*/ 31642, // Rule ID 55703 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv16f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M4 VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55703,
        GIR_Done,
      // Label 1389: @31642
      GIM_Try, /*On fail goto*//*Label 1390*/ 31705, // Rule ID 55704 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv16f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M4 VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55704,
        GIR_Done,
      // Label 1390: @31705
      GIM_Try, /*On fail goto*//*Label 1391*/ 31768, // Rule ID 55709 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv32f16] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M8 VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55709,
        GIR_Done,
      // Label 1391: @31768
      GIM_Try, /*On fail goto*//*Label 1392*/ 31831, // Rule ID 55710 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv32s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f16] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv32f16] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_M8 VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55710,
        GIR_Done,
      // Label 1392: @31831
      GIM_Reject,
    // Label 1380: @31832
    GIM_Reject,
    // Label 1348: @31833
    GIM_Try, /*On fail goto*//*Label 1393*/ 32473,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1394*/ 31905, // Rule ID 55673 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f32] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55673,
        GIR_Done,
      // Label 1394: @31905
      GIM_Try, /*On fail goto*//*Label 1395*/ 31968, // Rule ID 55674 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f32] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55674,
        GIR_Done,
      // Label 1395: @31968
      GIM_Try, /*On fail goto*//*Label 1396*/ 32031, // Rule ID 55685 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VR:{ *:[nxv2f32] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M1 VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55685,
        GIR_Done,
      // Label 1396: @32031
      GIM_Try, /*On fail goto*//*Label 1397*/ 32094, // Rule ID 55686 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VR:{ *:[nxv2f32] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M1 VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55686,
        GIR_Done,
      // Label 1397: @32094
      GIM_Try, /*On fail goto*//*Label 1398*/ 32157, // Rule ID 55715 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv4f32] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M2 VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55715,
        GIR_Done,
      // Label 1398: @32157
      GIM_Try, /*On fail goto*//*Label 1399*/ 32220, // Rule ID 55716 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv4f32] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M2 VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55716,
        GIR_Done,
      // Label 1399: @32220
      GIM_Try, /*On fail goto*//*Label 1400*/ 32283, // Rule ID 55721 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv8f32] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M4 VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55721,
        GIR_Done,
      // Label 1400: @32283
      GIM_Try, /*On fail goto*//*Label 1401*/ 32346, // Rule ID 55722 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv8f32] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M4 VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55722,
        GIR_Done,
      // Label 1401: @32346
      GIM_Try, /*On fail goto*//*Label 1402*/ 32409, // Rule ID 55727 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv16f32] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M8 VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55727,
        GIR_Done,
      // Label 1402: @32409
      GIM_Try, /*On fail goto*//*Label 1403*/ 32472, // Rule ID 55728 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f32] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv16f32] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_M8 VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55728,
        GIR_Done,
      // Label 1403: @32472
      GIM_Reject,
    // Label 1393: @32473
    GIM_Reject,
    // Label 1349: @32474
    GIM_Try, /*On fail goto*//*Label 1404*/ 32988,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1405*/ 32546, // Rule ID 55691 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f64] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M1 VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55691,
        GIR_Done,
      // Label 1405: @32546
      GIM_Try, /*On fail goto*//*Label 1406*/ 32609, // Rule ID 55692 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VR:{ *:[nxv1f64] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M1 VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55692,
        GIR_Done,
      // Label 1406: @32609
      GIM_Try, /*On fail goto*//*Label 1407*/ 32672, // Rule ID 55733 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv2f64] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M2 VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55733,
        GIR_Done,
      // Label 1407: @32672
      GIM_Try, /*On fail goto*//*Label 1408*/ 32735, // Rule ID 55734 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM2:{ *:[nxv2f64] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M2 VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55734,
        GIR_Done,
      // Label 1408: @32735
      GIM_Try, /*On fail goto*//*Label 1409*/ 32798, // Rule ID 55739 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv4f64] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M4 VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55739,
        GIR_Done,
      // Label 1409: @32798
      GIM_Try, /*On fail goto*//*Label 1410*/ 32861, // Rule ID 55740 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM4:{ *:[nxv4f64] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M4 VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55740,
        GIR_Done,
      // Label 1410: @32861
      GIM_Try, /*On fail goto*//*Label 1411*/ 32924, // Rule ID 55745 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv8f64] }:$rs2), GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M8 VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55745,
        GIR_Done,
      // Label 1411: @32924
      GIM_Try, /*On fail goto*//*Label 1412*/ 32987, // Rule ID 55746 //
        GIM_CheckFeatures, GIFBS_HasVInstructionsAnyF,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::riscv_vfmv_f_s,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (st (intrinsic_wo_chain:{ *:[f64] } 7636:{ *:[iPTR] }, VRM8:{ *:[nxv8f64] }:$rs2), GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE64_V_M8 VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE64_V_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55746,
        GIR_Done,
      // Label 1412: @32987
      GIM_Reject,
    // Label 1404: @32988
    GIM_Reject,
    // Label 1350: @32989
    GIM_Try, /*On fail goto*//*Label 1413*/ 33075,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1414*/ 33036, // Rule ID 46445 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i1:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B1 VR:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46445,
        GIR_Done,
      // Label 1414: @33036
      GIM_Try, /*On fail goto*//*Label 1415*/ 33074, // Rule ID 46446 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i1:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B1 VR:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46446,
        GIR_Done,
      // Label 1415: @33074
      GIM_Reject,
    // Label 1413: @33075
    GIM_Reject,
    // Label 1351: @33076
    GIM_Try, /*On fail goto*//*Label 1416*/ 33162,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1417*/ 33123, // Rule ID 46437 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i8:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF8 VR:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46437,
        GIR_Done,
      // Label 1417: @33123
      GIM_Try, /*On fail goto*//*Label 1418*/ 33161, // Rule ID 46438 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i8:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF8 VR:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46438,
        GIR_Done,
      // Label 1418: @33161
      GIM_Reject,
    // Label 1416: @33162
    GIM_Reject,
    // Label 1352: @33163
    GIM_Try, /*On fail goto*//*Label 1419*/ 33325,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1420*/ 33210, // Rule ID 46553 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i16:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46553,
        GIR_Done,
      // Label 1420: @33210
      GIM_Try, /*On fail goto*//*Label 1421*/ 33248, // Rule ID 46554 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i16:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46554,
        GIR_Done,
      // Label 1421: @33248
      GIM_Try, /*On fail goto*//*Label 1422*/ 33286, // Rule ID 46565 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f16:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46565,
        GIR_Done,
      // Label 1422: @33286
      GIM_Try, /*On fail goto*//*Label 1423*/ 33324, // Rule ID 46566 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f16:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46566,
        GIR_Done,
      // Label 1423: @33324
      GIM_Reject,
    // Label 1419: @33325
    GIM_Reject,
    // Label 1353: @33326
    GIM_Try, /*On fail goto*//*Label 1424*/ 33488,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1425*/ 33373, // Rule ID 46561 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i32:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46561,
        GIR_Done,
      // Label 1425: @33373
      GIM_Try, /*On fail goto*//*Label 1426*/ 33411, // Rule ID 46562 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i32:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46562,
        GIR_Done,
      // Label 1426: @33411
      GIM_Try, /*On fail goto*//*Label 1427*/ 33449, // Rule ID 46573 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f32:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46573,
        GIR_Done,
      // Label 1427: @33449
      GIM_Try, /*On fail goto*//*Label 1428*/ 33487, // Rule ID 46574 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f32:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46574,
        GIR_Done,
      // Label 1428: @33487
      GIM_Reject,
    // Label 1424: @33488
    GIM_Reject,
    // Label 1354: @33489
    GIM_Try, /*On fail goto*//*Label 1429*/ 33575,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1430*/ 33517, // Rule ID 46585 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i64:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46585,
        GIR_Done,
      // Label 1430: @33517
      GIM_Try, /*On fail goto*//*Label 1431*/ 33536, // Rule ID 46586 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i64:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46586,
        GIR_Done,
      // Label 1431: @33536
      GIM_Try, /*On fail goto*//*Label 1432*/ 33555, // Rule ID 46597 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f64:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46597,
        GIR_Done,
      // Label 1432: @33555
      GIM_Try, /*On fail goto*//*Label 1433*/ 33574, // Rule ID 46598 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f64:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46598,
        GIR_Done,
      // Label 1433: @33574
      GIM_Reject,
    // Label 1429: @33575
    GIM_Reject,
    // Label 1355: @33576
    GIM_Try, /*On fail goto*//*Label 1434*/ 33662,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1435*/ 33623, // Rule ID 46685 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i1:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B2 VR:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46685,
        GIR_Done,
      // Label 1435: @33623
      GIM_Try, /*On fail goto*//*Label 1436*/ 33661, // Rule ID 46686 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i1:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B2 VR:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46686,
        GIR_Done,
      // Label 1436: @33661
      GIM_Reject,
    // Label 1434: @33662
    GIM_Reject,
    // Label 1356: @33663
    GIM_Try, /*On fail goto*//*Label 1437*/ 33749,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1438*/ 33710, // Rule ID 46545 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i8:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF4 VR:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46545,
        GIR_Done,
      // Label 1438: @33710
      GIM_Try, /*On fail goto*//*Label 1439*/ 33748, // Rule ID 46546 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i8:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF4 VR:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46546,
        GIR_Done,
      // Label 1439: @33748
      GIM_Reject,
    // Label 1437: @33749
    GIM_Reject,
    // Label 1357: @33750
    GIM_Try, /*On fail goto*//*Label 1440*/ 33912,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1441*/ 33797, // Rule ID 46557 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i16:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46557,
        GIR_Done,
      // Label 1441: @33797
      GIM_Try, /*On fail goto*//*Label 1442*/ 33835, // Rule ID 46558 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i16:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46558,
        GIR_Done,
      // Label 1442: @33835
      GIM_Try, /*On fail goto*//*Label 1443*/ 33873, // Rule ID 46569 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f16:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46569,
        GIR_Done,
      // Label 1443: @33873
      GIM_Try, /*On fail goto*//*Label 1444*/ 33911, // Rule ID 46570 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f16:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46570,
        GIR_Done,
      // Label 1444: @33911
      GIM_Reject,
    // Label 1440: @33912
    GIM_Reject,
    // Label 1358: @33913
    GIM_Try, /*On fail goto*//*Label 1445*/ 33999,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1446*/ 33941, // Rule ID 46581 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i32:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46581,
        GIR_Done,
      // Label 1446: @33941
      GIM_Try, /*On fail goto*//*Label 1447*/ 33960, // Rule ID 46582 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i32:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46582,
        GIR_Done,
      // Label 1447: @33960
      GIM_Try, /*On fail goto*//*Label 1448*/ 33979, // Rule ID 46593 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f32:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46593,
        GIR_Done,
      // Label 1448: @33979
      GIM_Try, /*On fail goto*//*Label 1449*/ 33998, // Rule ID 46594 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f32:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46594,
        GIR_Done,
      // Label 1449: @33998
      GIM_Reject,
    // Label 1445: @33999
    GIM_Reject,
    // Label 1359: @34000
    GIM_Try, /*On fail goto*//*Label 1450*/ 34086,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1451*/ 34028, // Rule ID 46637 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i64:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46637,
        GIR_Done,
      // Label 1451: @34028
      GIM_Try, /*On fail goto*//*Label 1452*/ 34047, // Rule ID 46638 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i64:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46638,
        GIR_Done,
      // Label 1452: @34047
      GIM_Try, /*On fail goto*//*Label 1453*/ 34066, // Rule ID 46673 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f64:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46673,
        GIR_Done,
      // Label 1453: @34066
      GIM_Try, /*On fail goto*//*Label 1454*/ 34085, // Rule ID 46674 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f64:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46674,
        GIR_Done,
      // Label 1454: @34085
      GIM_Reject,
    // Label 1450: @34086
    GIM_Reject,
    // Label 1360: @34087
    GIM_Try, /*On fail goto*//*Label 1455*/ 34173,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1456*/ 34134, // Rule ID 46689 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i1:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B4 VR:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46689,
        GIR_Done,
      // Label 1456: @34134
      GIM_Try, /*On fail goto*//*Label 1457*/ 34172, // Rule ID 46690 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i1:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B4 VR:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46690,
        GIR_Done,
      // Label 1457: @34172
      GIM_Reject,
    // Label 1455: @34173
    GIM_Reject,
    // Label 1361: @34174
    GIM_Try, /*On fail goto*//*Label 1458*/ 34260,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1459*/ 34221, // Rule ID 46549 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i8:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF2 VR:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46549,
        GIR_Done,
      // Label 1459: @34221
      GIM_Try, /*On fail goto*//*Label 1460*/ 34259, // Rule ID 46550 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i8:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF2 VR:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46550,
        GIR_Done,
      // Label 1460: @34259
      GIM_Reject,
    // Label 1458: @34260
    GIM_Reject,
    // Label 1362: @34261
    GIM_Try, /*On fail goto*//*Label 1461*/ 34347,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1462*/ 34289, // Rule ID 46577 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i16:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46577,
        GIR_Done,
      // Label 1462: @34289
      GIM_Try, /*On fail goto*//*Label 1463*/ 34308, // Rule ID 46578 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i16:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46578,
        GIR_Done,
      // Label 1463: @34308
      GIM_Try, /*On fail goto*//*Label 1464*/ 34327, // Rule ID 46589 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f16:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46589,
        GIR_Done,
      // Label 1464: @34327
      GIM_Try, /*On fail goto*//*Label 1465*/ 34346, // Rule ID 46590 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f16:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46590,
        GIR_Done,
      // Label 1465: @34346
      GIM_Reject,
    // Label 1461: @34347
    GIM_Reject,
    // Label 1363: @34348
    GIM_Try, /*On fail goto*//*Label 1466*/ 34434,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1467*/ 34376, // Rule ID 46625 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i32:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46625,
        GIR_Done,
      // Label 1467: @34376
      GIM_Try, /*On fail goto*//*Label 1468*/ 34395, // Rule ID 46626 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i32:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46626,
        GIR_Done,
      // Label 1468: @34395
      GIM_Try, /*On fail goto*//*Label 1469*/ 34414, // Rule ID 46661 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f32:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46661,
        GIR_Done,
      // Label 1469: @34414
      GIM_Try, /*On fail goto*//*Label 1470*/ 34433, // Rule ID 46662 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f32:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46662,
        GIR_Done,
      // Label 1470: @34433
      GIM_Reject,
    // Label 1466: @34434
    GIM_Reject,
    // Label 1364: @34435
    GIM_Try, /*On fail goto*//*Label 1471*/ 34521,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1472*/ 34463, // Rule ID 46641 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i64:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46641,
        GIR_Done,
      // Label 1472: @34463
      GIM_Try, /*On fail goto*//*Label 1473*/ 34482, // Rule ID 46642 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i64:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46642,
        GIR_Done,
      // Label 1473: @34482
      GIM_Try, /*On fail goto*//*Label 1474*/ 34501, // Rule ID 46677 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f64:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46677,
        GIR_Done,
      // Label 1474: @34501
      GIM_Try, /*On fail goto*//*Label 1475*/ 34520, // Rule ID 46678 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f64:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46678,
        GIR_Done,
      // Label 1475: @34520
      GIM_Reject,
    // Label 1471: @34521
    GIM_Reject,
    // Label 1365: @34522
    GIM_Try, /*On fail goto*//*Label 1476*/ 34608,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1477*/ 34569, // Rule ID 46693 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i1:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B8 VR:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46693,
        GIR_Done,
      // Label 1477: @34569
      GIM_Try, /*On fail goto*//*Label 1478*/ 34607, // Rule ID 46694 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i1:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B8 VR:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46694,
        GIR_Done,
      // Label 1478: @34607
      GIM_Reject,
    // Label 1476: @34608
    GIM_Reject,
    // Label 1366: @34609
    GIM_Try, /*On fail goto*//*Label 1479*/ 34657,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1480*/ 34637, // Rule ID 46441 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i8:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46441,
        GIR_Done,
      // Label 1480: @34637
      GIM_Try, /*On fail goto*//*Label 1481*/ 34656, // Rule ID 46442 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i8:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46442,
        GIR_Done,
      // Label 1481: @34656
      GIM_Reject,
    // Label 1479: @34657
    GIM_Reject,
    // Label 1367: @34658
    GIM_Try, /*On fail goto*//*Label 1482*/ 34744,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1483*/ 34686, // Rule ID 46613 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i16:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46613,
        GIR_Done,
      // Label 1483: @34686
      GIM_Try, /*On fail goto*//*Label 1484*/ 34705, // Rule ID 46614 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i16:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46614,
        GIR_Done,
      // Label 1484: @34705
      GIM_Try, /*On fail goto*//*Label 1485*/ 34724, // Rule ID 46649 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f16:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46649,
        GIR_Done,
      // Label 1485: @34724
      GIM_Try, /*On fail goto*//*Label 1486*/ 34743, // Rule ID 46650 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f16:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46650,
        GIR_Done,
      // Label 1486: @34743
      GIM_Reject,
    // Label 1482: @34744
    GIM_Reject,
    // Label 1368: @34745
    GIM_Try, /*On fail goto*//*Label 1487*/ 34831,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1488*/ 34773, // Rule ID 46629 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i32:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46629,
        GIR_Done,
      // Label 1488: @34773
      GIM_Try, /*On fail goto*//*Label 1489*/ 34792, // Rule ID 46630 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i32:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46630,
        GIR_Done,
      // Label 1489: @34792
      GIM_Try, /*On fail goto*//*Label 1490*/ 34811, // Rule ID 46665 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f32:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46665,
        GIR_Done,
      // Label 1490: @34811
      GIM_Try, /*On fail goto*//*Label 1491*/ 34830, // Rule ID 46666 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f32:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46666,
        GIR_Done,
      // Label 1491: @34830
      GIM_Reject,
    // Label 1487: @34831
    GIM_Reject,
    // Label 1369: @34832
    GIM_Try, /*On fail goto*//*Label 1492*/ 34918,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1493*/ 34860, // Rule ID 46645 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i64:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46645,
        GIR_Done,
      // Label 1493: @34860
      GIM_Try, /*On fail goto*//*Label 1494*/ 34879, // Rule ID 46646 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i64:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46646,
        GIR_Done,
      // Label 1494: @34879
      GIM_Try, /*On fail goto*//*Label 1495*/ 34898, // Rule ID 46681 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f64:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46681,
        GIR_Done,
      // Label 1495: @34898
      GIM_Try, /*On fail goto*//*Label 1496*/ 34917, // Rule ID 46682 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f64:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46682,
        GIR_Done,
      // Label 1496: @34917
      GIM_Reject,
    // Label 1492: @34918
    GIM_Reject,
    // Label 1370: @34919
    GIM_Try, /*On fail goto*//*Label 1497*/ 35005,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1498*/ 34966, // Rule ID 46697 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i1:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B16 VR:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46697,
        GIR_Done,
      // Label 1498: @34966
      GIM_Try, /*On fail goto*//*Label 1499*/ 35004, // Rule ID 46698 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i1:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B16 VR:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46698,
        GIR_Done,
      // Label 1499: @35004
      GIM_Reject,
    // Label 1497: @35005
    GIM_Reject,
    // Label 1371: @35006
    GIM_Try, /*On fail goto*//*Label 1500*/ 35054,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1501*/ 35034, // Rule ID 46601 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i8:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46601,
        GIR_Done,
      // Label 1501: @35034
      GIM_Try, /*On fail goto*//*Label 1502*/ 35053, // Rule ID 46602 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i8:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46602,
        GIR_Done,
      // Label 1502: @35053
      GIM_Reject,
    // Label 1500: @35054
    GIM_Reject,
    // Label 1372: @35055
    GIM_Try, /*On fail goto*//*Label 1503*/ 35141,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1504*/ 35083, // Rule ID 46617 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i16:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46617,
        GIR_Done,
      // Label 1504: @35083
      GIM_Try, /*On fail goto*//*Label 1505*/ 35102, // Rule ID 46618 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i16:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46618,
        GIR_Done,
      // Label 1505: @35102
      GIM_Try, /*On fail goto*//*Label 1506*/ 35121, // Rule ID 46653 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f16:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46653,
        GIR_Done,
      // Label 1506: @35121
      GIM_Try, /*On fail goto*//*Label 1507*/ 35140, // Rule ID 46654 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f16:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46654,
        GIR_Done,
      // Label 1507: @35140
      GIM_Reject,
    // Label 1503: @35141
    GIM_Reject,
    // Label 1373: @35142
    GIM_Try, /*On fail goto*//*Label 1508*/ 35228,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1509*/ 35170, // Rule ID 46633 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i32:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46633,
        GIR_Done,
      // Label 1509: @35170
      GIM_Try, /*On fail goto*//*Label 1510*/ 35189, // Rule ID 46634 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i32:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46634,
        GIR_Done,
      // Label 1510: @35189
      GIM_Try, /*On fail goto*//*Label 1511*/ 35208, // Rule ID 46669 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f32:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46669,
        GIR_Done,
      // Label 1511: @35208
      GIM_Try, /*On fail goto*//*Label 1512*/ 35227, // Rule ID 46670 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f32:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46670,
        GIR_Done,
      // Label 1512: @35227
      GIM_Reject,
    // Label 1508: @35228
    GIM_Reject,
    // Label 1374: @35229
    GIM_Try, /*On fail goto*//*Label 1513*/ 35315,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1514*/ 35276, // Rule ID 46701 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i1:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B32 VR:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46701,
        GIR_Done,
      // Label 1514: @35276
      GIM_Try, /*On fail goto*//*Label 1515*/ 35314, // Rule ID 46702 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i1:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B32 VR:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46702,
        GIR_Done,
      // Label 1515: @35314
      GIM_Reject,
    // Label 1513: @35315
    GIM_Reject,
    // Label 1375: @35316
    GIM_Try, /*On fail goto*//*Label 1516*/ 35364,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1517*/ 35344, // Rule ID 46605 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i8:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46605,
        GIR_Done,
      // Label 1517: @35344
      GIM_Try, /*On fail goto*//*Label 1518*/ 35363, // Rule ID 46606 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i8:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46606,
        GIR_Done,
      // Label 1518: @35363
      GIM_Reject,
    // Label 1516: @35364
    GIM_Reject,
    // Label 1376: @35365
    GIM_Try, /*On fail goto*//*Label 1519*/ 35451,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1520*/ 35393, // Rule ID 46621 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i16:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46621,
        GIR_Done,
      // Label 1520: @35393
      GIM_Try, /*On fail goto*//*Label 1521*/ 35412, // Rule ID 46622 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i16:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46622,
        GIR_Done,
      // Label 1521: @35412
      GIM_Try, /*On fail goto*//*Label 1522*/ 35431, // Rule ID 46657 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32f16:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46657,
        GIR_Done,
      // Label 1522: @35431
      GIM_Try, /*On fail goto*//*Label 1523*/ 35450, // Rule ID 46658 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32f16:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46658,
        GIR_Done,
      // Label 1523: @35450
      GIM_Reject,
    // Label 1519: @35451
    GIM_Reject,
    // Label 1377: @35452
    GIM_Try, /*On fail goto*//*Label 1524*/ 35538,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1525*/ 35499, // Rule ID 46705 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i1:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B64 VR:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46705,
        GIR_Done,
      // Label 1525: @35499
      GIM_Try, /*On fail goto*//*Label 1526*/ 35537, // Rule ID 46706 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i1:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B64 VR:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46706,
        GIR_Done,
      // Label 1526: @35537
      GIM_Reject,
    // Label 1524: @35538
    GIM_Reject,
    // Label 1378: @35539
    GIM_Try, /*On fail goto*//*Label 1527*/ 35587,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1528*/ 35567, // Rule ID 46609 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46609,
        GIR_Done,
      // Label 1528: @35567
      GIM_Try, /*On fail goto*//*Label 1529*/ 35586, // Rule ID 46610 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46610,
        GIR_Done,
      // Label 1529: @35586
      GIM_Reject,
    // Label 1527: @35587
    GIM_Reject,
    // Label 1379: @35588
    GIM_Reject,
    // Label 14: @35589
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1532*/ 37001,
    /*GILLT_s32*//*Label 1530*/ 35597,
    /*GILLT_s64*//*Label 1531*/ 36299,
    // Label 1530: @35597
    GIM_Try, /*On fail goto*//*Label 1533*/ 36298,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1534*/ 35676, // Rule ID 56263 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56263,
        GIR_Done,
      // Label 1534: @35676
      GIM_Try, /*On fail goto*//*Label 1535*/ 35745, // Rule ID 56265 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56265,
        GIR_Done,
      // Label 1535: @35745
      GIM_Try, /*On fail goto*//*Label 1536*/ 35814, // Rule ID 56267 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56267,
        GIR_Done,
      // Label 1536: @35814
      GIM_Try, /*On fail goto*//*Label 1537*/ 35883, // Rule ID 56269 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56269,
        GIR_Done,
      // Label 1537: @35883
      GIM_Try, /*On fail goto*//*Label 1538*/ 35952, // Rule ID 56271 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56271,
        GIR_Done,
      // Label 1538: @35952
      GIM_Try, /*On fail goto*//*Label 1539*/ 36021, // Rule ID 56384 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56384,
        GIR_Done,
      // Label 1539: @36021
      GIM_Try, /*On fail goto*//*Label 1540*/ 36090, // Rule ID 56386 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56386,
        GIR_Done,
      // Label 1540: @36090
      GIM_Try, /*On fail goto*//*Label 1541*/ 36159, // Rule ID 56388 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56388,
        GIR_Done,
      // Label 1541: @36159
      GIM_Try, /*On fail goto*//*Label 1542*/ 36228, // Rule ID 56390 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56390,
        GIR_Done,
      // Label 1542: @36228
      GIM_Try, /*On fail goto*//*Label 1543*/ 36297, // Rule ID 56392 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56392,
        GIR_Done,
      // Label 1543: @36297
      GIM_Reject,
    // Label 1533: @36298
    GIM_Reject,
    // Label 1531: @36299
    GIM_Try, /*On fail goto*//*Label 1544*/ 37000,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1545*/ 36378, // Rule ID 56262 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56262,
        GIR_Done,
      // Label 1545: @36378
      GIM_Try, /*On fail goto*//*Label 1546*/ 36447, // Rule ID 56264 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56264,
        GIR_Done,
      // Label 1546: @36447
      GIM_Try, /*On fail goto*//*Label 1547*/ 36516, // Rule ID 56266 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56266,
        GIR_Done,
      // Label 1547: @36516
      GIM_Try, /*On fail goto*//*Label 1548*/ 36585, // Rule ID 56268 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56268,
        GIR_Done,
      // Label 1548: @36585
      GIM_Try, /*On fail goto*//*Label 1549*/ 36654, // Rule ID 56270 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56270,
        GIR_Done,
      // Label 1549: @36654
      GIM_Try, /*On fail goto*//*Label 1550*/ 36723, // Rule ID 56383 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56383,
        GIR_Done,
      // Label 1550: @36723
      GIM_Try, /*On fail goto*//*Label 1551*/ 36792, // Rule ID 56385 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56385,
        GIR_Done,
      // Label 1551: @36792
      GIM_Try, /*On fail goto*//*Label 1552*/ 36861, // Rule ID 56387 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56387,
        GIR_Done,
      // Label 1552: @36861
      GIM_Try, /*On fail goto*//*Label 1553*/ 36930, // Rule ID 56389 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56389,
        GIR_Done,
      // Label 1553: @36930
      GIM_Try, /*On fail goto*//*Label 1554*/ 36999, // Rule ID 56391 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56391,
        GIR_Done,
      // Label 1554: @36999
      GIM_Reject,
    // Label 1544: @37000
    GIM_Reject,
    // Label 1532: @37001
    GIM_Reject,
    // Label 15: @37002
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1557*/ 37706,
    /*GILLT_s32*//*Label 1555*/ 37010,
    /*GILLT_s64*//*Label 1556*/ 37358,
    // Label 1555: @37010
    GIM_Try, /*On fail goto*//*Label 1558*/ 37357,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1559*/ 37050, // Rule ID 56145 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (AMOSWAP_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56145,
        GIR_Done,
      // Label 1559: @37050
      GIM_Try, /*On fail goto*//*Label 1560*/ 37084, // Rule ID 56147 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_3