/**************************************************************************
** This file is part of LiteIDE
**
** Copyright (c) 2011-2019 LiteIDE. All rights reserved.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** In addition, as a special exception,  that plugins developed for LiteIDE,
** are allowed to remain closed sourced and can be distributed under any license .
** These rights are included in the file LGPL_EXCEPTION.txt in this package.
**
**************************************************************************/
// Module: toolmainwindow.cpp
// Creator: visualfc <visualfc@gmail.com>

#include "toolmainwindow.h"
#include <QDebug>
//lite_memory_check_begin
#if defined(WIN32) && defined(_MSC_VER) &&  defined(_DEBUG)
     #define _CRTDBG_MAP_ALLOC
     #include <stdlib.h>
     #include <crtdbg.h>
     #define DEBUG_NEW new( _NORMAL_BLOCK, __FILE__, __LINE__ )
     #define new DEBUG_NEW
#endif
//lite_memory_check_end

ToolMainWindow::ToolMainWindow(QWidget *parent)
    : QMainWindow(parent), m_windowStyle(0)
{

}

ToolMainWindow::~ToolMainWindow()
{
    if (m_windowStyle) {
        delete m_windowStyle;
    }
}

void ToolMainWindow::setWindowStyle(IWindowStyle *style)
{
    m_windowStyle = style;
}

void ToolMainWindow::createToolWindowMenu()
{
    m_windowStyle->createToolWindowMenu();
}

QAction *ToolMainWindow::findToolWindow(QWidget *widget)
{
    return m_windowStyle->findToolWindow(widget);
}

QByteArray ToolMainWindow::saveState(int version) const
{
    m_windowStyle->saveToolState();
    return QMainWindow::saveState(version);
}

bool ToolMainWindow::restoreState(const QByteArray &state, int version)
{
    bool b = QMainWindow::restoreState(state,version);
    m_windowStyle->restoreToolsState();
    return b;
}

void ToolMainWindow::updateConer()
{
    m_windowStyle->updateConer();
}

void ToolMainWindow::removeToolWindow(QAction *action)
{
    m_windowStyle->removeToolWindow(action);
}

QAction *ToolMainWindow::addToolWindow(LiteApi::IApplication *app, Qt::DockWidgetArea area, QWidget *widget, const QString &id, const QString &title, bool split, QList<QAction*> widgetActions, QList<QWidget *> widgetList)
{
    return m_windowStyle->addToolWindow(app,area,widget,id,title,split,widgetActions,widgetList);
}

void ToolMainWindow::moveToolWindow(Qt::DockWidgetArea from, Qt::DockWidgetArea to, QAction *action, bool split)
{
    m_windowStyle->moveToolWindow(from,to,action,split);
}

void ToolMainWindow::showOrHideToolWindow()
{
    m_windowStyle->showOrHideToolWindow();
}

void ToolMainWindow::hideOutputWindow()
{
    m_windowStyle->hideOutputWindow();
}

void ToolMainWindow::hideAllToolWindows()
{
    m_windowStyle->hideAllToolWindows();
}
