/* candidate.c generated by valac 0.56.17, the Vala compiler
 * generated from candidate.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SKK_CANDIDATE_0_PROPERTY,
	SKK_CANDIDATE_MIDASI_PROPERTY,
	SKK_CANDIDATE_OKURI_PROPERTY,
	SKK_CANDIDATE_TEXT_PROPERTY,
	SKK_CANDIDATE_ANNOTATION_PROPERTY,
	SKK_CANDIDATE_OUTPUT_PROPERTY,
	SKK_CANDIDATE_NUM_PROPERTIES
};
static GParamSpec* skk_candidate_properties[SKK_CANDIDATE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SkkCandidatePrivate {
	gchar* _midasi;
	gboolean _okuri;
	gchar* _text;
	gchar* _annotation;
	gchar* _output;
};

static gint SkkCandidate_private_offset;
static gpointer skk_candidate_parent_class = NULL;

static void skk_candidate_set_midasi (SkkCandidate* self,
                               const gchar* value);
static void skk_candidate_set_okuri (SkkCandidate* self,
                              gboolean value);
static void skk_candidate_finalize (GObject * obj);
static GType skk_candidate_get_type_once (void);
static void _vala_skk_candidate_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_skk_candidate_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_candidate_get_instance_private (SkkCandidate* self)
{
	return G_STRUCT_MEMBER_P (self, SkkCandidate_private_offset);
}

/**
         * Convert the candidate to string.
         * @return a string representing the candidate
         */
gchar*
skk_candidate_to_string (SkkCandidate* self)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_annotation;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->_text;
		_tmp2_ = g_strconcat (_tmp1_, ";", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_annotation;
		_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp3_);
		result = _tmp6_;
		return result;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->_text;
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		return result;
	}
}

/**
         * Create a new Candidate.
         *
         * @param midasi midasi (index) word which generate the candidate
         * @param okuri whether the candidate is a result of okuri-ari conversion
         * @param text base string value of the candidate
         * @param annotation optional annotation text to the candidate
         * @param output optional output text used instead of text
         *
         * @return a new SkkCandidate
         */
SkkCandidate*
skk_candidate_construct (GType object_type,
                         const gchar* midasi,
                         gboolean okuri,
                         const gchar* text,
                         const gchar* annotation,
                         const gchar* output)
{
	SkkCandidate * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (midasi != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (SkkCandidate*) g_object_new (object_type, NULL);
	skk_candidate_set_midasi (self, midasi);
	skk_candidate_set_okuri (self, okuri);
	skk_candidate_set_text (self, text);
	skk_candidate_set_annotation (self, annotation);
	if (output == NULL) {
		_tmp0_ = text;
	} else {
		_tmp0_ = output;
	}
	skk_candidate_set_output (self, _tmp0_);
	return self;
}

SkkCandidate*
skk_candidate_new (const gchar* midasi,
                   gboolean okuri,
                   const gchar* text,
                   const gchar* annotation,
                   const gchar* output)
{
	return skk_candidate_construct (SKK_TYPE_CANDIDATE, midasi, okuri, text, annotation, output);
}

const gchar*
skk_candidate_get_midasi (SkkCandidate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_midasi;
	result = _tmp0_;
	return result;
}

static void
skk_candidate_set_midasi (SkkCandidate* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_candidate_get_midasi (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_midasi);
		self->priv->_midasi = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_candidate_properties[SKK_CANDIDATE_MIDASI_PROPERTY]);
	}
}

gboolean
skk_candidate_get_okuri (SkkCandidate* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_okuri;
	return result;
}

static void
skk_candidate_set_okuri (SkkCandidate* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_candidate_get_okuri (self);
	if (old_value != value) {
		self->priv->_okuri = value;
		g_object_notify_by_pspec ((GObject *) self, skk_candidate_properties[SKK_CANDIDATE_OKURI_PROPERTY]);
	}
}

const gchar*
skk_candidate_get_text (SkkCandidate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
skk_candidate_set_text (SkkCandidate* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_candidate_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_candidate_properties[SKK_CANDIDATE_TEXT_PROPERTY]);
	}
}

const gchar*
skk_candidate_get_annotation (SkkCandidate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_annotation;
	result = _tmp0_;
	return result;
}

void
skk_candidate_set_annotation (SkkCandidate* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_candidate_get_annotation (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_annotation);
		self->priv->_annotation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_candidate_properties[SKK_CANDIDATE_ANNOTATION_PROPERTY]);
	}
}

const gchar*
skk_candidate_get_output (SkkCandidate* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_output;
	result = _tmp0_;
	return result;
}

void
skk_candidate_set_output (SkkCandidate* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = skk_candidate_get_output (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_output);
		self->priv->_output = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_candidate_properties[SKK_CANDIDATE_OUTPUT_PROPERTY]);
	}
}

static void
skk_candidate_class_init (SkkCandidateClass * klass,
                          gpointer klass_data)
{
	skk_candidate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkCandidate_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_candidate_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_candidate_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_candidate_finalize;
	/**
	         * Midasi word which generated this candidate.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_MIDASI_PROPERTY, skk_candidate_properties[SKK_CANDIDATE_MIDASI_PROPERTY] = g_param_spec_string ("midasi", "midasi", "midasi", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Flag to indicate whether this candidate is generated as a
	         * result of okuri-ari conversion.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_OKURI_PROPERTY, skk_candidate_properties[SKK_CANDIDATE_OKURI_PROPERTY] = g_param_spec_boolean ("okuri", "okuri", "okuri", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Base string value of the candidate.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_TEXT_PROPERTY, skk_candidate_properties[SKK_CANDIDATE_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Optional annotation text associated with the candidate.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_ANNOTATION_PROPERTY, skk_candidate_properties[SKK_CANDIDATE_ANNOTATION_PROPERTY] = g_param_spec_string ("annotation", "annotation", "annotation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Output string shown instead of text.
	         *
	         * This is particularly useful to display a candidate of
	         * numeric conversion.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CANDIDATE_OUTPUT_PROPERTY, skk_candidate_properties[SKK_CANDIDATE_OUTPUT_PROPERTY] = g_param_spec_string ("output", "output", "output", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
skk_candidate_instance_init (SkkCandidate * self,
                             gpointer klass)
{
	self->priv = skk_candidate_get_instance_private (self);
}

static void
skk_candidate_finalize (GObject * obj)
{
	SkkCandidate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_CANDIDATE, SkkCandidate);
	_g_free0 (self->priv->_midasi);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_annotation);
	_g_free0 (self->priv->_output);
	G_OBJECT_CLASS (skk_candidate_parent_class)->finalize (obj);
}

/**
     * Object representing a candidate in dictionaries.
     */
static GType
skk_candidate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkCandidateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_candidate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkCandidate), 0, (GInstanceInitFunc) skk_candidate_instance_init, NULL };
	GType skk_candidate_type_id;
	skk_candidate_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkCandidate", &g_define_type_info, 0);
	SkkCandidate_private_offset = g_type_add_instance_private (skk_candidate_type_id, sizeof (SkkCandidatePrivate));
	return skk_candidate_type_id;
}

GType
skk_candidate_get_type (void)
{
	static volatile gsize skk_candidate_type_id__once = 0;
	if (g_once_init_enter (&skk_candidate_type_id__once)) {
		GType skk_candidate_type_id;
		skk_candidate_type_id = skk_candidate_get_type_once ();
		g_once_init_leave (&skk_candidate_type_id__once, skk_candidate_type_id);
	}
	return skk_candidate_type_id__once;
}

static void
_vala_skk_candidate_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkCandidate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CANDIDATE, SkkCandidate);
	switch (property_id) {
		case SKK_CANDIDATE_MIDASI_PROPERTY:
		g_value_set_string (value, skk_candidate_get_midasi (self));
		break;
		case SKK_CANDIDATE_OKURI_PROPERTY:
		g_value_set_boolean (value, skk_candidate_get_okuri (self));
		break;
		case SKK_CANDIDATE_TEXT_PROPERTY:
		g_value_set_string (value, skk_candidate_get_text (self));
		break;
		case SKK_CANDIDATE_ANNOTATION_PROPERTY:
		g_value_set_string (value, skk_candidate_get_annotation (self));
		break;
		case SKK_CANDIDATE_OUTPUT_PROPERTY:
		g_value_set_string (value, skk_candidate_get_output (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_candidate_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SkkCandidate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CANDIDATE, SkkCandidate);
	switch (property_id) {
		case SKK_CANDIDATE_MIDASI_PROPERTY:
		skk_candidate_set_midasi (self, g_value_get_string (value));
		break;
		case SKK_CANDIDATE_OKURI_PROPERTY:
		skk_candidate_set_okuri (self, g_value_get_boolean (value));
		break;
		case SKK_CANDIDATE_TEXT_PROPERTY:
		skk_candidate_set_text (self, g_value_get_string (value));
		break;
		case SKK_CANDIDATE_ANNOTATION_PROPERTY:
		skk_candidate_set_annotation (self, g_value_get_string (value));
		break;
		case SKK_CANDIDATE_OUTPUT_PROPERTY:
		skk_candidate_set_output (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

