#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x006e";
static constexpr OUStringLiteral langDefaultName = u"\x0045\x006e\x0067\x006c\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x004d\x0059";
static constexpr OUStringLiteral countryDefaultName = u"\x004d\x0061\x006c\x0061\x0079\x0073\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_en_MY(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_en_MY(sal_Int16& count)
{
	return getLocaleItem_en_GB(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x52, 0x4d, 0x2d, 0x34, 0x34, 0x30, 0x39, 0x5d, 0x0};
extern OUString const * getAllFormats0_en_GB(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_en_MY(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_en_GB(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_en_MY(sal_Int16& count)
{
	return getDateAcceptancePatterns_en_GB(count);
}
extern const OUString *  getCollatorImplementation_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_en_MY(sal_Int16& count)
{
	return getCollatorImplementation_en_GB(count);
}
extern const OUString *  getCollationOptions_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_en_MY(sal_Int16& count)
{
	return getCollationOptions_en_GB(count);
}
extern const OUString *  getSearchOptions_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_en_MY(sal_Int16& count)
{
	return getSearchOptions_en_GB(count);
}
extern const OUString *  getIndexAlgorithm_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_en_MY(sal_Int16& count)
{
	return getIndexAlgorithm_en_GB(count);
}
extern const OUString *  getUnicodeScripts_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_en_MY(sal_Int16& count)
{
	return getUnicodeScripts_en_GB(count);
}
extern const OUString *  getFollowPageWords_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_en_MY(sal_Int16& count)
{
	return getFollowPageWords_en_GB(count);
}
extern const OUString *  getAllCalendars_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_en_MY(sal_Int16& count)
{
	return getAllCalendars_en_GB(count);
}
extern const OUString *  getAllCurrencies_ms_MY(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_en_MY(sal_Int16& count)
{
	return getAllCurrencies_ms_MY(count);
}
extern const OUString *  getTransliterations_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_en_MY(sal_Int16& count)
{
	return getTransliterations_en_GB(count);
}
extern const OUString *  getForbiddenCharacters_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_en_MY(sal_Int16& count)
{
	return getForbiddenCharacters_en_GB(count);
}
extern const OUString *  getBreakIteratorRules_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_en_MY(sal_Int16& count)
{
	return getBreakIteratorRules_en_GB(count);
}
extern const OUString *  getReservedWords_en_GB(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_en_MY(sal_Int16& count)
{
	return getReservedWords_en_GB(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_GB(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_en_MY(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_GB(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_GB(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_en_MY(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_GB(nStyles, nLevels, nAttributes);
}
} // extern "C"

