
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcharselect_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QList>
#include <qbytearray.h>
#include <qchar.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCharSelect_Type = nullptr;
static PyTypeObject *Sbk_KCharSelect_TypeF(void)
{
    return _Sbk_KCharSelect_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KCharSelectWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KCharSelectWrapper::KCharSelectWrapper(::QWidget * parent, ::QObject * actionParent, const ::QFlags<KCharSelect::Control> controls) : KCharSelect(parent, actionParent, controls)
{
}

KCharSelectWrapper::KCharSelectWrapper(::QWidget * parent, const ::QFlags<KCharSelect::Control> controls) : KCharSelect(parent, controls)
{
}

void KCharSelectWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCharSelect", funcName, gil, pyOverride, signal);
}

void KCharSelectWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KCharSelect", funcName, gil, pyOverride, event);
}

int KCharSelectWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KCharSelect", funcName, gil, pyOverride);
}

void KCharSelectWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCharSelect", funcName, gil, pyOverride, signal);
}

void KCharSelectWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KCharSelect", funcName, gil, pyOverride, event);
}

bool KCharSelectWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KCharSelect", funcName, gil, pyOverride, event);
}

bool KCharSelectWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KCharSelect", funcName, gil, pyOverride, watched, event);
}

void KCharSelectWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KCharSelect", funcName, gil, pyOverride, event);
}

bool KCharSelectWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KCharSelect", funcName, gil, pyOverride, next);
}

void KCharSelectWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KCharSelect", funcName, gil, pyOverride, event);
}

bool KCharSelectWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KCharSelect", funcName, gil, pyOverride);
}

int KCharSelectWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KCharSelect", funcName, gil, pyOverride, arg__1);
}

void KCharSelectWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KCharSelect", funcName, gil, pyOverride, painter);
}

void KCharSelectWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KCharSelect", funcName, gil, pyOverride, event);
}

::QVariant KCharSelectWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KCharSelect", funcName, gil, pyOverride, arg__1);
}

void KCharSelectWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KCharSelect", funcName, gil, pyOverride, event);
}

int KCharSelectWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KCharSelect", funcName, gil, pyOverride, arg__1);
}

::QSize KCharSelectWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCharSelect", funcName, gil, pyOverride);
}

void KCharSelectWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KCharSelect", funcName, gil, pyOverride, event);
}

bool KCharSelectWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KCharSelect", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KCharSelectWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KCharSelect", funcName, gil, pyOverride);
}

void KCharSelectWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KCharSelect", funcName, gil, pyOverride, event);
}

::QPaintDevice * KCharSelectWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KCharSelect", funcName, gil, pyOverride, offset);
}

void KCharSelectWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KCharSelect", funcName, gil, pyOverride, visible);
}

::QPainter * KCharSelectWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KCharSelect", funcName, gil, pyOverride);
}

void KCharSelectWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KCharSelect", funcName, gil, pyOverride, event);
}

::QSize KCharSelectWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCharSelect::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCharSelect", funcName, gil, pyOverride);
}

void KCharSelectWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KCharSelect", funcName, gil, pyOverride, event);
}

void KCharSelectWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCharSelect_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KCharSelect", funcName, gil, pyOverride, event);
}

const QMetaObject *KCharSelectWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KCharSelect::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KCharSelectWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KCharSelect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KCharSelectWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KCharSelectWrapper *>(this));
    }
    return KCharSelect::qt_metacast(_clname);
}

KCharSelectWrapper::~KCharSelectWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KCharSelect_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCharSelect_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCharSelect >()))
        return -1;

    KCharSelectWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KCharSelect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCharSelect::KCharSelect(QWidget*,QObject*,QFlags<KCharSelect::Control>=)
    // 1: KCharSelect::KCharSelect(QWidget*,QFlags<KCharSelect::Control>=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KCharSelect(QWidget*,QFlags<KCharSelect::Control>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KCharSelect_Control_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 1; // KCharSelect(QWidget*,QFlags<KCharSelect::Control>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KCharSelect(QWidget*,QObject*,QFlags<KCharSelect::Control>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KCharSelect_Control_IDX])))->flagsConverter, (pyArgs[2])))) {
                overloadId = 0; // KCharSelect(QWidget*,QObject*,QFlags<KCharSelect::Control>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KCharSelect(QWidget *parent, QObject *actionParent, const QFlags<KCharSelect::Control> controls)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"controls", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KCharSelect_Control_IDX])))->flagsConverter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<KCharSelect::Control> cppArg2(KCharSelect::Control::AllGuiElements);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KCharSelect(QWidget*,QObject*,QFlags<KCharSelect::Control>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KCharSelectWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KCharSelectWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 1: // KCharSelect(QWidget *parent, const QFlags<KCharSelect::Control> controls)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"controls", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KCharSelect_Control_IDX])))->flagsConverter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<KCharSelect::Control> cppArg1(KCharSelect::Control::AllGuiElements);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KCharSelect(QWidget*,QFlags<KCharSelect::Control>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KCharSelectWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KCharSelectWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KCharSelect >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KCharSelectFunc_allPlanesEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allPlanesEnabled()const
        bool cppResult = const_cast<const ::KCharSelect *>(cppSelf)->allPlanesEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_currentChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentChar()const
        QChar cppResult = const_cast<const ::KCharSelect *>(cppSelf)->currentChar();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_currentCodePoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentCodePoint()const
        uint cppResult = const_cast<const ::KCharSelect *>(cppSelf)->currentCodePoint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_currentFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentFont()const
        QFont cppResult = const_cast<const ::KCharSelect *>(cppSelf)->currentFont();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_displayedChars(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // displayedChars()const
        QList<QChar> cppResult = const_cast<const ::KCharSelect *>(cppSelf)->displayedChars();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QChar_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_displayedCodePoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // displayedCodePoints()const
        QList<uint> cppResult = const_cast<const ::KCharSelect *>(cppSelf)->displayedCodePoints();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_uint_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCharSelectFunc_setAllPlanesEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCharSelect::setAllPlanesEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllPlanesEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAllPlanesEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAllPlanesEnabled(bool)
            cppSelf->setAllPlanesEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCharSelectFunc_setCurrentChar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCharSelect::setCurrentChar(QChar)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArg)))) {
        overloadId = 0; // setCurrentChar(QChar)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentChar", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);

    // Call function/method
    {
        ::QChar cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentChar(QChar)
            cppSelf->setCurrentChar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCharSelectFunc_setCurrentCodePoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCharSelect::setCurrentCodePoint(uint)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setCurrentCodePoint(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentCodePoint", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentCodePoint(uint)
            cppSelf->setCurrentCodePoint(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCharSelectFunc_setCurrentFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCharSelect::setCurrentFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentFont(QFont)
            cppSelf->setCurrentFont(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCharSelectFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCharSelect *>(cppSelf)->::KCharSelect::sizeHint()
            : const_cast<const ::KCharSelect *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KCharSelect_PropertyStrings[] = {
    "allPlanesEnabled::",
    "currentChar::",
    "currentCodePoint::",
    "currentFont::",
    "displayedChars:",
    "displayedCodePoints:",
    nullptr // Sentinel
};

static const char *Sbk_KCharSelect_EnumFlagInfo[] = {
    "Control:IntFlag:Controls",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCharSelect_methods[] = {
    {"allPlanesEnabled", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_allPlanesEnabled), METH_NOARGS, nullptr},
    {"currentChar", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_currentChar), METH_NOARGS, nullptr},
    {"currentCodePoint", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_currentCodePoint), METH_NOARGS, nullptr},
    {"currentFont", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_currentFont), METH_NOARGS, nullptr},
    {"displayedChars", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_displayedChars), METH_NOARGS, nullptr},
    {"displayedCodePoints", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_displayedCodePoints), METH_NOARGS, nullptr},
    {"setAllPlanesEnabled", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_setAllPlanesEnabled), METH_O, nullptr},
    {"setCurrentChar", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_setCurrentChar), METH_O, nullptr},
    {"setCurrentCodePoint", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_setCurrentCodePoint), METH_O, nullptr},
    {"setCurrentFont", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_setCurrentFont), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KCharSelectFunc_sizeHint), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KCharSelect_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KCharSelect *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KCharSelectWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KCharSelect_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCharSelect_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KCharSelectSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KCharSelect *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCharSelect_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KCharSelect_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCharSelect_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCharSelect_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCharSelect_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCharSelect_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCharSelect_spec = {
    "1:KWidgetsAddons.KCharSelect",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCharSelect_slots
};

} //extern "C"

static void *Sbk_KCharSelect_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KCharSelect *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KCharSelect *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KCharSelect *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KCharSelect_Control(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KCharSelect::Control>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KCharSelect::Control *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KCharSelect_Control_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_Control_IDX])))
        return Enum_PythonToCpp_KCharSelect_Control;
    return {};
}

static PyObject *KCharSelect_Control_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KCharSelect::Control>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KCharSelect::Control *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KCharSelect_Control(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KCharSelect::Control>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KCharSelect::Control> *>(cppOut) = value;

}

static PyObject *KCharSelect_Control_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KCharSelect::Control> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_Control_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCharSelect_PythonToCpp_KCharSelect_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCharSelect_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCharSelect_PythonToCpp_KCharSelect_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCharSelect_TypeF()))
        return KCharSelect_PythonToCpp_KCharSelect_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCharSelect_PTR_CppToPython_KCharSelect(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KCharSelect *>(const_cast<void *>(cppIn)), Sbk_KCharSelect_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCharSelect_SignatureStrings[] = {
    "1:KWidgetsAddons.KCharSelect(self,parent:PySide6.QtWidgets.QWidget,actionParent:PySide6.QtCore.QObject,controls:KWidgetsAddons.KCharSelect.Control=KCharSelect.Control.AllGuiElements,*:KeywordOnly=None,currentFont:QFont=None,currentChar:QChar=None,currentCodePoint:uint=None,displayedChars:QList[QChar]=None,displayedCodePoints:QList[uint]=None,allPlanesEnabled:bool=None)",
    "0:KWidgetsAddons.KCharSelect(self,parent:PySide6.QtWidgets.QWidget,controls:KWidgetsAddons.KCharSelect.Control=KCharSelect.Control.AllGuiElements,*:KeywordOnly=None,currentFont:QFont=None,currentChar:QChar=None,currentCodePoint:uint=None,displayedChars:QList[QChar]=None,displayedCodePoints:QList[uint]=None,allPlanesEnabled:bool=None)",
    "KWidgetsAddons.KCharSelect.allPlanesEnabled(self)->bool",
    "KWidgetsAddons.KCharSelect.currentChar(self)->QChar",
    "KWidgetsAddons.KCharSelect.currentCodePoint(self)->uint",
    "KWidgetsAddons.KCharSelect.currentFont(self)->PySide6.QtGui.QFont",
    "KWidgetsAddons.KCharSelect.displayedChars(self)->QList[QChar]",
    "KWidgetsAddons.KCharSelect.displayedCodePoints(self)->QList[uint]",
    "KWidgetsAddons.KCharSelect.setAllPlanesEnabled(self,all:bool)",
    "KWidgetsAddons.KCharSelect.setCurrentChar(self,c:QChar)",
    "KWidgetsAddons.KCharSelect.setCurrentCodePoint(self,codePoint:uint)",
    "KWidgetsAddons.KCharSelect.setCurrentFont(self,font:typing.Union[PySide6.QtGui.QFont, QString, QStringList])",
    "KWidgetsAddons.KCharSelect.sizeHint(self)->PySide6.QtCore.QSize",
    nullptr}; // Sentinel
#else
static constexpr size_t KCharSelect_SignatureByteSize = 359;
static constexpr uint8_t KCharSelect_SignatureBytes[359] = {
    0x78, 0xda, 0xed, 0x94, 0x41, 0x4b, 0xc3, 0x30, 0x18, 0x86, 0xef, 0xfb, 0x15, 0x1e, 0x9d, 0xc4,
    0xa0, 0x17, 0x0f, 0x81, 0x09, 0xa3, 0x4c, 0x85, 0x89, 0x6b, 0x28, 0xe2, 0x61, 0xec, 0x90, 0x35,
    0xdf, 0x66, 0x24, 0x26, 0x23, 0xc9, 0x90, 0xfa, 0xeb, 0x4d, 0xda, 0xa5, 0xb6, 0xa5, 0x74, 0x05,
    0xaf, 0x5e, 0x4a, 0x48, 0xde, 0xe7, 0x4d, 0xbe, 0xf7, 0x4b, 0x73, 0x4b, 0x96, 0x6f, 0x82, 0xef,
    0xc1, 0xd9, 0x39, 0xe7, 0x5a, 0x59, 0xbc, 0x4c, 0xde, 0x99, 0xc9, 0x40, 0x42, 0xee, 0x2e, 0x2d,
    0xc8, 0x1d, 0x3a, 0x30, 0x03, 0xca, 0x91, 0xb4, 0xc8, 0x04, 0x87, 0x3b, 0x4c, 0xdd, 0x49, 0x8f,
    0x69, 0x35, 0x40, 0x2c, 0x77, 0x42, 0xab, 0xb4, 0x2b, 0x4b, 0xb4, 0x01, 0x4c, 0x57, 0xdb, 0x0f,
    0xef, 0x84, 0x72, 0xad, 0x9c, 0xd1, 0xd2, 0x0e, 0xec, 0x86, 0x93, 0x4a, 0x33, 0xeb, 0x99, 0xc3,
    0x73, 0x29, 0x1f, 0x8f, 0x62, 0x21, 0xe1, 0xd3, 0x6f, 0x62, 0xd1, 0x15, 0x59, 0x42, 0xf1, 0xa5,
    0x0d, 0x5f, 0x29, 0x59, 0xcc, 0x5e, 0xb4, 0x02, 0x94, 0x1f, 0x4d, 0x38, 0xc0, 0x83, 0x07, 0x08,
    0x0d, 0xdf, 0xd6, 0x74, 0xb0, 0x24, 0x34, 0x7c, 0xdb, 0xd3, 0x9a, 0x43, 0xaa, 0x85, 0x47, 0x8e,
    0x22, 0x12, 0x5c, 0xd8, 0x83, 0x64, 0x05, 0xf0, 0xa0, 0xb6, 0x84, 0x3e, 0x0b, 0xeb, 0xd6, 0x25,
    0xba, 0xe9, 0x0a, 0x22, 0x1d, 0x55, 0xc1, 0xe4, 0x24, 0x62, 0x52, 0xa6, 0x92, 0x29, 0xb0, 0x0b,
    0xc5, 0xb6, 0x12, 0x38, 0xd9, 0x6a, 0x5f, 0x5a, 0x58, 0x9a, 0x4e, 0x6e, 0xfe, 0x9e, 0xf9, 0x7f,
    0x9e, 0x8d, 0x3c, 0x07, 0x32, 0xe8, 0x62, 0x65, 0xbc, 0xd3, 0xeb, 0xfb, 0x40, 0x0f, 0x71, 0x8d,
    0x32, 0x23, 0x52, 0x1e, 0x79, 0x0c, 0x13, 0xab, 0x88, 0x60, 0xa8, 0x62, 0x04, 0x17, 0x32, 0x8e,
    0xc8, 0x6f, 0xe3, 0x7d, 0x97, 0x70, 0x19, 0xff, 0x90, 0x43, 0x3b, 0xe2, 0xfa, 0xc0, 0x8d, 0xa4,
    0xc7, 0xd1, 0x75, 0xfe, 0x6d, 0x8b, 0xb2, 0x0d, 0x43, 0x0e, 0x16, 0xdc, 0xbc, 0x2f, 0xe8, 0xd0,
    0xb5, 0xb2, 0x51, 0xd3, 0x33, 0x74, 0xd2, 0x89, 0x1b, 0xe5, 0xd5, 0xe5, 0x1a, 0xcb, 0xb5, 0x22,
    0xf7, 0x3f, 0x47, 0xf3, 0x16, 0x8e, 0xf4, 0xa8, 0xe3, 0x47, 0xbb, 0x70, 0xe5, 0x5d, 0x71, 0x10,
    0x6a, 0x8f, 0x5f, 0x95, 0x7f, 0xda, 0xd6, 0x3d, 0xed, 0x40, 0x17, 0x34, 0x73, 0xc6, 0x4b, 0xea,
    0x41, 0x88, 0x6a, 0x33, 0xbc, 0x99, 0xf8, 0x86, 0x27, 0xd1, 0xd7, 0xe5, 0xea, 0xad, 0xcc, 0xfc,
    0xfa, 0xe4, 0x07, 0x40, 0x16, 0x0e, 0x88
};
#endif

PyTypeObject *init_KCharSelect(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX].type;

    Shiboken::AutoDecRef Sbk_KCharSelect_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KCharSelect_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCharSelect",
        "KCharSelect*",
        &Sbk_KCharSelect_spec,
        &Shiboken::callCppDestructor< KCharSelect >,
        Sbk_KCharSelect_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KCharSelect_Type; // references _Sbk_KCharSelect_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCharSelect_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCharSelect_SignatureBytes, KCharSelect_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCharSelect_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCharSelect_PythonToCpp_KCharSelect_PTR,
        is_KCharSelect_PythonToCpp_KCharSelect_PTR_Convertible,
        KCharSelect_PTR_CppToPython_KCharSelect);

    Shiboken::Conversions::registerConverterName(converter, "KCharSelect");
    Shiboken::Conversions::registerConverterName(converter, "KCharSelect*");
    Shiboken::Conversions::registerConverterName(converter, "KCharSelect&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCharSelect).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KCharSelectWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KCharSelect_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KCharSelect_TypeF(), &Sbk_KCharSelectSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KCharSelect_TypeF(), &Sbk_KCharSelect_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KCharSelect_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Control'.
    const char *Control_Initializer[] = {
        "SearchLine",
        "FontCombo",
        "FontSize",
        "BlockCombos",
        "CharacterTable",
        "DetailBrowser",
        "HistoryButtons",
        "AllGuiElements",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Control_InitializerValues[] = {
        uint16_t(KCharSelect::Control::SearchLine),     //  0x0001  1
        uint16_t(KCharSelect::Control::FontCombo),      //  0x0002  2
        uint16_t(KCharSelect::Control::FontSize),       //  0x0004  4
        uint16_t(KCharSelect::Control::BlockCombos),    //  0x0008  8
        uint16_t(KCharSelect::Control::CharacterTable), //  0x0010  16
        uint16_t(KCharSelect::Control::DetailBrowser),  //  0x0020  32
        uint16_t(KCharSelect::Control::HistoryButtons), //  0x0040  64
        uint16_t(KCharSelect::Control::AllGuiElements)  //  0xffff  65535
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KCharSelect_TypeF(),
        "1:KWidgetsAddons.KCharSelect.Control",
        Control_Initializer, Control_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_Control_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KCharSelect_Control_IDX].type =
        EType;
    // Register converter for enum 'KCharSelect::Control'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KCharSelect_Control_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KCharSelect_Control,
            is_Enum_PythonToCpp_KCharSelect_Control_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KCharSelect::Control");
        Shiboken::Conversions::registerConverterAlias(converter, "Control");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KCharSelect_Control_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KCharSelect_Control,
            is_Enum_PythonToCpp_KCharSelect_Control_Convertible);
        // Register converter for flag 'QFlags<KCharSelect::Control>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KCharSelect::Control>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KCharSelect::Controls");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Control' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KCharSelect::staticMetaObject);
    qRegisterMetaType< ::KCharSelect::Control >("KCharSelect::Control");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KCharSelect::staticMetaObject, sizeof(KCharSelectWrapper));

    return pyType;
}
