
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kunitconversion_python.h"

// main header
#include "kunitconversion_converter_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <converter.h>
#include <unit.h>
#include <unitcategory.h>
#include <value.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KUnitConversion;

extern "C" {
static PyTypeObject *_Sbk_KUnitConversion_Converter_Type = nullptr;
static PyTypeObject *Sbk_KUnitConversion_Converter_TypeF(void)
{
    return _Sbk_KUnitConversion_Converter_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUnitConversion_Converter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUnitConversion::Converter >()))
        return -1;

    ::KUnitConversion::Converter *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Converter", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Converter::Converter()
    // 1: Converter::Converter(KUnitConversion::Converter)
    if (numArgs == 0) {
        overloadId = 0; // Converter()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Converter(KUnitConversion::Converter)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Converter()
        {

            // Converter()
            cptr = new ::KUnitConversion::Converter();
            break;
        }
        case 1: // Converter(const KUnitConversion::Converter &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUnitConversion::Converter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Converter(KUnitConversion::Converter)
                cptr = new ::KUnitConversion::Converter(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUnitConversion::Converter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUnitConversion_ConverterFunc_categories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Converter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // categories()const
        QList<KUnitConversion::UnitCategory> cppResult = const_cast<const ::KUnitConversion::Converter *>(cppSelf)->categories();
        pyResult = Shiboken::Conversions::copyToPython(SbkKUnitConversionTypeConverters[SBK_KUnitConversion_QList_KUnitConversion_UnitCategory_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ConverterFunc_category(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Converter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Converter::category(KUnitConversion::CategoryId)const->KUnitConversion::UnitCategory
    // 1: Converter::category(QString)const->KUnitConversion::UnitCategory
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 1; // category(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_CategoryId_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // category(KUnitConversion::CategoryId)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "category", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // category(KUnitConversion::CategoryId categoryId) const
        {
            ::KUnitConversion::CategoryId cppArg0{KUnitConversion::LengthCategory};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // category(KUnitConversion::CategoryId)const
                KUnitConversion::UnitCategory* cppResult = new KUnitConversion::UnitCategory(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->category(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // category(const QString &category) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // category(QString)const
                KUnitConversion::UnitCategory* cppResult = new KUnitConversion::UnitCategory(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->category(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ConverterFunc_categoryForUnit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Converter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Converter::categoryForUnit(QString)const->KUnitConversion::UnitCategory
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // categoryForUnit(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "categoryForUnit", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // categoryForUnit(QString)const
            KUnitConversion::UnitCategory* cppResult = new KUnitConversion::UnitCategory(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->categoryForUnit(cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ConverterFunc_convert(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Converter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    if (PyArg_ParseTuple(args, "|OO:convert", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Converter::convert(KUnitConversion::Value,KUnitConversion::UnitId)const->KUnitConversion::Value
    // 1: Converter::convert(KUnitConversion::Value,KUnitConversion::Unit)const->KUnitConversion::Value
    // 2: Converter::convert(KUnitConversion::Value,const QString&=)const->KUnitConversion::Value
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // convert(KUnitConversion::Value,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 2; // convert(KUnitConversion::Value,QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArgs[1])))) {
            overloadId = 1; // convert(KUnitConversion::Value,KUnitConversion::Unit)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // convert(KUnitConversion::Value,KUnitConversion::UnitId)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // convert(const KUnitConversion::Value &value, KUnitConversion::UnitId toUnit) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KUnitConversion::UnitId cppArg1{KUnitConversion::NoUnit};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,KUnitConversion::UnitId)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->convert(*cppArg0, cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // convert(const KUnitConversion::Value &value, const KUnitConversion::Unit &toUnit) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::KUnitConversion::Unit *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,KUnitConversion::Unit)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->convert(*cppArg0, *cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 2: // convert(const KUnitConversion::Value &value, const QString &toUnit) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"toUnit", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,QString)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->convert(*cppArg0, cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ConverterFunc_unit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Converter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Converter::unit(KUnitConversion::UnitId)const->KUnitConversion::Unit
    // 1: Converter::unit(QString)const->KUnitConversion::Unit
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 1; // unit(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // unit(KUnitConversion::UnitId)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unit", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // unit(KUnitConversion::UnitId unitId) const
        {
            ::KUnitConversion::UnitId cppArg0{KUnitConversion::NoUnit};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // unit(KUnitConversion::UnitId)const
                KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->unit(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // unit(const QString &unitString) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // unit(QString)const
                KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::Converter *>(cppSelf)->unit(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUnitConversion_Converter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUnitConversion_Converter_methods[] = {
    {"categories", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ConverterFunc_categories), METH_NOARGS, nullptr},
    {"category", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ConverterFunc_category), METH_O, nullptr},
    {"categoryForUnit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ConverterFunc_categoryForUnit), METH_O, nullptr},
    {"convert", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ConverterFunc_convert), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"unit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ConverterFunc_unit), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KUnitConversion_Converter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUnitConversion_Converter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUnitConversion_Converter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUnitConversion_Converter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUnitConversion_Converter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUnitConversion_Converter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUnitConversion_Converter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUnitConversion_Converter_spec = {
    "1:KUnitConversion.KUnitConversion.Converter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUnitConversion_Converter_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Converter_PythonToCpp_Converter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUnitConversion_Converter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Converter_PythonToCpp_Converter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUnitConversion_Converter_TypeF()))
        return Converter_PythonToCpp_Converter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Converter_PTR_CppToPython_Converter(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUnitConversion_Converter_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUnitConversion_Converter_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUnitConversion_Converter_SignatureStrings[] = {
    "1:KUnitConversion.KUnitConversion.Converter(self)",
    "0:KUnitConversion.KUnitConversion.Converter(self,other:KUnitConversion.KUnitConversion.Converter)",
    "KUnitConversion.KUnitConversion.Converter.categories(self)->QList[KUnitConversion.KUnitConversion.UnitCategory]",
    "1:KUnitConversion.KUnitConversion.Converter.category(self,categoryId:KUnitConversion.KUnitConversion.CategoryId)->KUnitConversion.KUnitConversion.UnitCategory",
    "0:KUnitConversion.KUnitConversion.Converter.category(self,category:QString)->KUnitConversion.KUnitConversion.UnitCategory",
    "KUnitConversion.KUnitConversion.Converter.categoryForUnit(self,unit:QString)->KUnitConversion.KUnitConversion.UnitCategory",
    "2:KUnitConversion.KUnitConversion.Converter.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:KUnitConversion.KUnitConversion.UnitId)->KUnitConversion.KUnitConversion.Value",
    "1:KUnitConversion.KUnitConversion.Converter.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:KUnitConversion.KUnitConversion.Unit)->KUnitConversion.KUnitConversion.Value",
    "0:KUnitConversion.KUnitConversion.Converter.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:QString=QString())->KUnitConversion.KUnitConversion.Value",
    "1:KUnitConversion.KUnitConversion.Converter.unit(self,unitId:KUnitConversion.KUnitConversion.UnitId)->KUnitConversion.KUnitConversion.Unit",
    "0:KUnitConversion.KUnitConversion.Converter.unit(self,unitString:QString)->KUnitConversion.KUnitConversion.Unit",
    nullptr}; // Sentinel
#else
static constexpr size_t KUnitConversion_Converter_SignatureByteSize = 213;
static constexpr uint8_t KUnitConversion_Converter_SignatureBytes[213] = {
    0x78, 0xda, 0x33, 0xb4, 0xf2, 0x0e, 0xcd, 0xcb, 0x2c, 0x71, 0xce, 0xcf, 0x2b, 0x4b, 0x2d, 0x2a,
    0xce, 0xcc, 0xcf, 0xd3, 0x43, 0xe7, 0x43, 0x98, 0x25, 0xa9, 0x45, 0x1a, 0xc5, 0xa9, 0x39, 0x69,
    0x9a, 0x5c, 0x06, 0x24, 0xea, 0xd0, 0xc9, 0x2f, 0xc9, 0x48, 0x2d, 0x22, 0x5e, 0x93, 0x26, 0x17,
    0xd1, 0x4a, 0xf5, 0x92, 0x13, 0x4b, 0x52, 0xd3, 0xf3, 0x8b, 0x32, 0x53, 0x8b, 0x21, 0x8e, 0xd3,
    0xb5, 0x0b, 0xf4, 0xc9, 0x2c, 0x2e, 0x89, 0x26, 0x64, 0x02, 0x98, 0x0b, 0xd1, 0x5b, 0x19, 0xcb,
    0x65, 0x68, 0x45, 0xb2, 0x8d, 0x95, 0x10, 0xaf, 0xc1, 0x78, 0x9e, 0x29, 0x84, 0x8d, 0x80, 0x2b,
    0x05, 0xba, 0x92, 0x14, 0xf7, 0x91, 0x12, 0xe0, 0x38, 0x9c, 0x67, 0x15, 0x18, 0x5c, 0x52, 0x94,
    0x99, 0x97, 0x4e, 0xaa, 0xcd, 0xa4, 0xdb, 0xeb, 0x96, 0x5f, 0x04, 0x52, 0x03, 0xb1, 0xbe, 0x14,
    0xc8, 0x22, 0xd7, 0x6a, 0x23, 0x52, 0x3c, 0x0d, 0x61, 0x41, 0x2c, 0x2d, 0x4b, 0xcc, 0x29, 0x4d,
    0x25, 0xa8, 0x39, 0x0c, 0xa4, 0x4a, 0xa7, 0x24, 0x1f, 0x24, 0x6c, 0x45, 0x8c, 0xc3, 0x88, 0x8a,
    0x36, 0xb0, 0xa9, 0xa4, 0x25, 0x27, 0x3a, 0x38, 0x9d, 0x68, 0x87, 0x1b, 0xd0, 0xd1, 0xe1, 0xd0,
    0x64, 0x61, 0x0b, 0xa5, 0x35, 0x34, 0x69, 0x12, 0xbc, 0xa5, 0x28, 0x69, 0x91, 0x88, 0x5c, 0x4a,
    0x74, 0x54, 0x83, 0xb8, 0x24, 0x05, 0x18, 0xaa, 0x53, 0x20, 0xbe, 0x26, 0x31, 0x73, 0x70, 0x01,
    0x00, 0x4c, 0xe9, 0x29, 0xe6
};
#endif

PyTypeObject *init_KUnitConversion_Converter(PyObject *enclosingClass)
{
    if (SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX].type != nullptr)
        return SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX].type;

    Shiboken::AutoDecRef Sbk_KUnitConversion_Converter_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUnitConversion_Converter_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Converter",
        "KUnitConversion::Converter*",
        &Sbk_KUnitConversion_Converter_spec,
        &Shiboken::callCppDestructor< ::KUnitConversion::Converter >,
        Sbk_KUnitConversion_Converter_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass);
    auto *pyType = Sbk_KUnitConversion_Converter_TypeF(); // references _Sbk_KUnitConversion_Converter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUnitConversion_Converter_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUnitConversion_Converter_SignatureBytes, KUnitConversion_Converter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUnitConversion_Converter_PropertyStrings);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Converter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Converter_PythonToCpp_Converter_PTR,
        is_Converter_PythonToCpp_Converter_PTR_Convertible,
        Converter_PTR_CppToPython_Converter);

    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Converter");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Converter*");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Converter&");
    Shiboken::Conversions::registerConverterAlias(converter, "Converter");
    Shiboken::Conversions::registerConverterAlias(converter, "Converter*");
    Shiboken::Conversions::registerConverterAlias(converter, "Converter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUnitConversion::Converter).name());

    qRegisterMetaType< ::KUnitConversion::Converter *>();

    return pyType;
}
