#ifndef itkImageSeriesReaderSwigInterface_h
#define itkImageSeriesReaderSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageSeriesReader.h"

using itkImageSeriesReaderIUC2 = itk::ImageSeriesReader< itk::Image< unsigned char,2 > >;
using itkImageSeriesReaderIUC2_Pointer = itk::ImageSeriesReader< itk::Image< unsigned char,2 > >::Pointer;
using itkImageSeriesReaderIUC3 = itk::ImageSeriesReader< itk::Image< unsigned char,3 > >;
using itkImageSeriesReaderIUC3_Pointer = itk::ImageSeriesReader< itk::Image< unsigned char,3 > >::Pointer;
using itkImageSeriesReaderIUC4 = itk::ImageSeriesReader< itk::Image< unsigned char,4 > >;
using itkImageSeriesReaderIUC4_Pointer = itk::ImageSeriesReader< itk::Image< unsigned char,4 > >::Pointer;
using itkImageSeriesReaderIUI2 = itk::ImageSeriesReader< itk::Image< unsigned int,2 > >;
using itkImageSeriesReaderIUI2_Pointer = itk::ImageSeriesReader< itk::Image< unsigned int,2 > >::Pointer;
using itkImageSeriesReaderIUI3 = itk::ImageSeriesReader< itk::Image< unsigned int,3 > >;
using itkImageSeriesReaderIUI3_Pointer = itk::ImageSeriesReader< itk::Image< unsigned int,3 > >::Pointer;
using itkImageSeriesReaderIUI4 = itk::ImageSeriesReader< itk::Image< unsigned int,4 > >;
using itkImageSeriesReaderIUI4_Pointer = itk::ImageSeriesReader< itk::Image< unsigned int,4 > >::Pointer;
using itkImageSeriesReaderISI2 = itk::ImageSeriesReader< itk::Image< signed int,2 > >;
using itkImageSeriesReaderISI2_Pointer = itk::ImageSeriesReader< itk::Image< signed int,2 > >::Pointer;
using itkImageSeriesReaderISI3 = itk::ImageSeriesReader< itk::Image< signed int,3 > >;
using itkImageSeriesReaderISI3_Pointer = itk::ImageSeriesReader< itk::Image< signed int,3 > >::Pointer;
using itkImageSeriesReaderISI4 = itk::ImageSeriesReader< itk::Image< signed int,4 > >;
using itkImageSeriesReaderISI4_Pointer = itk::ImageSeriesReader< itk::Image< signed int,4 > >::Pointer;
using itkImageSeriesReaderIRGBUC2 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageSeriesReaderIRGBUC2_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageSeriesReaderIRGBUC3 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageSeriesReaderIRGBUC3_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageSeriesReaderIRGBUC4 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageSeriesReaderIRGBUC4_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageSeriesReaderIRGBUS2 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageSeriesReaderIRGBUS2_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageSeriesReaderIRGBUS3 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageSeriesReaderIRGBUS3_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageSeriesReaderIRGBUS4 = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageSeriesReaderIRGBUS4_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageSeriesReaderIRGBAUC2 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageSeriesReaderIRGBAUC2_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageSeriesReaderIRGBAUC3 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageSeriesReaderIRGBAUC3_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageSeriesReaderIRGBAUC4 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageSeriesReaderIRGBAUC4_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageSeriesReaderIRGBAUS2 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageSeriesReaderIRGBAUS2_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageSeriesReaderIRGBAUS3 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageSeriesReaderIRGBAUS3_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageSeriesReaderIRGBAUS4 = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageSeriesReaderIRGBAUS4_Pointer = itk::ImageSeriesReader< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageSeriesReaderIVD22 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageSeriesReaderIVD22_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageSeriesReaderIVD23 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageSeriesReaderIVD23_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageSeriesReaderIVD24 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageSeriesReaderIVD24_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageSeriesReaderIVD32 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageSeriesReaderIVD32_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageSeriesReaderIVD33 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageSeriesReaderIVD33_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageSeriesReaderIVD34 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageSeriesReaderIVD34_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageSeriesReaderIVD42 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageSeriesReaderIVD42_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageSeriesReaderIVD43 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageSeriesReaderIVD43_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageSeriesReaderIVD44 = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageSeriesReaderIVD44_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageSeriesReaderIVF22 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageSeriesReaderIVF22_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageSeriesReaderIVF23 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageSeriesReaderIVF23_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageSeriesReaderIVF24 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageSeriesReaderIVF24_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageSeriesReaderIVF32 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageSeriesReaderIVF32_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageSeriesReaderIVF33 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageSeriesReaderIVF33_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageSeriesReaderIVF34 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageSeriesReaderIVF34_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageSeriesReaderIVF42 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageSeriesReaderIVF42_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageSeriesReaderIVF43 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageSeriesReaderIVF43_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageSeriesReaderIVF44 = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageSeriesReaderIVF44_Pointer = itk::ImageSeriesReader< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageSeriesReaderICVD22 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageSeriesReaderICVD22_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageSeriesReaderICVD23 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageSeriesReaderICVD23_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageSeriesReaderICVD24 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageSeriesReaderICVD24_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageSeriesReaderICVD32 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageSeriesReaderICVD32_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageSeriesReaderICVD33 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageSeriesReaderICVD33_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageSeriesReaderICVD34 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageSeriesReaderICVD34_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageSeriesReaderICVD42 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageSeriesReaderICVD42_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageSeriesReaderICVD43 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageSeriesReaderICVD43_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageSeriesReaderICVD44 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageSeriesReaderICVD44_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageSeriesReaderICVF22 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageSeriesReaderICVF22_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageSeriesReaderICVF23 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageSeriesReaderICVF23_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageSeriesReaderICVF24 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageSeriesReaderICVF24_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageSeriesReaderICVF32 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageSeriesReaderICVF32_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageSeriesReaderICVF33 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageSeriesReaderICVF33_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageSeriesReaderICVF34 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageSeriesReaderICVF34_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageSeriesReaderICVF42 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageSeriesReaderICVF42_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageSeriesReaderICVF43 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageSeriesReaderICVF43_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageSeriesReaderICVF44 = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageSeriesReaderICVF44_Pointer = itk::ImageSeriesReader< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageSeriesReaderISC2 = itk::ImageSeriesReader< itk::Image< signed char,2 > >;
using itkImageSeriesReaderISC2_Pointer = itk::ImageSeriesReader< itk::Image< signed char,2 > >::Pointer;
using itkImageSeriesReaderISC3 = itk::ImageSeriesReader< itk::Image< signed char,3 > >;
using itkImageSeriesReaderISC3_Pointer = itk::ImageSeriesReader< itk::Image< signed char,3 > >::Pointer;
using itkImageSeriesReaderISC4 = itk::ImageSeriesReader< itk::Image< signed char,4 > >;
using itkImageSeriesReaderISC4_Pointer = itk::ImageSeriesReader< itk::Image< signed char,4 > >::Pointer;
using itkImageSeriesReaderISS2 = itk::ImageSeriesReader< itk::Image< signed short,2 > >;
using itkImageSeriesReaderISS2_Pointer = itk::ImageSeriesReader< itk::Image< signed short,2 > >::Pointer;
using itkImageSeriesReaderISS3 = itk::ImageSeriesReader< itk::Image< signed short,3 > >;
using itkImageSeriesReaderISS3_Pointer = itk::ImageSeriesReader< itk::Image< signed short,3 > >::Pointer;
using itkImageSeriesReaderISS4 = itk::ImageSeriesReader< itk::Image< signed short,4 > >;
using itkImageSeriesReaderISS4_Pointer = itk::ImageSeriesReader< itk::Image< signed short,4 > >::Pointer;
using itkImageSeriesReaderIULL2 = itk::ImageSeriesReader< itk::Image< unsigned long long,2 > >;
using itkImageSeriesReaderIULL2_Pointer = itk::ImageSeriesReader< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageSeriesReaderIULL3 = itk::ImageSeriesReader< itk::Image< unsigned long long,3 > >;
using itkImageSeriesReaderIULL3_Pointer = itk::ImageSeriesReader< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageSeriesReaderIULL4 = itk::ImageSeriesReader< itk::Image< unsigned long long,4 > >;
using itkImageSeriesReaderIULL4_Pointer = itk::ImageSeriesReader< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageSeriesReaderIUS2 = itk::ImageSeriesReader< itk::Image< unsigned short,2 > >;
using itkImageSeriesReaderIUS2_Pointer = itk::ImageSeriesReader< itk::Image< unsigned short,2 > >::Pointer;
using itkImageSeriesReaderIUS3 = itk::ImageSeriesReader< itk::Image< unsigned short,3 > >;
using itkImageSeriesReaderIUS3_Pointer = itk::ImageSeriesReader< itk::Image< unsigned short,3 > >::Pointer;
using itkImageSeriesReaderIUS4 = itk::ImageSeriesReader< itk::Image< unsigned short,4 > >;
using itkImageSeriesReaderIUS4_Pointer = itk::ImageSeriesReader< itk::Image< unsigned short,4 > >::Pointer;
using itkImageSeriesReaderIF2 = itk::ImageSeriesReader< itk::Image< float,2 > >;
using itkImageSeriesReaderIF2_Pointer = itk::ImageSeriesReader< itk::Image< float,2 > >::Pointer;
using itkImageSeriesReaderIF3 = itk::ImageSeriesReader< itk::Image< float,3 > >;
using itkImageSeriesReaderIF3_Pointer = itk::ImageSeriesReader< itk::Image< float,3 > >::Pointer;
using itkImageSeriesReaderIF4 = itk::ImageSeriesReader< itk::Image< float,4 > >;
using itkImageSeriesReaderIF4_Pointer = itk::ImageSeriesReader< itk::Image< float,4 > >::Pointer;
using itkImageSeriesReaderID2 = itk::ImageSeriesReader< itk::Image< double,2 > >;
using itkImageSeriesReaderID2_Pointer = itk::ImageSeriesReader< itk::Image< double,2 > >::Pointer;
using itkImageSeriesReaderID3 = itk::ImageSeriesReader< itk::Image< double,3 > >;
using itkImageSeriesReaderID3_Pointer = itk::ImageSeriesReader< itk::Image< double,3 > >::Pointer;
using itkImageSeriesReaderID4 = itk::ImageSeriesReader< itk::Image< double,4 > >;
using itkImageSeriesReaderID4_Pointer = itk::ImageSeriesReader< itk::Image< double,4 > >::Pointer;
using itkImageSeriesReaderICD2 = itk::ImageSeriesReader< itk::Image< std::complex< double >,2 > >;
using itkImageSeriesReaderICD2_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< double >,2 > >::Pointer;
using itkImageSeriesReaderICD3 = itk::ImageSeriesReader< itk::Image< std::complex< double >,3 > >;
using itkImageSeriesReaderICD3_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< double >,3 > >::Pointer;
using itkImageSeriesReaderICD4 = itk::ImageSeriesReader< itk::Image< std::complex< double >,4 > >;
using itkImageSeriesReaderICD4_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< double >,4 > >::Pointer;
using itkImageSeriesReaderICF2 = itk::ImageSeriesReader< itk::Image< std::complex< float >,2 > >;
using itkImageSeriesReaderICF2_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< float >,2 > >::Pointer;
using itkImageSeriesReaderICF3 = itk::ImageSeriesReader< itk::Image< std::complex< float >,3 > >;
using itkImageSeriesReaderICF3_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< float >,3 > >::Pointer;
using itkImageSeriesReaderICF4 = itk::ImageSeriesReader< itk::Image< std::complex< float >,4 > >;
using itkImageSeriesReaderICF4_Pointer = itk::ImageSeriesReader< itk::Image< std::complex< float >,4 > >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSeriesReaderSwigInterface.h"
#include "itkImageFileReaderSwigInterface.h"
#include "itkImageSourceSwigInterface.h"
#include "ITKIOImageBaseBaseSwigInterface.h"
#endif
