/* game.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2010-2013 Robert Ancell
   Copyright 2013-2014 Michael Catanzaro
   Copyright 2014-2019 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	MAIN_LINE_TOP,
	MAIN_LINE_LEFT,
	MAIN_LINE_RIGHT,
	MAIN_LINE_BOTTOM,
	MAIN_LINE_TOPLEFT,
	MAIN_LINE_TOPRIGHT
} MainLine;

#define TYPE_MAIN_LINE (main_line_get_type ())

#define TYPE_GAME_STATE_STRUCT (game_state_struct_get_type ())
typedef struct _GameStateStruct GameStateStruct;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_POSSIBLE_MOVE (possible_move_get_type ())
typedef struct _PossibleMove PossibleMove;

#define TYPE_GAME_STATE_OBJECT (game_state_object_get_type ())
#define GAME_STATE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_STATE_OBJECT, GameStateObject))
#define GAME_STATE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_STATE_OBJECT, GameStateObjectClass))
#define IS_GAME_STATE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_STATE_OBJECT))
#define IS_GAME_STATE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_STATE_OBJECT))
#define GAME_STATE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_STATE_OBJECT, GameStateObjectClass))

typedef struct _GameStateObject GameStateObject;
typedef struct _GameStateObjectClass GameStateObjectClass;
typedef struct _GameStateObjectPrivate GameStateObjectPrivate;
enum  {
	GAME_STATE_OBJECT_0_PROPERTY,
	GAME_STATE_OBJECT_GAME_STATE_STRUCT_PROPERTY,
	GAME_STATE_OBJECT_CURRENT_COLOR_PROPERTY,
	GAME_STATE_OBJECT_N_LIGHT_TILES_PROPERTY,
	GAME_STATE_OBJECT_N_DARK_TILES_PROPERTY,
	GAME_STATE_OBJECT_CURRENT_PLAYER_CAN_MOVE_PROPERTY,
	GAME_STATE_OBJECT_IS_COMPLETE_PROPERTY,
	GAME_STATE_OBJECT_NUM_PROPERTIES
};
static GParamSpec* game_state_object_properties[GAME_STATE_OBJECT_NUM_PROPERTIES];

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
typedef enum  {
	OPENING_HUMANS,
	OPENING_REVERSI,
	OPENING_INVERTED,
	OPENING_ALTER_TOP,
	OPENING_ALTER_LEFT,
	OPENING_ALTER_RIGHT,
	OPENING_ALTER_BOTTOM
} Opening;

#define TYPE_OPENING (opening_get_type ())
enum  {
	GAME_0_PROPERTY,
	GAME_NUMBER_OF_MOVES_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_REVERSE_PROPERTY,
	GAME_OPENING_PROPERTY,
	GAME_CURRENT_STATE_PROPERTY,
	GAME_INITIAL_NUMBER_OF_TILES_PROPERTY,
	GAME_PRINT_LOGS_PROPERTY,
	GAME_IS_COMPLETE_PROPERTY,
	GAME_N_LIGHT_TILES_PROPERTY,
	GAME_N_DARK_TILES_PROPERTY,
	GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY,
	GAME_CURRENT_COLOR_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GAME_TURN_ENDED_SIGNAL,
	GAME_COMPLETENESS_UPDATED_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GameStateStruct {
	Player current_color;
	Player opponent_color;
	guint8 size;
	guint8 n_current_tiles;
	guint8 n_opponent_tiles;
	guint8 n_tiles;
	gboolean current_player_can_move;
	gboolean is_complete;
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	guint8* neighbor_tiles;
	gint neighbor_tiles_length1;
	gint neighbor_tiles_length2;
	guint8 x_saved;
	guint8 y_saved;
	guint8* empty_neighbors;
	gint empty_neighbors_length1;
	gint empty_neighbors_length2;
};

struct _PossibleMove {
	guint8 x;
	guint8 y;
	guint8 n_tiles;
	guint8 n_tiles_n;
	guint8 n_tiles_ne;
	guint8 n_tiles_e;
	guint8 n_tiles_se;
	guint8 n_tiles_s;
	guint8 n_tiles_so;
	guint8 n_tiles_o;
	guint8 n_tiles_no;
};

struct _GameStateObject {
	GObject parent_instance;
	GameStateObjectPrivate * priv;
};

struct _GameStateObjectClass {
	GObjectClass parent_class;
};

struct _GameStateObjectPrivate {
	GameStateStruct _game_state_struct;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	GListStore* undo_stack;
	guint8 _size;
	gboolean _reverse;
	Opening _opening;
	GameStateObject* _current_state;
	guint8 _initial_number_of_tiles;
	gboolean _print_logs;
	guint8* neighbor_tiles;
	gint neighbor_tiles_length1;
	gint neighbor_tiles_length2;
	GSList* possible_moves;
};

static gint GameStateObject_private_offset;
static gpointer game_state_object_parent_class = NULL;
static gint Game_private_offset;
static gpointer game_parent_class = NULL;

VALA_EXTERN GType main_line_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_state_struct_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameStateStruct* game_state_struct_dup (const GameStateStruct* self);
VALA_EXTERN void game_state_struct_free (GameStateStruct* self);
VALA_EXTERN void game_state_struct_copy (const GameStateStruct* self,
                             GameStateStruct* dest);
VALA_EXTERN void game_state_struct_destroy (GameStateStruct* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GameStateStruct, game_state_struct_destroy)
VALA_EXTERN gchar* game_state_struct_to_string (GameStateStruct *self);
VALA_EXTERN gchar* player_to_string (Player self);
VALA_EXTERN void game_state_struct_init_copy_and_pass (GameStateStruct *self,
                                           GameStateStruct* game);
VALA_EXTERN Player player_flip_color (Player p);
static Player* _vala_array_dup6 (Player* self,
                          gssize length);
static guint8* _vala_array_dup7 (guint8* self,
                          gssize length);
VALA_EXTERN GType possible_move_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PossibleMove* possible_move_dup (const PossibleMove* self);
VALA_EXTERN void possible_move_free (PossibleMove* self);
VALA_EXTERN void game_state_struct_init_copy_and_move (GameStateStruct *self,
                                           GameStateStruct* game,
                                           PossibleMove* move);
static Player* _vala_array_dup8 (Player* self,
                          gssize length);
static inline void game_state_struct_flip_tiles (Player** tiles,
                                   gint* tiles_length1,
                                   gint* tiles_length2,
                                   guint8 x,
                                   guint8 y,
                                   Player color,
                                   gint8 x_step,
                                   gint8 y_step,
                                   guint8 count);
static guint8* _vala_array_dup9 (guint8* self,
                          gssize length);
static inline void game_state_struct_update_empty_neighbors (GameStateStruct *self,
                                               guint8 x,
                                               guint8 y);
static void game_state_struct_update_who_can_move (GameStateStruct *self);
VALA_EXTERN void game_state_struct_init_from_grid (GameStateStruct *self,
                                       guint8 _size,
                                       Player* _tiles,
                                       gint _tiles_length1,
                                       gint _tiles_length2,
                                       Player color,
                                       guint8* _neighbor_tiles,
                                       gint _neighbor_tiles_length1,
                                       gint _neighbor_tiles_length2,
                                       gboolean humans_opening);
static Player* _vala_array_dup10 (Player* self,
                           gssize length);
static inline void game_state_struct_add_tile_of_color (GameStateStruct *self,
                                          Player color);
static inline void game_state_struct_init_empty_neighbors (GameStateStruct *self);
VALA_EXTERN void game_state_struct_init_empty (GameStateStruct *self,
                                   guint8 _size,
                                   guint8* _neighbor_tiles,
                                   gint _neighbor_tiles_length1,
                                   gint _neighbor_tiles_length2);
VALA_EXTERN void game_state_struct_init_copy_and_add (GameStateStruct *self,
                                          GameStateStruct* game,
                                          guint8 x,
                                          guint8 y);
static Player* _vala_array_dup11 (Player* self,
                           gssize length);
VALA_EXTERN void game_state_struct_init_copy_and_add_two (GameStateStruct *self,
                                              GameStateStruct* game,
                                              guint8 x1,
                                              guint8 y1,
                                              guint8 x2,
                                              guint8 y2);
static Player* _vala_array_dup12 (Player* self,
                           gssize length);
VALA_EXTERN gboolean game_state_struct_is_current_color (GameStateStruct *self,
                                             guint8 x,
                                             guint8 y);
VALA_EXTERN gboolean game_state_struct_is_empty_tile (GameStateStruct *self,
                                          guint8 x,
                                          guint8 y);
static inline gboolean game_state_struct_is_valid_location_signed (GameStateStruct *self,
                                                     gint8 x,
                                                     gint8 y);
static inline gboolean game_state_struct_is_unplayable_basic (GameStateStruct *self,
                                                guint8 x,
                                                guint8 y);
static inline gboolean game_state_struct_can_place (GameStateStruct *self,
                                      guint8 x,
                                      guint8 y,
                                      Player color);
VALA_EXTERN void game_state_struct_get_possible_moves (GameStateStruct *self,
                                           GSList** moves);
static void _possible_move_free0_ (gpointer var);
static inline void _g_slist_free__possible_move_free0_ (GSList* self);
static inline gboolean game_state_struct_place_tile (GameStateStruct *self,
                                       guint8 x,
                                       guint8 y,
                                       Player color,
                                       PossibleMove* move);
VALA_EXTERN gboolean game_state_struct_test_placing_tile (GameStateStruct *self,
                                              guint8 x,
                                              guint8 y,
                                              PossibleMove* move);
VALA_EXTERN void possible_move_init (PossibleMove *self,
                         guint8 x,
                         guint8 y);
static inline guint8 game_state_struct_can_flip_tiles (GameStateStruct *self,
                                         guint8 x,
                                         guint8 y,
                                         Player color,
                                         gint8 x_step,
                                         gint8 y_step);
VALA_EXTERN guint8 game_state_struct_get_empty_neighbors (GameStateStruct *self,
                                              guint8 x,
                                              guint8 y);
static inline guint8 game_state_struct_is_empty (GameStateStruct *self,
                                   gint8 x,
                                   gint8 y);
VALA_EXTERN Player* game_state_struct_get_mainline (GameStateStruct *self,
                                        MainLine mainline_id,
                                        gint* result_length1);
static Player* _vala_array_dup13 (Player* self,
                           gssize length);
static guint8* _vala_array_dup14 (guint8* self,
                           gssize length);
VALA_EXTERN GType game_state_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameStateObject, g_object_unref)
VALA_EXTERN gchar* game_state_object_to_string (GameStateObject* self);
VALA_EXTERN void game_state_object_get_game_state_struct (GameStateObject* self,
                                              GameStateStruct * result);
VALA_EXTERN GameStateObject* game_state_object_new_copy_and_pass (GameStateObject* game);
VALA_EXTERN GameStateObject* game_state_object_construct_copy_and_pass (GType object_type,
                                                            GameStateObject* game);
VALA_EXTERN GameStateObject* game_state_object_new_copy_and_move (GameStateObject* game,
                                                      PossibleMove* move);
VALA_EXTERN GameStateObject* game_state_object_construct_copy_and_move (GType object_type,
                                                            GameStateObject* game,
                                                            PossibleMove* move);
VALA_EXTERN GameStateObject* game_state_object_new_from_grid (guint8 size,
                                                  Player* tiles,
                                                  gint tiles_length1,
                                                  gint tiles_length2,
                                                  Player color,
                                                  guint8* neighbor_tiles,
                                                  gint neighbor_tiles_length1,
                                                  gint neighbor_tiles_length2,
                                                  gboolean humans_opening);
VALA_EXTERN GameStateObject* game_state_object_construct_from_grid (GType object_type,
                                                        guint8 size,
                                                        Player* tiles,
                                                        gint tiles_length1,
                                                        gint tiles_length2,
                                                        Player color,
                                                        guint8* neighbor_tiles,
                                                        gint neighbor_tiles_length1,
                                                        gint neighbor_tiles_length2,
                                                        gboolean humans_opening);
VALA_EXTERN GameStateObject* game_state_object_new_empty (guint8 size,
                                              guint8* neighbor_tiles,
                                              gint neighbor_tiles_length1,
                                              gint neighbor_tiles_length2);
VALA_EXTERN GameStateObject* game_state_object_construct_empty (GType object_type,
                                                    guint8 size,
                                                    guint8* neighbor_tiles,
                                                    gint neighbor_tiles_length1,
                                                    gint neighbor_tiles_length2);
VALA_EXTERN GameStateObject* game_state_object_new_copy_and_add (GameStateObject* game,
                                                     guint8 x,
                                                     guint8 y);
VALA_EXTERN GameStateObject* game_state_object_construct_copy_and_add (GType object_type,
                                                           GameStateObject* game,
                                                           guint8 x,
                                                           guint8 y);
VALA_EXTERN GameStateObject* game_state_object_new_copy_and_add_two (GameStateObject* game,
                                                         guint8 x,
                                                         guint8 y,
                                                         guint8 x2,
                                                         guint8 y2);
VALA_EXTERN GameStateObject* game_state_object_construct_copy_and_add_two (GType object_type,
                                                               GameStateObject* game,
                                                               guint8 x,
                                                               guint8 y,
                                                               guint8 x2,
                                                               guint8 y2);
VALA_EXTERN Player game_state_object_get_owner (GameStateObject* self,
                                    guint8 x,
                                    guint8 y);
VALA_EXTERN void game_state_object_get_possible_moves (GameStateObject* self,
                                           GSList** moves);
VALA_EXTERN gboolean game_state_object_test_placing_tile (GameStateObject* self,
                                              guint8 x,
                                              guint8 y,
                                              PossibleMove* move);
VALA_EXTERN GameStateObject* game_state_object_new (void);
VALA_EXTERN GameStateObject* game_state_object_construct (GType object_type);
VALA_EXTERN Player game_state_object_get_current_color (GameStateObject* self);
VALA_EXTERN guint8 game_state_object_get_n_light_tiles (GameStateObject* self);
VALA_EXTERN guint8 game_state_object_get_n_dark_tiles (GameStateObject* self);
VALA_EXTERN gboolean game_state_object_get_current_player_can_move (GameStateObject* self);
VALA_EXTERN gboolean game_state_object_get_is_complete (GameStateObject* self);
static void game_state_object_finalize (GObject * obj);
static GType game_state_object_get_type_once (void);
static void _vala_game_state_object_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType opening_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Game* game_new (gboolean _reverse,
                Opening _opening,
                guint8 _size,
                gboolean _print_logs);
VALA_EXTERN Game* game_construct (GType object_type,
                      gboolean _reverse,
                      Opening _opening,
                      guint8 _size,
                      gboolean _print_logs);
static void game_init_neighbor_tiles (guint8 size,
                               guint8** neighbor_tiles,
                               gint* neighbor_tiles_length1,
                               gint* neighbor_tiles_length2);
static inline void game_setup_even_board (guint8 size,
                            Opening opening,
                            Player** tiles,
                            gint* tiles_length1,
                            gint* tiles_length2,
                            guint8* initial_number_of_tiles);
static inline void game_setup_odd_board (guint8 size,
                           Opening opening,
                           Player** tiles,
                           gint* tiles_length1,
                           gint* tiles_length2,
                           guint8* initial_number_of_tiles);
VALA_EXTERN Game* game_new_from_strings (gchar** setup,
                             gint setup_length1,
                             Player to_move,
                             gboolean _reverse,
                             guint8 _size,
                             gboolean _print_logs);
VALA_EXTERN Game* game_construct_from_strings (GType object_type,
                                   gchar** setup,
                                   gint setup_length1,
                                   Player to_move,
                                   gboolean _reverse,
                                   guint8 _size,
                                   gboolean _print_logs);
VALA_EXTERN Player player_from_char (gchar c);
VALA_EXTERN gchar* game_to_string (Game* self);
VALA_EXTERN Player game_get_owner (Game* self,
                       guint8 x,
                       guint8 y);
VALA_EXTERN GameStateObject* game_get_current_state (Game* self);
VALA_EXTERN gboolean game_place_tile (Game* self,
                          guint8 x,
                          guint8 y);
VALA_EXTERN Opening game_get_opening (Game* self);
static inline gboolean game_humans_opening_place_tile (Game* self,
                                         guint8 x,
                                         guint8 y);
VALA_EXTERN gboolean game_get_print_logs (Game* self);
VALA_EXTERN Player game_get_current_color (Game* self);
VALA_EXTERN void game_set_current_state (Game* self,
                             GameStateObject* value);
static void game_end_of_turn (Game* self,
                       gboolean undoing,
                       gboolean no_draw);
VALA_EXTERN gboolean game_pass (Game* self);
VALA_EXTERN gboolean game_get_current_player_can_move (Game* self);
static inline void game_update_possible_moves (Game* self);
VALA_EXTERN void game_undo (Game* self,
                guint8 count);
VALA_EXTERN guint8 game_get_number_of_moves (Game* self);
VALA_EXTERN guint8* game_copy_neighbor_tiles (Game* self,
                                  gint* result_length1,
                                  gint* result_length2);
static guint8* _vala_array_dup15 (guint8* self,
                           gssize length);
VALA_EXTERN gboolean game_test_placing_tile (Game* self,
                                 guint8 x,
                                 guint8 y,
                                 PossibleMove* move);
static gboolean game_humans_opening_test_placing_tile (Game* self,
                                                guint8 x,
                                                guint8 y);
VALA_EXTERN void game_get_possible_moves (Game* self,
                              GSList** moves);
static PossibleMove* __lambda15_ (Game* self,
                           PossibleMove* a);
static gpointer ___lambda15__gcopy_func (gconstpointer src,
                                  gpointer self);
static inline void game_humans_opening_update_possible_moves (Game* self);
VALA_EXTERN guint8 game_get_size (Game* self);
static inline void game_humans_opening_update_opening_even (Game* self);
VALA_EXTERN guint8 game_get_n_light_tiles (Game* self);
static inline void game_humans_opening_update_opening_odd (Game* self,
                                             guint8 x,
                                             guint8 y);
VALA_EXTERN void game_set_opening (Game* self,
                       Opening value);
static inline gboolean game_humans_opening_test_placing_tile_even (Game* self,
                                                     guint8 x,
                                                     guint8 y);
static inline gboolean game_humans_opening_test_placing_tile_odd (Game* self,
                                                    guint8 x,
                                                    guint8 y);
static inline void game_humans_opening_update_possible_moves_even (Game* self);
static inline void game_humans_opening_update_possible_moves_odd (Game* self);
static void game_set_size (Game* self,
                    guint8 value);
VALA_EXTERN gboolean game_get_reverse (Game* self);
static void game_set_reverse (Game* self,
                       gboolean value);
VALA_EXTERN guint8 game_get_initial_number_of_tiles (Game* self);
static void game_set_initial_number_of_tiles (Game* self,
                                       guint8 value);
static void game_set_print_logs (Game* self,
                          gboolean value);
VALA_EXTERN gboolean game_get_is_complete (Game* self);
VALA_EXTERN guint8 game_get_n_dark_tiles (Game* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static GObject * game_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties);
VALA_EXTERN gchar* opening_to_string (Opening self);
static void game_finalize (GObject * obj);
static GType game_get_type_once (void);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
main_line_get_type_once (void)
{
	static const GEnumValue values[] = {{MAIN_LINE_TOP, "MAIN_LINE_TOP", "top"}, {MAIN_LINE_LEFT, "MAIN_LINE_LEFT", "left"}, {MAIN_LINE_RIGHT, "MAIN_LINE_RIGHT", "right"}, {MAIN_LINE_BOTTOM, "MAIN_LINE_BOTTOM", "bottom"}, {MAIN_LINE_TOPLEFT, "MAIN_LINE_TOPLEFT", "topleft"}, {MAIN_LINE_TOPRIGHT, "MAIN_LINE_TOPRIGHT", "topright"}, {0, NULL, NULL}};
	GType main_line_type_id;
	main_line_type_id = g_enum_register_static ("MainLine", values);
	return main_line_type_id;
}

GType
main_line_get_type (void)
{
	static volatile gsize main_line_type_id__once = 0;
	if (g_once_init_enter (&main_line_type_id__once)) {
		GType main_line_type_id;
		main_line_type_id = main_line_get_type_once ();
		g_once_init_leave (&main_line_type_id__once, main_line_type_id);
	}
	return main_line_type_id__once;
}

gchar*
game_state_struct_to_string (GameStateStruct *self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(y < (*self).size)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							const gchar* _tmp5_;
							Player* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							Player _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(x < (*self).size)) {
								break;
							}
							_tmp5_ = s;
							_tmp6_ = (*self).tiles;
							_tmp6__length1 = (*self).tiles_length1;
							_tmp6__length2 = (*self).tiles_length2;
							_tmp7_ = _tmp6_[(x * _tmp6__length2) + y];
							_tmp8_ = player_to_string (_tmp7_);
							_tmp9_ = _tmp8_;
							_tmp10_ = g_strconcat (" ", _tmp9_, NULL);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_strconcat (_tmp5_, _tmp11_, NULL);
							_g_free0 (s);
							s = _tmp12_;
							_g_free0 (_tmp11_);
							_g_free0 (_tmp9_);
						}
					}
				}
				_tmp13_ = s;
				_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
				_g_free0 (s);
				s = _tmp14_;
			}
		}
	}
	result = s;
	return result;
}

static Player*
_vala_array_dup6 (Player* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

static guint8*
_vala_array_dup7 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
game_state_struct_init_copy_and_pass (GameStateStruct *self,
                                      GameStateStruct* game)
{
	GameStateStruct _tmp0_;
	GameStateStruct _tmp1_;
	GameStateStruct _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	GameStateStruct _tmp4_;
	Player* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	Player* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	GameStateStruct _tmp7_;
	GameStateStruct _tmp8_;
	GameStateStruct _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	g_return_if_fail (game != NULL);
	memset (self, 0, sizeof (GameStateStruct));
	_tmp0_ = *game;
	(*self).opponent_color = _tmp0_.current_color;
	(*self).current_color = player_flip_color ((*self).opponent_color);
	_tmp1_ = *game;
	(*self).size = _tmp1_.size;
	_tmp2_ = *game;
	_tmp3_ = _tmp2_.neighbor_tiles;
	_tmp3__length1 = _tmp2_.neighbor_tiles_length1;
	_tmp3__length2 = _tmp2_.neighbor_tiles_length2;
	(*self).neighbor_tiles = _tmp3_;
	(*self).neighbor_tiles_length1 = _tmp3__length1;
	(*self).neighbor_tiles_length2 = _tmp3__length2;
	_tmp4_ = *game;
	_tmp5_ = _tmp4_.tiles;
	_tmp5__length1 = _tmp4_.tiles_length1;
	_tmp5__length2 = _tmp4_.tiles_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup6 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp6_;
	(*self).tiles_length1 = _tmp6__length1;
	(*self).tiles_length2 = _tmp6__length2;
	_tmp7_ = *game;
	(*self).n_current_tiles = _tmp7_.n_opponent_tiles;
	_tmp8_ = *game;
	(*self).n_opponent_tiles = _tmp8_.n_current_tiles;
	(*self).n_tiles = (*self).n_current_tiles + (*self).n_opponent_tiles;
	_tmp9_ = *game;
	_tmp10_ = _tmp9_.empty_neighbors;
	_tmp10__length1 = _tmp9_.empty_neighbors_length1;
	_tmp10__length2 = _tmp9_.empty_neighbors_length2;
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup7 (_tmp10_, _tmp10__length1 * _tmp10__length2) : _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	_tmp11__length2 = _tmp10__length2;
	(*self).empty_neighbors = (g_free ((*self).empty_neighbors), NULL);
	(*self).empty_neighbors = _tmp11_;
	(*self).empty_neighbors_length1 = _tmp11__length1;
	(*self).empty_neighbors_length2 = _tmp11__length2;
	(*self).current_player_can_move = TRUE;
	(*self).is_complete = FALSE;
	(*self).x_saved = (guint8) 0;
	(*self).y_saved = (guint8) 0;
}

static Player*
_vala_array_dup8 (Player* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

static guint8*
_vala_array_dup9 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
game_state_struct_init_copy_and_move (GameStateStruct *self,
                                      GameStateStruct* game,
                                      PossibleMove* move)
{
	GameStateStruct _tmp0_;
	GameStateStruct _tmp1_;
	GameStateStruct _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	GameStateStruct _tmp4_;
	Player* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	Player* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	PossibleMove _tmp7_;
	PossibleMove _tmp8_;
	PossibleMove _tmp9_;
	PossibleMove _tmp10_;
	PossibleMove _tmp11_;
	PossibleMove _tmp12_;
	PossibleMove _tmp13_;
	PossibleMove _tmp14_;
	PossibleMove _tmp15_;
	PossibleMove _tmp16_;
	PossibleMove _tmp17_;
	PossibleMove _tmp18_;
	PossibleMove _tmp19_;
	PossibleMove _tmp20_;
	PossibleMove _tmp21_;
	PossibleMove _tmp22_;
	PossibleMove _tmp23_;
	PossibleMove _tmp24_;
	PossibleMove _tmp25_;
	PossibleMove _tmp26_;
	PossibleMove _tmp27_;
	PossibleMove _tmp28_;
	PossibleMove _tmp29_;
	PossibleMove _tmp30_;
	PossibleMove _tmp31_;
	PossibleMove _tmp32_;
	GameStateStruct _tmp33_;
	PossibleMove _tmp34_;
	GameStateStruct _tmp35_;
	PossibleMove _tmp36_;
	GameStateStruct _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gint _tmp38__length2;
	guint8* _tmp39_;
	gint _tmp39__length1;
	gint _tmp39__length2;
	PossibleMove _tmp40_;
	PossibleMove _tmp41_;
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	memset (self, 0, sizeof (GameStateStruct));
	_tmp0_ = *game;
	(*self).opponent_color = _tmp0_.current_color;
	(*self).current_color = player_flip_color ((*self).opponent_color);
	_tmp1_ = *game;
	(*self).size = _tmp1_.size;
	_tmp2_ = *game;
	_tmp3_ = _tmp2_.neighbor_tiles;
	_tmp3__length1 = _tmp2_.neighbor_tiles_length1;
	_tmp3__length2 = _tmp2_.neighbor_tiles_length2;
	(*self).neighbor_tiles = _tmp3_;
	(*self).neighbor_tiles_length1 = _tmp3__length1;
	(*self).neighbor_tiles_length2 = _tmp3__length2;
	_tmp4_ = *game;
	_tmp5_ = _tmp4_.tiles;
	_tmp5__length1 = _tmp4_.tiles_length1;
	_tmp5__length2 = _tmp4_.tiles_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup8 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp6_;
	(*self).tiles_length1 = _tmp6__length1;
	(*self).tiles_length2 = _tmp6__length2;
	_tmp7_ = *move;
	_tmp8_ = *move;
	_tmp9_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp7_.x, _tmp8_.y, (*self).opponent_color, (gint8) 0, (gint8) -1, _tmp9_.n_tiles_n);
	_tmp10_ = *move;
	_tmp11_ = *move;
	_tmp12_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp10_.x, _tmp11_.y, (*self).opponent_color, (gint8) 1, (gint8) -1, _tmp12_.n_tiles_ne);
	_tmp13_ = *move;
	_tmp14_ = *move;
	_tmp15_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp13_.x, _tmp14_.y, (*self).opponent_color, (gint8) 1, (gint8) 0, _tmp15_.n_tiles_e);
	_tmp16_ = *move;
	_tmp17_ = *move;
	_tmp18_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp16_.x, _tmp17_.y, (*self).opponent_color, (gint8) 1, (gint8) 1, _tmp18_.n_tiles_se);
	_tmp19_ = *move;
	_tmp20_ = *move;
	_tmp21_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp19_.x, _tmp20_.y, (*self).opponent_color, (gint8) 0, (gint8) 1, _tmp21_.n_tiles_s);
	_tmp22_ = *move;
	_tmp23_ = *move;
	_tmp24_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp22_.x, _tmp23_.y, (*self).opponent_color, (gint8) -1, (gint8) 1, _tmp24_.n_tiles_so);
	_tmp25_ = *move;
	_tmp26_ = *move;
	_tmp27_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp25_.x, _tmp26_.y, (*self).opponent_color, (gint8) -1, (gint8) 0, _tmp27_.n_tiles_o);
	_tmp28_ = *move;
	_tmp29_ = *move;
	_tmp30_ = *move;
	game_state_struct_flip_tiles (&(*self).tiles, (gint*) (&(*self).tiles_length1), (gint*) (&(*self).tiles_length2), _tmp28_.x, _tmp29_.y, (*self).opponent_color, (gint8) -1, (gint8) -1, _tmp30_.n_tiles_no);
	_tmp31_ = *move;
	_tmp32_ = *move;
	(*self).tiles[(_tmp31_.x * (*self).tiles_length2) + _tmp32_.y] = (*self).opponent_color;
	_tmp33_ = *game;
	_tmp34_ = *move;
	(*self).n_current_tiles = _tmp33_.n_opponent_tiles - _tmp34_.n_tiles;
	_tmp35_ = *game;
	_tmp36_ = *move;
	(*self).n_opponent_tiles = (guint8) ((_tmp35_.n_current_tiles + _tmp36_.n_tiles) + 1);
	(*self).n_tiles = (*self).n_current_tiles + (*self).n_opponent_tiles;
	_tmp37_ = *game;
	_tmp38_ = _tmp37_.empty_neighbors;
	_tmp38__length1 = _tmp37_.empty_neighbors_length1;
	_tmp38__length2 = _tmp37_.empty_neighbors_length2;
	_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup9 (_tmp38_, _tmp38__length1 * _tmp38__length2) : _tmp38_;
	_tmp39__length1 = _tmp38__length1;
	_tmp39__length2 = _tmp38__length2;
	(*self).empty_neighbors = (g_free ((*self).empty_neighbors), NULL);
	(*self).empty_neighbors = _tmp39_;
	(*self).empty_neighbors_length1 = _tmp39__length1;
	(*self).empty_neighbors_length2 = _tmp39__length2;
	_tmp40_ = *move;
	_tmp41_ = *move;
	game_state_struct_update_empty_neighbors (&(*self), _tmp40_.x, _tmp41_.y);
	game_state_struct_update_who_can_move (&(*self));
}

static inline void
game_state_struct_flip_tiles (Player** tiles,
                              gint* tiles_length1,
                              gint* tiles_length2,
                              guint8 x,
                              guint8 y,
                              Player color,
                              gint8 x_step,
                              gint8 y_step,
                              guint8 count)
{
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = count;
				count = _tmp1_ - 1;
			}
			_tmp0_ = FALSE;
			if (!(((gint) count) > 0)) {
				break;
			}
			(*tiles)[((((gint8) x) + (((gint8) count) * x_step)) * (*tiles_length2)) + (((gint8) y) + (((gint8) count) * y_step))] = color;
		}
	}
}

static Player*
_vala_array_dup10 (Player* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

void
game_state_struct_init_from_grid (GameStateStruct *self,
                                  guint8 _size,
                                  Player* _tiles,
                                  gint _tiles_length1,
                                  gint _tiles_length2,
                                  Player color,
                                  guint8* _neighbor_tiles,
                                  gint _neighbor_tiles_length1,
                                  gint _neighbor_tiles_length2,
                                  gboolean humans_opening)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	memset (self, 0, sizeof (GameStateStruct));
	(*self).current_color = color;
	(*self).opponent_color = player_flip_color (color);
	(*self).size = _size;
	(*self).neighbor_tiles = _neighbor_tiles;
	(*self).neighbor_tiles_length1 = _neighbor_tiles_length1;
	(*self).neighbor_tiles_length2 = _neighbor_tiles_length2;
	_tmp0_ = (_tiles != NULL) ? _vala_array_dup10 (_tiles, _tiles_length1 * _tiles_length2) : _tiles;
	_tmp0__length1 = _tiles_length1;
	_tmp0__length2 = _tiles_length2;
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp0_;
	(*self).tiles_length1 = _tmp0__length1;
	(*self).tiles_length2 = _tmp0__length2;
	(*self).n_current_tiles = (guint8) 0;
	(*self).n_opponent_tiles = (guint8) 0;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x < _size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							Player _tmp5_;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y < _size)) {
								break;
							}
							_tmp5_ = _tiles[(x * _tiles_length2) + y];
							game_state_struct_add_tile_of_color (&(*self), _tmp5_);
						}
					}
				}
			}
		}
	}
	(*self).n_tiles = (*self).n_current_tiles + (*self).n_opponent_tiles;
	game_state_struct_init_empty_neighbors (&(*self));
	if (humans_opening) {
		(*self).current_player_can_move = TRUE;
		(*self).is_complete = FALSE;
	} else {
		game_state_struct_update_who_can_move (&(*self));
	}
}

static inline void
game_state_struct_add_tile_of_color (GameStateStruct *self,
                                     Player color)
{
	if (color == (*self).current_color) {
		guint8 _tmp0_;
		_tmp0_ = (*self).n_current_tiles;
		(*self).n_current_tiles = _tmp0_ + 1;
	} else {
		if (color != PLAYER_NONE) {
			guint8 _tmp1_;
			_tmp1_ = (*self).n_opponent_tiles;
			(*self).n_opponent_tiles = _tmp1_ + 1;
		}
	}
}

void
game_state_struct_init_empty (GameStateStruct *self,
                              guint8 _size,
                              guint8* _neighbor_tiles,
                              gint _neighbor_tiles_length1,
                              gint _neighbor_tiles_length2)
{
	Player* _tmp0_;
	memset (self, 0, sizeof (GameStateStruct));
	(*self).current_color = PLAYER_DARK;
	(*self).opponent_color = PLAYER_LIGHT;
	(*self).size = _size;
	(*self).neighbor_tiles = _neighbor_tiles;
	(*self).neighbor_tiles_length1 = _neighbor_tiles_length1;
	(*self).neighbor_tiles_length2 = _neighbor_tiles_length2;
	_tmp0_ = g_new0 (Player, _size * _size);
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp0_;
	(*self).tiles_length1 = _size;
	(*self).tiles_length2 = _size;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x < _size)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y < _size)) {
								break;
							}
							(*self).tiles[(x * (*self).tiles_length2) + y] = PLAYER_NONE;
						}
					}
				}
			}
		}
	}
	(*self).n_current_tiles = (guint8) 0;
	(*self).n_opponent_tiles = (guint8) 0;
	(*self).n_tiles = (guint8) 0;
	game_state_struct_init_empty_neighbors (&(*self));
	(*self).current_player_can_move = TRUE;
	(*self).is_complete = FALSE;
	(*self).x_saved = (guint8) (((*self).size / 2) - 2);
	(*self).y_saved = (guint8) (((*self).size / 2) - 2);
}

static Player*
_vala_array_dup11 (Player* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

void
game_state_struct_init_copy_and_add (GameStateStruct *self,
                                     GameStateStruct* game,
                                     guint8 x,
                                     guint8 y)
{
	GameStateStruct _tmp0_;
	GameStateStruct _tmp1_;
	GameStateStruct _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	GameStateStruct _tmp4_;
	Player* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	Player* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	Player* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	Player _tmp8_;
	GameStateStruct _tmp9_;
	GameStateStruct _tmp10_;
	g_return_if_fail (game != NULL);
	memset (self, 0, sizeof (GameStateStruct));
	_tmp0_ = *game;
	(*self).opponent_color = _tmp0_.current_color;
	(*self).current_color = player_flip_color ((*self).opponent_color);
	_tmp1_ = *game;
	(*self).size = _tmp1_.size;
	_tmp2_ = *game;
	_tmp3_ = _tmp2_.neighbor_tiles;
	_tmp3__length1 = _tmp2_.neighbor_tiles_length1;
	_tmp3__length2 = _tmp2_.neighbor_tiles_length2;
	(*self).neighbor_tiles = _tmp3_;
	(*self).neighbor_tiles_length1 = _tmp3__length1;
	(*self).neighbor_tiles_length2 = _tmp3__length2;
	_tmp4_ = *game;
	_tmp5_ = _tmp4_.tiles;
	_tmp5__length1 = _tmp4_.tiles_length1;
	_tmp5__length2 = _tmp4_.tiles_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup11 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp6_;
	(*self).tiles_length1 = _tmp6__length1;
	(*self).tiles_length2 = _tmp6__length2;
	_tmp7_ = (*self).tiles;
	_tmp7__length1 = (*self).tiles_length1;
	_tmp7__length2 = (*self).tiles_length2;
	_tmp8_ = _tmp7_[(x * _tmp7__length2) + y];
	if (_tmp8_ != PLAYER_NONE) {
		g_assert_not_reached ();
	}
	(*self).tiles[(x * (*self).tiles_length2) + y] = (*self).opponent_color;
	_tmp9_ = *game;
	(*self).n_current_tiles = _tmp9_.n_opponent_tiles;
	_tmp10_ = *game;
	(*self).n_opponent_tiles = (guint8) (_tmp10_.n_current_tiles + 1);
	(*self).n_tiles = (*self).n_current_tiles + (*self).n_opponent_tiles;
	game_state_struct_init_empty_neighbors (&(*self));
	(*self).current_player_can_move = TRUE;
	(*self).is_complete = FALSE;
	(*self).x_saved = (guint8) (((*self).size / 2) - 2);
	(*self).y_saved = (guint8) (((*self).size / 2) - 2);
}

static Player*
_vala_array_dup12 (Player* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

void
game_state_struct_init_copy_and_add_two (GameStateStruct *self,
                                         GameStateStruct* game,
                                         guint8 x1,
                                         guint8 y1,
                                         guint8 x2,
                                         guint8 y2)
{
	GameStateStruct _tmp0_;
	GameStateStruct _tmp1_;
	GameStateStruct _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	GameStateStruct _tmp4_;
	Player* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	Player* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean _tmp7_ = FALSE;
	Player* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	Player _tmp9_;
	GameStateStruct _tmp12_;
	GameStateStruct _tmp13_;
	g_return_if_fail (game != NULL);
	memset (self, 0, sizeof (GameStateStruct));
	_tmp0_ = *game;
	(*self).opponent_color = _tmp0_.current_color;
	(*self).current_color = player_flip_color ((*self).opponent_color);
	_tmp1_ = *game;
	(*self).size = _tmp1_.size;
	_tmp2_ = *game;
	_tmp3_ = _tmp2_.neighbor_tiles;
	_tmp3__length1 = _tmp2_.neighbor_tiles_length1;
	_tmp3__length2 = _tmp2_.neighbor_tiles_length2;
	(*self).neighbor_tiles = _tmp3_;
	(*self).neighbor_tiles_length1 = _tmp3__length1;
	(*self).neighbor_tiles_length2 = _tmp3__length2;
	_tmp4_ = *game;
	_tmp5_ = _tmp4_.tiles;
	_tmp5__length1 = _tmp4_.tiles_length1;
	_tmp5__length2 = _tmp4_.tiles_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup12 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).tiles = _tmp6_;
	(*self).tiles_length1 = _tmp6__length1;
	(*self).tiles_length2 = _tmp6__length2;
	_tmp8_ = (*self).tiles;
	_tmp8__length1 = (*self).tiles_length1;
	_tmp8__length2 = (*self).tiles_length2;
	_tmp9_ = _tmp8_[(x1 * _tmp8__length2) + y1];
	if (_tmp9_ != PLAYER_NONE) {
		_tmp7_ = TRUE;
	} else {
		Player* _tmp10_;
		gint _tmp10__length1;
		gint _tmp10__length2;
		Player _tmp11_;
		_tmp10_ = (*self).tiles;
		_tmp10__length1 = (*self).tiles_length1;
		_tmp10__length2 = (*self).tiles_length2;
		_tmp11_ = _tmp10_[(x2 * _tmp10__length2) + y2];
		_tmp7_ = _tmp11_ != PLAYER_NONE;
	}
	if (_tmp7_) {
		g_assert_not_reached ();
	}
	(*self).tiles[(x1 * (*self).tiles_length2) + y1] = (*self).opponent_color;
	(*self).tiles[(x2 * (*self).tiles_length2) + y2] = (*self).opponent_color;
	_tmp12_ = *game;
	(*self).n_current_tiles = _tmp12_.n_opponent_tiles;
	_tmp13_ = *game;
	(*self).n_opponent_tiles = (guint8) (_tmp13_.n_current_tiles + 2);
	(*self).n_tiles = (*self).n_current_tiles + (*self).n_opponent_tiles;
	game_state_struct_init_empty_neighbors (&(*self));
	(*self).current_player_can_move = TRUE;
	(*self).is_complete = FALSE;
	(*self).x_saved = (guint8) (((*self).size / 2) - 2);
	(*self).y_saved = (guint8) (((*self).size / 2) - 2);
}

inline gboolean
game_state_struct_is_current_color (GameStateStruct *self,
                                    guint8 x,
                                    guint8 y)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	gboolean result;
	_tmp0_ = (*self).tiles;
	_tmp0__length1 = (*self).tiles_length1;
	_tmp0__length2 = (*self).tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_ == (*self).current_color;
	return result;
}

inline gboolean
game_state_struct_is_empty_tile (GameStateStruct *self,
                                 guint8 x,
                                 guint8 y)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	gboolean result;
	_tmp0_ = (*self).tiles;
	_tmp0__length1 = (*self).tiles_length1;
	_tmp0__length2 = (*self).tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_ == PLAYER_NONE;
	return result;
}

static inline gboolean
game_state_struct_is_valid_location_signed (GameStateStruct *self,
                                            gint8 x,
                                            gint8 y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	if (((gint) x) >= 0) {
		_tmp2_ = ((guint8) x) < (*self).size;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = ((gint) y) >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = ((guint8) y) < (*self).size;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
game_state_struct_update_who_can_move (GameStateStruct *self)
{
	Player enemy = 0;
	gboolean opponent_can_move = FALSE;
	enemy = player_flip_color ((*self).current_color);
	opponent_can_move = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		(*self).x_saved = (guint8) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = (*self).x_saved;
				(*self).x_saved = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!((*self).x_saved < (*self).size)) {
				break;
			}
			{
				gboolean _tmp2_ = FALSE;
				(*self).y_saved = (guint8) 0;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						guint8 _tmp3_;
						_tmp3_ = (*self).y_saved;
						(*self).y_saved = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!((*self).y_saved < (*self).size)) {
						break;
					}
					if (game_state_struct_is_unplayable_basic (&(*self), (*self).x_saved, (*self).y_saved)) {
						continue;
					}
					if (game_state_struct_can_place (&(*self), (*self).x_saved, (*self).y_saved, (*self).current_color)) {
						(*self).current_player_can_move = TRUE;
						(*self).is_complete = FALSE;
						return;
					}
					if (opponent_can_move) {
						continue;
					}
					if (game_state_struct_can_place (&(*self), (*self).x_saved, (*self).y_saved, enemy)) {
						opponent_can_move = TRUE;
						(*self).is_complete = FALSE;
					}
				}
			}
		}
	}
	(*self).current_player_can_move = FALSE;
	if (!opponent_can_move) {
		(*self).is_complete = TRUE;
	}
}

static void
_possible_move_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (possible_move_free (var), NULL));
}

static inline void
_g_slist_free__possible_move_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _possible_move_free0_);
}

static gpointer
_possible_move_dup0 (gpointer self)
{
	return self ? possible_move_dup (self) : NULL;
}

void
game_state_struct_get_possible_moves (GameStateStruct *self,
                                      GSList** moves)
{
	GSList* _vala_moves = NULL;
	guint8 x = 0U;
	guint8 y = 0U;
	(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	_vala_moves = NULL;
	x = (*self).x_saved;
	y = (*self).y_saved;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = x;
				x = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(x < (*self).size)) {
				break;
			}
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					PossibleMove move = {0};
					PossibleMove _tmp4_ = {0};
					gboolean _tmp5_;
					if (!_tmp2_) {
						guint8 _tmp3_;
						_tmp3_ = y;
						y = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(y < (*self).size)) {
						break;
					}
					_tmp5_ = game_state_struct_place_tile (&(*self), x, y, (*self).current_color, &_tmp4_);
					move = _tmp4_;
					if (_tmp5_) {
						PossibleMove _tmp6_;
						PossibleMove* _tmp7_;
						_tmp6_ = move;
						_tmp7_ = _possible_move_dup0 (&_tmp6_);
						_vala_moves = g_slist_prepend (_vala_moves, _tmp7_);
					}
				}
			}
			y = (guint8) 0;
		}
	}
	if (moves) {
		*moves = _vala_moves;
	} else {
		(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	}
}

inline gboolean
game_state_struct_test_placing_tile (GameStateStruct *self,
                                     guint8 x,
                                     guint8 y,
                                     PossibleMove* move)
{
	PossibleMove _vala_move = {0};
	PossibleMove _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean result;
	_tmp1_ = game_state_struct_place_tile (&(*self), x, y, (*self).current_color, &_tmp0_);
	_vala_move = _tmp0_;
	result = _tmp1_;
	if (move) {
		*move = _vala_move;
	}
	return result;
}

static inline gboolean
game_state_struct_is_unplayable_basic (GameStateStruct *self,
                                       guint8 x,
                                       guint8 y)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint8 _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	guint8 _tmp3_;
	Player* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	Player _tmp5_;
	gboolean result;
	_tmp0_ = (*self).empty_neighbors;
	_tmp0__length1 = (*self).empty_neighbors_length1;
	_tmp0__length2 = (*self).empty_neighbors_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	_tmp2_ = (*self).neighbor_tiles;
	_tmp2__length1 = (*self).neighbor_tiles_length1;
	_tmp2__length2 = (*self).neighbor_tiles_length2;
	_tmp3_ = _tmp2_[(x * _tmp2__length2) + y];
	if (_tmp1_ == _tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = (*self).tiles;
	_tmp4__length1 = (*self).tiles_length1;
	_tmp4__length2 = (*self).tiles_length2;
	_tmp5_ = _tmp4_[(x * _tmp4__length2) + y];
	if (_tmp5_ != PLAYER_NONE) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static inline gboolean
game_state_struct_place_tile (GameStateStruct *self,
                              guint8 x,
                              guint8 y,
                              Player color,
                              PossibleMove* move)
{
	PossibleMove _vala_move = {0};
	PossibleMove _tmp0_;
	PossibleMove _tmp1_;
	PossibleMove _tmp2_;
	PossibleMove _tmp3_;
	PossibleMove _tmp4_;
	PossibleMove _tmp5_;
	PossibleMove _tmp6_;
	PossibleMove _tmp7_;
	PossibleMove _tmp8_;
	gboolean result;
	possible_move_init (&_vala_move, x, y);
	if (game_state_struct_is_unplayable_basic (&(*self), x, y)) {
		result = FALSE;
		if (move) {
			*move = _vala_move;
		}
		return result;
	}
	_vala_move.n_tiles_n = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 0, (gint8) -1);
	_vala_move.n_tiles_ne = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) -1);
	_vala_move.n_tiles_e = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) 0);
	_vala_move.n_tiles_se = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) 1);
	_vala_move.n_tiles_s = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 0, (gint8) 1);
	_vala_move.n_tiles_so = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) 1);
	_vala_move.n_tiles_o = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) 0);
	_vala_move.n_tiles_no = game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) -1);
	_tmp0_ = _vala_move;
	_tmp1_ = _vala_move;
	_tmp2_ = _vala_move;
	_tmp3_ = _vala_move;
	_tmp4_ = _vala_move;
	_tmp5_ = _vala_move;
	_tmp6_ = _vala_move;
	_tmp7_ = _vala_move;
	_vala_move.n_tiles = ((((((_tmp0_.n_tiles_n + _tmp1_.n_tiles_ne) + _tmp2_.n_tiles_e) + _tmp3_.n_tiles_se) + _tmp4_.n_tiles_s) + _tmp5_.n_tiles_so) + _tmp6_.n_tiles_o) + _tmp7_.n_tiles_no;
	_tmp8_ = _vala_move;
	result = ((gint) _tmp8_.n_tiles) != 0;
	if (move) {
		*move = _vala_move;
	}
	return result;
}

/**
     * can_place:
     * @x: the x coordinate of the tile to test
     * @y: the y coordinate of the tile to test
     * @color: the player color to test
     *
     * You should test is_unplayable_basic() before launching this.
     *
     * This method is faster than place_tile(), as it returns early
     * when some turnable tiles are found in one of the directions.
     *
     * Returns: %true if the given @color can be play there
     */
static inline gboolean
game_state_struct_can_place (GameStateStruct *self,
                             guint8 x,
                             guint8 y,
                             Player color)
{
	gboolean result;
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) -1)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) 1)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) 1)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) -1)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 1, (gint8) 0)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) -1, (gint8) 0)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 0, (gint8) 1)) > 0) {
		result = TRUE;
		return result;
	}
	if (((gint) game_state_struct_can_flip_tiles (&(*self), x, y, color, (gint8) 0, (gint8) -1)) > 0) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
     * can_flip_tiles:
     * @x: the x coordinate to start with
     * @y: the y coordinate to start with
     * @color: the player color to test
     * @x_step: the step on the x direction, %1, %0 or %-1
     * @y_step: the step on the y direction, %1, %0 or %-1
     *
     * Returns: the number of turnable tiles in the given direction
     */
static inline guint8
game_state_struct_can_flip_tiles (GameStateStruct *self,
                                  guint8 x,
                                  guint8 y,
                                  Player color,
                                  gint8 x_step,
                                  gint8 y_step)
{
	Player enemy = 0;
	gint8 enemy_count = 0;
	gboolean is_valid_location = FALSE;
	gint8 xt = 0;
	gint8 yt = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	guint8 result;
	enemy = player_flip_color (color);
	enemy_count = (gint8) -1;
	is_valid_location = FALSE;
	xt = (gint8) x;
	yt = (gint8) y;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint8 _tmp4_;
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (is_valid_location) {
					Player* _tmp2_;
					gint _tmp2__length1;
					gint _tmp2__length2;
					Player _tmp3_;
					_tmp2_ = (*self).tiles;
					_tmp2__length1 = (*self).tiles_length1;
					_tmp2__length2 = (*self).tiles_length2;
					_tmp3_ = _tmp2_[(xt * _tmp2__length2) + yt];
					_tmp1_ = _tmp3_ == enemy;
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp4_ = enemy_count;
			enemy_count = _tmp4_ + 1;
			xt += x_step;
			yt += y_step;
			is_valid_location = game_state_struct_is_valid_location_signed (&(*self), xt, yt);
		}
	}
	if (((gint) enemy_count) <= 0) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !is_valid_location;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		Player* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		Player _tmp8_;
		_tmp7_ = (*self).tiles;
		_tmp7__length1 = (*self).tiles_length1;
		_tmp7__length2 = (*self).tiles_length2;
		_tmp8_ = _tmp7_[(xt * _tmp7__length2) + yt];
		_tmp5_ = _tmp8_ != color;
	}
	if (_tmp5_) {
		result = (guint8) 0;
		return result;
	}
	result = (guint8) enemy_count;
	return result;
}

guint8
game_state_struct_get_empty_neighbors (GameStateStruct *self,
                                       guint8 x,
                                       guint8 y)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint8 _tmp1_;
	guint8 result;
	_tmp0_ = (*self).empty_neighbors;
	_tmp0__length1 = (*self).empty_neighbors_length1;
	_tmp0__length2 = (*self).empty_neighbors_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_;
	return result;
}

static inline void
game_state_struct_init_empty_neighbors (GameStateStruct *self)
{
	guint8* _tmp0_;
	gint8 _size = 0;
	gint8 xmm = 0;
	gint8 ymm = 0;
	gint8 xpp = 0;
	gint8 ypp = 0;
	gboolean xmm_is_valid = FALSE;
	gboolean xpp_is_valid = FALSE;
	_tmp0_ = g_new0 (guint8, (*self).size * (*self).size);
	(*self).empty_neighbors = (g_free ((*self).empty_neighbors), NULL);
	(*self).empty_neighbors = _tmp0_;
	(*self).empty_neighbors_length1 = (*self).size;
	(*self).empty_neighbors_length2 = (*self).size;
	_size = (gint8) (*self).size;
	{
		gint8 x = 0;
		x = (gint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint8 _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x < _size)) {
					break;
				}
				xmm = (gint8) (x - 1);
				xpp = (gint8) (x + 1);
				xmm_is_valid = ((gint) xmm) >= 0;
				xpp_is_valid = ((guint8) xpp) < (*self).size;
				{
					gint8 y = 0;
					y = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 empty_neighbors_x_y = 0U;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y < _size)) {
								break;
							}
							ymm = (gint8) (y - 1);
							ypp = (gint8) (y + 1);
							empty_neighbors_x_y = game_state_struct_is_empty (&(*self), x, ymm) + game_state_struct_is_empty (&(*self), x, ypp);
							if (xmm_is_valid) {
								empty_neighbors_x_y += (game_state_struct_is_empty (&(*self), xmm, y) + game_state_struct_is_empty (&(*self), xmm, ymm)) + game_state_struct_is_empty (&(*self), xmm, ypp);
							}
							if (xpp_is_valid) {
								empty_neighbors_x_y += (game_state_struct_is_empty (&(*self), xpp, y) + game_state_struct_is_empty (&(*self), xpp, ymm)) + game_state_struct_is_empty (&(*self), xpp, ypp);
							}
							(*self).empty_neighbors[(x * (*self).empty_neighbors_length2) + y] = empty_neighbors_x_y;
						}
					}
				}
			}
		}
	}
}

static inline guint8
game_state_struct_is_empty (GameStateStruct *self,
                            gint8 x,
                            gint8 y)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	guint8 result;
	if (!game_state_struct_is_valid_location_signed (&(*self), x, y)) {
		result = (guint8) 0;
		return result;
	}
	_tmp0_ = (*self).tiles;
	_tmp0__length1 = (*self).tiles_length1;
	_tmp0__length2 = (*self).tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_ != PLAYER_NONE) {
		result = (guint8) 0;
		return result;
	}
	result = (guint8) 1;
	return result;
}

static inline void
game_state_struct_update_empty_neighbors (GameStateStruct *self,
                                          guint8 x,
                                          guint8 y)
{
	gint8 xmm = 0;
	gint8 ymm = 0;
	gint8 xpp = 0;
	gint8 ypp = 0;
	gboolean ymm_is_valid = FALSE;
	gboolean ypp_is_valid = FALSE;
	xmm = (gint8) (((gint8) x) - 1);
	ymm = (gint8) (((gint8) y) - 1);
	xpp = (gint8) (xmm + 2);
	ypp = (gint8) (ymm + 2);
	ymm_is_valid = ((gint) ymm) >= 0;
	ypp_is_valid = ((guint8) ypp) < (*self).size;
	if (((gint) xmm) >= 0) {
		(*self).empty_neighbors[(xmm * (*self).empty_neighbors_length2) + y] -= (guint8) 1;
		if (ymm_is_valid) {
			(*self).empty_neighbors[(xmm * (*self).empty_neighbors_length2) + ymm] -= (guint8) 1;
		}
		if (ypp_is_valid) {
			(*self).empty_neighbors[(xmm * (*self).empty_neighbors_length2) + ypp] -= (guint8) 1;
		}
	}
	if (ymm_is_valid) {
		(*self).empty_neighbors[(x * (*self).empty_neighbors_length2) + ymm] -= (guint8) 1;
	}
	if (ypp_is_valid) {
		(*self).empty_neighbors[(x * (*self).empty_neighbors_length2) + ypp] -= (guint8) 1;
	}
	if (((guint8) xpp) < (*self).size) {
		(*self).empty_neighbors[(xpp * (*self).empty_neighbors_length2) + y] -= (guint8) 1;
		if (ymm_is_valid) {
			(*self).empty_neighbors[(xpp * (*self).empty_neighbors_length2) + ymm] -= (guint8) 1;
		}
		if (ypp_is_valid) {
			(*self).empty_neighbors[(xpp * (*self).empty_neighbors_length2) + ypp] -= (guint8) 1;
		}
	}
}

Player*
game_state_struct_get_mainline (GameStateStruct *self,
                                MainLine mainline_id,
                                gint* result_length1)
{
	Player* mainline = NULL;
	Player* _tmp0_;
	gint mainline_length1;
	gint _mainline_size_;
	Player* _tmp31_;
	gint _tmp31__length1;
	Player* result;
	_tmp0_ = g_new0 (Player, (*self).size);
	mainline = _tmp0_;
	mainline_length1 = (*self).size;
	_mainline_size_ = mainline_length1;
	switch (mainline_id) {
		case MAIN_LINE_TOP:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp1_ = FALSE;
					_tmp1_ = TRUE;
					while (TRUE) {
						Player* _tmp3_;
						gint _tmp3__length1;
						Player* _tmp4_;
						gint _tmp4__length1;
						gint _tmp4__length2;
						Player _tmp5_;
						if (!_tmp1_) {
							guint8 _tmp2_;
							_tmp2_ = i;
							i = _tmp2_ + 1;
						}
						_tmp1_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp3_ = mainline;
						_tmp3__length1 = mainline_length1;
						_tmp4_ = (*self).tiles;
						_tmp4__length1 = (*self).tiles_length1;
						_tmp4__length2 = (*self).tiles_length2;
						_tmp5_ = _tmp4_[(i * _tmp4__length2) + 0];
						_tmp3_[i] = _tmp5_;
					}
				}
			}
			break;
		}
		case MAIN_LINE_LEFT:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = TRUE;
					while (TRUE) {
						Player* _tmp8_;
						gint _tmp8__length1;
						Player* _tmp9_;
						gint _tmp9__length1;
						gint _tmp9__length2;
						Player _tmp10_;
						if (!_tmp6_) {
							guint8 _tmp7_;
							_tmp7_ = i;
							i = _tmp7_ + 1;
						}
						_tmp6_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp8_ = mainline;
						_tmp8__length1 = mainline_length1;
						_tmp9_ = (*self).tiles;
						_tmp9__length1 = (*self).tiles_length1;
						_tmp9__length2 = (*self).tiles_length2;
						_tmp10_ = _tmp9_[(0 * _tmp9__length2) + i];
						_tmp8_[i] = _tmp10_;
					}
				}
			}
			break;
		}
		case MAIN_LINE_RIGHT:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp11_ = FALSE;
					_tmp11_ = TRUE;
					while (TRUE) {
						Player* _tmp13_;
						gint _tmp13__length1;
						Player* _tmp14_;
						gint _tmp14__length1;
						gint _tmp14__length2;
						Player _tmp15_;
						if (!_tmp11_) {
							guint8 _tmp12_;
							_tmp12_ = i;
							i = _tmp12_ + 1;
						}
						_tmp11_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp13_ = mainline;
						_tmp13__length1 = mainline_length1;
						_tmp14_ = (*self).tiles;
						_tmp14__length1 = (*self).tiles_length1;
						_tmp14__length2 = (*self).tiles_length2;
						_tmp15_ = _tmp14_[(((*self).size - 1) * _tmp14__length2) + i];
						_tmp13_[i] = _tmp15_;
					}
				}
			}
			break;
		}
		case MAIN_LINE_BOTTOM:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						Player* _tmp18_;
						gint _tmp18__length1;
						Player* _tmp19_;
						gint _tmp19__length1;
						gint _tmp19__length2;
						Player _tmp20_;
						if (!_tmp16_) {
							guint8 _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ + 1;
						}
						_tmp16_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp18_ = mainline;
						_tmp18__length1 = mainline_length1;
						_tmp19_ = (*self).tiles;
						_tmp19__length1 = (*self).tiles_length1;
						_tmp19__length2 = (*self).tiles_length2;
						_tmp20_ = _tmp19_[(i * _tmp19__length2) + ((*self).size - 1)];
						_tmp18_[i] = _tmp20_;
					}
				}
			}
			break;
		}
		case MAIN_LINE_TOPLEFT:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						Player* _tmp23_;
						gint _tmp23__length1;
						Player* _tmp24_;
						gint _tmp24__length1;
						gint _tmp24__length2;
						Player _tmp25_;
						if (!_tmp21_) {
							guint8 _tmp22_;
							_tmp22_ = i;
							i = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp23_ = mainline;
						_tmp23__length1 = mainline_length1;
						_tmp24_ = (*self).tiles;
						_tmp24__length1 = (*self).tiles_length1;
						_tmp24__length2 = (*self).tiles_length2;
						_tmp25_ = _tmp24_[(i * _tmp24__length2) + i];
						_tmp23_[i] = _tmp25_;
					}
				}
			}
			break;
		}
		case MAIN_LINE_TOPRIGHT:
		{
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp26_ = FALSE;
					_tmp26_ = TRUE;
					while (TRUE) {
						Player* _tmp28_;
						gint _tmp28__length1;
						Player* _tmp29_;
						gint _tmp29__length1;
						gint _tmp29__length2;
						Player _tmp30_;
						if (!_tmp26_) {
							guint8 _tmp27_;
							_tmp27_ = i;
							i = _tmp27_ + 1;
						}
						_tmp26_ = FALSE;
						if (!(i < (*self).size)) {
							break;
						}
						_tmp28_ = mainline;
						_tmp28__length1 = mainline_length1;
						_tmp29_ = (*self).tiles;
						_tmp29__length1 = (*self).tiles_length1;
						_tmp29__length2 = (*self).tiles_length2;
						_tmp30_ = _tmp29_[((((*self).size - 1) - i) * _tmp29__length2) + i];
						_tmp28_[i] = _tmp30_;
					}
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp31_ = mainline;
	_tmp31__length1 = mainline_length1;
	if (result_length1) {
		*result_length1 = _tmp31__length1;
	}
	result = _tmp31_;
	return result;
}

static Player*
_vala_array_dup13 (Player* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (Player));
	}
	return NULL;
}

static guint8*
_vala_array_dup14 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
game_state_struct_copy (const GameStateStruct* self,
                        GameStateStruct* dest)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	(*dest).current_color = (*self).current_color;
	(*dest).opponent_color = (*self).opponent_color;
	(*dest).size = (*self).size;
	(*dest).n_current_tiles = (*self).n_current_tiles;
	(*dest).n_opponent_tiles = (*self).n_opponent_tiles;
	(*dest).n_tiles = (*self).n_tiles;
	(*dest).current_player_can_move = (*self).current_player_can_move;
	(*dest).is_complete = (*self).is_complete;
	_tmp0_ = (*self).tiles;
	_tmp0__length1 = (*self).tiles_length1;
	_tmp0__length2 = (*self).tiles_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup13 (_tmp0_, _tmp0__length1 * _tmp0__length2) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	(*dest).tiles = (g_free ((*dest).tiles), NULL);
	(*dest).tiles = _tmp1_;
	(*dest).tiles_length1 = _tmp1__length1;
	(*dest).tiles_length2 = _tmp1__length2;
	_tmp2_ = (*self).neighbor_tiles;
	_tmp2__length1 = (*self).neighbor_tiles_length1;
	_tmp2__length2 = (*self).neighbor_tiles_length2;
	(*dest).neighbor_tiles = _tmp2_;
	(*dest).neighbor_tiles_length1 = _tmp2__length1;
	(*dest).neighbor_tiles_length2 = _tmp2__length2;
	(*dest).x_saved = (*self).x_saved;
	(*dest).y_saved = (*self).y_saved;
	_tmp3_ = (*self).empty_neighbors;
	_tmp3__length1 = (*self).empty_neighbors_length1;
	_tmp3__length2 = (*self).empty_neighbors_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup14 (_tmp3_, _tmp3__length1 * _tmp3__length2) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	(*dest).empty_neighbors = (g_free ((*dest).empty_neighbors), NULL);
	(*dest).empty_neighbors = _tmp4_;
	(*dest).empty_neighbors_length1 = _tmp4__length1;
	(*dest).empty_neighbors_length2 = _tmp4__length2;
}

void
game_state_struct_destroy (GameStateStruct* self)
{
	(*self).tiles = (g_free ((*self).tiles), NULL);
	(*self).empty_neighbors = (g_free ((*self).empty_neighbors), NULL);
}

GameStateStruct*
game_state_struct_dup (const GameStateStruct* self)
{
	GameStateStruct* dup;
	dup = g_new0 (GameStateStruct, 1);
	game_state_struct_copy (self, dup);
	return dup;
}

void
game_state_struct_free (GameStateStruct* self)
{
	game_state_struct_destroy (self);
	g_free (self);
}

static GType
game_state_struct_get_type_once (void)
{
	GType game_state_struct_type_id;
	game_state_struct_type_id = g_boxed_type_register_static ("GameStateStruct", (GBoxedCopyFunc) game_state_struct_dup, (GBoxedFreeFunc) game_state_struct_free);
	return game_state_struct_type_id;
}

GType
game_state_struct_get_type (void)
{
	static volatile gsize game_state_struct_type_id__once = 0;
	if (g_once_init_enter (&game_state_struct_type_id__once)) {
		GType game_state_struct_type_id;
		game_state_struct_type_id = game_state_struct_get_type_once ();
		g_once_init_leave (&game_state_struct_type_id__once, game_state_struct_type_id);
	}
	return game_state_struct_type_id__once;
}

static inline gpointer
game_state_object_get_instance_private (GameStateObject* self)
{
	return G_STRUCT_MEMBER_P (self, GameStateObject_private_offset);
}

gchar*
game_state_object_to_string (GameStateObject* self)
{
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_state_struct_to_string (&_tmp1_);
	result = _tmp2_;
	return result;
}

GameStateObject*
game_state_object_construct_copy_and_pass (GType object_type,
                                           GameStateObject* game)
{
	GameStateObject * self = NULL;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_object_get_game_state_struct (game, &_tmp0_);
	_tmp1_ = _tmp0_;
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_copy_and_pass (&self->priv->_game_state_struct, &_tmp1_);
	return self;
}

GameStateObject*
game_state_object_new_copy_and_pass (GameStateObject* game)
{
	return game_state_object_construct_copy_and_pass (TYPE_GAME_STATE_OBJECT, game);
}

GameStateObject*
game_state_object_construct_copy_and_move (GType object_type,
                                           GameStateObject* game,
                                           PossibleMove* move)
{
	GameStateObject * self = NULL;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	PossibleMove _tmp2_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (move != NULL, NULL);
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_object_get_game_state_struct (game, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = *move;
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_copy_and_move (&self->priv->_game_state_struct, &_tmp1_, &_tmp2_);
	return self;
}

GameStateObject*
game_state_object_new_copy_and_move (GameStateObject* game,
                                     PossibleMove* move)
{
	return game_state_object_construct_copy_and_move (TYPE_GAME_STATE_OBJECT, game, move);
}

GameStateObject*
game_state_object_construct_from_grid (GType object_type,
                                       guint8 size,
                                       Player* tiles,
                                       gint tiles_length1,
                                       gint tiles_length2,
                                       Player color,
                                       guint8* neighbor_tiles,
                                       gint neighbor_tiles_length1,
                                       gint neighbor_tiles_length2,
                                       gboolean humans_opening)
{
	GameStateObject * self = NULL;
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_from_grid (&self->priv->_game_state_struct, size, tiles, tiles_length1, tiles_length2, color, neighbor_tiles, neighbor_tiles_length1, neighbor_tiles_length2, humans_opening);
	return self;
}

GameStateObject*
game_state_object_new_from_grid (guint8 size,
                                 Player* tiles,
                                 gint tiles_length1,
                                 gint tiles_length2,
                                 Player color,
                                 guint8* neighbor_tiles,
                                 gint neighbor_tiles_length1,
                                 gint neighbor_tiles_length2,
                                 gboolean humans_opening)
{
	return game_state_object_construct_from_grid (TYPE_GAME_STATE_OBJECT, size, tiles, tiles_length1, tiles_length2, color, neighbor_tiles, neighbor_tiles_length1, neighbor_tiles_length2, humans_opening);
}

GameStateObject*
game_state_object_construct_empty (GType object_type,
                                   guint8 size,
                                   guint8* neighbor_tiles,
                                   gint neighbor_tiles_length1,
                                   gint neighbor_tiles_length2)
{
	GameStateObject * self = NULL;
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_empty (&self->priv->_game_state_struct, size, neighbor_tiles, neighbor_tiles_length1, neighbor_tiles_length2);
	return self;
}

GameStateObject*
game_state_object_new_empty (guint8 size,
                             guint8* neighbor_tiles,
                             gint neighbor_tiles_length1,
                             gint neighbor_tiles_length2)
{
	return game_state_object_construct_empty (TYPE_GAME_STATE_OBJECT, size, neighbor_tiles, neighbor_tiles_length1, neighbor_tiles_length2);
}

GameStateObject*
game_state_object_construct_copy_and_add (GType object_type,
                                          GameStateObject* game,
                                          guint8 x,
                                          guint8 y)
{
	GameStateObject * self = NULL;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_object_get_game_state_struct (game, &_tmp0_);
	_tmp1_ = _tmp0_;
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_copy_and_add (&self->priv->_game_state_struct, &_tmp1_, x, y);
	return self;
}

GameStateObject*
game_state_object_new_copy_and_add (GameStateObject* game,
                                    guint8 x,
                                    guint8 y)
{
	return game_state_object_construct_copy_and_add (TYPE_GAME_STATE_OBJECT, game, x, y);
}

GameStateObject*
game_state_object_construct_copy_and_add_two (GType object_type,
                                              GameStateObject* game,
                                              guint8 x,
                                              guint8 y,
                                              guint8 x2,
                                              guint8 y2)
{
	GameStateObject * self = NULL;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (GameStateObject*) g_object_new (object_type, NULL);
	game_state_object_get_game_state_struct (game, &_tmp0_);
	_tmp1_ = _tmp0_;
	game_state_struct_destroy (&self->priv->_game_state_struct);
	game_state_struct_init_copy_and_add_two (&self->priv->_game_state_struct, &_tmp1_, x, y, x2, y2);
	return self;
}

GameStateObject*
game_state_object_new_copy_and_add_two (GameStateObject* game,
                                        guint8 x,
                                        guint8 y,
                                        guint8 x2,
                                        guint8 y2)
{
	return game_state_object_construct_copy_and_add_two (TYPE_GAME_STATE_OBJECT, game, x, y, x2, y2);
}

Player
game_state_object_get_owner (GameStateObject* self,
                             guint8 x,
                             guint8 y)
{
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	Player* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	Player _tmp3_;
	Player result;
	g_return_val_if_fail (self != NULL, 0);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.tiles;
	_tmp2__length1 = _tmp1_.tiles_length1;
	_tmp2__length2 = _tmp1_.tiles_length2;
	_tmp3_ = _tmp2_[(x * _tmp2__length2) + y];
	result = _tmp3_;
	return result;
}

void
game_state_object_get_possible_moves (GameStateObject* self,
                                      GSList** moves)
{
	GSList* _vala_moves = NULL;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	GSList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	game_state_struct_get_possible_moves (&_tmp1_, &_tmp2_);
	(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	_vala_moves = _tmp2_;
	if (moves) {
		*moves = _vala_moves;
	} else {
		(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	}
}

gboolean
game_state_object_test_placing_tile (GameStateObject* self,
                                     guint8 x,
                                     guint8 y,
                                     PossibleMove* move)
{
	PossibleMove _vala_move = {0};
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	PossibleMove _tmp2_ = {0};
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp3_ = game_state_struct_test_placing_tile (&_tmp1_, x, y, &_tmp2_);
	_vala_move = _tmp2_;
	result = _tmp3_;
	if (move) {
		*move = _vala_move;
	}
	return result;
}

GameStateObject*
game_state_object_construct (GType object_type)
{
	GameStateObject * self = NULL;
	self = (GameStateObject*) g_object_new (object_type, NULL);
	return self;
}

GameStateObject*
game_state_object_new (void)
{
	return game_state_object_construct (TYPE_GAME_STATE_OBJECT);
}

void
game_state_object_get_game_state_struct (GameStateObject* self,
                                         GameStateStruct * result)
{
	GameStateStruct _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_state_struct;
	*result = _tmp0_;
	return;
}

Player
game_state_object_get_current_color (GameStateObject* self)
{
	Player result;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	result = _tmp1_.current_color;
	return result;
}

guint8
game_state_object_get_n_light_tiles (GameStateObject* self)
{
	guint8 result;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	GameStateStruct _tmp4_ = {0};
	GameStateStruct _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	if (_tmp1_.current_color == PLAYER_LIGHT) {
		GameStateStruct _tmp2_ = {0};
		GameStateStruct _tmp3_;
		game_state_object_get_game_state_struct (self, &_tmp2_);
		_tmp3_ = _tmp2_;
		result = _tmp3_.n_current_tiles;
		return result;
	}
	game_state_object_get_game_state_struct (self, &_tmp4_);
	_tmp5_ = _tmp4_;
	result = _tmp5_.n_opponent_tiles;
	return result;
}

guint8
game_state_object_get_n_dark_tiles (GameStateObject* self)
{
	guint8 result;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	GameStateStruct _tmp4_ = {0};
	GameStateStruct _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	if (_tmp1_.current_color == PLAYER_DARK) {
		GameStateStruct _tmp2_ = {0};
		GameStateStruct _tmp3_;
		game_state_object_get_game_state_struct (self, &_tmp2_);
		_tmp3_ = _tmp2_;
		result = _tmp3_.n_current_tiles;
		return result;
	}
	game_state_object_get_game_state_struct (self, &_tmp4_);
	_tmp5_ = _tmp4_;
	result = _tmp5_.n_opponent_tiles;
	return result;
}

gboolean
game_state_object_get_current_player_can_move (GameStateObject* self)
{
	gboolean result;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	result = _tmp1_.current_player_can_move;
	return result;
}

gboolean
game_state_object_get_is_complete (GameStateObject* self)
{
	gboolean result;
	GameStateStruct _tmp0_ = {0};
	GameStateStruct _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	game_state_object_get_game_state_struct (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	result = _tmp1_.is_complete;
	return result;
}

static void
game_state_object_class_init (GameStateObjectClass * klass,
                              gpointer klass_data)
{
	game_state_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameStateObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_state_object_get_property;
	G_OBJECT_CLASS (klass)->finalize = game_state_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_GAME_STATE_STRUCT_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_GAME_STATE_STRUCT_PROPERTY] = g_param_spec_boxed ("game-state-struct", "game-state-struct", "game-state-struct", TYPE_GAME_STATE_STRUCT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_CURRENT_COLOR_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_CURRENT_COLOR_PROPERTY] = g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_N_LIGHT_TILES_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_N_LIGHT_TILES_PROPERTY] = g_param_spec_uchar ("n-light-tiles", "n-light-tiles", "n-light-tiles", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_N_DARK_TILES_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_N_DARK_TILES_PROPERTY] = g_param_spec_uchar ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_CURRENT_PLAYER_CAN_MOVE_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_CURRENT_PLAYER_CAN_MOVE_PROPERTY] = g_param_spec_boolean ("current-player-can-move", "current-player-can-move", "current-player-can-move", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STATE_OBJECT_IS_COMPLETE_PROPERTY, game_state_object_properties[GAME_STATE_OBJECT_IS_COMPLETE_PROPERTY] = g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
game_state_object_instance_init (GameStateObject * self,
                                 gpointer klass)
{
	self->priv = game_state_object_get_instance_private (self);
}

static void
game_state_object_finalize (GObject * obj)
{
	GameStateObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_STATE_OBJECT, GameStateObject);
	game_state_struct_destroy (&self->priv->_game_state_struct);
	G_OBJECT_CLASS (game_state_object_parent_class)->finalize (obj);
}

static GType
game_state_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameStateObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_state_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameStateObject), 0, (GInstanceInitFunc) game_state_object_instance_init, NULL };
	GType game_state_object_type_id;
	game_state_object_type_id = g_type_register_static (G_TYPE_OBJECT, "GameStateObject", &g_define_type_info, 0);
	GameStateObject_private_offset = g_type_add_instance_private (game_state_object_type_id, sizeof (GameStateObjectPrivate));
	return game_state_object_type_id;
}

GType
game_state_object_get_type (void)
{
	static volatile gsize game_state_object_type_id__once = 0;
	if (g_once_init_enter (&game_state_object_type_id__once)) {
		GType game_state_object_type_id;
		game_state_object_type_id = game_state_object_get_type_once ();
		g_once_init_leave (&game_state_object_type_id__once, game_state_object_type_id);
	}
	return game_state_object_type_id__once;
}

static void
_vala_game_state_object_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GameStateObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_STATE_OBJECT, GameStateObject);
	switch (property_id) {
		case GAME_STATE_OBJECT_GAME_STATE_STRUCT_PROPERTY:
		{
			GameStateStruct boxed;
			game_state_object_get_game_state_struct (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case GAME_STATE_OBJECT_CURRENT_COLOR_PROPERTY:
		g_value_set_enum (value, game_state_object_get_current_color (self));
		break;
		case GAME_STATE_OBJECT_N_LIGHT_TILES_PROPERTY:
		g_value_set_uchar (value, game_state_object_get_n_light_tiles (self));
		break;
		case GAME_STATE_OBJECT_N_DARK_TILES_PROPERTY:
		g_value_set_uchar (value, game_state_object_get_n_dark_tiles (self));
		break;
		case GAME_STATE_OBJECT_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		g_value_set_boolean (value, game_state_object_get_current_player_can_move (self));
		break;
		case GAME_STATE_OBJECT_IS_COMPLETE_PROPERTY:
		g_value_set_boolean (value, game_state_object_get_is_complete (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

Game*
game_construct (GType object_type,
                gboolean _reverse,
                Opening _opening,
                guint8 _size,
                gboolean _print_logs)
{
	Game * self = NULL;
	guint8* _neighbor_tiles = NULL;
	gint _neighbor_tiles_length1 = 0;
	gint _neighbor_tiles_length2 = 0;
	guint8* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GameStateObject* _current_state = NULL;
	guint8 _initial_number_of_tiles = 0U;
	gboolean even_board = FALSE;
	gboolean humans_opening = FALSE;
	gboolean _tmp3_ = FALSE;
	GameStateObject* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	gint _tmp19__length2;
	_vala_return_val_if_fail (((gint) _size) >= 4, "_size >= 4", NULL);
	_vala_return_val_if_fail (((gint) _size) <= 16, "_size <= 16", NULL);
	game_init_neighbor_tiles (_size, &_tmp0_, &_tmp1_, &_tmp2_);
	_neighbor_tiles = (g_free (_neighbor_tiles), NULL);
	_neighbor_tiles = _tmp0_;
	_neighbor_tiles_length1 = _tmp1_;
	_neighbor_tiles_length2 = _tmp2_;
	even_board = (_size % 2) == 0;
	humans_opening = _opening == OPENING_HUMANS;
	if (even_board) {
		_tmp3_ = humans_opening;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint8* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		GameStateObject* _tmp5_;
		_initial_number_of_tiles = (guint8) 0;
		_tmp4_ = _neighbor_tiles;
		_tmp4__length1 = _neighbor_tiles_length1;
		_tmp4__length2 = _neighbor_tiles_length2;
		_tmp5_ = game_state_object_new_empty (_size, _tmp4_, _tmp4__length1, _tmp4__length2);
		_g_object_unref0 (_current_state);
		_current_state = _tmp5_;
	} else {
		Player* tiles = NULL;
		Player* _tmp6_;
		gint tiles_length1;
		gint tiles_length2;
		Player _tmp14_ = 0;
		Player first_player = 0;
		Player* _tmp15_;
		gint _tmp15__length1;
		gint _tmp15__length2;
		guint8* _tmp16_;
		gint _tmp16__length1;
		gint _tmp16__length2;
		GameStateObject* _tmp17_;
		_tmp6_ = g_new0 (Player, _size * _size);
		tiles = _tmp6_;
		tiles_length1 = _size;
		tiles_length2 = _size;
		{
			guint8 x = 0U;
			x = (guint8) 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					if (!_tmp7_) {
						guint8 _tmp8_;
						_tmp8_ = x;
						x = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					if (!(x < _size)) {
						break;
					}
					{
						guint8 y = 0U;
						y = (guint8) 0;
						{
							gboolean _tmp9_ = FALSE;
							_tmp9_ = TRUE;
							while (TRUE) {
								Player* _tmp11_;
								gint _tmp11__length1;
								gint _tmp11__length2;
								if (!_tmp9_) {
									guint8 _tmp10_;
									_tmp10_ = y;
									y = _tmp10_ + 1;
								}
								_tmp9_ = FALSE;
								if (!(y < _size)) {
									break;
								}
								_tmp11_ = tiles;
								_tmp11__length1 = tiles_length1;
								_tmp11__length2 = tiles_length2;
								_tmp11_[(x * _tmp11__length2) + y] = PLAYER_NONE;
							}
						}
					}
				}
			}
		}
		if (even_board) {
			guint8 _tmp12_ = 0U;
			game_setup_even_board (_size, _opening, &tiles, (gint*) (&tiles_length1), (gint*) (&tiles_length2), &_tmp12_);
			_initial_number_of_tiles = _tmp12_;
		} else {
			guint8 _tmp13_ = 0U;
			game_setup_odd_board (_size, _opening, &tiles, (gint*) (&tiles_length1), (gint*) (&tiles_length2), &_tmp13_);
			_initial_number_of_tiles = _tmp13_;
		}
		if (humans_opening) {
			_tmp14_ = PLAYER_LIGHT;
		} else {
			_tmp14_ = PLAYER_DARK;
		}
		first_player = _tmp14_;
		_tmp15_ = tiles;
		_tmp15__length1 = tiles_length1;
		_tmp15__length2 = tiles_length2;
		_tmp16_ = _neighbor_tiles;
		_tmp16__length1 = _neighbor_tiles_length1;
		_tmp16__length2 = _neighbor_tiles_length2;
		_tmp17_ = game_state_object_new_from_grid (_size, _tmp15_, _tmp15__length1, _tmp15__length2, first_player, _tmp16_, _tmp16__length1, _tmp16__length2, humans_opening);
		_g_object_unref0 (_current_state);
		_current_state = _tmp17_;
		tiles = (g_free (tiles), NULL);
	}
	_tmp18_ = _current_state;
	self = (Game*) g_object_new (object_type, "size", _size, "reverse", _reverse, "opening", _opening, "current-state", _tmp18_, "initial-number-of-tiles", _initial_number_of_tiles, "print-logs", _print_logs, NULL);
	_tmp19_ = _neighbor_tiles;
	_tmp19__length1 = _neighbor_tiles_length1;
	_tmp19__length2 = _neighbor_tiles_length2;
	_neighbor_tiles = NULL;
	_neighbor_tiles_length1 = 0;
	_neighbor_tiles_length2 = 0;
	self->priv->neighbor_tiles = (g_free (self->priv->neighbor_tiles), NULL);
	self->priv->neighbor_tiles = _tmp19_;
	self->priv->neighbor_tiles_length1 = _tmp19__length1;
	self->priv->neighbor_tiles_length2 = _tmp19__length2;
	_g_object_unref0 (_current_state);
	_neighbor_tiles = (g_free (_neighbor_tiles), NULL);
	return self;
}

Game*
game_new (gboolean _reverse,
          Opening _opening,
          guint8 _size,
          gboolean _print_logs)
{
	return game_construct (TYPE_GAME, _reverse, _opening, _size, _print_logs);
}

static inline void
game_setup_even_board (guint8 size,
                       Opening opening,
                       Player** tiles,
                       gint* tiles_length1,
                       gint* tiles_length2,
                       guint8* initial_number_of_tiles)
{
	guint8 _vala_initial_number_of_tiles = 0U;
	guint8 half_size = 0U;
	Player* start_position = NULL;
	gint start_position_length1 = 0;
	gint start_position_length2 = 0;
	Player* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	Player _tmp7_;
	Player* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	Player _tmp9_;
	Player* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	Player _tmp11_;
	Player* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	Player _tmp13_;
	half_size = (guint8) (size / 2);
	_vala_initial_number_of_tiles = (guint8) 4;
	switch (opening) {
		case OPENING_REVERSI:
		{
			Player* _tmp0_;
			_tmp0_ = g_new0 (Player, 2 * 2);
			_tmp0_[0] = PLAYER_LIGHT;
			_tmp0_[1] = PLAYER_DARK;
			_tmp0_[2] = PLAYER_DARK;
			_tmp0_[3] = PLAYER_LIGHT;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp0_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		case OPENING_INVERTED:
		{
			Player* _tmp1_;
			_tmp1_ = g_new0 (Player, 2 * 2);
			_tmp1_[0] = PLAYER_DARK;
			_tmp1_[1] = PLAYER_LIGHT;
			_tmp1_[2] = PLAYER_LIGHT;
			_tmp1_[3] = PLAYER_DARK;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp1_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		case OPENING_ALTER_TOP:
		{
			Player* _tmp2_;
			_tmp2_ = g_new0 (Player, 2 * 2);
			_tmp2_[0] = PLAYER_DARK;
			_tmp2_[1] = PLAYER_DARK;
			_tmp2_[2] = PLAYER_LIGHT;
			_tmp2_[3] = PLAYER_LIGHT;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp2_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		case OPENING_ALTER_LEFT:
		{
			Player* _tmp3_;
			_tmp3_ = g_new0 (Player, 2 * 2);
			_tmp3_[0] = PLAYER_DARK;
			_tmp3_[1] = PLAYER_LIGHT;
			_tmp3_[2] = PLAYER_DARK;
			_tmp3_[3] = PLAYER_LIGHT;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp3_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		case OPENING_ALTER_RIGHT:
		{
			Player* _tmp4_;
			_tmp4_ = g_new0 (Player, 2 * 2);
			_tmp4_[0] = PLAYER_LIGHT;
			_tmp4_[1] = PLAYER_DARK;
			_tmp4_[2] = PLAYER_LIGHT;
			_tmp4_[3] = PLAYER_DARK;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp4_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		case OPENING_ALTER_BOTTOM:
		{
			Player* _tmp5_;
			_tmp5_ = g_new0 (Player, 2 * 2);
			_tmp5_[0] = PLAYER_LIGHT;
			_tmp5_[1] = PLAYER_LIGHT;
			_tmp5_[2] = PLAYER_DARK;
			_tmp5_[3] = PLAYER_DARK;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp5_;
			start_position_length1 = 2;
			start_position_length2 = 2;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp6_ = start_position;
	_tmp6__length1 = start_position_length1;
	_tmp6__length2 = start_position_length2;
	_tmp7_ = _tmp6_[(0 * _tmp6__length2) + 0];
	(*tiles)[((half_size - 1) * (*tiles_length2)) + (half_size - 1)] = _tmp7_;
	_tmp8_ = start_position;
	_tmp8__length1 = start_position_length1;
	_tmp8__length2 = start_position_length2;
	_tmp9_ = _tmp8_[(0 * _tmp8__length2) + 1];
	(*tiles)[(half_size * (*tiles_length2)) + (half_size - 1)] = _tmp9_;
	_tmp10_ = start_position;
	_tmp10__length1 = start_position_length1;
	_tmp10__length2 = start_position_length2;
	_tmp11_ = _tmp10_[(1 * _tmp10__length2) + 0];
	(*tiles)[((half_size - 1) * (*tiles_length2)) + half_size] = _tmp11_;
	_tmp12_ = start_position;
	_tmp12__length1 = start_position_length1;
	_tmp12__length2 = start_position_length2;
	_tmp13_ = _tmp12_[(1 * _tmp12__length2) + 1];
	(*tiles)[(half_size * (*tiles_length2)) + half_size] = _tmp13_;
	start_position = (g_free (start_position), NULL);
	if (initial_number_of_tiles) {
		*initial_number_of_tiles = _vala_initial_number_of_tiles;
	}
}

static inline void
game_setup_odd_board (guint8 size,
                      Opening opening,
                      Player** tiles,
                      gint* tiles_length1,
                      gint* tiles_length2,
                      guint8* initial_number_of_tiles)
{
	guint8 _vala_initial_number_of_tiles = 0U;
	guint8 mid_board = 0U;
	gint _tmp0_ = 0;
	Player* start_position = NULL;
	gint start_position_length1 = 0;
	gint start_position_length2 = 0;
	Player* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	Player _tmp9_;
	Player* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	Player _tmp11_;
	Player* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	Player _tmp13_;
	Player* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	Player _tmp15_;
	Player* _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	Player _tmp17_;
	Player* _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
	Player _tmp19_;
	Player* _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	Player _tmp21_;
	Player* _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	Player _tmp23_;
	mid_board = (guint8) ((size - 1) / 2);
	if (opening == OPENING_HUMANS) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 7;
	}
	_vala_initial_number_of_tiles = (guint8) _tmp0_;
	switch (opening) {
		case OPENING_HUMANS:
		{
			Player* _tmp1_;
			_tmp1_ = g_new0 (Player, 3 * 3);
			_tmp1_[0] = PLAYER_NONE;
			_tmp1_[1] = PLAYER_NONE;
			_tmp1_[2] = PLAYER_NONE;
			_tmp1_[3] = PLAYER_NONE;
			_tmp1_[4] = PLAYER_DARK;
			_tmp1_[5] = PLAYER_NONE;
			_tmp1_[6] = PLAYER_NONE;
			_tmp1_[7] = PLAYER_NONE;
			_tmp1_[8] = PLAYER_NONE;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp1_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_REVERSI:
		{
			Player* _tmp2_;
			_tmp2_ = g_new0 (Player, 3 * 3);
			_tmp2_[0] = PLAYER_NONE;
			_tmp2_[1] = PLAYER_LIGHT;
			_tmp2_[2] = PLAYER_DARK;
			_tmp2_[3] = PLAYER_LIGHT;
			_tmp2_[4] = PLAYER_DARK;
			_tmp2_[5] = PLAYER_LIGHT;
			_tmp2_[6] = PLAYER_DARK;
			_tmp2_[7] = PLAYER_LIGHT;
			_tmp2_[8] = PLAYER_NONE;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp2_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_INVERTED:
		{
			Player* _tmp3_;
			_tmp3_ = g_new0 (Player, 3 * 3);
			_tmp3_[0] = PLAYER_DARK;
			_tmp3_[1] = PLAYER_LIGHT;
			_tmp3_[2] = PLAYER_NONE;
			_tmp3_[3] = PLAYER_LIGHT;
			_tmp3_[4] = PLAYER_DARK;
			_tmp3_[5] = PLAYER_LIGHT;
			_tmp3_[6] = PLAYER_NONE;
			_tmp3_[7] = PLAYER_LIGHT;
			_tmp3_[8] = PLAYER_DARK;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp3_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_ALTER_TOP:
		{
			Player* _tmp4_;
			_tmp4_ = g_new0 (Player, 3 * 3);
			_tmp4_[0] = PLAYER_NONE;
			_tmp4_[1] = PLAYER_DARK;
			_tmp4_[2] = PLAYER_LIGHT;
			_tmp4_[3] = PLAYER_LIGHT;
			_tmp4_[4] = PLAYER_DARK;
			_tmp4_[5] = PLAYER_LIGHT;
			_tmp4_[6] = PLAYER_LIGHT;
			_tmp4_[7] = PLAYER_DARK;
			_tmp4_[8] = PLAYER_NONE;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp4_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_ALTER_LEFT:
		{
			Player* _tmp5_;
			_tmp5_ = g_new0 (Player, 3 * 3);
			_tmp5_[0] = PLAYER_LIGHT;
			_tmp5_[1] = PLAYER_LIGHT;
			_tmp5_[2] = PLAYER_NONE;
			_tmp5_[3] = PLAYER_DARK;
			_tmp5_[4] = PLAYER_DARK;
			_tmp5_[5] = PLAYER_DARK;
			_tmp5_[6] = PLAYER_NONE;
			_tmp5_[7] = PLAYER_LIGHT;
			_tmp5_[8] = PLAYER_LIGHT;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp5_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_ALTER_RIGHT:
		{
			Player* _tmp6_;
			_tmp6_ = g_new0 (Player, 3 * 3);
			_tmp6_[0] = PLAYER_NONE;
			_tmp6_[1] = PLAYER_LIGHT;
			_tmp6_[2] = PLAYER_LIGHT;
			_tmp6_[3] = PLAYER_DARK;
			_tmp6_[4] = PLAYER_DARK;
			_tmp6_[5] = PLAYER_DARK;
			_tmp6_[6] = PLAYER_LIGHT;
			_tmp6_[7] = PLAYER_LIGHT;
			_tmp6_[8] = PLAYER_NONE;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp6_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		case OPENING_ALTER_BOTTOM:
		{
			Player* _tmp7_;
			_tmp7_ = g_new0 (Player, 3 * 3);
			_tmp7_[0] = PLAYER_LIGHT;
			_tmp7_[1] = PLAYER_DARK;
			_tmp7_[2] = PLAYER_NONE;
			_tmp7_[3] = PLAYER_LIGHT;
			_tmp7_[4] = PLAYER_DARK;
			_tmp7_[5] = PLAYER_LIGHT;
			_tmp7_[6] = PLAYER_NONE;
			_tmp7_[7] = PLAYER_DARK;
			_tmp7_[8] = PLAYER_LIGHT;
			start_position = (g_free (start_position), NULL);
			start_position = _tmp7_;
			start_position_length1 = 3;
			start_position_length2 = 3;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp8_ = start_position;
	_tmp8__length1 = start_position_length1;
	_tmp8__length2 = start_position_length2;
	_tmp9_ = _tmp8_[(0 * _tmp8__length2) + 0];
	(*tiles)[((mid_board - 1) * (*tiles_length2)) + (mid_board - 1)] = _tmp9_;
	_tmp10_ = start_position;
	_tmp10__length1 = start_position_length1;
	_tmp10__length2 = start_position_length2;
	_tmp11_ = _tmp10_[(0 * _tmp10__length2) + 1];
	(*tiles)[(mid_board * (*tiles_length2)) + (mid_board - 1)] = _tmp11_;
	_tmp12_ = start_position;
	_tmp12__length1 = start_position_length1;
	_tmp12__length2 = start_position_length2;
	_tmp13_ = _tmp12_[(0 * _tmp12__length2) + 2];
	(*tiles)[((mid_board + 1) * (*tiles_length2)) + (mid_board - 1)] = _tmp13_;
	_tmp14_ = start_position;
	_tmp14__length1 = start_position_length1;
	_tmp14__length2 = start_position_length2;
	_tmp15_ = _tmp14_[(1 * _tmp14__length2) + 0];
	(*tiles)[((mid_board - 1) * (*tiles_length2)) + mid_board] = _tmp15_;
	(*tiles)[(mid_board * (*tiles_length2)) + mid_board] = PLAYER_DARK;
	_tmp16_ = start_position;
	_tmp16__length1 = start_position_length1;
	_tmp16__length2 = start_position_length2;
	_tmp17_ = _tmp16_[(1 * _tmp16__length2) + 2];
	(*tiles)[((mid_board + 1) * (*tiles_length2)) + mid_board] = _tmp17_;
	_tmp18_ = start_position;
	_tmp18__length1 = start_position_length1;
	_tmp18__length2 = start_position_length2;
	_tmp19_ = _tmp18_[(2 * _tmp18__length2) + 0];
	(*tiles)[((mid_board - 1) * (*tiles_length2)) + (mid_board + 1)] = _tmp19_;
	_tmp20_ = start_position;
	_tmp20__length1 = start_position_length1;
	_tmp20__length2 = start_position_length2;
	_tmp21_ = _tmp20_[(2 * _tmp20__length2) + 1];
	(*tiles)[(mid_board * (*tiles_length2)) + (mid_board + 1)] = _tmp21_;
	_tmp22_ = start_position;
	_tmp22__length1 = start_position_length1;
	_tmp22__length2 = start_position_length2;
	_tmp23_ = _tmp22_[(2 * _tmp22__length2) + 2];
	(*tiles)[((mid_board + 1) * (*tiles_length2)) + (mid_board + 1)] = _tmp23_;
	start_position = (g_free (start_position), NULL);
	if (initial_number_of_tiles) {
		*initial_number_of_tiles = _vala_initial_number_of_tiles;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

Game*
game_construct_from_strings (GType object_type,
                             gchar** setup,
                             gint setup_length1,
                             Player to_move,
                             gboolean _reverse,
                             guint8 _size,
                             gboolean _print_logs)
{
	Game * self = NULL;
	guint8* _neighbor_tiles = NULL;
	gint _neighbor_tiles_length1 = 0;
	gint _neighbor_tiles_length2 = 0;
	guint8* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Player* tiles = NULL;
	Player* _tmp3_;
	gint tiles_length1;
	gint tiles_length2;
	GameStateObject* _current_state = NULL;
	Player* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	guint8* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	GameStateObject* _tmp15_;
	gint _tmp16_ = 0;
	GameStateObject* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	_vala_return_val_if_fail (((gint) _size) >= 4, "_size >= 4", NULL);
	_vala_return_val_if_fail (((gint) _size) <= 16, "_size <= 16", NULL);
	_vala_return_val_if_fail (to_move != PLAYER_NONE, "to_move != Player.NONE", NULL);
	_vala_return_val_if_fail (setup_length1 == ((gint) _size), "setup.length == _size", NULL);
	game_init_neighbor_tiles (_size, &_tmp0_, &_tmp1_, &_tmp2_);
	_neighbor_tiles = (g_free (_neighbor_tiles), NULL);
	_neighbor_tiles = _tmp0_;
	_neighbor_tiles_length1 = _tmp1_;
	_neighbor_tiles_length2 = _tmp2_;
	_tmp3_ = g_new0 (Player, _size * _size);
	tiles = _tmp3_;
	tiles_length1 = _size;
	tiles_length2 = _size;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp4_) {
					guint8 _tmp5_;
					_tmp5_ = y;
					y = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(y < _size)) {
					break;
				}
				_tmp6_ = setup[y];
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ != (_size * 2)) {
					g_warn_if_reached ();
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							Player* _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							const gchar* _tmp12_;
							if (!_tmp9_) {
								guint8 _tmp10_;
								_tmp10_ = x;
								x = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							if (!(x < _size)) {
								break;
							}
							_tmp11_ = tiles;
							_tmp11__length1 = tiles_length1;
							_tmp11__length2 = tiles_length2;
							_tmp12_ = setup[y];
							_tmp11_[(x * _tmp11__length2) + y] = player_from_char (string_get (_tmp12_, (glong) ((x * 2) + 1)));
						}
					}
				}
			}
		}
	}
	_tmp13_ = tiles;
	_tmp13__length1 = tiles_length1;
	_tmp13__length2 = tiles_length2;
	_tmp14_ = _neighbor_tiles;
	_tmp14__length1 = _neighbor_tiles_length1;
	_tmp14__length2 = _neighbor_tiles_length2;
	_tmp15_ = game_state_object_new_from_grid (_size, _tmp13_, _tmp13__length1, _tmp13__length2, to_move, _tmp14_, _tmp14__length1, _tmp14__length2, FALSE);
	_current_state = _tmp15_;
	if ((_size % 2) == 0) {
		_tmp16_ = 4;
	} else {
		_tmp16_ = 7;
	}
	_tmp17_ = _current_state;
	self = (Game*) g_object_new (object_type, "size", _size, "reverse", _reverse, "opening", OPENING_REVERSI, "current-state", _tmp17_, "initial-number-of-tiles", _tmp16_, "print-logs", _print_logs, NULL);
	_tmp18_ = _neighbor_tiles;
	_tmp18__length1 = _neighbor_tiles_length1;
	_tmp18__length2 = _neighbor_tiles_length2;
	_neighbor_tiles = NULL;
	_neighbor_tiles_length1 = 0;
	_neighbor_tiles_length2 = 0;
	self->priv->neighbor_tiles = (g_free (self->priv->neighbor_tiles), NULL);
	self->priv->neighbor_tiles = _tmp18_;
	self->priv->neighbor_tiles_length1 = _tmp18__length1;
	self->priv->neighbor_tiles_length2 = _tmp18__length2;
	_tmp19_ = _vala_g_strjoinv ("\n", (gchar**) setup, (gint) ((setup_length1 * sizeof (gchar*)) / sizeof (gchar*)));
	_tmp20_ = _tmp19_;
	_tmp21_ = string_strip (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = game_to_string (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_strip (_tmp24_);
	_tmp26_ = _tmp25_;
	g_warn_if_fail (g_strcmp0 (_tmp22_, _tmp26_) == 0);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_object_unref0 (_current_state);
	tiles = (g_free (tiles), NULL);
	_neighbor_tiles = (g_free (_neighbor_tiles), NULL);
	return self;
}

Game*
game_new_from_strings (gchar** setup,
                       gint setup_length1,
                       Player to_move,
                       gboolean _reverse,
                       guint8 _size,
                       gboolean _print_logs)
{
	return game_construct_from_strings (TYPE_GAME, setup, setup_length1, to_move, _reverse, _size, _print_logs);
}

Player
game_get_owner (Game* self,
                guint8 x,
                guint8 y)
{
	GameStateObject* _tmp0_;
	Player result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_state;
	result = game_state_object_get_owner (_tmp0_, x, y);
	return result;
}

gchar*
game_to_string (Game* self)
{
	GameStateObject* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_to_string (_tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
game_place_tile (Game* self,
                 guint8 x,
                 guint8 y)
{
	Opening _tmp0_;
	PossibleMove move = {0};
	GameStateObject* _tmp1_;
	PossibleMove _tmp2_ = {0};
	gboolean _tmp3_;
	gboolean _tmp4_;
	GameStateObject* _tmp17_;
	PossibleMove _tmp18_;
	GameStateObject* _tmp19_;
	GameStateObject* _tmp20_;
	GListStore* _tmp21_;
	GameStateObject* _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_opening;
	if (_tmp0_ == OPENING_HUMANS) {
		result = game_humans_opening_place_tile (self, x, y);
		return result;
	}
	_tmp1_ = self->priv->_current_state;
	_tmp3_ = game_state_object_test_placing_tile (_tmp1_, x, y, &_tmp2_);
	move = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_print_logs;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		Player _tmp6_;
		Player _tmp7_;
		gchar* current_color_string = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp6_ = game_get_current_color (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == PLAYER_DARK) {
			_tmp5_ = "dark :";
		} else {
			_tmp5_ = "light:";
		}
		_tmp8_ = g_strdup (_tmp5_);
		current_color_string = _tmp8_;
		_tmp9_ = current_color_string;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strdup_printf ("%hhu", x);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%hhu", y);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp10_, " (", _tmp12_, ", ", _tmp14_, ")\n", NULL);
		_tmp16_ = _tmp15_;
		g_print ("%s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (current_color_string);
	}
	_tmp17_ = self->priv->_current_state;
	_tmp18_ = move;
	_tmp19_ = game_state_object_new_copy_and_move (_tmp17_, &_tmp18_);
	_tmp20_ = _tmp19_;
	game_set_current_state (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->undo_stack;
	_tmp22_ = self->priv->_current_state;
	g_list_store_append (_tmp21_, (GObject*) _tmp22_);
	game_end_of_turn (self, FALSE, FALSE);
	result = TRUE;
	return result;
}

gboolean
game_pass (Game* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GameStateObject* _tmp5_;
	GameStateObject* _tmp6_;
	GameStateObject* _tmp7_;
	GListStore* _tmp8_;
	GameStateObject* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_get_current_player_can_move (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_print_logs;
	if (_tmp2_) {
		Player _tmp3_;
		Player _tmp4_;
		_tmp3_ = game_get_current_color (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == PLAYER_DARK) {
			g_print ("dark : pass\n");
		} else {
			g_print ("light: pass\n");
		}
	}
	_tmp5_ = self->priv->_current_state;
	_tmp6_ = game_state_object_new_copy_and_pass (_tmp5_);
	_tmp7_ = _tmp6_;
	game_set_current_state (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->undo_stack;
	_tmp9_ = self->priv->_current_state;
	g_list_store_append (_tmp8_, (GObject*) _tmp9_);
	game_end_of_turn (self, FALSE, TRUE);
	result = TRUE;
	return result;
}

static void
game_end_of_turn (Game* self,
                  gboolean undoing,
                  gboolean no_draw)
{
	GameStateObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	game_update_possible_moves (self);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_is_complete (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, game_signals[GAME_COMPLETENESS_UPDATED_SIGNAL], 0, _tmp2_);
	g_signal_emit (self, game_signals[GAME_TURN_ENDED_SIGNAL], 0, undoing, no_draw);
}

void
game_undo (Game* self,
           guint8 count)
{
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint undo_stack_n_items = 0U;
	GListStore* _tmp2_;
	GObject* tmp_current_state = NULL;
	GListStore* _tmp3_;
	GObject* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GObject* _tmp6_;
	GObject* _tmp8_;
	GListStore* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((((gint) count) == 1) || (((gint) count) == 2), "count == 1 || count == 2");
	_tmp0_ = game_get_number_of_moves (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ >= count, "number_of_moves >= count");
	_tmp2_ = self->priv->undo_stack;
	undo_stack_n_items = g_list_model_get_n_items ((GListModel*) _tmp2_);
	_tmp3_ = self->priv->undo_stack;
	_tmp4_ = g_list_model_get_object ((GListModel*) _tmp3_, undo_stack_n_items - 2);
	tmp_current_state = _tmp4_;
	_tmp6_ = tmp_current_state;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GObject* _tmp7_;
		_tmp7_ = tmp_current_state;
		_tmp5_ = !IS_GAME_STATE_OBJECT (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject));
	}
	if (_tmp5_) {
		g_assert_not_reached ();
	}
	_tmp8_ = tmp_current_state;
	game_set_current_state (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G_TYPE_OBJECT, GObject), TYPE_GAME_STATE_OBJECT, GameStateObject));
	_tmp9_ = self->priv->undo_stack;
	g_list_store_remove (_tmp9_, undo_stack_n_items - 1);
	if (((gint) count) == 1) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = game_get_current_player_can_move (self);
		_tmp12_ = _tmp11_;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		game_end_of_turn (self, TRUE, FALSE);
	} else {
		if (((gint) count) == 2) {
			game_end_of_turn (self, TRUE, TRUE);
			game_undo (self, (guint8) (count - 1));
		}
	}
	_g_object_unref0 (tmp_current_state);
}

static guint8*
_vala_array_dup15 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

guint8*
game_copy_neighbor_tiles (Game* self,
                          gint* result_length1,
                          gint* result_length2)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->neighbor_tiles;
	_tmp0__length1 = self->priv->neighbor_tiles_length1;
	_tmp0__length2 = self->priv->neighbor_tiles_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup15 (_tmp0_, _tmp0__length1 * _tmp0__length2) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}

static void
game_init_neighbor_tiles (guint8 size,
                          guint8** neighbor_tiles,
                          gint* neighbor_tiles_length1,
                          gint* neighbor_tiles_length2)
{
	guint8* _vala_neighbor_tiles = NULL;
	gint _vala_neighbor_tiles_length1 = 0;
	gint _vala_neighbor_tiles_length2 = 0;
	guint8* _tmp0_;
	guint8 max = 0U;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	_tmp0_ = g_new0 (guint8, size * size);
	_vala_neighbor_tiles = (g_free (_vala_neighbor_tiles), NULL);
	_vala_neighbor_tiles = _tmp0_;
	_vala_neighbor_tiles_length1 = size;
	_vala_neighbor_tiles_length2 = size;
	max = (guint8) (size - 1);
	{
		guint8 i = 0U;
		i = (guint8) 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint8* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				guint8* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				guint8* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				guint8* _tmp6_;
				gint _tmp6__length1;
				gint _tmp6__length2;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < max)) {
					break;
				}
				_tmp3_ = _vala_neighbor_tiles;
				_tmp3__length1 = _vala_neighbor_tiles_length1;
				_tmp3__length2 = _vala_neighbor_tiles_length2;
				_tmp3_[(i * _tmp3__length2) + 0] = (guint8) 5;
				_tmp4_ = _vala_neighbor_tiles;
				_tmp4__length1 = _vala_neighbor_tiles_length1;
				_tmp4__length2 = _vala_neighbor_tiles_length2;
				_tmp4_[(i * _tmp4__length2) + max] = (guint8) 5;
				_tmp5_ = _vala_neighbor_tiles;
				_tmp5__length1 = _vala_neighbor_tiles_length1;
				_tmp5__length2 = _vala_neighbor_tiles_length2;
				_tmp5_[(0 * _tmp5__length2) + i] = (guint8) 5;
				_tmp6_ = _vala_neighbor_tiles;
				_tmp6__length1 = _vala_neighbor_tiles_length1;
				_tmp6__length2 = _vala_neighbor_tiles_length2;
				_tmp6_[(max * _tmp6__length2) + i] = (guint8) 5;
				{
					guint8 j = 0U;
					j = (guint8) 1;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							guint8* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							if (!_tmp7_) {
								guint8 _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							if (!(j < max)) {
								break;
							}
							_tmp9_ = _vala_neighbor_tiles;
							_tmp9__length1 = _vala_neighbor_tiles_length1;
							_tmp9__length2 = _vala_neighbor_tiles_length2;
							_tmp9_[(i * _tmp9__length2) + j] = (guint8) 8;
						}
					}
				}
			}
		}
	}
	_tmp10_ = _vala_neighbor_tiles;
	_tmp10__length1 = _vala_neighbor_tiles_length1;
	_tmp10__length2 = _vala_neighbor_tiles_length2;
	_tmp10_[(0 * _tmp10__length2) + 0] = (guint8) 3;
	_tmp11_ = _vala_neighbor_tiles;
	_tmp11__length1 = _vala_neighbor_tiles_length1;
	_tmp11__length2 = _vala_neighbor_tiles_length2;
	_tmp11_[(0 * _tmp11__length2) + max] = (guint8) 3;
	_tmp12_ = _vala_neighbor_tiles;
	_tmp12__length1 = _vala_neighbor_tiles_length1;
	_tmp12__length2 = _vala_neighbor_tiles_length2;
	_tmp12_[(max * _tmp12__length2) + max] = (guint8) 3;
	_tmp13_ = _vala_neighbor_tiles;
	_tmp13__length1 = _vala_neighbor_tiles_length1;
	_tmp13__length2 = _vala_neighbor_tiles_length2;
	_tmp13_[(max * _tmp13__length2) + 0] = (guint8) 3;
	if (neighbor_tiles) {
		*neighbor_tiles = _vala_neighbor_tiles;
	} else {
		_vala_neighbor_tiles = (g_free (_vala_neighbor_tiles), NULL);
	}
	if (neighbor_tiles_length1) {
		*neighbor_tiles_length1 = _vala_neighbor_tiles_length1;
	}
	if (neighbor_tiles_length2) {
		*neighbor_tiles_length2 = _vala_neighbor_tiles_length2;
	}
}

gboolean
game_test_placing_tile (Game* self,
                        guint8 x,
                        guint8 y,
                        PossibleMove* move)
{
	PossibleMove _vala_move = {0};
	Opening _tmp0_;
	GSList* test_move = NULL;
	GSList* _tmp1_;
	GSList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_opening;
	if (_tmp0_ == OPENING_HUMANS) {
		possible_move_init (&_vala_move, x, y);
		result = game_humans_opening_test_placing_tile (self, x, y);
		if (move) {
			*move = _vala_move;
		}
		return result;
	}
	_tmp1_ = self->priv->possible_moves;
	_tmp2_ = g_slist_nth (_tmp1_, (guint) 0);
	test_move = _tmp2_;
	while (TRUE) {
		GSList* _tmp3_;
		GSList* _tmp4_;
		gconstpointer _tmp5_;
		gboolean _tmp6_ = FALSE;
		PossibleMove _tmp7_;
		GSList* _tmp9_;
		GSList* _tmp10_;
		_tmp3_ = test_move;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = test_move;
		_tmp5_ = ((GSList*) _tmp4_)->data;
		_vala_move = (PossibleMove) (*((PossibleMove*) _tmp5_));
		_tmp7_ = _vala_move;
		if (_tmp7_.x == x) {
			PossibleMove _tmp8_;
			_tmp8_ = _vala_move;
			_tmp6_ = _tmp8_.y == y;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			if (move) {
				*move = _vala_move;
			}
			return result;
		}
		_tmp9_ = test_move;
		_tmp10_ = ((GSList*) _tmp9_)->next;
		test_move = _tmp10_;
	}
	result = FALSE;
	if (move) {
		*move = _vala_move;
	}
	return result;
}

static PossibleMove*
__lambda15_ (Game* self,
             PossibleMove* a)
{
	PossibleMove* _tmp0_;
	PossibleMove* result;
	_tmp0_ = _possible_move_dup0 (a);
	result = _tmp0_;
	return result;
}

static gpointer
___lambda15__gcopy_func (gconstpointer src,
                         gpointer self)
{
	gpointer result;
	result = __lambda15_ ((Game*) self, (PossibleMove*) src);
	return result;
}

void
game_get_possible_moves (Game* self,
                         GSList** moves)
{
	GSList* _vala_moves = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->possible_moves;
	_tmp1_ = g_slist_copy_deep (_tmp0_, ___lambda15__gcopy_func, self);
	(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	_vala_moves = _tmp1_;
	if (moves) {
		*moves = _vala_moves;
	} else {
		(_vala_moves == NULL) ? NULL : (_vala_moves = (_g_slist_free__possible_move_free0_ (_vala_moves), NULL));
	}
}

static inline void
game_update_possible_moves (Game* self)
{
	Opening _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opening;
	if (_tmp0_ == OPENING_HUMANS) {
		game_humans_opening_update_possible_moves (self);
	} else {
		GameStateObject* _tmp1_;
		GSList* _tmp2_ = NULL;
		_tmp1_ = self->priv->_current_state;
		game_state_object_get_possible_moves (_tmp1_, &_tmp2_);
		(self->priv->possible_moves == NULL) ? NULL : (self->priv->possible_moves = (_g_slist_free__possible_move_free0_ (self->priv->possible_moves), NULL));
		self->priv->possible_moves = _tmp2_;
	}
}

static inline gboolean
game_humans_opening_place_tile (Game* self,
                                guint8 x,
                                guint8 y)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	gboolean even_board = FALSE;
	guint8 _tmp1_;
	gint _tmp46_ = 0;
	guint8 _tmp47_;
	guint8 _tmp48_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	_tmp1_ = self->priv->_size;
	even_board = (_tmp1_ % 2) == 0;
	if (!game_humans_opening_test_placing_tile (self, x, y)) {
		result = FALSE;
		return result;
	}
	if (even_board) {
		GameStateObject* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		gboolean _tmp5_;
		GameStateObject* _tmp18_;
		GameStateObject* _tmp19_;
		GameStateObject* _tmp20_;
		_tmp2_ = self->priv->_current_state;
		_tmp3_ = game_state_object_get_n_dark_tiles (_tmp2_);
		_tmp4_ = _tmp3_;
		if (((gint) _tmp4_) == 2) {
			game_humans_opening_update_opening_even (self);
		}
		_tmp5_ = self->priv->_print_logs;
		if (_tmp5_) {
			const gchar* _tmp6_ = NULL;
			Player _tmp7_;
			Player _tmp8_;
			gchar* current_color_string = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp7_ = game_get_current_color (self);
			_tmp8_ = _tmp7_;
			if (_tmp8_ == PLAYER_DARK) {
				_tmp6_ = "dark :";
			} else {
				_tmp6_ = "light:";
			}
			_tmp9_ = g_strdup (_tmp6_);
			current_color_string = _tmp9_;
			_tmp10_ = current_color_string;
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strdup_printf ("%hhu", x);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("%hhu", y);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp11_, " (", _tmp13_, ", ", _tmp15_, ")\n", NULL);
			_tmp17_ = _tmp16_;
			g_print ("%s", _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (current_color_string);
		}
		_tmp18_ = self->priv->_current_state;
		_tmp19_ = game_state_object_new_copy_and_add (_tmp18_, x, y);
		_tmp20_ = _tmp19_;
		game_set_current_state (self, _tmp20_);
		_g_object_unref0 (_tmp20_);
	} else {
		gboolean _tmp21_ = FALSE;
		Player _tmp22_;
		Player _tmp23_;
		guint8 x2 = 0U;
		guint8 y2 = 0U;
		gboolean _tmp26_;
		GameStateObject* _tmp43_;
		GameStateObject* _tmp44_;
		GameStateObject* _tmp45_;
		_tmp22_ = game_get_current_color (self);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == PLAYER_LIGHT) {
			guint8 _tmp24_;
			guint8 _tmp25_;
			_tmp24_ = game_get_n_light_tiles (self);
			_tmp25_ = _tmp24_;
			_tmp21_ = ((gint) _tmp25_) != 0;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			game_humans_opening_update_opening_odd (self, x, y);
		}
		if (x == half_game_size) {
			x2 = half_game_size;
		} else {
			if (((gint) x) == (half_game_size - 1)) {
				x2 = (guint8) (half_game_size + 1);
			} else {
				x2 = (guint8) (half_game_size - 1);
			}
		}
		if (y == half_game_size) {
			y2 = half_game_size;
		} else {
			if (((gint) y) == (half_game_size - 1)) {
				y2 = (guint8) (half_game_size + 1);
			} else {
				y2 = (guint8) (half_game_size - 1);
			}
		}
		_tmp26_ = self->priv->_print_logs;
		if (_tmp26_) {
			const gchar* _tmp27_ = NULL;
			Player _tmp28_;
			Player _tmp29_;
			gchar* current_color_string = NULL;
			gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp28_ = game_get_current_color (self);
			_tmp29_ = _tmp28_;
			if (_tmp29_ == PLAYER_DARK) {
				_tmp27_ = "dark :";
			} else {
				_tmp27_ = "light:";
			}
			_tmp30_ = g_strdup (_tmp27_);
			current_color_string = _tmp30_;
			_tmp31_ = current_color_string;
			_tmp32_ = string_to_string (_tmp31_);
			_tmp33_ = g_strdup_printf ("%hhu", x);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strdup_printf ("%hhu", y);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strdup_printf ("%hhu", x2);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf ("%hhu", y2);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp32_, " (", _tmp34_, ", ", _tmp36_, ") and (", _tmp38_, ", ", _tmp40_, ")\n", NULL);
			_tmp42_ = _tmp41_;
			g_print ("%s", _tmp42_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (current_color_string);
		}
		_tmp43_ = self->priv->_current_state;
		_tmp44_ = game_state_object_new_copy_and_add_two (_tmp43_, x, y, x2, y2);
		_tmp45_ = _tmp44_;
		game_set_current_state (self, _tmp45_);
		_g_object_unref0 (_tmp45_);
	}
	if (even_board) {
		_tmp46_ = 2;
	} else {
		_tmp46_ = 4;
	}
	_tmp47_ = game_get_n_light_tiles (self);
	_tmp48_ = _tmp47_;
	if (((gint) _tmp48_) == _tmp46_) {
		GListStore* _tmp49_;
		GListStore* _tmp50_;
		GameStateObject* _tmp51_;
		_tmp49_ = self->priv->undo_stack;
		g_list_store_remove (_tmp49_, (guint) 0);
		_tmp50_ = self->priv->undo_stack;
		_tmp51_ = self->priv->_current_state;
		g_list_store_append (_tmp50_, (GObject*) _tmp51_);
	}
	game_end_of_turn (self, FALSE, FALSE);
	result = TRUE;
	return result;
}

static inline void
game_humans_opening_update_opening_even (Game* self)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	if (game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_DARK) {
		if (game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_DARK) {
			game_set_opening (self, OPENING_ALTER_TOP);
		} else {
			if (game_get_owner (self, half_game_size, half_game_size) == PLAYER_DARK) {
				game_set_opening (self, OPENING_REVERSI);
			} else {
				game_set_opening (self, OPENING_ALTER_LEFT);
			}
		}
	} else {
		if (game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_LIGHT) {
			game_set_opening (self, OPENING_ALTER_BOTTOM);
		} else {
			if (game_get_owner (self, half_game_size, half_game_size) == PLAYER_DARK) {
				game_set_opening (self, OPENING_ALTER_RIGHT);
			} else {
				game_set_opening (self, OPENING_INVERTED);
			}
		}
	}
}

static inline void
game_humans_opening_update_opening_odd (Game* self,
                                        guint8 x,
                                        guint8 y)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	if (x == half_game_size) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y == half_game_size;
	}
	if (_tmp1_) {
		if (game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE) {
			game_set_opening (self, OPENING_REVERSI);
		} else {
			game_set_opening (self, OPENING_INVERTED);
		}
	} else {
		if (x == y) {
			if (game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_LIGHT) {
				game_set_opening (self, OPENING_ALTER_LEFT);
			} else {
				game_set_opening (self, OPENING_ALTER_BOTTOM);
			}
		} else {
			if (game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_LIGHT) {
				game_set_opening (self, OPENING_ALTER_RIGHT);
			} else {
				game_set_opening (self, OPENING_ALTER_TOP);
			}
		}
	}
}

static gboolean
game_humans_opening_test_placing_tile (Game* self,
                                       guint8 x,
                                       guint8 y)
{
	guint8 _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (game_get_owner (self, x, y) != PLAYER_NONE) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_size;
	if ((_tmp0_ % 2) == 0) {
		result = game_humans_opening_test_placing_tile_even (self, x, y);
		return result;
	} else {
		result = game_humans_opening_test_placing_tile_odd (self, x, y);
		return result;
	}
}

static inline gboolean
game_humans_opening_test_placing_tile_even (Game* self,
                                            guint8 x,
                                            guint8 y)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Player _tmp5_;
	Player _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	if (((gint) x) < (half_game_size - 1)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = x > half_game_size;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = ((gint) y) < (half_game_size - 1);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y > half_game_size;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = game_get_current_color (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == PLAYER_LIGHT) {
		guint8 _tmp7_;
		guint8 _tmp8_;
		_tmp7_ = game_get_n_light_tiles (self);
		_tmp8_ = _tmp7_;
		_tmp4_ = ((gint) _tmp8_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint _tmp9_ = 0;
		guint8 opposite_x = 0U;
		gint _tmp10_ = 0;
		guint8 opposite_y = 0U;
		if (x == half_game_size) {
			_tmp9_ = half_game_size - 1;
		} else {
			_tmp9_ = (gint) half_game_size;
		}
		opposite_x = (guint8) _tmp9_;
		if (y == half_game_size) {
			_tmp10_ = half_game_size - 1;
		} else {
			_tmp10_ = (gint) half_game_size;
		}
		opposite_y = (guint8) _tmp10_;
		if (game_get_owner (self, opposite_x, opposite_y) == PLAYER_DARK) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static inline gboolean
game_humans_opening_test_placing_tile_odd (Game* self,
                                           guint8 x,
                                           guint8 y)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Player _tmp4_;
	Player _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	if (((gint) x) < (half_game_size - 1)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = ((gint) x) > (half_game_size + 1);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = ((gint) y) < (half_game_size - 1);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ((gint) y) > (half_game_size + 1);
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = game_get_current_color (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == PLAYER_LIGHT) {
		guint8 _tmp6_;
		guint8 _tmp7_;
		_tmp6_ = game_get_n_light_tiles (self);
		_tmp7_ = _tmp6_;
		if (((gint) _tmp7_) == 0) {
			gboolean _tmp8_ = FALSE;
			if (x != half_game_size) {
				_tmp8_ = y != half_game_size;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp9_ = FALSE;
			if (game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) != PLAYER_NONE) {
				_tmp9_ = TRUE;
			} else {
				_tmp9_ = game_get_owner (self, (guint8) (half_game_size + 1), (guint8) (half_game_size - 1)) != PLAYER_NONE;
			}
			if (_tmp9_) {
				gboolean _tmp10_ = FALSE;
				if (x != half_game_size) {
					_tmp10_ = y != half_game_size;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static inline void
game_humans_opening_update_possible_moves (Game* self)
{
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_size;
	if ((_tmp0_ % 2) == 0) {
		game_humans_opening_update_possible_moves_even (self);
	} else {
		game_humans_opening_update_possible_moves_odd (self);
	}
}

static inline void
game_humans_opening_update_possible_moves_even (Game* self)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	gboolean top_left = FALSE;
	gboolean top_right = FALSE;
	gboolean bottom_left = FALSE;
	gboolean bottom_right = FALSE;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_;
	Player _tmp3_;
	g_return_if_fail (self != NULL);
	(self->priv->possible_moves == NULL) ? NULL : (self->priv->possible_moves = (_g_slist_free__possible_move_free0_ (self->priv->possible_moves), NULL));
	self->priv->possible_moves = NULL;
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	_tmp2_ = game_get_current_color (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_LIGHT) {
		guint8 _tmp4_;
		guint8 _tmp5_;
		_tmp4_ = game_get_n_light_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = ((gint) _tmp5_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp6_ = FALSE;
		if (game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE) {
			_tmp6_ = game_get_owner (self, half_game_size, half_game_size) == PLAYER_NONE;
		} else {
			_tmp6_ = FALSE;
		}
		top_left = _tmp6_;
		top_right = !top_left;
		bottom_left = !top_left;
		bottom_right = top_left;
	} else {
		top_left = game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE;
		top_right = game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_NONE;
		bottom_left = game_get_owner (self, (guint8) (half_game_size - 1), half_game_size) == PLAYER_NONE;
		bottom_right = game_get_owner (self, half_game_size, half_game_size) == PLAYER_NONE;
	}
	if (top_left) {
		PossibleMove _tmp7_ = {0};
		PossibleMove* _tmp8_;
		possible_move_init (&_tmp7_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1));
		_tmp8_ = _possible_move_dup0 (&_tmp7_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp8_);
	}
	if (top_right) {
		PossibleMove _tmp9_ = {0};
		PossibleMove* _tmp10_;
		possible_move_init (&_tmp9_, half_game_size, (guint8) (half_game_size - 1));
		_tmp10_ = _possible_move_dup0 (&_tmp9_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp10_);
	}
	if (bottom_left) {
		PossibleMove _tmp11_ = {0};
		PossibleMove* _tmp12_;
		possible_move_init (&_tmp11_, (guint8) (half_game_size - 1), half_game_size);
		_tmp12_ = _possible_move_dup0 (&_tmp11_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp12_);
	}
	if (bottom_right) {
		PossibleMove _tmp13_ = {0};
		PossibleMove* _tmp14_;
		possible_move_init (&_tmp13_, half_game_size, half_game_size);
		_tmp14_ = _possible_move_dup0 (&_tmp13_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp14_);
	}
}

static inline void
game_humans_opening_update_possible_moves_odd (Game* self)
{
	guint8 half_game_size = 0U;
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	g_return_if_fail (self != NULL);
	(self->priv->possible_moves == NULL) ? NULL : (self->priv->possible_moves = (_g_slist_free__possible_move_free0_ (self->priv->possible_moves), NULL));
	self->priv->possible_moves = NULL;
	_tmp0_ = self->priv->_size;
	half_game_size = (guint8) (_tmp0_ / 2);
	_tmp1_ = game_get_n_light_tiles (self);
	_tmp2_ = _tmp1_;
	if (((gint) _tmp2_) == 0) {
		PossibleMove _tmp3_ = {0};
		PossibleMove* _tmp4_;
		PossibleMove _tmp5_ = {0};
		PossibleMove* _tmp6_;
		PossibleMove _tmp7_ = {0};
		PossibleMove* _tmp8_;
		PossibleMove _tmp9_ = {0};
		PossibleMove* _tmp10_;
		possible_move_init (&_tmp3_, (guint8) (half_game_size - 1), half_game_size);
		_tmp4_ = _possible_move_dup0 (&_tmp3_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp4_);
		possible_move_init (&_tmp5_, half_game_size, (guint8) (half_game_size - 1));
		_tmp6_ = _possible_move_dup0 (&_tmp5_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp6_);
		possible_move_init (&_tmp7_, half_game_size, (guint8) (half_game_size + 1));
		_tmp8_ = _possible_move_dup0 (&_tmp7_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp8_);
		possible_move_init (&_tmp9_, (guint8) (half_game_size + 1), half_game_size);
		_tmp10_ = _possible_move_dup0 (&_tmp9_);
		self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp10_);
	} else {
		Player _tmp11_;
		Player _tmp12_;
		_tmp11_ = game_get_current_color (self);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == PLAYER_DARK) {
			{
				guint8 x = 0U;
				x = (guint8) (half_game_size - 1);
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						if (!_tmp13_) {
							guint8 _tmp14_;
							_tmp14_ = x;
							x = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						if (!(((gint) x) <= (half_game_size + 1))) {
							break;
						}
						{
							guint8 y = 0U;
							y = (guint8) (half_game_size - 1);
							{
								gboolean _tmp15_ = FALSE;
								_tmp15_ = TRUE;
								while (TRUE) {
									if (!_tmp15_) {
										guint8 _tmp16_;
										_tmp16_ = y;
										y = _tmp16_ + 1;
									}
									_tmp15_ = FALSE;
									if (!(((gint) y) <= (half_game_size + 1))) {
										break;
									}
									if (game_get_owner (self, x, y) == PLAYER_NONE) {
										PossibleMove _tmp17_ = {0};
										PossibleMove* _tmp18_;
										possible_move_init (&_tmp17_, x, y);
										_tmp18_ = _possible_move_dup0 (&_tmp17_);
										self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp18_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			gboolean _tmp19_ = FALSE;
			if (game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1)) == PLAYER_NONE) {
				_tmp19_ = game_get_owner (self, (guint8) (half_game_size - 1), (guint8) (half_game_size + 1)) == PLAYER_NONE;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				PossibleMove _tmp20_ = {0};
				PossibleMove* _tmp21_;
				PossibleMove _tmp22_ = {0};
				PossibleMove* _tmp23_;
				PossibleMove _tmp24_ = {0};
				PossibleMove* _tmp25_;
				PossibleMove _tmp26_ = {0};
				PossibleMove* _tmp27_;
				possible_move_init (&_tmp20_, (guint8) (half_game_size - 1), (guint8) (half_game_size - 1));
				_tmp21_ = _possible_move_dup0 (&_tmp20_);
				self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp21_);
				possible_move_init (&_tmp22_, (guint8) (half_game_size - 1), (guint8) (half_game_size + 1));
				_tmp23_ = _possible_move_dup0 (&_tmp22_);
				self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp23_);
				possible_move_init (&_tmp24_, (guint8) (half_game_size + 1), (guint8) (half_game_size - 1));
				_tmp25_ = _possible_move_dup0 (&_tmp24_);
				self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp25_);
				possible_move_init (&_tmp26_, (guint8) (half_game_size + 1), (guint8) (half_game_size + 1));
				_tmp27_ = _possible_move_dup0 (&_tmp26_);
				self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp27_);
			} else {
				if (game_get_owner (self, half_game_size, (guint8) (half_game_size - 1)) == PLAYER_NONE) {
					PossibleMove _tmp28_ = {0};
					PossibleMove* _tmp29_;
					PossibleMove _tmp30_ = {0};
					PossibleMove* _tmp31_;
					possible_move_init (&_tmp28_, half_game_size, (guint8) (half_game_size - 1));
					_tmp29_ = _possible_move_dup0 (&_tmp28_);
					self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp29_);
					possible_move_init (&_tmp30_, half_game_size, (guint8) (half_game_size + 1));
					_tmp31_ = _possible_move_dup0 (&_tmp30_);
					self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp31_);
				} else {
					PossibleMove _tmp32_ = {0};
					PossibleMove* _tmp33_;
					PossibleMove _tmp34_ = {0};
					PossibleMove* _tmp35_;
					possible_move_init (&_tmp32_, (guint8) (half_game_size - 1), half_game_size);
					_tmp33_ = _possible_move_dup0 (&_tmp32_);
					self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp33_);
					possible_move_init (&_tmp34_, (guint8) (half_game_size + 1), half_game_size);
					_tmp35_ = _possible_move_dup0 (&_tmp34_);
					self->priv->possible_moves = g_slist_prepend (self->priv->possible_moves, _tmp35_);
				}
			}
		}
	}
}

guint8
game_get_number_of_moves (Game* self)
{
	guint8 result;
	guint n_items = 0U;
	GListStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->undo_stack;
	n_items = g_list_model_get_n_items ((GListModel*) _tmp0_);
	if (n_items == ((guint) 0)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = n_items >= ((guint) 256);
	}
	if (_tmp1_) {
		g_assert_not_reached ();
	}
	result = (guint8) (n_items - 1);
	return result;
}

guint8
game_get_size (Game* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_size;
	return result;
}

static void
game_set_size (Game* self,
               guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
}

gboolean
game_get_reverse (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reverse;
	return result;
}

static void
game_set_reverse (Game* self,
                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_reverse = value;
}

Opening
game_get_opening (Game* self)
{
	Opening result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_opening;
	return result;
}

void
game_set_opening (Game* self,
                  Opening value)
{
	g_return_if_fail (self != NULL);
	self->priv->_opening = value;
}

GameStateObject*
game_get_current_state (Game* self)
{
	GameStateObject* result;
	GameStateObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_state;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
game_set_current_state (Game* self,
                        GameStateObject* value)
{
	GameStateObject* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_state);
	self->priv->_current_state = _tmp0_;
}

guint8
game_get_initial_number_of_tiles (Game* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_initial_number_of_tiles;
	return result;
}

static void
game_set_initial_number_of_tiles (Game* self,
                                  guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_initial_number_of_tiles = value;
}

gboolean
game_get_print_logs (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_print_logs;
	return result;
}

static void
game_set_print_logs (Game* self,
                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_print_logs = value;
}

gboolean
game_get_is_complete (Game* self)
{
	gboolean result;
	GameStateObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_is_complete (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint8
game_get_n_light_tiles (Game* self)
{
	guint8 result;
	GameStateObject* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint8
game_get_n_dark_tiles (Game* self)
{
	guint8 result;
	GameStateObject* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_n_dark_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
game_get_current_player_can_move (Game* self)
{
	gboolean result;
	GameStateObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_current_player_can_move (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

Player
game_get_current_color (Game* self)
{
	Player result;
	GameStateObject* _tmp0_;
	Player _tmp1_;
	Player _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_state;
	_tmp1_ = game_state_object_get_current_color (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static GObject *
game_constructor (GType type,
                  guint n_construct_properties,
                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Game * self;
	GListStore* _tmp0_;
	GameStateObject* _tmp1_;
	gboolean _tmp2_;
	parent_class = G_OBJECT_CLASS (game_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_tmp0_ = self->priv->undo_stack;
	_tmp1_ = self->priv->_current_state;
	g_list_store_append (_tmp0_, (GObject*) _tmp1_);
	game_update_possible_moves (self);
	_tmp2_ = self->priv->_print_logs;
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* e_or_i = NULL;
		gchar* _tmp5_;
		guint8 _tmp6_;
		_tmp4_ = self->priv->_reverse;
		if (_tmp4_) {
			_tmp3_ = "e";
		} else {
			_tmp3_ = "i";
		}
		_tmp5_ = g_strdup (_tmp3_);
		e_or_i = _tmp5_;
		_tmp6_ = self->priv->_initial_number_of_tiles;
		if (((gint) _tmp6_) <= 1) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = e_or_i;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = g_strconcat ("\nnew two-player revers", _tmp8_, " game\n", NULL);
			_tmp10_ = _tmp9_;
			g_print ("%s", _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			Opening _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = e_or_i;
			_tmp12_ = string_to_string (_tmp11_);
			_tmp13_ = self->priv->_opening;
			_tmp14_ = opening_to_string (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat ("\nnew one-player revers", _tmp12_, " game (", _tmp15_, " opening)\n", NULL);
			_tmp17_ = _tmp16_;
			g_print ("%s", _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
		}
		_g_free0 (e_or_i);
	}
	return obj;
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_NUMBER_OF_MOVES_PROPERTY, game_properties[GAME_NUMBER_OF_MOVES_PROPERTY] = g_param_spec_uchar ("number-of-moves", "number-of-moves", "number-of-moves", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_uchar ("size", "size", "size", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_REVERSE_PROPERTY, game_properties[GAME_REVERSE_PROPERTY] = g_param_spec_boolean ("reverse", "reverse", "reverse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_OPENING_PROPERTY, game_properties[GAME_OPENING_PROPERTY] = g_param_spec_enum ("opening", "opening", "opening", TYPE_OPENING, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_STATE_PROPERTY, game_properties[GAME_CURRENT_STATE_PROPERTY] = g_param_spec_object ("current-state", "current-state", "current-state", TYPE_GAME_STATE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_INITIAL_NUMBER_OF_TILES_PROPERTY, game_properties[GAME_INITIAL_NUMBER_OF_TILES_PROPERTY] = g_param_spec_uchar ("initial-number-of-tiles", "initial-number-of-tiles", "initial-number-of-tiles", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PRINT_LOGS_PROPERTY, game_properties[GAME_PRINT_LOGS_PROPERTY] = g_param_spec_boolean ("print-logs", "print-logs", "print-logs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_IS_COMPLETE_PROPERTY, game_properties[GAME_IS_COMPLETE_PROPERTY] = g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_LIGHT_TILES_PROPERTY, game_properties[GAME_N_LIGHT_TILES_PROPERTY] = g_param_spec_uchar ("n-light-tiles", "n-light-tiles", "n-light-tiles", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_DARK_TILES_PROPERTY, game_properties[GAME_N_DARK_TILES_PROPERTY] = g_param_spec_uchar ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY, game_properties[GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY] = g_param_spec_boolean ("current-player-can-move", "current-player-can-move", "current-player-can-move", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_COLOR_PROPERTY, game_properties[GAME_CURRENT_COLOR_PROPERTY] = g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	game_signals[GAME_TURN_ENDED_SIGNAL] = g_signal_new ("turn-ended", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	game_signals[GAME_COMPLETENESS_UPDATED_SIGNAL] = g_signal_new ("completeness-updated", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	GListStore* _tmp0_;
	self->priv = game_get_instance_private (self);
	_tmp0_ = g_list_store_new (TYPE_GAME_STATE_OBJECT);
	self->priv->undo_stack = _tmp0_;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->priv->undo_stack);
	_g_object_unref0 (self->priv->_current_state);
	self->priv->neighbor_tiles = (g_free (self->priv->neighbor_tiles), NULL);
	(self->priv->possible_moves == NULL) ? NULL : (self->priv->possible_moves = (_g_slist_free__possible_move_free0_ (self->priv->possible_moves), NULL));
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

static GType
game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
	GType game_type_id;
	game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
	Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
	return game_type_id;
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__once = 0;
	if (g_once_init_enter (&game_type_id__once)) {
		GType game_type_id;
		game_type_id = game_get_type_once ();
		g_once_init_leave (&game_type_id__once, game_type_id);
	}
	return game_type_id__once;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_NUMBER_OF_MOVES_PROPERTY:
		g_value_set_uchar (value, game_get_number_of_moves (self));
		break;
		case GAME_SIZE_PROPERTY:
		g_value_set_uchar (value, game_get_size (self));
		break;
		case GAME_REVERSE_PROPERTY:
		g_value_set_boolean (value, game_get_reverse (self));
		break;
		case GAME_OPENING_PROPERTY:
		g_value_set_enum (value, game_get_opening (self));
		break;
		case GAME_CURRENT_STATE_PROPERTY:
		g_value_set_object (value, game_get_current_state (self));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		g_value_set_uchar (value, game_get_initial_number_of_tiles (self));
		break;
		case GAME_PRINT_LOGS_PROPERTY:
		g_value_set_boolean (value, game_get_print_logs (self));
		break;
		case GAME_IS_COMPLETE_PROPERTY:
		g_value_set_boolean (value, game_get_is_complete (self));
		break;
		case GAME_N_LIGHT_TILES_PROPERTY:
		g_value_set_uchar (value, game_get_n_light_tiles (self));
		break;
		case GAME_N_DARK_TILES_PROPERTY:
		g_value_set_uchar (value, game_get_n_dark_tiles (self));
		break;
		case GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		g_value_set_boolean (value, game_get_current_player_can_move (self));
		break;
		case GAME_CURRENT_COLOR_PROPERTY:
		g_value_set_enum (value, game_get_current_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_uchar (value));
		break;
		case GAME_REVERSE_PROPERTY:
		game_set_reverse (self, g_value_get_boolean (value));
		break;
		case GAME_OPENING_PROPERTY:
		game_set_opening (self, g_value_get_enum (value));
		break;
		case GAME_CURRENT_STATE_PROPERTY:
		game_set_current_state (self, g_value_get_object (value));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		game_set_initial_number_of_tiles (self, g_value_get_uchar (value));
		break;
		case GAME_PRINT_LOGS_PROPERTY:
		game_set_print_logs (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
opening_to_string (Opening self)
{
	gchar* result;
	switch (self) {
		case OPENING_HUMANS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("humans");
			result = _tmp0_;
			return result;
		}
		case OPENING_REVERSI:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("reversi");
			result = _tmp1_;
			return result;
		}
		case OPENING_INVERTED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("inverted");
			result = _tmp2_;
			return result;
		}
		case OPENING_ALTER_TOP:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("alter-top");
			result = _tmp3_;
			return result;
		}
		case OPENING_ALTER_LEFT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("alter-left");
			result = _tmp4_;
			return result;
		}
		case OPENING_ALTER_RIGHT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("alter-right");
			result = _tmp5_;
			return result;
		}
		case OPENING_ALTER_BOTTOM:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("alter-bottom");
			result = _tmp6_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
opening_get_type_once (void)
{
	static const GEnumValue values[] = {{OPENING_HUMANS, "OPENING_HUMANS", "humans"}, {OPENING_REVERSI, "OPENING_REVERSI", "reversi"}, {OPENING_INVERTED, "OPENING_INVERTED", "inverted"}, {OPENING_ALTER_TOP, "OPENING_ALTER_TOP", "alter-top"}, {OPENING_ALTER_LEFT, "OPENING_ALTER_LEFT", "alter-left"}, {OPENING_ALTER_RIGHT, "OPENING_ALTER_RIGHT", "alter-right"}, {OPENING_ALTER_BOTTOM, "OPENING_ALTER_BOTTOM", "alter-bottom"}, {0, NULL, NULL}};
	GType opening_type_id;
	opening_type_id = g_enum_register_static ("Opening", values);
	return opening_type_id;
}

GType
opening_get_type (void)
{
	static volatile gsize opening_type_id__once = 0;
	if (g_once_init_enter (&opening_type_id__once)) {
		GType opening_type_id;
		opening_type_id = opening_get_type_once ();
		g_once_init_leave (&opening_type_id__once, opening_type_id);
	}
	return opening_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

