//
// Copyright (c) 2021-2024 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
#pragma once




// This part allows Orochi.h to be included by the device kernel code to compile, and use generic oro** names.
// TODO: make this list exhaustive by auto-generating it with Orochi Summoner.
#if defined(__CUDACC__)
	typedef cudaMipmappedArray_t oroMipmappedArray_t;
	typedef cudaTextureObject_t oroTextureObject_t;
	typedef cudaSurfaceObject_t oroSurfaceObject_t;
#elif defined(__HIPCC__)
	typedef hipMipmappedArray_t oroMipmappedArray_t;
	typedef hipTextureObject_t oroTextureObject_t;
	typedef hipSurfaceObject_t oroSurfaceObject_t;
#else





#include "../contrib/hipew/include/hipew.h"


#define OROAPI HIPAPI
#define ORO_CB HIP_CB


#pragma region OROCHI_SUMMONER_REGION_orochi_h

/////
///// THIS REGION HAS BEEN AUTOMATICALLY GENERATED BY OROCHI SUMMONER.
///// Manual modification of this region is not recommended.
/////

typedef hipDeviceArch_t oroDeviceArch_t;
typedef hipUUID_t oroUUID_t;
typedef hipUUID oroUUID;
typedef hipDeviceProp_tR0600 oroDeviceProp_tR0600;
typedef hipMemoryType oroMemoryType;
	const hipMemoryType oroMemoryTypeUnregistered = hipMemoryTypeUnregistered;
	const hipMemoryType oroMemoryTypeHost = hipMemoryTypeHost;
	const hipMemoryType oroMemoryTypeDevice = hipMemoryTypeDevice;
	const hipMemoryType oroMemoryTypeManaged = hipMemoryTypeManaged;
	const hipMemoryType oroMemoryTypeArray = hipMemoryTypeArray;
	const hipMemoryType oroMemoryTypeUnified = hipMemoryTypeUnified;
typedef hipPointerAttribute_t oroPointerAttribute_t;
typedef hipError_t oroError_t;
	const hipError_t oroSuccess = hipSuccess;
	const hipError_t oroErrorInvalidValue = hipErrorInvalidValue;
	const hipError_t oroErrorOutOfMemory = hipErrorOutOfMemory;
	const hipError_t oroErrorMemoryAllocation = hipErrorMemoryAllocation;
	const hipError_t oroErrorNotInitialized = hipErrorNotInitialized;
	const hipError_t oroErrorInitializationError = hipErrorInitializationError;
	const hipError_t oroErrorDeinitialized = hipErrorDeinitialized;
	const hipError_t oroErrorProfilerDisabled = hipErrorProfilerDisabled;
	const hipError_t oroErrorProfilerNotInitialized = hipErrorProfilerNotInitialized;
	const hipError_t oroErrorProfilerAlreadyStarted = hipErrorProfilerAlreadyStarted;
	const hipError_t oroErrorProfilerAlreadyStopped = hipErrorProfilerAlreadyStopped;
	const hipError_t oroErrorInvalidConfiguration = hipErrorInvalidConfiguration;
	const hipError_t oroErrorInvalidPitchValue = hipErrorInvalidPitchValue;
	const hipError_t oroErrorInvalidSymbol = hipErrorInvalidSymbol;
	const hipError_t oroErrorInvalidDevicePointer = hipErrorInvalidDevicePointer;
	const hipError_t oroErrorInvalidMemcpyDirection = hipErrorInvalidMemcpyDirection;
	const hipError_t oroErrorInsufficientDriver = hipErrorInsufficientDriver;
	const hipError_t oroErrorMissingConfiguration = hipErrorMissingConfiguration;
	const hipError_t oroErrorPriorLaunchFailure = hipErrorPriorLaunchFailure;
	const hipError_t oroErrorInvalidDeviceFunction = hipErrorInvalidDeviceFunction;
	const hipError_t oroErrorNoDevice = hipErrorNoDevice;
	const hipError_t oroErrorInvalidDevice = hipErrorInvalidDevice;
	const hipError_t oroErrorInvalidImage = hipErrorInvalidImage;
	const hipError_t oroErrorInvalidContext = hipErrorInvalidContext;
	const hipError_t oroErrorContextAlreadyCurrent = hipErrorContextAlreadyCurrent;
	const hipError_t oroErrorMapFailed = hipErrorMapFailed;
	const hipError_t oroErrorMapBufferObjectFailed = hipErrorMapBufferObjectFailed;
	const hipError_t oroErrorUnmapFailed = hipErrorUnmapFailed;
	const hipError_t oroErrorArrayIsMapped = hipErrorArrayIsMapped;
	const hipError_t oroErrorAlreadyMapped = hipErrorAlreadyMapped;
	const hipError_t oroErrorNoBinaryForGpu = hipErrorNoBinaryForGpu;
	const hipError_t oroErrorAlreadyAcquired = hipErrorAlreadyAcquired;
	const hipError_t oroErrorNotMapped = hipErrorNotMapped;
	const hipError_t oroErrorNotMappedAsArray = hipErrorNotMappedAsArray;
	const hipError_t oroErrorNotMappedAsPointer = hipErrorNotMappedAsPointer;
	const hipError_t oroErrorECCNotCorrectable = hipErrorECCNotCorrectable;
	const hipError_t oroErrorUnsupportedLimit = hipErrorUnsupportedLimit;
	const hipError_t oroErrorContextAlreadyInUse = hipErrorContextAlreadyInUse;
	const hipError_t oroErrorPeerAccessUnsupported = hipErrorPeerAccessUnsupported;
	const hipError_t oroErrorInvalidKernelFile = hipErrorInvalidKernelFile;
	const hipError_t oroErrorInvalidGraphicsContext = hipErrorInvalidGraphicsContext;
	const hipError_t oroErrorInvalidSource = hipErrorInvalidSource;
	const hipError_t oroErrorFileNotFound = hipErrorFileNotFound;
	const hipError_t oroErrorSharedObjectSymbolNotFound = hipErrorSharedObjectSymbolNotFound;
	const hipError_t oroErrorSharedObjectInitFailed = hipErrorSharedObjectInitFailed;
	const hipError_t oroErrorOperatingSystem = hipErrorOperatingSystem;
	const hipError_t oroErrorInvalidHandle = hipErrorInvalidHandle;
	const hipError_t oroErrorInvalidResourceHandle = hipErrorInvalidResourceHandle;
	const hipError_t oroErrorIllegalState = hipErrorIllegalState;
	const hipError_t oroErrorNotFound = hipErrorNotFound;
	const hipError_t oroErrorNotReady = hipErrorNotReady;
	const hipError_t oroErrorIllegalAddress = hipErrorIllegalAddress;
	const hipError_t oroErrorLaunchOutOfResources = hipErrorLaunchOutOfResources;
	const hipError_t oroErrorLaunchTimeOut = hipErrorLaunchTimeOut;
	const hipError_t oroErrorPeerAccessAlreadyEnabled = hipErrorPeerAccessAlreadyEnabled;
	const hipError_t oroErrorPeerAccessNotEnabled = hipErrorPeerAccessNotEnabled;
	const hipError_t oroErrorSetOnActiveProcess = hipErrorSetOnActiveProcess;
	const hipError_t oroErrorContextIsDestroyed = hipErrorContextIsDestroyed;
	const hipError_t oroErrorAssert = hipErrorAssert;
	const hipError_t oroErrorHostMemoryAlreadyRegistered = hipErrorHostMemoryAlreadyRegistered;
	const hipError_t oroErrorHostMemoryNotRegistered = hipErrorHostMemoryNotRegistered;
	const hipError_t oroErrorLaunchFailure = hipErrorLaunchFailure;
	const hipError_t oroErrorCooperativeLaunchTooLarge = hipErrorCooperativeLaunchTooLarge;
	const hipError_t oroErrorNotSupported = hipErrorNotSupported;
	const hipError_t oroErrorStreamCaptureUnsupported = hipErrorStreamCaptureUnsupported;
	const hipError_t oroErrorStreamCaptureInvalidated = hipErrorStreamCaptureInvalidated;
	const hipError_t oroErrorStreamCaptureMerge = hipErrorStreamCaptureMerge;
	const hipError_t oroErrorStreamCaptureUnmatched = hipErrorStreamCaptureUnmatched;
	const hipError_t oroErrorStreamCaptureUnjoined = hipErrorStreamCaptureUnjoined;
	const hipError_t oroErrorStreamCaptureIsolation = hipErrorStreamCaptureIsolation;
	const hipError_t oroErrorStreamCaptureImplicit = hipErrorStreamCaptureImplicit;
	const hipError_t oroErrorCapturedEvent = hipErrorCapturedEvent;
	const hipError_t oroErrorStreamCaptureWrongThread = hipErrorStreamCaptureWrongThread;
	const hipError_t oroErrorGraphExecUpdateFailure = hipErrorGraphExecUpdateFailure;
	const hipError_t oroErrorUnknown = hipErrorUnknown;
	const hipError_t oroErrorRuntimeMemory = hipErrorRuntimeMemory;
	const hipError_t oroErrorRuntimeOther = hipErrorRuntimeOther;
	const hipError_t oroErrorTbd = hipErrorTbd;
typedef hipDeviceAttribute_t oroDeviceAttribute_t;
	const hipDeviceAttribute_t oroDeviceAttributeCudaCompatibleBegin = hipDeviceAttributeCudaCompatibleBegin;
	const hipDeviceAttribute_t oroDeviceAttributeEccEnabled = hipDeviceAttributeEccEnabled;
	const hipDeviceAttribute_t oroDeviceAttributeAccessPolicyMaxWindowSize = hipDeviceAttributeAccessPolicyMaxWindowSize;
	const hipDeviceAttribute_t oroDeviceAttributeAsyncEngineCount = hipDeviceAttributeAsyncEngineCount;
	const hipDeviceAttribute_t oroDeviceAttributeCanMapHostMemory = hipDeviceAttributeCanMapHostMemory;
	const hipDeviceAttribute_t oroDeviceAttributeCanUseHostPointerForRegisteredMem = hipDeviceAttributeCanUseHostPointerForRegisteredMem;
	const hipDeviceAttribute_t oroDeviceAttributeClockRate = hipDeviceAttributeClockRate;
	const hipDeviceAttribute_t oroDeviceAttributeComputeMode = hipDeviceAttributeComputeMode;
	const hipDeviceAttribute_t oroDeviceAttributeComputePreemptionSupported = hipDeviceAttributeComputePreemptionSupported;
	const hipDeviceAttribute_t oroDeviceAttributeConcurrentKernels = hipDeviceAttributeConcurrentKernels;
	const hipDeviceAttribute_t oroDeviceAttributeConcurrentManagedAccess = hipDeviceAttributeConcurrentManagedAccess;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeLaunch = hipDeviceAttributeCooperativeLaunch;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeMultiDeviceLaunch = hipDeviceAttributeCooperativeMultiDeviceLaunch;
	const hipDeviceAttribute_t oroDeviceAttributeDeviceOverlap = hipDeviceAttributeDeviceOverlap;
	const hipDeviceAttribute_t oroDeviceAttributeDirectManagedMemAccessFromHost = hipDeviceAttributeDirectManagedMemAccessFromHost;
	const hipDeviceAttribute_t oroDeviceAttributeGlobalL1CacheSupported = hipDeviceAttributeGlobalL1CacheSupported;
	const hipDeviceAttribute_t oroDeviceAttributeHostNativeAtomicSupported = hipDeviceAttributeHostNativeAtomicSupported;
	const hipDeviceAttribute_t oroDeviceAttributeIntegrated = hipDeviceAttributeIntegrated;
	const hipDeviceAttribute_t oroDeviceAttributeIsMultiGpuBoard = hipDeviceAttributeIsMultiGpuBoard;
	const hipDeviceAttribute_t oroDeviceAttributeKernelExecTimeout = hipDeviceAttributeKernelExecTimeout;
	const hipDeviceAttribute_t oroDeviceAttributeL2CacheSize = hipDeviceAttributeL2CacheSize;
	const hipDeviceAttribute_t oroDeviceAttributeLocalL1CacheSupported = hipDeviceAttributeLocalL1CacheSupported;
	const hipDeviceAttribute_t oroDeviceAttributeLuid = hipDeviceAttributeLuid;
	const hipDeviceAttribute_t oroDeviceAttributeLuidDeviceNodeMask = hipDeviceAttributeLuidDeviceNodeMask;
	const hipDeviceAttribute_t oroDeviceAttributeComputeCapabilityMajor = hipDeviceAttributeComputeCapabilityMajor;
	const hipDeviceAttribute_t oroDeviceAttributeManagedMemory = hipDeviceAttributeManagedMemory;
	const hipDeviceAttribute_t oroDeviceAttributeMaxBlocksPerMultiProcessor = hipDeviceAttributeMaxBlocksPerMultiProcessor;
	const hipDeviceAttribute_t oroDeviceAttributeMaxBlockDimX = hipDeviceAttributeMaxBlockDimX;
	const hipDeviceAttribute_t oroDeviceAttributeMaxBlockDimY = hipDeviceAttributeMaxBlockDimY;
	const hipDeviceAttribute_t oroDeviceAttributeMaxBlockDimZ = hipDeviceAttributeMaxBlockDimZ;
	const hipDeviceAttribute_t oroDeviceAttributeMaxGridDimX = hipDeviceAttributeMaxGridDimX;
	const hipDeviceAttribute_t oroDeviceAttributeMaxGridDimY = hipDeviceAttributeMaxGridDimY;
	const hipDeviceAttribute_t oroDeviceAttributeMaxGridDimZ = hipDeviceAttributeMaxGridDimZ;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurface1D = hipDeviceAttributeMaxSurface1D;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurface1DLayered = hipDeviceAttributeMaxSurface1DLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurface2D = hipDeviceAttributeMaxSurface2D;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurface2DLayered = hipDeviceAttributeMaxSurface2DLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurface3D = hipDeviceAttributeMaxSurface3D;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurfaceCubemap = hipDeviceAttributeMaxSurfaceCubemap;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSurfaceCubemapLayered = hipDeviceAttributeMaxSurfaceCubemapLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture1DWidth = hipDeviceAttributeMaxTexture1DWidth;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture1DLayered = hipDeviceAttributeMaxTexture1DLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture1DLinear = hipDeviceAttributeMaxTexture1DLinear;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture1DMipmap = hipDeviceAttributeMaxTexture1DMipmap;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DWidth = hipDeviceAttributeMaxTexture2DWidth;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DHeight = hipDeviceAttributeMaxTexture2DHeight;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DGather = hipDeviceAttributeMaxTexture2DGather;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DLayered = hipDeviceAttributeMaxTexture2DLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DLinear = hipDeviceAttributeMaxTexture2DLinear;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture2DMipmap = hipDeviceAttributeMaxTexture2DMipmap;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture3DWidth = hipDeviceAttributeMaxTexture3DWidth;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture3DHeight = hipDeviceAttributeMaxTexture3DHeight;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture3DDepth = hipDeviceAttributeMaxTexture3DDepth;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTexture3DAlt = hipDeviceAttributeMaxTexture3DAlt;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTextureCubemap = hipDeviceAttributeMaxTextureCubemap;
	const hipDeviceAttribute_t oroDeviceAttributeMaxTextureCubemapLayered = hipDeviceAttributeMaxTextureCubemapLayered;
	const hipDeviceAttribute_t oroDeviceAttributeMaxThreadsDim = hipDeviceAttributeMaxThreadsDim;
	const hipDeviceAttribute_t oroDeviceAttributeMaxThreadsPerBlock = hipDeviceAttributeMaxThreadsPerBlock;
	const hipDeviceAttribute_t oroDeviceAttributeMaxThreadsPerMultiProcessor = hipDeviceAttributeMaxThreadsPerMultiProcessor;
	const hipDeviceAttribute_t oroDeviceAttributeMaxPitch = hipDeviceAttributeMaxPitch;
	const hipDeviceAttribute_t oroDeviceAttributeMemoryBusWidth = hipDeviceAttributeMemoryBusWidth;
	const hipDeviceAttribute_t oroDeviceAttributeMemoryClockRate = hipDeviceAttributeMemoryClockRate;
	const hipDeviceAttribute_t oroDeviceAttributeComputeCapabilityMinor = hipDeviceAttributeComputeCapabilityMinor;
	const hipDeviceAttribute_t oroDeviceAttributeMultiGpuBoardGroupID = hipDeviceAttributeMultiGpuBoardGroupID;
	const hipDeviceAttribute_t oroDeviceAttributeMultiprocessorCount = hipDeviceAttributeMultiprocessorCount;
	const hipDeviceAttribute_t oroDeviceAttributeUnused1 = hipDeviceAttributeUnused1;
	const hipDeviceAttribute_t oroDeviceAttributePageableMemoryAccess = hipDeviceAttributePageableMemoryAccess;
	const hipDeviceAttribute_t oroDeviceAttributePageableMemoryAccessUsesHostPageTables = hipDeviceAttributePageableMemoryAccessUsesHostPageTables;
	const hipDeviceAttribute_t oroDeviceAttributePciBusId = hipDeviceAttributePciBusId;
	const hipDeviceAttribute_t oroDeviceAttributePciDeviceId = hipDeviceAttributePciDeviceId;
	const hipDeviceAttribute_t oroDeviceAttributePciDomainID = hipDeviceAttributePciDomainID;
	const hipDeviceAttribute_t oroDeviceAttributePersistingL2CacheMaxSize = hipDeviceAttributePersistingL2CacheMaxSize;
	const hipDeviceAttribute_t oroDeviceAttributeMaxRegistersPerBlock = hipDeviceAttributeMaxRegistersPerBlock;
	const hipDeviceAttribute_t oroDeviceAttributeMaxRegistersPerMultiprocessor = hipDeviceAttributeMaxRegistersPerMultiprocessor;
	const hipDeviceAttribute_t oroDeviceAttributeReservedSharedMemPerBlock = hipDeviceAttributeReservedSharedMemPerBlock;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSharedMemoryPerBlock = hipDeviceAttributeMaxSharedMemoryPerBlock;
	const hipDeviceAttribute_t oroDeviceAttributeSharedMemPerBlockOptin = hipDeviceAttributeSharedMemPerBlockOptin;
	const hipDeviceAttribute_t oroDeviceAttributeSharedMemPerMultiprocessor = hipDeviceAttributeSharedMemPerMultiprocessor;
	const hipDeviceAttribute_t oroDeviceAttributeSingleToDoublePrecisionPerfRatio = hipDeviceAttributeSingleToDoublePrecisionPerfRatio;
	const hipDeviceAttribute_t oroDeviceAttributeStreamPrioritiesSupported = hipDeviceAttributeStreamPrioritiesSupported;
	const hipDeviceAttribute_t oroDeviceAttributeSurfaceAlignment = hipDeviceAttributeSurfaceAlignment;
	const hipDeviceAttribute_t oroDeviceAttributeTccDriver = hipDeviceAttributeTccDriver;
	const hipDeviceAttribute_t oroDeviceAttributeTextureAlignment = hipDeviceAttributeTextureAlignment;
	const hipDeviceAttribute_t oroDeviceAttributeTexturePitchAlignment = hipDeviceAttributeTexturePitchAlignment;
	const hipDeviceAttribute_t oroDeviceAttributeTotalConstantMemory = hipDeviceAttributeTotalConstantMemory;
	const hipDeviceAttribute_t oroDeviceAttributeTotalGlobalMem = hipDeviceAttributeTotalGlobalMem;
	const hipDeviceAttribute_t oroDeviceAttributeUnifiedAddressing = hipDeviceAttributeUnifiedAddressing;
	const hipDeviceAttribute_t oroDeviceAttributeUnused2 = hipDeviceAttributeUnused2;
	const hipDeviceAttribute_t oroDeviceAttributeWarpSize = hipDeviceAttributeWarpSize;
	const hipDeviceAttribute_t oroDeviceAttributeMemoryPoolsSupported = hipDeviceAttributeMemoryPoolsSupported;
	const hipDeviceAttribute_t oroDeviceAttributeVirtualMemoryManagementSupported = hipDeviceAttributeVirtualMemoryManagementSupported;
	const hipDeviceAttribute_t oroDeviceAttributeHostRegisterSupported = hipDeviceAttributeHostRegisterSupported;
	const hipDeviceAttribute_t oroDeviceAttributeCudaCompatibleEnd = hipDeviceAttributeCudaCompatibleEnd;
	const hipDeviceAttribute_t oroDeviceAttributeAmdSpecificBegin = hipDeviceAttributeAmdSpecificBegin;
	const hipDeviceAttribute_t oroDeviceAttributeClockInstructionRate = hipDeviceAttributeClockInstructionRate;
	const hipDeviceAttribute_t oroDeviceAttributeUnused3 = hipDeviceAttributeUnused3;
	const hipDeviceAttribute_t oroDeviceAttributeMaxSharedMemoryPerMultiprocessor = hipDeviceAttributeMaxSharedMemoryPerMultiprocessor;
	const hipDeviceAttribute_t oroDeviceAttributeUnused4 = hipDeviceAttributeUnused4;
	const hipDeviceAttribute_t oroDeviceAttributeUnused5 = hipDeviceAttributeUnused5;
	const hipDeviceAttribute_t oroDeviceAttributeHdpMemFlushCntl = hipDeviceAttributeHdpMemFlushCntl;
	const hipDeviceAttribute_t oroDeviceAttributeHdpRegFlushCntl = hipDeviceAttributeHdpRegFlushCntl;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeMultiDeviceUnmatchedFunc = hipDeviceAttributeCooperativeMultiDeviceUnmatchedFunc;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeMultiDeviceUnmatchedGridDim = hipDeviceAttributeCooperativeMultiDeviceUnmatchedGridDim;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeMultiDeviceUnmatchedBlockDim = hipDeviceAttributeCooperativeMultiDeviceUnmatchedBlockDim;
	const hipDeviceAttribute_t oroDeviceAttributeCooperativeMultiDeviceUnmatchedSharedMem = hipDeviceAttributeCooperativeMultiDeviceUnmatchedSharedMem;
	const hipDeviceAttribute_t oroDeviceAttributeIsLargeBar = hipDeviceAttributeIsLargeBar;
	const hipDeviceAttribute_t oroDeviceAttributeAsicRevision = hipDeviceAttributeAsicRevision;
	const hipDeviceAttribute_t oroDeviceAttributeCanUseStreamWaitValue = hipDeviceAttributeCanUseStreamWaitValue;
	const hipDeviceAttribute_t oroDeviceAttributeImageSupport = hipDeviceAttributeImageSupport;
	const hipDeviceAttribute_t oroDeviceAttributePhysicalMultiProcessorCount = hipDeviceAttributePhysicalMultiProcessorCount;
	const hipDeviceAttribute_t oroDeviceAttributeFineGrainSupport = hipDeviceAttributeFineGrainSupport;
	const hipDeviceAttribute_t oroDeviceAttributeWallClockRate = hipDeviceAttributeWallClockRate;
	const hipDeviceAttribute_t oroDeviceAttributeAmdSpecificEnd = hipDeviceAttributeAmdSpecificEnd;
	const hipDeviceAttribute_t oroDeviceAttributeVendorSpecificBegin = hipDeviceAttributeVendorSpecificBegin;
typedef hipComputeMode oroComputeMode;
	const hipComputeMode oroComputeModeDefault = hipComputeModeDefault;
	const hipComputeMode oroComputeModeExclusive = hipComputeModeExclusive;
	const hipComputeMode oroComputeModeProhibited = hipComputeModeProhibited;
	const hipComputeMode oroComputeModeExclusiveProcess = hipComputeModeExclusiveProcess;
typedef hipFlushGPUDirectRDMAWritesOptions oroFlushGPUDirectRDMAWritesOptions;
	const hipFlushGPUDirectRDMAWritesOptions oroFlushGPUDirectRDMAWritesOptionHost = hipFlushGPUDirectRDMAWritesOptionHost;
	const hipFlushGPUDirectRDMAWritesOptions oroFlushGPUDirectRDMAWritesOptionMemOps = hipFlushGPUDirectRDMAWritesOptionMemOps;
typedef hipGPUDirectRDMAWritesOrdering oroGPUDirectRDMAWritesOrdering;
	const hipGPUDirectRDMAWritesOrdering oroGPUDirectRDMAWritesOrderingNone = hipGPUDirectRDMAWritesOrderingNone;
	const hipGPUDirectRDMAWritesOrdering oroGPUDirectRDMAWritesOrderingOwner = hipGPUDirectRDMAWritesOrderingOwner;
	const hipGPUDirectRDMAWritesOrdering oroGPUDirectRDMAWritesOrderingAllDevices = hipGPUDirectRDMAWritesOrderingAllDevices;
typedef hipDeviceptr_t oroDeviceptr_t;
typedef hipChannelFormatKind oroChannelFormatKind;
	const hipChannelFormatKind oroChannelFormatKindSigned = hipChannelFormatKindSigned;
	const hipChannelFormatKind oroChannelFormatKindUnsigned = hipChannelFormatKindUnsigned;
	const hipChannelFormatKind oroChannelFormatKindFloat = hipChannelFormatKindFloat;
	const hipChannelFormatKind oroChannelFormatKindNone = hipChannelFormatKindNone;
typedef hipChannelFormatDesc oroChannelFormatDesc;
typedef hipArray_t oroArray_t;
typedef hipArray_const_t oroArray_const_t;
typedef hipArray_Format oroArray_Format;
	const hipArray_Format ORO_AD_FORMAT_UNSIGNED_INT8 = HIP_AD_FORMAT_UNSIGNED_INT8;
	const hipArray_Format ORO_AD_FORMAT_UNSIGNED_INT16 = HIP_AD_FORMAT_UNSIGNED_INT16;
	const hipArray_Format ORO_AD_FORMAT_UNSIGNED_INT32 = HIP_AD_FORMAT_UNSIGNED_INT32;
	const hipArray_Format ORO_AD_FORMAT_SIGNED_INT8 = HIP_AD_FORMAT_SIGNED_INT8;
	const hipArray_Format ORO_AD_FORMAT_SIGNED_INT16 = HIP_AD_FORMAT_SIGNED_INT16;
	const hipArray_Format ORO_AD_FORMAT_SIGNED_INT32 = HIP_AD_FORMAT_SIGNED_INT32;
	const hipArray_Format ORO_AD_FORMAT_HALF = HIP_AD_FORMAT_HALF;
	const hipArray_Format ORO_AD_FORMAT_FLOAT = HIP_AD_FORMAT_FLOAT;
typedef HIP_ARRAY_DESCRIPTOR ORO_ARRAY_DESCRIPTOR;
typedef HIP_ARRAY3D_DESCRIPTOR ORO_ARRAY3D_DESCRIPTOR;
typedef hip_Memcpy2D oro_Memcpy2D;
typedef hipMipmappedArray oroMipmappedArray;
typedef hipMipmappedArray_t oroMipmappedArray_t;
typedef hipmipmappedArray oromipmappedArray;
typedef hipMipmappedArray_const_t oroMipmappedArray_const_t;
typedef hipResourceType oroResourceType;
	const hipResourceType oroResourceTypeArray = hipResourceTypeArray;
	const hipResourceType oroResourceTypeMipmappedArray = hipResourceTypeMipmappedArray;
	const hipResourceType oroResourceTypeLinear = hipResourceTypeLinear;
	const hipResourceType oroResourceTypePitch2D = hipResourceTypePitch2D;
typedef HIPresourcetype_enum OROresourcetype_enum;
	const HIPresourcetype_enum ORO_RESOURCE_TYPE_ARRAY = HIP_RESOURCE_TYPE_ARRAY;
	const HIPresourcetype_enum ORO_RESOURCE_TYPE_MIPMAPPED_ARRAY = HIP_RESOURCE_TYPE_MIPMAPPED_ARRAY;
	const HIPresourcetype_enum ORO_RESOURCE_TYPE_LINEAR = HIP_RESOURCE_TYPE_LINEAR;
	const HIPresourcetype_enum ORO_RESOURCE_TYPE_PITCH2D = HIP_RESOURCE_TYPE_PITCH2D;
typedef HIPresourcetype OROresourcetype;
typedef hipResourcetype oroResourcetype;
typedef HIPaddress_mode_enum OROaddress_mode_enum;
	const HIPaddress_mode_enum ORO_TR_ADDRESS_MODE_WRAP = HIP_TR_ADDRESS_MODE_WRAP;
	const HIPaddress_mode_enum ORO_TR_ADDRESS_MODE_CLAMP = HIP_TR_ADDRESS_MODE_CLAMP;
	const HIPaddress_mode_enum ORO_TR_ADDRESS_MODE_MIRROR = HIP_TR_ADDRESS_MODE_MIRROR;
	const HIPaddress_mode_enum ORO_TR_ADDRESS_MODE_BORDER = HIP_TR_ADDRESS_MODE_BORDER;
typedef HIPaddress_mode OROaddress_mode;
typedef HIPfilter_mode_enum OROfilter_mode_enum;
	const HIPfilter_mode_enum ORO_TR_FILTER_MODE_POINT = HIP_TR_FILTER_MODE_POINT;
	const HIPfilter_mode_enum ORO_TR_FILTER_MODE_LINEAR = HIP_TR_FILTER_MODE_LINEAR;
typedef HIPfilter_mode OROfilter_mode;
typedef HIP_TEXTURE_DESC_st ORO_TEXTURE_DESC_st;
typedef HIP_TEXTURE_DESC ORO_TEXTURE_DESC;
typedef hipResourceViewFormat oroResourceViewFormat;
	const hipResourceViewFormat oroResViewFormatNone = hipResViewFormatNone;
	const hipResourceViewFormat oroResViewFormatUnsignedChar1 = hipResViewFormatUnsignedChar1;
	const hipResourceViewFormat oroResViewFormatUnsignedChar2 = hipResViewFormatUnsignedChar2;
	const hipResourceViewFormat oroResViewFormatUnsignedChar4 = hipResViewFormatUnsignedChar4;
	const hipResourceViewFormat oroResViewFormatSignedChar1 = hipResViewFormatSignedChar1;
	const hipResourceViewFormat oroResViewFormatSignedChar2 = hipResViewFormatSignedChar2;
	const hipResourceViewFormat oroResViewFormatSignedChar4 = hipResViewFormatSignedChar4;
	const hipResourceViewFormat oroResViewFormatUnsignedShort1 = hipResViewFormatUnsignedShort1;
	const hipResourceViewFormat oroResViewFormatUnsignedShort2 = hipResViewFormatUnsignedShort2;
	const hipResourceViewFormat oroResViewFormatUnsignedShort4 = hipResViewFormatUnsignedShort4;
	const hipResourceViewFormat oroResViewFormatSignedShort1 = hipResViewFormatSignedShort1;
	const hipResourceViewFormat oroResViewFormatSignedShort2 = hipResViewFormatSignedShort2;
	const hipResourceViewFormat oroResViewFormatSignedShort4 = hipResViewFormatSignedShort4;
	const hipResourceViewFormat oroResViewFormatUnsignedInt1 = hipResViewFormatUnsignedInt1;
	const hipResourceViewFormat oroResViewFormatUnsignedInt2 = hipResViewFormatUnsignedInt2;
	const hipResourceViewFormat oroResViewFormatUnsignedInt4 = hipResViewFormatUnsignedInt4;
	const hipResourceViewFormat oroResViewFormatSignedInt1 = hipResViewFormatSignedInt1;
	const hipResourceViewFormat oroResViewFormatSignedInt2 = hipResViewFormatSignedInt2;
	const hipResourceViewFormat oroResViewFormatSignedInt4 = hipResViewFormatSignedInt4;
	const hipResourceViewFormat oroResViewFormatHalf1 = hipResViewFormatHalf1;
	const hipResourceViewFormat oroResViewFormatHalf2 = hipResViewFormatHalf2;
	const hipResourceViewFormat oroResViewFormatHalf4 = hipResViewFormatHalf4;
	const hipResourceViewFormat oroResViewFormatFloat1 = hipResViewFormatFloat1;
	const hipResourceViewFormat oroResViewFormatFloat2 = hipResViewFormatFloat2;
	const hipResourceViewFormat oroResViewFormatFloat4 = hipResViewFormatFloat4;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed1 = hipResViewFormatUnsignedBlockCompressed1;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed2 = hipResViewFormatUnsignedBlockCompressed2;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed3 = hipResViewFormatUnsignedBlockCompressed3;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed4 = hipResViewFormatUnsignedBlockCompressed4;
	const hipResourceViewFormat oroResViewFormatSignedBlockCompressed4 = hipResViewFormatSignedBlockCompressed4;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed5 = hipResViewFormatUnsignedBlockCompressed5;
	const hipResourceViewFormat oroResViewFormatSignedBlockCompressed5 = hipResViewFormatSignedBlockCompressed5;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed6H = hipResViewFormatUnsignedBlockCompressed6H;
	const hipResourceViewFormat oroResViewFormatSignedBlockCompressed6H = hipResViewFormatSignedBlockCompressed6H;
	const hipResourceViewFormat oroResViewFormatUnsignedBlockCompressed7 = hipResViewFormatUnsignedBlockCompressed7;
typedef HIPresourceViewFormat_enum OROresourceViewFormat_enum;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_NONE = HIP_RES_VIEW_FORMAT_NONE;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_1X8 = HIP_RES_VIEW_FORMAT_UINT_1X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_2X8 = HIP_RES_VIEW_FORMAT_UINT_2X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_4X8 = HIP_RES_VIEW_FORMAT_UINT_4X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_1X8 = HIP_RES_VIEW_FORMAT_SINT_1X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_2X8 = HIP_RES_VIEW_FORMAT_SINT_2X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_4X8 = HIP_RES_VIEW_FORMAT_SINT_4X8;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_1X16 = HIP_RES_VIEW_FORMAT_UINT_1X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_2X16 = HIP_RES_VIEW_FORMAT_UINT_2X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_4X16 = HIP_RES_VIEW_FORMAT_UINT_4X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_1X16 = HIP_RES_VIEW_FORMAT_SINT_1X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_2X16 = HIP_RES_VIEW_FORMAT_SINT_2X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_4X16 = HIP_RES_VIEW_FORMAT_SINT_4X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_1X32 = HIP_RES_VIEW_FORMAT_UINT_1X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_2X32 = HIP_RES_VIEW_FORMAT_UINT_2X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UINT_4X32 = HIP_RES_VIEW_FORMAT_UINT_4X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_1X32 = HIP_RES_VIEW_FORMAT_SINT_1X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_2X32 = HIP_RES_VIEW_FORMAT_SINT_2X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SINT_4X32 = HIP_RES_VIEW_FORMAT_SINT_4X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_1X16 = HIP_RES_VIEW_FORMAT_FLOAT_1X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_2X16 = HIP_RES_VIEW_FORMAT_FLOAT_2X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_4X16 = HIP_RES_VIEW_FORMAT_FLOAT_4X16;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_1X32 = HIP_RES_VIEW_FORMAT_FLOAT_1X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_2X32 = HIP_RES_VIEW_FORMAT_FLOAT_2X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_FLOAT_4X32 = HIP_RES_VIEW_FORMAT_FLOAT_4X32;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC1 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC1;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC2 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC2;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC3 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC3;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC4 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC4;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SIGNED_BC4 = HIP_RES_VIEW_FORMAT_SIGNED_BC4;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC5 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC5;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SIGNED_BC5 = HIP_RES_VIEW_FORMAT_SIGNED_BC5;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC6H = HIP_RES_VIEW_FORMAT_UNSIGNED_BC6H;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_SIGNED_BC6H = HIP_RES_VIEW_FORMAT_SIGNED_BC6H;
	const HIPresourceViewFormat_enum ORO_RES_VIEW_FORMAT_UNSIGNED_BC7 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC7;
typedef HIPresourceViewFormat OROresourceViewFormat;
typedef hipResourceDesc oroResourceDesc;
typedef HIP_RESOURCE_DESC_st ORO_RESOURCE_DESC_st;
typedef HIP_RESOURCE_DESC ORO_RESOURCE_DESC;
typedef hipResourceViewDesc oroResourceViewDesc;
typedef HIP_RESOURCE_VIEW_DESC_st ORO_RESOURCE_VIEW_DESC_st;
typedef HIP_RESOURCE_VIEW_DESC ORO_RESOURCE_VIEW_DESC;
typedef hipMemcpyKind oroMemcpyKind;
	const hipMemcpyKind oroMemcpyHostToHost = hipMemcpyHostToHost;
	const hipMemcpyKind oroMemcpyHostToDevice = hipMemcpyHostToDevice;
	const hipMemcpyKind oroMemcpyDeviceToHost = hipMemcpyDeviceToHost;
	const hipMemcpyKind oroMemcpyDeviceToDevice = hipMemcpyDeviceToDevice;
	const hipMemcpyKind oroMemcpyDefault = hipMemcpyDefault;
typedef hipPitchedPtr oroPitchedPtr;
typedef hipExtent oroExtent;
typedef hipPos oroPos;
typedef hipMemcpy3DParms oroMemcpy3DParms;
typedef HIP_MEMCPY3D ORO_MEMCPY3D;
typedef hipFunction_attribute oroFunction_attribute;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = HIP_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_CONST_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_CONST_SIZE_BYTES;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_NUM_REGS = HIP_FUNC_ATTRIBUTE_NUM_REGS;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_PTX_VERSION = HIP_FUNC_ATTRIBUTE_PTX_VERSION;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_BINARY_VERSION = HIP_FUNC_ATTRIBUTE_BINARY_VERSION;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_CACHE_MODE_CA = HIP_FUNC_ATTRIBUTE_CACHE_MODE_CA;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = HIP_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT;
	const hipFunction_attribute ORO_FUNC_ATTRIBUTE_MAX = HIP_FUNC_ATTRIBUTE_MAX;
typedef hipPointer_attribute oroPointer_attribute;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_CONTEXT = HIP_POINTER_ATTRIBUTE_CONTEXT;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_MEMORY_TYPE = HIP_POINTER_ATTRIBUTE_MEMORY_TYPE;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_DEVICE_POINTER = HIP_POINTER_ATTRIBUTE_DEVICE_POINTER;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_HOST_POINTER = HIP_POINTER_ATTRIBUTE_HOST_POINTER;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_P2P_TOKENS = HIP_POINTER_ATTRIBUTE_P2P_TOKENS;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_SYNC_MEMOPS = HIP_POINTER_ATTRIBUTE_SYNC_MEMOPS;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_BUFFER_ID = HIP_POINTER_ATTRIBUTE_BUFFER_ID;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_IS_MANAGED = HIP_POINTER_ATTRIBUTE_IS_MANAGED;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_DEVICE_ORDINAL = HIP_POINTER_ATTRIBUTE_DEVICE_ORDINAL;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_IS_LEGACY_HIP_IPC_CAPABLE = HIP_POINTER_ATTRIBUTE_IS_LEGACY_HIP_IPC_CAPABLE;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_RANGE_START_ADDR = HIP_POINTER_ATTRIBUTE_RANGE_START_ADDR;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_RANGE_SIZE = HIP_POINTER_ATTRIBUTE_RANGE_SIZE;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_MAPPED = HIP_POINTER_ATTRIBUTE_MAPPED;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES = HIP_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE = HIP_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_ACCESS_FLAGS = HIP_POINTER_ATTRIBUTE_ACCESS_FLAGS;
	const hipPointer_attribute ORO_POINTER_ATTRIBUTE_MEMPOOL_HANDLE = HIP_POINTER_ATTRIBUTE_MEMPOOL_HANDLE;
typedef hipTextureObject_t oroTextureObject_t;
typedef hipTextureAddressMode oroTextureAddressMode;
	const hipTextureAddressMode oroAddressModeWrap = hipAddressModeWrap;
	const hipTextureAddressMode oroAddressModeClamp = hipAddressModeClamp;
	const hipTextureAddressMode oroAddressModeMirror = hipAddressModeMirror;
	const hipTextureAddressMode oroAddressModeBorder = hipAddressModeBorder;
typedef hipTextureFilterMode oroTextureFilterMode;
	const hipTextureFilterMode oroFilterModePoint = hipFilterModePoint;
	const hipTextureFilterMode oroFilterModeLinear = hipFilterModeLinear;
typedef hipTextureReadMode oroTextureReadMode;
	const hipTextureReadMode oroReadModeElementType = hipReadModeElementType;
	const hipTextureReadMode oroReadModeNormalizedFloat = hipReadModeNormalizedFloat;
typedef hipTextureDesc oroTextureDesc;
typedef hipSurfaceObject_t oroSurfaceObject_t;
typedef hipSurfaceBoundaryMode oroSurfaceBoundaryMode;
	const hipSurfaceBoundaryMode oroBoundaryModeZero = hipBoundaryModeZero;
	const hipSurfaceBoundaryMode oroBoundaryModeTrap = hipBoundaryModeTrap;
	const hipSurfaceBoundaryMode oroBoundaryModeClamp = hipBoundaryModeClamp;
typedef hipCtx_t oroCtx_t;
typedef hipDevice_t oroDevice_t;
typedef hipDeviceP2PAttr oroDeviceP2PAttr;
	const hipDeviceP2PAttr oroDevP2PAttrPerformanceRank = hipDevP2PAttrPerformanceRank;
	const hipDeviceP2PAttr oroDevP2PAttrAccessSupported = hipDevP2PAttrAccessSupported;
	const hipDeviceP2PAttr oroDevP2PAttrNativeAtomicSupported = hipDevP2PAttrNativeAtomicSupported;
	const hipDeviceP2PAttr oroDevP2PAttrHipArrayAccessSupported = hipDevP2PAttrHipArrayAccessSupported;
typedef hipStream_t oroStream_t;
typedef hipIpcMemHandle_st oroIpcMemHandle_st;
typedef hipIpcMemHandle_t oroIpcMemHandle_t;
typedef hipIpcEventHandle_st oroIpcEventHandle_st;
typedef hipIpcEventHandle_t oroIpcEventHandle_t;
typedef hipModule_t oroModule_t;
typedef hipFunction_t oroFunction_t;
typedef hipMemPool_t oroMemPool_t;
typedef hipFuncAttributes oroFuncAttributes;
typedef hipEvent_t oroEvent_t;
typedef hipLimit_t oroLimit_t;
	const hipLimit_t oroLimitStackSize = hipLimitStackSize;
	const hipLimit_t oroLimitPrintfFifoSize = hipLimitPrintfFifoSize;
	const hipLimit_t oroLimitMallocHeapSize = hipLimitMallocHeapSize;
	const hipLimit_t oroLimitRange = hipLimitRange;
typedef hipMemoryAdvise oroMemoryAdvise;
	const hipMemoryAdvise oroMemAdviseSetReadMostly = hipMemAdviseSetReadMostly;
	const hipMemoryAdvise oroMemAdviseUnsetReadMostly = hipMemAdviseUnsetReadMostly;
	const hipMemoryAdvise oroMemAdviseSetPreferredLocation = hipMemAdviseSetPreferredLocation;
	const hipMemoryAdvise oroMemAdviseUnsetPreferredLocation = hipMemAdviseUnsetPreferredLocation;
	const hipMemoryAdvise oroMemAdviseSetAccessedBy = hipMemAdviseSetAccessedBy;
	const hipMemoryAdvise oroMemAdviseUnsetAccessedBy = hipMemAdviseUnsetAccessedBy;
	const hipMemoryAdvise oroMemAdviseSetCoarseGrain = hipMemAdviseSetCoarseGrain;
	const hipMemoryAdvise oroMemAdviseUnsetCoarseGrain = hipMemAdviseUnsetCoarseGrain;
typedef hipMemRangeCoherencyMode oroMemRangeCoherencyMode;
	const hipMemRangeCoherencyMode oroMemRangeCoherencyModeFineGrain = hipMemRangeCoherencyModeFineGrain;
	const hipMemRangeCoherencyMode oroMemRangeCoherencyModeCoarseGrain = hipMemRangeCoherencyModeCoarseGrain;
	const hipMemRangeCoherencyMode oroMemRangeCoherencyModeIndeterminate = hipMemRangeCoherencyModeIndeterminate;
typedef hipMemRangeAttribute oroMemRangeAttribute;
	const hipMemRangeAttribute oroMemRangeAttributeReadMostly = hipMemRangeAttributeReadMostly;
	const hipMemRangeAttribute oroMemRangeAttributePreferredLocation = hipMemRangeAttributePreferredLocation;
	const hipMemRangeAttribute oroMemRangeAttributeAccessedBy = hipMemRangeAttributeAccessedBy;
	const hipMemRangeAttribute oroMemRangeAttributeLastPrefetchLocation = hipMemRangeAttributeLastPrefetchLocation;
	const hipMemRangeAttribute oroMemRangeAttributeCoherencyMode = hipMemRangeAttributeCoherencyMode;
typedef hipMemPoolAttr oroMemPoolAttr;
	const hipMemPoolAttr oroMemPoolReuseFollowEventDependencies = hipMemPoolReuseFollowEventDependencies;
	const hipMemPoolAttr oroMemPoolReuseAllowOpportunistic = hipMemPoolReuseAllowOpportunistic;
	const hipMemPoolAttr oroMemPoolReuseAllowInternalDependencies = hipMemPoolReuseAllowInternalDependencies;
	const hipMemPoolAttr oroMemPoolAttrReleaseThreshold = hipMemPoolAttrReleaseThreshold;
	const hipMemPoolAttr oroMemPoolAttrReservedMemCurrent = hipMemPoolAttrReservedMemCurrent;
	const hipMemPoolAttr oroMemPoolAttrReservedMemHigh = hipMemPoolAttrReservedMemHigh;
	const hipMemPoolAttr oroMemPoolAttrUsedMemCurrent = hipMemPoolAttrUsedMemCurrent;
	const hipMemPoolAttr oroMemPoolAttrUsedMemHigh = hipMemPoolAttrUsedMemHigh;
typedef hipMemLocationType oroMemLocationType;
	const hipMemLocationType oroMemLocationTypeInvalid = hipMemLocationTypeInvalid;
	const hipMemLocationType oroMemLocationTypeDevice = hipMemLocationTypeDevice;
typedef hipMemLocation oroMemLocation;
typedef hipMemAccessFlags oroMemAccessFlags;
	const hipMemAccessFlags oroMemAccessFlagsProtNone = hipMemAccessFlagsProtNone;
	const hipMemAccessFlags oroMemAccessFlagsProtRead = hipMemAccessFlagsProtRead;
	const hipMemAccessFlags oroMemAccessFlagsProtReadWrite = hipMemAccessFlagsProtReadWrite;
typedef hipMemAccessDesc oroMemAccessDesc;
typedef hipMemAllocationType oroMemAllocationType;
	const hipMemAllocationType oroMemAllocationTypeInvalid = hipMemAllocationTypeInvalid;
	const hipMemAllocationType oroMemAllocationTypePinned = hipMemAllocationTypePinned;
	const hipMemAllocationType oroMemAllocationTypeMax = hipMemAllocationTypeMax;
typedef hipMemAllocationHandleType oroMemAllocationHandleType;
	const hipMemAllocationHandleType oroMemHandleTypeNone = hipMemHandleTypeNone;
	const hipMemAllocationHandleType oroMemHandleTypePosixFileDescriptor = hipMemHandleTypePosixFileDescriptor;
	const hipMemAllocationHandleType oroMemHandleTypeWin32 = hipMemHandleTypeWin32;
	const hipMemAllocationHandleType oroMemHandleTypeWin32Kmt = hipMemHandleTypeWin32Kmt;
typedef hipMemPoolProps oroMemPoolProps;
typedef hipMemPoolPtrExportData oroMemPoolPtrExportData;
typedef hipJitOption oroJitOption;
	const hipJitOption oroJitOptionMaxRegisters = hipJitOptionMaxRegisters;
	const hipJitOption oroJitOptionThreadsPerBlock = hipJitOptionThreadsPerBlock;
	const hipJitOption oroJitOptionWallTime = hipJitOptionWallTime;
	const hipJitOption oroJitOptionInfoLogBuffer = hipJitOptionInfoLogBuffer;
	const hipJitOption oroJitOptionInfoLogBufferSizeBytes = hipJitOptionInfoLogBufferSizeBytes;
	const hipJitOption oroJitOptionErrorLogBuffer = hipJitOptionErrorLogBuffer;
	const hipJitOption oroJitOptionErrorLogBufferSizeBytes = hipJitOptionErrorLogBufferSizeBytes;
	const hipJitOption oroJitOptionOptimizationLevel = hipJitOptionOptimizationLevel;
	const hipJitOption oroJitOptionTargetFromContext = hipJitOptionTargetFromContext;
	const hipJitOption oroJitOptionTarget = hipJitOptionTarget;
	const hipJitOption oroJitOptionFallbackStrategy = hipJitOptionFallbackStrategy;
	const hipJitOption oroJitOptionGenerateDebugInfo = hipJitOptionGenerateDebugInfo;
	const hipJitOption oroJitOptionLogVerbose = hipJitOptionLogVerbose;
	const hipJitOption oroJitOptionGenerateLineInfo = hipJitOptionGenerateLineInfo;
	const hipJitOption oroJitOptionCacheMode = hipJitOptionCacheMode;
	const hipJitOption oroJitOptionSm3xOpt = hipJitOptionSm3xOpt;
	const hipJitOption oroJitOptionFastCompile = hipJitOptionFastCompile;
	const hipJitOption oroJitOptionNumOptions = hipJitOptionNumOptions;
typedef hipFuncAttribute oroFuncAttribute;
	const hipFuncAttribute oroFuncAttributeMaxDynamicSharedMemorySize = hipFuncAttributeMaxDynamicSharedMemorySize;
	const hipFuncAttribute oroFuncAttributePreferredSharedMemoryCarveout = hipFuncAttributePreferredSharedMemoryCarveout;
	const hipFuncAttribute oroFuncAttributeMax = hipFuncAttributeMax;
typedef hipFuncCache_t oroFuncCache_t;
	const hipFuncCache_t oroFuncCachePreferNone = hipFuncCachePreferNone;
	const hipFuncCache_t oroFuncCachePreferShared = hipFuncCachePreferShared;
	const hipFuncCache_t oroFuncCachePreferL1 = hipFuncCachePreferL1;
	const hipFuncCache_t oroFuncCachePreferEqual = hipFuncCachePreferEqual;
typedef hipSharedMemConfig oroSharedMemConfig;
	const hipSharedMemConfig oroSharedMemBankSizeDefault = hipSharedMemBankSizeDefault;
	const hipSharedMemConfig oroSharedMemBankSizeFourByte = hipSharedMemBankSizeFourByte;
	const hipSharedMemConfig oroSharedMemBankSizeEightByte = hipSharedMemBankSizeEightByte;
typedef hipLaunchParams_t oroLaunchParams_t;
typedef hipLaunchParams oroLaunchParams;
typedef hipFunctionLaunchParams_t oroFunctionLaunchParams_t;
typedef hipFunctionLaunchParams oroFunctionLaunchParams;
typedef hipExternalMemoryHandleType_enum oroExternalMemoryHandleType_enum;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeOpaqueFd = hipExternalMemoryHandleTypeOpaqueFd;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeOpaqueWin32 = hipExternalMemoryHandleTypeOpaqueWin32;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeOpaqueWin32Kmt = hipExternalMemoryHandleTypeOpaqueWin32Kmt;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeD3D12Heap = hipExternalMemoryHandleTypeD3D12Heap;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeD3D12Resource = hipExternalMemoryHandleTypeD3D12Resource;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeD3D11Resource = hipExternalMemoryHandleTypeD3D11Resource;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeD3D11ResourceKmt = hipExternalMemoryHandleTypeD3D11ResourceKmt;
	const hipExternalMemoryHandleType_enum oroExternalMemoryHandleTypeNvSciBuf = hipExternalMemoryHandleTypeNvSciBuf;
typedef hipExternalMemoryHandleType oroExternalMemoryHandleType;
typedef hipExternalMemoryHandleDesc_st oroExternalMemoryHandleDesc_st;
typedef hipExternalMemoryHandleDesc oroExternalMemoryHandleDesc;
typedef hipExternalMemoryBufferDesc_st oroExternalMemoryBufferDesc_st;
typedef hipExternalMemoryBufferDesc oroExternalMemoryBufferDesc;
typedef hipExternalMemoryMipmappedArrayDesc_st oroExternalMemoryMipmappedArrayDesc_st;
typedef hipExternalMemoryMipmappedArrayDesc oroExternalMemoryMipmappedArrayDesc;
typedef hipExternalMemory_t oroExternalMemory_t;
typedef hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleType_enum;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeOpaqueFd = hipExternalSemaphoreHandleTypeOpaqueFd;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeOpaqueWin32 = hipExternalSemaphoreHandleTypeOpaqueWin32;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeOpaqueWin32Kmt = hipExternalSemaphoreHandleTypeOpaqueWin32Kmt;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeD3D12Fence = hipExternalSemaphoreHandleTypeD3D12Fence;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeD3D11Fence = hipExternalSemaphoreHandleTypeD3D11Fence;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeNvSciSync = hipExternalSemaphoreHandleTypeNvSciSync;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeKeyedMutex = hipExternalSemaphoreHandleTypeKeyedMutex;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeKeyedMutexKmt = hipExternalSemaphoreHandleTypeKeyedMutexKmt;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeTimelineSemaphoreFd = hipExternalSemaphoreHandleTypeTimelineSemaphoreFd;
	const hipExternalSemaphoreHandleType_enum oroExternalSemaphoreHandleTypeTimelineSemaphoreWin32 = hipExternalSemaphoreHandleTypeTimelineSemaphoreWin32;
typedef hipExternalSemaphoreHandleType oroExternalSemaphoreHandleType;
typedef hipExternalSemaphoreHandleDesc_st oroExternalSemaphoreHandleDesc_st;
typedef hipExternalSemaphoreHandleDesc oroExternalSemaphoreHandleDesc;
typedef hipExternalSemaphore_t oroExternalSemaphore_t;
typedef hipExternalSemaphoreSignalParams_st oroExternalSemaphoreSignalParams_st;
typedef hipExternalSemaphoreSignalParams oroExternalSemaphoreSignalParams;
typedef hipExternalSemaphoreWaitParams_st oroExternalSemaphoreWaitParams_st;
typedef hipExternalSemaphoreWaitParams oroExternalSemaphoreWaitParams;
typedef hipGraphicsRegisterFlags oroGraphicsRegisterFlags;
	const hipGraphicsRegisterFlags oroGraphicsRegisterFlagsNone = hipGraphicsRegisterFlagsNone;
	const hipGraphicsRegisterFlags oroGraphicsRegisterFlagsReadOnly = hipGraphicsRegisterFlagsReadOnly;
	const hipGraphicsRegisterFlags oroGraphicsRegisterFlagsWriteDiscard = hipGraphicsRegisterFlagsWriteDiscard;
	const hipGraphicsRegisterFlags oroGraphicsRegisterFlagsSurfaceLoadStore = hipGraphicsRegisterFlagsSurfaceLoadStore;
	const hipGraphicsRegisterFlags oroGraphicsRegisterFlagsTextureGather = hipGraphicsRegisterFlagsTextureGather;
typedef hipGraphicsResource oroGraphicsResource;
typedef hipGraphicsResource_t oroGraphicsResource_t;
typedef hipGraph_t oroGraph_t;
typedef hipGraphNode_t oroGraphNode_t;
typedef hipGraphExec_t oroGraphExec_t;
typedef hipUserObject_t oroUserObject_t;
typedef hipGraphNodeType oroGraphNodeType;
	const hipGraphNodeType oroGraphNodeTypeKernel = hipGraphNodeTypeKernel;
	const hipGraphNodeType oroGraphNodeTypeMemcpy = hipGraphNodeTypeMemcpy;
	const hipGraphNodeType oroGraphNodeTypeMemset = hipGraphNodeTypeMemset;
	const hipGraphNodeType oroGraphNodeTypeHost = hipGraphNodeTypeHost;
	const hipGraphNodeType oroGraphNodeTypeGraph = hipGraphNodeTypeGraph;
	const hipGraphNodeType oroGraphNodeTypeEmpty = hipGraphNodeTypeEmpty;
	const hipGraphNodeType oroGraphNodeTypeWaitEvent = hipGraphNodeTypeWaitEvent;
	const hipGraphNodeType oroGraphNodeTypeEventRecord = hipGraphNodeTypeEventRecord;
	const hipGraphNodeType oroGraphNodeTypeExtSemaphoreSignal = hipGraphNodeTypeExtSemaphoreSignal;
	const hipGraphNodeType oroGraphNodeTypeExtSemaphoreWait = hipGraphNodeTypeExtSemaphoreWait;
	const hipGraphNodeType oroGraphNodeTypeMemAlloc = hipGraphNodeTypeMemAlloc;
	const hipGraphNodeType oroGraphNodeTypeMemFree = hipGraphNodeTypeMemFree;
	const hipGraphNodeType oroGraphNodeTypeMemcpyFromSymbol = hipGraphNodeTypeMemcpyFromSymbol;
	const hipGraphNodeType oroGraphNodeTypeMemcpyToSymbol = hipGraphNodeTypeMemcpyToSymbol;
	const hipGraphNodeType oroGraphNodeTypeCount = hipGraphNodeTypeCount;
typedef hipHostFn_t oroHostFn_t;
typedef hipHostNodeParams oroHostNodeParams;
typedef hipKernelNodeParams oroKernelNodeParams;
typedef hipMemsetParams oroMemsetParams;
typedef hipMemAllocNodeParams oroMemAllocNodeParams;
typedef hipKernelNodeAttrID oroKernelNodeAttrID;
	const hipKernelNodeAttrID oroKernelNodeAttributeAccessPolicyWindow = hipKernelNodeAttributeAccessPolicyWindow;
	const hipKernelNodeAttrID oroKernelNodeAttributeCooperative = hipKernelNodeAttributeCooperative;
typedef hipAccessProperty oroAccessProperty;
	const hipAccessProperty oroAccessPropertyNormal = hipAccessPropertyNormal;
	const hipAccessProperty oroAccessPropertyStreaming = hipAccessPropertyStreaming;
	const hipAccessProperty oroAccessPropertyPersisting = hipAccessPropertyPersisting;
typedef hipAccessPolicyWindow oroAccessPolicyWindow;
typedef hipKernelNodeAttrValue oroKernelNodeAttrValue;
typedef HIP_MEMSET_NODE_PARAMS ORO_MEMSET_NODE_PARAMS;
typedef hipGraphExecUpdateResult oroGraphExecUpdateResult;
	const hipGraphExecUpdateResult oroGraphExecUpdateSuccess = hipGraphExecUpdateSuccess;
	const hipGraphExecUpdateResult oroGraphExecUpdateError = hipGraphExecUpdateError;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorTopologyChanged = hipGraphExecUpdateErrorTopologyChanged;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorNodeTypeChanged = hipGraphExecUpdateErrorNodeTypeChanged;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorFunctionChanged = hipGraphExecUpdateErrorFunctionChanged;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorParametersChanged = hipGraphExecUpdateErrorParametersChanged;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorNotSupported = hipGraphExecUpdateErrorNotSupported;
	const hipGraphExecUpdateResult oroGraphExecUpdateErrorUnsupportedFunctionChange = hipGraphExecUpdateErrorUnsupportedFunctionChange;
typedef hipStreamCaptureMode oroStreamCaptureMode;
	const hipStreamCaptureMode oroStreamCaptureModeGlobal = hipStreamCaptureModeGlobal;
	const hipStreamCaptureMode oroStreamCaptureModeThreadLocal = hipStreamCaptureModeThreadLocal;
	const hipStreamCaptureMode oroStreamCaptureModeRelaxed = hipStreamCaptureModeRelaxed;
typedef hipStreamCaptureStatus oroStreamCaptureStatus;
	const hipStreamCaptureStatus oroStreamCaptureStatusNone = hipStreamCaptureStatusNone;
	const hipStreamCaptureStatus oroStreamCaptureStatusActive = hipStreamCaptureStatusActive;
	const hipStreamCaptureStatus oroStreamCaptureStatusInvalidated = hipStreamCaptureStatusInvalidated;
typedef hipStreamUpdateCaptureDependenciesFlags oroStreamUpdateCaptureDependenciesFlags;
	const hipStreamUpdateCaptureDependenciesFlags oroStreamAddCaptureDependencies = hipStreamAddCaptureDependencies;
	const hipStreamUpdateCaptureDependenciesFlags oroStreamSetCaptureDependencies = hipStreamSetCaptureDependencies;
typedef hipGraphMemAttributeType oroGraphMemAttributeType;
	const hipGraphMemAttributeType oroGraphMemAttrUsedMemCurrent = hipGraphMemAttrUsedMemCurrent;
	const hipGraphMemAttributeType oroGraphMemAttrUsedMemHigh = hipGraphMemAttrUsedMemHigh;
	const hipGraphMemAttributeType oroGraphMemAttrReservedMemCurrent = hipGraphMemAttrReservedMemCurrent;
	const hipGraphMemAttributeType oroGraphMemAttrReservedMemHigh = hipGraphMemAttrReservedMemHigh;
typedef hipUserObjectFlags oroUserObjectFlags;
	const hipUserObjectFlags oroUserObjectNoDestructorSync = hipUserObjectNoDestructorSync;
typedef hipUserObjectRetainFlags oroUserObjectRetainFlags;
	const hipUserObjectRetainFlags oroGraphUserObjectMove = hipGraphUserObjectMove;
typedef hipGraphInstantiateFlags oroGraphInstantiateFlags;
	const hipGraphInstantiateFlags oroGraphInstantiateFlagAutoFreeOnLaunch = hipGraphInstantiateFlagAutoFreeOnLaunch;
	const hipGraphInstantiateFlags oroGraphInstantiateFlagUpload = hipGraphInstantiateFlagUpload;
	const hipGraphInstantiateFlags oroGraphInstantiateFlagDeviceLaunch = hipGraphInstantiateFlagDeviceLaunch;
	const hipGraphInstantiateFlags oroGraphInstantiateFlagUseNodePriority = hipGraphInstantiateFlagUseNodePriority;
typedef hipGraphDebugDotFlags oroGraphDebugDotFlags;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsVerbose = hipGraphDebugDotFlagsVerbose;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsKernelNodeParams = hipGraphDebugDotFlagsKernelNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsMemcpyNodeParams = hipGraphDebugDotFlagsMemcpyNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsMemsetNodeParams = hipGraphDebugDotFlagsMemsetNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsHostNodeParams = hipGraphDebugDotFlagsHostNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsEventNodeParams = hipGraphDebugDotFlagsEventNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsExtSemasSignalNodeParams = hipGraphDebugDotFlagsExtSemasSignalNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsExtSemasWaitNodeParams = hipGraphDebugDotFlagsExtSemasWaitNodeParams;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsKernelNodeAttributes = hipGraphDebugDotFlagsKernelNodeAttributes;
	const hipGraphDebugDotFlags oroGraphDebugDotFlagsHandles = hipGraphDebugDotFlagsHandles;
typedef hipMemAllocationProp oroMemAllocationProp;
typedef hipExternalSemaphoreSignalNodeParams oroExternalSemaphoreSignalNodeParams;
typedef hipExternalSemaphoreWaitNodeParams oroExternalSemaphoreWaitNodeParams;
typedef hipMemGenericAllocationHandle_t oroMemGenericAllocationHandle_t;
typedef hipMemAllocationGranularity_flags oroMemAllocationGranularity_flags;
	const hipMemAllocationGranularity_flags oroMemAllocationGranularityMinimum = hipMemAllocationGranularityMinimum;
	const hipMemAllocationGranularity_flags oroMemAllocationGranularityRecommended = hipMemAllocationGranularityRecommended;
typedef hipMemHandleType oroMemHandleType;
	const hipMemHandleType oroMemHandleTypeGeneric = hipMemHandleTypeGeneric;
typedef hipMemOperationType oroMemOperationType;
	const hipMemOperationType oroMemOperationTypeMap = hipMemOperationTypeMap;
	const hipMemOperationType oroMemOperationTypeUnmap = hipMemOperationTypeUnmap;
typedef hipArraySparseSubresourceType oroArraySparseSubresourceType;
	const hipArraySparseSubresourceType oroArraySparseSubresourceTypeSparseLevel = hipArraySparseSubresourceTypeSparseLevel;
	const hipArraySparseSubresourceType oroArraySparseSubresourceTypeMiptail = hipArraySparseSubresourceTypeMiptail;
typedef hipArrayMapInfo oroArrayMapInfo;
typedef hipStreamCallback_t oroStreamCallback_t;
typedef hiprtcResult orortcResult;
	const hiprtcResult ORORTC_SUCCESS = HIPRTC_SUCCESS;
	const hiprtcResult ORORTC_ERROR_OUT_OF_MEMORY = HIPRTC_ERROR_OUT_OF_MEMORY;
	const hiprtcResult ORORTC_ERROR_PROGRAM_CREATION_FAILURE = HIPRTC_ERROR_PROGRAM_CREATION_FAILURE;
	const hiprtcResult ORORTC_ERROR_INVALID_INPUT = HIPRTC_ERROR_INVALID_INPUT;
	const hiprtcResult ORORTC_ERROR_INVALID_PROGRAM = HIPRTC_ERROR_INVALID_PROGRAM;
	const hiprtcResult ORORTC_ERROR_INVALID_OPTION = HIPRTC_ERROR_INVALID_OPTION;
	const hiprtcResult ORORTC_ERROR_COMPILATION = HIPRTC_ERROR_COMPILATION;
	const hiprtcResult ORORTC_ERROR_BUILTIN_OPERATION_FAILURE = HIPRTC_ERROR_BUILTIN_OPERATION_FAILURE;
	const hiprtcResult ORORTC_ERROR_NO_NAME_EXPRESSIONS_AFTER_COMPILATION = HIPRTC_ERROR_NO_NAME_EXPRESSIONS_AFTER_COMPILATION;
	const hiprtcResult ORORTC_ERROR_NO_LOWERED_NAMES_BEFORE_COMPILATION = HIPRTC_ERROR_NO_LOWERED_NAMES_BEFORE_COMPILATION;
	const hiprtcResult ORORTC_ERROR_NAME_EXPRESSION_NOT_VALID = HIPRTC_ERROR_NAME_EXPRESSION_NOT_VALID;
	const hiprtcResult ORORTC_ERROR_INTERNAL_ERROR = HIPRTC_ERROR_INTERNAL_ERROR;
	const hiprtcResult ORORTC_ERROR_LINKING = HIPRTC_ERROR_LINKING;
typedef hiprtcJIT_option orortcJIT_option;
	const hiprtcJIT_option ORORTC_JIT_MAX_REGISTERS = HIPRTC_JIT_MAX_REGISTERS;
	const hiprtcJIT_option ORORTC_JIT_THREADS_PER_BLOCK = HIPRTC_JIT_THREADS_PER_BLOCK;
	const hiprtcJIT_option ORORTC_JIT_WALL_TIME = HIPRTC_JIT_WALL_TIME;
	const hiprtcJIT_option ORORTC_JIT_INFO_LOG_BUFFER = HIPRTC_JIT_INFO_LOG_BUFFER;
	const hiprtcJIT_option ORORTC_JIT_INFO_LOG_BUFFER_SIZE_BYTES = HIPRTC_JIT_INFO_LOG_BUFFER_SIZE_BYTES;
	const hiprtcJIT_option ORORTC_JIT_ERROR_LOG_BUFFER = HIPRTC_JIT_ERROR_LOG_BUFFER;
	const hiprtcJIT_option ORORTC_JIT_ERROR_LOG_BUFFER_SIZE_BYTES = HIPRTC_JIT_ERROR_LOG_BUFFER_SIZE_BYTES;
	const hiprtcJIT_option ORORTC_JIT_OPTIMIZATION_LEVEL = HIPRTC_JIT_OPTIMIZATION_LEVEL;
	const hiprtcJIT_option ORORTC_JIT_TARGET_FROM_HIPCONTEXT = HIPRTC_JIT_TARGET_FROM_HIPCONTEXT;
	const hiprtcJIT_option ORORTC_JIT_TARGET = HIPRTC_JIT_TARGET;
	const hiprtcJIT_option ORORTC_JIT_FALLBACK_STRATEGY = HIPRTC_JIT_FALLBACK_STRATEGY;
	const hiprtcJIT_option ORORTC_JIT_GENERATE_DEBUG_INFO = HIPRTC_JIT_GENERATE_DEBUG_INFO;
	const hiprtcJIT_option ORORTC_JIT_LOG_VERBOSE = HIPRTC_JIT_LOG_VERBOSE;
	const hiprtcJIT_option ORORTC_JIT_GENERATE_LINE_INFO = HIPRTC_JIT_GENERATE_LINE_INFO;
	const hiprtcJIT_option ORORTC_JIT_CACHE_MODE = HIPRTC_JIT_CACHE_MODE;
	const hiprtcJIT_option ORORTC_JIT_NEW_SM3X_OPT = HIPRTC_JIT_NEW_SM3X_OPT;
	const hiprtcJIT_option ORORTC_JIT_FAST_COMPILE = HIPRTC_JIT_FAST_COMPILE;
	const hiprtcJIT_option ORORTC_JIT_GLOBAL_SYMBOL_NAMES = HIPRTC_JIT_GLOBAL_SYMBOL_NAMES;
	const hiprtcJIT_option ORORTC_JIT_GLOBAL_SYMBOL_ADDRESS = HIPRTC_JIT_GLOBAL_SYMBOL_ADDRESS;
	const hiprtcJIT_option ORORTC_JIT_GLOBAL_SYMBOL_COUNT = HIPRTC_JIT_GLOBAL_SYMBOL_COUNT;
	const hiprtcJIT_option ORORTC_JIT_LTO = HIPRTC_JIT_LTO;
	const hiprtcJIT_option ORORTC_JIT_FTZ = HIPRTC_JIT_FTZ;
	const hiprtcJIT_option ORORTC_JIT_PREC_DIV = HIPRTC_JIT_PREC_DIV;
	const hiprtcJIT_option ORORTC_JIT_PREC_SQRT = HIPRTC_JIT_PREC_SQRT;
	const hiprtcJIT_option ORORTC_JIT_FMA = HIPRTC_JIT_FMA;
	const hiprtcJIT_option ORORTC_JIT_NUM_OPTIONS = HIPRTC_JIT_NUM_OPTIONS;
	const hiprtcJIT_option ORORTC_JIT_IR_TO_ISA_OPT_EXT = HIPRTC_JIT_IR_TO_ISA_OPT_EXT;
	const hiprtcJIT_option ORORTC_JIT_IR_TO_ISA_OPT_COUNT_EXT = HIPRTC_JIT_IR_TO_ISA_OPT_COUNT_EXT;
typedef hiprtcJITInputType orortcJITInputType;
	const hiprtcJITInputType ORORTC_JIT_INPUT_CUBIN = HIPRTC_JIT_INPUT_CUBIN;
	const hiprtcJITInputType ORORTC_JIT_INPUT_PTX = HIPRTC_JIT_INPUT_PTX;
	const hiprtcJITInputType ORORTC_JIT_INPUT_FATBINARY = HIPRTC_JIT_INPUT_FATBINARY;
	const hiprtcJITInputType ORORTC_JIT_INPUT_OBJECT = HIPRTC_JIT_INPUT_OBJECT;
	const hiprtcJITInputType ORORTC_JIT_INPUT_LIBRARY = HIPRTC_JIT_INPUT_LIBRARY;
	const hiprtcJITInputType ORORTC_JIT_INPUT_NVVM = HIPRTC_JIT_INPUT_NVVM;
	const hiprtcJITInputType ORORTC_JIT_NUM_LEGACY_INPUT_TYPES = HIPRTC_JIT_NUM_LEGACY_INPUT_TYPES;
	const hiprtcJITInputType ORORTC_JIT_INPUT_LLVM_BITCODE = HIPRTC_JIT_INPUT_LLVM_BITCODE;
	const hiprtcJITInputType ORORTC_JIT_INPUT_LLVM_BUNDLED_BITCODE = HIPRTC_JIT_INPUT_LLVM_BUNDLED_BITCODE;
	const hiprtcJITInputType ORORTC_JIT_INPUT_LLVM_ARCHIVES_OF_BUNDLED_BITCODE = HIPRTC_JIT_INPUT_LLVM_ARCHIVES_OF_BUNDLED_BITCODE;
	const hiprtcJITInputType ORORTC_JIT_NUM_INPUT_TYPES = HIPRTC_JIT_NUM_INPUT_TYPES;
typedef hiprtcLinkState orortcLinkState;
typedef hiprtcProgram orortcProgram;


// Add Orochi Alias
typedef oroArray_const_t oroArray_const;
typedef oroArray_t oroArray;
typedef oroDeviceArch_t oroDeviceArch;
typedef oroDeviceAttribute_t oroDeviceAttribute;
typedef oroDevice_t oroDevice;
typedef oroDeviceptr_t oroDeviceptr;
typedef oroError_t oroError;
typedef oroEvent_t oroEvent;
typedef oroExternalMemory_t oroExternalMemory;
typedef oroExternalSemaphore_t oroExternalSemaphore;
typedef oroFuncCache_t oroFuncCache;
typedef oroFunction_t oroFunction;
typedef oroGraphExec_t oroGraphExec;
typedef oroGraphNode_t oroGraphNode;
typedef oroGraph_t oroGraph;
typedef oroHostFn_t oroHostFn;
typedef oroIpcEventHandle_t oroIpcEventHandle;
typedef oroIpcMemHandle_t oroIpcMemHandle;
typedef oroLimit_t oroLimit;
typedef oroMemGenericAllocationHandle_t oroMemGenericAllocationHandle;
typedef oroMemPool_t oroMemPool;
typedef oroMipmappedArray_const_t oroMipmappedArray_const;
typedef oroModule_t oroModule;
typedef oroPointerAttribute_t oroPointerAttribute;
typedef oroStreamCallback_t oroStreamCallback;
typedef oroStream_t oroStream;
typedef oroSurfaceObject_t oroSurfaceObject;
typedef oroTextureObject_t oroTextureObject;
typedef oroUserObject_t oroUserObject;



oroError_t OROAPI oroChooseDeviceR0600(int * device, const oroDeviceProp_tR0600 * prop);
oroError_t OROAPI oroCreateSurfaceObject(oroSurfaceObject_t * pSurfObject, const oroResourceDesc * pResDesc);
oroError_t OROAPI oroCreateTextureObject(oroTextureObject_t * pTexObject, const oroResourceDesc * pResDesc, const oroTextureDesc * pTexDesc, const  oroResourceViewDesc * pResViewDesc);
oroError_t OROAPI oroCtxDisablePeerAccess(oroCtx_t peerCtx);
oroError_t OROAPI oroCtxEnablePeerAccess(oroCtx_t peerCtx, unsigned int flags);
oroError_t OROAPI oroCtxGetCacheConfig(oroFuncCache_t * cacheConfig);
oroError_t OROAPI oroCtxGetDevice(oroDevice_t * device);
oroError_t OROAPI oroCtxGetFlags(unsigned int * flags);
oroError_t OROAPI oroCtxGetSharedMemConfig(oroSharedMemConfig * pConfig);
oroError_t OROAPI oroCtxPopCurrent(oroCtx_t * ctx);
oroError_t OROAPI oroCtxPushCurrent(oroCtx_t ctx);
oroError_t OROAPI oroCtxSetCacheConfig(oroFuncCache_t cacheConfig);
oroError_t OROAPI oroCtxSetSharedMemConfig(oroSharedMemConfig config);
oroError_t OROAPI oroCtxSynchronize();
oroError_t OROAPI oroDestroyExternalMemory(oroExternalMemory_t extMem);
oroError_t OROAPI oroDestroyExternalSemaphore(oroExternalSemaphore_t extSem);
oroError_t OROAPI oroDestroySurfaceObject(oroSurfaceObject_t surfaceObject);
oroError_t OROAPI oroDestroyTextureObject(oroTextureObject_t textureObject);
oroError_t OROAPI oroDeviceCanAccessPeer(int * canAccessPeer, int deviceId, int peerDeviceId);
oroError_t OROAPI oroDeviceComputeCapability(int * major, int * minor, oroDevice_t device);
oroError_t OROAPI oroDeviceDisablePeerAccess(int peerDeviceId);
oroError_t OROAPI oroDeviceEnablePeerAccess(int peerDeviceId, unsigned int flags);
oroError_t OROAPI oroDeviceGetByPCIBusId(int * device, const char * pciBusId);
oroError_t OROAPI oroDeviceGetCacheConfig(oroFuncCache_t * cacheConfig);
oroError_t OROAPI oroDeviceGetDefaultMemPool(oroMemPool_t * mem_pool, int device);
oroError_t OROAPI oroDeviceGetLimit(size_t * pValue,  oroLimit_t limit);
oroError_t OROAPI oroDeviceGetMemPool(oroMemPool_t * mem_pool, int device);
oroError_t OROAPI oroDeviceGetP2PAttribute(int * value, oroDeviceP2PAttr attr, int srcDevice, int dstDevice);
oroError_t OROAPI oroDeviceGetPCIBusId(char * pciBusId, int len, int device);
oroError_t OROAPI oroDeviceGetSharedMemConfig(oroSharedMemConfig * pConfig);
oroError_t OROAPI oroDeviceGetStreamPriorityRange(int * leastPriority, int * greatestPriority);
oroError_t OROAPI oroDeviceGetUuid(oroUUID * uuid, oroDevice_t device);
oroError_t OROAPI oroDevicePrimaryCtxGetState(oroDevice_t dev, unsigned int * flags, int * active);
oroError_t OROAPI oroDevicePrimaryCtxRelease(oroDevice_t dev);
oroError_t OROAPI oroDevicePrimaryCtxReset(oroDevice_t dev);
oroError_t OROAPI oroDevicePrimaryCtxRetain(oroCtx_t * pctx, oroDevice_t dev);
oroError_t OROAPI oroDevicePrimaryCtxSetFlags(oroDevice_t dev, unsigned int flags);
oroError_t OROAPI oroDeviceReset();
oroError_t OROAPI oroDeviceSetCacheConfig(oroFuncCache_t cacheConfig);
oroError_t OROAPI oroDeviceSetLimit( oroLimit_t limit, size_t value);
oroError_t OROAPI oroDeviceSetMemPool(int device, oroMemPool_t mem_pool);
oroError_t OROAPI oroDeviceSetSharedMemConfig(oroSharedMemConfig config);
oroError_t OROAPI oroDeviceSynchronize();
oroError_t OROAPI oroDeviceTotalMem(size_t * bytes, oroDevice_t device);
oroError_t OROAPI oroDriverGetVersion(int * driverVersion);
oroError_t OROAPI oroDrvGetErrorName(oroError_t hipError, const char ** errorString);
oroError_t OROAPI oroDrvGetErrorString(oroError_t hipError, const char ** errorString);
oroError_t OROAPI oroDrvMemcpy3D(const ORO_MEMCPY3D * pCopy);
oroError_t OROAPI oroDrvMemcpy3DAsync(const ORO_MEMCPY3D * pCopy, oroStream_t stream);
oroError_t OROAPI oroDrvPointerGetAttributes(unsigned int numAttributes, oroPointer_attribute * attributes, void ** data, oroDeviceptr_t ptr);
oroError_t OROAPI oroEventCreate(oroEvent_t * event);
oroError_t OROAPI oroEventCreateWithFlags(oroEvent_t * event, unsigned int flags);
oroError_t OROAPI oroEventDestroy(oroEvent_t event);
oroError_t OROAPI oroEventElapsedTime(float * ms, oroEvent_t start, oroEvent_t stop);
oroError_t OROAPI oroEventQuery(oroEvent_t event);
oroError_t OROAPI oroEventRecord(oroEvent_t event, oroStream_t stream);
oroError_t OROAPI oroEventSynchronize(oroEvent_t event);
oroError_t OROAPI oroExternalMemoryGetMappedBuffer(void ** devPtr, oroExternalMemory_t extMem, const oroExternalMemoryBufferDesc * bufferDesc);
oroError_t OROAPI oroExternalMemoryGetMappedMipmappedArray(oroMipmappedArray_t * mipmap, oroExternalMemory_t extMem, const oroExternalMemoryMipmappedArrayDesc * mipmapDesc);
oroError_t OROAPI oroFree(void * ptr);
oroError_t OROAPI oroFreeArray(oroArray_t array);
oroError_t OROAPI oroFreeAsync(void * dev_ptr, oroStream_t stream);
oroError_t OROAPI oroFreeHost(void * ptr);
oroError_t OROAPI oroFreeMipmappedArray(oroMipmappedArray_t mipmappedArray);
oroError_t OROAPI oroFuncGetAttribute(int * value, oroFunction_attribute attrib, oroFunction_t hfunc);
oroError_t OROAPI oroFuncGetAttributes( oroFuncAttributes * attr, const void * func);
oroError_t OROAPI oroFuncSetAttribute(const void * func, oroFuncAttribute attr, int value);
oroError_t OROAPI oroFuncSetCacheConfig(const void * func, oroFuncCache_t config);
oroError_t OROAPI oroFuncSetSharedMemConfig(const void * func, oroSharedMemConfig config);
oroError_t OROAPI oroGetChannelDesc(oroChannelFormatDesc * desc, oroArray_const_t array);
oroError_t OROAPI oroGetDevice(int * deviceId);
oroError_t OROAPI oroGetDeviceFlags(unsigned int * flags);
oroError_t OROAPI oroGetDevicePropertiesR0600(oroDeviceProp_tR0600 * prop, int deviceId);
const char * OROAPI oroGetErrorName(oroError_t hip_error);
oroError_t OROAPI oroGetLastError();
oroError_t OROAPI oroGetMipmappedArrayLevel(oroArray_t * levelArray, oroMipmappedArray_const_t mipmappedArray, unsigned int level);
oroError_t OROAPI oroGetSymbolAddress(void ** devPtr, const void * symbol);
oroError_t OROAPI oroGetSymbolSize(size_t * size, const void * symbol);
oroError_t OROAPI oroGetTextureObjectResourceDesc(oroResourceDesc * pResDesc, oroTextureObject_t textureObject);
oroError_t OROAPI oroGraphicsMapResources(int count, oroGraphicsResource_t * resources, oroStream_t stream);
oroError_t OROAPI oroGraphicsResourceGetMappedPointer(void ** devPtr, size_t * size, oroGraphicsResource_t resource);
oroError_t OROAPI oroGraphicsSubResourceGetMappedArray(oroArray_t * array, oroGraphicsResource_t resource, unsigned int arrayIndex, unsigned int mipLevel);
oroError_t OROAPI oroGraphicsUnmapResources(int count, oroGraphicsResource_t * resources, oroStream_t stream);
oroError_t OROAPI oroGraphicsUnregisterResource(oroGraphicsResource_t resource);
oroError_t OROAPI oroHostAlloc(void ** ptr, size_t size, unsigned int flags);
oroError_t OROAPI oroHostFree(void * ptr);
oroError_t OROAPI oroHostGetDevicePointer(void ** devPtr, void * hstPtr, unsigned int flags);
oroError_t OROAPI oroHostGetFlags(unsigned int * flagsPtr, void * hostPtr);
oroError_t OROAPI oroHostMalloc(void ** ptr, size_t size, unsigned int flags);
oroError_t OROAPI oroHostRegister(void * hostPtr, size_t sizeBytes, unsigned int flags);
oroError_t OROAPI oroHostUnregister(void * hostPtr);
oroError_t OROAPI oroImportExternalMemory(oroExternalMemory_t * extMem_out, const oroExternalMemoryHandleDesc * memHandleDesc);
oroError_t OROAPI oroImportExternalSemaphore(oroExternalSemaphore_t * extSem_out, const oroExternalSemaphoreHandleDesc * semHandleDesc);
oroError_t OROAPI oroIpcCloseMemHandle(void * devPtr);
oroError_t OROAPI oroIpcGetEventHandle(oroIpcEventHandle_t * handle, oroEvent_t event);
oroError_t OROAPI oroIpcGetMemHandle(oroIpcMemHandle_t * handle, void * devPtr);
oroError_t OROAPI oroIpcOpenEventHandle(oroEvent_t * event, oroIpcEventHandle_t handle);
oroError_t OROAPI oroIpcOpenMemHandle(void ** devPtr, oroIpcMemHandle_t handle, unsigned int flags);
oroError_t OROAPI oroLaunchCooperativeKernel(const void * f, dim3 gridDim, dim3 blockDimX, void ** kernelParams, unsigned int sharedMemBytes, oroStream_t stream);
oroError_t OROAPI oroLaunchCooperativeKernelMultiDevice(oroLaunchParams * launchParamsList, int numDevices, unsigned int flags);
oroError_t OROAPI oroLaunchKernel(const void * function_address, dim3 numBlocks, dim3 dimBlocks, void ** args, size_t sharedMemBytes, oroStream_t stream);
oroError_t OROAPI oroMalloc(void ** ptr, size_t size);
oroError_t OROAPI oroMalloc3D(oroPitchedPtr * pitchedDevPtr, oroExtent extent);
oroError_t OROAPI oroMalloc3DArray(oroArray_t * array, const  oroChannelFormatDesc * desc,  oroExtent extent, unsigned int flags);
oroError_t OROAPI oroMallocArray(oroArray_t * array, const oroChannelFormatDesc * desc, size_t width, size_t height, unsigned int flags);
oroError_t OROAPI oroMallocAsync(void ** dev_ptr, size_t size, oroStream_t stream);
oroError_t OROAPI oroMallocFromPoolAsync(void ** dev_ptr, size_t size, oroMemPool_t mem_pool, oroStream_t stream);
oroError_t OROAPI oroMallocHost(void ** ptr, size_t size);
oroError_t OROAPI oroMallocManaged(void ** dev_ptr, size_t size, unsigned int flags);
oroError_t OROAPI oroMallocMipmappedArray(oroMipmappedArray_t * mipmappedArray, const  oroChannelFormatDesc * desc,  oroExtent extent, unsigned int numLevels, unsigned int flags);
oroError_t OROAPI oroMallocPitch(void ** ptr, size_t * pitch, size_t width, size_t height);
oroError_t OROAPI oroMemAddressFree(void * devPtr, size_t size);
oroError_t OROAPI oroMemAddressReserve(void ** ptr, size_t size, size_t alignment, void * addr, unsigned long long flags);
oroError_t OROAPI oroMemAdvise(const void * dev_ptr, size_t count, oroMemoryAdvise advice, int device);
oroError_t OROAPI oroMemAllocHost(void ** ptr, size_t size);
oroError_t OROAPI oroMemAllocPitch(oroDeviceptr_t * dptr, size_t * pitch, size_t widthInBytes, size_t height, unsigned int elementSizeBytes);
oroError_t OROAPI oroMemCreate(oroMemGenericAllocationHandle_t * handle, size_t size, const oroMemAllocationProp * prop, unsigned long long flags);
oroError_t OROAPI oroMemExportToShareableHandle(void * shareableHandle, oroMemGenericAllocationHandle_t handle, oroMemAllocationHandleType handleType, unsigned long long flags);
oroError_t OROAPI oroMemGetAccess(unsigned long long * flags, const oroMemLocation * location, void * ptr);
oroError_t OROAPI oroMemGetAddressRange(oroDeviceptr_t * pbase, size_t * psize, oroDeviceptr_t dptr);
oroError_t OROAPI oroMemGetAllocationGranularity(size_t * granularity, const oroMemAllocationProp * prop, oroMemAllocationGranularity_flags option);
oroError_t OROAPI oroMemGetAllocationPropertiesFromHandle(oroMemAllocationProp * prop, oroMemGenericAllocationHandle_t handle);
oroError_t OROAPI oroMemGetInfo(size_t * free, size_t * total);
oroError_t OROAPI oroMemImportFromShareableHandle(oroMemGenericAllocationHandle_t * handle, void * osHandle, oroMemAllocationHandleType shHandleType);
oroError_t OROAPI oroMemMap(void * ptr, size_t size, size_t offset, oroMemGenericAllocationHandle_t handle, unsigned long long flags);
oroError_t OROAPI oroMemMapArrayAsync(oroArrayMapInfo * mapInfoList, unsigned int count, oroStream_t stream);
oroError_t OROAPI oroMemPoolCreate(oroMemPool_t * mem_pool, const oroMemPoolProps * pool_props);
oroError_t OROAPI oroMemPoolDestroy(oroMemPool_t mem_pool);
oroError_t OROAPI oroMemPoolExportPointer(oroMemPoolPtrExportData * export_data, void * dev_ptr);
oroError_t OROAPI oroMemPoolExportToShareableHandle(void * shared_handle, oroMemPool_t mem_pool, oroMemAllocationHandleType handle_type, unsigned int flags);
oroError_t OROAPI oroMemPoolGetAccess(oroMemAccessFlags * flags, oroMemPool_t mem_pool, oroMemLocation * location);
oroError_t OROAPI oroMemPoolGetAttribute(oroMemPool_t mem_pool, oroMemPoolAttr attr, void * value);
oroError_t OROAPI oroMemPoolImportFromShareableHandle(oroMemPool_t * mem_pool, void * shared_handle, oroMemAllocationHandleType handle_type, unsigned int flags);
oroError_t OROAPI oroMemPoolImportPointer(void ** dev_ptr, oroMemPool_t mem_pool, oroMemPoolPtrExportData * export_data);
oroError_t OROAPI oroMemPoolSetAccess(oroMemPool_t mem_pool, const oroMemAccessDesc * desc_list, size_t count);
oroError_t OROAPI oroMemPoolSetAttribute(oroMemPool_t mem_pool, oroMemPoolAttr attr, void * value);
oroError_t OROAPI oroMemPoolTrimTo(oroMemPool_t mem_pool, size_t min_bytes_to_hold);
oroError_t OROAPI oroMemPrefetchAsync(const void * dev_ptr, size_t count, int device, oroStream_t stream);
oroError_t OROAPI oroMemRangeGetAttribute(void * data, size_t data_size, oroMemRangeAttribute attribute, const void * dev_ptr, size_t count);
oroError_t OROAPI oroMemRangeGetAttributes(void ** data, size_t * data_sizes, oroMemRangeAttribute * attributes, size_t num_attributes, const void * dev_ptr, size_t count);
oroError_t OROAPI oroMemRelease(oroMemGenericAllocationHandle_t handle);
oroError_t OROAPI oroMemRetainAllocationHandle(oroMemGenericAllocationHandle_t * handle, void * addr);
oroError_t OROAPI oroMemSetAccess(void * ptr, size_t size, const oroMemAccessDesc * desc, size_t count);
oroError_t OROAPI oroMemUnmap(void * ptr, size_t size);
oroError_t OROAPI oroMemcpy(void * dst, const void * src, size_t sizeBytes, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpy2D(void * dst, size_t dpitch, const void * src, size_t spitch, size_t width, size_t height, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpy2DAsync(void * dst, size_t dpitch, const void * src, size_t spitch, size_t width, size_t height, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpy2DFromArray(void * dst, size_t dpitch, oroArray_const_t src, size_t wOffset, size_t hOffset, size_t width, size_t height, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpy2DFromArrayAsync(void * dst, size_t dpitch, oroArray_const_t src, size_t wOffset, size_t hOffset, size_t width, size_t height, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpy2DToArray(oroArray_t dst, size_t wOffset, size_t hOffset, const void * src, size_t spitch, size_t width, size_t height, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpy2DToArrayAsync(oroArray_t dst, size_t wOffset, size_t hOffset, const void * src, size_t spitch, size_t width, size_t height, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpy3D(const  oroMemcpy3DParms * p);
oroError_t OROAPI oroMemcpy3DAsync(const  oroMemcpy3DParms * p, oroStream_t stream);
oroError_t OROAPI oroMemcpyAsync(void * dst, const void * src, size_t sizeBytes, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpyAtoH(void * dst, oroArray_t srcArray, size_t srcOffset, size_t count);
oroError_t OROAPI oroMemcpyDtoD(oroDeviceptr_t dst, oroDeviceptr_t src, size_t sizeBytes);
oroError_t OROAPI oroMemcpyDtoDAsync(oroDeviceptr_t dst, oroDeviceptr_t src, size_t sizeBytes, oroStream_t stream);
oroError_t OROAPI oroMemcpyDtoH(void * dst, oroDeviceptr_t src, size_t sizeBytes);
oroError_t OROAPI oroMemcpyDtoHAsync(void * dst, oroDeviceptr_t src, size_t sizeBytes, oroStream_t stream);
oroError_t OROAPI oroMemcpyFromArray(void * dst, oroArray_const_t srcArray, size_t wOffset, size_t hOffset, size_t count, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpyFromSymbol(void * dst, const void * symbol, size_t sizeBytes, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpyFromSymbolAsync(void * dst, const void * symbol, size_t sizeBytes, size_t offset, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpyHtoA(oroArray_t dstArray, size_t dstOffset, const void * srcHost, size_t count);
oroError_t OROAPI oroMemcpyHtoD(oroDeviceptr_t dst, void * src, size_t sizeBytes);
oroError_t OROAPI oroMemcpyHtoDAsync(oroDeviceptr_t dst, void * src, size_t sizeBytes, oroStream_t stream);
oroError_t OROAPI oroMemcpyParam2D(const oro_Memcpy2D * pCopy);
oroError_t OROAPI oroMemcpyParam2DAsync(const oro_Memcpy2D * pCopy, oroStream_t stream);
oroError_t OROAPI oroMemcpyPeer(void * dst, int dstDeviceId, const void * src, int srcDeviceId, size_t sizeBytes);
oroError_t OROAPI oroMemcpyPeerAsync(void * dst, int dstDeviceId, const void * src, int srcDevice, size_t sizeBytes, oroStream_t stream);
oroError_t OROAPI oroMemcpyToArray(oroArray_t dst, size_t wOffset, size_t hOffset, const void * src, size_t count, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpyToSymbol(const void * symbol, const void * src, size_t sizeBytes, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroMemcpyToSymbolAsync(const void * symbol, const void * src, size_t sizeBytes, size_t offset, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemcpyWithStream(void * dst, const void * src, size_t sizeBytes, oroMemcpyKind kind, oroStream_t stream);
oroError_t OROAPI oroMemset(void * dst, int value, size_t sizeBytes);
oroError_t OROAPI oroMemset2D(void * dst, size_t pitch, int value, size_t width, size_t height);
oroError_t OROAPI oroMemset2DAsync(void * dst, size_t pitch, int value, size_t width, size_t height, oroStream_t stream);
oroError_t OROAPI oroMemset3D(oroPitchedPtr pitchedDevPtr, int value, oroExtent extent);
oroError_t OROAPI oroMemset3DAsync(oroPitchedPtr pitchedDevPtr, int value, oroExtent extent, oroStream_t stream);
oroError_t OROAPI oroMemsetAsync(void * dst, int value, size_t sizeBytes, oroStream_t stream);
oroError_t OROAPI oroMemsetD16(oroDeviceptr_t dest, unsigned short value, size_t count);
oroError_t OROAPI oroMemsetD16Async(oroDeviceptr_t dest, unsigned short value, size_t count, oroStream_t stream);
oroError_t OROAPI oroMemsetD32(oroDeviceptr_t dest, int value, size_t count);
oroError_t OROAPI oroMemsetD32Async(oroDeviceptr_t dst, int value, size_t count, oroStream_t stream);
oroError_t OROAPI oroMemsetD8(oroDeviceptr_t dest, unsigned char value, size_t count);
oroError_t OROAPI oroMemsetD8Async(oroDeviceptr_t dest, unsigned char value, size_t count, oroStream_t stream);
oroError_t OROAPI oroMipmappedArrayCreate(oroMipmappedArray_t * pHandle, ORO_ARRAY3D_DESCRIPTOR * pMipmappedArrayDesc, unsigned int numMipmapLevels);
oroError_t OROAPI oroMipmappedArrayDestroy(oroMipmappedArray_t hMipmappedArray);
oroError_t OROAPI oroMipmappedArrayGetLevel(oroArray_t * pLevelArray, oroMipmappedArray_t hMipMappedArray, unsigned int level);
oroError_t OROAPI oroModuleGetFunction(oroFunction_t * function, oroModule_t module, const char * kname);
oroError_t OROAPI oroModuleGetGlobal(oroDeviceptr_t * dptr, size_t * bytes, oroModule_t hmod, const char * name);
oroError_t OROAPI oroModuleGetTexRef(textureReference ** texRef, oroModule_t hmod, const char * name);
oroError_t OROAPI oroModuleLaunchCooperativeKernel(oroFunction_t f, unsigned int gridDimX, unsigned int gridDimY, unsigned int gridDimZ, unsigned int blockDimX, unsigned int blockDimY, unsigned int blockDimZ, unsigned int sharedMemBytes, oroStream_t stream, void ** kernelParams);
oroError_t OROAPI oroModuleLaunchCooperativeKernelMultiDevice(oroFunctionLaunchParams * launchParamsList, unsigned int numDevices, unsigned int flags);
oroError_t OROAPI oroModuleLaunchKernel(oroFunction_t f, unsigned int gridDimX, unsigned int gridDimY, unsigned int gridDimZ, unsigned int blockDimX, unsigned int blockDimY, unsigned int blockDimZ, unsigned int sharedMemBytes, oroStream_t stream, const void* const* kernelParams, const void* const* extra);
oroError_t OROAPI oroModuleLoad(oroModule_t * module, const char * fname);
oroError_t OROAPI oroModuleLoadData(oroModule_t * module, const void * image);
oroError_t OROAPI oroModuleLoadDataEx(oroModule_t * module, const void * image, unsigned int numOptions, oroJitOption * options, void ** optionValues);
oroError_t OROAPI oroModuleOccupancyMaxActiveBlocksPerMultiprocessor(int * numBlocks, oroFunction_t f, int blockSize, size_t dynSharedMemPerBlk);
oroError_t OROAPI oroModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(int * numBlocks, oroFunction_t f, int blockSize, size_t dynSharedMemPerBlk, unsigned int flags);
oroError_t OROAPI oroModuleOccupancyMaxPotentialBlockSize(int * gridSize, int * blockSize, oroFunction_t f, size_t dynSharedMemPerBlk, int blockSizeLimit);
oroError_t OROAPI oroModuleOccupancyMaxPotentialBlockSizeWithFlags(int * gridSize, int * blockSize, oroFunction_t f, size_t dynSharedMemPerBlk, int blockSizeLimit, unsigned int flags);
oroError_t OROAPI oroModuleUnload(oroModule_t module);
oroError_t OROAPI oroOccupancyMaxActiveBlocksPerMultiprocessor(int * numBlocks, const void * f, int blockSize, size_t dynSharedMemPerBlk);
oroError_t OROAPI oroOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(int * numBlocks, const void * f, int blockSize, size_t dynSharedMemPerBlk, unsigned int flags);
oroError_t OROAPI oroPeekAtLastError();
oroError_t OROAPI oroPointerGetAttribute(void * data, oroPointer_attribute attribute, oroDeviceptr_t ptr);
oroError_t OROAPI oroPointerGetAttributes(oroPointerAttribute_t * attributes, const void * ptr);
oroError_t OROAPI oroProfilerStart();
oroError_t OROAPI oroProfilerStop();
oroError_t OROAPI oroRuntimeGetVersion(int * runtimeVersion);
oroError_t OROAPI oroSetDevice(int deviceId);
oroError_t OROAPI oroSetDeviceFlags(unsigned int flags);
oroError_t OROAPI oroSignalExternalSemaphoresAsync(const oroExternalSemaphore_t * extSemArray, const oroExternalSemaphoreSignalParams * paramsArray, unsigned int numExtSems, oroStream_t stream);
oroError_t OROAPI oroStreamAddCallback(oroStream_t stream, oroStreamCallback_t callback, void * userData, unsigned int flags);
oroError_t OROAPI oroStreamAttachMemAsync(oroStream_t stream, void * dev_ptr, size_t length, unsigned int flags);
oroError_t OROAPI oroStreamCreate(oroStream_t * stream);
oroError_t OROAPI oroStreamCreateWithFlags(oroStream_t * stream, unsigned int flags);
oroError_t OROAPI oroStreamCreateWithPriority(oroStream_t * stream, unsigned int flags, int priority);
oroError_t OROAPI oroStreamDestroy(oroStream_t stream);
oroError_t OROAPI oroStreamGetDevice(oroStream_t stream, oroDevice_t * device);
oroError_t OROAPI oroStreamGetFlags(oroStream_t stream, unsigned int * flags);
oroError_t OROAPI oroStreamGetPriority(oroStream_t stream, int * priority);
oroError_t OROAPI oroStreamQuery(oroStream_t stream);
oroError_t OROAPI oroStreamSynchronize(oroStream_t stream);
oroError_t OROAPI oroStreamWaitEvent(oroStream_t stream, oroEvent_t event, unsigned int flags);
oroError_t OROAPI oroWaitExternalSemaphoresAsync(const oroExternalSemaphore_t * extSemArray, const oroExternalSemaphoreWaitParams * paramsArray, unsigned int numExtSems, oroStream_t stream);
orortcResult OROAPI orortcAddNameExpression(orortcProgram prog, const char * name_expression);
orortcResult OROAPI orortcCompileProgram(orortcProgram prog, int numOptions, const char ** options);
orortcResult OROAPI orortcCreateProgram(orortcProgram * prog, const char * src, const char * name, int numHeaders, const char ** headers, const char ** includeNames);
orortcResult OROAPI orortcDestroyProgram(orortcProgram * prog);
orortcResult OROAPI orortcGetCode(orortcProgram prog, char * code);
orortcResult OROAPI orortcGetCodeSize(orortcProgram prog, size_t * codeSizeRet);
const char * OROAPI orortcGetErrorString(orortcResult result);
orortcResult OROAPI orortcGetLoweredName(orortcProgram prog, const char * name_expression, const char ** lowered_name);
orortcResult OROAPI orortcGetProgramLog(orortcProgram prog, char * log);
orortcResult OROAPI orortcGetProgramLogSize(orortcProgram prog, size_t * logSizeRet);
orortcResult OROAPI orortcVersion(int * major, int * minor);
oroError_t OROAPI oroArray3DCreate(oroArray_t * array, const ORO_ARRAY3D_DESCRIPTOR * pAllocateArray);
oroError_t OROAPI oroArray3DGetDescriptor(ORO_ARRAY3D_DESCRIPTOR * pArrayDescriptor, oroArray_t array);
oroError_t OROAPI oroArrayCreate(oroArray_t * pHandle, const ORO_ARRAY_DESCRIPTOR * pAllocateArray);
oroError_t OROAPI oroArrayDestroy(oroArray_t array);
oroError_t OROAPI oroArrayGetDescriptor(ORO_ARRAY_DESCRIPTOR * pArrayDescriptor, oroArray_t array);
oroError_t OROAPI oroArrayGetInfo(oroChannelFormatDesc * desc, oroExtent * extent, unsigned int * flags, oroArray_t array);
oroError_t OROAPI oroDeviceGetGraphMemAttribute(int device, oroGraphMemAttributeType attr, void * value);
oroError_t OROAPI oroDeviceGraphMemTrim(int device);
oroError_t OROAPI oroDeviceSetGraphMemAttribute(int device, oroGraphMemAttributeType attr, void * value);
oroError_t OROAPI oroDrvGraphAddMemcpyNode(oroGraphNode_t * phGraphNode, oroGraph_t hGraph, const oroGraphNode_t * dependencies, size_t numDependencies, const ORO_MEMCPY3D * copyParams, oroCtx_t ctx);
oroError_t OROAPI oroDrvMemcpy2DUnaligned(const oro_Memcpy2D * pCopy);
oroError_t OROAPI oroGetTextureObjectResourceViewDesc( oroResourceViewDesc * pResViewDesc, oroTextureObject_t textureObject);
oroError_t OROAPI oroGetTextureObjectTextureDesc(oroTextureDesc * pTexDesc, oroTextureObject_t textureObject);
oroError_t OROAPI oroGraphAddChildGraphNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, oroGraph_t childGraph);
oroError_t OROAPI oroGraphAddDependencies(oroGraph_t graph, const oroGraphNode_t * from, const oroGraphNode_t * to, size_t numDependencies);
oroError_t OROAPI oroGraphAddEmptyNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies);
oroError_t OROAPI oroGraphAddEventRecordNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, oroEvent_t event);
oroError_t OROAPI oroGraphAddEventWaitNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, oroEvent_t event);
oroError_t OROAPI oroGraphAddHostNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, const oroHostNodeParams * pNodeParams);
oroError_t OROAPI oroGraphAddKernelNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, const oroKernelNodeParams * pNodeParams);
oroError_t OROAPI oroGraphAddMemAllocNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, oroMemAllocNodeParams * pNodeParams);
oroError_t OROAPI oroGraphAddMemFreeNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, void * dev_ptr);
oroError_t OROAPI oroGraphAddMemcpyNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, const oroMemcpy3DParms * pCopyParams);
oroError_t OROAPI oroGraphAddMemcpyNode1D(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, void * dst, const void * src, size_t count, oroMemcpyKind kind);
oroError_t OROAPI oroGraphAddMemcpyNodeFromSymbol(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, void * dst, const void * symbol, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphAddMemcpyNodeToSymbol(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, const void * symbol, const void * src, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphAddMemsetNode(oroGraphNode_t * pGraphNode, oroGraph_t graph, const oroGraphNode_t * pDependencies, size_t numDependencies, const oroMemsetParams * pMemsetParams);
oroError_t OROAPI oroGraphChildGraphNodeGetGraph(oroGraphNode_t node, oroGraph_t * pGraph);
oroError_t OROAPI oroGraphClone(oroGraph_t * pGraphClone, oroGraph_t originalGraph);
oroError_t OROAPI oroGraphCreate(oroGraph_t * pGraph, unsigned int flags);
oroError_t OROAPI oroGraphDebugDotPrint(oroGraph_t graph, const char * path, unsigned int flags);
oroError_t OROAPI oroGraphDestroy(oroGraph_t graph);
oroError_t OROAPI oroGraphDestroyNode(oroGraphNode_t node);
oroError_t OROAPI oroGraphEventRecordNodeGetEvent(oroGraphNode_t node, oroEvent_t * event_out);
oroError_t OROAPI oroGraphEventRecordNodeSetEvent(oroGraphNode_t node, oroEvent_t event);
oroError_t OROAPI oroGraphEventWaitNodeGetEvent(oroGraphNode_t node, oroEvent_t * event_out);
oroError_t OROAPI oroGraphEventWaitNodeSetEvent(oroGraphNode_t node, oroEvent_t event);
oroError_t OROAPI oroGraphExecChildGraphNodeSetParams(oroGraphExec_t hGraphExec, oroGraphNode_t node, oroGraph_t childGraph);
oroError_t OROAPI oroGraphExecDestroy(oroGraphExec_t graphExec);
oroError_t OROAPI oroGraphExecEventRecordNodeSetEvent(oroGraphExec_t hGraphExec, oroGraphNode_t hNode, oroEvent_t event);
oroError_t OROAPI oroGraphExecEventWaitNodeSetEvent(oroGraphExec_t hGraphExec, oroGraphNode_t hNode, oroEvent_t event);
oroError_t OROAPI oroGraphExecHostNodeSetParams(oroGraphExec_t hGraphExec, oroGraphNode_t node, const oroHostNodeParams * pNodeParams);
oroError_t OROAPI oroGraphExecKernelNodeSetParams(oroGraphExec_t hGraphExec, oroGraphNode_t node, const oroKernelNodeParams * pNodeParams);
oroError_t OROAPI oroGraphExecMemcpyNodeSetParams(oroGraphExec_t hGraphExec, oroGraphNode_t node, oroMemcpy3DParms * pNodeParams);
oroError_t OROAPI oroGraphExecMemcpyNodeSetParams1D(oroGraphExec_t hGraphExec, oroGraphNode_t node, void * dst, const void * src, size_t count, oroMemcpyKind kind);
oroError_t OROAPI oroGraphExecMemcpyNodeSetParamsFromSymbol(oroGraphExec_t hGraphExec, oroGraphNode_t node, void * dst, const void * symbol, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphExecMemcpyNodeSetParamsToSymbol(oroGraphExec_t hGraphExec, oroGraphNode_t node, const void * symbol, const void * src, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphExecMemsetNodeSetParams(oroGraphExec_t hGraphExec, oroGraphNode_t node, const oroMemsetParams * pNodeParams);
oroError_t OROAPI oroGraphGetEdges(oroGraph_t graph, oroGraphNode_t * from, oroGraphNode_t * to, size_t * numEdges);
oroError_t OROAPI oroGraphGetNodes(oroGraph_t graph, oroGraphNode_t * nodes, size_t * numNodes);
oroError_t OROAPI oroGraphGetRootNodes(oroGraph_t graph, oroGraphNode_t * pRootNodes, size_t * pNumRootNodes);
oroError_t OROAPI oroGraphHostNodeGetParams(oroGraphNode_t node, oroHostNodeParams * pNodeParams);
oroError_t OROAPI oroGraphHostNodeSetParams(oroGraphNode_t node, const oroHostNodeParams * pNodeParams);
oroError_t OROAPI oroGraphInstantiateWithFlags(oroGraphExec_t * pGraphExec, oroGraph_t graph, unsigned long long flags);
oroError_t OROAPI oroGraphKernelNodeCopyAttributes(oroGraphNode_t hSrc, oroGraphNode_t hDst);
oroError_t OROAPI oroGraphKernelNodeGetAttribute(oroGraphNode_t hNode, oroKernelNodeAttrID attr, oroKernelNodeAttrValue * value);
oroError_t OROAPI oroGraphKernelNodeGetParams(oroGraphNode_t node, oroKernelNodeParams * pNodeParams);
oroError_t OROAPI oroGraphKernelNodeSetAttribute(oroGraphNode_t hNode, oroKernelNodeAttrID attr, const oroKernelNodeAttrValue * value);
oroError_t OROAPI oroGraphKernelNodeSetParams(oroGraphNode_t node, const oroKernelNodeParams * pNodeParams);
oroError_t OROAPI oroGraphLaunch(oroGraphExec_t graphExec, oroStream_t stream);
oroError_t OROAPI oroGraphMemAllocNodeGetParams(oroGraphNode_t node, oroMemAllocNodeParams * pNodeParams);
oroError_t OROAPI oroGraphMemFreeNodeGetParams(oroGraphNode_t node, void * dev_ptr);
oroError_t OROAPI oroGraphMemcpyNodeGetParams(oroGraphNode_t node, oroMemcpy3DParms * pNodeParams);
oroError_t OROAPI oroGraphMemcpyNodeSetParams(oroGraphNode_t node, const oroMemcpy3DParms * pNodeParams);
oroError_t OROAPI oroGraphMemcpyNodeSetParams1D(oroGraphNode_t node, void * dst, const void * src, size_t count, oroMemcpyKind kind);
oroError_t OROAPI oroGraphMemcpyNodeSetParamsFromSymbol(oroGraphNode_t node, void * dst, const void * symbol, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphMemcpyNodeSetParamsToSymbol(oroGraphNode_t node, const void * symbol, const void * src, size_t count, size_t offset, oroMemcpyKind kind);
oroError_t OROAPI oroGraphMemsetNodeGetParams(oroGraphNode_t node, oroMemsetParams * pNodeParams);
oroError_t OROAPI oroGraphMemsetNodeSetParams(oroGraphNode_t node, const oroMemsetParams * pNodeParams);
oroError_t OROAPI oroGraphNodeFindInClone(oroGraphNode_t * pNode, oroGraphNode_t originalNode, oroGraph_t clonedGraph);
oroError_t OROAPI oroGraphNodeGetDependencies(oroGraphNode_t node, oroGraphNode_t * pDependencies, size_t * pNumDependencies);
oroError_t OROAPI oroGraphNodeGetDependentNodes(oroGraphNode_t node, oroGraphNode_t * pDependentNodes, size_t * pNumDependentNodes);
oroError_t OROAPI oroGraphNodeGetEnabled(oroGraphExec_t hGraphExec, oroGraphNode_t hNode, unsigned int * isEnabled);
oroError_t OROAPI oroGraphNodeGetType(oroGraphNode_t node, oroGraphNodeType * pType);
oroError_t OROAPI oroGraphNodeSetEnabled(oroGraphExec_t hGraphExec, oroGraphNode_t hNode, unsigned int isEnabled);
oroError_t OROAPI oroGraphReleaseUserObject(oroGraph_t graph, oroUserObject_t object, unsigned int count);
oroError_t OROAPI oroGraphRemoveDependencies(oroGraph_t graph, const oroGraphNode_t * from, const oroGraphNode_t * to, size_t numDependencies);
oroError_t OROAPI oroGraphRetainUserObject(oroGraph_t graph, oroUserObject_t object, unsigned int count, unsigned int flags);
oroError_t OROAPI oroGraphUpload(oroGraphExec_t graphExec, oroStream_t stream);
oroError_t OROAPI oroLaunchHostFunc(oroStream_t stream, oroHostFn_t fn, void * userData);
oroError_t OROAPI oroPointerSetAttribute(const void * value, oroPointer_attribute attribute, oroDeviceptr_t ptr);
oroError_t OROAPI oroStreamBeginCapture(oroStream_t stream, oroStreamCaptureMode mode);
oroError_t OROAPI oroStreamEndCapture(oroStream_t stream, oroGraph_t * pGraph);
oroError_t OROAPI oroStreamGetCaptureInfo_v2(oroStream_t stream, oroStreamCaptureStatus * captureStatus_out, unsigned long long * id_out, oroGraph_t * graph_out, const oroGraphNode_t ** dependencies_out, size_t * numDependencies_out);
oroError_t OROAPI oroStreamIsCapturing(oroStream_t stream, oroStreamCaptureStatus * pCaptureStatus);
oroError_t OROAPI oroStreamUpdateCaptureDependencies(oroStream_t stream, oroGraphNode_t * dependencies, size_t numDependencies, unsigned int flags);
oroError_t OROAPI oroTexObjectCreate(oroTextureObject_t * pTexObject, const ORO_RESOURCE_DESC * pResDesc, const ORO_TEXTURE_DESC * pTexDesc, const ORO_RESOURCE_VIEW_DESC * pResViewDesc);
oroError_t OROAPI oroTexObjectDestroy(oroTextureObject_t texObject);
oroError_t OROAPI oroTexObjectGetResourceDesc(ORO_RESOURCE_DESC * pResDesc, oroTextureObject_t texObject);
oroError_t OROAPI oroTexObjectGetResourceViewDesc(ORO_RESOURCE_VIEW_DESC * pResViewDesc, oroTextureObject_t texObject);
oroError_t OROAPI oroTexObjectGetTextureDesc(ORO_TEXTURE_DESC * pTexDesc, oroTextureObject_t texObject);
oroError_t OROAPI oroTexRefGetAddress(oroDeviceptr_t * dev_ptr, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetAddressMode( oroTextureAddressMode * pam, const textureReference * texRef, int dim);
oroError_t OROAPI oroTexRefGetFilterMode( oroTextureFilterMode * pfm, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetFlags(unsigned int * pFlags, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetFormat(oroArray_Format * pFormat, int * pNumChannels, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetMaxAnisotropy(int * pmaxAnsio, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetMipmapFilterMode( oroTextureFilterMode * pfm, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetMipmapLevelBias(float * pbias, const textureReference * texRef);
oroError_t OROAPI oroTexRefGetMipmapLevelClamp(float * pminMipmapLevelClamp, float * pmaxMipmapLevelClamp, const textureReference * texRef);
oroError_t OROAPI oroTexRefSetAddress(size_t * ByteOffset, textureReference * texRef, oroDeviceptr_t dptr, size_t bytes);
oroError_t OROAPI oroTexRefSetAddress2D(textureReference * texRef, const ORO_ARRAY_DESCRIPTOR * desc, oroDeviceptr_t dptr, size_t Pitch);
oroError_t OROAPI oroTexRefSetAddressMode(textureReference * texRef, int dim,  oroTextureAddressMode am);
oroError_t OROAPI oroTexRefSetArray(textureReference * tex, oroArray_const_t array, unsigned int flags);
oroError_t OROAPI oroTexRefSetBorderColor(textureReference * texRef, float * pBorderColor);
oroError_t OROAPI oroTexRefSetFilterMode(textureReference * texRef,  oroTextureFilterMode fm);
oroError_t OROAPI oroTexRefSetFlags(textureReference * texRef, unsigned int Flags);
oroError_t OROAPI oroTexRefSetFormat(textureReference * texRef, oroArray_Format fmt, int NumPackedComponents);
oroError_t OROAPI oroTexRefSetMaxAnisotropy(textureReference * texRef, unsigned int maxAniso);
oroError_t OROAPI oroTexRefSetMipmapFilterMode(textureReference * texRef,  oroTextureFilterMode fm);
oroError_t OROAPI oroTexRefSetMipmapLevelBias(textureReference * texRef, float bias);
oroError_t OROAPI oroTexRefSetMipmapLevelClamp(textureReference * texRef, float minMipMapLevelClamp, float maxMipMapLevelClamp);
oroError_t OROAPI oroTexRefSetMipmappedArray(textureReference * texRef,  oroMipmappedArray * mipmappedArray, unsigned int Flags);
oroError_t OROAPI oroThreadExchangeStreamCaptureMode(oroStreamCaptureMode * mode);
oroError_t OROAPI oroUserObjectCreate(oroUserObject_t * object_out, void * ptr, oroHostFn_t destroy, unsigned int initialRefcount, unsigned int flags);
oroError_t OROAPI oroUserObjectRelease(oroUserObject_t object, unsigned int count);
oroError_t OROAPI oroUserObjectRetain(oroUserObject_t object, unsigned int count);
orortcResult OROAPI orortcLinkAddData(orortcLinkState hip_link_state, orortcJITInputType input_type, void * image, size_t image_size, const char * name, unsigned int num_options, orortcJIT_option * options_ptr, void ** option_values);
orortcResult OROAPI orortcLinkAddFile(orortcLinkState hip_link_state, orortcJITInputType input_type, const char * file_path, unsigned int num_options, orortcJIT_option * options_ptr, void ** option_values);
orortcResult OROAPI orortcLinkComplete(orortcLinkState hip_link_state, void ** bin_out, size_t * size_out);
orortcResult OROAPI orortcLinkCreate(unsigned int num_options, orortcJIT_option * option_ptr, void ** option_vals_pptr, orortcLinkState * hip_link_state_ptr);
orortcResult OROAPI orortcLinkDestroy(orortcLinkState hip_link_state);


///// END REGION: OROCHI_SUMMONER_REGION_orochi_h
///// (region automatically generated by Orochi Summoner)
#pragma endregion





enum oroApi
{
	ORO_API_AUTOMATIC = 1<<0,
	ORO_API_HIPDRIVER = 1 << 1,
	ORO_API_HIPRTC = 1 << 2,
	ORO_API_HIP = ORO_API_HIPDRIVER | ORO_API_HIPRTC,
	ORO_API_CUDADRIVER = 1 << 3,
	ORO_API_CUDARTC = 1 << 4,
	ORO_API_CUDA = ORO_API_CUDADRIVER | ORO_API_CUDARTC,
};



typedef hipDeviceProp_t oroDeviceProp_t;
typedef oroDeviceProp_t oroDeviceProp;


typedef unsigned int oroU32;

// oroCtx represent a special struct override by Orochi.
// It doesn't represent the original 'hipCtx_t'
typedef struct ioroCtx_t* oroCtx;


#define oroHostRegisterPortable hipHostRegisterPortable
#define oroHostRegisterMapped hipHostRegisterMapped
#define oroHostRegisterIoMemory hipHostRegisterIoMemory
#define ORO_LAUNCH_PARAM_BUFFER_POINTER HIP_LAUNCH_PARAM_BUFFER_POINTER
#define ORO_LAUNCH_PARAM_BUFFER_SIZE HIP_LAUNCH_PARAM_BUFFER_SIZE
#define ORO_EXTERNAL_MEMORY_DEDICATED 0x1
#define ORO_TRSF_READ_AS_INTEGER 0x01
#define oroArrayDefault hipArrayDefault


typedef enum oroEvent_flags_enum
{
	oroEventDefault = 0x0,
	oroEventBlockingSync = 0x1,
	oroEventDisableTiming = 0x2,
	oroEventInterprocess = 0x4,
} oroEvent_flags;


typedef enum PPshared_carveout_enum {
	ORO_SHAREDMEM_CARVEOUT_DEFAULT,
	ORO_SHAREDMEM_CARVEOUT_MAX_SHARED = 100,
	ORO_SHAREDMEM_CARVEOUT_MAX_L1 = 0,
} PPshared_carveout;


typedef enum OROmem_advise_enum {
	ORO_MEM_ADVISE_SET_READ_MOSTLY = 1,
	ORO_MEM_ADVISE_UNSET_READ_MOSTLY = 2,
	ORO_MEM_ADVISE_SET_PREFERRED_LOCATION = 3,
	ORO_MEM_ADVISE_UNSET_PREFERRED_LOCATION = 4,
	ORO_MEM_ADVISE_SET_ACCESSED_BY = 5,
	ORO_MEM_ADVISE_UNSET_ACCESSED_BY = 6,
} PPmem_advise;

typedef enum OROmem_range_attribute_enum {
	ORO_MEM_RANGE_ATTRIBUTE_READ_MOSTLY = 1,
	ORO_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = 2,
	ORO_MEM_RANGE_ATTRIBUTE_ACCESSED_BY = 3,
	ORO_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = 4,
} PPmem_range_attribute;

typedef enum oroManagedMemoryAttachFlags
{
	oroMemAttachGlobal = 0x1,
	oroMemAttachHost = 0x2,
	oroMemAttachSingle = 0x4,
}oroManagedMemoryAttachFlags;


enum {
	ORO_SUCCESS = 0,
	ORO_ERROR_OPEN_FAILED = -1,
	ORO_ERROR_ATEXIT_FAILED = -2,
	ORO_ERROR_OLD_DRIVER = -3,
};


//
// Functions of Orochi that are not part of the Orochi Summoner auto-generated source code.
// They are either functions specific to Orochi ( not part of Hip/Cuda API ),  or because they are too complex to be automatically generated by Orochi Summoner.
// Any function declared here will be detected by Orochi Summoner and not auto-generated.
//

// customPaths_** are optional parameters
//   They be used to overide the default values defined in Orochi.
//   It's a list of C-strings. This list must have a NULL as last element.
//   The order of the elements matters: the first library file to exist will be the one loaded.
//   Examples, for Hip on Windows:
//     customPaths_Hip[]    = {"amdhip64_6.dll", "amdhip64.dll", NULL};
//     customPaths_Hiprtc[] = {"hiprtc0600.dll", "hiprtc0507.dll", NULL};
//     Note that those lists are non-correlated, meaning Orochi can take for example the second element of customPaths_Hip and the first element of customPaths_Hiprtc.
int oroInitialize( oroApi api, oroU32 flags, 
	const char** customPaths_Hip hipew__dparm(0),
	const char** customPaths_Hiprtc hipew__dparm(0),
	const char** customPaths_Cuda hipew__dparm(0),
	const char** customPaths_CudaRT hipew__dparm(0),
	const char** customPaths_NvRTC hipew__dparm(0)
	);

oroApi oroLoadedAPI();
oroApi oroGetCurAPI( oroU32 flags );
void* oroGetRawCtx( oroCtx ctx );
oroError oroCtxCreateFromRaw( oroCtx* ctxOut, oroApi api, void* ctxIn );
oroError oroCtxCreateFromRawDestroy( oroCtx ctx );
oroDevice oroGetRawDevice( oroDevice dev );
oroDevice oroSetRawDevice( oroApi api, oroDevice dev );
oroError OROAPI oroGetErrorString(oroError error, const char** pStr) ;
oroError OROAPI oroInit(unsigned int Flags) ;
oroError OROAPI oroGetDeviceCount(int* count, oroApi api = ORO_API_AUTOMATIC ) ;
oroError OROAPI oroGetDeviceProperties(oroDeviceProp_t* props, oroDevice dev) ;
oroError OROAPI oroDeviceGet(oroDevice* device, int ordinal ) ;
oroError OROAPI oroDeviceGetName(char* name, int len, oroDevice dev) ;
oroError OROAPI oroDeviceGetAttribute(int* pi, oroDeviceAttribute_t attrib, oroDevice dev) ;
oroError OROAPI oroCtxCreate(oroCtx* pctx, unsigned int flags, oroDevice dev) ;
oroError OROAPI oroCtxDestroy(oroCtx ctx) ;
oroError OROAPI oroCtxSetCurrent(oroCtx ctx) ;
oroError OROAPI oroCtxGetCurrent(oroCtx* pctx) ;
oroError OROAPI oroCtxGetApiVersion(oroCtx ctx, int* version);


oroChannelFormatDesc OROAPI oroCreateChannelDesc(int x, int y, int z, int w,  oroChannelFormatKind f);
orortcResult OROAPI orortcGetBitcode(orortcProgram prog, char* bitcode);
orortcResult OROAPI orortcGetBitcodeSize(orortcProgram prog, size_t* bitcodeSizeRet);


#endif // if not __CUDACC__ and no __HIPCC__

