#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 4271
#define LARGE_STATE_COUNT 809
#define SYMBOL_COUNT 210
#define ALIAS_COUNT 2
#define TOKEN_COUNT 121
#define EXTERNAL_TOKEN_COUNT 47
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 34

enum ts_symbol_identifiers {
  sym__identifier = 1,
  sym_parbreak = 2,
  aux_sym_escape_token1 = 3,
  aux_sym_url_token1 = 4,
  sym__lb = 5,
  sym_linebreak = 6,
  sym_quote = 7,
  aux_sym_text_token1 = 8,
  anon_sym_COLON = 9,
  anon_sym_BQUOTE_BQUOTE_BQUOTE = 10,
  anon_sym_BQUOTE = 11,
  sym_shorthand = 12,
  anon_sym_DOLLAR = 13,
  sym__math_token_align = 14,
  sym__math_token_rpar = 15,
  sym__math_token_lpar = 16,
  sym__math_token_ldlm = 17,
  sym__math_token_orph = 18,
  sym__math_number = 19,
  aux_sym__math_root_token1 = 20,
  anon_sym_BANG = 21,
  anon_sym_CARET = 22,
  anon_sym__ = 23,
  anon_sym_COMMA = 24,
  anon_sym_SEMI = 25,
  aux_sym__math_shorthand_token1 = 26,
  aux_sym__math_symbol_token1 = 27,
  anon_sym_POUND = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  aux_sym_number_token1 = 31,
  anon_sym_DQUOTE = 32,
  anon_sym_context = 33,
  anon_sym_DOT_DOT = 34,
  aux_sym_assign_token1 = 35,
  anon_sym_EQ_GT = 36,
  anon_sym_or = 37,
  anon_sym_not = 38,
  anon_sym_and = 39,
  anon_sym_LT = 40,
  anon_sym_GT = 41,
  anon_sym_LT_EQ = 42,
  anon_sym_GT_EQ = 43,
  anon_sym_EQ_EQ = 44,
  anon_sym_BANG_EQ = 45,
  anon_sym_in = 46,
  anon_sym_PLUS = 47,
  anon_sym_DASH = 48,
  anon_sym_STAR = 49,
  anon_sym_SLASH = 50,
  anon_sym_DOT = 51,
  anon_sym_AT = 52,
  anon_sym_LPAREN = 53,
  anon_sym_RPAREN = 54,
  anon_sym_LBRACE = 55,
  anon_sym_RBRACE = 56,
  anon_sym_if = 57,
  anon_sym_let = 58,
  anon_sym_EQ = 59,
  anon_sym_set = 60,
  anon_sym_as = 61,
  anon_sym_import = 62,
  anon_sym_COLON2 = 63,
  anon_sym_COMMA2 = 64,
  anon_sym_include = 65,
  anon_sym_for = 66,
  anon_sym_while = 67,
  anon_sym_show = 68,
  anon_sym_return = 69,
  anon_sym_break = 70,
  anon_sym_continue = 71,
  sym_auto = 72,
  sym_none = 73,
  sym__indent = 74,
  sym__dedent = 75,
  sym__redent = 76,
  sym__line_start_check = 77,
  sym__token_content = 78,
  sym__token_strong = 79,
  sym__token_emph = 80,
  sym__barrier = 81,
  sym__token_bracket = 82,
  sym__token_section = 83,
  sym__termination = 84,
  sym__token_inlined_item_end = 85,
  sym__token_inlined_stmt_end = 86,
  sym__token_blocked_expr_end = 87,
  sym__token_math_letter = 88,
  sym__token_math_ident = 89,
  sym__token_math_frac = 90,
  sym__token_math_group_end = 91,
  sym__token_else = 92,
  sym__token_unit = 93,
  sym__token_url = 94,
  sym__token_item = 95,
  sym__token_term = 96,
  sym__token_head_1 = 97,
  sym__token_head_2 = 98,
  sym__token_head_3 = 99,
  sym__token_head_4 = 100,
  sym__token_head_5 = 101,
  sym__token_head_p = 102,
  sym__token_string_blob = 103,
  sym__token_raw_span_blob = 104,
  sym__token_raw_blck_blob = 105,
  sym__token_raw_lang = 106,
  sym__token_identifier = 107,
  sym__token_label = 108,
  sym__token_anti_markup = 109,
  sym_comment = 110,
  sym__sp = 111,
  sym__immediate = 112,
  sym__immediate_paren = 113,
  sym__immediate_brack = 114,
  sym__immediate_ident = 115,
  sym__immediate_math_call = 116,
  sym__immediate_math_apply = 117,
  sym__immediate_math_field = 118,
  sym__immediate_math_prime = 119,
  sym__recovery = 120,
  sym_source_file = 121,
  sym__line_content = 122,
  sym_escape = 123,
  sym_url = 124,
  sym__content_lb = 125,
  sym__brackets = 126,
  sym__markup = 127,
  sym_text = 128,
  sym__indented = 129,
  sym_item = 130,
  sym_term = 131,
  sym__section = 132,
  sym_section = 133,
  sym_heading = 134,
  sym_strong = 135,
  sym_emph = 136,
  sym_raw_blck = 137,
  sym_raw_span = 138,
  sym_math = 139,
  sym_formula = 140,
  sym__math_expr = 141,
  sym__math_token_colon = 142,
  sym__math_group = 143,
  sym__math_item = 144,
  sym__math_div = 145,
  sym__math_root = 146,
  sym__math_fac = 147,
  sym__math_prime = 148,
  sym__math_attach_sup = 149,
  sym__math_attach_sub = 150,
  sym__math_field = 151,
  sym__math_call = 152,
  sym__math_tag = 153,
  sym__math_tagged = 154,
  sym__math_apply = 155,
  sym__math_shorthand = 156,
  sym__math_symbol = 157,
  sym__code = 158,
  sym__item = 159,
  sym__stmt = 160,
  sym__expr = 161,
  sym_ident = 162,
  sym_unit = 163,
  sym_bool = 164,
  sym_number = 165,
  sym_string = 166,
  sym_tagged = 167,
  sym_context = 168,
  sym_elude = 169,
  sym_assign = 170,
  sym_lambda = 171,
  sym_or = 172,
  sym_not = 173,
  sym_and = 174,
  sym_cmp = 175,
  sym_in = 176,
  sym_add = 177,
  sym_sub = 178,
  sym_mul = 179,
  sym_div = 180,
  sym_sign = 181,
  sym_call = 182,
  sym_field = 183,
  sym_label = 184,
  sym_ref = 185,
  sym_content = 186,
  sym_group = 187,
  sym_block = 188,
  sym_branch = 189,
  sym_let = 190,
  sym_set = 191,
  sym_as = 192,
  sym_import = 193,
  sym_include = 194,
  sym_for = 195,
  sym_while = 196,
  sym_show = 197,
  sym_return = 198,
  sym_flow = 199,
  aux_sym_source_file_repeat1 = 200,
  aux_sym__line_content_repeat1 = 201,
  aux_sym_text_repeat1 = 202,
  aux_sym_formula_repeat1 = 203,
  aux_sym__math_call_repeat1 = 204,
  aux_sym_string_repeat1 = 205,
  aux_sym_group_repeat1 = 206,
  aux_sym_block_repeat1 = 207,
  aux_sym_branch_repeat1 = 208,
  aux_sym_import_repeat1 = 209,
  anon_alias_sym_RBRACK = 210,
  alias_sym_wildcard = 211,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [sym_parbreak] = "parbreak",
  [aux_sym_escape_token1] = "escape_token1",
  [aux_sym_url_token1] = "url_token1",
  [sym__lb] = "_lb",
  [sym_linebreak] = "linebreak",
  [sym_quote] = "quote",
  [aux_sym_text_token1] = "text_token1",
  [anon_sym_COLON] = ":",
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = "```",
  [anon_sym_BQUOTE] = "`",
  [sym_shorthand] = "shorthand",
  [anon_sym_DOLLAR] = "$",
  [sym__math_token_align] = "align",
  [sym__math_token_rpar] = ")",
  [sym__math_token_lpar] = "(",
  [sym__math_token_ldlm] = "(",
  [sym__math_token_orph] = "_math_token_orph",
  [sym__math_number] = "number",
  [aux_sym__math_root_token1] = "_math_root_token1",
  [anon_sym_BANG] = "!",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_COMMA] = ",",
  [anon_sym_SEMI] = ";",
  [aux_sym__math_shorthand_token1] = "_math_shorthand_token1",
  [aux_sym__math_symbol_token1] = "_math_symbol_token1",
  [anon_sym_POUND] = "#",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [aux_sym_number_token1] = "number_token1",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_context] = "context",
  [anon_sym_DOT_DOT] = "..",
  [aux_sym_assign_token1] = "assign",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_or] = "or",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_in] = "in",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_if] = "if",
  [anon_sym_let] = "let",
  [anon_sym_EQ] = "=",
  [anon_sym_set] = "set",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_COLON2] = ":",
  [anon_sym_COMMA2] = ",",
  [anon_sym_include] = "include",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [anon_sym_show] = "show",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [sym_auto] = "auto",
  [sym_none] = "none",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__redent] = "_redent",
  [sym__line_start_check] = "_line_start_check",
  [sym__token_content] = "[",
  [sym__token_strong] = "*",
  [sym__token_emph] = "_",
  [sym__barrier] = "_barrier",
  [sym__token_bracket] = "text",
  [sym__token_section] = "_token_section",
  [sym__termination] = "_termination",
  [sym__token_inlined_item_end] = "end",
  [sym__token_inlined_stmt_end] = "end",
  [sym__token_blocked_expr_end] = "sep",
  [sym__token_math_letter] = "letter",
  [sym__token_math_ident] = "ident",
  [sym__token_math_frac] = "/",
  [sym__token_math_group_end] = ")",
  [sym__token_else] = "else",
  [sym__token_unit] = "_token_unit",
  [sym__token_url] = "_token_url",
  [sym__token_item] = "-",
  [sym__token_term] = "/",
  [sym__token_head_1] = "=",
  [sym__token_head_2] = "==",
  [sym__token_head_3] = "===",
  [sym__token_head_4] = "====",
  [sym__token_head_5] = "=====",
  [sym__token_head_p] = "======",
  [sym__token_string_blob] = "_token_string_blob",
  [sym__token_raw_span_blob] = "blob",
  [sym__token_raw_blck_blob] = "blob",
  [sym__token_raw_lang] = "ident",
  [sym__token_identifier] = "_token_identifier",
  [sym__token_label] = "_token_label",
  [sym__token_anti_markup] = "_token_anti_markup",
  [sym_comment] = "comment",
  [sym__sp] = "_sp",
  [sym__immediate] = "_immediate",
  [sym__immediate_paren] = "_immediate_paren",
  [sym__immediate_brack] = "_immediate_brack",
  [sym__immediate_ident] = "_immediate_ident",
  [sym__immediate_math_call] = "_immediate_math_call",
  [sym__immediate_math_apply] = "_immediate_math_apply",
  [sym__immediate_math_field] = "_immediate_math_field",
  [sym__immediate_math_prime] = "_immediate_math_prime",
  [sym__recovery] = "_recovery",
  [sym_source_file] = "source_file",
  [sym__line_content] = "_line_content",
  [sym_escape] = "escape",
  [sym_url] = "url",
  [sym__content_lb] = "_content_lb",
  [sym__brackets] = "_brackets",
  [sym__markup] = "_markup",
  [sym_text] = "text",
  [sym__indented] = "_indented",
  [sym_item] = "item",
  [sym_term] = "term",
  [sym__section] = "content",
  [sym_section] = "section",
  [sym_heading] = "heading",
  [sym_strong] = "strong",
  [sym_emph] = "emph",
  [sym_raw_blck] = "raw_blck",
  [sym_raw_span] = "raw_span",
  [sym_math] = "math",
  [sym_formula] = "formula",
  [sym__math_expr] = "_math_expr",
  [sym__math_token_colon] = "_math_token_colon",
  [sym__math_group] = "_math_group",
  [sym__math_item] = "_math_item",
  [sym__math_div] = "fraction",
  [sym__math_root] = "root",
  [sym__math_fac] = "fac",
  [sym__math_prime] = "prime",
  [sym__math_attach_sup] = "attach",
  [sym__math_attach_sub] = "attach",
  [sym__math_field] = "field",
  [sym__math_call] = "call",
  [sym__math_tag] = "_math_tag",
  [sym__math_tagged] = "tagged",
  [sym__math_apply] = "apply",
  [sym__math_shorthand] = "shorthand",
  [sym__math_symbol] = "symbol",
  [sym__code] = "_code",
  [sym__item] = "_item",
  [sym__stmt] = "_stmt",
  [sym__expr] = "_expr",
  [sym_ident] = "ident",
  [sym_unit] = "unit",
  [sym_bool] = "bool",
  [sym_number] = "number",
  [sym_string] = "string",
  [sym_tagged] = "tagged",
  [sym_context] = "context",
  [sym_elude] = "elude",
  [sym_assign] = "assign",
  [sym_lambda] = "lambda",
  [sym_or] = "or",
  [sym_not] = "not",
  [sym_and] = "and",
  [sym_cmp] = "cmp",
  [sym_in] = "in",
  [sym_add] = "add",
  [sym_sub] = "sub",
  [sym_mul] = "mul",
  [sym_div] = "div",
  [sym_sign] = "sign",
  [sym_call] = "call",
  [sym_field] = "field",
  [sym_label] = "label",
  [sym_ref] = "ref",
  [sym_content] = "content",
  [sym_group] = "group",
  [sym_block] = "block",
  [sym_branch] = "branch",
  [sym_let] = "let",
  [sym_set] = "set",
  [sym_as] = "as",
  [sym_import] = "import",
  [sym_include] = "include",
  [sym_for] = "for",
  [sym_while] = "while",
  [sym_show] = "show",
  [sym_return] = "return",
  [sym_flow] = "flow",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__line_content_repeat1] = "_line_content_repeat1",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_formula_repeat1] = "formula_repeat1",
  [aux_sym__math_call_repeat1] = "_math_call_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_group_repeat1] = "group_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_branch_repeat1] = "branch_repeat1",
  [aux_sym_import_repeat1] = "import_repeat1",
  [anon_alias_sym_RBRACK] = "]",
  [alias_sym_wildcard] = "wildcard",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [sym_parbreak] = sym_parbreak,
  [aux_sym_escape_token1] = aux_sym_escape_token1,
  [aux_sym_url_token1] = aux_sym_url_token1,
  [sym__lb] = sym__lb,
  [sym_linebreak] = sym_linebreak,
  [sym_quote] = sym_quote,
  [aux_sym_text_token1] = aux_sym_text_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = anon_sym_BQUOTE_BQUOTE_BQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [sym_shorthand] = sym_shorthand,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__math_token_align] = sym__math_token_align,
  [sym__math_token_rpar] = anon_sym_RPAREN,
  [sym__math_token_lpar] = anon_sym_LPAREN,
  [sym__math_token_ldlm] = anon_sym_LPAREN,
  [sym__math_token_orph] = sym__math_token_orph,
  [sym__math_number] = sym_number,
  [aux_sym__math_root_token1] = aux_sym__math_root_token1,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym__math_shorthand_token1] = aux_sym__math_shorthand_token1,
  [aux_sym__math_symbol_token1] = aux_sym__math_symbol_token1,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_context] = anon_sym_context,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [aux_sym_assign_token1] = aux_sym_assign_token1,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_COMMA2] = anon_sym_COMMA,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_show] = anon_sym_show,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [sym_auto] = sym_auto,
  [sym_none] = sym_none,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__redent] = sym__redent,
  [sym__line_start_check] = sym__line_start_check,
  [sym__token_content] = sym__token_content,
  [sym__token_strong] = anon_sym_STAR,
  [sym__token_emph] = anon_sym__,
  [sym__barrier] = sym__barrier,
  [sym__token_bracket] = sym_text,
  [sym__token_section] = sym__token_section,
  [sym__termination] = sym__termination,
  [sym__token_inlined_item_end] = sym__token_inlined_item_end,
  [sym__token_inlined_stmt_end] = sym__token_inlined_item_end,
  [sym__token_blocked_expr_end] = sym__token_blocked_expr_end,
  [sym__token_math_letter] = sym__token_math_letter,
  [sym__token_math_ident] = sym_ident,
  [sym__token_math_frac] = anon_sym_SLASH,
  [sym__token_math_group_end] = anon_sym_RPAREN,
  [sym__token_else] = sym__token_else,
  [sym__token_unit] = sym__token_unit,
  [sym__token_url] = sym__token_url,
  [sym__token_item] = anon_sym_DASH,
  [sym__token_term] = anon_sym_SLASH,
  [sym__token_head_1] = anon_sym_EQ,
  [sym__token_head_2] = anon_sym_EQ_EQ,
  [sym__token_head_3] = sym__token_head_3,
  [sym__token_head_4] = sym__token_head_4,
  [sym__token_head_5] = sym__token_head_5,
  [sym__token_head_p] = sym__token_head_p,
  [sym__token_string_blob] = sym__token_string_blob,
  [sym__token_raw_span_blob] = sym__token_raw_span_blob,
  [sym__token_raw_blck_blob] = sym__token_raw_span_blob,
  [sym__token_raw_lang] = sym_ident,
  [sym__token_identifier] = sym__token_identifier,
  [sym__token_label] = sym__token_label,
  [sym__token_anti_markup] = sym__token_anti_markup,
  [sym_comment] = sym_comment,
  [sym__sp] = sym__sp,
  [sym__immediate] = sym__immediate,
  [sym__immediate_paren] = sym__immediate_paren,
  [sym__immediate_brack] = sym__immediate_brack,
  [sym__immediate_ident] = sym__immediate_ident,
  [sym__immediate_math_call] = sym__immediate_math_call,
  [sym__immediate_math_apply] = sym__immediate_math_apply,
  [sym__immediate_math_field] = sym__immediate_math_field,
  [sym__immediate_math_prime] = sym__immediate_math_prime,
  [sym__recovery] = sym__recovery,
  [sym_source_file] = sym_source_file,
  [sym__line_content] = sym__line_content,
  [sym_escape] = sym_escape,
  [sym_url] = sym_url,
  [sym__content_lb] = sym__content_lb,
  [sym__brackets] = sym__brackets,
  [sym__markup] = sym__markup,
  [sym_text] = sym_text,
  [sym__indented] = sym__indented,
  [sym_item] = sym_item,
  [sym_term] = sym_term,
  [sym__section] = sym_content,
  [sym_section] = sym_section,
  [sym_heading] = sym_heading,
  [sym_strong] = sym_strong,
  [sym_emph] = sym_emph,
  [sym_raw_blck] = sym_raw_blck,
  [sym_raw_span] = sym_raw_span,
  [sym_math] = sym_math,
  [sym_formula] = sym_formula,
  [sym__math_expr] = sym__math_expr,
  [sym__math_token_colon] = sym__math_token_colon,
  [sym__math_group] = sym__math_group,
  [sym__math_item] = sym__math_item,
  [sym__math_div] = sym__math_div,
  [sym__math_root] = sym__math_root,
  [sym__math_fac] = sym__math_fac,
  [sym__math_prime] = sym__math_prime,
  [sym__math_attach_sup] = sym__math_attach_sup,
  [sym__math_attach_sub] = sym__math_attach_sup,
  [sym__math_field] = sym_field,
  [sym__math_call] = sym_call,
  [sym__math_tag] = sym__math_tag,
  [sym__math_tagged] = sym_tagged,
  [sym__math_apply] = sym__math_apply,
  [sym__math_shorthand] = sym_shorthand,
  [sym__math_symbol] = sym__math_symbol,
  [sym__code] = sym__code,
  [sym__item] = sym__item,
  [sym__stmt] = sym__stmt,
  [sym__expr] = sym__expr,
  [sym_ident] = sym_ident,
  [sym_unit] = sym_unit,
  [sym_bool] = sym_bool,
  [sym_number] = sym_number,
  [sym_string] = sym_string,
  [sym_tagged] = sym_tagged,
  [sym_context] = sym_context,
  [sym_elude] = sym_elude,
  [sym_assign] = sym_assign,
  [sym_lambda] = sym_lambda,
  [sym_or] = sym_or,
  [sym_not] = sym_not,
  [sym_and] = sym_and,
  [sym_cmp] = sym_cmp,
  [sym_in] = sym_in,
  [sym_add] = sym_add,
  [sym_sub] = sym_sub,
  [sym_mul] = sym_mul,
  [sym_div] = sym_div,
  [sym_sign] = sym_sign,
  [sym_call] = sym_call,
  [sym_field] = sym_field,
  [sym_label] = sym_label,
  [sym_ref] = sym_ref,
  [sym_content] = sym_content,
  [sym_group] = sym_group,
  [sym_block] = sym_block,
  [sym_branch] = sym_branch,
  [sym_let] = sym_let,
  [sym_set] = sym_set,
  [sym_as] = sym_as,
  [sym_import] = sym_import,
  [sym_include] = sym_include,
  [sym_for] = sym_for,
  [sym_while] = sym_while,
  [sym_show] = sym_show,
  [sym_return] = sym_return,
  [sym_flow] = sym_flow,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__line_content_repeat1] = aux_sym__line_content_repeat1,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_formula_repeat1] = aux_sym_formula_repeat1,
  [aux_sym__math_call_repeat1] = aux_sym__math_call_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_group_repeat1] = aux_sym_group_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_branch_repeat1] = aux_sym_branch_repeat1,
  [aux_sym_import_repeat1] = aux_sym_import_repeat1,
  [anon_alias_sym_RBRACK] = anon_alias_sym_RBRACK,
  [alias_sym_wildcard] = alias_sym_wildcard,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_parbreak] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_url_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__lb] = {
    .visible = false,
    .named = true,
  },
  [sym_linebreak] = {
    .visible = true,
    .named = true,
  },
  [sym_quote] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_text_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_shorthand] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__math_token_align] = {
    .visible = true,
    .named = true,
  },
  [sym__math_token_rpar] = {
    .visible = true,
    .named = false,
  },
  [sym__math_token_lpar] = {
    .visible = true,
    .named = false,
  },
  [sym__math_token_ldlm] = {
    .visible = true,
    .named = false,
  },
  [sym__math_token_orph] = {
    .visible = false,
    .named = true,
  },
  [sym__math_number] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__math_root_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__math_shorthand_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__math_symbol_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_context] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_assign_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_show] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_auto] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__redent] = {
    .visible = false,
    .named = true,
  },
  [sym__line_start_check] = {
    .visible = false,
    .named = true,
  },
  [sym__token_content] = {
    .visible = true,
    .named = false,
  },
  [sym__token_strong] = {
    .visible = true,
    .named = false,
  },
  [sym__token_emph] = {
    .visible = true,
    .named = false,
  },
  [sym__barrier] = {
    .visible = false,
    .named = true,
  },
  [sym__token_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym__token_section] = {
    .visible = false,
    .named = true,
  },
  [sym__termination] = {
    .visible = false,
    .named = true,
  },
  [sym__token_inlined_item_end] = {
    .visible = true,
    .named = false,
  },
  [sym__token_inlined_stmt_end] = {
    .visible = true,
    .named = false,
  },
  [sym__token_blocked_expr_end] = {
    .visible = true,
    .named = false,
  },
  [sym__token_math_letter] = {
    .visible = true,
    .named = true,
  },
  [sym__token_math_ident] = {
    .visible = true,
    .named = true,
  },
  [sym__token_math_frac] = {
    .visible = true,
    .named = false,
  },
  [sym__token_math_group_end] = {
    .visible = true,
    .named = false,
  },
  [sym__token_else] = {
    .visible = true,
    .named = false,
  },
  [sym__token_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__token_url] = {
    .visible = false,
    .named = true,
  },
  [sym__token_item] = {
    .visible = true,
    .named = false,
  },
  [sym__token_term] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_1] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_2] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_3] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_4] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_5] = {
    .visible = true,
    .named = false,
  },
  [sym__token_head_p] = {
    .visible = true,
    .named = false,
  },
  [sym__token_string_blob] = {
    .visible = false,
    .named = true,
  },
  [sym__token_raw_span_blob] = {
    .visible = true,
    .named = true,
  },
  [sym__token_raw_blck_blob] = {
    .visible = true,
    .named = true,
  },
  [sym__token_raw_lang] = {
    .visible = true,
    .named = true,
  },
  [sym__token_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__token_label] = {
    .visible = false,
    .named = true,
  },
  [sym__token_anti_markup] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__sp] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_brack] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_ident] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_math_call] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_math_apply] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_math_field] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_math_prime] = {
    .visible = false,
    .named = true,
  },
  [sym__recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__line_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_url] = {
    .visible = true,
    .named = true,
  },
  [sym__content_lb] = {
    .visible = false,
    .named = true,
  },
  [sym__brackets] = {
    .visible = false,
    .named = true,
  },
  [sym__markup] = {
    .visible = false,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym__indented] = {
    .visible = false,
    .named = true,
  },
  [sym_item] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym__section] = {
    .visible = true,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym_heading] = {
    .visible = true,
    .named = true,
  },
  [sym_strong] = {
    .visible = true,
    .named = true,
  },
  [sym_emph] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_blck] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_span] = {
    .visible = true,
    .named = true,
  },
  [sym_math] = {
    .visible = true,
    .named = true,
  },
  [sym_formula] = {
    .visible = true,
    .named = true,
  },
  [sym__math_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__math_token_colon] = {
    .visible = false,
    .named = true,
  },
  [sym__math_group] = {
    .visible = false,
    .named = true,
  },
  [sym__math_item] = {
    .visible = false,
    .named = true,
  },
  [sym__math_div] = {
    .visible = true,
    .named = true,
  },
  [sym__math_root] = {
    .visible = true,
    .named = true,
  },
  [sym__math_fac] = {
    .visible = true,
    .named = true,
  },
  [sym__math_prime] = {
    .visible = true,
    .named = true,
  },
  [sym__math_attach_sup] = {
    .visible = true,
    .named = true,
  },
  [sym__math_attach_sub] = {
    .visible = true,
    .named = true,
  },
  [sym__math_field] = {
    .visible = true,
    .named = true,
  },
  [sym__math_call] = {
    .visible = true,
    .named = true,
  },
  [sym__math_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__math_tagged] = {
    .visible = true,
    .named = true,
  },
  [sym__math_apply] = {
    .visible = true,
    .named = true,
  },
  [sym__math_shorthand] = {
    .visible = true,
    .named = true,
  },
  [sym__math_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym__code] = {
    .visible = false,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym__stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_tagged] = {
    .visible = true,
    .named = true,
  },
  [sym_context] = {
    .visible = true,
    .named = true,
  },
  [sym_elude] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_or] = {
    .visible = true,
    .named = true,
  },
  [sym_not] = {
    .visible = true,
    .named = true,
  },
  [sym_and] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_add] = {
    .visible = true,
    .named = true,
  },
  [sym_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_sign] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_content] = {
    .visible = true,
    .named = true,
  },
  [sym_group] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_show] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_flow] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__line_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formula_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__math_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_branch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_wildcard] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_condition = 1,
  field_field = 2,
  field_import = 3,
  field_item = 4,
  field_lang = 5,
  field_pattern = 6,
  field_sub = 7,
  field_sup = 8,
  field_term = 9,
  field_value = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_condition] = "condition",
  [field_field] = "field",
  [field_import] = "import",
  [field_item] = "item",
  [field_lang] = "lang",
  [field_pattern] = "pattern",
  [field_sub] = "sub",
  [field_sup] = "sup",
  [field_term] = "term",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [4] = {.index = 0, .length = 2},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [10] = {.index = 4, .length = 1},
  [11] = {.index = 5, .length = 1},
  [13] = {.index = 6, .length = 1},
  [14] = {.index = 7, .length = 1},
  [15] = {.index = 8, .length = 1},
  [16] = {.index = 9, .length = 1},
  [17] = {.index = 10, .length = 1},
  [18] = {.index = 11, .length = 1},
  [19] = {.index = 12, .length = 1},
  [20] = {.index = 13, .length = 2},
  [21] = {.index = 15, .length = 1},
  [22] = {.index = 16, .length = 1},
  [25] = {.index = 17, .length = 2},
  [26] = {.index = 19, .length = 1},
  [27] = {.index = 5, .length = 1},
  [28] = {.index = 20, .length = 2},
  [29] = {.index = 22, .length = 2},
  [30] = {.index = 24, .length = 2},
  [32] = {.index = 5, .length = 1},
  [33] = {.index = 26, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_sub, 0, .inherited = true},
    {field_sup, 0, .inherited = true},
  [2] =
    {field_field, 0, .inherited = true},
  [3] =
    {field_item, 0, .inherited = true},
  [4] =
    {field_pattern, 1},
  [5] =
    {field_import, 1},
  [6] =
    {field_item, 0},
  [7] =
    {field_sup, 2},
  [8] =
    {field_sub, 2},
  [9] =
    {field_field, 2},
  [10] =
    {field_condition, 1},
  [11] =
    {field_value, 2},
  [12] =
    {field_field, 0},
  [13] =
    {field_pattern, 0},
    {field_value, 2},
  [15] =
    {field_term, 1},
  [16] =
    {field_lang, 1},
  [17] =
    {field_pattern, 1},
    {field_value, 3},
  [19] =
    {field_condition, 3},
  [20] =
    {field_sub, 4},
    {field_sup, 2},
  [22] =
    {field_sub, 2},
    {field_sup, 4},
  [24] =
    {field_field, 3, .inherited = true},
    {field_item, 0},
  [26] =
    {field_field, 4, .inherited = true},
    {field_item, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = anon_sym_STAR,
  },
  [2] = {
    [1] = anon_sym__,
  },
  [3] = {
    [0] = sym_group,
  },
  [7] = {
    [2] = anon_sym_STAR,
  },
  [8] = {
    [2] = anon_sym__,
  },
  [9] = {
    [2] = sym_text,
  },
  [12] = {
    [3] = sym_text,
  },
  [23] = {
    [0] = sym_ident,
  },
  [24] = {
    [2] = anon_alias_sym_RBRACK,
  },
  [27] = {
    [3] = alias_sym_wildcard,
  },
  [31] = {
    [3] = anon_alias_sym_RBRACK,
  },
  [32] = {
    [4] = alias_sym_wildcard,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__math_group, 2,
    sym__math_group,
    sym_group,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 3,
  [7] = 2,
  [8] = 3,
  [9] = 3,
  [10] = 2,
  [11] = 2,
  [12] = 2,
  [13] = 2,
  [14] = 3,
  [15] = 2,
  [16] = 2,
  [17] = 3,
  [18] = 3,
  [19] = 3,
  [20] = 3,
  [21] = 2,
  [22] = 3,
  [23] = 3,
  [24] = 2,
  [25] = 2,
  [26] = 3,
  [27] = 3,
  [28] = 2,
  [29] = 3,
  [30] = 3,
  [31] = 2,
  [32] = 2,
  [33] = 2,
  [34] = 3,
  [35] = 3,
  [36] = 2,
  [37] = 2,
  [38] = 3,
  [39] = 2,
  [40] = 3,
  [41] = 2,
  [42] = 2,
  [43] = 3,
  [44] = 2,
  [45] = 3,
  [46] = 46,
  [47] = 46,
  [48] = 46,
  [49] = 46,
  [50] = 46,
  [51] = 46,
  [52] = 46,
  [53] = 46,
  [54] = 46,
  [55] = 46,
  [56] = 46,
  [57] = 46,
  [58] = 46,
  [59] = 46,
  [60] = 46,
  [61] = 46,
  [62] = 46,
  [63] = 46,
  [64] = 46,
  [65] = 46,
  [66] = 46,
  [67] = 67,
  [68] = 67,
  [69] = 69,
  [70] = 70,
  [71] = 70,
  [72] = 72,
  [73] = 67,
  [74] = 67,
  [75] = 70,
  [76] = 76,
  [77] = 69,
  [78] = 70,
  [79] = 79,
  [80] = 67,
  [81] = 67,
  [82] = 72,
  [83] = 67,
  [84] = 70,
  [85] = 76,
  [86] = 67,
  [87] = 72,
  [88] = 70,
  [89] = 67,
  [90] = 76,
  [91] = 69,
  [92] = 70,
  [93] = 79,
  [94] = 72,
  [95] = 67,
  [96] = 76,
  [97] = 69,
  [98] = 70,
  [99] = 79,
  [100] = 72,
  [101] = 67,
  [102] = 67,
  [103] = 76,
  [104] = 69,
  [105] = 70,
  [106] = 70,
  [107] = 67,
  [108] = 79,
  [109] = 72,
  [110] = 70,
  [111] = 67,
  [112] = 67,
  [113] = 70,
  [114] = 76,
  [115] = 67,
  [116] = 69,
  [117] = 70,
  [118] = 70,
  [119] = 79,
  [120] = 72,
  [121] = 67,
  [122] = 76,
  [123] = 69,
  [124] = 70,
  [125] = 70,
  [126] = 67,
  [127] = 79,
  [128] = 70,
  [129] = 76,
  [130] = 72,
  [131] = 67,
  [132] = 69,
  [133] = 76,
  [134] = 70,
  [135] = 70,
  [136] = 67,
  [137] = 76,
  [138] = 67,
  [139] = 79,
  [140] = 79,
  [141] = 70,
  [142] = 69,
  [143] = 70,
  [144] = 79,
  [145] = 67,
  [146] = 72,
  [147] = 69,
  [148] = 70,
  [149] = 67,
  [150] = 76,
  [151] = 69,
  [152] = 70,
  [153] = 79,
  [154] = 70,
  [155] = 67,
  [156] = 76,
  [157] = 69,
  [158] = 70,
  [159] = 79,
  [160] = 79,
  [161] = 67,
  [162] = 67,
  [163] = 76,
  [164] = 69,
  [165] = 70,
  [166] = 79,
  [167] = 70,
  [168] = 67,
  [169] = 76,
  [170] = 69,
  [171] = 70,
  [172] = 79,
  [173] = 70,
  [174] = 69,
  [175] = 67,
  [176] = 76,
  [177] = 67,
  [178] = 69,
  [179] = 70,
  [180] = 70,
  [181] = 67,
  [182] = 79,
  [183] = 76,
  [184] = 70,
  [185] = 67,
  [186] = 76,
  [187] = 67,
  [188] = 69,
  [189] = 70,
  [190] = 79,
  [191] = 70,
  [192] = 67,
  [193] = 67,
  [194] = 79,
  [195] = 67,
  [196] = 76,
  [197] = 197,
  [198] = 69,
  [199] = 79,
  [200] = 70,
  [201] = 201,
  [202] = 70,
  [203] = 70,
  [204] = 79,
  [205] = 67,
  [206] = 67,
  [207] = 67,
  [208] = 76,
  [209] = 69,
  [210] = 70,
  [211] = 70,
  [212] = 79,
  [213] = 67,
  [214] = 69,
  [215] = 79,
  [216] = 67,
  [217] = 76,
  [218] = 70,
  [219] = 69,
  [220] = 76,
  [221] = 221,
  [222] = 221,
  [223] = 221,
  [224] = 221,
  [225] = 221,
  [226] = 221,
  [227] = 221,
  [228] = 221,
  [229] = 221,
  [230] = 221,
  [231] = 221,
  [232] = 221,
  [233] = 221,
  [234] = 221,
  [235] = 221,
  [236] = 221,
  [237] = 221,
  [238] = 221,
  [239] = 221,
  [240] = 221,
  [241] = 221,
  [242] = 221,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 248,
  [250] = 243,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 243,
  [259] = 252,
  [260] = 251,
  [261] = 254,
  [262] = 256,
  [263] = 257,
  [264] = 253,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 255,
  [273] = 273,
  [274] = 274,
  [275] = 273,
  [276] = 269,
  [277] = 268,
  [278] = 267,
  [279] = 274,
  [280] = 271,
  [281] = 252,
  [282] = 253,
  [283] = 270,
  [284] = 266,
  [285] = 265,
  [286] = 255,
  [287] = 287,
  [288] = 257,
  [289] = 265,
  [290] = 266,
  [291] = 255,
  [292] = 267,
  [293] = 256,
  [294] = 254,
  [295] = 295,
  [296] = 251,
  [297] = 252,
  [298] = 253,
  [299] = 299,
  [300] = 243,
  [301] = 248,
  [302] = 255,
  [303] = 247,
  [304] = 246,
  [305] = 268,
  [306] = 245,
  [307] = 245,
  [308] = 299,
  [309] = 244,
  [310] = 310,
  [311] = 270,
  [312] = 271,
  [313] = 274,
  [314] = 273,
  [315] = 269,
  [316] = 268,
  [317] = 267,
  [318] = 299,
  [319] = 252,
  [320] = 253,
  [321] = 255,
  [322] = 266,
  [323] = 245,
  [324] = 255,
  [325] = 269,
  [326] = 265,
  [327] = 257,
  [328] = 246,
  [329] = 270,
  [330] = 247,
  [331] = 271,
  [332] = 274,
  [333] = 310,
  [334] = 256,
  [335] = 246,
  [336] = 247,
  [337] = 254,
  [338] = 251,
  [339] = 243,
  [340] = 248,
  [341] = 247,
  [342] = 246,
  [343] = 245,
  [344] = 248,
  [345] = 243,
  [346] = 251,
  [347] = 254,
  [348] = 256,
  [349] = 257,
  [350] = 252,
  [351] = 265,
  [352] = 253,
  [353] = 266,
  [354] = 267,
  [355] = 268,
  [356] = 269,
  [357] = 299,
  [358] = 273,
  [359] = 273,
  [360] = 255,
  [361] = 274,
  [362] = 271,
  [363] = 270,
  [364] = 270,
  [365] = 271,
  [366] = 274,
  [367] = 273,
  [368] = 273,
  [369] = 269,
  [370] = 269,
  [371] = 268,
  [372] = 267,
  [373] = 266,
  [374] = 265,
  [375] = 257,
  [376] = 256,
  [377] = 254,
  [378] = 251,
  [379] = 243,
  [380] = 248,
  [381] = 268,
  [382] = 267,
  [383] = 266,
  [384] = 265,
  [385] = 257,
  [386] = 256,
  [387] = 254,
  [388] = 251,
  [389] = 252,
  [390] = 253,
  [391] = 274,
  [392] = 243,
  [393] = 248,
  [394] = 299,
  [395] = 255,
  [396] = 247,
  [397] = 246,
  [398] = 245,
  [399] = 271,
  [400] = 247,
  [401] = 246,
  [402] = 287,
  [403] = 295,
  [404] = 244,
  [405] = 310,
  [406] = 245,
  [407] = 252,
  [408] = 253,
  [409] = 245,
  [410] = 299,
  [411] = 299,
  [412] = 299,
  [413] = 255,
  [414] = 245,
  [415] = 246,
  [416] = 246,
  [417] = 247,
  [418] = 247,
  [419] = 248,
  [420] = 252,
  [421] = 243,
  [422] = 251,
  [423] = 248,
  [424] = 254,
  [425] = 251,
  [426] = 254,
  [427] = 256,
  [428] = 257,
  [429] = 253,
  [430] = 265,
  [431] = 266,
  [432] = 267,
  [433] = 270,
  [434] = 268,
  [435] = 269,
  [436] = 255,
  [437] = 273,
  [438] = 256,
  [439] = 247,
  [440] = 257,
  [441] = 287,
  [442] = 246,
  [443] = 295,
  [444] = 244,
  [445] = 310,
  [446] = 274,
  [447] = 271,
  [448] = 252,
  [449] = 270,
  [450] = 265,
  [451] = 266,
  [452] = 267,
  [453] = 253,
  [454] = 268,
  [455] = 269,
  [456] = 273,
  [457] = 255,
  [458] = 248,
  [459] = 270,
  [460] = 245,
  [461] = 243,
  [462] = 251,
  [463] = 287,
  [464] = 299,
  [465] = 254,
  [466] = 299,
  [467] = 295,
  [468] = 271,
  [469] = 252,
  [470] = 253,
  [471] = 256,
  [472] = 257,
  [473] = 299,
  [474] = 255,
  [475] = 265,
  [476] = 245,
  [477] = 274,
  [478] = 310,
  [479] = 274,
  [480] = 271,
  [481] = 266,
  [482] = 267,
  [483] = 270,
  [484] = 273,
  [485] = 252,
  [486] = 253,
  [487] = 268,
  [488] = 269,
  [489] = 269,
  [490] = 268,
  [491] = 267,
  [492] = 246,
  [493] = 255,
  [494] = 266,
  [495] = 247,
  [496] = 265,
  [497] = 287,
  [498] = 257,
  [499] = 273,
  [500] = 270,
  [501] = 295,
  [502] = 271,
  [503] = 274,
  [504] = 310,
  [505] = 244,
  [506] = 310,
  [507] = 256,
  [508] = 254,
  [509] = 251,
  [510] = 287,
  [511] = 295,
  [512] = 252,
  [513] = 244,
  [514] = 253,
  [515] = 299,
  [516] = 248,
  [517] = 310,
  [518] = 243,
  [519] = 248,
  [520] = 255,
  [521] = 247,
  [522] = 245,
  [523] = 287,
  [524] = 295,
  [525] = 244,
  [526] = 246,
  [527] = 246,
  [528] = 247,
  [529] = 310,
  [530] = 245,
  [531] = 252,
  [532] = 253,
  [533] = 299,
  [534] = 287,
  [535] = 248,
  [536] = 243,
  [537] = 243,
  [538] = 273,
  [539] = 255,
  [540] = 251,
  [541] = 269,
  [542] = 268,
  [543] = 267,
  [544] = 266,
  [545] = 265,
  [546] = 257,
  [547] = 256,
  [548] = 254,
  [549] = 251,
  [550] = 243,
  [551] = 248,
  [552] = 254,
  [553] = 256,
  [554] = 257,
  [555] = 265,
  [556] = 266,
  [557] = 267,
  [558] = 268,
  [559] = 269,
  [560] = 295,
  [561] = 252,
  [562] = 253,
  [563] = 244,
  [564] = 273,
  [565] = 310,
  [566] = 299,
  [567] = 251,
  [568] = 255,
  [569] = 270,
  [570] = 295,
  [571] = 247,
  [572] = 246,
  [573] = 254,
  [574] = 287,
  [575] = 271,
  [576] = 274,
  [577] = 245,
  [578] = 295,
  [579] = 252,
  [580] = 253,
  [581] = 244,
  [582] = 274,
  [583] = 299,
  [584] = 271,
  [585] = 270,
  [586] = 255,
  [587] = 310,
  [588] = 245,
  [589] = 273,
  [590] = 269,
  [591] = 287,
  [592] = 295,
  [593] = 244,
  [594] = 310,
  [595] = 268,
  [596] = 267,
  [597] = 266,
  [598] = 265,
  [599] = 252,
  [600] = 253,
  [601] = 257,
  [602] = 256,
  [603] = 254,
  [604] = 251,
  [605] = 287,
  [606] = 295,
  [607] = 255,
  [608] = 244,
  [609] = 310,
  [610] = 243,
  [611] = 256,
  [612] = 248,
  [613] = 257,
  [614] = 265,
  [615] = 266,
  [616] = 246,
  [617] = 247,
  [618] = 247,
  [619] = 246,
  [620] = 245,
  [621] = 248,
  [622] = 252,
  [623] = 253,
  [624] = 287,
  [625] = 295,
  [626] = 244,
  [627] = 310,
  [628] = 243,
  [629] = 287,
  [630] = 310,
  [631] = 299,
  [632] = 267,
  [633] = 268,
  [634] = 287,
  [635] = 269,
  [636] = 310,
  [637] = 251,
  [638] = 273,
  [639] = 287,
  [640] = 295,
  [641] = 274,
  [642] = 271,
  [643] = 244,
  [644] = 270,
  [645] = 310,
  [646] = 254,
  [647] = 299,
  [648] = 256,
  [649] = 299,
  [650] = 257,
  [651] = 287,
  [652] = 299,
  [653] = 245,
  [654] = 245,
  [655] = 295,
  [656] = 244,
  [657] = 246,
  [658] = 246,
  [659] = 247,
  [660] = 248,
  [661] = 247,
  [662] = 243,
  [663] = 251,
  [664] = 245,
  [665] = 254,
  [666] = 270,
  [667] = 310,
  [668] = 271,
  [669] = 274,
  [670] = 252,
  [671] = 256,
  [672] = 257,
  [673] = 265,
  [674] = 265,
  [675] = 266,
  [676] = 267,
  [677] = 268,
  [678] = 269,
  [679] = 273,
  [680] = 310,
  [681] = 274,
  [682] = 266,
  [683] = 271,
  [684] = 244,
  [685] = 246,
  [686] = 247,
  [687] = 267,
  [688] = 268,
  [689] = 248,
  [690] = 270,
  [691] = 243,
  [692] = 251,
  [693] = 254,
  [694] = 256,
  [695] = 257,
  [696] = 265,
  [697] = 266,
  [698] = 273,
  [699] = 267,
  [700] = 268,
  [701] = 269,
  [702] = 268,
  [703] = 267,
  [704] = 266,
  [705] = 265,
  [706] = 257,
  [707] = 256,
  [708] = 254,
  [709] = 251,
  [710] = 243,
  [711] = 248,
  [712] = 269,
  [713] = 299,
  [714] = 273,
  [715] = 295,
  [716] = 274,
  [717] = 271,
  [718] = 245,
  [719] = 269,
  [720] = 246,
  [721] = 247,
  [722] = 248,
  [723] = 270,
  [724] = 243,
  [725] = 251,
  [726] = 287,
  [727] = 247,
  [728] = 246,
  [729] = 295,
  [730] = 254,
  [731] = 256,
  [732] = 257,
  [733] = 245,
  [734] = 265,
  [735] = 266,
  [736] = 267,
  [737] = 268,
  [738] = 269,
  [739] = 299,
  [740] = 273,
  [741] = 295,
  [742] = 274,
  [743] = 271,
  [744] = 287,
  [745] = 270,
  [746] = 255,
  [747] = 253,
  [748] = 244,
  [749] = 274,
  [750] = 271,
  [751] = 310,
  [752] = 248,
  [753] = 270,
  [754] = 243,
  [755] = 252,
  [756] = 244,
  [757] = 287,
  [758] = 251,
  [759] = 253,
  [760] = 254,
  [761] = 256,
  [762] = 257,
  [763] = 265,
  [764] = 299,
  [765] = 245,
  [766] = 266,
  [767] = 267,
  [768] = 244,
  [769] = 268,
  [770] = 246,
  [771] = 247,
  [772] = 269,
  [773] = 244,
  [774] = 295,
  [775] = 270,
  [776] = 248,
  [777] = 243,
  [778] = 251,
  [779] = 254,
  [780] = 256,
  [781] = 257,
  [782] = 273,
  [783] = 244,
  [784] = 295,
  [785] = 287,
  [786] = 265,
  [787] = 266,
  [788] = 267,
  [789] = 274,
  [790] = 268,
  [791] = 310,
  [792] = 244,
  [793] = 273,
  [794] = 271,
  [795] = 270,
  [796] = 295,
  [797] = 287,
  [798] = 287,
  [799] = 270,
  [800] = 295,
  [801] = 271,
  [802] = 274,
  [803] = 244,
  [804] = 269,
  [805] = 310,
  [806] = 271,
  [807] = 274,
  [808] = 273,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 810,
  [813] = 811,
  [814] = 810,
  [815] = 811,
  [816] = 811,
  [817] = 810,
  [818] = 811,
  [819] = 810,
  [820] = 810,
  [821] = 811,
  [822] = 822,
  [823] = 810,
  [824] = 811,
  [825] = 810,
  [826] = 809,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 811,
  [831] = 810,
  [832] = 810,
  [833] = 811,
  [834] = 810,
  [835] = 828,
  [836] = 810,
  [837] = 837,
  [838] = 811,
  [839] = 811,
  [840] = 810,
  [841] = 810,
  [842] = 809,
  [843] = 811,
  [844] = 844,
  [845] = 811,
  [846] = 810,
  [847] = 847,
  [848] = 810,
  [849] = 811,
  [850] = 811,
  [851] = 851,
  [852] = 847,
  [853] = 828,
  [854] = 810,
  [855] = 855,
  [856] = 811,
  [857] = 810,
  [858] = 858,
  [859] = 810,
  [860] = 827,
  [861] = 861,
  [862] = 822,
  [863] = 810,
  [864] = 811,
  [865] = 810,
  [866] = 810,
  [867] = 810,
  [868] = 811,
  [869] = 810,
  [870] = 810,
  [871] = 858,
  [872] = 811,
  [873] = 811,
  [874] = 811,
  [875] = 810,
  [876] = 829,
  [877] = 810,
  [878] = 851,
  [879] = 810,
  [880] = 858,
  [881] = 811,
  [882] = 811,
  [883] = 810,
  [884] = 837,
  [885] = 811,
  [886] = 811,
  [887] = 811,
  [888] = 810,
  [889] = 811,
  [890] = 811,
  [891] = 811,
  [892] = 822,
  [893] = 809,
  [894] = 828,
  [895] = 829,
  [896] = 810,
  [897] = 837,
  [898] = 810,
  [899] = 811,
  [900] = 847,
  [901] = 811,
  [902] = 810,
  [903] = 844,
  [904] = 851,
  [905] = 811,
  [906] = 847,
  [907] = 810,
  [908] = 908,
  [909] = 811,
  [910] = 810,
  [911] = 844,
  [912] = 810,
  [913] = 811,
  [914] = 811,
  [915] = 811,
  [916] = 827,
  [917] = 811,
  [918] = 837,
  [919] = 810,
  [920] = 810,
  [921] = 811,
  [922] = 810,
  [923] = 810,
  [924] = 822,
  [925] = 811,
  [926] = 810,
  [927] = 811,
  [928] = 829,
  [929] = 837,
  [930] = 908,
  [931] = 811,
  [932] = 847,
  [933] = 810,
  [934] = 810,
  [935] = 811,
  [936] = 811,
  [937] = 811,
  [938] = 822,
  [939] = 810,
  [940] = 809,
  [941] = 811,
  [942] = 908,
  [943] = 810,
  [944] = 829,
  [945] = 828,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 946,
  [951] = 949,
  [952] = 948,
  [953] = 947,
  [954] = 949,
  [955] = 947,
  [956] = 946,
  [957] = 948,
  [958] = 958,
  [959] = 958,
  [960] = 960,
  [961] = 960,
  [962] = 958,
  [963] = 963,
  [964] = 960,
  [965] = 960,
  [966] = 958,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 969,
  [971] = 969,
  [972] = 969,
  [973] = 969,
  [974] = 969,
  [975] = 969,
  [976] = 969,
  [977] = 969,
  [978] = 967,
  [979] = 979,
  [980] = 969,
  [981] = 979,
  [982] = 969,
  [983] = 969,
  [984] = 969,
  [985] = 969,
  [986] = 969,
  [987] = 969,
  [988] = 969,
  [989] = 969,
  [990] = 969,
  [991] = 969,
  [992] = 969,
  [993] = 969,
  [994] = 969,
  [995] = 979,
  [996] = 969,
  [997] = 968,
  [998] = 969,
  [999] = 979,
  [1000] = 968,
  [1001] = 968,
  [1002] = 1002,
  [1003] = 967,
  [1004] = 1002,
  [1005] = 967,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1007,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1011,
  [1013] = 1013,
  [1014] = 1013,
  [1015] = 1015,
  [1016] = 1015,
  [1017] = 1017,
  [1018] = 948,
  [1019] = 1019,
  [1020] = 1006,
  [1021] = 1021,
  [1022] = 1006,
  [1023] = 1006,
  [1024] = 1021,
  [1025] = 1007,
  [1026] = 1026,
  [1027] = 1021,
  [1028] = 1021,
  [1029] = 1029,
  [1030] = 1007,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 948,
  [1034] = 1034,
  [1035] = 1017,
  [1036] = 1029,
  [1037] = 1013,
  [1038] = 1015,
  [1039] = 1029,
  [1040] = 1031,
  [1041] = 1034,
  [1042] = 1011,
  [1043] = 1013,
  [1044] = 1015,
  [1045] = 1034,
  [1046] = 1009,
  [1047] = 1017,
  [1048] = 1031,
  [1049] = 1017,
  [1050] = 1050,
  [1051] = 1009,
  [1052] = 1032,
  [1053] = 1032,
  [1054] = 1026,
  [1055] = 1019,
  [1056] = 1026,
  [1057] = 1019,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1061,
  [1064] = 1060,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1062,
  [1068] = 1068,
  [1069] = 1066,
  [1070] = 1070,
  [1071] = 1070,
  [1072] = 1070,
  [1073] = 1060,
  [1074] = 1065,
  [1075] = 1068,
  [1076] = 1061,
  [1077] = 1066,
  [1078] = 1078,
  [1079] = 1078,
  [1080] = 1065,
  [1081] = 1068,
  [1082] = 1062,
  [1083] = 1078,
  [1084] = 1084,
  [1085] = 1084,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1089,
  [1092] = 1088,
  [1093] = 1086,
  [1094] = 1090,
  [1095] = 1087,
  [1096] = 1084,
  [1097] = 1097,
  [1098] = 1088,
  [1099] = 1099,
  [1100] = 1087,
  [1101] = 1088,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1089,
  [1105] = 1090,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1086,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1120,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1097,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1128,
  [1135] = 1102,
  [1136] = 1127,
  [1137] = 1090,
  [1138] = 1138,
  [1139] = 1119,
  [1140] = 1125,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1118,
  [1144] = 1103,
  [1145] = 1089,
  [1146] = 1146,
  [1147] = 1086,
  [1148] = 1148,
  [1149] = 1141,
  [1150] = 1133,
  [1151] = 1131,
  [1152] = 1122,
  [1153] = 1087,
  [1154] = 1089,
  [1155] = 1155,
  [1156] = 1099,
  [1157] = 1088,
  [1158] = 1158,
  [1159] = 1121,
  [1160] = 1138,
  [1161] = 1089,
  [1162] = 1097,
  [1163] = 1163,
  [1164] = 1125,
  [1165] = 1165,
  [1166] = 1090,
  [1167] = 1113,
  [1168] = 1118,
  [1169] = 1119,
  [1170] = 1120,
  [1171] = 1165,
  [1172] = 1107,
  [1173] = 1116,
  [1174] = 1112,
  [1175] = 1109,
  [1176] = 1117,
  [1177] = 1127,
  [1178] = 1116,
  [1179] = 1115,
  [1180] = 1114,
  [1181] = 1087,
  [1182] = 1114,
  [1183] = 1111,
  [1184] = 1087,
  [1185] = 1086,
  [1186] = 1142,
  [1187] = 1090,
  [1188] = 1086,
  [1189] = 1141,
  [1190] = 1158,
  [1191] = 1123,
  [1192] = 1133,
  [1193] = 1124,
  [1194] = 1132,
  [1195] = 1131,
  [1196] = 1115,
  [1197] = 1088,
  [1198] = 1087,
  [1199] = 1163,
  [1200] = 1088,
  [1201] = 1089,
  [1202] = 1110,
  [1203] = 1122,
  [1204] = 1128,
  [1205] = 1090,
  [1206] = 1110,
  [1207] = 1103,
  [1208] = 1121,
  [1209] = 1130,
  [1210] = 1113,
  [1211] = 1086,
  [1212] = 1146,
  [1213] = 1106,
  [1214] = 1142,
  [1215] = 1130,
  [1216] = 1132,
  [1217] = 1124,
  [1218] = 1123,
  [1219] = 1163,
  [1220] = 1138,
  [1221] = 1155,
  [1222] = 1099,
  [1223] = 1102,
  [1224] = 1155,
  [1225] = 1148,
  [1226] = 1109,
  [1227] = 1158,
  [1228] = 1165,
  [1229] = 1090,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1146,
  [1235] = 1112,
  [1236] = 1111,
  [1237] = 1107,
  [1238] = 1106,
  [1239] = 1117,
  [1240] = 1089,
  [1241] = 1088,
  [1242] = 1110,
  [1243] = 1087,
  [1244] = 1086,
  [1245] = 1117,
  [1246] = 1246,
  [1247] = 1112,
  [1248] = 1148,
  [1249] = 1107,
  [1250] = 1231,
  [1251] = 1148,
  [1252] = 1233,
  [1253] = 1253,
  [1254] = 1090,
  [1255] = 1089,
  [1256] = 1088,
  [1257] = 1257,
  [1258] = 1090,
  [1259] = 1146,
  [1260] = 1117,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1089,
  [1265] = 1088,
  [1266] = 1087,
  [1267] = 1086,
  [1268] = 1246,
  [1269] = 1253,
  [1270] = 1087,
  [1271] = 1086,
  [1272] = 1146,
  [1273] = 1148,
  [1274] = 1112,
  [1275] = 1106,
  [1276] = 1276,
  [1277] = 1146,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1117,
  [1281] = 1107,
  [1282] = 1111,
  [1283] = 1086,
  [1284] = 1087,
  [1285] = 1112,
  [1286] = 1112,
  [1287] = 1117,
  [1288] = 1110,
  [1289] = 1103,
  [1290] = 1088,
  [1291] = 1089,
  [1292] = 1107,
  [1293] = 1146,
  [1294] = 1279,
  [1295] = 1276,
  [1296] = 1103,
  [1297] = 1253,
  [1298] = 1262,
  [1299] = 1107,
  [1300] = 1261,
  [1301] = 1111,
  [1302] = 1257,
  [1303] = 1090,
  [1304] = 1148,
  [1305] = 1103,
  [1306] = 1306,
  [1307] = 1253,
  [1308] = 1308,
  [1309] = 1148,
  [1310] = 1306,
  [1311] = 1110,
  [1312] = 1110,
  [1313] = 1106,
  [1314] = 1107,
  [1315] = 1232,
  [1316] = 1111,
  [1317] = 1317,
  [1318] = 1107,
  [1319] = 1308,
  [1320] = 1112,
  [1321] = 1278,
  [1322] = 1112,
  [1323] = 1106,
  [1324] = 1263,
  [1325] = 1117,
  [1326] = 1117,
  [1327] = 1086,
  [1328] = 1087,
  [1329] = 1088,
  [1330] = 1089,
  [1331] = 1111,
  [1332] = 1090,
  [1333] = 1103,
  [1334] = 1317,
  [1335] = 1230,
  [1336] = 1106,
  [1337] = 1148,
  [1338] = 1338,
  [1339] = 1253,
  [1340] = 1340,
  [1341] = 1276,
  [1342] = 1090,
  [1343] = 1306,
  [1344] = 1107,
  [1345] = 1345,
  [1346] = 1279,
  [1347] = 1089,
  [1348] = 1088,
  [1349] = 1349,
  [1350] = 1112,
  [1351] = 1086,
  [1352] = 1352,
  [1353] = 1306,
  [1354] = 1354,
  [1355] = 1231,
  [1356] = 1356,
  [1357] = 1110,
  [1358] = 1110,
  [1359] = 1106,
  [1360] = 1230,
  [1361] = 1103,
  [1362] = 1107,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1306,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1111,
  [1371] = 1371,
  [1372] = 1087,
  [1373] = 1112,
  [1374] = 1148,
  [1375] = 1375,
  [1376] = 1090,
  [1377] = 1257,
  [1378] = 1378,
  [1379] = 1107,
  [1380] = 1261,
  [1381] = 1262,
  [1382] = 1278,
  [1383] = 1117,
  [1384] = 1230,
  [1385] = 1385,
  [1386] = 1233,
  [1387] = 1387,
  [1388] = 1388,
  [1389] = 1231,
  [1390] = 1103,
  [1391] = 1276,
  [1392] = 1125,
  [1393] = 1393,
  [1394] = 1279,
  [1395] = 1146,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1262,
  [1399] = 1261,
  [1400] = 1308,
  [1401] = 1165,
  [1402] = 1402,
  [1403] = 1103,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1257,
  [1407] = 1407,
  [1408] = 1263,
  [1409] = 1338,
  [1410] = 1317,
  [1411] = 1317,
  [1412] = 1263,
  [1413] = 1253,
  [1414] = 1414,
  [1415] = 1120,
  [1416] = 1263,
  [1417] = 1119,
  [1418] = 1118,
  [1419] = 1113,
  [1420] = 1420,
  [1421] = 1113,
  [1422] = 1422,
  [1423] = 1233,
  [1424] = 1352,
  [1425] = 1118,
  [1426] = 1125,
  [1427] = 1119,
  [1428] = 1253,
  [1429] = 1232,
  [1430] = 1120,
  [1431] = 1165,
  [1432] = 1146,
  [1433] = 1433,
  [1434] = 1279,
  [1435] = 1278,
  [1436] = 1436,
  [1437] = 1253,
  [1438] = 1363,
  [1439] = 1276,
  [1440] = 1103,
  [1441] = 1110,
  [1442] = 1110,
  [1443] = 1253,
  [1444] = 1444,
  [1445] = 1112,
  [1446] = 1308,
  [1447] = 1246,
  [1448] = 1103,
  [1449] = 1106,
  [1450] = 1354,
  [1451] = 1365,
  [1452] = 1306,
  [1453] = 1257,
  [1454] = 1246,
  [1455] = 1455,
  [1456] = 1089,
  [1457] = 1088,
  [1458] = 1422,
  [1459] = 1261,
  [1460] = 1262,
  [1461] = 1117,
  [1462] = 1111,
  [1463] = 1117,
  [1464] = 1276,
  [1465] = 1233,
  [1466] = 1231,
  [1467] = 1368,
  [1468] = 1110,
  [1469] = 1369,
  [1470] = 1279,
  [1471] = 1308,
  [1472] = 1110,
  [1473] = 1278,
  [1474] = 1317,
  [1475] = 1444,
  [1476] = 1232,
  [1477] = 1086,
  [1478] = 1087,
  [1479] = 1112,
  [1480] = 1103,
  [1481] = 1262,
  [1482] = 1263,
  [1483] = 1117,
  [1484] = 1103,
  [1485] = 1261,
  [1486] = 1397,
  [1487] = 1117,
  [1488] = 1396,
  [1489] = 1393,
  [1490] = 1455,
  [1491] = 1371,
  [1492] = 1385,
  [1493] = 1388,
  [1494] = 1257,
  [1495] = 1402,
  [1496] = 1246,
  [1497] = 1279,
  [1498] = 1253,
  [1499] = 1306,
  [1500] = 1308,
  [1501] = 1352,
  [1502] = 1110,
  [1503] = 1112,
  [1504] = 1504,
  [1505] = 1253,
  [1506] = 1086,
  [1507] = 1507,
  [1508] = 1117,
  [1509] = 1436,
  [1510] = 1510,
  [1511] = 1088,
  [1512] = 1089,
  [1513] = 1404,
  [1514] = 1112,
  [1515] = 1107,
  [1516] = 1278,
  [1517] = 1090,
  [1518] = 1405,
  [1519] = 1407,
  [1520] = 1107,
  [1521] = 1414,
  [1522] = 1230,
  [1523] = 1230,
  [1524] = 1420,
  [1525] = 1378,
  [1526] = 1111,
  [1527] = 1306,
  [1528] = 1433,
  [1529] = 1317,
  [1530] = 1233,
  [1531] = 1232,
  [1532] = 1231,
  [1533] = 1107,
  [1534] = 1246,
  [1535] = 1106,
  [1536] = 1090,
  [1537] = 1253,
  [1538] = 1349,
  [1539] = 1539,
  [1540] = 1233,
  [1541] = 1230,
  [1542] = 1510,
  [1543] = 1148,
  [1544] = 1253,
  [1545] = 1232,
  [1546] = 1231,
  [1547] = 1089,
  [1548] = 1088,
  [1549] = 1306,
  [1550] = 1107,
  [1551] = 1117,
  [1552] = 1089,
  [1553] = 1088,
  [1554] = 1087,
  [1555] = 1504,
  [1556] = 1086,
  [1557] = 1233,
  [1558] = 1087,
  [1559] = 1507,
  [1560] = 1086,
  [1561] = 1231,
  [1562] = 1117,
  [1563] = 1356,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1246,
  [1568] = 1086,
  [1569] = 1306,
  [1570] = 1112,
  [1571] = 1087,
  [1572] = 1565,
  [1573] = 1112,
  [1574] = 1111,
  [1575] = 1263,
  [1576] = 1367,
  [1577] = 1146,
  [1578] = 1564,
  [1579] = 1146,
  [1580] = 1146,
  [1581] = 1088,
  [1582] = 1566,
  [1583] = 1089,
  [1584] = 1117,
  [1585] = 1375,
  [1586] = 1107,
  [1587] = 1257,
  [1588] = 1230,
  [1589] = 1233,
  [1590] = 1103,
  [1591] = 1106,
  [1592] = 1112,
  [1593] = 1111,
  [1594] = 1231,
  [1595] = 1110,
  [1596] = 1103,
  [1597] = 1107,
  [1598] = 1345,
  [1599] = 1090,
  [1600] = 1261,
  [1601] = 1262,
  [1602] = 1253,
  [1603] = 1278,
  [1604] = 1317,
  [1605] = 1106,
  [1606] = 1148,
  [1607] = 1232,
  [1608] = 1110,
  [1609] = 1090,
  [1610] = 1103,
  [1611] = 1148,
  [1612] = 1352,
  [1613] = 1308,
  [1614] = 1110,
  [1615] = 1276,
  [1616] = 1396,
  [1617] = 1433,
  [1618] = 1232,
  [1619] = 1263,
  [1620] = 1444,
  [1621] = 1621,
  [1622] = 1354,
  [1623] = 1365,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1504,
  [1627] = 1422,
  [1628] = 1368,
  [1629] = 1103,
  [1630] = 1369,
  [1631] = 1625,
  [1632] = 1231,
  [1633] = 1624,
  [1634] = 1621,
  [1635] = 1338,
  [1636] = 1436,
  [1637] = 1433,
  [1638] = 1566,
  [1639] = 1625,
  [1640] = 1624,
  [1641] = 1165,
  [1642] = 1397,
  [1643] = 1110,
  [1644] = 1621,
  [1645] = 1393,
  [1646] = 1103,
  [1647] = 1279,
  [1648] = 1276,
  [1649] = 1317,
  [1650] = 1625,
  [1651] = 1455,
  [1652] = 1624,
  [1653] = 1371,
  [1654] = 1385,
  [1655] = 1388,
  [1656] = 1262,
  [1657] = 1261,
  [1658] = 1402,
  [1659] = 1621,
  [1660] = 1352,
  [1661] = 1257,
  [1662] = 1404,
  [1663] = 1621,
  [1664] = 1624,
  [1665] = 1625,
  [1666] = 1246,
  [1667] = 1110,
  [1668] = 1405,
  [1669] = 1407,
  [1670] = 1306,
  [1671] = 1306,
  [1672] = 1414,
  [1673] = 1308,
  [1674] = 1306,
  [1675] = 1420,
  [1676] = 1246,
  [1677] = 1378,
  [1678] = 1262,
  [1679] = 1624,
  [1680] = 1125,
  [1681] = 1625,
  [1682] = 1565,
  [1683] = 1278,
  [1684] = 1621,
  [1685] = 1278,
  [1686] = 1089,
  [1687] = 1624,
  [1688] = 1625,
  [1689] = 1111,
  [1690] = 1111,
  [1691] = 1625,
  [1692] = 1308,
  [1693] = 1624,
  [1694] = 1233,
  [1695] = 1621,
  [1696] = 1232,
  [1697] = 1120,
  [1698] = 1246,
  [1699] = 1621,
  [1700] = 1621,
  [1701] = 1106,
  [1702] = 1317,
  [1703] = 1119,
  [1704] = 1624,
  [1705] = 1263,
  [1706] = 1118,
  [1707] = 1113,
  [1708] = 1625,
  [1709] = 1106,
  [1710] = 1621,
  [1711] = 1624,
  [1712] = 1625,
  [1713] = 1621,
  [1714] = 1624,
  [1715] = 1625,
  [1716] = 1621,
  [1717] = 1510,
  [1718] = 1148,
  [1719] = 1624,
  [1720] = 1504,
  [1721] = 1103,
  [1722] = 1625,
  [1723] = 1317,
  [1724] = 1507,
  [1725] = 1113,
  [1726] = 1165,
  [1727] = 1356,
  [1728] = 1564,
  [1729] = 1565,
  [1730] = 1118,
  [1731] = 1119,
  [1732] = 1120,
  [1733] = 1566,
  [1734] = 1625,
  [1735] = 1110,
  [1736] = 1308,
  [1737] = 1263,
  [1738] = 1624,
  [1739] = 1279,
  [1740] = 1276,
  [1741] = 1621,
  [1742] = 1148,
  [1743] = 1125,
  [1744] = 1232,
  [1745] = 1367,
  [1746] = 1278,
  [1747] = 1120,
  [1748] = 1262,
  [1749] = 1261,
  [1750] = 1621,
  [1751] = 1119,
  [1752] = 1624,
  [1753] = 1257,
  [1754] = 1375,
  [1755] = 1625,
  [1756] = 1118,
  [1757] = 1113,
  [1758] = 1621,
  [1759] = 1279,
  [1760] = 1367,
  [1761] = 1146,
  [1762] = 1276,
  [1763] = 1510,
  [1764] = 1566,
  [1765] = 1565,
  [1766] = 1564,
  [1767] = 1356,
  [1768] = 1352,
  [1769] = 1507,
  [1770] = 1306,
  [1771] = 1504,
  [1772] = 1624,
  [1773] = 1625,
  [1774] = 1117,
  [1775] = 1621,
  [1776] = 1624,
  [1777] = 1625,
  [1778] = 1086,
  [1779] = 1621,
  [1780] = 1087,
  [1781] = 1112,
  [1782] = 1624,
  [1783] = 1625,
  [1784] = 1375,
  [1785] = 1257,
  [1786] = 1261,
  [1787] = 1146,
  [1788] = 1232,
  [1789] = 1233,
  [1790] = 1125,
  [1791] = 1111,
  [1792] = 1621,
  [1793] = 1624,
  [1794] = 1378,
  [1795] = 1420,
  [1796] = 1625,
  [1797] = 1165,
  [1798] = 1414,
  [1799] = 1407,
  [1800] = 1405,
  [1801] = 1404,
  [1802] = 1088,
  [1803] = 1402,
  [1804] = 1388,
  [1805] = 1385,
  [1806] = 1371,
  [1807] = 1455,
  [1808] = 1393,
  [1809] = 1396,
  [1810] = 1397,
  [1811] = 1261,
  [1812] = 1433,
  [1813] = 1375,
  [1814] = 1338,
  [1815] = 1317,
  [1816] = 1231,
  [1817] = 1507,
  [1818] = 1369,
  [1819] = 1368,
  [1820] = 1367,
  [1821] = 1422,
  [1822] = 1257,
  [1823] = 1230,
  [1824] = 1107,
  [1825] = 1365,
  [1826] = 1354,
  [1827] = 1261,
  [1828] = 1308,
  [1829] = 1444,
  [1830] = 1262,
  [1831] = 1253,
  [1832] = 1278,
  [1833] = 1276,
  [1834] = 1279,
  [1835] = 1363,
  [1836] = 1106,
  [1837] = 1436,
  [1838] = 1278,
  [1839] = 1363,
  [1840] = 1230,
  [1841] = 1308,
  [1842] = 1436,
  [1843] = 1110,
  [1844] = 1090,
  [1845] = 1352,
  [1846] = 1375,
  [1847] = 1148,
  [1848] = 1340,
  [1849] = 1420,
  [1850] = 1414,
  [1851] = 1407,
  [1852] = 1367,
  [1853] = 1363,
  [1854] = 1510,
  [1855] = 1356,
  [1856] = 1566,
  [1857] = 1565,
  [1858] = 1564,
  [1859] = 1356,
  [1860] = 1352,
  [1861] = 1507,
  [1862] = 1405,
  [1863] = 1504,
  [1864] = 1404,
  [1865] = 1402,
  [1866] = 1388,
  [1867] = 1385,
  [1868] = 1371,
  [1869] = 1253,
  [1870] = 1455,
  [1871] = 1369,
  [1872] = 1368,
  [1873] = 1365,
  [1874] = 1354,
  [1875] = 1146,
  [1876] = 1317,
  [1877] = 1103,
  [1878] = 1510,
  [1879] = 1352,
  [1880] = 1510,
  [1881] = 1444,
  [1882] = 1263,
  [1883] = 1306,
  [1884] = 1364,
  [1885] = 1387,
  [1886] = 1378,
  [1887] = 1420,
  [1888] = 1253,
  [1889] = 1232,
  [1890] = 1414,
  [1891] = 1407,
  [1892] = 1405,
  [1893] = 1404,
  [1894] = 1349,
  [1895] = 1402,
  [1896] = 1388,
  [1897] = 1385,
  [1898] = 1371,
  [1899] = 1455,
  [1900] = 1393,
  [1901] = 1396,
  [1902] = 1397,
  [1903] = 1625,
  [1904] = 1233,
  [1905] = 1354,
  [1906] = 1338,
  [1907] = 1090,
  [1908] = 1365,
  [1909] = 1510,
  [1910] = 1369,
  [1911] = 1368,
  [1912] = 1378,
  [1913] = 1422,
  [1914] = 1253,
  [1915] = 1253,
  [1916] = 1393,
  [1917] = 1365,
  [1918] = 1354,
  [1919] = 1396,
  [1920] = 1397,
  [1921] = 1444,
  [1922] = 1246,
  [1923] = 1345,
  [1924] = 1306,
  [1925] = 1621,
  [1926] = 1338,
  [1927] = 1363,
  [1928] = 1231,
  [1929] = 1436,
  [1930] = 1257,
  [1931] = 1433,
  [1932] = 1306,
  [1933] = 1110,
  [1934] = 1262,
  [1935] = 1422,
  [1936] = 1422,
  [1937] = 1107,
  [1938] = 1089,
  [1939] = 1349,
  [1940] = 1276,
  [1941] = 1624,
  [1942] = 1279,
  [1943] = 1088,
  [1944] = 1233,
  [1945] = 1230,
  [1946] = 1148,
  [1947] = 1564,
  [1948] = 1368,
  [1949] = 1369,
  [1950] = 1345,
  [1951] = 1231,
  [1952] = 1444,
  [1953] = 1103,
  [1954] = 1345,
  [1955] = 1338,
  [1956] = 1125,
  [1957] = 1113,
  [1958] = 1253,
  [1959] = 1118,
  [1960] = 1119,
  [1961] = 1120,
  [1962] = 1165,
  [1963] = 1230,
  [1964] = 1125,
  [1965] = 1263,
  [1966] = 1113,
  [1967] = 1118,
  [1968] = 1345,
  [1969] = 1397,
  [1970] = 1349,
  [1971] = 1396,
  [1972] = 1510,
  [1973] = 1233,
  [1974] = 1621,
  [1975] = 1624,
  [1976] = 1112,
  [1977] = 1363,
  [1978] = 1119,
  [1979] = 1393,
  [1980] = 1120,
  [1981] = 1349,
  [1982] = 1455,
  [1983] = 1371,
  [1984] = 1385,
  [1985] = 1388,
  [1986] = 1117,
  [1987] = 1402,
  [1988] = 1086,
  [1989] = 1404,
  [1990] = 1405,
  [1991] = 1407,
  [1992] = 1165,
  [1993] = 1086,
  [1994] = 1436,
  [1995] = 1414,
  [1996] = 1345,
  [1997] = 1433,
  [1998] = 1117,
  [1999] = 1306,
  [2000] = 1231,
  [2001] = 1087,
  [2002] = 1146,
  [2003] = 1112,
  [2004] = 1420,
  [2005] = 1352,
  [2006] = 1246,
  [2007] = 1306,
  [2008] = 1233,
  [2009] = 1378,
  [2010] = 1111,
  [2011] = 1231,
  [2012] = 1103,
  [2013] = 1110,
  [2014] = 1088,
  [2015] = 1233,
  [2016] = 1231,
  [2017] = 1233,
  [2018] = 1089,
  [2019] = 1111,
  [2020] = 1231,
  [2021] = 1233,
  [2022] = 1231,
  [2023] = 1233,
  [2024] = 1103,
  [2025] = 1231,
  [2026] = 1107,
  [2027] = 1106,
  [2028] = 1230,
  [2029] = 1110,
  [2030] = 1375,
  [2031] = 1106,
  [2032] = 1539,
  [2033] = 1090,
  [2034] = 1148,
  [2035] = 1103,
  [2036] = 1367,
  [2037] = 1110,
  [2038] = 1103,
  [2039] = 1110,
  [2040] = 1566,
  [2041] = 1565,
  [2042] = 1564,
  [2043] = 1356,
  [2044] = 1103,
  [2045] = 1507,
  [2046] = 1253,
  [2047] = 1504,
  [2048] = 1146,
  [2049] = 1090,
  [2050] = 1117,
  [2051] = 1086,
  [2052] = 1087,
  [2053] = 1112,
  [2054] = 1625,
  [2055] = 1088,
  [2056] = 1089,
  [2057] = 1107,
  [2058] = 1230,
  [2059] = 1349,
  [2060] = 1110,
  [2061] = 1369,
  [2062] = 1276,
  [2063] = 1120,
  [2064] = 1118,
  [2065] = 1119,
  [2066] = 1317,
  [2067] = 1125,
  [2068] = 1103,
  [2069] = 1263,
  [2070] = 1232,
  [2071] = 1261,
  [2072] = 1230,
  [2073] = 1257,
  [2074] = 1262,
  [2075] = 1165,
  [2076] = 1276,
  [2077] = 1279,
  [2078] = 1111,
  [2079] = 1110,
  [2080] = 1106,
  [2081] = 1308,
  [2082] = 1278,
  [2083] = 1510,
  [2084] = 1148,
  [2085] = 1246,
  [2086] = 1120,
  [2087] = 1165,
  [2088] = 1119,
  [2089] = 1118,
  [2090] = 1113,
  [2091] = 1352,
  [2092] = 1352,
  [2093] = 1246,
  [2094] = 1246,
  [2095] = 1146,
  [2096] = 1306,
  [2097] = 1125,
  [2098] = 2098,
  [2099] = 1165,
  [2100] = 1232,
  [2101] = 1230,
  [2102] = 1510,
  [2103] = 2103,
  [2104] = 1345,
  [2105] = 1263,
  [2106] = 1278,
  [2107] = 1308,
  [2108] = 1349,
  [2109] = 1110,
  [2110] = 1103,
  [2111] = 1317,
  [2112] = 1317,
  [2113] = 1103,
  [2114] = 1110,
  [2115] = 1230,
  [2116] = 1345,
  [2117] = 1367,
  [2118] = 1308,
  [2119] = 1120,
  [2120] = 1279,
  [2121] = 1349,
  [2122] = 1119,
  [2123] = 1118,
  [2124] = 1113,
  [2125] = 1125,
  [2126] = 1276,
  [2127] = 1263,
  [2128] = 1433,
  [2129] = 1436,
  [2130] = 1363,
  [2131] = 1444,
  [2132] = 1354,
  [2133] = 1365,
  [2134] = 1422,
  [2135] = 1232,
  [2136] = 1368,
  [2137] = 1369,
  [2138] = 1231,
  [2139] = 1338,
  [2140] = 1340,
  [2141] = 1165,
  [2142] = 1397,
  [2143] = 1396,
  [2144] = 1393,
  [2145] = 1455,
  [2146] = 1371,
  [2147] = 1385,
  [2148] = 1388,
  [2149] = 1402,
  [2150] = 1404,
  [2151] = 1405,
  [2152] = 1407,
  [2153] = 1414,
  [2154] = 1420,
  [2155] = 1378,
  [2156] = 1233,
  [2157] = 1120,
  [2158] = 1278,
  [2159] = 1119,
  [2160] = 1118,
  [2161] = 1113,
  [2162] = 1504,
  [2163] = 1507,
  [2164] = 1356,
  [2165] = 1564,
  [2166] = 1565,
  [2167] = 1566,
  [2168] = 1125,
  [2169] = 1378,
  [2170] = 1375,
  [2171] = 1262,
  [2172] = 1261,
  [2173] = 1433,
  [2174] = 1278,
  [2175] = 1436,
  [2176] = 1363,
  [2177] = 1444,
  [2178] = 1308,
  [2179] = 1354,
  [2180] = 1365,
  [2181] = 1422,
  [2182] = 1230,
  [2183] = 1368,
  [2184] = 1369,
  [2185] = 1231,
  [2186] = 1317,
  [2187] = 1338,
  [2188] = 1230,
  [2189] = 1345,
  [2190] = 1257,
  [2191] = 1397,
  [2192] = 1396,
  [2193] = 1393,
  [2194] = 1455,
  [2195] = 1371,
  [2196] = 1385,
  [2197] = 1388,
  [2198] = 1402,
  [2199] = 1404,
  [2200] = 1405,
  [2201] = 1407,
  [2202] = 1414,
  [2203] = 1420,
  [2204] = 1375,
  [2205] = 1233,
  [2206] = 1232,
  [2207] = 1367,
  [2208] = 1349,
  [2209] = 1566,
  [2210] = 1565,
  [2211] = 1564,
  [2212] = 1356,
  [2213] = 1246,
  [2214] = 1504,
  [2215] = 1507,
  [2216] = 1356,
  [2217] = 1564,
  [2218] = 1565,
  [2219] = 1566,
  [2220] = 1364,
  [2221] = 1367,
  [2222] = 1375,
  [2223] = 1257,
  [2224] = 1387,
  [2225] = 1233,
  [2226] = 1261,
  [2227] = 1262,
  [2228] = 1510,
  [2229] = 1414,
  [2230] = 1111,
  [2231] = 1276,
  [2232] = 1279,
  [2233] = 1407,
  [2234] = 1110,
  [2235] = 1405,
  [2236] = 1404,
  [2237] = 1402,
  [2238] = 1388,
  [2239] = 1385,
  [2240] = 1371,
  [2241] = 1455,
  [2242] = 1106,
  [2243] = 1103,
  [2244] = 1345,
  [2245] = 1393,
  [2246] = 1349,
  [2247] = 1396,
  [2248] = 1397,
  [2249] = 1233,
  [2250] = 1338,
  [2251] = 1231,
  [2252] = 2252,
  [2253] = 1354,
  [2254] = 1444,
  [2255] = 1279,
  [2256] = 1276,
  [2257] = 1433,
  [2258] = 1262,
  [2259] = 1263,
  [2260] = 1261,
  [2261] = 1257,
  [2262] = 1148,
  [2263] = 1349,
  [2264] = 1340,
  [2265] = 1306,
  [2266] = 1246,
  [2267] = 1146,
  [2268] = 1507,
  [2269] = 1504,
  [2270] = 1148,
  [2271] = 1306,
  [2272] = 1345,
  [2273] = 1510,
  [2274] = 1378,
  [2275] = 1420,
  [2276] = 1231,
  [2277] = 1113,
  [2278] = 1433,
  [2279] = 1436,
  [2280] = 1363,
  [2281] = 1444,
  [2282] = 1354,
  [2283] = 1365,
  [2284] = 1422,
  [2285] = 1146,
  [2286] = 1368,
  [2287] = 1369,
  [2288] = 1231,
  [2289] = 1338,
  [2290] = 1306,
  [2291] = 1106,
  [2292] = 1397,
  [2293] = 1396,
  [2294] = 1393,
  [2295] = 1455,
  [2296] = 1371,
  [2297] = 1385,
  [2298] = 1388,
  [2299] = 1402,
  [2300] = 1404,
  [2301] = 1405,
  [2302] = 1368,
  [2303] = 1407,
  [2304] = 1364,
  [2305] = 1414,
  [2306] = 1420,
  [2307] = 1378,
  [2308] = 1233,
  [2309] = 1387,
  [2310] = 1422,
  [2311] = 1365,
  [2312] = 1111,
  [2313] = 1436,
  [2314] = 1363,
  [2315] = 1504,
  [2316] = 1507,
  [2317] = 1436,
  [2318] = 1356,
  [2319] = 1352,
  [2320] = 1510,
  [2321] = 1564,
  [2322] = 1349,
  [2323] = 1565,
  [2324] = 1566,
  [2325] = 1253,
  [2326] = 1367,
  [2327] = 1375,
  [2328] = 1352,
  [2329] = 1510,
  [2330] = 1433,
  [2331] = 1278,
  [2332] = 1510,
  [2333] = 1363,
  [2334] = 1444,
  [2335] = 1308,
  [2336] = 1354,
  [2337] = 1365,
  [2338] = 1422,
  [2339] = 1368,
  [2340] = 1369,
  [2341] = 1231,
  [2342] = 1317,
  [2343] = 1338,
  [2344] = 1165,
  [2345] = 1397,
  [2346] = 1396,
  [2347] = 1393,
  [2348] = 1455,
  [2349] = 1371,
  [2350] = 1385,
  [2351] = 1233,
  [2352] = 1388,
  [2353] = 1402,
  [2354] = 1103,
  [2355] = 1231,
  [2356] = 1404,
  [2357] = 1110,
  [2358] = 1405,
  [2359] = 1407,
  [2360] = 1414,
  [2361] = 1420,
  [2362] = 1378,
  [2363] = 1345,
  [2364] = 1233,
  [2365] = 1232,
  [2366] = 1120,
  [2367] = 1099,
  [2368] = 1246,
  [2369] = 1119,
  [2370] = 1279,
  [2371] = 1118,
  [2372] = 1113,
  [2373] = 1504,
  [2374] = 1507,
  [2375] = 1356,
  [2376] = 1564,
  [2377] = 1233,
  [2378] = 1565,
  [2379] = 1566,
  [2380] = 1231,
  [2381] = 1125,
  [2382] = 1367,
  [2383] = 1103,
  [2384] = 1375,
  [2385] = 1110,
  [2386] = 1103,
  [2387] = 1233,
  [2388] = 1110,
  [2389] = 1257,
  [2390] = 1231,
  [2391] = 1103,
  [2392] = 1510,
  [2393] = 1110,
  [2394] = 1233,
  [2395] = 1261,
  [2396] = 1231,
  [2397] = 1262,
  [2398] = 1110,
  [2399] = 1103,
  [2400] = 1103,
  [2401] = 1110,
  [2402] = 1263,
  [2403] = 1368,
  [2404] = 2404,
  [2405] = 1233,
  [2406] = 1099,
  [2407] = 1231,
  [2408] = 1231,
  [2409] = 2409,
  [2410] = 1566,
  [2411] = 1103,
  [2412] = 1436,
  [2413] = 1110,
  [2414] = 1363,
  [2415] = 1444,
  [2416] = 1368,
  [2417] = 2404,
  [2418] = 1354,
  [2419] = 1365,
  [2420] = 1422,
  [2421] = 1368,
  [2422] = 1369,
  [2423] = 1231,
  [2424] = 1338,
  [2425] = 1338,
  [2426] = 1165,
  [2427] = 1397,
  [2428] = 1396,
  [2429] = 1393,
  [2430] = 1455,
  [2431] = 1371,
  [2432] = 1385,
  [2433] = 1388,
  [2434] = 1402,
  [2435] = 1404,
  [2436] = 1405,
  [2437] = 1407,
  [2438] = 1414,
  [2439] = 1420,
  [2440] = 1378,
  [2441] = 1233,
  [2442] = 1120,
  [2443] = 1369,
  [2444] = 1119,
  [2445] = 1118,
  [2446] = 1113,
  [2447] = 1231,
  [2448] = 1504,
  [2449] = 1507,
  [2450] = 1345,
  [2451] = 1356,
  [2452] = 1564,
  [2453] = 1565,
  [2454] = 1110,
  [2455] = 1354,
  [2456] = 1356,
  [2457] = 1338,
  [2458] = 2458,
  [2459] = 1338,
  [2460] = 1165,
  [2461] = 1125,
  [2462] = 1367,
  [2463] = 1375,
  [2464] = 1345,
  [2465] = 1103,
  [2466] = 2252,
  [2467] = 2409,
  [2468] = 1397,
  [2469] = 2404,
  [2470] = 1396,
  [2471] = 1393,
  [2472] = 1455,
  [2473] = 1113,
  [2474] = 1371,
  [2475] = 1385,
  [2476] = 1388,
  [2477] = 2458,
  [2478] = 1422,
  [2479] = 1365,
  [2480] = 1402,
  [2481] = 1404,
  [2482] = 1405,
  [2483] = 1407,
  [2484] = 1414,
  [2485] = 1354,
  [2486] = 1397,
  [2487] = 2458,
  [2488] = 1510,
  [2489] = 1233,
  [2490] = 1365,
  [2491] = 1352,
  [2492] = 2409,
  [2493] = 1233,
  [2494] = 1444,
  [2495] = 2404,
  [2496] = 1118,
  [2497] = 2404,
  [2498] = 1119,
  [2499] = 1349,
  [2500] = 1444,
  [2501] = 1397,
  [2502] = 2409,
  [2503] = 1279,
  [2504] = 1230,
  [2505] = 1276,
  [2506] = 1396,
  [2507] = 1363,
  [2508] = 1436,
  [2509] = 2458,
  [2510] = 1510,
  [2511] = 1233,
  [2512] = 1349,
  [2513] = 2409,
  [2514] = 1345,
  [2515] = 1246,
  [2516] = 1352,
  [2517] = 1349,
  [2518] = 1393,
  [2519] = 1368,
  [2520] = 1564,
  [2521] = 1433,
  [2522] = 1565,
  [2523] = 1566,
  [2524] = 1455,
  [2525] = 1165,
  [2526] = 2098,
  [2527] = 1352,
  [2528] = 1120,
  [2529] = 1433,
  [2530] = 1371,
  [2531] = 2404,
  [2532] = 1385,
  [2533] = 1352,
  [2534] = 2458,
  [2535] = 1120,
  [2536] = 1367,
  [2537] = 1119,
  [2538] = 1118,
  [2539] = 1113,
  [2540] = 1109,
  [2541] = 1354,
  [2542] = 1352,
  [2543] = 1388,
  [2544] = 1246,
  [2545] = 1402,
  [2546] = 1433,
  [2547] = 1262,
  [2548] = 1510,
  [2549] = 1375,
  [2550] = 1125,
  [2551] = 1261,
  [2552] = 1261,
  [2553] = 2458,
  [2554] = 1278,
  [2555] = 1231,
  [2556] = 2404,
  [2557] = 1233,
  [2558] = 2409,
  [2559] = 1308,
  [2560] = 1110,
  [2561] = 1257,
  [2562] = 1125,
  [2563] = 1246,
  [2564] = 1352,
  [2565] = 1349,
  [2566] = 2409,
  [2567] = 2404,
  [2568] = 1120,
  [2569] = 1119,
  [2570] = 2103,
  [2571] = 1125,
  [2572] = 1404,
  [2573] = 1317,
  [2574] = 1369,
  [2575] = 1118,
  [2576] = 1232,
  [2577] = 2458,
  [2578] = 1566,
  [2579] = 1103,
  [2580] = 1345,
  [2581] = 1306,
  [2582] = 1110,
  [2583] = 1405,
  [2584] = 1407,
  [2585] = 1414,
  [2586] = 1278,
  [2587] = 1233,
  [2588] = 1420,
  [2589] = 1165,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 1436,
  [2595] = 1363,
  [2596] = 2458,
  [2597] = 1378,
  [2598] = 1371,
  [2599] = 1385,
  [2600] = 1367,
  [2601] = 1375,
  [2602] = 1103,
  [2603] = 1388,
  [2604] = 2409,
  [2605] = 2605,
  [2606] = 1113,
  [2607] = 1308,
  [2608] = 1231,
  [2609] = 2609,
  [2610] = 2404,
  [2611] = 2404,
  [2612] = 1345,
  [2613] = 1230,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 1565,
  [2617] = 1564,
  [2618] = 1356,
  [2619] = 1110,
  [2620] = 1385,
  [2621] = 1375,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 1367,
  [2625] = 2409,
  [2626] = 1352,
  [2627] = 2627,
  [2628] = 1507,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 1246,
  [2632] = 1504,
  [2633] = 1232,
  [2634] = 1276,
  [2635] = 1349,
  [2636] = 1113,
  [2637] = 1118,
  [2638] = 1422,
  [2639] = 2458,
  [2640] = 1231,
  [2641] = 2641,
  [2642] = 1566,
  [2643] = 1565,
  [2644] = 1352,
  [2645] = 2458,
  [2646] = 2458,
  [2647] = 1365,
  [2648] = 1422,
  [2649] = 1368,
  [2650] = 2650,
  [2651] = 1257,
  [2652] = 2409,
  [2653] = 1564,
  [2654] = 1356,
  [2655] = 1231,
  [2656] = 1402,
  [2657] = 2404,
  [2658] = 1262,
  [2659] = 1455,
  [2660] = 2409,
  [2661] = 1369,
  [2662] = 1404,
  [2663] = 2404,
  [2664] = 1507,
  [2665] = 2409,
  [2666] = 2666,
  [2667] = 1232,
  [2668] = 2409,
  [2669] = 1278,
  [2670] = 2670,
  [2671] = 1317,
  [2672] = 1405,
  [2673] = 1444,
  [2674] = 1279,
  [2675] = 1566,
  [2676] = 1349,
  [2677] = 1504,
  [2678] = 1103,
  [2679] = 2679,
  [2680] = 1120,
  [2681] = 2458,
  [2682] = 2458,
  [2683] = 2458,
  [2684] = 1504,
  [2685] = 1507,
  [2686] = 1233,
  [2687] = 1565,
  [2688] = 2458,
  [2689] = 1564,
  [2690] = 1263,
  [2691] = 2409,
  [2692] = 1433,
  [2693] = 1414,
  [2694] = 1436,
  [2695] = 1378,
  [2696] = 1378,
  [2697] = 1420,
  [2698] = 1407,
  [2699] = 1263,
  [2700] = 1420,
  [2701] = 1414,
  [2702] = 1436,
  [2703] = 1405,
  [2704] = 2404,
  [2705] = 1404,
  [2706] = 1363,
  [2707] = 1407,
  [2708] = 1405,
  [2709] = 1404,
  [2710] = 1402,
  [2711] = 2409,
  [2712] = 1402,
  [2713] = 1388,
  [2714] = 1365,
  [2715] = 1385,
  [2716] = 2458,
  [2717] = 1371,
  [2718] = 1455,
  [2719] = 2404,
  [2720] = 2409,
  [2721] = 1119,
  [2722] = 1276,
  [2723] = 1279,
  [2724] = 1356,
  [2725] = 2404,
  [2726] = 1393,
  [2727] = 1363,
  [2728] = 1407,
  [2729] = 1396,
  [2730] = 1433,
  [2731] = 1564,
  [2732] = 2404,
  [2733] = 1444,
  [2734] = 1388,
  [2735] = 1507,
  [2736] = 2409,
  [2737] = 1308,
  [2738] = 1504,
  [2739] = 1369,
  [2740] = 1262,
  [2741] = 1507,
  [2742] = 1263,
  [2743] = 2458,
  [2744] = 2458,
  [2745] = 1103,
  [2746] = 1125,
  [2747] = 1371,
  [2748] = 1345,
  [2749] = 1165,
  [2750] = 1455,
  [2751] = 1420,
  [2752] = 1378,
  [2753] = 1110,
  [2754] = 1317,
  [2755] = 1414,
  [2756] = 2404,
  [2757] = 2404,
  [2758] = 1504,
  [2759] = 1565,
  [2760] = 1393,
  [2761] = 1396,
  [2762] = 1566,
  [2763] = 2409,
  [2764] = 1420,
  [2765] = 2409,
  [2766] = 1354,
  [2767] = 1261,
  [2768] = 1397,
  [2769] = 1365,
  [2770] = 2458,
  [2771] = 2458,
  [2772] = 1510,
  [2773] = 2404,
  [2774] = 2404,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 1338,
  [2778] = 2409,
  [2779] = 2779,
  [2780] = 1354,
  [2781] = 1257,
  [2782] = 1375,
  [2783] = 1367,
  [2784] = 2458,
  [2785] = 1369,
  [2786] = 1368,
  [2787] = 1230,
  [2788] = 1422,
  [2789] = 2409,
  [2790] = 2404,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 1165,
  [2794] = 2775,
  [2795] = 1365,
  [2796] = 1233,
  [2797] = 1368,
  [2798] = 1369,
  [2799] = 2799,
  [2800] = 2799,
  [2801] = 2799,
  [2802] = 2799,
  [2803] = 1231,
  [2804] = 2804,
  [2805] = 1338,
  [2806] = 1414,
  [2807] = 1407,
  [2808] = 1405,
  [2809] = 1444,
  [2810] = 1404,
  [2811] = 1356,
  [2812] = 1564,
  [2813] = 1345,
  [2814] = 1397,
  [2815] = 2592,
  [2816] = 2593,
  [2817] = 1402,
  [2818] = 2799,
  [2819] = 1388,
  [2820] = 1385,
  [2821] = 1363,
  [2822] = 1371,
  [2823] = 1455,
  [2824] = 1436,
  [2825] = 1363,
  [2826] = 2799,
  [2827] = 1436,
  [2828] = 1393,
  [2829] = 1420,
  [2830] = 1378,
  [2831] = 1396,
  [2832] = 1565,
  [2833] = 1566,
  [2834] = 1397,
  [2835] = 2622,
  [2836] = 1345,
  [2837] = 1233,
  [2838] = 2799,
  [2839] = 1338,
  [2840] = 2799,
  [2841] = 1375,
  [2842] = 1367,
  [2843] = 1433,
  [2844] = 1231,
  [2845] = 1125,
  [2846] = 1349,
  [2847] = 1422,
  [2848] = 2630,
  [2849] = 2799,
  [2850] = 1566,
  [2851] = 1565,
  [2852] = 1564,
  [2853] = 2103,
  [2854] = 1356,
  [2855] = 2799,
  [2856] = 1504,
  [2857] = 1349,
  [2858] = 2799,
  [2859] = 1507,
  [2860] = 1118,
  [2861] = 1119,
  [2862] = 1120,
  [2863] = 1354,
  [2864] = 1233,
  [2865] = 1367,
  [2866] = 1375,
  [2867] = 2623,
  [2868] = 2868,
  [2869] = 1566,
  [2870] = 2629,
  [2871] = 1414,
  [2872] = 1407,
  [2873] = 1405,
  [2874] = 1404,
  [2875] = 1444,
  [2876] = 2799,
  [2877] = 1165,
  [2878] = 2799,
  [2879] = 2799,
  [2880] = 2799,
  [2881] = 1402,
  [2882] = 1388,
  [2883] = 2799,
  [2884] = 2098,
  [2885] = 2885,
  [2886] = 2098,
  [2887] = 1385,
  [2888] = 1371,
  [2889] = 1113,
  [2890] = 1393,
  [2891] = 2891,
  [2892] = 1367,
  [2893] = 1396,
  [2894] = 1397,
  [2895] = 2666,
  [2896] = 1113,
  [2897] = 1349,
  [2898] = 1338,
  [2899] = 1231,
  [2900] = 1099,
  [2901] = 1120,
  [2902] = 2590,
  [2903] = 1565,
  [2904] = 2591,
  [2905] = 1564,
  [2906] = 1356,
  [2907] = 2605,
  [2908] = 2609,
  [2909] = 1119,
  [2910] = 1099,
  [2911] = 1118,
  [2912] = 2799,
  [2913] = 1354,
  [2914] = 1444,
  [2915] = 1507,
  [2916] = 2614,
  [2917] = 1433,
  [2918] = 1504,
  [2919] = 2615,
  [2920] = 2627,
  [2921] = 1566,
  [2922] = 1565,
  [2923] = 2799,
  [2924] = 1349,
  [2925] = 1564,
  [2926] = 1507,
  [2927] = 1504,
  [2928] = 1125,
  [2929] = 1436,
  [2930] = 1125,
  [2931] = 1510,
  [2932] = 2641,
  [2933] = 2650,
  [2934] = 1375,
  [2935] = 2670,
  [2936] = 1420,
  [2937] = 2103,
  [2938] = 1414,
  [2939] = 1407,
  [2940] = 1405,
  [2941] = 1507,
  [2942] = 1504,
  [2943] = 1378,
  [2944] = 1113,
  [2945] = 1118,
  [2946] = 1119,
  [2947] = 2799,
  [2948] = 1404,
  [2949] = 1363,
  [2950] = 1420,
  [2951] = 2792,
  [2952] = 2791,
  [2953] = 1402,
  [2954] = 1388,
  [2955] = 1414,
  [2956] = 1407,
  [2957] = 1405,
  [2958] = 1385,
  [2959] = 1404,
  [2960] = 1371,
  [2961] = 1120,
  [2962] = 2779,
  [2963] = 1402,
  [2964] = 2776,
  [2965] = 1433,
  [2966] = 1388,
  [2967] = 1385,
  [2968] = 2799,
  [2969] = 2799,
  [2970] = 1345,
  [2971] = 1354,
  [2972] = 1455,
  [2973] = 1455,
  [2974] = 1371,
  [2975] = 1455,
  [2976] = 1393,
  [2977] = 1378,
  [2978] = 1396,
  [2979] = 1420,
  [2980] = 1369,
  [2981] = 1368,
  [2982] = 2799,
  [2983] = 1365,
  [2984] = 1365,
  [2985] = 1422,
  [2986] = 1368,
  [2987] = 1354,
  [2988] = 1345,
  [2989] = 1165,
  [2990] = 2679,
  [2991] = 1365,
  [2992] = 1109,
  [2993] = 1349,
  [2994] = 1345,
  [2995] = 1422,
  [2996] = 1369,
  [2997] = 1368,
  [2998] = 1369,
  [2999] = 2670,
  [3000] = 2615,
  [3001] = 3001,
  [3002] = 2623,
  [3003] = 3001,
  [3004] = 3001,
  [3005] = 2593,
  [3006] = 2592,
  [3007] = 2679,
  [3008] = 3001,
  [3009] = 3001,
  [3010] = 1109,
  [3011] = 3001,
  [3012] = 2590,
  [3013] = 2622,
  [3014] = 3001,
  [3015] = 2630,
  [3016] = 2590,
  [3017] = 2591,
  [3018] = 2629,
  [3019] = 2630,
  [3020] = 2792,
  [3021] = 2623,
  [3022] = 2622,
  [3023] = 2591,
  [3024] = 3001,
  [3025] = 3001,
  [3026] = 3001,
  [3027] = 3001,
  [3028] = 2605,
  [3029] = 2609,
  [3030] = 3001,
  [3031] = 3001,
  [3032] = 2614,
  [3033] = 2776,
  [3034] = 1109,
  [3035] = 3001,
  [3036] = 2666,
  [3037] = 2629,
  [3038] = 2605,
  [3039] = 2650,
  [3040] = 2627,
  [3041] = 3001,
  [3042] = 2641,
  [3043] = 2775,
  [3044] = 2650,
  [3045] = 2593,
  [3046] = 2666,
  [3047] = 3001,
  [3048] = 2592,
  [3049] = 3001,
  [3050] = 2776,
  [3051] = 2609,
  [3052] = 2779,
  [3053] = 2670,
  [3054] = 2614,
  [3055] = 2615,
  [3056] = 2627,
  [3057] = 2791,
  [3058] = 3001,
  [3059] = 3001,
  [3060] = 3001,
  [3061] = 2679,
  [3062] = 2792,
  [3063] = 2791,
  [3064] = 2779,
  [3065] = 2641,
  [3066] = 3001,
  [3067] = 2775,
  [3068] = 1070,
  [3069] = 1070,
  [3070] = 1062,
  [3071] = 1062,
  [3072] = 1084,
  [3073] = 1084,
  [3074] = 1138,
  [3075] = 1097,
  [3076] = 1099,
  [3077] = 3077,
  [3078] = 1103,
  [3079] = 1110,
  [3080] = 1155,
  [3081] = 1099,
  [3082] = 1165,
  [3083] = 1141,
  [3084] = 1125,
  [3085] = 1138,
  [3086] = 3086,
  [3087] = 3087,
  [3088] = 1163,
  [3089] = 1119,
  [3090] = 1118,
  [3091] = 1115,
  [3092] = 1113,
  [3093] = 1109,
  [3094] = 1141,
  [3095] = 1110,
  [3096] = 1115,
  [3097] = 1120,
  [3098] = 1127,
  [3099] = 1165,
  [3100] = 1128,
  [3101] = 1109,
  [3102] = 1113,
  [3103] = 1163,
  [3104] = 1097,
  [3105] = 1128,
  [3106] = 1155,
  [3107] = 1125,
  [3108] = 1127,
  [3109] = 1120,
  [3110] = 1103,
  [3111] = 1119,
  [3112] = 1118,
  [3113] = 3113,
  [3114] = 3113,
  [3115] = 3115,
  [3116] = 3113,
  [3117] = 3113,
  [3118] = 3113,
  [3119] = 3115,
  [3120] = 3115,
  [3121] = 3115,
  [3122] = 3113,
  [3123] = 3113,
  [3124] = 3115,
  [3125] = 3115,
  [3126] = 3113,
  [3127] = 3115,
  [3128] = 3113,
  [3129] = 3113,
  [3130] = 3115,
  [3131] = 3115,
  [3132] = 3113,
  [3133] = 3113,
  [3134] = 3115,
  [3135] = 3115,
  [3136] = 3113,
  [3137] = 3115,
  [3138] = 3115,
  [3139] = 3115,
  [3140] = 3113,
  [3141] = 3115,
  [3142] = 3115,
  [3143] = 3113,
  [3144] = 3113,
  [3145] = 3115,
  [3146] = 3113,
  [3147] = 3115,
  [3148] = 3115,
  [3149] = 3113,
  [3150] = 3115,
  [3151] = 3113,
  [3152] = 3113,
  [3153] = 3153,
  [3154] = 3154,
  [3155] = 3153,
  [3156] = 3153,
  [3157] = 3154,
  [3158] = 3153,
  [3159] = 3154,
  [3160] = 3154,
  [3161] = 3161,
  [3162] = 3154,
  [3163] = 3153,
  [3164] = 3153,
  [3165] = 3154,
  [3166] = 3154,
  [3167] = 3154,
  [3168] = 3153,
  [3169] = 3153,
  [3170] = 3153,
  [3171] = 3153,
  [3172] = 3154,
  [3173] = 3154,
  [3174] = 3153,
  [3175] = 3154,
  [3176] = 3153,
  [3177] = 3153,
  [3178] = 3153,
  [3179] = 3153,
  [3180] = 3153,
  [3181] = 3153,
  [3182] = 3154,
  [3183] = 3154,
  [3184] = 3154,
  [3185] = 3153,
  [3186] = 3154,
  [3187] = 3153,
  [3188] = 3153,
  [3189] = 3154,
  [3190] = 3154,
  [3191] = 3154,
  [3192] = 3154,
  [3193] = 3153,
  [3194] = 3154,
  [3195] = 3154,
  [3196] = 3153,
  [3197] = 3153,
  [3198] = 3154,
  [3199] = 3153,
  [3200] = 3154,
  [3201] = 3154,
  [3202] = 3202,
  [3203] = 3202,
  [3204] = 3202,
  [3205] = 3202,
  [3206] = 3202,
  [3207] = 3202,
  [3208] = 3202,
  [3209] = 3202,
  [3210] = 3202,
  [3211] = 3202,
  [3212] = 3202,
  [3213] = 3202,
  [3214] = 3202,
  [3215] = 3202,
  [3216] = 3202,
  [3217] = 3202,
  [3218] = 3202,
  [3219] = 3202,
  [3220] = 3202,
  [3221] = 3202,
  [3222] = 3222,
  [3223] = 3222,
  [3224] = 3222,
  [3225] = 3222,
  [3226] = 3222,
  [3227] = 3222,
  [3228] = 3222,
  [3229] = 3229,
  [3230] = 3222,
  [3231] = 3231,
  [3232] = 3222,
  [3233] = 3233,
  [3234] = 3234,
  [3235] = 3234,
  [3236] = 3229,
  [3237] = 1306,
  [3238] = 3233,
  [3239] = 3222,
  [3240] = 3222,
  [3241] = 3229,
  [3242] = 3222,
  [3243] = 3231,
  [3244] = 3233,
  [3245] = 3222,
  [3246] = 1099,
  [3247] = 3234,
  [3248] = 3234,
  [3249] = 3222,
  [3250] = 3222,
  [3251] = 3233,
  [3252] = 3231,
  [3253] = 3222,
  [3254] = 3222,
  [3255] = 3255,
  [3256] = 3222,
  [3257] = 3231,
  [3258] = 3222,
  [3259] = 3229,
  [3260] = 3222,
  [3261] = 3261,
  [3262] = 3262,
  [3263] = 3262,
  [3264] = 3261,
  [3265] = 3265,
  [3266] = 3261,
  [3267] = 3267,
  [3268] = 3268,
  [3269] = 3261,
  [3270] = 3262,
  [3271] = 3261,
  [3272] = 3268,
  [3273] = 3267,
  [3274] = 3274,
  [3275] = 3261,
  [3276] = 3262,
  [3277] = 3268,
  [3278] = 3267,
  [3279] = 3262,
  [3280] = 3261,
  [3281] = 3265,
  [3282] = 3265,
  [3283] = 3261,
  [3284] = 3267,
  [3285] = 3268,
  [3286] = 3267,
  [3287] = 3268,
  [3288] = 3262,
  [3289] = 3262,
  [3290] = 3262,
  [3291] = 3274,
  [3292] = 3262,
  [3293] = 3274,
  [3294] = 3262,
  [3295] = 3261,
  [3296] = 3261,
  [3297] = 3267,
  [3298] = 3268,
  [3299] = 3268,
  [3300] = 3268,
  [3301] = 3267,
  [3302] = 3261,
  [3303] = 3267,
  [3304] = 3268,
  [3305] = 3267,
  [3306] = 3306,
  [3307] = 3262,
  [3308] = 3262,
  [3309] = 3261,
  [3310] = 3265,
  [3311] = 3262,
  [3312] = 3262,
  [3313] = 3267,
  [3314] = 3268,
  [3315] = 3262,
  [3316] = 3261,
  [3317] = 3267,
  [3318] = 3268,
  [3319] = 3319,
  [3320] = 3262,
  [3321] = 3268,
  [3322] = 3267,
  [3323] = 3267,
  [3324] = 3261,
  [3325] = 3261,
  [3326] = 3267,
  [3327] = 3268,
  [3328] = 3262,
  [3329] = 3268,
  [3330] = 3268,
  [3331] = 3331,
  [3332] = 3267,
  [3333] = 3261,
  [3334] = 3262,
  [3335] = 3267,
  [3336] = 3306,
  [3337] = 3262,
  [3338] = 3331,
  [3339] = 3331,
  [3340] = 3331,
  [3341] = 3331,
  [3342] = 3331,
  [3343] = 3265,
  [3344] = 3261,
  [3345] = 3331,
  [3346] = 3267,
  [3347] = 3268,
  [3348] = 3261,
  [3349] = 3331,
  [3350] = 3331,
  [3351] = 3331,
  [3352] = 3331,
  [3353] = 3331,
  [3354] = 3331,
  [3355] = 3274,
  [3356] = 3331,
  [3357] = 3331,
  [3358] = 3331,
  [3359] = 3331,
  [3360] = 3331,
  [3361] = 3331,
  [3362] = 3331,
  [3363] = 3331,
  [3364] = 3268,
  [3365] = 3319,
  [3366] = 3331,
  [3367] = 3367,
  [3368] = 3331,
  [3369] = 3331,
  [3370] = 3331,
  [3371] = 3371,
  [3372] = 3262,
  [3373] = 3268,
  [3374] = 3306,
  [3375] = 3267,
  [3376] = 3262,
  [3377] = 3262,
  [3378] = 3261,
  [3379] = 3261,
  [3380] = 3268,
  [3381] = 3262,
  [3382] = 3267,
  [3383] = 3268,
  [3384] = 3267,
  [3385] = 3385,
  [3386] = 3386,
  [3387] = 3387,
  [3388] = 3388,
  [3389] = 3389,
  [3390] = 3386,
  [3391] = 3387,
  [3392] = 3388,
  [3393] = 3389,
  [3394] = 3386,
  [3395] = 3387,
  [3396] = 3388,
  [3397] = 3389,
  [3398] = 3386,
  [3399] = 3387,
  [3400] = 3388,
  [3401] = 3389,
  [3402] = 3386,
  [3403] = 3387,
  [3404] = 3388,
  [3405] = 3389,
  [3406] = 3386,
  [3407] = 3387,
  [3408] = 3389,
  [3409] = 3387,
  [3410] = 3389,
  [3411] = 3387,
  [3412] = 3389,
  [3413] = 3387,
  [3414] = 3389,
  [3415] = 3387,
  [3416] = 3389,
  [3417] = 3387,
  [3418] = 3418,
  [3419] = 3419,
  [3420] = 3420,
  [3421] = 3387,
  [3422] = 3388,
  [3423] = 3423,
  [3424] = 3424,
  [3425] = 3425,
  [3426] = 3426,
  [3427] = 3389,
  [3428] = 3428,
  [3429] = 3386,
  [3430] = 3387,
  [3431] = 3388,
  [3432] = 3389,
  [3433] = 3386,
  [3434] = 3387,
  [3435] = 3388,
  [3436] = 3436,
  [3437] = 3437,
  [3438] = 3389,
  [3439] = 3439,
  [3440] = 3388,
  [3441] = 3386,
  [3442] = 3389,
  [3443] = 3388,
  [3444] = 3387,
  [3445] = 3386,
  [3446] = 3389,
  [3447] = 3388,
  [3448] = 3387,
  [3449] = 3386,
  [3450] = 3389,
  [3451] = 3388,
  [3452] = 3387,
  [3453] = 3386,
  [3454] = 3389,
  [3455] = 3388,
  [3456] = 3387,
  [3457] = 3386,
  [3458] = 3389,
  [3459] = 3388,
  [3460] = 3387,
  [3461] = 3386,
  [3462] = 3389,
  [3463] = 3388,
  [3464] = 3387,
  [3465] = 3386,
  [3466] = 3389,
  [3467] = 3467,
  [3468] = 3387,
  [3469] = 3386,
  [3470] = 3389,
  [3471] = 3471,
  [3472] = 3388,
  [3473] = 3473,
  [3474] = 3474,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 3467,
  [3478] = 3478,
  [3479] = 3387,
  [3480] = 3386,
  [3481] = 3389,
  [3482] = 3385,
  [3483] = 3471,
  [3484] = 3388,
  [3485] = 3473,
  [3486] = 3486,
  [3487] = 3474,
  [3488] = 3475,
  [3489] = 3476,
  [3490] = 3467,
  [3491] = 3478,
  [3492] = 3387,
  [3493] = 3386,
  [3494] = 3389,
  [3495] = 3385,
  [3496] = 3471,
  [3497] = 3388,
  [3498] = 3473,
  [3499] = 3486,
  [3500] = 3474,
  [3501] = 3475,
  [3502] = 3476,
  [3503] = 3486,
  [3504] = 3478,
  [3505] = 3387,
  [3506] = 3386,
  [3507] = 3389,
  [3508] = 3385,
  [3509] = 3471,
  [3510] = 3388,
  [3511] = 3473,
  [3512] = 3486,
  [3513] = 3474,
  [3514] = 3475,
  [3515] = 3515,
  [3516] = 3476,
  [3517] = 3467,
  [3518] = 3478,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3387,
  [3522] = 3386,
  [3523] = 3523,
  [3524] = 3389,
  [3525] = 3385,
  [3526] = 3526,
  [3527] = 3471,
  [3528] = 3388,
  [3529] = 3529,
  [3530] = 3473,
  [3531] = 3526,
  [3532] = 3418,
  [3533] = 3419,
  [3534] = 3420,
  [3535] = 3486,
  [3536] = 3474,
  [3537] = 3423,
  [3538] = 3424,
  [3539] = 3425,
  [3540] = 3426,
  [3541] = 3475,
  [3542] = 3428,
  [3543] = 3476,
  [3544] = 3467,
  [3545] = 3478,
  [3546] = 3519,
  [3547] = 3520,
  [3548] = 3436,
  [3549] = 3437,
  [3550] = 3387,
  [3551] = 3439,
  [3552] = 3386,
  [3553] = 3523,
  [3554] = 3554,
  [3555] = 3389,
  [3556] = 3385,
  [3557] = 3471,
  [3558] = 3526,
  [3559] = 3388,
  [3560] = 3529,
  [3561] = 3473,
  [3562] = 3419,
  [3563] = 3486,
  [3564] = 3474,
  [3565] = 3423,
  [3566] = 3425,
  [3567] = 3426,
  [3568] = 3475,
  [3569] = 3428,
  [3570] = 3476,
  [3571] = 3571,
  [3572] = 3467,
  [3573] = 3478,
  [3574] = 3519,
  [3575] = 3437,
  [3576] = 3520,
  [3577] = 3439,
  [3578] = 3387,
  [3579] = 3386,
  [3580] = 3523,
  [3581] = 3554,
  [3582] = 3389,
  [3583] = 3385,
  [3584] = 3471,
  [3585] = 3526,
  [3586] = 3388,
  [3587] = 3529,
  [3588] = 3419,
  [3589] = 3473,
  [3590] = 3386,
  [3591] = 3423,
  [3592] = 3425,
  [3593] = 3426,
  [3594] = 3474,
  [3595] = 3428,
  [3596] = 3475,
  [3597] = 3476,
  [3598] = 3571,
  [3599] = 3467,
  [3600] = 3478,
  [3601] = 3437,
  [3602] = 3519,
  [3603] = 3520,
  [3604] = 3387,
  [3605] = 3386,
  [3606] = 3523,
  [3607] = 3554,
  [3608] = 3389,
  [3609] = 3385,
  [3610] = 3471,
  [3611] = 3526,
  [3612] = 3388,
  [3613] = 3529,
  [3614] = 3473,
  [3615] = 3423,
  [3616] = 3425,
  [3617] = 3426,
  [3618] = 3486,
  [3619] = 3428,
  [3620] = 3474,
  [3621] = 3475,
  [3622] = 3476,
  [3623] = 3515,
  [3624] = 3571,
  [3625] = 3437,
  [3626] = 3467,
  [3627] = 3478,
  [3628] = 3519,
  [3629] = 3520,
  [3630] = 3387,
  [3631] = 3471,
  [3632] = 3523,
  [3633] = 3554,
  [3634] = 3389,
  [3635] = 3385,
  [3636] = 3471,
  [3637] = 3526,
  [3638] = 3388,
  [3639] = 3423,
  [3640] = 3425,
  [3641] = 3426,
  [3642] = 3529,
  [3643] = 3428,
  [3644] = 3473,
  [3645] = 3486,
  [3646] = 3474,
  [3647] = 3475,
  [3648] = 3476,
  [3649] = 3437,
  [3650] = 3571,
  [3651] = 3467,
  [3652] = 3478,
  [3653] = 3519,
  [3654] = 3520,
  [3655] = 3387,
  [3656] = 3386,
  [3657] = 3523,
  [3658] = 3554,
  [3659] = 3389,
  [3660] = 3385,
  [3661] = 3471,
  [3662] = 3526,
  [3663] = 3423,
  [3664] = 3425,
  [3665] = 3426,
  [3666] = 3388,
  [3667] = 3428,
  [3668] = 3529,
  [3669] = 3473,
  [3670] = 3486,
  [3671] = 3474,
  [3672] = 3475,
  [3673] = 3437,
  [3674] = 3476,
  [3675] = 3571,
  [3676] = 3467,
  [3677] = 3478,
  [3678] = 3519,
  [3679] = 3520,
  [3680] = 3387,
  [3681] = 3386,
  [3682] = 3523,
  [3683] = 3554,
  [3684] = 3389,
  [3685] = 3385,
  [3686] = 3387,
  [3687] = 3423,
  [3688] = 3425,
  [3689] = 3426,
  [3690] = 3526,
  [3691] = 3428,
  [3692] = 3388,
  [3693] = 3529,
  [3694] = 3473,
  [3695] = 3486,
  [3696] = 3474,
  [3697] = 3437,
  [3698] = 3475,
  [3699] = 3476,
  [3700] = 3571,
  [3701] = 3467,
  [3702] = 3478,
  [3703] = 3519,
  [3704] = 3520,
  [3705] = 3387,
  [3706] = 3515,
  [3707] = 3386,
  [3708] = 3523,
  [3709] = 3554,
  [3710] = 3423,
  [3711] = 3425,
  [3712] = 3426,
  [3713] = 3389,
  [3714] = 3428,
  [3715] = 3385,
  [3716] = 3471,
  [3717] = 3526,
  [3718] = 3388,
  [3719] = 3529,
  [3720] = 3437,
  [3721] = 3473,
  [3722] = 3486,
  [3723] = 3474,
  [3724] = 3475,
  [3725] = 3476,
  [3726] = 3571,
  [3727] = 3467,
  [3728] = 3478,
  [3729] = 3519,
  [3730] = 3520,
  [3731] = 3387,
  [3732] = 3386,
  [3733] = 3423,
  [3734] = 3425,
  [3735] = 3426,
  [3736] = 3523,
  [3737] = 3428,
  [3738] = 3554,
  [3739] = 3389,
  [3740] = 3385,
  [3741] = 3471,
  [3742] = 3526,
  [3743] = 3437,
  [3744] = 3388,
  [3745] = 3529,
  [3746] = 3473,
  [3747] = 3486,
  [3748] = 3474,
  [3749] = 3475,
  [3750] = 3476,
  [3751] = 3571,
  [3752] = 3467,
  [3753] = 3478,
  [3754] = 3519,
  [3755] = 3520,
  [3756] = 3423,
  [3757] = 3425,
  [3758] = 3426,
  [3759] = 3478,
  [3760] = 3428,
  [3761] = 3386,
  [3762] = 3523,
  [3763] = 3554,
  [3764] = 3389,
  [3765] = 3385,
  [3766] = 3437,
  [3767] = 3471,
  [3768] = 3526,
  [3769] = 3388,
  [3770] = 3529,
  [3771] = 3473,
  [3772] = 3486,
  [3773] = 3474,
  [3774] = 3475,
  [3775] = 3476,
  [3776] = 3571,
  [3777] = 3467,
  [3778] = 3526,
  [3779] = 3423,
  [3780] = 3425,
  [3781] = 3426,
  [3782] = 3519,
  [3783] = 3428,
  [3784] = 3520,
  [3785] = 3387,
  [3786] = 3386,
  [3787] = 3523,
  [3788] = 3554,
  [3789] = 3437,
  [3790] = 3389,
  [3791] = 3385,
  [3792] = 3471,
  [3793] = 3526,
  [3794] = 3388,
  [3795] = 3529,
  [3796] = 3473,
  [3797] = 3486,
  [3798] = 3474,
  [3799] = 3475,
  [3800] = 3476,
  [3801] = 3571,
  [3802] = 3423,
  [3803] = 3425,
  [3804] = 3426,
  [3805] = 3467,
  [3806] = 3428,
  [3807] = 3478,
  [3808] = 3519,
  [3809] = 3520,
  [3810] = 3387,
  [3811] = 3386,
  [3812] = 3437,
  [3813] = 3523,
  [3814] = 3554,
  [3815] = 3389,
  [3816] = 3385,
  [3817] = 3471,
  [3818] = 3526,
  [3819] = 3388,
  [3820] = 3529,
  [3821] = 3473,
  [3822] = 3486,
  [3823] = 3474,
  [3824] = 3475,
  [3825] = 3423,
  [3826] = 3425,
  [3827] = 3426,
  [3828] = 3476,
  [3829] = 3428,
  [3830] = 3571,
  [3831] = 3467,
  [3832] = 3478,
  [3833] = 3833,
  [3834] = 3519,
  [3835] = 3437,
  [3836] = 3520,
  [3837] = 3387,
  [3838] = 3386,
  [3839] = 3523,
  [3840] = 3554,
  [3841] = 3389,
  [3842] = 3385,
  [3843] = 3471,
  [3844] = 3526,
  [3845] = 3388,
  [3846] = 3529,
  [3847] = 3473,
  [3848] = 3423,
  [3849] = 3425,
  [3850] = 3426,
  [3851] = 3486,
  [3852] = 3428,
  [3853] = 3474,
  [3854] = 3475,
  [3855] = 3476,
  [3856] = 3856,
  [3857] = 3857,
  [3858] = 3437,
  [3859] = 3571,
  [3860] = 3467,
  [3861] = 3478,
  [3862] = 3833,
  [3863] = 3519,
  [3864] = 3515,
  [3865] = 3515,
  [3866] = 3520,
  [3867] = 3387,
  [3868] = 3386,
  [3869] = 3523,
  [3870] = 3554,
  [3871] = 3423,
  [3872] = 3425,
  [3873] = 3426,
  [3874] = 3389,
  [3875] = 3428,
  [3876] = 3385,
  [3877] = 3471,
  [3878] = 3856,
  [3879] = 3388,
  [3880] = 3529,
  [3881] = 3437,
  [3882] = 3473,
  [3883] = 3486,
  [3884] = 3474,
  [3885] = 3475,
  [3886] = 3476,
  [3887] = 3857,
  [3888] = 3857,
  [3889] = 3571,
  [3890] = 3467,
  [3891] = 3478,
  [3892] = 3833,
  [3893] = 3519,
  [3894] = 3423,
  [3895] = 3425,
  [3896] = 3426,
  [3897] = 3520,
  [3898] = 3428,
  [3899] = 3387,
  [3900] = 3386,
  [3901] = 3519,
  [3902] = 3523,
  [3903] = 3554,
  [3904] = 3437,
  [3905] = 3389,
  [3906] = 3385,
  [3907] = 3471,
  [3908] = 3526,
  [3909] = 3388,
  [3910] = 3529,
  [3911] = 3473,
  [3912] = 3486,
  [3913] = 3474,
  [3914] = 3475,
  [3915] = 3476,
  [3916] = 3856,
  [3917] = 3423,
  [3918] = 3425,
  [3919] = 3426,
  [3920] = 3857,
  [3921] = 3428,
  [3922] = 3571,
  [3923] = 3467,
  [3924] = 3478,
  [3925] = 3833,
  [3926] = 3519,
  [3927] = 3437,
  [3928] = 3520,
  [3929] = 3387,
  [3930] = 3386,
  [3931] = 3523,
  [3932] = 3554,
  [3933] = 3389,
  [3934] = 3385,
  [3935] = 3471,
  [3936] = 3526,
  [3937] = 3388,
  [3938] = 3529,
  [3939] = 3473,
  [3940] = 3423,
  [3941] = 3425,
  [3942] = 3426,
  [3943] = 3486,
  [3944] = 3428,
  [3945] = 3520,
  [3946] = 3474,
  [3947] = 3475,
  [3948] = 3387,
  [3949] = 3476,
  [3950] = 3437,
  [3951] = 3856,
  [3952] = 3857,
  [3953] = 3571,
  [3954] = 3467,
  [3955] = 3478,
  [3956] = 3833,
  [3957] = 3519,
  [3958] = 3520,
  [3959] = 3387,
  [3960] = 3386,
  [3961] = 3523,
  [3962] = 3554,
  [3963] = 3423,
  [3964] = 3425,
  [3965] = 3426,
  [3966] = 3389,
  [3967] = 3428,
  [3968] = 3385,
  [3969] = 3471,
  [3970] = 3526,
  [3971] = 3437,
  [3972] = 3388,
  [3973] = 3529,
  [3974] = 3473,
  [3975] = 3486,
  [3976] = 3474,
  [3977] = 3475,
  [3978] = 3476,
  [3979] = 3856,
  [3980] = 3529,
  [3981] = 3571,
  [3982] = 3467,
  [3983] = 3423,
  [3984] = 3425,
  [3985] = 3426,
  [3986] = 3478,
  [3987] = 3428,
  [3988] = 3988,
  [3989] = 3437,
  [3990] = 3990,
  [3991] = 3833,
  [3992] = 3519,
  [3993] = 3515,
  [3994] = 3520,
  [3995] = 3423,
  [3996] = 3425,
  [3997] = 3426,
  [3998] = 3387,
  [3999] = 3428,
  [4000] = 3386,
  [4001] = 3437,
  [4002] = 3523,
  [4003] = 3554,
  [4004] = 3389,
  [4005] = 3386,
  [4006] = 3385,
  [4007] = 3423,
  [4008] = 3425,
  [4009] = 3426,
  [4010] = 3471,
  [4011] = 3428,
  [4012] = 3526,
  [4013] = 3437,
  [4014] = 3388,
  [4015] = 3857,
  [4016] = 3523,
  [4017] = 3554,
  [4018] = 4018,
  [4019] = 3423,
  [4020] = 3425,
  [4021] = 3426,
  [4022] = 3428,
  [4023] = 3389,
  [4024] = 3437,
  [4025] = 4025,
  [4026] = 3473,
  [4027] = 3486,
  [4028] = 4028,
  [4029] = 3474,
  [4030] = 3385,
  [4031] = 3475,
  [4032] = 3476,
  [4033] = 3856,
  [4034] = 3471,
  [4035] = 4035,
  [4036] = 3857,
  [4037] = 3571,
  [4038] = 3526,
  [4039] = 3467,
  [4040] = 4040,
  [4041] = 3478,
  [4042] = 3988,
  [4043] = 4043,
  [4044] = 3990,
  [4045] = 3833,
  [4046] = 3519,
  [4047] = 3520,
  [4048] = 3388,
  [4049] = 4049,
  [4050] = 3529,
  [4051] = 3387,
  [4052] = 3386,
  [4053] = 3523,
  [4054] = 3554,
  [4055] = 3389,
  [4056] = 3471,
  [4057] = 4025,
  [4058] = 3439,
  [4059] = 3526,
  [4060] = 3388,
  [4061] = 3473,
  [4062] = 3529,
  [4063] = 3486,
  [4064] = 4025,
  [4065] = 3473,
  [4066] = 4028,
  [4067] = 3486,
  [4068] = 4028,
  [4069] = 3474,
  [4070] = 3437,
  [4071] = 3475,
  [4072] = 4072,
  [4073] = 3436,
  [4074] = 3476,
  [4075] = 3474,
  [4076] = 3475,
  [4077] = 3856,
  [4078] = 3857,
  [4079] = 3476,
  [4080] = 3856,
  [4081] = 3526,
  [4082] = 3571,
  [4083] = 3571,
  [4084] = 3467,
  [4085] = 4085,
  [4086] = 3467,
  [4087] = 4040,
  [4088] = 3478,
  [4089] = 4089,
  [4090] = 3988,
  [4091] = 3990,
  [4092] = 3833,
  [4093] = 4093,
  [4094] = 3428,
  [4095] = 3515,
  [4096] = 4040,
  [4097] = 3519,
  [4098] = 3478,
  [4099] = 1232,
  [4100] = 4100,
  [4101] = 3520,
  [4102] = 4102,
  [4103] = 4085,
  [4104] = 4043,
  [4105] = 3426,
  [4106] = 4102,
  [4107] = 3425,
  [4108] = 3424,
  [4109] = 4089,
  [4110] = 3387,
  [4111] = 3988,
  [4112] = 3423,
  [4113] = 4100,
  [4114] = 3386,
  [4115] = 3990,
  [4116] = 3833,
  [4117] = 4093,
  [4118] = 4118,
  [4119] = 3420,
  [4120] = 3419,
  [4121] = 3523,
  [4122] = 4100,
  [4123] = 3418,
  [4124] = 4102,
  [4125] = 4085,
  [4126] = 4043,
  [4127] = 3554,
  [4128] = 4100,
  [4129] = 4102,
  [4130] = 4085,
  [4131] = 4043,
  [4132] = 3389,
  [4133] = 4100,
  [4134] = 4102,
  [4135] = 4085,
  [4136] = 4043,
  [4137] = 3385,
  [4138] = 4100,
  [4139] = 4102,
  [4140] = 4085,
  [4141] = 4043,
  [4142] = 3471,
  [4143] = 4100,
  [4144] = 4102,
  [4145] = 4085,
  [4146] = 4043,
  [4147] = 4093,
  [4148] = 4100,
  [4149] = 4102,
  [4150] = 4085,
  [4151] = 4043,
  [4152] = 3388,
  [4153] = 4100,
  [4154] = 4102,
  [4155] = 4085,
  [4156] = 4043,
  [4157] = 3529,
  [4158] = 4100,
  [4159] = 4102,
  [4160] = 4085,
  [4161] = 4043,
  [4162] = 4025,
  [4163] = 4100,
  [4164] = 4102,
  [4165] = 4085,
  [4166] = 4043,
  [4167] = 3473,
  [4168] = 4100,
  [4169] = 4102,
  [4170] = 4085,
  [4171] = 4043,
  [4172] = 3486,
  [4173] = 4100,
  [4174] = 4102,
  [4175] = 4085,
  [4176] = 4043,
  [4177] = 4028,
  [4178] = 4100,
  [4179] = 4102,
  [4180] = 4085,
  [4181] = 4043,
  [4182] = 3474,
  [4183] = 4100,
  [4184] = 4102,
  [4185] = 4085,
  [4186] = 4043,
  [4187] = 3475,
  [4188] = 4100,
  [4189] = 4102,
  [4190] = 4085,
  [4191] = 4043,
  [4192] = 1317,
  [4193] = 4100,
  [4194] = 4102,
  [4195] = 4085,
  [4196] = 4043,
  [4197] = 3476,
  [4198] = 4100,
  [4199] = 4102,
  [4200] = 4085,
  [4201] = 4043,
  [4202] = 3856,
  [4203] = 4100,
  [4204] = 4102,
  [4205] = 4085,
  [4206] = 4043,
  [4207] = 3857,
  [4208] = 4100,
  [4209] = 4102,
  [4210] = 4085,
  [4211] = 4043,
  [4212] = 1308,
  [4213] = 4100,
  [4214] = 4102,
  [4215] = 4085,
  [4216] = 1278,
  [4217] = 4100,
  [4218] = 4102,
  [4219] = 4085,
  [4220] = 3515,
  [4221] = 4100,
  [4222] = 4102,
  [4223] = 4085,
  [4224] = 3571,
  [4225] = 4100,
  [4226] = 4102,
  [4227] = 4085,
  [4228] = 3467,
  [4229] = 4100,
  [4230] = 4102,
  [4231] = 4085,
  [4232] = 4085,
  [4233] = 4085,
  [4234] = 4085,
  [4235] = 4085,
  [4236] = 4085,
  [4237] = 4085,
  [4238] = 4085,
  [4239] = 4085,
  [4240] = 4085,
  [4241] = 4085,
  [4242] = 4085,
  [4243] = 4085,
  [4244] = 4085,
  [4245] = 4085,
  [4246] = 4085,
  [4247] = 4085,
  [4248] = 4085,
  [4249] = 4085,
  [4250] = 4085,
  [4251] = 4085,
  [4252] = 4040,
  [4253] = 3478,
  [4254] = 4089,
  [4255] = 3988,
  [4256] = 3990,
  [4257] = 3833,
  [4258] = 3515,
  [4259] = 3515,
  [4260] = 3515,
  [4261] = 1230,
  [4262] = 3515,
  [4263] = 3515,
  [4264] = 3515,
  [4265] = 3515,
  [4266] = 3515,
  [4267] = 3515,
  [4268] = 3515,
  [4269] = 3515,
  [4270] = 3515,
};

static inline bool aux_sym_escape_token1_character_set_1(int32_t c) {
  return (c < 5760
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= ' ' || (c < 160
        ? c == 133
        : c <= 160)))
    : (c <= 5760 || (c < 8239
      ? (c < 8232
        ? (c >= 8192 && c <= 8202)
        : c <= 8233)
      : (c <= 8239 || (c < 12288
        ? c == 8287
        : c <= 12288)))));
}

static inline bool aux_sym_text_token1_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym__identifier_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym__identifier_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym__identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '-'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(42);
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(77);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(124);
      if (lookahead == '+') ADVANCE(120);
      if (lookahead == ',') ADVANCE(137);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(126);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == '_') ADVANCE(81);
      if (lookahead == '`') ADVANCE(62);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(134);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(54);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (aux_sym_text_token1_character_set_1(lookahead)) ADVANCE(58);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(93);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(93);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(93);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(93);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == '_') ADVANCE(80);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == '_') ADVANCE(80);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == '_') ADVANCE(80);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '&') ADVANCE(67);
      if (lookahead == '(' ||
          lookahead == '{') ADVANCE(70);
      if (lookahead == ')' ||
          lookahead == ']' ||
          lookahead == '}') ADVANCE(72);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(96);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(79);
      if (lookahead == '_') ADVANCE(80);
      if (lookahead == '|') ADVANCE(73);
      if (lookahead == '~') ADVANCE(95);
      if ((8730 <= lookahead && lookahead <= 8732)) ADVANCE(76);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(53);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(48);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(53);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 11:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '(') ADVANCE(131);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(83);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(134);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (sym__identifier_character_set_1(lookahead)) ADVANCE(98);
      END_STATE();
    case 12:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '(') ADVANCE(131);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (sym__identifier_character_set_1(lookahead)) ADVANCE(98);
      END_STATE();
    case 13:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '(') ADVANCE(131);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (sym__identifier_character_set_1(lookahead)) ADVANCE(98);
      END_STATE();
    case 14:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(107);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '(') ADVANCE(131);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '0') ADVANCE(99);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(100);
      if (sym__identifier_character_set_1(lookahead)) ADVANCE(98);
      END_STATE();
    case 15:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(137);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (sym__identifier_character_set_2(lookahead)) ADVANCE(98);
      END_STATE();
    case 16:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(137);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (sym__identifier_character_set_2(lookahead)) ADVANCE(98);
      END_STATE();
    case 17:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(137);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (sym__identifier_character_set_2(lookahead)) ADVANCE(98);
      END_STATE();
    case 18:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == ')') ADVANCE(132);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '+') ADVANCE(121);
      if (lookahead == ',') ADVANCE(137);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '{') ADVANCE(133);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      if (sym__identifier_character_set_2(lookahead)) ADVANCE(98);
      END_STATE();
    case 19:
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '>') ADVANCE(114);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(48);
      END_STATE();
    case 20:
      if (lookahead == '\r') ADVANCE(44);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(84);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(47);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(23);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(24);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 29:
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 30:
      if (lookahead == '`') ADVANCE(61);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(26);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(46);
      if (!aux_sym_escape_token1_character_set_1(lookahead)) ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 36:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 41:
      if (eof) ADVANCE(42);
      if (lookahead == '\n') ADVANCE(51);
      if (lookahead == '\r') ADVANCE(50);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(53);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '@') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '`') ADVANCE(63);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(51);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_parbreak);
      if (lookahead == '\r') ADVANCE(44);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(20);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_parbreak);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(43);
      if (lookahead == '\r') ADVANCE(44);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(20);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_escape_token1);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym_escape_token1);
      if (lookahead == '{') ADVANCE(34);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym_url_token1);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym__lb);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym__lb);
      if (lookahead == '\n') ADVANCE(48);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym__lb);
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == '\r') ADVANCE(44);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(20);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym__lb);
      if (lookahead == '\r') ADVANCE(44);
      if (('\n' <= lookahead && lookahead <= '\f') ||
          lookahead == 133 ||
          lookahead == 8232 ||
          lookahead == 8233) ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(20);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_linebreak);
      if (lookahead == 'u') ADVANCE(46);
      if (!aux_sym_escape_token1_character_set_1(lookahead)) ADVANCE(45);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_quote);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_text_token1);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '-') ADVANCE(65);
      if (lookahead == '?') ADVANCE(64);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == '.') ADVANCE(21);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_text_token1);
      if (sym__identifier_character_set_3(lookahead)) ADVANCE(98);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_BQUOTE_BQUOTE_BQUOTE);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead == '`') ADVANCE(30);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_shorthand);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_shorthand);
      if (lookahead == '-') ADVANCE(64);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__math_token_align);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__math_token_rpar);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym__math_token_lpar);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym__math_token_ldlm);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym__math_token_ldlm);
      if (lookahead == '|') ADVANCE(70);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym__math_token_orph);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym__math_token_orph);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == ']' ||
          lookahead == '|') ADVANCE(72);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym__math_number);
      if (lookahead == '.') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym__math_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__math_root_token1);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym__);
      if (sym__identifier_character_set_3(lookahead)) ADVANCE(98);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym__math_shorthand_token1);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym__math_shorthand_token1);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__math_shorthand_token1);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__math_shorthand_token1);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym__math_shorthand_token1);
      if (lookahead == '-' ||
          lookahead == '<') ADVANCE(84);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '>') ADVANCE(87);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '.') ADVANCE(22);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '=') ADVANCE(84);
      if (lookahead == '>') ADVANCE(87);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == '>') ADVANCE(84);
      if (lookahead == '~') ADVANCE(29);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym__math_symbol_token1);
      if (lookahead == ':' ||
          lookahead == '>') ADVANCE(84);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym__identifier);
      if (sym__identifier_character_set_3(lookahead)) ADVANCE(98);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == 'b') ADVANCE(36);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'x') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == 'e') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'e') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_assign_token1);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_assign_token1);
      if (lookahead == '=') ADVANCE(118);
      if (lookahead == '>') ADVANCE(111);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(101);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COMMA2);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(7);
      if (lookahead == 'o') ADVANCE(8);
      if (lookahead == 'r') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == 'w') ADVANCE(12);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(20);
      if (lookahead == 'm') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(27);
      if (lookahead == 'h') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 'd') ADVANCE(31);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 15:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 18:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 21:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'c') ADVANCE(38);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(40);
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 26:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 27:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 28:
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(46);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(48);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 35:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(55);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_auto);
      END_STATE();
    case 48:
      if (lookahead == 'k') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(60);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(63);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_show);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 59:
      if (lookahead == 'x') ADVANCE(66);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 63:
      if (lookahead == 'd') ADVANCE(69);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_context);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 11, .external_lex_state = 3},
  [3] = {.lex_state = 11, .external_lex_state = 3},
  [4] = {.lex_state = 11, .external_lex_state = 4},
  [5] = {.lex_state = 11, .external_lex_state = 4},
  [6] = {.lex_state = 12, .external_lex_state = 3},
  [7] = {.lex_state = 11, .external_lex_state = 5},
  [8] = {.lex_state = 11, .external_lex_state = 5},
  [9] = {.lex_state = 11, .external_lex_state = 6},
  [10] = {.lex_state = 12, .external_lex_state = 3},
  [11] = {.lex_state = 11, .external_lex_state = 6},
  [12] = {.lex_state = 12, .external_lex_state = 6},
  [13] = {.lex_state = 12, .external_lex_state = 4},
  [14] = {.lex_state = 11, .external_lex_state = 3},
  [15] = {.lex_state = 11, .external_lex_state = 3},
  [16] = {.lex_state = 12, .external_lex_state = 5},
  [17] = {.lex_state = 12, .external_lex_state = 5},
  [18] = {.lex_state = 12, .external_lex_state = 6},
  [19] = {.lex_state = 12, .external_lex_state = 4},
  [20] = {.lex_state = 13, .external_lex_state = 3},
  [21] = {.lex_state = 13, .external_lex_state = 3},
  [22] = {.lex_state = 13, .external_lex_state = 6},
  [23] = {.lex_state = 14, .external_lex_state = 3},
  [24] = {.lex_state = 13, .external_lex_state = 6},
  [25] = {.lex_state = 13, .external_lex_state = 4},
  [26] = {.lex_state = 13, .external_lex_state = 4},
  [27] = {.lex_state = 12, .external_lex_state = 3},
  [28] = {.lex_state = 12, .external_lex_state = 3},
  [29] = {.lex_state = 13, .external_lex_state = 5},
  [30] = {.lex_state = 11, .external_lex_state = 3},
  [31] = {.lex_state = 14, .external_lex_state = 3},
  [32] = {.lex_state = 11, .external_lex_state = 3},
  [33] = {.lex_state = 13, .external_lex_state = 5},
  [34] = {.lex_state = 14, .external_lex_state = 6},
  [35] = {.lex_state = 14, .external_lex_state = 4},
  [36] = {.lex_state = 14, .external_lex_state = 4},
  [37] = {.lex_state = 13, .external_lex_state = 3},
  [38] = {.lex_state = 13, .external_lex_state = 3},
  [39] = {.lex_state = 14, .external_lex_state = 5},
  [40] = {.lex_state = 14, .external_lex_state = 5},
  [41] = {.lex_state = 14, .external_lex_state = 6},
  [42] = {.lex_state = 12, .external_lex_state = 3},
  [43] = {.lex_state = 12, .external_lex_state = 3},
  [44] = {.lex_state = 14, .external_lex_state = 3},
  [45] = {.lex_state = 14, .external_lex_state = 3},
  [46] = {.lex_state = 13, .external_lex_state = 7},
  [47] = {.lex_state = 13, .external_lex_state = 7},
  [48] = {.lex_state = 13, .external_lex_state = 7},
  [49] = {.lex_state = 13, .external_lex_state = 7},
  [50] = {.lex_state = 13, .external_lex_state = 7},
  [51] = {.lex_state = 13, .external_lex_state = 7},
  [52] = {.lex_state = 13, .external_lex_state = 7},
  [53] = {.lex_state = 13, .external_lex_state = 7},
  [54] = {.lex_state = 13, .external_lex_state = 7},
  [55] = {.lex_state = 13, .external_lex_state = 7},
  [56] = {.lex_state = 13, .external_lex_state = 7},
  [57] = {.lex_state = 13, .external_lex_state = 7},
  [58] = {.lex_state = 13, .external_lex_state = 7},
  [59] = {.lex_state = 13, .external_lex_state = 7},
  [60] = {.lex_state = 13, .external_lex_state = 7},
  [61] = {.lex_state = 13, .external_lex_state = 7},
  [62] = {.lex_state = 13, .external_lex_state = 7},
  [63] = {.lex_state = 13, .external_lex_state = 7},
  [64] = {.lex_state = 13, .external_lex_state = 7},
  [65] = {.lex_state = 13, .external_lex_state = 7},
  [66] = {.lex_state = 13, .external_lex_state = 7},
  [67] = {.lex_state = 11, .external_lex_state = 7},
  [68] = {.lex_state = 11, .external_lex_state = 7},
  [69] = {.lex_state = 11, .external_lex_state = 7},
  [70] = {.lex_state = 11, .external_lex_state = 7},
  [71] = {.lex_state = 11, .external_lex_state = 7},
  [72] = {.lex_state = 11, .external_lex_state = 7},
  [73] = {.lex_state = 11, .external_lex_state = 7},
  [74] = {.lex_state = 11, .external_lex_state = 7},
  [75] = {.lex_state = 11, .external_lex_state = 7},
  [76] = {.lex_state = 11, .external_lex_state = 7},
  [77] = {.lex_state = 11, .external_lex_state = 7},
  [78] = {.lex_state = 11, .external_lex_state = 7},
  [79] = {.lex_state = 11, .external_lex_state = 7},
  [80] = {.lex_state = 11, .external_lex_state = 7},
  [81] = {.lex_state = 11, .external_lex_state = 7},
  [82] = {.lex_state = 11, .external_lex_state = 7},
  [83] = {.lex_state = 11, .external_lex_state = 7},
  [84] = {.lex_state = 11, .external_lex_state = 7},
  [85] = {.lex_state = 11, .external_lex_state = 7},
  [86] = {.lex_state = 11, .external_lex_state = 7},
  [87] = {.lex_state = 11, .external_lex_state = 7},
  [88] = {.lex_state = 11, .external_lex_state = 7},
  [89] = {.lex_state = 11, .external_lex_state = 7},
  [90] = {.lex_state = 11, .external_lex_state = 7},
  [91] = {.lex_state = 11, .external_lex_state = 7},
  [92] = {.lex_state = 11, .external_lex_state = 7},
  [93] = {.lex_state = 11, .external_lex_state = 7},
  [94] = {.lex_state = 11, .external_lex_state = 7},
  [95] = {.lex_state = 11, .external_lex_state = 7},
  [96] = {.lex_state = 11, .external_lex_state = 7},
  [97] = {.lex_state = 11, .external_lex_state = 7},
  [98] = {.lex_state = 11, .external_lex_state = 7},
  [99] = {.lex_state = 11, .external_lex_state = 7},
  [100] = {.lex_state = 11, .external_lex_state = 7},
  [101] = {.lex_state = 11, .external_lex_state = 7},
  [102] = {.lex_state = 11, .external_lex_state = 7},
  [103] = {.lex_state = 11, .external_lex_state = 7},
  [104] = {.lex_state = 11, .external_lex_state = 7},
  [105] = {.lex_state = 11, .external_lex_state = 7},
  [106] = {.lex_state = 11, .external_lex_state = 7},
  [107] = {.lex_state = 11, .external_lex_state = 7},
  [108] = {.lex_state = 11, .external_lex_state = 7},
  [109] = {.lex_state = 11, .external_lex_state = 7},
  [110] = {.lex_state = 11, .external_lex_state = 7},
  [111] = {.lex_state = 11, .external_lex_state = 7},
  [112] = {.lex_state = 11, .external_lex_state = 7},
  [113] = {.lex_state = 11, .external_lex_state = 7},
  [114] = {.lex_state = 11, .external_lex_state = 7},
  [115] = {.lex_state = 11, .external_lex_state = 7},
  [116] = {.lex_state = 11, .external_lex_state = 7},
  [117] = {.lex_state = 11, .external_lex_state = 7},
  [118] = {.lex_state = 11, .external_lex_state = 7},
  [119] = {.lex_state = 11, .external_lex_state = 7},
  [120] = {.lex_state = 11, .external_lex_state = 7},
  [121] = {.lex_state = 11, .external_lex_state = 7},
  [122] = {.lex_state = 11, .external_lex_state = 7},
  [123] = {.lex_state = 11, .external_lex_state = 7},
  [124] = {.lex_state = 11, .external_lex_state = 7},
  [125] = {.lex_state = 11, .external_lex_state = 7},
  [126] = {.lex_state = 11, .external_lex_state = 7},
  [127] = {.lex_state = 11, .external_lex_state = 7},
  [128] = {.lex_state = 11, .external_lex_state = 7},
  [129] = {.lex_state = 11, .external_lex_state = 7},
  [130] = {.lex_state = 11, .external_lex_state = 7},
  [131] = {.lex_state = 11, .external_lex_state = 7},
  [132] = {.lex_state = 11, .external_lex_state = 7},
  [133] = {.lex_state = 11, .external_lex_state = 7},
  [134] = {.lex_state = 11, .external_lex_state = 7},
  [135] = {.lex_state = 11, .external_lex_state = 7},
  [136] = {.lex_state = 11, .external_lex_state = 7},
  [137] = {.lex_state = 11, .external_lex_state = 7},
  [138] = {.lex_state = 11, .external_lex_state = 7},
  [139] = {.lex_state = 11, .external_lex_state = 7},
  [140] = {.lex_state = 11, .external_lex_state = 7},
  [141] = {.lex_state = 11, .external_lex_state = 7},
  [142] = {.lex_state = 11, .external_lex_state = 7},
  [143] = {.lex_state = 11, .external_lex_state = 7},
  [144] = {.lex_state = 11, .external_lex_state = 7},
  [145] = {.lex_state = 11, .external_lex_state = 7},
  [146] = {.lex_state = 11, .external_lex_state = 7},
  [147] = {.lex_state = 11, .external_lex_state = 7},
  [148] = {.lex_state = 11, .external_lex_state = 7},
  [149] = {.lex_state = 11, .external_lex_state = 7},
  [150] = {.lex_state = 11, .external_lex_state = 7},
  [151] = {.lex_state = 11, .external_lex_state = 7},
  [152] = {.lex_state = 11, .external_lex_state = 7},
  [153] = {.lex_state = 11, .external_lex_state = 7},
  [154] = {.lex_state = 11, .external_lex_state = 7},
  [155] = {.lex_state = 11, .external_lex_state = 7},
  [156] = {.lex_state = 11, .external_lex_state = 7},
  [157] = {.lex_state = 11, .external_lex_state = 7},
  [158] = {.lex_state = 11, .external_lex_state = 7},
  [159] = {.lex_state = 11, .external_lex_state = 7},
  [160] = {.lex_state = 11, .external_lex_state = 7},
  [161] = {.lex_state = 11, .external_lex_state = 7},
  [162] = {.lex_state = 11, .external_lex_state = 7},
  [163] = {.lex_state = 11, .external_lex_state = 7},
  [164] = {.lex_state = 11, .external_lex_state = 7},
  [165] = {.lex_state = 11, .external_lex_state = 7},
  [166] = {.lex_state = 11, .external_lex_state = 7},
  [167] = {.lex_state = 11, .external_lex_state = 7},
  [168] = {.lex_state = 11, .external_lex_state = 7},
  [169] = {.lex_state = 11, .external_lex_state = 7},
  [170] = {.lex_state = 11, .external_lex_state = 7},
  [171] = {.lex_state = 11, .external_lex_state = 7},
  [172] = {.lex_state = 11, .external_lex_state = 7},
  [173] = {.lex_state = 11, .external_lex_state = 7},
  [174] = {.lex_state = 11, .external_lex_state = 7},
  [175] = {.lex_state = 11, .external_lex_state = 7},
  [176] = {.lex_state = 11, .external_lex_state = 7},
  [177] = {.lex_state = 11, .external_lex_state = 7},
  [178] = {.lex_state = 11, .external_lex_state = 7},
  [179] = {.lex_state = 11, .external_lex_state = 7},
  [180] = {.lex_state = 11, .external_lex_state = 7},
  [181] = {.lex_state = 11, .external_lex_state = 7},
  [182] = {.lex_state = 11, .external_lex_state = 7},
  [183] = {.lex_state = 11, .external_lex_state = 7},
  [184] = {.lex_state = 11, .external_lex_state = 7},
  [185] = {.lex_state = 11, .external_lex_state = 7},
  [186] = {.lex_state = 11, .external_lex_state = 7},
  [187] = {.lex_state = 11, .external_lex_state = 7},
  [188] = {.lex_state = 11, .external_lex_state = 7},
  [189] = {.lex_state = 11, .external_lex_state = 7},
  [190] = {.lex_state = 11, .external_lex_state = 7},
  [191] = {.lex_state = 11, .external_lex_state = 7},
  [192] = {.lex_state = 11, .external_lex_state = 7},
  [193] = {.lex_state = 11, .external_lex_state = 7},
  [194] = {.lex_state = 11, .external_lex_state = 7},
  [195] = {.lex_state = 11, .external_lex_state = 7},
  [196] = {.lex_state = 11, .external_lex_state = 7},
  [197] = {.lex_state = 11, .external_lex_state = 7},
  [198] = {.lex_state = 11, .external_lex_state = 7},
  [199] = {.lex_state = 11, .external_lex_state = 7},
  [200] = {.lex_state = 11, .external_lex_state = 7},
  [201] = {.lex_state = 11, .external_lex_state = 7},
  [202] = {.lex_state = 11, .external_lex_state = 7},
  [203] = {.lex_state = 11, .external_lex_state = 7},
  [204] = {.lex_state = 11, .external_lex_state = 7},
  [205] = {.lex_state = 11, .external_lex_state = 7},
  [206] = {.lex_state = 11, .external_lex_state = 7},
  [207] = {.lex_state = 11, .external_lex_state = 7},
  [208] = {.lex_state = 11, .external_lex_state = 7},
  [209] = {.lex_state = 11, .external_lex_state = 7},
  [210] = {.lex_state = 11, .external_lex_state = 7},
  [211] = {.lex_state = 11, .external_lex_state = 7},
  [212] = {.lex_state = 11, .external_lex_state = 7},
  [213] = {.lex_state = 11, .external_lex_state = 7},
  [214] = {.lex_state = 11, .external_lex_state = 7},
  [215] = {.lex_state = 11, .external_lex_state = 7},
  [216] = {.lex_state = 11, .external_lex_state = 7},
  [217] = {.lex_state = 11, .external_lex_state = 7},
  [218] = {.lex_state = 11, .external_lex_state = 7},
  [219] = {.lex_state = 11, .external_lex_state = 7},
  [220] = {.lex_state = 11, .external_lex_state = 7},
  [221] = {.lex_state = 11, .external_lex_state = 7},
  [222] = {.lex_state = 11, .external_lex_state = 7},
  [223] = {.lex_state = 11, .external_lex_state = 7},
  [224] = {.lex_state = 11, .external_lex_state = 7},
  [225] = {.lex_state = 11, .external_lex_state = 7},
  [226] = {.lex_state = 11, .external_lex_state = 7},
  [227] = {.lex_state = 11, .external_lex_state = 7},
  [228] = {.lex_state = 11, .external_lex_state = 7},
  [229] = {.lex_state = 11, .external_lex_state = 7},
  [230] = {.lex_state = 11, .external_lex_state = 7},
  [231] = {.lex_state = 11, .external_lex_state = 7},
  [232] = {.lex_state = 11, .external_lex_state = 7},
  [233] = {.lex_state = 11, .external_lex_state = 7},
  [234] = {.lex_state = 11, .external_lex_state = 7},
  [235] = {.lex_state = 11, .external_lex_state = 7},
  [236] = {.lex_state = 11, .external_lex_state = 7},
  [237] = {.lex_state = 11, .external_lex_state = 7},
  [238] = {.lex_state = 11, .external_lex_state = 7},
  [239] = {.lex_state = 11, .external_lex_state = 7},
  [240] = {.lex_state = 11, .external_lex_state = 7},
  [241] = {.lex_state = 11, .external_lex_state = 7},
  [242] = {.lex_state = 11, .external_lex_state = 7},
  [243] = {.lex_state = 11, .external_lex_state = 7},
  [244] = {.lex_state = 11, .external_lex_state = 7},
  [245] = {.lex_state = 11, .external_lex_state = 7},
  [246] = {.lex_state = 11, .external_lex_state = 7},
  [247] = {.lex_state = 11, .external_lex_state = 7},
  [248] = {.lex_state = 11, .external_lex_state = 7},
  [249] = {.lex_state = 11, .external_lex_state = 7},
  [250] = {.lex_state = 11, .external_lex_state = 7},
  [251] = {.lex_state = 11, .external_lex_state = 7},
  [252] = {.lex_state = 11, .external_lex_state = 7},
  [253] = {.lex_state = 11, .external_lex_state = 7},
  [254] = {.lex_state = 11, .external_lex_state = 7},
  [255] = {.lex_state = 11, .external_lex_state = 7},
  [256] = {.lex_state = 11, .external_lex_state = 7},
  [257] = {.lex_state = 11, .external_lex_state = 7},
  [258] = {.lex_state = 11, .external_lex_state = 7},
  [259] = {.lex_state = 11, .external_lex_state = 7},
  [260] = {.lex_state = 11, .external_lex_state = 7},
  [261] = {.lex_state = 11, .external_lex_state = 7},
  [262] = {.lex_state = 11, .external_lex_state = 7},
  [263] = {.lex_state = 11, .external_lex_state = 7},
  [264] = {.lex_state = 11, .external_lex_state = 7},
  [265] = {.lex_state = 11, .external_lex_state = 7},
  [266] = {.lex_state = 11, .external_lex_state = 7},
  [267] = {.lex_state = 11, .external_lex_state = 7},
  [268] = {.lex_state = 11, .external_lex_state = 7},
  [269] = {.lex_state = 11, .external_lex_state = 7},
  [270] = {.lex_state = 11, .external_lex_state = 7},
  [271] = {.lex_state = 11, .external_lex_state = 7},
  [272] = {.lex_state = 11, .external_lex_state = 7},
  [273] = {.lex_state = 11, .external_lex_state = 7},
  [274] = {.lex_state = 11, .external_lex_state = 7},
  [275] = {.lex_state = 11, .external_lex_state = 7},
  [276] = {.lex_state = 11, .external_lex_state = 7},
  [277] = {.lex_state = 11, .external_lex_state = 7},
  [278] = {.lex_state = 11, .external_lex_state = 7},
  [279] = {.lex_state = 11, .external_lex_state = 7},
  [280] = {.lex_state = 11, .external_lex_state = 7},
  [281] = {.lex_state = 11, .external_lex_state = 7},
  [282] = {.lex_state = 11, .external_lex_state = 7},
  [283] = {.lex_state = 11, .external_lex_state = 7},
  [284] = {.lex_state = 11, .external_lex_state = 7},
  [285] = {.lex_state = 11, .external_lex_state = 7},
  [286] = {.lex_state = 11, .external_lex_state = 7},
  [287] = {.lex_state = 11, .external_lex_state = 7},
  [288] = {.lex_state = 11, .external_lex_state = 7},
  [289] = {.lex_state = 11, .external_lex_state = 7},
  [290] = {.lex_state = 11, .external_lex_state = 7},
  [291] = {.lex_state = 11, .external_lex_state = 7},
  [292] = {.lex_state = 11, .external_lex_state = 7},
  [293] = {.lex_state = 11, .external_lex_state = 7},
  [294] = {.lex_state = 11, .external_lex_state = 7},
  [295] = {.lex_state = 11, .external_lex_state = 7},
  [296] = {.lex_state = 11, .external_lex_state = 7},
  [297] = {.lex_state = 11, .external_lex_state = 7},
  [298] = {.lex_state = 11, .external_lex_state = 7},
  [299] = {.lex_state = 11, .external_lex_state = 7},
  [300] = {.lex_state = 11, .external_lex_state = 7},
  [301] = {.lex_state = 11, .external_lex_state = 7},
  [302] = {.lex_state = 11, .external_lex_state = 7},
  [303] = {.lex_state = 11, .external_lex_state = 7},
  [304] = {.lex_state = 11, .external_lex_state = 7},
  [305] = {.lex_state = 11, .external_lex_state = 7},
  [306] = {.lex_state = 11, .external_lex_state = 7},
  [307] = {.lex_state = 11, .external_lex_state = 7},
  [308] = {.lex_state = 11, .external_lex_state = 7},
  [309] = {.lex_state = 11, .external_lex_state = 7},
  [310] = {.lex_state = 11, .external_lex_state = 7},
  [311] = {.lex_state = 11, .external_lex_state = 7},
  [312] = {.lex_state = 11, .external_lex_state = 7},
  [313] = {.lex_state = 11, .external_lex_state = 7},
  [314] = {.lex_state = 11, .external_lex_state = 7},
  [315] = {.lex_state = 11, .external_lex_state = 7},
  [316] = {.lex_state = 11, .external_lex_state = 7},
  [317] = {.lex_state = 11, .external_lex_state = 7},
  [318] = {.lex_state = 11, .external_lex_state = 7},
  [319] = {.lex_state = 11, .external_lex_state = 7},
  [320] = {.lex_state = 11, .external_lex_state = 7},
  [321] = {.lex_state = 11, .external_lex_state = 7},
  [322] = {.lex_state = 11, .external_lex_state = 7},
  [323] = {.lex_state = 11, .external_lex_state = 7},
  [324] = {.lex_state = 11, .external_lex_state = 7},
  [325] = {.lex_state = 11, .external_lex_state = 7},
  [326] = {.lex_state = 11, .external_lex_state = 7},
  [327] = {.lex_state = 11, .external_lex_state = 7},
  [328] = {.lex_state = 11, .external_lex_state = 7},
  [329] = {.lex_state = 11, .external_lex_state = 7},
  [330] = {.lex_state = 11, .external_lex_state = 7},
  [331] = {.lex_state = 11, .external_lex_state = 7},
  [332] = {.lex_state = 11, .external_lex_state = 7},
  [333] = {.lex_state = 11, .external_lex_state = 7},
  [334] = {.lex_state = 11, .external_lex_state = 7},
  [335] = {.lex_state = 11, .external_lex_state = 7},
  [336] = {.lex_state = 11, .external_lex_state = 7},
  [337] = {.lex_state = 11, .external_lex_state = 7},
  [338] = {.lex_state = 11, .external_lex_state = 7},
  [339] = {.lex_state = 11, .external_lex_state = 7},
  [340] = {.lex_state = 11, .external_lex_state = 7},
  [341] = {.lex_state = 11, .external_lex_state = 7},
  [342] = {.lex_state = 11, .external_lex_state = 7},
  [343] = {.lex_state = 11, .external_lex_state = 7},
  [344] = {.lex_state = 11, .external_lex_state = 7},
  [345] = {.lex_state = 11, .external_lex_state = 7},
  [346] = {.lex_state = 11, .external_lex_state = 7},
  [347] = {.lex_state = 11, .external_lex_state = 7},
  [348] = {.lex_state = 11, .external_lex_state = 7},
  [349] = {.lex_state = 11, .external_lex_state = 7},
  [350] = {.lex_state = 11, .external_lex_state = 7},
  [351] = {.lex_state = 11, .external_lex_state = 7},
  [352] = {.lex_state = 11, .external_lex_state = 7},
  [353] = {.lex_state = 11, .external_lex_state = 7},
  [354] = {.lex_state = 11, .external_lex_state = 7},
  [355] = {.lex_state = 11, .external_lex_state = 7},
  [356] = {.lex_state = 11, .external_lex_state = 7},
  [357] = {.lex_state = 11, .external_lex_state = 7},
  [358] = {.lex_state = 11, .external_lex_state = 7},
  [359] = {.lex_state = 11, .external_lex_state = 7},
  [360] = {.lex_state = 11, .external_lex_state = 7},
  [361] = {.lex_state = 11, .external_lex_state = 7},
  [362] = {.lex_state = 11, .external_lex_state = 7},
  [363] = {.lex_state = 11, .external_lex_state = 7},
  [364] = {.lex_state = 11, .external_lex_state = 7},
  [365] = {.lex_state = 11, .external_lex_state = 7},
  [366] = {.lex_state = 11, .external_lex_state = 7},
  [367] = {.lex_state = 11, .external_lex_state = 7},
  [368] = {.lex_state = 11, .external_lex_state = 7},
  [369] = {.lex_state = 11, .external_lex_state = 7},
  [370] = {.lex_state = 11, .external_lex_state = 7},
  [371] = {.lex_state = 11, .external_lex_state = 7},
  [372] = {.lex_state = 11, .external_lex_state = 7},
  [373] = {.lex_state = 11, .external_lex_state = 7},
  [374] = {.lex_state = 11, .external_lex_state = 7},
  [375] = {.lex_state = 11, .external_lex_state = 7},
  [376] = {.lex_state = 11, .external_lex_state = 7},
  [377] = {.lex_state = 11, .external_lex_state = 7},
  [378] = {.lex_state = 11, .external_lex_state = 7},
  [379] = {.lex_state = 11, .external_lex_state = 7},
  [380] = {.lex_state = 11, .external_lex_state = 7},
  [381] = {.lex_state = 11, .external_lex_state = 7},
  [382] = {.lex_state = 11, .external_lex_state = 7},
  [383] = {.lex_state = 11, .external_lex_state = 7},
  [384] = {.lex_state = 11, .external_lex_state = 7},
  [385] = {.lex_state = 11, .external_lex_state = 7},
  [386] = {.lex_state = 11, .external_lex_state = 7},
  [387] = {.lex_state = 11, .external_lex_state = 7},
  [388] = {.lex_state = 11, .external_lex_state = 7},
  [389] = {.lex_state = 11, .external_lex_state = 7},
  [390] = {.lex_state = 11, .external_lex_state = 7},
  [391] = {.lex_state = 11, .external_lex_state = 7},
  [392] = {.lex_state = 11, .external_lex_state = 7},
  [393] = {.lex_state = 11, .external_lex_state = 7},
  [394] = {.lex_state = 11, .external_lex_state = 7},
  [395] = {.lex_state = 11, .external_lex_state = 7},
  [396] = {.lex_state = 11, .external_lex_state = 7},
  [397] = {.lex_state = 11, .external_lex_state = 7},
  [398] = {.lex_state = 11, .external_lex_state = 7},
  [399] = {.lex_state = 11, .external_lex_state = 7},
  [400] = {.lex_state = 11, .external_lex_state = 7},
  [401] = {.lex_state = 11, .external_lex_state = 7},
  [402] = {.lex_state = 11, .external_lex_state = 7},
  [403] = {.lex_state = 11, .external_lex_state = 7},
  [404] = {.lex_state = 11, .external_lex_state = 7},
  [405] = {.lex_state = 11, .external_lex_state = 7},
  [406] = {.lex_state = 11, .external_lex_state = 7},
  [407] = {.lex_state = 11, .external_lex_state = 7},
  [408] = {.lex_state = 11, .external_lex_state = 7},
  [409] = {.lex_state = 11, .external_lex_state = 7},
  [410] = {.lex_state = 11, .external_lex_state = 7},
  [411] = {.lex_state = 11, .external_lex_state = 7},
  [412] = {.lex_state = 11, .external_lex_state = 7},
  [413] = {.lex_state = 11, .external_lex_state = 7},
  [414] = {.lex_state = 11, .external_lex_state = 7},
  [415] = {.lex_state = 11, .external_lex_state = 7},
  [416] = {.lex_state = 11, .external_lex_state = 7},
  [417] = {.lex_state = 11, .external_lex_state = 7},
  [418] = {.lex_state = 11, .external_lex_state = 7},
  [419] = {.lex_state = 11, .external_lex_state = 7},
  [420] = {.lex_state = 11, .external_lex_state = 7},
  [421] = {.lex_state = 11, .external_lex_state = 7},
  [422] = {.lex_state = 11, .external_lex_state = 7},
  [423] = {.lex_state = 11, .external_lex_state = 7},
  [424] = {.lex_state = 11, .external_lex_state = 7},
  [425] = {.lex_state = 11, .external_lex_state = 7},
  [426] = {.lex_state = 11, .external_lex_state = 7},
  [427] = {.lex_state = 11, .external_lex_state = 7},
  [428] = {.lex_state = 11, .external_lex_state = 7},
  [429] = {.lex_state = 11, .external_lex_state = 7},
  [430] = {.lex_state = 11, .external_lex_state = 7},
  [431] = {.lex_state = 11, .external_lex_state = 7},
  [432] = {.lex_state = 11, .external_lex_state = 7},
  [433] = {.lex_state = 11, .external_lex_state = 7},
  [434] = {.lex_state = 11, .external_lex_state = 7},
  [435] = {.lex_state = 11, .external_lex_state = 7},
  [436] = {.lex_state = 11, .external_lex_state = 7},
  [437] = {.lex_state = 11, .external_lex_state = 7},
  [438] = {.lex_state = 11, .external_lex_state = 7},
  [439] = {.lex_state = 11, .external_lex_state = 7},
  [440] = {.lex_state = 11, .external_lex_state = 7},
  [441] = {.lex_state = 11, .external_lex_state = 7},
  [442] = {.lex_state = 11, .external_lex_state = 7},
  [443] = {.lex_state = 11, .external_lex_state = 7},
  [444] = {.lex_state = 11, .external_lex_state = 7},
  [445] = {.lex_state = 11, .external_lex_state = 7},
  [446] = {.lex_state = 11, .external_lex_state = 7},
  [447] = {.lex_state = 11, .external_lex_state = 7},
  [448] = {.lex_state = 11, .external_lex_state = 7},
  [449] = {.lex_state = 11, .external_lex_state = 7},
  [450] = {.lex_state = 11, .external_lex_state = 7},
  [451] = {.lex_state = 11, .external_lex_state = 7},
  [452] = {.lex_state = 11, .external_lex_state = 7},
  [453] = {.lex_state = 11, .external_lex_state = 7},
  [454] = {.lex_state = 11, .external_lex_state = 7},
  [455] = {.lex_state = 11, .external_lex_state = 7},
  [456] = {.lex_state = 11, .external_lex_state = 7},
  [457] = {.lex_state = 11, .external_lex_state = 7},
  [458] = {.lex_state = 11, .external_lex_state = 7},
  [459] = {.lex_state = 11, .external_lex_state = 7},
  [460] = {.lex_state = 11, .external_lex_state = 7},
  [461] = {.lex_state = 11, .external_lex_state = 7},
  [462] = {.lex_state = 11, .external_lex_state = 7},
  [463] = {.lex_state = 11, .external_lex_state = 7},
  [464] = {.lex_state = 11, .external_lex_state = 7},
  [465] = {.lex_state = 11, .external_lex_state = 7},
  [466] = {.lex_state = 11, .external_lex_state = 7},
  [467] = {.lex_state = 11, .external_lex_state = 7},
  [468] = {.lex_state = 11, .external_lex_state = 7},
  [469] = {.lex_state = 11, .external_lex_state = 7},
  [470] = {.lex_state = 11, .external_lex_state = 7},
  [471] = {.lex_state = 11, .external_lex_state = 7},
  [472] = {.lex_state = 11, .external_lex_state = 7},
  [473] = {.lex_state = 11, .external_lex_state = 7},
  [474] = {.lex_state = 11, .external_lex_state = 7},
  [475] = {.lex_state = 11, .external_lex_state = 7},
  [476] = {.lex_state = 11, .external_lex_state = 7},
  [477] = {.lex_state = 11, .external_lex_state = 7},
  [478] = {.lex_state = 11, .external_lex_state = 7},
  [479] = {.lex_state = 11, .external_lex_state = 7},
  [480] = {.lex_state = 11, .external_lex_state = 7},
  [481] = {.lex_state = 11, .external_lex_state = 7},
  [482] = {.lex_state = 11, .external_lex_state = 7},
  [483] = {.lex_state = 11, .external_lex_state = 7},
  [484] = {.lex_state = 11, .external_lex_state = 7},
  [485] = {.lex_state = 11, .external_lex_state = 7},
  [486] = {.lex_state = 11, .external_lex_state = 7},
  [487] = {.lex_state = 11, .external_lex_state = 7},
  [488] = {.lex_state = 11, .external_lex_state = 7},
  [489] = {.lex_state = 11, .external_lex_state = 7},
  [490] = {.lex_state = 11, .external_lex_state = 7},
  [491] = {.lex_state = 11, .external_lex_state = 7},
  [492] = {.lex_state = 11, .external_lex_state = 7},
  [493] = {.lex_state = 11, .external_lex_state = 7},
  [494] = {.lex_state = 11, .external_lex_state = 7},
  [495] = {.lex_state = 11, .external_lex_state = 7},
  [496] = {.lex_state = 11, .external_lex_state = 7},
  [497] = {.lex_state = 11, .external_lex_state = 7},
  [498] = {.lex_state = 11, .external_lex_state = 7},
  [499] = {.lex_state = 11, .external_lex_state = 7},
  [500] = {.lex_state = 11, .external_lex_state = 7},
  [501] = {.lex_state = 11, .external_lex_state = 7},
  [502] = {.lex_state = 11, .external_lex_state = 7},
  [503] = {.lex_state = 11, .external_lex_state = 7},
  [504] = {.lex_state = 11, .external_lex_state = 7},
  [505] = {.lex_state = 11, .external_lex_state = 7},
  [506] = {.lex_state = 11, .external_lex_state = 7},
  [507] = {.lex_state = 11, .external_lex_state = 7},
  [508] = {.lex_state = 11, .external_lex_state = 7},
  [509] = {.lex_state = 11, .external_lex_state = 7},
  [510] = {.lex_state = 11, .external_lex_state = 7},
  [511] = {.lex_state = 11, .external_lex_state = 7},
  [512] = {.lex_state = 11, .external_lex_state = 7},
  [513] = {.lex_state = 11, .external_lex_state = 7},
  [514] = {.lex_state = 11, .external_lex_state = 7},
  [515] = {.lex_state = 11, .external_lex_state = 7},
  [516] = {.lex_state = 11, .external_lex_state = 7},
  [517] = {.lex_state = 11, .external_lex_state = 7},
  [518] = {.lex_state = 11, .external_lex_state = 7},
  [519] = {.lex_state = 11, .external_lex_state = 7},
  [520] = {.lex_state = 11, .external_lex_state = 7},
  [521] = {.lex_state = 11, .external_lex_state = 7},
  [522] = {.lex_state = 11, .external_lex_state = 7},
  [523] = {.lex_state = 11, .external_lex_state = 7},
  [524] = {.lex_state = 11, .external_lex_state = 7},
  [525] = {.lex_state = 11, .external_lex_state = 7},
  [526] = {.lex_state = 11, .external_lex_state = 7},
  [527] = {.lex_state = 11, .external_lex_state = 7},
  [528] = {.lex_state = 11, .external_lex_state = 7},
  [529] = {.lex_state = 11, .external_lex_state = 7},
  [530] = {.lex_state = 11, .external_lex_state = 7},
  [531] = {.lex_state = 11, .external_lex_state = 7},
  [532] = {.lex_state = 11, .external_lex_state = 7},
  [533] = {.lex_state = 11, .external_lex_state = 7},
  [534] = {.lex_state = 11, .external_lex_state = 7},
  [535] = {.lex_state = 11, .external_lex_state = 7},
  [536] = {.lex_state = 11, .external_lex_state = 7},
  [537] = {.lex_state = 11, .external_lex_state = 7},
  [538] = {.lex_state = 11, .external_lex_state = 7},
  [539] = {.lex_state = 11, .external_lex_state = 7},
  [540] = {.lex_state = 11, .external_lex_state = 7},
  [541] = {.lex_state = 11, .external_lex_state = 7},
  [542] = {.lex_state = 11, .external_lex_state = 7},
  [543] = {.lex_state = 11, .external_lex_state = 7},
  [544] = {.lex_state = 11, .external_lex_state = 7},
  [545] = {.lex_state = 11, .external_lex_state = 7},
  [546] = {.lex_state = 11, .external_lex_state = 7},
  [547] = {.lex_state = 11, .external_lex_state = 7},
  [548] = {.lex_state = 11, .external_lex_state = 7},
  [549] = {.lex_state = 11, .external_lex_state = 7},
  [550] = {.lex_state = 11, .external_lex_state = 7},
  [551] = {.lex_state = 11, .external_lex_state = 7},
  [552] = {.lex_state = 11, .external_lex_state = 7},
  [553] = {.lex_state = 11, .external_lex_state = 7},
  [554] = {.lex_state = 11, .external_lex_state = 7},
  [555] = {.lex_state = 11, .external_lex_state = 7},
  [556] = {.lex_state = 11, .external_lex_state = 7},
  [557] = {.lex_state = 11, .external_lex_state = 7},
  [558] = {.lex_state = 11, .external_lex_state = 7},
  [559] = {.lex_state = 11, .external_lex_state = 7},
  [560] = {.lex_state = 11, .external_lex_state = 7},
  [561] = {.lex_state = 11, .external_lex_state = 7},
  [562] = {.lex_state = 11, .external_lex_state = 7},
  [563] = {.lex_state = 11, .external_lex_state = 7},
  [564] = {.lex_state = 11, .external_lex_state = 7},
  [565] = {.lex_state = 11, .external_lex_state = 7},
  [566] = {.lex_state = 11, .external_lex_state = 7},
  [567] = {.lex_state = 11, .external_lex_state = 7},
  [568] = {.lex_state = 11, .external_lex_state = 7},
  [569] = {.lex_state = 11, .external_lex_state = 7},
  [570] = {.lex_state = 11, .external_lex_state = 7},
  [571] = {.lex_state = 11, .external_lex_state = 7},
  [572] = {.lex_state = 11, .external_lex_state = 7},
  [573] = {.lex_state = 11, .external_lex_state = 7},
  [574] = {.lex_state = 11, .external_lex_state = 7},
  [575] = {.lex_state = 11, .external_lex_state = 7},
  [576] = {.lex_state = 11, .external_lex_state = 7},
  [577] = {.lex_state = 11, .external_lex_state = 7},
  [578] = {.lex_state = 11, .external_lex_state = 7},
  [579] = {.lex_state = 11, .external_lex_state = 7},
  [580] = {.lex_state = 11, .external_lex_state = 7},
  [581] = {.lex_state = 11, .external_lex_state = 7},
  [582] = {.lex_state = 11, .external_lex_state = 7},
  [583] = {.lex_state = 11, .external_lex_state = 7},
  [584] = {.lex_state = 11, .external_lex_state = 7},
  [585] = {.lex_state = 11, .external_lex_state = 7},
  [586] = {.lex_state = 11, .external_lex_state = 7},
  [587] = {.lex_state = 11, .external_lex_state = 7},
  [588] = {.lex_state = 11, .external_lex_state = 7},
  [589] = {.lex_state = 11, .external_lex_state = 7},
  [590] = {.lex_state = 11, .external_lex_state = 7},
  [591] = {.lex_state = 11, .external_lex_state = 7},
  [592] = {.lex_state = 11, .external_lex_state = 7},
  [593] = {.lex_state = 11, .external_lex_state = 7},
  [594] = {.lex_state = 11, .external_lex_state = 7},
  [595] = {.lex_state = 11, .external_lex_state = 7},
  [596] = {.lex_state = 11, .external_lex_state = 7},
  [597] = {.lex_state = 11, .external_lex_state = 7},
  [598] = {.lex_state = 11, .external_lex_state = 7},
  [599] = {.lex_state = 11, .external_lex_state = 7},
  [600] = {.lex_state = 11, .external_lex_state = 7},
  [601] = {.lex_state = 11, .external_lex_state = 7},
  [602] = {.lex_state = 11, .external_lex_state = 7},
  [603] = {.lex_state = 11, .external_lex_state = 7},
  [604] = {.lex_state = 11, .external_lex_state = 7},
  [605] = {.lex_state = 11, .external_lex_state = 7},
  [606] = {.lex_state = 11, .external_lex_state = 7},
  [607] = {.lex_state = 11, .external_lex_state = 7},
  [608] = {.lex_state = 11, .external_lex_state = 7},
  [609] = {.lex_state = 11, .external_lex_state = 7},
  [610] = {.lex_state = 11, .external_lex_state = 7},
  [611] = {.lex_state = 11, .external_lex_state = 7},
  [612] = {.lex_state = 11, .external_lex_state = 7},
  [613] = {.lex_state = 11, .external_lex_state = 7},
  [614] = {.lex_state = 11, .external_lex_state = 7},
  [615] = {.lex_state = 11, .external_lex_state = 7},
  [616] = {.lex_state = 11, .external_lex_state = 7},
  [617] = {.lex_state = 11, .external_lex_state = 7},
  [618] = {.lex_state = 11, .external_lex_state = 7},
  [619] = {.lex_state = 11, .external_lex_state = 7},
  [620] = {.lex_state = 11, .external_lex_state = 7},
  [621] = {.lex_state = 11, .external_lex_state = 7},
  [622] = {.lex_state = 11, .external_lex_state = 7},
  [623] = {.lex_state = 11, .external_lex_state = 7},
  [624] = {.lex_state = 11, .external_lex_state = 7},
  [625] = {.lex_state = 11, .external_lex_state = 7},
  [626] = {.lex_state = 11, .external_lex_state = 7},
  [627] = {.lex_state = 11, .external_lex_state = 7},
  [628] = {.lex_state = 11, .external_lex_state = 7},
  [629] = {.lex_state = 11, .external_lex_state = 7},
  [630] = {.lex_state = 11, .external_lex_state = 7},
  [631] = {.lex_state = 11, .external_lex_state = 7},
  [632] = {.lex_state = 11, .external_lex_state = 7},
  [633] = {.lex_state = 11, .external_lex_state = 7},
  [634] = {.lex_state = 11, .external_lex_state = 7},
  [635] = {.lex_state = 11, .external_lex_state = 7},
  [636] = {.lex_state = 11, .external_lex_state = 7},
  [637] = {.lex_state = 11, .external_lex_state = 7},
  [638] = {.lex_state = 11, .external_lex_state = 7},
  [639] = {.lex_state = 11, .external_lex_state = 7},
  [640] = {.lex_state = 11, .external_lex_state = 7},
  [641] = {.lex_state = 11, .external_lex_state = 7},
  [642] = {.lex_state = 11, .external_lex_state = 7},
  [643] = {.lex_state = 11, .external_lex_state = 7},
  [644] = {.lex_state = 11, .external_lex_state = 7},
  [645] = {.lex_state = 11, .external_lex_state = 7},
  [646] = {.lex_state = 11, .external_lex_state = 7},
  [647] = {.lex_state = 11, .external_lex_state = 7},
  [648] = {.lex_state = 11, .external_lex_state = 7},
  [649] = {.lex_state = 11, .external_lex_state = 7},
  [650] = {.lex_state = 11, .external_lex_state = 7},
  [651] = {.lex_state = 11, .external_lex_state = 7},
  [652] = {.lex_state = 11, .external_lex_state = 7},
  [653] = {.lex_state = 11, .external_lex_state = 7},
  [654] = {.lex_state = 11, .external_lex_state = 7},
  [655] = {.lex_state = 11, .external_lex_state = 7},
  [656] = {.lex_state = 11, .external_lex_state = 7},
  [657] = {.lex_state = 11, .external_lex_state = 7},
  [658] = {.lex_state = 11, .external_lex_state = 7},
  [659] = {.lex_state = 11, .external_lex_state = 7},
  [660] = {.lex_state = 11, .external_lex_state = 7},
  [661] = {.lex_state = 11, .external_lex_state = 7},
  [662] = {.lex_state = 11, .external_lex_state = 7},
  [663] = {.lex_state = 11, .external_lex_state = 7},
  [664] = {.lex_state = 11, .external_lex_state = 7},
  [665] = {.lex_state = 11, .external_lex_state = 7},
  [666] = {.lex_state = 11, .external_lex_state = 7},
  [667] = {.lex_state = 11, .external_lex_state = 7},
  [668] = {.lex_state = 11, .external_lex_state = 7},
  [669] = {.lex_state = 11, .external_lex_state = 7},
  [670] = {.lex_state = 11, .external_lex_state = 7},
  [671] = {.lex_state = 11, .external_lex_state = 7},
  [672] = {.lex_state = 11, .external_lex_state = 7},
  [673] = {.lex_state = 11, .external_lex_state = 7},
  [674] = {.lex_state = 11, .external_lex_state = 7},
  [675] = {.lex_state = 11, .external_lex_state = 7},
  [676] = {.lex_state = 11, .external_lex_state = 7},
  [677] = {.lex_state = 11, .external_lex_state = 7},
  [678] = {.lex_state = 11, .external_lex_state = 7},
  [679] = {.lex_state = 11, .external_lex_state = 7},
  [680] = {.lex_state = 11, .external_lex_state = 7},
  [681] = {.lex_state = 11, .external_lex_state = 7},
  [682] = {.lex_state = 11, .external_lex_state = 7},
  [683] = {.lex_state = 11, .external_lex_state = 7},
  [684] = {.lex_state = 11, .external_lex_state = 7},
  [685] = {.lex_state = 11, .external_lex_state = 7},
  [686] = {.lex_state = 11, .external_lex_state = 7},
  [687] = {.lex_state = 11, .external_lex_state = 7},
  [688] = {.lex_state = 11, .external_lex_state = 7},
  [689] = {.lex_state = 11, .external_lex_state = 7},
  [690] = {.lex_state = 11, .external_lex_state = 7},
  [691] = {.lex_state = 11, .external_lex_state = 7},
  [692] = {.lex_state = 11, .external_lex_state = 7},
  [693] = {.lex_state = 11, .external_lex_state = 7},
  [694] = {.lex_state = 11, .external_lex_state = 7},
  [695] = {.lex_state = 11, .external_lex_state = 7},
  [696] = {.lex_state = 11, .external_lex_state = 7},
  [697] = {.lex_state = 11, .external_lex_state = 7},
  [698] = {.lex_state = 11, .external_lex_state = 7},
  [699] = {.lex_state = 11, .external_lex_state = 7},
  [700] = {.lex_state = 11, .external_lex_state = 7},
  [701] = {.lex_state = 11, .external_lex_state = 7},
  [702] = {.lex_state = 11, .external_lex_state = 7},
  [703] = {.lex_state = 11, .external_lex_state = 7},
  [704] = {.lex_state = 11, .external_lex_state = 7},
  [705] = {.lex_state = 11, .external_lex_state = 7},
  [706] = {.lex_state = 11, .external_lex_state = 7},
  [707] = {.lex_state = 11, .external_lex_state = 7},
  [708] = {.lex_state = 11, .external_lex_state = 7},
  [709] = {.lex_state = 11, .external_lex_state = 7},
  [710] = {.lex_state = 11, .external_lex_state = 7},
  [711] = {.lex_state = 11, .external_lex_state = 7},
  [712] = {.lex_state = 11, .external_lex_state = 7},
  [713] = {.lex_state = 11, .external_lex_state = 7},
  [714] = {.lex_state = 11, .external_lex_state = 7},
  [715] = {.lex_state = 11, .external_lex_state = 7},
  [716] = {.lex_state = 11, .external_lex_state = 7},
  [717] = {.lex_state = 11, .external_lex_state = 7},
  [718] = {.lex_state = 11, .external_lex_state = 7},
  [719] = {.lex_state = 11, .external_lex_state = 7},
  [720] = {.lex_state = 11, .external_lex_state = 7},
  [721] = {.lex_state = 11, .external_lex_state = 7},
  [722] = {.lex_state = 11, .external_lex_state = 7},
  [723] = {.lex_state = 11, .external_lex_state = 7},
  [724] = {.lex_state = 11, .external_lex_state = 7},
  [725] = {.lex_state = 11, .external_lex_state = 7},
  [726] = {.lex_state = 11, .external_lex_state = 7},
  [727] = {.lex_state = 11, .external_lex_state = 7},
  [728] = {.lex_state = 11, .external_lex_state = 7},
  [729] = {.lex_state = 11, .external_lex_state = 7},
  [730] = {.lex_state = 11, .external_lex_state = 7},
  [731] = {.lex_state = 11, .external_lex_state = 7},
  [732] = {.lex_state = 11, .external_lex_state = 7},
  [733] = {.lex_state = 11, .external_lex_state = 7},
  [734] = {.lex_state = 11, .external_lex_state = 7},
  [735] = {.lex_state = 11, .external_lex_state = 7},
  [736] = {.lex_state = 11, .external_lex_state = 7},
  [737] = {.lex_state = 11, .external_lex_state = 7},
  [738] = {.lex_state = 11, .external_lex_state = 7},
  [739] = {.lex_state = 11, .external_lex_state = 7},
  [740] = {.lex_state = 11, .external_lex_state = 7},
  [741] = {.lex_state = 11, .external_lex_state = 7},
  [742] = {.lex_state = 11, .external_lex_state = 7},
  [743] = {.lex_state = 11, .external_lex_state = 7},
  [744] = {.lex_state = 11, .external_lex_state = 7},
  [745] = {.lex_state = 11, .external_lex_state = 7},
  [746] = {.lex_state = 11, .external_lex_state = 7},
  [747] = {.lex_state = 11, .external_lex_state = 7},
  [748] = {.lex_state = 11, .external_lex_state = 7},
  [749] = {.lex_state = 11, .external_lex_state = 7},
  [750] = {.lex_state = 11, .external_lex_state = 7},
  [751] = {.lex_state = 11, .external_lex_state = 7},
  [752] = {.lex_state = 11, .external_lex_state = 7},
  [753] = {.lex_state = 11, .external_lex_state = 7},
  [754] = {.lex_state = 11, .external_lex_state = 7},
  [755] = {.lex_state = 11, .external_lex_state = 7},
  [756] = {.lex_state = 11, .external_lex_state = 7},
  [757] = {.lex_state = 11, .external_lex_state = 7},
  [758] = {.lex_state = 11, .external_lex_state = 7},
  [759] = {.lex_state = 11, .external_lex_state = 7},
  [760] = {.lex_state = 11, .external_lex_state = 7},
  [761] = {.lex_state = 11, .external_lex_state = 7},
  [762] = {.lex_state = 11, .external_lex_state = 7},
  [763] = {.lex_state = 11, .external_lex_state = 7},
  [764] = {.lex_state = 11, .external_lex_state = 7},
  [765] = {.lex_state = 11, .external_lex_state = 7},
  [766] = {.lex_state = 11, .external_lex_state = 7},
  [767] = {.lex_state = 11, .external_lex_state = 7},
  [768] = {.lex_state = 11, .external_lex_state = 7},
  [769] = {.lex_state = 11, .external_lex_state = 7},
  [770] = {.lex_state = 11, .external_lex_state = 7},
  [771] = {.lex_state = 11, .external_lex_state = 7},
  [772] = {.lex_state = 11, .external_lex_state = 7},
  [773] = {.lex_state = 11, .external_lex_state = 7},
  [774] = {.lex_state = 11, .external_lex_state = 7},
  [775] = {.lex_state = 11, .external_lex_state = 7},
  [776] = {.lex_state = 11, .external_lex_state = 7},
  [777] = {.lex_state = 11, .external_lex_state = 7},
  [778] = {.lex_state = 11, .external_lex_state = 7},
  [779] = {.lex_state = 11, .external_lex_state = 7},
  [780] = {.lex_state = 11, .external_lex_state = 7},
  [781] = {.lex_state = 11, .external_lex_state = 7},
  [782] = {.lex_state = 11, .external_lex_state = 7},
  [783] = {.lex_state = 11, .external_lex_state = 7},
  [784] = {.lex_state = 11, .external_lex_state = 7},
  [785] = {.lex_state = 11, .external_lex_state = 7},
  [786] = {.lex_state = 11, .external_lex_state = 7},
  [787] = {.lex_state = 11, .external_lex_state = 7},
  [788] = {.lex_state = 11, .external_lex_state = 7},
  [789] = {.lex_state = 11, .external_lex_state = 7},
  [790] = {.lex_state = 11, .external_lex_state = 7},
  [791] = {.lex_state = 11, .external_lex_state = 7},
  [792] = {.lex_state = 11, .external_lex_state = 7},
  [793] = {.lex_state = 11, .external_lex_state = 7},
  [794] = {.lex_state = 11, .external_lex_state = 7},
  [795] = {.lex_state = 11, .external_lex_state = 7},
  [796] = {.lex_state = 11, .external_lex_state = 7},
  [797] = {.lex_state = 11, .external_lex_state = 7},
  [798] = {.lex_state = 11, .external_lex_state = 7},
  [799] = {.lex_state = 11, .external_lex_state = 7},
  [800] = {.lex_state = 11, .external_lex_state = 7},
  [801] = {.lex_state = 11, .external_lex_state = 7},
  [802] = {.lex_state = 11, .external_lex_state = 7},
  [803] = {.lex_state = 11, .external_lex_state = 7},
  [804] = {.lex_state = 11, .external_lex_state = 7},
  [805] = {.lex_state = 11, .external_lex_state = 7},
  [806] = {.lex_state = 11, .external_lex_state = 7},
  [807] = {.lex_state = 11, .external_lex_state = 7},
  [808] = {.lex_state = 11, .external_lex_state = 7},
  [809] = {.lex_state = 41, .external_lex_state = 8},
  [810] = {.lex_state = 41, .external_lex_state = 8},
  [811] = {.lex_state = 41, .external_lex_state = 8},
  [812] = {.lex_state = 41, .external_lex_state = 8},
  [813] = {.lex_state = 41, .external_lex_state = 8},
  [814] = {.lex_state = 41, .external_lex_state = 8},
  [815] = {.lex_state = 41, .external_lex_state = 8},
  [816] = {.lex_state = 41, .external_lex_state = 8},
  [817] = {.lex_state = 41, .external_lex_state = 8},
  [818] = {.lex_state = 41, .external_lex_state = 8},
  [819] = {.lex_state = 41, .external_lex_state = 8},
  [820] = {.lex_state = 41, .external_lex_state = 8},
  [821] = {.lex_state = 41, .external_lex_state = 8},
  [822] = {.lex_state = 41, .external_lex_state = 8},
  [823] = {.lex_state = 41, .external_lex_state = 8},
  [824] = {.lex_state = 41, .external_lex_state = 8},
  [825] = {.lex_state = 41, .external_lex_state = 8},
  [826] = {.lex_state = 41, .external_lex_state = 8},
  [827] = {.lex_state = 41, .external_lex_state = 9},
  [828] = {.lex_state = 41, .external_lex_state = 8},
  [829] = {.lex_state = 41, .external_lex_state = 8},
  [830] = {.lex_state = 41, .external_lex_state = 8},
  [831] = {.lex_state = 41, .external_lex_state = 8},
  [832] = {.lex_state = 41, .external_lex_state = 8},
  [833] = {.lex_state = 41, .external_lex_state = 8},
  [834] = {.lex_state = 41, .external_lex_state = 8},
  [835] = {.lex_state = 41, .external_lex_state = 8},
  [836] = {.lex_state = 41, .external_lex_state = 8},
  [837] = {.lex_state = 41, .external_lex_state = 8},
  [838] = {.lex_state = 41, .external_lex_state = 8},
  [839] = {.lex_state = 41, .external_lex_state = 8},
  [840] = {.lex_state = 41, .external_lex_state = 8},
  [841] = {.lex_state = 41, .external_lex_state = 8},
  [842] = {.lex_state = 41, .external_lex_state = 8},
  [843] = {.lex_state = 41, .external_lex_state = 8},
  [844] = {.lex_state = 41, .external_lex_state = 9},
  [845] = {.lex_state = 41, .external_lex_state = 8},
  [846] = {.lex_state = 41, .external_lex_state = 8},
  [847] = {.lex_state = 41, .external_lex_state = 8},
  [848] = {.lex_state = 41, .external_lex_state = 8},
  [849] = {.lex_state = 41, .external_lex_state = 8},
  [850] = {.lex_state = 41, .external_lex_state = 8},
  [851] = {.lex_state = 41, .external_lex_state = 8},
  [852] = {.lex_state = 41, .external_lex_state = 8},
  [853] = {.lex_state = 41, .external_lex_state = 8},
  [854] = {.lex_state = 41, .external_lex_state = 8},
  [855] = {.lex_state = 41, .external_lex_state = 10},
  [856] = {.lex_state = 41, .external_lex_state = 8},
  [857] = {.lex_state = 41, .external_lex_state = 8},
  [858] = {.lex_state = 41, .external_lex_state = 9},
  [859] = {.lex_state = 41, .external_lex_state = 8},
  [860] = {.lex_state = 41, .external_lex_state = 9},
  [861] = {.lex_state = 41, .external_lex_state = 10},
  [862] = {.lex_state = 41, .external_lex_state = 8},
  [863] = {.lex_state = 41, .external_lex_state = 8},
  [864] = {.lex_state = 41, .external_lex_state = 8},
  [865] = {.lex_state = 41, .external_lex_state = 8},
  [866] = {.lex_state = 41, .external_lex_state = 8},
  [867] = {.lex_state = 41, .external_lex_state = 8},
  [868] = {.lex_state = 41, .external_lex_state = 8},
  [869] = {.lex_state = 41, .external_lex_state = 8},
  [870] = {.lex_state = 41, .external_lex_state = 8},
  [871] = {.lex_state = 41, .external_lex_state = 8},
  [872] = {.lex_state = 41, .external_lex_state = 8},
  [873] = {.lex_state = 41, .external_lex_state = 8},
  [874] = {.lex_state = 41, .external_lex_state = 8},
  [875] = {.lex_state = 41, .external_lex_state = 8},
  [876] = {.lex_state = 41, .external_lex_state = 8},
  [877] = {.lex_state = 41, .external_lex_state = 8},
  [878] = {.lex_state = 41, .external_lex_state = 8},
  [879] = {.lex_state = 41, .external_lex_state = 8},
  [880] = {.lex_state = 41, .external_lex_state = 10},
  [881] = {.lex_state = 41, .external_lex_state = 8},
  [882] = {.lex_state = 41, .external_lex_state = 8},
  [883] = {.lex_state = 41, .external_lex_state = 8},
  [884] = {.lex_state = 41, .external_lex_state = 8},
  [885] = {.lex_state = 41, .external_lex_state = 8},
  [886] = {.lex_state = 41, .external_lex_state = 8},
  [887] = {.lex_state = 41, .external_lex_state = 8},
  [888] = {.lex_state = 41, .external_lex_state = 8},
  [889] = {.lex_state = 41, .external_lex_state = 8},
  [890] = {.lex_state = 41, .external_lex_state = 8},
  [891] = {.lex_state = 41, .external_lex_state = 8},
  [892] = {.lex_state = 41, .external_lex_state = 8},
  [893] = {.lex_state = 41, .external_lex_state = 8},
  [894] = {.lex_state = 41, .external_lex_state = 8},
  [895] = {.lex_state = 41, .external_lex_state = 8},
  [896] = {.lex_state = 41, .external_lex_state = 8},
  [897] = {.lex_state = 41, .external_lex_state = 8},
  [898] = {.lex_state = 41, .external_lex_state = 8},
  [899] = {.lex_state = 41, .external_lex_state = 8},
  [900] = {.lex_state = 41, .external_lex_state = 8},
  [901] = {.lex_state = 41, .external_lex_state = 8},
  [902] = {.lex_state = 41, .external_lex_state = 8},
  [903] = {.lex_state = 41, .external_lex_state = 9},
  [904] = {.lex_state = 41, .external_lex_state = 8},
  [905] = {.lex_state = 41, .external_lex_state = 8},
  [906] = {.lex_state = 41, .external_lex_state = 8},
  [907] = {.lex_state = 41, .external_lex_state = 8},
  [908] = {.lex_state = 41, .external_lex_state = 8},
  [909] = {.lex_state = 41, .external_lex_state = 8},
  [910] = {.lex_state = 41, .external_lex_state = 8},
  [911] = {.lex_state = 41, .external_lex_state = 9},
  [912] = {.lex_state = 41, .external_lex_state = 8},
  [913] = {.lex_state = 41, .external_lex_state = 8},
  [914] = {.lex_state = 41, .external_lex_state = 8},
  [915] = {.lex_state = 41, .external_lex_state = 8},
  [916] = {.lex_state = 41, .external_lex_state = 9},
  [917] = {.lex_state = 41, .external_lex_state = 8},
  [918] = {.lex_state = 41, .external_lex_state = 8},
  [919] = {.lex_state = 41, .external_lex_state = 8},
  [920] = {.lex_state = 41, .external_lex_state = 8},
  [921] = {.lex_state = 41, .external_lex_state = 8},
  [922] = {.lex_state = 41, .external_lex_state = 8},
  [923] = {.lex_state = 41, .external_lex_state = 8},
  [924] = {.lex_state = 41, .external_lex_state = 8},
  [925] = {.lex_state = 41, .external_lex_state = 8},
  [926] = {.lex_state = 41, .external_lex_state = 8},
  [927] = {.lex_state = 41, .external_lex_state = 8},
  [928] = {.lex_state = 41, .external_lex_state = 8},
  [929] = {.lex_state = 41, .external_lex_state = 8},
  [930] = {.lex_state = 41, .external_lex_state = 8},
  [931] = {.lex_state = 41, .external_lex_state = 8},
  [932] = {.lex_state = 41, .external_lex_state = 8},
  [933] = {.lex_state = 41, .external_lex_state = 8},
  [934] = {.lex_state = 41, .external_lex_state = 8},
  [935] = {.lex_state = 41, .external_lex_state = 8},
  [936] = {.lex_state = 41, .external_lex_state = 8},
  [937] = {.lex_state = 41, .external_lex_state = 8},
  [938] = {.lex_state = 41, .external_lex_state = 8},
  [939] = {.lex_state = 41, .external_lex_state = 8},
  [940] = {.lex_state = 41, .external_lex_state = 8},
  [941] = {.lex_state = 41, .external_lex_state = 8},
  [942] = {.lex_state = 41, .external_lex_state = 8},
  [943] = {.lex_state = 41, .external_lex_state = 8},
  [944] = {.lex_state = 41, .external_lex_state = 8},
  [945] = {.lex_state = 41, .external_lex_state = 8},
  [946] = {.lex_state = 41, .external_lex_state = 10},
  [947] = {.lex_state = 41, .external_lex_state = 10},
  [948] = {.lex_state = 41, .external_lex_state = 9},
  [949] = {.lex_state = 41, .external_lex_state = 8},
  [950] = {.lex_state = 41, .external_lex_state = 8},
  [951] = {.lex_state = 41, .external_lex_state = 10},
  [952] = {.lex_state = 41, .external_lex_state = 10},
  [953] = {.lex_state = 41, .external_lex_state = 9},
  [954] = {.lex_state = 41, .external_lex_state = 9},
  [955] = {.lex_state = 41, .external_lex_state = 8},
  [956] = {.lex_state = 41, .external_lex_state = 9},
  [957] = {.lex_state = 41, .external_lex_state = 8},
  [958] = {.lex_state = 2, .external_lex_state = 11},
  [959] = {.lex_state = 2, .external_lex_state = 11},
  [960] = {.lex_state = 2, .external_lex_state = 11},
  [961] = {.lex_state = 2, .external_lex_state = 11},
  [962] = {.lex_state = 2, .external_lex_state = 11},
  [963] = {.lex_state = 2, .external_lex_state = 11},
  [964] = {.lex_state = 2, .external_lex_state = 11},
  [965] = {.lex_state = 2, .external_lex_state = 11},
  [966] = {.lex_state = 2, .external_lex_state = 11},
  [967] = {.lex_state = 2, .external_lex_state = 11},
  [968] = {.lex_state = 2, .external_lex_state = 11},
  [969] = {.lex_state = 1, .external_lex_state = 11},
  [970] = {.lex_state = 1, .external_lex_state = 11},
  [971] = {.lex_state = 1, .external_lex_state = 11},
  [972] = {.lex_state = 1, .external_lex_state = 11},
  [973] = {.lex_state = 1, .external_lex_state = 11},
  [974] = {.lex_state = 1, .external_lex_state = 11},
  [975] = {.lex_state = 1, .external_lex_state = 11},
  [976] = {.lex_state = 1, .external_lex_state = 11},
  [977] = {.lex_state = 1, .external_lex_state = 11},
  [978] = {.lex_state = 3, .external_lex_state = 11},
  [979] = {.lex_state = 4, .external_lex_state = 12},
  [980] = {.lex_state = 1, .external_lex_state = 11},
  [981] = {.lex_state = 4, .external_lex_state = 12},
  [982] = {.lex_state = 1, .external_lex_state = 11},
  [983] = {.lex_state = 1, .external_lex_state = 11},
  [984] = {.lex_state = 1, .external_lex_state = 11},
  [985] = {.lex_state = 1, .external_lex_state = 11},
  [986] = {.lex_state = 1, .external_lex_state = 11},
  [987] = {.lex_state = 1, .external_lex_state = 11},
  [988] = {.lex_state = 1, .external_lex_state = 11},
  [989] = {.lex_state = 1, .external_lex_state = 11},
  [990] = {.lex_state = 1, .external_lex_state = 11},
  [991] = {.lex_state = 1, .external_lex_state = 11},
  [992] = {.lex_state = 1, .external_lex_state = 11},
  [993] = {.lex_state = 1, .external_lex_state = 11},
  [994] = {.lex_state = 1, .external_lex_state = 11},
  [995] = {.lex_state = 4, .external_lex_state = 12},
  [996] = {.lex_state = 1, .external_lex_state = 11},
  [997] = {.lex_state = 3, .external_lex_state = 11},
  [998] = {.lex_state = 1, .external_lex_state = 11},
  [999] = {.lex_state = 4, .external_lex_state = 12},
  [1000] = {.lex_state = 1, .external_lex_state = 11},
  [1001] = {.lex_state = 4, .external_lex_state = 12},
  [1002] = {.lex_state = 4, .external_lex_state = 11},
  [1003] = {.lex_state = 1, .external_lex_state = 11},
  [1004] = {.lex_state = 4, .external_lex_state = 11},
  [1005] = {.lex_state = 4, .external_lex_state = 12},
  [1006] = {.lex_state = 4, .external_lex_state = 11},
  [1007] = {.lex_state = 4, .external_lex_state = 11},
  [1008] = {.lex_state = 4, .external_lex_state = 11},
  [1009] = {.lex_state = 10, .external_lex_state = 13},
  [1010] = {.lex_state = 10, .external_lex_state = 13},
  [1011] = {.lex_state = 9, .external_lex_state = 14},
  [1012] = {.lex_state = 9, .external_lex_state = 14},
  [1013] = {.lex_state = 4, .external_lex_state = 11},
  [1014] = {.lex_state = 4, .external_lex_state = 11},
  [1015] = {.lex_state = 4, .external_lex_state = 11},
  [1016] = {.lex_state = 4, .external_lex_state = 11},
  [1017] = {.lex_state = 4, .external_lex_state = 11},
  [1018] = {.lex_state = 10, .external_lex_state = 13},
  [1019] = {.lex_state = 10, .external_lex_state = 13},
  [1020] = {.lex_state = 4, .external_lex_state = 11},
  [1021] = {.lex_state = 4, .external_lex_state = 11},
  [1022] = {.lex_state = 4, .external_lex_state = 11},
  [1023] = {.lex_state = 4, .external_lex_state = 11},
  [1024] = {.lex_state = 4, .external_lex_state = 11},
  [1025] = {.lex_state = 4, .external_lex_state = 11},
  [1026] = {.lex_state = 10, .external_lex_state = 13},
  [1027] = {.lex_state = 4, .external_lex_state = 11},
  [1028] = {.lex_state = 4, .external_lex_state = 11},
  [1029] = {.lex_state = 10, .external_lex_state = 13},
  [1030] = {.lex_state = 4, .external_lex_state = 11},
  [1031] = {.lex_state = 10, .external_lex_state = 13},
  [1032] = {.lex_state = 9, .external_lex_state = 14},
  [1033] = {.lex_state = 9, .external_lex_state = 14},
  [1034] = {.lex_state = 10, .external_lex_state = 13},
  [1035] = {.lex_state = 4, .external_lex_state = 11},
  [1036] = {.lex_state = 10, .external_lex_state = 13},
  [1037] = {.lex_state = 4, .external_lex_state = 11},
  [1038] = {.lex_state = 4, .external_lex_state = 11},
  [1039] = {.lex_state = 10, .external_lex_state = 13},
  [1040] = {.lex_state = 10, .external_lex_state = 13},
  [1041] = {.lex_state = 10, .external_lex_state = 13},
  [1042] = {.lex_state = 9, .external_lex_state = 14},
  [1043] = {.lex_state = 4, .external_lex_state = 11},
  [1044] = {.lex_state = 4, .external_lex_state = 11},
  [1045] = {.lex_state = 10, .external_lex_state = 13},
  [1046] = {.lex_state = 10, .external_lex_state = 13},
  [1047] = {.lex_state = 4, .external_lex_state = 11},
  [1048] = {.lex_state = 10, .external_lex_state = 13},
  [1049] = {.lex_state = 4, .external_lex_state = 11},
  [1050] = {.lex_state = 10, .external_lex_state = 13},
  [1051] = {.lex_state = 10, .external_lex_state = 13},
  [1052] = {.lex_state = 9, .external_lex_state = 14},
  [1053] = {.lex_state = 9, .external_lex_state = 14},
  [1054] = {.lex_state = 10, .external_lex_state = 13},
  [1055] = {.lex_state = 10, .external_lex_state = 13},
  [1056] = {.lex_state = 10, .external_lex_state = 13},
  [1057] = {.lex_state = 10, .external_lex_state = 13},
  [1058] = {.lex_state = 11, .external_lex_state = 7},
  [1059] = {.lex_state = 11, .external_lex_state = 7},
  [1060] = {.lex_state = 41, .external_lex_state = 15},
  [1061] = {.lex_state = 41, .external_lex_state = 16},
  [1062] = {.lex_state = 41, .external_lex_state = 10},
  [1063] = {.lex_state = 41, .external_lex_state = 17},
  [1064] = {.lex_state = 41, .external_lex_state = 17},
  [1065] = {.lex_state = 41, .external_lex_state = 16},
  [1066] = {.lex_state = 41, .external_lex_state = 16},
  [1067] = {.lex_state = 41, .external_lex_state = 8},
  [1068] = {.lex_state = 41, .external_lex_state = 16},
  [1069] = {.lex_state = 41, .external_lex_state = 15},
  [1070] = {.lex_state = 41, .external_lex_state = 10},
  [1071] = {.lex_state = 41, .external_lex_state = 8},
  [1072] = {.lex_state = 41, .external_lex_state = 9},
  [1073] = {.lex_state = 41, .external_lex_state = 16},
  [1074] = {.lex_state = 41, .external_lex_state = 17},
  [1075] = {.lex_state = 41, .external_lex_state = 17},
  [1076] = {.lex_state = 41, .external_lex_state = 15},
  [1077] = {.lex_state = 41, .external_lex_state = 17},
  [1078] = {.lex_state = 41, .external_lex_state = 16},
  [1079] = {.lex_state = 41, .external_lex_state = 17},
  [1080] = {.lex_state = 41, .external_lex_state = 15},
  [1081] = {.lex_state = 41, .external_lex_state = 15},
  [1082] = {.lex_state = 41, .external_lex_state = 9},
  [1083] = {.lex_state = 41, .external_lex_state = 15},
  [1084] = {.lex_state = 41, .external_lex_state = 18},
  [1085] = {.lex_state = 41, .external_lex_state = 19},
  [1086] = {.lex_state = 11, .external_lex_state = 3},
  [1087] = {.lex_state = 11, .external_lex_state = 3},
  [1088] = {.lex_state = 11, .external_lex_state = 3},
  [1089] = {.lex_state = 11, .external_lex_state = 3},
  [1090] = {.lex_state = 11, .external_lex_state = 20},
  [1091] = {.lex_state = 11, .external_lex_state = 20},
  [1092] = {.lex_state = 11, .external_lex_state = 20},
  [1093] = {.lex_state = 11, .external_lex_state = 20},
  [1094] = {.lex_state = 11, .external_lex_state = 3},
  [1095] = {.lex_state = 11, .external_lex_state = 20},
  [1096] = {.lex_state = 41, .external_lex_state = 21},
  [1097] = {.lex_state = 41, .external_lex_state = 10},
  [1098] = {.lex_state = 11, .external_lex_state = 22},
  [1099] = {.lex_state = 41, .external_lex_state = 9},
  [1100] = {.lex_state = 11, .external_lex_state = 23},
  [1101] = {.lex_state = 12, .external_lex_state = 20},
  [1102] = {.lex_state = 41, .external_lex_state = 10},
  [1103] = {.lex_state = 41, .external_lex_state = 8},
  [1104] = {.lex_state = 12, .external_lex_state = 20},
  [1105] = {.lex_state = 12, .external_lex_state = 20},
  [1106] = {.lex_state = 11, .external_lex_state = 24},
  [1107] = {.lex_state = 15, .external_lex_state = 20},
  [1108] = {.lex_state = 12, .external_lex_state = 20},
  [1109] = {.lex_state = 41, .external_lex_state = 8},
  [1110] = {.lex_state = 41, .external_lex_state = 8},
  [1111] = {.lex_state = 11, .external_lex_state = 24},
  [1112] = {.lex_state = 15, .external_lex_state = 20},
  [1113] = {.lex_state = 41, .external_lex_state = 8},
  [1114] = {.lex_state = 41, .external_lex_state = 8},
  [1115] = {.lex_state = 41, .external_lex_state = 8},
  [1116] = {.lex_state = 41, .external_lex_state = 8},
  [1117] = {.lex_state = 15, .external_lex_state = 20},
  [1118] = {.lex_state = 41, .external_lex_state = 8},
  [1119] = {.lex_state = 41, .external_lex_state = 8},
  [1120] = {.lex_state = 41, .external_lex_state = 8},
  [1121] = {.lex_state = 41, .external_lex_state = 9},
  [1122] = {.lex_state = 41, .external_lex_state = 9},
  [1123] = {.lex_state = 41, .external_lex_state = 9},
  [1124] = {.lex_state = 41, .external_lex_state = 9},
  [1125] = {.lex_state = 41, .external_lex_state = 8},
  [1126] = {.lex_state = 41, .external_lex_state = 10},
  [1127] = {.lex_state = 41, .external_lex_state = 8},
  [1128] = {.lex_state = 41, .external_lex_state = 8},
  [1129] = {.lex_state = 41, .external_lex_state = 8},
  [1130] = {.lex_state = 41, .external_lex_state = 8},
  [1131] = {.lex_state = 41, .external_lex_state = 9},
  [1132] = {.lex_state = 41, .external_lex_state = 9},
  [1133] = {.lex_state = 41, .external_lex_state = 9},
  [1134] = {.lex_state = 41, .external_lex_state = 10},
  [1135] = {.lex_state = 41, .external_lex_state = 8},
  [1136] = {.lex_state = 41, .external_lex_state = 10},
  [1137] = {.lex_state = 11, .external_lex_state = 23},
  [1138] = {.lex_state = 41, .external_lex_state = 10},
  [1139] = {.lex_state = 41, .external_lex_state = 10},
  [1140] = {.lex_state = 41, .external_lex_state = 10},
  [1141] = {.lex_state = 41, .external_lex_state = 9},
  [1142] = {.lex_state = 41, .external_lex_state = 9},
  [1143] = {.lex_state = 41, .external_lex_state = 10},
  [1144] = {.lex_state = 41, .external_lex_state = 10},
  [1145] = {.lex_state = 11, .external_lex_state = 23},
  [1146] = {.lex_state = 11, .external_lex_state = 25},
  [1147] = {.lex_state = 11, .external_lex_state = 26},
  [1148] = {.lex_state = 11, .external_lex_state = 24},
  [1149] = {.lex_state = 41, .external_lex_state = 8},
  [1150] = {.lex_state = 41, .external_lex_state = 8},
  [1151] = {.lex_state = 41, .external_lex_state = 8},
  [1152] = {.lex_state = 41, .external_lex_state = 8},
  [1153] = {.lex_state = 11, .external_lex_state = 26},
  [1154] = {.lex_state = 11, .external_lex_state = 22},
  [1155] = {.lex_state = 41, .external_lex_state = 8},
  [1156] = {.lex_state = 41, .external_lex_state = 8},
  [1157] = {.lex_state = 11, .external_lex_state = 26},
  [1158] = {.lex_state = 41, .external_lex_state = 8},
  [1159] = {.lex_state = 41, .external_lex_state = 8},
  [1160] = {.lex_state = 41, .external_lex_state = 8},
  [1161] = {.lex_state = 11, .external_lex_state = 26},
  [1162] = {.lex_state = 41, .external_lex_state = 9},
  [1163] = {.lex_state = 41, .external_lex_state = 8},
  [1164] = {.lex_state = 41, .external_lex_state = 9},
  [1165] = {.lex_state = 41, .external_lex_state = 8},
  [1166] = {.lex_state = 11, .external_lex_state = 26},
  [1167] = {.lex_state = 41, .external_lex_state = 9},
  [1168] = {.lex_state = 41, .external_lex_state = 9},
  [1169] = {.lex_state = 41, .external_lex_state = 9},
  [1170] = {.lex_state = 41, .external_lex_state = 9},
  [1171] = {.lex_state = 41, .external_lex_state = 9},
  [1172] = {.lex_state = 15, .external_lex_state = 3},
  [1173] = {.lex_state = 41, .external_lex_state = 10},
  [1174] = {.lex_state = 15, .external_lex_state = 3},
  [1175] = {.lex_state = 41, .external_lex_state = 9},
  [1176] = {.lex_state = 15, .external_lex_state = 3},
  [1177] = {.lex_state = 41, .external_lex_state = 9},
  [1178] = {.lex_state = 41, .external_lex_state = 9},
  [1179] = {.lex_state = 41, .external_lex_state = 10},
  [1180] = {.lex_state = 41, .external_lex_state = 9},
  [1181] = {.lex_state = 12, .external_lex_state = 20},
  [1182] = {.lex_state = 41, .external_lex_state = 10},
  [1183] = {.lex_state = 11, .external_lex_state = 27},
  [1184] = {.lex_state = 11, .external_lex_state = 22},
  [1185] = {.lex_state = 11, .external_lex_state = 22},
  [1186] = {.lex_state = 41, .external_lex_state = 10},
  [1187] = {.lex_state = 11, .external_lex_state = 22},
  [1188] = {.lex_state = 12, .external_lex_state = 3},
  [1189] = {.lex_state = 41, .external_lex_state = 10},
  [1190] = {.lex_state = 41, .external_lex_state = 10},
  [1191] = {.lex_state = 41, .external_lex_state = 8},
  [1192] = {.lex_state = 41, .external_lex_state = 10},
  [1193] = {.lex_state = 41, .external_lex_state = 8},
  [1194] = {.lex_state = 41, .external_lex_state = 8},
  [1195] = {.lex_state = 41, .external_lex_state = 10},
  [1196] = {.lex_state = 41, .external_lex_state = 9},
  [1197] = {.lex_state = 11, .external_lex_state = 23},
  [1198] = {.lex_state = 12, .external_lex_state = 3},
  [1199] = {.lex_state = 41, .external_lex_state = 10},
  [1200] = {.lex_state = 12, .external_lex_state = 3},
  [1201] = {.lex_state = 12, .external_lex_state = 3},
  [1202] = {.lex_state = 41, .external_lex_state = 10},
  [1203] = {.lex_state = 41, .external_lex_state = 10},
  [1204] = {.lex_state = 41, .external_lex_state = 9},
  [1205] = {.lex_state = 12, .external_lex_state = 3},
  [1206] = {.lex_state = 41, .external_lex_state = 9},
  [1207] = {.lex_state = 41, .external_lex_state = 9},
  [1208] = {.lex_state = 41, .external_lex_state = 10},
  [1209] = {.lex_state = 41, .external_lex_state = 10},
  [1210] = {.lex_state = 41, .external_lex_state = 10},
  [1211] = {.lex_state = 11, .external_lex_state = 23},
  [1212] = {.lex_state = 11, .external_lex_state = 28},
  [1213] = {.lex_state = 11, .external_lex_state = 27},
  [1214] = {.lex_state = 41, .external_lex_state = 8},
  [1215] = {.lex_state = 41, .external_lex_state = 9},
  [1216] = {.lex_state = 41, .external_lex_state = 10},
  [1217] = {.lex_state = 41, .external_lex_state = 10},
  [1218] = {.lex_state = 41, .external_lex_state = 10},
  [1219] = {.lex_state = 41, .external_lex_state = 9},
  [1220] = {.lex_state = 41, .external_lex_state = 9},
  [1221] = {.lex_state = 41, .external_lex_state = 9},
  [1222] = {.lex_state = 41, .external_lex_state = 10},
  [1223] = {.lex_state = 41, .external_lex_state = 9},
  [1224] = {.lex_state = 41, .external_lex_state = 10},
  [1225] = {.lex_state = 11, .external_lex_state = 27},
  [1226] = {.lex_state = 41, .external_lex_state = 10},
  [1227] = {.lex_state = 41, .external_lex_state = 9},
  [1228] = {.lex_state = 41, .external_lex_state = 10},
  [1229] = {.lex_state = 12, .external_lex_state = 23},
  [1230] = {.lex_state = 15, .external_lex_state = 3},
  [1231] = {.lex_state = 11, .external_lex_state = 24},
  [1232] = {.lex_state = 11, .external_lex_state = 20},
  [1233] = {.lex_state = 11, .external_lex_state = 24},
  [1234] = {.lex_state = 11, .external_lex_state = 29},
  [1235] = {.lex_state = 15, .external_lex_state = 22},
  [1236] = {.lex_state = 11, .external_lex_state = 30},
  [1237] = {.lex_state = 15, .external_lex_state = 22},
  [1238] = {.lex_state = 11, .external_lex_state = 30},
  [1239] = {.lex_state = 15, .external_lex_state = 22},
  [1240] = {.lex_state = 12, .external_lex_state = 23},
  [1241] = {.lex_state = 12, .external_lex_state = 23},
  [1242] = {.lex_state = 11, .external_lex_state = 27},
  [1243] = {.lex_state = 12, .external_lex_state = 23},
  [1244] = {.lex_state = 12, .external_lex_state = 23},
  [1245] = {.lex_state = 16, .external_lex_state = 20},
  [1246] = {.lex_state = 11, .external_lex_state = 3},
  [1247] = {.lex_state = 16, .external_lex_state = 20},
  [1248] = {.lex_state = 11, .external_lex_state = 30},
  [1249] = {.lex_state = 16, .external_lex_state = 20},
  [1250] = {.lex_state = 11, .external_lex_state = 27},
  [1251] = {.lex_state = 11, .external_lex_state = 31},
  [1252] = {.lex_state = 11, .external_lex_state = 27},
  [1253] = {.lex_state = 11, .external_lex_state = 20},
  [1254] = {.lex_state = 13, .external_lex_state = 3},
  [1255] = {.lex_state = 13, .external_lex_state = 3},
  [1256] = {.lex_state = 13, .external_lex_state = 3},
  [1257] = {.lex_state = 15, .external_lex_state = 20},
  [1258] = {.lex_state = 12, .external_lex_state = 26},
  [1259] = {.lex_state = 11, .external_lex_state = 32},
  [1260] = {.lex_state = 15, .external_lex_state = 26},
  [1261] = {.lex_state = 15, .external_lex_state = 20},
  [1262] = {.lex_state = 11, .external_lex_state = 20},
  [1263] = {.lex_state = 11, .external_lex_state = 3},
  [1264] = {.lex_state = 12, .external_lex_state = 26},
  [1265] = {.lex_state = 12, .external_lex_state = 26},
  [1266] = {.lex_state = 13, .external_lex_state = 3},
  [1267] = {.lex_state = 13, .external_lex_state = 3},
  [1268] = {.lex_state = 11, .external_lex_state = 20},
  [1269] = {.lex_state = 11, .external_lex_state = 3},
  [1270] = {.lex_state = 12, .external_lex_state = 26},
  [1271] = {.lex_state = 12, .external_lex_state = 26},
  [1272] = {.lex_state = 12, .external_lex_state = 28},
  [1273] = {.lex_state = 12, .external_lex_state = 24},
  [1274] = {.lex_state = 15, .external_lex_state = 26},
  [1275] = {.lex_state = 12, .external_lex_state = 24},
  [1276] = {.lex_state = 15, .external_lex_state = 20},
  [1277] = {.lex_state = 12, .external_lex_state = 25},
  [1278] = {.lex_state = 11, .external_lex_state = 20},
  [1279] = {.lex_state = 11, .external_lex_state = 20},
  [1280] = {.lex_state = 17, .external_lex_state = 20},
  [1281] = {.lex_state = 17, .external_lex_state = 3},
  [1282] = {.lex_state = 12, .external_lex_state = 24},
  [1283] = {.lex_state = 13, .external_lex_state = 20},
  [1284] = {.lex_state = 13, .external_lex_state = 20},
  [1285] = {.lex_state = 17, .external_lex_state = 20},
  [1286] = {.lex_state = 17, .external_lex_state = 3},
  [1287] = {.lex_state = 17, .external_lex_state = 3},
  [1288] = {.lex_state = 11, .external_lex_state = 3},
  [1289] = {.lex_state = 11, .external_lex_state = 3},
  [1290] = {.lex_state = 13, .external_lex_state = 20},
  [1291] = {.lex_state = 13, .external_lex_state = 20},
  [1292] = {.lex_state = 17, .external_lex_state = 20},
  [1293] = {.lex_state = 11, .external_lex_state = 33},
  [1294] = {.lex_state = 11, .external_lex_state = 3},
  [1295] = {.lex_state = 15, .external_lex_state = 3},
  [1296] = {.lex_state = 11, .external_lex_state = 24},
  [1297] = {.lex_state = 11, .external_lex_state = 20},
  [1298] = {.lex_state = 11, .external_lex_state = 3},
  [1299] = {.lex_state = 15, .external_lex_state = 26},
  [1300] = {.lex_state = 15, .external_lex_state = 3},
  [1301] = {.lex_state = 11, .external_lex_state = 31},
  [1302] = {.lex_state = 15, .external_lex_state = 3},
  [1303] = {.lex_state = 13, .external_lex_state = 20},
  [1304] = {.lex_state = 11, .external_lex_state = 34},
  [1305] = {.lex_state = 11, .external_lex_state = 27},
  [1306] = {.lex_state = 15, .external_lex_state = 3},
  [1307] = {.lex_state = 11, .external_lex_state = 3},
  [1308] = {.lex_state = 11, .external_lex_state = 20},
  [1309] = {.lex_state = 12, .external_lex_state = 27},
  [1310] = {.lex_state = 15, .external_lex_state = 20},
  [1311] = {.lex_state = 11, .external_lex_state = 24},
  [1312] = {.lex_state = 11, .external_lex_state = 20},
  [1313] = {.lex_state = 11, .external_lex_state = 34},
  [1314] = {.lex_state = 16, .external_lex_state = 3},
  [1315] = {.lex_state = 11, .external_lex_state = 3},
  [1316] = {.lex_state = 11, .external_lex_state = 34},
  [1317] = {.lex_state = 11, .external_lex_state = 3},
  [1318] = {.lex_state = 15, .external_lex_state = 23},
  [1319] = {.lex_state = 11, .external_lex_state = 3},
  [1320] = {.lex_state = 15, .external_lex_state = 23},
  [1321] = {.lex_state = 11, .external_lex_state = 3},
  [1322] = {.lex_state = 16, .external_lex_state = 3},
  [1323] = {.lex_state = 12, .external_lex_state = 27},
  [1324] = {.lex_state = 11, .external_lex_state = 20},
  [1325] = {.lex_state = 15, .external_lex_state = 23},
  [1326] = {.lex_state = 16, .external_lex_state = 3},
  [1327] = {.lex_state = 12, .external_lex_state = 22},
  [1328] = {.lex_state = 12, .external_lex_state = 22},
  [1329] = {.lex_state = 12, .external_lex_state = 22},
  [1330] = {.lex_state = 12, .external_lex_state = 22},
  [1331] = {.lex_state = 12, .external_lex_state = 27},
  [1332] = {.lex_state = 12, .external_lex_state = 22},
  [1333] = {.lex_state = 11, .external_lex_state = 20},
  [1334] = {.lex_state = 11, .external_lex_state = 20},
  [1335] = {.lex_state = 15, .external_lex_state = 20},
  [1336] = {.lex_state = 11, .external_lex_state = 31},
  [1337] = {.lex_state = 13, .external_lex_state = 27},
  [1338] = {.lex_state = 11, .external_lex_state = 3},
  [1339] = {.lex_state = 12, .external_lex_state = 20},
  [1340] = {.lex_state = 6, .external_lex_state = 35},
  [1341] = {.lex_state = 16, .external_lex_state = 20},
  [1342] = {.lex_state = 14, .external_lex_state = 20},
  [1343] = {.lex_state = 17, .external_lex_state = 20},
  [1344] = {.lex_state = 18, .external_lex_state = 20},
  [1345] = {.lex_state = 11, .external_lex_state = 3},
  [1346] = {.lex_state = 12, .external_lex_state = 20},
  [1347] = {.lex_state = 14, .external_lex_state = 20},
  [1348] = {.lex_state = 14, .external_lex_state = 20},
  [1349] = {.lex_state = 11, .external_lex_state = 3},
  [1350] = {.lex_state = 18, .external_lex_state = 20},
  [1351] = {.lex_state = 14, .external_lex_state = 20},
  [1352] = {.lex_state = 11, .external_lex_state = 20},
  [1353] = {.lex_state = 16, .external_lex_state = 20},
  [1354] = {.lex_state = 11, .external_lex_state = 20},
  [1355] = {.lex_state = 11, .external_lex_state = 20},
  [1356] = {.lex_state = 11, .external_lex_state = 20},
  [1357] = {.lex_state = 11, .external_lex_state = 22},
  [1358] = {.lex_state = 12, .external_lex_state = 20},
  [1359] = {.lex_state = 12, .external_lex_state = 31},
  [1360] = {.lex_state = 16, .external_lex_state = 20},
  [1361] = {.lex_state = 11, .external_lex_state = 22},
  [1362] = {.lex_state = 16, .external_lex_state = 22},
  [1363] = {.lex_state = 11, .external_lex_state = 20},
  [1364] = {.lex_state = 6, .external_lex_state = 35},
  [1365] = {.lex_state = 11, .external_lex_state = 20},
  [1366] = {.lex_state = 15, .external_lex_state = 26},
  [1367] = {.lex_state = 11, .external_lex_state = 20},
  [1368] = {.lex_state = 11, .external_lex_state = 20},
  [1369] = {.lex_state = 11, .external_lex_state = 20},
  [1370] = {.lex_state = 12, .external_lex_state = 31},
  [1371] = {.lex_state = 11, .external_lex_state = 20},
  [1372] = {.lex_state = 14, .external_lex_state = 20},
  [1373] = {.lex_state = 16, .external_lex_state = 22},
  [1374] = {.lex_state = 12, .external_lex_state = 31},
  [1375] = {.lex_state = 11, .external_lex_state = 20},
  [1376] = {.lex_state = 11, .external_lex_state = 20},
  [1377] = {.lex_state = 15, .external_lex_state = 26},
  [1378] = {.lex_state = 11, .external_lex_state = 20},
  [1379] = {.lex_state = 15, .external_lex_state = 20},
  [1380] = {.lex_state = 15, .external_lex_state = 26},
  [1381] = {.lex_state = 11, .external_lex_state = 26},
  [1382] = {.lex_state = 12, .external_lex_state = 3},
  [1383] = {.lex_state = 16, .external_lex_state = 22},
  [1384] = {.lex_state = 11, .external_lex_state = 20},
  [1385] = {.lex_state = 11, .external_lex_state = 20},
  [1386] = {.lex_state = 11, .external_lex_state = 3},
  [1387] = {.lex_state = 6, .external_lex_state = 35},
  [1388] = {.lex_state = 11, .external_lex_state = 20},
  [1389] = {.lex_state = 11, .external_lex_state = 3},
  [1390] = {.lex_state = 12, .external_lex_state = 20},
  [1391] = {.lex_state = 15, .external_lex_state = 26},
  [1392] = {.lex_state = 11, .external_lex_state = 3},
  [1393] = {.lex_state = 11, .external_lex_state = 20},
  [1394] = {.lex_state = 11, .external_lex_state = 26},
  [1395] = {.lex_state = 13, .external_lex_state = 25},
  [1396] = {.lex_state = 11, .external_lex_state = 20},
  [1397] = {.lex_state = 11, .external_lex_state = 20},
  [1398] = {.lex_state = 12, .external_lex_state = 20},
  [1399] = {.lex_state = 16, .external_lex_state = 20},
  [1400] = {.lex_state = 12, .external_lex_state = 3},
  [1401] = {.lex_state = 11, .external_lex_state = 20},
  [1402] = {.lex_state = 11, .external_lex_state = 20},
  [1403] = {.lex_state = 11, .external_lex_state = 26},
  [1404] = {.lex_state = 11, .external_lex_state = 20},
  [1405] = {.lex_state = 11, .external_lex_state = 20},
  [1406] = {.lex_state = 16, .external_lex_state = 20},
  [1407] = {.lex_state = 11, .external_lex_state = 20},
  [1408] = {.lex_state = 12, .external_lex_state = 20},
  [1409] = {.lex_state = 11, .external_lex_state = 20},
  [1410] = {.lex_state = 12, .external_lex_state = 3},
  [1411] = {.lex_state = 11, .external_lex_state = 26},
  [1412] = {.lex_state = 11, .external_lex_state = 22},
  [1413] = {.lex_state = 11, .external_lex_state = 23},
  [1414] = {.lex_state = 11, .external_lex_state = 20},
  [1415] = {.lex_state = 11, .external_lex_state = 20},
  [1416] = {.lex_state = 11, .external_lex_state = 26},
  [1417] = {.lex_state = 11, .external_lex_state = 20},
  [1418] = {.lex_state = 11, .external_lex_state = 20},
  [1419] = {.lex_state = 11, .external_lex_state = 20},
  [1420] = {.lex_state = 11, .external_lex_state = 20},
  [1421] = {.lex_state = 11, .external_lex_state = 3},
  [1422] = {.lex_state = 11, .external_lex_state = 20},
  [1423] = {.lex_state = 11, .external_lex_state = 20},
  [1424] = {.lex_state = 11, .external_lex_state = 3},
  [1425] = {.lex_state = 11, .external_lex_state = 3},
  [1426] = {.lex_state = 11, .external_lex_state = 20},
  [1427] = {.lex_state = 11, .external_lex_state = 3},
  [1428] = {.lex_state = 12, .external_lex_state = 3},
  [1429] = {.lex_state = 12, .external_lex_state = 3},
  [1430] = {.lex_state = 11, .external_lex_state = 3},
  [1431] = {.lex_state = 11, .external_lex_state = 3},
  [1432] = {.lex_state = 12, .external_lex_state = 29},
  [1433] = {.lex_state = 11, .external_lex_state = 3},
  [1434] = {.lex_state = 11, .external_lex_state = 22},
  [1435] = {.lex_state = 11, .external_lex_state = 23},
  [1436] = {.lex_state = 11, .external_lex_state = 3},
  [1437] = {.lex_state = 11, .external_lex_state = 26},
  [1438] = {.lex_state = 11, .external_lex_state = 3},
  [1439] = {.lex_state = 15, .external_lex_state = 22},
  [1440] = {.lex_state = 11, .external_lex_state = 23},
  [1441] = {.lex_state = 11, .external_lex_state = 23},
  [1442] = {.lex_state = 11, .external_lex_state = 30},
  [1443] = {.lex_state = 11, .external_lex_state = 22},
  [1444] = {.lex_state = 11, .external_lex_state = 3},
  [1445] = {.lex_state = 15, .external_lex_state = 20},
  [1446] = {.lex_state = 11, .external_lex_state = 23},
  [1447] = {.lex_state = 11, .external_lex_state = 26},
  [1448] = {.lex_state = 11, .external_lex_state = 30},
  [1449] = {.lex_state = 13, .external_lex_state = 27},
  [1450] = {.lex_state = 11, .external_lex_state = 3},
  [1451] = {.lex_state = 11, .external_lex_state = 3},
  [1452] = {.lex_state = 16, .external_lex_state = 3},
  [1453] = {.lex_state = 16, .external_lex_state = 3},
  [1454] = {.lex_state = 12, .external_lex_state = 20},
  [1455] = {.lex_state = 11, .external_lex_state = 20},
  [1456] = {.lex_state = 11, .external_lex_state = 20},
  [1457] = {.lex_state = 11, .external_lex_state = 20},
  [1458] = {.lex_state = 11, .external_lex_state = 3},
  [1459] = {.lex_state = 16, .external_lex_state = 3},
  [1460] = {.lex_state = 12, .external_lex_state = 3},
  [1461] = {.lex_state = 18, .external_lex_state = 20},
  [1462] = {.lex_state = 13, .external_lex_state = 27},
  [1463] = {.lex_state = 17, .external_lex_state = 22},
  [1464] = {.lex_state = 16, .external_lex_state = 3},
  [1465] = {.lex_state = 12, .external_lex_state = 27},
  [1466] = {.lex_state = 12, .external_lex_state = 27},
  [1467] = {.lex_state = 11, .external_lex_state = 3},
  [1468] = {.lex_state = 11, .external_lex_state = 26},
  [1469] = {.lex_state = 11, .external_lex_state = 3},
  [1470] = {.lex_state = 12, .external_lex_state = 3},
  [1471] = {.lex_state = 11, .external_lex_state = 26},
  [1472] = {.lex_state = 12, .external_lex_state = 3},
  [1473] = {.lex_state = 12, .external_lex_state = 20},
  [1474] = {.lex_state = 11, .external_lex_state = 23},
  [1475] = {.lex_state = 11, .external_lex_state = 20},
  [1476] = {.lex_state = 11, .external_lex_state = 26},
  [1477] = {.lex_state = 13, .external_lex_state = 22},
  [1478] = {.lex_state = 13, .external_lex_state = 22},
  [1479] = {.lex_state = 17, .external_lex_state = 22},
  [1480] = {.lex_state = 12, .external_lex_state = 3},
  [1481] = {.lex_state = 11, .external_lex_state = 22},
  [1482] = {.lex_state = 12, .external_lex_state = 3},
  [1483] = {.lex_state = 16, .external_lex_state = 26},
  [1484] = {.lex_state = 12, .external_lex_state = 27},
  [1485] = {.lex_state = 15, .external_lex_state = 22},
  [1486] = {.lex_state = 11, .external_lex_state = 3},
  [1487] = {.lex_state = 15, .external_lex_state = 20},
  [1488] = {.lex_state = 11, .external_lex_state = 3},
  [1489] = {.lex_state = 11, .external_lex_state = 3},
  [1490] = {.lex_state = 11, .external_lex_state = 3},
  [1491] = {.lex_state = 11, .external_lex_state = 3},
  [1492] = {.lex_state = 11, .external_lex_state = 3},
  [1493] = {.lex_state = 11, .external_lex_state = 3},
  [1494] = {.lex_state = 15, .external_lex_state = 22},
  [1495] = {.lex_state = 11, .external_lex_state = 3},
  [1496] = {.lex_state = 12, .external_lex_state = 3},
  [1497] = {.lex_state = 11, .external_lex_state = 23},
  [1498] = {.lex_state = 11, .external_lex_state = 23},
  [1499] = {.lex_state = 17, .external_lex_state = 3},
  [1500] = {.lex_state = 12, .external_lex_state = 20},
  [1501] = {.lex_state = 11, .external_lex_state = 3},
  [1502] = {.lex_state = 12, .external_lex_state = 27},
  [1503] = {.lex_state = 16, .external_lex_state = 26},
  [1504] = {.lex_state = 11, .external_lex_state = 20},
  [1505] = {.lex_state = 12, .external_lex_state = 3},
  [1506] = {.lex_state = 11, .external_lex_state = 20},
  [1507] = {.lex_state = 11, .external_lex_state = 20},
  [1508] = {.lex_state = 16, .external_lex_state = 23},
  [1509] = {.lex_state = 11, .external_lex_state = 20},
  [1510] = {.lex_state = 11, .external_lex_state = 3},
  [1511] = {.lex_state = 13, .external_lex_state = 22},
  [1512] = {.lex_state = 13, .external_lex_state = 22},
  [1513] = {.lex_state = 11, .external_lex_state = 3},
  [1514] = {.lex_state = 16, .external_lex_state = 23},
  [1515] = {.lex_state = 17, .external_lex_state = 22},
  [1516] = {.lex_state = 11, .external_lex_state = 26},
  [1517] = {.lex_state = 13, .external_lex_state = 23},
  [1518] = {.lex_state = 11, .external_lex_state = 3},
  [1519] = {.lex_state = 11, .external_lex_state = 3},
  [1520] = {.lex_state = 16, .external_lex_state = 26},
  [1521] = {.lex_state = 11, .external_lex_state = 3},
  [1522] = {.lex_state = 15, .external_lex_state = 23},
  [1523] = {.lex_state = 15, .external_lex_state = 22},
  [1524] = {.lex_state = 11, .external_lex_state = 3},
  [1525] = {.lex_state = 11, .external_lex_state = 3},
  [1526] = {.lex_state = 13, .external_lex_state = 24},
  [1527] = {.lex_state = 15, .external_lex_state = 22},
  [1528] = {.lex_state = 11, .external_lex_state = 20},
  [1529] = {.lex_state = 12, .external_lex_state = 20},
  [1530] = {.lex_state = 12, .external_lex_state = 24},
  [1531] = {.lex_state = 11, .external_lex_state = 23},
  [1532] = {.lex_state = 12, .external_lex_state = 24},
  [1533] = {.lex_state = 16, .external_lex_state = 23},
  [1534] = {.lex_state = 11, .external_lex_state = 23},
  [1535] = {.lex_state = 13, .external_lex_state = 24},
  [1536] = {.lex_state = 14, .external_lex_state = 3},
  [1537] = {.lex_state = 12, .external_lex_state = 20},
  [1538] = {.lex_state = 11, .external_lex_state = 20},
  [1539] = {.lex_state = 6, .external_lex_state = 35},
  [1540] = {.lex_state = 11, .external_lex_state = 34},
  [1541] = {.lex_state = 16, .external_lex_state = 3},
  [1542] = {.lex_state = 11, .external_lex_state = 20},
  [1543] = {.lex_state = 13, .external_lex_state = 24},
  [1544] = {.lex_state = 11, .external_lex_state = 22},
  [1545] = {.lex_state = 11, .external_lex_state = 22},
  [1546] = {.lex_state = 11, .external_lex_state = 34},
  [1547] = {.lex_state = 13, .external_lex_state = 23},
  [1548] = {.lex_state = 13, .external_lex_state = 23},
  [1549] = {.lex_state = 11, .external_lex_state = 20},
  [1550] = {.lex_state = 18, .external_lex_state = 3},
  [1551] = {.lex_state = 17, .external_lex_state = 26},
  [1552] = {.lex_state = 14, .external_lex_state = 3},
  [1553] = {.lex_state = 14, .external_lex_state = 3},
  [1554] = {.lex_state = 14, .external_lex_state = 3},
  [1555] = {.lex_state = 11, .external_lex_state = 3},
  [1556] = {.lex_state = 14, .external_lex_state = 3},
  [1557] = {.lex_state = 11, .external_lex_state = 31},
  [1558] = {.lex_state = 13, .external_lex_state = 23},
  [1559] = {.lex_state = 11, .external_lex_state = 3},
  [1560] = {.lex_state = 13, .external_lex_state = 23},
  [1561] = {.lex_state = 11, .external_lex_state = 31},
  [1562] = {.lex_state = 18, .external_lex_state = 3},
  [1563] = {.lex_state = 11, .external_lex_state = 3},
  [1564] = {.lex_state = 11, .external_lex_state = 3},
  [1565] = {.lex_state = 11, .external_lex_state = 3},
  [1566] = {.lex_state = 11, .external_lex_state = 3},
  [1567] = {.lex_state = 11, .external_lex_state = 22},
  [1568] = {.lex_state = 13, .external_lex_state = 26},
  [1569] = {.lex_state = 15, .external_lex_state = 23},
  [1570] = {.lex_state = 18, .external_lex_state = 3},
  [1571] = {.lex_state = 13, .external_lex_state = 26},
  [1572] = {.lex_state = 11, .external_lex_state = 20},
  [1573] = {.lex_state = 17, .external_lex_state = 26},
  [1574] = {.lex_state = 12, .external_lex_state = 34},
  [1575] = {.lex_state = 11, .external_lex_state = 23},
  [1576] = {.lex_state = 11, .external_lex_state = 3},
  [1577] = {.lex_state = 13, .external_lex_state = 28},
  [1578] = {.lex_state = 11, .external_lex_state = 20},
  [1579] = {.lex_state = 12, .external_lex_state = 32},
  [1580] = {.lex_state = 12, .external_lex_state = 33},
  [1581] = {.lex_state = 13, .external_lex_state = 26},
  [1582] = {.lex_state = 11, .external_lex_state = 20},
  [1583] = {.lex_state = 13, .external_lex_state = 26},
  [1584] = {.lex_state = 17, .external_lex_state = 23},
  [1585] = {.lex_state = 11, .external_lex_state = 3},
  [1586] = {.lex_state = 17, .external_lex_state = 26},
  [1587] = {.lex_state = 15, .external_lex_state = 23},
  [1588] = {.lex_state = 15, .external_lex_state = 26},
  [1589] = {.lex_state = 11, .external_lex_state = 30},
  [1590] = {.lex_state = 12, .external_lex_state = 24},
  [1591] = {.lex_state = 12, .external_lex_state = 34},
  [1592] = {.lex_state = 17, .external_lex_state = 23},
  [1593] = {.lex_state = 12, .external_lex_state = 30},
  [1594] = {.lex_state = 11, .external_lex_state = 30},
  [1595] = {.lex_state = 12, .external_lex_state = 24},
  [1596] = {.lex_state = 11, .external_lex_state = 34},
  [1597] = {.lex_state = 17, .external_lex_state = 23},
  [1598] = {.lex_state = 11, .external_lex_state = 20},
  [1599] = {.lex_state = 13, .external_lex_state = 22},
  [1600] = {.lex_state = 15, .external_lex_state = 23},
  [1601] = {.lex_state = 11, .external_lex_state = 23},
  [1602] = {.lex_state = 11, .external_lex_state = 26},
  [1603] = {.lex_state = 11, .external_lex_state = 22},
  [1604] = {.lex_state = 11, .external_lex_state = 22},
  [1605] = {.lex_state = 12, .external_lex_state = 30},
  [1606] = {.lex_state = 12, .external_lex_state = 30},
  [1607] = {.lex_state = 12, .external_lex_state = 20},
  [1608] = {.lex_state = 11, .external_lex_state = 34},
  [1609] = {.lex_state = 13, .external_lex_state = 26},
  [1610] = {.lex_state = 11, .external_lex_state = 31},
  [1611] = {.lex_state = 12, .external_lex_state = 34},
  [1612] = {.lex_state = 11, .external_lex_state = 20},
  [1613] = {.lex_state = 11, .external_lex_state = 22},
  [1614] = {.lex_state = 11, .external_lex_state = 31},
  [1615] = {.lex_state = 15, .external_lex_state = 23},
  [1616] = {.lex_state = 11, .external_lex_state = 23},
  [1617] = {.lex_state = 12, .external_lex_state = 3},
  [1618] = {.lex_state = 12, .external_lex_state = 26},
  [1619] = {.lex_state = 12, .external_lex_state = 23},
  [1620] = {.lex_state = 11, .external_lex_state = 23},
  [1621] = {.lex_state = 14, .external_lex_state = 3},
  [1622] = {.lex_state = 11, .external_lex_state = 23},
  [1623] = {.lex_state = 11, .external_lex_state = 23},
  [1624] = {.lex_state = 14, .external_lex_state = 3},
  [1625] = {.lex_state = 14, .external_lex_state = 3},
  [1626] = {.lex_state = 12, .external_lex_state = 20},
  [1627] = {.lex_state = 11, .external_lex_state = 23},
  [1628] = {.lex_state = 11, .external_lex_state = 23},
  [1629] = {.lex_state = 12, .external_lex_state = 23},
  [1630] = {.lex_state = 11, .external_lex_state = 23},
  [1631] = {.lex_state = 14, .external_lex_state = 3},
  [1632] = {.lex_state = 11, .external_lex_state = 22},
  [1633] = {.lex_state = 14, .external_lex_state = 3},
  [1634] = {.lex_state = 14, .external_lex_state = 3},
  [1635] = {.lex_state = 11, .external_lex_state = 23},
  [1636] = {.lex_state = 11, .external_lex_state = 23},
  [1637] = {.lex_state = 11, .external_lex_state = 23},
  [1638] = {.lex_state = 12, .external_lex_state = 20},
  [1639] = {.lex_state = 14, .external_lex_state = 3},
  [1640] = {.lex_state = 14, .external_lex_state = 3},
  [1641] = {.lex_state = 12, .external_lex_state = 3},
  [1642] = {.lex_state = 11, .external_lex_state = 23},
  [1643] = {.lex_state = 12, .external_lex_state = 23},
  [1644] = {.lex_state = 14, .external_lex_state = 3},
  [1645] = {.lex_state = 11, .external_lex_state = 23},
  [1646] = {.lex_state = 12, .external_lex_state = 26},
  [1647] = {.lex_state = 12, .external_lex_state = 23},
  [1648] = {.lex_state = 16, .external_lex_state = 23},
  [1649] = {.lex_state = 12, .external_lex_state = 26},
  [1650] = {.lex_state = 14, .external_lex_state = 3},
  [1651] = {.lex_state = 11, .external_lex_state = 23},
  [1652] = {.lex_state = 14, .external_lex_state = 3},
  [1653] = {.lex_state = 11, .external_lex_state = 23},
  [1654] = {.lex_state = 11, .external_lex_state = 23},
  [1655] = {.lex_state = 11, .external_lex_state = 23},
  [1656] = {.lex_state = 12, .external_lex_state = 23},
  [1657] = {.lex_state = 16, .external_lex_state = 23},
  [1658] = {.lex_state = 11, .external_lex_state = 23},
  [1659] = {.lex_state = 14, .external_lex_state = 3},
  [1660] = {.lex_state = 11, .external_lex_state = 26},
  [1661] = {.lex_state = 16, .external_lex_state = 23},
  [1662] = {.lex_state = 11, .external_lex_state = 23},
  [1663] = {.lex_state = 14, .external_lex_state = 3},
  [1664] = {.lex_state = 14, .external_lex_state = 3},
  [1665] = {.lex_state = 14, .external_lex_state = 3},
  [1666] = {.lex_state = 12, .external_lex_state = 23},
  [1667] = {.lex_state = 12, .external_lex_state = 26},
  [1668] = {.lex_state = 11, .external_lex_state = 23},
  [1669] = {.lex_state = 11, .external_lex_state = 23},
  [1670] = {.lex_state = 16, .external_lex_state = 23},
  [1671] = {.lex_state = 17, .external_lex_state = 23},
  [1672] = {.lex_state = 11, .external_lex_state = 23},
  [1673] = {.lex_state = 12, .external_lex_state = 26},
  [1674] = {.lex_state = 16, .external_lex_state = 26},
  [1675] = {.lex_state = 11, .external_lex_state = 23},
  [1676] = {.lex_state = 13, .external_lex_state = 3},
  [1677] = {.lex_state = 11, .external_lex_state = 23},
  [1678] = {.lex_state = 12, .external_lex_state = 26},
  [1679] = {.lex_state = 14, .external_lex_state = 3},
  [1680] = {.lex_state = 11, .external_lex_state = 26},
  [1681] = {.lex_state = 14, .external_lex_state = 3},
  [1682] = {.lex_state = 12, .external_lex_state = 20},
  [1683] = {.lex_state = 13, .external_lex_state = 20},
  [1684] = {.lex_state = 14, .external_lex_state = 3},
  [1685] = {.lex_state = 12, .external_lex_state = 26},
  [1686] = {.lex_state = 14, .external_lex_state = 23},
  [1687] = {.lex_state = 14, .external_lex_state = 3},
  [1688] = {.lex_state = 14, .external_lex_state = 3},
  [1689] = {.lex_state = 13, .external_lex_state = 34},
  [1690] = {.lex_state = 13, .external_lex_state = 30},
  [1691] = {.lex_state = 14, .external_lex_state = 3},
  [1692] = {.lex_state = 13, .external_lex_state = 20},
  [1693] = {.lex_state = 14, .external_lex_state = 3},
  [1694] = {.lex_state = 11, .external_lex_state = 22},
  [1695] = {.lex_state = 14, .external_lex_state = 3},
  [1696] = {.lex_state = 12, .external_lex_state = 23},
  [1697] = {.lex_state = 12, .external_lex_state = 3},
  [1698] = {.lex_state = 12, .external_lex_state = 26},
  [1699] = {.lex_state = 14, .external_lex_state = 3},
  [1700] = {.lex_state = 14, .external_lex_state = 3},
  [1701] = {.lex_state = 13, .external_lex_state = 30},
  [1702] = {.lex_state = 13, .external_lex_state = 20},
  [1703] = {.lex_state = 12, .external_lex_state = 3},
  [1704] = {.lex_state = 14, .external_lex_state = 3},
  [1705] = {.lex_state = 13, .external_lex_state = 3},
  [1706] = {.lex_state = 12, .external_lex_state = 3},
  [1707] = {.lex_state = 12, .external_lex_state = 3},
  [1708] = {.lex_state = 14, .external_lex_state = 3},
  [1709] = {.lex_state = 13, .external_lex_state = 34},
  [1710] = {.lex_state = 14, .external_lex_state = 3},
  [1711] = {.lex_state = 14, .external_lex_state = 3},
  [1712] = {.lex_state = 14, .external_lex_state = 3},
  [1713] = {.lex_state = 14, .external_lex_state = 3},
  [1714] = {.lex_state = 14, .external_lex_state = 3},
  [1715] = {.lex_state = 14, .external_lex_state = 3},
  [1716] = {.lex_state = 14, .external_lex_state = 3},
  [1717] = {.lex_state = 12, .external_lex_state = 20},
  [1718] = {.lex_state = 13, .external_lex_state = 34},
  [1719] = {.lex_state = 14, .external_lex_state = 3},
  [1720] = {.lex_state = 11, .external_lex_state = 23},
  [1721] = {.lex_state = 13, .external_lex_state = 3},
  [1722] = {.lex_state = 14, .external_lex_state = 3},
  [1723] = {.lex_state = 12, .external_lex_state = 23},
  [1724] = {.lex_state = 11, .external_lex_state = 23},
  [1725] = {.lex_state = 11, .external_lex_state = 26},
  [1726] = {.lex_state = 12, .external_lex_state = 20},
  [1727] = {.lex_state = 11, .external_lex_state = 23},
  [1728] = {.lex_state = 11, .external_lex_state = 23},
  [1729] = {.lex_state = 11, .external_lex_state = 23},
  [1730] = {.lex_state = 11, .external_lex_state = 26},
  [1731] = {.lex_state = 11, .external_lex_state = 26},
  [1732] = {.lex_state = 11, .external_lex_state = 26},
  [1733] = {.lex_state = 11, .external_lex_state = 23},
  [1734] = {.lex_state = 14, .external_lex_state = 3},
  [1735] = {.lex_state = 13, .external_lex_state = 3},
  [1736] = {.lex_state = 12, .external_lex_state = 23},
  [1737] = {.lex_state = 12, .external_lex_state = 26},
  [1738] = {.lex_state = 14, .external_lex_state = 3},
  [1739] = {.lex_state = 13, .external_lex_state = 3},
  [1740] = {.lex_state = 17, .external_lex_state = 3},
  [1741] = {.lex_state = 14, .external_lex_state = 3},
  [1742] = {.lex_state = 13, .external_lex_state = 30},
  [1743] = {.lex_state = 12, .external_lex_state = 3},
  [1744] = {.lex_state = 13, .external_lex_state = 20},
  [1745] = {.lex_state = 11, .external_lex_state = 23},
  [1746] = {.lex_state = 12, .external_lex_state = 23},
  [1747] = {.lex_state = 12, .external_lex_state = 20},
  [1748] = {.lex_state = 13, .external_lex_state = 3},
  [1749] = {.lex_state = 17, .external_lex_state = 3},
  [1750] = {.lex_state = 14, .external_lex_state = 3},
  [1751] = {.lex_state = 12, .external_lex_state = 20},
  [1752] = {.lex_state = 14, .external_lex_state = 3},
  [1753] = {.lex_state = 17, .external_lex_state = 3},
  [1754] = {.lex_state = 12, .external_lex_state = 3},
  [1755] = {.lex_state = 14, .external_lex_state = 3},
  [1756] = {.lex_state = 12, .external_lex_state = 20},
  [1757] = {.lex_state = 12, .external_lex_state = 20},
  [1758] = {.lex_state = 14, .external_lex_state = 3},
  [1759] = {.lex_state = 12, .external_lex_state = 26},
  [1760] = {.lex_state = 12, .external_lex_state = 3},
  [1761] = {.lex_state = 13, .external_lex_state = 33},
  [1762] = {.lex_state = 16, .external_lex_state = 26},
  [1763] = {.lex_state = 11, .external_lex_state = 23},
  [1764] = {.lex_state = 12, .external_lex_state = 3},
  [1765] = {.lex_state = 12, .external_lex_state = 3},
  [1766] = {.lex_state = 12, .external_lex_state = 3},
  [1767] = {.lex_state = 12, .external_lex_state = 3},
  [1768] = {.lex_state = 11, .external_lex_state = 23},
  [1769] = {.lex_state = 12, .external_lex_state = 3},
  [1770] = {.lex_state = 17, .external_lex_state = 26},
  [1771] = {.lex_state = 12, .external_lex_state = 3},
  [1772] = {.lex_state = 14, .external_lex_state = 3},
  [1773] = {.lex_state = 14, .external_lex_state = 3},
  [1774] = {.lex_state = 18, .external_lex_state = 23},
  [1775] = {.lex_state = 14, .external_lex_state = 3},
  [1776] = {.lex_state = 14, .external_lex_state = 3},
  [1777] = {.lex_state = 14, .external_lex_state = 3},
  [1778] = {.lex_state = 14, .external_lex_state = 23},
  [1779] = {.lex_state = 14, .external_lex_state = 3},
  [1780] = {.lex_state = 14, .external_lex_state = 23},
  [1781] = {.lex_state = 18, .external_lex_state = 23},
  [1782] = {.lex_state = 14, .external_lex_state = 3},
  [1783] = {.lex_state = 14, .external_lex_state = 3},
  [1784] = {.lex_state = 11, .external_lex_state = 23},
  [1785] = {.lex_state = 16, .external_lex_state = 26},
  [1786] = {.lex_state = 16, .external_lex_state = 26},
  [1787] = {.lex_state = 13, .external_lex_state = 32},
  [1788] = {.lex_state = 13, .external_lex_state = 3},
  [1789] = {.lex_state = 12, .external_lex_state = 3},
  [1790] = {.lex_state = 12, .external_lex_state = 20},
  [1791] = {.lex_state = 14, .external_lex_state = 24},
  [1792] = {.lex_state = 14, .external_lex_state = 3},
  [1793] = {.lex_state = 14, .external_lex_state = 3},
  [1794] = {.lex_state = 12, .external_lex_state = 3},
  [1795] = {.lex_state = 12, .external_lex_state = 3},
  [1796] = {.lex_state = 14, .external_lex_state = 3},
  [1797] = {.lex_state = 11, .external_lex_state = 26},
  [1798] = {.lex_state = 12, .external_lex_state = 3},
  [1799] = {.lex_state = 12, .external_lex_state = 3},
  [1800] = {.lex_state = 12, .external_lex_state = 3},
  [1801] = {.lex_state = 12, .external_lex_state = 3},
  [1802] = {.lex_state = 14, .external_lex_state = 23},
  [1803] = {.lex_state = 12, .external_lex_state = 3},
  [1804] = {.lex_state = 12, .external_lex_state = 3},
  [1805] = {.lex_state = 12, .external_lex_state = 3},
  [1806] = {.lex_state = 12, .external_lex_state = 3},
  [1807] = {.lex_state = 12, .external_lex_state = 3},
  [1808] = {.lex_state = 12, .external_lex_state = 3},
  [1809] = {.lex_state = 12, .external_lex_state = 3},
  [1810] = {.lex_state = 12, .external_lex_state = 3},
  [1811] = {.lex_state = 16, .external_lex_state = 22},
  [1812] = {.lex_state = 11, .external_lex_state = 22},
  [1813] = {.lex_state = 12, .external_lex_state = 20},
  [1814] = {.lex_state = 12, .external_lex_state = 3},
  [1815] = {.lex_state = 13, .external_lex_state = 3},
  [1816] = {.lex_state = 12, .external_lex_state = 3},
  [1817] = {.lex_state = 12, .external_lex_state = 20},
  [1818] = {.lex_state = 12, .external_lex_state = 3},
  [1819] = {.lex_state = 12, .external_lex_state = 3},
  [1820] = {.lex_state = 12, .external_lex_state = 20},
  [1821] = {.lex_state = 12, .external_lex_state = 3},
  [1822] = {.lex_state = 17, .external_lex_state = 20},
  [1823] = {.lex_state = 16, .external_lex_state = 23},
  [1824] = {.lex_state = 18, .external_lex_state = 23},
  [1825] = {.lex_state = 12, .external_lex_state = 3},
  [1826] = {.lex_state = 12, .external_lex_state = 3},
  [1827] = {.lex_state = 17, .external_lex_state = 20},
  [1828] = {.lex_state = 13, .external_lex_state = 3},
  [1829] = {.lex_state = 12, .external_lex_state = 3},
  [1830] = {.lex_state = 13, .external_lex_state = 20},
  [1831] = {.lex_state = 11, .external_lex_state = 20},
  [1832] = {.lex_state = 12, .external_lex_state = 22},
  [1833] = {.lex_state = 17, .external_lex_state = 20},
  [1834] = {.lex_state = 13, .external_lex_state = 20},
  [1835] = {.lex_state = 12, .external_lex_state = 3},
  [1836] = {.lex_state = 14, .external_lex_state = 24},
  [1837] = {.lex_state = 12, .external_lex_state = 3},
  [1838] = {.lex_state = 13, .external_lex_state = 3},
  [1839] = {.lex_state = 11, .external_lex_state = 23},
  [1840] = {.lex_state = 17, .external_lex_state = 3},
  [1841] = {.lex_state = 12, .external_lex_state = 22},
  [1842] = {.lex_state = 11, .external_lex_state = 22},
  [1843] = {.lex_state = 13, .external_lex_state = 20},
  [1844] = {.lex_state = 14, .external_lex_state = 23},
  [1845] = {.lex_state = 11, .external_lex_state = 22},
  [1846] = {.lex_state = 11, .external_lex_state = 26},
  [1847] = {.lex_state = 14, .external_lex_state = 24},
  [1848] = {.lex_state = 7, .external_lex_state = 35},
  [1849] = {.lex_state = 12, .external_lex_state = 20},
  [1850] = {.lex_state = 12, .external_lex_state = 20},
  [1851] = {.lex_state = 12, .external_lex_state = 20},
  [1852] = {.lex_state = 11, .external_lex_state = 26},
  [1853] = {.lex_state = 11, .external_lex_state = 22},
  [1854] = {.lex_state = 11, .external_lex_state = 22},
  [1855] = {.lex_state = 12, .external_lex_state = 20},
  [1856] = {.lex_state = 11, .external_lex_state = 26},
  [1857] = {.lex_state = 11, .external_lex_state = 26},
  [1858] = {.lex_state = 11, .external_lex_state = 26},
  [1859] = {.lex_state = 11, .external_lex_state = 26},
  [1860] = {.lex_state = 11, .external_lex_state = 22},
  [1861] = {.lex_state = 11, .external_lex_state = 26},
  [1862] = {.lex_state = 12, .external_lex_state = 20},
  [1863] = {.lex_state = 11, .external_lex_state = 26},
  [1864] = {.lex_state = 12, .external_lex_state = 20},
  [1865] = {.lex_state = 12, .external_lex_state = 20},
  [1866] = {.lex_state = 12, .external_lex_state = 20},
  [1867] = {.lex_state = 12, .external_lex_state = 20},
  [1868] = {.lex_state = 12, .external_lex_state = 20},
  [1869] = {.lex_state = 12, .external_lex_state = 23},
  [1870] = {.lex_state = 12, .external_lex_state = 20},
  [1871] = {.lex_state = 12, .external_lex_state = 20},
  [1872] = {.lex_state = 12, .external_lex_state = 20},
  [1873] = {.lex_state = 12, .external_lex_state = 20},
  [1874] = {.lex_state = 12, .external_lex_state = 20},
  [1875] = {.lex_state = 14, .external_lex_state = 28},
  [1876] = {.lex_state = 12, .external_lex_state = 22},
  [1877] = {.lex_state = 13, .external_lex_state = 20},
  [1878] = {.lex_state = 11, .external_lex_state = 26},
  [1879] = {.lex_state = 11, .external_lex_state = 26},
  [1880] = {.lex_state = 12, .external_lex_state = 3},
  [1881] = {.lex_state = 11, .external_lex_state = 22},
  [1882] = {.lex_state = 13, .external_lex_state = 20},
  [1883] = {.lex_state = 18, .external_lex_state = 3},
  [1884] = {.lex_state = 7, .external_lex_state = 35},
  [1885] = {.lex_state = 7, .external_lex_state = 35},
  [1886] = {.lex_state = 11, .external_lex_state = 26},
  [1887] = {.lex_state = 11, .external_lex_state = 26},
  [1888] = {.lex_state = 12, .external_lex_state = 23},
  [1889] = {.lex_state = 12, .external_lex_state = 22},
  [1890] = {.lex_state = 11, .external_lex_state = 26},
  [1891] = {.lex_state = 11, .external_lex_state = 26},
  [1892] = {.lex_state = 11, .external_lex_state = 26},
  [1893] = {.lex_state = 11, .external_lex_state = 26},
  [1894] = {.lex_state = 11, .external_lex_state = 22},
  [1895] = {.lex_state = 11, .external_lex_state = 26},
  [1896] = {.lex_state = 11, .external_lex_state = 26},
  [1897] = {.lex_state = 11, .external_lex_state = 26},
  [1898] = {.lex_state = 11, .external_lex_state = 26},
  [1899] = {.lex_state = 11, .external_lex_state = 26},
  [1900] = {.lex_state = 11, .external_lex_state = 26},
  [1901] = {.lex_state = 11, .external_lex_state = 26},
  [1902] = {.lex_state = 11, .external_lex_state = 26},
  [1903] = {.lex_state = 14, .external_lex_state = 3},
  [1904] = {.lex_state = 12, .external_lex_state = 20},
  [1905] = {.lex_state = 11, .external_lex_state = 22},
  [1906] = {.lex_state = 11, .external_lex_state = 26},
  [1907] = {.lex_state = 12, .external_lex_state = 20},
  [1908] = {.lex_state = 11, .external_lex_state = 22},
  [1909] = {.lex_state = 11, .external_lex_state = 20},
  [1910] = {.lex_state = 11, .external_lex_state = 26},
  [1911] = {.lex_state = 11, .external_lex_state = 26},
  [1912] = {.lex_state = 12, .external_lex_state = 20},
  [1913] = {.lex_state = 11, .external_lex_state = 26},
  [1914] = {.lex_state = 12, .external_lex_state = 22},
  [1915] = {.lex_state = 12, .external_lex_state = 26},
  [1916] = {.lex_state = 12, .external_lex_state = 20},
  [1917] = {.lex_state = 11, .external_lex_state = 26},
  [1918] = {.lex_state = 11, .external_lex_state = 26},
  [1919] = {.lex_state = 12, .external_lex_state = 20},
  [1920] = {.lex_state = 12, .external_lex_state = 20},
  [1921] = {.lex_state = 11, .external_lex_state = 26},
  [1922] = {.lex_state = 13, .external_lex_state = 20},
  [1923] = {.lex_state = 11, .external_lex_state = 22},
  [1924] = {.lex_state = 16, .external_lex_state = 22},
  [1925] = {.lex_state = 14, .external_lex_state = 3},
  [1926] = {.lex_state = 12, .external_lex_state = 20},
  [1927] = {.lex_state = 11, .external_lex_state = 26},
  [1928] = {.lex_state = 12, .external_lex_state = 20},
  [1929] = {.lex_state = 11, .external_lex_state = 26},
  [1930] = {.lex_state = 16, .external_lex_state = 22},
  [1931] = {.lex_state = 11, .external_lex_state = 26},
  [1932] = {.lex_state = 18, .external_lex_state = 20},
  [1933] = {.lex_state = 12, .external_lex_state = 22},
  [1934] = {.lex_state = 12, .external_lex_state = 22},
  [1935] = {.lex_state = 12, .external_lex_state = 20},
  [1936] = {.lex_state = 11, .external_lex_state = 22},
  [1937] = {.lex_state = 16, .external_lex_state = 20},
  [1938] = {.lex_state = 12, .external_lex_state = 20},
  [1939] = {.lex_state = 11, .external_lex_state = 23},
  [1940] = {.lex_state = 16, .external_lex_state = 22},
  [1941] = {.lex_state = 14, .external_lex_state = 3},
  [1942] = {.lex_state = 12, .external_lex_state = 22},
  [1943] = {.lex_state = 12, .external_lex_state = 20},
  [1944] = {.lex_state = 11, .external_lex_state = 23},
  [1945] = {.lex_state = 17, .external_lex_state = 20},
  [1946] = {.lex_state = 13, .external_lex_state = 31},
  [1947] = {.lex_state = 12, .external_lex_state = 20},
  [1948] = {.lex_state = 11, .external_lex_state = 22},
  [1949] = {.lex_state = 11, .external_lex_state = 22},
  [1950] = {.lex_state = 11, .external_lex_state = 23},
  [1951] = {.lex_state = 11, .external_lex_state = 23},
  [1952] = {.lex_state = 12, .external_lex_state = 20},
  [1953] = {.lex_state = 12, .external_lex_state = 22},
  [1954] = {.lex_state = 12, .external_lex_state = 20},
  [1955] = {.lex_state = 11, .external_lex_state = 22},
  [1956] = {.lex_state = 11, .external_lex_state = 22},
  [1957] = {.lex_state = 11, .external_lex_state = 22},
  [1958] = {.lex_state = 12, .external_lex_state = 26},
  [1959] = {.lex_state = 11, .external_lex_state = 22},
  [1960] = {.lex_state = 11, .external_lex_state = 22},
  [1961] = {.lex_state = 11, .external_lex_state = 22},
  [1962] = {.lex_state = 11, .external_lex_state = 22},
  [1963] = {.lex_state = 12, .external_lex_state = 20},
  [1964] = {.lex_state = 11, .external_lex_state = 23},
  [1965] = {.lex_state = 12, .external_lex_state = 22},
  [1966] = {.lex_state = 11, .external_lex_state = 23},
  [1967] = {.lex_state = 11, .external_lex_state = 23},
  [1968] = {.lex_state = 11, .external_lex_state = 26},
  [1969] = {.lex_state = 11, .external_lex_state = 22},
  [1970] = {.lex_state = 12, .external_lex_state = 3},
  [1971] = {.lex_state = 11, .external_lex_state = 22},
  [1972] = {.lex_state = 11, .external_lex_state = 3},
  [1973] = {.lex_state = 11, .external_lex_state = 26},
  [1974] = {.lex_state = 14, .external_lex_state = 3},
  [1975] = {.lex_state = 14, .external_lex_state = 3},
  [1976] = {.lex_state = 16, .external_lex_state = 20},
  [1977] = {.lex_state = 12, .external_lex_state = 20},
  [1978] = {.lex_state = 11, .external_lex_state = 23},
  [1979] = {.lex_state = 11, .external_lex_state = 22},
  [1980] = {.lex_state = 11, .external_lex_state = 23},
  [1981] = {.lex_state = 12, .external_lex_state = 20},
  [1982] = {.lex_state = 11, .external_lex_state = 22},
  [1983] = {.lex_state = 11, .external_lex_state = 22},
  [1984] = {.lex_state = 11, .external_lex_state = 22},
  [1985] = {.lex_state = 11, .external_lex_state = 22},
  [1986] = {.lex_state = 18, .external_lex_state = 22},
  [1987] = {.lex_state = 11, .external_lex_state = 22},
  [1988] = {.lex_state = 14, .external_lex_state = 22},
  [1989] = {.lex_state = 11, .external_lex_state = 22},
  [1990] = {.lex_state = 11, .external_lex_state = 22},
  [1991] = {.lex_state = 11, .external_lex_state = 22},
  [1992] = {.lex_state = 11, .external_lex_state = 23},
  [1993] = {.lex_state = 12, .external_lex_state = 20},
  [1994] = {.lex_state = 12, .external_lex_state = 20},
  [1995] = {.lex_state = 11, .external_lex_state = 22},
  [1996] = {.lex_state = 12, .external_lex_state = 3},
  [1997] = {.lex_state = 12, .external_lex_state = 20},
  [1998] = {.lex_state = 16, .external_lex_state = 20},
  [1999] = {.lex_state = 12, .external_lex_state = 20},
  [2000] = {.lex_state = 11, .external_lex_state = 26},
  [2001] = {.lex_state = 14, .external_lex_state = 22},
  [2002] = {.lex_state = 13, .external_lex_state = 29},
  [2003] = {.lex_state = 18, .external_lex_state = 22},
  [2004] = {.lex_state = 11, .external_lex_state = 22},
  [2005] = {.lex_state = 11, .external_lex_state = 23},
  [2006] = {.lex_state = 12, .external_lex_state = 22},
  [2007] = {.lex_state = 17, .external_lex_state = 22},
  [2008] = {.lex_state = 12, .external_lex_state = 34},
  [2009] = {.lex_state = 11, .external_lex_state = 22},
  [2010] = {.lex_state = 14, .external_lex_state = 27},
  [2011] = {.lex_state = 12, .external_lex_state = 34},
  [2012] = {.lex_state = 12, .external_lex_state = 34},
  [2013] = {.lex_state = 12, .external_lex_state = 34},
  [2014] = {.lex_state = 14, .external_lex_state = 22},
  [2015] = {.lex_state = 12, .external_lex_state = 31},
  [2016] = {.lex_state = 12, .external_lex_state = 31},
  [2017] = {.lex_state = 13, .external_lex_state = 27},
  [2018] = {.lex_state = 14, .external_lex_state = 22},
  [2019] = {.lex_state = 13, .external_lex_state = 31},
  [2020] = {.lex_state = 13, .external_lex_state = 27},
  [2021] = {.lex_state = 12, .external_lex_state = 30},
  [2022] = {.lex_state = 12, .external_lex_state = 30},
  [2023] = {.lex_state = 13, .external_lex_state = 24},
  [2024] = {.lex_state = 12, .external_lex_state = 31},
  [2025] = {.lex_state = 13, .external_lex_state = 24},
  [2026] = {.lex_state = 18, .external_lex_state = 22},
  [2027] = {.lex_state = 13, .external_lex_state = 31},
  [2028] = {.lex_state = 16, .external_lex_state = 22},
  [2029] = {.lex_state = 12, .external_lex_state = 31},
  [2030] = {.lex_state = 11, .external_lex_state = 22},
  [2031] = {.lex_state = 14, .external_lex_state = 27},
  [2032] = {.lex_state = 7, .external_lex_state = 35},
  [2033] = {.lex_state = 14, .external_lex_state = 22},
  [2034] = {.lex_state = 14, .external_lex_state = 27},
  [2035] = {.lex_state = 13, .external_lex_state = 27},
  [2036] = {.lex_state = 11, .external_lex_state = 22},
  [2037] = {.lex_state = 13, .external_lex_state = 27},
  [2038] = {.lex_state = 12, .external_lex_state = 30},
  [2039] = {.lex_state = 12, .external_lex_state = 30},
  [2040] = {.lex_state = 11, .external_lex_state = 22},
  [2041] = {.lex_state = 11, .external_lex_state = 22},
  [2042] = {.lex_state = 11, .external_lex_state = 22},
  [2043] = {.lex_state = 11, .external_lex_state = 22},
  [2044] = {.lex_state = 13, .external_lex_state = 24},
  [2045] = {.lex_state = 11, .external_lex_state = 22},
  [2046] = {.lex_state = 12, .external_lex_state = 22},
  [2047] = {.lex_state = 11, .external_lex_state = 22},
  [2048] = {.lex_state = 14, .external_lex_state = 25},
  [2049] = {.lex_state = 14, .external_lex_state = 26},
  [2050] = {.lex_state = 18, .external_lex_state = 26},
  [2051] = {.lex_state = 14, .external_lex_state = 26},
  [2052] = {.lex_state = 14, .external_lex_state = 26},
  [2053] = {.lex_state = 18, .external_lex_state = 26},
  [2054] = {.lex_state = 14, .external_lex_state = 3},
  [2055] = {.lex_state = 14, .external_lex_state = 26},
  [2056] = {.lex_state = 14, .external_lex_state = 26},
  [2057] = {.lex_state = 18, .external_lex_state = 26},
  [2058] = {.lex_state = 16, .external_lex_state = 26},
  [2059] = {.lex_state = 11, .external_lex_state = 26},
  [2060] = {.lex_state = 13, .external_lex_state = 24},
  [2061] = {.lex_state = 12, .external_lex_state = 26},
  [2062] = {.lex_state = 17, .external_lex_state = 22},
  [2063] = {.lex_state = 13, .external_lex_state = 3},
  [2064] = {.lex_state = 13, .external_lex_state = 3},
  [2065] = {.lex_state = 13, .external_lex_state = 3},
  [2066] = {.lex_state = 14, .external_lex_state = 3},
  [2067] = {.lex_state = 13, .external_lex_state = 3},
  [2068] = {.lex_state = 14, .external_lex_state = 3},
  [2069] = {.lex_state = 14, .external_lex_state = 3},
  [2070] = {.lex_state = 14, .external_lex_state = 3},
  [2071] = {.lex_state = 18, .external_lex_state = 20},
  [2072] = {.lex_state = 17, .external_lex_state = 22},
  [2073] = {.lex_state = 18, .external_lex_state = 20},
  [2074] = {.lex_state = 14, .external_lex_state = 20},
  [2075] = {.lex_state = 12, .external_lex_state = 23},
  [2076] = {.lex_state = 18, .external_lex_state = 20},
  [2077] = {.lex_state = 14, .external_lex_state = 20},
  [2078] = {.lex_state = 14, .external_lex_state = 30},
  [2079] = {.lex_state = 14, .external_lex_state = 3},
  [2080] = {.lex_state = 14, .external_lex_state = 30},
  [2081] = {.lex_state = 14, .external_lex_state = 3},
  [2082] = {.lex_state = 14, .external_lex_state = 3},
  [2083] = {.lex_state = 12, .external_lex_state = 20},
  [2084] = {.lex_state = 14, .external_lex_state = 30},
  [2085] = {.lex_state = 14, .external_lex_state = 20},
  [2086] = {.lex_state = 12, .external_lex_state = 23},
  [2087] = {.lex_state = 13, .external_lex_state = 3},
  [2088] = {.lex_state = 12, .external_lex_state = 23},
  [2089] = {.lex_state = 12, .external_lex_state = 23},
  [2090] = {.lex_state = 12, .external_lex_state = 23},
  [2091] = {.lex_state = 13, .external_lex_state = 20},
  [2092] = {.lex_state = 13, .external_lex_state = 3},
  [2093] = {.lex_state = 11, .external_lex_state = 20},
  [2094] = {.lex_state = 14, .external_lex_state = 3},
  [2095] = {.lex_state = 14, .external_lex_state = 32},
  [2096] = {.lex_state = 18, .external_lex_state = 23},
  [2097] = {.lex_state = 12, .external_lex_state = 23},
  [2098] = {.lex_state = 6, .external_lex_state = 36},
  [2099] = {.lex_state = 13, .external_lex_state = 20},
  [2100] = {.lex_state = 13, .external_lex_state = 26},
  [2101] = {.lex_state = 17, .external_lex_state = 26},
  [2102] = {.lex_state = 12, .external_lex_state = 3},
  [2103] = {.lex_state = 6, .external_lex_state = 36},
  [2104] = {.lex_state = 13, .external_lex_state = 3},
  [2105] = {.lex_state = 13, .external_lex_state = 26},
  [2106] = {.lex_state = 14, .external_lex_state = 20},
  [2107] = {.lex_state = 14, .external_lex_state = 20},
  [2108] = {.lex_state = 13, .external_lex_state = 3},
  [2109] = {.lex_state = 14, .external_lex_state = 20},
  [2110] = {.lex_state = 13, .external_lex_state = 26},
  [2111] = {.lex_state = 13, .external_lex_state = 26},
  [2112] = {.lex_state = 14, .external_lex_state = 20},
  [2113] = {.lex_state = 14, .external_lex_state = 20},
  [2114] = {.lex_state = 13, .external_lex_state = 26},
  [2115] = {.lex_state = 18, .external_lex_state = 3},
  [2116] = {.lex_state = 12, .external_lex_state = 23},
  [2117] = {.lex_state = 13, .external_lex_state = 3},
  [2118] = {.lex_state = 13, .external_lex_state = 26},
  [2119] = {.lex_state = 13, .external_lex_state = 20},
  [2120] = {.lex_state = 14, .external_lex_state = 3},
  [2121] = {.lex_state = 12, .external_lex_state = 23},
  [2122] = {.lex_state = 13, .external_lex_state = 20},
  [2123] = {.lex_state = 13, .external_lex_state = 20},
  [2124] = {.lex_state = 13, .external_lex_state = 20},
  [2125] = {.lex_state = 13, .external_lex_state = 20},
  [2126] = {.lex_state = 18, .external_lex_state = 3},
  [2127] = {.lex_state = 14, .external_lex_state = 20},
  [2128] = {.lex_state = 13, .external_lex_state = 3},
  [2129] = {.lex_state = 13, .external_lex_state = 3},
  [2130] = {.lex_state = 13, .external_lex_state = 3},
  [2131] = {.lex_state = 13, .external_lex_state = 3},
  [2132] = {.lex_state = 13, .external_lex_state = 3},
  [2133] = {.lex_state = 13, .external_lex_state = 3},
  [2134] = {.lex_state = 13, .external_lex_state = 3},
  [2135] = {.lex_state = 14, .external_lex_state = 20},
  [2136] = {.lex_state = 13, .external_lex_state = 3},
  [2137] = {.lex_state = 13, .external_lex_state = 3},
  [2138] = {.lex_state = 13, .external_lex_state = 3},
  [2139] = {.lex_state = 13, .external_lex_state = 3},
  [2140] = {.lex_state = 8, .external_lex_state = 37},
  [2141] = {.lex_state = 12, .external_lex_state = 22},
  [2142] = {.lex_state = 13, .external_lex_state = 3},
  [2143] = {.lex_state = 13, .external_lex_state = 3},
  [2144] = {.lex_state = 13, .external_lex_state = 3},
  [2145] = {.lex_state = 13, .external_lex_state = 3},
  [2146] = {.lex_state = 13, .external_lex_state = 3},
  [2147] = {.lex_state = 13, .external_lex_state = 3},
  [2148] = {.lex_state = 13, .external_lex_state = 3},
  [2149] = {.lex_state = 13, .external_lex_state = 3},
  [2150] = {.lex_state = 13, .external_lex_state = 3},
  [2151] = {.lex_state = 13, .external_lex_state = 3},
  [2152] = {.lex_state = 13, .external_lex_state = 3},
  [2153] = {.lex_state = 13, .external_lex_state = 3},
  [2154] = {.lex_state = 13, .external_lex_state = 3},
  [2155] = {.lex_state = 13, .external_lex_state = 3},
  [2156] = {.lex_state = 13, .external_lex_state = 3},
  [2157] = {.lex_state = 12, .external_lex_state = 22},
  [2158] = {.lex_state = 13, .external_lex_state = 26},
  [2159] = {.lex_state = 12, .external_lex_state = 22},
  [2160] = {.lex_state = 12, .external_lex_state = 22},
  [2161] = {.lex_state = 12, .external_lex_state = 22},
  [2162] = {.lex_state = 13, .external_lex_state = 3},
  [2163] = {.lex_state = 13, .external_lex_state = 3},
  [2164] = {.lex_state = 13, .external_lex_state = 3},
  [2165] = {.lex_state = 13, .external_lex_state = 3},
  [2166] = {.lex_state = 13, .external_lex_state = 3},
  [2167] = {.lex_state = 13, .external_lex_state = 3},
  [2168] = {.lex_state = 12, .external_lex_state = 22},
  [2169] = {.lex_state = 12, .external_lex_state = 23},
  [2170] = {.lex_state = 13, .external_lex_state = 3},
  [2171] = {.lex_state = 14, .external_lex_state = 3},
  [2172] = {.lex_state = 18, .external_lex_state = 3},
  [2173] = {.lex_state = 12, .external_lex_state = 23},
  [2174] = {.lex_state = 13, .external_lex_state = 23},
  [2175] = {.lex_state = 12, .external_lex_state = 23},
  [2176] = {.lex_state = 12, .external_lex_state = 23},
  [2177] = {.lex_state = 12, .external_lex_state = 23},
  [2178] = {.lex_state = 13, .external_lex_state = 23},
  [2179] = {.lex_state = 12, .external_lex_state = 23},
  [2180] = {.lex_state = 12, .external_lex_state = 23},
  [2181] = {.lex_state = 12, .external_lex_state = 23},
  [2182] = {.lex_state = 18, .external_lex_state = 20},
  [2183] = {.lex_state = 12, .external_lex_state = 23},
  [2184] = {.lex_state = 12, .external_lex_state = 23},
  [2185] = {.lex_state = 12, .external_lex_state = 23},
  [2186] = {.lex_state = 13, .external_lex_state = 23},
  [2187] = {.lex_state = 12, .external_lex_state = 23},
  [2188] = {.lex_state = 17, .external_lex_state = 23},
  [2189] = {.lex_state = 13, .external_lex_state = 20},
  [2190] = {.lex_state = 18, .external_lex_state = 3},
  [2191] = {.lex_state = 12, .external_lex_state = 23},
  [2192] = {.lex_state = 12, .external_lex_state = 23},
  [2193] = {.lex_state = 12, .external_lex_state = 23},
  [2194] = {.lex_state = 12, .external_lex_state = 23},
  [2195] = {.lex_state = 12, .external_lex_state = 23},
  [2196] = {.lex_state = 12, .external_lex_state = 23},
  [2197] = {.lex_state = 12, .external_lex_state = 23},
  [2198] = {.lex_state = 12, .external_lex_state = 23},
  [2199] = {.lex_state = 12, .external_lex_state = 23},
  [2200] = {.lex_state = 12, .external_lex_state = 23},
  [2201] = {.lex_state = 12, .external_lex_state = 23},
  [2202] = {.lex_state = 12, .external_lex_state = 23},
  [2203] = {.lex_state = 12, .external_lex_state = 23},
  [2204] = {.lex_state = 12, .external_lex_state = 26},
  [2205] = {.lex_state = 12, .external_lex_state = 23},
  [2206] = {.lex_state = 13, .external_lex_state = 23},
  [2207] = {.lex_state = 12, .external_lex_state = 26},
  [2208] = {.lex_state = 13, .external_lex_state = 20},
  [2209] = {.lex_state = 12, .external_lex_state = 26},
  [2210] = {.lex_state = 12, .external_lex_state = 26},
  [2211] = {.lex_state = 12, .external_lex_state = 26},
  [2212] = {.lex_state = 12, .external_lex_state = 26},
  [2213] = {.lex_state = 13, .external_lex_state = 26},
  [2214] = {.lex_state = 12, .external_lex_state = 23},
  [2215] = {.lex_state = 12, .external_lex_state = 23},
  [2216] = {.lex_state = 12, .external_lex_state = 23},
  [2217] = {.lex_state = 12, .external_lex_state = 23},
  [2218] = {.lex_state = 12, .external_lex_state = 23},
  [2219] = {.lex_state = 12, .external_lex_state = 23},
  [2220] = {.lex_state = 8, .external_lex_state = 37},
  [2221] = {.lex_state = 12, .external_lex_state = 23},
  [2222] = {.lex_state = 12, .external_lex_state = 23},
  [2223] = {.lex_state = 17, .external_lex_state = 23},
  [2224] = {.lex_state = 8, .external_lex_state = 37},
  [2225] = {.lex_state = 12, .external_lex_state = 26},
  [2226] = {.lex_state = 17, .external_lex_state = 23},
  [2227] = {.lex_state = 13, .external_lex_state = 23},
  [2228] = {.lex_state = 11, .external_lex_state = 26},
  [2229] = {.lex_state = 12, .external_lex_state = 26},
  [2230] = {.lex_state = 14, .external_lex_state = 31},
  [2231] = {.lex_state = 17, .external_lex_state = 23},
  [2232] = {.lex_state = 13, .external_lex_state = 23},
  [2233] = {.lex_state = 12, .external_lex_state = 26},
  [2234] = {.lex_state = 13, .external_lex_state = 23},
  [2235] = {.lex_state = 12, .external_lex_state = 26},
  [2236] = {.lex_state = 12, .external_lex_state = 26},
  [2237] = {.lex_state = 12, .external_lex_state = 26},
  [2238] = {.lex_state = 12, .external_lex_state = 26},
  [2239] = {.lex_state = 12, .external_lex_state = 26},
  [2240] = {.lex_state = 12, .external_lex_state = 26},
  [2241] = {.lex_state = 12, .external_lex_state = 26},
  [2242] = {.lex_state = 14, .external_lex_state = 31},
  [2243] = {.lex_state = 13, .external_lex_state = 23},
  [2244] = {.lex_state = 12, .external_lex_state = 22},
  [2245] = {.lex_state = 12, .external_lex_state = 26},
  [2246] = {.lex_state = 6, .external_lex_state = 36},
  [2247] = {.lex_state = 12, .external_lex_state = 26},
  [2248] = {.lex_state = 12, .external_lex_state = 26},
  [2249] = {.lex_state = 14, .external_lex_state = 27},
  [2250] = {.lex_state = 12, .external_lex_state = 26},
  [2251] = {.lex_state = 12, .external_lex_state = 26},
  [2252] = {.lex_state = 6, .external_lex_state = 36},
  [2253] = {.lex_state = 12, .external_lex_state = 26},
  [2254] = {.lex_state = 12, .external_lex_state = 26},
  [2255] = {.lex_state = 13, .external_lex_state = 26},
  [2256] = {.lex_state = 17, .external_lex_state = 26},
  [2257] = {.lex_state = 12, .external_lex_state = 26},
  [2258] = {.lex_state = 13, .external_lex_state = 26},
  [2259] = {.lex_state = 13, .external_lex_state = 23},
  [2260] = {.lex_state = 17, .external_lex_state = 26},
  [2261] = {.lex_state = 17, .external_lex_state = 26},
  [2262] = {.lex_state = 14, .external_lex_state = 31},
  [2263] = {.lex_state = 12, .external_lex_state = 22},
  [2264] = {.lex_state = 5, .external_lex_state = 35},
  [2265] = {.lex_state = 18, .external_lex_state = 26},
  [2266] = {.lex_state = 13, .external_lex_state = 23},
  [2267] = {.lex_state = 14, .external_lex_state = 33},
  [2268] = {.lex_state = 12, .external_lex_state = 26},
  [2269] = {.lex_state = 12, .external_lex_state = 26},
  [2270] = {.lex_state = 14, .external_lex_state = 34},
  [2271] = {.lex_state = 13, .external_lex_state = 20},
  [2272] = {.lex_state = 6, .external_lex_state = 36},
  [2273] = {.lex_state = 11, .external_lex_state = 22},
  [2274] = {.lex_state = 12, .external_lex_state = 26},
  [2275] = {.lex_state = 12, .external_lex_state = 26},
  [2276] = {.lex_state = 14, .external_lex_state = 27},
  [2277] = {.lex_state = 13, .external_lex_state = 3},
  [2278] = {.lex_state = 13, .external_lex_state = 20},
  [2279] = {.lex_state = 13, .external_lex_state = 20},
  [2280] = {.lex_state = 13, .external_lex_state = 20},
  [2281] = {.lex_state = 13, .external_lex_state = 20},
  [2282] = {.lex_state = 13, .external_lex_state = 20},
  [2283] = {.lex_state = 13, .external_lex_state = 20},
  [2284] = {.lex_state = 13, .external_lex_state = 20},
  [2285] = {.lex_state = 14, .external_lex_state = 29},
  [2286] = {.lex_state = 13, .external_lex_state = 20},
  [2287] = {.lex_state = 13, .external_lex_state = 20},
  [2288] = {.lex_state = 13, .external_lex_state = 20},
  [2289] = {.lex_state = 13, .external_lex_state = 20},
  [2290] = {.lex_state = 18, .external_lex_state = 22},
  [2291] = {.lex_state = 14, .external_lex_state = 34},
  [2292] = {.lex_state = 13, .external_lex_state = 20},
  [2293] = {.lex_state = 13, .external_lex_state = 20},
  [2294] = {.lex_state = 13, .external_lex_state = 20},
  [2295] = {.lex_state = 13, .external_lex_state = 20},
  [2296] = {.lex_state = 13, .external_lex_state = 20},
  [2297] = {.lex_state = 13, .external_lex_state = 20},
  [2298] = {.lex_state = 13, .external_lex_state = 20},
  [2299] = {.lex_state = 13, .external_lex_state = 20},
  [2300] = {.lex_state = 13, .external_lex_state = 20},
  [2301] = {.lex_state = 13, .external_lex_state = 20},
  [2302] = {.lex_state = 12, .external_lex_state = 26},
  [2303] = {.lex_state = 13, .external_lex_state = 20},
  [2304] = {.lex_state = 5, .external_lex_state = 35},
  [2305] = {.lex_state = 13, .external_lex_state = 20},
  [2306] = {.lex_state = 13, .external_lex_state = 20},
  [2307] = {.lex_state = 13, .external_lex_state = 20},
  [2308] = {.lex_state = 13, .external_lex_state = 20},
  [2309] = {.lex_state = 5, .external_lex_state = 35},
  [2310] = {.lex_state = 12, .external_lex_state = 26},
  [2311] = {.lex_state = 12, .external_lex_state = 26},
  [2312] = {.lex_state = 14, .external_lex_state = 34},
  [2313] = {.lex_state = 12, .external_lex_state = 22},
  [2314] = {.lex_state = 12, .external_lex_state = 26},
  [2315] = {.lex_state = 13, .external_lex_state = 20},
  [2316] = {.lex_state = 13, .external_lex_state = 20},
  [2317] = {.lex_state = 12, .external_lex_state = 26},
  [2318] = {.lex_state = 13, .external_lex_state = 20},
  [2319] = {.lex_state = 13, .external_lex_state = 3},
  [2320] = {.lex_state = 12, .external_lex_state = 23},
  [2321] = {.lex_state = 13, .external_lex_state = 20},
  [2322] = {.lex_state = 12, .external_lex_state = 26},
  [2323] = {.lex_state = 13, .external_lex_state = 20},
  [2324] = {.lex_state = 13, .external_lex_state = 20},
  [2325] = {.lex_state = 12, .external_lex_state = 20},
  [2326] = {.lex_state = 13, .external_lex_state = 20},
  [2327] = {.lex_state = 13, .external_lex_state = 20},
  [2328] = {.lex_state = 13, .external_lex_state = 20},
  [2329] = {.lex_state = 12, .external_lex_state = 22},
  [2330] = {.lex_state = 12, .external_lex_state = 22},
  [2331] = {.lex_state = 13, .external_lex_state = 22},
  [2332] = {.lex_state = 12, .external_lex_state = 26},
  [2333] = {.lex_state = 12, .external_lex_state = 22},
  [2334] = {.lex_state = 12, .external_lex_state = 22},
  [2335] = {.lex_state = 13, .external_lex_state = 22},
  [2336] = {.lex_state = 12, .external_lex_state = 22},
  [2337] = {.lex_state = 12, .external_lex_state = 22},
  [2338] = {.lex_state = 12, .external_lex_state = 22},
  [2339] = {.lex_state = 12, .external_lex_state = 22},
  [2340] = {.lex_state = 12, .external_lex_state = 22},
  [2341] = {.lex_state = 12, .external_lex_state = 22},
  [2342] = {.lex_state = 13, .external_lex_state = 22},
  [2343] = {.lex_state = 12, .external_lex_state = 22},
  [2344] = {.lex_state = 12, .external_lex_state = 26},
  [2345] = {.lex_state = 12, .external_lex_state = 22},
  [2346] = {.lex_state = 12, .external_lex_state = 22},
  [2347] = {.lex_state = 12, .external_lex_state = 22},
  [2348] = {.lex_state = 12, .external_lex_state = 22},
  [2349] = {.lex_state = 12, .external_lex_state = 22},
  [2350] = {.lex_state = 12, .external_lex_state = 22},
  [2351] = {.lex_state = 14, .external_lex_state = 24},
  [2352] = {.lex_state = 12, .external_lex_state = 22},
  [2353] = {.lex_state = 12, .external_lex_state = 22},
  [2354] = {.lex_state = 14, .external_lex_state = 27},
  [2355] = {.lex_state = 14, .external_lex_state = 24},
  [2356] = {.lex_state = 12, .external_lex_state = 22},
  [2357] = {.lex_state = 14, .external_lex_state = 27},
  [2358] = {.lex_state = 12, .external_lex_state = 22},
  [2359] = {.lex_state = 12, .external_lex_state = 22},
  [2360] = {.lex_state = 12, .external_lex_state = 22},
  [2361] = {.lex_state = 12, .external_lex_state = 22},
  [2362] = {.lex_state = 12, .external_lex_state = 22},
  [2363] = {.lex_state = 12, .external_lex_state = 26},
  [2364] = {.lex_state = 12, .external_lex_state = 22},
  [2365] = {.lex_state = 13, .external_lex_state = 22},
  [2366] = {.lex_state = 12, .external_lex_state = 26},
  [2367] = {.lex_state = 6, .external_lex_state = 36},
  [2368] = {.lex_state = 13, .external_lex_state = 22},
  [2369] = {.lex_state = 12, .external_lex_state = 26},
  [2370] = {.lex_state = 13, .external_lex_state = 22},
  [2371] = {.lex_state = 12, .external_lex_state = 26},
  [2372] = {.lex_state = 12, .external_lex_state = 26},
  [2373] = {.lex_state = 12, .external_lex_state = 22},
  [2374] = {.lex_state = 12, .external_lex_state = 22},
  [2375] = {.lex_state = 12, .external_lex_state = 22},
  [2376] = {.lex_state = 12, .external_lex_state = 22},
  [2377] = {.lex_state = 13, .external_lex_state = 34},
  [2378] = {.lex_state = 12, .external_lex_state = 22},
  [2379] = {.lex_state = 12, .external_lex_state = 22},
  [2380] = {.lex_state = 13, .external_lex_state = 34},
  [2381] = {.lex_state = 12, .external_lex_state = 26},
  [2382] = {.lex_state = 12, .external_lex_state = 22},
  [2383] = {.lex_state = 14, .external_lex_state = 24},
  [2384] = {.lex_state = 12, .external_lex_state = 22},
  [2385] = {.lex_state = 14, .external_lex_state = 24},
  [2386] = {.lex_state = 13, .external_lex_state = 22},
  [2387] = {.lex_state = 13, .external_lex_state = 30},
  [2388] = {.lex_state = 13, .external_lex_state = 30},
  [2389] = {.lex_state = 17, .external_lex_state = 22},
  [2390] = {.lex_state = 13, .external_lex_state = 30},
  [2391] = {.lex_state = 13, .external_lex_state = 34},
  [2392] = {.lex_state = 11, .external_lex_state = 23},
  [2393] = {.lex_state = 13, .external_lex_state = 34},
  [2394] = {.lex_state = 13, .external_lex_state = 31},
  [2395] = {.lex_state = 17, .external_lex_state = 22},
  [2396] = {.lex_state = 13, .external_lex_state = 31},
  [2397] = {.lex_state = 13, .external_lex_state = 22},
  [2398] = {.lex_state = 13, .external_lex_state = 22},
  [2399] = {.lex_state = 13, .external_lex_state = 31},
  [2400] = {.lex_state = 13, .external_lex_state = 30},
  [2401] = {.lex_state = 13, .external_lex_state = 31},
  [2402] = {.lex_state = 13, .external_lex_state = 22},
  [2403] = {.lex_state = 13, .external_lex_state = 26},
  [2404] = {.lex_state = 14, .external_lex_state = 20},
  [2405] = {.lex_state = 14, .external_lex_state = 34},
  [2406] = {.lex_state = 7, .external_lex_state = 36},
  [2407] = {.lex_state = 14, .external_lex_state = 34},
  [2408] = {.lex_state = 14, .external_lex_state = 3},
  [2409] = {.lex_state = 14, .external_lex_state = 20},
  [2410] = {.lex_state = 13, .external_lex_state = 22},
  [2411] = {.lex_state = 14, .external_lex_state = 34},
  [2412] = {.lex_state = 13, .external_lex_state = 22},
  [2413] = {.lex_state = 14, .external_lex_state = 34},
  [2414] = {.lex_state = 13, .external_lex_state = 22},
  [2415] = {.lex_state = 13, .external_lex_state = 22},
  [2416] = {.lex_state = 14, .external_lex_state = 3},
  [2417] = {.lex_state = 14, .external_lex_state = 20},
  [2418] = {.lex_state = 13, .external_lex_state = 22},
  [2419] = {.lex_state = 13, .external_lex_state = 22},
  [2420] = {.lex_state = 13, .external_lex_state = 22},
  [2421] = {.lex_state = 13, .external_lex_state = 22},
  [2422] = {.lex_state = 13, .external_lex_state = 22},
  [2423] = {.lex_state = 13, .external_lex_state = 22},
  [2424] = {.lex_state = 13, .external_lex_state = 22},
  [2425] = {.lex_state = 14, .external_lex_state = 20},
  [2426] = {.lex_state = 13, .external_lex_state = 26},
  [2427] = {.lex_state = 13, .external_lex_state = 22},
  [2428] = {.lex_state = 13, .external_lex_state = 22},
  [2429] = {.lex_state = 13, .external_lex_state = 22},
  [2430] = {.lex_state = 13, .external_lex_state = 22},
  [2431] = {.lex_state = 13, .external_lex_state = 22},
  [2432] = {.lex_state = 13, .external_lex_state = 22},
  [2433] = {.lex_state = 13, .external_lex_state = 22},
  [2434] = {.lex_state = 13, .external_lex_state = 22},
  [2435] = {.lex_state = 13, .external_lex_state = 22},
  [2436] = {.lex_state = 13, .external_lex_state = 22},
  [2437] = {.lex_state = 13, .external_lex_state = 22},
  [2438] = {.lex_state = 13, .external_lex_state = 22},
  [2439] = {.lex_state = 13, .external_lex_state = 22},
  [2440] = {.lex_state = 13, .external_lex_state = 22},
  [2441] = {.lex_state = 13, .external_lex_state = 22},
  [2442] = {.lex_state = 13, .external_lex_state = 26},
  [2443] = {.lex_state = 14, .external_lex_state = 3},
  [2444] = {.lex_state = 13, .external_lex_state = 26},
  [2445] = {.lex_state = 13, .external_lex_state = 26},
  [2446] = {.lex_state = 13, .external_lex_state = 26},
  [2447] = {.lex_state = 13, .external_lex_state = 26},
  [2448] = {.lex_state = 13, .external_lex_state = 22},
  [2449] = {.lex_state = 13, .external_lex_state = 22},
  [2450] = {.lex_state = 7, .external_lex_state = 36},
  [2451] = {.lex_state = 13, .external_lex_state = 22},
  [2452] = {.lex_state = 13, .external_lex_state = 22},
  [2453] = {.lex_state = 13, .external_lex_state = 22},
  [2454] = {.lex_state = 14, .external_lex_state = 31},
  [2455] = {.lex_state = 14, .external_lex_state = 3},
  [2456] = {.lex_state = 14, .external_lex_state = 3},
  [2457] = {.lex_state = 14, .external_lex_state = 3},
  [2458] = {.lex_state = 14, .external_lex_state = 20},
  [2459] = {.lex_state = 13, .external_lex_state = 26},
  [2460] = {.lex_state = 14, .external_lex_state = 3},
  [2461] = {.lex_state = 13, .external_lex_state = 26},
  [2462] = {.lex_state = 13, .external_lex_state = 22},
  [2463] = {.lex_state = 13, .external_lex_state = 22},
  [2464] = {.lex_state = 14, .external_lex_state = 20},
  [2465] = {.lex_state = 14, .external_lex_state = 30},
  [2466] = {.lex_state = 7, .external_lex_state = 36},
  [2467] = {.lex_state = 14, .external_lex_state = 20},
  [2468] = {.lex_state = 14, .external_lex_state = 3},
  [2469] = {.lex_state = 14, .external_lex_state = 20},
  [2470] = {.lex_state = 14, .external_lex_state = 3},
  [2471] = {.lex_state = 14, .external_lex_state = 3},
  [2472] = {.lex_state = 14, .external_lex_state = 3},
  [2473] = {.lex_state = 13, .external_lex_state = 23},
  [2474] = {.lex_state = 14, .external_lex_state = 3},
  [2475] = {.lex_state = 14, .external_lex_state = 3},
  [2476] = {.lex_state = 14, .external_lex_state = 3},
  [2477] = {.lex_state = 14, .external_lex_state = 20},
  [2478] = {.lex_state = 14, .external_lex_state = 3},
  [2479] = {.lex_state = 14, .external_lex_state = 3},
  [2480] = {.lex_state = 14, .external_lex_state = 3},
  [2481] = {.lex_state = 14, .external_lex_state = 3},
  [2482] = {.lex_state = 14, .external_lex_state = 3},
  [2483] = {.lex_state = 14, .external_lex_state = 3},
  [2484] = {.lex_state = 14, .external_lex_state = 3},
  [2485] = {.lex_state = 11, .external_lex_state = 20},
  [2486] = {.lex_state = 14, .external_lex_state = 20},
  [2487] = {.lex_state = 14, .external_lex_state = 20},
  [2488] = {.lex_state = 12, .external_lex_state = 23},
  [2489] = {.lex_state = 14, .external_lex_state = 3},
  [2490] = {.lex_state = 11, .external_lex_state = 20},
  [2491] = {.lex_state = 13, .external_lex_state = 26},
  [2492] = {.lex_state = 14, .external_lex_state = 20},
  [2493] = {.lex_state = 13, .external_lex_state = 26},
  [2494] = {.lex_state = 13, .external_lex_state = 26},
  [2495] = {.lex_state = 14, .external_lex_state = 20},
  [2496] = {.lex_state = 13, .external_lex_state = 23},
  [2497] = {.lex_state = 14, .external_lex_state = 20},
  [2498] = {.lex_state = 13, .external_lex_state = 23},
  [2499] = {.lex_state = 14, .external_lex_state = 20},
  [2500] = {.lex_state = 14, .external_lex_state = 20},
  [2501] = {.lex_state = 13, .external_lex_state = 26},
  [2502] = {.lex_state = 14, .external_lex_state = 20},
  [2503] = {.lex_state = 14, .external_lex_state = 22},
  [2504] = {.lex_state = 18, .external_lex_state = 23},
  [2505] = {.lex_state = 18, .external_lex_state = 22},
  [2506] = {.lex_state = 13, .external_lex_state = 26},
  [2507] = {.lex_state = 14, .external_lex_state = 3},
  [2508] = {.lex_state = 14, .external_lex_state = 3},
  [2509] = {.lex_state = 14, .external_lex_state = 20},
  [2510] = {.lex_state = 12, .external_lex_state = 22},
  [2511] = {.lex_state = 14, .external_lex_state = 20},
  [2512] = {.lex_state = 7, .external_lex_state = 36},
  [2513] = {.lex_state = 14, .external_lex_state = 20},
  [2514] = {.lex_state = 13, .external_lex_state = 23},
  [2515] = {.lex_state = 14, .external_lex_state = 23},
  [2516] = {.lex_state = 13, .external_lex_state = 23},
  [2517] = {.lex_state = 13, .external_lex_state = 23},
  [2518] = {.lex_state = 13, .external_lex_state = 26},
  [2519] = {.lex_state = 11, .external_lex_state = 20},
  [2520] = {.lex_state = 14, .external_lex_state = 3},
  [2521] = {.lex_state = 13, .external_lex_state = 26},
  [2522] = {.lex_state = 14, .external_lex_state = 3},
  [2523] = {.lex_state = 14, .external_lex_state = 3},
  [2524] = {.lex_state = 13, .external_lex_state = 26},
  [2525] = {.lex_state = 13, .external_lex_state = 22},
  [2526] = {.lex_state = 7, .external_lex_state = 36},
  [2527] = {.lex_state = 13, .external_lex_state = 22},
  [2528] = {.lex_state = 14, .external_lex_state = 3},
  [2529] = {.lex_state = 13, .external_lex_state = 22},
  [2530] = {.lex_state = 13, .external_lex_state = 26},
  [2531] = {.lex_state = 14, .external_lex_state = 20},
  [2532] = {.lex_state = 13, .external_lex_state = 26},
  [2533] = {.lex_state = 13, .external_lex_state = 23},
  [2534] = {.lex_state = 14, .external_lex_state = 20},
  [2535] = {.lex_state = 13, .external_lex_state = 23},
  [2536] = {.lex_state = 14, .external_lex_state = 3},
  [2537] = {.lex_state = 14, .external_lex_state = 3},
  [2538] = {.lex_state = 14, .external_lex_state = 3},
  [2539] = {.lex_state = 14, .external_lex_state = 3},
  [2540] = {.lex_state = 6, .external_lex_state = 38},
  [2541] = {.lex_state = 13, .external_lex_state = 26},
  [2542] = {.lex_state = 11, .external_lex_state = 20},
  [2543] = {.lex_state = 13, .external_lex_state = 26},
  [2544] = {.lex_state = 12, .external_lex_state = 20},
  [2545] = {.lex_state = 13, .external_lex_state = 26},
  [2546] = {.lex_state = 14, .external_lex_state = 20},
  [2547] = {.lex_state = 14, .external_lex_state = 22},
  [2548] = {.lex_state = 11, .external_lex_state = 20},
  [2549] = {.lex_state = 14, .external_lex_state = 3},
  [2550] = {.lex_state = 14, .external_lex_state = 3},
  [2551] = {.lex_state = 18, .external_lex_state = 22},
  [2552] = {.lex_state = 18, .external_lex_state = 26},
  [2553] = {.lex_state = 14, .external_lex_state = 20},
  [2554] = {.lex_state = 14, .external_lex_state = 26},
  [2555] = {.lex_state = 14, .external_lex_state = 30},
  [2556] = {.lex_state = 14, .external_lex_state = 20},
  [2557] = {.lex_state = 14, .external_lex_state = 30},
  [2558] = {.lex_state = 14, .external_lex_state = 20},
  [2559] = {.lex_state = 14, .external_lex_state = 26},
  [2560] = {.lex_state = 14, .external_lex_state = 26},
  [2561] = {.lex_state = 18, .external_lex_state = 22},
  [2562] = {.lex_state = 13, .external_lex_state = 23},
  [2563] = {.lex_state = 14, .external_lex_state = 22},
  [2564] = {.lex_state = 13, .external_lex_state = 22},
  [2565] = {.lex_state = 13, .external_lex_state = 22},
  [2566] = {.lex_state = 14, .external_lex_state = 20},
  [2567] = {.lex_state = 14, .external_lex_state = 20},
  [2568] = {.lex_state = 13, .external_lex_state = 22},
  [2569] = {.lex_state = 13, .external_lex_state = 22},
  [2570] = {.lex_state = 7, .external_lex_state = 36},
  [2571] = {.lex_state = 14, .external_lex_state = 20},
  [2572] = {.lex_state = 13, .external_lex_state = 26},
  [2573] = {.lex_state = 14, .external_lex_state = 26},
  [2574] = {.lex_state = 11, .external_lex_state = 20},
  [2575] = {.lex_state = 13, .external_lex_state = 22},
  [2576] = {.lex_state = 14, .external_lex_state = 23},
  [2577] = {.lex_state = 14, .external_lex_state = 20},
  [2578] = {.lex_state = 14, .external_lex_state = 20},
  [2579] = {.lex_state = 14, .external_lex_state = 26},
  [2580] = {.lex_state = 13, .external_lex_state = 26},
  [2581] = {.lex_state = 14, .external_lex_state = 20},
  [2582] = {.lex_state = 14, .external_lex_state = 30},
  [2583] = {.lex_state = 13, .external_lex_state = 26},
  [2584] = {.lex_state = 13, .external_lex_state = 26},
  [2585] = {.lex_state = 13, .external_lex_state = 26},
  [2586] = {.lex_state = 14, .external_lex_state = 23},
  [2587] = {.lex_state = 14, .external_lex_state = 31},
  [2588] = {.lex_state = 14, .external_lex_state = 3},
  [2589] = {.lex_state = 13, .external_lex_state = 23},
  [2590] = {.lex_state = 6, .external_lex_state = 38},
  [2591] = {.lex_state = 6, .external_lex_state = 38},
  [2592] = {.lex_state = 6, .external_lex_state = 38},
  [2593] = {.lex_state = 6, .external_lex_state = 38},
  [2594] = {.lex_state = 14, .external_lex_state = 20},
  [2595] = {.lex_state = 14, .external_lex_state = 20},
  [2596] = {.lex_state = 14, .external_lex_state = 20},
  [2597] = {.lex_state = 14, .external_lex_state = 3},
  [2598] = {.lex_state = 11, .external_lex_state = 20},
  [2599] = {.lex_state = 11, .external_lex_state = 20},
  [2600] = {.lex_state = 14, .external_lex_state = 20},
  [2601] = {.lex_state = 14, .external_lex_state = 20},
  [2602] = {.lex_state = 14, .external_lex_state = 31},
  [2603] = {.lex_state = 11, .external_lex_state = 20},
  [2604] = {.lex_state = 14, .external_lex_state = 20},
  [2605] = {.lex_state = 6, .external_lex_state = 38},
  [2606] = {.lex_state = 13, .external_lex_state = 22},
  [2607] = {.lex_state = 14, .external_lex_state = 23},
  [2608] = {.lex_state = 13, .external_lex_state = 23},
  [2609] = {.lex_state = 6, .external_lex_state = 38},
  [2610] = {.lex_state = 14, .external_lex_state = 20},
  [2611] = {.lex_state = 14, .external_lex_state = 20},
  [2612] = {.lex_state = 13, .external_lex_state = 22},
  [2613] = {.lex_state = 18, .external_lex_state = 26},
  [2614] = {.lex_state = 6, .external_lex_state = 38},
  [2615] = {.lex_state = 6, .external_lex_state = 38},
  [2616] = {.lex_state = 14, .external_lex_state = 20},
  [2617] = {.lex_state = 14, .external_lex_state = 20},
  [2618] = {.lex_state = 14, .external_lex_state = 20},
  [2619] = {.lex_state = 14, .external_lex_state = 23},
  [2620] = {.lex_state = 13, .external_lex_state = 23},
  [2621] = {.lex_state = 13, .external_lex_state = 23},
  [2622] = {.lex_state = 6, .external_lex_state = 38},
  [2623] = {.lex_state = 6, .external_lex_state = 38},
  [2624] = {.lex_state = 13, .external_lex_state = 23},
  [2625] = {.lex_state = 14, .external_lex_state = 20},
  [2626] = {.lex_state = 13, .external_lex_state = 26},
  [2627] = {.lex_state = 6, .external_lex_state = 38},
  [2628] = {.lex_state = 13, .external_lex_state = 26},
  [2629] = {.lex_state = 6, .external_lex_state = 38},
  [2630] = {.lex_state = 6, .external_lex_state = 38},
  [2631] = {.lex_state = 14, .external_lex_state = 26},
  [2632] = {.lex_state = 13, .external_lex_state = 26},
  [2633] = {.lex_state = 14, .external_lex_state = 26},
  [2634] = {.lex_state = 18, .external_lex_state = 23},
  [2635] = {.lex_state = 13, .external_lex_state = 26},
  [2636] = {.lex_state = 14, .external_lex_state = 20},
  [2637] = {.lex_state = 14, .external_lex_state = 20},
  [2638] = {.lex_state = 13, .external_lex_state = 26},
  [2639] = {.lex_state = 14, .external_lex_state = 20},
  [2640] = {.lex_state = 14, .external_lex_state = 31},
  [2641] = {.lex_state = 6, .external_lex_state = 38},
  [2642] = {.lex_state = 13, .external_lex_state = 23},
  [2643] = {.lex_state = 13, .external_lex_state = 23},
  [2644] = {.lex_state = 11, .external_lex_state = 20},
  [2645] = {.lex_state = 14, .external_lex_state = 20},
  [2646] = {.lex_state = 14, .external_lex_state = 20},
  [2647] = {.lex_state = 14, .external_lex_state = 20},
  [2648] = {.lex_state = 14, .external_lex_state = 20},
  [2649] = {.lex_state = 14, .external_lex_state = 20},
  [2650] = {.lex_state = 6, .external_lex_state = 38},
  [2651] = {.lex_state = 18, .external_lex_state = 26},
  [2652] = {.lex_state = 14, .external_lex_state = 20},
  [2653] = {.lex_state = 13, .external_lex_state = 23},
  [2654] = {.lex_state = 13, .external_lex_state = 23},
  [2655] = {.lex_state = 14, .external_lex_state = 20},
  [2656] = {.lex_state = 11, .external_lex_state = 20},
  [2657] = {.lex_state = 14, .external_lex_state = 20},
  [2658] = {.lex_state = 14, .external_lex_state = 26},
  [2659] = {.lex_state = 11, .external_lex_state = 20},
  [2660] = {.lex_state = 14, .external_lex_state = 20},
  [2661] = {.lex_state = 14, .external_lex_state = 20},
  [2662] = {.lex_state = 11, .external_lex_state = 20},
  [2663] = {.lex_state = 14, .external_lex_state = 20},
  [2664] = {.lex_state = 13, .external_lex_state = 23},
  [2665] = {.lex_state = 14, .external_lex_state = 20},
  [2666] = {.lex_state = 6, .external_lex_state = 38},
  [2667] = {.lex_state = 14, .external_lex_state = 22},
  [2668] = {.lex_state = 14, .external_lex_state = 20},
  [2669] = {.lex_state = 14, .external_lex_state = 22},
  [2670] = {.lex_state = 6, .external_lex_state = 38},
  [2671] = {.lex_state = 14, .external_lex_state = 23},
  [2672] = {.lex_state = 11, .external_lex_state = 20},
  [2673] = {.lex_state = 14, .external_lex_state = 3},
  [2674] = {.lex_state = 14, .external_lex_state = 23},
  [2675] = {.lex_state = 11, .external_lex_state = 20},
  [2676] = {.lex_state = 14, .external_lex_state = 3},
  [2677] = {.lex_state = 13, .external_lex_state = 23},
  [2678] = {.lex_state = 14, .external_lex_state = 23},
  [2679] = {.lex_state = 6, .external_lex_state = 38},
  [2680] = {.lex_state = 14, .external_lex_state = 20},
  [2681] = {.lex_state = 14, .external_lex_state = 20},
  [2682] = {.lex_state = 14, .external_lex_state = 20},
  [2683] = {.lex_state = 14, .external_lex_state = 20},
  [2684] = {.lex_state = 14, .external_lex_state = 3},
  [2685] = {.lex_state = 14, .external_lex_state = 3},
  [2686] = {.lex_state = 13, .external_lex_state = 23},
  [2687] = {.lex_state = 11, .external_lex_state = 20},
  [2688] = {.lex_state = 14, .external_lex_state = 20},
  [2689] = {.lex_state = 11, .external_lex_state = 20},
  [2690] = {.lex_state = 14, .external_lex_state = 22},
  [2691] = {.lex_state = 14, .external_lex_state = 20},
  [2692] = {.lex_state = 13, .external_lex_state = 23},
  [2693] = {.lex_state = 14, .external_lex_state = 20},
  [2694] = {.lex_state = 13, .external_lex_state = 23},
  [2695] = {.lex_state = 13, .external_lex_state = 26},
  [2696] = {.lex_state = 13, .external_lex_state = 23},
  [2697] = {.lex_state = 13, .external_lex_state = 26},
  [2698] = {.lex_state = 14, .external_lex_state = 20},
  [2699] = {.lex_state = 14, .external_lex_state = 26},
  [2700] = {.lex_state = 13, .external_lex_state = 23},
  [2701] = {.lex_state = 13, .external_lex_state = 23},
  [2702] = {.lex_state = 13, .external_lex_state = 26},
  [2703] = {.lex_state = 14, .external_lex_state = 20},
  [2704] = {.lex_state = 14, .external_lex_state = 20},
  [2705] = {.lex_state = 14, .external_lex_state = 20},
  [2706] = {.lex_state = 13, .external_lex_state = 26},
  [2707] = {.lex_state = 13, .external_lex_state = 23},
  [2708] = {.lex_state = 13, .external_lex_state = 23},
  [2709] = {.lex_state = 13, .external_lex_state = 23},
  [2710] = {.lex_state = 13, .external_lex_state = 23},
  [2711] = {.lex_state = 14, .external_lex_state = 20},
  [2712] = {.lex_state = 14, .external_lex_state = 20},
  [2713] = {.lex_state = 14, .external_lex_state = 20},
  [2714] = {.lex_state = 13, .external_lex_state = 26},
  [2715] = {.lex_state = 14, .external_lex_state = 20},
  [2716] = {.lex_state = 14, .external_lex_state = 20},
  [2717] = {.lex_state = 14, .external_lex_state = 20},
  [2718] = {.lex_state = 14, .external_lex_state = 20},
  [2719] = {.lex_state = 14, .external_lex_state = 20},
  [2720] = {.lex_state = 14, .external_lex_state = 20},
  [2721] = {.lex_state = 14, .external_lex_state = 20},
  [2722] = {.lex_state = 18, .external_lex_state = 26},
  [2723] = {.lex_state = 14, .external_lex_state = 26},
  [2724] = {.lex_state = 13, .external_lex_state = 26},
  [2725] = {.lex_state = 14, .external_lex_state = 20},
  [2726] = {.lex_state = 14, .external_lex_state = 20},
  [2727] = {.lex_state = 13, .external_lex_state = 23},
  [2728] = {.lex_state = 11, .external_lex_state = 20},
  [2729] = {.lex_state = 14, .external_lex_state = 20},
  [2730] = {.lex_state = 14, .external_lex_state = 3},
  [2731] = {.lex_state = 13, .external_lex_state = 26},
  [2732] = {.lex_state = 14, .external_lex_state = 20},
  [2733] = {.lex_state = 13, .external_lex_state = 23},
  [2734] = {.lex_state = 13, .external_lex_state = 23},
  [2735] = {.lex_state = 11, .external_lex_state = 20},
  [2736] = {.lex_state = 14, .external_lex_state = 20},
  [2737] = {.lex_state = 14, .external_lex_state = 22},
  [2738] = {.lex_state = 11, .external_lex_state = 20},
  [2739] = {.lex_state = 13, .external_lex_state = 26},
  [2740] = {.lex_state = 14, .external_lex_state = 23},
  [2741] = {.lex_state = 14, .external_lex_state = 20},
  [2742] = {.lex_state = 14, .external_lex_state = 23},
  [2743] = {.lex_state = 14, .external_lex_state = 20},
  [2744] = {.lex_state = 14, .external_lex_state = 20},
  [2745] = {.lex_state = 14, .external_lex_state = 22},
  [2746] = {.lex_state = 13, .external_lex_state = 22},
  [2747] = {.lex_state = 13, .external_lex_state = 23},
  [2748] = {.lex_state = 14, .external_lex_state = 3},
  [2749] = {.lex_state = 14, .external_lex_state = 20},
  [2750] = {.lex_state = 13, .external_lex_state = 23},
  [2751] = {.lex_state = 14, .external_lex_state = 20},
  [2752] = {.lex_state = 14, .external_lex_state = 20},
  [2753] = {.lex_state = 14, .external_lex_state = 22},
  [2754] = {.lex_state = 14, .external_lex_state = 22},
  [2755] = {.lex_state = 11, .external_lex_state = 20},
  [2756] = {.lex_state = 14, .external_lex_state = 20},
  [2757] = {.lex_state = 14, .external_lex_state = 20},
  [2758] = {.lex_state = 14, .external_lex_state = 20},
  [2759] = {.lex_state = 13, .external_lex_state = 26},
  [2760] = {.lex_state = 13, .external_lex_state = 23},
  [2761] = {.lex_state = 13, .external_lex_state = 23},
  [2762] = {.lex_state = 13, .external_lex_state = 26},
  [2763] = {.lex_state = 14, .external_lex_state = 20},
  [2764] = {.lex_state = 11, .external_lex_state = 20},
  [2765] = {.lex_state = 14, .external_lex_state = 20},
  [2766] = {.lex_state = 13, .external_lex_state = 23},
  [2767] = {.lex_state = 18, .external_lex_state = 23},
  [2768] = {.lex_state = 13, .external_lex_state = 23},
  [2769] = {.lex_state = 13, .external_lex_state = 23},
  [2770] = {.lex_state = 14, .external_lex_state = 20},
  [2771] = {.lex_state = 14, .external_lex_state = 20},
  [2772] = {.lex_state = 12, .external_lex_state = 26},
  [2773] = {.lex_state = 14, .external_lex_state = 20},
  [2774] = {.lex_state = 14, .external_lex_state = 20},
  [2775] = {.lex_state = 6, .external_lex_state = 38},
  [2776] = {.lex_state = 6, .external_lex_state = 38},
  [2777] = {.lex_state = 13, .external_lex_state = 23},
  [2778] = {.lex_state = 14, .external_lex_state = 20},
  [2779] = {.lex_state = 6, .external_lex_state = 38},
  [2780] = {.lex_state = 14, .external_lex_state = 20},
  [2781] = {.lex_state = 18, .external_lex_state = 23},
  [2782] = {.lex_state = 13, .external_lex_state = 26},
  [2783] = {.lex_state = 13, .external_lex_state = 26},
  [2784] = {.lex_state = 14, .external_lex_state = 20},
  [2785] = {.lex_state = 13, .external_lex_state = 23},
  [2786] = {.lex_state = 13, .external_lex_state = 23},
  [2787] = {.lex_state = 18, .external_lex_state = 22},
  [2788] = {.lex_state = 13, .external_lex_state = 23},
  [2789] = {.lex_state = 14, .external_lex_state = 20},
  [2790] = {.lex_state = 14, .external_lex_state = 20},
  [2791] = {.lex_state = 6, .external_lex_state = 38},
  [2792] = {.lex_state = 6, .external_lex_state = 38},
  [2793] = {.lex_state = 14, .external_lex_state = 23},
  [2794] = {.lex_state = 7, .external_lex_state = 38},
  [2795] = {.lex_state = 14, .external_lex_state = 26},
  [2796] = {.lex_state = 14, .external_lex_state = 23},
  [2797] = {.lex_state = 14, .external_lex_state = 26},
  [2798] = {.lex_state = 14, .external_lex_state = 26},
  [2799] = {.lex_state = 12, .external_lex_state = 20},
  [2800] = {.lex_state = 12, .external_lex_state = 20},
  [2801] = {.lex_state = 12, .external_lex_state = 20},
  [2802] = {.lex_state = 12, .external_lex_state = 20},
  [2803] = {.lex_state = 14, .external_lex_state = 22},
  [2804] = {.lex_state = 14, .external_lex_state = 20},
  [2805] = {.lex_state = 14, .external_lex_state = 22},
  [2806] = {.lex_state = 14, .external_lex_state = 23},
  [2807] = {.lex_state = 14, .external_lex_state = 23},
  [2808] = {.lex_state = 14, .external_lex_state = 23},
  [2809] = {.lex_state = 14, .external_lex_state = 22},
  [2810] = {.lex_state = 14, .external_lex_state = 23},
  [2811] = {.lex_state = 14, .external_lex_state = 23},
  [2812] = {.lex_state = 14, .external_lex_state = 23},
  [2813] = {.lex_state = 5, .external_lex_state = 36},
  [2814] = {.lex_state = 14, .external_lex_state = 22},
  [2815] = {.lex_state = 7, .external_lex_state = 38},
  [2816] = {.lex_state = 7, .external_lex_state = 38},
  [2817] = {.lex_state = 14, .external_lex_state = 23},
  [2818] = {.lex_state = 12, .external_lex_state = 20},
  [2819] = {.lex_state = 14, .external_lex_state = 23},
  [2820] = {.lex_state = 14, .external_lex_state = 23},
  [2821] = {.lex_state = 14, .external_lex_state = 26},
  [2822] = {.lex_state = 14, .external_lex_state = 23},
  [2823] = {.lex_state = 14, .external_lex_state = 23},
  [2824] = {.lex_state = 14, .external_lex_state = 23},
  [2825] = {.lex_state = 14, .external_lex_state = 23},
  [2826] = {.lex_state = 12, .external_lex_state = 20},
  [2827] = {.lex_state = 14, .external_lex_state = 26},
  [2828] = {.lex_state = 14, .external_lex_state = 23},
  [2829] = {.lex_state = 14, .external_lex_state = 26},
  [2830] = {.lex_state = 14, .external_lex_state = 26},
  [2831] = {.lex_state = 14, .external_lex_state = 23},
  [2832] = {.lex_state = 14, .external_lex_state = 23},
  [2833] = {.lex_state = 14, .external_lex_state = 23},
  [2834] = {.lex_state = 14, .external_lex_state = 23},
  [2835] = {.lex_state = 7, .external_lex_state = 38},
  [2836] = {.lex_state = 8, .external_lex_state = 39},
  [2837] = {.lex_state = 14, .external_lex_state = 22},
  [2838] = {.lex_state = 12, .external_lex_state = 20},
  [2839] = {.lex_state = 14, .external_lex_state = 23},
  [2840] = {.lex_state = 12, .external_lex_state = 20},
  [2841] = {.lex_state = 14, .external_lex_state = 26},
  [2842] = {.lex_state = 14, .external_lex_state = 26},
  [2843] = {.lex_state = 14, .external_lex_state = 22},
  [2844] = {.lex_state = 14, .external_lex_state = 23},
  [2845] = {.lex_state = 14, .external_lex_state = 23},
  [2846] = {.lex_state = 5, .external_lex_state = 36},
  [2847] = {.lex_state = 14, .external_lex_state = 26},
  [2848] = {.lex_state = 7, .external_lex_state = 38},
  [2849] = {.lex_state = 12, .external_lex_state = 20},
  [2850] = {.lex_state = 14, .external_lex_state = 26},
  [2851] = {.lex_state = 14, .external_lex_state = 26},
  [2852] = {.lex_state = 14, .external_lex_state = 26},
  [2853] = {.lex_state = 8, .external_lex_state = 39},
  [2854] = {.lex_state = 14, .external_lex_state = 26},
  [2855] = {.lex_state = 12, .external_lex_state = 20},
  [2856] = {.lex_state = 14, .external_lex_state = 26},
  [2857] = {.lex_state = 14, .external_lex_state = 23},
  [2858] = {.lex_state = 12, .external_lex_state = 20},
  [2859] = {.lex_state = 14, .external_lex_state = 26},
  [2860] = {.lex_state = 14, .external_lex_state = 23},
  [2861] = {.lex_state = 14, .external_lex_state = 23},
  [2862] = {.lex_state = 14, .external_lex_state = 23},
  [2863] = {.lex_state = 14, .external_lex_state = 23},
  [2864] = {.lex_state = 14, .external_lex_state = 26},
  [2865] = {.lex_state = 14, .external_lex_state = 23},
  [2866] = {.lex_state = 14, .external_lex_state = 23},
  [2867] = {.lex_state = 7, .external_lex_state = 38},
  [2868] = {.lex_state = 14, .external_lex_state = 23},
  [2869] = {.lex_state = 14, .external_lex_state = 22},
  [2870] = {.lex_state = 7, .external_lex_state = 38},
  [2871] = {.lex_state = 14, .external_lex_state = 26},
  [2872] = {.lex_state = 14, .external_lex_state = 26},
  [2873] = {.lex_state = 14, .external_lex_state = 26},
  [2874] = {.lex_state = 14, .external_lex_state = 26},
  [2875] = {.lex_state = 14, .external_lex_state = 23},
  [2876] = {.lex_state = 12, .external_lex_state = 20},
  [2877] = {.lex_state = 14, .external_lex_state = 26},
  [2878] = {.lex_state = 12, .external_lex_state = 20},
  [2879] = {.lex_state = 12, .external_lex_state = 20},
  [2880] = {.lex_state = 12, .external_lex_state = 20},
  [2881] = {.lex_state = 14, .external_lex_state = 26},
  [2882] = {.lex_state = 14, .external_lex_state = 26},
  [2883] = {.lex_state = 12, .external_lex_state = 20},
  [2884] = {.lex_state = 5, .external_lex_state = 36},
  [2885] = {.lex_state = 14, .external_lex_state = 26},
  [2886] = {.lex_state = 8, .external_lex_state = 39},
  [2887] = {.lex_state = 14, .external_lex_state = 26},
  [2888] = {.lex_state = 14, .external_lex_state = 26},
  [2889] = {.lex_state = 14, .external_lex_state = 23},
  [2890] = {.lex_state = 14, .external_lex_state = 26},
  [2891] = {.lex_state = 14, .external_lex_state = 22},
  [2892] = {.lex_state = 14, .external_lex_state = 22},
  [2893] = {.lex_state = 14, .external_lex_state = 26},
  [2894] = {.lex_state = 14, .external_lex_state = 26},
  [2895] = {.lex_state = 7, .external_lex_state = 38},
  [2896] = {.lex_state = 14, .external_lex_state = 26},
  [2897] = {.lex_state = 8, .external_lex_state = 39},
  [2898] = {.lex_state = 14, .external_lex_state = 26},
  [2899] = {.lex_state = 14, .external_lex_state = 26},
  [2900] = {.lex_state = 5, .external_lex_state = 36},
  [2901] = {.lex_state = 14, .external_lex_state = 26},
  [2902] = {.lex_state = 7, .external_lex_state = 38},
  [2903] = {.lex_state = 14, .external_lex_state = 22},
  [2904] = {.lex_state = 7, .external_lex_state = 38},
  [2905] = {.lex_state = 14, .external_lex_state = 22},
  [2906] = {.lex_state = 14, .external_lex_state = 22},
  [2907] = {.lex_state = 7, .external_lex_state = 38},
  [2908] = {.lex_state = 7, .external_lex_state = 38},
  [2909] = {.lex_state = 14, .external_lex_state = 26},
  [2910] = {.lex_state = 8, .external_lex_state = 39},
  [2911] = {.lex_state = 14, .external_lex_state = 26},
  [2912] = {.lex_state = 12, .external_lex_state = 20},
  [2913] = {.lex_state = 14, .external_lex_state = 26},
  [2914] = {.lex_state = 14, .external_lex_state = 26},
  [2915] = {.lex_state = 14, .external_lex_state = 22},
  [2916] = {.lex_state = 7, .external_lex_state = 38},
  [2917] = {.lex_state = 14, .external_lex_state = 26},
  [2918] = {.lex_state = 14, .external_lex_state = 22},
  [2919] = {.lex_state = 7, .external_lex_state = 38},
  [2920] = {.lex_state = 7, .external_lex_state = 38},
  [2921] = {.lex_state = 12, .external_lex_state = 20},
  [2922] = {.lex_state = 12, .external_lex_state = 20},
  [2923] = {.lex_state = 12, .external_lex_state = 20},
  [2924] = {.lex_state = 14, .external_lex_state = 22},
  [2925] = {.lex_state = 12, .external_lex_state = 20},
  [2926] = {.lex_state = 12, .external_lex_state = 20},
  [2927] = {.lex_state = 12, .external_lex_state = 20},
  [2928] = {.lex_state = 14, .external_lex_state = 22},
  [2929] = {.lex_state = 14, .external_lex_state = 22},
  [2930] = {.lex_state = 14, .external_lex_state = 26},
  [2931] = {.lex_state = 12, .external_lex_state = 20},
  [2932] = {.lex_state = 7, .external_lex_state = 38},
  [2933] = {.lex_state = 7, .external_lex_state = 38},
  [2934] = {.lex_state = 14, .external_lex_state = 22},
  [2935] = {.lex_state = 7, .external_lex_state = 38},
  [2936] = {.lex_state = 12, .external_lex_state = 20},
  [2937] = {.lex_state = 5, .external_lex_state = 36},
  [2938] = {.lex_state = 12, .external_lex_state = 20},
  [2939] = {.lex_state = 12, .external_lex_state = 20},
  [2940] = {.lex_state = 12, .external_lex_state = 20},
  [2941] = {.lex_state = 14, .external_lex_state = 23},
  [2942] = {.lex_state = 14, .external_lex_state = 23},
  [2943] = {.lex_state = 14, .external_lex_state = 22},
  [2944] = {.lex_state = 14, .external_lex_state = 22},
  [2945] = {.lex_state = 14, .external_lex_state = 22},
  [2946] = {.lex_state = 14, .external_lex_state = 22},
  [2947] = {.lex_state = 12, .external_lex_state = 20},
  [2948] = {.lex_state = 12, .external_lex_state = 20},
  [2949] = {.lex_state = 14, .external_lex_state = 22},
  [2950] = {.lex_state = 14, .external_lex_state = 22},
  [2951] = {.lex_state = 7, .external_lex_state = 38},
  [2952] = {.lex_state = 7, .external_lex_state = 38},
  [2953] = {.lex_state = 12, .external_lex_state = 20},
  [2954] = {.lex_state = 12, .external_lex_state = 20},
  [2955] = {.lex_state = 14, .external_lex_state = 22},
  [2956] = {.lex_state = 14, .external_lex_state = 22},
  [2957] = {.lex_state = 14, .external_lex_state = 22},
  [2958] = {.lex_state = 12, .external_lex_state = 20},
  [2959] = {.lex_state = 14, .external_lex_state = 22},
  [2960] = {.lex_state = 12, .external_lex_state = 20},
  [2961] = {.lex_state = 14, .external_lex_state = 22},
  [2962] = {.lex_state = 7, .external_lex_state = 38},
  [2963] = {.lex_state = 14, .external_lex_state = 22},
  [2964] = {.lex_state = 7, .external_lex_state = 38},
  [2965] = {.lex_state = 14, .external_lex_state = 23},
  [2966] = {.lex_state = 14, .external_lex_state = 22},
  [2967] = {.lex_state = 14, .external_lex_state = 22},
  [2968] = {.lex_state = 12, .external_lex_state = 20},
  [2969] = {.lex_state = 12, .external_lex_state = 20},
  [2970] = {.lex_state = 14, .external_lex_state = 23},
  [2971] = {.lex_state = 14, .external_lex_state = 22},
  [2972] = {.lex_state = 12, .external_lex_state = 20},
  [2973] = {.lex_state = 14, .external_lex_state = 26},
  [2974] = {.lex_state = 14, .external_lex_state = 22},
  [2975] = {.lex_state = 14, .external_lex_state = 22},
  [2976] = {.lex_state = 14, .external_lex_state = 22},
  [2977] = {.lex_state = 14, .external_lex_state = 23},
  [2978] = {.lex_state = 14, .external_lex_state = 22},
  [2979] = {.lex_state = 14, .external_lex_state = 23},
  [2980] = {.lex_state = 12, .external_lex_state = 20},
  [2981] = {.lex_state = 12, .external_lex_state = 20},
  [2982] = {.lex_state = 12, .external_lex_state = 20},
  [2983] = {.lex_state = 14, .external_lex_state = 22},
  [2984] = {.lex_state = 12, .external_lex_state = 20},
  [2985] = {.lex_state = 14, .external_lex_state = 22},
  [2986] = {.lex_state = 14, .external_lex_state = 22},
  [2987] = {.lex_state = 12, .external_lex_state = 20},
  [2988] = {.lex_state = 14, .external_lex_state = 22},
  [2989] = {.lex_state = 14, .external_lex_state = 22},
  [2990] = {.lex_state = 7, .external_lex_state = 38},
  [2991] = {.lex_state = 14, .external_lex_state = 23},
  [2992] = {.lex_state = 7, .external_lex_state = 38},
  [2993] = {.lex_state = 14, .external_lex_state = 26},
  [2994] = {.lex_state = 14, .external_lex_state = 26},
  [2995] = {.lex_state = 14, .external_lex_state = 23},
  [2996] = {.lex_state = 14, .external_lex_state = 22},
  [2997] = {.lex_state = 14, .external_lex_state = 23},
  [2998] = {.lex_state = 14, .external_lex_state = 23},
  [2999] = {.lex_state = 8, .external_lex_state = 40},
  [3000] = {.lex_state = 5, .external_lex_state = 38},
  [3001] = {.lex_state = 14, .external_lex_state = 20},
  [3002] = {.lex_state = 5, .external_lex_state = 38},
  [3003] = {.lex_state = 14, .external_lex_state = 20},
  [3004] = {.lex_state = 14, .external_lex_state = 20},
  [3005] = {.lex_state = 5, .external_lex_state = 38},
  [3006] = {.lex_state = 5, .external_lex_state = 38},
  [3007] = {.lex_state = 8, .external_lex_state = 40},
  [3008] = {.lex_state = 14, .external_lex_state = 20},
  [3009] = {.lex_state = 14, .external_lex_state = 20},
  [3010] = {.lex_state = 5, .external_lex_state = 38},
  [3011] = {.lex_state = 14, .external_lex_state = 20},
  [3012] = {.lex_state = 5, .external_lex_state = 38},
  [3013] = {.lex_state = 5, .external_lex_state = 38},
  [3014] = {.lex_state = 14, .external_lex_state = 20},
  [3015] = {.lex_state = 5, .external_lex_state = 38},
  [3016] = {.lex_state = 8, .external_lex_state = 40},
  [3017] = {.lex_state = 8, .external_lex_state = 40},
  [3018] = {.lex_state = 8, .external_lex_state = 40},
  [3019] = {.lex_state = 8, .external_lex_state = 40},
  [3020] = {.lex_state = 8, .external_lex_state = 40},
  [3021] = {.lex_state = 8, .external_lex_state = 40},
  [3022] = {.lex_state = 8, .external_lex_state = 40},
  [3023] = {.lex_state = 5, .external_lex_state = 38},
  [3024] = {.lex_state = 14, .external_lex_state = 20},
  [3025] = {.lex_state = 14, .external_lex_state = 20},
  [3026] = {.lex_state = 14, .external_lex_state = 20},
  [3027] = {.lex_state = 14, .external_lex_state = 20},
  [3028] = {.lex_state = 5, .external_lex_state = 38},
  [3029] = {.lex_state = 5, .external_lex_state = 38},
  [3030] = {.lex_state = 14, .external_lex_state = 20},
  [3031] = {.lex_state = 14, .external_lex_state = 20},
  [3032] = {.lex_state = 5, .external_lex_state = 38},
  [3033] = {.lex_state = 5, .external_lex_state = 38},
  [3034] = {.lex_state = 8, .external_lex_state = 40},
  [3035] = {.lex_state = 14, .external_lex_state = 20},
  [3036] = {.lex_state = 8, .external_lex_state = 40},
  [3037] = {.lex_state = 5, .external_lex_state = 38},
  [3038] = {.lex_state = 8, .external_lex_state = 40},
  [3039] = {.lex_state = 8, .external_lex_state = 40},
  [3040] = {.lex_state = 5, .external_lex_state = 38},
  [3041] = {.lex_state = 14, .external_lex_state = 20},
  [3042] = {.lex_state = 5, .external_lex_state = 38},
  [3043] = {.lex_state = 8, .external_lex_state = 40},
  [3044] = {.lex_state = 5, .external_lex_state = 38},
  [3045] = {.lex_state = 8, .external_lex_state = 40},
  [3046] = {.lex_state = 5, .external_lex_state = 38},
  [3047] = {.lex_state = 14, .external_lex_state = 20},
  [3048] = {.lex_state = 8, .external_lex_state = 40},
  [3049] = {.lex_state = 14, .external_lex_state = 20},
  [3050] = {.lex_state = 8, .external_lex_state = 40},
  [3051] = {.lex_state = 8, .external_lex_state = 40},
  [3052] = {.lex_state = 8, .external_lex_state = 40},
  [3053] = {.lex_state = 5, .external_lex_state = 38},
  [3054] = {.lex_state = 8, .external_lex_state = 40},
  [3055] = {.lex_state = 8, .external_lex_state = 40},
  [3056] = {.lex_state = 8, .external_lex_state = 40},
  [3057] = {.lex_state = 8, .external_lex_state = 40},
  [3058] = {.lex_state = 14, .external_lex_state = 20},
  [3059] = {.lex_state = 14, .external_lex_state = 20},
  [3060] = {.lex_state = 14, .external_lex_state = 20},
  [3061] = {.lex_state = 5, .external_lex_state = 38},
  [3062] = {.lex_state = 5, .external_lex_state = 38},
  [3063] = {.lex_state = 5, .external_lex_state = 38},
  [3064] = {.lex_state = 5, .external_lex_state = 38},
  [3065] = {.lex_state = 8, .external_lex_state = 40},
  [3066] = {.lex_state = 14, .external_lex_state = 20},
  [3067] = {.lex_state = 5, .external_lex_state = 38},
  [3068] = {.lex_state = 9, .external_lex_state = 14},
  [3069] = {.lex_state = 10, .external_lex_state = 13},
  [3070] = {.lex_state = 9, .external_lex_state = 14},
  [3071] = {.lex_state = 10, .external_lex_state = 13},
  [3072] = {.lex_state = 9, .external_lex_state = 41},
  [3073] = {.lex_state = 10, .external_lex_state = 42},
  [3074] = {.lex_state = 10, .external_lex_state = 13},
  [3075] = {.lex_state = 9, .external_lex_state = 14},
  [3076] = {.lex_state = 10, .external_lex_state = 13},
  [3077] = {.lex_state = 2, .external_lex_state = 11},
  [3078] = {.lex_state = 10, .external_lex_state = 13},
  [3079] = {.lex_state = 10, .external_lex_state = 13},
  [3080] = {.lex_state = 9, .external_lex_state = 14},
  [3081] = {.lex_state = 9, .external_lex_state = 14},
  [3082] = {.lex_state = 9, .external_lex_state = 14},
  [3083] = {.lex_state = 9, .external_lex_state = 14},
  [3084] = {.lex_state = 10, .external_lex_state = 13},
  [3085] = {.lex_state = 9, .external_lex_state = 14},
  [3086] = {.lex_state = 2, .external_lex_state = 11},
  [3087] = {.lex_state = 2, .external_lex_state = 11},
  [3088] = {.lex_state = 9, .external_lex_state = 14},
  [3089] = {.lex_state = 9, .external_lex_state = 14},
  [3090] = {.lex_state = 9, .external_lex_state = 14},
  [3091] = {.lex_state = 9, .external_lex_state = 14},
  [3092] = {.lex_state = 9, .external_lex_state = 14},
  [3093] = {.lex_state = 9, .external_lex_state = 14},
  [3094] = {.lex_state = 10, .external_lex_state = 13},
  [3095] = {.lex_state = 9, .external_lex_state = 14},
  [3096] = {.lex_state = 10, .external_lex_state = 13},
  [3097] = {.lex_state = 9, .external_lex_state = 14},
  [3098] = {.lex_state = 10, .external_lex_state = 13},
  [3099] = {.lex_state = 10, .external_lex_state = 13},
  [3100] = {.lex_state = 10, .external_lex_state = 13},
  [3101] = {.lex_state = 10, .external_lex_state = 13},
  [3102] = {.lex_state = 10, .external_lex_state = 13},
  [3103] = {.lex_state = 10, .external_lex_state = 13},
  [3104] = {.lex_state = 10, .external_lex_state = 13},
  [3105] = {.lex_state = 9, .external_lex_state = 14},
  [3106] = {.lex_state = 10, .external_lex_state = 13},
  [3107] = {.lex_state = 9, .external_lex_state = 14},
  [3108] = {.lex_state = 9, .external_lex_state = 14},
  [3109] = {.lex_state = 10, .external_lex_state = 13},
  [3110] = {.lex_state = 9, .external_lex_state = 14},
  [3111] = {.lex_state = 10, .external_lex_state = 13},
  [3112] = {.lex_state = 10, .external_lex_state = 13},
  [3113] = {.lex_state = 11, .external_lex_state = 7},
  [3114] = {.lex_state = 11, .external_lex_state = 7},
  [3115] = {.lex_state = 11, .external_lex_state = 7},
  [3116] = {.lex_state = 11, .external_lex_state = 7},
  [3117] = {.lex_state = 11, .external_lex_state = 7},
  [3118] = {.lex_state = 11, .external_lex_state = 7},
  [3119] = {.lex_state = 11, .external_lex_state = 7},
  [3120] = {.lex_state = 11, .external_lex_state = 7},
  [3121] = {.lex_state = 11, .external_lex_state = 7},
  [3122] = {.lex_state = 11, .external_lex_state = 7},
  [3123] = {.lex_state = 11, .external_lex_state = 7},
  [3124] = {.lex_state = 11, .external_lex_state = 7},
  [3125] = {.lex_state = 11, .external_lex_state = 7},
  [3126] = {.lex_state = 11, .external_lex_state = 7},
  [3127] = {.lex_state = 11, .external_lex_state = 7},
  [3128] = {.lex_state = 11, .external_lex_state = 7},
  [3129] = {.lex_state = 11, .external_lex_state = 7},
  [3130] = {.lex_state = 11, .external_lex_state = 7},
  [3131] = {.lex_state = 11, .external_lex_state = 7},
  [3132] = {.lex_state = 11, .external_lex_state = 7},
  [3133] = {.lex_state = 11, .external_lex_state = 7},
  [3134] = {.lex_state = 11, .external_lex_state = 7},
  [3135] = {.lex_state = 11, .external_lex_state = 7},
  [3136] = {.lex_state = 11, .external_lex_state = 7},
  [3137] = {.lex_state = 11, .external_lex_state = 7},
  [3138] = {.lex_state = 11, .external_lex_state = 7},
  [3139] = {.lex_state = 11, .external_lex_state = 7},
  [3140] = {.lex_state = 11, .external_lex_state = 7},
  [3141] = {.lex_state = 11, .external_lex_state = 7},
  [3142] = {.lex_state = 11, .external_lex_state = 7},
  [3143] = {.lex_state = 11, .external_lex_state = 7},
  [3144] = {.lex_state = 11, .external_lex_state = 7},
  [3145] = {.lex_state = 11, .external_lex_state = 7},
  [3146] = {.lex_state = 11, .external_lex_state = 7},
  [3147] = {.lex_state = 11, .external_lex_state = 7},
  [3148] = {.lex_state = 11, .external_lex_state = 7},
  [3149] = {.lex_state = 11, .external_lex_state = 7},
  [3150] = {.lex_state = 11, .external_lex_state = 7},
  [3151] = {.lex_state = 11, .external_lex_state = 7},
  [3152] = {.lex_state = 11, .external_lex_state = 7},
  [3153] = {.lex_state = 11, .external_lex_state = 43},
  [3154] = {.lex_state = 11, .external_lex_state = 43},
  [3155] = {.lex_state = 11, .external_lex_state = 43},
  [3156] = {.lex_state = 11, .external_lex_state = 43},
  [3157] = {.lex_state = 11, .external_lex_state = 43},
  [3158] = {.lex_state = 11, .external_lex_state = 43},
  [3159] = {.lex_state = 11, .external_lex_state = 43},
  [3160] = {.lex_state = 11, .external_lex_state = 43},
  [3161] = {.lex_state = 11, .external_lex_state = 43},
  [3162] = {.lex_state = 11, .external_lex_state = 43},
  [3163] = {.lex_state = 11, .external_lex_state = 43},
  [3164] = {.lex_state = 11, .external_lex_state = 43},
  [3165] = {.lex_state = 11, .external_lex_state = 43},
  [3166] = {.lex_state = 11, .external_lex_state = 43},
  [3167] = {.lex_state = 11, .external_lex_state = 43},
  [3168] = {.lex_state = 11, .external_lex_state = 43},
  [3169] = {.lex_state = 11, .external_lex_state = 43},
  [3170] = {.lex_state = 11, .external_lex_state = 43},
  [3171] = {.lex_state = 11, .external_lex_state = 43},
  [3172] = {.lex_state = 11, .external_lex_state = 43},
  [3173] = {.lex_state = 11, .external_lex_state = 43},
  [3174] = {.lex_state = 11, .external_lex_state = 43},
  [3175] = {.lex_state = 11, .external_lex_state = 43},
  [3176] = {.lex_state = 11, .external_lex_state = 43},
  [3177] = {.lex_state = 11, .external_lex_state = 43},
  [3178] = {.lex_state = 11, .external_lex_state = 43},
  [3179] = {.lex_state = 11, .external_lex_state = 43},
  [3180] = {.lex_state = 11, .external_lex_state = 43},
  [3181] = {.lex_state = 11, .external_lex_state = 43},
  [3182] = {.lex_state = 11, .external_lex_state = 43},
  [3183] = {.lex_state = 11, .external_lex_state = 43},
  [3184] = {.lex_state = 11, .external_lex_state = 43},
  [3185] = {.lex_state = 11, .external_lex_state = 43},
  [3186] = {.lex_state = 11, .external_lex_state = 43},
  [3187] = {.lex_state = 11, .external_lex_state = 43},
  [3188] = {.lex_state = 11, .external_lex_state = 43},
  [3189] = {.lex_state = 11, .external_lex_state = 43},
  [3190] = {.lex_state = 11, .external_lex_state = 43},
  [3191] = {.lex_state = 11, .external_lex_state = 43},
  [3192] = {.lex_state = 11, .external_lex_state = 43},
  [3193] = {.lex_state = 11, .external_lex_state = 43},
  [3194] = {.lex_state = 11, .external_lex_state = 43},
  [3195] = {.lex_state = 11, .external_lex_state = 43},
  [3196] = {.lex_state = 11, .external_lex_state = 43},
  [3197] = {.lex_state = 11, .external_lex_state = 43},
  [3198] = {.lex_state = 11, .external_lex_state = 43},
  [3199] = {.lex_state = 11, .external_lex_state = 43},
  [3200] = {.lex_state = 11, .external_lex_state = 43},
  [3201] = {.lex_state = 11, .external_lex_state = 43},
  [3202] = {.lex_state = 11, .external_lex_state = 44},
  [3203] = {.lex_state = 11, .external_lex_state = 44},
  [3204] = {.lex_state = 11, .external_lex_state = 44},
  [3205] = {.lex_state = 11, .external_lex_state = 44},
  [3206] = {.lex_state = 11, .external_lex_state = 44},
  [3207] = {.lex_state = 11, .external_lex_state = 44},
  [3208] = {.lex_state = 11, .external_lex_state = 44},
  [3209] = {.lex_state = 11, .external_lex_state = 44},
  [3210] = {.lex_state = 11, .external_lex_state = 44},
  [3211] = {.lex_state = 11, .external_lex_state = 44},
  [3212] = {.lex_state = 11, .external_lex_state = 44},
  [3213] = {.lex_state = 11, .external_lex_state = 44},
  [3214] = {.lex_state = 11, .external_lex_state = 44},
  [3215] = {.lex_state = 11, .external_lex_state = 44},
  [3216] = {.lex_state = 11, .external_lex_state = 44},
  [3217] = {.lex_state = 11, .external_lex_state = 44},
  [3218] = {.lex_state = 11, .external_lex_state = 44},
  [3219] = {.lex_state = 11, .external_lex_state = 44},
  [3220] = {.lex_state = 11, .external_lex_state = 44},
  [3221] = {.lex_state = 11, .external_lex_state = 44},
  [3222] = {.lex_state = 15, .external_lex_state = 44},
  [3223] = {.lex_state = 15, .external_lex_state = 44},
  [3224] = {.lex_state = 15, .external_lex_state = 44},
  [3225] = {.lex_state = 15, .external_lex_state = 44},
  [3226] = {.lex_state = 15, .external_lex_state = 44},
  [3227] = {.lex_state = 15, .external_lex_state = 44},
  [3228] = {.lex_state = 15, .external_lex_state = 44},
  [3229] = {.lex_state = 2, .external_lex_state = 44},
  [3230] = {.lex_state = 15, .external_lex_state = 44},
  [3231] = {.lex_state = 2, .external_lex_state = 44},
  [3232] = {.lex_state = 15, .external_lex_state = 44},
  [3233] = {.lex_state = 2, .external_lex_state = 44},
  [3234] = {.lex_state = 2, .external_lex_state = 44},
  [3235] = {.lex_state = 2, .external_lex_state = 44},
  [3236] = {.lex_state = 2, .external_lex_state = 44},
  [3237] = {.lex_state = 15, .external_lex_state = 44},
  [3238] = {.lex_state = 2, .external_lex_state = 44},
  [3239] = {.lex_state = 15, .external_lex_state = 44},
  [3240] = {.lex_state = 15, .external_lex_state = 44},
  [3241] = {.lex_state = 2, .external_lex_state = 44},
  [3242] = {.lex_state = 15, .external_lex_state = 44},
  [3243] = {.lex_state = 2, .external_lex_state = 44},
  [3244] = {.lex_state = 2, .external_lex_state = 44},
  [3245] = {.lex_state = 15, .external_lex_state = 44},
  [3246] = {.lex_state = 11, .external_lex_state = 43},
  [3247] = {.lex_state = 2, .external_lex_state = 44},
  [3248] = {.lex_state = 2, .external_lex_state = 44},
  [3249] = {.lex_state = 15, .external_lex_state = 44},
  [3250] = {.lex_state = 15, .external_lex_state = 44},
  [3251] = {.lex_state = 2, .external_lex_state = 44},
  [3252] = {.lex_state = 2, .external_lex_state = 44},
  [3253] = {.lex_state = 15, .external_lex_state = 44},
  [3254] = {.lex_state = 15, .external_lex_state = 44},
  [3255] = {.lex_state = 2, .external_lex_state = 44},
  [3256] = {.lex_state = 15, .external_lex_state = 44},
  [3257] = {.lex_state = 2, .external_lex_state = 44},
  [3258] = {.lex_state = 15, .external_lex_state = 44},
  [3259] = {.lex_state = 2, .external_lex_state = 44},
  [3260] = {.lex_state = 15, .external_lex_state = 44},
  [3261] = {.lex_state = 11, .external_lex_state = 44},
  [3262] = {.lex_state = 11, .external_lex_state = 44},
  [3263] = {.lex_state = 11, .external_lex_state = 44},
  [3264] = {.lex_state = 11, .external_lex_state = 44},
  [3265] = {.lex_state = 0, .external_lex_state = 7},
  [3266] = {.lex_state = 11, .external_lex_state = 44},
  [3267] = {.lex_state = 0, .external_lex_state = 7},
  [3268] = {.lex_state = 11, .external_lex_state = 44},
  [3269] = {.lex_state = 11, .external_lex_state = 44},
  [3270] = {.lex_state = 11, .external_lex_state = 44},
  [3271] = {.lex_state = 11, .external_lex_state = 44},
  [3272] = {.lex_state = 11, .external_lex_state = 44},
  [3273] = {.lex_state = 0, .external_lex_state = 7},
  [3274] = {.lex_state = 2, .external_lex_state = 44},
  [3275] = {.lex_state = 11, .external_lex_state = 44},
  [3276] = {.lex_state = 11, .external_lex_state = 44},
  [3277] = {.lex_state = 11, .external_lex_state = 44},
  [3278] = {.lex_state = 0, .external_lex_state = 7},
  [3279] = {.lex_state = 11, .external_lex_state = 44},
  [3280] = {.lex_state = 11, .external_lex_state = 44},
  [3281] = {.lex_state = 0, .external_lex_state = 7},
  [3282] = {.lex_state = 0, .external_lex_state = 7},
  [3283] = {.lex_state = 11, .external_lex_state = 44},
  [3284] = {.lex_state = 0, .external_lex_state = 7},
  [3285] = {.lex_state = 11, .external_lex_state = 44},
  [3286] = {.lex_state = 0, .external_lex_state = 7},
  [3287] = {.lex_state = 11, .external_lex_state = 44},
  [3288] = {.lex_state = 11, .external_lex_state = 44},
  [3289] = {.lex_state = 11, .external_lex_state = 44},
  [3290] = {.lex_state = 11, .external_lex_state = 44},
  [3291] = {.lex_state = 2, .external_lex_state = 44},
  [3292] = {.lex_state = 11, .external_lex_state = 44},
  [3293] = {.lex_state = 2, .external_lex_state = 44},
  [3294] = {.lex_state = 11, .external_lex_state = 44},
  [3295] = {.lex_state = 11, .external_lex_state = 44},
  [3296] = {.lex_state = 11, .external_lex_state = 44},
  [3297] = {.lex_state = 0, .external_lex_state = 7},
  [3298] = {.lex_state = 11, .external_lex_state = 44},
  [3299] = {.lex_state = 11, .external_lex_state = 44},
  [3300] = {.lex_state = 11, .external_lex_state = 44},
  [3301] = {.lex_state = 0, .external_lex_state = 7},
  [3302] = {.lex_state = 11, .external_lex_state = 44},
  [3303] = {.lex_state = 0, .external_lex_state = 7},
  [3304] = {.lex_state = 11, .external_lex_state = 44},
  [3305] = {.lex_state = 0, .external_lex_state = 7},
  [3306] = {.lex_state = 0, .external_lex_state = 45},
  [3307] = {.lex_state = 11, .external_lex_state = 44},
  [3308] = {.lex_state = 11, .external_lex_state = 44},
  [3309] = {.lex_state = 11, .external_lex_state = 44},
  [3310] = {.lex_state = 0, .external_lex_state = 7},
  [3311] = {.lex_state = 11, .external_lex_state = 44},
  [3312] = {.lex_state = 11, .external_lex_state = 44},
  [3313] = {.lex_state = 0, .external_lex_state = 7},
  [3314] = {.lex_state = 11, .external_lex_state = 44},
  [3315] = {.lex_state = 11, .external_lex_state = 44},
  [3316] = {.lex_state = 11, .external_lex_state = 44},
  [3317] = {.lex_state = 0, .external_lex_state = 7},
  [3318] = {.lex_state = 11, .external_lex_state = 44},
  [3319] = {.lex_state = 13, .external_lex_state = 44},
  [3320] = {.lex_state = 11, .external_lex_state = 44},
  [3321] = {.lex_state = 11, .external_lex_state = 44},
  [3322] = {.lex_state = 0, .external_lex_state = 7},
  [3323] = {.lex_state = 0, .external_lex_state = 7},
  [3324] = {.lex_state = 11, .external_lex_state = 44},
  [3325] = {.lex_state = 11, .external_lex_state = 44},
  [3326] = {.lex_state = 0, .external_lex_state = 7},
  [3327] = {.lex_state = 11, .external_lex_state = 44},
  [3328] = {.lex_state = 11, .external_lex_state = 44},
  [3329] = {.lex_state = 11, .external_lex_state = 44},
  [3330] = {.lex_state = 11, .external_lex_state = 44},
  [3331] = {.lex_state = 0, .external_lex_state = 46},
  [3332] = {.lex_state = 0, .external_lex_state = 7},
  [3333] = {.lex_state = 11, .external_lex_state = 44},
  [3334] = {.lex_state = 11, .external_lex_state = 44},
  [3335] = {.lex_state = 0, .external_lex_state = 7},
  [3336] = {.lex_state = 0, .external_lex_state = 45},
  [3337] = {.lex_state = 11, .external_lex_state = 44},
  [3338] = {.lex_state = 0, .external_lex_state = 46},
  [3339] = {.lex_state = 0, .external_lex_state = 46},
  [3340] = {.lex_state = 0, .external_lex_state = 46},
  [3341] = {.lex_state = 0, .external_lex_state = 46},
  [3342] = {.lex_state = 0, .external_lex_state = 46},
  [3343] = {.lex_state = 0, .external_lex_state = 7},
  [3344] = {.lex_state = 11, .external_lex_state = 44},
  [3345] = {.lex_state = 0, .external_lex_state = 46},
  [3346] = {.lex_state = 0, .external_lex_state = 7},
  [3347] = {.lex_state = 11, .external_lex_state = 44},
  [3348] = {.lex_state = 11, .external_lex_state = 44},
  [3349] = {.lex_state = 0, .external_lex_state = 46},
  [3350] = {.lex_state = 0, .external_lex_state = 46},
  [3351] = {.lex_state = 0, .external_lex_state = 46},
  [3352] = {.lex_state = 0, .external_lex_state = 46},
  [3353] = {.lex_state = 0, .external_lex_state = 46},
  [3354] = {.lex_state = 0, .external_lex_state = 46},
  [3355] = {.lex_state = 2, .external_lex_state = 44},
  [3356] = {.lex_state = 0, .external_lex_state = 46},
  [3357] = {.lex_state = 0, .external_lex_state = 46},
  [3358] = {.lex_state = 0, .external_lex_state = 46},
  [3359] = {.lex_state = 0, .external_lex_state = 46},
  [3360] = {.lex_state = 0, .external_lex_state = 46},
  [3361] = {.lex_state = 0, .external_lex_state = 46},
  [3362] = {.lex_state = 0, .external_lex_state = 46},
  [3363] = {.lex_state = 0, .external_lex_state = 46},
  [3364] = {.lex_state = 11, .external_lex_state = 44},
  [3365] = {.lex_state = 13, .external_lex_state = 44},
  [3366] = {.lex_state = 0, .external_lex_state = 46},
  [3367] = {.lex_state = 11, .external_lex_state = 44},
  [3368] = {.lex_state = 0, .external_lex_state = 46},
  [3369] = {.lex_state = 0, .external_lex_state = 46},
  [3370] = {.lex_state = 0, .external_lex_state = 46},
  [3371] = {.lex_state = 11, .external_lex_state = 44},
  [3372] = {.lex_state = 11, .external_lex_state = 44},
  [3373] = {.lex_state = 11, .external_lex_state = 44},
  [3374] = {.lex_state = 0, .external_lex_state = 45},
  [3375] = {.lex_state = 0, .external_lex_state = 7},
  [3376] = {.lex_state = 11, .external_lex_state = 44},
  [3377] = {.lex_state = 11, .external_lex_state = 44},
  [3378] = {.lex_state = 11, .external_lex_state = 44},
  [3379] = {.lex_state = 11, .external_lex_state = 44},
  [3380] = {.lex_state = 11, .external_lex_state = 44},
  [3381] = {.lex_state = 11, .external_lex_state = 44},
  [3382] = {.lex_state = 0, .external_lex_state = 7},
  [3383] = {.lex_state = 11, .external_lex_state = 44},
  [3384] = {.lex_state = 0, .external_lex_state = 7},
  [3385] = {.lex_state = 0, .external_lex_state = 47},
  [3386] = {.lex_state = 0, .external_lex_state = 47},
  [3387] = {.lex_state = 0, .external_lex_state = 47},
  [3388] = {.lex_state = 0, .external_lex_state = 47},
  [3389] = {.lex_state = 0, .external_lex_state = 47},
  [3390] = {.lex_state = 0, .external_lex_state = 47},
  [3391] = {.lex_state = 0, .external_lex_state = 47},
  [3392] = {.lex_state = 0, .external_lex_state = 47},
  [3393] = {.lex_state = 0, .external_lex_state = 47},
  [3394] = {.lex_state = 0, .external_lex_state = 47},
  [3395] = {.lex_state = 0, .external_lex_state = 47},
  [3396] = {.lex_state = 0, .external_lex_state = 47},
  [3397] = {.lex_state = 0, .external_lex_state = 47},
  [3398] = {.lex_state = 0, .external_lex_state = 47},
  [3399] = {.lex_state = 0, .external_lex_state = 47},
  [3400] = {.lex_state = 0, .external_lex_state = 47},
  [3401] = {.lex_state = 0, .external_lex_state = 47},
  [3402] = {.lex_state = 0, .external_lex_state = 47},
  [3403] = {.lex_state = 0, .external_lex_state = 47},
  [3404] = {.lex_state = 0, .external_lex_state = 47},
  [3405] = {.lex_state = 0, .external_lex_state = 47},
  [3406] = {.lex_state = 0, .external_lex_state = 47},
  [3407] = {.lex_state = 0, .external_lex_state = 47},
  [3408] = {.lex_state = 0, .external_lex_state = 47},
  [3409] = {.lex_state = 0, .external_lex_state = 47},
  [3410] = {.lex_state = 0, .external_lex_state = 47},
  [3411] = {.lex_state = 0, .external_lex_state = 47},
  [3412] = {.lex_state = 0, .external_lex_state = 47},
  [3413] = {.lex_state = 0, .external_lex_state = 47},
  [3414] = {.lex_state = 0, .external_lex_state = 47},
  [3415] = {.lex_state = 0, .external_lex_state = 47},
  [3416] = {.lex_state = 0, .external_lex_state = 47},
  [3417] = {.lex_state = 0, .external_lex_state = 47},
  [3418] = {.lex_state = 41, .external_lex_state = 44},
  [3419] = {.lex_state = 0, .external_lex_state = 2},
  [3420] = {.lex_state = 0, .external_lex_state = 48},
  [3421] = {.lex_state = 0, .external_lex_state = 47},
  [3422] = {.lex_state = 0, .external_lex_state = 47},
  [3423] = {.lex_state = 0, .external_lex_state = 49},
  [3424] = {.lex_state = 0, .external_lex_state = 48},
  [3425] = {.lex_state = 11, .external_lex_state = 44},
  [3426] = {.lex_state = 11, .external_lex_state = 44},
  [3427] = {.lex_state = 0, .external_lex_state = 47},
  [3428] = {.lex_state = 0, .external_lex_state = 44},
  [3429] = {.lex_state = 0, .external_lex_state = 47},
  [3430] = {.lex_state = 0, .external_lex_state = 47},
  [3431] = {.lex_state = 0, .external_lex_state = 47},
  [3432] = {.lex_state = 0, .external_lex_state = 47},
  [3433] = {.lex_state = 0, .external_lex_state = 47},
  [3434] = {.lex_state = 0, .external_lex_state = 47},
  [3435] = {.lex_state = 0, .external_lex_state = 47},
  [3436] = {.lex_state = 0, .external_lex_state = 48},
  [3437] = {.lex_state = 11, .external_lex_state = 44},
  [3438] = {.lex_state = 0, .external_lex_state = 47},
  [3439] = {.lex_state = 15, .external_lex_state = 44},
  [3440] = {.lex_state = 0, .external_lex_state = 47},
  [3441] = {.lex_state = 0, .external_lex_state = 47},
  [3442] = {.lex_state = 0, .external_lex_state = 47},
  [3443] = {.lex_state = 0, .external_lex_state = 47},
  [3444] = {.lex_state = 0, .external_lex_state = 47},
  [3445] = {.lex_state = 0, .external_lex_state = 47},
  [3446] = {.lex_state = 0, .external_lex_state = 47},
  [3447] = {.lex_state = 0, .external_lex_state = 47},
  [3448] = {.lex_state = 0, .external_lex_state = 47},
  [3449] = {.lex_state = 0, .external_lex_state = 47},
  [3450] = {.lex_state = 0, .external_lex_state = 47},
  [3451] = {.lex_state = 0, .external_lex_state = 47},
  [3452] = {.lex_state = 0, .external_lex_state = 47},
  [3453] = {.lex_state = 0, .external_lex_state = 47},
  [3454] = {.lex_state = 0, .external_lex_state = 47},
  [3455] = {.lex_state = 0, .external_lex_state = 47},
  [3456] = {.lex_state = 0, .external_lex_state = 47},
  [3457] = {.lex_state = 0, .external_lex_state = 47},
  [3458] = {.lex_state = 0, .external_lex_state = 47},
  [3459] = {.lex_state = 0, .external_lex_state = 47},
  [3460] = {.lex_state = 0, .external_lex_state = 47},
  [3461] = {.lex_state = 0, .external_lex_state = 47},
  [3462] = {.lex_state = 0, .external_lex_state = 47},
  [3463] = {.lex_state = 0, .external_lex_state = 47},
  [3464] = {.lex_state = 0, .external_lex_state = 47},
  [3465] = {.lex_state = 0, .external_lex_state = 47},
  [3466] = {.lex_state = 0, .external_lex_state = 47},
  [3467] = {.lex_state = 0, .external_lex_state = 47},
  [3468] = {.lex_state = 0, .external_lex_state = 47},
  [3469] = {.lex_state = 0, .external_lex_state = 47},
  [3470] = {.lex_state = 0, .external_lex_state = 47},
  [3471] = {.lex_state = 0, .external_lex_state = 47},
  [3472] = {.lex_state = 0, .external_lex_state = 47},
  [3473] = {.lex_state = 0, .external_lex_state = 47},
  [3474] = {.lex_state = 0, .external_lex_state = 47},
  [3475] = {.lex_state = 0, .external_lex_state = 47},
  [3476] = {.lex_state = 19, .external_lex_state = 44},
  [3477] = {.lex_state = 0, .external_lex_state = 47},
  [3478] = {.lex_state = 0, .external_lex_state = 47},
  [3479] = {.lex_state = 0, .external_lex_state = 47},
  [3480] = {.lex_state = 0, .external_lex_state = 47},
  [3481] = {.lex_state = 0, .external_lex_state = 47},
  [3482] = {.lex_state = 0, .external_lex_state = 47},
  [3483] = {.lex_state = 0, .external_lex_state = 47},
  [3484] = {.lex_state = 0, .external_lex_state = 47},
  [3485] = {.lex_state = 0, .external_lex_state = 47},
  [3486] = {.lex_state = 0, .external_lex_state = 47},
  [3487] = {.lex_state = 0, .external_lex_state = 47},
  [3488] = {.lex_state = 0, .external_lex_state = 47},
  [3489] = {.lex_state = 19, .external_lex_state = 44},
  [3490] = {.lex_state = 0, .external_lex_state = 47},
  [3491] = {.lex_state = 0, .external_lex_state = 47},
  [3492] = {.lex_state = 0, .external_lex_state = 47},
  [3493] = {.lex_state = 0, .external_lex_state = 47},
  [3494] = {.lex_state = 0, .external_lex_state = 47},
  [3495] = {.lex_state = 0, .external_lex_state = 47},
  [3496] = {.lex_state = 0, .external_lex_state = 47},
  [3497] = {.lex_state = 0, .external_lex_state = 47},
  [3498] = {.lex_state = 0, .external_lex_state = 47},
  [3499] = {.lex_state = 0, .external_lex_state = 47},
  [3500] = {.lex_state = 0, .external_lex_state = 47},
  [3501] = {.lex_state = 0, .external_lex_state = 47},
  [3502] = {.lex_state = 19, .external_lex_state = 44},
  [3503] = {.lex_state = 0, .external_lex_state = 47},
  [3504] = {.lex_state = 0, .external_lex_state = 47},
  [3505] = {.lex_state = 0, .external_lex_state = 47},
  [3506] = {.lex_state = 0, .external_lex_state = 47},
  [3507] = {.lex_state = 0, .external_lex_state = 47},
  [3508] = {.lex_state = 0, .external_lex_state = 47},
  [3509] = {.lex_state = 0, .external_lex_state = 47},
  [3510] = {.lex_state = 0, .external_lex_state = 47},
  [3511] = {.lex_state = 0, .external_lex_state = 47},
  [3512] = {.lex_state = 0, .external_lex_state = 47},
  [3513] = {.lex_state = 0, .external_lex_state = 47},
  [3514] = {.lex_state = 0, .external_lex_state = 47},
  [3515] = {.lex_state = 15, .external_lex_state = 44},
  [3516] = {.lex_state = 19, .external_lex_state = 44},
  [3517] = {.lex_state = 0, .external_lex_state = 47},
  [3518] = {.lex_state = 0, .external_lex_state = 47},
  [3519] = {.lex_state = 0, .external_lex_state = 47},
  [3520] = {.lex_state = 0, .external_lex_state = 47},
  [3521] = {.lex_state = 0, .external_lex_state = 47},
  [3522] = {.lex_state = 0, .external_lex_state = 47},
  [3523] = {.lex_state = 0, .external_lex_state = 47},
  [3524] = {.lex_state = 0, .external_lex_state = 47},
  [3525] = {.lex_state = 0, .external_lex_state = 47},
  [3526] = {.lex_state = 11, .external_lex_state = 44},
  [3527] = {.lex_state = 0, .external_lex_state = 47},
  [3528] = {.lex_state = 0, .external_lex_state = 47},
  [3529] = {.lex_state = 0, .external_lex_state = 47},
  [3530] = {.lex_state = 0, .external_lex_state = 47},
  [3531] = {.lex_state = 11, .external_lex_state = 44},
  [3532] = {.lex_state = 41, .external_lex_state = 44},
  [3533] = {.lex_state = 0, .external_lex_state = 2},
  [3534] = {.lex_state = 0, .external_lex_state = 48},
  [3535] = {.lex_state = 0, .external_lex_state = 47},
  [3536] = {.lex_state = 0, .external_lex_state = 47},
  [3537] = {.lex_state = 0, .external_lex_state = 49},
  [3538] = {.lex_state = 0, .external_lex_state = 48},
  [3539] = {.lex_state = 11, .external_lex_state = 44},
  [3540] = {.lex_state = 11, .external_lex_state = 44},
  [3541] = {.lex_state = 0, .external_lex_state = 47},
  [3542] = {.lex_state = 0, .external_lex_state = 44},
  [3543] = {.lex_state = 19, .external_lex_state = 44},
  [3544] = {.lex_state = 0, .external_lex_state = 47},
  [3545] = {.lex_state = 0, .external_lex_state = 47},
  [3546] = {.lex_state = 0, .external_lex_state = 47},
  [3547] = {.lex_state = 0, .external_lex_state = 47},
  [3548] = {.lex_state = 0, .external_lex_state = 48},
  [3549] = {.lex_state = 11, .external_lex_state = 44},
  [3550] = {.lex_state = 0, .external_lex_state = 47},
  [3551] = {.lex_state = 15, .external_lex_state = 44},
  [3552] = {.lex_state = 0, .external_lex_state = 47},
  [3553] = {.lex_state = 0, .external_lex_state = 47},
  [3554] = {.lex_state = 0, .external_lex_state = 47},
  [3555] = {.lex_state = 0, .external_lex_state = 47},
  [3556] = {.lex_state = 0, .external_lex_state = 47},
  [3557] = {.lex_state = 0, .external_lex_state = 47},
  [3558] = {.lex_state = 11, .external_lex_state = 44},
  [3559] = {.lex_state = 0, .external_lex_state = 47},
  [3560] = {.lex_state = 0, .external_lex_state = 47},
  [3561] = {.lex_state = 0, .external_lex_state = 47},
  [3562] = {.lex_state = 0, .external_lex_state = 2},
  [3563] = {.lex_state = 0, .external_lex_state = 47},
  [3564] = {.lex_state = 0, .external_lex_state = 47},
  [3565] = {.lex_state = 0, .external_lex_state = 49},
  [3566] = {.lex_state = 11, .external_lex_state = 44},
  [3567] = {.lex_state = 11, .external_lex_state = 44},
  [3568] = {.lex_state = 0, .external_lex_state = 47},
  [3569] = {.lex_state = 0, .external_lex_state = 44},
  [3570] = {.lex_state = 19, .external_lex_state = 44},
  [3571] = {.lex_state = 0, .external_lex_state = 47},
  [3572] = {.lex_state = 0, .external_lex_state = 47},
  [3573] = {.lex_state = 0, .external_lex_state = 47},
  [3574] = {.lex_state = 0, .external_lex_state = 47},
  [3575] = {.lex_state = 11, .external_lex_state = 44},
  [3576] = {.lex_state = 0, .external_lex_state = 47},
  [3577] = {.lex_state = 15, .external_lex_state = 44},
  [3578] = {.lex_state = 0, .external_lex_state = 47},
  [3579] = {.lex_state = 0, .external_lex_state = 47},
  [3580] = {.lex_state = 0, .external_lex_state = 47},
  [3581] = {.lex_state = 0, .external_lex_state = 47},
  [3582] = {.lex_state = 0, .external_lex_state = 47},
  [3583] = {.lex_state = 0, .external_lex_state = 47},
  [3584] = {.lex_state = 0, .external_lex_state = 47},
  [3585] = {.lex_state = 11, .external_lex_state = 44},
  [3586] = {.lex_state = 0, .external_lex_state = 47},
  [3587] = {.lex_state = 0, .external_lex_state = 47},
  [3588] = {.lex_state = 0, .external_lex_state = 2},
  [3589] = {.lex_state = 0, .external_lex_state = 47},
  [3590] = {.lex_state = 0, .external_lex_state = 47},
  [3591] = {.lex_state = 0, .external_lex_state = 49},
  [3592] = {.lex_state = 11, .external_lex_state = 44},
  [3593] = {.lex_state = 11, .external_lex_state = 44},
  [3594] = {.lex_state = 0, .external_lex_state = 47},
  [3595] = {.lex_state = 0, .external_lex_state = 44},
  [3596] = {.lex_state = 0, .external_lex_state = 47},
  [3597] = {.lex_state = 19, .external_lex_state = 44},
  [3598] = {.lex_state = 0, .external_lex_state = 47},
  [3599] = {.lex_state = 0, .external_lex_state = 47},
  [3600] = {.lex_state = 0, .external_lex_state = 47},
  [3601] = {.lex_state = 11, .external_lex_state = 44},
  [3602] = {.lex_state = 0, .external_lex_state = 47},
  [3603] = {.lex_state = 0, .external_lex_state = 47},
  [3604] = {.lex_state = 0, .external_lex_state = 47},
  [3605] = {.lex_state = 0, .external_lex_state = 47},
  [3606] = {.lex_state = 0, .external_lex_state = 47},
  [3607] = {.lex_state = 0, .external_lex_state = 47},
  [3608] = {.lex_state = 0, .external_lex_state = 47},
  [3609] = {.lex_state = 0, .external_lex_state = 47},
  [3610] = {.lex_state = 0, .external_lex_state = 47},
  [3611] = {.lex_state = 11, .external_lex_state = 44},
  [3612] = {.lex_state = 0, .external_lex_state = 47},
  [3613] = {.lex_state = 0, .external_lex_state = 47},
  [3614] = {.lex_state = 0, .external_lex_state = 47},
  [3615] = {.lex_state = 0, .external_lex_state = 49},
  [3616] = {.lex_state = 11, .external_lex_state = 44},
  [3617] = {.lex_state = 11, .external_lex_state = 44},
  [3618] = {.lex_state = 0, .external_lex_state = 47},
  [3619] = {.lex_state = 0, .external_lex_state = 44},
  [3620] = {.lex_state = 0, .external_lex_state = 47},
  [3621] = {.lex_state = 0, .external_lex_state = 47},
  [3622] = {.lex_state = 19, .external_lex_state = 44},
  [3623] = {.lex_state = 15, .external_lex_state = 44},
  [3624] = {.lex_state = 0, .external_lex_state = 47},
  [3625] = {.lex_state = 11, .external_lex_state = 44},
  [3626] = {.lex_state = 0, .external_lex_state = 47},
  [3627] = {.lex_state = 0, .external_lex_state = 47},
  [3628] = {.lex_state = 0, .external_lex_state = 47},
  [3629] = {.lex_state = 0, .external_lex_state = 47},
  [3630] = {.lex_state = 0, .external_lex_state = 47},
  [3631] = {.lex_state = 0, .external_lex_state = 47},
  [3632] = {.lex_state = 0, .external_lex_state = 47},
  [3633] = {.lex_state = 0, .external_lex_state = 47},
  [3634] = {.lex_state = 0, .external_lex_state = 47},
  [3635] = {.lex_state = 0, .external_lex_state = 47},
  [3636] = {.lex_state = 0, .external_lex_state = 47},
  [3637] = {.lex_state = 11, .external_lex_state = 44},
  [3638] = {.lex_state = 0, .external_lex_state = 47},
  [3639] = {.lex_state = 0, .external_lex_state = 49},
  [3640] = {.lex_state = 11, .external_lex_state = 44},
  [3641] = {.lex_state = 11, .external_lex_state = 44},
  [3642] = {.lex_state = 0, .external_lex_state = 47},
  [3643] = {.lex_state = 0, .external_lex_state = 44},
  [3644] = {.lex_state = 0, .external_lex_state = 47},
  [3645] = {.lex_state = 0, .external_lex_state = 47},
  [3646] = {.lex_state = 0, .external_lex_state = 47},
  [3647] = {.lex_state = 0, .external_lex_state = 47},
  [3648] = {.lex_state = 19, .external_lex_state = 44},
  [3649] = {.lex_state = 11, .external_lex_state = 44},
  [3650] = {.lex_state = 0, .external_lex_state = 47},
  [3651] = {.lex_state = 0, .external_lex_state = 47},
  [3652] = {.lex_state = 0, .external_lex_state = 47},
  [3653] = {.lex_state = 0, .external_lex_state = 47},
  [3654] = {.lex_state = 0, .external_lex_state = 47},
  [3655] = {.lex_state = 0, .external_lex_state = 47},
  [3656] = {.lex_state = 0, .external_lex_state = 47},
  [3657] = {.lex_state = 0, .external_lex_state = 47},
  [3658] = {.lex_state = 0, .external_lex_state = 47},
  [3659] = {.lex_state = 0, .external_lex_state = 47},
  [3660] = {.lex_state = 0, .external_lex_state = 47},
  [3661] = {.lex_state = 0, .external_lex_state = 47},
  [3662] = {.lex_state = 11, .external_lex_state = 44},
  [3663] = {.lex_state = 0, .external_lex_state = 49},
  [3664] = {.lex_state = 11, .external_lex_state = 44},
  [3665] = {.lex_state = 11, .external_lex_state = 44},
  [3666] = {.lex_state = 0, .external_lex_state = 47},
  [3667] = {.lex_state = 0, .external_lex_state = 44},
  [3668] = {.lex_state = 0, .external_lex_state = 47},
  [3669] = {.lex_state = 0, .external_lex_state = 47},
  [3670] = {.lex_state = 0, .external_lex_state = 47},
  [3671] = {.lex_state = 0, .external_lex_state = 47},
  [3672] = {.lex_state = 0, .external_lex_state = 47},
  [3673] = {.lex_state = 11, .external_lex_state = 44},
  [3674] = {.lex_state = 19, .external_lex_state = 44},
  [3675] = {.lex_state = 0, .external_lex_state = 47},
  [3676] = {.lex_state = 0, .external_lex_state = 47},
  [3677] = {.lex_state = 0, .external_lex_state = 47},
  [3678] = {.lex_state = 0, .external_lex_state = 47},
  [3679] = {.lex_state = 0, .external_lex_state = 47},
  [3680] = {.lex_state = 0, .external_lex_state = 47},
  [3681] = {.lex_state = 0, .external_lex_state = 47},
  [3682] = {.lex_state = 0, .external_lex_state = 47},
  [3683] = {.lex_state = 0, .external_lex_state = 47},
  [3684] = {.lex_state = 0, .external_lex_state = 47},
  [3685] = {.lex_state = 0, .external_lex_state = 47},
  [3686] = {.lex_state = 0, .external_lex_state = 47},
  [3687] = {.lex_state = 0, .external_lex_state = 49},
  [3688] = {.lex_state = 11, .external_lex_state = 44},
  [3689] = {.lex_state = 11, .external_lex_state = 44},
  [3690] = {.lex_state = 11, .external_lex_state = 44},
  [3691] = {.lex_state = 0, .external_lex_state = 44},
  [3692] = {.lex_state = 0, .external_lex_state = 47},
  [3693] = {.lex_state = 0, .external_lex_state = 47},
  [3694] = {.lex_state = 0, .external_lex_state = 47},
  [3695] = {.lex_state = 0, .external_lex_state = 47},
  [3696] = {.lex_state = 0, .external_lex_state = 47},
  [3697] = {.lex_state = 11, .external_lex_state = 44},
  [3698] = {.lex_state = 0, .external_lex_state = 47},
  [3699] = {.lex_state = 19, .external_lex_state = 44},
  [3700] = {.lex_state = 0, .external_lex_state = 47},
  [3701] = {.lex_state = 0, .external_lex_state = 47},
  [3702] = {.lex_state = 0, .external_lex_state = 47},
  [3703] = {.lex_state = 0, .external_lex_state = 47},
  [3704] = {.lex_state = 0, .external_lex_state = 47},
  [3705] = {.lex_state = 0, .external_lex_state = 47},
  [3706] = {.lex_state = 15, .external_lex_state = 44},
  [3707] = {.lex_state = 0, .external_lex_state = 47},
  [3708] = {.lex_state = 0, .external_lex_state = 47},
  [3709] = {.lex_state = 0, .external_lex_state = 47},
  [3710] = {.lex_state = 0, .external_lex_state = 49},
  [3711] = {.lex_state = 11, .external_lex_state = 44},
  [3712] = {.lex_state = 11, .external_lex_state = 44},
  [3713] = {.lex_state = 0, .external_lex_state = 47},
  [3714] = {.lex_state = 0, .external_lex_state = 44},
  [3715] = {.lex_state = 0, .external_lex_state = 47},
  [3716] = {.lex_state = 0, .external_lex_state = 47},
  [3717] = {.lex_state = 11, .external_lex_state = 44},
  [3718] = {.lex_state = 0, .external_lex_state = 47},
  [3719] = {.lex_state = 0, .external_lex_state = 47},
  [3720] = {.lex_state = 11, .external_lex_state = 44},
  [3721] = {.lex_state = 0, .external_lex_state = 47},
  [3722] = {.lex_state = 0, .external_lex_state = 47},
  [3723] = {.lex_state = 0, .external_lex_state = 47},
  [3724] = {.lex_state = 0, .external_lex_state = 47},
  [3725] = {.lex_state = 19, .external_lex_state = 44},
  [3726] = {.lex_state = 0, .external_lex_state = 47},
  [3727] = {.lex_state = 0, .external_lex_state = 47},
  [3728] = {.lex_state = 0, .external_lex_state = 47},
  [3729] = {.lex_state = 0, .external_lex_state = 47},
  [3730] = {.lex_state = 0, .external_lex_state = 47},
  [3731] = {.lex_state = 0, .external_lex_state = 47},
  [3732] = {.lex_state = 0, .external_lex_state = 47},
  [3733] = {.lex_state = 0, .external_lex_state = 49},
  [3734] = {.lex_state = 11, .external_lex_state = 44},
  [3735] = {.lex_state = 11, .external_lex_state = 44},
  [3736] = {.lex_state = 0, .external_lex_state = 47},
  [3737] = {.lex_state = 0, .external_lex_state = 44},
  [3738] = {.lex_state = 0, .external_lex_state = 47},
  [3739] = {.lex_state = 0, .external_lex_state = 47},
  [3740] = {.lex_state = 0, .external_lex_state = 47},
  [3741] = {.lex_state = 0, .external_lex_state = 47},
  [3742] = {.lex_state = 11, .external_lex_state = 44},
  [3743] = {.lex_state = 11, .external_lex_state = 44},
  [3744] = {.lex_state = 0, .external_lex_state = 47},
  [3745] = {.lex_state = 0, .external_lex_state = 47},
  [3746] = {.lex_state = 0, .external_lex_state = 47},
  [3747] = {.lex_state = 0, .external_lex_state = 47},
  [3748] = {.lex_state = 0, .external_lex_state = 47},
  [3749] = {.lex_state = 0, .external_lex_state = 47},
  [3750] = {.lex_state = 19, .external_lex_state = 44},
  [3751] = {.lex_state = 0, .external_lex_state = 47},
  [3752] = {.lex_state = 0, .external_lex_state = 47},
  [3753] = {.lex_state = 0, .external_lex_state = 47},
  [3754] = {.lex_state = 0, .external_lex_state = 47},
  [3755] = {.lex_state = 0, .external_lex_state = 47},
  [3756] = {.lex_state = 0, .external_lex_state = 49},
  [3757] = {.lex_state = 11, .external_lex_state = 44},
  [3758] = {.lex_state = 11, .external_lex_state = 44},
  [3759] = {.lex_state = 0, .external_lex_state = 47},
  [3760] = {.lex_state = 0, .external_lex_state = 44},
  [3761] = {.lex_state = 0, .external_lex_state = 47},
  [3762] = {.lex_state = 0, .external_lex_state = 47},
  [3763] = {.lex_state = 0, .external_lex_state = 47},
  [3764] = {.lex_state = 0, .external_lex_state = 47},
  [3765] = {.lex_state = 0, .external_lex_state = 47},
  [3766] = {.lex_state = 11, .external_lex_state = 44},
  [3767] = {.lex_state = 0, .external_lex_state = 47},
  [3768] = {.lex_state = 11, .external_lex_state = 44},
  [3769] = {.lex_state = 0, .external_lex_state = 47},
  [3770] = {.lex_state = 0, .external_lex_state = 47},
  [3771] = {.lex_state = 0, .external_lex_state = 47},
  [3772] = {.lex_state = 0, .external_lex_state = 47},
  [3773] = {.lex_state = 0, .external_lex_state = 47},
  [3774] = {.lex_state = 0, .external_lex_state = 47},
  [3775] = {.lex_state = 19, .external_lex_state = 44},
  [3776] = {.lex_state = 0, .external_lex_state = 47},
  [3777] = {.lex_state = 0, .external_lex_state = 47},
  [3778] = {.lex_state = 11, .external_lex_state = 44},
  [3779] = {.lex_state = 0, .external_lex_state = 49},
  [3780] = {.lex_state = 11, .external_lex_state = 44},
  [3781] = {.lex_state = 11, .external_lex_state = 44},
  [3782] = {.lex_state = 0, .external_lex_state = 47},
  [3783] = {.lex_state = 0, .external_lex_state = 44},
  [3784] = {.lex_state = 0, .external_lex_state = 47},
  [3785] = {.lex_state = 0, .external_lex_state = 47},
  [3786] = {.lex_state = 0, .external_lex_state = 47},
  [3787] = {.lex_state = 0, .external_lex_state = 47},
  [3788] = {.lex_state = 0, .external_lex_state = 47},
  [3789] = {.lex_state = 11, .external_lex_state = 44},
  [3790] = {.lex_state = 0, .external_lex_state = 47},
  [3791] = {.lex_state = 0, .external_lex_state = 47},
  [3792] = {.lex_state = 0, .external_lex_state = 47},
  [3793] = {.lex_state = 11, .external_lex_state = 44},
  [3794] = {.lex_state = 0, .external_lex_state = 47},
  [3795] = {.lex_state = 0, .external_lex_state = 47},
  [3796] = {.lex_state = 0, .external_lex_state = 47},
  [3797] = {.lex_state = 0, .external_lex_state = 47},
  [3798] = {.lex_state = 0, .external_lex_state = 47},
  [3799] = {.lex_state = 0, .external_lex_state = 47},
  [3800] = {.lex_state = 19, .external_lex_state = 44},
  [3801] = {.lex_state = 0, .external_lex_state = 47},
  [3802] = {.lex_state = 0, .external_lex_state = 49},
  [3803] = {.lex_state = 11, .external_lex_state = 44},
  [3804] = {.lex_state = 11, .external_lex_state = 44},
  [3805] = {.lex_state = 0, .external_lex_state = 47},
  [3806] = {.lex_state = 0, .external_lex_state = 44},
  [3807] = {.lex_state = 0, .external_lex_state = 47},
  [3808] = {.lex_state = 0, .external_lex_state = 47},
  [3809] = {.lex_state = 0, .external_lex_state = 47},
  [3810] = {.lex_state = 0, .external_lex_state = 47},
  [3811] = {.lex_state = 0, .external_lex_state = 47},
  [3812] = {.lex_state = 11, .external_lex_state = 44},
  [3813] = {.lex_state = 0, .external_lex_state = 47},
  [3814] = {.lex_state = 0, .external_lex_state = 47},
  [3815] = {.lex_state = 0, .external_lex_state = 47},
  [3816] = {.lex_state = 0, .external_lex_state = 47},
  [3817] = {.lex_state = 0, .external_lex_state = 47},
  [3818] = {.lex_state = 11, .external_lex_state = 44},
  [3819] = {.lex_state = 0, .external_lex_state = 47},
  [3820] = {.lex_state = 0, .external_lex_state = 47},
  [3821] = {.lex_state = 0, .external_lex_state = 47},
  [3822] = {.lex_state = 0, .external_lex_state = 47},
  [3823] = {.lex_state = 0, .external_lex_state = 47},
  [3824] = {.lex_state = 0, .external_lex_state = 47},
  [3825] = {.lex_state = 0, .external_lex_state = 49},
  [3826] = {.lex_state = 11, .external_lex_state = 44},
  [3827] = {.lex_state = 11, .external_lex_state = 44},
  [3828] = {.lex_state = 19, .external_lex_state = 44},
  [3829] = {.lex_state = 0, .external_lex_state = 44},
  [3830] = {.lex_state = 0, .external_lex_state = 47},
  [3831] = {.lex_state = 0, .external_lex_state = 47},
  [3832] = {.lex_state = 0, .external_lex_state = 47},
  [3833] = {.lex_state = 0, .external_lex_state = 47},
  [3834] = {.lex_state = 0, .external_lex_state = 47},
  [3835] = {.lex_state = 11, .external_lex_state = 44},
  [3836] = {.lex_state = 0, .external_lex_state = 47},
  [3837] = {.lex_state = 0, .external_lex_state = 47},
  [3838] = {.lex_state = 0, .external_lex_state = 47},
  [3839] = {.lex_state = 0, .external_lex_state = 47},
  [3840] = {.lex_state = 0, .external_lex_state = 47},
  [3841] = {.lex_state = 0, .external_lex_state = 47},
  [3842] = {.lex_state = 0, .external_lex_state = 47},
  [3843] = {.lex_state = 0, .external_lex_state = 47},
  [3844] = {.lex_state = 11, .external_lex_state = 44},
  [3845] = {.lex_state = 0, .external_lex_state = 47},
  [3846] = {.lex_state = 0, .external_lex_state = 47},
  [3847] = {.lex_state = 0, .external_lex_state = 47},
  [3848] = {.lex_state = 0, .external_lex_state = 49},
  [3849] = {.lex_state = 11, .external_lex_state = 44},
  [3850] = {.lex_state = 11, .external_lex_state = 44},
  [3851] = {.lex_state = 0, .external_lex_state = 47},
  [3852] = {.lex_state = 0, .external_lex_state = 44},
  [3853] = {.lex_state = 0, .external_lex_state = 47},
  [3854] = {.lex_state = 0, .external_lex_state = 47},
  [3855] = {.lex_state = 19, .external_lex_state = 44},
  [3856] = {.lex_state = 0, .external_lex_state = 50},
  [3857] = {.lex_state = 0, .external_lex_state = 51},
  [3858] = {.lex_state = 11, .external_lex_state = 44},
  [3859] = {.lex_state = 0, .external_lex_state = 47},
  [3860] = {.lex_state = 0, .external_lex_state = 47},
  [3861] = {.lex_state = 0, .external_lex_state = 47},
  [3862] = {.lex_state = 0, .external_lex_state = 47},
  [3863] = {.lex_state = 0, .external_lex_state = 47},
  [3864] = {.lex_state = 15, .external_lex_state = 44},
  [3865] = {.lex_state = 15, .external_lex_state = 44},
  [3866] = {.lex_state = 0, .external_lex_state = 47},
  [3867] = {.lex_state = 0, .external_lex_state = 47},
  [3868] = {.lex_state = 0, .external_lex_state = 47},
  [3869] = {.lex_state = 0, .external_lex_state = 47},
  [3870] = {.lex_state = 0, .external_lex_state = 47},
  [3871] = {.lex_state = 0, .external_lex_state = 49},
  [3872] = {.lex_state = 11, .external_lex_state = 44},
  [3873] = {.lex_state = 11, .external_lex_state = 44},
  [3874] = {.lex_state = 0, .external_lex_state = 47},
  [3875] = {.lex_state = 0, .external_lex_state = 44},
  [3876] = {.lex_state = 0, .external_lex_state = 47},
  [3877] = {.lex_state = 0, .external_lex_state = 47},
  [3878] = {.lex_state = 0, .external_lex_state = 50},
  [3879] = {.lex_state = 0, .external_lex_state = 47},
  [3880] = {.lex_state = 0, .external_lex_state = 47},
  [3881] = {.lex_state = 11, .external_lex_state = 44},
  [3882] = {.lex_state = 0, .external_lex_state = 47},
  [3883] = {.lex_state = 0, .external_lex_state = 47},
  [3884] = {.lex_state = 0, .external_lex_state = 47},
  [3885] = {.lex_state = 0, .external_lex_state = 47},
  [3886] = {.lex_state = 19, .external_lex_state = 44},
  [3887] = {.lex_state = 0, .external_lex_state = 51},
  [3888] = {.lex_state = 0, .external_lex_state = 51},
  [3889] = {.lex_state = 0, .external_lex_state = 47},
  [3890] = {.lex_state = 0, .external_lex_state = 47},
  [3891] = {.lex_state = 0, .external_lex_state = 47},
  [3892] = {.lex_state = 0, .external_lex_state = 47},
  [3893] = {.lex_state = 0, .external_lex_state = 47},
  [3894] = {.lex_state = 0, .external_lex_state = 49},
  [3895] = {.lex_state = 11, .external_lex_state = 44},
  [3896] = {.lex_state = 11, .external_lex_state = 44},
  [3897] = {.lex_state = 0, .external_lex_state = 47},
  [3898] = {.lex_state = 0, .external_lex_state = 44},
  [3899] = {.lex_state = 0, .external_lex_state = 47},
  [3900] = {.lex_state = 0, .external_lex_state = 47},
  [3901] = {.lex_state = 0, .external_lex_state = 47},
  [3902] = {.lex_state = 0, .external_lex_state = 47},
  [3903] = {.lex_state = 0, .external_lex_state = 47},
  [3904] = {.lex_state = 11, .external_lex_state = 44},
  [3905] = {.lex_state = 0, .external_lex_state = 47},
  [3906] = {.lex_state = 0, .external_lex_state = 47},
  [3907] = {.lex_state = 0, .external_lex_state = 47},
  [3908] = {.lex_state = 11, .external_lex_state = 44},
  [3909] = {.lex_state = 0, .external_lex_state = 47},
  [3910] = {.lex_state = 0, .external_lex_state = 47},
  [3911] = {.lex_state = 0, .external_lex_state = 47},
  [3912] = {.lex_state = 0, .external_lex_state = 47},
  [3913] = {.lex_state = 0, .external_lex_state = 47},
  [3914] = {.lex_state = 0, .external_lex_state = 47},
  [3915] = {.lex_state = 19, .external_lex_state = 44},
  [3916] = {.lex_state = 0, .external_lex_state = 50},
  [3917] = {.lex_state = 0, .external_lex_state = 49},
  [3918] = {.lex_state = 11, .external_lex_state = 44},
  [3919] = {.lex_state = 11, .external_lex_state = 44},
  [3920] = {.lex_state = 0, .external_lex_state = 51},
  [3921] = {.lex_state = 0, .external_lex_state = 44},
  [3922] = {.lex_state = 0, .external_lex_state = 47},
  [3923] = {.lex_state = 0, .external_lex_state = 47},
  [3924] = {.lex_state = 0, .external_lex_state = 47},
  [3925] = {.lex_state = 0, .external_lex_state = 47},
  [3926] = {.lex_state = 0, .external_lex_state = 47},
  [3927] = {.lex_state = 11, .external_lex_state = 44},
  [3928] = {.lex_state = 0, .external_lex_state = 47},
  [3929] = {.lex_state = 0, .external_lex_state = 47},
  [3930] = {.lex_state = 0, .external_lex_state = 47},
  [3931] = {.lex_state = 0, .external_lex_state = 47},
  [3932] = {.lex_state = 0, .external_lex_state = 47},
  [3933] = {.lex_state = 0, .external_lex_state = 47},
  [3934] = {.lex_state = 0, .external_lex_state = 47},
  [3935] = {.lex_state = 0, .external_lex_state = 47},
  [3936] = {.lex_state = 11, .external_lex_state = 44},
  [3937] = {.lex_state = 0, .external_lex_state = 47},
  [3938] = {.lex_state = 0, .external_lex_state = 47},
  [3939] = {.lex_state = 0, .external_lex_state = 47},
  [3940] = {.lex_state = 0, .external_lex_state = 49},
  [3941] = {.lex_state = 11, .external_lex_state = 44},
  [3942] = {.lex_state = 11, .external_lex_state = 44},
  [3943] = {.lex_state = 0, .external_lex_state = 47},
  [3944] = {.lex_state = 0, .external_lex_state = 44},
  [3945] = {.lex_state = 0, .external_lex_state = 47},
  [3946] = {.lex_state = 0, .external_lex_state = 47},
  [3947] = {.lex_state = 0, .external_lex_state = 47},
  [3948] = {.lex_state = 0, .external_lex_state = 47},
  [3949] = {.lex_state = 19, .external_lex_state = 44},
  [3950] = {.lex_state = 11, .external_lex_state = 44},
  [3951] = {.lex_state = 0, .external_lex_state = 50},
  [3952] = {.lex_state = 0, .external_lex_state = 51},
  [3953] = {.lex_state = 0, .external_lex_state = 47},
  [3954] = {.lex_state = 0, .external_lex_state = 47},
  [3955] = {.lex_state = 0, .external_lex_state = 47},
  [3956] = {.lex_state = 0, .external_lex_state = 47},
  [3957] = {.lex_state = 0, .external_lex_state = 47},
  [3958] = {.lex_state = 0, .external_lex_state = 47},
  [3959] = {.lex_state = 0, .external_lex_state = 47},
  [3960] = {.lex_state = 0, .external_lex_state = 47},
  [3961] = {.lex_state = 0, .external_lex_state = 47},
  [3962] = {.lex_state = 0, .external_lex_state = 47},
  [3963] = {.lex_state = 0, .external_lex_state = 49},
  [3964] = {.lex_state = 11, .external_lex_state = 44},
  [3965] = {.lex_state = 11, .external_lex_state = 44},
  [3966] = {.lex_state = 0, .external_lex_state = 47},
  [3967] = {.lex_state = 0, .external_lex_state = 44},
  [3968] = {.lex_state = 0, .external_lex_state = 47},
  [3969] = {.lex_state = 0, .external_lex_state = 47},
  [3970] = {.lex_state = 11, .external_lex_state = 44},
  [3971] = {.lex_state = 11, .external_lex_state = 44},
  [3972] = {.lex_state = 0, .external_lex_state = 47},
  [3973] = {.lex_state = 0, .external_lex_state = 47},
  [3974] = {.lex_state = 0, .external_lex_state = 47},
  [3975] = {.lex_state = 0, .external_lex_state = 47},
  [3976] = {.lex_state = 0, .external_lex_state = 47},
  [3977] = {.lex_state = 0, .external_lex_state = 47},
  [3978] = {.lex_state = 19, .external_lex_state = 44},
  [3979] = {.lex_state = 0, .external_lex_state = 50},
  [3980] = {.lex_state = 0, .external_lex_state = 47},
  [3981] = {.lex_state = 0, .external_lex_state = 47},
  [3982] = {.lex_state = 0, .external_lex_state = 47},
  [3983] = {.lex_state = 0, .external_lex_state = 49},
  [3984] = {.lex_state = 11, .external_lex_state = 44},
  [3985] = {.lex_state = 11, .external_lex_state = 44},
  [3986] = {.lex_state = 0, .external_lex_state = 47},
  [3987] = {.lex_state = 0, .external_lex_state = 44},
  [3988] = {.lex_state = 0, .external_lex_state = 49},
  [3989] = {.lex_state = 11, .external_lex_state = 44},
  [3990] = {.lex_state = 0, .external_lex_state = 52},
  [3991] = {.lex_state = 0, .external_lex_state = 47},
  [3992] = {.lex_state = 0, .external_lex_state = 47},
  [3993] = {.lex_state = 15, .external_lex_state = 44},
  [3994] = {.lex_state = 0, .external_lex_state = 47},
  [3995] = {.lex_state = 0, .external_lex_state = 49},
  [3996] = {.lex_state = 11, .external_lex_state = 44},
  [3997] = {.lex_state = 11, .external_lex_state = 44},
  [3998] = {.lex_state = 0, .external_lex_state = 47},
  [3999] = {.lex_state = 0, .external_lex_state = 44},
  [4000] = {.lex_state = 0, .external_lex_state = 47},
  [4001] = {.lex_state = 11, .external_lex_state = 44},
  [4002] = {.lex_state = 0, .external_lex_state = 47},
  [4003] = {.lex_state = 0, .external_lex_state = 47},
  [4004] = {.lex_state = 0, .external_lex_state = 47},
  [4005] = {.lex_state = 0, .external_lex_state = 47},
  [4006] = {.lex_state = 0, .external_lex_state = 47},
  [4007] = {.lex_state = 0, .external_lex_state = 49},
  [4008] = {.lex_state = 11, .external_lex_state = 44},
  [4009] = {.lex_state = 11, .external_lex_state = 44},
  [4010] = {.lex_state = 0, .external_lex_state = 47},
  [4011] = {.lex_state = 0, .external_lex_state = 44},
  [4012] = {.lex_state = 11, .external_lex_state = 44},
  [4013] = {.lex_state = 11, .external_lex_state = 44},
  [4014] = {.lex_state = 0, .external_lex_state = 47},
  [4015] = {.lex_state = 0, .external_lex_state = 51},
  [4016] = {.lex_state = 0, .external_lex_state = 47},
  [4017] = {.lex_state = 0, .external_lex_state = 47},
  [4018] = {.lex_state = 0, .external_lex_state = 47},
  [4019] = {.lex_state = 0, .external_lex_state = 49},
  [4020] = {.lex_state = 11, .external_lex_state = 44},
  [4021] = {.lex_state = 11, .external_lex_state = 44},
  [4022] = {.lex_state = 0, .external_lex_state = 44},
  [4023] = {.lex_state = 0, .external_lex_state = 47},
  [4024] = {.lex_state = 11, .external_lex_state = 44},
  [4025] = {.lex_state = 0, .external_lex_state = 53},
  [4026] = {.lex_state = 0, .external_lex_state = 47},
  [4027] = {.lex_state = 0, .external_lex_state = 47},
  [4028] = {.lex_state = 0, .external_lex_state = 54},
  [4029] = {.lex_state = 0, .external_lex_state = 47},
  [4030] = {.lex_state = 0, .external_lex_state = 47},
  [4031] = {.lex_state = 0, .external_lex_state = 47},
  [4032] = {.lex_state = 19, .external_lex_state = 44},
  [4033] = {.lex_state = 0, .external_lex_state = 50},
  [4034] = {.lex_state = 0, .external_lex_state = 47},
  [4035] = {.lex_state = 0, .external_lex_state = 45},
  [4036] = {.lex_state = 0, .external_lex_state = 51},
  [4037] = {.lex_state = 0, .external_lex_state = 47},
  [4038] = {.lex_state = 11, .external_lex_state = 44},
  [4039] = {.lex_state = 0, .external_lex_state = 47},
  [4040] = {.lex_state = 0, .external_lex_state = 47},
  [4041] = {.lex_state = 0, .external_lex_state = 47},
  [4042] = {.lex_state = 0, .external_lex_state = 49},
  [4043] = {.lex_state = 11, .external_lex_state = 44},
  [4044] = {.lex_state = 0, .external_lex_state = 52},
  [4045] = {.lex_state = 0, .external_lex_state = 47},
  [4046] = {.lex_state = 0, .external_lex_state = 47},
  [4047] = {.lex_state = 0, .external_lex_state = 47},
  [4048] = {.lex_state = 0, .external_lex_state = 47},
  [4049] = {.lex_state = 0, .external_lex_state = 44},
  [4050] = {.lex_state = 0, .external_lex_state = 47},
  [4051] = {.lex_state = 0, .external_lex_state = 47},
  [4052] = {.lex_state = 0, .external_lex_state = 47},
  [4053] = {.lex_state = 0, .external_lex_state = 47},
  [4054] = {.lex_state = 0, .external_lex_state = 47},
  [4055] = {.lex_state = 0, .external_lex_state = 47},
  [4056] = {.lex_state = 0, .external_lex_state = 47},
  [4057] = {.lex_state = 0, .external_lex_state = 53},
  [4058] = {.lex_state = 15, .external_lex_state = 44},
  [4059] = {.lex_state = 11, .external_lex_state = 44},
  [4060] = {.lex_state = 0, .external_lex_state = 47},
  [4061] = {.lex_state = 0, .external_lex_state = 47},
  [4062] = {.lex_state = 0, .external_lex_state = 47},
  [4063] = {.lex_state = 0, .external_lex_state = 47},
  [4064] = {.lex_state = 0, .external_lex_state = 53},
  [4065] = {.lex_state = 0, .external_lex_state = 47},
  [4066] = {.lex_state = 0, .external_lex_state = 54},
  [4067] = {.lex_state = 0, .external_lex_state = 47},
  [4068] = {.lex_state = 0, .external_lex_state = 54},
  [4069] = {.lex_state = 0, .external_lex_state = 47},
  [4070] = {.lex_state = 11, .external_lex_state = 44},
  [4071] = {.lex_state = 0, .external_lex_state = 47},
  [4072] = {.lex_state = 0, .external_lex_state = 45},
  [4073] = {.lex_state = 0, .external_lex_state = 48},
  [4074] = {.lex_state = 19, .external_lex_state = 44},
  [4075] = {.lex_state = 0, .external_lex_state = 47},
  [4076] = {.lex_state = 0, .external_lex_state = 47},
  [4077] = {.lex_state = 0, .external_lex_state = 50},
  [4078] = {.lex_state = 0, .external_lex_state = 51},
  [4079] = {.lex_state = 19, .external_lex_state = 44},
  [4080] = {.lex_state = 0, .external_lex_state = 50},
  [4081] = {.lex_state = 11, .external_lex_state = 44},
  [4082] = {.lex_state = 0, .external_lex_state = 47},
  [4083] = {.lex_state = 0, .external_lex_state = 47},
  [4084] = {.lex_state = 0, .external_lex_state = 47},
  [4085] = {.lex_state = 0, .external_lex_state = 2},
  [4086] = {.lex_state = 0, .external_lex_state = 47},
  [4087] = {.lex_state = 0, .external_lex_state = 47},
  [4088] = {.lex_state = 0, .external_lex_state = 47},
  [4089] = {.lex_state = 0, .external_lex_state = 2},
  [4090] = {.lex_state = 0, .external_lex_state = 49},
  [4091] = {.lex_state = 0, .external_lex_state = 52},
  [4092] = {.lex_state = 0, .external_lex_state = 47},
  [4093] = {.lex_state = 0, .external_lex_state = 2},
  [4094] = {.lex_state = 0, .external_lex_state = 44},
  [4095] = {.lex_state = 15, .external_lex_state = 44},
  [4096] = {.lex_state = 0, .external_lex_state = 47},
  [4097] = {.lex_state = 0, .external_lex_state = 47},
  [4098] = {.lex_state = 0, .external_lex_state = 47},
  [4099] = {.lex_state = 11, .external_lex_state = 44},
  [4100] = {.lex_state = 0, .external_lex_state = 55},
  [4101] = {.lex_state = 0, .external_lex_state = 47},
  [4102] = {.lex_state = 0, .external_lex_state = 56},
  [4103] = {.lex_state = 0, .external_lex_state = 2},
  [4104] = {.lex_state = 11, .external_lex_state = 44},
  [4105] = {.lex_state = 11, .external_lex_state = 44},
  [4106] = {.lex_state = 0, .external_lex_state = 56},
  [4107] = {.lex_state = 11, .external_lex_state = 44},
  [4108] = {.lex_state = 0, .external_lex_state = 48},
  [4109] = {.lex_state = 0, .external_lex_state = 2},
  [4110] = {.lex_state = 0, .external_lex_state = 47},
  [4111] = {.lex_state = 0, .external_lex_state = 49},
  [4112] = {.lex_state = 0, .external_lex_state = 49},
  [4113] = {.lex_state = 0, .external_lex_state = 55},
  [4114] = {.lex_state = 0, .external_lex_state = 47},
  [4115] = {.lex_state = 0, .external_lex_state = 52},
  [4116] = {.lex_state = 0, .external_lex_state = 47},
  [4117] = {.lex_state = 0, .external_lex_state = 2},
  [4118] = {.lex_state = 0, .external_lex_state = 48},
  [4119] = {.lex_state = 0, .external_lex_state = 48},
  [4120] = {.lex_state = 0, .external_lex_state = 2},
  [4121] = {.lex_state = 0, .external_lex_state = 47},
  [4122] = {.lex_state = 0, .external_lex_state = 55},
  [4123] = {.lex_state = 41, .external_lex_state = 44},
  [4124] = {.lex_state = 0, .external_lex_state = 56},
  [4125] = {.lex_state = 0, .external_lex_state = 2},
  [4126] = {.lex_state = 11, .external_lex_state = 44},
  [4127] = {.lex_state = 0, .external_lex_state = 47},
  [4128] = {.lex_state = 0, .external_lex_state = 55},
  [4129] = {.lex_state = 0, .external_lex_state = 56},
  [4130] = {.lex_state = 0, .external_lex_state = 2},
  [4131] = {.lex_state = 11, .external_lex_state = 44},
  [4132] = {.lex_state = 0, .external_lex_state = 47},
  [4133] = {.lex_state = 0, .external_lex_state = 55},
  [4134] = {.lex_state = 0, .external_lex_state = 56},
  [4135] = {.lex_state = 0, .external_lex_state = 2},
  [4136] = {.lex_state = 11, .external_lex_state = 44},
  [4137] = {.lex_state = 0, .external_lex_state = 47},
  [4138] = {.lex_state = 0, .external_lex_state = 55},
  [4139] = {.lex_state = 0, .external_lex_state = 56},
  [4140] = {.lex_state = 0, .external_lex_state = 2},
  [4141] = {.lex_state = 11, .external_lex_state = 44},
  [4142] = {.lex_state = 0, .external_lex_state = 47},
  [4143] = {.lex_state = 0, .external_lex_state = 55},
  [4144] = {.lex_state = 0, .external_lex_state = 56},
  [4145] = {.lex_state = 0, .external_lex_state = 2},
  [4146] = {.lex_state = 11, .external_lex_state = 44},
  [4147] = {.lex_state = 0, .external_lex_state = 2},
  [4148] = {.lex_state = 0, .external_lex_state = 55},
  [4149] = {.lex_state = 0, .external_lex_state = 56},
  [4150] = {.lex_state = 0, .external_lex_state = 2},
  [4151] = {.lex_state = 11, .external_lex_state = 44},
  [4152] = {.lex_state = 0, .external_lex_state = 47},
  [4153] = {.lex_state = 0, .external_lex_state = 55},
  [4154] = {.lex_state = 0, .external_lex_state = 56},
  [4155] = {.lex_state = 0, .external_lex_state = 2},
  [4156] = {.lex_state = 11, .external_lex_state = 44},
  [4157] = {.lex_state = 0, .external_lex_state = 47},
  [4158] = {.lex_state = 0, .external_lex_state = 55},
  [4159] = {.lex_state = 0, .external_lex_state = 56},
  [4160] = {.lex_state = 0, .external_lex_state = 2},
  [4161] = {.lex_state = 11, .external_lex_state = 44},
  [4162] = {.lex_state = 0, .external_lex_state = 53},
  [4163] = {.lex_state = 0, .external_lex_state = 55},
  [4164] = {.lex_state = 0, .external_lex_state = 56},
  [4165] = {.lex_state = 0, .external_lex_state = 2},
  [4166] = {.lex_state = 11, .external_lex_state = 44},
  [4167] = {.lex_state = 0, .external_lex_state = 47},
  [4168] = {.lex_state = 0, .external_lex_state = 55},
  [4169] = {.lex_state = 0, .external_lex_state = 56},
  [4170] = {.lex_state = 0, .external_lex_state = 2},
  [4171] = {.lex_state = 11, .external_lex_state = 44},
  [4172] = {.lex_state = 0, .external_lex_state = 47},
  [4173] = {.lex_state = 0, .external_lex_state = 55},
  [4174] = {.lex_state = 0, .external_lex_state = 56},
  [4175] = {.lex_state = 0, .external_lex_state = 2},
  [4176] = {.lex_state = 11, .external_lex_state = 44},
  [4177] = {.lex_state = 0, .external_lex_state = 54},
  [4178] = {.lex_state = 0, .external_lex_state = 55},
  [4179] = {.lex_state = 0, .external_lex_state = 56},
  [4180] = {.lex_state = 0, .external_lex_state = 2},
  [4181] = {.lex_state = 11, .external_lex_state = 44},
  [4182] = {.lex_state = 0, .external_lex_state = 47},
  [4183] = {.lex_state = 0, .external_lex_state = 55},
  [4184] = {.lex_state = 0, .external_lex_state = 56},
  [4185] = {.lex_state = 0, .external_lex_state = 2},
  [4186] = {.lex_state = 11, .external_lex_state = 44},
  [4187] = {.lex_state = 0, .external_lex_state = 47},
  [4188] = {.lex_state = 0, .external_lex_state = 55},
  [4189] = {.lex_state = 0, .external_lex_state = 56},
  [4190] = {.lex_state = 0, .external_lex_state = 2},
  [4191] = {.lex_state = 11, .external_lex_state = 44},
  [4192] = {.lex_state = 11, .external_lex_state = 44},
  [4193] = {.lex_state = 0, .external_lex_state = 55},
  [4194] = {.lex_state = 0, .external_lex_state = 56},
  [4195] = {.lex_state = 0, .external_lex_state = 2},
  [4196] = {.lex_state = 11, .external_lex_state = 44},
  [4197] = {.lex_state = 19, .external_lex_state = 44},
  [4198] = {.lex_state = 0, .external_lex_state = 55},
  [4199] = {.lex_state = 0, .external_lex_state = 56},
  [4200] = {.lex_state = 0, .external_lex_state = 2},
  [4201] = {.lex_state = 11, .external_lex_state = 44},
  [4202] = {.lex_state = 0, .external_lex_state = 50},
  [4203] = {.lex_state = 0, .external_lex_state = 55},
  [4204] = {.lex_state = 0, .external_lex_state = 56},
  [4205] = {.lex_state = 0, .external_lex_state = 2},
  [4206] = {.lex_state = 11, .external_lex_state = 44},
  [4207] = {.lex_state = 0, .external_lex_state = 51},
  [4208] = {.lex_state = 0, .external_lex_state = 55},
  [4209] = {.lex_state = 0, .external_lex_state = 56},
  [4210] = {.lex_state = 0, .external_lex_state = 2},
  [4211] = {.lex_state = 11, .external_lex_state = 44},
  [4212] = {.lex_state = 11, .external_lex_state = 44},
  [4213] = {.lex_state = 0, .external_lex_state = 55},
  [4214] = {.lex_state = 0, .external_lex_state = 56},
  [4215] = {.lex_state = 0, .external_lex_state = 2},
  [4216] = {.lex_state = 11, .external_lex_state = 44},
  [4217] = {.lex_state = 0, .external_lex_state = 55},
  [4218] = {.lex_state = 0, .external_lex_state = 56},
  [4219] = {.lex_state = 0, .external_lex_state = 2},
  [4220] = {.lex_state = 15, .external_lex_state = 44},
  [4221] = {.lex_state = 0, .external_lex_state = 55},
  [4222] = {.lex_state = 0, .external_lex_state = 56},
  [4223] = {.lex_state = 0, .external_lex_state = 2},
  [4224] = {.lex_state = 0, .external_lex_state = 47},
  [4225] = {.lex_state = 0, .external_lex_state = 55},
  [4226] = {.lex_state = 0, .external_lex_state = 56},
  [4227] = {.lex_state = 0, .external_lex_state = 2},
  [4228] = {.lex_state = 0, .external_lex_state = 47},
  [4229] = {.lex_state = 0, .external_lex_state = 55},
  [4230] = {.lex_state = 0, .external_lex_state = 56},
  [4231] = {.lex_state = 0, .external_lex_state = 2},
  [4232] = {.lex_state = 0, .external_lex_state = 2},
  [4233] = {.lex_state = 0, .external_lex_state = 2},
  [4234] = {.lex_state = 0, .external_lex_state = 2},
  [4235] = {.lex_state = 0, .external_lex_state = 2},
  [4236] = {.lex_state = 0, .external_lex_state = 2},
  [4237] = {.lex_state = 0, .external_lex_state = 2},
  [4238] = {.lex_state = 0, .external_lex_state = 2},
  [4239] = {.lex_state = 0, .external_lex_state = 2},
  [4240] = {.lex_state = 0, .external_lex_state = 2},
  [4241] = {.lex_state = 0, .external_lex_state = 2},
  [4242] = {.lex_state = 0, .external_lex_state = 2},
  [4243] = {.lex_state = 0, .external_lex_state = 2},
  [4244] = {.lex_state = 0, .external_lex_state = 2},
  [4245] = {.lex_state = 0, .external_lex_state = 2},
  [4246] = {.lex_state = 0, .external_lex_state = 2},
  [4247] = {.lex_state = 0, .external_lex_state = 2},
  [4248] = {.lex_state = 0, .external_lex_state = 2},
  [4249] = {.lex_state = 0, .external_lex_state = 2},
  [4250] = {.lex_state = 0, .external_lex_state = 2},
  [4251] = {.lex_state = 0, .external_lex_state = 2},
  [4252] = {.lex_state = 0, .external_lex_state = 47},
  [4253] = {.lex_state = 0, .external_lex_state = 47},
  [4254] = {.lex_state = 0, .external_lex_state = 2},
  [4255] = {.lex_state = 0, .external_lex_state = 49},
  [4256] = {.lex_state = 0, .external_lex_state = 52},
  [4257] = {.lex_state = 0, .external_lex_state = 47},
  [4258] = {.lex_state = 15, .external_lex_state = 44},
  [4259] = {.lex_state = 15, .external_lex_state = 44},
  [4260] = {.lex_state = 15, .external_lex_state = 44},
  [4261] = {.lex_state = 15, .external_lex_state = 44},
  [4262] = {.lex_state = 15, .external_lex_state = 44},
  [4263] = {.lex_state = 15, .external_lex_state = 44},
  [4264] = {.lex_state = 15, .external_lex_state = 44},
  [4265] = {.lex_state = 15, .external_lex_state = 44},
  [4266] = {.lex_state = 15, .external_lex_state = 44},
  [4267] = {.lex_state = 15, .external_lex_state = 44},
  [4268] = {.lex_state = 15, .external_lex_state = 44},
  [4269] = {.lex_state = 15, .external_lex_state = 44},
  [4270] = {.lex_state = 15, .external_lex_state = 44},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [aux_sym_escape_token1] = ACTIONS(1),
    [sym__lb] = ACTIONS(3),
    [sym_linebreak] = ACTIONS(1),
    [sym_quote] = ACTIONS(1),
    [aux_sym_text_token1] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__math_token_align] = ACTIONS(1),
    [sym__math_token_rpar] = ACTIONS(1),
    [sym__math_token_lpar] = ACTIONS(1),
    [aux_sym__math_root_token1] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [aux_sym__math_symbol_token1] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_context] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_COMMA2] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_show] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [sym_auto] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__redent] = ACTIONS(1),
    [sym__line_start_check] = ACTIONS(1),
    [sym__token_content] = ACTIONS(1),
    [sym__token_strong] = ACTIONS(1),
    [sym__token_emph] = ACTIONS(1),
    [sym__barrier] = ACTIONS(1),
    [sym__token_bracket] = ACTIONS(1),
    [sym__token_section] = ACTIONS(1),
    [sym__termination] = ACTIONS(1),
    [sym__token_inlined_item_end] = ACTIONS(1),
    [sym__token_inlined_stmt_end] = ACTIONS(1),
    [sym__token_blocked_expr_end] = ACTIONS(1),
    [sym__token_math_letter] = ACTIONS(1),
    [sym__token_math_ident] = ACTIONS(1),
    [sym__token_math_frac] = ACTIONS(1),
    [sym__token_math_group_end] = ACTIONS(1),
    [sym__token_else] = ACTIONS(1),
    [sym__token_unit] = ACTIONS(1),
    [sym__token_url] = ACTIONS(1),
    [sym__token_item] = ACTIONS(1),
    [sym__token_term] = ACTIONS(1),
    [sym__token_head_1] = ACTIONS(1),
    [sym__token_head_2] = ACTIONS(1),
    [sym__token_head_3] = ACTIONS(1),
    [sym__token_head_4] = ACTIONS(1),
    [sym__token_head_5] = ACTIONS(1),
    [sym__token_head_p] = ACTIONS(1),
    [sym__token_string_blob] = ACTIONS(1),
    [sym__token_raw_span_blob] = ACTIONS(1),
    [sym__token_raw_blck_blob] = ACTIONS(1),
    [sym__token_raw_lang] = ACTIONS(1),
    [sym__token_identifier] = ACTIONS(1),
    [sym__token_label] = ACTIONS(1),
    [sym__token_anti_markup] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate] = ACTIONS(1),
    [sym__immediate_paren] = ACTIONS(1),
    [sym__immediate_brack] = ACTIONS(1),
    [sym__immediate_ident] = ACTIONS(1),
    [sym__immediate_math_call] = ACTIONS(1),
    [sym__immediate_math_apply] = ACTIONS(1),
    [sym__immediate_math_field] = ACTIONS(1),
    [sym__immediate_math_prime] = ACTIONS(1),
    [sym__recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4049),
    [sym__lb] = ACTIONS(3),
    [sym__line_start_check] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [2] = {
    [sym_raw_blck] = STATE(1504),
    [sym_raw_span] = STATE(1504),
    [sym_math] = STATE(1504),
    [sym__expr] = STATE(1504),
    [sym_ident] = STATE(1504),
    [sym_bool] = STATE(1504),
    [sym_number] = STATE(1504),
    [sym_string] = STATE(1504),
    [sym_tagged] = STATE(1504),
    [sym_context] = STATE(1504),
    [sym_elude] = STATE(1504),
    [sym_assign] = STATE(1504),
    [sym_lambda] = STATE(1504),
    [sym_or] = STATE(1504),
    [sym_not] = STATE(1504),
    [sym_and] = STATE(1504),
    [sym_cmp] = STATE(1504),
    [sym_in] = STATE(1504),
    [sym_add] = STATE(1504),
    [sym_sub] = STATE(1504),
    [sym_mul] = STATE(1504),
    [sym_div] = STATE(1504),
    [sym_sign] = STATE(1504),
    [sym_call] = STATE(1504),
    [sym_field] = STATE(1504),
    [sym_label] = STATE(1504),
    [sym_content] = STATE(1504),
    [sym_group] = STATE(1504),
    [sym_block] = STATE(1504),
    [sym_branch] = STATE(1504),
    [sym_let] = STATE(1504),
    [sym_set] = STATE(1504),
    [sym_import] = STATE(1504),
    [sym_include] = STATE(1504),
    [sym_for] = STATE(1504),
    [sym_while] = STATE(1504),
    [sym_show] = STATE(1504),
    [sym_return] = STATE(1504),
    [sym_flow] = STATE(1504),
    [sym__identifier] = ACTIONS(7),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(11),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_true] = ACTIONS(19),
    [anon_sym_false] = ACTIONS(19),
    [aux_sym_number_token1] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [anon_sym_context] = ACTIONS(25),
    [anon_sym_DOT_DOT] = ACTIONS(27),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(29),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(31),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(33),
    [anon_sym_DASH] = ACTIONS(33),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_RPAREN] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(43),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_show] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(57),
    [sym_auto] = ACTIONS(59),
    [sym_none] = ACTIONS(59),
    [sym__token_content] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [3] = {
    [sym_raw_blck] = STATE(1572),
    [sym_raw_span] = STATE(1572),
    [sym_math] = STATE(1572),
    [sym__expr] = STATE(1572),
    [sym_ident] = STATE(1572),
    [sym_bool] = STATE(1572),
    [sym_number] = STATE(1572),
    [sym_string] = STATE(1572),
    [sym_tagged] = STATE(1572),
    [sym_context] = STATE(1572),
    [sym_elude] = STATE(1572),
    [sym_assign] = STATE(1572),
    [sym_lambda] = STATE(1572),
    [sym_or] = STATE(1572),
    [sym_not] = STATE(1572),
    [sym_and] = STATE(1572),
    [sym_cmp] = STATE(1572),
    [sym_in] = STATE(1572),
    [sym_add] = STATE(1572),
    [sym_sub] = STATE(1572),
    [sym_mul] = STATE(1572),
    [sym_div] = STATE(1572),
    [sym_sign] = STATE(1572),
    [sym_call] = STATE(1572),
    [sym_field] = STATE(1572),
    [sym_label] = STATE(1572),
    [sym_content] = STATE(1572),
    [sym_group] = STATE(1572),
    [sym_block] = STATE(1572),
    [sym_branch] = STATE(1572),
    [sym_let] = STATE(1572),
    [sym_set] = STATE(1572),
    [sym_import] = STATE(1572),
    [sym_include] = STATE(1572),
    [sym_for] = STATE(1572),
    [sym_while] = STATE(1572),
    [sym_show] = STATE(1572),
    [sym_return] = STATE(1572),
    [sym_flow] = STATE(1572),
    [sym__identifier] = ACTIONS(7),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(11),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(19),
    [anon_sym_false] = ACTIONS(19),
    [aux_sym_number_token1] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [anon_sym_context] = ACTIONS(25),
    [anon_sym_DOT_DOT] = ACTIONS(27),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(43),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_show] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(57),
    [sym_auto] = ACTIONS(67),
    [sym_none] = ACTIONS(67),
    [sym__token_content] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [4] = {
    [sym_raw_blck] = STATE(2047),
    [sym_raw_span] = STATE(2047),
    [sym_math] = STATE(2047),
    [sym__expr] = STATE(2047),
    [sym_ident] = STATE(2047),
    [sym_bool] = STATE(2047),
    [sym_number] = STATE(2047),
    [sym_string] = STATE(2047),
    [sym_tagged] = STATE(2047),
    [sym_context] = STATE(2047),
    [sym_elude] = STATE(2047),
    [sym_assign] = STATE(2047),
    [sym_lambda] = STATE(2047),
    [sym_or] = STATE(2047),
    [sym_not] = STATE(2047),
    [sym_and] = STATE(2047),
    [sym_cmp] = STATE(2047),
    [sym_in] = STATE(2047),
    [sym_add] = STATE(2047),
    [sym_sub] = STATE(2047),
    [sym_mul] = STATE(2047),
    [sym_div] = STATE(2047),
    [sym_sign] = STATE(2047),
    [sym_call] = STATE(2047),
    [sym_field] = STATE(2047),
    [sym_label] = STATE(2047),
    [sym_content] = STATE(2047),
    [sym_group] = STATE(2047),
    [sym_block] = STATE(2047),
    [sym_branch] = STATE(2047),
    [sym_let] = STATE(2047),
    [sym_set] = STATE(2047),
    [sym_import] = STATE(2047),
    [sym_include] = STATE(2047),
    [sym_for] = STATE(2047),
    [sym_while] = STATE(2047),
    [sym_show] = STATE(2047),
    [sym_return] = STATE(2047),
    [sym_flow] = STATE(2047),
    [sym__identifier] = ACTIONS(69),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(73),
    [anon_sym_DOLLAR] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [aux_sym_number_token1] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_context] = ACTIONS(83),
    [anon_sym_DOT_DOT] = ACTIONS(85),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(87),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(89),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_if] = ACTIONS(97),
    [anon_sym_let] = ACTIONS(99),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(103),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(105),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_show] = ACTIONS(111),
    [anon_sym_return] = ACTIONS(113),
    [anon_sym_break] = ACTIONS(115),
    [anon_sym_continue] = ACTIONS(115),
    [sym_auto] = ACTIONS(117),
    [sym_none] = ACTIONS(117),
    [sym__token_content] = ACTIONS(119),
    [sym__token_inlined_item_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [5] = {
    [sym_raw_blck] = STATE(2041),
    [sym_raw_span] = STATE(2041),
    [sym_math] = STATE(2041),
    [sym__expr] = STATE(2041),
    [sym_ident] = STATE(2041),
    [sym_bool] = STATE(2041),
    [sym_number] = STATE(2041),
    [sym_string] = STATE(2041),
    [sym_tagged] = STATE(2041),
    [sym_context] = STATE(2041),
    [sym_elude] = STATE(2041),
    [sym_assign] = STATE(2041),
    [sym_lambda] = STATE(2041),
    [sym_or] = STATE(2041),
    [sym_not] = STATE(2041),
    [sym_and] = STATE(2041),
    [sym_cmp] = STATE(2041),
    [sym_in] = STATE(2041),
    [sym_add] = STATE(2041),
    [sym_sub] = STATE(2041),
    [sym_mul] = STATE(2041),
    [sym_div] = STATE(2041),
    [sym_sign] = STATE(2041),
    [sym_call] = STATE(2041),
    [sym_field] = STATE(2041),
    [sym_label] = STATE(2041),
    [sym_content] = STATE(2041),
    [sym_group] = STATE(2041),
    [sym_block] = STATE(2041),
    [sym_branch] = STATE(2041),
    [sym_let] = STATE(2041),
    [sym_set] = STATE(2041),
    [sym_import] = STATE(2041),
    [sym_include] = STATE(2041),
    [sym_for] = STATE(2041),
    [sym_while] = STATE(2041),
    [sym_show] = STATE(2041),
    [sym_return] = STATE(2041),
    [sym_flow] = STATE(2041),
    [sym__identifier] = ACTIONS(69),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(73),
    [anon_sym_DOLLAR] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [aux_sym_number_token1] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_context] = ACTIONS(83),
    [anon_sym_DOT_DOT] = ACTIONS(85),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_if] = ACTIONS(97),
    [anon_sym_let] = ACTIONS(99),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(103),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(105),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_show] = ACTIONS(111),
    [anon_sym_return] = ACTIONS(113),
    [anon_sym_break] = ACTIONS(115),
    [anon_sym_continue] = ACTIONS(115),
    [sym_auto] = ACTIONS(121),
    [sym_none] = ACTIONS(121),
    [sym__token_content] = ACTIONS(119),
    [sym__token_inlined_item_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [6] = {
    [sym_raw_blck] = STATE(1682),
    [sym_raw_span] = STATE(1682),
    [sym_math] = STATE(1682),
    [sym__expr] = STATE(1682),
    [sym_ident] = STATE(1682),
    [sym_bool] = STATE(1682),
    [sym_number] = STATE(1682),
    [sym_string] = STATE(1682),
    [sym_tagged] = STATE(1682),
    [sym_context] = STATE(1682),
    [sym_elude] = STATE(1682),
    [sym_assign] = STATE(1682),
    [sym_lambda] = STATE(1682),
    [sym_or] = STATE(1682),
    [sym_not] = STATE(1682),
    [sym_and] = STATE(1682),
    [sym_cmp] = STATE(1682),
    [sym_in] = STATE(1682),
    [sym_add] = STATE(1682),
    [sym_sub] = STATE(1682),
    [sym_mul] = STATE(1682),
    [sym_div] = STATE(1682),
    [sym_sign] = STATE(1682),
    [sym_call] = STATE(1682),
    [sym_field] = STATE(1682),
    [sym_label] = STATE(1682),
    [sym_content] = STATE(1682),
    [sym_group] = STATE(1682),
    [sym_block] = STATE(1682),
    [sym_branch] = STATE(1682),
    [sym_let] = STATE(1682),
    [sym_set] = STATE(1682),
    [sym_import] = STATE(1682),
    [sym_include] = STATE(1682),
    [sym_for] = STATE(1682),
    [sym_while] = STATE(1682),
    [sym_show] = STATE(1682),
    [sym_return] = STATE(1682),
    [sym_flow] = STATE(1682),
    [sym__identifier] = ACTIONS(123),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(131),
    [anon_sym_false] = ACTIONS(131),
    [aux_sym_number_token1] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_context] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(139),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_set] = ACTIONS(149),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(151),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_show] = ACTIONS(159),
    [anon_sym_return] = ACTIONS(161),
    [anon_sym_break] = ACTIONS(163),
    [anon_sym_continue] = ACTIONS(163),
    [sym_auto] = ACTIONS(165),
    [sym_none] = ACTIONS(165),
    [sym__token_content] = ACTIONS(167),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [7] = {
    [sym_raw_blck] = STATE(1863),
    [sym_raw_span] = STATE(1863),
    [sym_math] = STATE(1863),
    [sym__expr] = STATE(1863),
    [sym_ident] = STATE(1863),
    [sym_bool] = STATE(1863),
    [sym_number] = STATE(1863),
    [sym_string] = STATE(1863),
    [sym_tagged] = STATE(1863),
    [sym_context] = STATE(1863),
    [sym_elude] = STATE(1863),
    [sym_assign] = STATE(1863),
    [sym_lambda] = STATE(1863),
    [sym_or] = STATE(1863),
    [sym_not] = STATE(1863),
    [sym_and] = STATE(1863),
    [sym_cmp] = STATE(1863),
    [sym_in] = STATE(1863),
    [sym_add] = STATE(1863),
    [sym_sub] = STATE(1863),
    [sym_mul] = STATE(1863),
    [sym_div] = STATE(1863),
    [sym_sign] = STATE(1863),
    [sym_call] = STATE(1863),
    [sym_field] = STATE(1863),
    [sym_label] = STATE(1863),
    [sym_content] = STATE(1863),
    [sym_group] = STATE(1863),
    [sym_block] = STATE(1863),
    [sym_branch] = STATE(1863),
    [sym_let] = STATE(1863),
    [sym_set] = STATE(1863),
    [sym_import] = STATE(1863),
    [sym_include] = STATE(1863),
    [sym_for] = STATE(1863),
    [sym_while] = STATE(1863),
    [sym_show] = STATE(1863),
    [sym_return] = STATE(1863),
    [sym_flow] = STATE(1863),
    [sym__identifier] = ACTIONS(169),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_DOLLAR] = ACTIONS(175),
    [anon_sym_true] = ACTIONS(177),
    [anon_sym_false] = ACTIONS(177),
    [aux_sym_number_token1] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(181),
    [anon_sym_context] = ACTIONS(183),
    [anon_sym_DOT_DOT] = ACTIONS(185),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(187),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(191),
    [anon_sym_DASH] = ACTIONS(191),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_let] = ACTIONS(199),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(201),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(203),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(207),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_show] = ACTIONS(211),
    [anon_sym_return] = ACTIONS(213),
    [anon_sym_break] = ACTIONS(215),
    [anon_sym_continue] = ACTIONS(215),
    [sym_auto] = ACTIONS(217),
    [sym_none] = ACTIONS(217),
    [sym__token_content] = ACTIONS(219),
    [sym__token_inlined_stmt_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [8] = {
    [sym_raw_blck] = STATE(1857),
    [sym_raw_span] = STATE(1857),
    [sym_math] = STATE(1857),
    [sym__expr] = STATE(1857),
    [sym_ident] = STATE(1857),
    [sym_bool] = STATE(1857),
    [sym_number] = STATE(1857),
    [sym_string] = STATE(1857),
    [sym_tagged] = STATE(1857),
    [sym_context] = STATE(1857),
    [sym_elude] = STATE(1857),
    [sym_assign] = STATE(1857),
    [sym_lambda] = STATE(1857),
    [sym_or] = STATE(1857),
    [sym_not] = STATE(1857),
    [sym_and] = STATE(1857),
    [sym_cmp] = STATE(1857),
    [sym_in] = STATE(1857),
    [sym_add] = STATE(1857),
    [sym_sub] = STATE(1857),
    [sym_mul] = STATE(1857),
    [sym_div] = STATE(1857),
    [sym_sign] = STATE(1857),
    [sym_call] = STATE(1857),
    [sym_field] = STATE(1857),
    [sym_label] = STATE(1857),
    [sym_content] = STATE(1857),
    [sym_group] = STATE(1857),
    [sym_block] = STATE(1857),
    [sym_branch] = STATE(1857),
    [sym_let] = STATE(1857),
    [sym_set] = STATE(1857),
    [sym_import] = STATE(1857),
    [sym_include] = STATE(1857),
    [sym_for] = STATE(1857),
    [sym_while] = STATE(1857),
    [sym_show] = STATE(1857),
    [sym_return] = STATE(1857),
    [sym_flow] = STATE(1857),
    [sym__identifier] = ACTIONS(169),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_DOLLAR] = ACTIONS(175),
    [anon_sym_true] = ACTIONS(177),
    [anon_sym_false] = ACTIONS(177),
    [aux_sym_number_token1] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(181),
    [anon_sym_context] = ACTIONS(183),
    [anon_sym_DOT_DOT] = ACTIONS(185),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_let] = ACTIONS(199),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(201),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(203),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(207),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_show] = ACTIONS(211),
    [anon_sym_return] = ACTIONS(213),
    [anon_sym_break] = ACTIONS(215),
    [anon_sym_continue] = ACTIONS(215),
    [sym_auto] = ACTIONS(221),
    [sym_none] = ACTIONS(221),
    [sym__token_content] = ACTIONS(219),
    [sym__token_inlined_stmt_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [9] = {
    [sym_raw_blck] = STATE(1729),
    [sym_raw_span] = STATE(1729),
    [sym_math] = STATE(1729),
    [sym__expr] = STATE(1729),
    [sym_ident] = STATE(1729),
    [sym_bool] = STATE(1729),
    [sym_number] = STATE(1729),
    [sym_string] = STATE(1729),
    [sym_tagged] = STATE(1729),
    [sym_context] = STATE(1729),
    [sym_elude] = STATE(1729),
    [sym_assign] = STATE(1729),
    [sym_lambda] = STATE(1729),
    [sym_or] = STATE(1729),
    [sym_not] = STATE(1729),
    [sym_and] = STATE(1729),
    [sym_cmp] = STATE(1729),
    [sym_in] = STATE(1729),
    [sym_add] = STATE(1729),
    [sym_sub] = STATE(1729),
    [sym_mul] = STATE(1729),
    [sym_div] = STATE(1729),
    [sym_sign] = STATE(1729),
    [sym_call] = STATE(1729),
    [sym_field] = STATE(1729),
    [sym_label] = STATE(1729),
    [sym_content] = STATE(1729),
    [sym_group] = STATE(1729),
    [sym_block] = STATE(1729),
    [sym_branch] = STATE(1729),
    [sym_let] = STATE(1729),
    [sym_set] = STATE(1729),
    [sym_import] = STATE(1729),
    [sym_include] = STATE(1729),
    [sym_for] = STATE(1729),
    [sym_while] = STATE(1729),
    [sym_show] = STATE(1729),
    [sym_return] = STATE(1729),
    [sym_flow] = STATE(1729),
    [sym__identifier] = ACTIONS(223),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [anon_sym_true] = ACTIONS(231),
    [anon_sym_false] = ACTIONS(231),
    [aux_sym_number_token1] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(235),
    [anon_sym_context] = ACTIONS(237),
    [anon_sym_DOT_DOT] = ACTIONS(239),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_let] = ACTIONS(247),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(249),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(251),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(253),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_show] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(263),
    [sym_auto] = ACTIONS(265),
    [sym_none] = ACTIONS(265),
    [sym__token_content] = ACTIONS(267),
    [sym__token_blocked_expr_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [10] = {
    [sym_raw_blck] = STATE(1626),
    [sym_raw_span] = STATE(1626),
    [sym_math] = STATE(1626),
    [sym__expr] = STATE(1626),
    [sym_ident] = STATE(1626),
    [sym_bool] = STATE(1626),
    [sym_number] = STATE(1626),
    [sym_string] = STATE(1626),
    [sym_tagged] = STATE(1626),
    [sym_context] = STATE(1626),
    [sym_elude] = STATE(1626),
    [sym_assign] = STATE(1626),
    [sym_lambda] = STATE(1626),
    [sym_or] = STATE(1626),
    [sym_not] = STATE(1626),
    [sym_and] = STATE(1626),
    [sym_cmp] = STATE(1626),
    [sym_in] = STATE(1626),
    [sym_add] = STATE(1626),
    [sym_sub] = STATE(1626),
    [sym_mul] = STATE(1626),
    [sym_div] = STATE(1626),
    [sym_sign] = STATE(1626),
    [sym_call] = STATE(1626),
    [sym_field] = STATE(1626),
    [sym_label] = STATE(1626),
    [sym_content] = STATE(1626),
    [sym_group] = STATE(1626),
    [sym_block] = STATE(1626),
    [sym_branch] = STATE(1626),
    [sym_let] = STATE(1626),
    [sym_set] = STATE(1626),
    [sym_import] = STATE(1626),
    [sym_include] = STATE(1626),
    [sym_for] = STATE(1626),
    [sym_while] = STATE(1626),
    [sym_show] = STATE(1626),
    [sym_return] = STATE(1626),
    [sym_flow] = STATE(1626),
    [sym__identifier] = ACTIONS(123),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_true] = ACTIONS(131),
    [anon_sym_false] = ACTIONS(131),
    [aux_sym_number_token1] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_context] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(139),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(269),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(271),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_RPAREN] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_set] = ACTIONS(149),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(151),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_show] = ACTIONS(159),
    [anon_sym_return] = ACTIONS(161),
    [anon_sym_break] = ACTIONS(163),
    [anon_sym_continue] = ACTIONS(163),
    [sym_auto] = ACTIONS(275),
    [sym_none] = ACTIONS(275),
    [sym__token_content] = ACTIONS(167),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [11] = {
    [sym_raw_blck] = STATE(1720),
    [sym_raw_span] = STATE(1720),
    [sym_math] = STATE(1720),
    [sym__expr] = STATE(1720),
    [sym_ident] = STATE(1720),
    [sym_bool] = STATE(1720),
    [sym_number] = STATE(1720),
    [sym_string] = STATE(1720),
    [sym_tagged] = STATE(1720),
    [sym_context] = STATE(1720),
    [sym_elude] = STATE(1720),
    [sym_assign] = STATE(1720),
    [sym_lambda] = STATE(1720),
    [sym_or] = STATE(1720),
    [sym_not] = STATE(1720),
    [sym_and] = STATE(1720),
    [sym_cmp] = STATE(1720),
    [sym_in] = STATE(1720),
    [sym_add] = STATE(1720),
    [sym_sub] = STATE(1720),
    [sym_mul] = STATE(1720),
    [sym_div] = STATE(1720),
    [sym_sign] = STATE(1720),
    [sym_call] = STATE(1720),
    [sym_field] = STATE(1720),
    [sym_label] = STATE(1720),
    [sym_content] = STATE(1720),
    [sym_group] = STATE(1720),
    [sym_block] = STATE(1720),
    [sym_branch] = STATE(1720),
    [sym_let] = STATE(1720),
    [sym_set] = STATE(1720),
    [sym_import] = STATE(1720),
    [sym_include] = STATE(1720),
    [sym_for] = STATE(1720),
    [sym_while] = STATE(1720),
    [sym_show] = STATE(1720),
    [sym_return] = STATE(1720),
    [sym_flow] = STATE(1720),
    [sym__identifier] = ACTIONS(223),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [anon_sym_true] = ACTIONS(231),
    [anon_sym_false] = ACTIONS(231),
    [aux_sym_number_token1] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(235),
    [anon_sym_context] = ACTIONS(237),
    [anon_sym_DOT_DOT] = ACTIONS(239),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(277),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_let] = ACTIONS(247),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(249),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(251),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(253),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_show] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(263),
    [sym_auto] = ACTIONS(283),
    [sym_none] = ACTIONS(283),
    [sym__token_content] = ACTIONS(267),
    [sym__token_blocked_expr_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [12] = {
    [sym_raw_blck] = STATE(2214),
    [sym_raw_span] = STATE(2214),
    [sym_math] = STATE(2214),
    [sym__expr] = STATE(2214),
    [sym_ident] = STATE(2214),
    [sym_bool] = STATE(2214),
    [sym_number] = STATE(2214),
    [sym_string] = STATE(2214),
    [sym_tagged] = STATE(2214),
    [sym_context] = STATE(2214),
    [sym_elude] = STATE(2214),
    [sym_assign] = STATE(2214),
    [sym_lambda] = STATE(2214),
    [sym_or] = STATE(2214),
    [sym_not] = STATE(2214),
    [sym_and] = STATE(2214),
    [sym_cmp] = STATE(2214),
    [sym_in] = STATE(2214),
    [sym_add] = STATE(2214),
    [sym_sub] = STATE(2214),
    [sym_mul] = STATE(2214),
    [sym_div] = STATE(2214),
    [sym_sign] = STATE(2214),
    [sym_call] = STATE(2214),
    [sym_field] = STATE(2214),
    [sym_label] = STATE(2214),
    [sym_content] = STATE(2214),
    [sym_group] = STATE(2214),
    [sym_block] = STATE(2214),
    [sym_branch] = STATE(2214),
    [sym_let] = STATE(2214),
    [sym_set] = STATE(2214),
    [sym_import] = STATE(2214),
    [sym_include] = STATE(2214),
    [sym_for] = STATE(2214),
    [sym_while] = STATE(2214),
    [sym_show] = STATE(2214),
    [sym_return] = STATE(2214),
    [sym_flow] = STATE(2214),
    [sym__identifier] = ACTIONS(285),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(287),
    [anon_sym_BQUOTE] = ACTIONS(289),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [anon_sym_true] = ACTIONS(293),
    [anon_sym_false] = ACTIONS(293),
    [aux_sym_number_token1] = ACTIONS(295),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [anon_sym_context] = ACTIONS(299),
    [anon_sym_DOT_DOT] = ACTIONS(301),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(307),
    [anon_sym_DASH] = ACTIONS(307),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_if] = ACTIONS(313),
    [anon_sym_let] = ACTIONS(315),
    [anon_sym_set] = ACTIONS(317),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(319),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [anon_sym_show] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_break] = ACTIONS(331),
    [anon_sym_continue] = ACTIONS(331),
    [sym_auto] = ACTIONS(333),
    [sym_none] = ACTIONS(333),
    [sym__token_content] = ACTIONS(335),
    [sym__token_blocked_expr_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [13] = {
    [sym_raw_blck] = STATE(2373),
    [sym_raw_span] = STATE(2373),
    [sym_math] = STATE(2373),
    [sym__expr] = STATE(2373),
    [sym_ident] = STATE(2373),
    [sym_bool] = STATE(2373),
    [sym_number] = STATE(2373),
    [sym_string] = STATE(2373),
    [sym_tagged] = STATE(2373),
    [sym_context] = STATE(2373),
    [sym_elude] = STATE(2373),
    [sym_assign] = STATE(2373),
    [sym_lambda] = STATE(2373),
    [sym_or] = STATE(2373),
    [sym_not] = STATE(2373),
    [sym_and] = STATE(2373),
    [sym_cmp] = STATE(2373),
    [sym_in] = STATE(2373),
    [sym_add] = STATE(2373),
    [sym_sub] = STATE(2373),
    [sym_mul] = STATE(2373),
    [sym_div] = STATE(2373),
    [sym_sign] = STATE(2373),
    [sym_call] = STATE(2373),
    [sym_field] = STATE(2373),
    [sym_label] = STATE(2373),
    [sym_content] = STATE(2373),
    [sym_group] = STATE(2373),
    [sym_block] = STATE(2373),
    [sym_branch] = STATE(2373),
    [sym_let] = STATE(2373),
    [sym_set] = STATE(2373),
    [sym_import] = STATE(2373),
    [sym_include] = STATE(2373),
    [sym_for] = STATE(2373),
    [sym_while] = STATE(2373),
    [sym_show] = STATE(2373),
    [sym_return] = STATE(2373),
    [sym_flow] = STATE(2373),
    [sym__identifier] = ACTIONS(337),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(341),
    [anon_sym_DOLLAR] = ACTIONS(343),
    [anon_sym_true] = ACTIONS(345),
    [anon_sym_false] = ACTIONS(345),
    [aux_sym_number_token1] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_context] = ACTIONS(351),
    [anon_sym_DOT_DOT] = ACTIONS(353),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(355),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(357),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_let] = ACTIONS(367),
    [anon_sym_set] = ACTIONS(369),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(371),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(375),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_show] = ACTIONS(379),
    [anon_sym_return] = ACTIONS(381),
    [anon_sym_break] = ACTIONS(383),
    [anon_sym_continue] = ACTIONS(383),
    [sym_auto] = ACTIONS(385),
    [sym_none] = ACTIONS(385),
    [sym__token_content] = ACTIONS(387),
    [sym__token_inlined_item_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [14] = {
    [sym_raw_blck] = STATE(1565),
    [sym_raw_span] = STATE(1565),
    [sym_math] = STATE(1565),
    [sym__expr] = STATE(1565),
    [sym_ident] = STATE(1565),
    [sym_bool] = STATE(1565),
    [sym_number] = STATE(1565),
    [sym_string] = STATE(1565),
    [sym_tagged] = STATE(1565),
    [sym_context] = STATE(1565),
    [sym_elude] = STATE(1565),
    [sym_assign] = STATE(1565),
    [sym_lambda] = STATE(1565),
    [sym_or] = STATE(1565),
    [sym_not] = STATE(1565),
    [sym_and] = STATE(1565),
    [sym_cmp] = STATE(1565),
    [sym_in] = STATE(1565),
    [sym_add] = STATE(1565),
    [sym_sub] = STATE(1565),
    [sym_mul] = STATE(1565),
    [sym_div] = STATE(1565),
    [sym_sign] = STATE(1565),
    [sym_call] = STATE(1565),
    [sym_field] = STATE(1565),
    [sym_label] = STATE(1565),
    [sym_content] = STATE(1565),
    [sym_group] = STATE(1565),
    [sym_block] = STATE(1565),
    [sym_branch] = STATE(1565),
    [sym_let] = STATE(1565),
    [sym_set] = STATE(1565),
    [sym_import] = STATE(1565),
    [sym_include] = STATE(1565),
    [sym_for] = STATE(1565),
    [sym_while] = STATE(1565),
    [sym_show] = STATE(1565),
    [sym_return] = STATE(1565),
    [sym_flow] = STATE(1565),
    [sym__identifier] = ACTIONS(389),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [anon_sym_true] = ACTIONS(397),
    [anon_sym_false] = ACTIONS(397),
    [aux_sym_number_token1] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(401),
    [anon_sym_context] = ACTIONS(403),
    [anon_sym_DOT_DOT] = ACTIONS(405),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(411),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(413),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(415),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_show] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(427),
    [anon_sym_continue] = ACTIONS(427),
    [sym_auto] = ACTIONS(429),
    [sym_none] = ACTIONS(429),
    [sym__token_content] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [15] = {
    [sym_raw_blck] = STATE(1555),
    [sym_raw_span] = STATE(1555),
    [sym_math] = STATE(1555),
    [sym__expr] = STATE(1555),
    [sym_ident] = STATE(1555),
    [sym_bool] = STATE(1555),
    [sym_number] = STATE(1555),
    [sym_string] = STATE(1555),
    [sym_tagged] = STATE(1555),
    [sym_context] = STATE(1555),
    [sym_elude] = STATE(1555),
    [sym_assign] = STATE(1555),
    [sym_lambda] = STATE(1555),
    [sym_or] = STATE(1555),
    [sym_not] = STATE(1555),
    [sym_and] = STATE(1555),
    [sym_cmp] = STATE(1555),
    [sym_in] = STATE(1555),
    [sym_add] = STATE(1555),
    [sym_sub] = STATE(1555),
    [sym_mul] = STATE(1555),
    [sym_div] = STATE(1555),
    [sym_sign] = STATE(1555),
    [sym_call] = STATE(1555),
    [sym_field] = STATE(1555),
    [sym_label] = STATE(1555),
    [sym_content] = STATE(1555),
    [sym_group] = STATE(1555),
    [sym_block] = STATE(1555),
    [sym_branch] = STATE(1555),
    [sym_let] = STATE(1555),
    [sym_set] = STATE(1555),
    [sym_import] = STATE(1555),
    [sym_include] = STATE(1555),
    [sym_for] = STATE(1555),
    [sym_while] = STATE(1555),
    [sym_show] = STATE(1555),
    [sym_return] = STATE(1555),
    [sym_flow] = STATE(1555),
    [sym__identifier] = ACTIONS(389),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [anon_sym_true] = ACTIONS(397),
    [anon_sym_false] = ACTIONS(397),
    [aux_sym_number_token1] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(401),
    [anon_sym_context] = ACTIONS(403),
    [anon_sym_DOT_DOT] = ACTIONS(405),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(431),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(411),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(413),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(415),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_show] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(427),
    [anon_sym_continue] = ACTIONS(427),
    [sym_auto] = ACTIONS(439),
    [sym_none] = ACTIONS(439),
    [sym__token_content] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [16] = {
    [sym_raw_blck] = STATE(2269),
    [sym_raw_span] = STATE(2269),
    [sym_math] = STATE(2269),
    [sym__expr] = STATE(2269),
    [sym_ident] = STATE(2269),
    [sym_bool] = STATE(2269),
    [sym_number] = STATE(2269),
    [sym_string] = STATE(2269),
    [sym_tagged] = STATE(2269),
    [sym_context] = STATE(2269),
    [sym_elude] = STATE(2269),
    [sym_assign] = STATE(2269),
    [sym_lambda] = STATE(2269),
    [sym_or] = STATE(2269),
    [sym_not] = STATE(2269),
    [sym_and] = STATE(2269),
    [sym_cmp] = STATE(2269),
    [sym_in] = STATE(2269),
    [sym_add] = STATE(2269),
    [sym_sub] = STATE(2269),
    [sym_mul] = STATE(2269),
    [sym_div] = STATE(2269),
    [sym_sign] = STATE(2269),
    [sym_call] = STATE(2269),
    [sym_field] = STATE(2269),
    [sym_label] = STATE(2269),
    [sym_content] = STATE(2269),
    [sym_group] = STATE(2269),
    [sym_block] = STATE(2269),
    [sym_branch] = STATE(2269),
    [sym_let] = STATE(2269),
    [sym_set] = STATE(2269),
    [sym_import] = STATE(2269),
    [sym_include] = STATE(2269),
    [sym_for] = STATE(2269),
    [sym_while] = STATE(2269),
    [sym_show] = STATE(2269),
    [sym_return] = STATE(2269),
    [sym_flow] = STATE(2269),
    [sym__identifier] = ACTIONS(443),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [anon_sym_DOLLAR] = ACTIONS(449),
    [anon_sym_true] = ACTIONS(451),
    [anon_sym_false] = ACTIONS(451),
    [aux_sym_number_token1] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(455),
    [anon_sym_context] = ACTIONS(457),
    [anon_sym_DOT_DOT] = ACTIONS(459),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(461),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(463),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(465),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(471),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(475),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(477),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(483),
    [anon_sym_show] = ACTIONS(485),
    [anon_sym_return] = ACTIONS(487),
    [anon_sym_break] = ACTIONS(489),
    [anon_sym_continue] = ACTIONS(489),
    [sym_auto] = ACTIONS(491),
    [sym_none] = ACTIONS(491),
    [sym__token_content] = ACTIONS(493),
    [sym__token_inlined_stmt_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [17] = {
    [sym_raw_blck] = STATE(2210),
    [sym_raw_span] = STATE(2210),
    [sym_math] = STATE(2210),
    [sym__expr] = STATE(2210),
    [sym_ident] = STATE(2210),
    [sym_bool] = STATE(2210),
    [sym_number] = STATE(2210),
    [sym_string] = STATE(2210),
    [sym_tagged] = STATE(2210),
    [sym_context] = STATE(2210),
    [sym_elude] = STATE(2210),
    [sym_assign] = STATE(2210),
    [sym_lambda] = STATE(2210),
    [sym_or] = STATE(2210),
    [sym_not] = STATE(2210),
    [sym_and] = STATE(2210),
    [sym_cmp] = STATE(2210),
    [sym_in] = STATE(2210),
    [sym_add] = STATE(2210),
    [sym_sub] = STATE(2210),
    [sym_mul] = STATE(2210),
    [sym_div] = STATE(2210),
    [sym_sign] = STATE(2210),
    [sym_call] = STATE(2210),
    [sym_field] = STATE(2210),
    [sym_label] = STATE(2210),
    [sym_content] = STATE(2210),
    [sym_group] = STATE(2210),
    [sym_block] = STATE(2210),
    [sym_branch] = STATE(2210),
    [sym_let] = STATE(2210),
    [sym_set] = STATE(2210),
    [sym_import] = STATE(2210),
    [sym_include] = STATE(2210),
    [sym_for] = STATE(2210),
    [sym_while] = STATE(2210),
    [sym_show] = STATE(2210),
    [sym_return] = STATE(2210),
    [sym_flow] = STATE(2210),
    [sym__identifier] = ACTIONS(443),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [anon_sym_DOLLAR] = ACTIONS(449),
    [anon_sym_true] = ACTIONS(451),
    [anon_sym_false] = ACTIONS(451),
    [aux_sym_number_token1] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(455),
    [anon_sym_context] = ACTIONS(457),
    [anon_sym_DOT_DOT] = ACTIONS(459),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(471),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(475),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(477),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(483),
    [anon_sym_show] = ACTIONS(485),
    [anon_sym_return] = ACTIONS(487),
    [anon_sym_break] = ACTIONS(489),
    [anon_sym_continue] = ACTIONS(489),
    [sym_auto] = ACTIONS(495),
    [sym_none] = ACTIONS(495),
    [sym__token_content] = ACTIONS(493),
    [sym__token_inlined_stmt_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [18] = {
    [sym_raw_blck] = STATE(2218),
    [sym_raw_span] = STATE(2218),
    [sym_math] = STATE(2218),
    [sym__expr] = STATE(2218),
    [sym_ident] = STATE(2218),
    [sym_bool] = STATE(2218),
    [sym_number] = STATE(2218),
    [sym_string] = STATE(2218),
    [sym_tagged] = STATE(2218),
    [sym_context] = STATE(2218),
    [sym_elude] = STATE(2218),
    [sym_assign] = STATE(2218),
    [sym_lambda] = STATE(2218),
    [sym_or] = STATE(2218),
    [sym_not] = STATE(2218),
    [sym_and] = STATE(2218),
    [sym_cmp] = STATE(2218),
    [sym_in] = STATE(2218),
    [sym_add] = STATE(2218),
    [sym_sub] = STATE(2218),
    [sym_mul] = STATE(2218),
    [sym_div] = STATE(2218),
    [sym_sign] = STATE(2218),
    [sym_call] = STATE(2218),
    [sym_field] = STATE(2218),
    [sym_label] = STATE(2218),
    [sym_content] = STATE(2218),
    [sym_group] = STATE(2218),
    [sym_block] = STATE(2218),
    [sym_branch] = STATE(2218),
    [sym_let] = STATE(2218),
    [sym_set] = STATE(2218),
    [sym_import] = STATE(2218),
    [sym_include] = STATE(2218),
    [sym_for] = STATE(2218),
    [sym_while] = STATE(2218),
    [sym_show] = STATE(2218),
    [sym_return] = STATE(2218),
    [sym_flow] = STATE(2218),
    [sym__identifier] = ACTIONS(285),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(287),
    [anon_sym_BQUOTE] = ACTIONS(289),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [anon_sym_true] = ACTIONS(293),
    [anon_sym_false] = ACTIONS(293),
    [aux_sym_number_token1] = ACTIONS(295),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [anon_sym_context] = ACTIONS(299),
    [anon_sym_DOT_DOT] = ACTIONS(301),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_if] = ACTIONS(313),
    [anon_sym_let] = ACTIONS(315),
    [anon_sym_set] = ACTIONS(317),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(319),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(325),
    [anon_sym_show] = ACTIONS(327),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_break] = ACTIONS(331),
    [anon_sym_continue] = ACTIONS(331),
    [sym_auto] = ACTIONS(497),
    [sym_none] = ACTIONS(497),
    [sym__token_content] = ACTIONS(335),
    [sym__token_blocked_expr_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [19] = {
    [sym_raw_blck] = STATE(2378),
    [sym_raw_span] = STATE(2378),
    [sym_math] = STATE(2378),
    [sym__expr] = STATE(2378),
    [sym_ident] = STATE(2378),
    [sym_bool] = STATE(2378),
    [sym_number] = STATE(2378),
    [sym_string] = STATE(2378),
    [sym_tagged] = STATE(2378),
    [sym_context] = STATE(2378),
    [sym_elude] = STATE(2378),
    [sym_assign] = STATE(2378),
    [sym_lambda] = STATE(2378),
    [sym_or] = STATE(2378),
    [sym_not] = STATE(2378),
    [sym_and] = STATE(2378),
    [sym_cmp] = STATE(2378),
    [sym_in] = STATE(2378),
    [sym_add] = STATE(2378),
    [sym_sub] = STATE(2378),
    [sym_mul] = STATE(2378),
    [sym_div] = STATE(2378),
    [sym_sign] = STATE(2378),
    [sym_call] = STATE(2378),
    [sym_field] = STATE(2378),
    [sym_label] = STATE(2378),
    [sym_content] = STATE(2378),
    [sym_group] = STATE(2378),
    [sym_block] = STATE(2378),
    [sym_branch] = STATE(2378),
    [sym_let] = STATE(2378),
    [sym_set] = STATE(2378),
    [sym_import] = STATE(2378),
    [sym_include] = STATE(2378),
    [sym_for] = STATE(2378),
    [sym_while] = STATE(2378),
    [sym_show] = STATE(2378),
    [sym_return] = STATE(2378),
    [sym_flow] = STATE(2378),
    [sym__identifier] = ACTIONS(337),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(341),
    [anon_sym_DOLLAR] = ACTIONS(343),
    [anon_sym_true] = ACTIONS(345),
    [anon_sym_false] = ACTIONS(345),
    [aux_sym_number_token1] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_context] = ACTIONS(351),
    [anon_sym_DOT_DOT] = ACTIONS(353),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_let] = ACTIONS(367),
    [anon_sym_set] = ACTIONS(369),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(371),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(375),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_show] = ACTIONS(379),
    [anon_sym_return] = ACTIONS(381),
    [anon_sym_break] = ACTIONS(383),
    [anon_sym_continue] = ACTIONS(383),
    [sym_auto] = ACTIONS(499),
    [sym_none] = ACTIONS(499),
    [sym__token_content] = ACTIONS(387),
    [sym__token_inlined_item_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [20] = {
    [sym_raw_blck] = STATE(2323),
    [sym_raw_span] = STATE(2323),
    [sym_math] = STATE(2323),
    [sym__expr] = STATE(2323),
    [sym_ident] = STATE(2323),
    [sym_bool] = STATE(2323),
    [sym_number] = STATE(2323),
    [sym_string] = STATE(2323),
    [sym_tagged] = STATE(2323),
    [sym_context] = STATE(2323),
    [sym_elude] = STATE(2323),
    [sym_assign] = STATE(2323),
    [sym_lambda] = STATE(2323),
    [sym_or] = STATE(2323),
    [sym_not] = STATE(2323),
    [sym_and] = STATE(2323),
    [sym_cmp] = STATE(2323),
    [sym_in] = STATE(2323),
    [sym_add] = STATE(2323),
    [sym_sub] = STATE(2323),
    [sym_mul] = STATE(2323),
    [sym_div] = STATE(2323),
    [sym_sign] = STATE(2323),
    [sym_call] = STATE(2323),
    [sym_field] = STATE(2323),
    [sym_label] = STATE(2323),
    [sym_content] = STATE(2323),
    [sym_group] = STATE(2323),
    [sym_block] = STATE(2323),
    [sym_branch] = STATE(2323),
    [sym_let] = STATE(2323),
    [sym_set] = STATE(2323),
    [sym_import] = STATE(2323),
    [sym_include] = STATE(2323),
    [sym_for] = STATE(2323),
    [sym_while] = STATE(2323),
    [sym_show] = STATE(2323),
    [sym_return] = STATE(2323),
    [sym_flow] = STATE(2323),
    [sym__identifier] = ACTIONS(501),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(503),
    [anon_sym_BQUOTE] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(509),
    [anon_sym_false] = ACTIONS(509),
    [aux_sym_number_token1] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_context] = ACTIONS(515),
    [anon_sym_DOT_DOT] = ACTIONS(517),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(523),
    [anon_sym_let] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_import] = ACTIONS(529),
    [anon_sym_include] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(535),
    [anon_sym_show] = ACTIONS(537),
    [anon_sym_return] = ACTIONS(539),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [sym_auto] = ACTIONS(543),
    [sym_none] = ACTIONS(543),
    [sym__token_content] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [21] = {
    [sym_raw_blck] = STATE(2315),
    [sym_raw_span] = STATE(2315),
    [sym_math] = STATE(2315),
    [sym__expr] = STATE(2315),
    [sym_ident] = STATE(2315),
    [sym_bool] = STATE(2315),
    [sym_number] = STATE(2315),
    [sym_string] = STATE(2315),
    [sym_tagged] = STATE(2315),
    [sym_context] = STATE(2315),
    [sym_elude] = STATE(2315),
    [sym_assign] = STATE(2315),
    [sym_lambda] = STATE(2315),
    [sym_or] = STATE(2315),
    [sym_not] = STATE(2315),
    [sym_and] = STATE(2315),
    [sym_cmp] = STATE(2315),
    [sym_in] = STATE(2315),
    [sym_add] = STATE(2315),
    [sym_sub] = STATE(2315),
    [sym_mul] = STATE(2315),
    [sym_div] = STATE(2315),
    [sym_sign] = STATE(2315),
    [sym_call] = STATE(2315),
    [sym_field] = STATE(2315),
    [sym_label] = STATE(2315),
    [sym_content] = STATE(2315),
    [sym_group] = STATE(2315),
    [sym_block] = STATE(2315),
    [sym_branch] = STATE(2315),
    [sym_let] = STATE(2315),
    [sym_set] = STATE(2315),
    [sym_import] = STATE(2315),
    [sym_include] = STATE(2315),
    [sym_for] = STATE(2315),
    [sym_while] = STATE(2315),
    [sym_show] = STATE(2315),
    [sym_return] = STATE(2315),
    [sym_flow] = STATE(2315),
    [sym__identifier] = ACTIONS(501),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(503),
    [anon_sym_BQUOTE] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_true] = ACTIONS(509),
    [anon_sym_false] = ACTIONS(509),
    [aux_sym_number_token1] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_context] = ACTIONS(515),
    [anon_sym_DOT_DOT] = ACTIONS(517),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(547),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(549),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(551),
    [anon_sym_DASH] = ACTIONS(551),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_RPAREN] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(523),
    [anon_sym_let] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_import] = ACTIONS(529),
    [anon_sym_include] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(535),
    [anon_sym_show] = ACTIONS(537),
    [anon_sym_return] = ACTIONS(539),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [sym_auto] = ACTIONS(553),
    [sym_none] = ACTIONS(553),
    [sym__token_content] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [22] = {
    [sym_raw_blck] = STATE(2643),
    [sym_raw_span] = STATE(2643),
    [sym_math] = STATE(2643),
    [sym__expr] = STATE(2643),
    [sym_ident] = STATE(2643),
    [sym_bool] = STATE(2643),
    [sym_number] = STATE(2643),
    [sym_string] = STATE(2643),
    [sym_tagged] = STATE(2643),
    [sym_context] = STATE(2643),
    [sym_elude] = STATE(2643),
    [sym_assign] = STATE(2643),
    [sym_lambda] = STATE(2643),
    [sym_or] = STATE(2643),
    [sym_not] = STATE(2643),
    [sym_and] = STATE(2643),
    [sym_cmp] = STATE(2643),
    [sym_in] = STATE(2643),
    [sym_add] = STATE(2643),
    [sym_sub] = STATE(2643),
    [sym_mul] = STATE(2643),
    [sym_div] = STATE(2643),
    [sym_sign] = STATE(2643),
    [sym_call] = STATE(2643),
    [sym_field] = STATE(2643),
    [sym_label] = STATE(2643),
    [sym_content] = STATE(2643),
    [sym_group] = STATE(2643),
    [sym_block] = STATE(2643),
    [sym_branch] = STATE(2643),
    [sym_let] = STATE(2643),
    [sym_set] = STATE(2643),
    [sym_import] = STATE(2643),
    [sym_include] = STATE(2643),
    [sym_for] = STATE(2643),
    [sym_while] = STATE(2643),
    [sym_show] = STATE(2643),
    [sym_return] = STATE(2643),
    [sym_flow] = STATE(2643),
    [sym__identifier] = ACTIONS(555),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(557),
    [anon_sym_BQUOTE] = ACTIONS(559),
    [anon_sym_DOLLAR] = ACTIONS(561),
    [anon_sym_true] = ACTIONS(563),
    [anon_sym_false] = ACTIONS(563),
    [aux_sym_number_token1] = ACTIONS(565),
    [anon_sym_DQUOTE] = ACTIONS(567),
    [anon_sym_context] = ACTIONS(569),
    [anon_sym_DOT_DOT] = ACTIONS(571),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(573),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_let] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(583),
    [anon_sym_include] = ACTIONS(585),
    [anon_sym_for] = ACTIONS(587),
    [anon_sym_while] = ACTIONS(589),
    [anon_sym_show] = ACTIONS(591),
    [anon_sym_return] = ACTIONS(593),
    [anon_sym_break] = ACTIONS(595),
    [anon_sym_continue] = ACTIONS(595),
    [sym_auto] = ACTIONS(597),
    [sym_none] = ACTIONS(597),
    [sym__token_content] = ACTIONS(599),
    [sym__token_blocked_expr_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [23] = {
    [sym_raw_blck] = STATE(2616),
    [sym_raw_span] = STATE(2616),
    [sym_math] = STATE(2616),
    [sym__expr] = STATE(2616),
    [sym_ident] = STATE(2616),
    [sym_bool] = STATE(2616),
    [sym_number] = STATE(2616),
    [sym_string] = STATE(2616),
    [sym_tagged] = STATE(2616),
    [sym_context] = STATE(2616),
    [sym_elude] = STATE(2616),
    [sym_assign] = STATE(2616),
    [sym_lambda] = STATE(2616),
    [sym_or] = STATE(2616),
    [sym_not] = STATE(2616),
    [sym_and] = STATE(2616),
    [sym_cmp] = STATE(2616),
    [sym_in] = STATE(2616),
    [sym_add] = STATE(2616),
    [sym_sub] = STATE(2616),
    [sym_mul] = STATE(2616),
    [sym_div] = STATE(2616),
    [sym_sign] = STATE(2616),
    [sym_call] = STATE(2616),
    [sym_field] = STATE(2616),
    [sym_label] = STATE(2616),
    [sym_content] = STATE(2616),
    [sym_group] = STATE(2616),
    [sym_block] = STATE(2616),
    [sym_branch] = STATE(2616),
    [sym_let] = STATE(2616),
    [sym_set] = STATE(2616),
    [sym_import] = STATE(2616),
    [sym_include] = STATE(2616),
    [sym_for] = STATE(2616),
    [sym_while] = STATE(2616),
    [sym_show] = STATE(2616),
    [sym_return] = STATE(2616),
    [sym_flow] = STATE(2616),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(643),
    [sym_none] = ACTIONS(643),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [24] = {
    [sym_raw_blck] = STATE(2677),
    [sym_raw_span] = STATE(2677),
    [sym_math] = STATE(2677),
    [sym__expr] = STATE(2677),
    [sym_ident] = STATE(2677),
    [sym_bool] = STATE(2677),
    [sym_number] = STATE(2677),
    [sym_string] = STATE(2677),
    [sym_tagged] = STATE(2677),
    [sym_context] = STATE(2677),
    [sym_elude] = STATE(2677),
    [sym_assign] = STATE(2677),
    [sym_lambda] = STATE(2677),
    [sym_or] = STATE(2677),
    [sym_not] = STATE(2677),
    [sym_and] = STATE(2677),
    [sym_cmp] = STATE(2677),
    [sym_in] = STATE(2677),
    [sym_add] = STATE(2677),
    [sym_sub] = STATE(2677),
    [sym_mul] = STATE(2677),
    [sym_div] = STATE(2677),
    [sym_sign] = STATE(2677),
    [sym_call] = STATE(2677),
    [sym_field] = STATE(2677),
    [sym_label] = STATE(2677),
    [sym_content] = STATE(2677),
    [sym_group] = STATE(2677),
    [sym_block] = STATE(2677),
    [sym_branch] = STATE(2677),
    [sym_let] = STATE(2677),
    [sym_set] = STATE(2677),
    [sym_import] = STATE(2677),
    [sym_include] = STATE(2677),
    [sym_for] = STATE(2677),
    [sym_while] = STATE(2677),
    [sym_show] = STATE(2677),
    [sym_return] = STATE(2677),
    [sym_flow] = STATE(2677),
    [sym__identifier] = ACTIONS(555),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(557),
    [anon_sym_BQUOTE] = ACTIONS(559),
    [anon_sym_DOLLAR] = ACTIONS(561),
    [anon_sym_true] = ACTIONS(563),
    [anon_sym_false] = ACTIONS(563),
    [aux_sym_number_token1] = ACTIONS(565),
    [anon_sym_DQUOTE] = ACTIONS(567),
    [anon_sym_context] = ACTIONS(569),
    [anon_sym_DOT_DOT] = ACTIONS(571),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(647),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(649),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(651),
    [anon_sym_DASH] = ACTIONS(651),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(573),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_let] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(583),
    [anon_sym_include] = ACTIONS(585),
    [anon_sym_for] = ACTIONS(587),
    [anon_sym_while] = ACTIONS(589),
    [anon_sym_show] = ACTIONS(591),
    [anon_sym_return] = ACTIONS(593),
    [anon_sym_break] = ACTIONS(595),
    [anon_sym_continue] = ACTIONS(595),
    [sym_auto] = ACTIONS(653),
    [sym_none] = ACTIONS(653),
    [sym__token_content] = ACTIONS(599),
    [sym__token_blocked_expr_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [25] = {
    [sym_raw_blck] = STATE(2448),
    [sym_raw_span] = STATE(2448),
    [sym_math] = STATE(2448),
    [sym__expr] = STATE(2448),
    [sym_ident] = STATE(2448),
    [sym_bool] = STATE(2448),
    [sym_number] = STATE(2448),
    [sym_string] = STATE(2448),
    [sym_tagged] = STATE(2448),
    [sym_context] = STATE(2448),
    [sym_elude] = STATE(2448),
    [sym_assign] = STATE(2448),
    [sym_lambda] = STATE(2448),
    [sym_or] = STATE(2448),
    [sym_not] = STATE(2448),
    [sym_and] = STATE(2448),
    [sym_cmp] = STATE(2448),
    [sym_in] = STATE(2448),
    [sym_add] = STATE(2448),
    [sym_sub] = STATE(2448),
    [sym_mul] = STATE(2448),
    [sym_div] = STATE(2448),
    [sym_sign] = STATE(2448),
    [sym_call] = STATE(2448),
    [sym_field] = STATE(2448),
    [sym_label] = STATE(2448),
    [sym_content] = STATE(2448),
    [sym_group] = STATE(2448),
    [sym_block] = STATE(2448),
    [sym_branch] = STATE(2448),
    [sym_let] = STATE(2448),
    [sym_set] = STATE(2448),
    [sym_import] = STATE(2448),
    [sym_include] = STATE(2448),
    [sym_for] = STATE(2448),
    [sym_while] = STATE(2448),
    [sym_show] = STATE(2448),
    [sym_return] = STATE(2448),
    [sym_flow] = STATE(2448),
    [sym__identifier] = ACTIONS(655),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(657),
    [anon_sym_BQUOTE] = ACTIONS(659),
    [anon_sym_DOLLAR] = ACTIONS(661),
    [anon_sym_true] = ACTIONS(663),
    [anon_sym_false] = ACTIONS(663),
    [aux_sym_number_token1] = ACTIONS(665),
    [anon_sym_DQUOTE] = ACTIONS(667),
    [anon_sym_context] = ACTIONS(669),
    [anon_sym_DOT_DOT] = ACTIONS(671),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(673),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(675),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(679),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_if] = ACTIONS(683),
    [anon_sym_let] = ACTIONS(685),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(687),
    [anon_sym_import] = ACTIONS(689),
    [anon_sym_include] = ACTIONS(691),
    [anon_sym_for] = ACTIONS(693),
    [anon_sym_while] = ACTIONS(695),
    [anon_sym_show] = ACTIONS(697),
    [anon_sym_return] = ACTIONS(699),
    [anon_sym_break] = ACTIONS(701),
    [anon_sym_continue] = ACTIONS(701),
    [sym_auto] = ACTIONS(703),
    [sym_none] = ACTIONS(703),
    [sym__token_content] = ACTIONS(705),
    [sym__token_inlined_item_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [26] = {
    [sym_raw_blck] = STATE(2453),
    [sym_raw_span] = STATE(2453),
    [sym_math] = STATE(2453),
    [sym__expr] = STATE(2453),
    [sym_ident] = STATE(2453),
    [sym_bool] = STATE(2453),
    [sym_number] = STATE(2453),
    [sym_string] = STATE(2453),
    [sym_tagged] = STATE(2453),
    [sym_context] = STATE(2453),
    [sym_elude] = STATE(2453),
    [sym_assign] = STATE(2453),
    [sym_lambda] = STATE(2453),
    [sym_or] = STATE(2453),
    [sym_not] = STATE(2453),
    [sym_and] = STATE(2453),
    [sym_cmp] = STATE(2453),
    [sym_in] = STATE(2453),
    [sym_add] = STATE(2453),
    [sym_sub] = STATE(2453),
    [sym_mul] = STATE(2453),
    [sym_div] = STATE(2453),
    [sym_sign] = STATE(2453),
    [sym_call] = STATE(2453),
    [sym_field] = STATE(2453),
    [sym_label] = STATE(2453),
    [sym_content] = STATE(2453),
    [sym_group] = STATE(2453),
    [sym_block] = STATE(2453),
    [sym_branch] = STATE(2453),
    [sym_let] = STATE(2453),
    [sym_set] = STATE(2453),
    [sym_import] = STATE(2453),
    [sym_include] = STATE(2453),
    [sym_for] = STATE(2453),
    [sym_while] = STATE(2453),
    [sym_show] = STATE(2453),
    [sym_return] = STATE(2453),
    [sym_flow] = STATE(2453),
    [sym__identifier] = ACTIONS(655),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(657),
    [anon_sym_BQUOTE] = ACTIONS(659),
    [anon_sym_DOLLAR] = ACTIONS(661),
    [anon_sym_true] = ACTIONS(663),
    [anon_sym_false] = ACTIONS(663),
    [aux_sym_number_token1] = ACTIONS(665),
    [anon_sym_DQUOTE] = ACTIONS(667),
    [anon_sym_context] = ACTIONS(669),
    [anon_sym_DOT_DOT] = ACTIONS(671),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(679),
    [anon_sym_LBRACE] = ACTIONS(681),
    [anon_sym_if] = ACTIONS(683),
    [anon_sym_let] = ACTIONS(685),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(687),
    [anon_sym_import] = ACTIONS(689),
    [anon_sym_include] = ACTIONS(691),
    [anon_sym_for] = ACTIONS(693),
    [anon_sym_while] = ACTIONS(695),
    [anon_sym_show] = ACTIONS(697),
    [anon_sym_return] = ACTIONS(699),
    [anon_sym_break] = ACTIONS(701),
    [anon_sym_continue] = ACTIONS(701),
    [sym_auto] = ACTIONS(707),
    [sym_none] = ACTIONS(707),
    [sym__token_content] = ACTIONS(705),
    [sym__token_inlined_item_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [27] = {
    [sym_raw_blck] = STATE(1765),
    [sym_raw_span] = STATE(1765),
    [sym_math] = STATE(1765),
    [sym__expr] = STATE(1765),
    [sym_ident] = STATE(1765),
    [sym_bool] = STATE(1765),
    [sym_number] = STATE(1765),
    [sym_string] = STATE(1765),
    [sym_tagged] = STATE(1765),
    [sym_context] = STATE(1765),
    [sym_elude] = STATE(1765),
    [sym_assign] = STATE(1765),
    [sym_lambda] = STATE(1765),
    [sym_or] = STATE(1765),
    [sym_not] = STATE(1765),
    [sym_and] = STATE(1765),
    [sym_cmp] = STATE(1765),
    [sym_in] = STATE(1765),
    [sym_add] = STATE(1765),
    [sym_sub] = STATE(1765),
    [sym_mul] = STATE(1765),
    [sym_div] = STATE(1765),
    [sym_sign] = STATE(1765),
    [sym_call] = STATE(1765),
    [sym_field] = STATE(1765),
    [sym_label] = STATE(1765),
    [sym_content] = STATE(1765),
    [sym_group] = STATE(1765),
    [sym_block] = STATE(1765),
    [sym_branch] = STATE(1765),
    [sym_let] = STATE(1765),
    [sym_set] = STATE(1765),
    [sym_import] = STATE(1765),
    [sym_include] = STATE(1765),
    [sym_for] = STATE(1765),
    [sym_while] = STATE(1765),
    [sym_show] = STATE(1765),
    [sym_return] = STATE(1765),
    [sym_flow] = STATE(1765),
    [sym__identifier] = ACTIONS(709),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(711),
    [anon_sym_BQUOTE] = ACTIONS(713),
    [anon_sym_DOLLAR] = ACTIONS(715),
    [anon_sym_true] = ACTIONS(717),
    [anon_sym_false] = ACTIONS(717),
    [aux_sym_number_token1] = ACTIONS(719),
    [anon_sym_DQUOTE] = ACTIONS(721),
    [anon_sym_context] = ACTIONS(723),
    [anon_sym_DOT_DOT] = ACTIONS(725),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(727),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(729),
    [anon_sym_let] = ACTIONS(731),
    [anon_sym_set] = ACTIONS(733),
    [anon_sym_as] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(735),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(737),
    [anon_sym_for] = ACTIONS(739),
    [anon_sym_while] = ACTIONS(741),
    [anon_sym_show] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(747),
    [sym_auto] = ACTIONS(749),
    [sym_none] = ACTIONS(749),
    [sym__token_content] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [28] = {
    [sym_raw_blck] = STATE(1771),
    [sym_raw_span] = STATE(1771),
    [sym_math] = STATE(1771),
    [sym__expr] = STATE(1771),
    [sym_ident] = STATE(1771),
    [sym_bool] = STATE(1771),
    [sym_number] = STATE(1771),
    [sym_string] = STATE(1771),
    [sym_tagged] = STATE(1771),
    [sym_context] = STATE(1771),
    [sym_elude] = STATE(1771),
    [sym_assign] = STATE(1771),
    [sym_lambda] = STATE(1771),
    [sym_or] = STATE(1771),
    [sym_not] = STATE(1771),
    [sym_and] = STATE(1771),
    [sym_cmp] = STATE(1771),
    [sym_in] = STATE(1771),
    [sym_add] = STATE(1771),
    [sym_sub] = STATE(1771),
    [sym_mul] = STATE(1771),
    [sym_div] = STATE(1771),
    [sym_sign] = STATE(1771),
    [sym_call] = STATE(1771),
    [sym_field] = STATE(1771),
    [sym_label] = STATE(1771),
    [sym_content] = STATE(1771),
    [sym_group] = STATE(1771),
    [sym_block] = STATE(1771),
    [sym_branch] = STATE(1771),
    [sym_let] = STATE(1771),
    [sym_set] = STATE(1771),
    [sym_import] = STATE(1771),
    [sym_include] = STATE(1771),
    [sym_for] = STATE(1771),
    [sym_while] = STATE(1771),
    [sym_show] = STATE(1771),
    [sym_return] = STATE(1771),
    [sym_flow] = STATE(1771),
    [sym__identifier] = ACTIONS(709),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(711),
    [anon_sym_BQUOTE] = ACTIONS(713),
    [anon_sym_DOLLAR] = ACTIONS(715),
    [anon_sym_true] = ACTIONS(717),
    [anon_sym_false] = ACTIONS(717),
    [aux_sym_number_token1] = ACTIONS(719),
    [anon_sym_DQUOTE] = ACTIONS(721),
    [anon_sym_context] = ACTIONS(723),
    [anon_sym_DOT_DOT] = ACTIONS(725),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(751),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(753),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(755),
    [anon_sym_DASH] = ACTIONS(755),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(727),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_if] = ACTIONS(729),
    [anon_sym_let] = ACTIONS(731),
    [anon_sym_set] = ACTIONS(733),
    [anon_sym_as] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(735),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(737),
    [anon_sym_for] = ACTIONS(739),
    [anon_sym_while] = ACTIONS(741),
    [anon_sym_show] = ACTIONS(743),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(747),
    [anon_sym_continue] = ACTIONS(747),
    [sym_auto] = ACTIONS(759),
    [sym_none] = ACTIONS(759),
    [sym__token_content] = ACTIONS(761),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [29] = {
    [sym_raw_blck] = STATE(2759),
    [sym_raw_span] = STATE(2759),
    [sym_math] = STATE(2759),
    [sym__expr] = STATE(2759),
    [sym_ident] = STATE(2759),
    [sym_bool] = STATE(2759),
    [sym_number] = STATE(2759),
    [sym_string] = STATE(2759),
    [sym_tagged] = STATE(2759),
    [sym_context] = STATE(2759),
    [sym_elude] = STATE(2759),
    [sym_assign] = STATE(2759),
    [sym_lambda] = STATE(2759),
    [sym_or] = STATE(2759),
    [sym_not] = STATE(2759),
    [sym_and] = STATE(2759),
    [sym_cmp] = STATE(2759),
    [sym_in] = STATE(2759),
    [sym_add] = STATE(2759),
    [sym_sub] = STATE(2759),
    [sym_mul] = STATE(2759),
    [sym_div] = STATE(2759),
    [sym_sign] = STATE(2759),
    [sym_call] = STATE(2759),
    [sym_field] = STATE(2759),
    [sym_label] = STATE(2759),
    [sym_content] = STATE(2759),
    [sym_group] = STATE(2759),
    [sym_block] = STATE(2759),
    [sym_branch] = STATE(2759),
    [sym_let] = STATE(2759),
    [sym_set] = STATE(2759),
    [sym_import] = STATE(2759),
    [sym_include] = STATE(2759),
    [sym_for] = STATE(2759),
    [sym_while] = STATE(2759),
    [sym_show] = STATE(2759),
    [sym_return] = STATE(2759),
    [sym_flow] = STATE(2759),
    [sym__identifier] = ACTIONS(763),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(769),
    [anon_sym_true] = ACTIONS(771),
    [anon_sym_false] = ACTIONS(771),
    [aux_sym_number_token1] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(775),
    [anon_sym_context] = ACTIONS(777),
    [anon_sym_DOT_DOT] = ACTIONS(779),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(781),
    [anon_sym_LBRACE] = ACTIONS(783),
    [anon_sym_if] = ACTIONS(785),
    [anon_sym_let] = ACTIONS(787),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(789),
    [anon_sym_import] = ACTIONS(791),
    [anon_sym_include] = ACTIONS(793),
    [anon_sym_for] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(797),
    [anon_sym_show] = ACTIONS(799),
    [anon_sym_return] = ACTIONS(801),
    [anon_sym_break] = ACTIONS(803),
    [anon_sym_continue] = ACTIONS(803),
    [sym_auto] = ACTIONS(805),
    [sym_none] = ACTIONS(805),
    [sym__token_content] = ACTIONS(807),
    [sym__token_inlined_stmt_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [30] = {
    [sym_raw_blck] = STATE(2687),
    [sym_raw_span] = STATE(2687),
    [sym_math] = STATE(2687),
    [sym__expr] = STATE(2687),
    [sym_ident] = STATE(2687),
    [sym_bool] = STATE(2687),
    [sym_number] = STATE(2687),
    [sym_string] = STATE(2687),
    [sym_tagged] = STATE(2687),
    [sym_context] = STATE(2687),
    [sym_elude] = STATE(2687),
    [sym_assign] = STATE(2687),
    [sym_lambda] = STATE(2687),
    [sym_or] = STATE(2687),
    [sym_not] = STATE(2687),
    [sym_and] = STATE(2687),
    [sym_cmp] = STATE(2687),
    [sym_in] = STATE(2687),
    [sym_add] = STATE(2687),
    [sym_sub] = STATE(2687),
    [sym_mul] = STATE(2687),
    [sym_div] = STATE(2687),
    [sym_sign] = STATE(2687),
    [sym_call] = STATE(2687),
    [sym_field] = STATE(2687),
    [sym_label] = STATE(2687),
    [sym_content] = STATE(2687),
    [sym_group] = STATE(2687),
    [sym_block] = STATE(2687),
    [sym_branch] = STATE(2687),
    [sym_let] = STATE(2687),
    [sym_set] = STATE(2687),
    [sym_import] = STATE(2687),
    [sym_include] = STATE(2687),
    [sym_for] = STATE(2687),
    [sym_while] = STATE(2687),
    [sym_show] = STATE(2687),
    [sym_return] = STATE(2687),
    [sym_flow] = STATE(2687),
    [sym__identifier] = ACTIONS(7),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(11),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_true] = ACTIONS(19),
    [anon_sym_false] = ACTIONS(19),
    [aux_sym_number_token1] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [anon_sym_context] = ACTIONS(809),
    [anon_sym_DOT_DOT] = ACTIONS(811),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(813),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(815),
    [anon_sym_import] = ACTIONS(817),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(819),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_show] = ACTIONS(821),
    [anon_sym_return] = ACTIONS(823),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(57),
    [sym_auto] = ACTIONS(825),
    [sym_none] = ACTIONS(825),
    [sym__token_content] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [31] = {
    [sym_raw_blck] = STATE(2758),
    [sym_raw_span] = STATE(2758),
    [sym_math] = STATE(2758),
    [sym__expr] = STATE(2758),
    [sym_ident] = STATE(2758),
    [sym_bool] = STATE(2758),
    [sym_number] = STATE(2758),
    [sym_string] = STATE(2758),
    [sym_tagged] = STATE(2758),
    [sym_context] = STATE(2758),
    [sym_elude] = STATE(2758),
    [sym_assign] = STATE(2758),
    [sym_lambda] = STATE(2758),
    [sym_or] = STATE(2758),
    [sym_not] = STATE(2758),
    [sym_and] = STATE(2758),
    [sym_cmp] = STATE(2758),
    [sym_in] = STATE(2758),
    [sym_add] = STATE(2758),
    [sym_sub] = STATE(2758),
    [sym_mul] = STATE(2758),
    [sym_div] = STATE(2758),
    [sym_sign] = STATE(2758),
    [sym_call] = STATE(2758),
    [sym_field] = STATE(2758),
    [sym_label] = STATE(2758),
    [sym_content] = STATE(2758),
    [sym_group] = STATE(2758),
    [sym_block] = STATE(2758),
    [sym_branch] = STATE(2758),
    [sym_let] = STATE(2758),
    [sym_set] = STATE(2758),
    [sym_import] = STATE(2758),
    [sym_include] = STATE(2758),
    [sym_for] = STATE(2758),
    [sym_while] = STATE(2758),
    [sym_show] = STATE(2758),
    [sym_return] = STATE(2758),
    [sym_flow] = STATE(2758),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(829),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(831),
    [anon_sym_DASH] = ACTIONS(831),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(833),
    [sym_none] = ACTIONS(833),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [32] = {
    [sym_raw_blck] = STATE(2738),
    [sym_raw_span] = STATE(2738),
    [sym_math] = STATE(2738),
    [sym__expr] = STATE(2738),
    [sym_ident] = STATE(2738),
    [sym_bool] = STATE(2738),
    [sym_number] = STATE(2738),
    [sym_string] = STATE(2738),
    [sym_tagged] = STATE(2738),
    [sym_context] = STATE(2738),
    [sym_elude] = STATE(2738),
    [sym_assign] = STATE(2738),
    [sym_lambda] = STATE(2738),
    [sym_or] = STATE(2738),
    [sym_not] = STATE(2738),
    [sym_and] = STATE(2738),
    [sym_cmp] = STATE(2738),
    [sym_in] = STATE(2738),
    [sym_add] = STATE(2738),
    [sym_sub] = STATE(2738),
    [sym_mul] = STATE(2738),
    [sym_div] = STATE(2738),
    [sym_sign] = STATE(2738),
    [sym_call] = STATE(2738),
    [sym_field] = STATE(2738),
    [sym_label] = STATE(2738),
    [sym_content] = STATE(2738),
    [sym_group] = STATE(2738),
    [sym_block] = STATE(2738),
    [sym_branch] = STATE(2738),
    [sym_let] = STATE(2738),
    [sym_set] = STATE(2738),
    [sym_import] = STATE(2738),
    [sym_include] = STATE(2738),
    [sym_for] = STATE(2738),
    [sym_while] = STATE(2738),
    [sym_show] = STATE(2738),
    [sym_return] = STATE(2738),
    [sym_flow] = STATE(2738),
    [sym__identifier] = ACTIONS(7),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(11),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_true] = ACTIONS(19),
    [anon_sym_false] = ACTIONS(19),
    [aux_sym_number_token1] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [anon_sym_context] = ACTIONS(809),
    [anon_sym_DOT_DOT] = ACTIONS(811),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(835),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(31),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(837),
    [anon_sym_DASH] = ACTIONS(837),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(813),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(815),
    [anon_sym_import] = ACTIONS(817),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(819),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_show] = ACTIONS(821),
    [anon_sym_return] = ACTIONS(823),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(57),
    [sym_auto] = ACTIONS(839),
    [sym_none] = ACTIONS(839),
    [sym__token_content] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [33] = {
    [sym_raw_blck] = STATE(2632),
    [sym_raw_span] = STATE(2632),
    [sym_math] = STATE(2632),
    [sym__expr] = STATE(2632),
    [sym_ident] = STATE(2632),
    [sym_bool] = STATE(2632),
    [sym_number] = STATE(2632),
    [sym_string] = STATE(2632),
    [sym_tagged] = STATE(2632),
    [sym_context] = STATE(2632),
    [sym_elude] = STATE(2632),
    [sym_assign] = STATE(2632),
    [sym_lambda] = STATE(2632),
    [sym_or] = STATE(2632),
    [sym_not] = STATE(2632),
    [sym_and] = STATE(2632),
    [sym_cmp] = STATE(2632),
    [sym_in] = STATE(2632),
    [sym_add] = STATE(2632),
    [sym_sub] = STATE(2632),
    [sym_mul] = STATE(2632),
    [sym_div] = STATE(2632),
    [sym_sign] = STATE(2632),
    [sym_call] = STATE(2632),
    [sym_field] = STATE(2632),
    [sym_label] = STATE(2632),
    [sym_content] = STATE(2632),
    [sym_group] = STATE(2632),
    [sym_block] = STATE(2632),
    [sym_branch] = STATE(2632),
    [sym_let] = STATE(2632),
    [sym_set] = STATE(2632),
    [sym_import] = STATE(2632),
    [sym_include] = STATE(2632),
    [sym_for] = STATE(2632),
    [sym_while] = STATE(2632),
    [sym_show] = STATE(2632),
    [sym_return] = STATE(2632),
    [sym_flow] = STATE(2632),
    [sym__identifier] = ACTIONS(763),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(767),
    [anon_sym_DOLLAR] = ACTIONS(769),
    [anon_sym_true] = ACTIONS(771),
    [anon_sym_false] = ACTIONS(771),
    [aux_sym_number_token1] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(775),
    [anon_sym_context] = ACTIONS(777),
    [anon_sym_DOT_DOT] = ACTIONS(779),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(841),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(843),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(845),
    [anon_sym_DASH] = ACTIONS(845),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(781),
    [anon_sym_LBRACE] = ACTIONS(783),
    [anon_sym_if] = ACTIONS(785),
    [anon_sym_let] = ACTIONS(787),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(789),
    [anon_sym_import] = ACTIONS(791),
    [anon_sym_include] = ACTIONS(793),
    [anon_sym_for] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(797),
    [anon_sym_show] = ACTIONS(799),
    [anon_sym_return] = ACTIONS(801),
    [anon_sym_break] = ACTIONS(803),
    [anon_sym_continue] = ACTIONS(803),
    [sym_auto] = ACTIONS(847),
    [sym_none] = ACTIONS(847),
    [sym__token_content] = ACTIONS(807),
    [sym__token_inlined_stmt_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [34] = {
    [sym_raw_blck] = STATE(2832),
    [sym_raw_span] = STATE(2832),
    [sym_math] = STATE(2832),
    [sym__expr] = STATE(2832),
    [sym_ident] = STATE(2832),
    [sym_bool] = STATE(2832),
    [sym_number] = STATE(2832),
    [sym_string] = STATE(2832),
    [sym_tagged] = STATE(2832),
    [sym_context] = STATE(2832),
    [sym_elude] = STATE(2832),
    [sym_assign] = STATE(2832),
    [sym_lambda] = STATE(2832),
    [sym_or] = STATE(2832),
    [sym_not] = STATE(2832),
    [sym_and] = STATE(2832),
    [sym_cmp] = STATE(2832),
    [sym_in] = STATE(2832),
    [sym_add] = STATE(2832),
    [sym_sub] = STATE(2832),
    [sym_mul] = STATE(2832),
    [sym_div] = STATE(2832),
    [sym_sign] = STATE(2832),
    [sym_call] = STATE(2832),
    [sym_field] = STATE(2832),
    [sym_label] = STATE(2832),
    [sym_content] = STATE(2832),
    [sym_group] = STATE(2832),
    [sym_block] = STATE(2832),
    [sym_branch] = STATE(2832),
    [sym_let] = STATE(2832),
    [sym_set] = STATE(2832),
    [sym_import] = STATE(2832),
    [sym_include] = STATE(2832),
    [sym_for] = STATE(2832),
    [sym_while] = STATE(2832),
    [sym_show] = STATE(2832),
    [sym_return] = STATE(2832),
    [sym_flow] = STATE(2832),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(891),
    [sym_none] = ACTIONS(891),
    [sym__token_content] = ACTIONS(893),
    [sym__token_blocked_expr_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [35] = {
    [sym_raw_blck] = STATE(2903),
    [sym_raw_span] = STATE(2903),
    [sym_math] = STATE(2903),
    [sym__expr] = STATE(2903),
    [sym_ident] = STATE(2903),
    [sym_bool] = STATE(2903),
    [sym_number] = STATE(2903),
    [sym_string] = STATE(2903),
    [sym_tagged] = STATE(2903),
    [sym_context] = STATE(2903),
    [sym_elude] = STATE(2903),
    [sym_assign] = STATE(2903),
    [sym_lambda] = STATE(2903),
    [sym_or] = STATE(2903),
    [sym_not] = STATE(2903),
    [sym_and] = STATE(2903),
    [sym_cmp] = STATE(2903),
    [sym_in] = STATE(2903),
    [sym_add] = STATE(2903),
    [sym_sub] = STATE(2903),
    [sym_mul] = STATE(2903),
    [sym_div] = STATE(2903),
    [sym_sign] = STATE(2903),
    [sym_call] = STATE(2903),
    [sym_field] = STATE(2903),
    [sym_label] = STATE(2903),
    [sym_content] = STATE(2903),
    [sym_group] = STATE(2903),
    [sym_block] = STATE(2903),
    [sym_branch] = STATE(2903),
    [sym_let] = STATE(2903),
    [sym_set] = STATE(2903),
    [sym_import] = STATE(2903),
    [sym_include] = STATE(2903),
    [sym_for] = STATE(2903),
    [sym_while] = STATE(2903),
    [sym_show] = STATE(2903),
    [sym_return] = STATE(2903),
    [sym_flow] = STATE(2903),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(911),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(919),
    [anon_sym_set] = ACTIONS(921),
    [anon_sym_import] = ACTIONS(923),
    [anon_sym_include] = ACTIONS(925),
    [anon_sym_for] = ACTIONS(927),
    [anon_sym_while] = ACTIONS(929),
    [anon_sym_show] = ACTIONS(931),
    [anon_sym_return] = ACTIONS(933),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(937),
    [sym_none] = ACTIONS(937),
    [sym__token_content] = ACTIONS(939),
    [sym__token_inlined_item_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [36] = {
    [sym_raw_blck] = STATE(2918),
    [sym_raw_span] = STATE(2918),
    [sym_math] = STATE(2918),
    [sym__expr] = STATE(2918),
    [sym_ident] = STATE(2918),
    [sym_bool] = STATE(2918),
    [sym_number] = STATE(2918),
    [sym_string] = STATE(2918),
    [sym_tagged] = STATE(2918),
    [sym_context] = STATE(2918),
    [sym_elude] = STATE(2918),
    [sym_assign] = STATE(2918),
    [sym_lambda] = STATE(2918),
    [sym_or] = STATE(2918),
    [sym_not] = STATE(2918),
    [sym_and] = STATE(2918),
    [sym_cmp] = STATE(2918),
    [sym_in] = STATE(2918),
    [sym_add] = STATE(2918),
    [sym_sub] = STATE(2918),
    [sym_mul] = STATE(2918),
    [sym_div] = STATE(2918),
    [sym_sign] = STATE(2918),
    [sym_call] = STATE(2918),
    [sym_field] = STATE(2918),
    [sym_label] = STATE(2918),
    [sym_content] = STATE(2918),
    [sym_group] = STATE(2918),
    [sym_block] = STATE(2918),
    [sym_branch] = STATE(2918),
    [sym_let] = STATE(2918),
    [sym_set] = STATE(2918),
    [sym_import] = STATE(2918),
    [sym_include] = STATE(2918),
    [sym_for] = STATE(2918),
    [sym_while] = STATE(2918),
    [sym_show] = STATE(2918),
    [sym_return] = STATE(2918),
    [sym_flow] = STATE(2918),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(911),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(941),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(943),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(945),
    [anon_sym_DASH] = ACTIONS(945),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(919),
    [anon_sym_set] = ACTIONS(921),
    [anon_sym_import] = ACTIONS(923),
    [anon_sym_include] = ACTIONS(925),
    [anon_sym_for] = ACTIONS(927),
    [anon_sym_while] = ACTIONS(929),
    [anon_sym_show] = ACTIONS(931),
    [anon_sym_return] = ACTIONS(933),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(947),
    [sym_none] = ACTIONS(947),
    [sym__token_content] = ACTIONS(939),
    [sym__token_inlined_item_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [37] = {
    [sym_raw_blck] = STATE(2162),
    [sym_raw_span] = STATE(2162),
    [sym_math] = STATE(2162),
    [sym__expr] = STATE(2162),
    [sym_ident] = STATE(2162),
    [sym_bool] = STATE(2162),
    [sym_number] = STATE(2162),
    [sym_string] = STATE(2162),
    [sym_tagged] = STATE(2162),
    [sym_context] = STATE(2162),
    [sym_elude] = STATE(2162),
    [sym_assign] = STATE(2162),
    [sym_lambda] = STATE(2162),
    [sym_or] = STATE(2162),
    [sym_not] = STATE(2162),
    [sym_and] = STATE(2162),
    [sym_cmp] = STATE(2162),
    [sym_in] = STATE(2162),
    [sym_add] = STATE(2162),
    [sym_sub] = STATE(2162),
    [sym_mul] = STATE(2162),
    [sym_div] = STATE(2162),
    [sym_sign] = STATE(2162),
    [sym_call] = STATE(2162),
    [sym_field] = STATE(2162),
    [sym_label] = STATE(2162),
    [sym_content] = STATE(2162),
    [sym_group] = STATE(2162),
    [sym_block] = STATE(2162),
    [sym_branch] = STATE(2162),
    [sym_let] = STATE(2162),
    [sym_set] = STATE(2162),
    [sym_import] = STATE(2162),
    [sym_include] = STATE(2162),
    [sym_for] = STATE(2162),
    [sym_while] = STATE(2162),
    [sym_show] = STATE(2162),
    [sym_return] = STATE(2162),
    [sym_flow] = STATE(2162),
    [sym__identifier] = ACTIONS(949),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(953),
    [anon_sym_DOLLAR] = ACTIONS(955),
    [anon_sym_true] = ACTIONS(957),
    [anon_sym_false] = ACTIONS(957),
    [aux_sym_number_token1] = ACTIONS(959),
    [anon_sym_DQUOTE] = ACTIONS(961),
    [anon_sym_context] = ACTIONS(963),
    [anon_sym_DOT_DOT] = ACTIONS(965),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(967),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(969),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(9),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(971),
    [anon_sym_DASH] = ACTIONS(971),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(973),
    [anon_sym_LBRACE] = ACTIONS(975),
    [anon_sym_if] = ACTIONS(977),
    [anon_sym_let] = ACTIONS(979),
    [anon_sym_EQ] = ACTIONS(17),
    [anon_sym_set] = ACTIONS(981),
    [anon_sym_import] = ACTIONS(983),
    [anon_sym_include] = ACTIONS(985),
    [anon_sym_for] = ACTIONS(987),
    [anon_sym_while] = ACTIONS(989),
    [anon_sym_show] = ACTIONS(991),
    [anon_sym_return] = ACTIONS(993),
    [anon_sym_break] = ACTIONS(995),
    [anon_sym_continue] = ACTIONS(995),
    [sym_auto] = ACTIONS(997),
    [sym_none] = ACTIONS(997),
    [sym__token_content] = ACTIONS(999),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [38] = {
    [sym_raw_blck] = STATE(2166),
    [sym_raw_span] = STATE(2166),
    [sym_math] = STATE(2166),
    [sym__expr] = STATE(2166),
    [sym_ident] = STATE(2166),
    [sym_bool] = STATE(2166),
    [sym_number] = STATE(2166),
    [sym_string] = STATE(2166),
    [sym_tagged] = STATE(2166),
    [sym_context] = STATE(2166),
    [sym_elude] = STATE(2166),
    [sym_assign] = STATE(2166),
    [sym_lambda] = STATE(2166),
    [sym_or] = STATE(2166),
    [sym_not] = STATE(2166),
    [sym_and] = STATE(2166),
    [sym_cmp] = STATE(2166),
    [sym_in] = STATE(2166),
    [sym_add] = STATE(2166),
    [sym_sub] = STATE(2166),
    [sym_mul] = STATE(2166),
    [sym_div] = STATE(2166),
    [sym_sign] = STATE(2166),
    [sym_call] = STATE(2166),
    [sym_field] = STATE(2166),
    [sym_label] = STATE(2166),
    [sym_content] = STATE(2166),
    [sym_group] = STATE(2166),
    [sym_block] = STATE(2166),
    [sym_branch] = STATE(2166),
    [sym_let] = STATE(2166),
    [sym_set] = STATE(2166),
    [sym_import] = STATE(2166),
    [sym_include] = STATE(2166),
    [sym_for] = STATE(2166),
    [sym_while] = STATE(2166),
    [sym_show] = STATE(2166),
    [sym_return] = STATE(2166),
    [sym_flow] = STATE(2166),
    [sym__identifier] = ACTIONS(949),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(953),
    [anon_sym_DOLLAR] = ACTIONS(955),
    [anon_sym_true] = ACTIONS(957),
    [anon_sym_false] = ACTIONS(957),
    [aux_sym_number_token1] = ACTIONS(959),
    [anon_sym_DQUOTE] = ACTIONS(961),
    [anon_sym_context] = ACTIONS(963),
    [anon_sym_DOT_DOT] = ACTIONS(965),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(63),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(63),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(973),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(977),
    [anon_sym_let] = ACTIONS(979),
    [anon_sym_EQ] = ACTIONS(65),
    [anon_sym_set] = ACTIONS(981),
    [anon_sym_import] = ACTIONS(983),
    [anon_sym_include] = ACTIONS(985),
    [anon_sym_for] = ACTIONS(987),
    [anon_sym_while] = ACTIONS(989),
    [anon_sym_show] = ACTIONS(991),
    [anon_sym_return] = ACTIONS(993),
    [anon_sym_break] = ACTIONS(995),
    [anon_sym_continue] = ACTIONS(995),
    [sym_auto] = ACTIONS(1001),
    [sym_none] = ACTIONS(1001),
    [sym__token_content] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [39] = {
    [sym_raw_blck] = STATE(2856),
    [sym_raw_span] = STATE(2856),
    [sym_math] = STATE(2856),
    [sym__expr] = STATE(2856),
    [sym_ident] = STATE(2856),
    [sym_bool] = STATE(2856),
    [sym_number] = STATE(2856),
    [sym_string] = STATE(2856),
    [sym_tagged] = STATE(2856),
    [sym_context] = STATE(2856),
    [sym_elude] = STATE(2856),
    [sym_assign] = STATE(2856),
    [sym_lambda] = STATE(2856),
    [sym_or] = STATE(2856),
    [sym_not] = STATE(2856),
    [sym_and] = STATE(2856),
    [sym_cmp] = STATE(2856),
    [sym_in] = STATE(2856),
    [sym_add] = STATE(2856),
    [sym_sub] = STATE(2856),
    [sym_mul] = STATE(2856),
    [sym_div] = STATE(2856),
    [sym_sign] = STATE(2856),
    [sym_call] = STATE(2856),
    [sym_field] = STATE(2856),
    [sym_label] = STATE(2856),
    [sym_content] = STATE(2856),
    [sym_group] = STATE(2856),
    [sym_block] = STATE(2856),
    [sym_branch] = STATE(2856),
    [sym_let] = STATE(2856),
    [sym_set] = STATE(2856),
    [sym_import] = STATE(2856),
    [sym_include] = STATE(2856),
    [sym_for] = STATE(2856),
    [sym_while] = STATE(2856),
    [sym_show] = STATE(2856),
    [sym_return] = STATE(2856),
    [sym_flow] = STATE(2856),
    [sym__identifier] = ACTIONS(1003),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1005),
    [anon_sym_BQUOTE] = ACTIONS(1007),
    [anon_sym_DOLLAR] = ACTIONS(1009),
    [anon_sym_true] = ACTIONS(1011),
    [anon_sym_false] = ACTIONS(1011),
    [aux_sym_number_token1] = ACTIONS(1013),
    [anon_sym_DQUOTE] = ACTIONS(1015),
    [anon_sym_context] = ACTIONS(1017),
    [anon_sym_DOT_DOT] = ACTIONS(1019),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(1021),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(1023),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(1025),
    [anon_sym_DASH] = ACTIONS(1025),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(1027),
    [anon_sym_LBRACE] = ACTIONS(1029),
    [anon_sym_if] = ACTIONS(1031),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(1049),
    [anon_sym_continue] = ACTIONS(1049),
    [sym_auto] = ACTIONS(1051),
    [sym_none] = ACTIONS(1051),
    [sym__token_content] = ACTIONS(1053),
    [sym__token_inlined_stmt_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [40] = {
    [sym_raw_blck] = STATE(2851),
    [sym_raw_span] = STATE(2851),
    [sym_math] = STATE(2851),
    [sym__expr] = STATE(2851),
    [sym_ident] = STATE(2851),
    [sym_bool] = STATE(2851),
    [sym_number] = STATE(2851),
    [sym_string] = STATE(2851),
    [sym_tagged] = STATE(2851),
    [sym_context] = STATE(2851),
    [sym_elude] = STATE(2851),
    [sym_assign] = STATE(2851),
    [sym_lambda] = STATE(2851),
    [sym_or] = STATE(2851),
    [sym_not] = STATE(2851),
    [sym_and] = STATE(2851),
    [sym_cmp] = STATE(2851),
    [sym_in] = STATE(2851),
    [sym_add] = STATE(2851),
    [sym_sub] = STATE(2851),
    [sym_mul] = STATE(2851),
    [sym_div] = STATE(2851),
    [sym_sign] = STATE(2851),
    [sym_call] = STATE(2851),
    [sym_field] = STATE(2851),
    [sym_label] = STATE(2851),
    [sym_content] = STATE(2851),
    [sym_group] = STATE(2851),
    [sym_block] = STATE(2851),
    [sym_branch] = STATE(2851),
    [sym_let] = STATE(2851),
    [sym_set] = STATE(2851),
    [sym_import] = STATE(2851),
    [sym_include] = STATE(2851),
    [sym_for] = STATE(2851),
    [sym_while] = STATE(2851),
    [sym_show] = STATE(2851),
    [sym_return] = STATE(2851),
    [sym_flow] = STATE(2851),
    [sym__identifier] = ACTIONS(1003),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1005),
    [anon_sym_BQUOTE] = ACTIONS(1007),
    [anon_sym_DOLLAR] = ACTIONS(1009),
    [anon_sym_true] = ACTIONS(1011),
    [anon_sym_false] = ACTIONS(1011),
    [aux_sym_number_token1] = ACTIONS(1013),
    [anon_sym_DQUOTE] = ACTIONS(1015),
    [anon_sym_context] = ACTIONS(1017),
    [anon_sym_DOT_DOT] = ACTIONS(1019),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(1027),
    [anon_sym_LBRACE] = ACTIONS(1029),
    [anon_sym_if] = ACTIONS(1031),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(1049),
    [anon_sym_continue] = ACTIONS(1049),
    [sym_auto] = ACTIONS(1055),
    [sym_none] = ACTIONS(1055),
    [sym__token_content] = ACTIONS(1053),
    [sym__token_inlined_stmt_end] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [41] = {
    [sym_raw_blck] = STATE(2942),
    [sym_raw_span] = STATE(2942),
    [sym_math] = STATE(2942),
    [sym__expr] = STATE(2942),
    [sym_ident] = STATE(2942),
    [sym_bool] = STATE(2942),
    [sym_number] = STATE(2942),
    [sym_string] = STATE(2942),
    [sym_tagged] = STATE(2942),
    [sym_context] = STATE(2942),
    [sym_elude] = STATE(2942),
    [sym_assign] = STATE(2942),
    [sym_lambda] = STATE(2942),
    [sym_or] = STATE(2942),
    [sym_not] = STATE(2942),
    [sym_and] = STATE(2942),
    [sym_cmp] = STATE(2942),
    [sym_in] = STATE(2942),
    [sym_add] = STATE(2942),
    [sym_sub] = STATE(2942),
    [sym_mul] = STATE(2942),
    [sym_div] = STATE(2942),
    [sym_sign] = STATE(2942),
    [sym_call] = STATE(2942),
    [sym_field] = STATE(2942),
    [sym_label] = STATE(2942),
    [sym_content] = STATE(2942),
    [sym_group] = STATE(2942),
    [sym_block] = STATE(2942),
    [sym_branch] = STATE(2942),
    [sym_let] = STATE(2942),
    [sym_set] = STATE(2942),
    [sym_import] = STATE(2942),
    [sym_include] = STATE(2942),
    [sym_for] = STATE(2942),
    [sym_while] = STATE(2942),
    [sym_show] = STATE(2942),
    [sym_return] = STATE(2942),
    [sym_flow] = STATE(2942),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(1059),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(1061),
    [anon_sym_DASH] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1063),
    [sym_none] = ACTIONS(1063),
    [sym__token_content] = ACTIONS(893),
    [sym__token_blocked_expr_end] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [42] = {
    [sym_raw_blck] = STATE(2927),
    [sym_raw_span] = STATE(2927),
    [sym_math] = STATE(2927),
    [sym__expr] = STATE(2927),
    [sym_ident] = STATE(2927),
    [sym_bool] = STATE(2927),
    [sym_number] = STATE(2927),
    [sym_string] = STATE(2927),
    [sym_tagged] = STATE(2927),
    [sym_context] = STATE(2927),
    [sym_elude] = STATE(2927),
    [sym_assign] = STATE(2927),
    [sym_lambda] = STATE(2927),
    [sym_or] = STATE(2927),
    [sym_not] = STATE(2927),
    [sym_and] = STATE(2927),
    [sym_cmp] = STATE(2927),
    [sym_in] = STATE(2927),
    [sym_add] = STATE(2927),
    [sym_sub] = STATE(2927),
    [sym_mul] = STATE(2927),
    [sym_div] = STATE(2927),
    [sym_sign] = STATE(2927),
    [sym_call] = STATE(2927),
    [sym_field] = STATE(2927),
    [sym_label] = STATE(2927),
    [sym_content] = STATE(2927),
    [sym_group] = STATE(2927),
    [sym_block] = STATE(2927),
    [sym_branch] = STATE(2927),
    [sym_let] = STATE(2927),
    [sym_set] = STATE(2927),
    [sym_import] = STATE(2927),
    [sym_include] = STATE(2927),
    [sym_for] = STATE(2927),
    [sym_while] = STATE(2927),
    [sym_show] = STATE(2927),
    [sym_return] = STATE(2927),
    [sym_flow] = STATE(2927),
    [sym__identifier] = ACTIONS(123),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(9),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_true] = ACTIONS(131),
    [anon_sym_false] = ACTIONS(131),
    [aux_sym_number_token1] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_context] = ACTIONS(1065),
    [anon_sym_DOT_DOT] = ACTIONS(1067),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(1069),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(271),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(1071),
    [anon_sym_DASH] = ACTIONS(1071),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(1073),
    [anon_sym_set] = ACTIONS(1075),
    [anon_sym_import] = ACTIONS(1077),
    [anon_sym_COLON2] = ACTIONS(17),
    [anon_sym_include] = ACTIONS(1079),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_show] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(1083),
    [anon_sym_break] = ACTIONS(163),
    [anon_sym_continue] = ACTIONS(163),
    [sym_auto] = ACTIONS(1085),
    [sym_none] = ACTIONS(1085),
    [sym__token_content] = ACTIONS(167),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [43] = {
    [sym_raw_blck] = STATE(2922),
    [sym_raw_span] = STATE(2922),
    [sym_math] = STATE(2922),
    [sym__expr] = STATE(2922),
    [sym_ident] = STATE(2922),
    [sym_bool] = STATE(2922),
    [sym_number] = STATE(2922),
    [sym_string] = STATE(2922),
    [sym_tagged] = STATE(2922),
    [sym_context] = STATE(2922),
    [sym_elude] = STATE(2922),
    [sym_assign] = STATE(2922),
    [sym_lambda] = STATE(2922),
    [sym_or] = STATE(2922),
    [sym_not] = STATE(2922),
    [sym_and] = STATE(2922),
    [sym_cmp] = STATE(2922),
    [sym_in] = STATE(2922),
    [sym_add] = STATE(2922),
    [sym_sub] = STATE(2922),
    [sym_mul] = STATE(2922),
    [sym_div] = STATE(2922),
    [sym_sign] = STATE(2922),
    [sym_call] = STATE(2922),
    [sym_field] = STATE(2922),
    [sym_label] = STATE(2922),
    [sym_content] = STATE(2922),
    [sym_group] = STATE(2922),
    [sym_block] = STATE(2922),
    [sym_branch] = STATE(2922),
    [sym_let] = STATE(2922),
    [sym_set] = STATE(2922),
    [sym_import] = STATE(2922),
    [sym_include] = STATE(2922),
    [sym_for] = STATE(2922),
    [sym_while] = STATE(2922),
    [sym_show] = STATE(2922),
    [sym_return] = STATE(2922),
    [sym_flow] = STATE(2922),
    [sym__identifier] = ACTIONS(123),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(63),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [anon_sym_true] = ACTIONS(131),
    [anon_sym_false] = ACTIONS(131),
    [aux_sym_number_token1] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_context] = ACTIONS(1065),
    [anon_sym_DOT_DOT] = ACTIONS(1067),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_let] = ACTIONS(1073),
    [anon_sym_set] = ACTIONS(1075),
    [anon_sym_import] = ACTIONS(1077),
    [anon_sym_COLON2] = ACTIONS(65),
    [anon_sym_include] = ACTIONS(1079),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_show] = ACTIONS(1081),
    [anon_sym_return] = ACTIONS(1083),
    [anon_sym_break] = ACTIONS(163),
    [anon_sym_continue] = ACTIONS(163),
    [sym_auto] = ACTIONS(1087),
    [sym_none] = ACTIONS(1087),
    [sym__token_content] = ACTIONS(167),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [44] = {
    [sym_raw_blck] = STATE(2684),
    [sym_raw_span] = STATE(2684),
    [sym_math] = STATE(2684),
    [sym__expr] = STATE(2684),
    [sym_ident] = STATE(2684),
    [sym_bool] = STATE(2684),
    [sym_number] = STATE(2684),
    [sym_string] = STATE(2684),
    [sym_tagged] = STATE(2684),
    [sym_context] = STATE(2684),
    [sym_elude] = STATE(2684),
    [sym_assign] = STATE(2684),
    [sym_lambda] = STATE(2684),
    [sym_or] = STATE(2684),
    [sym_not] = STATE(2684),
    [sym_and] = STATE(2684),
    [sym_cmp] = STATE(2684),
    [sym_in] = STATE(2684),
    [sym_add] = STATE(2684),
    [sym_sub] = STATE(2684),
    [sym_mul] = STATE(2684),
    [sym_div] = STATE(2684),
    [sym_sign] = STATE(2684),
    [sym_call] = STATE(2684),
    [sym_field] = STATE(2684),
    [sym_label] = STATE(2684),
    [sym_content] = STATE(2684),
    [sym_group] = STATE(2684),
    [sym_block] = STATE(2684),
    [sym_branch] = STATE(2684),
    [sym_let] = STATE(2684),
    [sym_set] = STATE(2684),
    [sym_import] = STATE(2684),
    [sym_include] = STATE(2684),
    [sym_for] = STATE(2684),
    [sym_while] = STATE(2684),
    [sym_show] = STATE(2684),
    [sym_return] = STATE(2684),
    [sym_flow] = STATE(2684),
    [sym__identifier] = ACTIONS(1089),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1091),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [anon_sym_true] = ACTIONS(1097),
    [anon_sym_false] = ACTIONS(1097),
    [aux_sym_number_token1] = ACTIONS(1099),
    [anon_sym_DQUOTE] = ACTIONS(1101),
    [anon_sym_context] = ACTIONS(1103),
    [anon_sym_DOT_DOT] = ACTIONS(1105),
    [aux_sym_assign_token1] = ACTIONS(9),
    [anon_sym_EQ_GT] = ACTIONS(17),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_not] = ACTIONS(1107),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(1109),
    [anon_sym_GT] = ACTIONS(9),
    [anon_sym_LT_EQ] = ACTIONS(17),
    [anon_sym_GT_EQ] = ACTIONS(17),
    [anon_sym_EQ_EQ] = ACTIONS(17),
    [anon_sym_BANG_EQ] = ACTIONS(17),
    [anon_sym_in] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(1111),
    [anon_sym_DASH] = ACTIONS(1111),
    [anon_sym_STAR] = ACTIONS(9),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_if] = ACTIONS(1117),
    [anon_sym_let] = ACTIONS(1119),
    [anon_sym_set] = ACTIONS(1121),
    [anon_sym_import] = ACTIONS(1123),
    [anon_sym_include] = ACTIONS(1125),
    [anon_sym_for] = ACTIONS(1127),
    [anon_sym_while] = ACTIONS(1129),
    [anon_sym_show] = ACTIONS(1131),
    [anon_sym_return] = ACTIONS(1133),
    [anon_sym_break] = ACTIONS(1135),
    [anon_sym_continue] = ACTIONS(1135),
    [sym_auto] = ACTIONS(1137),
    [sym_none] = ACTIONS(1137),
    [sym__token_content] = ACTIONS(1139),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(17),
    [sym__immediate_brack] = ACTIONS(17),
  },
  [45] = {
    [sym_raw_blck] = STATE(2522),
    [sym_raw_span] = STATE(2522),
    [sym_math] = STATE(2522),
    [sym__expr] = STATE(2522),
    [sym_ident] = STATE(2522),
    [sym_bool] = STATE(2522),
    [sym_number] = STATE(2522),
    [sym_string] = STATE(2522),
    [sym_tagged] = STATE(2522),
    [sym_context] = STATE(2522),
    [sym_elude] = STATE(2522),
    [sym_assign] = STATE(2522),
    [sym_lambda] = STATE(2522),
    [sym_or] = STATE(2522),
    [sym_not] = STATE(2522),
    [sym_and] = STATE(2522),
    [sym_cmp] = STATE(2522),
    [sym_in] = STATE(2522),
    [sym_add] = STATE(2522),
    [sym_sub] = STATE(2522),
    [sym_mul] = STATE(2522),
    [sym_div] = STATE(2522),
    [sym_sign] = STATE(2522),
    [sym_call] = STATE(2522),
    [sym_field] = STATE(2522),
    [sym_label] = STATE(2522),
    [sym_content] = STATE(2522),
    [sym_group] = STATE(2522),
    [sym_block] = STATE(2522),
    [sym_branch] = STATE(2522),
    [sym_let] = STATE(2522),
    [sym_set] = STATE(2522),
    [sym_import] = STATE(2522),
    [sym_include] = STATE(2522),
    [sym_for] = STATE(2522),
    [sym_while] = STATE(2522),
    [sym_show] = STATE(2522),
    [sym_return] = STATE(2522),
    [sym_flow] = STATE(2522),
    [sym__identifier] = ACTIONS(1089),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1091),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [anon_sym_true] = ACTIONS(1097),
    [anon_sym_false] = ACTIONS(1097),
    [aux_sym_number_token1] = ACTIONS(1099),
    [anon_sym_DQUOTE] = ACTIONS(1101),
    [anon_sym_context] = ACTIONS(1103),
    [anon_sym_DOT_DOT] = ACTIONS(1105),
    [aux_sym_assign_token1] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_or] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_and] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_in] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_STAR] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(63),
    [anon_sym_DOT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(1117),
    [anon_sym_let] = ACTIONS(1119),
    [anon_sym_set] = ACTIONS(1121),
    [anon_sym_import] = ACTIONS(1123),
    [anon_sym_include] = ACTIONS(1125),
    [anon_sym_for] = ACTIONS(1127),
    [anon_sym_while] = ACTIONS(1129),
    [anon_sym_show] = ACTIONS(1131),
    [anon_sym_return] = ACTIONS(1133),
    [anon_sym_break] = ACTIONS(1135),
    [anon_sym_continue] = ACTIONS(1135),
    [sym_auto] = ACTIONS(1141),
    [sym_none] = ACTIONS(1141),
    [sym__token_content] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(65),
    [sym__immediate_brack] = ACTIONS(65),
  },
  [46] = {
    [sym_raw_blck] = STATE(2487),
    [sym_raw_span] = STATE(2487),
    [sym_math] = STATE(2487),
    [sym__expr] = STATE(2487),
    [sym_ident] = STATE(2487),
    [sym_bool] = STATE(2487),
    [sym_number] = STATE(2487),
    [sym_string] = STATE(2487),
    [sym_tagged] = STATE(2487),
    [sym_context] = STATE(2487),
    [sym_elude] = STATE(2487),
    [sym_assign] = STATE(2487),
    [sym_lambda] = STATE(2487),
    [sym_or] = STATE(2487),
    [sym_not] = STATE(2487),
    [sym_and] = STATE(2487),
    [sym_cmp] = STATE(2487),
    [sym_in] = STATE(2487),
    [sym_add] = STATE(2487),
    [sym_sub] = STATE(2487),
    [sym_mul] = STATE(2487),
    [sym_div] = STATE(2487),
    [sym_sign] = STATE(2487),
    [sym_call] = STATE(2487),
    [sym_field] = STATE(2487),
    [sym_label] = STATE(2487),
    [sym_content] = STATE(2487),
    [sym_group] = STATE(2487),
    [sym_block] = STATE(2487),
    [sym_branch] = STATE(2487),
    [sym_let] = STATE(2487),
    [sym_set] = STATE(2487),
    [sym_import] = STATE(2487),
    [sym_include] = STATE(2487),
    [sym_for] = STATE(2487),
    [sym_while] = STATE(2487),
    [sym_show] = STATE(2487),
    [sym_return] = STATE(2487),
    [sym_flow] = STATE(2487),
    [aux_sym_group_repeat1] = STATE(170),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1143),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1149),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1151),
    [sym_none] = ACTIONS(1151),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [47] = {
    [sym_raw_blck] = STATE(2577),
    [sym_raw_span] = STATE(2577),
    [sym_math] = STATE(2577),
    [sym__expr] = STATE(2577),
    [sym_ident] = STATE(2577),
    [sym_bool] = STATE(2577),
    [sym_number] = STATE(2577),
    [sym_string] = STATE(2577),
    [sym_tagged] = STATE(2577),
    [sym_context] = STATE(2577),
    [sym_elude] = STATE(2577),
    [sym_assign] = STATE(2577),
    [sym_lambda] = STATE(2577),
    [sym_or] = STATE(2577),
    [sym_not] = STATE(2577),
    [sym_and] = STATE(2577),
    [sym_cmp] = STATE(2577),
    [sym_in] = STATE(2577),
    [sym_add] = STATE(2577),
    [sym_sub] = STATE(2577),
    [sym_mul] = STATE(2577),
    [sym_div] = STATE(2577),
    [sym_sign] = STATE(2577),
    [sym_call] = STATE(2577),
    [sym_field] = STATE(2577),
    [sym_label] = STATE(2577),
    [sym_content] = STATE(2577),
    [sym_group] = STATE(2577),
    [sym_block] = STATE(2577),
    [sym_branch] = STATE(2577),
    [sym_let] = STATE(2577),
    [sym_set] = STATE(2577),
    [sym_import] = STATE(2577),
    [sym_include] = STATE(2577),
    [sym_for] = STATE(2577),
    [sym_while] = STATE(2577),
    [sym_show] = STATE(2577),
    [sym_return] = STATE(2577),
    [sym_flow] = STATE(2577),
    [aux_sym_group_repeat1] = STATE(151),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1153),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1155),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1157),
    [sym_none] = ACTIONS(1157),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [48] = {
    [sym_raw_blck] = STATE(2784),
    [sym_raw_span] = STATE(2784),
    [sym_math] = STATE(2784),
    [sym__expr] = STATE(2784),
    [sym_ident] = STATE(2784),
    [sym_bool] = STATE(2784),
    [sym_number] = STATE(2784),
    [sym_string] = STATE(2784),
    [sym_tagged] = STATE(2784),
    [sym_context] = STATE(2784),
    [sym_elude] = STATE(2784),
    [sym_assign] = STATE(2784),
    [sym_lambda] = STATE(2784),
    [sym_or] = STATE(2784),
    [sym_not] = STATE(2784),
    [sym_and] = STATE(2784),
    [sym_cmp] = STATE(2784),
    [sym_in] = STATE(2784),
    [sym_add] = STATE(2784),
    [sym_sub] = STATE(2784),
    [sym_mul] = STATE(2784),
    [sym_div] = STATE(2784),
    [sym_sign] = STATE(2784),
    [sym_call] = STATE(2784),
    [sym_field] = STATE(2784),
    [sym_label] = STATE(2784),
    [sym_content] = STATE(2784),
    [sym_group] = STATE(2784),
    [sym_block] = STATE(2784),
    [sym_branch] = STATE(2784),
    [sym_let] = STATE(2784),
    [sym_set] = STATE(2784),
    [sym_import] = STATE(2784),
    [sym_include] = STATE(2784),
    [sym_for] = STATE(2784),
    [sym_while] = STATE(2784),
    [sym_show] = STATE(2784),
    [sym_return] = STATE(2784),
    [sym_flow] = STATE(2784),
    [aux_sym_group_repeat1] = STATE(116),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1159),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1161),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1163),
    [sym_none] = ACTIONS(1163),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [49] = {
    [sym_raw_blck] = STATE(2688),
    [sym_raw_span] = STATE(2688),
    [sym_math] = STATE(2688),
    [sym__expr] = STATE(2688),
    [sym_ident] = STATE(2688),
    [sym_bool] = STATE(2688),
    [sym_number] = STATE(2688),
    [sym_string] = STATE(2688),
    [sym_tagged] = STATE(2688),
    [sym_context] = STATE(2688),
    [sym_elude] = STATE(2688),
    [sym_assign] = STATE(2688),
    [sym_lambda] = STATE(2688),
    [sym_or] = STATE(2688),
    [sym_not] = STATE(2688),
    [sym_and] = STATE(2688),
    [sym_cmp] = STATE(2688),
    [sym_in] = STATE(2688),
    [sym_add] = STATE(2688),
    [sym_sub] = STATE(2688),
    [sym_mul] = STATE(2688),
    [sym_div] = STATE(2688),
    [sym_sign] = STATE(2688),
    [sym_call] = STATE(2688),
    [sym_field] = STATE(2688),
    [sym_label] = STATE(2688),
    [sym_content] = STATE(2688),
    [sym_group] = STATE(2688),
    [sym_block] = STATE(2688),
    [sym_branch] = STATE(2688),
    [sym_let] = STATE(2688),
    [sym_set] = STATE(2688),
    [sym_import] = STATE(2688),
    [sym_include] = STATE(2688),
    [sym_for] = STATE(2688),
    [sym_while] = STATE(2688),
    [sym_show] = STATE(2688),
    [sym_return] = STATE(2688),
    [sym_flow] = STATE(2688),
    [aux_sym_group_repeat1] = STATE(214),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1165),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1167),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1169),
    [sym_none] = ACTIONS(1169),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [50] = {
    [sym_raw_blck] = STATE(2639),
    [sym_raw_span] = STATE(2639),
    [sym_math] = STATE(2639),
    [sym__expr] = STATE(2639),
    [sym_ident] = STATE(2639),
    [sym_bool] = STATE(2639),
    [sym_number] = STATE(2639),
    [sym_string] = STATE(2639),
    [sym_tagged] = STATE(2639),
    [sym_context] = STATE(2639),
    [sym_elude] = STATE(2639),
    [sym_assign] = STATE(2639),
    [sym_lambda] = STATE(2639),
    [sym_or] = STATE(2639),
    [sym_not] = STATE(2639),
    [sym_and] = STATE(2639),
    [sym_cmp] = STATE(2639),
    [sym_in] = STATE(2639),
    [sym_add] = STATE(2639),
    [sym_sub] = STATE(2639),
    [sym_mul] = STATE(2639),
    [sym_div] = STATE(2639),
    [sym_sign] = STATE(2639),
    [sym_call] = STATE(2639),
    [sym_field] = STATE(2639),
    [sym_label] = STATE(2639),
    [sym_content] = STATE(2639),
    [sym_group] = STATE(2639),
    [sym_block] = STATE(2639),
    [sym_branch] = STATE(2639),
    [sym_let] = STATE(2639),
    [sym_set] = STATE(2639),
    [sym_import] = STATE(2639),
    [sym_include] = STATE(2639),
    [sym_for] = STATE(2639),
    [sym_while] = STATE(2639),
    [sym_show] = STATE(2639),
    [sym_return] = STATE(2639),
    [sym_flow] = STATE(2639),
    [aux_sym_group_repeat1] = STATE(142),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1171),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1173),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1175),
    [sym_none] = ACTIONS(1175),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [51] = {
    [sym_raw_blck] = STATE(2716),
    [sym_raw_span] = STATE(2716),
    [sym_math] = STATE(2716),
    [sym__expr] = STATE(2716),
    [sym_ident] = STATE(2716),
    [sym_bool] = STATE(2716),
    [sym_number] = STATE(2716),
    [sym_string] = STATE(2716),
    [sym_tagged] = STATE(2716),
    [sym_context] = STATE(2716),
    [sym_elude] = STATE(2716),
    [sym_assign] = STATE(2716),
    [sym_lambda] = STATE(2716),
    [sym_or] = STATE(2716),
    [sym_not] = STATE(2716),
    [sym_and] = STATE(2716),
    [sym_cmp] = STATE(2716),
    [sym_in] = STATE(2716),
    [sym_add] = STATE(2716),
    [sym_sub] = STATE(2716),
    [sym_mul] = STATE(2716),
    [sym_div] = STATE(2716),
    [sym_sign] = STATE(2716),
    [sym_call] = STATE(2716),
    [sym_field] = STATE(2716),
    [sym_label] = STATE(2716),
    [sym_content] = STATE(2716),
    [sym_group] = STATE(2716),
    [sym_block] = STATE(2716),
    [sym_branch] = STATE(2716),
    [sym_let] = STATE(2716),
    [sym_set] = STATE(2716),
    [sym_import] = STATE(2716),
    [sym_include] = STATE(2716),
    [sym_for] = STATE(2716),
    [sym_while] = STATE(2716),
    [sym_show] = STATE(2716),
    [sym_return] = STATE(2716),
    [sym_flow] = STATE(2716),
    [aux_sym_group_repeat1] = STATE(219),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1177),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1179),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1181),
    [sym_none] = ACTIONS(1181),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [52] = {
    [sym_raw_blck] = STATE(2596),
    [sym_raw_span] = STATE(2596),
    [sym_math] = STATE(2596),
    [sym__expr] = STATE(2596),
    [sym_ident] = STATE(2596),
    [sym_bool] = STATE(2596),
    [sym_number] = STATE(2596),
    [sym_string] = STATE(2596),
    [sym_tagged] = STATE(2596),
    [sym_context] = STATE(2596),
    [sym_elude] = STATE(2596),
    [sym_assign] = STATE(2596),
    [sym_lambda] = STATE(2596),
    [sym_or] = STATE(2596),
    [sym_not] = STATE(2596),
    [sym_and] = STATE(2596),
    [sym_cmp] = STATE(2596),
    [sym_in] = STATE(2596),
    [sym_add] = STATE(2596),
    [sym_sub] = STATE(2596),
    [sym_mul] = STATE(2596),
    [sym_div] = STATE(2596),
    [sym_sign] = STATE(2596),
    [sym_call] = STATE(2596),
    [sym_field] = STATE(2596),
    [sym_label] = STATE(2596),
    [sym_content] = STATE(2596),
    [sym_group] = STATE(2596),
    [sym_block] = STATE(2596),
    [sym_branch] = STATE(2596),
    [sym_let] = STATE(2596),
    [sym_set] = STATE(2596),
    [sym_import] = STATE(2596),
    [sym_include] = STATE(2596),
    [sym_for] = STATE(2596),
    [sym_while] = STATE(2596),
    [sym_show] = STATE(2596),
    [sym_return] = STATE(2596),
    [sym_flow] = STATE(2596),
    [aux_sym_group_repeat1] = STATE(198),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1183),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1185),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1187),
    [sym_none] = ACTIONS(1187),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [53] = {
    [sym_raw_blck] = STATE(2534),
    [sym_raw_span] = STATE(2534),
    [sym_math] = STATE(2534),
    [sym__expr] = STATE(2534),
    [sym_ident] = STATE(2534),
    [sym_bool] = STATE(2534),
    [sym_number] = STATE(2534),
    [sym_string] = STATE(2534),
    [sym_tagged] = STATE(2534),
    [sym_context] = STATE(2534),
    [sym_elude] = STATE(2534),
    [sym_assign] = STATE(2534),
    [sym_lambda] = STATE(2534),
    [sym_or] = STATE(2534),
    [sym_not] = STATE(2534),
    [sym_and] = STATE(2534),
    [sym_cmp] = STATE(2534),
    [sym_in] = STATE(2534),
    [sym_add] = STATE(2534),
    [sym_sub] = STATE(2534),
    [sym_mul] = STATE(2534),
    [sym_div] = STATE(2534),
    [sym_sign] = STATE(2534),
    [sym_call] = STATE(2534),
    [sym_field] = STATE(2534),
    [sym_label] = STATE(2534),
    [sym_content] = STATE(2534),
    [sym_group] = STATE(2534),
    [sym_block] = STATE(2534),
    [sym_branch] = STATE(2534),
    [sym_let] = STATE(2534),
    [sym_set] = STATE(2534),
    [sym_import] = STATE(2534),
    [sym_include] = STATE(2534),
    [sym_for] = STATE(2534),
    [sym_while] = STATE(2534),
    [sym_show] = STATE(2534),
    [sym_return] = STATE(2534),
    [sym_flow] = STATE(2534),
    [aux_sym_group_repeat1] = STATE(157),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1189),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1191),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1193),
    [sym_none] = ACTIONS(1193),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [54] = {
    [sym_raw_blck] = STATE(2771),
    [sym_raw_span] = STATE(2771),
    [sym_math] = STATE(2771),
    [sym__expr] = STATE(2771),
    [sym_ident] = STATE(2771),
    [sym_bool] = STATE(2771),
    [sym_number] = STATE(2771),
    [sym_string] = STATE(2771),
    [sym_tagged] = STATE(2771),
    [sym_context] = STATE(2771),
    [sym_elude] = STATE(2771),
    [sym_assign] = STATE(2771),
    [sym_lambda] = STATE(2771),
    [sym_or] = STATE(2771),
    [sym_not] = STATE(2771),
    [sym_and] = STATE(2771),
    [sym_cmp] = STATE(2771),
    [sym_in] = STATE(2771),
    [sym_add] = STATE(2771),
    [sym_sub] = STATE(2771),
    [sym_mul] = STATE(2771),
    [sym_div] = STATE(2771),
    [sym_sign] = STATE(2771),
    [sym_call] = STATE(2771),
    [sym_field] = STATE(2771),
    [sym_label] = STATE(2771),
    [sym_content] = STATE(2771),
    [sym_group] = STATE(2771),
    [sym_block] = STATE(2771),
    [sym_branch] = STATE(2771),
    [sym_let] = STATE(2771),
    [sym_set] = STATE(2771),
    [sym_import] = STATE(2771),
    [sym_include] = STATE(2771),
    [sym_for] = STATE(2771),
    [sym_while] = STATE(2771),
    [sym_show] = STATE(2771),
    [sym_return] = STATE(2771),
    [sym_flow] = STATE(2771),
    [aux_sym_group_repeat1] = STATE(174),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1195),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1197),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1199),
    [sym_none] = ACTIONS(1199),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [55] = {
    [sym_raw_blck] = STATE(2770),
    [sym_raw_span] = STATE(2770),
    [sym_math] = STATE(2770),
    [sym__expr] = STATE(2770),
    [sym_ident] = STATE(2770),
    [sym_bool] = STATE(2770),
    [sym_number] = STATE(2770),
    [sym_string] = STATE(2770),
    [sym_tagged] = STATE(2770),
    [sym_context] = STATE(2770),
    [sym_elude] = STATE(2770),
    [sym_assign] = STATE(2770),
    [sym_lambda] = STATE(2770),
    [sym_or] = STATE(2770),
    [sym_not] = STATE(2770),
    [sym_and] = STATE(2770),
    [sym_cmp] = STATE(2770),
    [sym_in] = STATE(2770),
    [sym_add] = STATE(2770),
    [sym_sub] = STATE(2770),
    [sym_mul] = STATE(2770),
    [sym_div] = STATE(2770),
    [sym_sign] = STATE(2770),
    [sym_call] = STATE(2770),
    [sym_field] = STATE(2770),
    [sym_label] = STATE(2770),
    [sym_content] = STATE(2770),
    [sym_group] = STATE(2770),
    [sym_block] = STATE(2770),
    [sym_branch] = STATE(2770),
    [sym_let] = STATE(2770),
    [sym_set] = STATE(2770),
    [sym_import] = STATE(2770),
    [sym_include] = STATE(2770),
    [sym_for] = STATE(2770),
    [sym_while] = STATE(2770),
    [sym_show] = STATE(2770),
    [sym_return] = STATE(2770),
    [sym_flow] = STATE(2770),
    [aux_sym_group_repeat1] = STATE(147),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1201),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1203),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1205),
    [sym_none] = ACTIONS(1205),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [56] = {
    [sym_raw_blck] = STATE(2477),
    [sym_raw_span] = STATE(2477),
    [sym_math] = STATE(2477),
    [sym__expr] = STATE(2477),
    [sym_ident] = STATE(2477),
    [sym_bool] = STATE(2477),
    [sym_number] = STATE(2477),
    [sym_string] = STATE(2477),
    [sym_tagged] = STATE(2477),
    [sym_context] = STATE(2477),
    [sym_elude] = STATE(2477),
    [sym_assign] = STATE(2477),
    [sym_lambda] = STATE(2477),
    [sym_or] = STATE(2477),
    [sym_not] = STATE(2477),
    [sym_and] = STATE(2477),
    [sym_cmp] = STATE(2477),
    [sym_in] = STATE(2477),
    [sym_add] = STATE(2477),
    [sym_sub] = STATE(2477),
    [sym_mul] = STATE(2477),
    [sym_div] = STATE(2477),
    [sym_sign] = STATE(2477),
    [sym_call] = STATE(2477),
    [sym_field] = STATE(2477),
    [sym_label] = STATE(2477),
    [sym_content] = STATE(2477),
    [sym_group] = STATE(2477),
    [sym_block] = STATE(2477),
    [sym_branch] = STATE(2477),
    [sym_let] = STATE(2477),
    [sym_set] = STATE(2477),
    [sym_import] = STATE(2477),
    [sym_include] = STATE(2477),
    [sym_for] = STATE(2477),
    [sym_while] = STATE(2477),
    [sym_show] = STATE(2477),
    [sym_return] = STATE(2477),
    [sym_flow] = STATE(2477),
    [aux_sym_group_repeat1] = STATE(164),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1207),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1209),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1211),
    [sym_none] = ACTIONS(1211),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [57] = {
    [sym_raw_blck] = STATE(2458),
    [sym_raw_span] = STATE(2458),
    [sym_math] = STATE(2458),
    [sym__expr] = STATE(2458),
    [sym_ident] = STATE(2458),
    [sym_bool] = STATE(2458),
    [sym_number] = STATE(2458),
    [sym_string] = STATE(2458),
    [sym_tagged] = STATE(2458),
    [sym_context] = STATE(2458),
    [sym_elude] = STATE(2458),
    [sym_assign] = STATE(2458),
    [sym_lambda] = STATE(2458),
    [sym_or] = STATE(2458),
    [sym_not] = STATE(2458),
    [sym_and] = STATE(2458),
    [sym_cmp] = STATE(2458),
    [sym_in] = STATE(2458),
    [sym_add] = STATE(2458),
    [sym_sub] = STATE(2458),
    [sym_mul] = STATE(2458),
    [sym_div] = STATE(2458),
    [sym_sign] = STATE(2458),
    [sym_call] = STATE(2458),
    [sym_field] = STATE(2458),
    [sym_label] = STATE(2458),
    [sym_content] = STATE(2458),
    [sym_group] = STATE(2458),
    [sym_block] = STATE(2458),
    [sym_branch] = STATE(2458),
    [sym_let] = STATE(2458),
    [sym_set] = STATE(2458),
    [sym_import] = STATE(2458),
    [sym_include] = STATE(2458),
    [sym_for] = STATE(2458),
    [sym_while] = STATE(2458),
    [sym_show] = STATE(2458),
    [sym_return] = STATE(2458),
    [sym_flow] = STATE(2458),
    [aux_sym_group_repeat1] = STATE(77),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1213),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1215),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1217),
    [sym_none] = ACTIONS(1217),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [58] = {
    [sym_raw_blck] = STATE(2682),
    [sym_raw_span] = STATE(2682),
    [sym_math] = STATE(2682),
    [sym__expr] = STATE(2682),
    [sym_ident] = STATE(2682),
    [sym_bool] = STATE(2682),
    [sym_number] = STATE(2682),
    [sym_string] = STATE(2682),
    [sym_tagged] = STATE(2682),
    [sym_context] = STATE(2682),
    [sym_elude] = STATE(2682),
    [sym_assign] = STATE(2682),
    [sym_lambda] = STATE(2682),
    [sym_or] = STATE(2682),
    [sym_not] = STATE(2682),
    [sym_and] = STATE(2682),
    [sym_cmp] = STATE(2682),
    [sym_in] = STATE(2682),
    [sym_add] = STATE(2682),
    [sym_sub] = STATE(2682),
    [sym_mul] = STATE(2682),
    [sym_div] = STATE(2682),
    [sym_sign] = STATE(2682),
    [sym_call] = STATE(2682),
    [sym_field] = STATE(2682),
    [sym_label] = STATE(2682),
    [sym_content] = STATE(2682),
    [sym_group] = STATE(2682),
    [sym_block] = STATE(2682),
    [sym_branch] = STATE(2682),
    [sym_let] = STATE(2682),
    [sym_set] = STATE(2682),
    [sym_import] = STATE(2682),
    [sym_include] = STATE(2682),
    [sym_for] = STATE(2682),
    [sym_while] = STATE(2682),
    [sym_show] = STATE(2682),
    [sym_return] = STATE(2682),
    [sym_flow] = STATE(2682),
    [aux_sym_group_repeat1] = STATE(123),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1219),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1221),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1223),
    [sym_none] = ACTIONS(1223),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [59] = {
    [sym_raw_blck] = STATE(2646),
    [sym_raw_span] = STATE(2646),
    [sym_math] = STATE(2646),
    [sym__expr] = STATE(2646),
    [sym_ident] = STATE(2646),
    [sym_bool] = STATE(2646),
    [sym_number] = STATE(2646),
    [sym_string] = STATE(2646),
    [sym_tagged] = STATE(2646),
    [sym_context] = STATE(2646),
    [sym_elude] = STATE(2646),
    [sym_assign] = STATE(2646),
    [sym_lambda] = STATE(2646),
    [sym_or] = STATE(2646),
    [sym_not] = STATE(2646),
    [sym_and] = STATE(2646),
    [sym_cmp] = STATE(2646),
    [sym_in] = STATE(2646),
    [sym_add] = STATE(2646),
    [sym_sub] = STATE(2646),
    [sym_mul] = STATE(2646),
    [sym_div] = STATE(2646),
    [sym_sign] = STATE(2646),
    [sym_call] = STATE(2646),
    [sym_field] = STATE(2646),
    [sym_label] = STATE(2646),
    [sym_content] = STATE(2646),
    [sym_group] = STATE(2646),
    [sym_block] = STATE(2646),
    [sym_branch] = STATE(2646),
    [sym_let] = STATE(2646),
    [sym_set] = STATE(2646),
    [sym_import] = STATE(2646),
    [sym_include] = STATE(2646),
    [sym_for] = STATE(2646),
    [sym_while] = STATE(2646),
    [sym_show] = STATE(2646),
    [sym_return] = STATE(2646),
    [sym_flow] = STATE(2646),
    [aux_sym_group_repeat1] = STATE(209),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1225),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1227),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1229),
    [sym_none] = ACTIONS(1229),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [60] = {
    [sym_raw_blck] = STATE(2744),
    [sym_raw_span] = STATE(2744),
    [sym_math] = STATE(2744),
    [sym__expr] = STATE(2744),
    [sym_ident] = STATE(2744),
    [sym_bool] = STATE(2744),
    [sym_number] = STATE(2744),
    [sym_string] = STATE(2744),
    [sym_tagged] = STATE(2744),
    [sym_context] = STATE(2744),
    [sym_elude] = STATE(2744),
    [sym_assign] = STATE(2744),
    [sym_lambda] = STATE(2744),
    [sym_or] = STATE(2744),
    [sym_not] = STATE(2744),
    [sym_and] = STATE(2744),
    [sym_cmp] = STATE(2744),
    [sym_in] = STATE(2744),
    [sym_add] = STATE(2744),
    [sym_sub] = STATE(2744),
    [sym_mul] = STATE(2744),
    [sym_div] = STATE(2744),
    [sym_sign] = STATE(2744),
    [sym_call] = STATE(2744),
    [sym_field] = STATE(2744),
    [sym_label] = STATE(2744),
    [sym_content] = STATE(2744),
    [sym_group] = STATE(2744),
    [sym_block] = STATE(2744),
    [sym_branch] = STATE(2744),
    [sym_let] = STATE(2744),
    [sym_set] = STATE(2744),
    [sym_import] = STATE(2744),
    [sym_include] = STATE(2744),
    [sym_for] = STATE(2744),
    [sym_while] = STATE(2744),
    [sym_show] = STATE(2744),
    [sym_return] = STATE(2744),
    [sym_flow] = STATE(2744),
    [aux_sym_group_repeat1] = STATE(104),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1231),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1233),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1235),
    [sym_none] = ACTIONS(1235),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [61] = {
    [sym_raw_blck] = STATE(2509),
    [sym_raw_span] = STATE(2509),
    [sym_math] = STATE(2509),
    [sym__expr] = STATE(2509),
    [sym_ident] = STATE(2509),
    [sym_bool] = STATE(2509),
    [sym_number] = STATE(2509),
    [sym_string] = STATE(2509),
    [sym_tagged] = STATE(2509),
    [sym_context] = STATE(2509),
    [sym_elude] = STATE(2509),
    [sym_assign] = STATE(2509),
    [sym_lambda] = STATE(2509),
    [sym_or] = STATE(2509),
    [sym_not] = STATE(2509),
    [sym_and] = STATE(2509),
    [sym_cmp] = STATE(2509),
    [sym_in] = STATE(2509),
    [sym_add] = STATE(2509),
    [sym_sub] = STATE(2509),
    [sym_mul] = STATE(2509),
    [sym_div] = STATE(2509),
    [sym_sign] = STATE(2509),
    [sym_call] = STATE(2509),
    [sym_field] = STATE(2509),
    [sym_label] = STATE(2509),
    [sym_content] = STATE(2509),
    [sym_group] = STATE(2509),
    [sym_block] = STATE(2509),
    [sym_branch] = STATE(2509),
    [sym_let] = STATE(2509),
    [sym_set] = STATE(2509),
    [sym_import] = STATE(2509),
    [sym_include] = STATE(2509),
    [sym_for] = STATE(2509),
    [sym_while] = STATE(2509),
    [sym_show] = STATE(2509),
    [sym_return] = STATE(2509),
    [sym_flow] = STATE(2509),
    [aux_sym_group_repeat1] = STATE(178),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1237),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1239),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1241),
    [sym_none] = ACTIONS(1241),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [62] = {
    [sym_raw_blck] = STATE(2645),
    [sym_raw_span] = STATE(2645),
    [sym_math] = STATE(2645),
    [sym__expr] = STATE(2645),
    [sym_ident] = STATE(2645),
    [sym_bool] = STATE(2645),
    [sym_number] = STATE(2645),
    [sym_string] = STATE(2645),
    [sym_tagged] = STATE(2645),
    [sym_context] = STATE(2645),
    [sym_elude] = STATE(2645),
    [sym_assign] = STATE(2645),
    [sym_lambda] = STATE(2645),
    [sym_or] = STATE(2645),
    [sym_not] = STATE(2645),
    [sym_and] = STATE(2645),
    [sym_cmp] = STATE(2645),
    [sym_in] = STATE(2645),
    [sym_add] = STATE(2645),
    [sym_sub] = STATE(2645),
    [sym_mul] = STATE(2645),
    [sym_div] = STATE(2645),
    [sym_sign] = STATE(2645),
    [sym_call] = STATE(2645),
    [sym_field] = STATE(2645),
    [sym_label] = STATE(2645),
    [sym_content] = STATE(2645),
    [sym_group] = STATE(2645),
    [sym_block] = STATE(2645),
    [sym_branch] = STATE(2645),
    [sym_let] = STATE(2645),
    [sym_set] = STATE(2645),
    [sym_import] = STATE(2645),
    [sym_include] = STATE(2645),
    [sym_for] = STATE(2645),
    [sym_while] = STATE(2645),
    [sym_show] = STATE(2645),
    [sym_return] = STATE(2645),
    [sym_flow] = STATE(2645),
    [aux_sym_group_repeat1] = STATE(91),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1243),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1245),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1247),
    [sym_none] = ACTIONS(1247),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [63] = {
    [sym_raw_blck] = STATE(2743),
    [sym_raw_span] = STATE(2743),
    [sym_math] = STATE(2743),
    [sym__expr] = STATE(2743),
    [sym_ident] = STATE(2743),
    [sym_bool] = STATE(2743),
    [sym_number] = STATE(2743),
    [sym_string] = STATE(2743),
    [sym_tagged] = STATE(2743),
    [sym_context] = STATE(2743),
    [sym_elude] = STATE(2743),
    [sym_assign] = STATE(2743),
    [sym_lambda] = STATE(2743),
    [sym_or] = STATE(2743),
    [sym_not] = STATE(2743),
    [sym_and] = STATE(2743),
    [sym_cmp] = STATE(2743),
    [sym_in] = STATE(2743),
    [sym_add] = STATE(2743),
    [sym_sub] = STATE(2743),
    [sym_mul] = STATE(2743),
    [sym_div] = STATE(2743),
    [sym_sign] = STATE(2743),
    [sym_call] = STATE(2743),
    [sym_field] = STATE(2743),
    [sym_label] = STATE(2743),
    [sym_content] = STATE(2743),
    [sym_group] = STATE(2743),
    [sym_block] = STATE(2743),
    [sym_branch] = STATE(2743),
    [sym_let] = STATE(2743),
    [sym_set] = STATE(2743),
    [sym_import] = STATE(2743),
    [sym_include] = STATE(2743),
    [sym_for] = STATE(2743),
    [sym_while] = STATE(2743),
    [sym_show] = STATE(2743),
    [sym_return] = STATE(2743),
    [sym_flow] = STATE(2743),
    [aux_sym_group_repeat1] = STATE(69),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1249),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1251),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1253),
    [sym_none] = ACTIONS(1253),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [64] = {
    [sym_raw_blck] = STATE(2553),
    [sym_raw_span] = STATE(2553),
    [sym_math] = STATE(2553),
    [sym__expr] = STATE(2553),
    [sym_ident] = STATE(2553),
    [sym_bool] = STATE(2553),
    [sym_number] = STATE(2553),
    [sym_string] = STATE(2553),
    [sym_tagged] = STATE(2553),
    [sym_context] = STATE(2553),
    [sym_elude] = STATE(2553),
    [sym_assign] = STATE(2553),
    [sym_lambda] = STATE(2553),
    [sym_or] = STATE(2553),
    [sym_not] = STATE(2553),
    [sym_and] = STATE(2553),
    [sym_cmp] = STATE(2553),
    [sym_in] = STATE(2553),
    [sym_add] = STATE(2553),
    [sym_sub] = STATE(2553),
    [sym_mul] = STATE(2553),
    [sym_div] = STATE(2553),
    [sym_sign] = STATE(2553),
    [sym_call] = STATE(2553),
    [sym_field] = STATE(2553),
    [sym_label] = STATE(2553),
    [sym_content] = STATE(2553),
    [sym_group] = STATE(2553),
    [sym_block] = STATE(2553),
    [sym_branch] = STATE(2553),
    [sym_let] = STATE(2553),
    [sym_set] = STATE(2553),
    [sym_import] = STATE(2553),
    [sym_include] = STATE(2553),
    [sym_for] = STATE(2553),
    [sym_while] = STATE(2553),
    [sym_show] = STATE(2553),
    [sym_return] = STATE(2553),
    [sym_flow] = STATE(2553),
    [aux_sym_group_repeat1] = STATE(188),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1255),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1257),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1259),
    [sym_none] = ACTIONS(1259),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [65] = {
    [sym_raw_blck] = STATE(2683),
    [sym_raw_span] = STATE(2683),
    [sym_math] = STATE(2683),
    [sym__expr] = STATE(2683),
    [sym_ident] = STATE(2683),
    [sym_bool] = STATE(2683),
    [sym_number] = STATE(2683),
    [sym_string] = STATE(2683),
    [sym_tagged] = STATE(2683),
    [sym_context] = STATE(2683),
    [sym_elude] = STATE(2683),
    [sym_assign] = STATE(2683),
    [sym_lambda] = STATE(2683),
    [sym_or] = STATE(2683),
    [sym_not] = STATE(2683),
    [sym_and] = STATE(2683),
    [sym_cmp] = STATE(2683),
    [sym_in] = STATE(2683),
    [sym_add] = STATE(2683),
    [sym_sub] = STATE(2683),
    [sym_mul] = STATE(2683),
    [sym_div] = STATE(2683),
    [sym_sign] = STATE(2683),
    [sym_call] = STATE(2683),
    [sym_field] = STATE(2683),
    [sym_label] = STATE(2683),
    [sym_content] = STATE(2683),
    [sym_group] = STATE(2683),
    [sym_block] = STATE(2683),
    [sym_branch] = STATE(2683),
    [sym_let] = STATE(2683),
    [sym_set] = STATE(2683),
    [sym_import] = STATE(2683),
    [sym_include] = STATE(2683),
    [sym_for] = STATE(2683),
    [sym_while] = STATE(2683),
    [sym_show] = STATE(2683),
    [sym_return] = STATE(2683),
    [sym_flow] = STATE(2683),
    [aux_sym_group_repeat1] = STATE(97),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1261),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1263),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1265),
    [sym_none] = ACTIONS(1265),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [66] = {
    [sym_raw_blck] = STATE(2681),
    [sym_raw_span] = STATE(2681),
    [sym_math] = STATE(2681),
    [sym__expr] = STATE(2681),
    [sym_ident] = STATE(2681),
    [sym_bool] = STATE(2681),
    [sym_number] = STATE(2681),
    [sym_string] = STATE(2681),
    [sym_tagged] = STATE(2681),
    [sym_context] = STATE(2681),
    [sym_elude] = STATE(2681),
    [sym_assign] = STATE(2681),
    [sym_lambda] = STATE(2681),
    [sym_or] = STATE(2681),
    [sym_not] = STATE(2681),
    [sym_and] = STATE(2681),
    [sym_cmp] = STATE(2681),
    [sym_in] = STATE(2681),
    [sym_add] = STATE(2681),
    [sym_sub] = STATE(2681),
    [sym_mul] = STATE(2681),
    [sym_div] = STATE(2681),
    [sym_sign] = STATE(2681),
    [sym_call] = STATE(2681),
    [sym_field] = STATE(2681),
    [sym_label] = STATE(2681),
    [sym_content] = STATE(2681),
    [sym_group] = STATE(2681),
    [sym_block] = STATE(2681),
    [sym_branch] = STATE(2681),
    [sym_let] = STATE(2681),
    [sym_set] = STATE(2681),
    [sym_import] = STATE(2681),
    [sym_include] = STATE(2681),
    [sym_for] = STATE(2681),
    [sym_while] = STATE(2681),
    [sym_show] = STATE(2681),
    [sym_return] = STATE(2681),
    [sym_flow] = STATE(2681),
    [aux_sym_group_repeat1] = STATE(132),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_COLON] = ACTIONS(1267),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1269),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1271),
    [sym_none] = ACTIONS(1271),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [67] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(118),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1277),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [68] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(158),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1281),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [69] = {
    [sym_raw_blck] = STATE(2736),
    [sym_raw_span] = STATE(2736),
    [sym_math] = STATE(2736),
    [sym__expr] = STATE(2736),
    [sym_ident] = STATE(2736),
    [sym_bool] = STATE(2736),
    [sym_number] = STATE(2736),
    [sym_string] = STATE(2736),
    [sym_tagged] = STATE(2736),
    [sym_context] = STATE(2736),
    [sym_elude] = STATE(2736),
    [sym_assign] = STATE(2736),
    [sym_lambda] = STATE(2736),
    [sym_or] = STATE(2736),
    [sym_not] = STATE(2736),
    [sym_and] = STATE(2736),
    [sym_cmp] = STATE(2736),
    [sym_in] = STATE(2736),
    [sym_add] = STATE(2736),
    [sym_sub] = STATE(2736),
    [sym_mul] = STATE(2736),
    [sym_div] = STATE(2736),
    [sym_sign] = STATE(2736),
    [sym_call] = STATE(2736),
    [sym_field] = STATE(2736),
    [sym_label] = STATE(2736),
    [sym_content] = STATE(2736),
    [sym_group] = STATE(2736),
    [sym_block] = STATE(2736),
    [sym_branch] = STATE(2736),
    [sym_let] = STATE(2736),
    [sym_set] = STATE(2736),
    [sym_import] = STATE(2736),
    [sym_include] = STATE(2736),
    [sym_for] = STATE(2736),
    [sym_while] = STATE(2736),
    [sym_show] = STATE(2736),
    [sym_return] = STATE(2736),
    [sym_flow] = STATE(2736),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1283),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1285),
    [sym_none] = ACTIONS(1285),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [70] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1287),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [71] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1289),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [72] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(4207),
    [sym__stmt] = STATE(4202),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [73] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(71),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1295),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [74] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(78),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1297),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [75] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1299),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [76] = {
    [sym_raw_blck] = STATE(2467),
    [sym_raw_span] = STATE(2467),
    [sym_math] = STATE(2467),
    [sym__expr] = STATE(2467),
    [sym_ident] = STATE(2467),
    [sym_bool] = STATE(2467),
    [sym_number] = STATE(2467),
    [sym_string] = STATE(2467),
    [sym_tagged] = STATE(2467),
    [sym_context] = STATE(2467),
    [sym_elude] = STATE(2467),
    [sym_assign] = STATE(2467),
    [sym_lambda] = STATE(2467),
    [sym_or] = STATE(2467),
    [sym_not] = STATE(2467),
    [sym_and] = STATE(2467),
    [sym_cmp] = STATE(2467),
    [sym_in] = STATE(2467),
    [sym_add] = STATE(2467),
    [sym_sub] = STATE(2467),
    [sym_mul] = STATE(2467),
    [sym_div] = STATE(2467),
    [sym_sign] = STATE(2467),
    [sym_call] = STATE(2467),
    [sym_field] = STATE(2467),
    [sym_label] = STATE(2467),
    [sym_content] = STATE(2467),
    [sym_group] = STATE(2467),
    [sym_block] = STATE(2467),
    [sym_branch] = STATE(2467),
    [sym_let] = STATE(2467),
    [sym_set] = STATE(2467),
    [sym_import] = STATE(2467),
    [sym_include] = STATE(2467),
    [sym_for] = STATE(2467),
    [sym_while] = STATE(2467),
    [sym_show] = STATE(2467),
    [sym_return] = STATE(2467),
    [sym_flow] = STATE(2467),
    [aux_sym_group_repeat1] = STATE(79),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1301),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1303),
    [sym_none] = ACTIONS(1303),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [77] = {
    [sym_raw_blck] = STATE(2467),
    [sym_raw_span] = STATE(2467),
    [sym_math] = STATE(2467),
    [sym__expr] = STATE(2467),
    [sym_ident] = STATE(2467),
    [sym_bool] = STATE(2467),
    [sym_number] = STATE(2467),
    [sym_string] = STATE(2467),
    [sym_tagged] = STATE(2467),
    [sym_context] = STATE(2467),
    [sym_elude] = STATE(2467),
    [sym_assign] = STATE(2467),
    [sym_lambda] = STATE(2467),
    [sym_or] = STATE(2467),
    [sym_not] = STATE(2467),
    [sym_and] = STATE(2467),
    [sym_cmp] = STATE(2467),
    [sym_in] = STATE(2467),
    [sym_add] = STATE(2467),
    [sym_sub] = STATE(2467),
    [sym_mul] = STATE(2467),
    [sym_div] = STATE(2467),
    [sym_sign] = STATE(2467),
    [sym_call] = STATE(2467),
    [sym_field] = STATE(2467),
    [sym_label] = STATE(2467),
    [sym_content] = STATE(2467),
    [sym_group] = STATE(2467),
    [sym_block] = STATE(2467),
    [sym_branch] = STATE(2467),
    [sym_let] = STATE(2467),
    [sym_set] = STATE(2467),
    [sym_import] = STATE(2467),
    [sym_include] = STATE(2467),
    [sym_for] = STATE(2467),
    [sym_while] = STATE(2467),
    [sym_show] = STATE(2467),
    [sym_return] = STATE(2467),
    [sym_flow] = STATE(2467),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1301),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1303),
    [sym_none] = ACTIONS(1303),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [78] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1305),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [79] = {
    [sym_raw_blck] = STATE(2469),
    [sym_raw_span] = STATE(2469),
    [sym_math] = STATE(2469),
    [sym__expr] = STATE(2469),
    [sym_ident] = STATE(2469),
    [sym_bool] = STATE(2469),
    [sym_number] = STATE(2469),
    [sym_string] = STATE(2469),
    [sym_tagged] = STATE(2469),
    [sym_context] = STATE(2469),
    [sym_elude] = STATE(2469),
    [sym_assign] = STATE(2469),
    [sym_lambda] = STATE(2469),
    [sym_or] = STATE(2469),
    [sym_not] = STATE(2469),
    [sym_and] = STATE(2469),
    [sym_cmp] = STATE(2469),
    [sym_in] = STATE(2469),
    [sym_add] = STATE(2469),
    [sym_sub] = STATE(2469),
    [sym_mul] = STATE(2469),
    [sym_div] = STATE(2469),
    [sym_sign] = STATE(2469),
    [sym_call] = STATE(2469),
    [sym_field] = STATE(2469),
    [sym_label] = STATE(2469),
    [sym_content] = STATE(2469),
    [sym_group] = STATE(2469),
    [sym_block] = STATE(2469),
    [sym_branch] = STATE(2469),
    [sym_let] = STATE(2469),
    [sym_set] = STATE(2469),
    [sym_import] = STATE(2469),
    [sym_include] = STATE(2469),
    [sym_for] = STATE(2469),
    [sym_while] = STATE(2469),
    [sym_show] = STATE(2469),
    [sym_return] = STATE(2469),
    [sym_flow] = STATE(2469),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1307),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1309),
    [sym_none] = ACTIONS(1309),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [80] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(135),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1311),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [81] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(75),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1313),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [82] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(4078),
    [sym__stmt] = STATE(4077),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [83] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(70),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1315),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [84] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1317),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [85] = {
    [sym_raw_blck] = STATE(2765),
    [sym_raw_span] = STATE(2765),
    [sym_math] = STATE(2765),
    [sym__expr] = STATE(2765),
    [sym_ident] = STATE(2765),
    [sym_bool] = STATE(2765),
    [sym_number] = STATE(2765),
    [sym_string] = STATE(2765),
    [sym_tagged] = STATE(2765),
    [sym_context] = STATE(2765),
    [sym_elude] = STATE(2765),
    [sym_assign] = STATE(2765),
    [sym_lambda] = STATE(2765),
    [sym_or] = STATE(2765),
    [sym_not] = STATE(2765),
    [sym_and] = STATE(2765),
    [sym_cmp] = STATE(2765),
    [sym_in] = STATE(2765),
    [sym_add] = STATE(2765),
    [sym_sub] = STATE(2765),
    [sym_mul] = STATE(2765),
    [sym_div] = STATE(2765),
    [sym_sign] = STATE(2765),
    [sym_call] = STATE(2765),
    [sym_field] = STATE(2765),
    [sym_label] = STATE(2765),
    [sym_content] = STATE(2765),
    [sym_group] = STATE(2765),
    [sym_block] = STATE(2765),
    [sym_branch] = STATE(2765),
    [sym_let] = STATE(2765),
    [sym_set] = STATE(2765),
    [sym_import] = STATE(2765),
    [sym_include] = STATE(2765),
    [sym_for] = STATE(2765),
    [sym_while] = STATE(2765),
    [sym_show] = STATE(2765),
    [sym_return] = STATE(2765),
    [sym_flow] = STATE(2765),
    [aux_sym_group_repeat1] = STATE(139),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1319),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1321),
    [sym_none] = ACTIONS(1321),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [86] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(84),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1323),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [87] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(4015),
    [sym__stmt] = STATE(4080),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [88] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1325),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [89] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(92),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1327),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [90] = {
    [sym_raw_blck] = STATE(2660),
    [sym_raw_span] = STATE(2660),
    [sym_math] = STATE(2660),
    [sym__expr] = STATE(2660),
    [sym_ident] = STATE(2660),
    [sym_bool] = STATE(2660),
    [sym_number] = STATE(2660),
    [sym_string] = STATE(2660),
    [sym_tagged] = STATE(2660),
    [sym_context] = STATE(2660),
    [sym_elude] = STATE(2660),
    [sym_assign] = STATE(2660),
    [sym_lambda] = STATE(2660),
    [sym_or] = STATE(2660),
    [sym_not] = STATE(2660),
    [sym_and] = STATE(2660),
    [sym_cmp] = STATE(2660),
    [sym_in] = STATE(2660),
    [sym_add] = STATE(2660),
    [sym_sub] = STATE(2660),
    [sym_mul] = STATE(2660),
    [sym_div] = STATE(2660),
    [sym_sign] = STATE(2660),
    [sym_call] = STATE(2660),
    [sym_field] = STATE(2660),
    [sym_label] = STATE(2660),
    [sym_content] = STATE(2660),
    [sym_group] = STATE(2660),
    [sym_block] = STATE(2660),
    [sym_branch] = STATE(2660),
    [sym_let] = STATE(2660),
    [sym_set] = STATE(2660),
    [sym_import] = STATE(2660),
    [sym_include] = STATE(2660),
    [sym_for] = STATE(2660),
    [sym_while] = STATE(2660),
    [sym_show] = STATE(2660),
    [sym_return] = STATE(2660),
    [sym_flow] = STATE(2660),
    [aux_sym_group_repeat1] = STATE(93),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1329),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1331),
    [sym_none] = ACTIONS(1331),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [91] = {
    [sym_raw_blck] = STATE(2660),
    [sym_raw_span] = STATE(2660),
    [sym_math] = STATE(2660),
    [sym__expr] = STATE(2660),
    [sym_ident] = STATE(2660),
    [sym_bool] = STATE(2660),
    [sym_number] = STATE(2660),
    [sym_string] = STATE(2660),
    [sym_tagged] = STATE(2660),
    [sym_context] = STATE(2660),
    [sym_elude] = STATE(2660),
    [sym_assign] = STATE(2660),
    [sym_lambda] = STATE(2660),
    [sym_or] = STATE(2660),
    [sym_not] = STATE(2660),
    [sym_and] = STATE(2660),
    [sym_cmp] = STATE(2660),
    [sym_in] = STATE(2660),
    [sym_add] = STATE(2660),
    [sym_sub] = STATE(2660),
    [sym_mul] = STATE(2660),
    [sym_div] = STATE(2660),
    [sym_sign] = STATE(2660),
    [sym_call] = STATE(2660),
    [sym_field] = STATE(2660),
    [sym_label] = STATE(2660),
    [sym_content] = STATE(2660),
    [sym_group] = STATE(2660),
    [sym_block] = STATE(2660),
    [sym_branch] = STATE(2660),
    [sym_let] = STATE(2660),
    [sym_set] = STATE(2660),
    [sym_import] = STATE(2660),
    [sym_include] = STATE(2660),
    [sym_for] = STATE(2660),
    [sym_while] = STATE(2660),
    [sym_show] = STATE(2660),
    [sym_return] = STATE(2660),
    [sym_flow] = STATE(2660),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1329),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1331),
    [sym_none] = ACTIONS(1331),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [92] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1333),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [93] = {
    [sym_raw_blck] = STATE(2663),
    [sym_raw_span] = STATE(2663),
    [sym_math] = STATE(2663),
    [sym__expr] = STATE(2663),
    [sym_ident] = STATE(2663),
    [sym_bool] = STATE(2663),
    [sym_number] = STATE(2663),
    [sym_string] = STATE(2663),
    [sym_tagged] = STATE(2663),
    [sym_context] = STATE(2663),
    [sym_elude] = STATE(2663),
    [sym_assign] = STATE(2663),
    [sym_lambda] = STATE(2663),
    [sym_or] = STATE(2663),
    [sym_not] = STATE(2663),
    [sym_and] = STATE(2663),
    [sym_cmp] = STATE(2663),
    [sym_in] = STATE(2663),
    [sym_add] = STATE(2663),
    [sym_sub] = STATE(2663),
    [sym_mul] = STATE(2663),
    [sym_div] = STATE(2663),
    [sym_sign] = STATE(2663),
    [sym_call] = STATE(2663),
    [sym_field] = STATE(2663),
    [sym_label] = STATE(2663),
    [sym_content] = STATE(2663),
    [sym_group] = STATE(2663),
    [sym_block] = STATE(2663),
    [sym_branch] = STATE(2663),
    [sym_let] = STATE(2663),
    [sym_set] = STATE(2663),
    [sym_import] = STATE(2663),
    [sym_include] = STATE(2663),
    [sym_for] = STATE(2663),
    [sym_while] = STATE(2663),
    [sym_show] = STATE(2663),
    [sym_return] = STATE(2663),
    [sym_flow] = STATE(2663),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1335),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1337),
    [sym_none] = ACTIONS(1337),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [94] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(4036),
    [sym__stmt] = STATE(4033),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [95] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(98),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1339),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [96] = {
    [sym_raw_blck] = STATE(2691),
    [sym_raw_span] = STATE(2691),
    [sym_math] = STATE(2691),
    [sym__expr] = STATE(2691),
    [sym_ident] = STATE(2691),
    [sym_bool] = STATE(2691),
    [sym_number] = STATE(2691),
    [sym_string] = STATE(2691),
    [sym_tagged] = STATE(2691),
    [sym_context] = STATE(2691),
    [sym_elude] = STATE(2691),
    [sym_assign] = STATE(2691),
    [sym_lambda] = STATE(2691),
    [sym_or] = STATE(2691),
    [sym_not] = STATE(2691),
    [sym_and] = STATE(2691),
    [sym_cmp] = STATE(2691),
    [sym_in] = STATE(2691),
    [sym_add] = STATE(2691),
    [sym_sub] = STATE(2691),
    [sym_mul] = STATE(2691),
    [sym_div] = STATE(2691),
    [sym_sign] = STATE(2691),
    [sym_call] = STATE(2691),
    [sym_field] = STATE(2691),
    [sym_label] = STATE(2691),
    [sym_content] = STATE(2691),
    [sym_group] = STATE(2691),
    [sym_block] = STATE(2691),
    [sym_branch] = STATE(2691),
    [sym_let] = STATE(2691),
    [sym_set] = STATE(2691),
    [sym_import] = STATE(2691),
    [sym_include] = STATE(2691),
    [sym_for] = STATE(2691),
    [sym_while] = STATE(2691),
    [sym_show] = STATE(2691),
    [sym_return] = STATE(2691),
    [sym_flow] = STATE(2691),
    [aux_sym_group_repeat1] = STATE(99),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1341),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1343),
    [sym_none] = ACTIONS(1343),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [97] = {
    [sym_raw_blck] = STATE(2691),
    [sym_raw_span] = STATE(2691),
    [sym_math] = STATE(2691),
    [sym__expr] = STATE(2691),
    [sym_ident] = STATE(2691),
    [sym_bool] = STATE(2691),
    [sym_number] = STATE(2691),
    [sym_string] = STATE(2691),
    [sym_tagged] = STATE(2691),
    [sym_context] = STATE(2691),
    [sym_elude] = STATE(2691),
    [sym_assign] = STATE(2691),
    [sym_lambda] = STATE(2691),
    [sym_or] = STATE(2691),
    [sym_not] = STATE(2691),
    [sym_and] = STATE(2691),
    [sym_cmp] = STATE(2691),
    [sym_in] = STATE(2691),
    [sym_add] = STATE(2691),
    [sym_sub] = STATE(2691),
    [sym_mul] = STATE(2691),
    [sym_div] = STATE(2691),
    [sym_sign] = STATE(2691),
    [sym_call] = STATE(2691),
    [sym_field] = STATE(2691),
    [sym_label] = STATE(2691),
    [sym_content] = STATE(2691),
    [sym_group] = STATE(2691),
    [sym_block] = STATE(2691),
    [sym_branch] = STATE(2691),
    [sym_let] = STATE(2691),
    [sym_set] = STATE(2691),
    [sym_import] = STATE(2691),
    [sym_include] = STATE(2691),
    [sym_for] = STATE(2691),
    [sym_while] = STATE(2691),
    [sym_show] = STATE(2691),
    [sym_return] = STATE(2691),
    [sym_flow] = STATE(2691),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1341),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1343),
    [sym_none] = ACTIONS(1343),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [98] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1345),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [99] = {
    [sym_raw_blck] = STATE(2719),
    [sym_raw_span] = STATE(2719),
    [sym_math] = STATE(2719),
    [sym__expr] = STATE(2719),
    [sym_ident] = STATE(2719),
    [sym_bool] = STATE(2719),
    [sym_number] = STATE(2719),
    [sym_string] = STATE(2719),
    [sym_tagged] = STATE(2719),
    [sym_context] = STATE(2719),
    [sym_elude] = STATE(2719),
    [sym_assign] = STATE(2719),
    [sym_lambda] = STATE(2719),
    [sym_or] = STATE(2719),
    [sym_not] = STATE(2719),
    [sym_and] = STATE(2719),
    [sym_cmp] = STATE(2719),
    [sym_in] = STATE(2719),
    [sym_add] = STATE(2719),
    [sym_sub] = STATE(2719),
    [sym_mul] = STATE(2719),
    [sym_div] = STATE(2719),
    [sym_sign] = STATE(2719),
    [sym_call] = STATE(2719),
    [sym_field] = STATE(2719),
    [sym_label] = STATE(2719),
    [sym_content] = STATE(2719),
    [sym_group] = STATE(2719),
    [sym_block] = STATE(2719),
    [sym_branch] = STATE(2719),
    [sym_let] = STATE(2719),
    [sym_set] = STATE(2719),
    [sym_import] = STATE(2719),
    [sym_include] = STATE(2719),
    [sym_for] = STATE(2719),
    [sym_while] = STATE(2719),
    [sym_show] = STATE(2719),
    [sym_return] = STATE(2719),
    [sym_flow] = STATE(2719),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1347),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1349),
    [sym_none] = ACTIONS(1349),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [100] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(3887),
    [sym__stmt] = STATE(3979),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [101] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(106),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1351),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [102] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(88),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [103] = {
    [sym_raw_blck] = STATE(2763),
    [sym_raw_span] = STATE(2763),
    [sym_math] = STATE(2763),
    [sym__expr] = STATE(2763),
    [sym_ident] = STATE(2763),
    [sym_bool] = STATE(2763),
    [sym_number] = STATE(2763),
    [sym_string] = STATE(2763),
    [sym_tagged] = STATE(2763),
    [sym_context] = STATE(2763),
    [sym_elude] = STATE(2763),
    [sym_assign] = STATE(2763),
    [sym_lambda] = STATE(2763),
    [sym_or] = STATE(2763),
    [sym_not] = STATE(2763),
    [sym_and] = STATE(2763),
    [sym_cmp] = STATE(2763),
    [sym_in] = STATE(2763),
    [sym_add] = STATE(2763),
    [sym_sub] = STATE(2763),
    [sym_mul] = STATE(2763),
    [sym_div] = STATE(2763),
    [sym_sign] = STATE(2763),
    [sym_call] = STATE(2763),
    [sym_field] = STATE(2763),
    [sym_label] = STATE(2763),
    [sym_content] = STATE(2763),
    [sym_group] = STATE(2763),
    [sym_block] = STATE(2763),
    [sym_branch] = STATE(2763),
    [sym_let] = STATE(2763),
    [sym_set] = STATE(2763),
    [sym_import] = STATE(2763),
    [sym_include] = STATE(2763),
    [sym_for] = STATE(2763),
    [sym_while] = STATE(2763),
    [sym_show] = STATE(2763),
    [sym_return] = STATE(2763),
    [sym_flow] = STATE(2763),
    [aux_sym_group_repeat1] = STATE(108),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1355),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1357),
    [sym_none] = ACTIONS(1357),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [104] = {
    [sym_raw_blck] = STATE(2763),
    [sym_raw_span] = STATE(2763),
    [sym_math] = STATE(2763),
    [sym__expr] = STATE(2763),
    [sym_ident] = STATE(2763),
    [sym_bool] = STATE(2763),
    [sym_number] = STATE(2763),
    [sym_string] = STATE(2763),
    [sym_tagged] = STATE(2763),
    [sym_context] = STATE(2763),
    [sym_elude] = STATE(2763),
    [sym_assign] = STATE(2763),
    [sym_lambda] = STATE(2763),
    [sym_or] = STATE(2763),
    [sym_not] = STATE(2763),
    [sym_and] = STATE(2763),
    [sym_cmp] = STATE(2763),
    [sym_in] = STATE(2763),
    [sym_add] = STATE(2763),
    [sym_sub] = STATE(2763),
    [sym_mul] = STATE(2763),
    [sym_div] = STATE(2763),
    [sym_sign] = STATE(2763),
    [sym_call] = STATE(2763),
    [sym_field] = STATE(2763),
    [sym_label] = STATE(2763),
    [sym_content] = STATE(2763),
    [sym_group] = STATE(2763),
    [sym_block] = STATE(2763),
    [sym_branch] = STATE(2763),
    [sym_let] = STATE(2763),
    [sym_set] = STATE(2763),
    [sym_import] = STATE(2763),
    [sym_include] = STATE(2763),
    [sym_for] = STATE(2763),
    [sym_while] = STATE(2763),
    [sym_show] = STATE(2763),
    [sym_return] = STATE(2763),
    [sym_flow] = STATE(2763),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1355),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1357),
    [sym_none] = ACTIONS(1357),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [105] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1359),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [106] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1361),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [107] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(105),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1363),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [108] = {
    [sym_raw_blck] = STATE(2774),
    [sym_raw_span] = STATE(2774),
    [sym_math] = STATE(2774),
    [sym__expr] = STATE(2774),
    [sym_ident] = STATE(2774),
    [sym_bool] = STATE(2774),
    [sym_number] = STATE(2774),
    [sym_string] = STATE(2774),
    [sym_tagged] = STATE(2774),
    [sym_context] = STATE(2774),
    [sym_elude] = STATE(2774),
    [sym_assign] = STATE(2774),
    [sym_lambda] = STATE(2774),
    [sym_or] = STATE(2774),
    [sym_not] = STATE(2774),
    [sym_and] = STATE(2774),
    [sym_cmp] = STATE(2774),
    [sym_in] = STATE(2774),
    [sym_add] = STATE(2774),
    [sym_sub] = STATE(2774),
    [sym_mul] = STATE(2774),
    [sym_div] = STATE(2774),
    [sym_sign] = STATE(2774),
    [sym_call] = STATE(2774),
    [sym_field] = STATE(2774),
    [sym_label] = STATE(2774),
    [sym_content] = STATE(2774),
    [sym_group] = STATE(2774),
    [sym_block] = STATE(2774),
    [sym_branch] = STATE(2774),
    [sym_let] = STATE(2774),
    [sym_set] = STATE(2774),
    [sym_import] = STATE(2774),
    [sym_include] = STATE(2774),
    [sym_for] = STATE(2774),
    [sym_while] = STATE(2774),
    [sym_show] = STATE(2774),
    [sym_return] = STATE(2774),
    [sym_flow] = STATE(2774),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1365),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1367),
    [sym_none] = ACTIONS(1367),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [109] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(3952),
    [sym__stmt] = STATE(3951),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [110] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1369),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [111] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(110),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1371),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [112] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(117),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1373),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [113] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1375),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [114] = {
    [sym_raw_blck] = STATE(2778),
    [sym_raw_span] = STATE(2778),
    [sym_math] = STATE(2778),
    [sym__expr] = STATE(2778),
    [sym_ident] = STATE(2778),
    [sym_bool] = STATE(2778),
    [sym_number] = STATE(2778),
    [sym_string] = STATE(2778),
    [sym_tagged] = STATE(2778),
    [sym_context] = STATE(2778),
    [sym_elude] = STATE(2778),
    [sym_assign] = STATE(2778),
    [sym_lambda] = STATE(2778),
    [sym_or] = STATE(2778),
    [sym_not] = STATE(2778),
    [sym_and] = STATE(2778),
    [sym_cmp] = STATE(2778),
    [sym_in] = STATE(2778),
    [sym_add] = STATE(2778),
    [sym_sub] = STATE(2778),
    [sym_mul] = STATE(2778),
    [sym_div] = STATE(2778),
    [sym_sign] = STATE(2778),
    [sym_call] = STATE(2778),
    [sym_field] = STATE(2778),
    [sym_label] = STATE(2778),
    [sym_content] = STATE(2778),
    [sym_group] = STATE(2778),
    [sym_block] = STATE(2778),
    [sym_branch] = STATE(2778),
    [sym_let] = STATE(2778),
    [sym_set] = STATE(2778),
    [sym_import] = STATE(2778),
    [sym_include] = STATE(2778),
    [sym_for] = STATE(2778),
    [sym_while] = STATE(2778),
    [sym_show] = STATE(2778),
    [sym_return] = STATE(2778),
    [sym_flow] = STATE(2778),
    [aux_sym_group_repeat1] = STATE(119),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1377),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1379),
    [sym_none] = ACTIONS(1379),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [115] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(113),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1381),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [116] = {
    [sym_raw_blck] = STATE(2778),
    [sym_raw_span] = STATE(2778),
    [sym_math] = STATE(2778),
    [sym__expr] = STATE(2778),
    [sym_ident] = STATE(2778),
    [sym_bool] = STATE(2778),
    [sym_number] = STATE(2778),
    [sym_string] = STATE(2778),
    [sym_tagged] = STATE(2778),
    [sym_context] = STATE(2778),
    [sym_elude] = STATE(2778),
    [sym_assign] = STATE(2778),
    [sym_lambda] = STATE(2778),
    [sym_or] = STATE(2778),
    [sym_not] = STATE(2778),
    [sym_and] = STATE(2778),
    [sym_cmp] = STATE(2778),
    [sym_in] = STATE(2778),
    [sym_add] = STATE(2778),
    [sym_sub] = STATE(2778),
    [sym_mul] = STATE(2778),
    [sym_div] = STATE(2778),
    [sym_sign] = STATE(2778),
    [sym_call] = STATE(2778),
    [sym_field] = STATE(2778),
    [sym_label] = STATE(2778),
    [sym_content] = STATE(2778),
    [sym_group] = STATE(2778),
    [sym_block] = STATE(2778),
    [sym_branch] = STATE(2778),
    [sym_let] = STATE(2778),
    [sym_set] = STATE(2778),
    [sym_import] = STATE(2778),
    [sym_include] = STATE(2778),
    [sym_for] = STATE(2778),
    [sym_while] = STATE(2778),
    [sym_show] = STATE(2778),
    [sym_return] = STATE(2778),
    [sym_flow] = STATE(2778),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1377),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1379),
    [sym_none] = ACTIONS(1379),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [117] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1383),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [118] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1385),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [119] = {
    [sym_raw_blck] = STATE(2773),
    [sym_raw_span] = STATE(2773),
    [sym_math] = STATE(2773),
    [sym__expr] = STATE(2773),
    [sym_ident] = STATE(2773),
    [sym_bool] = STATE(2773),
    [sym_number] = STATE(2773),
    [sym_string] = STATE(2773),
    [sym_tagged] = STATE(2773),
    [sym_context] = STATE(2773),
    [sym_elude] = STATE(2773),
    [sym_assign] = STATE(2773),
    [sym_lambda] = STATE(2773),
    [sym_or] = STATE(2773),
    [sym_not] = STATE(2773),
    [sym_and] = STATE(2773),
    [sym_cmp] = STATE(2773),
    [sym_in] = STATE(2773),
    [sym_add] = STATE(2773),
    [sym_sub] = STATE(2773),
    [sym_mul] = STATE(2773),
    [sym_div] = STATE(2773),
    [sym_sign] = STATE(2773),
    [sym_call] = STATE(2773),
    [sym_field] = STATE(2773),
    [sym_label] = STATE(2773),
    [sym_content] = STATE(2773),
    [sym_group] = STATE(2773),
    [sym_block] = STATE(2773),
    [sym_branch] = STATE(2773),
    [sym_let] = STATE(2773),
    [sym_set] = STATE(2773),
    [sym_import] = STATE(2773),
    [sym_include] = STATE(2773),
    [sym_for] = STATE(2773),
    [sym_while] = STATE(2773),
    [sym_show] = STATE(2773),
    [sym_return] = STATE(2773),
    [sym_flow] = STATE(2773),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1387),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1389),
    [sym_none] = ACTIONS(1389),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [120] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(3920),
    [sym__stmt] = STATE(3916),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [121] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(125),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1391),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [122] = {
    [sym_raw_blck] = STATE(2668),
    [sym_raw_span] = STATE(2668),
    [sym_math] = STATE(2668),
    [sym__expr] = STATE(2668),
    [sym_ident] = STATE(2668),
    [sym_bool] = STATE(2668),
    [sym_number] = STATE(2668),
    [sym_string] = STATE(2668),
    [sym_tagged] = STATE(2668),
    [sym_context] = STATE(2668),
    [sym_elude] = STATE(2668),
    [sym_assign] = STATE(2668),
    [sym_lambda] = STATE(2668),
    [sym_or] = STATE(2668),
    [sym_not] = STATE(2668),
    [sym_and] = STATE(2668),
    [sym_cmp] = STATE(2668),
    [sym_in] = STATE(2668),
    [sym_add] = STATE(2668),
    [sym_sub] = STATE(2668),
    [sym_mul] = STATE(2668),
    [sym_div] = STATE(2668),
    [sym_sign] = STATE(2668),
    [sym_call] = STATE(2668),
    [sym_field] = STATE(2668),
    [sym_label] = STATE(2668),
    [sym_content] = STATE(2668),
    [sym_group] = STATE(2668),
    [sym_block] = STATE(2668),
    [sym_branch] = STATE(2668),
    [sym_let] = STATE(2668),
    [sym_set] = STATE(2668),
    [sym_import] = STATE(2668),
    [sym_include] = STATE(2668),
    [sym_for] = STATE(2668),
    [sym_while] = STATE(2668),
    [sym_show] = STATE(2668),
    [sym_return] = STATE(2668),
    [sym_flow] = STATE(2668),
    [aux_sym_group_repeat1] = STATE(127),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1393),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1395),
    [sym_none] = ACTIONS(1395),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [123] = {
    [sym_raw_blck] = STATE(2668),
    [sym_raw_span] = STATE(2668),
    [sym_math] = STATE(2668),
    [sym__expr] = STATE(2668),
    [sym_ident] = STATE(2668),
    [sym_bool] = STATE(2668),
    [sym_number] = STATE(2668),
    [sym_string] = STATE(2668),
    [sym_tagged] = STATE(2668),
    [sym_context] = STATE(2668),
    [sym_elude] = STATE(2668),
    [sym_assign] = STATE(2668),
    [sym_lambda] = STATE(2668),
    [sym_or] = STATE(2668),
    [sym_not] = STATE(2668),
    [sym_and] = STATE(2668),
    [sym_cmp] = STATE(2668),
    [sym_in] = STATE(2668),
    [sym_add] = STATE(2668),
    [sym_sub] = STATE(2668),
    [sym_mul] = STATE(2668),
    [sym_div] = STATE(2668),
    [sym_sign] = STATE(2668),
    [sym_call] = STATE(2668),
    [sym_field] = STATE(2668),
    [sym_label] = STATE(2668),
    [sym_content] = STATE(2668),
    [sym_group] = STATE(2668),
    [sym_block] = STATE(2668),
    [sym_branch] = STATE(2668),
    [sym_let] = STATE(2668),
    [sym_set] = STATE(2668),
    [sym_import] = STATE(2668),
    [sym_include] = STATE(2668),
    [sym_for] = STATE(2668),
    [sym_while] = STATE(2668),
    [sym_show] = STATE(2668),
    [sym_return] = STATE(2668),
    [sym_flow] = STATE(2668),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1393),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1395),
    [sym_none] = ACTIONS(1395),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [124] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1397),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [125] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1399),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [126] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(124),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1401),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [127] = {
    [sym_raw_blck] = STATE(2404),
    [sym_raw_span] = STATE(2404),
    [sym_math] = STATE(2404),
    [sym__expr] = STATE(2404),
    [sym_ident] = STATE(2404),
    [sym_bool] = STATE(2404),
    [sym_number] = STATE(2404),
    [sym_string] = STATE(2404),
    [sym_tagged] = STATE(2404),
    [sym_context] = STATE(2404),
    [sym_elude] = STATE(2404),
    [sym_assign] = STATE(2404),
    [sym_lambda] = STATE(2404),
    [sym_or] = STATE(2404),
    [sym_not] = STATE(2404),
    [sym_and] = STATE(2404),
    [sym_cmp] = STATE(2404),
    [sym_in] = STATE(2404),
    [sym_add] = STATE(2404),
    [sym_sub] = STATE(2404),
    [sym_mul] = STATE(2404),
    [sym_div] = STATE(2404),
    [sym_sign] = STATE(2404),
    [sym_call] = STATE(2404),
    [sym_field] = STATE(2404),
    [sym_label] = STATE(2404),
    [sym_content] = STATE(2404),
    [sym_group] = STATE(2404),
    [sym_block] = STATE(2404),
    [sym_branch] = STATE(2404),
    [sym_let] = STATE(2404),
    [sym_set] = STATE(2404),
    [sym_import] = STATE(2404),
    [sym_include] = STATE(2404),
    [sym_for] = STATE(2404),
    [sym_while] = STATE(2404),
    [sym_show] = STATE(2404),
    [sym_return] = STATE(2404),
    [sym_flow] = STATE(2404),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1403),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1405),
    [sym_none] = ACTIONS(1405),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [128] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [129] = {
    [sym_raw_blck] = STATE(2665),
    [sym_raw_span] = STATE(2665),
    [sym_math] = STATE(2665),
    [sym__expr] = STATE(2665),
    [sym_ident] = STATE(2665),
    [sym_bool] = STATE(2665),
    [sym_number] = STATE(2665),
    [sym_string] = STATE(2665),
    [sym_tagged] = STATE(2665),
    [sym_context] = STATE(2665),
    [sym_elude] = STATE(2665),
    [sym_assign] = STATE(2665),
    [sym_lambda] = STATE(2665),
    [sym_or] = STATE(2665),
    [sym_not] = STATE(2665),
    [sym_and] = STATE(2665),
    [sym_cmp] = STATE(2665),
    [sym_in] = STATE(2665),
    [sym_add] = STATE(2665),
    [sym_sub] = STATE(2665),
    [sym_mul] = STATE(2665),
    [sym_div] = STATE(2665),
    [sym_sign] = STATE(2665),
    [sym_call] = STATE(2665),
    [sym_field] = STATE(2665),
    [sym_label] = STATE(2665),
    [sym_content] = STATE(2665),
    [sym_group] = STATE(2665),
    [sym_block] = STATE(2665),
    [sym_branch] = STATE(2665),
    [sym_let] = STATE(2665),
    [sym_set] = STATE(2665),
    [sym_import] = STATE(2665),
    [sym_include] = STATE(2665),
    [sym_for] = STATE(2665),
    [sym_while] = STATE(2665),
    [sym_show] = STATE(2665),
    [sym_return] = STATE(2665),
    [sym_flow] = STATE(2665),
    [aux_sym_group_repeat1] = STATE(194),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1411),
    [sym_none] = ACTIONS(1411),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [130] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(3888),
    [sym__stmt] = STATE(3878),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [131] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(128),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1413),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [132] = {
    [sym_raw_blck] = STATE(2665),
    [sym_raw_span] = STATE(2665),
    [sym_math] = STATE(2665),
    [sym__expr] = STATE(2665),
    [sym_ident] = STATE(2665),
    [sym_bool] = STATE(2665),
    [sym_number] = STATE(2665),
    [sym_string] = STATE(2665),
    [sym_tagged] = STATE(2665),
    [sym_context] = STATE(2665),
    [sym_elude] = STATE(2665),
    [sym_assign] = STATE(2665),
    [sym_lambda] = STATE(2665),
    [sym_or] = STATE(2665),
    [sym_not] = STATE(2665),
    [sym_and] = STATE(2665),
    [sym_cmp] = STATE(2665),
    [sym_in] = STATE(2665),
    [sym_add] = STATE(2665),
    [sym_sub] = STATE(2665),
    [sym_mul] = STATE(2665),
    [sym_div] = STATE(2665),
    [sym_sign] = STATE(2665),
    [sym_call] = STATE(2665),
    [sym_field] = STATE(2665),
    [sym_label] = STATE(2665),
    [sym_content] = STATE(2665),
    [sym_group] = STATE(2665),
    [sym_block] = STATE(2665),
    [sym_branch] = STATE(2665),
    [sym_let] = STATE(2665),
    [sym_set] = STATE(2665),
    [sym_import] = STATE(2665),
    [sym_include] = STATE(2665),
    [sym_for] = STATE(2665),
    [sym_while] = STATE(2665),
    [sym_show] = STATE(2665),
    [sym_return] = STATE(2665),
    [sym_flow] = STATE(2665),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1411),
    [sym_none] = ACTIONS(1411),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [133] = {
    [sym_raw_blck] = STATE(2736),
    [sym_raw_span] = STATE(2736),
    [sym_math] = STATE(2736),
    [sym__expr] = STATE(2736),
    [sym_ident] = STATE(2736),
    [sym_bool] = STATE(2736),
    [sym_number] = STATE(2736),
    [sym_string] = STATE(2736),
    [sym_tagged] = STATE(2736),
    [sym_context] = STATE(2736),
    [sym_elude] = STATE(2736),
    [sym_assign] = STATE(2736),
    [sym_lambda] = STATE(2736),
    [sym_or] = STATE(2736),
    [sym_not] = STATE(2736),
    [sym_and] = STATE(2736),
    [sym_cmp] = STATE(2736),
    [sym_in] = STATE(2736),
    [sym_add] = STATE(2736),
    [sym_sub] = STATE(2736),
    [sym_mul] = STATE(2736),
    [sym_div] = STATE(2736),
    [sym_sign] = STATE(2736),
    [sym_call] = STATE(2736),
    [sym_field] = STATE(2736),
    [sym_label] = STATE(2736),
    [sym_content] = STATE(2736),
    [sym_group] = STATE(2736),
    [sym_block] = STATE(2736),
    [sym_branch] = STATE(2736),
    [sym_let] = STATE(2736),
    [sym_set] = STATE(2736),
    [sym_import] = STATE(2736),
    [sym_include] = STATE(2736),
    [sym_for] = STATE(2736),
    [sym_while] = STATE(2736),
    [sym_show] = STATE(2736),
    [sym_return] = STATE(2736),
    [sym_flow] = STATE(2736),
    [aux_sym_group_repeat1] = STATE(140),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1283),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1285),
    [sym_none] = ACTIONS(1285),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [134] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [135] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1417),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [136] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(143),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1419),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [137] = {
    [sym_raw_blck] = STATE(2625),
    [sym_raw_span] = STATE(2625),
    [sym_math] = STATE(2625),
    [sym__expr] = STATE(2625),
    [sym_ident] = STATE(2625),
    [sym_bool] = STATE(2625),
    [sym_number] = STATE(2625),
    [sym_string] = STATE(2625),
    [sym_tagged] = STATE(2625),
    [sym_context] = STATE(2625),
    [sym_elude] = STATE(2625),
    [sym_assign] = STATE(2625),
    [sym_lambda] = STATE(2625),
    [sym_or] = STATE(2625),
    [sym_not] = STATE(2625),
    [sym_and] = STATE(2625),
    [sym_cmp] = STATE(2625),
    [sym_in] = STATE(2625),
    [sym_add] = STATE(2625),
    [sym_sub] = STATE(2625),
    [sym_mul] = STATE(2625),
    [sym_div] = STATE(2625),
    [sym_sign] = STATE(2625),
    [sym_call] = STATE(2625),
    [sym_field] = STATE(2625),
    [sym_label] = STATE(2625),
    [sym_content] = STATE(2625),
    [sym_group] = STATE(2625),
    [sym_block] = STATE(2625),
    [sym_branch] = STATE(2625),
    [sym_let] = STATE(2625),
    [sym_set] = STATE(2625),
    [sym_import] = STATE(2625),
    [sym_include] = STATE(2625),
    [sym_for] = STATE(2625),
    [sym_while] = STATE(2625),
    [sym_show] = STATE(2625),
    [sym_return] = STATE(2625),
    [sym_flow] = STATE(2625),
    [aux_sym_group_repeat1] = STATE(144),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1423),
    [sym_none] = ACTIONS(1423),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [138] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(134),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1425),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [139] = {
    [sym_raw_blck] = STATE(2757),
    [sym_raw_span] = STATE(2757),
    [sym_math] = STATE(2757),
    [sym__expr] = STATE(2757),
    [sym_ident] = STATE(2757),
    [sym_bool] = STATE(2757),
    [sym_number] = STATE(2757),
    [sym_string] = STATE(2757),
    [sym_tagged] = STATE(2757),
    [sym_context] = STATE(2757),
    [sym_elude] = STATE(2757),
    [sym_assign] = STATE(2757),
    [sym_lambda] = STATE(2757),
    [sym_or] = STATE(2757),
    [sym_not] = STATE(2757),
    [sym_and] = STATE(2757),
    [sym_cmp] = STATE(2757),
    [sym_in] = STATE(2757),
    [sym_add] = STATE(2757),
    [sym_sub] = STATE(2757),
    [sym_mul] = STATE(2757),
    [sym_div] = STATE(2757),
    [sym_sign] = STATE(2757),
    [sym_call] = STATE(2757),
    [sym_field] = STATE(2757),
    [sym_label] = STATE(2757),
    [sym_content] = STATE(2757),
    [sym_group] = STATE(2757),
    [sym_block] = STATE(2757),
    [sym_branch] = STATE(2757),
    [sym_let] = STATE(2757),
    [sym_set] = STATE(2757),
    [sym_import] = STATE(2757),
    [sym_include] = STATE(2757),
    [sym_for] = STATE(2757),
    [sym_while] = STATE(2757),
    [sym_show] = STATE(2757),
    [sym_return] = STATE(2757),
    [sym_flow] = STATE(2757),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1427),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1429),
    [sym_none] = ACTIONS(1429),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [140] = {
    [sym_raw_blck] = STATE(2732),
    [sym_raw_span] = STATE(2732),
    [sym_math] = STATE(2732),
    [sym__expr] = STATE(2732),
    [sym_ident] = STATE(2732),
    [sym_bool] = STATE(2732),
    [sym_number] = STATE(2732),
    [sym_string] = STATE(2732),
    [sym_tagged] = STATE(2732),
    [sym_context] = STATE(2732),
    [sym_elude] = STATE(2732),
    [sym_assign] = STATE(2732),
    [sym_lambda] = STATE(2732),
    [sym_or] = STATE(2732),
    [sym_not] = STATE(2732),
    [sym_and] = STATE(2732),
    [sym_cmp] = STATE(2732),
    [sym_in] = STATE(2732),
    [sym_add] = STATE(2732),
    [sym_sub] = STATE(2732),
    [sym_mul] = STATE(2732),
    [sym_div] = STATE(2732),
    [sym_sign] = STATE(2732),
    [sym_call] = STATE(2732),
    [sym_field] = STATE(2732),
    [sym_label] = STATE(2732),
    [sym_content] = STATE(2732),
    [sym_group] = STATE(2732),
    [sym_block] = STATE(2732),
    [sym_branch] = STATE(2732),
    [sym_let] = STATE(2732),
    [sym_set] = STATE(2732),
    [sym_import] = STATE(2732),
    [sym_include] = STATE(2732),
    [sym_for] = STATE(2732),
    [sym_while] = STATE(2732),
    [sym_show] = STATE(2732),
    [sym_return] = STATE(2732),
    [sym_flow] = STATE(2732),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1431),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1433),
    [sym_none] = ACTIONS(1433),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [141] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1435),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [142] = {
    [sym_raw_blck] = STATE(2625),
    [sym_raw_span] = STATE(2625),
    [sym_math] = STATE(2625),
    [sym__expr] = STATE(2625),
    [sym_ident] = STATE(2625),
    [sym_bool] = STATE(2625),
    [sym_number] = STATE(2625),
    [sym_string] = STATE(2625),
    [sym_tagged] = STATE(2625),
    [sym_context] = STATE(2625),
    [sym_elude] = STATE(2625),
    [sym_assign] = STATE(2625),
    [sym_lambda] = STATE(2625),
    [sym_or] = STATE(2625),
    [sym_not] = STATE(2625),
    [sym_and] = STATE(2625),
    [sym_cmp] = STATE(2625),
    [sym_in] = STATE(2625),
    [sym_add] = STATE(2625),
    [sym_sub] = STATE(2625),
    [sym_mul] = STATE(2625),
    [sym_div] = STATE(2625),
    [sym_sign] = STATE(2625),
    [sym_call] = STATE(2625),
    [sym_field] = STATE(2625),
    [sym_label] = STATE(2625),
    [sym_content] = STATE(2625),
    [sym_group] = STATE(2625),
    [sym_block] = STATE(2625),
    [sym_branch] = STATE(2625),
    [sym_let] = STATE(2625),
    [sym_set] = STATE(2625),
    [sym_import] = STATE(2625),
    [sym_include] = STATE(2625),
    [sym_for] = STATE(2625),
    [sym_while] = STATE(2625),
    [sym_show] = STATE(2625),
    [sym_return] = STATE(2625),
    [sym_flow] = STATE(2625),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1423),
    [sym_none] = ACTIONS(1423),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [143] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1437),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [144] = {
    [sym_raw_blck] = STATE(2610),
    [sym_raw_span] = STATE(2610),
    [sym_math] = STATE(2610),
    [sym__expr] = STATE(2610),
    [sym_ident] = STATE(2610),
    [sym_bool] = STATE(2610),
    [sym_number] = STATE(2610),
    [sym_string] = STATE(2610),
    [sym_tagged] = STATE(2610),
    [sym_context] = STATE(2610),
    [sym_elude] = STATE(2610),
    [sym_assign] = STATE(2610),
    [sym_lambda] = STATE(2610),
    [sym_or] = STATE(2610),
    [sym_not] = STATE(2610),
    [sym_and] = STATE(2610),
    [sym_cmp] = STATE(2610),
    [sym_in] = STATE(2610),
    [sym_add] = STATE(2610),
    [sym_sub] = STATE(2610),
    [sym_mul] = STATE(2610),
    [sym_div] = STATE(2610),
    [sym_sign] = STATE(2610),
    [sym_call] = STATE(2610),
    [sym_field] = STATE(2610),
    [sym_label] = STATE(2610),
    [sym_content] = STATE(2610),
    [sym_group] = STATE(2610),
    [sym_block] = STATE(2610),
    [sym_branch] = STATE(2610),
    [sym_let] = STATE(2610),
    [sym_set] = STATE(2610),
    [sym_import] = STATE(2610),
    [sym_include] = STATE(2610),
    [sym_for] = STATE(2610),
    [sym_while] = STATE(2610),
    [sym_show] = STATE(2610),
    [sym_return] = STATE(2610),
    [sym_flow] = STATE(2610),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1439),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1441),
    [sym_none] = ACTIONS(1441),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [145] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(141),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1443),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [146] = {
    [sym_raw_blck] = STATE(2891),
    [sym_raw_span] = STATE(2891),
    [sym_math] = STATE(2891),
    [sym__item] = STATE(3857),
    [sym__stmt] = STATE(3856),
    [sym__expr] = STATE(3041),
    [sym_ident] = STATE(2891),
    [sym_bool] = STATE(2891),
    [sym_number] = STATE(2891),
    [sym_string] = STATE(2891),
    [sym_tagged] = STATE(3041),
    [sym_context] = STATE(2891),
    [sym_elude] = STATE(3041),
    [sym_assign] = STATE(3041),
    [sym_lambda] = STATE(3041),
    [sym_or] = STATE(3041),
    [sym_not] = STATE(3041),
    [sym_and] = STATE(3041),
    [sym_cmp] = STATE(3041),
    [sym_in] = STATE(3041),
    [sym_add] = STATE(3041),
    [sym_sub] = STATE(3041),
    [sym_mul] = STATE(3041),
    [sym_div] = STATE(3041),
    [sym_sign] = STATE(3041),
    [sym_call] = STATE(2891),
    [sym_field] = STATE(2891),
    [sym_label] = STATE(2891),
    [sym_content] = STATE(2891),
    [sym_group] = STATE(2891),
    [sym_block] = STATE(2891),
    [sym_branch] = STATE(2891),
    [sym_let] = STATE(2885),
    [sym_set] = STATE(2885),
    [sym_import] = STATE(2885),
    [sym_include] = STATE(2885),
    [sym_for] = STATE(2885),
    [sym_while] = STATE(2885),
    [sym_show] = STATE(2885),
    [sym_return] = STATE(2885),
    [sym_flow] = STATE(2891),
    [sym__identifier] = ACTIONS(895),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(897),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(901),
    [anon_sym_true] = ACTIONS(903),
    [anon_sym_false] = ACTIONS(903),
    [aux_sym_number_token1] = ACTIONS(905),
    [anon_sym_DQUOTE] = ACTIONS(907),
    [anon_sym_context] = ACTIONS(909),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1291),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_LBRACE] = ACTIONS(915),
    [anon_sym_if] = ACTIONS(917),
    [anon_sym_let] = ACTIONS(1033),
    [anon_sym_set] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_include] = ACTIONS(1039),
    [anon_sym_for] = ACTIONS(1041),
    [anon_sym_while] = ACTIONS(1043),
    [anon_sym_show] = ACTIONS(1045),
    [anon_sym_return] = ACTIONS(1047),
    [anon_sym_break] = ACTIONS(935),
    [anon_sym_continue] = ACTIONS(935),
    [sym_auto] = ACTIONS(1293),
    [sym_none] = ACTIONS(1293),
    [sym__token_content] = ACTIONS(939),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [147] = {
    [sym_raw_blck] = STATE(2765),
    [sym_raw_span] = STATE(2765),
    [sym_math] = STATE(2765),
    [sym__expr] = STATE(2765),
    [sym_ident] = STATE(2765),
    [sym_bool] = STATE(2765),
    [sym_number] = STATE(2765),
    [sym_string] = STATE(2765),
    [sym_tagged] = STATE(2765),
    [sym_context] = STATE(2765),
    [sym_elude] = STATE(2765),
    [sym_assign] = STATE(2765),
    [sym_lambda] = STATE(2765),
    [sym_or] = STATE(2765),
    [sym_not] = STATE(2765),
    [sym_and] = STATE(2765),
    [sym_cmp] = STATE(2765),
    [sym_in] = STATE(2765),
    [sym_add] = STATE(2765),
    [sym_sub] = STATE(2765),
    [sym_mul] = STATE(2765),
    [sym_div] = STATE(2765),
    [sym_sign] = STATE(2765),
    [sym_call] = STATE(2765),
    [sym_field] = STATE(2765),
    [sym_label] = STATE(2765),
    [sym_content] = STATE(2765),
    [sym_group] = STATE(2765),
    [sym_block] = STATE(2765),
    [sym_branch] = STATE(2765),
    [sym_let] = STATE(2765),
    [sym_set] = STATE(2765),
    [sym_import] = STATE(2765),
    [sym_include] = STATE(2765),
    [sym_for] = STATE(2765),
    [sym_while] = STATE(2765),
    [sym_show] = STATE(2765),
    [sym_return] = STATE(2765),
    [sym_flow] = STATE(2765),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1319),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1321),
    [sym_none] = ACTIONS(1321),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [148] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1445),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [149] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(152),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1447),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [150] = {
    [sym_raw_blck] = STATE(2558),
    [sym_raw_span] = STATE(2558),
    [sym_math] = STATE(2558),
    [sym__expr] = STATE(2558),
    [sym_ident] = STATE(2558),
    [sym_bool] = STATE(2558),
    [sym_number] = STATE(2558),
    [sym_string] = STATE(2558),
    [sym_tagged] = STATE(2558),
    [sym_context] = STATE(2558),
    [sym_elude] = STATE(2558),
    [sym_assign] = STATE(2558),
    [sym_lambda] = STATE(2558),
    [sym_or] = STATE(2558),
    [sym_not] = STATE(2558),
    [sym_and] = STATE(2558),
    [sym_cmp] = STATE(2558),
    [sym_in] = STATE(2558),
    [sym_add] = STATE(2558),
    [sym_sub] = STATE(2558),
    [sym_mul] = STATE(2558),
    [sym_div] = STATE(2558),
    [sym_sign] = STATE(2558),
    [sym_call] = STATE(2558),
    [sym_field] = STATE(2558),
    [sym_label] = STATE(2558),
    [sym_content] = STATE(2558),
    [sym_group] = STATE(2558),
    [sym_block] = STATE(2558),
    [sym_branch] = STATE(2558),
    [sym_let] = STATE(2558),
    [sym_set] = STATE(2558),
    [sym_import] = STATE(2558),
    [sym_include] = STATE(2558),
    [sym_for] = STATE(2558),
    [sym_while] = STATE(2558),
    [sym_show] = STATE(2558),
    [sym_return] = STATE(2558),
    [sym_flow] = STATE(2558),
    [aux_sym_group_repeat1] = STATE(153),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1449),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1451),
    [sym_none] = ACTIONS(1451),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [151] = {
    [sym_raw_blck] = STATE(2558),
    [sym_raw_span] = STATE(2558),
    [sym_math] = STATE(2558),
    [sym__expr] = STATE(2558),
    [sym_ident] = STATE(2558),
    [sym_bool] = STATE(2558),
    [sym_number] = STATE(2558),
    [sym_string] = STATE(2558),
    [sym_tagged] = STATE(2558),
    [sym_context] = STATE(2558),
    [sym_elude] = STATE(2558),
    [sym_assign] = STATE(2558),
    [sym_lambda] = STATE(2558),
    [sym_or] = STATE(2558),
    [sym_not] = STATE(2558),
    [sym_and] = STATE(2558),
    [sym_cmp] = STATE(2558),
    [sym_in] = STATE(2558),
    [sym_add] = STATE(2558),
    [sym_sub] = STATE(2558),
    [sym_mul] = STATE(2558),
    [sym_div] = STATE(2558),
    [sym_sign] = STATE(2558),
    [sym_call] = STATE(2558),
    [sym_field] = STATE(2558),
    [sym_label] = STATE(2558),
    [sym_content] = STATE(2558),
    [sym_group] = STATE(2558),
    [sym_block] = STATE(2558),
    [sym_branch] = STATE(2558),
    [sym_let] = STATE(2558),
    [sym_set] = STATE(2558),
    [sym_import] = STATE(2558),
    [sym_include] = STATE(2558),
    [sym_for] = STATE(2558),
    [sym_while] = STATE(2558),
    [sym_show] = STATE(2558),
    [sym_return] = STATE(2558),
    [sym_flow] = STATE(2558),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1449),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1451),
    [sym_none] = ACTIONS(1451),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [152] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1453),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [153] = {
    [sym_raw_blck] = STATE(2556),
    [sym_raw_span] = STATE(2556),
    [sym_math] = STATE(2556),
    [sym__expr] = STATE(2556),
    [sym_ident] = STATE(2556),
    [sym_bool] = STATE(2556),
    [sym_number] = STATE(2556),
    [sym_string] = STATE(2556),
    [sym_tagged] = STATE(2556),
    [sym_context] = STATE(2556),
    [sym_elude] = STATE(2556),
    [sym_assign] = STATE(2556),
    [sym_lambda] = STATE(2556),
    [sym_or] = STATE(2556),
    [sym_not] = STATE(2556),
    [sym_and] = STATE(2556),
    [sym_cmp] = STATE(2556),
    [sym_in] = STATE(2556),
    [sym_add] = STATE(2556),
    [sym_sub] = STATE(2556),
    [sym_mul] = STATE(2556),
    [sym_div] = STATE(2556),
    [sym_sign] = STATE(2556),
    [sym_call] = STATE(2556),
    [sym_field] = STATE(2556),
    [sym_label] = STATE(2556),
    [sym_content] = STATE(2556),
    [sym_group] = STATE(2556),
    [sym_block] = STATE(2556),
    [sym_branch] = STATE(2556),
    [sym_let] = STATE(2556),
    [sym_set] = STATE(2556),
    [sym_import] = STATE(2556),
    [sym_include] = STATE(2556),
    [sym_for] = STATE(2556),
    [sym_while] = STATE(2556),
    [sym_show] = STATE(2556),
    [sym_return] = STATE(2556),
    [sym_flow] = STATE(2556),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1455),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1457),
    [sym_none] = ACTIONS(1457),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [154] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1459),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [155] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(154),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1461),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [156] = {
    [sym_raw_blck] = STATE(2502),
    [sym_raw_span] = STATE(2502),
    [sym_math] = STATE(2502),
    [sym__expr] = STATE(2502),
    [sym_ident] = STATE(2502),
    [sym_bool] = STATE(2502),
    [sym_number] = STATE(2502),
    [sym_string] = STATE(2502),
    [sym_tagged] = STATE(2502),
    [sym_context] = STATE(2502),
    [sym_elude] = STATE(2502),
    [sym_assign] = STATE(2502),
    [sym_lambda] = STATE(2502),
    [sym_or] = STATE(2502),
    [sym_not] = STATE(2502),
    [sym_and] = STATE(2502),
    [sym_cmp] = STATE(2502),
    [sym_in] = STATE(2502),
    [sym_add] = STATE(2502),
    [sym_sub] = STATE(2502),
    [sym_mul] = STATE(2502),
    [sym_div] = STATE(2502),
    [sym_sign] = STATE(2502),
    [sym_call] = STATE(2502),
    [sym_field] = STATE(2502),
    [sym_label] = STATE(2502),
    [sym_content] = STATE(2502),
    [sym_group] = STATE(2502),
    [sym_block] = STATE(2502),
    [sym_branch] = STATE(2502),
    [sym_let] = STATE(2502),
    [sym_set] = STATE(2502),
    [sym_import] = STATE(2502),
    [sym_include] = STATE(2502),
    [sym_for] = STATE(2502),
    [sym_while] = STATE(2502),
    [sym_show] = STATE(2502),
    [sym_return] = STATE(2502),
    [sym_flow] = STATE(2502),
    [aux_sym_group_repeat1] = STATE(159),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1463),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1465),
    [sym_none] = ACTIONS(1465),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [157] = {
    [sym_raw_blck] = STATE(2502),
    [sym_raw_span] = STATE(2502),
    [sym_math] = STATE(2502),
    [sym__expr] = STATE(2502),
    [sym_ident] = STATE(2502),
    [sym_bool] = STATE(2502),
    [sym_number] = STATE(2502),
    [sym_string] = STATE(2502),
    [sym_tagged] = STATE(2502),
    [sym_context] = STATE(2502),
    [sym_elude] = STATE(2502),
    [sym_assign] = STATE(2502),
    [sym_lambda] = STATE(2502),
    [sym_or] = STATE(2502),
    [sym_not] = STATE(2502),
    [sym_and] = STATE(2502),
    [sym_cmp] = STATE(2502),
    [sym_in] = STATE(2502),
    [sym_add] = STATE(2502),
    [sym_sub] = STATE(2502),
    [sym_mul] = STATE(2502),
    [sym_div] = STATE(2502),
    [sym_sign] = STATE(2502),
    [sym_call] = STATE(2502),
    [sym_field] = STATE(2502),
    [sym_label] = STATE(2502),
    [sym_content] = STATE(2502),
    [sym_group] = STATE(2502),
    [sym_block] = STATE(2502),
    [sym_branch] = STATE(2502),
    [sym_let] = STATE(2502),
    [sym_set] = STATE(2502),
    [sym_import] = STATE(2502),
    [sym_include] = STATE(2502),
    [sym_for] = STATE(2502),
    [sym_while] = STATE(2502),
    [sym_show] = STATE(2502),
    [sym_return] = STATE(2502),
    [sym_flow] = STATE(2502),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1463),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1465),
    [sym_none] = ACTIONS(1465),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [158] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1467),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [159] = {
    [sym_raw_blck] = STATE(2497),
    [sym_raw_span] = STATE(2497),
    [sym_math] = STATE(2497),
    [sym__expr] = STATE(2497),
    [sym_ident] = STATE(2497),
    [sym_bool] = STATE(2497),
    [sym_number] = STATE(2497),
    [sym_string] = STATE(2497),
    [sym_tagged] = STATE(2497),
    [sym_context] = STATE(2497),
    [sym_elude] = STATE(2497),
    [sym_assign] = STATE(2497),
    [sym_lambda] = STATE(2497),
    [sym_or] = STATE(2497),
    [sym_not] = STATE(2497),
    [sym_and] = STATE(2497),
    [sym_cmp] = STATE(2497),
    [sym_in] = STATE(2497),
    [sym_add] = STATE(2497),
    [sym_sub] = STATE(2497),
    [sym_mul] = STATE(2497),
    [sym_div] = STATE(2497),
    [sym_sign] = STATE(2497),
    [sym_call] = STATE(2497),
    [sym_field] = STATE(2497),
    [sym_label] = STATE(2497),
    [sym_content] = STATE(2497),
    [sym_group] = STATE(2497),
    [sym_block] = STATE(2497),
    [sym_branch] = STATE(2497),
    [sym_let] = STATE(2497),
    [sym_set] = STATE(2497),
    [sym_import] = STATE(2497),
    [sym_include] = STATE(2497),
    [sym_for] = STATE(2497),
    [sym_while] = STATE(2497),
    [sym_show] = STATE(2497),
    [sym_return] = STATE(2497),
    [sym_flow] = STATE(2497),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1469),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1471),
    [sym_none] = ACTIONS(1471),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [160] = {
    [sym_raw_blck] = STATE(2790),
    [sym_raw_span] = STATE(2790),
    [sym_math] = STATE(2790),
    [sym__expr] = STATE(2790),
    [sym_ident] = STATE(2790),
    [sym_bool] = STATE(2790),
    [sym_number] = STATE(2790),
    [sym_string] = STATE(2790),
    [sym_tagged] = STATE(2790),
    [sym_context] = STATE(2790),
    [sym_elude] = STATE(2790),
    [sym_assign] = STATE(2790),
    [sym_lambda] = STATE(2790),
    [sym_or] = STATE(2790),
    [sym_not] = STATE(2790),
    [sym_and] = STATE(2790),
    [sym_cmp] = STATE(2790),
    [sym_in] = STATE(2790),
    [sym_add] = STATE(2790),
    [sym_sub] = STATE(2790),
    [sym_mul] = STATE(2790),
    [sym_div] = STATE(2790),
    [sym_sign] = STATE(2790),
    [sym_call] = STATE(2790),
    [sym_field] = STATE(2790),
    [sym_label] = STATE(2790),
    [sym_content] = STATE(2790),
    [sym_group] = STATE(2790),
    [sym_block] = STATE(2790),
    [sym_branch] = STATE(2790),
    [sym_let] = STATE(2790),
    [sym_set] = STATE(2790),
    [sym_import] = STATE(2790),
    [sym_include] = STATE(2790),
    [sym_for] = STATE(2790),
    [sym_while] = STATE(2790),
    [sym_show] = STATE(2790),
    [sym_return] = STATE(2790),
    [sym_flow] = STATE(2790),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1473),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1475),
    [sym_none] = ACTIONS(1475),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [161] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(148),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1477),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [162] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(165),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1479),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [163] = {
    [sym_raw_blck] = STATE(2409),
    [sym_raw_span] = STATE(2409),
    [sym_math] = STATE(2409),
    [sym__expr] = STATE(2409),
    [sym_ident] = STATE(2409),
    [sym_bool] = STATE(2409),
    [sym_number] = STATE(2409),
    [sym_string] = STATE(2409),
    [sym_tagged] = STATE(2409),
    [sym_context] = STATE(2409),
    [sym_elude] = STATE(2409),
    [sym_assign] = STATE(2409),
    [sym_lambda] = STATE(2409),
    [sym_or] = STATE(2409),
    [sym_not] = STATE(2409),
    [sym_and] = STATE(2409),
    [sym_cmp] = STATE(2409),
    [sym_in] = STATE(2409),
    [sym_add] = STATE(2409),
    [sym_sub] = STATE(2409),
    [sym_mul] = STATE(2409),
    [sym_div] = STATE(2409),
    [sym_sign] = STATE(2409),
    [sym_call] = STATE(2409),
    [sym_field] = STATE(2409),
    [sym_label] = STATE(2409),
    [sym_content] = STATE(2409),
    [sym_group] = STATE(2409),
    [sym_block] = STATE(2409),
    [sym_branch] = STATE(2409),
    [sym_let] = STATE(2409),
    [sym_set] = STATE(2409),
    [sym_import] = STATE(2409),
    [sym_include] = STATE(2409),
    [sym_for] = STATE(2409),
    [sym_while] = STATE(2409),
    [sym_show] = STATE(2409),
    [sym_return] = STATE(2409),
    [sym_flow] = STATE(2409),
    [aux_sym_group_repeat1] = STATE(166),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1481),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1483),
    [sym_none] = ACTIONS(1483),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [164] = {
    [sym_raw_blck] = STATE(2409),
    [sym_raw_span] = STATE(2409),
    [sym_math] = STATE(2409),
    [sym__expr] = STATE(2409),
    [sym_ident] = STATE(2409),
    [sym_bool] = STATE(2409),
    [sym_number] = STATE(2409),
    [sym_string] = STATE(2409),
    [sym_tagged] = STATE(2409),
    [sym_context] = STATE(2409),
    [sym_elude] = STATE(2409),
    [sym_assign] = STATE(2409),
    [sym_lambda] = STATE(2409),
    [sym_or] = STATE(2409),
    [sym_not] = STATE(2409),
    [sym_and] = STATE(2409),
    [sym_cmp] = STATE(2409),
    [sym_in] = STATE(2409),
    [sym_add] = STATE(2409),
    [sym_sub] = STATE(2409),
    [sym_mul] = STATE(2409),
    [sym_div] = STATE(2409),
    [sym_sign] = STATE(2409),
    [sym_call] = STATE(2409),
    [sym_field] = STATE(2409),
    [sym_label] = STATE(2409),
    [sym_content] = STATE(2409),
    [sym_group] = STATE(2409),
    [sym_block] = STATE(2409),
    [sym_branch] = STATE(2409),
    [sym_let] = STATE(2409),
    [sym_set] = STATE(2409),
    [sym_import] = STATE(2409),
    [sym_include] = STATE(2409),
    [sym_for] = STATE(2409),
    [sym_while] = STATE(2409),
    [sym_show] = STATE(2409),
    [sym_return] = STATE(2409),
    [sym_flow] = STATE(2409),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1481),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1483),
    [sym_none] = ACTIONS(1483),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [165] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1485),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [166] = {
    [sym_raw_blck] = STATE(2417),
    [sym_raw_span] = STATE(2417),
    [sym_math] = STATE(2417),
    [sym__expr] = STATE(2417),
    [sym_ident] = STATE(2417),
    [sym_bool] = STATE(2417),
    [sym_number] = STATE(2417),
    [sym_string] = STATE(2417),
    [sym_tagged] = STATE(2417),
    [sym_context] = STATE(2417),
    [sym_elude] = STATE(2417),
    [sym_assign] = STATE(2417),
    [sym_lambda] = STATE(2417),
    [sym_or] = STATE(2417),
    [sym_not] = STATE(2417),
    [sym_and] = STATE(2417),
    [sym_cmp] = STATE(2417),
    [sym_in] = STATE(2417),
    [sym_add] = STATE(2417),
    [sym_sub] = STATE(2417),
    [sym_mul] = STATE(2417),
    [sym_div] = STATE(2417),
    [sym_sign] = STATE(2417),
    [sym_call] = STATE(2417),
    [sym_field] = STATE(2417),
    [sym_label] = STATE(2417),
    [sym_content] = STATE(2417),
    [sym_group] = STATE(2417),
    [sym_block] = STATE(2417),
    [sym_branch] = STATE(2417),
    [sym_let] = STATE(2417),
    [sym_set] = STATE(2417),
    [sym_import] = STATE(2417),
    [sym_include] = STATE(2417),
    [sym_for] = STATE(2417),
    [sym_while] = STATE(2417),
    [sym_show] = STATE(2417),
    [sym_return] = STATE(2417),
    [sym_flow] = STATE(2417),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1487),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1489),
    [sym_none] = ACTIONS(1489),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [167] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1491),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [168] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(171),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1493),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [169] = {
    [sym_raw_blck] = STATE(2492),
    [sym_raw_span] = STATE(2492),
    [sym_math] = STATE(2492),
    [sym__expr] = STATE(2492),
    [sym_ident] = STATE(2492),
    [sym_bool] = STATE(2492),
    [sym_number] = STATE(2492),
    [sym_string] = STATE(2492),
    [sym_tagged] = STATE(2492),
    [sym_context] = STATE(2492),
    [sym_elude] = STATE(2492),
    [sym_assign] = STATE(2492),
    [sym_lambda] = STATE(2492),
    [sym_or] = STATE(2492),
    [sym_not] = STATE(2492),
    [sym_and] = STATE(2492),
    [sym_cmp] = STATE(2492),
    [sym_in] = STATE(2492),
    [sym_add] = STATE(2492),
    [sym_sub] = STATE(2492),
    [sym_mul] = STATE(2492),
    [sym_div] = STATE(2492),
    [sym_sign] = STATE(2492),
    [sym_call] = STATE(2492),
    [sym_field] = STATE(2492),
    [sym_label] = STATE(2492),
    [sym_content] = STATE(2492),
    [sym_group] = STATE(2492),
    [sym_block] = STATE(2492),
    [sym_branch] = STATE(2492),
    [sym_let] = STATE(2492),
    [sym_set] = STATE(2492),
    [sym_import] = STATE(2492),
    [sym_include] = STATE(2492),
    [sym_for] = STATE(2492),
    [sym_while] = STATE(2492),
    [sym_show] = STATE(2492),
    [sym_return] = STATE(2492),
    [sym_flow] = STATE(2492),
    [aux_sym_group_repeat1] = STATE(172),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1495),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1497),
    [sym_none] = ACTIONS(1497),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [170] = {
    [sym_raw_blck] = STATE(2492),
    [sym_raw_span] = STATE(2492),
    [sym_math] = STATE(2492),
    [sym__expr] = STATE(2492),
    [sym_ident] = STATE(2492),
    [sym_bool] = STATE(2492),
    [sym_number] = STATE(2492),
    [sym_string] = STATE(2492),
    [sym_tagged] = STATE(2492),
    [sym_context] = STATE(2492),
    [sym_elude] = STATE(2492),
    [sym_assign] = STATE(2492),
    [sym_lambda] = STATE(2492),
    [sym_or] = STATE(2492),
    [sym_not] = STATE(2492),
    [sym_and] = STATE(2492),
    [sym_cmp] = STATE(2492),
    [sym_in] = STATE(2492),
    [sym_add] = STATE(2492),
    [sym_sub] = STATE(2492),
    [sym_mul] = STATE(2492),
    [sym_div] = STATE(2492),
    [sym_sign] = STATE(2492),
    [sym_call] = STATE(2492),
    [sym_field] = STATE(2492),
    [sym_label] = STATE(2492),
    [sym_content] = STATE(2492),
    [sym_group] = STATE(2492),
    [sym_block] = STATE(2492),
    [sym_branch] = STATE(2492),
    [sym_let] = STATE(2492),
    [sym_set] = STATE(2492),
    [sym_import] = STATE(2492),
    [sym_include] = STATE(2492),
    [sym_for] = STATE(2492),
    [sym_while] = STATE(2492),
    [sym_show] = STATE(2492),
    [sym_return] = STATE(2492),
    [sym_flow] = STATE(2492),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1495),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1497),
    [sym_none] = ACTIONS(1497),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [171] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1499),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [172] = {
    [sym_raw_blck] = STATE(2495),
    [sym_raw_span] = STATE(2495),
    [sym_math] = STATE(2495),
    [sym__expr] = STATE(2495),
    [sym_ident] = STATE(2495),
    [sym_bool] = STATE(2495),
    [sym_number] = STATE(2495),
    [sym_string] = STATE(2495),
    [sym_tagged] = STATE(2495),
    [sym_context] = STATE(2495),
    [sym_elude] = STATE(2495),
    [sym_assign] = STATE(2495),
    [sym_lambda] = STATE(2495),
    [sym_or] = STATE(2495),
    [sym_not] = STATE(2495),
    [sym_and] = STATE(2495),
    [sym_cmp] = STATE(2495),
    [sym_in] = STATE(2495),
    [sym_add] = STATE(2495),
    [sym_sub] = STATE(2495),
    [sym_mul] = STATE(2495),
    [sym_div] = STATE(2495),
    [sym_sign] = STATE(2495),
    [sym_call] = STATE(2495),
    [sym_field] = STATE(2495),
    [sym_label] = STATE(2495),
    [sym_content] = STATE(2495),
    [sym_group] = STATE(2495),
    [sym_block] = STATE(2495),
    [sym_branch] = STATE(2495),
    [sym_let] = STATE(2495),
    [sym_set] = STATE(2495),
    [sym_import] = STATE(2495),
    [sym_include] = STATE(2495),
    [sym_for] = STATE(2495),
    [sym_while] = STATE(2495),
    [sym_show] = STATE(2495),
    [sym_return] = STATE(2495),
    [sym_flow] = STATE(2495),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1501),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1503),
    [sym_none] = ACTIONS(1503),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [173] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1505),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [174] = {
    [sym_raw_blck] = STATE(2789),
    [sym_raw_span] = STATE(2789),
    [sym_math] = STATE(2789),
    [sym__expr] = STATE(2789),
    [sym_ident] = STATE(2789),
    [sym_bool] = STATE(2789),
    [sym_number] = STATE(2789),
    [sym_string] = STATE(2789),
    [sym_tagged] = STATE(2789),
    [sym_context] = STATE(2789),
    [sym_elude] = STATE(2789),
    [sym_assign] = STATE(2789),
    [sym_lambda] = STATE(2789),
    [sym_or] = STATE(2789),
    [sym_not] = STATE(2789),
    [sym_and] = STATE(2789),
    [sym_cmp] = STATE(2789),
    [sym_in] = STATE(2789),
    [sym_add] = STATE(2789),
    [sym_sub] = STATE(2789),
    [sym_mul] = STATE(2789),
    [sym_div] = STATE(2789),
    [sym_sign] = STATE(2789),
    [sym_call] = STATE(2789),
    [sym_field] = STATE(2789),
    [sym_label] = STATE(2789),
    [sym_content] = STATE(2789),
    [sym_group] = STATE(2789),
    [sym_block] = STATE(2789),
    [sym_branch] = STATE(2789),
    [sym_let] = STATE(2789),
    [sym_set] = STATE(2789),
    [sym_import] = STATE(2789),
    [sym_include] = STATE(2789),
    [sym_for] = STATE(2789),
    [sym_while] = STATE(2789),
    [sym_show] = STATE(2789),
    [sym_return] = STATE(2789),
    [sym_flow] = STATE(2789),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1507),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1509),
    [sym_none] = ACTIONS(1509),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [175] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(180),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1511),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [176] = {
    [sym_raw_blck] = STATE(2513),
    [sym_raw_span] = STATE(2513),
    [sym_math] = STATE(2513),
    [sym__expr] = STATE(2513),
    [sym_ident] = STATE(2513),
    [sym_bool] = STATE(2513),
    [sym_number] = STATE(2513),
    [sym_string] = STATE(2513),
    [sym_tagged] = STATE(2513),
    [sym_context] = STATE(2513),
    [sym_elude] = STATE(2513),
    [sym_assign] = STATE(2513),
    [sym_lambda] = STATE(2513),
    [sym_or] = STATE(2513),
    [sym_not] = STATE(2513),
    [sym_and] = STATE(2513),
    [sym_cmp] = STATE(2513),
    [sym_in] = STATE(2513),
    [sym_add] = STATE(2513),
    [sym_sub] = STATE(2513),
    [sym_mul] = STATE(2513),
    [sym_div] = STATE(2513),
    [sym_sign] = STATE(2513),
    [sym_call] = STATE(2513),
    [sym_field] = STATE(2513),
    [sym_label] = STATE(2513),
    [sym_content] = STATE(2513),
    [sym_group] = STATE(2513),
    [sym_block] = STATE(2513),
    [sym_branch] = STATE(2513),
    [sym_let] = STATE(2513),
    [sym_set] = STATE(2513),
    [sym_import] = STATE(2513),
    [sym_include] = STATE(2513),
    [sym_for] = STATE(2513),
    [sym_while] = STATE(2513),
    [sym_show] = STATE(2513),
    [sym_return] = STATE(2513),
    [sym_flow] = STATE(2513),
    [aux_sym_group_repeat1] = STATE(182),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1513),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1515),
    [sym_none] = ACTIONS(1515),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [177] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(173),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1517),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_show] = ACTIONS(885),
    [anon_sym_return] = ACTIONS(887),
    [anon_sym_break] = ACTIONS(889),
    [anon_sym_continue] = ACTIONS(889),
    [sym_auto] = ACTIONS(1279),
    [sym_none] = ACTIONS(1279),
    [sym__token_content] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [178] = {
    [sym_raw_blck] = STATE(2513),
    [sym_raw_span] = STATE(2513),
    [sym_math] = STATE(2513),
    [sym__expr] = STATE(2513),
    [sym_ident] = STATE(2513),
    [sym_bool] = STATE(2513),
    [sym_number] = STATE(2513),
    [sym_string] = STATE(2513),
    [sym_tagged] = STATE(2513),
    [sym_context] = STATE(2513),
    [sym_elude] = STATE(2513),
    [sym_assign] = STATE(2513),
    [sym_lambda] = STATE(2513),
    [sym_or] = STATE(2513),
    [sym_not] = STATE(2513),
    [sym_and] = STATE(2513),
    [sym_cmp] = STATE(2513),
    [sym_in] = STATE(2513),
    [sym_add] = STATE(2513),
    [sym_sub] = STATE(2513),
    [sym_mul] = STATE(2513),
    [sym_div] = STATE(2513),
    [sym_sign] = STATE(2513),
    [sym_call] = STATE(2513),
    [sym_field] = STATE(2513),
    [sym_label] = STATE(2513),
    [sym_content] = STATE(2513),
    [sym_group] = STATE(2513),
    [sym_block] = STATE(2513),
    [sym_branch] = STATE(2513),
    [sym_let] = STATE(2513),
    [sym_set] = STATE(2513),
    [sym_import] = STATE(2513),
    [sym_include] = STATE(2513),
    [sym_for] = STATE(2513),
    [sym_while] = STATE(2513),
    [sym_show] = STATE(2513),
    [sym_return] = STATE(2513),
    [sym_flow] = STATE(2513),
    [aux_sym_group_repeat1] = STATE(197),
    [sym__identifier] = ACTIONS(601),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(603),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(607),
    [anon_sym_true] = ACTIONS(609),
    [anon_sym_false] = ACTIONS(609),
    [aux_sym_number_token1] = ACTIONS(611),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_context] = ACTIONS(615),
    [anon_sym_DOT_DOT] = ACTIONS(617),
    [anon_sym_not] = ACTIONS(827),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_LPAREN] = ACTIONS(619),
    [anon_sym_RPAREN] = ACTIONS(1513),
    [anon_sym_LBRACE] = ACTIONS(621),
    [anon_sym_if] = ACTIONS(623),
    [anon_sym_let] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(627),
    [anon_sym_import] = ACTIONS(629),
    [anon_sym_include] = ACTIONS(631),
    [anon_sym_for] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(635),
    [anon_sym_show] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(639),
    [anon_sym_break] = ACTIONS(641),
    [anon_sym_continue] = ACTIONS(641),
    [sym_auto] = ACTIONS(1515),
    [sym_none] = ACTIONS(1515),
    [sym__token_content] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [sym__sp] = ACTIONS(3),
  },
  [179] = {
    [sym_raw_blck] = STATE(2868),
    [sym_raw_span] = STATE(2868),
    [sym_math] = STATE(2868),
    [sym__expr] = STATE(2868),
    [sym_ident] = STATE(2868),
    [sym_bool] = STATE(2868),
    [sym_number] = STATE(2868),
    [sym_string] = STATE(2868),
    [sym_tagged] = STATE(2868),
    [sym_context] = STATE(2868),
    [sym_elude] = STATE(2868),
    [sym_assign] = STATE(2868),
    [sym_lambda] = STATE(2868),
    [sym_or] = STATE(2868),
    [sym_not] = STATE(2868),
    [sym_and] = STATE(2868),
    [sym_cmp] = STATE(2868),
    [sym_in] = STATE(2868),
    [sym_add] = STATE(2868),
    [sym_sub] = STATE(2868),
    [sym_mul] = STATE(2868),
    [sym_div] = STATE(2868),
    [sym_sign] = STATE(2868),
    [sym_call] = STATE(2868),
    [sym_field] = STATE(2868),
    [sym_label] = STATE(2868),
    [sym_content] = STATE(2868),
    [sym_group] = STATE(2868),
    [sym_block] = STATE(2868),
    [sym_branch] = STATE(2868),
    [sym_let] = STATE(2868),
    [sym_set] = STATE(2868),
    [sym_import] = STATE(2868),
    [sym_include] = STATE(2868),
    [sym_for] = STATE(2868),
    [sym_while] = STATE(2868),
    [sym_show] = STATE(2868),
    [sym_return] = STATE(2868),
    [sym_flow] = STATE(2868),
    [aux_sym_block_repeat1] = STATE(201),
    [sym__identifier] = ACTIONS(849),
    [sym__lb] = ACTIONS(3),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(851),
    [anon_sym_BQUOTE] = ACTIONS(853),
    [anon_sym_DOLLAR] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(857),
    [anon_sym_false] = ACTIONS(857),
    [aux_sym_number_token1] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_context] = ACTIONS(863),
    [anon_sym_DOT_DOT] = ACTIONS(865),
    [anon_sym_not] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_PLUS] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(1275),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_LBRACE] = ACTIONS(869),
    [anon_sym_RBRACE] = ACTIONS(1519),
    [anon_sym_if] = ACTIONS(871),
    [anon_sym_let] = ACTIONS(873),
    [anon_sym_set] = ACTIONS(875),
    [anon_sym_import] = ACTIONS(877),
    [anon_sym_include] = ACTIONS(879),
    [anon_sym_for] = ACTIONS(881),
    