#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3261
#define LARGE_STATE_COUNT 1986
#define SYMBOL_COUNT 467
#define ALIAS_COUNT 1
#define TOKEN_COUNT 330
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 52
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 91

enum {
  sym_command_name = 1,
  sym__whitespace = 2,
  sym_line_comment = 3,
  anon_sym_BSLASHiffalse = 4,
  anon_sym_BSLASHfi = 5,
  anon_sym_LBRACK = 6,
  anon_sym_RBRACK = 7,
  anon_sym_COMMA = 8,
  anon_sym_EQ = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_BSLASHpart = 12,
  anon_sym_BSLASHpart_STAR = 13,
  anon_sym_BSLASHaddpart = 14,
  anon_sym_BSLASHaddpart_STAR = 15,
  anon_sym_BSLASHchapter = 16,
  anon_sym_BSLASHchapter_STAR = 17,
  anon_sym_BSLASHaddchap = 18,
  anon_sym_BSLASHaddchap_STAR = 19,
  anon_sym_BSLASHsection = 20,
  anon_sym_BSLASHsection_STAR = 21,
  anon_sym_BSLASHaddsec = 22,
  anon_sym_BSLASHaddsec_STAR = 23,
  anon_sym_BSLASHsubsection = 24,
  anon_sym_BSLASHsubsection_STAR = 25,
  anon_sym_BSLASHsubsubsection = 26,
  anon_sym_BSLASHsubsubsection_STAR = 27,
  anon_sym_BSLASHparagraph = 28,
  anon_sym_BSLASHparagraph_STAR = 29,
  anon_sym_BSLASHsubparagraph = 30,
  anon_sym_BSLASHsubparagraph_STAR = 31,
  anon_sym_BSLASHitem = 32,
  anon_sym_BSLASHitem_STAR = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_BSLASHand = 36,
  sym_word = 37,
  sym_placeholder = 38,
  sym_path = 39,
  sym_argc = 40,
  aux_sym__glob_pattern_fragment_token1 = 41,
  anon_sym_PLUS = 42,
  anon_sym_DASH = 43,
  anon_sym_STAR = 44,
  anon_sym_SLASH = 45,
  anon_sym_CARET = 46,
  anon_sym__ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_BANG = 50,
  anon_sym_PIPE = 51,
  anon_sym_COLON = 52,
  anon_sym_SQUOTE = 53,
  anon_sym_DOLLAR_DOLLAR = 54,
  anon_sym_BSLASH_LBRACK = 55,
  anon_sym_BSLASH_RBRACK = 56,
  anon_sym_DOLLAR = 57,
  anon_sym_BSLASH_LPAREN = 58,
  anon_sym_BSLASH_RPAREN = 59,
  anon_sym_BSLASHbegin = 60,
  anon_sym_BSLASHend = 61,
  anon_sym_comment = 62,
  anon_sym_verbatim = 63,
  anon_sym_lstlisting = 64,
  anon_sym_minted = 65,
  anon_sym_pycode = 66,
  anon_sym_displaymath = 67,
  anon_sym_displaymath_STAR = 68,
  anon_sym_equation = 69,
  anon_sym_equation_STAR = 70,
  anon_sym_multline = 71,
  anon_sym_multline_STAR = 72,
  anon_sym_eqnarray = 73,
  anon_sym_eqnarray_STAR = 74,
  anon_sym_align = 75,
  anon_sym_align_STAR = 76,
  anon_sym_array = 77,
  anon_sym_array_STAR = 78,
  anon_sym_split = 79,
  anon_sym_split_STAR = 80,
  anon_sym_alignat = 81,
  anon_sym_alignat_STAR = 82,
  anon_sym_gather = 83,
  anon_sym_gather_STAR = 84,
  anon_sym_flalign = 85,
  anon_sym_flalign_STAR = 86,
  anon_sym_BSLASHtitle = 87,
  anon_sym_BSLASHauthor = 88,
  anon_sym_BSLASHusepackage = 89,
  anon_sym_BSLASHRequirePackage = 90,
  anon_sym_BSLASHdocumentclass = 91,
  anon_sym_BSLASHinclude = 92,
  anon_sym_BSLASHsubfileinclude = 93,
  anon_sym_BSLASHinput = 94,
  anon_sym_BSLASHsubfile = 95,
  anon_sym_BSLASHaddbibresource = 96,
  anon_sym_BSLASHbibliography = 97,
  anon_sym_BSLASHincludegraphics = 98,
  anon_sym_BSLASHincludesvg = 99,
  anon_sym_BSLASHincludeinkscape = 100,
  anon_sym_BSLASHverbatiminput = 101,
  anon_sym_BSLASHVerbatimInput = 102,
  anon_sym_BSLASHimport = 103,
  anon_sym_BSLASHsubimport = 104,
  anon_sym_BSLASHinputfrom = 105,
  anon_sym_BSLASHsubimportfrom = 106,
  anon_sym_BSLASHincludefrom = 107,
  anon_sym_BSLASHsubincludefrom = 108,
  anon_sym_BSLASHcaption = 109,
  anon_sym_BSLASHcite = 110,
  anon_sym_BSLASHcite_STAR = 111,
  anon_sym_BSLASHCite = 112,
  anon_sym_BSLASHnocite = 113,
  anon_sym_BSLASHcitet = 114,
  anon_sym_BSLASHcitep = 115,
  anon_sym_BSLASHcitet_STAR = 116,
  anon_sym_BSLASHcitep_STAR = 117,
  anon_sym_BSLASHciteauthor = 118,
  anon_sym_BSLASHciteauthor_STAR = 119,
  anon_sym_BSLASHCiteauthor = 120,
  anon_sym_BSLASHCiteauthor_STAR = 121,
  anon_sym_BSLASHcitetitle = 122,
  anon_sym_BSLASHcitetitle_STAR = 123,
  anon_sym_BSLASHciteyear = 124,
  anon_sym_BSLASHciteyear_STAR = 125,
  anon_sym_BSLASHcitedate = 126,
  anon_sym_BSLASHcitedate_STAR = 127,
  anon_sym_BSLASHciteurl = 128,
  anon_sym_BSLASHfullcite = 129,
  anon_sym_BSLASHciteyearpar = 130,
  anon_sym_BSLASHcitealt = 131,
  anon_sym_BSLASHcitealp = 132,
  anon_sym_BSLASHcitetext = 133,
  anon_sym_BSLASHparencite = 134,
  anon_sym_BSLASHparencite_STAR = 135,
  anon_sym_BSLASHParencite = 136,
  anon_sym_BSLASHfootcite = 137,
  anon_sym_BSLASHfootfullcite = 138,
  anon_sym_BSLASHfootcitetext = 139,
  anon_sym_BSLASHtextcite = 140,
  anon_sym_BSLASHTextcite = 141,
  anon_sym_BSLASHsmartcite = 142,
  anon_sym_BSLASHSmartcite = 143,
  anon_sym_BSLASHsupercite = 144,
  anon_sym_BSLASHautocite = 145,
  anon_sym_BSLASHAutocite = 146,
  anon_sym_BSLASHautocite_STAR = 147,
  anon_sym_BSLASHAutocite_STAR = 148,
  anon_sym_BSLASHvolcite = 149,
  anon_sym_BSLASHVolcite = 150,
  anon_sym_BSLASHpvolcite = 151,
  anon_sym_BSLASHPvolcite = 152,
  anon_sym_BSLASHfvolcite = 153,
  anon_sym_BSLASHftvolcite = 154,
  anon_sym_BSLASHsvolcite = 155,
  anon_sym_BSLASHSvolcite = 156,
  anon_sym_BSLASHtvolcite = 157,
  anon_sym_BSLASHTvolcite = 158,
  anon_sym_BSLASHavolcite = 159,
  anon_sym_BSLASHAvolcite = 160,
  anon_sym_BSLASHnotecite = 161,
  anon_sym_BSLASHNotecite = 162,
  anon_sym_BSLASHpnotecite = 163,
  anon_sym_BSLASHPnotecite = 164,
  anon_sym_BSLASHfnotecite = 165,
  anon_sym_BSLASHlabel = 166,
  anon_sym_BSLASHref = 167,
  anon_sym_BSLASHeqref = 168,
  anon_sym_BSLASHvref = 169,
  anon_sym_BSLASHVref = 170,
  anon_sym_BSLASHautoref = 171,
  anon_sym_BSLASHpageref = 172,
  anon_sym_BSLASHcref = 173,
  anon_sym_BSLASHCref = 174,
  anon_sym_BSLASHcref_STAR = 175,
  anon_sym_BSLASHCref_STAR = 176,
  anon_sym_BSLASHnamecref = 177,
  anon_sym_BSLASHnameCref = 178,
  anon_sym_BSLASHlcnamecref = 179,
  anon_sym_BSLASHnamecrefs = 180,
  anon_sym_BSLASHnameCrefs = 181,
  anon_sym_BSLASHlcnamecrefs = 182,
  anon_sym_BSLASHlabelcref = 183,
  anon_sym_BSLASHlabelcpageref = 184,
  anon_sym_BSLASHcrefrange = 185,
  anon_sym_BSLASHcrefrange_STAR = 186,
  anon_sym_BSLASHCrefrange = 187,
  anon_sym_BSLASHCrefrange_STAR = 188,
  anon_sym_BSLASHnewlabel = 189,
  anon_sym_BSLASHnewcommand = 190,
  anon_sym_BSLASHnewcommand_STAR = 191,
  anon_sym_BSLASHrenewcommand = 192,
  anon_sym_BSLASHrenewcommand_STAR = 193,
  anon_sym_BSLASHDeclareRobustCommand = 194,
  anon_sym_BSLASHDeclareRobustCommand_STAR = 195,
  anon_sym_BSLASHDeclareMathOperator = 196,
  anon_sym_BSLASHDeclareMathOperator_STAR = 197,
  anon_sym_BSLASHdef = 198,
  anon_sym_BSLASHlet = 199,
  anon_sym_BSLASHleft = 200,
  anon_sym_BSLASHbig = 201,
  anon_sym_BSLASHBig = 202,
  anon_sym_BSLASHbigg = 203,
  anon_sym_BSLASHBigg = 204,
  anon_sym_BSLASHbigl = 205,
  anon_sym_BSLASHBigl = 206,
  anon_sym_BSLASHbiggl = 207,
  anon_sym_BSLASHBiggl = 208,
  anon_sym_BSLASHright = 209,
  anon_sym_BSLASHbigr = 210,
  anon_sym_BSLASHBigr = 211,
  anon_sym_BSLASHbiggr = 212,
  anon_sym_BSLASHBiggr = 213,
  anon_sym_BSLASHDeclarePairedDelimiter = 214,
  anon_sym_BSLASHDeclarePairedDelimiterX = 215,
  anon_sym_BSLASHnewenvironment = 216,
  anon_sym_BSLASHrenewenvironment = 217,
  anon_sym_BSLASHnewglossaryentry = 218,
  anon_sym_BSLASHgls = 219,
  anon_sym_BSLASHGls = 220,
  anon_sym_BSLASHGLS = 221,
  anon_sym_BSLASHglspl = 222,
  anon_sym_BSLASHGlspl = 223,
  anon_sym_BSLASHGLSpl = 224,
  anon_sym_BSLASHglsdisp = 225,
  anon_sym_BSLASHglslink = 226,
  anon_sym_BSLASHglstext = 227,
  anon_sym_BSLASHGlstext = 228,
  anon_sym_BSLASHGLStext = 229,
  anon_sym_BSLASHglsfirst = 230,
  anon_sym_BSLASHGlsfirst = 231,
  anon_sym_BSLASHGLSfirst = 232,
  anon_sym_BSLASHglsplural = 233,
  anon_sym_BSLASHGlsplural = 234,
  anon_sym_BSLASHGLSplural = 235,
  anon_sym_BSLASHglsfirstplural = 236,
  anon_sym_BSLASHGlsfirstplural = 237,
  anon_sym_BSLASHGLSfirstplural = 238,
  anon_sym_BSLASHglsname = 239,
  anon_sym_BSLASHGlsname = 240,
  anon_sym_BSLASHGLSname = 241,
  anon_sym_BSLASHglssymbol = 242,
  anon_sym_BSLASHGlssymbol = 243,
  anon_sym_BSLASHglsdesc = 244,
  anon_sym_BSLASHGlsdesc = 245,
  anon_sym_BSLASHGLSdesc = 246,
  anon_sym_BSLASHglsuseri = 247,
  anon_sym_BSLASHGlsuseri = 248,
  anon_sym_BSLASHGLSuseri = 249,
  anon_sym_BSLASHglsuserii = 250,
  anon_sym_BSLASHGlsuserii = 251,
  anon_sym_BSLASHGLSuserii = 252,
  anon_sym_BSLASHglsuseriii = 253,
  anon_sym_BSLASHGlsuseriii = 254,
  anon_sym_BSLASHGLSuseriii = 255,
  anon_sym_BSLASHglsuseriv = 256,
  anon_sym_BSLASHGlsuseriv = 257,
  anon_sym_BSLASHGLSuseriv = 258,
  anon_sym_BSLASHglsuserv = 259,
  anon_sym_BSLASHGlsuserv = 260,
  anon_sym_BSLASHGLSuserv = 261,
  anon_sym_BSLASHglsuservi = 262,
  anon_sym_BSLASHGlsuservi = 263,
  anon_sym_BSLASHGLSuservi = 264,
  anon_sym_BSLASHnewacronym = 265,
  anon_sym_BSLASHacrshort = 266,
  anon_sym_BSLASHAcrshort = 267,
  anon_sym_BSLASHACRshort = 268,
  anon_sym_BSLASHacrshortpl = 269,
  anon_sym_BSLASHAcrshortpl = 270,
  anon_sym_BSLASHACRshortpl = 271,
  anon_sym_BSLASHacrlong = 272,
  anon_sym_BSLASHAcrlong = 273,
  anon_sym_BSLASHACRlong = 274,
  anon_sym_BSLASHacrlongpl = 275,
  anon_sym_BSLASHAcrlongpl = 276,
  anon_sym_BSLASHACRlongpl = 277,
  anon_sym_BSLASHacrfull = 278,
  anon_sym_BSLASHAcrfull = 279,
  anon_sym_BSLASHACRfull = 280,
  anon_sym_BSLASHacrfullpl = 281,
  anon_sym_BSLASHAcrfullpl = 282,
  anon_sym_BSLASHACRfullpl = 283,
  anon_sym_BSLASHacs = 284,
  anon_sym_BSLASHAcs = 285,
  anon_sym_BSLASHacsp = 286,
  anon_sym_BSLASHAcsp = 287,
  anon_sym_BSLASHacl = 288,
  anon_sym_BSLASHAcl = 289,
  anon_sym_BSLASHaclp = 290,
  anon_sym_BSLASHAclp = 291,
  anon_sym_BSLASHacf = 292,
  anon_sym_BSLASHAcf = 293,
  anon_sym_BSLASHacfp = 294,
  anon_sym_BSLASHAcfp = 295,
  anon_sym_BSLASHac = 296,
  anon_sym_BSLASHAc = 297,
  anon_sym_BSLASHacp = 298,
  anon_sym_BSLASHglsentrylong = 299,
  anon_sym_BSLASHGlsentrylong = 300,
  anon_sym_BSLASHglsentrylongpl = 301,
  anon_sym_BSLASHGlsentrylongpl = 302,
  anon_sym_BSLASHglsentryshort = 303,
  anon_sym_BSLASHGlsentryshort = 304,
  anon_sym_BSLASHglsentryshortpl = 305,
  anon_sym_BSLASHGlsentryshortpl = 306,
  anon_sym_BSLASHglsentryfullpl = 307,
  anon_sym_BSLASHGlsentryfullpl = 308,
  anon_sym_BSLASHnewtheorem = 309,
  anon_sym_BSLASHnewtheorem_STAR = 310,
  anon_sym_BSLASHdeclaretheorem = 311,
  anon_sym_BSLASHdeclaretheorem_STAR = 312,
  anon_sym_BSLASHdefinecolor = 313,
  anon_sym_BSLASHdefinecolorset = 314,
  anon_sym_BSLASHcolor = 315,
  anon_sym_BSLASHcolorbox = 316,
  anon_sym_BSLASHtextcolor = 317,
  anon_sym_BSLASHpagecolor = 318,
  anon_sym_BSLASHusepgflibrary = 319,
  anon_sym_BSLASHusetikzlibrary = 320,
  anon_sym_BSLASHtext = 321,
  anon_sym_BSLASHintertext = 322,
  anon_sym_shortintertext = 323,
  sym__trivia_raw_fi = 324,
  sym__trivia_raw_env_comment = 325,
  sym__trivia_raw_env_verbatim = 326,
  sym__trivia_raw_env_listing = 327,
  sym__trivia_raw_env_minted = 328,
  sym__trivia_raw_env_pycode = 329,
  sym_source_file = 330,
  sym_block_comment = 331,
  sym__root_content = 332,
  sym__flat_content = 333,
  sym__text_with_env_content = 334,
  sym__text_content = 335,
  sym__section = 336,
  sym__section_part = 337,
  sym__part_declaration = 338,
  sym_part = 339,
  sym__chapter_declaration = 340,
  sym_chapter = 341,
  sym__section_declaration = 342,
  sym_section = 343,
  sym__subsection_declaration = 344,
  sym_subsection = 345,
  sym__subsubsection_declaration = 346,
  sym_subsubsection = 347,
  sym__paragraph_declaration = 348,
  sym_paragraph = 349,
  sym__subparagraph_declaration = 350,
  sym_subparagraph = 351,
  sym__enum_itemdeclaration = 352,
  sym_enum_item = 353,
  sym_curly_group = 354,
  sym_curly_group_text = 355,
  sym_curly_group_text_list = 356,
  sym_curly_group_path = 357,
  sym_curly_group_path_list = 358,
  sym_curly_group_command_name = 359,
  sym_curly_group_key_value = 360,
  sym_curly_group_glob_pattern = 361,
  sym_curly_group_impl = 362,
  sym_curly_group_author_list = 363,
  sym_brack_group = 364,
  sym_brack_group_text = 365,
  sym_brack_group_argc = 366,
  sym_brack_group_key_value = 367,
  sym_text = 368,
  sym_glob_pattern = 369,
  sym__glob_pattern_fragment = 370,
  sym_operator = 371,
  sym_key_value_pair = 372,
  sym_value = 373,
  sym_displayed_equation = 374,
  sym_inline_formula = 375,
  sym_begin = 376,
  sym_end = 377,
  sym_generic_environment = 378,
  sym_comment_environment = 379,
  sym__comment_environment_begin = 380,
  sym__comment_environment_end = 381,
  sym__comment_environment_group = 382,
  sym__comment_environment_name = 383,
  sym_verbatim_environment = 384,
  sym__verbatim_environment_begin = 385,
  sym__verbatim_environment_end = 386,
  sym__verbatim_environment_group = 387,
  sym__verbatim_environment_name = 388,
  sym_listing_environment = 389,
  sym__listing_environment_begin = 390,
  sym__listing_environment_end = 391,
  sym__listing_environment_group = 392,
  sym__listing_environment_name = 393,
  sym_minted_environment = 394,
  sym__minted_environment_begin = 395,
  sym__minted_environment_end = 396,
  sym__minted_environment_group = 397,
  sym__minted_environment_name = 398,
  sym_pycode_environment = 399,
  sym__pycode_environment_begin = 400,
  sym__pycode_environment_end = 401,
  sym__pycode_environment_group = 402,
  sym__pycode_environment_name = 403,
  sym_math_environment = 404,
  sym__math_environment_begin = 405,
  sym__math_environment_end = 406,
  sym__math_environment_group = 407,
  sym__math_environment_name = 408,
  sym__command = 409,
  sym_generic_command = 410,
  sym_title_declaration = 411,
  sym_author_declaration = 412,
  sym_package_include = 413,
  sym_class_include = 414,
  sym_latex_include = 415,
  sym_biblatex_include = 416,
  sym_bibtex_include = 417,
  sym_graphics_include = 418,
  sym_svg_include = 419,
  sym_inkscape_include = 420,
  sym_verbatim_include = 421,
  sym_import_include = 422,
  sym_caption = 423,
  sym_citation = 424,
  sym_label_definition = 425,
  sym_label_reference = 426,
  sym_label_reference_range = 427,
  sym_label_number = 428,
  sym_new_command_definition = 429,
  sym_old_command_definition = 430,
  sym_let_command_definition = 431,
  sym__math_delimiter_part = 432,
  sym_math_delimiter = 433,
  sym_paired_delimiter_definition = 434,
  sym_environment_definition = 435,
  sym_glossary_entry_definition = 436,
  sym_glossary_entry_reference = 437,
  sym_acronym_definition = 438,
  sym_acronym_reference = 439,
  sym_theorem_definition = 440,
  sym_color_definition = 441,
  sym_color_set_definition = 442,
  sym_color_reference = 443,
  sym_tikz_library_import = 444,
  sym_text_mode = 445,
  aux_sym_source_file_repeat1 = 446,
  aux_sym__section_repeat1 = 447,
  aux_sym__section_repeat2 = 448,
  aux_sym__section_repeat3 = 449,
  aux_sym__section_repeat4 = 450,
  aux_sym__section_repeat5 = 451,
  aux_sym__section_repeat6 = 452,
  aux_sym__section_repeat7 = 453,
  aux_sym__section_repeat8 = 454,
  aux_sym_part_repeat1 = 455,
  aux_sym_curly_group_text_list_repeat1 = 456,
  aux_sym_curly_group_path_list_repeat1 = 457,
  aux_sym_curly_group_key_value_repeat1 = 458,
  aux_sym_curly_group_impl_repeat1 = 459,
  aux_sym_curly_group_author_list_repeat1 = 460,
  aux_sym_curly_group_author_list_repeat2 = 461,
  aux_sym_brack_group_repeat1 = 462,
  aux_sym_text_repeat1 = 463,
  aux_sym_glob_pattern_repeat1 = 464,
  aux_sym_value_repeat1 = 465,
  aux_sym_generic_command_repeat1 = 466,
  alias_sym_author = 467,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_command_name] = "command_name",
  [sym__whitespace] = "_whitespace",
  [sym_line_comment] = "line_comment",
  [anon_sym_BSLASHiffalse] = "\\iffalse",
  [anon_sym_BSLASHfi] = "\\fi",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BSLASHpart] = "\\part",
  [anon_sym_BSLASHpart_STAR] = "\\part*",
  [anon_sym_BSLASHaddpart] = "\\addpart",
  [anon_sym_BSLASHaddpart_STAR] = "\\addpart*",
  [anon_sym_BSLASHchapter] = "\\chapter",
  [anon_sym_BSLASHchapter_STAR] = "\\chapter*",
  [anon_sym_BSLASHaddchap] = "\\addchap",
  [anon_sym_BSLASHaddchap_STAR] = "\\addchap*",
  [anon_sym_BSLASHsection] = "\\section",
  [anon_sym_BSLASHsection_STAR] = "\\section*",
  [anon_sym_BSLASHaddsec] = "\\addsec",
  [anon_sym_BSLASHaddsec_STAR] = "\\addsec*",
  [anon_sym_BSLASHsubsection] = "\\subsection",
  [anon_sym_BSLASHsubsection_STAR] = "\\subsection*",
  [anon_sym_BSLASHsubsubsection] = "\\subsubsection",
  [anon_sym_BSLASHsubsubsection_STAR] = "\\subsubsection*",
  [anon_sym_BSLASHparagraph] = "\\paragraph",
  [anon_sym_BSLASHparagraph_STAR] = "\\paragraph*",
  [anon_sym_BSLASHsubparagraph] = "\\subparagraph",
  [anon_sym_BSLASHsubparagraph_STAR] = "\\subparagraph*",
  [anon_sym_BSLASHitem] = "\\item",
  [anon_sym_BSLASHitem_STAR] = "\\item*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_BSLASHand] = "command_name",
  [sym_word] = "word",
  [sym_placeholder] = "placeholder",
  [sym_path] = "path",
  [sym_argc] = "argc",
  [aux_sym__glob_pattern_fragment_token1] = "_glob_pattern_fragment_token1",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_PIPE] = "|",
  [anon_sym_COLON] = ":",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_BSLASH_LBRACK] = "\\[",
  [anon_sym_BSLASH_RBRACK] = "\\]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_RPAREN] = "\\)",
  [anon_sym_BSLASHbegin] = "\\begin",
  [anon_sym_BSLASHend] = "\\end",
  [anon_sym_comment] = "word",
  [anon_sym_verbatim] = "word",
  [anon_sym_lstlisting] = "word",
  [anon_sym_minted] = "word",
  [anon_sym_pycode] = "word",
  [anon_sym_displaymath] = "word",
  [anon_sym_displaymath_STAR] = "word",
  [anon_sym_equation] = "word",
  [anon_sym_equation_STAR] = "word",
  [anon_sym_multline] = "word",
  [anon_sym_multline_STAR] = "word",
  [anon_sym_eqnarray] = "word",
  [anon_sym_eqnarray_STAR] = "word",
  [anon_sym_align] = "word",
  [anon_sym_align_STAR] = "word",
  [anon_sym_array] = "word",
  [anon_sym_array_STAR] = "word",
  [anon_sym_split] = "word",
  [anon_sym_split_STAR] = "word",
  [anon_sym_alignat] = "word",
  [anon_sym_alignat_STAR] = "word",
  [anon_sym_gather] = "word",
  [anon_sym_gather_STAR] = "word",
  [anon_sym_flalign] = "word",
  [anon_sym_flalign_STAR] = "word",
  [anon_sym_BSLASHtitle] = "\\title",
  [anon_sym_BSLASHauthor] = "\\author",
  [anon_sym_BSLASHusepackage] = "\\usepackage",
  [anon_sym_BSLASHRequirePackage] = "\\RequirePackage",
  [anon_sym_BSLASHdocumentclass] = "\\documentclass",
  [anon_sym_BSLASHinclude] = "\\include",
  [anon_sym_BSLASHsubfileinclude] = "\\subfileinclude",
  [anon_sym_BSLASHinput] = "\\input",
  [anon_sym_BSLASHsubfile] = "\\subfile",
  [anon_sym_BSLASHaddbibresource] = "\\addbibresource",
  [anon_sym_BSLASHbibliography] = "\\bibliography",
  [anon_sym_BSLASHincludegraphics] = "\\includegraphics",
  [anon_sym_BSLASHincludesvg] = "\\includesvg",
  [anon_sym_BSLASHincludeinkscape] = "\\includeinkscape",
  [anon_sym_BSLASHverbatiminput] = "\\verbatiminput",
  [anon_sym_BSLASHVerbatimInput] = "\\VerbatimInput",
  [anon_sym_BSLASHimport] = "\\import",
  [anon_sym_BSLASHsubimport] = "\\subimport",
  [anon_sym_BSLASHinputfrom] = "\\inputfrom",
  [anon_sym_BSLASHsubimportfrom] = "\\subimportfrom",
  [anon_sym_BSLASHincludefrom] = "\\includefrom",
  [anon_sym_BSLASHsubincludefrom] = "\\subincludefrom",
  [anon_sym_BSLASHcaption] = "\\caption",
  [anon_sym_BSLASHcite] = "\\cite",
  [anon_sym_BSLASHcite_STAR] = "\\cite*",
  [anon_sym_BSLASHCite] = "\\Cite",
  [anon_sym_BSLASHnocite] = "\\nocite",
  [anon_sym_BSLASHcitet] = "\\citet",
  [anon_sym_BSLASHcitep] = "\\citep",
  [anon_sym_BSLASHcitet_STAR] = "\\citet*",
  [anon_sym_BSLASHcitep_STAR] = "\\citep*",
  [anon_sym_BSLASHciteauthor] = "\\citeauthor",
  [anon_sym_BSLASHciteauthor_STAR] = "\\citeauthor*",
  [anon_sym_BSLASHCiteauthor] = "\\Citeauthor",
  [anon_sym_BSLASHCiteauthor_STAR] = "\\Citeauthor*",
  [anon_sym_BSLASHcitetitle] = "\\citetitle",
  [anon_sym_BSLASHcitetitle_STAR] = "\\citetitle*",
  [anon_sym_BSLASHciteyear] = "\\citeyear",
  [anon_sym_BSLASHciteyear_STAR] = "\\citeyear*",
  [anon_sym_BSLASHcitedate] = "\\citedate",
  [anon_sym_BSLASHcitedate_STAR] = "\\citedate*",
  [anon_sym_BSLASHciteurl] = "\\citeurl",
  [anon_sym_BSLASHfullcite] = "\\fullcite",
  [anon_sym_BSLASHciteyearpar] = "\\citeyearpar",
  [anon_sym_BSLASHcitealt] = "\\citealt",
  [anon_sym_BSLASHcitealp] = "\\citealp",
  [anon_sym_BSLASHcitetext] = "\\citetext",
  [anon_sym_BSLASHparencite] = "\\parencite",
  [anon_sym_BSLASHparencite_STAR] = "\\parencite*",
  [anon_sym_BSLASHParencite] = "\\Parencite",
  [anon_sym_BSLASHfootcite] = "\\footcite",
  [anon_sym_BSLASHfootfullcite] = "\\footfullcite",
  [anon_sym_BSLASHfootcitetext] = "\\footcitetext",
  [anon_sym_BSLASHtextcite] = "\\textcite",
  [anon_sym_BSLASHTextcite] = "\\Textcite",
  [anon_sym_BSLASHsmartcite] = "\\smartcite",
  [anon_sym_BSLASHSmartcite] = "\\Smartcite",
  [anon_sym_BSLASHsupercite] = "\\supercite",
  [anon_sym_BSLASHautocite] = "\\autocite",
  [anon_sym_BSLASHAutocite] = "\\Autocite",
  [anon_sym_BSLASHautocite_STAR] = "\\autocite*",
  [anon_sym_BSLASHAutocite_STAR] = "\\Autocite*",
  [anon_sym_BSLASHvolcite] = "\\volcite",
  [anon_sym_BSLASHVolcite] = "\\Volcite",
  [anon_sym_BSLASHpvolcite] = "\\pvolcite",
  [anon_sym_BSLASHPvolcite] = "\\Pvolcite",
  [anon_sym_BSLASHfvolcite] = "\\fvolcite",
  [anon_sym_BSLASHftvolcite] = "\\ftvolcite",
  [anon_sym_BSLASHsvolcite] = "\\svolcite",
  [anon_sym_BSLASHSvolcite] = "\\Svolcite",
  [anon_sym_BSLASHtvolcite] = "\\tvolcite",
  [anon_sym_BSLASHTvolcite] = "\\Tvolcite",
  [anon_sym_BSLASHavolcite] = "\\avolcite",
  [anon_sym_BSLASHAvolcite] = "\\Avolcite",
  [anon_sym_BSLASHnotecite] = "\\notecite",
  [anon_sym_BSLASHNotecite] = "\\Notecite",
  [anon_sym_BSLASHpnotecite] = "\\pnotecite",
  [anon_sym_BSLASHPnotecite] = "\\Pnotecite",
  [anon_sym_BSLASHfnotecite] = "\\fnotecite",
  [anon_sym_BSLASHlabel] = "\\label",
  [anon_sym_BSLASHref] = "\\ref",
  [anon_sym_BSLASHeqref] = "\\eqref",
  [anon_sym_BSLASHvref] = "\\vref",
  [anon_sym_BSLASHVref] = "\\Vref",
  [anon_sym_BSLASHautoref] = "\\autoref",
  [anon_sym_BSLASHpageref] = "\\pageref",
  [anon_sym_BSLASHcref] = "\\cref",
  [anon_sym_BSLASHCref] = "\\Cref",
  [anon_sym_BSLASHcref_STAR] = "\\cref*",
  [anon_sym_BSLASHCref_STAR] = "\\Cref*",
  [anon_sym_BSLASHnamecref] = "\\namecref",
  [anon_sym_BSLASHnameCref] = "\\nameCref",
  [anon_sym_BSLASHlcnamecref] = "\\lcnamecref",
  [anon_sym_BSLASHnamecrefs] = "\\namecrefs",
  [anon_sym_BSLASHnameCrefs] = "\\nameCrefs",
  [anon_sym_BSLASHlcnamecrefs] = "\\lcnamecrefs",
  [anon_sym_BSLASHlabelcref] = "\\labelcref",
  [anon_sym_BSLASHlabelcpageref] = "\\labelcpageref",
  [anon_sym_BSLASHcrefrange] = "\\crefrange",
  [anon_sym_BSLASHcrefrange_STAR] = "\\crefrange*",
  [anon_sym_BSLASHCrefrange] = "\\Crefrange",
  [anon_sym_BSLASHCrefrange_STAR] = "\\Crefrange*",
  [anon_sym_BSLASHnewlabel] = "\\newlabel",
  [anon_sym_BSLASHnewcommand] = "\\newcommand",
  [anon_sym_BSLASHnewcommand_STAR] = "\\newcommand*",
  [anon_sym_BSLASHrenewcommand] = "\\renewcommand",
  [anon_sym_BSLASHrenewcommand_STAR] = "\\renewcommand*",
  [anon_sym_BSLASHDeclareRobustCommand] = "\\DeclareRobustCommand",
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = "\\DeclareRobustCommand*",
  [anon_sym_BSLASHDeclareMathOperator] = "\\DeclareMathOperator",
  [anon_sym_BSLASHDeclareMathOperator_STAR] = "\\DeclareMathOperator*",
  [anon_sym_BSLASHdef] = "\\def",
  [anon_sym_BSLASHlet] = "\\let",
  [anon_sym_BSLASHleft] = "\\left",
  [anon_sym_BSLASHbig] = "\\big",
  [anon_sym_BSLASHBig] = "\\Big",
  [anon_sym_BSLASHbigg] = "\\bigg",
  [anon_sym_BSLASHBigg] = "\\Bigg",
  [anon_sym_BSLASHbigl] = "\\bigl",
  [anon_sym_BSLASHBigl] = "\\Bigl",
  [anon_sym_BSLASHbiggl] = "\\biggl",
  [anon_sym_BSLASHBiggl] = "\\Biggl",
  [anon_sym_BSLASHright] = "\\right",
  [anon_sym_BSLASHbigr] = "\\bigr",
  [anon_sym_BSLASHBigr] = "\\Bigr",
  [anon_sym_BSLASHbiggr] = "\\biggr",
  [anon_sym_BSLASHBiggr] = "\\Biggr",
  [anon_sym_BSLASHDeclarePairedDelimiter] = "\\DeclarePairedDelimiter",
  [anon_sym_BSLASHDeclarePairedDelimiterX] = "\\DeclarePairedDelimiterX",
  [anon_sym_BSLASHnewenvironment] = "\\newenvironment",
  [anon_sym_BSLASHrenewenvironment] = "\\renewenvironment",
  [anon_sym_BSLASHnewglossaryentry] = "\\newglossaryentry",
  [anon_sym_BSLASHgls] = "\\gls",
  [anon_sym_BSLASHGls] = "\\Gls",
  [anon_sym_BSLASHGLS] = "\\GLS",
  [anon_sym_BSLASHglspl] = "\\glspl",
  [anon_sym_BSLASHGlspl] = "\\Glspl",
  [anon_sym_BSLASHGLSpl] = "\\GLSpl",
  [anon_sym_BSLASHglsdisp] = "\\glsdisp",
  [anon_sym_BSLASHglslink] = "\\glslink",
  [anon_sym_BSLASHglstext] = "\\glstext",
  [anon_sym_BSLASHGlstext] = "\\Glstext",
  [anon_sym_BSLASHGLStext] = "\\GLStext",
  [anon_sym_BSLASHglsfirst] = "\\glsfirst",
  [anon_sym_BSLASHGlsfirst] = "\\Glsfirst",
  [anon_sym_BSLASHGLSfirst] = "\\GLSfirst",
  [anon_sym_BSLASHglsplural] = "\\glsplural",
  [anon_sym_BSLASHGlsplural] = "\\Glsplural",
  [anon_sym_BSLASHGLSplural] = "\\GLSplural",
  [anon_sym_BSLASHglsfirstplural] = "\\glsfirstplural",
  [anon_sym_BSLASHGlsfirstplural] = "\\Glsfirstplural",
  [anon_sym_BSLASHGLSfirstplural] = "\\GLSfirstplural",
  [anon_sym_BSLASHglsname] = "\\glsname",
  [anon_sym_BSLASHGlsname] = "\\Glsname",
  [anon_sym_BSLASHGLSname] = "\\GLSname",
  [anon_sym_BSLASHglssymbol] = "\\glssymbol",
  [anon_sym_BSLASHGlssymbol] = "\\Glssymbol",
  [anon_sym_BSLASHglsdesc] = "\\glsdesc",
  [anon_sym_BSLASHGlsdesc] = "\\Glsdesc",
  [anon_sym_BSLASHGLSdesc] = "\\GLSdesc",
  [anon_sym_BSLASHglsuseri] = "\\glsuseri",
  [anon_sym_BSLASHGlsuseri] = "\\Glsuseri",
  [anon_sym_BSLASHGLSuseri] = "\\GLSuseri",
  [anon_sym_BSLASHglsuserii] = "\\glsuserii",
  [anon_sym_BSLASHGlsuserii] = "\\Glsuserii",
  [anon_sym_BSLASHGLSuserii] = "\\GLSuserii",
  [anon_sym_BSLASHglsuseriii] = "\\glsuseriii",
  [anon_sym_BSLASHGlsuseriii] = "\\Glsuseriii",
  [anon_sym_BSLASHGLSuseriii] = "\\GLSuseriii",
  [anon_sym_BSLASHglsuseriv] = "\\glsuseriv",
  [anon_sym_BSLASHGlsuseriv] = "\\Glsuseriv",
  [anon_sym_BSLASHGLSuseriv] = "\\GLSuseriv",
  [anon_sym_BSLASHglsuserv] = "\\glsuserv",
  [anon_sym_BSLASHGlsuserv] = "\\Glsuserv",
  [anon_sym_BSLASHGLSuserv] = "\\GLSuserv",
  [anon_sym_BSLASHglsuservi] = "\\glsuservi",
  [anon_sym_BSLASHGlsuservi] = "\\Glsuservi",
  [anon_sym_BSLASHGLSuservi] = "\\GLSuservi",
  [anon_sym_BSLASHnewacronym] = "\\newacronym",
  [anon_sym_BSLASHacrshort] = "\\acrshort",
  [anon_sym_BSLASHAcrshort] = "\\Acrshort",
  [anon_sym_BSLASHACRshort] = "\\ACRshort",
  [anon_sym_BSLASHacrshortpl] = "\\acrshortpl",
  [anon_sym_BSLASHAcrshortpl] = "\\Acrshortpl",
  [anon_sym_BSLASHACRshortpl] = "\\ACRshortpl",
  [anon_sym_BSLASHacrlong] = "\\acrlong",
  [anon_sym_BSLASHAcrlong] = "\\Acrlong",
  [anon_sym_BSLASHACRlong] = "\\ACRlong",
  [anon_sym_BSLASHacrlongpl] = "\\acrlongpl",
  [anon_sym_BSLASHAcrlongpl] = "\\Acrlongpl",
  [anon_sym_BSLASHACRlongpl] = "\\ACRlongpl",
  [anon_sym_BSLASHacrfull] = "\\acrfull",
  [anon_sym_BSLASHAcrfull] = "\\Acrfull",
  [anon_sym_BSLASHACRfull] = "\\ACRfull",
  [anon_sym_BSLASHacrfullpl] = "\\acrfullpl",
  [anon_sym_BSLASHAcrfullpl] = "\\Acrfullpl",
  [anon_sym_BSLASHACRfullpl] = "\\ACRfullpl",
  [anon_sym_BSLASHacs] = "\\acs",
  [anon_sym_BSLASHAcs] = "\\Acs",
  [anon_sym_BSLASHacsp] = "\\acsp",
  [anon_sym_BSLASHAcsp] = "\\Acsp",
  [anon_sym_BSLASHacl] = "\\acl",
  [anon_sym_BSLASHAcl] = "\\Acl",
  [anon_sym_BSLASHaclp] = "\\aclp",
  [anon_sym_BSLASHAclp] = "\\Aclp",
  [anon_sym_BSLASHacf] = "\\acf",
  [anon_sym_BSLASHAcf] = "\\Acf",
  [anon_sym_BSLASHacfp] = "\\acfp",
  [anon_sym_BSLASHAcfp] = "\\Acfp",
  [anon_sym_BSLASHac] = "\\ac",
  [anon_sym_BSLASHAc] = "\\Ac",
  [anon_sym_BSLASHacp] = "\\acp",
  [anon_sym_BSLASHglsentrylong] = "\\glsentrylong",
  [anon_sym_BSLASHGlsentrylong] = "\\Glsentrylong",
  [anon_sym_BSLASHglsentrylongpl] = "\\glsentrylongpl",
  [anon_sym_BSLASHGlsentrylongpl] = "\\Glsentrylongpl",
  [anon_sym_BSLASHglsentryshort] = "\\glsentryshort",
  [anon_sym_BSLASHGlsentryshort] = "\\Glsentryshort",
  [anon_sym_BSLASHglsentryshortpl] = "\\glsentryshortpl",
  [anon_sym_BSLASHGlsentryshortpl] = "\\Glsentryshortpl",
  [anon_sym_BSLASHglsentryfullpl] = "\\glsentryfullpl",
  [anon_sym_BSLASHGlsentryfullpl] = "\\Glsentryfullpl",
  [anon_sym_BSLASHnewtheorem] = "\\newtheorem",
  [anon_sym_BSLASHnewtheorem_STAR] = "\\newtheorem*",
  [anon_sym_BSLASHdeclaretheorem] = "\\declaretheorem",
  [anon_sym_BSLASHdeclaretheorem_STAR] = "\\declaretheorem*",
  [anon_sym_BSLASHdefinecolor] = "\\definecolor",
  [anon_sym_BSLASHdefinecolorset] = "\\definecolorset",
  [anon_sym_BSLASHcolor] = "\\color",
  [anon_sym_BSLASHcolorbox] = "\\colorbox",
  [anon_sym_BSLASHtextcolor] = "\\textcolor",
  [anon_sym_BSLASHpagecolor] = "\\pagecolor",
  [anon_sym_BSLASHusepgflibrary] = "\\usepgflibrary",
  [anon_sym_BSLASHusetikzlibrary] = "\\usetikzlibrary",
  [anon_sym_BSLASHtext] = "\\text",
  [anon_sym_BSLASHintertext] = "\\intertext",
  [anon_sym_shortintertext] = "shortintertext",
  [sym__trivia_raw_fi] = "comment",
  [sym__trivia_raw_env_comment] = "comment",
  [sym__trivia_raw_env_verbatim] = "comment",
  [sym__trivia_raw_env_listing] = "source_code",
  [sym__trivia_raw_env_minted] = "source_code",
  [sym__trivia_raw_env_pycode] = "source_code",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym__root_content] = "_root_content",
  [sym__flat_content] = "_flat_content",
  [sym__text_with_env_content] = "_text_with_env_content",
  [sym__text_content] = "_text_content",
  [sym__section] = "_section",
  [sym__section_part] = "_section_part",
  [sym__part_declaration] = "_part_declaration",
  [sym_part] = "part",
  [sym__chapter_declaration] = "_chapter_declaration",
  [sym_chapter] = "chapter",
  [sym__section_declaration] = "_section_declaration",
  [sym_section] = "section",
  [sym__subsection_declaration] = "_subsection_declaration",
  [sym_subsection] = "subsection",
  [sym__subsubsection_declaration] = "_subsubsection_declaration",
  [sym_subsubsection] = "subsubsection",
  [sym__paragraph_declaration] = "_paragraph_declaration",
  [sym_paragraph] = "paragraph",
  [sym__subparagraph_declaration] = "_subparagraph_declaration",
  [sym_subparagraph] = "subparagraph",
  [sym__enum_itemdeclaration] = "_enum_itemdeclaration",
  [sym_enum_item] = "enum_item",
  [sym_curly_group] = "curly_group",
  [sym_curly_group_text] = "curly_group_text",
  [sym_curly_group_text_list] = "curly_group_text_list",
  [sym_curly_group_path] = "curly_group_path",
  [sym_curly_group_path_list] = "curly_group_path_list",
  [sym_curly_group_command_name] = "curly_group_command_name",
  [sym_curly_group_key_value] = "curly_group_key_value",
  [sym_curly_group_glob_pattern] = "curly_group_glob_pattern",
  [sym_curly_group_impl] = "curly_group_impl",
  [sym_curly_group_author_list] = "curly_group_author_list",
  [sym_brack_group] = "brack_group",
  [sym_brack_group_text] = "brack_group_text",
  [sym_brack_group_argc] = "brack_group_argc",
  [sym_brack_group_key_value] = "brack_group_key_value",
  [sym_text] = "text",
  [sym_glob_pattern] = "glob_pattern",
  [sym__glob_pattern_fragment] = "_glob_pattern_fragment",
  [sym_operator] = "operator",
  [sym_key_value_pair] = "key_value_pair",
  [sym_value] = "value",
  [sym_displayed_equation] = "displayed_equation",
  [sym_inline_formula] = "inline_formula",
  [sym_begin] = "begin",
  [sym_end] = "end",
  [sym_generic_environment] = "generic_environment",
  [sym_comment_environment] = "comment_environment",
  [sym__comment_environment_begin] = "begin",
  [sym__comment_environment_end] = "end",
  [sym__comment_environment_group] = "curly_group_text",
  [sym__comment_environment_name] = "text",
  [sym_verbatim_environment] = "verbatim_environment",
  [sym__verbatim_environment_begin] = "begin",
  [sym__verbatim_environment_end] = "end",
  [sym__verbatim_environment_group] = "curly_group_text",
  [sym__verbatim_environment_name] = "text",
  [sym_listing_environment] = "listing_environment",
  [sym__listing_environment_begin] = "begin",
  [sym__listing_environment_end] = "end",
  [sym__listing_environment_group] = "curly_group_text",
  [sym__listing_environment_name] = "text",
  [sym_minted_environment] = "minted_environment",
  [sym__minted_environment_begin] = "begin",
  [sym__minted_environment_end] = "end",
  [sym__minted_environment_group] = "curly_group_text",
  [sym__minted_environment_name] = "text",
  [sym_pycode_environment] = "pycode_environment",
  [sym__pycode_environment_begin] = "begin",
  [sym__pycode_environment_end] = "end",
  [sym__pycode_environment_group] = "curly_group_text",
  [sym__pycode_environment_name] = "text",
  [sym_math_environment] = "math_environment",
  [sym__math_environment_begin] = "begin",
  [sym__math_environment_end] = "end",
  [sym__math_environment_group] = "curly_group_text",
  [sym__math_environment_name] = "text",
  [sym__command] = "_command",
  [sym_generic_command] = "generic_command",
  [sym_title_declaration] = "title_declaration",
  [sym_author_declaration] = "author_declaration",
  [sym_package_include] = "package_include",
  [sym_class_include] = "class_include",
  [sym_latex_include] = "latex_include",
  [sym_biblatex_include] = "biblatex_include",
  [sym_bibtex_include] = "bibtex_include",
  [sym_graphics_include] = "graphics_include",
  [sym_svg_include] = "svg_include",
  [sym_inkscape_include] = "inkscape_include",
  [sym_verbatim_include] = "verbatim_include",
  [sym_import_include] = "import_include",
  [sym_caption] = "caption",
  [sym_citation] = "citation",
  [sym_label_definition] = "label_definition",
  [sym_label_reference] = "label_reference",
  [sym_label_reference_range] = "label_reference_range",
  [sym_label_number] = "label_number",
  [sym_new_command_definition] = "new_command_definition",
  [sym_old_command_definition] = "old_command_definition",
  [sym_let_command_definition] = "let_command_definition",
  [sym__math_delimiter_part] = "_math_delimiter_part",
  [sym_math_delimiter] = "math_delimiter",
  [sym_paired_delimiter_definition] = "paired_delimiter_definition",
  [sym_environment_definition] = "environment_definition",
  [sym_glossary_entry_definition] = "glossary_entry_definition",
  [sym_glossary_entry_reference] = "glossary_entry_reference",
  [sym_acronym_definition] = "acronym_definition",
  [sym_acronym_reference] = "acronym_reference",
  [sym_theorem_definition] = "theorem_definition",
  [sym_color_definition] = "color_definition",
  [sym_color_set_definition] = "color_set_definition",
  [sym_color_reference] = "color_reference",
  [sym_tikz_library_import] = "tikz_library_import",
  [sym_text_mode] = "text_mode",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__section_repeat1] = "_section_repeat1",
  [aux_sym__section_repeat2] = "_section_repeat2",
  [aux_sym__section_repeat3] = "_section_repeat3",
  [aux_sym__section_repeat4] = "_section_repeat4",
  [aux_sym__section_repeat5] = "_section_repeat5",
  [aux_sym__section_repeat6] = "_section_repeat6",
  [aux_sym__section_repeat7] = "_section_repeat7",
  [aux_sym__section_repeat8] = "_section_repeat8",
  [aux_sym_part_repeat1] = "part_repeat1",
  [aux_sym_curly_group_text_list_repeat1] = "curly_group_text_list_repeat1",
  [aux_sym_curly_group_path_list_repeat1] = "curly_group_path_list_repeat1",
  [aux_sym_curly_group_key_value_repeat1] = "curly_group_key_value_repeat1",
  [aux_sym_curly_group_impl_repeat1] = "curly_group_impl_repeat1",
  [aux_sym_curly_group_author_list_repeat1] = "curly_group_author_list_repeat1",
  [aux_sym_curly_group_author_list_repeat2] = "curly_group_author_list_repeat2",
  [aux_sym_brack_group_repeat1] = "brack_group_repeat1",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_glob_pattern_repeat1] = "glob_pattern_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym_generic_command_repeat1] = "generic_command_repeat1",
  [alias_sym_author] = "author",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_command_name] = sym_command_name,
  [sym__whitespace] = sym__whitespace,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_BSLASHiffalse] = anon_sym_BSLASHiffalse,
  [anon_sym_BSLASHfi] = anon_sym_BSLASHfi,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BSLASHpart] = anon_sym_BSLASHpart,
  [anon_sym_BSLASHpart_STAR] = anon_sym_BSLASHpart_STAR,
  [anon_sym_BSLASHaddpart] = anon_sym_BSLASHaddpart,
  [anon_sym_BSLASHaddpart_STAR] = anon_sym_BSLASHaddpart_STAR,
  [anon_sym_BSLASHchapter] = anon_sym_BSLASHchapter,
  [anon_sym_BSLASHchapter_STAR] = anon_sym_BSLASHchapter_STAR,
  [anon_sym_BSLASHaddchap] = anon_sym_BSLASHaddchap,
  [anon_sym_BSLASHaddchap_STAR] = anon_sym_BSLASHaddchap_STAR,
  [anon_sym_BSLASHsection] = anon_sym_BSLASHsection,
  [anon_sym_BSLASHsection_STAR] = anon_sym_BSLASHsection_STAR,
  [anon_sym_BSLASHaddsec] = anon_sym_BSLASHaddsec,
  [anon_sym_BSLASHaddsec_STAR] = anon_sym_BSLASHaddsec_STAR,
  [anon_sym_BSLASHsubsection] = anon_sym_BSLASHsubsection,
  [anon_sym_BSLASHsubsection_STAR] = anon_sym_BSLASHsubsection_STAR,
  [anon_sym_BSLASHsubsubsection] = anon_sym_BSLASHsubsubsection,
  [anon_sym_BSLASHsubsubsection_STAR] = anon_sym_BSLASHsubsubsection_STAR,
  [anon_sym_BSLASHparagraph] = anon_sym_BSLASHparagraph,
  [anon_sym_BSLASHparagraph_STAR] = anon_sym_BSLASHparagraph_STAR,
  [anon_sym_BSLASHsubparagraph] = anon_sym_BSLASHsubparagraph,
  [anon_sym_BSLASHsubparagraph_STAR] = anon_sym_BSLASHsubparagraph_STAR,
  [anon_sym_BSLASHitem] = anon_sym_BSLASHitem,
  [anon_sym_BSLASHitem_STAR] = anon_sym_BSLASHitem_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_BSLASHand] = sym_command_name,
  [sym_word] = sym_word,
  [sym_placeholder] = sym_placeholder,
  [sym_path] = sym_path,
  [sym_argc] = sym_argc,
  [aux_sym__glob_pattern_fragment_token1] = aux_sym__glob_pattern_fragment_token1,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_BSLASH_LBRACK] = anon_sym_BSLASH_LBRACK,
  [anon_sym_BSLASH_RBRACK] = anon_sym_BSLASH_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_RPAREN] = anon_sym_BSLASH_RPAREN,
  [anon_sym_BSLASHbegin] = anon_sym_BSLASHbegin,
  [anon_sym_BSLASHend] = anon_sym_BSLASHend,
  [anon_sym_comment] = sym_word,
  [anon_sym_verbatim] = sym_word,
  [anon_sym_lstlisting] = sym_word,
  [anon_sym_minted] = sym_word,
  [anon_sym_pycode] = sym_word,
  [anon_sym_displaymath] = sym_word,
  [anon_sym_displaymath_STAR] = sym_word,
  [anon_sym_equation] = sym_word,
  [anon_sym_equation_STAR] = sym_word,
  [anon_sym_multline] = sym_word,
  [anon_sym_multline_STAR] = sym_word,
  [anon_sym_eqnarray] = sym_word,
  [anon_sym_eqnarray_STAR] = sym_word,
  [anon_sym_align] = sym_word,
  [anon_sym_align_STAR] = sym_word,
  [anon_sym_array] = sym_word,
  [anon_sym_array_STAR] = sym_word,
  [anon_sym_split] = sym_word,
  [anon_sym_split_STAR] = sym_word,
  [anon_sym_alignat] = sym_word,
  [anon_sym_alignat_STAR] = sym_word,
  [anon_sym_gather] = sym_word,
  [anon_sym_gather_STAR] = sym_word,
  [anon_sym_flalign] = sym_word,
  [anon_sym_flalign_STAR] = sym_word,
  [anon_sym_BSLASHtitle] = anon_sym_BSLASHtitle,
  [anon_sym_BSLASHauthor] = anon_sym_BSLASHauthor,
  [anon_sym_BSLASHusepackage] = anon_sym_BSLASHusepackage,
  [anon_sym_BSLASHRequirePackage] = anon_sym_BSLASHRequirePackage,
  [anon_sym_BSLASHdocumentclass] = anon_sym_BSLASHdocumentclass,
  [anon_sym_BSLASHinclude] = anon_sym_BSLASHinclude,
  [anon_sym_BSLASHsubfileinclude] = anon_sym_BSLASHsubfileinclude,
  [anon_sym_BSLASHinput] = anon_sym_BSLASHinput,
  [anon_sym_BSLASHsubfile] = anon_sym_BSLASHsubfile,
  [anon_sym_BSLASHaddbibresource] = anon_sym_BSLASHaddbibresource,
  [anon_sym_BSLASHbibliography] = anon_sym_BSLASHbibliography,
  [anon_sym_BSLASHincludegraphics] = anon_sym_BSLASHincludegraphics,
  [anon_sym_BSLASHincludesvg] = anon_sym_BSLASHincludesvg,
  [anon_sym_BSLASHincludeinkscape] = anon_sym_BSLASHincludeinkscape,
  [anon_sym_BSLASHverbatiminput] = anon_sym_BSLASHverbatiminput,
  [anon_sym_BSLASHVerbatimInput] = anon_sym_BSLASHVerbatimInput,
  [anon_sym_BSLASHimport] = anon_sym_BSLASHimport,
  [anon_sym_BSLASHsubimport] = anon_sym_BSLASHsubimport,
  [anon_sym_BSLASHinputfrom] = anon_sym_BSLASHinputfrom,
  [anon_sym_BSLASHsubimportfrom] = anon_sym_BSLASHsubimportfrom,
  [anon_sym_BSLASHincludefrom] = anon_sym_BSLASHincludefrom,
  [anon_sym_BSLASHsubincludefrom] = anon_sym_BSLASHsubincludefrom,
  [anon_sym_BSLASHcaption] = anon_sym_BSLASHcaption,
  [anon_sym_BSLASHcite] = anon_sym_BSLASHcite,
  [anon_sym_BSLASHcite_STAR] = anon_sym_BSLASHcite_STAR,
  [anon_sym_BSLASHCite] = anon_sym_BSLASHCite,
  [anon_sym_BSLASHnocite] = anon_sym_BSLASHnocite,
  [anon_sym_BSLASHcitet] = anon_sym_BSLASHcitet,
  [anon_sym_BSLASHcitep] = anon_sym_BSLASHcitep,
  [anon_sym_BSLASHcitet_STAR] = anon_sym_BSLASHcitet_STAR,
  [anon_sym_BSLASHcitep_STAR] = anon_sym_BSLASHcitep_STAR,
  [anon_sym_BSLASHciteauthor] = anon_sym_BSLASHciteauthor,
  [anon_sym_BSLASHciteauthor_STAR] = anon_sym_BSLASHciteauthor_STAR,
  [anon_sym_BSLASHCiteauthor] = anon_sym_BSLASHCiteauthor,
  [anon_sym_BSLASHCiteauthor_STAR] = anon_sym_BSLASHCiteauthor_STAR,
  [anon_sym_BSLASHcitetitle] = anon_sym_BSLASHcitetitle,
  [anon_sym_BSLASHcitetitle_STAR] = anon_sym_BSLASHcitetitle_STAR,
  [anon_sym_BSLASHciteyear] = anon_sym_BSLASHciteyear,
  [anon_sym_BSLASHciteyear_STAR] = anon_sym_BSLASHciteyear_STAR,
  [anon_sym_BSLASHcitedate] = anon_sym_BSLASHcitedate,
  [anon_sym_BSLASHcitedate_STAR] = anon_sym_BSLASHcitedate_STAR,
  [anon_sym_BSLASHciteurl] = anon_sym_BSLASHciteurl,
  [anon_sym_BSLASHfullcite] = anon_sym_BSLASHfullcite,
  [anon_sym_BSLASHciteyearpar] = anon_sym_BSLASHciteyearpar,
  [anon_sym_BSLASHcitealt] = anon_sym_BSLASHcitealt,
  [anon_sym_BSLASHcitealp] = anon_sym_BSLASHcitealp,
  [anon_sym_BSLASHcitetext] = anon_sym_BSLASHcitetext,
  [anon_sym_BSLASHparencite] = anon_sym_BSLASHparencite,
  [anon_sym_BSLASHparencite_STAR] = anon_sym_BSLASHparencite_STAR,
  [anon_sym_BSLASHParencite] = anon_sym_BSLASHParencite,
  [anon_sym_BSLASHfootcite] = anon_sym_BSLASHfootcite,
  [anon_sym_BSLASHfootfullcite] = anon_sym_BSLASHfootfullcite,
  [anon_sym_BSLASHfootcitetext] = anon_sym_BSLASHfootcitetext,
  [anon_sym_BSLASHtextcite] = anon_sym_BSLASHtextcite,
  [anon_sym_BSLASHTextcite] = anon_sym_BSLASHTextcite,
  [anon_sym_BSLASHsmartcite] = anon_sym_BSLASHsmartcite,
  [anon_sym_BSLASHSmartcite] = anon_sym_BSLASHSmartcite,
  [anon_sym_BSLASHsupercite] = anon_sym_BSLASHsupercite,
  [anon_sym_BSLASHautocite] = anon_sym_BSLASHautocite,
  [anon_sym_BSLASHAutocite] = anon_sym_BSLASHAutocite,
  [anon_sym_BSLASHautocite_STAR] = anon_sym_BSLASHautocite_STAR,
  [anon_sym_BSLASHAutocite_STAR] = anon_sym_BSLASHAutocite_STAR,
  [anon_sym_BSLASHvolcite] = anon_sym_BSLASHvolcite,
  [anon_sym_BSLASHVolcite] = anon_sym_BSLASHVolcite,
  [anon_sym_BSLASHpvolcite] = anon_sym_BSLASHpvolcite,
  [anon_sym_BSLASHPvolcite] = anon_sym_BSLASHPvolcite,
  [anon_sym_BSLASHfvolcite] = anon_sym_BSLASHfvolcite,
  [anon_sym_BSLASHftvolcite] = anon_sym_BSLASHftvolcite,
  [anon_sym_BSLASHsvolcite] = anon_sym_BSLASHsvolcite,
  [anon_sym_BSLASHSvolcite] = anon_sym_BSLASHSvolcite,
  [anon_sym_BSLASHtvolcite] = anon_sym_BSLASHtvolcite,
  [anon_sym_BSLASHTvolcite] = anon_sym_BSLASHTvolcite,
  [anon_sym_BSLASHavolcite] = anon_sym_BSLASHavolcite,
  [anon_sym_BSLASHAvolcite] = anon_sym_BSLASHAvolcite,
  [anon_sym_BSLASHnotecite] = anon_sym_BSLASHnotecite,
  [anon_sym_BSLASHNotecite] = anon_sym_BSLASHNotecite,
  [anon_sym_BSLASHpnotecite] = anon_sym_BSLASHpnotecite,
  [anon_sym_BSLASHPnotecite] = anon_sym_BSLASHPnotecite,
  [anon_sym_BSLASHfnotecite] = anon_sym_BSLASHfnotecite,
  [anon_sym_BSLASHlabel] = anon_sym_BSLASHlabel,
  [anon_sym_BSLASHref] = anon_sym_BSLASHref,
  [anon_sym_BSLASHeqref] = anon_sym_BSLASHeqref,
  [anon_sym_BSLASHvref] = anon_sym_BSLASHvref,
  [anon_sym_BSLASHVref] = anon_sym_BSLASHVref,
  [anon_sym_BSLASHautoref] = anon_sym_BSLASHautoref,
  [anon_sym_BSLASHpageref] = anon_sym_BSLASHpageref,
  [anon_sym_BSLASHcref] = anon_sym_BSLASHcref,
  [anon_sym_BSLASHCref] = anon_sym_BSLASHCref,
  [anon_sym_BSLASHcref_STAR] = anon_sym_BSLASHcref_STAR,
  [anon_sym_BSLASHCref_STAR] = anon_sym_BSLASHCref_STAR,
  [anon_sym_BSLASHnamecref] = anon_sym_BSLASHnamecref,
  [anon_sym_BSLASHnameCref] = anon_sym_BSLASHnameCref,
  [anon_sym_BSLASHlcnamecref] = anon_sym_BSLASHlcnamecref,
  [anon_sym_BSLASHnamecrefs] = anon_sym_BSLASHnamecrefs,
  [anon_sym_BSLASHnameCrefs] = anon_sym_BSLASHnameCrefs,
  [anon_sym_BSLASHlcnamecrefs] = anon_sym_BSLASHlcnamecrefs,
  [anon_sym_BSLASHlabelcref] = anon_sym_BSLASHlabelcref,
  [anon_sym_BSLASHlabelcpageref] = anon_sym_BSLASHlabelcpageref,
  [anon_sym_BSLASHcrefrange] = anon_sym_BSLASHcrefrange,
  [anon_sym_BSLASHcrefrange_STAR] = anon_sym_BSLASHcrefrange_STAR,
  [anon_sym_BSLASHCrefrange] = anon_sym_BSLASHCrefrange,
  [anon_sym_BSLASHCrefrange_STAR] = anon_sym_BSLASHCrefrange_STAR,
  [anon_sym_BSLASHnewlabel] = anon_sym_BSLASHnewlabel,
  [anon_sym_BSLASHnewcommand] = anon_sym_BSLASHnewcommand,
  [anon_sym_BSLASHnewcommand_STAR] = anon_sym_BSLASHnewcommand_STAR,
  [anon_sym_BSLASHrenewcommand] = anon_sym_BSLASHrenewcommand,
  [anon_sym_BSLASHrenewcommand_STAR] = anon_sym_BSLASHrenewcommand_STAR,
  [anon_sym_BSLASHDeclareRobustCommand] = anon_sym_BSLASHDeclareRobustCommand,
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = anon_sym_BSLASHDeclareRobustCommand_STAR,
  [anon_sym_BSLASHDeclareMathOperator] = anon_sym_BSLASHDeclareMathOperator,
  [anon_sym_BSLASHDeclareMathOperator_STAR] = anon_sym_BSLASHDeclareMathOperator_STAR,
  [anon_sym_BSLASHdef] = anon_sym_BSLASHdef,
  [anon_sym_BSLASHlet] = anon_sym_BSLASHlet,
  [anon_sym_BSLASHleft] = anon_sym_BSLASHleft,
  [anon_sym_BSLASHbig] = anon_sym_BSLASHbig,
  [anon_sym_BSLASHBig] = anon_sym_BSLASHBig,
  [anon_sym_BSLASHbigg] = anon_sym_BSLASHbigg,
  [anon_sym_BSLASHBigg] = anon_sym_BSLASHBigg,
  [anon_sym_BSLASHbigl] = anon_sym_BSLASHbigl,
  [anon_sym_BSLASHBigl] = anon_sym_BSLASHBigl,
  [anon_sym_BSLASHbiggl] = anon_sym_BSLASHbiggl,
  [anon_sym_BSLASHBiggl] = anon_sym_BSLASHBiggl,
  [anon_sym_BSLASHright] = anon_sym_BSLASHright,
  [anon_sym_BSLASHbigr] = anon_sym_BSLASHbigr,
  [anon_sym_BSLASHBigr] = anon_sym_BSLASHBigr,
  [anon_sym_BSLASHbiggr] = anon_sym_BSLASHbiggr,
  [anon_sym_BSLASHBiggr] = anon_sym_BSLASHBiggr,
  [anon_sym_BSLASHDeclarePairedDelimiter] = anon_sym_BSLASHDeclarePairedDelimiter,
  [anon_sym_BSLASHDeclarePairedDelimiterX] = anon_sym_BSLASHDeclarePairedDelimiterX,
  [anon_sym_BSLASHnewenvironment] = anon_sym_BSLASHnewenvironment,
  [anon_sym_BSLASHrenewenvironment] = anon_sym_BSLASHrenewenvironment,
  [anon_sym_BSLASHnewglossaryentry] = anon_sym_BSLASHnewglossaryentry,
  [anon_sym_BSLASHgls] = anon_sym_BSLASHgls,
  [anon_sym_BSLASHGls] = anon_sym_BSLASHGls,
  [anon_sym_BSLASHGLS] = anon_sym_BSLASHGLS,
  [anon_sym_BSLASHglspl] = anon_sym_BSLASHglspl,
  [anon_sym_BSLASHGlspl] = anon_sym_BSLASHGlspl,
  [anon_sym_BSLASHGLSpl] = anon_sym_BSLASHGLSpl,
  [anon_sym_BSLASHglsdisp] = anon_sym_BSLASHglsdisp,
  [anon_sym_BSLASHglslink] = anon_sym_BSLASHglslink,
  [anon_sym_BSLASHglstext] = anon_sym_BSLASHglstext,
  [anon_sym_BSLASHGlstext] = anon_sym_BSLASHGlstext,
  [anon_sym_BSLASHGLStext] = anon_sym_BSLASHGLStext,
  [anon_sym_BSLASHglsfirst] = anon_sym_BSLASHglsfirst,
  [anon_sym_BSLASHGlsfirst] = anon_sym_BSLASHGlsfirst,
  [anon_sym_BSLASHGLSfirst] = anon_sym_BSLASHGLSfirst,
  [anon_sym_BSLASHglsplural] = anon_sym_BSLASHglsplural,
  [anon_sym_BSLASHGlsplural] = anon_sym_BSLASHGlsplural,
  [anon_sym_BSLASHGLSplural] = anon_sym_BSLASHGLSplural,
  [anon_sym_BSLASHglsfirstplural] = anon_sym_BSLASHglsfirstplural,
  [anon_sym_BSLASHGlsfirstplural] = anon_sym_BSLASHGlsfirstplural,
  [anon_sym_BSLASHGLSfirstplural] = anon_sym_BSLASHGLSfirstplural,
  [anon_sym_BSLASHglsname] = anon_sym_BSLASHglsname,
  [anon_sym_BSLASHGlsname] = anon_sym_BSLASHGlsname,
  [anon_sym_BSLASHGLSname] = anon_sym_BSLASHGLSname,
  [anon_sym_BSLASHglssymbol] = anon_sym_BSLASHglssymbol,
  [anon_sym_BSLASHGlssymbol] = anon_sym_BSLASHGlssymbol,
  [anon_sym_BSLASHglsdesc] = anon_sym_BSLASHglsdesc,
  [anon_sym_BSLASHGlsdesc] = anon_sym_BSLASHGlsdesc,
  [anon_sym_BSLASHGLSdesc] = anon_sym_BSLASHGLSdesc,
  [anon_sym_BSLASHglsuseri] = anon_sym_BSLASHglsuseri,
  [anon_sym_BSLASHGlsuseri] = anon_sym_BSLASHGlsuseri,
  [anon_sym_BSLASHGLSuseri] = anon_sym_BSLASHGLSuseri,
  [anon_sym_BSLASHglsuserii] = anon_sym_BSLASHglsuserii,
  [anon_sym_BSLASHGlsuserii] = anon_sym_BSLASHGlsuserii,
  [anon_sym_BSLASHGLSuserii] = anon_sym_BSLASHGLSuserii,
  [anon_sym_BSLASHglsuseriii] = anon_sym_BSLASHglsuseriii,
  [anon_sym_BSLASHGlsuseriii] = anon_sym_BSLASHGlsuseriii,
  [anon_sym_BSLASHGLSuseriii] = anon_sym_BSLASHGLSuseriii,
  [anon_sym_BSLASHglsuseriv] = anon_sym_BSLASHglsuseriv,
  [anon_sym_BSLASHGlsuseriv] = anon_sym_BSLASHGlsuseriv,
  [anon_sym_BSLASHGLSuseriv] = anon_sym_BSLASHGLSuseriv,
  [anon_sym_BSLASHglsuserv] = anon_sym_BSLASHglsuserv,
  [anon_sym_BSLASHGlsuserv] = anon_sym_BSLASHGlsuserv,
  [anon_sym_BSLASHGLSuserv] = anon_sym_BSLASHGLSuserv,
  [anon_sym_BSLASHglsuservi] = anon_sym_BSLASHglsuservi,
  [anon_sym_BSLASHGlsuservi] = anon_sym_BSLASHGlsuservi,
  [anon_sym_BSLASHGLSuservi] = anon_sym_BSLASHGLSuservi,
  [anon_sym_BSLASHnewacronym] = anon_sym_BSLASHnewacronym,
  [anon_sym_BSLASHacrshort] = anon_sym_BSLASHacrshort,
  [anon_sym_BSLASHAcrshort] = anon_sym_BSLASHAcrshort,
  [anon_sym_BSLASHACRshort] = anon_sym_BSLASHACRshort,
  [anon_sym_BSLASHacrshortpl] = anon_sym_BSLASHacrshortpl,
  [anon_sym_BSLASHAcrshortpl] = anon_sym_BSLASHAcrshortpl,
  [anon_sym_BSLASHACRshortpl] = anon_sym_BSLASHACRshortpl,
  [anon_sym_BSLASHacrlong] = anon_sym_BSLASHacrlong,
  [anon_sym_BSLASHAcrlong] = anon_sym_BSLASHAcrlong,
  [anon_sym_BSLASHACRlong] = anon_sym_BSLASHACRlong,
  [anon_sym_BSLASHacrlongpl] = anon_sym_BSLASHacrlongpl,
  [anon_sym_BSLASHAcrlongpl] = anon_sym_BSLASHAcrlongpl,
  [anon_sym_BSLASHACRlongpl] = anon_sym_BSLASHACRlongpl,
  [anon_sym_BSLASHacrfull] = anon_sym_BSLASHacrfull,
  [anon_sym_BSLASHAcrfull] = anon_sym_BSLASHAcrfull,
  [anon_sym_BSLASHACRfull] = anon_sym_BSLASHACRfull,
  [anon_sym_BSLASHacrfullpl] = anon_sym_BSLASHacrfullpl,
  [anon_sym_BSLASHAcrfullpl] = anon_sym_BSLASHAcrfullpl,
  [anon_sym_BSLASHACRfullpl] = anon_sym_BSLASHACRfullpl,
  [anon_sym_BSLASHacs] = anon_sym_BSLASHacs,
  [anon_sym_BSLASHAcs] = anon_sym_BSLASHAcs,
  [anon_sym_BSLASHacsp] = anon_sym_BSLASHacsp,
  [anon_sym_BSLASHAcsp] = anon_sym_BSLASHAcsp,
  [anon_sym_BSLASHacl] = anon_sym_BSLASHacl,
  [anon_sym_BSLASHAcl] = anon_sym_BSLASHAcl,
  [anon_sym_BSLASHaclp] = anon_sym_BSLASHaclp,
  [anon_sym_BSLASHAclp] = anon_sym_BSLASHAclp,
  [anon_sym_BSLASHacf] = anon_sym_BSLASHacf,
  [anon_sym_BSLASHAcf] = anon_sym_BSLASHAcf,
  [anon_sym_BSLASHacfp] = anon_sym_BSLASHacfp,
  [anon_sym_BSLASHAcfp] = anon_sym_BSLASHAcfp,
  [anon_sym_BSLASHac] = anon_sym_BSLASHac,
  [anon_sym_BSLASHAc] = anon_sym_BSLASHAc,
  [anon_sym_BSLASHacp] = anon_sym_BSLASHacp,
  [anon_sym_BSLASHglsentrylong] = anon_sym_BSLASHglsentrylong,
  [anon_sym_BSLASHGlsentrylong] = anon_sym_BSLASHGlsentrylong,
  [anon_sym_BSLASHglsentrylongpl] = anon_sym_BSLASHglsentrylongpl,
  [anon_sym_BSLASHGlsentrylongpl] = anon_sym_BSLASHGlsentrylongpl,
  [anon_sym_BSLASHglsentryshort] = anon_sym_BSLASHglsentryshort,
  [anon_sym_BSLASHGlsentryshort] = anon_sym_BSLASHGlsentryshort,
  [anon_sym_BSLASHglsentryshortpl] = anon_sym_BSLASHglsentryshortpl,
  [anon_sym_BSLASHGlsentryshortpl] = anon_sym_BSLASHGlsentryshortpl,
  [anon_sym_BSLASHglsentryfullpl] = anon_sym_BSLASHglsentryfullpl,
  [anon_sym_BSLASHGlsentryfullpl] = anon_sym_BSLASHGlsentryfullpl,
  [anon_sym_BSLASHnewtheorem] = anon_sym_BSLASHnewtheorem,
  [anon_sym_BSLASHnewtheorem_STAR] = anon_sym_BSLASHnewtheorem_STAR,
  [anon_sym_BSLASHdeclaretheorem] = anon_sym_BSLASHdeclaretheorem,
  [anon_sym_BSLASHdeclaretheorem_STAR] = anon_sym_BSLASHdeclaretheorem_STAR,
  [anon_sym_BSLASHdefinecolor] = anon_sym_BSLASHdefinecolor,
  [anon_sym_BSLASHdefinecolorset] = anon_sym_BSLASHdefinecolorset,
  [anon_sym_BSLASHcolor] = anon_sym_BSLASHcolor,
  [anon_sym_BSLASHcolorbox] = anon_sym_BSLASHcolorbox,
  [anon_sym_BSLASHtextcolor] = anon_sym_BSLASHtextcolor,
  [anon_sym_BSLASHpagecolor] = anon_sym_BSLASHpagecolor,
  [anon_sym_BSLASHusepgflibrary] = anon_sym_BSLASHusepgflibrary,
  [anon_sym_BSLASHusetikzlibrary] = anon_sym_BSLASHusetikzlibrary,
  [anon_sym_BSLASHtext] = anon_sym_BSLASHtext,
  [anon_sym_BSLASHintertext] = anon_sym_BSLASHintertext,
  [anon_sym_shortintertext] = anon_sym_shortintertext,
  [sym__trivia_raw_fi] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_comment] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_verbatim] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_listing] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_minted] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_pycode] = sym__trivia_raw_env_listing,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym__root_content] = sym__root_content,
  [sym__flat_content] = sym__flat_content,
  [sym__text_with_env_content] = sym__text_with_env_content,
  [sym__text_content] = sym__text_content,
  [sym__section] = sym__section,
  [sym__section_part] = sym__section_part,
  [sym__part_declaration] = sym__part_declaration,
  [sym_part] = sym_part,
  [sym__chapter_declaration] = sym__chapter_declaration,
  [sym_chapter] = sym_chapter,
  [sym__section_declaration] = sym__section_declaration,
  [sym_section] = sym_section,
  [sym__subsection_declaration] = sym__subsection_declaration,
  [sym_subsection] = sym_subsection,
  [sym__subsubsection_declaration] = sym__subsubsection_declaration,
  [sym_subsubsection] = sym_subsubsection,
  [sym__paragraph_declaration] = sym__paragraph_declaration,
  [sym_paragraph] = sym_paragraph,
  [sym__subparagraph_declaration] = sym__subparagraph_declaration,
  [sym_subparagraph] = sym_subparagraph,
  [sym__enum_itemdeclaration] = sym__enum_itemdeclaration,
  [sym_enum_item] = sym_enum_item,
  [sym_curly_group] = sym_curly_group,
  [sym_curly_group_text] = sym_curly_group_text,
  [sym_curly_group_text_list] = sym_curly_group_text_list,
  [sym_curly_group_path] = sym_curly_group_path,
  [sym_curly_group_path_list] = sym_curly_group_path_list,
  [sym_curly_group_command_name] = sym_curly_group_command_name,
  [sym_curly_group_key_value] = sym_curly_group_key_value,
  [sym_curly_group_glob_pattern] = sym_curly_group_glob_pattern,
  [sym_curly_group_impl] = sym_curly_group_impl,
  [sym_curly_group_author_list] = sym_curly_group_author_list,
  [sym_brack_group] = sym_brack_group,
  [sym_brack_group_text] = sym_brack_group_text,
  [sym_brack_group_argc] = sym_brack_group_argc,
  [sym_brack_group_key_value] = sym_brack_group_key_value,
  [sym_text] = sym_text,
  [sym_glob_pattern] = sym_glob_pattern,
  [sym__glob_pattern_fragment] = sym__glob_pattern_fragment,
  [sym_operator] = sym_operator,
  [sym_key_value_pair] = sym_key_value_pair,
  [sym_value] = sym_value,
  [sym_displayed_equation] = sym_displayed_equation,
  [sym_inline_formula] = sym_inline_formula,
  [sym_begin] = sym_begin,
  [sym_end] = sym_end,
  [sym_generic_environment] = sym_generic_environment,
  [sym_comment_environment] = sym_comment_environment,
  [sym__comment_environment_begin] = sym_begin,
  [sym__comment_environment_end] = sym_end,
  [sym__comment_environment_group] = sym_curly_group_text,
  [sym__comment_environment_name] = sym_text,
  [sym_verbatim_environment] = sym_verbatim_environment,
  [sym__verbatim_environment_begin] = sym_begin,
  [sym__verbatim_environment_end] = sym_end,
  [sym__verbatim_environment_group] = sym_curly_group_text,
  [sym__verbatim_environment_name] = sym_text,
  [sym_listing_environment] = sym_listing_environment,
  [sym__listing_environment_begin] = sym_begin,
  [sym__listing_environment_end] = sym_end,
  [sym__listing_environment_group] = sym_curly_group_text,
  [sym__listing_environment_name] = sym_text,
  [sym_minted_environment] = sym_minted_environment,
  [sym__minted_environment_begin] = sym_begin,
  [sym__minted_environment_end] = sym_end,
  [sym__minted_environment_group] = sym_curly_group_text,
  [sym__minted_environment_name] = sym_text,
  [sym_pycode_environment] = sym_pycode_environment,
  [sym__pycode_environment_begin] = sym_begin,
  [sym__pycode_environment_end] = sym_end,
  [sym__pycode_environment_group] = sym_curly_group_text,
  [sym__pycode_environment_name] = sym_text,
  [sym_math_environment] = sym_math_environment,
  [sym__math_environment_begin] = sym_begin,
  [sym__math_environment_end] = sym_end,
  [sym__math_environment_group] = sym_curly_group_text,
  [sym__math_environment_name] = sym_text,
  [sym__command] = sym__command,
  [sym_generic_command] = sym_generic_command,
  [sym_title_declaration] = sym_title_declaration,
  [sym_author_declaration] = sym_author_declaration,
  [sym_package_include] = sym_package_include,
  [sym_class_include] = sym_class_include,
  [sym_latex_include] = sym_latex_include,
  [sym_biblatex_include] = sym_biblatex_include,
  [sym_bibtex_include] = sym_bibtex_include,
  [sym_graphics_include] = sym_graphics_include,
  [sym_svg_include] = sym_svg_include,
  [sym_inkscape_include] = sym_inkscape_include,
  [sym_verbatim_include] = sym_verbatim_include,
  [sym_import_include] = sym_import_include,
  [sym_caption] = sym_caption,
  [sym_citation] = sym_citation,
  [sym_label_definition] = sym_label_definition,
  [sym_label_reference] = sym_label_reference,
  [sym_label_reference_range] = sym_label_reference_range,
  [sym_label_number] = sym_label_number,
  [sym_new_command_definition] = sym_new_command_definition,
  [sym_old_command_definition] = sym_old_command_definition,
  [sym_let_command_definition] = sym_let_command_definition,
  [sym__math_delimiter_part] = sym__math_delimiter_part,
  [sym_math_delimiter] = sym_math_delimiter,
  [sym_paired_delimiter_definition] = sym_paired_delimiter_definition,
  [sym_environment_definition] = sym_environment_definition,
  [sym_glossary_entry_definition] = sym_glossary_entry_definition,
  [sym_glossary_entry_reference] = sym_glossary_entry_reference,
  [sym_acronym_definition] = sym_acronym_definition,
  [sym_acronym_reference] = sym_acronym_reference,
  [sym_theorem_definition] = sym_theorem_definition,
  [sym_color_definition] = sym_color_definition,
  [sym_color_set_definition] = sym_color_set_definition,
  [sym_color_reference] = sym_color_reference,
  [sym_tikz_library_import] = sym_tikz_library_import,
  [sym_text_mode] = sym_text_mode,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__section_repeat1] = aux_sym__section_repeat1,
  [aux_sym__section_repeat2] = aux_sym__section_repeat2,
  [aux_sym__section_repeat3] = aux_sym__section_repeat3,
  [aux_sym__section_repeat4] = aux_sym__section_repeat4,
  [aux_sym__section_repeat5] = aux_sym__section_repeat5,
  [aux_sym__section_repeat6] = aux_sym__section_repeat6,
  [aux_sym__section_repeat7] = aux_sym__section_repeat7,
  [aux_sym__section_repeat8] = aux_sym__section_repeat8,
  [aux_sym_part_repeat1] = aux_sym_part_repeat1,
  [aux_sym_curly_group_text_list_repeat1] = aux_sym_curly_group_text_list_repeat1,
  [aux_sym_curly_group_path_list_repeat1] = aux_sym_curly_group_path_list_repeat1,
  [aux_sym_curly_group_key_value_repeat1] = aux_sym_curly_group_key_value_repeat1,
  [aux_sym_curly_group_impl_repeat1] = aux_sym_curly_group_impl_repeat1,
  [aux_sym_curly_group_author_list_repeat1] = aux_sym_curly_group_author_list_repeat1,
  [aux_sym_curly_group_author_list_repeat2] = aux_sym_curly_group_author_list_repeat2,
  [aux_sym_brack_group_repeat1] = aux_sym_brack_group_repeat1,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_glob_pattern_repeat1] = aux_sym_glob_pattern_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym_generic_command_repeat1] = aux_sym_generic_command_repeat1,
  [alias_sym_author] = alias_sym_author,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHiffalse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHand] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym_argc] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__glob_pattern_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbegin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_verbatim] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_lstlisting] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_minted] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pycode] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHtitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRequirePackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdocumentclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfileinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddbibresource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbibliography] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludegraphics] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludesvg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludeinkscape] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHverbatiminput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVerbatimInput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinputfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimportfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcaption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyearpar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHParencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupercite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHftvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHavolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHeqref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautoref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleft] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHright] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiterX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewglossaryentry] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdisp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglslink] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLStext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewacronym] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolorset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolorbox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpagecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepgflibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusetikzlibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintertext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shortintertext] = {
    .visible = true,
    .named = false,
  },
  [sym__trivia_raw_fi] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_verbatim] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_listing] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_minted] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_pycode] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__root_content] = {
    .visible = false,
    .named = true,
  },
  [sym__flat_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_with_env_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_content] = {
    .visible = false,
    .named = true,
  },
  [sym__section] = {
    .visible = false,
    .named = true,
  },
  [sym__section_part] = {
    .visible = false,
    .named = true,
  },
  [sym__part_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_part] = {
    .visible = true,
    .named = true,
  },
  [sym__chapter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_chapter] = {
    .visible = true,
    .named = true,
  },
  [sym__section_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__subsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsection] = {
    .visible = true,
    .named = true,
  },
  [sym__subsubsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsubsection] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__subparagraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subparagraph] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_itemdeclaration] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_item] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_author_list] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_argc] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__glob_pattern_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_displayed_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_formula] = {
    .visible = true,
    .named = true,
  },
  [sym_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_end] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_listing_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_minted_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_pycode_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_math_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_command] = {
    .visible = true,
    .named = true,
  },
  [sym_title_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_author_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_package_include] = {
    .visible = true,
    .named = true,
  },
  [sym_class_include] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_biblatex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_bibtex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_graphics_include] = {
    .visible = true,
    .named = true,
  },
  [sym_svg_include] = {
    .visible = true,
    .named = true,
  },
  [sym_inkscape_include] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_include] = {
    .visible = true,
    .named = true,
  },
  [sym_import_include] = {
    .visible = true,
    .named = true,
  },
  [sym_caption] = {
    .visible = true,
    .named = true,
  },
  [sym_citation] = {
    .visible = true,
    .named = true,
  },
  [sym_label_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference_range] = {
    .visible = true,
    .named = true,
  },
  [sym_label_number] = {
    .visible = true,
    .named = true,
  },
  [sym_new_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_old_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_let_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__math_delimiter_part] = {
    .visible = false,
    .named = true,
  },
  [sym_math_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_paired_delimiter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_glossary_entry_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_glossary_entry_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_set_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_tikz_library_import] = {
    .visible = true,
    .named = true,
  },
  [sym_text_mode] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_part_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_text_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_path_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_key_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_impl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brack_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glob_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_author] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arg = 1,
  field_argc = 2,
  field_authors = 3,
  field_begin = 4,
  field_body = 5,
  field_code = 6,
  field_command = 7,
  field_comment = 8,
  field_content = 9,
  field_counter = 10,
  field_declaration = 11,
  field_default = 12,
  field_directory = 13,
  field_end = 14,
  field_file = 15,
  field_from = 16,
  field_glob = 17,
  field_head = 18,
  field_implementation = 19,
  field_key = 20,
  field_keys = 21,
  field_label = 22,
  field_language = 23,
  field_left = 24,
  field_left_command = 25,
  field_left_delimiter = 26,
  field_long = 27,
  field_model = 28,
  field_name = 29,
  field_names = 30,
  field_number = 31,
  field_options = 32,
  field_pair = 33,
  field_path = 34,
  field_paths = 35,
  field_pattern = 36,
  field_postnote = 37,
  field_prenote = 38,
  field_right = 39,
  field_right_command = 40,
  field_right_delimiter = 41,
  field_short = 42,
  field_spec = 43,
  field_tail = 44,
  field_text = 45,
  field_title = 46,
  field_to = 47,
  field_toc = 48,
  field_ty = 49,
  field_value = 50,
  field_verbatim = 51,
  field_word = 52,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argc] = "argc",
  [field_authors] = "authors",
  [field_begin] = "begin",
  [field_body] = "body",
  [field_code] = "code",
  [field_command] = "command",
  [field_comment] = "comment",
  [field_content] = "content",
  [field_counter] = "counter",
  [field_declaration] = "declaration",
  [field_default] = "default",
  [field_directory] = "directory",
  [field_end] = "end",
  [field_file] = "file",
  [field_from] = "from",
  [field_glob] = "glob",
  [field_head] = "head",
  [field_implementation] = "implementation",
  [field_key] = "key",
  [field_keys] = "keys",
  [field_label] = "label",
  [field_language] = "language",
  [field_left] = "left",
  [field_left_command] = "left_command",
  [field_left_delimiter] = "left_delimiter",
  [field_long] = "long",
  [field_model] = "model",
  [field_name] = "name",
  [field_names] = "names",
  [field_number] = "number",
  [field_options] = "options",
  [field_pair] = "pair",
  [field_path] = "path",
  [field_paths] = "paths",
  [field_pattern] = "pattern",
  [field_postnote] = "postnote",
  [field_prenote] = "prenote",
  [field_right] = "right",
  [field_right_command] = "right_command",
  [field_right_delimiter] = "right_delimiter",
  [field_short] = "short",
  [field_spec] = "spec",
  [field_tail] = "tail",
  [field_text] = "text",
  [field_title] = "title",
  [field_to] = "to",
  [field_toc] = "toc",
  [field_ty] = "ty",
  [field_value] = "value",
  [field_verbatim] = "verbatim",
  [field_word] = "word",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 3},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 3},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 3},
  [14] = {.index = 24, .length = 1},
  [15] = {.index = 25, .length = 2},
  [16] = {.index = 27, .length = 2},
  [17] = {.index = 29, .length = 2},
  [18] = {.index = 31, .length = 2},
  [19] = {.index = 33, .length = 2},
  [20] = {.index = 35, .length = 1},
  [21] = {.index = 36, .length = 2},
  [22] = {.index = 38, .length = 2},
  [23] = {.index = 40, .length = 2},
  [24] = {.index = 42, .length = 2},
  [25] = {.index = 44, .length = 2},
  [26] = {.index = 46, .length = 6},
  [27] = {.index = 52, .length = 2},
  [28] = {.index = 54, .length = 3},
  [29] = {.index = 57, .length = 2},
  [30] = {.index = 59, .length = 3},
  [31] = {.index = 62, .length = 4},
  [32] = {.index = 66, .length = 2},
  [33] = {.index = 68, .length = 3},
  [34] = {.index = 71, .length = 1},
  [35] = {.index = 72, .length = 3},
  [36] = {.index = 75, .length = 3},
  [37] = {.index = 78, .length = 2},
  [38] = {.index = 80, .length = 3},
  [39] = {.index = 83, .length = 3},
  [40] = {.index = 86, .length = 3},
  [41] = {.index = 89, .length = 3},
  [42] = {.index = 92, .length = 3},
  [43] = {.index = 95, .length = 3},
  [44] = {.index = 98, .length = 3},
  [45] = {.index = 101, .length = 3},
  [46] = {.index = 104, .length = 2},
  [47] = {.index = 106, .length = 7},
  [48] = {.index = 113, .length = 7},
  [49] = {.index = 120, .length = 7},
  [50] = {.index = 127, .length = 9},
  [51] = {.index = 136, .length = 6},
  [52] = {.index = 142, .length = 1},
  [53] = {.index = 143, .length = 2},
  [54] = {.index = 145, .length = 5},
  [56] = {.index = 150, .length = 1},
  [57] = {.index = 151, .length = 1},
  [58] = {.index = 152, .length = 1},
  [59] = {.index = 153, .length = 4},
  [60] = {.index = 157, .length = 1},
  [61] = {.index = 158, .length = 4},
  [62] = {.index = 162, .length = 3},
  [63] = {.index = 165, .length = 4},
  [64] = {.index = 169, .length = 4},
  [65] = {.index = 173, .length = 4},
  [66] = {.index = 177, .length = 4},
  [67] = {.index = 181, .length = 4},
  [68] = {.index = 185, .length = 4},
  [69] = {.index = 189, .length = 4},
  [70] = {.index = 193, .length = 4},
  [71] = {.index = 197, .length = 2},
  [72] = {.index = 199, .length = 2},
  [73] = {.index = 201, .length = 2},
  [74] = {.index = 203, .length = 2},
  [75] = {.index = 205, .length = 2},
  [76] = {.index = 207, .length = 2},
  [77] = {.index = 209, .length = 2},
  [78] = {.index = 211, .length = 1},
  [79] = {.index = 212, .length = 5},
  [80] = {.index = 217, .length = 4},
  [81] = {.index = 221, .length = 5},
  [82] = {.index = 226, .length = 5},
  [83] = {.index = 231, .length = 5},
  [84] = {.index = 236, .length = 5},
  [85] = {.index = 241, .length = 5},
  [86] = {.index = 246, .length = 5},
  [87] = {.index = 251, .length = 4},
  [88] = {.index = 255, .length = 5},
  [89] = {.index = 260, .length = 6},
  [90] = {.index = 266, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_begin, 0},
  [1] =
    {field_command, 0},
  [2] =
    {field_word, 0},
  [3] =
    {field_command, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_toc, 0, .inherited = true},
  [6] =
    {field_command, 0, .inherited = true},
    {field_label, 0, .inherited = true},
  [8] =
    {field_word, 0, .inherited = true},
  [9] =
    {field_begin, 0},
    {field_comment, 1},
  [11] =
    {field_begin, 0},
    {field_end, 1},
  [13] =
    {field_command, 0},
    {field_text, 1, .inherited = true},
    {field_toc, 1, .inherited = true},
  [16] =
    {field_text, 0},
  [17] =
    {field_command, 0},
    {field_label, 1},
  [19] =
    {field_command, 0},
    {field_name, 1},
  [21] =
    {field_command, 0},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [24] =
    {field_arg, 0},
  [25] =
    {field_arg, 1, .inherited = true},
    {field_command, 0},
  [27] =
    {field_command, 0},
    {field_text, 1},
  [29] =
    {field_authors, 1},
    {field_command, 0},
  [31] =
    {field_command, 0},
    {field_paths, 1},
  [33] =
    {field_command, 0},
    {field_path, 1},
  [35] =
    {field_glob, 1},
  [36] =
    {field_command, 0},
    {field_long, 1},
  [38] =
    {field_command, 0},
    {field_keys, 1},
  [40] =
    {field_command, 0},
    {field_names, 1},
  [42] =
    {field_command, 0},
    {field_declaration, 1},
  [44] =
    {field_command, 0},
    {field_content, 1},
  [46] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 1, .inherited = true},
    {field_end, 1},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [52] =
    {field_word, 0, .inherited = true},
    {field_word, 1, .inherited = true},
  [54] =
    {field_begin, 0},
    {field_comment, 1},
    {field_end, 2},
  [57] =
    {field_text, 1},
    {field_toc, 0},
  [59] =
    {field_command, 0},
    {field_name, 1},
    {field_options, 2},
  [62] =
    {field_command, 0},
    {field_language, 2},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [66] =
    {field_arg, 0, .inherited = true},
    {field_arg, 1, .inherited = true},
  [68] =
    {field_command, 0},
    {field_options, 1},
    {field_text, 2},
  [71] =
    {field_key, 0},
  [72] =
    {field_command, 0},
    {field_options, 1},
    {field_paths, 2},
  [75] =
    {field_command, 0},
    {field_options, 1},
    {field_path, 2},
  [78] =
    {field_glob, 2},
    {field_options, 1},
  [80] =
    {field_command, 0},
    {field_directory, 1},
    {field_file, 2},
  [83] =
    {field_command, 0},
    {field_long, 2},
    {field_short, 1},
  [86] =
    {field_command, 0},
    {field_keys, 2},
    {field_prenote, 1},
  [89] =
    {field_command, 0},
    {field_from, 1},
    {field_to, 2},
  [92] =
    {field_command, 0},
    {field_name, 1},
    {field_number, 2},
  [95] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 2},
  [98] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
  [101] =
    {field_command, 0},
    {field_name, 1},
    {field_title, 2},
  [104] =
    {field_begin, 0},
    {field_end, 2},
  [106] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_comment, 1},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [113] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_verbatim, 1},
  [120] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [127] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_language, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_options, 0, .inherited = true},
  [136] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [142] =
    {field_text, 1},
  [143] =
    {field_text, 1},
    {field_word, 1, .inherited = true},
  [145] =
    {field_command, 0},
    {field_language, 3},
    {field_name, 1},
    {field_options, 2},
    {field_text, 1, .inherited = true},
  [150] =
    {field_pair, 1},
  [151] =
    {field_path, 1},
  [152] =
    {field_pattern, 1},
  [153] =
    {field_command, 0},
    {field_keys, 3},
    {field_postnote, 2},
    {field_prenote, 1},
  [157] =
    {field_command, 1},
  [158] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [162] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [165] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 2},
    {field_right_delimiter, 3},
  [169] =
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [173] =
    {field_begin, 2},
    {field_command, 0},
    {field_end, 3},
    {field_name, 1},
  [177] =
    {field_command, 0},
    {field_long, 3},
    {field_name, 1},
    {field_short, 2},
  [181] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 1},
    {field_title, 2},
  [185] =
    {field_command, 0},
    {field_counter, 2},
    {field_name, 1},
    {field_title, 3},
  [189] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [193] =
    {field_command, 0},
    {field_model, 2},
    {field_name, 1},
    {field_spec, 3},
  [197] =
    {field_key, 0},
    {field_value, 2},
  [199] =
    {field_pair, 1},
    {field_pair, 2, .inherited = true},
  [201] =
    {field_pair, 0, .inherited = true},
    {field_pair, 1, .inherited = true},
  [203] =
    {field_path, 1},
    {field_path, 2, .inherited = true},
  [205] =
    {field_path, 0, .inherited = true},
    {field_path, 1, .inherited = true},
  [207] =
    {field_text, 1},
    {field_text, 2, .inherited = true},
  [209] =
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [211] =
    {field_value, 1},
  [212] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_default, 3},
    {field_implementation, 4},
  [217] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 3},
    {field_right_delimiter, 4},
  [221] =
    {field_body, 4},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [226] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [231] =
    {field_argc, 2},
    {field_begin, 3},
    {field_command, 0},
    {field_end, 4},
    {field_name, 1},
  [236] =
    {field_command, 0},
    {field_long, 4},
    {field_name, 2},
    {field_options, 1},
    {field_short, 3},
  [241] =
    {field_command, 0},
    {field_counter, 4},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [246] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 2},
    {field_options, 1},
    {field_title, 4},
  [251] =
    {field_command, 0},
    {field_model, 3},
    {field_name, 2},
    {field_spec, 4},
  [255] =
    {field_command, 0},
    {field_head, 2},
    {field_model, 1},
    {field_spec, 4},
    {field_tail, 3},
  [260] =
    {field_argc, 2},
    {field_body, 5},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [266] =
    {field_command, 0},
    {field_head, 3},
    {field_model, 2},
    {field_spec, 5},
    {field_tail, 4},
    {field_ty, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [55] = {
    [1] = alias_sym_author,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym_curly_group_author_list_repeat1, 2,
    aux_sym_curly_group_author_list_repeat1,
    alias_sym_author,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 2,
  [7] = 3,
  [8] = 3,
  [9] = 3,
  [10] = 10,
  [11] = 3,
  [12] = 2,
  [13] = 2,
  [14] = 2,
  [15] = 2,
  [16] = 16,
  [17] = 17,
  [18] = 3,
  [19] = 19,
  [20] = 2,
  [21] = 3,
  [22] = 22,
  [23] = 23,
  [24] = 23,
  [25] = 22,
  [26] = 23,
  [27] = 23,
  [28] = 28,
  [29] = 22,
  [30] = 22,
  [31] = 23,
  [32] = 22,
  [33] = 23,
  [34] = 22,
  [35] = 23,
  [36] = 23,
  [37] = 22,
  [38] = 22,
  [39] = 23,
  [40] = 22,
  [41] = 2,
  [42] = 23,
  [43] = 22,
  [44] = 3,
  [45] = 23,
  [46] = 3,
  [47] = 2,
  [48] = 3,
  [49] = 22,
  [50] = 2,
  [51] = 16,
  [52] = 10,
  [53] = 17,
  [54] = 16,
  [55] = 10,
  [56] = 19,
  [57] = 17,
  [58] = 19,
  [59] = 59,
  [60] = 17,
  [61] = 61,
  [62] = 19,
  [63] = 59,
  [64] = 59,
  [65] = 61,
  [66] = 59,
  [67] = 61,
  [68] = 28,
  [69] = 61,
  [70] = 61,
  [71] = 61,
  [72] = 61,
  [73] = 16,
  [74] = 16,
  [75] = 19,
  [76] = 17,
  [77] = 59,
  [78] = 10,
  [79] = 17,
  [80] = 10,
  [81] = 19,
  [82] = 10,
  [83] = 17,
  [84] = 17,
  [85] = 19,
  [86] = 59,
  [87] = 16,
  [88] = 59,
  [89] = 19,
  [90] = 10,
  [91] = 16,
  [92] = 16,
  [93] = 10,
  [94] = 94,
  [95] = 95,
  [96] = 94,
  [97] = 97,
  [98] = 94,
  [99] = 95,
  [100] = 97,
  [101] = 94,
  [102] = 102,
  [103] = 28,
  [104] = 104,
  [105] = 95,
  [106] = 102,
  [107] = 16,
  [108] = 104,
  [109] = 102,
  [110] = 97,
  [111] = 94,
  [112] = 17,
  [113] = 95,
  [114] = 16,
  [115] = 115,
  [116] = 19,
  [117] = 19,
  [118] = 115,
  [119] = 19,
  [120] = 97,
  [121] = 104,
  [122] = 102,
  [123] = 104,
  [124] = 17,
  [125] = 10,
  [126] = 102,
  [127] = 115,
  [128] = 128,
  [129] = 104,
  [130] = 95,
  [131] = 102,
  [132] = 28,
  [133] = 97,
  [134] = 10,
  [135] = 94,
  [136] = 115,
  [137] = 104,
  [138] = 95,
  [139] = 95,
  [140] = 94,
  [141] = 104,
  [142] = 115,
  [143] = 17,
  [144] = 104,
  [145] = 102,
  [146] = 115,
  [147] = 95,
  [148] = 102,
  [149] = 97,
  [150] = 94,
  [151] = 104,
  [152] = 94,
  [153] = 102,
  [154] = 97,
  [155] = 94,
  [156] = 102,
  [157] = 95,
  [158] = 104,
  [159] = 115,
  [160] = 115,
  [161] = 97,
  [162] = 95,
  [163] = 115,
  [164] = 95,
  [165] = 115,
  [166] = 94,
  [167] = 16,
  [168] = 28,
  [169] = 104,
  [170] = 10,
  [171] = 97,
  [172] = 97,
  [173] = 102,
  [174] = 174,
  [175] = 175,
  [176] = 174,
  [177] = 177,
  [178] = 178,
  [179] = 175,
  [180] = 174,
  [181] = 174,
  [182] = 175,
  [183] = 175,
  [184] = 174,
  [185] = 175,
  [186] = 178,
  [187] = 187,
  [188] = 177,
  [189] = 189,
  [190] = 178,
  [191] = 177,
  [192] = 177,
  [193] = 178,
  [194] = 178,
  [195] = 177,
  [196] = 196,
  [197] = 189,
  [198] = 187,
  [199] = 199,
  [200] = 189,
  [201] = 187,
  [202] = 187,
  [203] = 189,
  [204] = 187,
  [205] = 189,
  [206] = 196,
  [207] = 207,
  [208] = 208,
  [209] = 199,
  [210] = 199,
  [211] = 196,
  [212] = 196,
  [213] = 199,
  [214] = 199,
  [215] = 196,
  [216] = 208,
  [217] = 217,
  [218] = 207,
  [219] = 219,
  [220] = 208,
  [221] = 208,
  [222] = 207,
  [223] = 208,
  [224] = 207,
  [225] = 207,
  [226] = 219,
  [227] = 227,
  [228] = 228,
  [229] = 217,
  [230] = 217,
  [231] = 219,
  [232] = 219,
  [233] = 217,
  [234] = 217,
  [235] = 219,
  [236] = 228,
  [237] = 227,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 228,
  [242] = 227,
  [243] = 227,
  [244] = 227,
  [245] = 228,
  [246] = 228,
  [247] = 238,
  [248] = 240,
  [249] = 239,
  [250] = 239,
  [251] = 239,
  [252] = 240,
  [253] = 238,
  [254] = 238,
  [255] = 240,
  [256] = 240,
  [257] = 239,
  [258] = 238,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 261,
  [263] = 263,
  [264] = 261,
  [265] = 263,
  [266] = 261,
  [267] = 263,
  [268] = 261,
  [269] = 261,
  [270] = 263,
  [271] = 261,
  [272] = 263,
  [273] = 263,
  [274] = 263,
  [275] = 238,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 259,
  [280] = 276,
  [281] = 278,
  [282] = 260,
  [283] = 278,
  [284] = 276,
  [285] = 260,
  [286] = 260,
  [287] = 259,
  [288] = 259,
  [289] = 259,
  [290] = 260,
  [291] = 291,
  [292] = 291,
  [293] = 293,
  [294] = 291,
  [295] = 295,
  [296] = 291,
  [297] = 291,
  [298] = 298,
  [299] = 298,
  [300] = 291,
  [301] = 298,
  [302] = 291,
  [303] = 298,
  [304] = 291,
  [305] = 298,
  [306] = 298,
  [307] = 291,
  [308] = 291,
  [309] = 298,
  [310] = 298,
  [311] = 298,
  [312] = 298,
  [313] = 291,
  [314] = 298,
  [315] = 315,
  [316] = 316,
  [317] = 315,
  [318] = 316,
  [319] = 319,
  [320] = 319,
  [321] = 321,
  [322] = 319,
  [323] = 319,
  [324] = 319,
  [325] = 319,
  [326] = 319,
  [327] = 319,
  [328] = 319,
  [329] = 321,
  [330] = 319,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 333,
  [335] = 333,
  [336] = 333,
  [337] = 333,
  [338] = 333,
  [339] = 333,
  [340] = 333,
  [341] = 333,
  [342] = 333,
  [343] = 343,
  [344] = 259,
  [345] = 260,
  [346] = 259,
  [347] = 259,
  [348] = 260,
  [349] = 260,
  [350] = 260,
  [351] = 259,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 384,
  [444] = 444,
  [445] = 445,
  [446] = 377,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 412,
  [456] = 411,
  [457] = 410,
  [458] = 409,
  [459] = 408,
  [460] = 407,
  [461] = 406,
  [462] = 405,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 404,
  [467] = 403,
  [468] = 468,
  [469] = 402,
  [470] = 401,
  [471] = 400,
  [472] = 399,
  [473] = 398,
  [474] = 353,
  [475] = 396,
  [476] = 395,
  [477] = 393,
  [478] = 392,
  [479] = 391,
  [480] = 390,
  [481] = 389,
  [482] = 482,
  [483] = 483,
  [484] = 388,
  [485] = 387,
  [486] = 486,
  [487] = 386,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 385,
  [495] = 495,
  [496] = 419,
  [497] = 420,
  [498] = 383,
  [499] = 382,
  [500] = 381,
  [501] = 501,
  [502] = 380,
  [503] = 503,
  [504] = 413,
  [505] = 379,
  [506] = 414,
  [507] = 422,
  [508] = 352,
  [509] = 378,
  [510] = 362,
  [511] = 363,
  [512] = 512,
  [513] = 424,
  [514] = 397,
  [515] = 515,
  [516] = 516,
  [517] = 358,
  [518] = 364,
  [519] = 365,
  [520] = 376,
  [521] = 366,
  [522] = 373,
  [523] = 394,
  [524] = 416,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 354,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 415,
  [578] = 417,
  [579] = 418,
  [580] = 421,
  [581] = 425,
  [582] = 426,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 427,
  [594] = 428,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 429,
  [604] = 604,
  [605] = 375,
  [606] = 374,
  [607] = 372,
  [608] = 371,
  [609] = 370,
  [610] = 369,
  [611] = 368,
  [612] = 367,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 430,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 423,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 361,
  [636] = 360,
  [637] = 359,
  [638] = 357,
  [639] = 356,
  [640] = 355,
  [641] = 369,
  [642] = 397,
  [643] = 413,
  [644] = 412,
  [645] = 411,
  [646] = 410,
  [647] = 409,
  [648] = 408,
  [649] = 407,
  [650] = 406,
  [651] = 405,
  [652] = 432,
  [653] = 404,
  [654] = 403,
  [655] = 402,
  [656] = 401,
  [657] = 400,
  [658] = 418,
  [659] = 399,
  [660] = 422,
  [661] = 398,
  [662] = 353,
  [663] = 396,
  [664] = 395,
  [665] = 352,
  [666] = 393,
  [667] = 392,
  [668] = 391,
  [669] = 390,
  [670] = 389,
  [671] = 362,
  [672] = 388,
  [673] = 431,
  [674] = 387,
  [675] = 386,
  [676] = 385,
  [677] = 384,
  [678] = 383,
  [679] = 363,
  [680] = 382,
  [681] = 381,
  [682] = 380,
  [683] = 379,
  [684] = 378,
  [685] = 433,
  [686] = 377,
  [687] = 376,
  [688] = 424,
  [689] = 397,
  [690] = 358,
  [691] = 364,
  [692] = 365,
  [693] = 366,
  [694] = 435,
  [695] = 373,
  [696] = 354,
  [697] = 355,
  [698] = 356,
  [699] = 357,
  [700] = 359,
  [701] = 360,
  [702] = 361,
  [703] = 394,
  [704] = 416,
  [705] = 419,
  [706] = 420,
  [707] = 423,
  [708] = 430,
  [709] = 429,
  [710] = 428,
  [711] = 427,
  [712] = 426,
  [713] = 425,
  [714] = 415,
  [715] = 367,
  [716] = 368,
  [717] = 369,
  [718] = 370,
  [719] = 371,
  [720] = 372,
  [721] = 374,
  [722] = 375,
  [723] = 417,
  [724] = 421,
  [725] = 418,
  [726] = 434,
  [727] = 417,
  [728] = 415,
  [729] = 379,
  [730] = 412,
  [731] = 411,
  [732] = 410,
  [733] = 409,
  [734] = 408,
  [735] = 407,
  [736] = 365,
  [737] = 406,
  [738] = 421,
  [739] = 405,
  [740] = 413,
  [741] = 375,
  [742] = 374,
  [743] = 372,
  [744] = 371,
  [745] = 370,
  [746] = 369,
  [747] = 368,
  [748] = 367,
  [749] = 414,
  [750] = 422,
  [751] = 436,
  [752] = 352,
  [753] = 362,
  [754] = 363,
  [755] = 424,
  [756] = 414,
  [757] = 358,
  [758] = 404,
  [759] = 403,
  [760] = 361,
  [761] = 360,
  [762] = 359,
  [763] = 357,
  [764] = 376,
  [765] = 377,
  [766] = 378,
  [767] = 379,
  [768] = 380,
  [769] = 381,
  [770] = 382,
  [771] = 425,
  [772] = 383,
  [773] = 384,
  [774] = 385,
  [775] = 386,
  [776] = 387,
  [777] = 388,
  [778] = 426,
  [779] = 389,
  [780] = 390,
  [781] = 391,
  [782] = 392,
  [783] = 393,
  [784] = 427,
  [785] = 395,
  [786] = 396,
  [787] = 353,
  [788] = 398,
  [789] = 428,
  [790] = 399,
  [791] = 400,
  [792] = 401,
  [793] = 429,
  [794] = 402,
  [795] = 403,
  [796] = 430,
  [797] = 404,
  [798] = 423,
  [799] = 420,
  [800] = 356,
  [801] = 355,
  [802] = 419,
  [803] = 405,
  [804] = 406,
  [805] = 407,
  [806] = 408,
  [807] = 409,
  [808] = 410,
  [809] = 411,
  [810] = 412,
  [811] = 416,
  [812] = 354,
  [813] = 402,
  [814] = 401,
  [815] = 400,
  [816] = 394,
  [817] = 399,
  [818] = 373,
  [819] = 398,
  [820] = 353,
  [821] = 396,
  [822] = 395,
  [823] = 393,
  [824] = 392,
  [825] = 391,
  [826] = 390,
  [827] = 389,
  [828] = 364,
  [829] = 388,
  [830] = 387,
  [831] = 386,
  [832] = 385,
  [833] = 384,
  [834] = 383,
  [835] = 382,
  [836] = 381,
  [837] = 380,
  [838] = 378,
  [839] = 377,
  [840] = 376,
  [841] = 375,
  [842] = 374,
  [843] = 413,
  [844] = 414,
  [845] = 422,
  [846] = 352,
  [847] = 362,
  [848] = 363,
  [849] = 424,
  [850] = 366,
  [851] = 397,
  [852] = 358,
  [853] = 364,
  [854] = 365,
  [855] = 366,
  [856] = 373,
  [857] = 394,
  [858] = 416,
  [859] = 419,
  [860] = 420,
  [861] = 423,
  [862] = 430,
  [863] = 429,
  [864] = 428,
  [865] = 427,
  [866] = 426,
  [867] = 425,
  [868] = 421,
  [869] = 418,
  [870] = 417,
  [871] = 415,
  [872] = 372,
  [873] = 371,
  [874] = 370,
  [875] = 368,
  [876] = 367,
  [877] = 361,
  [878] = 360,
  [879] = 359,
  [880] = 357,
  [881] = 356,
  [882] = 355,
  [883] = 354,
  [884] = 433,
  [885] = 436,
  [886] = 434,
  [887] = 438,
  [888] = 437,
  [889] = 435,
  [890] = 433,
  [891] = 432,
  [892] = 432,
  [893] = 431,
  [894] = 436,
  [895] = 434,
  [896] = 441,
  [897] = 442,
  [898] = 436,
  [899] = 434,
  [900] = 432,
  [901] = 435,
  [902] = 431,
  [903] = 439,
  [904] = 435,
  [905] = 431,
  [906] = 433,
  [907] = 440,
  [908] = 576,
  [909] = 527,
  [910] = 439,
  [911] = 437,
  [912] = 440,
  [913] = 625,
  [914] = 623,
  [915] = 542,
  [916] = 441,
  [917] = 622,
  [918] = 621,
  [919] = 620,
  [920] = 483,
  [921] = 573,
  [922] = 563,
  [923] = 562,
  [924] = 561,
  [925] = 559,
  [926] = 618,
  [927] = 616,
  [928] = 615,
  [929] = 614,
  [930] = 442,
  [931] = 613,
  [932] = 604,
  [933] = 468,
  [934] = 602,
  [935] = 601,
  [936] = 600,
  [937] = 599,
  [938] = 598,
  [939] = 597,
  [940] = 596,
  [941] = 595,
  [942] = 555,
  [943] = 571,
  [944] = 554,
  [945] = 438,
  [946] = 553,
  [947] = 552,
  [948] = 535,
  [949] = 534,
  [950] = 533,
  [951] = 532,
  [952] = 531,
  [953] = 530,
  [954] = 592,
  [955] = 591,
  [956] = 590,
  [957] = 589,
  [958] = 588,
  [959] = 587,
  [960] = 586,
  [961] = 585,
  [962] = 584,
  [963] = 437,
  [964] = 583,
  [965] = 574,
  [966] = 572,
  [967] = 567,
  [968] = 570,
  [969] = 569,
  [970] = 568,
  [971] = 634,
  [972] = 442,
  [973] = 441,
  [974] = 626,
  [975] = 440,
  [976] = 439,
  [977] = 619,
  [978] = 566,
  [979] = 627,
  [980] = 565,
  [981] = 492,
  [982] = 437,
  [983] = 493,
  [984] = 495,
  [985] = 486,
  [986] = 560,
  [987] = 516,
  [988] = 515,
  [989] = 482,
  [990] = 628,
  [991] = 557,
  [992] = 556,
  [993] = 438,
  [994] = 438,
  [995] = 551,
  [996] = 550,
  [997] = 547,
  [998] = 629,
  [999] = 444,
  [1000] = 538,
  [1001] = 537,
  [1002] = 536,
  [1003] = 529,
  [1004] = 442,
  [1005] = 465,
  [1006] = 512,
  [1007] = 464,
  [1008] = 463,
  [1009] = 454,
  [1010] = 453,
  [1011] = 452,
  [1012] = 451,
  [1013] = 450,
  [1014] = 449,
  [1015] = 448,
  [1016] = 1016,
  [1017] = 501,
  [1018] = 441,
  [1019] = 503,
  [1020] = 575,
  [1021] = 539,
  [1022] = 540,
  [1023] = 541,
  [1024] = 440,
  [1025] = 526,
  [1026] = 543,
  [1027] = 544,
  [1028] = 545,
  [1029] = 546,
  [1030] = 548,
  [1031] = 549,
  [1032] = 447,
  [1033] = 630,
  [1034] = 525,
  [1035] = 445,
  [1036] = 558,
  [1037] = 488,
  [1038] = 631,
  [1039] = 489,
  [1040] = 490,
  [1041] = 491,
  [1042] = 632,
  [1043] = 439,
  [1044] = 633,
  [1045] = 528,
  [1046] = 452,
  [1047] = 557,
  [1048] = 583,
  [1049] = 560,
  [1050] = 486,
  [1051] = 495,
  [1052] = 576,
  [1053] = 493,
  [1054] = 574,
  [1055] = 492,
  [1056] = 588,
  [1057] = 565,
  [1058] = 566,
  [1059] = 567,
  [1060] = 568,
  [1061] = 569,
  [1062] = 570,
  [1063] = 571,
  [1064] = 572,
  [1065] = 574,
  [1066] = 576,
  [1067] = 583,
  [1068] = 584,
  [1069] = 585,
  [1070] = 586,
  [1071] = 587,
  [1072] = 588,
  [1073] = 589,
  [1074] = 590,
  [1075] = 591,
  [1076] = 592,
  [1077] = 586,
  [1078] = 585,
  [1079] = 515,
  [1080] = 516,
  [1081] = 448,
  [1082] = 589,
  [1083] = 590,
  [1084] = 591,
  [1085] = 571,
  [1086] = 572,
  [1087] = 482,
  [1088] = 557,
  [1089] = 556,
  [1090] = 551,
  [1091] = 550,
  [1092] = 547,
  [1093] = 444,
  [1094] = 538,
  [1095] = 537,
  [1096] = 536,
  [1097] = 529,
  [1098] = 527,
  [1099] = 465,
  [1100] = 464,
  [1101] = 463,
  [1102] = 454,
  [1103] = 453,
  [1104] = 452,
  [1105] = 451,
  [1106] = 450,
  [1107] = 449,
  [1108] = 530,
  [1109] = 531,
  [1110] = 532,
  [1111] = 533,
  [1112] = 534,
  [1113] = 535,
  [1114] = 552,
  [1115] = 553,
  [1116] = 554,
  [1117] = 468,
  [1118] = 528,
  [1119] = 491,
  [1120] = 490,
  [1121] = 489,
  [1122] = 555,
  [1123] = 488,
  [1124] = 558,
  [1125] = 595,
  [1126] = 596,
  [1127] = 597,
  [1128] = 598,
  [1129] = 599,
  [1130] = 600,
  [1131] = 601,
  [1132] = 602,
  [1133] = 559,
  [1134] = 483,
  [1135] = 526,
  [1136] = 501,
  [1137] = 604,
  [1138] = 613,
  [1139] = 614,
  [1140] = 615,
  [1141] = 616,
  [1142] = 503,
  [1143] = 618,
  [1144] = 559,
  [1145] = 561,
  [1146] = 562,
  [1147] = 563,
  [1148] = 573,
  [1149] = 619,
  [1150] = 620,
  [1151] = 621,
  [1152] = 622,
  [1153] = 570,
  [1154] = 542,
  [1155] = 512,
  [1156] = 623,
  [1157] = 575,
  [1158] = 625,
  [1159] = 626,
  [1160] = 627,
  [1161] = 628,
  [1162] = 629,
  [1163] = 630,
  [1164] = 631,
  [1165] = 632,
  [1166] = 633,
  [1167] = 634,
  [1168] = 569,
  [1169] = 568,
  [1170] = 567,
  [1171] = 566,
  [1172] = 565,
  [1173] = 539,
  [1174] = 492,
  [1175] = 493,
  [1176] = 595,
  [1177] = 596,
  [1178] = 495,
  [1179] = 486,
  [1180] = 589,
  [1181] = 1181,
  [1182] = 560,
  [1183] = 540,
  [1184] = 541,
  [1185] = 543,
  [1186] = 544,
  [1187] = 545,
  [1188] = 546,
  [1189] = 548,
  [1190] = 549,
  [1191] = 516,
  [1192] = 515,
  [1193] = 447,
  [1194] = 525,
  [1195] = 445,
  [1196] = 597,
  [1197] = 584,
  [1198] = 634,
  [1199] = 633,
  [1200] = 632,
  [1201] = 631,
  [1202] = 630,
  [1203] = 629,
  [1204] = 628,
  [1205] = 627,
  [1206] = 626,
  [1207] = 598,
  [1208] = 625,
  [1209] = 515,
  [1210] = 623,
  [1211] = 587,
  [1212] = 586,
  [1213] = 585,
  [1214] = 584,
  [1215] = 583,
  [1216] = 576,
  [1217] = 574,
  [1218] = 590,
  [1219] = 572,
  [1220] = 571,
  [1221] = 591,
  [1222] = 570,
  [1223] = 569,
  [1224] = 568,
  [1225] = 567,
  [1226] = 566,
  [1227] = 565,
  [1228] = 492,
  [1229] = 493,
  [1230] = 495,
  [1231] = 486,
  [1232] = 560,
  [1233] = 599,
  [1234] = 516,
  [1235] = 600,
  [1236] = 601,
  [1237] = 602,
  [1238] = 512,
  [1239] = 542,
  [1240] = 622,
  [1241] = 621,
  [1242] = 620,
  [1243] = 619,
  [1244] = 573,
  [1245] = 563,
  [1246] = 562,
  [1247] = 561,
  [1248] = 444,
  [1249] = 613,
  [1250] = 618,
  [1251] = 616,
  [1252] = 482,
  [1253] = 587,
  [1254] = 556,
  [1255] = 615,
  [1256] = 551,
  [1257] = 550,
  [1258] = 547,
  [1259] = 614,
  [1260] = 538,
  [1261] = 537,
  [1262] = 536,
  [1263] = 529,
  [1264] = 527,
  [1265] = 465,
  [1266] = 464,
  [1267] = 463,
  [1268] = 454,
  [1269] = 453,
  [1270] = 468,
  [1271] = 451,
  [1272] = 450,
  [1273] = 449,
  [1274] = 482,
  [1275] = 483,
  [1276] = 532,
  [1277] = 448,
  [1278] = 501,
  [1279] = 503,
  [1280] = 575,
  [1281] = 539,
  [1282] = 540,
  [1283] = 541,
  [1284] = 543,
  [1285] = 544,
  [1286] = 1286,
  [1287] = 545,
  [1288] = 554,
  [1289] = 546,
  [1290] = 604,
  [1291] = 548,
  [1292] = 613,
  [1293] = 528,
  [1294] = 614,
  [1295] = 539,
  [1296] = 615,
  [1297] = 616,
  [1298] = 618,
  [1299] = 559,
  [1300] = 561,
  [1301] = 562,
  [1302] = 563,
  [1303] = 573,
  [1304] = 619,
  [1305] = 557,
  [1306] = 620,
  [1307] = 556,
  [1308] = 621,
  [1309] = 622,
  [1310] = 553,
  [1311] = 551,
  [1312] = 542,
  [1313] = 623,
  [1314] = 625,
  [1315] = 550,
  [1316] = 549,
  [1317] = 447,
  [1318] = 604,
  [1319] = 526,
  [1320] = 483,
  [1321] = 592,
  [1322] = 602,
  [1323] = 601,
  [1324] = 626,
  [1325] = 600,
  [1326] = 599,
  [1327] = 598,
  [1328] = 525,
  [1329] = 445,
  [1330] = 597,
  [1331] = 596,
  [1332] = 595,
  [1333] = 558,
  [1334] = 488,
  [1335] = 555,
  [1336] = 489,
  [1337] = 490,
  [1338] = 491,
  [1339] = 528,
  [1340] = 468,
  [1341] = 627,
  [1342] = 554,
  [1343] = 553,
  [1344] = 552,
  [1345] = 628,
  [1346] = 547,
  [1347] = 629,
  [1348] = 444,
  [1349] = 630,
  [1350] = 631,
  [1351] = 592,
  [1352] = 632,
  [1353] = 530,
  [1354] = 535,
  [1355] = 534,
  [1356] = 491,
  [1357] = 490,
  [1358] = 489,
  [1359] = 633,
  [1360] = 488,
  [1361] = 558,
  [1362] = 634,
  [1363] = 445,
  [1364] = 538,
  [1365] = 525,
  [1366] = 552,
  [1367] = 535,
  [1368] = 534,
  [1369] = 537,
  [1370] = 533,
  [1371] = 533,
  [1372] = 526,
  [1373] = 532,
  [1374] = 531,
  [1375] = 530,
  [1376] = 447,
  [1377] = 549,
  [1378] = 536,
  [1379] = 1379,
  [1380] = 531,
  [1381] = 548,
  [1382] = 546,
  [1383] = 545,
  [1384] = 544,
  [1385] = 543,
  [1386] = 541,
  [1387] = 540,
  [1388] = 555,
  [1389] = 575,
  [1390] = 588,
  [1391] = 503,
  [1392] = 512,
  [1393] = 501,
  [1394] = 448,
  [1395] = 449,
  [1396] = 450,
  [1397] = 451,
  [1398] = 452,
  [1399] = 529,
  [1400] = 453,
  [1401] = 454,
  [1402] = 527,
  [1403] = 465,
  [1404] = 463,
  [1405] = 464,
  [1406] = 259,
  [1407] = 260,
  [1408] = 1408,
  [1409] = 1408,
  [1410] = 1408,
  [1411] = 1408,
  [1412] = 1408,
  [1413] = 1408,
  [1414] = 1408,
  [1415] = 1408,
  [1416] = 1408,
  [1417] = 1417,
  [1418] = 1408,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1420,
  [1422] = 1420,
  [1423] = 1420,
  [1424] = 1420,
  [1425] = 1420,
  [1426] = 1420,
  [1427] = 1419,
  [1428] = 1420,
  [1429] = 1420,
  [1430] = 1420,
  [1431] = 1431,
  [1432] = 1431,
  [1433] = 1433,
  [1434] = 1431,
  [1435] = 1433,
  [1436] = 1431,
  [1437] = 1433,
  [1438] = 1431,
  [1439] = 1431,
  [1440] = 1433,
  [1441] = 1433,
  [1442] = 1431,
  [1443] = 1433,
  [1444] = 1444,
  [1445] = 1433,
  [1446] = 1431,
  [1447] = 1433,
  [1448] = 1433,
  [1449] = 1431,
  [1450] = 1431,
  [1451] = 1431,
  [1452] = 1433,
  [1453] = 433,
  [1454] = 434,
  [1455] = 432,
  [1456] = 431,
  [1457] = 435,
  [1458] = 436,
  [1459] = 436,
  [1460] = 431,
  [1461] = 437,
  [1462] = 432,
  [1463] = 433,
  [1464] = 439,
  [1465] = 436,
  [1466] = 434,
  [1467] = 431,
  [1468] = 435,
  [1469] = 435,
  [1470] = 432,
  [1471] = 433,
  [1472] = 442,
  [1473] = 441,
  [1474] = 440,
  [1475] = 434,
  [1476] = 588,
  [1477] = 633,
  [1478] = 452,
  [1479] = 453,
  [1480] = 454,
  [1481] = 463,
  [1482] = 464,
  [1483] = 465,
  [1484] = 527,
  [1485] = 529,
  [1486] = 468,
  [1487] = 528,
  [1488] = 491,
  [1489] = 490,
  [1490] = 489,
  [1491] = 536,
  [1492] = 488,
  [1493] = 537,
  [1494] = 538,
  [1495] = 444,
  [1496] = 547,
  [1497] = 550,
  [1498] = 551,
  [1499] = 556,
  [1500] = 557,
  [1501] = 482,
  [1502] = 515,
  [1503] = 526,
  [1504] = 440,
  [1505] = 516,
  [1506] = 560,
  [1507] = 495,
  [1508] = 493,
  [1509] = 492,
  [1510] = 441,
  [1511] = 565,
  [1512] = 566,
  [1513] = 567,
  [1514] = 568,
  [1515] = 569,
  [1516] = 570,
  [1517] = 571,
  [1518] = 572,
  [1519] = 1519,
  [1520] = 574,
  [1521] = 576,
  [1522] = 583,
  [1523] = 512,
  [1524] = 584,
  [1525] = 442,
  [1526] = 445,
  [1527] = 586,
  [1528] = 587,
  [1529] = 589,
  [1530] = 590,
  [1531] = 591,
  [1532] = 592,
  [1533] = 530,
  [1534] = 552,
  [1535] = 451,
  [1536] = 604,
  [1537] = 534,
  [1538] = 535,
  [1539] = 531,
  [1540] = 553,
  [1541] = 554,
  [1542] = 555,
  [1543] = 595,
  [1544] = 596,
  [1545] = 597,
  [1546] = 598,
  [1547] = 599,
  [1548] = 558,
  [1549] = 600,
  [1550] = 601,
  [1551] = 602,
  [1552] = 483,
  [1553] = 439,
  [1554] = 533,
  [1555] = 613,
  [1556] = 614,
  [1557] = 615,
  [1558] = 616,
  [1559] = 450,
  [1560] = 618,
  [1561] = 442,
  [1562] = 559,
  [1563] = 561,
  [1564] = 562,
  [1565] = 563,
  [1566] = 573,
  [1567] = 619,
  [1568] = 620,
  [1569] = 621,
  [1570] = 585,
  [1571] = 542,
  [1572] = 623,
  [1573] = 449,
  [1574] = 625,
  [1575] = 626,
  [1576] = 627,
  [1577] = 628,
  [1578] = 629,
  [1579] = 630,
  [1580] = 631,
  [1581] = 441,
  [1582] = 632,
  [1583] = 532,
  [1584] = 634,
  [1585] = 448,
  [1586] = 501,
  [1587] = 440,
  [1588] = 503,
  [1589] = 437,
  [1590] = 575,
  [1591] = 447,
  [1592] = 437,
  [1593] = 622,
  [1594] = 525,
  [1595] = 439,
  [1596] = 515,
  [1597] = 631,
  [1598] = 597,
  [1599] = 596,
  [1600] = 595,
  [1601] = 550,
  [1602] = 468,
  [1603] = 527,
  [1604] = 453,
  [1605] = 444,
  [1606] = 538,
  [1607] = 537,
  [1608] = 536,
  [1609] = 465,
  [1610] = 529,
  [1611] = 527,
  [1612] = 465,
  [1613] = 468,
  [1614] = 528,
  [1615] = 491,
  [1616] = 490,
  [1617] = 489,
  [1618] = 488,
  [1619] = 464,
  [1620] = 592,
  [1621] = 591,
  [1622] = 590,
  [1623] = 589,
  [1624] = 588,
  [1625] = 587,
  [1626] = 586,
  [1627] = 463,
  [1628] = 464,
  [1629] = 526,
  [1630] = 454,
  [1631] = 585,
  [1632] = 584,
  [1633] = 583,
  [1634] = 576,
  [1635] = 574,
  [1636] = 572,
  [1637] = 571,
  [1638] = 551,
  [1639] = 1286,
  [1640] = 452,
  [1641] = 451,
  [1642] = 450,
  [1643] = 570,
  [1644] = 569,
  [1645] = 568,
  [1646] = 567,
  [1647] = 449,
  [1648] = 463,
  [1649] = 512,
  [1650] = 566,
  [1651] = 565,
  [1652] = 599,
  [1653] = 600,
  [1654] = 448,
  [1655] = 495,
  [1656] = 560,
  [1657] = 501,
  [1658] = 557,
  [1659] = 556,
  [1660] = 601,
  [1661] = 551,
  [1662] = 454,
  [1663] = 453,
  [1664] = 452,
  [1665] = 451,
  [1666] = 503,
  [1667] = 450,
  [1668] = 449,
  [1669] = 575,
  [1670] = 447,
  [1671] = 602,
  [1672] = 571,
  [1673] = 525,
  [1674] = 574,
  [1675] = 448,
  [1676] = 576,
  [1677] = 583,
  [1678] = 575,
  [1679] = 447,
  [1680] = 584,
  [1681] = 585,
  [1682] = 586,
  [1683] = 525,
  [1684] = 445,
  [1685] = 587,
  [1686] = 588,
  [1687] = 589,
  [1688] = 590,
  [1689] = 591,
  [1690] = 592,
  [1691] = 530,
  [1692] = 531,
  [1693] = 532,
  [1694] = 435,
  [1695] = 533,
  [1696] = 534,
  [1697] = 445,
  [1698] = 604,
  [1699] = 535,
  [1700] = 613,
  [1701] = 614,
  [1702] = 615,
  [1703] = 616,
  [1704] = 618,
  [1705] = 552,
  [1706] = 542,
  [1707] = 553,
  [1708] = 554,
  [1709] = 555,
  [1710] = 558,
  [1711] = 595,
  [1712] = 596,
  [1713] = 597,
  [1714] = 598,
  [1715] = 599,
  [1716] = 600,
  [1717] = 601,
  [1718] = 602,
  [1719] = 483,
  [1720] = 483,
  [1721] = 604,
  [1722] = 613,
  [1723] = 614,
  [1724] = 615,
  [1725] = 616,
  [1726] = 618,
  [1727] = 436,
  [1728] = 550,
  [1729] = 547,
  [1730] = 559,
  [1731] = 561,
  [1732] = 556,
  [1733] = 562,
  [1734] = 563,
  [1735] = 573,
  [1736] = 619,
  [1737] = 620,
  [1738] = 621,
  [1739] = 622,
  [1740] = 547,
  [1741] = 542,
  [1742] = 557,
  [1743] = 623,
  [1744] = 444,
  [1745] = 625,
  [1746] = 626,
  [1747] = 627,
  [1748] = 628,
  [1749] = 629,
  [1750] = 630,
  [1751] = 598,
  [1752] = 632,
  [1753] = 633,
  [1754] = 634,
  [1755] = 529,
  [1756] = 512,
  [1757] = 619,
  [1758] = 482,
  [1759] = 538,
  [1760] = 570,
  [1761] = 492,
  [1762] = 526,
  [1763] = 493,
  [1764] = 536,
  [1765] = 569,
  [1766] = 568,
  [1767] = 482,
  [1768] = 528,
  [1769] = 567,
  [1770] = 566,
  [1771] = 565,
  [1772] = 572,
  [1773] = 516,
  [1774] = 492,
  [1775] = 620,
  [1776] = 621,
  [1777] = 493,
  [1778] = 634,
  [1779] = 537,
  [1780] = 622,
  [1781] = 503,
  [1782] = 560,
  [1783] = 501,
  [1784] = 495,
  [1785] = 623,
  [1786] = 625,
  [1787] = 626,
  [1788] = 627,
  [1789] = 628,
  [1790] = 629,
  [1791] = 1181,
  [1792] = 630,
  [1793] = 631,
  [1794] = 632,
  [1795] = 633,
  [1796] = 1286,
  [1797] = 1181,
  [1798] = 433,
  [1799] = 432,
  [1800] = 431,
  [1801] = 434,
  [1802] = 439,
  [1803] = 441,
  [1804] = 437,
  [1805] = 528,
  [1806] = 440,
  [1807] = 575,
  [1808] = 495,
  [1809] = 442,
  [1810] = 588,
  [1811] = 576,
  [1812] = 632,
  [1813] = 631,
  [1814] = 630,
  [1815] = 629,
  [1816] = 628,
  [1817] = 627,
  [1818] = 482,
  [1819] = 626,
  [1820] = 625,
  [1821] = 623,
  [1822] = 622,
  [1823] = 621,
  [1824] = 620,
  [1825] = 619,
  [1826] = 618,
  [1827] = 616,
  [1828] = 615,
  [1829] = 614,
  [1830] = 613,
  [1831] = 604,
  [1832] = 602,
  [1833] = 601,
  [1834] = 600,
  [1835] = 599,
  [1836] = 598,
  [1837] = 597,
  [1838] = 596,
  [1839] = 595,
  [1840] = 468,
  [1841] = 493,
  [1842] = 492,
  [1843] = 483,
  [1844] = 592,
  [1845] = 591,
  [1846] = 590,
  [1847] = 589,
  [1848] = 542,
  [1849] = 587,
  [1850] = 526,
  [1851] = 586,
  [1852] = 585,
  [1853] = 584,
  [1854] = 583,
  [1855] = 503,
  [1856] = 574,
  [1857] = 572,
  [1858] = 571,
  [1859] = 570,
  [1860] = 569,
  [1861] = 568,
  [1862] = 567,
  [1863] = 566,
  [1864] = 565,
  [1865] = 512,
  [1866] = 1866,
  [1867] = 560,
  [1868] = 557,
  [1869] = 556,
  [1870] = 551,
  [1871] = 550,
  [1872] = 547,
  [1873] = 444,
  [1874] = 538,
  [1875] = 537,
  [1876] = 536,
  [1877] = 529,
  [1878] = 527,
  [1879] = 465,
  [1880] = 464,
  [1881] = 463,
  [1882] = 454,
  [1883] = 453,
  [1884] = 452,
  [1885] = 451,
  [1886] = 450,
  [1887] = 449,
  [1888] = 633,
  [1889] = 448,
  [1890] = 447,
  [1891] = 501,
  [1892] = 634,
  [1893] = 525,
  [1894] = 445,
  [1895] = 435,
  [1896] = 436,
  [1897] = 431,
  [1898] = 434,
  [1899] = 432,
  [1900] = 440,
  [1901] = 442,
  [1902] = 495,
  [1903] = 575,
  [1904] = 528,
  [1905] = 433,
  [1906] = 441,
  [1907] = 439,
  [1908] = 512,
  [1909] = 526,
  [1910] = 437,
  [1911] = 448,
  [1912] = 445,
  [1913] = 454,
  [1914] = 631,
  [1915] = 630,
  [1916] = 629,
  [1917] = 628,
  [1918] = 627,
  [1919] = 626,
  [1920] = 625,
  [1921] = 623,
  [1922] = 622,
  [1923] = 621,
  [1924] = 620,
  [1925] = 619,
  [1926] = 618,
  [1927] = 616,
  [1928] = 615,
  [1929] = 614,
  [1930] = 613,
  [1931] = 604,
  [1932] = 602,
  [1933] = 601,
  [1934] = 600,
  [1935] = 599,
  [1936] = 598,
  [1937] = 597,
  [1938] = 596,
  [1939] = 595,
  [1940] = 592,
  [1941] = 591,
  [1942] = 590,
  [1943] = 589,
  [1944] = 588,
  [1945] = 587,
  [1946] = 586,
  [1947] = 585,
  [1948] = 584,
  [1949] = 583,
  [1950] = 576,
  [1951] = 574,
  [1952] = 572,
  [1953] = 571,
  [1954] = 570,
  [1955] = 569,
  [1956] = 453,
  [1957] = 567,
  [1958] = 566,
  [1959] = 565,
  [1960] = 560,
  [1961] = 557,
  [1962] = 556,
  [1963] = 551,
  [1964] = 550,
  [1965] = 547,
  [1966] = 444,
  [1967] = 538,
  [1968] = 537,
  [1969] = 536,
  [1970] = 529,
  [1971] = 527,
  [1972] = 465,
  [1973] = 464,
  [1974] = 463,
  [1975] = 632,
  [1976] = 468,
  [1977] = 452,
  [1978] = 451,
  [1979] = 450,
  [1980] = 449,
  [1981] = 633,
  [1982] = 447,
  [1983] = 634,
  [1984] = 525,
  [1985] = 568,
  [1986] = 1986,
  [1987] = 1986,
  [1988] = 1986,
  [1989] = 1986,
  [1990] = 1986,
  [1991] = 1986,
  [1992] = 1986,
  [1993] = 1993,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1993,
  [1998] = 1998,
  [1999] = 1995,
  [2000] = 1996,
  [2001] = 1993,
  [2002] = 1998,
  [2003] = 1996,
  [2004] = 1995,
  [2005] = 1998,
  [2006] = 1993,
  [2007] = 1998,
  [2008] = 1995,
  [2009] = 1993,
  [2010] = 1998,
  [2011] = 1993,
  [2012] = 1998,
  [2013] = 1998,
  [2014] = 1996,
  [2015] = 1994,
  [2016] = 1996,
  [2017] = 1996,
  [2018] = 1993,
  [2019] = 1995,
  [2020] = 1993,
  [2021] = 1996,
  [2022] = 1998,
  [2023] = 1993,
  [2024] = 1994,
  [2025] = 1995,
  [2026] = 1998,
  [2027] = 1994,
  [2028] = 1996,
  [2029] = 1995,
  [2030] = 1994,
  [2031] = 1996,
  [2032] = 1993,
  [2033] = 1994,
  [2034] = 1994,
  [2035] = 1994,
  [2036] = 2036,
  [2037] = 1995,
  [2038] = 1996,
  [2039] = 1995,
  [2040] = 1994,
  [2041] = 1994,
  [2042] = 1994,
  [2043] = 1993,
  [2044] = 1996,
  [2045] = 2045,
  [2046] = 2045,
  [2047] = 2047,
  [2048] = 2045,
  [2049] = 2045,
  [2050] = 2045,
  [2051] = 2045,
  [2052] = 2047,
  [2053] = 2047,
  [2054] = 2047,
  [2055] = 2045,
  [2056] = 2047,
  [2057] = 2047,
  [2058] = 2047,
  [2059] = 2045,
  [2060] = 2045,
  [2061] = 2045,
  [2062] = 2047,
  [2063] = 2047,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2047,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2071,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2071,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2072,
  [2084] = 2080,
  [2085] = 2071,
  [2086] = 2080,
  [2087] = 2087,
  [2088] = 2073,
  [2089] = 2081,
  [2090] = 2077,
  [2091] = 2091,
  [2092] = 2081,
  [2093] = 2071,
  [2094] = 2082,
  [2095] = 2074,
  [2096] = 2072,
  [2097] = 2097,
  [2098] = 2098,
  [2099] = 2099,
  [2100] = 2073,
  [2101] = 2101,
  [2102] = 2071,
  [2103] = 2103,
  [2104] = 2077,
  [2105] = 2082,
  [2106] = 2074,
  [2107] = 2071,
  [2108] = 2072,
  [2109] = 2073,
  [2110] = 2077,
  [2111] = 2082,
  [2112] = 2087,
  [2113] = 2091,
  [2114] = 2070,
  [2115] = 2101,
  [2116] = 2103,
  [2117] = 2103,
  [2118] = 2101,
  [2119] = 2071,
  [2120] = 2099,
  [2121] = 2098,
  [2122] = 2097,
  [2123] = 2070,
  [2124] = 2069,
  [2125] = 2087,
  [2126] = 2074,
  [2127] = 2099,
  [2128] = 2070,
  [2129] = 2091,
  [2130] = 2087,
  [2131] = 2098,
  [2132] = 2082,
  [2133] = 2071,
  [2134] = 2075,
  [2135] = 2097,
  [2136] = 2069,
  [2137] = 2070,
  [2138] = 2069,
  [2139] = 2091,
  [2140] = 2077,
  [2141] = 2101,
  [2142] = 2073,
  [2143] = 2072,
  [2144] = 2103,
  [2145] = 2078,
  [2146] = 2074,
  [2147] = 2099,
  [2148] = 2075,
  [2149] = 2080,
  [2150] = 2098,
  [2151] = 2097,
  [2152] = 2075,
  [2153] = 2078,
  [2154] = 2154,
  [2155] = 2097,
  [2156] = 2078,
  [2157] = 2098,
  [2158] = 2099,
  [2159] = 2103,
  [2160] = 2101,
  [2161] = 2091,
  [2162] = 2087,
  [2163] = 2082,
  [2164] = 2077,
  [2165] = 2077,
  [2166] = 2073,
  [2167] = 2072,
  [2168] = 2074,
  [2169] = 2087,
  [2170] = 2091,
  [2171] = 2081,
  [2172] = 2078,
  [2173] = 2069,
  [2174] = 2075,
  [2175] = 2101,
  [2176] = 2103,
  [2177] = 2080,
  [2178] = 2081,
  [2179] = 2080,
  [2180] = 2070,
  [2181] = 2069,
  [2182] = 2070,
  [2183] = 2080,
  [2184] = 2081,
  [2185] = 2081,
  [2186] = 2099,
  [2187] = 2074,
  [2188] = 2081,
  [2189] = 2075,
  [2190] = 2078,
  [2191] = 2097,
  [2192] = 2098,
  [2193] = 2099,
  [2194] = 2103,
  [2195] = 2101,
  [2196] = 2098,
  [2197] = 2097,
  [2198] = 2072,
  [2199] = 2091,
  [2200] = 2069,
  [2201] = 2070,
  [2202] = 2080,
  [2203] = 2073,
  [2204] = 2087,
  [2205] = 2077,
  [2206] = 2082,
  [2207] = 2077,
  [2208] = 2073,
  [2209] = 2072,
  [2210] = 2074,
  [2211] = 2082,
  [2212] = 2078,
  [2213] = 2087,
  [2214] = 2070,
  [2215] = 2069,
  [2216] = 2091,
  [2217] = 2101,
  [2218] = 2074,
  [2219] = 2103,
  [2220] = 2072,
  [2221] = 2073,
  [2222] = 2099,
  [2223] = 2077,
  [2224] = 2098,
  [2225] = 2082,
  [2226] = 2087,
  [2227] = 2091,
  [2228] = 2070,
  [2229] = 2101,
  [2230] = 2103,
  [2231] = 2097,
  [2232] = 2078,
  [2233] = 2075,
  [2234] = 2099,
  [2235] = 2098,
  [2236] = 2097,
  [2237] = 2075,
  [2238] = 2080,
  [2239] = 2069,
  [2240] = 2081,
  [2241] = 2080,
  [2242] = 2069,
  [2243] = 2074,
  [2244] = 2072,
  [2245] = 2073,
  [2246] = 2075,
  [2247] = 2081,
  [2248] = 2075,
  [2249] = 2078,
  [2250] = 2071,
  [2251] = 2097,
  [2252] = 2098,
  [2253] = 2099,
  [2254] = 2103,
  [2255] = 2101,
  [2256] = 2091,
  [2257] = 2087,
  [2258] = 2078,
  [2259] = 2082,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 2262,
  [2263] = 2260,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 2261,
  [2270] = 2270,
  [2271] = 2260,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2270,
  [2275] = 2264,
  [2276] = 2262,
  [2277] = 2272,
  [2278] = 2260,
  [2279] = 2270,
  [2280] = 2261,
  [2281] = 2267,
  [2282] = 2266,
  [2283] = 2265,
  [2284] = 2284,
  [2285] = 2265,
  [2286] = 2262,
  [2287] = 2287,
  [2288] = 2265,
  [2289] = 2264,
  [2290] = 2266,
  [2291] = 2267,
  [2292] = 2292,
  [2293] = 2261,
  [2294] = 2270,
  [2295] = 2260,
  [2296] = 2265,
  [2297] = 2272,
  [2298] = 2266,
  [2299] = 2267,
  [2300] = 2300,
  [2301] = 2262,
  [2302] = 2261,
  [2303] = 2270,
  [2304] = 2260,
  [2305] = 2272,
  [2306] = 2272,
  [2307] = 2264,
  [2308] = 2260,
  [2309] = 2270,
  [2310] = 2261,
  [2311] = 2272,
  [2312] = 2264,
  [2313] = 2260,
  [2314] = 2264,
  [2315] = 2267,
  [2316] = 2262,
  [2317] = 2266,
  [2318] = 2270,
  [2319] = 2262,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2262,
  [2323] = 2265,
  [2324] = 2261,
  [2325] = 2267,
  [2326] = 2266,
  [2327] = 2265,
  [2328] = 2262,
  [2329] = 2264,
  [2330] = 2272,
  [2331] = 2331,
  [2332] = 2266,
  [2333] = 2270,
  [2334] = 2261,
  [2335] = 2267,
  [2336] = 2266,
  [2337] = 2265,
  [2338] = 2267,
  [2339] = 2331,
  [2340] = 2340,
  [2341] = 2320,
  [2342] = 2331,
  [2343] = 2343,
  [2344] = 2331,
  [2345] = 2265,
  [2346] = 2331,
  [2347] = 2266,
  [2348] = 2267,
  [2349] = 2349,
  [2350] = 2261,
  [2351] = 2270,
  [2352] = 2260,
  [2353] = 2331,
  [2354] = 2265,
  [2355] = 2266,
  [2356] = 2267,
  [2357] = 2357,
  [2358] = 2272,
  [2359] = 2261,
  [2360] = 2270,
  [2361] = 2260,
  [2362] = 2272,
  [2363] = 2363,
  [2364] = 2264,
  [2365] = 2264,
  [2366] = 2331,
  [2367] = 2262,
  [2368] = 2264,
  [2369] = 2262,
  [2370] = 2340,
  [2371] = 2331,
  [2372] = 2331,
  [2373] = 2272,
  [2374] = 2331,
  [2375] = 2375,
  [2376] = 2376,
  [2377] = 2377,
  [2378] = 2378,
  [2379] = 2379,
  [2380] = 2380,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2389,
  [2392] = 2392,
  [2393] = 2389,
  [2394] = 2394,
  [2395] = 2389,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2389,
  [2400] = 2400,
  [2401] = 2401,
  [2402] = 2402,
  [2403] = 2403,
  [2404] = 2389,
  [2405] = 2405,
  [2406] = 2406,
  [2407] = 2407,
  [2408] = 2408,
  [2409] = 2409,
  [2410] = 2401,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2414,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2424,
  [2425] = 2425,
  [2426] = 2389,
  [2427] = 2412,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2398,
  [2431] = 2431,
  [2432] = 2432,
  [2433] = 2376,
  [2434] = 2434,
  [2435] = 2413,
  [2436] = 2436,
  [2437] = 2375,
  [2438] = 2414,
  [2439] = 2402,
  [2440] = 2389,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2390,
  [2444] = 2444,
  [2445] = 2445,
  [2446] = 2392,
  [2447] = 2445,
  [2448] = 2394,
  [2449] = 2411,
  [2450] = 2400,
  [2451] = 2396,
  [2452] = 2396,
  [2453] = 2394,
  [2454] = 2392,
  [2455] = 2400,
  [2456] = 2411,
  [2457] = 2389,
  [2458] = 2390,
  [2459] = 2459,
  [2460] = 2460,
  [2461] = 2445,
  [2462] = 2444,
  [2463] = 2442,
  [2464] = 2444,
  [2465] = 2415,
  [2466] = 2460,
  [2467] = 2436,
  [2468] = 2434,
  [2469] = 2425,
  [2470] = 2376,
  [2471] = 2422,
  [2472] = 2421,
  [2473] = 2420,
  [2474] = 2409,
  [2475] = 2408,
  [2476] = 2407,
  [2477] = 2406,
  [2478] = 2405,
  [2479] = 2403,
  [2480] = 2480,
  [2481] = 2432,
  [2482] = 2381,
  [2483] = 2397,
  [2484] = 2431,
  [2485] = 2388,
  [2486] = 2486,
  [2487] = 2487,
  [2488] = 2377,
  [2489] = 2378,
  [2490] = 2379,
  [2491] = 2380,
  [2492] = 2492,
  [2493] = 2382,
  [2494] = 2383,
  [2495] = 2384,
  [2496] = 2385,
  [2497] = 2386,
  [2498] = 2387,
  [2499] = 2499,
  [2500] = 2442,
  [2501] = 2375,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2460,
  [2505] = 2480,
  [2506] = 2492,
  [2507] = 2499,
  [2508] = 2436,
  [2509] = 512,
  [2510] = 2502,
  [2511] = 2503,
  [2512] = 2428,
  [2513] = 2402,
  [2514] = 2416,
  [2515] = 2460,
  [2516] = 2423,
  [2517] = 2419,
  [2518] = 2480,
  [2519] = 2492,
  [2520] = 2418,
  [2521] = 2401,
  [2522] = 2499,
  [2523] = 2412,
  [2524] = 2413,
  [2525] = 2414,
  [2526] = 2415,
  [2527] = 2416,
  [2528] = 2417,
  [2529] = 2418,
  [2530] = 2419,
  [2531] = 2417,
  [2532] = 2416,
  [2533] = 2415,
  [2534] = 2423,
  [2535] = 2414,
  [2536] = 2413,
  [2537] = 2499,
  [2538] = 2412,
  [2539] = 2428,
  [2540] = 2417,
  [2541] = 2398,
  [2542] = 2431,
  [2543] = 2432,
  [2544] = 2376,
  [2545] = 2434,
  [2546] = 2401,
  [2547] = 2436,
  [2548] = 2425,
  [2549] = 2422,
  [2550] = 2502,
  [2551] = 2418,
  [2552] = 2390,
  [2553] = 2419,
  [2554] = 2503,
  [2555] = 2392,
  [2556] = 2402,
  [2557] = 2394,
  [2558] = 2460,
  [2559] = 2480,
  [2560] = 2492,
  [2561] = 2396,
  [2562] = 2499,
  [2563] = 2421,
  [2564] = 2400,
  [2565] = 2411,
  [2566] = 2420,
  [2567] = 2502,
  [2568] = 2503,
  [2569] = 2460,
  [2570] = 2445,
  [2571] = 2444,
  [2572] = 2442,
  [2573] = 2480,
  [2574] = 2492,
  [2575] = 2499,
  [2576] = 2409,
  [2577] = 2408,
  [2578] = 2425,
  [2579] = 2387,
  [2580] = 2422,
  [2581] = 2421,
  [2582] = 2420,
  [2583] = 2409,
  [2584] = 2408,
  [2585] = 2407,
  [2586] = 2406,
  [2587] = 2405,
  [2588] = 2403,
  [2589] = 2386,
  [2590] = 2502,
  [2591] = 2381,
  [2592] = 2397,
  [2593] = 2503,
  [2594] = 2388,
  [2595] = 2385,
  [2596] = 2487,
  [2597] = 2377,
  [2598] = 2378,
  [2599] = 2379,
  [2600] = 2380,
  [2601] = 2384,
  [2602] = 2382,
  [2603] = 2383,
  [2604] = 2384,
  [2605] = 2385,
  [2606] = 2386,
  [2607] = 2387,
  [2608] = 2383,
  [2609] = 2460,
  [2610] = 2480,
  [2611] = 2492,
  [2612] = 2499,
  [2613] = 2407,
  [2614] = 2406,
  [2615] = 2502,
  [2616] = 2503,
  [2617] = 2382,
  [2618] = 2405,
  [2619] = 2460,
  [2620] = 2480,
  [2621] = 2492,
  [2622] = 2402,
  [2623] = 2387,
  [2624] = 2499,
  [2625] = 2386,
  [2626] = 2380,
  [2627] = 2389,
  [2628] = 2385,
  [2629] = 2401,
  [2630] = 2480,
  [2631] = 2412,
  [2632] = 2413,
  [2633] = 2414,
  [2634] = 2415,
  [2635] = 2416,
  [2636] = 2417,
  [2637] = 2418,
  [2638] = 2419,
  [2639] = 2384,
  [2640] = 2383,
  [2641] = 2382,
  [2642] = 2423,
  [2643] = 2403,
  [2644] = 2492,
  [2645] = 2380,
  [2646] = 2428,
  [2647] = 2379,
  [2648] = 2398,
  [2649] = 2431,
  [2650] = 2432,
  [2651] = 2376,
  [2652] = 2434,
  [2653] = 2378,
  [2654] = 2436,
  [2655] = 2655,
  [2656] = 2379,
  [2657] = 2378,
  [2658] = 2377,
  [2659] = 2390,
  [2660] = 2487,
  [2661] = 2431,
  [2662] = 2392,
  [2663] = 2388,
  [2664] = 2394,
  [2665] = 2397,
  [2666] = 2381,
  [2667] = 2502,
  [2668] = 2396,
  [2669] = 2403,
  [2670] = 2405,
  [2671] = 2400,
  [2672] = 2411,
  [2673] = 2503,
  [2674] = 2406,
  [2675] = 2407,
  [2676] = 2408,
  [2677] = 2445,
  [2678] = 2444,
  [2679] = 2442,
  [2680] = 2381,
  [2681] = 2681,
  [2682] = 2377,
  [2683] = 2425,
  [2684] = 2487,
  [2685] = 2422,
  [2686] = 2421,
  [2687] = 2420,
  [2688] = 2409,
  [2689] = 2408,
  [2690] = 2407,
  [2691] = 2406,
  [2692] = 2405,
  [2693] = 2403,
  [2694] = 2409,
  [2695] = 2420,
  [2696] = 2381,
  [2697] = 2397,
  [2698] = 2421,
  [2699] = 2388,
  [2700] = 2487,
  [2701] = 2377,
  [2702] = 2378,
  [2703] = 2379,
  [2704] = 2460,
  [2705] = 2480,
  [2706] = 2492,
  [2707] = 2499,
  [2708] = 2397,
  [2709] = 2388,
  [2710] = 2422,
  [2711] = 2502,
  [2712] = 2503,
  [2713] = 2713,
  [2714] = 2425,
  [2715] = 2402,
  [2716] = 2432,
  [2717] = 2487,
  [2718] = 2377,
  [2719] = 2388,
  [2720] = 2442,
  [2721] = 2401,
  [2722] = 2444,
  [2723] = 2412,
  [2724] = 2413,
  [2725] = 2414,
  [2726] = 2445,
  [2727] = 2460,
  [2728] = 2411,
  [2729] = 2423,
  [2730] = 2400,
  [2731] = 2409,
  [2732] = 2396,
  [2733] = 2428,
  [2734] = 2394,
  [2735] = 2398,
  [2736] = 2431,
  [2737] = 2432,
  [2738] = 2376,
  [2739] = 2392,
  [2740] = 2436,
  [2741] = 2397,
  [2742] = 2381,
  [2743] = 2390,
  [2744] = 2436,
  [2745] = 2390,
  [2746] = 2434,
  [2747] = 2376,
  [2748] = 2392,
  [2749] = 2428,
  [2750] = 2394,
  [2751] = 2431,
  [2752] = 2398,
  [2753] = 2428,
  [2754] = 2396,
  [2755] = 2423,
  [2756] = 2419,
  [2757] = 2400,
  [2758] = 2411,
  [2759] = 2378,
  [2760] = 2418,
  [2761] = 2417,
  [2762] = 2416,
  [2763] = 2445,
  [2764] = 2444,
  [2765] = 2442,
  [2766] = 2403,
  [2767] = 2405,
  [2768] = 2406,
  [2769] = 2425,
  [2770] = 2407,
  [2771] = 2422,
  [2772] = 2421,
  [2773] = 2420,
  [2774] = 2409,
  [2775] = 2408,
  [2776] = 2407,
  [2777] = 2406,
  [2778] = 2405,
  [2779] = 2403,
  [2780] = 2408,
  [2781] = 2415,
  [2782] = 2381,
  [2783] = 2397,
  [2784] = 2414,
  [2785] = 2388,
  [2786] = 2487,
  [2787] = 2377,
  [2788] = 2378,
  [2789] = 2379,
  [2790] = 2480,
  [2791] = 2492,
  [2792] = 2413,
  [2793] = 2412,
  [2794] = 2499,
  [2795] = 2379,
  [2796] = 2401,
  [2797] = 2402,
  [2798] = 2380,
  [2799] = 2502,
  [2800] = 2423,
  [2801] = 2503,
  [2802] = 2401,
  [2803] = 2420,
  [2804] = 2412,
  [2805] = 2413,
  [2806] = 2414,
  [2807] = 2402,
  [2808] = 2382,
  [2809] = 2390,
  [2810] = 2423,
  [2811] = 2811,
  [2812] = 2459,
  [2813] = 2428,
  [2814] = 2441,
  [2815] = 2398,
  [2816] = 2431,
  [2817] = 2432,
  [2818] = 2487,
  [2819] = 2429,
  [2820] = 2436,
  [2821] = 2421,
  [2822] = 2422,
  [2823] = 2425,
  [2824] = 2424,
  [2825] = 2390,
  [2826] = 2383,
  [2827] = 2655,
  [2828] = 2392,
  [2829] = 2681,
  [2830] = 2394,
  [2831] = 2384,
  [2832] = 526,
  [2833] = 2387,
  [2834] = 2396,
  [2835] = 2386,
  [2836] = 2385,
  [2837] = 2400,
  [2838] = 2411,
  [2839] = 2385,
  [2840] = 2384,
  [2841] = 2383,
  [2842] = 2382,
  [2843] = 2445,
  [2844] = 2444,
  [2845] = 2386,
  [2846] = 2380,
  [2847] = 2387,
  [2848] = 2425,
  [2849] = 2849,
  [2850] = 2422,
  [2851] = 2421,
  [2852] = 2420,
  [2853] = 2409,
  [2854] = 2408,
  [2855] = 2407,
  [2856] = 2406,
  [2857] = 2405,
  [2858] = 2403,
  [2859] = 2859,
  [2860] = 2379,
  [2861] = 2381,
  [2862] = 2397,
  [2863] = 2378,
  [2864] = 2388,
  [2865] = 2487,
  [2866] = 2377,
  [2867] = 2378,
  [2868] = 2379,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2375,
  [2872] = 2377,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2487,
  [2876] = 2402,
  [2877] = 2396,
  [2878] = 2811,
  [2879] = 2459,
  [2880] = 2388,
  [2881] = 2401,
  [2882] = 2441,
  [2883] = 2412,
  [2884] = 2413,
  [2885] = 2414,
  [2886] = 2397,
  [2887] = 2381,
  [2888] = 2403,
  [2889] = 2423,
  [2890] = 2429,
  [2891] = 2405,
  [2892] = 2428,
  [2893] = 2406,
  [2894] = 2398,
  [2895] = 2431,
  [2896] = 2432,
  [2897] = 2376,
  [2898] = 2407,
  [2899] = 2436,
  [2900] = 2424,
  [2901] = 2655,
  [2902] = 2681,
  [2903] = 2442,
  [2904] = 2392,
  [2905] = 2444,
  [2906] = 2445,
  [2907] = 2874,
  [2908] = 2873,
  [2909] = 2870,
  [2910] = 2869,
  [2911] = 2859,
  [2912] = 2408,
  [2913] = 2859,
  [2914] = 2869,
  [2915] = 2870,
  [2916] = 2873,
  [2917] = 2874,
  [2918] = 2811,
  [2919] = 2874,
  [2920] = 2459,
  [2921] = 2409,
  [2922] = 2420,
  [2923] = 2421,
  [2924] = 2422,
  [2925] = 2398,
  [2926] = 2681,
  [2927] = 2655,
  [2928] = 2425,
  [2929] = 2432,
  [2930] = 2424,
  [2931] = 2429,
  [2932] = 2441,
  [2933] = 2459,
  [2934] = 2376,
  [2935] = 2375,
  [2936] = 2811,
  [2937] = 2937,
  [2938] = 2938,
  [2939] = 2939,
  [2940] = 2940,
  [2941] = 2811,
  [2942] = 2859,
  [2943] = 2874,
  [2944] = 2873,
  [2945] = 2870,
  [2946] = 2869,
  [2947] = 2441,
  [2948] = 2937,
  [2949] = 2859,
  [2950] = 2429,
  [2951] = 2424,
  [2952] = 2655,
  [2953] = 2681,
  [2954] = 2394,
  [2955] = 2502,
  [2956] = 2859,
  [2957] = 2938,
  [2958] = 2503,
  [2959] = 2442,
  [2960] = 2444,
  [2961] = 2445,
  [2962] = 2681,
  [2963] = 2655,
  [2964] = 2869,
  [2965] = 2870,
  [2966] = 2424,
  [2967] = 2429,
  [2968] = 2441,
  [2969] = 2459,
  [2970] = 2411,
  [2971] = 2811,
  [2972] = 2937,
  [2973] = 2938,
  [2974] = 2939,
  [2975] = 2940,
  [2976] = 2874,
  [2977] = 2873,
  [2978] = 2870,
  [2979] = 2869,
  [2980] = 2873,
  [2981] = 2400,
  [2982] = 2859,
  [2983] = 2874,
  [2984] = 2940,
  [2985] = 2939,
  [2986] = 2938,
  [2987] = 2937,
  [2988] = 2811,
  [2989] = 2459,
  [2990] = 2434,
  [2991] = 2869,
  [2992] = 2870,
  [2993] = 2394,
  [2994] = 2392,
  [2995] = 2681,
  [2996] = 2655,
  [2997] = 2873,
  [2998] = 2390,
  [2999] = 2424,
  [3000] = 2429,
  [3001] = 2441,
  [3002] = 2459,
  [3003] = 2939,
  [3004] = 2811,
  [3005] = 2937,
  [3006] = 2938,
  [3007] = 2939,
  [3008] = 2940,
  [3009] = 2874,
  [3010] = 2873,
  [3011] = 2870,
  [3012] = 2869,
  [3013] = 2441,
  [3014] = 2429,
  [3015] = 2859,
  [3016] = 2424,
  [3017] = 2402,
  [3018] = 2655,
  [3019] = 2681,
  [3020] = 2401,
  [3021] = 2411,
  [3022] = 2412,
  [3023] = 2940,
  [3024] = 2400,
  [3025] = 2436,
  [3026] = 2434,
  [3027] = 2376,
  [3028] = 2681,
  [3029] = 2655,
  [3030] = 2432,
  [3031] = 2431,
  [3032] = 2424,
  [3033] = 2429,
  [3034] = 2441,
  [3035] = 2459,
  [3036] = 2398,
  [3037] = 2811,
  [3038] = 2937,
  [3039] = 2938,
  [3040] = 2939,
  [3041] = 2940,
  [3042] = 2874,
  [3043] = 2873,
  [3044] = 2870,
  [3045] = 2869,
  [3046] = 2413,
  [3047] = 2428,
  [3048] = 2859,
  [3049] = 2859,
  [3050] = 2414,
  [3051] = 2869,
  [3052] = 2870,
  [3053] = 2873,
  [3054] = 2423,
  [3055] = 2874,
  [3056] = 2419,
  [3057] = 2396,
  [3058] = 2418,
  [3059] = 2417,
  [3060] = 2681,
  [3061] = 2655,
  [3062] = 2416,
  [3063] = 2424,
  [3064] = 2429,
  [3065] = 2441,
  [3066] = 2459,
  [3067] = 2415,
  [3068] = 2811,
  [3069] = 2937,
  [3070] = 2938,
  [3071] = 2939,
  [3072] = 2940,
  [3073] = 3073,
  [3074] = 3074,
  [3075] = 3075,
  [3076] = 3076,
  [3077] = 3077,
  [3078] = 3078,
  [3079] = 3079,
  [3080] = 3079,
  [3081] = 3078,
  [3082] = 3074,
  [3083] = 3075,
  [3084] = 3084,
  [3085] = 3077,
  [3086] = 3086,
  [3087] = 3074,
  [3088] = 3084,
  [3089] = 3089,
  [3090] = 3086,
  [3091] = 3075,
  [3092] = 3076,
  [3093] = 3078,
  [3094] = 3079,
  [3095] = 3095,
  [3096] = 3077,
  [3097] = 3074,
  [3098] = 3098,
  [3099] = 3084,
  [3100] = 3075,
  [3101] = 3076,
  [3102] = 3078,
  [3103] = 3079,
  [3104] = 3077,
  [3105] = 3098,
  [3106] = 3077,
  [3107] = 3077,
  [3108] = 3074,
  [3109] = 3109,
  [3110] = 3074,
  [3111] = 3111,
  [3112] = 3084,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3075,
  [3116] = 3076,
  [3117] = 3117,
  [3118] = 3078,
  [3119] = 3079,
  [3120] = 3077,
  [3121] = 3074,
  [3122] = 3084,
  [3123] = 3075,
  [3124] = 3076,
  [3125] = 3078,
  [3126] = 3079,
  [3127] = 3077,
  [3128] = 3077,
  [3129] = 3129,
  [3130] = 3074,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 528,
  [3134] = 3132,
  [3135] = 3135,
  [3136] = 3079,
  [3137] = 3137,
  [3138] = 3078,
  [3139] = 3076,
  [3140] = 3075,
  [3141] = 3084,
  [3142] = 3086,
  [3143] = 3109,
  [3144] = 3111,
  [3145] = 3132,
  [3146] = 3137,
  [3147] = 3077,
  [3148] = 3148,
  [3149] = 3149,
  [3150] = 3074,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3098,
  [3154] = 3137,
  [3155] = 3132,
  [3156] = 3095,
  [3157] = 3131,
  [3158] = 3129,
  [3159] = 3117,
  [3160] = 3114,
  [3161] = 3113,
  [3162] = 3074,
  [3163] = 3111,
  [3164] = 3109,
  [3165] = 3109,
  [3166] = 3084,
  [3167] = 3076,
  [3168] = 3109,
  [3169] = 3111,
  [3170] = 3132,
  [3171] = 3137,
  [3172] = 3098,
  [3173] = 3098,
  [3174] = 3174,
  [3175] = 3086,
  [3176] = 3086,
  [3177] = 3111,
  [3178] = 3178,
  [3179] = 3114,
  [3180] = 3129,
  [3181] = 3131,
  [3182] = 3095,
  [3183] = 3132,
  [3184] = 3137,
  [3185] = 3185,
  [3186] = 3098,
  [3187] = 488,
  [3188] = 489,
  [3189] = 490,
  [3190] = 3086,
  [3191] = 3191,
  [3192] = 3109,
  [3193] = 3111,
  [3194] = 3137,
  [3195] = 3113,
  [3196] = 3114,
  [3197] = 3117,
  [3198] = 3129,
  [3199] = 3131,
  [3200] = 3095,
  [3201] = 3132,
  [3202] = 3137,
  [3203] = 3132,
  [3204] = 3095,
  [3205] = 3137,
  [3206] = 3206,
  [3207] = 3207,
  [3208] = 3208,
  [3209] = 3209,
  [3210] = 3131,
  [3211] = 3129,
  [3212] = 3117,
  [3213] = 3098,
  [3214] = 3114,
  [3215] = 3113,
  [3216] = 3086,
  [3217] = 3111,
  [3218] = 3109,
  [3219] = 3086,
  [3220] = 3220,
  [3221] = 3221,
  [3222] = 3132,
  [3223] = 3131,
  [3224] = 3129,
  [3225] = 3117,
  [3226] = 3086,
  [3227] = 3109,
  [3228] = 3111,
  [3229] = 491,
  [3230] = 3114,
  [3231] = 3113,
  [3232] = 3114,
  [3233] = 3117,
  [3234] = 3129,
  [3235] = 3131,
  [3236] = 3095,
  [3237] = 3132,
  [3238] = 3137,
  [3239] = 3113,
  [3240] = 3240,
  [3241] = 3241,
  [3242] = 3111,
  [3243] = 3109,
  [3244] = 3098,
  [3245] = 3098,
  [3246] = 3095,
  [3247] = 3098,
  [3248] = 3248,
  [3249] = 3249,
  [3250] = 3086,
  [3251] = 3109,
  [3252] = 3111,
  [3253] = 3113,
  [3254] = 3114,
  [3255] = 3117,
  [3256] = 3129,
  [3257] = 3131,
  [3258] = 3095,
  [3259] = 3132,
  [3260] = 3137,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '('
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '#'
        ? c == ' '
        : c <= '%')))
    : (c <= ')' || (c < '['
      ? (c < '='
        ? c == ','
        : c <= '=')
      : (c <= ']' || (c < '}'
        ? c == '{'
        : c <= '}')))));
}

static inline bool sym_path_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '*' || c == ','))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '>'
        : c <= '[')
      : (c <= ']' || (c >= '{' && c <= '|')))));
}

static inline bool sym_path_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '*' || c == ','))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '>'
        : c <= '[')
      : (c <= ']' || (c >= '{' && c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(228);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'c') ADVANCE(140);
      if (lookahead == 'd') ADVANCE(110);
      if (lookahead == 'e') ADVANCE(146);
      if (lookahead == 'f') ADVANCE(120);
      if (lookahead == 'g') ADVANCE(80);
      if (lookahead == 'l') ADVANCE(155);
      if (lookahead == 'm') ADVANCE(108);
      if (lookahead == 'p') ADVANCE(173);
      if (lookahead == 's') ADVANCE(105);
      if (lookahead == 'v') ADVANCE(96);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(177);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(235);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(229);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(236);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(240);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(237);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(241);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(245);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(242);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(233);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(251);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(253);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(249);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(238);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(244);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(250);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(248);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(252);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(255);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '=' &&
          lookahead != ']') ADVANCE(177);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(254);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '=' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(177);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(1138);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(177);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(1137);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != '{') ADVANCE(177);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(1138);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'c') ADVANCE(140);
      if (lookahead == 'd') ADVANCE(110);
      if (lookahead == 'e') ADVANCE(146);
      if (lookahead == 'f') ADVANCE(120);
      if (lookahead == 'g') ADVANCE(80);
      if (lookahead == 'l') ADVANCE(155);
      if (lookahead == 'm') ADVANCE(108);
      if (lookahead == 'p') ADVANCE(173);
      if (lookahead == 's') ADVANCE(144);
      if (lookahead == 'v') ADVANCE(96);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '$' &&
          (lookahead < '(' || ',' < lookahead) &&
          lookahead != '=' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(177);
      END_STATE();
    case 26:
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(1139);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != ',' &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 27:
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(180);
      END_STATE();
    case 28:
      if (lookahead == '%') ADVANCE(43);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(181);
      END_STATE();
    case 29:
      if (lookahead == '%') ADVANCE(44);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (!sym_path_character_set_1(lookahead)) ADVANCE(179);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(78);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 34:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(247);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 35:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 36:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(239);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 37:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(234);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(184);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(246);
      if (lookahead == ']') ADVANCE(49);
      if (lookahead == '^') ADVANCE(186);
      if (lookahead == '_') ADVANCE(187);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == '{') ADVANCE(76);
      if (lookahead == '|') ADVANCE(191);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(181);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (!sym_path_character_set_2(lookahead)) ADVANCE(179);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(181);
      if (lookahead == '"' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(45);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(179);
      if (lookahead == '"' ||
          lookahead == '*' ||
          lookahead == ',' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(45);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_BSLASHiffalse);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BSLASHfi);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BSLASHpart);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BSLASHpart_STAR);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart_STAR);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter_STAR);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap_STAR);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BSLASHsection);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_BSLASHsection_STAR);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec_STAR);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection_STAR);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection_STAR);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph);
      if (lookahead == '*') ADVANCE(71);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph_STAR);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_BSLASHitem);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_BSLASHitem_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(157);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(174);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(176);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(125);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(175);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(153);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(164);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(162);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(169);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'b') ADVANCE(88);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(141);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(205);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(93);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(206);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(211);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(172);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(147);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(91);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(148);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(138);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(152);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(204);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(131);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(132);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(207);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(142);
      if (lookahead == 'p') ADVANCE(121);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(142);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(98);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(126);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(102);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(154);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(143);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(127);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(137);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(158);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(134);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(156);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(103);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(139);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(109);
      if (lookahead == 'r') ADVANCE(149);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(83);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(114);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(113);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(82);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(116);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(117);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(167);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(203);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(99);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(128);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(87);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(215);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(225);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(209);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(101);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(163);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead == 'u') ADVANCE(86);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(94);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(160);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(171);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(129);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(92);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(150);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(133);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'p') ADVANCE(121);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'p') ADVANCE(123);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'q') ADVANCE(136);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(89);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(223);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(81);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(166);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(84);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(168);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(151);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(145);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(165);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(170);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(107);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(219);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(221);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(202);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(1380);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(104);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(97);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(111);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(124);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(118);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(122);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(95);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(112);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(115);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(100);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'x') ADVANCE(161);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(90);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(217);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(213);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(130);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_word);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_path);
      if (!sym_path_character_set_2(lookahead)) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_argc);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__glob_pattern_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym__);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LT);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_GT);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_BSLASH_LBRACK);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_BSLASH_RBRACK);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(194);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_BSLASH_RPAREN);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_BSLASHbegin);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_BSLASHend);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_comment);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_verbatim);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_lstlisting);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_minted);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_pycode);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_displaymath);
      if (lookahead == '*') ADVANCE(208);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_displaymath_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_equation);
      if (lookahead == '*') ADVANCE(210);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_equation_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_multline);
      if (lookahead == '*') ADVANCE(212);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_multline_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_eqnarray);
      if (lookahead == '*') ADVANCE(214);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_eqnarray_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == '*') ADVANCE(216);
      if (lookahead == 'a') ADVANCE(159);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_align_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_array);
      if (lookahead == '*') ADVANCE(218);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_array_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_split);
      if (lookahead == '*') ADVANCE(220);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_split_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_alignat);
      if (lookahead == '*') ADVANCE(222);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_alignat_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_gather);
      if (lookahead == '*') ADVANCE(224);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_gather_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_flalign);
      if (lookahead == '*') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_flalign_STAR);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_command_name);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(343);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(343);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == ')') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(343);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(603);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(471);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(417);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(343);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(539);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(478);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(610);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(610);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(472);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(345);
      if (lookahead == 'b') ADVANCE(610);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(198);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'B') ADVANCE(620);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == '[') ADVANCE(195);
      if (lookahead == 'a') ADVANCE(345);
      if (lookahead == 'b') ADVANCE(610);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(540);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(512);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'C') ADVANCE(265);
      if (lookahead == 'c') ADVANCE(1354);
      if (lookahead == 'u') ADVANCE(1027);
      if (lookahead == 'v') ADVANCE(866);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'C') ADVANCE(945);
      if (lookahead == 'c') ADVANCE(946);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'C') ADVANCE(865);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'D') ADVANCE(519);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'I') ADVANCE(795);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'L') ADVANCE(266);
      if (lookahead == 'l') ADVANCE(974);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'M') ADVANCE(292);
      if (lookahead == 'P') ADVANCE(321);
      if (lookahead == 'R') ADVANCE(823);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'O') ADVANCE(892);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'P') ADVANCE(322);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'R') ADVANCE(556);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'S') ADVANCE(1278);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(922);
      if (lookahead == 'n') ADVANCE(876);
      if (lookahead == 'v') ADVANCE(867);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(885);
      if (lookahead == 'h') ADVANCE(300);
      if (lookahead == 'i') ADVANCE(1033);
      if (lookahead == 'o') ADVANCE(706);
      if (lookahead == 'r') ADVANCE(482);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(885);
      if (lookahead == 'i') ADVANCE(1033);
      if (lookahead == 'o') ADVANCE(706);
      if (lookahead == 'r') ADVANCE(482);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(335);
      if (lookahead == 'c') ADVANCE(789);
      if (lookahead == 'e') ADVANCE(559);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(335);
      if (lookahead == 'c') ADVANCE(789);
      if (lookahead == 'e') ADVANCE(998);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(763);
      if (lookahead == 'e') ADVANCE(1113);
      if (lookahead == 'o') ADVANCE(353);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(577);
      if (lookahead == 'n') ADVANCE(878);
      if (lookahead == 'v') ADVANCE(872);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(578);
      if (lookahead == 'n') ADVANCE(878);
      if (lookahead == 'v') ADVANCE(872);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(972);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(880);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(772);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(576);
      if (lookahead == 'e') ADVANCE(814);
      if (lookahead == 't') ADVANCE(54);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(358);
      if (lookahead == 'c') ADVANCE(821);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'g') ADVANCE(713);
      if (lookahead == 'l') ADVANCE(301);
      if (lookahead == 't') ADVANCE(593);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(884);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(354);
      if (lookahead == 'g') ADVANCE(561);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(797);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(792);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(904);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(685);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(794);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(686);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(916);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(798);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(909);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(690);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1028);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(918);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(920);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(695);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(698);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(701);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(730);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1074);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(894);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(337);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(886);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(983);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1032);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(893);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(926);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(806);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(940);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(765);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(934);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(887);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1034);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(581);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(766);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(888);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(582);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(944);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(767);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(583);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1051);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(636);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(395);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(585);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(557);
      if (lookahead == 'p') ADVANCE(486);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(558);
      if (lookahead == 'p') ADVANCE(486);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(611);
      if (lookahead == 'c') ADVANCE(590);
      if (lookahead == 'p') ADVANCE(310);
      if (lookahead == 's') ADVANCE(485);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(611);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(710);
      if (lookahead == 'g') ADVANCE(1254);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(710);
      if (lookahead == 'g') ADVANCE(1255);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(710);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(304);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(1102);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(996);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(497);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(962);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(508);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(845);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(847);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(947);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(312);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(966);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1353);
      if (lookahead == 'd') ADVANCE(402);
      if (lookahead == 'n') ADVANCE(403);
      if (lookahead == 'u') ADVANCE(997);
      if (lookahead == 'v') ADVANCE(870);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1353);
      if (lookahead == 'd') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(997);
      if (lookahead == 'v') ADVANCE(870);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1353);
      if (lookahead == 'd') ADVANCE(409);
      if (lookahead == 'n') ADVANCE(403);
      if (lookahead == 'u') ADVANCE(997);
      if (lookahead == 'v') ADVANCE(870);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1353);
      if (lookahead == 'd') ADVANCE(409);
      if (lookahead == 'u') ADVANCE(997);
      if (lookahead == 'v') ADVANCE(870);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(650);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1303);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1302);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1301);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1097);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(627);
      if (lookahead == 't') ADVANCE(531);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(670);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(708);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(709);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(483);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(709);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(964);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(977);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(305);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(468);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(859);
      if (lookahead == 'r') ADVANCE(490);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(719);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(724);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(728);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(948);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(629);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(631);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(632);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(634);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(635);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(637);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(639);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(640);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(641);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(642);
      if (lookahead == 'r') ADVANCE(489);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(643);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(644);
      if (lookahead == 'f') ADVANCE(1108);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(645);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(646);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(647);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(648);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(649);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(651);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(652);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(653);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(654);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(655);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(656);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(657);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(658);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(659);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(660);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(661);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(671);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(732);
      if (lookahead == 'f') ADVANCE(1251);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(862);
      if (lookahead == 'e') ADVANCE(816);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1076);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(860);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1078);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(1079);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(327);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(201);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(1243);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(1245);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(1247);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(328);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(432);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(503);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(469);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(355);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(898);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1116);
      if (lookahead == 'v') ADVANCE(869);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(396);
      if (lookahead == 'o') ADVANCE(352);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(542);
      if (lookahead == 'i') ADVANCE(567);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(542);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(879);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1165);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1163);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(257);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1140);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1166);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(262);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1298);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1297);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(264);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1203);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1296);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(46);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1145);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1148);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1202);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1199);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1213);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1215);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1205);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1209);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1194);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1211);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1198);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1212);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1179);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1190);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1182);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1206);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1214);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1204);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1208);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1193);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1210);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1240);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1189);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1217);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1196);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1175);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1238);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1218);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1207);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1187);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1216);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1195);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1197);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1142);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1191);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1143);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1149);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1146);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1153);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(575);
      if (lookahead == 'i') ADVANCE(329);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(575);
      if (lookahead == 'i') ADVANCE(330);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(913);
      if (lookahead == 'o') ADVANCE(707);
      if (lookahead == 'r') ADVANCE(479);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(543);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(752);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1114);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(362);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(398);
      if (lookahead == 'm') ADVANCE(324);
      if (lookahead == 'u') ADVANCE(325);
      if (lookahead == 'v') ADVANCE(873);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(544);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(813);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(980);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(545);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(963);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(546);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(348);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(971);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(547);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(407);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(548);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(986);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(399);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(550);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(857);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(551);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(756);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(675);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(366);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(902);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(552);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(553);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(915);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(560);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(759);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(903);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(554);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(680);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1081);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1023);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1117);
      if (lookahead == 'i') ADVANCE(1030);
      if (lookahead == 'v') ADVANCE(874);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(802);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(982);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(284);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1118);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(803);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(984);
      if (lookahead == 'i') ADVANCE(978);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(716);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1119);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(804);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1120);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1122);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1123);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(1124);
      if (lookahead == 'i') ADVANCE(1030);
      if (lookahead == 'v') ADVANCE(874);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(937);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(951);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(807);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(858);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(371);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(381);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(386);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(388);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(391);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(968);
      if (lookahead == 'o') ADVANCE(735);
      if (lookahead == 'r') ADVANCE(484);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(400);
      if (lookahead == 'u') ADVANCE(334);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(814);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(401);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(555);
      if (lookahead == 'm') ADVANCE(883);
      if (lookahead == 'n') ADVANCE(356);
      if (lookahead == 't') ADVANCE(475);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(555);
      if (lookahead == 'm') ADVANCE(883);
      if (lookahead == 'n') ADVANCE(356);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(555);
      if (lookahead == 'm') ADVANCE(883);
      if (lookahead == 'n') ADVANCE(357);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1220);
      if (lookahead == 'n') ADVANCE(476);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1223);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1226);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1222);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1221);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1224);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1225);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1231);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1230);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1236);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1232);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1237);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(298);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(824);
      if (lookahead == 's') ADVANCE(597);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(624);
      if (lookahead == 'i') ADVANCE(779);
      if (lookahead == 'p') ADVANCE(306);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(624);
      if (lookahead == 'i') ADVANCE(779);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(999);
      if (lookahead == 't') ADVANCE(1252);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(932);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(714);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1099);
      if (lookahead == 'l') ADVANCE(827);
      if (lookahead == 's') ADVANCE(599);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1101);
      if (lookahead == 'l') ADVANCE(828);
      if (lookahead == 's') ADVANCE(600);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1103);
      if (lookahead == 'l') ADVANCE(840);
      if (lookahead == 's') ADVANCE(601);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1104);
      if (lookahead == 'l') ADVANCE(842);
      if (lookahead == 's') ADVANCE(602);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1256);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(591);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1331);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1330);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1329);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1152);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1357);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1356);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1257);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(612);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(925);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(477);
      if (lookahead == 'r') ADVANCE(278);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(477);
      if (lookahead == 'r') ADVANCE(537);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(453);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(458);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(527);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(465);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(467);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(954);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(959);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(70);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(263);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(72);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(1125);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(276);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(1002);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(621);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(494);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(826);
      if (lookahead == 'o') ADVANCE(376);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(841);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(843);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(851);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(529);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(852);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(853);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(855);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'h') ADVANCE(856);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(566);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(877);
      if (lookahead == 'o') ADVANCE(825);
      if (lookahead == 't') ADVANCE(1112);
      if (lookahead == 'u') ADVANCE(749);
      if (lookahead == 'v') ADVANCE(871);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(667);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1306);
      if (lookahead == 'v') ADVANCE(1318);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1305);
      if (lookahead == 'v') ADVANCE(1317);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1304);
      if (lookahead == 'v') ADVANCE(1316);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1031);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(330);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(340);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(781);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(336);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(919);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(753);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(861);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(769);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(331);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(787);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(574);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(359);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(778);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(953);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(722);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(956);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(942);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1038);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(830);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1040);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(832);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1041);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1042);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(838);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1043);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1044);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(950);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1045);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(844);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1046);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1047);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1048);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1049);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1052);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1053);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1054);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1055);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1056);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1057);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1058);
      if (lookahead == 'o') ADVANCE(729);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1059);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1060);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1061);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1062);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1063);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1064);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1065);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1066);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1067);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1068);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1069);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1070);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(967);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(809);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(970);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'k') ADVANCE(1135);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'k') ADVANCE(1283);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'k') ADVANCE(985);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'k') ADVANCE(319);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1281);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1280);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1279);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1219);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1337);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1336);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1335);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1181);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1242);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1340);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1334);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1339);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1333);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1292);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1291);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1300);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1338);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1332);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1290);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1299);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1328);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1327);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1326);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1295);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1365);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1359);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1294);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1364);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1358);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1293);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1363);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1362);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(881);
      if (lookahead == 'u') ADVANCE(1077);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(975);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(820);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(367);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(308);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1089);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(616);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(890);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1105);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(822);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(613);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(622);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(677);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(678);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(303);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(423);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(711);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(433);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1098);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(891);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(725);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(837);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1100);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(839);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(994);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(846);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(317);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1106);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1107);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(368);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(665);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(370);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(372);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(373);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(375);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(377);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(380);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(382);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(383);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(384);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(389);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(394);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(742);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(748);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(275);
      if (lookahead == 'v') ADVANCE(868);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(74);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(260);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1158);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1322);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1366);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1160);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1159);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1368);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(1161);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(338);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(768);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(422);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(513);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(426);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(427);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(430);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(283);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(664);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(286);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(289);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(498);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(339);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(770);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(517);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(771);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(521);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(662);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(897);
      if (lookahead == 'n') ADVANCE(364);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'm') ADVANCE(324);
      if (lookahead == 'u') ADVANCE(326);
      if (lookahead == 'v') ADVANCE(873);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1162);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(68);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1110);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(668);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(404);
      if (lookahead == 'q') ADVANCE(923);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(277);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(669);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(568);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(405);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(569);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(406);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(895);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(570);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(408);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(572);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(573);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1035);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1075);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1024);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1025);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1130);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(580);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1039);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(492);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(896);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(365);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(775);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(777);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(385);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(390);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1082);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(1111);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(877);
      if (lookahead == 'o') ADVANCE(825);
      if (lookahead == 't') ADVANCE(1112);
      if (lookahead == 'u') ADVANCE(749);
      if (lookahead == 'v') ADVANCE(871);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1115);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1071);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(900);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(762);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(981);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(333);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(791);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1026);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(901);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(793);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(796);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(754);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(782);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(757);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(783);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(758);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(805);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(760);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(811);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(905);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(784);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(906);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(799);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(907);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(800);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(908);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(785);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(687);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(910);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(691);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(911);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(927);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1094);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(935);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(936);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(938);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(939);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(941);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(943);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(949);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(952);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(727);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(731);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(584);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(774);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(812);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(369);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(776);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(737);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(738);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(739);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(740);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(741);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(743);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(744);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(745);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(746);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(747);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1086);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1087);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(1088);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(281);
      if (lookahead == 't') ADVANCE(605);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(60);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1185);
      if (lookahead == 't') ADVANCE(1184);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1282);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(849);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(586);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1029);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(589);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(592);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(588);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(313);
      if (lookahead == 'r') ADVANCE(500);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(696);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(699);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(526);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(470);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1037);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1095);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(854);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'q') ADVANCE(1090);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'q') ADVANCE(923);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1372);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1141);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(606);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1177);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1375);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1374);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1173);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1171);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1183);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1370);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1249);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1271);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(332);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1132);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(607);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1131);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(608);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1126);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(988);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1127);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1128);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(480);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(487);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(829);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(280);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(323);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1003);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(361);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(831);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(833);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(835);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(679);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1006);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1008);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1009);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(299);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1012);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1016);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(425);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1019);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(428);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1021);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(509);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(493);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(495);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(491);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(501);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(496);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(488);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(506);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(504);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(302);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(287);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(992);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(311);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(291);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(315);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(295);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(296);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(293);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1080);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(834);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(297);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(294);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(836);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(341);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1133);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(863);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(393);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1084);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'r') ADVANCE(1085);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1277);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1276);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1144);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1151);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(882);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(419);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(349);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(995);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(350);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(976);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(351);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(360);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(850);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(499);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1010);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(502);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1011);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(507);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1014);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1018);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(431);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(288);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(538);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(594);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1252);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1253);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1378);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1147);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1266);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1156);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1286);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1285);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(56);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1284);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1325);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1324);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1289);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1288);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1323);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1186);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1287);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1379);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1157);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1192);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(258);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1361);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1360);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1154);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1371);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1273);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(1274);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(378);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(864);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(587);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(628);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(720);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(420);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(615);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(421);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(617);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(914);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(347);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(505);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(424);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(921);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(429);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(434);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(435);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(436);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(437);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(438);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(439);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(440);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(441);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(442);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(443);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(444);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(445);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(446);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(447);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(448);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(449);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(450);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(451);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(452);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(454);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(455);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(456);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(459);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(460);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(461);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(462);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(463);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(464);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(466);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(510);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(530);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(595);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(723);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(848);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(363);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(630);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(596);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(633);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(638);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(523);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(598);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(969);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(374);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(387);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(392);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(532);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(533);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(534);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(410);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(626);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(1001);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(715);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(1072);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(928);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(1020);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(1022);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(764);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(411);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(717);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(412);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(718);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(993);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(721);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(726);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(960);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(961);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(965);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(750);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'v') ADVANCE(571);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'v') ADVANCE(663);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'v') ADVANCE(666);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'v') ADVANCE(875);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'w') ADVANCE(279);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'w') ADVANCE(397);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1373);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1083);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1000);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1004);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1005);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1007);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1013);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1015);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1017);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'x') ADVANCE(1036);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(1150);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(1376);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(1377);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(1275);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(761);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(755);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(564);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(565);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'y') ADVANCE(773);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'z') ADVANCE(736);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1136);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(618);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(604);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(541);
      if (lookahead == 'l') ADVANCE(271);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(525);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == 'A') ADVANCE(256);
      if (lookahead == 'C') ADVANCE(609);
      if (lookahead == 'D') ADVANCE(413);
      if (lookahead == 'G') ADVANCE(261);
      if (lookahead == 'N') ADVANCE(819);
      if (lookahead == 'P') ADVANCE(267);
      if (lookahead == 'R') ADVANCE(414);
      if (lookahead == 'S') ADVANCE(751);
      if (lookahead == 'T') ADVANCE(415);
      if (lookahead == 'V') ADVANCE(473);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == 'b') ADVANCE(618);
      if (lookahead == 'c') ADVANCE(269);
      if (lookahead == 'd') ADVANCE(416);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == 'f') ADVANCE(817);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(541);
      if (lookahead == 'l') ADVANCE(271);
      if (lookahead == 'n') ADVANCE(272);
      if (lookahead == 'p') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(418);
      if (lookahead == 's') ADVANCE(780);
      if (lookahead == 't') ADVANCE(525);
      if (lookahead == 'u') ADVANCE(979);
      if (lookahead == 'v') ADVANCE(535);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(227);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(anon_sym_BSLASHtitle);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(anon_sym_BSLASHauthor);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(anon_sym_BSLASHusepackage);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(anon_sym_BSLASHRequirePackage);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(anon_sym_BSLASHdocumentclass);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(anon_sym_BSLASHinclude);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(930);
      if (lookahead == 'g') ADVANCE(957);
      if (lookahead == 'i') ADVANCE(790);
      if (lookahead == 's') ADVANCE(1109);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfileinclude);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(anon_sym_BSLASHinput);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(924);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfile);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(810);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(anon_sym_BSLASHaddbibresource);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(anon_sym_BSLASHbibliography);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(anon_sym_BSLASHincludegraphics);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(anon_sym_BSLASHincludesvg);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(anon_sym_BSLASHincludeinkscape);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(anon_sym_BSLASHverbatiminput);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(anon_sym_BSLASHVerbatimInput);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(anon_sym_BSLASHimport);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimport);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(931);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(anon_sym_BSLASHinputfrom);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimportfrom);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(anon_sym_BSLASHincludefrom);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(anon_sym_BSLASHsubincludefrom);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(anon_sym_BSLASHcaption);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(anon_sym_BSLASHcite);
      if (lookahead == '*') ADVANCE(1164);
      if (lookahead == 'a') ADVANCE(704);
      if (lookahead == 'd') ADVANCE(320);
      if (lookahead == 'p') ADVANCE(1168);
      if (lookahead == 't') ADVANCE(1167);
      if (lookahead == 'u') ADVANCE(933);
      if (lookahead == 'y') ADVANCE(515);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(anon_sym_BSLASHcite_STAR);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(anon_sym_BSLASHCite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(1093);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(anon_sym_BSLASHnocite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet);
      if (lookahead == '*') ADVANCE(1169);
      if (lookahead == 'e') ADVANCE(1121);
      if (lookahead == 'i') ADVANCE(1073);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep);
      if (lookahead == '*') ADVANCE(1170);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet_STAR);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep_STAR);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor);
      if (lookahead == '*') ADVANCE(1172);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor_STAR);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor);
      if (lookahead == '*') ADVANCE(1174);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor_STAR);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle);
      if (lookahead == '*') ADVANCE(1176);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle_STAR);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear);
      if (lookahead == '*') ADVANCE(1178);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear_STAR);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate);
      if (lookahead == '*') ADVANCE(1180);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate_STAR);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(anon_sym_BSLASHciteurl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(anon_sym_BSLASHfullcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyearpar);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealt);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite);
      if (lookahead == '*') ADVANCE(1188);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite_STAR);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(anon_sym_BSLASHParencite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 't') ADVANCE(524);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(anon_sym_BSLASHfootfullcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcitetext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(anon_sym_BSLASHTextcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(anon_sym_BSLASHsmartcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(anon_sym_BSLASHSmartcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(anon_sym_BSLASHsupercite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite);
      if (lookahead == '*') ADVANCE(1200);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite);
      if (lookahead == '*') ADVANCE(1201);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite_STAR);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite_STAR);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(anon_sym_BSLASHvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(anon_sym_BSLASHVolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(anon_sym_BSLASHpvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(anon_sym_BSLASHPvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(anon_sym_BSLASHfvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(anon_sym_BSLASHftvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(anon_sym_BSLASHsvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(anon_sym_BSLASHSvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(anon_sym_BSLASHtvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(anon_sym_BSLASHTvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(anon_sym_BSLASHavolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(anon_sym_BSLASHAvolcite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(anon_sym_BSLASHnotecite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(anon_sym_BSLASHNotecite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(anon_sym_BSLASHpnotecite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(anon_sym_BSLASHPnotecite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(anon_sym_BSLASHfnotecite);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(anon_sym_BSLASHlabel);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(889);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(anon_sym_BSLASHref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(anon_sym_BSLASHeqref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(anon_sym_BSLASHvref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(anon_sym_BSLASHVref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(anon_sym_BSLASHautoref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(anon_sym_BSLASHpageref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(anon_sym_BSLASHcref);
      if (lookahead == '*') ADVANCE(1228);
      if (lookahead == 'r') ADVANCE(307);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(anon_sym_BSLASHCref);
      if (lookahead == '*') ADVANCE(1229);
      if (lookahead == 'r') ADVANCE(282);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(anon_sym_BSLASHcref_STAR);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(anon_sym_BSLASHCref_STAR);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1233);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1234);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(1235);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecrefs);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCrefs);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecrefs);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcpageref);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange);
      if (lookahead == '*') ADVANCE(1239);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange_STAR);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange);
      if (lookahead == '*') ADVANCE(1241);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange_STAR);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(anon_sym_BSLASHnewlabel);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand);
      if (lookahead == '*') ADVANCE(1244);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand_STAR);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand);
      if (lookahead == '*') ADVANCE(1246);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand_STAR);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand);
      if (lookahead == '*') ADVANCE(1248);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand_STAR);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator);
      if (lookahead == '*') ADVANCE(1250);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator_STAR);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(anon_sym_BSLASHdef);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(808);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(anon_sym_BSLASHlet);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(anon_sym_BSLASHleft);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(anon_sym_BSLASHbig);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1258);
      if (lookahead == 'l') ADVANCE(1262);
      if (lookahead == 'r') ADVANCE(1267);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(anon_sym_BSLASHbig);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1259);
      if (lookahead == 'l') ADVANCE(1262);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(anon_sym_BSLASHBig);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1260);
      if (lookahead == 'l') ADVANCE(1263);
      if (lookahead == 'r') ADVANCE(1268);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(anon_sym_BSLASHBig);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'g') ADVANCE(1261);
      if (lookahead == 'l') ADVANCE(1263);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(anon_sym_BSLASHbigg);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1264);
      if (lookahead == 'r') ADVANCE(1269);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(anon_sym_BSLASHbigg);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1264);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(anon_sym_BSLASHBigg);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1265);
      if (lookahead == 'r') ADVANCE(1270);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(anon_sym_BSLASHBigg);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'l') ADVANCE(1265);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(anon_sym_BSLASHbigl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(anon_sym_BSLASHBigl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(anon_sym_BSLASHright);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(anon_sym_BSLASHbigr);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(anon_sym_BSLASHBigr);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggr);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggr);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiter);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'X') ADVANCE(1272);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiterX);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(anon_sym_BSLASHnewenvironment);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewenvironment);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(anon_sym_BSLASHnewglossaryentry);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(anon_sym_BSLASHgls);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(518);
      if (lookahead == 'e') ADVANCE(815);
      if (lookahead == 'f') ADVANCE(625);
      if (lookahead == 'l') ADVANCE(619);
      if (lookahead == 'n') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(674);
      if (lookahead == 's') ADVANCE(1134);
      if (lookahead == 't') ADVANCE(522);
      if (lookahead == 'u') ADVANCE(991);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(anon_sym_BSLASHGls);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(514);
      if (lookahead == 'e') ADVANCE(801);
      if (lookahead == 'f') ADVANCE(623);
      if (lookahead == 'n') ADVANCE(314);
      if (lookahead == 'p') ADVANCE(673);
      if (lookahead == 's') ADVANCE(1129);
      if (lookahead == 't') ADVANCE(520);
      if (lookahead == 'u') ADVANCE(989);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(anon_sym_BSLASHGLS);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'd') ADVANCE(481);
      if (lookahead == 'f') ADVANCE(614);
      if (lookahead == 'n') ADVANCE(309);
      if (lookahead == 'p') ADVANCE(672);
      if (lookahead == 't') ADVANCE(516);
      if (lookahead == 'u') ADVANCE(987);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(anon_sym_BSLASHglspl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(958);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(anon_sym_BSLASHGlspl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(955);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(929);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdisp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(anon_sym_BSLASHglslink);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(anon_sym_BSLASHglstext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(anon_sym_BSLASHGlstext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(anon_sym_BSLASHGLStext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirst);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(734);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirst);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(733);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirst);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(712);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(anon_sym_BSLASHglsplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirstplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirstplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirstplural);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(anon_sym_BSLASHglsname);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsname);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSname);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(anon_sym_BSLASHglssymbol);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(anon_sym_BSLASHGlssymbol);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdesc);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsdesc);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSdesc);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseri);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1307);
      if (lookahead == 'v') ADVANCE(1313);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseri);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1308);
      if (lookahead == 'v') ADVANCE(1314);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseri);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1309);
      if (lookahead == 'v') ADVANCE(1315);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1310);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1311);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1312);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriii);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1319);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1320);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserv);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'i') ADVANCE(1321);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuservi);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuservi);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuservi);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(anon_sym_BSLASHnewacronym);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshort);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(694);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshort);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(693);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshort);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(692);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshortpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshortpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshortpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlong);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(689);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlong);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(684);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlong);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(682);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlongpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlongpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlongpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfull);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(688);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfull);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(683);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfull);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(681);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfullpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfullpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfullpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(anon_sym_BSLASHacs);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1343);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(anon_sym_BSLASHAcs);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1344);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(anon_sym_BSLASHacsp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(anon_sym_BSLASHAcsp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(anon_sym_BSLASHacl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1347);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(anon_sym_BSLASHAcl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1348);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(anon_sym_BSLASHaclp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(anon_sym_BSLASHAclp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(anon_sym_BSLASHacf);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1351);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(anon_sym_BSLASHAcf);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(1352);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(anon_sym_BSLASHacfp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(anon_sym_BSLASHAcfp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(anon_sym_BSLASHac);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1349);
      if (lookahead == 'l') ADVANCE(1345);
      if (lookahead == 'p') ADVANCE(1355);
      if (lookahead == 'r') ADVANCE(563);
      if (lookahead == 's') ADVANCE(1341);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(anon_sym_BSLASHAc);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(1350);
      if (lookahead == 'l') ADVANCE(1346);
      if (lookahead == 'r') ADVANCE(562);
      if (lookahead == 's') ADVANCE(1342);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(anon_sym_BSLASHacp);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylong);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(700);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylong);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(697);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylongpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylongpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshort);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(703);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshort);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(702);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshortpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshortpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryfullpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryfullpl);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem);
      if (lookahead == '*') ADVANCE(1367);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem_STAR);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem);
      if (lookahead == '*') ADVANCE(1369);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem_STAR);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolor);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 's') ADVANCE(511);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolorset);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(anon_sym_BSLASHcolor);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'b') ADVANCE(818);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(anon_sym_BSLASHcolorbox);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcolor);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(anon_sym_BSLASHpagecolor);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(anon_sym_BSLASHusepgflibrary);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(anon_sym_BSLASHusetikzlibrary);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(anon_sym_BSLASHtext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == 'c') ADVANCE(650);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(anon_sym_BSLASHintertext);
      if (lookahead == '*') ADVANCE(227);
      if (lookahead == ':' ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(anon_sym_shortintertext);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(177);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 36},
  [5] = {.lex_state = 36},
  [6] = {.lex_state = 7},
  [7] = {.lex_state = 36},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 7},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 7},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 7},
  [15] = {.lex_state = 36},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 36},
  [21] = {.lex_state = 36},
  [22] = {.lex_state = 36},
  [23] = {.lex_state = 36},
  [24] = {.lex_state = 36},
  [25] = {.lex_state = 36},
  [26] = {.lex_state = 36},
  [27] = {.lex_state = 36},
  [28] = {.lex_state = 36},
  [29] = {.lex_state = 36},
  [30] = {.lex_state = 36},
  [31] = {.lex_state = 36},
  [32] = {.lex_state = 36},
  [33] = {.lex_state = 36},
  [34] = {.lex_state = 36},
  [35] = {.lex_state = 36},
  [36] = {.lex_state = 36},
  [37] = {.lex_state = 36},
  [38] = {.lex_state = 36},
  [39] = {.lex_state = 36},
  [40] = {.lex_state = 36},
  [41] = {.lex_state = 36},
  [42] = {.lex_state = 36},
  [43] = {.lex_state = 36},
  [44] = {.lex_state = 36},
  [45] = {.lex_state = 36},
  [46] = {.lex_state = 36},
  [47] = {.lex_state = 36},
  [48] = {.lex_state = 36},
  [49] = {.lex_state = 36},
  [50] = {.lex_state = 36},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 35},
  [53] = {.lex_state = 37},
  [54] = {.lex_state = 37},
  [55] = {.lex_state = 6},
  [56] = {.lex_state = 6},
  [57] = {.lex_state = 5},
  [58] = {.lex_state = 35},
  [59] = {.lex_state = 10},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 3},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 10},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 34},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 10},
  [73] = {.lex_state = 37},
  [74] = {.lex_state = 9},
  [75] = {.lex_state = 8},
  [76] = {.lex_state = 37},
  [77] = {.lex_state = 10},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 9},
  [80] = {.lex_state = 8},
  [81] = {.lex_state = 35},
  [82] = {.lex_state = 8},
  [83] = {.lex_state = 9},
  [84] = {.lex_state = 37},
  [85] = {.lex_state = 35},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 37},
  [88] = {.lex_state = 10},
  [89] = {.lex_state = 8},
  [90] = {.lex_state = 35},
  [91] = {.lex_state = 9},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 35},
  [94] = {.lex_state = 37},
  [95] = {.lex_state = 35},
  [96] = {.lex_state = 37},
  [97] = {.lex_state = 34},
  [98] = {.lex_state = 37},
  [99] = {.lex_state = 35},
  [100] = {.lex_state = 34},
  [101] = {.lex_state = 37},
  [102] = {.lex_state = 35},
  [103] = {.lex_state = 10},
  [104] = {.lex_state = 37},
  [105] = {.lex_state = 35},
  [106] = {.lex_state = 35},
  [107] = {.lex_state = 37},
  [108] = {.lex_state = 37},
  [109] = {.lex_state = 35},
  [110] = {.lex_state = 34},
  [111] = {.lex_state = 37},
  [112] = {.lex_state = 37},
  [113] = {.lex_state = 35},
  [114] = {.lex_state = 37},
  [115] = {.lex_state = 34},
  [116] = {.lex_state = 35},
  [117] = {.lex_state = 35},
  [118] = {.lex_state = 34},
  [119] = {.lex_state = 35},
  [120] = {.lex_state = 34},
  [121] = {.lex_state = 37},
  [122] = {.lex_state = 35},
  [123] = {.lex_state = 37},
  [124] = {.lex_state = 37},
  [125] = {.lex_state = 35},
  [126] = {.lex_state = 35},
  [127] = {.lex_state = 34},
  [128] = {.lex_state = 34},
  [129] = {.lex_state = 37},
  [130] = {.lex_state = 35},
  [131] = {.lex_state = 35},
  [132] = {.lex_state = 35},
  [133] = {.lex_state = 34},
  [134] = {.lex_state = 35},
  [135] = {.lex_state = 37},
  [136] = {.lex_state = 34},
  [137] = {.lex_state = 37},
  [138] = {.lex_state = 35},
  [139] = {.lex_state = 35},
  [140] = {.lex_state = 37},
  [141] = {.lex_state = 37},
  [142] = {.lex_state = 34},
  [143] = {.lex_state = 37},
  [144] = {.lex_state = 37},
  [145] = {.lex_state = 35},
  [146] = {.lex_state = 34},
  [147] = {.lex_state = 35},
  [148] = {.lex_state = 35},
  [149] = {.lex_state = 34},
  [150] = {.lex_state = 37},
  [151] = {.lex_state = 37},
  [152] = {.lex_state = 37},
  [153] = {.lex_state = 35},
  [154] = {.lex_state = 34},
  [155] = {.lex_state = 37},
  [156] = {.lex_state = 35},
  [157] = {.lex_state = 35},
  [158] = {.lex_state = 37},
  [159] = {.lex_state = 34},
  [160] = {.lex_state = 34},
  [161] = {.lex_state = 34},
  [162] = {.lex_state = 35},
  [163] = {.lex_state = 34},
  [164] = {.lex_state = 35},
  [165] = {.lex_state = 34},
  [166] = {.lex_state = 37},
  [167] = {.lex_state = 37},
  [168] = {.lex_state = 37},
  [169] = {.lex_state = 37},
  [170] = {.lex_state = 35},
  [171] = {.lex_state = 34},
  [172] = {.lex_state = 34},
  [173] = {.lex_state = 35},
  [174] = {.lex_state = 36},
  [175] = {.lex_state = 36},
  [176] = {.lex_state = 34},
  [177] = {.lex_state = 36},
  [178] = {.lex_state = 36},
  [179] = {.lex_state = 34},
  [180] = {.lex_state = 35},
  [181] = {.lex_state = 37},
  [182] = {.lex_state = 10},
  [183] = {.lex_state = 37},
  [184] = {.lex_state = 10},
  [185] = {.lex_state = 35},
  [186] = {.lex_state = 34},
  [187] = {.lex_state = 36},
  [188] = {.lex_state = 34},
  [189] = {.lex_state = 36},
  [190] = {.lex_state = 37},
  [191] = {.lex_state = 35},
  [192] = {.lex_state = 37},
  [193] = {.lex_state = 35},
  [194] = {.lex_state = 10},
  [195] = {.lex_state = 10},
  [196] = {.lex_state = 36},
  [197] = {.lex_state = 34},
  [198] = {.lex_state = 34},
  [199] = {.lex_state = 36},
  [200] = {.lex_state = 35},
  [201] = {.lex_state = 37},
  [202] = {.lex_state = 10},
  [203] = {.lex_state = 37},
  [204] = {.lex_state = 35},
  [205] = {.lex_state = 10},
  [206] = {.lex_state = 34},
  [207] = {.lex_state = 36},
  [208] = {.lex_state = 36},
  [209] = {.lex_state = 34},
  [210] = {.lex_state = 10},
  [211] = {.lex_state = 10},
  [212] = {.lex_state = 37},
  [213] = {.lex_state = 35},
  [214] = {.lex_state = 37},
  [215] = {.lex_state = 35},
  [216] = {.lex_state = 34},
  [217] = {.lex_state = 36},
  [218] = {.lex_state = 34},
  [219] = {.lex_state = 36},
  [220] = {.lex_state = 35},
  [221] = {.lex_state = 10},
  [222] = {.lex_state = 37},
  [223] = {.lex_state = 37},
  [224] = {.lex_state = 10},
  [225] = {.lex_state = 35},
  [226] = {.lex_state = 34},
  [227] = {.lex_state = 36},
  [228] = {.lex_state = 36},
  [229] = {.lex_state = 34},
  [230] = {.lex_state = 37},
  [231] = {.lex_state = 10},
  [232] = {.lex_state = 35},
  [233] = {.lex_state = 35},
  [234] = {.lex_state = 10},
  [235] = {.lex_state = 37},
  [236] = {.lex_state = 34},
  [237] = {.lex_state = 34},
  [238] = {.lex_state = 36},
  [239] = {.lex_state = 36},
  [240] = {.lex_state = 36},
  [241] = {.lex_state = 37},
  [242] = {.lex_state = 35},
  [243] = {.lex_state = 37},
  [244] = {.lex_state = 10},
  [245] = {.lex_state = 35},
  [246] = {.lex_state = 10},
  [247] = {.lex_state = 34},
  [248] = {.lex_state = 34},
  [249] = {.lex_state = 34},
  [250] = {.lex_state = 37},
  [251] = {.lex_state = 10},
  [252] = {.lex_state = 35},
  [253] = {.lex_state = 10},
  [254] = {.lex_state = 37},
  [255] = {.lex_state = 10},
  [256] = {.lex_state = 37},
  [257] = {.lex_state = 35},
  [258] = {.lex_state = 35},
  [259] = {.lex_state = 36},
  [260] = {.lex_state = 36},
  [261] = {.lex_state = 13},
  [262] = {.lex_state = 13},
  [263] = {.lex_state = 13},
  [264] = {.lex_state = 13},
  [265] = {.lex_state = 13},
  [266] = {.lex_state = 13},
  [267] = {.lex_state = 13},
  [268] = {.lex_state = 13},
  [269] = {.lex_state = 13},
  [270] = {.lex_state = 13},
  [271] = {.lex_state = 13},
  [272] = {.lex_state = 13},
  [273] = {.lex_state = 13},
  [274] = {.lex_state = 13},
  [275] = {.lex_state = 13},
  [276] = {.lex_state = 14},
  [277] = {.lex_state = 14},
  [278] = {.lex_state = 14},
  [279] = {.lex_state = 34},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 14},
  [282] = {.lex_state = 34},
  [283] = {.lex_state = 14},
  [284] = {.lex_state = 14},
  [285] = {.lex_state = 37},
  [286] = {.lex_state = 10},
  [287] = {.lex_state = 35},
  [288] = {.lex_state = 37},
  [289] = {.lex_state = 10},
  [290] = {.lex_state = 35},
  [291] = {.lex_state = 15},
  [292] = {.lex_state = 15},
  [293] = {.lex_state = 25},
  [294] = {.lex_state = 15},
  [295] = {.lex_state = 15},
  [296] = {.lex_state = 15},
  [297] = {.lex_state = 15},
  [298] = {.lex_state = 15},
  [299] = {.lex_state = 15},
  [300] = {.lex_state = 15},
  [301] = {.lex_state = 15},
  [302] = {.lex_state = 15},
  [303] = {.lex_state = 15},
  [304] = {.lex_state = 15},
  [305] = {.lex_state = 15},
  [306] = {.lex_state = 15},
  [307] = {.lex_state = 15},
  [308] = {.lex_state = 15},
  [309] = {.lex_state = 15},
  [310] = {.lex_state = 15},
  [311] = {.lex_state = 15},
  [312] = {.lex_state = 15},
  [313] = {.lex_state = 15},
  [314] = {.lex_state = 15},
  [315] = {.lex_state = 15},
  [316] = {.lex_state = 15},
  [317] = {.lex_state = 15},
  [318] = {.lex_state = 15},
  [319] = {.lex_state = 21},
  [320] = {.lex_state = 21},
  [321] = {.lex_state = 15},
  [322] = {.lex_state = 21},
  [323] = {.lex_state = 21},
  [324] = {.lex_state = 21},
  [325] = {.lex_state = 21},
  [326] = {.lex_state = 21},
  [327] = {.lex_state = 21},
  [328] = {.lex_state = 21},
  [329] = {.lex_state = 15},
  [330] = {.lex_state = 21},
  [331] = {.lex_state = 21},
  [332] = {.lex_state = 21},
  [333] = {.lex_state = 15},
  [334] = {.lex_state = 15},
  [335] = {.lex_state = 15},
  [336] = {.lex_state = 15},
  [337] = {.lex_state = 15},
  [338] = {.lex_state = 15},
  [339] = {.lex_state = 15},
  [340] = {.lex_state = 15},
  [341] = {.lex_state = 15},
  [342] = {.lex_state = 15},
  [343] = {.lex_state = 15},
  [344] = {.lex_state = 13},
  [345] = {.lex_state = 13},
  [346] = {.lex_state = 15},
  [347] = {.lex_state = 14},
  [348] = {.lex_state = 14},
  [349] = {.lex_state = 15},
  [350] = {.lex_state = 21},
  [351] = {.lex_state = 21},
  [352] = {.lex_state = 36},
  [353] = {.lex_state = 36},
  [354] = {.lex_state = 36},
  [355] = {.lex_state = 36},
  [356] = {.lex_state = 36},
  [357] = {.lex_state = 36},
  [358] = {.lex_state = 36},
  [359] = {.lex_state = 36},
  [360] = {.lex_state = 36},
  [361] = {.lex_state = 36},
  [362] = {.lex_state = 36},
  [363] = {.lex_state = 36},
  [364] = {.lex_state = 36},
  [365] = {.lex_state = 36},
  [366] = {.lex_state = 36},
  [367] = {.lex_state = 36},
  [368] = {.lex_state = 36},
  [369] = {.lex_state = 36},
  [370] = {.lex_state = 36},
  [371] = {.lex_state = 36},
  [372] = {.lex_state = 36},
  [373] = {.lex_state = 36},
  [374] = {.lex_state = 36},
  [375] = {.lex_state = 36},
  [376] = {.lex_state = 36},
  [377] = {.lex_state = 36},
  [378] = {.lex_state = 36},
  [379] = {.lex_state = 36},
  [380] = {.lex_state = 36},
  [381] = {.lex_state = 36},
  [382] = {.lex_state = 36},
  [383] = {.lex_state = 36},
  [384] = {.lex_state = 36},
  [385] = {.lex_state = 36},
  [386] = {.lex_state = 36},
  [387] = {.lex_state = 36},
  [388] = {.lex_state = 36},
  [389] = {.lex_state = 36},
  [390] = {.lex_state = 36},
  [391] = {.lex_state = 36},
  [392] = {.lex_state = 36},
  [393] = {.lex_state = 36},
  [394] = {.lex_state = 36},
  [395] = {.lex_state = 36},
  [396] = {.lex_state = 36},
  [397] = {.lex_state = 36},
  [398] = {.lex_state = 36},
  [399] = {.lex_state = 36},
  [400] = {.lex_state = 36},
  [401] = {.lex_state = 36},
  [402] = {.lex_state = 36},
  [403] = {.lex_state = 36},
  [404] = {.lex_state = 36},
  [405] = {.lex_state = 36},
  [406] = {.lex_state = 36},
  [407] = {.lex_state = 36},
  [408] = {.lex_state = 36},
  [409] = {.lex_state = 36},
  [410] = {.lex_state = 36},
  [411] = {.lex_state = 36},
  [412] = {.lex_state = 36},
  [413] = {.lex_state = 36},
  [414] = {.lex_state = 36},
  [415] = {.lex_state = 36},
  [416] = {.lex_state = 36},
  [417] = {.lex_state = 36},
  [418] = {.lex_state = 36},
  [419] = {.lex_state = 36},
  [420] = {.lex_state = 36},
  [421] = {.lex_state = 36},
  [422] = {.lex_state = 36},
  [423] = {.lex_state = 36},
  [424] = {.lex_state = 36},
  [425] = {.lex_state = 36},
  [426] = {.lex_state = 36},
  [427] = {.lex_state = 36},
  [428] = {.lex_state = 36},
  [429] = {.lex_state = 36},
  [430] = {.lex_state = 36},
  [431] = {.lex_state = 36},
  [432] = {.lex_state = 36},
  [433] = {.lex_state = 16, .external_lex_state = 2},
  [434] = {.lex_state = 36},
  [435] = {.lex_state = 36},
  [436] = {.lex_state = 36},
  [437] = {.lex_state = 16},
  [438] = {.lex_state = 36},
  [439] = {.lex_state = 36},
  [440] = {.lex_state = 36},
  [441] = {.lex_state = 36},
  [442] = {.lex_state = 36},
  [443] = {.lex_state = 34},
  [444] = {.lex_state = 36},
  [445] = {.lex_state = 36},
  [446] = {.lex_state = 34},
  [447] = {.lex_state = 36},
  [448] = {.lex_state = 36},
  [449] = {.lex_state = 36},
  [450] = {.lex_state = 36},
  [451] = {.lex_state = 36},
  [452] = {.lex_state = 36},
  [453] = {.lex_state = 36},
  [454] = {.lex_state = 36},
  [455] = {.lex_state = 34},
  [456] = {.lex_state = 34},
  [457] = {.lex_state = 34},
  [458] = {.lex_state = 34},
  [459] = {.lex_state = 34},
  [460] = {.lex_state = 34},
  [461] = {.lex_state = 34},
  [462] = {.lex_state = 34},
  [463] = {.lex_state = 36},
  [464] = {.lex_state = 36},
  [465] = {.lex_state = 36},
  [466] = {.lex_state = 34},
  [467] = {.lex_state = 34},
  [468] = {.lex_state = 36},
  [469] = {.lex_state = 34},
  [470] = {.lex_state = 34},
  [471] = {.lex_state = 34},
  [472] = {.lex_state = 34},
  [473] = {.lex_state = 34},
  [474] = {.lex_state = 34},
  [475] = {.lex_state = 34},
  [476] = {.lex_state = 34},
  [477] = {.lex_state = 34},
  [478] = {.lex_state = 34},
  [479] = {.lex_state = 34},
  [480] = {.lex_state = 34},
  [481] = {.lex_state = 34},
  [482] = {.lex_state = 36},
  [483] = {.lex_state = 36},
  [484] = {.lex_state = 34},
  [485] = {.lex_state = 34},
  [486] = {.lex_state = 36},
  [487] = {.lex_state = 34},
  [488] = {.lex_state = 36},
  [489] = {.lex_state = 36},
  [490] = {.lex_state = 36},
  [491] = {.lex_state = 36},
  [492] = {.lex_state = 36},
  [493] = {.lex_state = 36},
  [494] = {.lex_state = 34},
  [495] = {.lex_state = 36},
  [496] = {.lex_state = 34},
  [497] = {.lex_state = 34},
  [498] = {.lex_state = 34},
  [499] = {.lex_state = 34},
  [500] = {.lex_state = 34},
  [501] = {.lex_state = 36},
  [502] = {.lex_state = 34},
  [503] = {.lex_state = 36},
  [504] = {.lex_state = 34},
  [505] = {.lex_state = 34},
  [506] = {.lex_state = 34},
  [507] = {.lex_state = 34},
  [508] = {.lex_state = 34},
  [509] = {.lex_state = 34},
  [510] = {.lex_state = 34},
  [511] = {.lex_state = 34},
  [512] = {.lex_state = 36},
  [513] = {.lex_state = 34},
  [514] = {.lex_state = 34},
  [515] = {.lex_state = 36},
  [516] = {.lex_state = 36},
  [517] = {.lex_state = 34},
  [518] = {.lex_state = 34},
  [519] = {.lex_state = 34},
  [520] = {.lex_state = 34},
  [521] = {.lex_state = 34},
  [522] = {.lex_state = 34},
  [523] = {.lex_state = 34},
  [524] = {.lex_state = 34},
  [525] = {.lex_state = 36},
  [526] = {.lex_state = 36},
  [527] = {.lex_state = 36},
  [528] = {.lex_state = 36},
  [529] = {.lex_state = 36},
  [530] = {.lex_state = 36},
  [531] = {.lex_state = 36},
  [532] = {.lex_state = 36},
  [533] = {.lex_state = 36},
  [534] = {.lex_state = 36},
  [535] = {.lex_state = 36},
  [536] = {.lex_state = 36},
  [537] = {.lex_state = 36},
  [538] = {.lex_state = 36},
  [539] = {.lex_state = 36},
  [540] = {.lex_state = 36},
  [541] = {.lex_state = 36},
  [542] = {.lex_state = 36},
  [543] = {.lex_state = 36},
  [544] = {.lex_state = 36},
  [545] = {.lex_state = 36},
  [546] = {.lex_state = 36},
  [547] = {.lex_state = 36},
  [548] = {.lex_state = 36},
  [549] = {.lex_state = 36},
  [550] = {.lex_state = 36},
  [551] = {.lex_state = 36},
  [552] = {.lex_state = 36},
  [553] = {.lex_state = 36},
  [554] = {.lex_state = 36},
  [555] = {.lex_state = 36},
  [556] = {.lex_state = 36},
  [557] = {.lex_state = 36},
  [558] = {.lex_state = 36},
  [559] = {.lex_state = 36},
  [560] = {.lex_state = 36},
  [561] = {.lex_state = 36},
  [562] = {.lex_state = 36},
  [563] = {.lex_state = 36},
  [564] = {.lex_state = 34},
  [565] = {.lex_state = 36},
  [566] = {.lex_state = 36},
  [567] = {.lex_state = 36},
  [568] = {.lex_state = 36},
  [569] = {.lex_state = 36},
  [570] = {.lex_state = 36},
  [571] = {.lex_state = 36},
  [572] = {.lex_state = 36},
  [573] = {.lex_state = 36},
  [574] = {.lex_state = 36},
  [575] = {.lex_state = 36},
  [576] = {.lex_state = 36},
  [577] = {.lex_state = 34},
  [578] = {.lex_state = 34},
  [579] = {.lex_state = 34},
  [580] = {.lex_state = 34},
  [581] = {.lex_state = 34},
  [582] = {.lex_state = 34},
  [583] = {.lex_state = 36},
  [584] = {.lex_state = 36},
  [585] = {.lex_state = 36},
  [586] = {.lex_state = 36},
  [587] = {.lex_state = 36},
  [588] = {.lex_state = 36},
  [589] = {.lex_state = 36},
  [590] = {.lex_state = 36},
  [591] = {.lex_state = 36},
  [592] = {.lex_state = 36},
  [593] = {.lex_state = 34},
  [594] = {.lex_state = 34},
  [595] = {.lex_state = 36},
  [596] = {.lex_state = 36},
  [597] = {.lex_state = 36},
  [598] = {.lex_state = 36},
  [599] = {.lex_state = 36},
  [600] = {.lex_state = 36},
  [601] = {.lex_state = 36},
  [602] = {.lex_state = 36},
  [603] = {.lex_state = 34},
  [604] = {.lex_state = 36},
  [605] = {.lex_state = 34},
  [606] = {.lex_state = 34},
  [607] = {.lex_state = 34},
  [608] = {.lex_state = 34},
  [609] = {.lex_state = 34},
  [610] = {.lex_state = 34},
  [611] = {.lex_state = 34},
  [612] = {.lex_state = 34},
  [613] = {.lex_state = 36},
  [614] = {.lex_state = 36},
  [615] = {.lex_state = 36},
  [616] = {.lex_state = 36},
  [617] = {.lex_state = 34},
  [618] = {.lex_state = 36},
  [619] = {.lex_state = 36},
  [620] = {.lex_state = 36},
  [621] = {.lex_state = 36},
  [622] = {.lex_state = 36},
  [623] = {.lex_state = 36},
  [624] = {.lex_state = 34},
  [625] = {.lex_state = 36},
  [626] = {.lex_state = 36},
  [627] = {.lex_state = 36},
  [628] = {.lex_state = 36},
  [629] = {.lex_state = 36},
  [630] = {.lex_state = 36},
  [631] = {.lex_state = 36},
  [632] = {.lex_state = 36},
  [633] = {.lex_state = 36},
  [634] = {.lex_state = 36},
  [635] = {.lex_state = 34},
  [636] = {.lex_state = 34},
  [637] = {.lex_state = 34},
  [638] = {.lex_state = 34},
  [639] = {.lex_state = 34},
  [640] = {.lex_state = 34},
  [641] = {.lex_state = 35},
  [642] = {.lex_state = 35},
  [643] = {.lex_state = 10},
  [644] = {.lex_state = 10},
  [645] = {.lex_state = 10},
  [646] = {.lex_state = 10},
  [647] = {.lex_state = 10},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 10},
  [650] = {.lex_state = 10},
  [651] = {.lex_state = 10},
  [652] = {.lex_state = 34},
  [653] = {.lex_state = 10},
  [654] = {.lex_state = 10},
  [655] = {.lex_state = 10},
  [656] = {.lex_state = 10},
  [657] = {.lex_state = 10},
  [658] = {.lex_state = 35},
  [659] = {.lex_state = 10},
  [660] = {.lex_state = 10},
  [661] = {.lex_state = 10},
  [662] = {.lex_state = 10},
  [663] = {.lex_state = 10},
  [664] = {.lex_state = 10},
  [665] = {.lex_state = 10},
  [666] = {.lex_state = 10},
  [667] = {.lex_state = 10},
  [668] = {.lex_state = 10},
  [669] = {.lex_state = 10},
  [670] = {.lex_state = 10},
  [671] = {.lex_state = 10},
  [672] = {.lex_state = 10},
  [673] = {.lex_state = 34},
  [674] = {.lex_state = 10},
  [675] = {.lex_state = 10},
  [676] = {.lex_state = 10},
  [677] = {.lex_state = 10},
  [678] = {.lex_state = 10},
  [679] = {.lex_state = 10},
  [680] = {.lex_state = 10},
  [681] = {.lex_state = 10},
  [682] = {.lex_state = 10},
  [683] = {.lex_state = 10},
  [684] = {.lex_state = 10},
  [685] = {.lex_state = 38, .external_lex_state = 2},
  [686] = {.lex_state = 10},
  [687] = {.lex_state = 10},
  [688] = {.lex_state = 10},
  [689] = {.lex_state = 10},
  [690] = {.lex_state = 10},
  [691] = {.lex_state = 10},
  [692] = {.lex_state = 10},
  [693] = {.lex_state = 10},
  [694] = {.lex_state = 34},
  [695] = {.lex_state = 10},
  [696] = {.lex_state = 37},
  [697] = {.lex_state = 37},
  [698] = {.lex_state = 37},
  [699] = {.lex_state = 37},
  [700] = {.lex_state = 37},
  [701] = {.lex_state = 37},
  [702] = {.lex_state = 37},
  [703] = {.lex_state = 10},
  [704] = {.lex_state = 10},
  [705] = {.lex_state = 10},
  [706] = {.lex_state = 10},
  [707] = {.lex_state = 10},
  [708] = {.lex_state = 10},
  [709] = {.lex_state = 10},
  [710] = {.lex_state = 10},
  [711] = {.lex_state = 10},
  [712] = {.lex_state = 10},
  [713] = {.lex_state = 10},
  [714] = {.lex_state = 35},
  [715] = {.lex_state = 37},
  [716] = {.lex_state = 37},
  [717] = {.lex_state = 37},
  [718] = {.lex_state = 37},
  [719] = {.lex_state = 37},
  [720] = {.lex_state = 37},
  [721] = {.lex_state = 37},
  [722] = {.lex_state = 37},
  [723] = {.lex_state = 35},
  [724] = {.lex_state = 10},
  [725] = {.lex_state = 10},
  [726] = {.lex_state = 34},
  [727] = {.lex_state = 10},
  [728] = {.lex_state = 10},
  [729] = {.lex_state = 35},
  [730] = {.lex_state = 35},
  [731] = {.lex_state = 35},
  [732] = {.lex_state = 35},
  [733] = {.lex_state = 35},
  [734] = {.lex_state = 35},
  [735] = {.lex_state = 35},
  [736] = {.lex_state = 35},
  [737] = {.lex_state = 35},
  [738] = {.lex_state = 35},
  [739] = {.lex_state = 35},
  [740] = {.lex_state = 35},
  [741] = {.lex_state = 10},
  [742] = {.lex_state = 10},
  [743] = {.lex_state = 10},
  [744] = {.lex_state = 10},
  [745] = {.lex_state = 10},
  [746] = {.lex_state = 10},
  [747] = {.lex_state = 10},
  [748] = {.lex_state = 10},
  [749] = {.lex_state = 35},
  [750] = {.lex_state = 35},
  [751] = {.lex_state = 34},
  [752] = {.lex_state = 35},
  [753] = {.lex_state = 35},
  [754] = {.lex_state = 35},
  [755] = {.lex_state = 35},
  [756] = {.lex_state = 10},
  [757] = {.lex_state = 35},
  [758] = {.lex_state = 35},
  [759] = {.lex_state = 35},
  [760] = {.lex_state = 10},
  [761] = {.lex_state = 10},
  [762] = {.lex_state = 10},
  [763] = {.lex_state = 10},
  [764] = {.lex_state = 37},
  [765] = {.lex_state = 37},
  [766] = {.lex_state = 37},
  [767] = {.lex_state = 37},
  [768] = {.lex_state = 37},
  [769] = {.lex_state = 37},
  [770] = {.lex_state = 37},
  [771] = {.lex_state = 35},
  [772] = {.lex_state = 37},
  [773] = {.lex_state = 37},
  [774] = {.lex_state = 37},
  [775] = {.lex_state = 37},
  [776] = {.lex_state = 37},
  [777] = {.lex_state = 37},
  [778] = {.lex_state = 35},
  [779] = {.lex_state = 37},
  [780] = {.lex_state = 37},
  [781] = {.lex_state = 37},
  [782] = {.lex_state = 37},
  [783] = {.lex_state = 37},
  [784] = {.lex_state = 35},
  [785] = {.lex_state = 37},
  [786] = {.lex_state = 37},
  [787] = {.lex_state = 37},
  [788] = {.lex_state = 37},
  [789] = {.lex_state = 35},
  [790] = {.lex_state = 37},
  [791] = {.lex_state = 37},
  [792] = {.lex_state = 37},
  [793] = {.lex_state = 35},
  [794] = {.lex_state = 37},
  [795] = {.lex_state = 37},
  [796] = {.lex_state = 35},
  [797] = {.lex_state = 37},
  [798] = {.lex_state = 35},
  [799] = {.lex_state = 35},
  [800] = {.lex_state = 10},
  [801] = {.lex_state = 10},
  [802] = {.lex_state = 35},
  [803] = {.lex_state = 37},
  [804] = {.lex_state = 37},
  [805] = {.lex_state = 37},
  [806] = {.lex_state = 37},
  [807] = {.lex_state = 37},
  [808] = {.lex_state = 37},
  [809] = {.lex_state = 37},
  [810] = {.lex_state = 37},
  [811] = {.lex_state = 35},
  [812] = {.lex_state = 10},
  [813] = {.lex_state = 35},
  [814] = {.lex_state = 35},
  [815] = {.lex_state = 35},
  [816] = {.lex_state = 35},
  [817] = {.lex_state = 35},
  [818] = {.lex_state = 35},
  [819] = {.lex_state = 35},
  [820] = {.lex_state = 35},
  [821] = {.lex_state = 35},
  [822] = {.lex_state = 35},
  [823] = {.lex_state = 35},
  [824] = {.lex_state = 35},
  [825] = {.lex_state = 35},
  [826] = {.lex_state = 35},
  [827] = {.lex_state = 35},
  [828] = {.lex_state = 35},
  [829] = {.lex_state = 35},
  [830] = {.lex_state = 35},
  [831] = {.lex_state = 35},
  [832] = {.lex_state = 35},
  [833] = {.lex_state = 35},
  [834] = {.lex_state = 35},
  [835] = {.lex_state = 35},
  [836] = {.lex_state = 35},
  [837] = {.lex_state = 35},
  [838] = {.lex_state = 35},
  [839] = {.lex_state = 35},
  [840] = {.lex_state = 35},
  [841] = {.lex_state = 35},
  [842] = {.lex_state = 35},
  [843] = {.lex_state = 37},
  [844] = {.lex_state = 37},
  [845] = {.lex_state = 37},
  [846] = {.lex_state = 37},
  [847] = {.lex_state = 37},
  [848] = {.lex_state = 37},
  [849] = {.lex_state = 37},
  [850] = {.lex_state = 35},
  [851] = {.lex_state = 37},
  [852] = {.lex_state = 37},
  [853] = {.lex_state = 37},
  [854] = {.lex_state = 37},
  [855] = {.lex_state = 37},
  [856] = {.lex_state = 37},
  [857] = {.lex_state = 37},
  [858] = {.lex_state = 37},
  [859] = {.lex_state = 37},
  [860] = {.lex_state = 37},
  [861] = {.lex_state = 37},
  [862] = {.lex_state = 37},
  [863] = {.lex_state = 37},
  [864] = {.lex_state = 37},
  [865] = {.lex_state = 37},
  [866] = {.lex_state = 37},
  [867] = {.lex_state = 37},
  [868] = {.lex_state = 37},
  [869] = {.lex_state = 37},
  [870] = {.lex_state = 37},
  [871] = {.lex_state = 37},
  [872] = {.lex_state = 35},
  [873] = {.lex_state = 35},
  [874] = {.lex_state = 35},
  [875] = {.lex_state = 35},
  [876] = {.lex_state = 35},
  [877] = {.lex_state = 35},
  [878] = {.lex_state = 35},
  [879] = {.lex_state = 35},
  [880] = {.lex_state = 35},
  [881] = {.lex_state = 35},
  [882] = {.lex_state = 35},
  [883] = {.lex_state = 35},
  [884] = {.lex_state = 17, .external_lex_state = 2},
  [885] = {.lex_state = 10},
  [886] = {.lex_state = 10},
  [887] = {.lex_state = 34},
  [888] = {.lex_state = 38},
  [889] = {.lex_state = 10},
  [890] = {.lex_state = 12, .external_lex_state = 2},
  [891] = {.lex_state = 37},
  [892] = {.lex_state = 35},
  [893] = {.lex_state = 10},
  [894] = {.lex_state = 35},
  [895] = {.lex_state = 35},
  [896] = {.lex_state = 34},
  [897] = {.lex_state = 34},
  [898] = {.lex_state = 37},
  [899] = {.lex_state = 37},
  [900] = {.lex_state = 10},
  [901] = {.lex_state = 37},
  [902] = {.lex_state = 35},
  [903] = {.lex_state = 34},
  [904] = {.lex_state = 35},
  [905] = {.lex_state = 37},
  [906] = {.lex_state = 11, .external_lex_state = 2},
  [907] = {.lex_state = 34},
  [908] = {.lex_state = 34},
  [909] = {.lex_state = 34},
  [910] = {.lex_state = 37},
  [911] = {.lex_state = 11},
  [912] = {.lex_state = 37},
  [913] = {.lex_state = 34},
  [914] = {.lex_state = 34},
  [915] = {.lex_state = 34},
  [916] = {.lex_state = 37},
  [917] = {.lex_state = 34},
  [918] = {.lex_state = 34},
  [919] = {.lex_state = 34},
  [920] = {.lex_state = 34},
  [921] = {.lex_state = 34},
  [922] = {.lex_state = 34},
  [923] = {.lex_state = 34},
  [924] = {.lex_state = 34},
  [925] = {.lex_state = 34},
  [926] = {.lex_state = 34},
  [927] = {.lex_state = 34},
  [928] = {.lex_state = 34},
  [929] = {.lex_state = 34},
  [930] = {.lex_state = 37},
  [931] = {.lex_state = 34},
  [932] = {.lex_state = 34},
  [933] = {.lex_state = 34},
  [934] = {.lex_state = 34},
  [935] = {.lex_state = 34},
  [936] = {.lex_state = 34},
  [937] = {.lex_state = 34},
  [938] = {.lex_state = 34},
  [939] = {.lex_state = 34},
  [940] = {.lex_state = 34},
  [941] = {.lex_state = 34},
  [942] = {.lex_state = 34},
  [943] = {.lex_state = 34},
  [944] = {.lex_state = 34},
  [945] = {.lex_state = 10},
  [946] = {.lex_state = 34},
  [947] = {.lex_state = 34},
  [948] = {.lex_state = 34},
  [949] = {.lex_state = 34},
  [950] = {.lex_state = 34},
  [951] = {.lex_state = 34},
  [952] = {.lex_state = 34},
  [953] = {.lex_state = 34},
  [954] = {.lex_state = 34},
  [955] = {.lex_state = 34},
  [956] = {.lex_state = 34},
  [957] = {.lex_state = 34},
  [958] = {.lex_state = 34},
  [959] = {.lex_state = 34},
  [960] = {.lex_state = 34},
  [961] = {.lex_state = 34},
  [962] = {.lex_state = 34},
  [963] = {.lex_state = 17},
  [964] = {.lex_state = 34},
  [965] = {.lex_state = 34},
  [966] = {.lex_state = 34},
  [967] = {.lex_state = 34},
  [968] = {.lex_state = 34},
  [969] = {.lex_state = 34},
  [970] = {.lex_state = 34},
  [971] = {.lex_state = 34},
  [972] = {.lex_state = 10},
  [973] = {.lex_state = 10},
  [974] = {.lex_state = 34},
  [975] = {.lex_state = 10},
  [976] = {.lex_state = 35},
  [977] = {.lex_state = 34},
  [978] = {.lex_state = 34},
  [979] = {.lex_state = 34},
  [980] = {.lex_state = 34},
  [981] = {.lex_state = 34},
  [982] = {.lex_state = 12},
  [983] = {.lex_state = 34},
  [984] = {.lex_state = 34},
  [985] = {.lex_state = 34},
  [986] = {.lex_state = 34},
  [987] = {.lex_state = 34},
  [988] = {.lex_state = 34},
  [989] = {.lex_state = 34},
  [990] = {.lex_state = 34},
  [991] = {.lex_state = 34},
  [992] = {.lex_state = 34},
  [993] = {.lex_state = 37},
  [994] = {.lex_state = 35},
  [995] = {.lex_state = 34},
  [996] = {.lex_state = 34},
  [997] = {.lex_state = 34},
  [998] = {.lex_state = 34},
  [999] = {.lex_state = 34},
  [1000] = {.lex_state = 34},
  [1001] = {.lex_state = 34},
  [1002] = {.lex_state = 34},
  [1003] = {.lex_state = 34},
  [1004] = {.lex_state = 35},
  [1005] = {.lex_state = 34},
  [1006] = {.lex_state = 34},
  [1007] = {.lex_state = 34},
  [1008] = {.lex_state = 34},
  [1009] = {.lex_state = 34},
  [1010] = {.lex_state = 34},
  [1011] = {.lex_state = 34},
  [1012] = {.lex_state = 34},
  [1013] = {.lex_state = 34},
  [1014] = {.lex_state = 34},
  [1015] = {.lex_state = 34},
  [1016] = {.lex_state = 10},
  [1017] = {.lex_state = 34},
  [1018] = {.lex_state = 35},
  [1019] = {.lex_state = 34},
  [1020] = {.lex_state = 34},
  [1021] = {.lex_state = 34},
  [1022] = {.lex_state = 34},
  [1023] = {.lex_state = 34},
  [1024] = {.lex_state = 35},
  [1025] = {.lex_state = 34},
  [1026] = {.lex_state = 34},
  [1027] = {.lex_state = 34},
  [1028] = {.lex_state = 34},
  [1029] = {.lex_state = 34},
  [1030] = {.lex_state = 34},
  [1031] = {.lex_state = 34},
  [1032] = {.lex_state = 34},
  [1033] = {.lex_state = 34},
  [1034] = {.lex_state = 34},
  [1035] = {.lex_state = 34},
  [1036] = {.lex_state = 34},
  [1037] = {.lex_state = 34},
  [1038] = {.lex_state = 34},
  [1039] = {.lex_state = 34},
  [1040] = {.lex_state = 34},
  [1041] = {.lex_state = 34},
  [1042] = {.lex_state = 34},
  [1043] = {.lex_state = 10},
  [1044] = {.lex_state = 34},
  [1045] = {.lex_state = 34},
  [1046] = {.lex_state = 35},
  [1047] = {.lex_state = 35},
  [1048] = {.lex_state = 35},
  [1049] = {.lex_state = 10},
  [1050] = {.lex_state = 10},
  [1051] = {.lex_state = 10},
  [1052] = {.lex_state = 35},
  [1053] = {.lex_state = 10},
  [1054] = {.lex_state = 35},
  [1055] = {.lex_state = 10},
  [1056] = {.lex_state = 35},
  [1057] = {.lex_state = 10},
  [1058] = {.lex_state = 10},
  [1059] = {.lex_state = 10},
  [1060] = {.lex_state = 10},
  [1061] = {.lex_state = 10},
  [1062] = {.lex_state = 10},
  [1063] = {.lex_state = 10},
  [1064] = {.lex_state = 10},
  [1065] = {.lex_state = 10},
  [1066] = {.lex_state = 10},
  [1067] = {.lex_state = 10},
  [1068] = {.lex_state = 10},
  [1069] = {.lex_state = 10},
  [1070] = {.lex_state = 10},
  [1071] = {.lex_state = 10},
  [1072] = {.lex_state = 10},
  [1073] = {.lex_state = 10},
  [1074] = {.lex_state = 10},
  [1075] = {.lex_state = 10},
  [1076] = {.lex_state = 10},
  [1077] = {.lex_state = 35},
  [1078] = {.lex_state = 35},
  [1079] = {.lex_state = 10},
  [1080] = {.lex_state = 10},
  [1081] = {.lex_state = 10},
  [1082] = {.lex_state = 35},
  [1083] = {.lex_state = 35},
  [1084] = {.lex_state = 35},
  [1085] = {.lex_state = 35},
  [1086] = {.lex_state = 35},
  [1087] = {.lex_state = 10},
  [1088] = {.lex_state = 10},
  [1089] = {.lex_state = 10},
  [1090] = {.lex_state = 10},
  [1091] = {.lex_state = 10},
  [1092] = {.lex_state = 10},
  [1093] = {.lex_state = 10},
  [1094] = {.lex_state = 10},
  [1095] = {.lex_state = 10},
  [1096] = {.lex_state = 10},
  [1097] = {.lex_state = 10},
  [1098] = {.lex_state = 10},
  [1099] = {.lex_state = 10},
  [1100] = {.lex_state = 10},
  [1101] = {.lex_state = 10},
  [1102] = {.lex_state = 10},
  [1103] = {.lex_state = 10},
  [1104] = {.lex_state = 10},
  [1105] = {.lex_state = 10},
  [1106] = {.lex_state = 10},
  [1107] = {.lex_state = 10},
  [1108] = {.lex_state = 10},
  [1109] = {.lex_state = 10},
  [1110] = {.lex_state = 10},
  [1111] = {.lex_state = 10},
  [1112] = {.lex_state = 10},
  [1113] = {.lex_state = 10},
  [1114] = {.lex_state = 10},
  [1115] = {.lex_state = 10},
  [1116] = {.lex_state = 10},
  [1117] = {.lex_state = 10},
  [1118] = {.lex_state = 37},
  [1119] = {.lex_state = 37},
  [1120] = {.lex_state = 37},
  [1121] = {.lex_state = 37},
  [1122] = {.lex_state = 10},
  [1123] = {.lex_state = 37},
  [1124] = {.lex_state = 37},
  [1125] = {.lex_state = 10},
  [1126] = {.lex_state = 10},
  [1127] = {.lex_state = 10},
  [1128] = {.lex_state = 10},
  [1129] = {.lex_state = 10},
  [1130] = {.lex_state = 10},
  [1131] = {.lex_state = 10},
  [1132] = {.lex_state = 10},
  [1133] = {.lex_state = 37},
  [1134] = {.lex_state = 10},
  [1135] = {.lex_state = 37},
  [1136] = {.lex_state = 10},
  [1137] = {.lex_state = 10},
  [1138] = {.lex_state = 10},
  [1139] = {.lex_state = 10},
  [1140] = {.lex_state = 10},
  [1141] = {.lex_state = 10},
  [1142] = {.lex_state = 10},
  [1143] = {.lex_state = 10},
  [1144] = {.lex_state = 10},
  [1145] = {.lex_state = 10},
  [1146] = {.lex_state = 10},
  [1147] = {.lex_state = 10},
  [1148] = {.lex_state = 10},
  [1149] = {.lex_state = 10},
  [1150] = {.lex_state = 10},
  [1151] = {.lex_state = 10},
  [1152] = {.lex_state = 10},
  [1153] = {.lex_state = 35},
  [1154] = {.lex_state = 10},
  [1155] = {.lex_state = 37},
  [1156] = {.lex_state = 10},
  [1157] = {.lex_state = 10},
  [1158] = {.lex_state = 10},
  [1159] = {.lex_state = 10},
  [1160] = {.lex_state = 10},
  [1161] = {.lex_state = 10},
  [1162] = {.lex_state = 10},
  [1163] = {.lex_state = 10},
  [1164] = {.lex_state = 10},
  [1165] = {.lex_state = 10},
  [1166] = {.lex_state = 10},
  [1167] = {.lex_state = 10},
  [1168] = {.lex_state = 35},
  [1169] = {.lex_state = 35},
  [1170] = {.lex_state = 35},
  [1171] = {.lex_state = 35},
  [1172] = {.lex_state = 35},
  [1173] = {.lex_state = 10},
  [1174] = {.lex_state = 35},
  [1175] = {.lex_state = 35},
  [1176] = {.lex_state = 35},
  [1177] = {.lex_state = 35},
  [1178] = {.lex_state = 35},
  [1179] = {.lex_state = 35},
  [1180] = {.lex_state = 37},
  [1181] = {.lex_state = 10},
  [1182] = {.lex_state = 35},
  [1183] = {.lex_state = 10},
  [1184] = {.lex_state = 10},
  [1185] = {.lex_state = 10},
  [1186] = {.lex_state = 10},
  [1187] = {.lex_state = 10},
  [1188] = {.lex_state = 10},
  [1189] = {.lex_state = 10},
  [1190] = {.lex_state = 10},
  [1191] = {.lex_state = 35},
  [1192] = {.lex_state = 35},
  [1193] = {.lex_state = 10},
  [1194] = {.lex_state = 10},
  [1195] = {.lex_state = 10},
  [1196] = {.lex_state = 35},
  [1197] = {.lex_state = 35},
  [1198] = {.lex_state = 37},
  [1199] = {.lex_state = 37},
  [1200] = {.lex_state = 37},
  [1201] = {.lex_state = 37},
  [1202] = {.lex_state = 37},
  [1203] = {.lex_state = 37},
  [1204] = {.lex_state = 37},
  [1205] = {.lex_state = 37},
  [1206] = {.lex_state = 37},
  [1207] = {.lex_state = 35},
  [1208] = {.lex_state = 37},
  [1209] = {.lex_state = 37},
  [1210] = {.lex_state = 37},
  [1211] = {.lex_state = 37},
  [1212] = {.lex_state = 37},
  [1213] = {.lex_state = 37},
  [1214] = {.lex_state = 37},
  [1215] = {.lex_state = 37},
  [1216] = {.lex_state = 37},
  [1217] = {.lex_state = 37},
  [1218] = {.lex_state = 37},
  [1219] = {.lex_state = 37},
  [1220] = {.lex_state = 37},
  [1221] = {.lex_state = 37},
  [1222] = {.lex_state = 37},
  [1223] = {.lex_state = 37},
  [1224] = {.lex_state = 37},
  [1225] = {.lex_state = 37},
  [1226] = {.lex_state = 37},
  [1227] = {.lex_state = 37},
  [1228] = {.lex_state = 37},
  [1229] = {.lex_state = 37},
  [1230] = {.lex_state = 37},
  [1231] = {.lex_state = 37},
  [1232] = {.lex_state = 37},
  [1233] = {.lex_state = 35},
  [1234] = {.lex_state = 37},
  [1235] = {.lex_state = 35},
  [1236] = {.lex_state = 35},
  [1237] = {.lex_state = 35},
  [1238] = {.lex_state = 35},
  [1239] = {.lex_state = 37},
  [1240] = {.lex_state = 37},
  [1241] = {.lex_state = 37},
  [1242] = {.lex_state = 37},
  [1243] = {.lex_state = 37},
  [1244] = {.lex_state = 37},
  [1245] = {.lex_state = 37},
  [1246] = {.lex_state = 37},
  [1247] = {.lex_state = 37},
  [1248] = {.lex_state = 35},
  [1249] = {.lex_state = 37},
  [1250] = {.lex_state = 37},
  [1251] = {.lex_state = 37},
  [1252] = {.lex_state = 35},
  [1253] = {.lex_state = 35},
  [1254] = {.lex_state = 35},
  [1255] = {.lex_state = 37},
  [1256] = {.lex_state = 35},
  [1257] = {.lex_state = 35},
  [1258] = {.lex_state = 35},
  [1259] = {.lex_state = 37},
  [1260] = {.lex_state = 35},
  [1261] = {.lex_state = 35},
  [1262] = {.lex_state = 35},
  [1263] = {.lex_state = 35},
  [1264] = {.lex_state = 35},
  [1265] = {.lex_state = 35},
  [1266] = {.lex_state = 35},
  [1267] = {.lex_state = 35},
  [1268] = {.lex_state = 35},
  [1269] = {.lex_state = 35},
  [1270] = {.lex_state = 35},
  [1271] = {.lex_state = 35},
  [1272] = {.lex_state = 35},
  [1273] = {.lex_state = 35},
  [1274] = {.lex_state = 37},
  [1275] = {.lex_state = 35},
  [1276] = {.lex_state = 37},
  [1277] = {.lex_state = 35},
  [1278] = {.lex_state = 35},
  [1279] = {.lex_state = 35},
  [1280] = {.lex_state = 35},
  [1281] = {.lex_state = 35},
  [1282] = {.lex_state = 35},
  [1283] = {.lex_state = 35},
  [1284] = {.lex_state = 35},
  [1285] = {.lex_state = 35},
  [1286] = {.lex_state = 10},
  [1287] = {.lex_state = 35},
  [1288] = {.lex_state = 35},
  [1289] = {.lex_state = 35},
  [1290] = {.lex_state = 35},
  [1291] = {.lex_state = 35},
  [1292] = {.lex_state = 35},
  [1293] = {.lex_state = 10},
  [1294] = {.lex_state = 35},
  [1295] = {.lex_state = 37},
  [1296] = {.lex_state = 35},
  [1297] = {.lex_state = 35},
  [1298] = {.lex_state = 35},
  [1299] = {.lex_state = 35},
  [1300] = {.lex_state = 35},
  [1301] = {.lex_state = 35},
  [1302] = {.lex_state = 35},
  [1303] = {.lex_state = 35},
  [1304] = {.lex_state = 35},
  [1305] = {.lex_state = 37},
  [1306] = {.lex_state = 35},
  [1307] = {.lex_state = 37},
  [1308] = {.lex_state = 35},
  [1309] = {.lex_state = 35},
  [1310] = {.lex_state = 35},
  [1311] = {.lex_state = 37},
  [1312] = {.lex_state = 35},
  [1313] = {.lex_state = 35},
  [1314] = {.lex_state = 35},
  [1315] = {.lex_state = 37},
  [1316] = {.lex_state = 35},
  [1317] = {.lex_state = 35},
  [1318] = {.lex_state = 37},
  [1319] = {.lex_state = 35},
  [1320] = {.lex_state = 37},
  [1321] = {.lex_state = 35},
  [1322] = {.lex_state = 37},
  [1323] = {.lex_state = 37},
  [1324] = {.lex_state = 35},
  [1325] = {.lex_state = 37},
  [1326] = {.lex_state = 37},
  [1327] = {.lex_state = 37},
  [1328] = {.lex_state = 35},
  [1329] = {.lex_state = 35},
  [1330] = {.lex_state = 37},
  [1331] = {.lex_state = 37},
  [1332] = {.lex_state = 37},
  [1333] = {.lex_state = 35},
  [1334] = {.lex_state = 35},
  [1335] = {.lex_state = 37},
  [1336] = {.lex_state = 35},
  [1337] = {.lex_state = 35},
  [1338] = {.lex_state = 35},
  [1339] = {.lex_state = 35},
  [1340] = {.lex_state = 37},
  [1341] = {.lex_state = 35},
  [1342] = {.lex_state = 37},
  [1343] = {.lex_state = 37},
  [1344] = {.lex_state = 37},
  [1345] = {.lex_state = 35},
  [1346] = {.lex_state = 37},
  [1347] = {.lex_state = 35},
  [1348] = {.lex_state = 37},
  [1349] = {.lex_state = 35},
  [1350] = {.lex_state = 35},
  [1351] = {.lex_state = 37},
  [1352] = {.lex_state = 35},
  [1353] = {.lex_state = 37},
  [1354] = {.lex_state = 37},
  [1355] = {.lex_state = 37},
  [1356] = {.lex_state = 10},
  [1357] = {.lex_state = 10},
  [1358] = {.lex_state = 10},
  [1359] = {.lex_state = 35},
  [1360] = {.lex_state = 10},
  [1361] = {.lex_state = 10},
  [1362] = {.lex_state = 35},
  [1363] = {.lex_state = 37},
  [1364] = {.lex_state = 37},
  [1365] = {.lex_state = 37},
  [1366] = {.lex_state = 35},
  [1367] = {.lex_state = 35},
  [1368] = {.lex_state = 35},
  [1369] = {.lex_state = 37},
  [1370] = {.lex_state = 37},
  [1371] = {.lex_state = 35},
  [1372] = {.lex_state = 10},
  [1373] = {.lex_state = 35},
  [1374] = {.lex_state = 35},
  [1375] = {.lex_state = 35},
  [1376] = {.lex_state = 37},
  [1377] = {.lex_state = 37},
  [1378] = {.lex_state = 37},
  [1379] = {.lex_state = 10},
  [1380] = {.lex_state = 37},
  [1381] = {.lex_state = 37},
  [1382] = {.lex_state = 37},
  [1383] = {.lex_state = 37},
  [1384] = {.lex_state = 37},
  [1385] = {.lex_state = 37},
  [1386] = {.lex_state = 37},
  [1387] = {.lex_state = 37},
  [1388] = {.lex_state = 35},
  [1389] = {.lex_state = 37},
  [1390] = {.lex_state = 37},
  [1391] = {.lex_state = 37},
  [1392] = {.lex_state = 10},
  [1393] = {.lex_state = 37},
  [1394] = {.lex_state = 37},
  [1395] = {.lex_state = 37},
  [1396] = {.lex_state = 37},
  [1397] = {.lex_state = 37},
  [1398] = {.lex_state = 37},
  [1399] = {.lex_state = 37},
  [1400] = {.lex_state = 37},
  [1401] = {.lex_state = 37},
  [1402] = {.lex_state = 37},
  [1403] = {.lex_state = 37},
  [1404] = {.lex_state = 37},
  [1405] = {.lex_state = 37},
  [1406] = {.lex_state = 23},
  [1407] = {.lex_state = 23},
  [1408] = {.lex_state = 23},
  [1409] = {.lex_state = 23},
  [1410] = {.lex_state = 23},
  [1411] = {.lex_state = 23},
  [1412] = {.lex_state = 23},
  [1413] = {.lex_state = 23},
  [1414] = {.lex_state = 23},
  [1415] = {.lex_state = 23},
  [1416] = {.lex_state = 23},
  [1417] = {.lex_state = 23},
  [1418] = {.lex_state = 23},
  [1419] = {.lex_state = 23},
  [1420] = {.lex_state = 23},
  [1421] = {.lex_state = 23},
  [1422] = {.lex_state = 23},
  [1423] = {.lex_state = 23},
  [1424] = {.lex_state = 23},
  [1425] = {.lex_state = 23},
  [1426] = {.lex_state = 23},
  [1427] = {.lex_state = 23},
  [1428] = {.lex_state = 23},
  [1429] = {.lex_state = 23},
  [1430] = {.lex_state = 23},
  [1431] = {.lex_state = 23},
  [1432] = {.lex_state = 23},
  [1433] = {.lex_state = 23},
  [1434] = {.lex_state = 23},
  [1435] = {.lex_state = 23},
  [1436] = {.lex_state = 23},
  [1437] = {.lex_state = 23},
  [1438] = {.lex_state = 23},
  [1439] = {.lex_state = 23},
  [1440] = {.lex_state = 23},
  [1441] = {.lex_state = 23},
  [1442] = {.lex_state = 23},
  [1443] = {.lex_state = 23},
  [1444] = {.lex_state = 23},
  [1445] = {.lex_state = 23},
  [1446] = {.lex_state = 23},
  [1447] = {.lex_state = 23},
  [1448] = {.lex_state = 23},
  [1449] = {.lex_state = 23},
  [1450] = {.lex_state = 23},
  [1451] = {.lex_state = 23},
  [1452] = {.lex_state = 23},
  [1453] = {.lex_state = 18, .external_lex_state = 2},
  [1454] = {.lex_state = 13},
  [1455] = {.lex_state = 13},
  [1456] = {.lex_state = 13},
  [1457] = {.lex_state = 13},
  [1458] = {.lex_state = 13},
  [1459] = {.lex_state = 14},
  [1460] = {.lex_state = 15},
  [1461] = {.lex_state = 18},
  [1462] = {.lex_state = 15},
  [1463] = {.lex_state = 19, .external_lex_state = 2},
  [1464] = {.lex_state = 13},
  [1465] = {.lex_state = 15},
  [1466] = {.lex_state = 15},
  [1467] = {.lex_state = 14},
  [1468] = {.lex_state = 15},
  [1469] = {.lex_state = 14},
  [1470] = {.lex_state = 14},
  [1471] = {.lex_state = 20, .external_lex_state = 2},
  [1472] = {.lex_state = 13},
  [1473] = {.lex_state = 13},
  [1474] = {.lex_state = 13},
  [1475] = {.lex_state = 14},
  [1476] = {.lex_state = 13},
  [1477] = {.lex_state = 13},
  [1478] = {.lex_state = 13},
  [1479] = {.lex_state = 13},
  [1480] = {.lex_state = 13},
  [1481] = {.lex_state = 13},
  [1482] = {.lex_state = 13},
  [1483] = {.lex_state = 13},
  [1484] = {.lex_state = 13},
  [1485] = {.lex_state = 13},
  [1486] = {.lex_state = 13},
  [1487] = {.lex_state = 13},
  [1488] = {.lex_state = 13},
  [1489] = {.lex_state = 13},
  [1490] = {.lex_state = 13},
  [1491] = {.lex_state = 13},
  [1492] = {.lex_state = 13},
  [1493] = {.lex_state = 13},
  [1494] = {.lex_state = 13},
  [1495] = {.lex_state = 13},
  [1496] = {.lex_state = 13},
  [1497] = {.lex_state = 13},
  [1498] = {.lex_state = 13},
  [1499] = {.lex_state = 13},
  [1500] = {.lex_state = 13},
  [1501] = {.lex_state = 13},
  [1502] = {.lex_state = 13},
  [1503] = {.lex_state = 13},
  [1504] = {.lex_state = 14},
  [1505] = {.lex_state = 13},
  [1506] = {.lex_state = 13},
  [1507] = {.lex_state = 13},
  [1508] = {.lex_state = 13},
  [1509] = {.lex_state = 13},
  [1510] = {.lex_state = 14},
  [1511] = {.lex_state = 13},
  [1512] = {.lex_state = 13},
  [1513] = {.lex_state = 13},
  [1514] = {.lex_state = 13},
  [1515] = {.lex_state = 13},
  [1516] = {.lex_state = 13},
  [1517] = {.lex_state = 13},
  [1518] = {.lex_state = 13},
  [1519] = {.lex_state = 13},
  [1520] = {.lex_state = 13},
  [1521] = {.lex_state = 13},
  [1522] = {.lex_state = 13},
  [1523] = {.lex_state = 13},
  [1524] = {.lex_state = 13},
  [1525] = {.lex_state = 14},
  [1526] = {.lex_state = 13},
  [1527] = {.lex_state = 13},
  [1528] = {.lex_state = 13},
  [1529] = {.lex_state = 13},
  [1530] = {.lex_state = 13},
  [1531] = {.lex_state = 13},
  [1532] = {.lex_state = 13},
  [1533] = {.lex_state = 13},
  [1534] = {.lex_state = 13},
  [1535] = {.lex_state = 13},
  [1536] = {.lex_state = 13},
  [1537] = {.lex_state = 13},
  [1538] = {.lex_state = 13},
  [1539] = {.lex_state = 13},
  [1540] = {.lex_state = 13},
  [1541] = {.lex_state = 13},
  [1542] = {.lex_state = 13},
  [1543] = {.lex_state = 13},
  [1544] = {.lex_state = 13},
  [1545] = {.lex_state = 13},
  [1546] = {.lex_state = 13},
  [1547] = {.lex_state = 13},
  [1548] = {.lex_state = 13},
  [1549] = {.lex_state = 13},
  [1550] = {.lex_state = 13},
  [1551] = {.lex_state = 13},
  [1552] = {.lex_state = 13},
  [1553] = {.lex_state = 14},
  [1554] = {.lex_state = 13},
  [1555] = {.lex_state = 13},
  [1556] = {.lex_state = 13},
  [1557] = {.lex_state = 13},
  [1558] = {.lex_state = 13},
  [1559] = {.lex_state = 13},
  [1560] = {.lex_state = 13},
  [1561] = {.lex_state = 15},
  [1562] = {.lex_state = 13},
  [1563] = {.lex_state = 13},
  [1564] = {.lex_state = 13},
  [1565] = {.lex_state = 13},
  [1566] = {.lex_state = 13},
  [1567] = {.lex_state = 13},
  [1568] = {.lex_state = 13},
  [1569] = {.lex_state = 13},
  [1570] = {.lex_state = 13},
  [1571] = {.lex_state = 13},
  [1572] = {.lex_state = 13},
  [1573] = {.lex_state = 13},
  [1574] = {.lex_state = 13},
  [1575] = {.lex_state = 13},
  [1576] = {.lex_state = 13},
  [1577] = {.lex_state = 13},
  [1578] = {.lex_state = 13},
  [1579] = {.lex_state = 13},
  [1580] = {.lex_state = 13},
  [1581] = {.lex_state = 15},
  [1582] = {.lex_state = 13},
  [1583] = {.lex_state = 13},
  [1584] = {.lex_state = 13},
  [1585] = {.lex_state = 13},
  [1586] = {.lex_state = 13},
  [1587] = {.lex_state = 15},
  [1588] = {.lex_state = 13},
  [1589] = {.lex_state = 20},
  [1590] = {.lex_state = 13},
  [1591] = {.lex_state = 13},
  [1592] = {.lex_state = 19},
  [1593] = {.lex_state = 13},
  [1594] = {.lex_state = 13},
  [1595] = {.lex_state = 15},
  [1596] = {.lex_state = 14},
  [1597] = {.lex_state = 14},
  [1598] = {.lex_state = 15},
  [1599] = {.lex_state = 15},
  [1600] = {.lex_state = 15},
  [1601] = {.lex_state = 14},
  [1602] = {.lex_state = 15},
  [1603] = {.lex_state = 15},
  [1604] = {.lex_state = 14},
  [1605] = {.lex_state = 14},
  [1606] = {.lex_state = 14},
  [1607] = {.lex_state = 14},
  [1608] = {.lex_state = 14},
  [1609] = {.lex_state = 15},
  [1610] = {.lex_state = 14},
  [1611] = {.lex_state = 14},
  [1612] = {.lex_state = 14},
  [1613] = {.lex_state = 14},
  [1614] = {.lex_state = 14},
  [1615] = {.lex_state = 14},
  [1616] = {.lex_state = 14},
  [1617] = {.lex_state = 14},
  [1618] = {.lex_state = 14},
  [1619] = {.lex_state = 14},
  [1620] = {.lex_state = 15},
  [1621] = {.lex_state = 15},
  [1622] = {.lex_state = 15},
  [1623] = {.lex_state = 15},
  [1624] = {.lex_state = 15},
  [1625] = {.lex_state = 15},
  [1626] = {.lex_state = 15},
  [1627] = {.lex_state = 14},
  [1628] = {.lex_state = 15},
  [1629] = {.lex_state = 14},
  [1630] = {.lex_state = 14},
  [1631] = {.lex_state = 15},
  [1632] = {.lex_state = 15},
  [1633] = {.lex_state = 15},
  [1634] = {.lex_state = 15},
  [1635] = {.lex_state = 15},
  [1636] = {.lex_state = 15},
  [1637] = {.lex_state = 15},
  [1638] = {.lex_state = 14},
  [1639] = {.lex_state = 14},
  [1640] = {.lex_state = 14},
  [1641] = {.lex_state = 14},
  [1642] = {.lex_state = 14},
  [1643] = {.lex_state = 15},
  [1644] = {.lex_state = 15},
  [1645] = {.lex_state = 15},
  [1646] = {.lex_state = 15},
  [1647] = {.lex_state = 14},
  [1648] = {.lex_state = 15},
  [1649] = {.lex_state = 14},
  [1650] = {.lex_state = 15},
  [1651] = {.lex_state = 15},
  [1652] = {.lex_state = 15},
  [1653] = {.lex_state = 15},
  [1654] = {.lex_state = 14},
  [1655] = {.lex_state = 15},
  [1656] = {.lex_state = 15},
  [1657] = {.lex_state = 14},
  [1658] = {.lex_state = 15},
  [1659] = {.lex_state = 15},
  [1660] = {.lex_state = 15},
  [1661] = {.lex_state = 15},
  [1662] = {.lex_state = 15},
  [1663] = {.lex_state = 15},
  [1664] = {.lex_state = 15},
  [1665] = {.lex_state = 15},
  [1666] = {.lex_state = 14},
  [1667] = {.lex_state = 15},
  [1668] = {.lex_state = 15},
  [1669] = {.lex_state = 14},
  [1670] = {.lex_state = 14},
  [1671] = {.lex_state = 15},
  [1672] = {.lex_state = 14},
  [1673] = {.lex_state = 14},
  [1674] = {.lex_state = 14},
  [1675] = {.lex_state = 15},
  [1676] = {.lex_state = 14},
  [1677] = {.lex_state = 14},
  [1678] = {.lex_state = 15},
  [1679] = {.lex_state = 15},
  [1680] = {.lex_state = 14},
  [1681] = {.lex_state = 14},
  [1682] = {.lex_state = 14},
  [1683] = {.lex_state = 15},
  [1684] = {.lex_state = 15},
  [1685] = {.lex_state = 14},
  [1686] = {.lex_state = 14},
  [1687] = {.lex_state = 14},
  [1688] = {.lex_state = 14},
  [1689] = {.lex_state = 14},
  [1690] = {.lex_state = 14},
  [1691] = {.lex_state = 14},
  [1692] = {.lex_state = 14},
  [1693] = {.lex_state = 14},
  [1694] = {.lex_state = 21},
  [1695] = {.lex_state = 14},
  [1696] = {.lex_state = 14},
  [1697] = {.lex_state = 14},
  [1698] = {.lex_state = 15},
  [1699] = {.lex_state = 14},
  [1700] = {.lex_state = 15},
  [1701] = {.lex_state = 15},
  [1702] = {.lex_state = 15},
  [1703] = {.lex_state = 15},
  [1704] = {.lex_state = 15},
  [1705] = {.lex_state = 14},
  [1706] = {.lex_state = 15},
  [1707] = {.lex_state = 14},
  [1708] = {.lex_state = 14},
  [1709] = {.lex_state = 14},
  [1710] = {.lex_state = 14},
  [1711] = {.lex_state = 14},
  [1712] = {.lex_state = 14},
  [1713] = {.lex_state = 14},
  [1714] = {.lex_state = 14},
  [1715] = {.lex_state = 14},
  [1716] = {.lex_state = 14},
  [1717] = {.lex_state = 14},
  [1718] = {.lex_state = 14},
  [1719] = {.lex_state = 14},
  [1720] = {.lex_state = 15},
  [1721] = {.lex_state = 14},
  [1722] = {.lex_state = 14},
  [1723] = {.lex_state = 14},
  [1724] = {.lex_state = 14},
  [1725] = {.lex_state = 14},
  [1726] = {.lex_state = 14},
  [1727] = {.lex_state = 21},
  [1728] = {.lex_state = 15},
  [1729] = {.lex_state = 15},
  [1730] = {.lex_state = 14},
  [1731] = {.lex_state = 14},
  [1732] = {.lex_state = 14},
  [1733] = {.lex_state = 14},
  [1734] = {.lex_state = 14},
  [1735] = {.lex_state = 14},
  [1736] = {.lex_state = 14},
  [1737] = {.lex_state = 14},
  [1738] = {.lex_state = 14},
  [1739] = {.lex_state = 14},
  [1740] = {.lex_state = 14},
  [1741] = {.lex_state = 14},
  [1742] = {.lex_state = 14},
  [1743] = {.lex_state = 14},
  [1744] = {.lex_state = 15},
  [1745] = {.lex_state = 14},
  [1746] = {.lex_state = 14},
  [1747] = {.lex_state = 14},
  [1748] = {.lex_state = 14},
  [1749] = {.lex_state = 14},
  [1750] = {.lex_state = 14},
  [1751] = {.lex_state = 15},
  [1752] = {.lex_state = 14},
  [1753] = {.lex_state = 14},
  [1754] = {.lex_state = 14},
  [1755] = {.lex_state = 15},
  [1756] = {.lex_state = 15},
  [1757] = {.lex_state = 15},
  [1758] = {.lex_state = 14},
  [1759] = {.lex_state = 15},
  [1760] = {.lex_state = 14},
  [1761] = {.lex_state = 15},
  [1762] = {.lex_state = 15},
  [1763] = {.lex_state = 15},
  [1764] = {.lex_state = 15},
  [1765] = {.lex_state = 14},
  [1766] = {.lex_state = 14},
  [1767] = {.lex_state = 15},
  [1768] = {.lex_state = 15},
  [1769] = {.lex_state = 14},
  [1770] = {.lex_state = 14},
  [1771] = {.lex_state = 14},
  [1772] = {.lex_state = 14},
  [1773] = {.lex_state = 14},
  [1774] = {.lex_state = 14},
  [1775] = {.lex_state = 15},
  [1776] = {.lex_state = 15},
  [1777] = {.lex_state = 14},
  [1778] = {.lex_state = 15},
  [1779] = {.lex_state = 15},
  [1780] = {.lex_state = 15},
  [1781] = {.lex_state = 15},
  [1782] = {.lex_state = 14},
  [1783] = {.lex_state = 15},
  [1784] = {.lex_state = 14},
  [1785] = {.lex_state = 15},
  [1786] = {.lex_state = 15},
  [1787] = {.lex_state = 15},
  [1788] = {.lex_state = 15},
  [1789] = {.lex_state = 15},
  [1790] = {.lex_state = 15},
  [1791] = {.lex_state = 14},
  [1792] = {.lex_state = 15},
  [1793] = {.lex_state = 15},
  [1794] = {.lex_state = 15},
  [1795] = {.lex_state = 15},
  [1796] = {.lex_state = 15},
  [1797] = {.lex_state = 15},
  [1798] = {.lex_state = 22, .external_lex_state = 2},
  [1799] = {.lex_state = 21},
  [1800] = {.lex_state = 21},
  [1801] = {.lex_state = 21},
  [1802] = {.lex_state = 21},
  [1803] = {.lex_state = 21},
  [1804] = {.lex_state = 22},
  [1805] = {.lex_state = 21},
  [1806] = {.lex_state = 21},
  [1807] = {.lex_state = 21},
  [1808] = {.lex_state = 21},
  [1809] = {.lex_state = 21},
  [1810] = {.lex_state = 21},
  [1811] = {.lex_state = 21},
  [1812] = {.lex_state = 21},
  [1813] = {.lex_state = 21},
  [1814] = {.lex_state = 21},
  [1815] = {.lex_state = 21},
  [1816] = {.lex_state = 21},
  [1817] = {.lex_state = 21},
  [1818] = {.lex_state = 21},
  [1819] = {.lex_state = 21},
  [1820] = {.lex_state = 21},
  [1821] = {.lex_state = 21},
  [1822] = {.lex_state = 21},
  [1823] = {.lex_state = 21},
  [1824] = {.lex_state = 21},
  [1825] = {.lex_state = 21},
  [1826] = {.lex_state = 21},
  [1827] = {.lex_state = 21},
  [1828] = {.lex_state = 21},
  [1829] = {.lex_state = 21},
  [1830] = {.lex_state = 21},
  [1831] = {.lex_state = 21},
  [1832] = {.lex_state = 21},
  [1833] = {.lex_state = 21},
  [1834] = {.lex_state = 21},
  [1835] = {.lex_state = 21},
  [1836] = {.lex_state = 21},
  [1837] = {.lex_state = 21},
  [1838] = {.lex_state = 21},
  [1839] = {.lex_state = 21},
  [1840] = {.lex_state = 21},
  [1841] = {.lex_state = 21},
  [1842] = {.lex_state = 21},
  [1843] = {.lex_state = 21},
  [1844] = {.lex_state = 21},
  [1845] = {.lex_state = 21},
  [1846] = {.lex_state = 21},
  [1847] = {.lex_state = 21},
  [1848] = {.lex_state = 21},
  [1849] = {.lex_state = 21},
  [1850] = {.lex_state = 21},
  [1851] = {.lex_state = 21},
  [1852] = {.lex_state = 21},
  [1853] = {.lex_state = 21},
  [1854] = {.lex_state = 21},
  [1855] = {.lex_state = 21},
  [1856] = {.lex_state = 21},
  [1857] = {.lex_state = 21},
  [1858] = {.lex_state = 21},
  [1859] = {.lex_state = 21},
  [1860] = {.lex_state = 21},
  [1861] = {.lex_state = 21},
  [1862] = {.lex_state = 21},
  [1863] = {.lex_state = 21},
  [1864] = {.lex_state = 21},
  [1865] = {.lex_state = 21},
  [1866] = {.lex_state = 21},
  [1867] = {.lex_state = 21},
  [1868] = {.lex_state = 21},
  [1869] = {.lex_state = 21},
  [1870] = {.lex_state = 21},
  [1871] = {.lex_state = 21},
  [1872] = {.lex_state = 21},
  [1873] = {.lex_state = 21},
  [1874] = {.lex_state = 21},
  [1875] = {.lex_state = 21},
  [1876] = {.lex_state = 21},
  [1877] = {.lex_state = 21},
  [1878] = {.lex_state = 21},
  [1879] = {.lex_state = 21},
  [1880] = {.lex_state = 21},
  [1881] = {.lex_state = 21},
  [1882] = {.lex_state = 21},
  [1883] = {.lex_state = 21},
  [1884] = {.lex_state = 21},
  [1885] = {.lex_state = 21},
  [1886] = {.lex_state = 21},
  [1887] = {.lex_state = 21},
  [1888] = {.lex_state = 21},
  [1889] = {.lex_state = 21},
  [1890] = {.lex_state = 21},
  [1891] = {.lex_state = 21},
  [1892] = {.lex_state = 21},
  [1893] = {.lex_state = 21},
  [1894] = {.lex_state = 21},
  [1895] = {.lex_state = 23},
  [1896] = {.lex_state = 23},
  [1897] = {.lex_state = 23},
  [1898] = {.lex_state = 23},
  [1899] = {.lex_state = 23},
  [1900] = {.lex_state = 23},
  [1901] = {.lex_state = 23},
  [1902] = {.lex_state = 23},
  [1903] = {.lex_state = 23},
  [1904] = {.lex_state = 23},
  [1905] = {.lex_state = 24, .external_lex_state = 2},
  [1906] = {.lex_state = 23},
  [1907] = {.lex_state = 23},
  [1908] = {.lex_state = 23},
  [1909] = {.lex_state = 23},
  [1910] = {.lex_state = 24},
  [1911] = {.lex_state = 23},
  [1912] = {.lex_state = 23},
  [1913] = {.lex_state = 23},
  [1914] = {.lex_state = 23},
  [1915] = {.lex_state = 23},
  [1916] = {.lex_state = 23},
  [1917] = {.lex_state = 23},
  [1918] = {.lex_state = 23},
  [1919] = {.lex_state = 23},
  [1920] = {.lex_state = 23},
  [1921] = {.lex_state = 23},
  [1922] = {.lex_state = 23},
  [1923] = {.lex_state = 23},
  [1924] = {.lex_state = 23},
  [1925] = {.lex_state = 23},
  [1926] = {.lex_state = 23},
  [1927] = {.lex_state = 23},
  [1928] = {.lex_state = 23},
  [1929] = {.lex_state = 23},
  [1930] = {.lex_state = 23},
  [1931] = {.lex_state = 23},
  [1932] = {.lex_state = 23},
  [1933] = {.lex_state = 23},
  [1934] = {.lex_state = 23},
  [1935] = {.lex_state = 23},
  [1936] = {.lex_state = 23},
  [1937] = {.lex_state = 23},
  [1938] = {.lex_state = 23},
  [1939] = {.lex_state = 23},
  [1940] = {.lex_state = 23},
  [1941] = {.lex_state = 23},
  [1942] = {.lex_state = 23},
  [1943] = {.lex_state = 23},
  [1944] = {.lex_state = 23},
  [1945] = {.lex_state = 23},
  [1946] = {.lex_state = 23},
  [1947] = {.lex_state = 23},
  [1948] = {.lex_state = 23},
  [1949] = {.lex_state = 23},
  [1950] = {.lex_state = 23},
  [1951] = {.lex_state = 23},
  [1952] = {.lex_state = 23},
  [1953] = {.lex_state = 23},
  [1954] = {.lex_state = 23},
  [1955] = {.lex_state = 23},
  [1956] = {.lex_state = 23},
  [1957] = {.lex_state = 23},
  [1958] = {.lex_state = 23},
  [1959] = {.lex_state = 23},
  [1960] = {.lex_state = 23},
  [1961] = {.lex_state = 23},
  [1962] = {.lex_state = 23},
  [1963] = {.lex_state = 23},
  [1964] = {.lex_state = 23},
  [1965] = {.lex_state = 23},
  [1966] = {.lex_state = 23},
  [1967] = {.lex_state = 23},
  [1968] = {.lex_state = 23},
  [1969] = {.lex_state = 23},
  [1970] = {.lex_state = 23},
  [1971] = {.lex_state = 23},
  [1972] = {.lex_state = 23},
  [1973] = {.lex_state = 23},
  [1974] = {.lex_state = 23},
  [1975] = {.lex_state = 23},
  [1976] = {.lex_state = 23},
  [1977] = {.lex_state = 23},
  [1978] = {.lex_state = 23},
  [1979] = {.lex_state = 23},
  [1980] = {.lex_state = 23},
  [1981] = {.lex_state = 23},
  [1982] = {.lex_state = 23},
  [1983] = {.lex_state = 23},
  [1984] = {.lex_state = 23},
  [1985] = {.lex_state = 23},
  [1986] = {.lex_state = 0},
  [1987] = {.lex_state = 0},
  [1988] = {.lex_state = 0},
  [1989] = {.lex_state = 0},
  [1990] = {.lex_state = 0},
  [1991] = {.lex_state = 0},
  [1992] = {.lex_state = 0},
  [1993] = {.lex_state = 26},
  [1994] = {.lex_state = 26},
  [1995] = {.lex_state = 26},
  [1996] = {.lex_state = 26},
  [1997] = {.lex_state = 26},
  [1998] = {.lex_state = 26},
  [1999] = {.lex_state = 26},
  [2000] = {.lex_state = 26},
  [2001] = {.lex_state = 26},
  [2002] = {.lex_state = 26},
  [2003] = {.lex_state = 26},
  [2004] = {.lex_state = 26},
  [2005] = {.lex_state = 26},
  [2006] = {.lex_state = 26},
  [2007] = {.lex_state = 26},
  [2008] = {.lex_state = 26},
  [2009] = {.lex_state = 26},
  [2010] = {.lex_state = 26},
  [2011] = {.lex_state = 26},
  [2012] = {.lex_state = 26},
  [2013] = {.lex_state = 26},
  [2014] = {.lex_state = 26},
  [2015] = {.lex_state = 26},
  [2016] = {.lex_state = 26},
  [2017] = {.lex_state = 26},
  [2018] = {.lex_state = 26},
  [2019] = {.lex_state = 26},
  [2020] = {.lex_state = 26},
  [2021] = {.lex_state = 26},
  [2022] = {.lex_state = 26},
  [2023] = {.lex_state = 26},
  [2024] = {.lex_state = 26},
  [2025] = {.lex_state = 26},
  [2026] = {.lex_state = 26},
  [2027] = {.lex_state = 26},
  [2028] = {.lex_state = 26},
  [2029] = {.lex_state = 26},
  [2030] = {.lex_state = 26},
  [2031] = {.lex_state = 26},
  [2032] = {.lex_state = 26},
  [2033] = {.lex_state = 26},
  [2034] = {.lex_state = 26},
  [2035] = {.lex_state = 26},
  [2036] = {.lex_state = 0},
  [2037] = {.lex_state = 26},
  [2038] = {.lex_state = 26},
  [2039] = {.lex_state = 26},
  [2040] = {.lex_state = 26},
  [2041] = {.lex_state = 26},
  [2042] = {.lex_state = 26},
  [2043] = {.lex_state = 26},
  [2044] = {.lex_state = 26},
  [2045] = {.lex_state = 26},
  [2046] = {.lex_state = 26},
  [2047] = {.lex_state = 28},
  [2048] = {.lex_state = 26},
  [2049] = {.lex_state = 26},
  [2050] = {.lex_state = 26},
  [2051] = {.lex_state = 26},
  [2052] = {.lex_state = 28},
  [2053] = {.lex_state = 28},
  [2054] = {.lex_state = 28},
  [2055] = {.lex_state = 26},
  [2056] = {.lex_state = 28},
  [2057] = {.lex_state = 28},
  [2058] = {.lex_state = 28},
  [2059] = {.lex_state = 26},
  [2060] = {.lex_state = 26},
  [2061] = {.lex_state = 26},
  [2062] = {.lex_state = 28},
  [2063] = {.lex_state = 28},
  [2064] = {.lex_state = 28},
  [2065] = {.lex_state = 28},
  [2066] = {.lex_state = 28},
  [2067] = {.lex_state = 28},
  [2068] = {.lex_state = 28},
  [2069] = {.lex_state = 0},
  [2070] = {.lex_state = 0},
  [2071] = {.lex_state = 0},
  [2072] = {.lex_state = 0},
  [2073] = {.lex_state = 0},
  [2074] = {.lex_state = 0},
  [2075] = {.lex_state = 0},
  [2076] = {.lex_state = 0},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 0},
  [2079] = {.lex_state = 0},
  [2080] = {.lex_state = 0},
  [2081] = {.lex_state = 0},
  [2082] = {.lex_state = 0},
  [2083] = {.lex_state = 0},
  [2084] = {.lex_state = 0},
  [2085] = {.lex_state = 0},
  [2086] = {.lex_state = 0},
  [2087] = {.lex_state = 0},
  [2088] = {.lex_state = 0},
  [2089] = {.lex_state = 0},
  [2090] = {.lex_state = 0},
  [2091] = {.lex_state = 0},
  [2092] = {.lex_state = 0},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 0},
  [2095] = {.lex_state = 0},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 0},
  [2098] = {.lex_state = 0},
  [2099] = {.lex_state = 0},
  [2100] = {.lex_state = 0},
  [2101] = {.lex_state = 0},
  [2102] = {.lex_state = 0},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 0},
  [2105] = {.lex_state = 0},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 0},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 0},
  [2114] = {.lex_state = 0},
  [2115] = {.lex_state = 0},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 0},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 0},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 0},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 0},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 0},
  [2153] = {.lex_state = 0},
  [2154] = {.lex_state = 0},
  [2155] = {.lex_state = 0},
  [2156] = {.lex_state = 0},
  [2157] = {.lex_state = 0},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 0},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 0},
  [2163] = {.lex_state = 0},
  [2164] = {.lex_state = 0},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 0},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 0},
  [2169] = {.lex_state = 0},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 0},
  [2172] = {.lex_state = 0},
  [2173] = {.lex_state = 0},
  [2174] = {.lex_state = 0},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 0},
  [2180] = {.lex_state = 0},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 0},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 0},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 0},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 0},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 0},
  [2193] = {.lex_state = 0},
  [2194] = {.lex_state = 0},
  [2195] = {.lex_state = 0},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 0},
  [2199] = {.lex_state = 0},
  [2200] = {.lex_state = 0},
  [2201] = {.lex_state = 0},
  [2202] = {.lex_state = 0},
  [2203] = {.lex_state = 0},
  [2204] = {.lex_state = 0},
  [2205] = {.lex_state = 0},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 0},
  [2208] = {.lex_state = 0},
  [2209] = {.lex_state = 0},
  [2210] = {.lex_state = 0},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 0},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 0},
  [2215] = {.lex_state = 0},
  [2216] = {.lex_state = 0},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 0},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 0},
  [2222] = {.lex_state = 0},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 0},
  [2225] = {.lex_state = 0},
  [2226] = {.lex_state = 0},
  [2227] = {.lex_state = 0},
  [2228] = {.lex_state = 0},
  [2229] = {.lex_state = 0},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 0},
  [2232] = {.lex_state = 0},
  [2233] = {.lex_state = 0},
  [2234] = {.lex_state = 0},
  [2235] = {.lex_state = 0},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 0},
  [2238] = {.lex_state = 0},
  [2239] = {.lex_state = 0},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 0},
  [2242] = {.lex_state = 0},
  [2243] = {.lex_state = 0},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 0},
  [2246] = {.lex_state = 0},
  [2247] = {.lex_state = 0},
  [2248] = {.lex_state = 0},
  [2249] = {.lex_state = 0},
  [2250] = {.lex_state = 0},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 0},
  [2255] = {.lex_state = 0},
  [2256] = {.lex_state = 0},
  [2257] = {.lex_state = 0},
  [2258] = {.lex_state = 0},
  [2259] = {.lex_state = 0},
  [2260] = {.lex_state = 27},
  [2261] = {.lex_state = 0},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 27},
  [2264] = {.lex_state = 0},
  [2265] = {.lex_state = 0},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 26},
  [2268] = {.lex_state = 0},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 0},
  [2271] = {.lex_state = 27},
  [2272] = {.lex_state = 26},
  [2273] = {.lex_state = 0},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 0},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 26},
  [2278] = {.lex_state = 27},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0},
  [2281] = {.lex_state = 26},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 0},
  [2284] = {.lex_state = 28},
  [2285] = {.lex_state = 0},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 26},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 0},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 26},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 0},
  [2295] = {.lex_state = 27},
  [2296] = {.lex_state = 0},
  [2297] = {.lex_state = 26},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 26},
  [2300] = {.lex_state = 26},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 0},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 27},
  [2305] = {.lex_state = 26},
  [2306] = {.lex_state = 26},
  [2307] = {.lex_state = 0},
  [2308] = {.lex_state = 27},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 0},
  [2311] = {.lex_state = 26},
  [2312] = {.lex_state = 0},
  [2313] = {.lex_state = 27},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 26},
  [2316] = {.lex_state = 0},
  [2317] = {.lex_state = 0},
  [2318] = {.lex_state = 0},
  [2319] = {.lex_state = 0},
  [2320] = {.lex_state = 0},
  [2321] = {.lex_state = 0},
  [2322] = {.lex_state = 0},
  [2323] = {.lex_state = 0},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 26},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 0},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 0},
  [2330] = {.lex_state = 26},
  [2331] = {.lex_state = 26},
  [2332] = {.lex_state = 0},
  [2333] = {.lex_state = 0},
  [2334] = {.lex_state = 0},
  [2335] = {.lex_state = 26},
  [2336] = {.lex_state = 0},
  [2337] = {.lex_state = 0},
  [2338] = {.lex_state = 26},
  [2339] = {.lex_state = 26},
  [2340] = {.lex_state = 0},
  [2341] = {.lex_state = 0},
  [2342] = {.lex_state = 26},
  [2343] = {.lex_state = 28},
  [2344] = {.lex_state = 26},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 26},
  [2347] = {.lex_state = 0},
  [2348] = {.lex_state = 26},
  [2349] = {.lex_state = 27},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 0},
  [2352] = {.lex_state = 27},
  [2353] = {.lex_state = 26},
  [2354] = {.lex_state = 0},
  [2355] = {.lex_state = 0},
  [2356] = {.lex_state = 26},
  [2357] = {.lex_state = 0},
  [2358] = {.lex_state = 26},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 27},
  [2362] = {.lex_state = 26},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 0},
  [2365] = {.lex_state = 0},
  [2366] = {.lex_state = 26},
  [2367] = {.lex_state = 0},
  [2368] = {.lex_state = 0},
  [2369] = {.lex_state = 0},
  [2370] = {.lex_state = 0},
  [2371] = {.lex_state = 26},
  [2372] = {.lex_state = 26},
  [2373] = {.lex_state = 26},
  [2374] = {.lex_state = 26},
  [2375] = {.lex_state = 0},
  [2376] = {.lex_state = 0},
  [2377] = {.lex_state = 0},
  [2378] = {.lex_state = 0},
  [2379] = {.lex_state = 0},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 0},
  [2382] = {.lex_state = 0},
  [2383] = {.lex_state = 0},
  [2384] = {.lex_state = 0},
  [2385] = {.lex_state = 0},
  [2386] = {.lex_state = 0},
  [2387] = {.lex_state = 0},
  [2388] = {.lex_state = 26},
  [2389] = {.lex_state = 0},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 0},
  [2393] = {.lex_state = 0},
  [2394] = {.lex_state = 0},
  [2395] = {.lex_state = 0},
  [2396] = {.lex_state = 0},
  [2397] = {.lex_state = 0},
  [2398] = {.lex_state = 0},
  [2399] = {.lex_state = 0},
  [2400] = {.lex_state = 0},
  [2401] = {.lex_state = 0},
  [2402] = {.lex_state = 0},
  [2403] = {.lex_state = 0},
  [2404] = {.lex_state = 0},
  [2405] = {.lex_state = 0},
  [2406] = {.lex_state = 0},
  [2407] = {.lex_state = 0},
  [2408] = {.lex_state = 0},
  [2409] = {.lex_state = 0},
  [2410] = {.lex_state = 0},
  [2411] = {.lex_state = 0},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 0},
  [2414] = {.lex_state = 0},
  [2415] = {.lex_state = 0},
  [2416] = {.lex_state = 0},
  [2417] = {.lex_state = 0},
  [2418] = {.lex_state = 0},
  [2419] = {.lex_state = 0},
  [2420] = {.lex_state = 0},
  [2421] = {.lex_state = 0},
  [2422] = {.lex_state = 29},
  [2423] = {.lex_state = 0},
  [2424] = {.lex_state = 0},
  [2425] = {.lex_state = 0},
  [2426] = {.lex_state = 0},
  [2427] = {.lex_state = 0},
  [2428] = {.lex_state = 0},
  [2429] = {.lex_state = 0},
  [2430] = {.lex_state = 0},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 0},
  [2433] = {.lex_state = 0},
  [2434] = {.lex_state = 0},
  [2435] = {.lex_state = 0},
  [2436] = {.lex_state = 0},
  [2437] = {.lex_state = 0},
  [2438] = {.lex_state = 0},
  [2439] = {.lex_state = 0},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 0},
  [2442] = {.lex_state = 0},
  [2443] = {.lex_state = 0},
  [2444] = {.lex_state = 0},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 0},
  [2448] = {.lex_state = 0},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 0},
  [2451] = {.lex_state = 0},
  [2452] = {.lex_state = 0},
  [2453] = {.lex_state = 0},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 0},
  [2457] = {.lex_state = 0},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0},
  [2460] = {.lex_state = 0},
  [2461] = {.lex_state = 0},
  [2462] = {.lex_state = 0},
  [2463] = {.lex_state = 0},
  [2464] = {.lex_state = 0},
  [2465] = {.lex_state = 0},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 0},
  [2468] = {.lex_state = 0},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 29},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 0},
  [2474] = {.lex_state = 0},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 0},
  [2479] = {.lex_state = 0},
  [2480] = {.lex_state = 0},
  [2481] = {.lex_state = 0},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 0},
  [2484] = {.lex_state = 0},
  [2485] = {.lex_state = 26},
  [2486] = {.lex_state = 0},
  [2487] = {.lex_state = 0},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 0},
  [2490] = {.lex_state = 0},
  [2491] = {.lex_state = 0},
  [2492] = {.lex_state = 0},
  [2493] = {.lex_state = 0},
  [2494] = {.lex_state = 0},
  [2495] = {.lex_state = 0},
  [2496] = {.lex_state = 0},
  [2497] = {.lex_state = 0},
  [2498] = {.lex_state = 0},
  [2499] = {.lex_state = 0},
  [2500] = {.lex_state = 0},
  [2501] = {.lex_state = 0},
  [2502] = {.lex_state = 0},
  [2503] = {.lex_state = 0},
  [2504] = {.lex_state = 0},
  [2505] = {.lex_state = 0},
  [2506] = {.lex_state = 0},
  [2507] = {.lex_state = 0},
  [2508] = {.lex_state = 0},
  [2509] = {.lex_state = 26},
  [2510] = {.lex_state = 0},
  [2511] = {.lex_state = 0},
  [2512] = {.lex_state = 0},
  [2513] = {.lex_state = 0},
  [2514] = {.lex_state = 0},
  [2515] = {.lex_state = 0},
  [2516] = {.lex_state = 0},
  [2517] = {.lex_state = 0},
  [2518] = {.lex_state = 0},
  [2519] = {.lex_state = 0},
  [2520] = {.lex_state = 0},
  [2521] = {.lex_state = 0},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 0},
  [2524] = {.lex_state = 0},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 0},
  [2527] = {.lex_state = 0},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 0},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0},
  [2533] = {.lex_state = 0},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 0},
  [2536] = {.lex_state = 0},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 0},
  [2539] = {.lex_state = 0},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 0},
  [2543] = {.lex_state = 0},
  [2544] = {.lex_state = 0},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 0},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 29},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 0},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 0},
  [2555] = {.lex_state = 0},
  [2556] = {.lex_state = 0},
  [2557] = {.lex_state = 0},
  [2558] = {.lex_state = 0},
  [2559] = {.lex_state = 0},
  [2560] = {.lex_state = 0},
  [2561] = {.lex_state = 0},
  [2562] = {.lex_state = 0},
  [2563] = {.lex_state = 0},
  [2564] = {.lex_state = 0},
  [2565] = {.lex_state = 0},
  [2566] = {.lex_state = 0},
  [2567] = {.lex_state = 0},
  [2568] = {.lex_state = 0},
  [2569] = {.lex_state = 0},
  [2570] = {.lex_state = 0},
  [2571] = {.lex_state = 0},
  [2572] = {.lex_state = 0},
  [2573] = {.lex_state = 0},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 0},
  [2576] = {.lex_state = 0},
  [2577] = {.lex_state = 0},
  [2578] = {.lex_state = 0},
  [2579] = {.lex_state = 0},
  [2580] = {.lex_state = 29},
  [2581] = {.lex_state = 0},
  [2582] = {.lex_state = 0},
  [2583] = {.lex_state = 0},
  [2584] = {.lex_state = 0},
  [2585] = {.lex_state = 0},
  [2586] = {.lex_state = 0},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 0},
  [2589] = {.lex_state = 0},
  [2590] = {.lex_state = 0},
  [2591] = {.lex_state = 0},
  [2592] = {.lex_state = 0},
  [2593] = {.lex_state = 0},
  [2594] = {.lex_state = 26},
  [2595] = {.lex_state = 0},
  [2596] = {.lex_state = 0},
  [2597] = {.lex_state = 0},
  [2598] = {.lex_state = 0},
  [2599] = {.lex_state = 0},
  [2600] = {.lex_state = 0},
  [2601] = {.lex_state = 0},
  [2602] = {.lex_state = 0},
  [2603] = {.lex_state = 0},
  [2604] = {.lex_state = 0},
  [2605] = {.lex_state = 0},
  [2606] = {.lex_state = 0},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 0},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 0},
  [2611] = {.lex_state = 0},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 0},
  [2614] = {.lex_state = 0},
  [2615] = {.lex_state = 0},
  [2616] = {.lex_state = 0},
  [2617] = {.lex_state = 0},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 0},
  [2621] = {.lex_state = 0},
  [2622] = {.lex_state = 0},
  [2623] = {.lex_state = 0},
  [2624] = {.lex_state = 0},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 0},
  [2628] = {.lex_state = 0},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 0},
  [2632] = {.lex_state = 0},
  [2633] = {.lex_state = 0},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 0},
  [2636] = {.lex_state = 0},
  [2637] = {.lex_state = 0},
  [2638] = {.lex_state = 0},
  [2639] = {.lex_state = 0},
  [2640] = {.lex_state = 0},
  [2641] = {.lex_state = 0},
  [2642] = {.lex_state = 0},
  [2643] = {.lex_state = 0},
  [2644] = {.lex_state = 0},
  [2645] = {.lex_state = 0},
  [2646] = {.lex_state = 0},
  [2647] = {.lex_state = 0},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 0},
  [2650] = {.lex_state = 0},
  [2651] = {.lex_state = 0},
  [2652] = {.lex_state = 0},
  [2653] = {.lex_state = 0},
  [2654] = {.lex_state = 0},
  [2655] = {.lex_state = 0},
  [2656] = {.lex_state = 0},
  [2657] = {.lex_state = 0},
  [2658] = {.lex_state = 0},
  [2659] = {.lex_state = 0},
  [2660] = {.lex_state = 0},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 0},
  [2663] = {.lex_state = 26},
  [2664] = {.lex_state = 0},
  [2665] = {.lex_state = 0},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 0},
  [2668] = {.lex_state = 0},
  [2669] = {.lex_state = 0},
  [2670] = {.lex_state = 0},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 0},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 0},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 0},
  [2677] = {.lex_state = 0},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 0},
  [2680] = {.lex_state = 0},
  [2681] = {.lex_state = 0},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 0},
  [2684] = {.lex_state = 0},
  [2685] = {.lex_state = 29},
  [2686] = {.lex_state = 0},
  [2687] = {.lex_state = 0},
  [2688] = {.lex_state = 0},
  [2689] = {.lex_state = 0},
  [2690] = {.lex_state = 0},
  [2691] = {.lex_state = 0},
  [2692] = {.lex_state = 0},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 0},
  [2696] = {.lex_state = 0},
  [2697] = {.lex_state = 0},
  [2698] = {.lex_state = 0},
  [2699] = {.lex_state = 26},
  [2700] = {.lex_state = 0},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 0},
  [2704] = {.lex_state = 0},
  [2705] = {.lex_state = 0},
  [2706] = {.lex_state = 0},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 0},
  [2709] = {.lex_state = 26},
  [2710] = {.lex_state = 29},
  [2711] = {.lex_state = 0},
  [2712] = {.lex_state = 0},
  [2713] = {.lex_state = 0},
  [2714] = {.lex_state = 0},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 0},
  [2718] = {.lex_state = 0},
  [2719] = {.lex_state = 26},
  [2720] = {.lex_state = 0},
  [2721] = {.lex_state = 0},
  [2722] = {.lex_state = 0},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 0},
  [2725] = {.lex_state = 0},
  [2726] = {.lex_state = 0},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 0},
  [2729] = {.lex_state = 0},
  [2730] = {.lex_state = 0},
  [2731] = {.lex_state = 0},
  [2732] = {.lex_state = 0},
  [2733] = {.lex_state = 0},
  [2734] = {.lex_state = 0},
  [2735] = {.lex_state = 0},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 0},
  [2738] = {.lex_state = 0},
  [2739] = {.lex_state = 0},
  [2740] = {.lex_state = 0},
  [2741] = {.lex_state = 0},
  [2742] = {.lex_state = 0},
  [2743] = {.lex_state = 0},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 0},
  [2746] = {.lex_state = 0},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 0},
  [2749] = {.lex_state = 0},
  [2750] = {.lex_state = 0},
  [2751] = {.lex_state = 0},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 0},
  [2754] = {.lex_state = 0},
  [2755] = {.lex_state = 0},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 0},
  [2759] = {.lex_state = 0},
  [2760] = {.lex_state = 0},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 0},
  [2763] = {.lex_state = 0},
  [2764] = {.lex_state = 0},
  [2765] = {.lex_state = 0},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 0},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 29},
  [2772] = {.lex_state = 0},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 0},
  [2775] = {.lex_state = 0},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 0},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 0},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 0},
  [2782] = {.lex_state = 0},
  [2783] = {.lex_state = 0},
  [2784] = {.lex_state = 0},
  [2785] = {.lex_state = 26},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 0},
  [2792] = {.lex_state = 0},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0},
  [2796] = {.lex_state = 0},
  [2797] = {.lex_state = 0},
  [2798] = {.lex_state = 0},
  [2799] = {.lex_state = 0},
  [2800] = {.lex_state = 0},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 0},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 0},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 0},
  [2809] = {.lex_state = 0},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 0},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 0},
  [2814] = {.lex_state = 0},
  [2815] = {.lex_state = 0},
  [2816] = {.lex_state = 0},
  [2817] = {.lex_state = 0},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 0},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 0},
  [2822] = {.lex_state = 29},
  [2823] = {.lex_state = 0},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 0},
  [2829] = {.lex_state = 0},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 0},
  [2832] = {.lex_state = 26},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 0},
  [2840] = {.lex_state = 0},
  [2841] = {.lex_state = 0},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 0},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 0},
  [2848] = {.lex_state = 0},
  [2849] = {.lex_state = 0},
  [2850] = {.lex_state = 29},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 0},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 0},
  [2860] = {.lex_state = 0},
  [2861] = {.lex_state = 0},
  [2862] = {.lex_state = 0},
  [2863] = {.lex_state = 0},
  [2864] = {.lex_state = 26},
  [2865] = {.lex_state = 0},
  [2866] = {.lex_state = 0},
  [2867] = {.lex_state = 0},
  [2868] = {.lex_state = 0},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 0},
  [2871] = {.lex_state = 0},
  [2872] = {.lex_state = 0},
  [2873] = {.lex_state = 0},
  [2874] = {.lex_state = 0},
  [2875] = {.lex_state = 0},
  [2876] = {.lex_state = 0},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 0},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 26},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 0},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 0},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 0},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 0},
  [2894] = {.lex_state = 0},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 0},
  [2898] = {.lex_state = 0},
  [2899] = {.lex_state = 0},
  [2900] = {.lex_state = 0},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 0},
  [2903] = {.lex_state = 0},
  [2904] = {.lex_state = 0},
  [2905] = {.lex_state = 0},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 0},
  [2910] = {.lex_state = 0},
  [2911] = {.lex_state = 0},
  [2912] = {.lex_state = 0},
  [2913] = {.lex_state = 0},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 0},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 0},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 0},
  [2922] = {.lex_state = 0},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 29},
  [2925] = {.lex_state = 0},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 0},
  [2929] = {.lex_state = 0},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 0},
  [2932] = {.lex_state = 0},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 0},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 0},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 0},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 0},
  [2943] = {.lex_state = 0},
  [2944] = {.lex_state = 0},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 0},
  [2948] = {.lex_state = 0},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 0},
  [2955] = {.lex_state = 0},
  [2956] = {.lex_state = 0},
  [2957] = {.lex_state = 0},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 0},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 0},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 0},
  [2965] = {.lex_state = 0},
  [2966] = {.lex_state = 0},
  [2967] = {.lex_state = 0},
  [2968] = {.lex_state = 0},
  [2969] = {.lex_state = 0},
  [2970] = {.lex_state = 0},
  [2971] = {.lex_state = 0},
  [2972] = {.lex_state = 0},
  [2973] = {.lex_state = 0},
  [2974] = {.lex_state = 0},
  [2975] = {.lex_state = 0},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 0},
  [2978] = {.lex_state = 0},
  [2979] = {.lex_state = 0},
  [2980] = {.lex_state = 0},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 0},
  [2985] = {.lex_state = 0},
  [2986] = {.lex_state = 0},
  [2987] = {.lex_state = 0},
  [2988] = {.lex_state = 0},
  [2989] = {.lex_state = 0},
  [2990] = {.lex_state = 0},
  [2991] = {.lex_state = 0},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 0},
  [2994] = {.lex_state = 0},
  [2995] = {.lex_state = 0},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 0},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 0},
  [3002] = {.lex_state = 0},
  [3003] = {.lex_state = 0},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 0},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 0},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 0},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 0},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 0},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 0},
  [3030] = {.lex_state = 0},
  [3031] = {.lex_state = 0},
  [3032] = {.lex_state = 0},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 0},
  [3036] = {.lex_state = 0},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 0},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 0},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 0},
  [3047] = {.lex_state = 0},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 0},
  [3052] = {.lex_state = 0},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 0},
  [3055] = {.lex_state = 0},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 0},
  [3059] = {.lex_state = 0},
  [3060] = {.lex_state = 0},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 0},
  [3064] = {.lex_state = 0},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 0},
  [3067] = {.lex_state = 0},
  [3068] = {.lex_state = 0},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 0},
  [3074] = {.lex_state = 29},
  [3075] = {.lex_state = 0, .external_lex_state = 3},
  [3076] = {.lex_state = 0, .external_lex_state = 4},
  [3077] = {.lex_state = 26},
  [3078] = {.lex_state = 0, .external_lex_state = 5},
  [3079] = {.lex_state = 0, .external_lex_state = 6},
  [3080] = {.lex_state = 0, .external_lex_state = 6},
  [3081] = {.lex_state = 0, .external_lex_state = 5},
  [3082] = {.lex_state = 29},
  [3083] = {.lex_state = 0, .external_lex_state = 3},
  [3084] = {.lex_state = 0, .external_lex_state = 7},
  [3085] = {.lex_state = 26},
  [3086] = {.lex_state = 26},
  [3087] = {.lex_state = 29},
  [3088] = {.lex_state = 0, .external_lex_state = 7},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 26},
  [3091] = {.lex_state = 0, .external_lex_state = 3},
  [3092] = {.lex_state = 0, .external_lex_state = 4},
  [3093] = {.lex_state = 0, .external_lex_state = 5},
  [3094] = {.lex_state = 0, .external_lex_state = 6},
  [3095] = {.lex_state = 0},
  [3096] = {.lex_state = 26},
  [3097] = {.lex_state = 29},
  [3098] = {.lex_state = 26},
  [3099] = {.lex_state = 0, .external_lex_state = 7},
  [3100] = {.lex_state = 0, .external_lex_state = 3},
  [3101] = {.lex_state = 0, .external_lex_state = 4},
  [3102] = {.lex_state = 0, .external_lex_state = 5},
  [3103] = {.lex_state = 0, .external_lex_state = 6},
  [3104] = {.lex_state = 26},
  [3105] = {.lex_state = 26},
  [3106] = {.lex_state = 26},
  [3107] = {.lex_state = 26},
  [3108] = {.lex_state = 29},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 29},
  [3111] = {.lex_state = 0},
  [3112] = {.lex_state = 0, .external_lex_state = 7},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 0},
  [3115] = {.lex_state = 0, .external_lex_state = 3},
  [3116] = {.lex_state = 0, .external_lex_state = 4},
  [3117] = {.lex_state = 0},
  [3118] = {.lex_state = 0, .external_lex_state = 5},
  [3119] = {.lex_state = 0, .external_lex_state = 6},
  [3120] = {.lex_state = 26},
  [3121] = {.lex_state = 29},
  [3122] = {.lex_state = 0, .external_lex_state = 7},
  [3123] = {.lex_state = 0, .external_lex_state = 3},
  [3124] = {.lex_state = 0, .external_lex_state = 4},
  [3125] = {.lex_state = 0, .external_lex_state = 5},
  [3126] = {.lex_state = 0, .external_lex_state = 6},
  [3127] = {.lex_state = 26},
  [3128] = {.lex_state = 26},
  [3129] = {.lex_state = 0},
  [3130] = {.lex_state = 29},
  [3131] = {.lex_state = 0},
  [3132] = {.lex_state = 0},
  [3133] = {.lex_state = 0, .external_lex_state = 3},
  [3134] = {.lex_state = 0},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 0, .external_lex_state = 6},
  [3137] = {.lex_state = 0},
  [3138] = {.lex_state = 0, .external_lex_state = 5},
  [3139] = {.lex_state = 0, .external_lex_state = 4},
  [3140] = {.lex_state = 0, .external_lex_state = 3},
  [3141] = {.lex_state = 0, .external_lex_state = 7},
  [3142] = {.lex_state = 26},
  [3143] = {.lex_state = 0},
  [3144] = {.lex_state = 0},
  [3145] = {.lex_state = 0},
  [3146] = {.lex_state = 0},
  [3147] = {.lex_state = 26},
  [3148] = {.lex_state = 0, .external_lex_state = 6},
  [3149] = {.lex_state = 0, .external_lex_state = 5},
  [3150] = {.lex_state = 29},
  [3151] = {.lex_state = 0, .external_lex_state = 4},
  [3152] = {.lex_state = 0, .external_lex_state = 7},
  [3153] = {.lex_state = 26},
  [3154] = {.lex_state = 0},
  [3155] = {.lex_state = 0},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 0},
  [3158] = {.lex_state = 0},
  [3159] = {.lex_state = 0},
  [3160] = {.lex_state = 0},
  [3161] = {.lex_state = 0},
  [3162] = {.lex_state = 29},
  [3163] = {.lex_state = 0},
  [3164] = {.lex_state = 0},
  [3165] = {.lex_state = 0},
  [3166] = {.lex_state = 0, .external_lex_state = 7},
  [3167] = {.lex_state = 0, .external_lex_state = 4},
  [3168] = {.lex_state = 0},
  [3169] = {.lex_state = 0},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 0},
  [3172] = {.lex_state = 26},
  [3173] = {.lex_state = 26},
  [3174] = {.lex_state = 29},
  [3175] = {.lex_state = 26},
  [3176] = {.lex_state = 26},
  [3177] = {.lex_state = 0},
  [3178] = {.lex_state = 0, .external_lex_state = 3},
  [3179] = {.lex_state = 0},
  [3180] = {.lex_state = 0},
  [3181] = {.lex_state = 0},
  [3182] = {.lex_state = 0},
  [3183] = {.lex_state = 0},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 26},
  [3186] = {.lex_state = 26},
  [3187] = {.lex_state = 0, .external_lex_state = 7},
  [3188] = {.lex_state = 0, .external_lex_state = 4},
  [3189] = {.lex_state = 0, .external_lex_state = 5},
  [3190] = {.lex_state = 26},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 0},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 0},
  [3197] = {.lex_state = 0},
  [3198] = {.lex_state = 0},
  [3199] = {.lex_state = 0},
  [3200] = {.lex_state = 0},
  [3201] = {.lex_state = 0},
  [3202] = {.lex_state = 0},
  [3203] = {.lex_state = 0},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
  [3206] = {.lex_state = 0},
  [3207] = {.lex_state = 0},
  [3208] = {.lex_state = 0},
  [3209] = {.lex_state = 0},
  [3210] = {.lex_state = 0},
  [3211] = {.lex_state = 0},
  [3212] = {.lex_state = 0},
  [3213] = {.lex_state = 26},
  [3214] = {.lex_state = 0},
  [3215] = {.lex_state = 0},
  [3216] = {.lex_state = 26},
  [3217] = {.lex_state = 0},
  [3218] = {.lex_state = 0},
  [3219] = {.lex_state = 26},
  [3220] = {.lex_state = 0},
  [3221] = {.lex_state = 0},
  [3222] = {.lex_state = 0},
  [3223] = {.lex_state = 0},
  [3224] = {.lex_state = 0},
  [3225] = {.lex_state = 0},
  [3226] = {.lex_state = 26},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 0},
  [3229] = {.lex_state = 0, .external_lex_state = 6},
  [3230] = {.lex_state = 0},
  [3231] = {.lex_state = 0},
  [3232] = {.lex_state = 0},
  [3233] = {.lex_state = 0},
  [3234] = {.lex_state = 0},
  [3235] = {.lex_state = 0},
  [3236] = {.lex_state = 0},
  [3237] = {.lex_state = 0},
  [3238] = {.lex_state = 0},
  [3239] = {.lex_state = 0},
  [3240] = {.lex_state = 0, .external_lex_state = 3},
  [3241] = {.lex_state = 0},
  [3242] = {.lex_state = 0},
  [3243] = {.lex_state = 0},
  [3244] = {.lex_state = 26},
  [3245] = {.lex_state = 26},
  [3246] = {.lex_state = 0},
  [3247] = {.lex_state = 26},
  [3248] = {.lex_state = 0},
  [3249] = {.lex_state = 27},
  [3250] = {.lex_state = 26},
  [3251] = {.lex_state = 0},
  [3252] = {.lex_state = 0},
  [3253] = {.lex_state = 0},
  [3254] = {.lex_state = 0},
  [3255] = {.lex_state = 0},
  [3256] = {.lex_state = 0},
  [3257] = {.lex_state = 0},
  [3258] = {.lex_state = 0},
  [3259] = {.lex_state = 0},
  [3260] = {.lex_state = 0},
};

enum {
  ts_external_token__trivia_raw_fi = 0,
  ts_external_token__trivia_raw_env_comment = 1,
  ts_external_token__trivia_raw_env_verbatim = 2,
  ts_external_token__trivia_raw_env_listing = 3,
  ts_external_token__trivia_raw_env_minted = 4,
  ts_external_token__trivia_raw_env_pycode = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__trivia_raw_fi] = sym__trivia_raw_fi,
  [ts_external_token__trivia_raw_env_comment] = sym__trivia_raw_env_comment,
  [ts_external_token__trivia_raw_env_verbatim] = sym__trivia_raw_env_verbatim,
  [ts_external_token__trivia_raw_env_listing] = sym__trivia_raw_env_listing,
  [ts_external_token__trivia_raw_env_minted] = sym__trivia_raw_env_minted,
  [ts_external_token__trivia_raw_env_pycode] = sym__trivia_raw_env_pycode,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__trivia_raw_fi] = true,
    [ts_external_token__trivia_raw_env_comment] = true,
    [ts_external_token__trivia_raw_env_verbatim] = true,
    [ts_external_token__trivia_raw_env_listing] = true,
    [ts_external_token__trivia_raw_env_minted] = true,
    [ts_external_token__trivia_raw_env_pycode] = true,
  },
  [2] = {
    [ts_external_token__trivia_raw_fi] = true,
  },
  [3] = {
    [ts_external_token__trivia_raw_env_minted] = true,
  },
  [4] = {
    [ts_external_token__trivia_raw_env_listing] = true,
  },
  [5] = {
    [ts_external_token__trivia_raw_env_verbatim] = true,
  },
  [6] = {
    [ts_external_token__trivia_raw_env_comment] = true,
  },
  [7] = {
    [ts_external_token__trivia_raw_env_pycode] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_command_name] = ACTIONS(1),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(1),
    [anon_sym_BSLASHfi] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHpart] = ACTIONS(1),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddpart] = ACTIONS(1),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHchapter] = ACTIONS(1),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddchap] = ACTIONS(1),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsection] = ACTIONS(1),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddsec] = ACTIONS(1),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHparagraph] = ACTIONS(1),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHitem] = ACTIONS(1),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_BSLASHand] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [sym_argc] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(1),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHbegin] = ACTIONS(1),
    [anon_sym_BSLASHend] = ACTIONS(1),
    [anon_sym_comment] = ACTIONS(1),
    [anon_sym_verbatim] = ACTIONS(1),
    [anon_sym_lstlisting] = ACTIONS(1),
    [anon_sym_minted] = ACTIONS(1),
    [anon_sym_pycode] = ACTIONS(1),
    [anon_sym_displaymath] = ACTIONS(1),
    [anon_sym_displaymath_STAR] = ACTIONS(1),
    [anon_sym_equation] = ACTIONS(1),
    [anon_sym_equation_STAR] = ACTIONS(1),
    [anon_sym_multline] = ACTIONS(1),
    [anon_sym_multline_STAR] = ACTIONS(1),
    [anon_sym_eqnarray] = ACTIONS(1),
    [anon_sym_eqnarray_STAR] = ACTIONS(1),
    [anon_sym_align] = ACTIONS(1),
    [anon_sym_align_STAR] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_array_STAR] = ACTIONS(1),
    [anon_sym_split] = ACTIONS(1),
    [anon_sym_split_STAR] = ACTIONS(1),
    [anon_sym_alignat] = ACTIONS(1),
    [anon_sym_alignat_STAR] = ACTIONS(1),
    [anon_sym_gather] = ACTIONS(1),
    [anon_sym_gather_STAR] = ACTIONS(1),
    [anon_sym_flalign] = ACTIONS(1),
    [anon_sym_flalign_STAR] = ACTIONS(1),
    [anon_sym_BSLASHtitle] = ACTIONS(1),
    [anon_sym_BSLASHauthor] = ACTIONS(1),
    [anon_sym_BSLASHusepackage] = ACTIONS(1),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(1),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(1),
    [anon_sym_BSLASHinclude] = ACTIONS(1),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(1),
    [anon_sym_BSLASHinput] = ACTIONS(1),
    [anon_sym_BSLASHsubfile] = ACTIONS(1),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(1),
    [anon_sym_BSLASHbibliography] = ACTIONS(1),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(1),
    [anon_sym_BSLASHincludesvg] = ACTIONS(1),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(1),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(1),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(1),
    [anon_sym_BSLASHimport] = ACTIONS(1),
    [anon_sym_BSLASHsubimport] = ACTIONS(1),
    [anon_sym_BSLASHinputfrom] = ACTIONS(1),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(1),
    [anon_sym_BSLASHincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHcaption] = ACTIONS(1),
    [anon_sym_BSLASHcite] = ACTIONS(1),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCite] = ACTIONS(1),
    [anon_sym_BSLASHnocite] = ACTIONS(1),
    [anon_sym_BSLASHcitet] = ACTIONS(1),
    [anon_sym_BSLASHcitep] = ACTIONS(1),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteyear] = ACTIONS(1),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitedate] = ACTIONS(1),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteurl] = ACTIONS(1),
    [anon_sym_BSLASHfullcite] = ACTIONS(1),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(1),
    [anon_sym_BSLASHcitealt] = ACTIONS(1),
    [anon_sym_BSLASHcitealp] = ACTIONS(1),
    [anon_sym_BSLASHcitetext] = ACTIONS(1),
    [anon_sym_BSLASHparencite] = ACTIONS(1),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHParencite] = ACTIONS(1),
    [anon_sym_BSLASHfootcite] = ACTIONS(1),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(1),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(1),
    [anon_sym_BSLASHtextcite] = ACTIONS(1),
    [anon_sym_BSLASHTextcite] = ACTIONS(1),
    [anon_sym_BSLASHsmartcite] = ACTIONS(1),
    [anon_sym_BSLASHSmartcite] = ACTIONS(1),
    [anon_sym_BSLASHsupercite] = ACTIONS(1),
    [anon_sym_BSLASHautocite] = ACTIONS(1),
    [anon_sym_BSLASHAutocite] = ACTIONS(1),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHvolcite] = ACTIONS(1),
    [anon_sym_BSLASHVolcite] = ACTIONS(1),
    [anon_sym_BSLASHpvolcite] = ACTIONS(1),
    [anon_sym_BSLASHPvolcite] = ACTIONS(1),
    [anon_sym_BSLASHfvolcite] = ACTIONS(1),
    [anon_sym_BSLASHftvolcite] = ACTIONS(1),
    [anon_sym_BSLASHsvolcite] = ACTIONS(1),
    [anon_sym_BSLASHSvolcite] = ACTIONS(1),
    [anon_sym_BSLASHtvolcite] = ACTIONS(1),
    [anon_sym_BSLASHTvolcite] = ACTIONS(1),
    [anon_sym_BSLASHavolcite] = ACTIONS(1),
    [anon_sym_BSLASHAvolcite] = ACTIONS(1),
    [anon_sym_BSLASHnotecite] = ACTIONS(1),
    [anon_sym_BSLASHNotecite] = ACTIONS(1),
    [anon_sym_BSLASHpnotecite] = ACTIONS(1),
    [anon_sym_BSLASHPnotecite] = ACTIONS(1),
    [anon_sym_BSLASHfnotecite] = ACTIONS(1),
    [anon_sym_BSLASHlabel] = ACTIONS(1),
    [anon_sym_BSLASHref] = ACTIONS(1),
    [anon_sym_BSLASHeqref] = ACTIONS(1),
    [anon_sym_BSLASHvref] = ACTIONS(1),
    [anon_sym_BSLASHVref] = ACTIONS(1),
    [anon_sym_BSLASHautoref] = ACTIONS(1),
    [anon_sym_BSLASHpageref] = ACTIONS(1),
    [anon_sym_BSLASHcref] = ACTIONS(1),
    [anon_sym_BSLASHCref] = ACTIONS(1),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnameCref] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHlabelcref] = ACTIONS(1),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHnewlabel] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdef] = ACTIONS(1),
    [anon_sym_BSLASHlet] = ACTIONS(1),
    [anon_sym_BSLASHleft] = ACTIONS(1),
    [anon_sym_BSLASHbig] = ACTIONS(1),
    [anon_sym_BSLASHBig] = ACTIONS(1),
    [anon_sym_BSLASHbigg] = ACTIONS(1),
    [anon_sym_BSLASHBigg] = ACTIONS(1),
    [anon_sym_BSLASHbigl] = ACTIONS(1),
    [anon_sym_BSLASHBigl] = ACTIONS(1),
    [anon_sym_BSLASHbiggl] = ACTIONS(1),
    [anon_sym_BSLASHBiggl] = ACTIONS(1),
    [anon_sym_BSLASHright] = ACTIONS(1),
    [anon_sym_BSLASHbigr] = ACTIONS(1),
    [anon_sym_BSLASHBigr] = ACTIONS(1),
    [anon_sym_BSLASHbiggr] = ACTIONS(1),
    [anon_sym_BSLASHBiggr] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(1),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(1),
    [anon_sym_BSLASHgls] = ACTIONS(1),
    [anon_sym_BSLASHGls] = ACTIONS(1),
    [anon_sym_BSLASHGLS] = ACTIONS(1),
    [anon_sym_BSLASHglspl] = ACTIONS(1),
    [anon_sym_BSLASHGlspl] = ACTIONS(1),
    [anon_sym_BSLASHGLSpl] = ACTIONS(1),
    [anon_sym_BSLASHglsdisp] = ACTIONS(1),
    [anon_sym_BSLASHglslink] = ACTIONS(1),
    [anon_sym_BSLASHglstext] = ACTIONS(1),
    [anon_sym_BSLASHGlstext] = ACTIONS(1),
    [anon_sym_BSLASHGLStext] = ACTIONS(1),
    [anon_sym_BSLASHglsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(1),
    [anon_sym_BSLASHglsplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSplural] = ACTIONS(1),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHglsname] = ACTIONS(1),
    [anon_sym_BSLASHGlsname] = ACTIONS(1),
    [anon_sym_BSLASHGLSname] = ACTIONS(1),
    [anon_sym_BSLASHglssymbol] = ACTIONS(1),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(1),
    [anon_sym_BSLASHglsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(1),
    [anon_sym_BSLASHglsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(1),
    [anon_sym_BSLASHglsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(1),
    [anon_sym_BSLASHglsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(1),
    [anon_sym_BSLASHglsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(1),
    [anon_sym_BSLASHnewacronym] = ACTIONS(1),
    [anon_sym_BSLASHacrshort] = ACTIONS(1),
    [anon_sym_BSLASHAcrshort] = ACTIONS(1),
    [anon_sym_BSLASHACRshort] = ACTIONS(1),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(1),
    [anon_sym_BSLASHacrlong] = ACTIONS(1),
    [anon_sym_BSLASHAcrlong] = ACTIONS(1),
    [anon_sym_BSLASHACRlong] = ACTIONS(1),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(1),
    [anon_sym_BSLASHacrfull] = ACTIONS(1),
    [anon_sym_BSLASHAcrfull] = ACTIONS(1),
    [anon_sym_BSLASHACRfull] = ACTIONS(1),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(1),
    [anon_sym_BSLASHacs] = ACTIONS(1),
    [anon_sym_BSLASHAcs] = ACTIONS(1),
    [anon_sym_BSLASHacsp] = ACTIONS(1),
    [anon_sym_BSLASHAcsp] = ACTIONS(1),
    [anon_sym_BSLASHacl] = ACTIONS(1),
    [anon_sym_BSLASHAcl] = ACTIONS(1),
    [anon_sym_BSLASHaclp] = ACTIONS(1),
    [anon_sym_BSLASHAclp] = ACTIONS(1),
    [anon_sym_BSLASHacf] = ACTIONS(1),
    [anon_sym_BSLASHAcf] = ACTIONS(1),
    [anon_sym_BSLASHacfp] = ACTIONS(1),
    [anon_sym_BSLASHAcfp] = ACTIONS(1),
    [anon_sym_BSLASHac] = ACTIONS(1),
    [anon_sym_BSLASHAc] = ACTIONS(1),
    [anon_sym_BSLASHacp] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(1),
    [anon_sym_BSLASHcolor] = ACTIONS(1),
    [anon_sym_BSLASHcolorbox] = ACTIONS(1),
    [anon_sym_BSLASHtextcolor] = ACTIONS(1),
    [anon_sym_BSLASHpagecolor] = ACTIONS(1),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(1),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(1),
    [anon_sym_BSLASHtext] = ACTIONS(1),
    [anon_sym_BSLASHintertext] = ACTIONS(1),
    [anon_sym_shortintertext] = ACTIONS(1),
    [sym__trivia_raw_fi] = ACTIONS(1),
    [sym__trivia_raw_env_comment] = ACTIONS(1),
    [sym__trivia_raw_env_verbatim] = ACTIONS(1),
    [sym__trivia_raw_env_listing] = ACTIONS(1),
    [sym__trivia_raw_env_minted] = ACTIONS(1),
    [sym__trivia_raw_env_pycode] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(3135),
    [sym_block_comment] = STATE(128),
    [sym__root_content] = STATE(128),
    [sym__flat_content] = STATE(128),
    [sym__text_with_env_content] = STATE(128),
    [sym__text_content] = STATE(128),
    [sym__section] = STATE(128),
    [sym__part_declaration] = STATE(176),
    [sym_part] = STATE(612),
    [sym__chapter_declaration] = STATE(188),
    [sym_chapter] = STATE(611),
    [sym__section_declaration] = STATE(197),
    [sym_section] = STATE(610),
    [sym__subsection_declaration] = STATE(206),
    [sym_subsection] = STATE(609),
    [sym__subsubsection_declaration] = STATE(216),
    [sym_subsubsection] = STATE(608),
    [sym__paragraph_declaration] = STATE(226),
    [sym_paragraph] = STATE(607),
    [sym__subparagraph_declaration] = STATE(236),
    [sym_subparagraph] = STATE(606),
    [sym__enum_itemdeclaration] = STATE(249),
    [sym_enum_item] = STATE(605),
    [sym_curly_group] = STATE(128),
    [sym_text] = STATE(128),
    [sym_operator] = STATE(1035),
    [sym_displayed_equation] = STATE(128),
    [sym_inline_formula] = STATE(128),
    [sym_begin] = STATE(59),
    [sym_generic_environment] = STATE(128),
    [sym_comment_environment] = STATE(128),
    [sym__comment_environment_begin] = STATE(3136),
    [sym_verbatim_environment] = STATE(128),
    [sym__verbatim_environment_begin] = STATE(3138),
    [sym_listing_environment] = STATE(128),
    [sym__listing_environment_begin] = STATE(3139),
    [sym_minted_environment] = STATE(128),
    [sym__minted_environment_begin] = STATE(3140),
    [sym_pycode_environment] = STATE(128),
    [sym__pycode_environment_begin] = STATE(3141),
    [sym_math_environment] = STATE(128),
    [sym__math_environment_begin] = STATE(262),
    [sym__command] = STATE(128),
    [sym_generic_command] = STATE(128),
    [sym_title_declaration] = STATE(128),
    [sym_author_declaration] = STATE(128),
    [sym_package_include] = STATE(128),
    [sym_class_include] = STATE(128),
    [sym_latex_include] = STATE(128),
    [sym_biblatex_include] = STATE(128),
    [sym_bibtex_include] = STATE(128),
    [sym_graphics_include] = STATE(128),
    [sym_svg_include] = STATE(128),
    [sym_inkscape_include] = STATE(128),
    [sym_verbatim_include] = STATE(128),
    [sym_import_include] = STATE(128),
    [sym_caption] = STATE(128),
    [sym_citation] = STATE(128),
    [sym_label_definition] = STATE(128),
    [sym_label_reference] = STATE(128),
    [sym_label_reference_range] = STATE(128),
    [sym_label_number] = STATE(128),
    [sym_new_command_definition] = STATE(128),
    [sym_old_command_definition] = STATE(128),
    [sym_let_command_definition] = STATE(128),
    [sym_math_delimiter] = STATE(128),
    [sym_paired_delimiter_definition] = STATE(128),
    [sym_environment_definition] = STATE(128),
    [sym_glossary_entry_definition] = STATE(128),
    [sym_glossary_entry_reference] = STATE(128),
    [sym_acronym_definition] = STATE(128),
    [sym_acronym_reference] = STATE(128),
    [sym_theorem_definition] = STATE(128),
    [sym_color_definition] = STATE(128),
    [sym_color_set_definition] = STATE(128),
    [sym_color_reference] = STATE(128),
    [sym_tikz_library_import] = STATE(128),
    [sym_text_mode] = STATE(128),
    [aux_sym_source_file_repeat1] = STATE(128),
    [aux_sym__section_repeat1] = STATE(612),
    [aux_sym__section_repeat2] = STATE(611),
    [aux_sym__section_repeat3] = STATE(610),
    [aux_sym__section_repeat4] = STATE(609),
    [aux_sym__section_repeat5] = STATE(608),
    [aux_sym__section_repeat6] = STATE(607),
    [aux_sym__section_repeat7] = STATE(606),
    [aux_sym__section_repeat8] = STATE(605),
    [aux_sym_text_repeat1] = STATE(282),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_command_name] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(11),
    [anon_sym_COMMA] = ACTIONS(11),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_RPAREN] = ACTIONS(11),
    [anon_sym_BSLASHpart] = ACTIONS(13),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHaddpart] = ACTIONS(13),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHchapter] = ACTIONS(17),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(19),
    [anon_sym_BSLASHaddchap] = ACTIONS(17),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(19),
    [anon_sym_BSLASHsection] = ACTIONS(21),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(23),
    [anon_sym_BSLASHaddsec] = ACTIONS(21),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(23),
    [anon_sym_BSLASHsubsection] = ACTIONS(25),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(27),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(29),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(31),
    [anon_sym_BSLASHparagraph] = ACTIONS(33),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(35),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(37),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(39),
    [anon_sym_BSLASHitem] = ACTIONS(41),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [sym_word] = ACTIONS(47),
    [sym_placeholder] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_GT] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(51),
    [anon_sym_COLON] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(51),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(53),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(57),
    [anon_sym_BSLASHbegin] = ACTIONS(59),
    [anon_sym_BSLASHtitle] = ACTIONS(61),
    [anon_sym_BSLASHauthor] = ACTIONS(63),
    [anon_sym_BSLASHusepackage] = ACTIONS(65),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(65),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(67),
    [anon_sym_BSLASHinclude] = ACTIONS(69),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(69),
    [anon_sym_BSLASHinput] = ACTIONS(69),
    [anon_sym_BSLASHsubfile] = ACTIONS(69),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(71),
    [anon_sym_BSLASHbibliography] = ACTIONS(73),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(75),
    [anon_sym_BSLASHincludesvg] = ACTIONS(77),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(79),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(81),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(81),
    [anon_sym_BSLASHimport] = ACTIONS(83),
    [anon_sym_BSLASHsubimport] = ACTIONS(83),
    [anon_sym_BSLASHinputfrom] = ACTIONS(83),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(83),
    [anon_sym_BSLASHincludefrom] = ACTIONS(83),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(83),
    [anon_sym_BSLASHcaption] = ACTIONS(85),
    [anon_sym_BSLASHcite] = ACTIONS(87),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(89),
    [anon_sym_BSLASHCite] = ACTIONS(87),
    [anon_sym_BSLASHnocite] = ACTIONS(87),
    [anon_sym_BSLASHcitet] = ACTIONS(87),
    [anon_sym_BSLASHcitep] = ACTIONS(87),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(89),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(89),
    [anon_sym_BSLASHciteauthor] = ACTIONS(87),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(89),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(87),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(89),
    [anon_sym_BSLASHcitetitle] = ACTIONS(87),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(89),
    [anon_sym_BSLASHciteyear] = ACTIONS(87),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(89),
    [anon_sym_BSLASHcitedate] = ACTIONS(87),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(89),
    [anon_sym_BSLASHciteurl] = ACTIONS(87),
    [anon_sym_BSLASHfullcite] = ACTIONS(87),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(87),
    [anon_sym_BSLASHcitealt] = ACTIONS(87),
    [anon_sym_BSLASHcitealp] = ACTIONS(87),
    [anon_sym_BSLASHcitetext] = ACTIONS(87),
    [anon_sym_BSLASHparencite] = ACTIONS(87),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(89),
    [anon_sym_BSLASHParencite] = ACTIONS(87),
    [anon_sym_BSLASHfootcite] = ACTIONS(87),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(87),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(87),
    [anon_sym_BSLASHtextcite] = ACTIONS(87),
    [anon_sym_BSLASHTextcite] = ACTIONS(87),
    [anon_sym_BSLASHsmartcite] = ACTIONS(87),
    [anon_sym_BSLASHSmartcite] = ACTIONS(87),
    [anon_sym_BSLASHsupercite] = ACTIONS(87),
    [anon_sym_BSLASHautocite] = ACTIONS(87),
    [anon_sym_BSLASHAutocite] = ACTIONS(87),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(89),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(89),
    [anon_sym_BSLASHvolcite] = ACTIONS(87),
    [anon_sym_BSLASHVolcite] = ACTIONS(87),
    [anon_sym_BSLASHpvolcite] = ACTIONS(87),
    [anon_sym_BSLASHPvolcite] = ACTIONS(87),
    [anon_sym_BSLASHfvolcite] = ACTIONS(87),
    [anon_sym_BSLASHftvolcite] = ACTIONS(87),
    [anon_sym_BSLASHsvolcite] = ACTIONS(87),
    [anon_sym_BSLASHSvolcite] = ACTIONS(87),
    [anon_sym_BSLASHtvolcite] = ACTIONS(87),
    [anon_sym_BSLASHTvolcite] = ACTIONS(87),
    [anon_sym_BSLASHavolcite] = ACTIONS(87),
    [anon_sym_BSLASHAvolcite] = ACTIONS(87),
    [anon_sym_BSLASHnotecite] = ACTIONS(87),
    [anon_sym_BSLASHNotecite] = ACTIONS(87),
    [anon_sym_BSLASHpnotecite] = ACTIONS(87),
    [anon_sym_BSLASHPnotecite] = ACTIONS(87),
    [anon_sym_BSLASHfnotecite] = ACTIONS(87),
    [anon_sym_BSLASHlabel] = ACTIONS(91),
    [anon_sym_BSLASHref] = ACTIONS(93),
    [anon_sym_BSLASHeqref] = ACTIONS(93),
    [anon_sym_BSLASHvref] = ACTIONS(93),
    [anon_sym_BSLASHVref] = ACTIONS(93),
    [anon_sym_BSLASHautoref] = ACTIONS(93),
    [anon_sym_BSLASHpageref] = ACTIONS(93),
    [anon_sym_BSLASHcref] = ACTIONS(93),
    [anon_sym_BSLASHCref] = ACTIONS(93),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(95),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(95),
    [anon_sym_BSLASHnamecref] = ACTIONS(93),
    [anon_sym_BSLASHnameCref] = ACTIONS(93),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(93),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(93),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(93),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(93),
    [anon_sym_BSLASHlabelcref] = ACTIONS(93),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(93),
    [anon_sym_BSLASHcrefrange] = ACTIONS(97),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(99),
    [anon_sym_BSLASHCrefrange] = ACTIONS(97),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(99),
    [anon_sym_BSLASHnewlabel] = ACTIONS(101),
    [anon_sym_BSLASHnewcommand] = ACTIONS(103),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(105),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(103),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(105),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(103),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(105),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(103),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(105),
    [anon_sym_BSLASHdef] = ACTIONS(107),
    [anon_sym_BSLASHlet] = ACTIONS(109),
    [anon_sym_BSLASHleft] = ACTIONS(111),
    [anon_sym_BSLASHbig] = ACTIONS(111),
    [anon_sym_BSLASHBig] = ACTIONS(111),
    [anon_sym_BSLASHbigg] = ACTIONS(111),
    [anon_sym_BSLASHBigg] = ACTIONS(111),
    [anon_sym_BSLASHbigl] = ACTIONS(111),
    [anon_sym_BSLASHBigl] = ACTIONS(111),
    [anon_sym_BSLASHbiggl] = ACTIONS(111),
    [anon_sym_BSLASHBiggl] = ACTIONS(111),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(113),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(113),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(115),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(115),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(117),
    [anon_sym_BSLASHgls] = ACTIONS(119),
    [anon_sym_BSLASHGls] = ACTIONS(119),
    [anon_sym_BSLASHGLS] = ACTIONS(119),
    [anon_sym_BSLASHglspl] = ACTIONS(119),
    [anon_sym_BSLASHGlspl] = ACTIONS(119),
    [anon_sym_BSLASHGLSpl] = ACTIONS(119),
    [anon_sym_BSLASHglsdisp] = ACTIONS(119),
    [anon_sym_BSLASHglslink] = ACTIONS(119),
    [anon_sym_BSLASHglstext] = ACTIONS(119),
    [anon_sym_BSLASHGlstext] = ACTIONS(119),
    [anon_sym_BSLASHGLStext] = ACTIONS(119),
    [anon_sym_BSLASHglsfirst] = ACTIONS(119),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(119),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(119),
    [anon_sym_BSLASHglsplural] = ACTIONS(119),
    [anon_sym_BSLASHGlsplural] = ACTIONS(119),
    [anon_sym_BSLASHGLSplural] = ACTIONS(119),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(119),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(119),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(119),
    [anon_sym_BSLASHglsname] = ACTIONS(119),
    [anon_sym_BSLASHGlsname] = ACTIONS(119),
    [anon_sym_BSLASHGLSname] = ACTIONS(119),
    [anon_sym_BSLASHglssymbol] = ACTIONS(119),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(119),
    [anon_sym_BSLASHglsdesc] = ACTIONS(119),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(119),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(119),
    [anon_sym_BSLASHglsuseri] = ACTIONS(119),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(119),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(119),
    [anon_sym_BSLASHglsuserii] = ACTIONS(119),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(119),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(119),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(119),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(119),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(119),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(119),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(119),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(119),
    [anon_sym_BSLASHglsuserv] = ACTIONS(119),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(119),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(119),
    [anon_sym_BSLASHglsuservi] = ACTIONS(119),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(119),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(119),
    [anon_sym_BSLASHnewacronym] = ACTIONS(121),
    [anon_sym_BSLASHacrshort] = ACTIONS(123),
    [anon_sym_BSLASHAcrshort] = ACTIONS(123),
    [anon_sym_BSLASHACRshort] = ACTIONS(123),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(123),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(123),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(123),
    [anon_sym_BSLASHacrlong] = ACTIONS(123),
    [anon_sym_BSLASHAcrlong] = ACTIONS(123),
    [anon_sym_BSLASHACRlong] = ACTIONS(123),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(123),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(123),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(123),
    [anon_sym_BSLASHacrfull] = ACTIONS(123),
    [anon_sym_BSLASHAcrfull] = ACTIONS(123),
    [anon_sym_BSLASHACRfull] = ACTIONS(123),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(123),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(123),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(123),
    [anon_sym_BSLASHacs] = ACTIONS(123),
    [anon_sym_BSLASHAcs] = ACTIONS(123),
    [anon_sym_BSLASHacsp] = ACTIONS(123),
    [anon_sym_BSLASHAcsp] = ACTIONS(123),
    [anon_sym_BSLASHacl] = ACTIONS(123),
    [anon_sym_BSLASHAcl] = ACTIONS(123),
    [anon_sym_BSLASHaclp] = ACTIONS(123),
    [anon_sym_BSLASHAclp] = ACTIONS(123),
    [anon_sym_BSLASHacf] = ACTIONS(123),
    [anon_sym_BSLASHAcf] = ACTIONS(123),
    [anon_sym_BSLASHacfp] = ACTIONS(123),
    [anon_sym_BSLASHAcfp] = ACTIONS(123),
    [anon_sym_BSLASHac] = ACTIONS(123),
    [anon_sym_BSLASHAc] = ACTIONS(123),
    [anon_sym_BSLASHacp] = ACTIONS(123),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(123),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(123),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(123),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(123),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(123),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(123),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(123),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(123),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(123),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(123),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(125),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(127),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(125),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(127),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(129),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(131),
    [anon_sym_BSLASHcolor] = ACTIONS(133),
    [anon_sym_BSLASHcolorbox] = ACTIONS(133),
    [anon_sym_BSLASHtextcolor] = ACTIONS(133),
    [anon_sym_BSLASHpagecolor] = ACTIONS(133),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(135),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(135),
    [anon_sym_BSLASHtext] = ACTIONS(137),
    [anon_sym_BSLASHintertext] = ACTIONS(137),
    [anon_sym_shortintertext] = ACTIONS(137),
  },
  [2] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_RBRACK] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_EQ] = ACTIONS(141),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHchapter] = ACTIONS(149),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(151),
    [anon_sym_BSLASHaddchap] = ACTIONS(149),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(151),
    [anon_sym_BSLASHsection] = ACTIONS(153),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(155),
    [anon_sym_BSLASHaddsec] = ACTIONS(153),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(155),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(161),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(163),
    [anon_sym_BSLASHparagraph] = ACTIONS(165),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(167),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_RBRACE] = ACTIONS(143),
    [anon_sym_BSLASHand] = ACTIONS(139),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(59),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139),
    [anon_sym_BSLASHcref] = ACTIONS(139),
    [anon_sym_BSLASHCref] = ACTIONS(139),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnameCref] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHlabelcref] = ACTIONS(139),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCrefrange] = ACTIONS(139),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnewlabel] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(139),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(139),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(139),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdef] = ACTIONS(139),
    [anon_sym_BSLASHlet] = ACTIONS(139),
    [anon_sym_BSLASHleft] = ACTIONS(139),
    [anon_sym_BSLASHbig] = ACTIONS(139),
    [anon_sym_BSLASHBig] = ACTIONS(139),
    [anon_sym_BSLASHbigg] = ACTIONS(139),
    [anon_sym_BSLASHBigg] = ACTIONS(139),
    [anon_sym_BSLASHbigl] = ACTIONS(139),
    [anon_sym_BSLASHBigl] = ACTIONS(139),
    [anon_sym_BSLASHbiggl] = ACTIONS(139),
    [anon_sym_BSLASHBiggl] = ACTIONS(139),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(139),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(139),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(139),
    [anon_sym_BSLASHgls] = ACTIONS(139),
    [anon_sym_BSLASHGls] = ACTIONS(139),
    [anon_sym_BSLASHGLS] = ACTIONS(139),
    [anon_sym_BSLASHglspl] = ACTIONS(139),
    [anon_sym_BSLASHGlspl] = ACTIONS(139),
    [anon_sym_BSLASHGLSpl] = ACTIONS(139),
    [anon_sym_BSLASHglsdisp] = ACTIONS(139),
    [anon_sym_BSLASHglslink] = ACTIONS(139),
    [anon_sym_BSLASHglstext] = ACTIONS(139),
    [anon_sym_BSLASHGlstext] = ACTIONS(139),
    [anon_sym_BSLASHGLStext] = ACTIONS(139),
    [anon_sym_BSLASHglsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(139),
    [anon_sym_BSLASHglsplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSplural] = ACTIONS(139),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHglsname] = ACTIONS(139),
    [anon_sym_BSLASHGlsname] = ACTIONS(139),
    [anon_sym_BSLASHGLSname] = ACTIONS(139),
    [anon_sym_BSLASHglssymbol] = ACTIONS(139),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(139),
    [anon_sym_BSLASHglsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(139),
    [anon_sym_BSLASHglsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(139),
    [anon_sym_BSLASHglsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(139),
    [anon_sym_BSLASHglsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(139),
    [anon_sym_BSLASHglsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(139),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(139),
    [anon_sym_BSLASHAcrshort] = ACTIONS(139),
    [anon_sym_BSLASHACRshort] = ACTIONS(139),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(139),
    [anon_sym_BSLASHacrlong] = ACTIONS(139),
    [anon_sym_BSLASHAcrlong] = ACTIONS(139),
    [anon_sym_BSLASHACRlong] = ACTIONS(139),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(139),
    [anon_sym_BSLASHacrfull] = ACTIONS(139),
    [anon_sym_BSLASHAcrfull] = ACTIONS(139),
    [anon_sym_BSLASHACRfull] = ACTIONS(139),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(139),
    [anon_sym_BSLASHacs] = ACTIONS(139),
    [anon_sym_BSLASHAcs] = ACTIONS(139),
    [anon_sym_BSLASHacsp] = ACTIONS(139),
    [anon_sym_BSLASHAcsp] = ACTIONS(139),
    [anon_sym_BSLASHacl] = ACTIONS(139),
    [anon_sym_BSLASHAcl] = ACTIONS(139),
    [anon_sym_BSLASHaclp] = ACTIONS(139),
    [anon_sym_BSLASHAclp] = ACTIONS(139),
    [anon_sym_BSLASHacf] = ACTIONS(139),
    [anon_sym_BSLASHAcf] = ACTIONS(139),
    [anon_sym_BSLASHacfp] = ACTIONS(139),
    [anon_sym_BSLASHAcfp] = ACTIONS(139),
    [anon_sym_BSLASHac] = ACTIONS(139),
    [anon_sym_BSLASHAc] = ACTIONS(139),
    [anon_sym_BSLASHacp] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(139),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(139),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(139),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(139),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(139),
    [anon_sym_BSLASHtext] = ACTIONS(139),
    [anon_sym_BSLASHintertext] = ACTIONS(139),
    [anon_sym_shortintertext] = ACTIONS(139),
  },
  [3] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_RBRACK] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_EQ] = ACTIONS(141),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHchapter] = ACTIONS(149),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(151),
    [anon_sym_BSLASHaddchap] = ACTIONS(149),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(151),
    [anon_sym_BSLASHsection] = ACTIONS(153),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(155),
    [anon_sym_BSLASHaddsec] = ACTIONS(153),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(155),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(161),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(163),
    [anon_sym_BSLASHparagraph] = ACTIONS(165),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(167),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_RBRACE] = ACTIONS(181),
    [anon_sym_BSLASHand] = ACTIONS(179),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(59),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [4] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(139),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddpart] = ACTIONS(139),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHchapter] = ACTIONS(139),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddchap] = ACTIONS(139),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsection] = ACTIONS(139),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddsec] = ACTIONS(139),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHparagraph] = ACTIONS(139),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(139),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHitem] = ACTIONS(139),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_RBRACE] = ACTIONS(143),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(139),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139),
    [anon_sym_BSLASHcref] = ACTIONS(139),
    [anon_sym_BSLASHCref] = ACTIONS(139),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnameCref] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHlabelcref] = ACTIONS(139),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCrefrange] = ACTIONS(139),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnewlabel] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(139),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(139),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(139),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdef] = ACTIONS(139),
    [anon_sym_BSLASHlet] = ACTIONS(139),
    [anon_sym_BSLASHleft] = ACTIONS(139),
    [anon_sym_BSLASHbig] = ACTIONS(139),
    [anon_sym_BSLASHBig] = ACTIONS(139),
    [anon_sym_BSLASHbigg] = ACTIONS(139),
    [anon_sym_BSLASHBigg] = ACTIONS(139),
    [anon_sym_BSLASHbigl] = ACTIONS(139),
    [anon_sym_BSLASHBigl] = ACTIONS(139),
    [anon_sym_BSLASHbiggl] = ACTIONS(139),
    [anon_sym_BSLASHBiggl] = ACTIONS(139),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(139),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(139),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(139),
    [anon_sym_BSLASHgls] = ACTIONS(139),
    [anon_sym_BSLASHGls] = ACTIONS(139),
    [anon_sym_BSLASHGLS] = ACTIONS(139),
    [anon_sym_BSLASHglspl] = ACTIONS(139),
    [anon_sym_BSLASHGlspl] = ACTIONS(139),
    [anon_sym_BSLASHGLSpl] = ACTIONS(139),
    [anon_sym_BSLASHglsdisp] = ACTIONS(139),
    [anon_sym_BSLASHglslink] = ACTIONS(139),
    [anon_sym_BSLASHglstext] = ACTIONS(139),
    [anon_sym_BSLASHGlstext] = ACTIONS(139),
    [anon_sym_BSLASHGLStext] = ACTIONS(139),
    [anon_sym_BSLASHglsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(139),
    [anon_sym_BSLASHglsplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSplural] = ACTIONS(139),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHglsname] = ACTIONS(139),
    [anon_sym_BSLASHGlsname] = ACTIONS(139),
    [anon_sym_BSLASHGLSname] = ACTIONS(139),
    [anon_sym_BSLASHglssymbol] = ACTIONS(139),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(139),
    [anon_sym_BSLASHglsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(139),
    [anon_sym_BSLASHglsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(139),
    [anon_sym_BSLASHglsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(139),
    [anon_sym_BSLASHglsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(139),
    [anon_sym_BSLASHglsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(139),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(139),
    [anon_sym_BSLASHAcrshort] = ACTIONS(139),
    [anon_sym_BSLASHACRshort] = ACTIONS(139),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(139),
    [anon_sym_BSLASHacrlong] = ACTIONS(139),
    [anon_sym_BSLASHAcrlong] = ACTIONS(139),
    [anon_sym_BSLASHACRlong] = ACTIONS(139),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(139),
    [anon_sym_BSLASHacrfull] = ACTIONS(139),
    [anon_sym_BSLASHAcrfull] = ACTIONS(139),
    [anon_sym_BSLASHACRfull] = ACTIONS(139),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(139),
    [anon_sym_BSLASHacs] = ACTIONS(139),
    [anon_sym_BSLASHAcs] = ACTIONS(139),
    [anon_sym_BSLASHacsp] = ACTIONS(139),
    [anon_sym_BSLASHAcsp] = ACTIONS(139),
    [anon_sym_BSLASHacl] = ACTIONS(139),
    [anon_sym_BSLASHAcl] = ACTIONS(139),
    [anon_sym_BSLASHaclp] = ACTIONS(139),
    [anon_sym_BSLASHAclp] = ACTIONS(139),
    [anon_sym_BSLASHacf] = ACTIONS(139),
    [anon_sym_BSLASHAcf] = ACTIONS(139),
    [anon_sym_BSLASHacfp] = ACTIONS(139),
    [anon_sym_BSLASHAcfp] = ACTIONS(139),
    [anon_sym_BSLASHac] = ACTIONS(139),
    [anon_sym_BSLASHAc] = ACTIONS(139),
    [anon_sym_BSLASHacp] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(139),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(139),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(139),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(139),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(139),
    [anon_sym_BSLASHtext] = ACTIONS(139),
    [anon_sym_BSLASHintertext] = ACTIONS(139),
    [anon_sym_shortintertext] = ACTIONS(139),
  },
  [5] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [ts_builtin_sym_end] = ACTIONS(181),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(179),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddpart] = ACTIONS(179),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHchapter] = ACTIONS(179),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddchap] = ACTIONS(179),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsection] = ACTIONS(179),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddsec] = ACTIONS(179),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHparagraph] = ACTIONS(179),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(179),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_RBRACE] = ACTIONS(181),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(179),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [6] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHchapter] = ACTIONS(149),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(151),
    [anon_sym_BSLASHaddchap] = ACTIONS(149),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(151),
    [anon_sym_BSLASHsection] = ACTIONS(153),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(155),
    [anon_sym_BSLASHaddsec] = ACTIONS(153),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(155),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(161),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(163),
    [anon_sym_BSLASHparagraph] = ACTIONS(165),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(167),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(143),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(139),
    [anon_sym_BSLASHend] = ACTIONS(139),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139),
    [anon_sym_BSLASHcref] = ACTIONS(139),
    [anon_sym_BSLASHCref] = ACTIONS(139),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnameCref] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHlabelcref] = ACTIONS(139),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCrefrange] = ACTIONS(139),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnewlabel] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(139),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(139),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(139),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdef] = ACTIONS(139),
    [anon_sym_BSLASHlet] = ACTIONS(139),
    [anon_sym_BSLASHleft] = ACTIONS(139),
    [anon_sym_BSLASHbig] = ACTIONS(139),
    [anon_sym_BSLASHBig] = ACTIONS(139),
    [anon_sym_BSLASHbigg] = ACTIONS(139),
    [anon_sym_BSLASHBigg] = ACTIONS(139),
    [anon_sym_BSLASHbigl] = ACTIONS(139),
    [anon_sym_BSLASHBigl] = ACTIONS(139),
    [anon_sym_BSLASHbiggl] = ACTIONS(139),
    [anon_sym_BSLASHBiggl] = ACTIONS(139),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(139),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(139),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(139),
    [anon_sym_BSLASHgls] = ACTIONS(139),
    [anon_sym_BSLASHGls] = ACTIONS(139),
    [anon_sym_BSLASHGLS] = ACTIONS(139),
    [anon_sym_BSLASHglspl] = ACTIONS(139),
    [anon_sym_BSLASHGlspl] = ACTIONS(139),
    [anon_sym_BSLASHGLSpl] = ACTIONS(139),
    [anon_sym_BSLASHglsdisp] = ACTIONS(139),
    [anon_sym_BSLASHglslink] = ACTIONS(139),
    [anon_sym_BSLASHglstext] = ACTIONS(139),
    [anon_sym_BSLASHGlstext] = ACTIONS(139),
    [anon_sym_BSLASHGLStext] = ACTIONS(139),
    [anon_sym_BSLASHglsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(139),
    [anon_sym_BSLASHglsplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSplural] = ACTIONS(139),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHglsname] = ACTIONS(139),
    [anon_sym_BSLASHGlsname] = ACTIONS(139),
    [anon_sym_BSLASHGLSname] = ACTIONS(139),
    [anon_sym_BSLASHglssymbol] = ACTIONS(139),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(139),
    [anon_sym_BSLASHglsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(139),
    [anon_sym_BSLASHglsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(139),
    [anon_sym_BSLASHglsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(139),
    [anon_sym_BSLASHglsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(139),
    [anon_sym_BSLASHglsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(139),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(139),
    [anon_sym_BSLASHAcrshort] = ACTIONS(139),
    [anon_sym_BSLASHACRshort] = ACTIONS(139),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(139),
    [anon_sym_BSLASHacrlong] = ACTIONS(139),
    [anon_sym_BSLASHAcrlong] = ACTIONS(139),
    [anon_sym_BSLASHACRlong] = ACTIONS(139),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(139),
    [anon_sym_BSLASHacrfull] = ACTIONS(139),
    [anon_sym_BSLASHAcrfull] = ACTIONS(139),
    [anon_sym_BSLASHACRfull] = ACTIONS(139),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(139),
    [anon_sym_BSLASHacs] = ACTIONS(139),
    [anon_sym_BSLASHAcs] = ACTIONS(139),
    [anon_sym_BSLASHacsp] = ACTIONS(139),
    [anon_sym_BSLASHAcsp] = ACTIONS(139),
    [anon_sym_BSLASHacl] = ACTIONS(139),
    [anon_sym_BSLASHAcl] = ACTIONS(139),
    [anon_sym_BSLASHaclp] = ACTIONS(139),
    [anon_sym_BSLASHAclp] = ACTIONS(139),
    [anon_sym_BSLASHacf] = ACTIONS(139),
    [anon_sym_BSLASHAcf] = ACTIONS(139),
    [anon_sym_BSLASHacfp] = ACTIONS(139),
    [anon_sym_BSLASHAcfp] = ACTIONS(139),
    [anon_sym_BSLASHac] = ACTIONS(139),
    [anon_sym_BSLASHAc] = ACTIONS(139),
    [anon_sym_BSLASHacp] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(139),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(139),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(139),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(139),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(139),
    [anon_sym_BSLASHtext] = ACTIONS(139),
    [anon_sym_BSLASHintertext] = ACTIONS(139),
    [anon_sym_shortintertext] = ACTIONS(139),
  },
  [7] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHchapter] = ACTIONS(149),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(151),
    [anon_sym_BSLASHaddchap] = ACTIONS(149),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(151),
    [anon_sym_BSLASHsection] = ACTIONS(153),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(155),
    [anon_sym_BSLASHaddsec] = ACTIONS(153),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(155),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(161),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(163),
    [anon_sym_BSLASHparagraph] = ACTIONS(165),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(167),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_RBRACE] = ACTIONS(181),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(59),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [8] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(179),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddpart] = ACTIONS(179),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHchapter] = ACTIONS(179),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddchap] = ACTIONS(179),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsection] = ACTIONS(179),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddsec] = ACTIONS(179),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHparagraph] = ACTIONS(179),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(179),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(181),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(179),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [9] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(147),
    [anon_sym_BSLASHchapter] = ACTIONS(149),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(151),
    [anon_sym_BSLASHaddchap] = ACTIONS(149),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(151),
    [anon_sym_BSLASHsection] = ACTIONS(153),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(155),
    [anon_sym_BSLASHaddsec] = ACTIONS(153),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(155),
    [anon_sym_BSLASHsubsection] = ACTIONS(157),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(159),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(161),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(163),
    [anon_sym_BSLASHparagraph] = ACTIONS(165),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(167),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(169),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(171),
    [anon_sym_BSLASHitem] = ACTIONS(173),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(181),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(179),
    [anon_sym_BSLASHend] = ACTIONS(179),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [10] = {
    [sym_block_comment] = STATE(126),
    [sym__root_content] = STATE(126),
    [sym__flat_content] = STATE(126),
    [sym__text_with_env_content] = STATE(126),
    [sym__text_content] = STATE(126),
    [sym__section] = STATE(126),
    [sym__part_declaration] = STATE(180),
    [sym_part] = STATE(876),
    [sym__chapter_declaration] = STATE(191),
    [sym_chapter] = STATE(875),
    [sym__section_declaration] = STATE(200),
    [sym_section] = STATE(641),
    [sym__subsection_declaration] = STATE(215),
    [sym_subsection] = STATE(874),
    [sym__subsubsection_declaration] = STATE(220),
    [sym_subsubsection] = STATE(873),
    [sym__paragraph_declaration] = STATE(232),
    [sym_paragraph] = STATE(872),
    [sym__subparagraph_declaration] = STATE(245),
    [sym_subparagraph] = STATE(842),
    [sym__enum_itemdeclaration] = STATE(257),
    [sym_enum_item] = STATE(841),
    [sym_curly_group] = STATE(126),
    [sym_text] = STATE(126),
    [sym_operator] = STATE(1329),
    [sym_displayed_equation] = STATE(126),
    [sym_inline_formula] = STATE(126),
    [sym_begin] = STATE(86),
    [sym_generic_environment] = STATE(126),
    [sym_comment_environment] = STATE(126),
    [sym__comment_environment_begin] = STATE(3126),
    [sym_verbatim_environment] = STATE(126),
    [sym__verbatim_environment_begin] = STATE(3125),
    [sym_listing_environment] = STATE(126),
    [sym__listing_environment_begin] = STATE(3124),
    [sym_minted_environment] = STATE(126),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(126),
    [sym__pycode_environment_begin] = STATE(3122),
    [sym_math_environment] = STATE(126),
    [sym__math_environment_begin] = STATE(261),
    [sym__command] = STATE(126),
    [sym_generic_command] = STATE(126),
    [sym_title_declaration] = STATE(126),
    [sym_author_declaration] = STATE(126),
    [sym_package_include] = STATE(126),
    [sym_class_include] = STATE(126),
    [sym_latex_include] = STATE(126),
    [sym_biblatex_include] = STATE(126),
    [sym_bibtex_include] = STATE(126),
    [sym_graphics_include] = STATE(126),
    [sym_svg_include] = STATE(126),
    [sym_inkscape_include] = STATE(126),
    [sym_verbatim_include] = STATE(126),
    [sym_import_include] = STATE(126),
    [sym_caption] = STATE(126),
    [sym_citation] = STATE(126),
    [sym_label_definition] = STATE(126),
    [sym_label_reference] = STATE(126),
    [sym_label_reference_range] = STATE(126),
    [sym_label_number] = STATE(126),
    [sym_new_command_definition] = STATE(126),
    [sym_old_command_definition] = STATE(126),
    [sym_let_command_definition] = STATE(126),
    [sym_math_delimiter] = STATE(126),
    [sym_paired_delimiter_definition] = STATE(126),
    [sym_environment_definition] = STATE(126),
    [sym_glossary_entry_definition] = STATE(126),
    [sym_glossary_entry_reference] = STATE(126),
    [sym_acronym_definition] = STATE(126),
    [sym_acronym_reference] = STATE(126),
    [sym_theorem_definition] = STATE(126),
    [sym_color_definition] = STATE(126),
    [sym_color_set_definition] = STATE(126),
    [sym_color_reference] = STATE(126),
    [sym_tikz_library_import] = STATE(126),
    [sym_text_mode] = STATE(126),
    [aux_sym_source_file_repeat1] = STATE(126),
    [aux_sym__section_repeat1] = STATE(876),
    [aux_sym__section_repeat2] = STATE(875),
    [aux_sym__section_repeat3] = STATE(641),
    [aux_sym__section_repeat4] = STATE(874),
    [aux_sym__section_repeat5] = STATE(873),
    [aux_sym__section_repeat6] = STATE(872),
    [aux_sym__section_repeat7] = STATE(842),
    [aux_sym__section_repeat8] = STATE(841),
    [aux_sym_text_repeat1] = STATE(290),
    [sym_command_name] = ACTIONS(183),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(183),
    [anon_sym_LBRACK] = ACTIONS(185),
    [anon_sym_RBRACK] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(183),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(183),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(183),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddchap] = ACTIONS(183),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsection] = ACTIONS(183),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddsec] = ACTIONS(183),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsection] = ACTIONS(183),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(183),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHparagraph] = ACTIONS(183),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(183),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHitem] = ACTIONS(183),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(185),
    [anon_sym_LBRACE] = ACTIONS(185),
    [sym_word] = ACTIONS(183),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(183),
    [anon_sym_DASH] = ACTIONS(183),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(183),
    [anon_sym_CARET] = ACTIONS(183),
    [anon_sym__] = ACTIONS(183),
    [anon_sym_LT] = ACTIONS(183),
    [anon_sym_GT] = ACTIONS(183),
    [anon_sym_BANG] = ACTIONS(183),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(183),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(187),
    [anon_sym_DOLLAR] = ACTIONS(183),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(183),
    [anon_sym_BSLASHtitle] = ACTIONS(183),
    [anon_sym_BSLASHauthor] = ACTIONS(183),
    [anon_sym_BSLASHusepackage] = ACTIONS(183),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(183),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(183),
    [anon_sym_BSLASHinclude] = ACTIONS(183),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(183),
    [anon_sym_BSLASHinput] = ACTIONS(183),
    [anon_sym_BSLASHsubfile] = ACTIONS(183),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(183),
    [anon_sym_BSLASHbibliography] = ACTIONS(183),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(183),
    [anon_sym_BSLASHincludesvg] = ACTIONS(183),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(183),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(183),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(183),
    [anon_sym_BSLASHimport] = ACTIONS(183),
    [anon_sym_BSLASHsubimport] = ACTIONS(183),
    [anon_sym_BSLASHinputfrom] = ACTIONS(183),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(183),
    [anon_sym_BSLASHincludefrom] = ACTIONS(183),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(183),
    [anon_sym_BSLASHcaption] = ACTIONS(183),
    [anon_sym_BSLASHcite] = ACTIONS(183),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(183),
    [anon_sym_BSLASHnocite] = ACTIONS(183),
    [anon_sym_BSLASHcitet] = ACTIONS(183),
    [anon_sym_BSLASHcitep] = ACTIONS(183),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(183),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(183),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(183),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(183),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(183),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(183),
    [anon_sym_BSLASHfullcite] = ACTIONS(183),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(183),
    [anon_sym_BSLASHcitealt] = ACTIONS(183),
    [anon_sym_BSLASHcitealp] = ACTIONS(183),
    [anon_sym_BSLASHcitetext] = ACTIONS(183),
    [anon_sym_BSLASHparencite] = ACTIONS(183),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(183),
    [anon_sym_BSLASHfootcite] = ACTIONS(183),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(183),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(183),
    [anon_sym_BSLASHtextcite] = ACTIONS(183),
    [anon_sym_BSLASHTextcite] = ACTIONS(183),
    [anon_sym_BSLASHsmartcite] = ACTIONS(183),
    [anon_sym_BSLASHSmartcite] = ACTIONS(183),
    [anon_sym_BSLASHsupercite] = ACTIONS(183),
    [anon_sym_BSLASHautocite] = ACTIONS(183),
    [anon_sym_BSLASHAutocite] = ACTIONS(183),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(183),
    [anon_sym_BSLASHVolcite] = ACTIONS(183),
    [anon_sym_BSLASHpvolcite] = ACTIONS(183),
    [anon_sym_BSLASHPvolcite] = ACTIONS(183),
    [anon_sym_BSLASHfvolcite] = ACTIONS(183),
    [anon_sym_BSLASHftvolcite] = ACTIONS(183),
    [anon_sym_BSLASHsvolcite] = ACTIONS(183),
    [anon_sym_BSLASHSvolcite] = ACTIONS(183),
    [anon_sym_BSLASHtvolcite] = ACTIONS(183),
    [anon_sym_BSLASHTvolcite] = ACTIONS(183),
    [anon_sym_BSLASHavolcite] = ACTIONS(183),
    [anon_sym_BSLASHAvolcite] = ACTIONS(183),
    [anon_sym_BSLASHnotecite] = ACTIONS(183),
    [anon_sym_BSLASHNotecite] = ACTIONS(183),
    [anon_sym_BSLASHpnotecite] = ACTIONS(183),
    [anon_sym_BSLASHPnotecite] = ACTIONS(183),
    [anon_sym_BSLASHfnotecite] = ACTIONS(183),
    [anon_sym_BSLASHlabel] = ACTIONS(183),
    [anon_sym_BSLASHref] = ACTIONS(183),
    [anon_sym_BSLASHeqref] = ACTIONS(183),
    [anon_sym_BSLASHvref] = ACTIONS(183),
    [anon_sym_BSLASHVref] = ACTIONS(183),
    [anon_sym_BSLASHautoref] = ACTIONS(183),
    [anon_sym_BSLASHpageref] = ACTIONS(183),
    [anon_sym_BSLASHcref] = ACTIONS(183),
    [anon_sym_BSLASHCref] = ACTIONS(183),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(183),
    [anon_sym_BSLASHnameCref] = ACTIONS(183),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(183),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(183),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(183),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(183),
    [anon_sym_BSLASHlabelcref] = ACTIONS(183),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(183),
    [anon_sym_BSLASHcrefrange] = ACTIONS(183),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(183),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(183),
    [anon_sym_BSLASHnewcommand] = ACTIONS(183),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(183),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(183),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(183),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdef] = ACTIONS(183),
    [anon_sym_BSLASHlet] = ACTIONS(183),
    [anon_sym_BSLASHleft] = ACTIONS(183),
    [anon_sym_BSLASHbig] = ACTIONS(183),
    [anon_sym_BSLASHBig] = ACTIONS(183),
    [anon_sym_BSLASHbigg] = ACTIONS(183),
    [anon_sym_BSLASHBigg] = ACTIONS(183),
    [anon_sym_BSLASHbigl] = ACTIONS(183),
    [anon_sym_BSLASHBigl] = ACTIONS(183),
    [anon_sym_BSLASHbiggl] = ACTIONS(183),
    [anon_sym_BSLASHBiggl] = ACTIONS(183),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(183),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(183),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(183),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(183),
    [anon_sym_BSLASHgls] = ACTIONS(183),
    [anon_sym_BSLASHGls] = ACTIONS(183),
    [anon_sym_BSLASHGLS] = ACTIONS(183),
    [anon_sym_BSLASHglspl] = ACTIONS(183),
    [anon_sym_BSLASHGlspl] = ACTIONS(183),
    [anon_sym_BSLASHGLSpl] = ACTIONS(183),
    [anon_sym_BSLASHglsdisp] = ACTIONS(183),
    [anon_sym_BSLASHglslink] = ACTIONS(183),
    [anon_sym_BSLASHglstext] = ACTIONS(183),
    [anon_sym_BSLASHGlstext] = ACTIONS(183),
    [anon_sym_BSLASHGLStext] = ACTIONS(183),
    [anon_sym_BSLASHglsfirst] = ACTIONS(183),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(183),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(183),
    [anon_sym_BSLASHglsplural] = ACTIONS(183),
    [anon_sym_BSLASHGlsplural] = ACTIONS(183),
    [anon_sym_BSLASHGLSplural] = ACTIONS(183),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(183),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(183),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(183),
    [anon_sym_BSLASHglsname] = ACTIONS(183),
    [anon_sym_BSLASHGlsname] = ACTIONS(183),
    [anon_sym_BSLASHGLSname] = ACTIONS(183),
    [anon_sym_BSLASHglssymbol] = ACTIONS(183),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(183),
    [anon_sym_BSLASHglsdesc] = ACTIONS(183),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(183),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(183),
    [anon_sym_BSLASHglsuseri] = ACTIONS(183),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(183),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(183),
    [anon_sym_BSLASHglsuserii] = ACTIONS(183),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(183),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(183),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(183),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(183),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(183),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(183),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(183),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(183),
    [anon_sym_BSLASHglsuserv] = ACTIONS(183),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(183),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(183),
    [anon_sym_BSLASHglsuservi] = ACTIONS(183),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(183),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(183),
    [anon_sym_BSLASHnewacronym] = ACTIONS(183),
    [anon_sym_BSLASHacrshort] = ACTIONS(183),
    [anon_sym_BSLASHAcrshort] = ACTIONS(183),
    [anon_sym_BSLASHACRshort] = ACTIONS(183),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(183),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(183),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(183),
    [anon_sym_BSLASHacrlong] = ACTIONS(183),
    [anon_sym_BSLASHAcrlong] = ACTIONS(183),
    [anon_sym_BSLASHACRlong] = ACTIONS(183),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(183),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(183),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(183),
    [anon_sym_BSLASHacrfull] = ACTIONS(183),
    [anon_sym_BSLASHAcrfull] = ACTIONS(183),
    [anon_sym_BSLASHACRfull] = ACTIONS(183),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(183),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(183),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(183),
    [anon_sym_BSLASHacs] = ACTIONS(183),
    [anon_sym_BSLASHAcs] = ACTIONS(183),
    [anon_sym_BSLASHacsp] = ACTIONS(183),
    [anon_sym_BSLASHAcsp] = ACTIONS(183),
    [anon_sym_BSLASHacl] = ACTIONS(183),
    [anon_sym_BSLASHAcl] = ACTIONS(183),
    [anon_sym_BSLASHaclp] = ACTIONS(183),
    [anon_sym_BSLASHAclp] = ACTIONS(183),
    [anon_sym_BSLASHacf] = ACTIONS(183),
    [anon_sym_BSLASHAcf] = ACTIONS(183),
    [anon_sym_BSLASHacfp] = ACTIONS(183),
    [anon_sym_BSLASHAcfp] = ACTIONS(183),
    [anon_sym_BSLASHac] = ACTIONS(183),
    [anon_sym_BSLASHAc] = ACTIONS(183),
    [anon_sym_BSLASHacp] = ACTIONS(183),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(183),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(183),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(183),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(183),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(183),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(183),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(183),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(183),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(183),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(183),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(183),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(183),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(183),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(183),
    [anon_sym_BSLASHcolor] = ACTIONS(183),
    [anon_sym_BSLASHcolorbox] = ACTIONS(183),
    [anon_sym_BSLASHtextcolor] = ACTIONS(183),
    [anon_sym_BSLASHpagecolor] = ACTIONS(183),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(183),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(183),
    [anon_sym_BSLASHtext] = ACTIONS(183),
    [anon_sym_BSLASHintertext] = ACTIONS(183),
    [anon_sym_shortintertext] = ACTIONS(183),
  },
  [11] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(179),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_RBRACK] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(181),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_BSLASHpart] = ACTIONS(179),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddpart] = ACTIONS(179),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(181),
    [anon_sym_BSLASHchapter] = ACTIONS(179),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddchap] = ACTIONS(179),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsection] = ACTIONS(179),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHaddsec] = ACTIONS(179),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(179),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(181),
    [anon_sym_BSLASHparagraph] = ACTIONS(179),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(179),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(181),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(181),
    [sym_word] = ACTIONS(179),
    [sym_placeholder] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_CARET] = ACTIONS(179),
    [anon_sym__] = ACTIONS(179),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(179),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_COLON] = ACTIONS(179),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(181),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(181),
    [anon_sym_DOLLAR] = ACTIONS(179),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(181),
    [anon_sym_BSLASHbegin] = ACTIONS(179),
    [anon_sym_BSLASHend] = ACTIONS(179),
    [anon_sym_BSLASHtitle] = ACTIONS(179),
    [anon_sym_BSLASHauthor] = ACTIONS(179),
    [anon_sym_BSLASHusepackage] = ACTIONS(179),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(179),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(179),
    [anon_sym_BSLASHinclude] = ACTIONS(179),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(179),
    [anon_sym_BSLASHinput] = ACTIONS(179),
    [anon_sym_BSLASHsubfile] = ACTIONS(179),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(179),
    [anon_sym_BSLASHbibliography] = ACTIONS(179),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(179),
    [anon_sym_BSLASHincludesvg] = ACTIONS(179),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(179),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(179),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(179),
    [anon_sym_BSLASHimport] = ACTIONS(179),
    [anon_sym_BSLASHsubimport] = ACTIONS(179),
    [anon_sym_BSLASHinputfrom] = ACTIONS(179),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(179),
    [anon_sym_BSLASHincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(179),
    [anon_sym_BSLASHcaption] = ACTIONS(179),
    [anon_sym_BSLASHcite] = ACTIONS(179),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCite] = ACTIONS(179),
    [anon_sym_BSLASHnocite] = ACTIONS(179),
    [anon_sym_BSLASHcitet] = ACTIONS(179),
    [anon_sym_BSLASHcitep] = ACTIONS(179),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteauthor] = ACTIONS(179),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(179),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitetitle] = ACTIONS(179),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteyear] = ACTIONS(179),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(181),
    [anon_sym_BSLASHcitedate] = ACTIONS(179),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(181),
    [anon_sym_BSLASHciteurl] = ACTIONS(179),
    [anon_sym_BSLASHfullcite] = ACTIONS(179),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(179),
    [anon_sym_BSLASHcitealt] = ACTIONS(179),
    [anon_sym_BSLASHcitealp] = ACTIONS(179),
    [anon_sym_BSLASHcitetext] = ACTIONS(179),
    [anon_sym_BSLASHparencite] = ACTIONS(179),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHParencite] = ACTIONS(179),
    [anon_sym_BSLASHfootcite] = ACTIONS(179),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(179),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(179),
    [anon_sym_BSLASHtextcite] = ACTIONS(179),
    [anon_sym_BSLASHTextcite] = ACTIONS(179),
    [anon_sym_BSLASHsmartcite] = ACTIONS(179),
    [anon_sym_BSLASHSmartcite] = ACTIONS(179),
    [anon_sym_BSLASHsupercite] = ACTIONS(179),
    [anon_sym_BSLASHautocite] = ACTIONS(179),
    [anon_sym_BSLASHAutocite] = ACTIONS(179),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(181),
    [anon_sym_BSLASHvolcite] = ACTIONS(179),
    [anon_sym_BSLASHVolcite] = ACTIONS(179),
    [anon_sym_BSLASHpvolcite] = ACTIONS(179),
    [anon_sym_BSLASHPvolcite] = ACTIONS(179),
    [anon_sym_BSLASHfvolcite] = ACTIONS(179),
    [anon_sym_BSLASHftvolcite] = ACTIONS(179),
    [anon_sym_BSLASHsvolcite] = ACTIONS(179),
    [anon_sym_BSLASHSvolcite] = ACTIONS(179),
    [anon_sym_BSLASHtvolcite] = ACTIONS(179),
    [anon_sym_BSLASHTvolcite] = ACTIONS(179),
    [anon_sym_BSLASHavolcite] = ACTIONS(179),
    [anon_sym_BSLASHAvolcite] = ACTIONS(179),
    [anon_sym_BSLASHnotecite] = ACTIONS(179),
    [anon_sym_BSLASHNotecite] = ACTIONS(179),
    [anon_sym_BSLASHpnotecite] = ACTIONS(179),
    [anon_sym_BSLASHPnotecite] = ACTIONS(179),
    [anon_sym_BSLASHfnotecite] = ACTIONS(179),
    [anon_sym_BSLASHlabel] = ACTIONS(179),
    [anon_sym_BSLASHref] = ACTIONS(179),
    [anon_sym_BSLASHeqref] = ACTIONS(179),
    [anon_sym_BSLASHvref] = ACTIONS(179),
    [anon_sym_BSLASHVref] = ACTIONS(179),
    [anon_sym_BSLASHautoref] = ACTIONS(179),
    [anon_sym_BSLASHpageref] = ACTIONS(179),
    [anon_sym_BSLASHcref] = ACTIONS(179),
    [anon_sym_BSLASHCref] = ACTIONS(179),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnameCref] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(179),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(179),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(179),
    [anon_sym_BSLASHlabelcref] = ACTIONS(179),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange] = ACTIONS(179),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHCrefrange] = ACTIONS(179),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(181),
    [anon_sym_BSLASHnewlabel] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand] = ACTIONS(179),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(179),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(179),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(181),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(179),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdef] = ACTIONS(179),
    [anon_sym_BSLASHlet] = ACTIONS(179),
    [anon_sym_BSLASHleft] = ACTIONS(179),
    [anon_sym_BSLASHbig] = ACTIONS(179),
    [anon_sym_BSLASHBig] = ACTIONS(179),
    [anon_sym_BSLASHbigg] = ACTIONS(179),
    [anon_sym_BSLASHBigg] = ACTIONS(179),
    [anon_sym_BSLASHbigl] = ACTIONS(179),
    [anon_sym_BSLASHBigl] = ACTIONS(179),
    [anon_sym_BSLASHbiggl] = ACTIONS(179),
    [anon_sym_BSLASHBiggl] = ACTIONS(179),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(179),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(179),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(179),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(179),
    [anon_sym_BSLASHgls] = ACTIONS(179),
    [anon_sym_BSLASHGls] = ACTIONS(179),
    [anon_sym_BSLASHGLS] = ACTIONS(179),
    [anon_sym_BSLASHglspl] = ACTIONS(179),
    [anon_sym_BSLASHGlspl] = ACTIONS(179),
    [anon_sym_BSLASHGLSpl] = ACTIONS(179),
    [anon_sym_BSLASHglsdisp] = ACTIONS(179),
    [anon_sym_BSLASHglslink] = ACTIONS(179),
    [anon_sym_BSLASHglstext] = ACTIONS(179),
    [anon_sym_BSLASHGlstext] = ACTIONS(179),
    [anon_sym_BSLASHGLStext] = ACTIONS(179),
    [anon_sym_BSLASHglsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(179),
    [anon_sym_BSLASHglsplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSplural] = ACTIONS(179),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(179),
    [anon_sym_BSLASHglsname] = ACTIONS(179),
    [anon_sym_BSLASHGlsname] = ACTIONS(179),
    [anon_sym_BSLASHGLSname] = ACTIONS(179),
    [anon_sym_BSLASHglssymbol] = ACTIONS(179),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(179),
    [anon_sym_BSLASHglsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(179),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(179),
    [anon_sym_BSLASHglsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(179),
    [anon_sym_BSLASHglsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(179),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(179),
    [anon_sym_BSLASHglsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(179),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(179),
    [anon_sym_BSLASHglsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(179),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(179),
    [anon_sym_BSLASHnewacronym] = ACTIONS(179),
    [anon_sym_BSLASHacrshort] = ACTIONS(179),
    [anon_sym_BSLASHAcrshort] = ACTIONS(179),
    [anon_sym_BSLASHACRshort] = ACTIONS(179),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(179),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(179),
    [anon_sym_BSLASHacrlong] = ACTIONS(179),
    [anon_sym_BSLASHAcrlong] = ACTIONS(179),
    [anon_sym_BSLASHACRlong] = ACTIONS(179),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(179),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(179),
    [anon_sym_BSLASHacrfull] = ACTIONS(179),
    [anon_sym_BSLASHAcrfull] = ACTIONS(179),
    [anon_sym_BSLASHACRfull] = ACTIONS(179),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(179),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(179),
    [anon_sym_BSLASHacs] = ACTIONS(179),
    [anon_sym_BSLASHAcs] = ACTIONS(179),
    [anon_sym_BSLASHacsp] = ACTIONS(179),
    [anon_sym_BSLASHAcsp] = ACTIONS(179),
    [anon_sym_BSLASHacl] = ACTIONS(179),
    [anon_sym_BSLASHAcl] = ACTIONS(179),
    [anon_sym_BSLASHaclp] = ACTIONS(179),
    [anon_sym_BSLASHAclp] = ACTIONS(179),
    [anon_sym_BSLASHacf] = ACTIONS(179),
    [anon_sym_BSLASHAcf] = ACTIONS(179),
    [anon_sym_BSLASHacfp] = ACTIONS(179),
    [anon_sym_BSLASHAcfp] = ACTIONS(179),
    [anon_sym_BSLASHac] = ACTIONS(179),
    [anon_sym_BSLASHAc] = ACTIONS(179),
    [anon_sym_BSLASHacp] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(179),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(179),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(179),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(179),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(179),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(181),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(179),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(179),
    [anon_sym_BSLASHcolor] = ACTIONS(179),
    [anon_sym_BSLASHcolorbox] = ACTIONS(179),
    [anon_sym_BSLASHtextcolor] = ACTIONS(179),
    [anon_sym_BSLASHpagecolor] = ACTIONS(179),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(179),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(179),
    [anon_sym_BSLASHtext] = ACTIONS(179),
    [anon_sym_BSLASHintertext] = ACTIONS(179),
    [anon_sym_shortintertext] = ACTIONS(179),
  },
  [12] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(139),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddpart] = ACTIONS(139),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHchapter] = ACTIONS(139),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddchap] = ACTIONS(139),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsection] = ACTIONS(139),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddsec] = ACTIONS(139),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHparagraph] = ACTIONS(139),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(139),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHitem] = ACTIONS(139),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(143),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(139),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139),
    [anon_sym_BSLASHcref] = ACTIONS(139),
    [anon_sym_BSLASHCref] = ACTIONS(139),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnameCref] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHlabelcref] = ACTIONS(139),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCrefrange] = ACTIONS(139),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnewlabel] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(139),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(139),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(139),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdef] = ACTIONS(139),
    [anon_sym_BSLASHlet] = ACTIONS(139),
    [anon_sym_BSLASHleft] = ACTIONS(139),
    [anon_sym_BSLASHbig] = ACTIONS(139),
    [anon_sym_BSLASHBig] = ACTIONS(139),
    [anon_sym_BSLASHbigg] = ACTIONS(139),
    [anon_sym_BSLASHBigg] = ACTIONS(139),
    [anon_sym_BSLASHbigl] = ACTIONS(139),
    [anon_sym_BSLASHBigl] = ACTIONS(139),
    [anon_sym_BSLASHbiggl] = ACTIONS(139),
    [anon_sym_BSLASHBiggl] = ACTIONS(139),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(139),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(139),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(139),
    [anon_sym_BSLASHgls] = ACTIONS(139),
    [anon_sym_BSLASHGls] = ACTIONS(139),
    [anon_sym_BSLASHGLS] = ACTIONS(139),
    [anon_sym_BSLASHglspl] = ACTIONS(139),
    [anon_sym_BSLASHGlspl] = ACTIONS(139),
    [anon_sym_BSLASHGLSpl] = ACTIONS(139),
    [anon_sym_BSLASHglsdisp] = ACTIONS(139),
    [anon_sym_BSLASHglslink] = ACTIONS(139),
    [anon_sym_BSLASHglstext] = ACTIONS(139),
    [anon_sym_BSLASHGlstext] = ACTIONS(139),
    [anon_sym_BSLASHGLStext] = ACTIONS(139),
    [anon_sym_BSLASHglsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(139),
    [anon_sym_BSLASHglsplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSplural] = ACTIONS(139),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHglsname] = ACTIONS(139),
    [anon_sym_BSLASHGlsname] = ACTIONS(139),
    [anon_sym_BSLASHGLSname] = ACTIONS(139),
    [anon_sym_BSLASHglssymbol] = ACTIONS(139),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(139),
    [anon_sym_BSLASHglsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(139),
    [anon_sym_BSLASHglsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(139),
    [anon_sym_BSLASHglsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(139),
    [anon_sym_BSLASHglsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(139),
    [anon_sym_BSLASHglsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(139),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(139),
    [anon_sym_BSLASHAcrshort] = ACTIONS(139),
    [anon_sym_BSLASHACRshort] = ACTIONS(139),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(139),
    [anon_sym_BSLASHacrlong] = ACTIONS(139),
    [anon_sym_BSLASHAcrlong] = ACTIONS(139),
    [anon_sym_BSLASHACRlong] = ACTIONS(139),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(139),
    [anon_sym_BSLASHacrfull] = ACTIONS(139),
    [anon_sym_BSLASHAcrfull] = ACTIONS(139),
    [anon_sym_BSLASHACRfull] = ACTIONS(139),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(139),
    [anon_sym_BSLASHacs] = ACTIONS(139),
    [anon_sym_BSLASHAcs] = ACTIONS(139),
    [anon_sym_BSLASHacsp] = ACTIONS(139),
    [anon_sym_BSLASHAcsp] = ACTIONS(139),
    [anon_sym_BSLASHacl] = ACTIONS(139),
    [anon_sym_BSLASHAcl] = ACTIONS(139),
    [anon_sym_BSLASHaclp] = ACTIONS(139),
    [anon_sym_BSLASHAclp] = ACTIONS(139),
    [anon_sym_BSLASHacf] = ACTIONS(139),
    [anon_sym_BSLASHAcf] = ACTIONS(139),
    [anon_sym_BSLASHacfp] = ACTIONS(139),
    [anon_sym_BSLASHAcfp] = ACTIONS(139),
    [anon_sym_BSLASHac] = ACTIONS(139),
    [anon_sym_BSLASHAc] = ACTIONS(139),
    [anon_sym_BSLASHacp] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(139),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(139),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(139),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(139),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(139),
    [anon_sym_BSLASHtext] = ACTIONS(139),
    [anon_sym_BSLASHintertext] = ACTIONS(139),
    [anon_sym_shortintertext] = ACTIONS(139),
  },
  [13] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(139),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddpart] = ACTIONS(139),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHchapter] = ACTIONS(139),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddchap] = ACTIONS(139),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsection] = ACTIONS(139),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddsec] = ACTIONS(139),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHparagraph] = ACTIONS(139),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(139),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHitem] = ACTIONS(139),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(143),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(139),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139),
    [anon_sym_BSLASHcref] = ACTIONS(139),
    [anon_sym_BSLASHCref] = ACTIONS(139),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnameCref] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(139),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(139),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(139),
    [anon_sym_BSLASHlabelcref] = ACTIONS(139),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange] = ACTIONS(139),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCrefrange] = ACTIONS(139),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(143),
    [anon_sym_BSLASHnewlabel] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand] = ACTIONS(139),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(139),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(139),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(143),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(139),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdef] = ACTIONS(139),
    [anon_sym_BSLASHlet] = ACTIONS(139),
    [anon_sym_BSLASHleft] = ACTIONS(139),
    [anon_sym_BSLASHbig] = ACTIONS(139),
    [anon_sym_BSLASHBig] = ACTIONS(139),
    [anon_sym_BSLASHbigg] = ACTIONS(139),
    [anon_sym_BSLASHBigg] = ACTIONS(139),
    [anon_sym_BSLASHbigl] = ACTIONS(139),
    [anon_sym_BSLASHBigl] = ACTIONS(139),
    [anon_sym_BSLASHbiggl] = ACTIONS(139),
    [anon_sym_BSLASHBiggl] = ACTIONS(139),
    [anon_sym_BSLASHright] = ACTIONS(177),
    [anon_sym_BSLASHbigr] = ACTIONS(177),
    [anon_sym_BSLASHBigr] = ACTIONS(177),
    [anon_sym_BSLASHbiggr] = ACTIONS(177),
    [anon_sym_BSLASHBiggr] = ACTIONS(177),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(139),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(139),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(139),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(139),
    [anon_sym_BSLASHgls] = ACTIONS(139),
    [anon_sym_BSLASHGls] = ACTIONS(139),
    [anon_sym_BSLASHGLS] = ACTIONS(139),
    [anon_sym_BSLASHglspl] = ACTIONS(139),
    [anon_sym_BSLASHGlspl] = ACTIONS(139),
    [anon_sym_BSLASHGLSpl] = ACTIONS(139),
    [anon_sym_BSLASHglsdisp] = ACTIONS(139),
    [anon_sym_BSLASHglslink] = ACTIONS(139),
    [anon_sym_BSLASHglstext] = ACTIONS(139),
    [anon_sym_BSLASHGlstext] = ACTIONS(139),
    [anon_sym_BSLASHGLStext] = ACTIONS(139),
    [anon_sym_BSLASHglsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(139),
    [anon_sym_BSLASHglsplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSplural] = ACTIONS(139),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(139),
    [anon_sym_BSLASHglsname] = ACTIONS(139),
    [anon_sym_BSLASHGlsname] = ACTIONS(139),
    [anon_sym_BSLASHGLSname] = ACTIONS(139),
    [anon_sym_BSLASHglssymbol] = ACTIONS(139),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(139),
    [anon_sym_BSLASHglsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(139),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(139),
    [anon_sym_BSLASHglsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(139),
    [anon_sym_BSLASHglsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(139),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(139),
    [anon_sym_BSLASHglsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(139),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(139),
    [anon_sym_BSLASHglsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(139),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(139),
    [anon_sym_BSLASHnewacronym] = ACTIONS(139),
    [anon_sym_BSLASHacrshort] = ACTIONS(139),
    [anon_sym_BSLASHAcrshort] = ACTIONS(139),
    [anon_sym_BSLASHACRshort] = ACTIONS(139),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(139),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(139),
    [anon_sym_BSLASHacrlong] = ACTIONS(139),
    [anon_sym_BSLASHAcrlong] = ACTIONS(139),
    [anon_sym_BSLASHACRlong] = ACTIONS(139),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(139),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(139),
    [anon_sym_BSLASHacrfull] = ACTIONS(139),
    [anon_sym_BSLASHAcrfull] = ACTIONS(139),
    [anon_sym_BSLASHACRfull] = ACTIONS(139),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(139),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(139),
    [anon_sym_BSLASHacs] = ACTIONS(139),
    [anon_sym_BSLASHAcs] = ACTIONS(139),
    [anon_sym_BSLASHacsp] = ACTIONS(139),
    [anon_sym_BSLASHAcsp] = ACTIONS(139),
    [anon_sym_BSLASHacl] = ACTIONS(139),
    [anon_sym_BSLASHAcl] = ACTIONS(139),
    [anon_sym_BSLASHaclp] = ACTIONS(139),
    [anon_sym_BSLASHAclp] = ACTIONS(139),
    [anon_sym_BSLASHacf] = ACTIONS(139),
    [anon_sym_BSLASHAcf] = ACTIONS(139),
    [anon_sym_BSLASHacfp] = ACTIONS(139),
    [anon_sym_BSLASHAcfp] = ACTIONS(139),
    [anon_sym_BSLASHac] = ACTIONS(139),
    [anon_sym_BSLASHAc] = ACTIONS(139),
    [anon_sym_BSLASHacp] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(139),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(139),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(139),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(139),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(139),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(143),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(139),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(139),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(139),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(139),
    [anon_sym_BSLASHtext] = ACTIONS(139),
    [anon_sym_BSLASHintertext] = ACTIONS(139),
    [anon_sym_shortintertext] = ACTIONS(139),
  },
  [14] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(174),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(189),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(208),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(219),
    [sym_paragraph] = STATE(372),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(239),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(445),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3080),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3081),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3167),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3083),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3084),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(372),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(260),
    [sym_command_name] = ACTIONS(139),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_BSLASHpart] = ACTIONS(139),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddpart] = ACTIONS(139),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(143),
    [anon_sym_BSLASHchapter] = ACTIONS(139),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddchap] = ACTIONS(139),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsection] = ACTIONS(139),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHaddsec] = ACTIONS(139),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(139),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(143),
    [anon_sym_BSLASHparagraph] = ACTIONS(139),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(139),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(143),
    [anon_sym_BSLASHitem] = ACTIONS(139),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(143),
    [sym_word] = ACTIONS(139),
    [sym_placeholder] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(139),
    [anon_sym_SLASH] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(139),
    [anon_sym__] = ACTIONS(139),
    [anon_sym_LT] = ACTIONS(139),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(139),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_SQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(143),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(139),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(143),
    [anon_sym_BSLASHbegin] = ACTIONS(139),
    [anon_sym_BSLASHend] = ACTIONS(139),
    [anon_sym_BSLASHtitle] = ACTIONS(139),
    [anon_sym_BSLASHauthor] = ACTIONS(139),
    [anon_sym_BSLASHusepackage] = ACTIONS(139),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(139),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(139),
    [anon_sym_BSLASHinclude] = ACTIONS(139),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(139),
    [anon_sym_BSLASHinput] = ACTIONS(139),
    [anon_sym_BSLASHsubfile] = ACTIONS(139),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(139),
    [anon_sym_BSLASHbibliography] = ACTIONS(139),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(139),
    [anon_sym_BSLASHincludesvg] = ACTIONS(139),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(139),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(139),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(139),
    [anon_sym_BSLASHimport] = ACTIONS(139),
    [anon_sym_BSLASHsubimport] = ACTIONS(139),
    [anon_sym_BSLASHinputfrom] = ACTIONS(139),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(139),
    [anon_sym_BSLASHincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(139),
    [anon_sym_BSLASHcaption] = ACTIONS(139),
    [anon_sym_BSLASHcite] = ACTIONS(139),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCite] = ACTIONS(139),
    [anon_sym_BSLASHnocite] = ACTIONS(139),
    [anon_sym_BSLASHcitet] = ACTIONS(139),
    [anon_sym_BSLASHcitep] = ACTIONS(139),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteauthor] = ACTIONS(139),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(139),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitetitle] = ACTIONS(139),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteyear] = ACTIONS(139),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(143),
    [anon_sym_BSLASHcitedate] = ACTIONS(139),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(143),
    [anon_sym_BSLASHciteurl] = ACTIONS(139),
    [anon_sym_BSLASHfullcite] = ACTIONS(139),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(139),
    [anon_sym_BSLASHcitealt] = ACTIONS(139),
    [anon_sym_BSLASHcitealp] = ACTIONS(139),
    [anon_sym_BSLASHcitetext] = ACTIONS(139),
    [anon_sym_BSLASHparencite] = ACTIONS(139),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHParencite] = ACTIONS(139),
    [anon_sym_BSLASHfootcite] = ACTIONS(139),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(139),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(139),
    [anon_sym_BSLASHtextcite] = ACTIONS(139),
    [anon_sym_BSLASHTextcite] = ACTIONS(139),
    [anon_sym_BSLASHsmartcite] = ACTIONS(139),
    [anon_sym_BSLASHSmartcite] = ACTIONS(139),
    [anon_sym_BSLASHsupercite] = ACTIONS(139),
    [anon_sym_BSLASHautocite] = ACTIONS(139),
    [anon_sym_BSLASHAutocite] = ACTIONS(139),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(143),
    [anon_sym_BSLASHvolcite] = ACTIONS(139),
    [anon_sym_BSLASHVolcite] = ACTIONS(139),
    [anon_sym_BSLASHpvolcite] = ACTIONS(139),
    [anon_sym_BSLASHPvolcite] = ACTIONS(139),
    [anon_sym_BSLASHfvolcite] = ACTIONS(139),
    [anon_sym_BSLASHftvolcite] = ACTIONS(139),
    [anon_sym_BSLASHsvolcite] = ACTIONS(139),
    [anon_sym_BSLASHSvolcite] = ACTIONS(139),
    [anon_sym_BSLASHtvolcite] = ACTIONS(139),
    [anon_sym_BSLASHTvolcite] = ACTIONS(139),
    [anon_sym_BSLASHavolcite] = ACTIONS(139),
    [anon_sym_BSLASHAvolcite] = ACTIONS(139),
    [anon_sym_BSLASHnotecite] = ACTIONS(139),
    [anon_sym_BSLASHNotecite] = ACTIONS(139),
    [anon_sym_BSLASHpnotecite] = ACTIONS(139),
    [anon_sym_BSLASHPnotecite] = ACTIONS(139),
    [anon_sym_BSLASHfnotecite] = ACTIONS(139),
    [anon_sym_BSLASHlabel] = ACTIONS(139),
    [anon_sym_BSLASHref] = ACTIONS(139),
    [anon_sym_BSLASHeqref] = ACTIONS(139),
    [anon_sym_BSLASHvref] = ACTIONS(139),
    [anon_sym_BSLASHVref] = ACTIONS(139),
    [anon_sym_BSLASHautoref] = ACTIONS(139),
    [anon_sym_BSLASHpageref] = ACTIONS(139