

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Callbacks
    ( 

 -- * Signals


-- ** BufferMessageFuncT #signal:BufferMessageFuncT#

    BufferMessageFuncT                      ,
    BufferMessageFuncT_WithClosures         ,
    C_BufferMessageFuncT                    ,
    drop_closures_BufferMessageFuncT        ,
    dynamic_BufferMessageFuncT              ,
    genClosure_BufferMessageFuncT           ,
    mk_BufferMessageFuncT                   ,
    noBufferMessageFuncT                    ,
    noBufferMessageFuncT_WithClosures       ,
    wrap_BufferMessageFuncT                 ,


-- ** ColorLineGetColorStopsFuncT #signal:ColorLineGetColorStopsFuncT#

    C_ColorLineGetColorStopsFuncT           ,
    ColorLineGetColorStopsFuncT             ,
    ColorLineGetColorStopsFuncT_WithClosures,
    drop_closures_ColorLineGetColorStopsFuncT,
    dynamic_ColorLineGetColorStopsFuncT     ,
    genClosure_ColorLineGetColorStopsFuncT  ,
    mk_ColorLineGetColorStopsFuncT          ,
    noColorLineGetColorStopsFuncT           ,
    noColorLineGetColorStopsFuncT_WithClosures,
    wrap_ColorLineGetColorStopsFuncT        ,


-- ** ColorLineGetExtendFuncT #signal:ColorLineGetExtendFuncT#

    C_ColorLineGetExtendFuncT               ,
    ColorLineGetExtendFuncT                 ,
    ColorLineGetExtendFuncT_WithClosures    ,
    drop_closures_ColorLineGetExtendFuncT   ,
    dynamic_ColorLineGetExtendFuncT         ,
    genClosure_ColorLineGetExtendFuncT      ,
    mk_ColorLineGetExtendFuncT              ,
    noColorLineGetExtendFuncT               ,
    noColorLineGetExtendFuncT_WithClosures  ,
    wrap_ColorLineGetExtendFuncT            ,


-- ** DestroyFuncT #signal:DestroyFuncT#

    C_DestroyFuncT                          ,
    DestroyFuncT                            ,
    DestroyFuncT_WithClosures               ,
    drop_closures_DestroyFuncT              ,
    dynamic_DestroyFuncT                    ,
    genClosure_DestroyFuncT                 ,
    mk_DestroyFuncT                         ,
    noDestroyFuncT                          ,
    noDestroyFuncT_WithClosures             ,
    wrap_DestroyFuncT                       ,


-- ** DrawClosePathFuncT #signal:DrawClosePathFuncT#

    C_DrawClosePathFuncT                    ,
    DrawClosePathFuncT                      ,
    DrawClosePathFuncT_WithClosures         ,
    drop_closures_DrawClosePathFuncT        ,
    dynamic_DrawClosePathFuncT              ,
    genClosure_DrawClosePathFuncT           ,
    mk_DrawClosePathFuncT                   ,
    noDrawClosePathFuncT                    ,
    noDrawClosePathFuncT_WithClosures       ,
    wrap_DrawClosePathFuncT                 ,


-- ** DrawCubicToFuncT #signal:DrawCubicToFuncT#

    C_DrawCubicToFuncT                      ,
    DrawCubicToFuncT                        ,
    DrawCubicToFuncT_WithClosures           ,
    drop_closures_DrawCubicToFuncT          ,
    dynamic_DrawCubicToFuncT                ,
    genClosure_DrawCubicToFuncT             ,
    mk_DrawCubicToFuncT                     ,
    noDrawCubicToFuncT                      ,
    noDrawCubicToFuncT_WithClosures         ,
    wrap_DrawCubicToFuncT                   ,


-- ** DrawLineToFuncT #signal:DrawLineToFuncT#

    C_DrawLineToFuncT                       ,
    DrawLineToFuncT                         ,
    DrawLineToFuncT_WithClosures            ,
    drop_closures_DrawLineToFuncT           ,
    dynamic_DrawLineToFuncT                 ,
    genClosure_DrawLineToFuncT              ,
    mk_DrawLineToFuncT                      ,
    noDrawLineToFuncT                       ,
    noDrawLineToFuncT_WithClosures          ,
    wrap_DrawLineToFuncT                    ,


-- ** DrawMoveToFuncT #signal:DrawMoveToFuncT#

    C_DrawMoveToFuncT                       ,
    DrawMoveToFuncT                         ,
    DrawMoveToFuncT_WithClosures            ,
    drop_closures_DrawMoveToFuncT           ,
    dynamic_DrawMoveToFuncT                 ,
    genClosure_DrawMoveToFuncT              ,
    mk_DrawMoveToFuncT                      ,
    noDrawMoveToFuncT                       ,
    noDrawMoveToFuncT_WithClosures          ,
    wrap_DrawMoveToFuncT                    ,


-- ** DrawQuadraticToFuncT #signal:DrawQuadraticToFuncT#

    C_DrawQuadraticToFuncT                  ,
    DrawQuadraticToFuncT                    ,
    DrawQuadraticToFuncT_WithClosures       ,
    drop_closures_DrawQuadraticToFuncT      ,
    dynamic_DrawQuadraticToFuncT            ,
    genClosure_DrawQuadraticToFuncT         ,
    mk_DrawQuadraticToFuncT                 ,
    noDrawQuadraticToFuncT                  ,
    noDrawQuadraticToFuncT_WithClosures     ,
    wrap_DrawQuadraticToFuncT               ,


-- ** FontDrawGlyphFuncT #signal:FontDrawGlyphFuncT#

    C_FontDrawGlyphFuncT                    ,
    FontDrawGlyphFuncT                      ,
    FontDrawGlyphFuncT_WithClosures         ,
    drop_closures_FontDrawGlyphFuncT        ,
    dynamic_FontDrawGlyphFuncT              ,
    genClosure_FontDrawGlyphFuncT           ,
    mk_FontDrawGlyphFuncT                   ,
    noFontDrawGlyphFuncT                    ,
    noFontDrawGlyphFuncT_WithClosures       ,
    wrap_FontDrawGlyphFuncT                 ,


-- ** FontDrawGlyphOrFailFuncT #signal:FontDrawGlyphOrFailFuncT#

    C_FontDrawGlyphOrFailFuncT              ,
    FontDrawGlyphOrFailFuncT                ,
    FontDrawGlyphOrFailFuncT_WithClosures   ,
    drop_closures_FontDrawGlyphOrFailFuncT  ,
    dynamic_FontDrawGlyphOrFailFuncT        ,
    genClosure_FontDrawGlyphOrFailFuncT     ,
    mk_FontDrawGlyphOrFailFuncT             ,
    noFontDrawGlyphOrFailFuncT              ,
    noFontDrawGlyphOrFailFuncT_WithClosures ,
    wrap_FontDrawGlyphOrFailFuncT           ,


-- ** FontGetFontExtentsFuncT #signal:FontGetFontExtentsFuncT#

    C_FontGetFontExtentsFuncT               ,
    FontGetFontExtentsFuncT                 ,
    FontGetFontExtentsFuncT_WithClosures    ,
    drop_closures_FontGetFontExtentsFuncT   ,
    dynamic_FontGetFontExtentsFuncT         ,
    genClosure_FontGetFontExtentsFuncT      ,
    mk_FontGetFontExtentsFuncT              ,
    noFontGetFontExtentsFuncT               ,
    noFontGetFontExtentsFuncT_WithClosures  ,
    wrap_FontGetFontExtentsFuncT            ,


-- ** FontGetGlyphAdvanceFuncT #signal:FontGetGlyphAdvanceFuncT#

    C_FontGetGlyphAdvanceFuncT              ,
    FontGetGlyphAdvanceFuncT                ,
    FontGetGlyphAdvanceFuncT_WithClosures   ,
    drop_closures_FontGetGlyphAdvanceFuncT  ,
    dynamic_FontGetGlyphAdvanceFuncT        ,
    genClosure_FontGetGlyphAdvanceFuncT     ,
    mk_FontGetGlyphAdvanceFuncT             ,
    noFontGetGlyphAdvanceFuncT              ,
    noFontGetGlyphAdvanceFuncT_WithClosures ,
    wrap_FontGetGlyphAdvanceFuncT           ,


-- ** FontGetGlyphAdvancesFuncT #signal:FontGetGlyphAdvancesFuncT#

    C_FontGetGlyphAdvancesFuncT             ,
    FontGetGlyphAdvancesFuncT               ,
    FontGetGlyphAdvancesFuncT_WithClosures  ,
    drop_closures_FontGetGlyphAdvancesFuncT ,
    dynamic_FontGetGlyphAdvancesFuncT       ,
    genClosure_FontGetGlyphAdvancesFuncT    ,
    mk_FontGetGlyphAdvancesFuncT            ,
    noFontGetGlyphAdvancesFuncT             ,
    noFontGetGlyphAdvancesFuncT_WithClosures,
    wrap_FontGetGlyphAdvancesFuncT          ,


-- ** FontGetGlyphContourPointFuncT #signal:FontGetGlyphContourPointFuncT#

    C_FontGetGlyphContourPointFuncT         ,
    FontGetGlyphContourPointFuncT           ,
    FontGetGlyphContourPointFuncT_WithClosures,
    drop_closures_FontGetGlyphContourPointFuncT,
    dynamic_FontGetGlyphContourPointFuncT   ,
    genClosure_FontGetGlyphContourPointFuncT,
    mk_FontGetGlyphContourPointFuncT        ,
    noFontGetGlyphContourPointFuncT         ,
    noFontGetGlyphContourPointFuncT_WithClosures,
    wrap_FontGetGlyphContourPointFuncT      ,


-- ** FontGetGlyphExtentsFuncT #signal:FontGetGlyphExtentsFuncT#

    C_FontGetGlyphExtentsFuncT              ,
    FontGetGlyphExtentsFuncT                ,
    FontGetGlyphExtentsFuncT_WithClosures   ,
    drop_closures_FontGetGlyphExtentsFuncT  ,
    dynamic_FontGetGlyphExtentsFuncT        ,
    genClosure_FontGetGlyphExtentsFuncT     ,
    mk_FontGetGlyphExtentsFuncT             ,
    noFontGetGlyphExtentsFuncT              ,
    noFontGetGlyphExtentsFuncT_WithClosures ,
    wrap_FontGetGlyphExtentsFuncT           ,


-- ** FontGetGlyphFromNameFuncT #signal:FontGetGlyphFromNameFuncT#

    C_FontGetGlyphFromNameFuncT             ,
    FontGetGlyphFromNameFuncT               ,
    FontGetGlyphFromNameFuncT_WithClosures  ,
    drop_closures_FontGetGlyphFromNameFuncT ,
    dynamic_FontGetGlyphFromNameFuncT       ,
    genClosure_FontGetGlyphFromNameFuncT    ,
    mk_FontGetGlyphFromNameFuncT            ,
    noFontGetGlyphFromNameFuncT             ,
    noFontGetGlyphFromNameFuncT_WithClosures,
    wrap_FontGetGlyphFromNameFuncT          ,


-- ** FontGetGlyphFuncT #signal:FontGetGlyphFuncT#

    C_FontGetGlyphFuncT                     ,
    FontGetGlyphFuncT                       ,
    FontGetGlyphFuncT_WithClosures          ,
    drop_closures_FontGetGlyphFuncT         ,
    dynamic_FontGetGlyphFuncT               ,
    genClosure_FontGetGlyphFuncT            ,
    mk_FontGetGlyphFuncT                    ,
    noFontGetGlyphFuncT                     ,
    noFontGetGlyphFuncT_WithClosures        ,
    wrap_FontGetGlyphFuncT                  ,


-- ** FontGetGlyphKerningFuncT #signal:FontGetGlyphKerningFuncT#

    C_FontGetGlyphKerningFuncT              ,
    FontGetGlyphKerningFuncT                ,
    FontGetGlyphKerningFuncT_WithClosures   ,
    drop_closures_FontGetGlyphKerningFuncT  ,
    dynamic_FontGetGlyphKerningFuncT        ,
    genClosure_FontGetGlyphKerningFuncT     ,
    mk_FontGetGlyphKerningFuncT             ,
    noFontGetGlyphKerningFuncT              ,
    noFontGetGlyphKerningFuncT_WithClosures ,
    wrap_FontGetGlyphKerningFuncT           ,


-- ** FontGetGlyphNameFuncT #signal:FontGetGlyphNameFuncT#

    C_FontGetGlyphNameFuncT                 ,
    FontGetGlyphNameFuncT                   ,
    FontGetGlyphNameFuncT_WithClosures      ,
    drop_closures_FontGetGlyphNameFuncT     ,
    dynamic_FontGetGlyphNameFuncT           ,
    genClosure_FontGetGlyphNameFuncT        ,
    mk_FontGetGlyphNameFuncT                ,
    noFontGetGlyphNameFuncT                 ,
    noFontGetGlyphNameFuncT_WithClosures    ,
    wrap_FontGetGlyphNameFuncT              ,


-- ** FontGetGlyphOriginFuncT #signal:FontGetGlyphOriginFuncT#

    C_FontGetGlyphOriginFuncT               ,
    FontGetGlyphOriginFuncT                 ,
    FontGetGlyphOriginFuncT_WithClosures    ,
    drop_closures_FontGetGlyphOriginFuncT   ,
    dynamic_FontGetGlyphOriginFuncT         ,
    genClosure_FontGetGlyphOriginFuncT      ,
    mk_FontGetGlyphOriginFuncT              ,
    noFontGetGlyphOriginFuncT               ,
    noFontGetGlyphOriginFuncT_WithClosures  ,
    wrap_FontGetGlyphOriginFuncT            ,


-- ** FontGetGlyphOriginsFuncT #signal:FontGetGlyphOriginsFuncT#

    C_FontGetGlyphOriginsFuncT              ,
    FontGetGlyphOriginsFuncT                ,
    FontGetGlyphOriginsFuncT_WithClosures   ,
    drop_closures_FontGetGlyphOriginsFuncT  ,
    dynamic_FontGetGlyphOriginsFuncT        ,
    genClosure_FontGetGlyphOriginsFuncT     ,
    mk_FontGetGlyphOriginsFuncT             ,
    noFontGetGlyphOriginsFuncT              ,
    noFontGetGlyphOriginsFuncT_WithClosures ,
    wrap_FontGetGlyphOriginsFuncT           ,


-- ** FontGetGlyphShapeFuncT #signal:FontGetGlyphShapeFuncT#

    C_FontGetGlyphShapeFuncT                ,
    FontGetGlyphShapeFuncT                  ,
    FontGetGlyphShapeFuncT_WithClosures     ,
    drop_closures_FontGetGlyphShapeFuncT    ,
    dynamic_FontGetGlyphShapeFuncT          ,
    genClosure_FontGetGlyphShapeFuncT       ,
    mk_FontGetGlyphShapeFuncT               ,
    noFontGetGlyphShapeFuncT                ,
    noFontGetGlyphShapeFuncT_WithClosures   ,
    wrap_FontGetGlyphShapeFuncT             ,


-- ** FontGetNominalGlyphFuncT #signal:FontGetNominalGlyphFuncT#

    C_FontGetNominalGlyphFuncT              ,
    FontGetNominalGlyphFuncT                ,
    FontGetNominalGlyphFuncT_WithClosures   ,
    drop_closures_FontGetNominalGlyphFuncT  ,
    dynamic_FontGetNominalGlyphFuncT        ,
    genClosure_FontGetNominalGlyphFuncT     ,
    mk_FontGetNominalGlyphFuncT             ,
    noFontGetNominalGlyphFuncT              ,
    noFontGetNominalGlyphFuncT_WithClosures ,
    wrap_FontGetNominalGlyphFuncT           ,


-- ** FontGetNominalGlyphsFuncT #signal:FontGetNominalGlyphsFuncT#

    C_FontGetNominalGlyphsFuncT             ,
    FontGetNominalGlyphsFuncT               ,
    FontGetNominalGlyphsFuncT_WithClosures  ,
    drop_closures_FontGetNominalGlyphsFuncT ,
    dynamic_FontGetNominalGlyphsFuncT       ,
    genClosure_FontGetNominalGlyphsFuncT    ,
    mk_FontGetNominalGlyphsFuncT            ,
    noFontGetNominalGlyphsFuncT             ,
    noFontGetNominalGlyphsFuncT_WithClosures,
    wrap_FontGetNominalGlyphsFuncT          ,


-- ** FontGetVariationGlyphFuncT #signal:FontGetVariationGlyphFuncT#

    C_FontGetVariationGlyphFuncT            ,
    FontGetVariationGlyphFuncT              ,
    FontGetVariationGlyphFuncT_WithClosures ,
    drop_closures_FontGetVariationGlyphFuncT,
    dynamic_FontGetVariationGlyphFuncT      ,
    genClosure_FontGetVariationGlyphFuncT   ,
    mk_FontGetVariationGlyphFuncT           ,
    noFontGetVariationGlyphFuncT            ,
    noFontGetVariationGlyphFuncT_WithClosures,
    wrap_FontGetVariationGlyphFuncT         ,


-- ** FontPaintGlyphFuncT #signal:FontPaintGlyphFuncT#

    C_FontPaintGlyphFuncT                   ,
    FontPaintGlyphFuncT                     ,
    FontPaintGlyphFuncT_WithClosures        ,
    drop_closures_FontPaintGlyphFuncT       ,
    dynamic_FontPaintGlyphFuncT             ,
    genClosure_FontPaintGlyphFuncT          ,
    mk_FontPaintGlyphFuncT                  ,
    noFontPaintGlyphFuncT                   ,
    noFontPaintGlyphFuncT_WithClosures      ,
    wrap_FontPaintGlyphFuncT                ,


-- ** FontPaintGlyphOrFailFuncT #signal:FontPaintGlyphOrFailFuncT#

    C_FontPaintGlyphOrFailFuncT             ,
    FontPaintGlyphOrFailFuncT               ,
    FontPaintGlyphOrFailFuncT_WithClosures  ,
    drop_closures_FontPaintGlyphOrFailFuncT ,
    dynamic_FontPaintGlyphOrFailFuncT       ,
    genClosure_FontPaintGlyphOrFailFuncT    ,
    mk_FontPaintGlyphOrFailFuncT            ,
    noFontPaintGlyphOrFailFuncT             ,
    noFontPaintGlyphOrFailFuncT_WithClosures,
    wrap_FontPaintGlyphOrFailFuncT          ,


-- ** GetTableTagsFuncT #signal:GetTableTagsFuncT#

    C_GetTableTagsFuncT                     ,
    GetTableTagsFuncT                       ,
    GetTableTagsFuncT_WithClosures          ,
    drop_closures_GetTableTagsFuncT         ,
    dynamic_GetTableTagsFuncT               ,
    genClosure_GetTableTagsFuncT            ,
    mk_GetTableTagsFuncT                    ,
    noGetTableTagsFuncT                     ,
    noGetTableTagsFuncT_WithClosures        ,
    wrap_GetTableTagsFuncT                  ,


-- ** PaintColorFuncT #signal:PaintColorFuncT#

    C_PaintColorFuncT                       ,
    PaintColorFuncT                         ,
    PaintColorFuncT_WithClosures            ,
    drop_closures_PaintColorFuncT           ,
    dynamic_PaintColorFuncT                 ,
    genClosure_PaintColorFuncT              ,
    mk_PaintColorFuncT                      ,
    noPaintColorFuncT                       ,
    noPaintColorFuncT_WithClosures          ,
    wrap_PaintColorFuncT                    ,


-- ** PaintColorGlyphFuncT #signal:PaintColorGlyphFuncT#

    C_PaintColorGlyphFuncT                  ,
    PaintColorGlyphFuncT                    ,
    PaintColorGlyphFuncT_WithClosures       ,
    drop_closures_PaintColorGlyphFuncT      ,
    dynamic_PaintColorGlyphFuncT            ,
    genClosure_PaintColorGlyphFuncT         ,
    mk_PaintColorGlyphFuncT                 ,
    noPaintColorGlyphFuncT                  ,
    noPaintColorGlyphFuncT_WithClosures     ,
    wrap_PaintColorGlyphFuncT               ,


-- ** PaintCustomPaletteColorFuncT #signal:PaintCustomPaletteColorFuncT#

    C_PaintCustomPaletteColorFuncT          ,
    PaintCustomPaletteColorFuncT            ,
    PaintCustomPaletteColorFuncT_WithClosures,
    drop_closures_PaintCustomPaletteColorFuncT,
    dynamic_PaintCustomPaletteColorFuncT    ,
    genClosure_PaintCustomPaletteColorFuncT ,
    mk_PaintCustomPaletteColorFuncT         ,
    noPaintCustomPaletteColorFuncT          ,
    noPaintCustomPaletteColorFuncT_WithClosures,
    wrap_PaintCustomPaletteColorFuncT       ,


-- ** PaintImageFuncT #signal:PaintImageFuncT#

    C_PaintImageFuncT                       ,
    PaintImageFuncT                         ,
    PaintImageFuncT_WithClosures            ,
    drop_closures_PaintImageFuncT           ,
    dynamic_PaintImageFuncT                 ,
    genClosure_PaintImageFuncT              ,
    mk_PaintImageFuncT                      ,
    noPaintImageFuncT                       ,
    noPaintImageFuncT_WithClosures          ,
    wrap_PaintImageFuncT                    ,


-- ** PaintLinearGradientFuncT #signal:PaintLinearGradientFuncT#

    C_PaintLinearGradientFuncT              ,
    PaintLinearGradientFuncT                ,
    PaintLinearGradientFuncT_WithClosures   ,
    drop_closures_PaintLinearGradientFuncT  ,
    dynamic_PaintLinearGradientFuncT        ,
    genClosure_PaintLinearGradientFuncT     ,
    mk_PaintLinearGradientFuncT             ,
    noPaintLinearGradientFuncT              ,
    noPaintLinearGradientFuncT_WithClosures ,
    wrap_PaintLinearGradientFuncT           ,


-- ** PaintPopClipFuncT #signal:PaintPopClipFuncT#

    C_PaintPopClipFuncT                     ,
    PaintPopClipFuncT                       ,
    PaintPopClipFuncT_WithClosures          ,
    drop_closures_PaintPopClipFuncT         ,
    dynamic_PaintPopClipFuncT               ,
    genClosure_PaintPopClipFuncT            ,
    mk_PaintPopClipFuncT                    ,
    noPaintPopClipFuncT                     ,
    noPaintPopClipFuncT_WithClosures        ,
    wrap_PaintPopClipFuncT                  ,


-- ** PaintPopGroupFuncT #signal:PaintPopGroupFuncT#

    C_PaintPopGroupFuncT                    ,
    PaintPopGroupFuncT                      ,
    PaintPopGroupFuncT_WithClosures         ,
    drop_closures_PaintPopGroupFuncT        ,
    dynamic_PaintPopGroupFuncT              ,
    genClosure_PaintPopGroupFuncT           ,
    mk_PaintPopGroupFuncT                   ,
    noPaintPopGroupFuncT                    ,
    noPaintPopGroupFuncT_WithClosures       ,
    wrap_PaintPopGroupFuncT                 ,


-- ** PaintPopTransformFuncT #signal:PaintPopTransformFuncT#

    C_PaintPopTransformFuncT                ,
    PaintPopTransformFuncT                  ,
    PaintPopTransformFuncT_WithClosures     ,
    drop_closures_PaintPopTransformFuncT    ,
    dynamic_PaintPopTransformFuncT          ,
    genClosure_PaintPopTransformFuncT       ,
    mk_PaintPopTransformFuncT               ,
    noPaintPopTransformFuncT                ,
    noPaintPopTransformFuncT_WithClosures   ,
    wrap_PaintPopTransformFuncT             ,


-- ** PaintPushClipGlyphFuncT #signal:PaintPushClipGlyphFuncT#

    C_PaintPushClipGlyphFuncT               ,
    PaintPushClipGlyphFuncT                 ,
    PaintPushClipGlyphFuncT_WithClosures    ,
    drop_closures_PaintPushClipGlyphFuncT   ,
    dynamic_PaintPushClipGlyphFuncT         ,
    genClosure_PaintPushClipGlyphFuncT      ,
    mk_PaintPushClipGlyphFuncT              ,
    noPaintPushClipGlyphFuncT               ,
    noPaintPushClipGlyphFuncT_WithClosures  ,
    wrap_PaintPushClipGlyphFuncT            ,


-- ** PaintPushClipRectangleFuncT #signal:PaintPushClipRectangleFuncT#

    C_PaintPushClipRectangleFuncT           ,
    PaintPushClipRectangleFuncT             ,
    PaintPushClipRectangleFuncT_WithClosures,
    drop_closures_PaintPushClipRectangleFuncT,
    dynamic_PaintPushClipRectangleFuncT     ,
    genClosure_PaintPushClipRectangleFuncT  ,
    mk_PaintPushClipRectangleFuncT          ,
    noPaintPushClipRectangleFuncT           ,
    noPaintPushClipRectangleFuncT_WithClosures,
    wrap_PaintPushClipRectangleFuncT        ,


-- ** PaintPushGroupFuncT #signal:PaintPushGroupFuncT#

    C_PaintPushGroupFuncT                   ,
    PaintPushGroupFuncT                     ,
    PaintPushGroupFuncT_WithClosures        ,
    drop_closures_PaintPushGroupFuncT       ,
    dynamic_PaintPushGroupFuncT             ,
    genClosure_PaintPushGroupFuncT          ,
    mk_PaintPushGroupFuncT                  ,
    noPaintPushGroupFuncT                   ,
    noPaintPushGroupFuncT_WithClosures      ,
    wrap_PaintPushGroupFuncT                ,


-- ** PaintPushTransformFuncT #signal:PaintPushTransformFuncT#

    C_PaintPushTransformFuncT               ,
    PaintPushTransformFuncT                 ,
    PaintPushTransformFuncT_WithClosures    ,
    drop_closures_PaintPushTransformFuncT   ,
    dynamic_PaintPushTransformFuncT         ,
    genClosure_PaintPushTransformFuncT      ,
    mk_PaintPushTransformFuncT              ,
    noPaintPushTransformFuncT               ,
    noPaintPushTransformFuncT_WithClosures  ,
    wrap_PaintPushTransformFuncT            ,


-- ** PaintRadialGradientFuncT #signal:PaintRadialGradientFuncT#

    C_PaintRadialGradientFuncT              ,
    PaintRadialGradientFuncT                ,
    PaintRadialGradientFuncT_WithClosures   ,
    drop_closures_PaintRadialGradientFuncT  ,
    dynamic_PaintRadialGradientFuncT        ,
    genClosure_PaintRadialGradientFuncT     ,
    mk_PaintRadialGradientFuncT             ,
    noPaintRadialGradientFuncT              ,
    noPaintRadialGradientFuncT_WithClosures ,
    wrap_PaintRadialGradientFuncT           ,


-- ** PaintSweepGradientFuncT #signal:PaintSweepGradientFuncT#

    C_PaintSweepGradientFuncT               ,
    PaintSweepGradientFuncT                 ,
    PaintSweepGradientFuncT_WithClosures    ,
    drop_closures_PaintSweepGradientFuncT   ,
    dynamic_PaintSweepGradientFuncT         ,
    genClosure_PaintSweepGradientFuncT      ,
    mk_PaintSweepGradientFuncT              ,
    noPaintSweepGradientFuncT               ,
    noPaintSweepGradientFuncT_WithClosures  ,
    wrap_PaintSweepGradientFuncT            ,


-- ** ReferenceTableFuncT #signal:ReferenceTableFuncT#

    C_ReferenceTableFuncT                   ,
    ReferenceTableFuncT                     ,
    ReferenceTableFuncT_WithClosures        ,
    drop_closures_ReferenceTableFuncT       ,
    dynamic_ReferenceTableFuncT             ,
    genClosure_ReferenceTableFuncT          ,
    mk_ReferenceTableFuncT                  ,
    noReferenceTableFuncT                   ,
    noReferenceTableFuncT_WithClosures      ,
    wrap_ReferenceTableFuncT                ,


-- ** UnicodeCombiningClassFuncT #signal:UnicodeCombiningClassFuncT#

    C_UnicodeCombiningClassFuncT            ,
    UnicodeCombiningClassFuncT              ,
    UnicodeCombiningClassFuncT_WithClosures ,
    drop_closures_UnicodeCombiningClassFuncT,
    dynamic_UnicodeCombiningClassFuncT      ,
    genClosure_UnicodeCombiningClassFuncT   ,
    mk_UnicodeCombiningClassFuncT           ,
    noUnicodeCombiningClassFuncT            ,
    noUnicodeCombiningClassFuncT_WithClosures,
    wrap_UnicodeCombiningClassFuncT         ,


-- ** UnicodeComposeFuncT #signal:UnicodeComposeFuncT#

    C_UnicodeComposeFuncT                   ,
    UnicodeComposeFuncT                     ,
    UnicodeComposeFuncT_WithClosures        ,
    drop_closures_UnicodeComposeFuncT       ,
    dynamic_UnicodeComposeFuncT             ,
    genClosure_UnicodeComposeFuncT          ,
    mk_UnicodeComposeFuncT                  ,
    noUnicodeComposeFuncT                   ,
    noUnicodeComposeFuncT_WithClosures      ,
    wrap_UnicodeComposeFuncT                ,


-- ** UnicodeDecomposeCompatibilityFuncT #signal:UnicodeDecomposeCompatibilityFuncT#

    C_UnicodeDecomposeCompatibilityFuncT    ,
    UnicodeDecomposeCompatibilityFuncT      ,
    UnicodeDecomposeCompatibilityFuncT_WithClosures,
    drop_closures_UnicodeDecomposeCompatibilityFuncT,
    dynamic_UnicodeDecomposeCompatibilityFuncT,
    genClosure_UnicodeDecomposeCompatibilityFuncT,
    mk_UnicodeDecomposeCompatibilityFuncT   ,
    noUnicodeDecomposeCompatibilityFuncT    ,
    noUnicodeDecomposeCompatibilityFuncT_WithClosures,
    wrap_UnicodeDecomposeCompatibilityFuncT ,


-- ** UnicodeDecomposeFuncT #signal:UnicodeDecomposeFuncT#

    C_UnicodeDecomposeFuncT                 ,
    UnicodeDecomposeFuncT                   ,
    UnicodeDecomposeFuncT_WithClosures      ,
    drop_closures_UnicodeDecomposeFuncT     ,
    dynamic_UnicodeDecomposeFuncT           ,
    genClosure_UnicodeDecomposeFuncT        ,
    mk_UnicodeDecomposeFuncT                ,
    noUnicodeDecomposeFuncT                 ,
    noUnicodeDecomposeFuncT_WithClosures    ,
    wrap_UnicodeDecomposeFuncT              ,


-- ** UnicodeEastasianWidthFuncT #signal:UnicodeEastasianWidthFuncT#

    C_UnicodeEastasianWidthFuncT            ,
    UnicodeEastasianWidthFuncT              ,
    UnicodeEastasianWidthFuncT_WithClosures ,
    drop_closures_UnicodeEastasianWidthFuncT,
    dynamic_UnicodeEastasianWidthFuncT      ,
    genClosure_UnicodeEastasianWidthFuncT   ,
    mk_UnicodeEastasianWidthFuncT           ,
    noUnicodeEastasianWidthFuncT            ,
    noUnicodeEastasianWidthFuncT_WithClosures,
    wrap_UnicodeEastasianWidthFuncT         ,


-- ** UnicodeGeneralCategoryFuncT #signal:UnicodeGeneralCategoryFuncT#

    C_UnicodeGeneralCategoryFuncT           ,
    UnicodeGeneralCategoryFuncT             ,
    UnicodeGeneralCategoryFuncT_WithClosures,
    drop_closures_UnicodeGeneralCategoryFuncT,
    dynamic_UnicodeGeneralCategoryFuncT     ,
    genClosure_UnicodeGeneralCategoryFuncT  ,
    mk_UnicodeGeneralCategoryFuncT          ,
    noUnicodeGeneralCategoryFuncT           ,
    noUnicodeGeneralCategoryFuncT_WithClosures,
    wrap_UnicodeGeneralCategoryFuncT        ,


-- ** UnicodeMirroringFuncT #signal:UnicodeMirroringFuncT#

    C_UnicodeMirroringFuncT                 ,
    UnicodeMirroringFuncT                   ,
    UnicodeMirroringFuncT_WithClosures      ,
    drop_closures_UnicodeMirroringFuncT     ,
    dynamic_UnicodeMirroringFuncT           ,
    genClosure_UnicodeMirroringFuncT        ,
    mk_UnicodeMirroringFuncT                ,
    noUnicodeMirroringFuncT                 ,
    noUnicodeMirroringFuncT_WithClosures    ,
    wrap_UnicodeMirroringFuncT              ,


-- ** UnicodeScriptFuncT #signal:UnicodeScriptFuncT#

    C_UnicodeScriptFuncT                    ,
    UnicodeScriptFuncT                      ,
    UnicodeScriptFuncT_WithClosures         ,
    drop_closures_UnicodeScriptFuncT        ,
    dynamic_UnicodeScriptFuncT              ,
    genClosure_UnicodeScriptFuncT           ,
    mk_UnicodeScriptFuncT                   ,
    noUnicodeScriptFuncT                    ,
    noUnicodeScriptFuncT_WithClosures       ,
    wrap_UnicodeScriptFuncT                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.HarfBuzz.Enums as HarfBuzz.Enums
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.BlobT as HarfBuzz.BlobT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.BufferT as HarfBuzz.BufferT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.ColorLineT as HarfBuzz.ColorLineT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.ColorStopT as HarfBuzz.ColorStopT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.DrawFuncsT as HarfBuzz.DrawFuncsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.DrawStateT as HarfBuzz.DrawStateT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FaceT as HarfBuzz.FaceT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FontExtentsT as HarfBuzz.FontExtentsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FontT as HarfBuzz.FontT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.GlyphExtentsT as HarfBuzz.GlyphExtentsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.PaintFuncsT as HarfBuzz.PaintFuncsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.UnicodeFuncsT as HarfBuzz.UnicodeFuncsT

#else
import {-# SOURCE #-} qualified GI.HarfBuzz.Enums as HarfBuzz.Enums
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.BlobT as HarfBuzz.BlobT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.BufferT as HarfBuzz.BufferT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.ColorLineT as HarfBuzz.ColorLineT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.ColorStopT as HarfBuzz.ColorStopT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.DrawFuncsT as HarfBuzz.DrawFuncsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.DrawStateT as HarfBuzz.DrawStateT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FaceT as HarfBuzz.FaceT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FontExtentsT as HarfBuzz.FontExtentsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.FontT as HarfBuzz.FontT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.GlyphExtentsT as HarfBuzz.GlyphExtentsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.PaintFuncsT as HarfBuzz.PaintFuncsT
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.UnicodeFuncsT as HarfBuzz.UnicodeFuncsT

#endif

-- callback UnicodeScriptFuncT
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "HarfBuzz" , name = "script_t" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "The #hb_script_t of @unicode"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should retrieve the Script property for a\nspecified Unicode code point."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeScriptFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "HarfBuzz" , name = "script_t" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeScriptFuncT :: FunPtr C_UnicodeScriptFuncT -> C_UnicodeScriptFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeScriptFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeScriptFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m HarfBuzz.Enums.ScriptT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.ScriptT' of /@unicode@/
dynamic_UnicodeScriptFuncT __funPtr ufuncs unicode userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeScriptFuncT __funPtr) ufuncs' unicode userData
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr ufuncs
    return result'

-- | Generate a function pointer callable from C code, from a `C_UnicodeScriptFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeScriptFuncT :: C_UnicodeScriptFuncT -> IO (FunPtr C_UnicodeScriptFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Script property for a
-- specified Unicode code point.
type UnicodeScriptFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> IO HarfBuzz.Enums.ScriptT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.ScriptT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeScriptFuncT`@.
noUnicodeScriptFuncT :: Maybe UnicodeScriptFuncT
noUnicodeScriptFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Script property for a
-- specified Unicode code point.
type UnicodeScriptFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO HarfBuzz.Enums.ScriptT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.ScriptT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeScriptFuncT_WithClosures`@.
noUnicodeScriptFuncT_WithClosures :: Maybe UnicodeScriptFuncT_WithClosures
noUnicodeScriptFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeScriptFuncT :: UnicodeScriptFuncT -> UnicodeScriptFuncT_WithClosures
drop_closures_UnicodeScriptFuncT _f ufuncs unicode _ = _f ufuncs unicode

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeScriptFuncT :: MonadIO m => UnicodeScriptFuncT -> m (GClosure C_UnicodeScriptFuncT)
genClosure_UnicodeScriptFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeScriptFuncT cb
    let cb'' = wrap_UnicodeScriptFuncT Nothing cb'
    mk_UnicodeScriptFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeScriptFuncT` into a `C_UnicodeScriptFuncT`.
wrap_UnicodeScriptFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeScriptFuncT)) ->
    UnicodeScriptFuncT_WithClosures ->
    C_UnicodeScriptFuncT
wrap_UnicodeScriptFuncT gi'funptrptr gi'cb ufuncs unicode userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' unicode userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (fromIntegral . fromEnum) result
        return result'


-- callback UnicodeMirroringFuncT
{- Callable
  { returnType = Just (TBasicType TUInt32)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "The #hb_codepoint_t of the Mirroring Glyph for @unicode"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should retrieve the Bi-Directional Mirroring Glyph\ncode point for a specified Unicode code point.\n\n<note>Note: If a code point does not have a specified\nBi-Directional Mirroring Glyph defined, the method should\nreturn the original code point.</note>"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeMirroringFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeMirroringFuncT :: FunPtr C_UnicodeMirroringFuncT -> C_UnicodeMirroringFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeMirroringFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeMirroringFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Word32
    -- ^ __Returns:__ The @/hb_codepoint_t/@ of the Mirroring Glyph for /@unicode@/
dynamic_UnicodeMirroringFuncT __funPtr ufuncs unicode userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeMirroringFuncT __funPtr) ufuncs' unicode userData
    touchManagedPtr ufuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_UnicodeMirroringFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeMirroringFuncT :: C_UnicodeMirroringFuncT -> IO (FunPtr C_UnicodeMirroringFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Bi-Directional Mirroring Glyph
-- code point for a specified Unicode code point.
-- 
-- \<note>Note: If a code point does not have a specified
-- Bi-Directional Mirroring Glyph defined, the method should
-- return the original code point.\<\/note>
type UnicodeMirroringFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> IO Word32
    -- ^ __Returns:__ The @/hb_codepoint_t/@ of the Mirroring Glyph for /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeMirroringFuncT`@.
noUnicodeMirroringFuncT :: Maybe UnicodeMirroringFuncT
noUnicodeMirroringFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Bi-Directional Mirroring Glyph
-- code point for a specified Unicode code point.
-- 
-- \<note>Note: If a code point does not have a specified
-- Bi-Directional Mirroring Glyph defined, the method should
-- return the original code point.\<\/note>
type UnicodeMirroringFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Word32
    -- ^ __Returns:__ The @/hb_codepoint_t/@ of the Mirroring Glyph for /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeMirroringFuncT_WithClosures`@.
noUnicodeMirroringFuncT_WithClosures :: Maybe UnicodeMirroringFuncT_WithClosures
noUnicodeMirroringFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeMirroringFuncT :: UnicodeMirroringFuncT -> UnicodeMirroringFuncT_WithClosures
drop_closures_UnicodeMirroringFuncT _f ufuncs unicode _ = _f ufuncs unicode

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeMirroringFuncT :: MonadIO m => UnicodeMirroringFuncT -> m (GClosure C_UnicodeMirroringFuncT)
genClosure_UnicodeMirroringFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeMirroringFuncT cb
    let cb'' = wrap_UnicodeMirroringFuncT Nothing cb'
    mk_UnicodeMirroringFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeMirroringFuncT` into a `C_UnicodeMirroringFuncT`.
wrap_UnicodeMirroringFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeMirroringFuncT)) ->
    UnicodeMirroringFuncT_WithClosures ->
    C_UnicodeMirroringFuncT
wrap_UnicodeMirroringFuncT gi'funptrptr gi'cb ufuncs unicode userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' unicode userData
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback UnicodeGeneralCategoryFuncT
{- Callable
  { returnType =
      Just
        (TInterface
           Name
             { namespace = "HarfBuzz" , name = "unicode_general_category_t" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "The #hb_unicode_general_category_t of @unicode"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should retrieve the General Category property for\na specified Unicode code point."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeGeneralCategoryFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name
--                    { namespace = "HarfBuzz" , name = "unicode_general_category_t" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeGeneralCategoryFuncT :: FunPtr C_UnicodeGeneralCategoryFuncT -> C_UnicodeGeneralCategoryFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeGeneralCategoryFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeGeneralCategoryFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m HarfBuzz.Enums.UnicodeGeneralCategoryT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeGeneralCategoryT' of /@unicode@/
dynamic_UnicodeGeneralCategoryFuncT __funPtr ufuncs unicode userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeGeneralCategoryFuncT __funPtr) ufuncs' unicode userData
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr ufuncs
    return result'

-- | Generate a function pointer callable from C code, from a `C_UnicodeGeneralCategoryFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeGeneralCategoryFuncT :: C_UnicodeGeneralCategoryFuncT -> IO (FunPtr C_UnicodeGeneralCategoryFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the General Category property for
-- a specified Unicode code point.
type UnicodeGeneralCategoryFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> IO HarfBuzz.Enums.UnicodeGeneralCategoryT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeGeneralCategoryT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeGeneralCategoryFuncT`@.
noUnicodeGeneralCategoryFuncT :: Maybe UnicodeGeneralCategoryFuncT
noUnicodeGeneralCategoryFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the General Category property for
-- a specified Unicode code point.
type UnicodeGeneralCategoryFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO HarfBuzz.Enums.UnicodeGeneralCategoryT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeGeneralCategoryT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeGeneralCategoryFuncT_WithClosures`@.
noUnicodeGeneralCategoryFuncT_WithClosures :: Maybe UnicodeGeneralCategoryFuncT_WithClosures
noUnicodeGeneralCategoryFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeGeneralCategoryFuncT :: UnicodeGeneralCategoryFuncT -> UnicodeGeneralCategoryFuncT_WithClosures
drop_closures_UnicodeGeneralCategoryFuncT _f ufuncs unicode _ = _f ufuncs unicode

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeGeneralCategoryFuncT :: MonadIO m => UnicodeGeneralCategoryFuncT -> m (GClosure C_UnicodeGeneralCategoryFuncT)
genClosure_UnicodeGeneralCategoryFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeGeneralCategoryFuncT cb
    let cb'' = wrap_UnicodeGeneralCategoryFuncT Nothing cb'
    mk_UnicodeGeneralCategoryFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeGeneralCategoryFuncT` into a `C_UnicodeGeneralCategoryFuncT`.
wrap_UnicodeGeneralCategoryFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeGeneralCategoryFuncT)) ->
    UnicodeGeneralCategoryFuncT_WithClosures ->
    C_UnicodeGeneralCategoryFuncT
wrap_UnicodeGeneralCategoryFuncT gi'funptrptr gi'cb ufuncs unicode userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' unicode userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (fromIntegral . fromEnum) result
        return result'


-- callback UnicodeEastasianWidthFuncT
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.0.0"
          , deprecationMessage = Nothing
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "A virtual method for the #hb_unicode_funcs_t structure."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeEastasianWidthFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeEastasianWidthFuncT :: FunPtr C_UnicodeEastasianWidthFuncT -> C_UnicodeEastasianWidthFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeEastasianWidthFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeEastasianWidthFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Word32
dynamic_UnicodeEastasianWidthFuncT __funPtr ufuncs unicode userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeEastasianWidthFuncT __funPtr) ufuncs' unicode userData
    touchManagedPtr ufuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_UnicodeEastasianWidthFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeEastasianWidthFuncT :: C_UnicodeEastasianWidthFuncT -> IO (FunPtr C_UnicodeEastasianWidthFuncT)

{-# DEPRECATED UnicodeEastasianWidthFuncT ["(Since version 2.0.0)"] #-}
-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
type UnicodeEastasianWidthFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> IO Word32

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeEastasianWidthFuncT`@.
noUnicodeEastasianWidthFuncT :: Maybe UnicodeEastasianWidthFuncT
noUnicodeEastasianWidthFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
type UnicodeEastasianWidthFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Word32

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeEastasianWidthFuncT_WithClosures`@.
noUnicodeEastasianWidthFuncT_WithClosures :: Maybe UnicodeEastasianWidthFuncT_WithClosures
noUnicodeEastasianWidthFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeEastasianWidthFuncT :: UnicodeEastasianWidthFuncT -> UnicodeEastasianWidthFuncT_WithClosures
drop_closures_UnicodeEastasianWidthFuncT _f ufuncs unicode _ = _f ufuncs unicode

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeEastasianWidthFuncT :: MonadIO m => UnicodeEastasianWidthFuncT -> m (GClosure C_UnicodeEastasianWidthFuncT)
genClosure_UnicodeEastasianWidthFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeEastasianWidthFuncT cb
    let cb'' = wrap_UnicodeEastasianWidthFuncT Nothing cb'
    mk_UnicodeEastasianWidthFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeEastasianWidthFuncT` into a `C_UnicodeEastasianWidthFuncT`.
wrap_UnicodeEastasianWidthFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeEastasianWidthFuncT)) ->
    UnicodeEastasianWidthFuncT_WithClosures ->
    C_UnicodeEastasianWidthFuncT
wrap_UnicodeEastasianWidthFuncT gi'funptrptr gi'cb ufuncs unicode userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' unicode userData
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback UnicodeDecomposeFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if @ab decomposed, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "ab"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to decompose"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "a"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first decomposed code point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The second decomposed code point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should decompose an input Unicode code point,\nreturning the two decomposed code points in #hb_codepoint_t\noutput parameters (if successful). The method must return an\n#hb_bool_t indicating the success of the composition."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeDecomposeFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ab"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to decompose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first decomposed code point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The second decomposed code point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeDecomposeFuncT :: FunPtr C_UnicodeDecomposeFuncT -> C_UnicodeDecomposeFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeDecomposeFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeDecomposeFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@ab@/: The code point to decompose
    -> Ptr ()
    -- ^ /@userData@/: user data pointer passed by the caller
    -> m ((Int32, Word32, Word32))
    -- ^ __Returns:__ @true@ if /@ab@/ decomposed, @false@ otherwise
dynamic_UnicodeDecomposeFuncT __funPtr ufuncs ab userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    a <- allocMem :: IO (Ptr Word32)
    b <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_UnicodeDecomposeFuncT __funPtr) ufuncs' ab a b userData
    a' <- peek a
    b' <- peek b
    touchManagedPtr ufuncs
    freeMem a
    freeMem b
    return (result, a', b')

-- | Generate a function pointer callable from C code, from a `C_UnicodeDecomposeFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeDecomposeFuncT :: C_UnicodeDecomposeFuncT -> IO (FunPtr C_UnicodeDecomposeFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should decompose an input Unicode code point,
-- returning the two decomposed code points in @/hb_codepoint_t/@
-- output parameters (if successful). The method must return an
-- @/hb_bool_t/@ indicating the success of the composition.
type UnicodeDecomposeFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@ab@/: The code point to decompose
    -> IO ((Int32, Word32, Word32))
    -- ^ __Returns:__ @true@ if /@ab@/ decomposed, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeDecomposeFuncT`@.
noUnicodeDecomposeFuncT :: Maybe UnicodeDecomposeFuncT
noUnicodeDecomposeFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should decompose an input Unicode code point,
-- returning the two decomposed code points in @/hb_codepoint_t/@
-- output parameters (if successful). The method must return an
-- @/hb_bool_t/@ indicating the success of the composition.
type UnicodeDecomposeFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@ab@/: The code point to decompose
    -> Ptr ()
    -- ^ /@userData@/: user data pointer passed by the caller
    -> IO ((Int32, Word32, Word32))
    -- ^ __Returns:__ @true@ if /@ab@/ decomposed, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeDecomposeFuncT_WithClosures`@.
noUnicodeDecomposeFuncT_WithClosures :: Maybe UnicodeDecomposeFuncT_WithClosures
noUnicodeDecomposeFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeDecomposeFuncT :: UnicodeDecomposeFuncT -> UnicodeDecomposeFuncT_WithClosures
drop_closures_UnicodeDecomposeFuncT _f ufuncs ab _ = _f ufuncs ab

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeDecomposeFuncT :: MonadIO m => UnicodeDecomposeFuncT -> m (GClosure C_UnicodeDecomposeFuncT)
genClosure_UnicodeDecomposeFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeDecomposeFuncT cb
    let cb'' = wrap_UnicodeDecomposeFuncT Nothing cb'
    mk_UnicodeDecomposeFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeDecomposeFuncT` into a `C_UnicodeDecomposeFuncT`.
wrap_UnicodeDecomposeFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeDecomposeFuncT)) ->
    UnicodeDecomposeFuncT_WithClosures ->
    C_UnicodeDecomposeFuncT
wrap_UnicodeDecomposeFuncT gi'funptrptr gi'cb ufuncs ab a b userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        (result, outa, outb) <- gi'cb  ufuncs' ab userData
        poke a outa
        poke b outb
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback UnicodeDecomposeCompatibilityFuncT
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "number of codepoints in the full compatibility decomposition of @u, or 0 if no decomposition available."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a Unicode function structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "u"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "codepoint to decompose"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "decomposed"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "address of codepoint array (of length #HB_UNICODE_MAX_DECOMPOSITION_LEN) to write decomposition into"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data pointer as passed to hb_unicode_funcs_set_decompose_compatibility_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.0.0"
          , deprecationMessage = Nothing
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Fully decompose @u to its Unicode compatibility decomposition. The codepoints of the decomposition will be written to @decomposed.\nThe complete length of the decomposition will be returned.\n\nIf @u has no compatibility decomposition, zero should be returned.\n\nThe Unicode standard guarantees that a buffer of length #HB_UNICODE_MAX_DECOMPOSITION_LEN codepoints will always be sufficient for any\ncompatibility decomposition plus an terminating value of 0.  Consequently, @decompose must be allocated by the caller to be at least this length.  Implementations\nof this function type must ensure that they do not write past the provided array."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeDecomposeCompatibilityFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Word32 ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode function structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "u"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "codepoint to decompose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "decomposed"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "address of codepoint array (of length #HB_UNICODE_MAX_DECOMPOSITION_LEN) to write decomposition into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data pointer as passed to hb_unicode_funcs_set_decompose_compatibility_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeDecomposeCompatibilityFuncT :: FunPtr C_UnicodeDecomposeCompatibilityFuncT -> C_UnicodeDecomposeCompatibilityFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeDecomposeCompatibilityFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeDecomposeCompatibilityFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: a Unicode function structure
    -> Word32
    -- ^ /@u@/: codepoint to decompose
    -> Word32
    -- ^ /@decomposed@/: address of codepoint array (of length 'GI.HarfBuzz.Constants.UNICODE_MAX_DECOMPOSITION_LEN') to write decomposition into
    -> Ptr ()
    -- ^ /@userData@/: user data pointer as passed to 'GI.HarfBuzz.Functions.unicodeFuncsSetDecomposeCompatibilityFunc'
    -> m Word32
    -- ^ __Returns:__ number of codepoints in the full compatibility decomposition of /@u@/, or 0 if no decomposition available.
dynamic_UnicodeDecomposeCompatibilityFuncT __funPtr ufuncs u decomposed userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeDecomposeCompatibilityFuncT __funPtr) ufuncs' u decomposed userData
    touchManagedPtr ufuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_UnicodeDecomposeCompatibilityFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeDecomposeCompatibilityFuncT :: C_UnicodeDecomposeCompatibilityFuncT -> IO (FunPtr C_UnicodeDecomposeCompatibilityFuncT)

{-# DEPRECATED UnicodeDecomposeCompatibilityFuncT ["(Since version 2.0.0)"] #-}
-- | Fully decompose /@u@/ to its Unicode compatibility decomposition. The codepoints of the decomposition will be written to /@decomposed@/.
-- The complete length of the decomposition will be returned.
-- 
-- If /@u@/ has no compatibility decomposition, zero should be returned.
-- 
-- The Unicode standard guarantees that a buffer of length 'GI.HarfBuzz.Constants.UNICODE_MAX_DECOMPOSITION_LEN' codepoints will always be sufficient for any
-- compatibility decomposition plus an terminating value of 0.  Consequently, /@decompose@/ must be allocated by the caller to be at least this length.  Implementations
-- of this function type must ensure that they do not write past the provided array.
type UnicodeDecomposeCompatibilityFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: a Unicode function structure
    -> Word32
    -- ^ /@u@/: codepoint to decompose
    -> Word32
    -- ^ /@decomposed@/: address of codepoint array (of length 'GI.HarfBuzz.Constants.UNICODE_MAX_DECOMPOSITION_LEN') to write decomposition into
    -> IO Word32
    -- ^ __Returns:__ number of codepoints in the full compatibility decomposition of /@u@/, or 0 if no decomposition available.

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeDecomposeCompatibilityFuncT`@.
noUnicodeDecomposeCompatibilityFuncT :: Maybe UnicodeDecomposeCompatibilityFuncT
noUnicodeDecomposeCompatibilityFuncT = Nothing

-- | Fully decompose /@u@/ to its Unicode compatibility decomposition. The codepoints of the decomposition will be written to /@decomposed@/.
-- The complete length of the decomposition will be returned.
-- 
-- If /@u@/ has no compatibility decomposition, zero should be returned.
-- 
-- The Unicode standard guarantees that a buffer of length 'GI.HarfBuzz.Constants.UNICODE_MAX_DECOMPOSITION_LEN' codepoints will always be sufficient for any
-- compatibility decomposition plus an terminating value of 0.  Consequently, /@decompose@/ must be allocated by the caller to be at least this length.  Implementations
-- of this function type must ensure that they do not write past the provided array.
type UnicodeDecomposeCompatibilityFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: a Unicode function structure
    -> Word32
    -- ^ /@u@/: codepoint to decompose
    -> Word32
    -- ^ /@decomposed@/: address of codepoint array (of length 'GI.HarfBuzz.Constants.UNICODE_MAX_DECOMPOSITION_LEN') to write decomposition into
    -> Ptr ()
    -- ^ /@userData@/: user data pointer as passed to 'GI.HarfBuzz.Functions.unicodeFuncsSetDecomposeCompatibilityFunc'
    -> IO Word32
    -- ^ __Returns:__ number of codepoints in the full compatibility decomposition of /@u@/, or 0 if no decomposition available.

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeDecomposeCompatibilityFuncT_WithClosures`@.
noUnicodeDecomposeCompatibilityFuncT_WithClosures :: Maybe UnicodeDecomposeCompatibilityFuncT_WithClosures
noUnicodeDecomposeCompatibilityFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeDecomposeCompatibilityFuncT :: UnicodeDecomposeCompatibilityFuncT -> UnicodeDecomposeCompatibilityFuncT_WithClosures
drop_closures_UnicodeDecomposeCompatibilityFuncT _f ufuncs u decomposed _ = _f ufuncs u decomposed

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeDecomposeCompatibilityFuncT :: MonadIO m => UnicodeDecomposeCompatibilityFuncT -> m (GClosure C_UnicodeDecomposeCompatibilityFuncT)
genClosure_UnicodeDecomposeCompatibilityFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeDecomposeCompatibilityFuncT cb
    let cb'' = wrap_UnicodeDecomposeCompatibilityFuncT Nothing cb'
    mk_UnicodeDecomposeCompatibilityFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeDecomposeCompatibilityFuncT` into a `C_UnicodeDecomposeCompatibilityFuncT`.
wrap_UnicodeDecomposeCompatibilityFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeDecomposeCompatibilityFuncT)) ->
    UnicodeDecomposeCompatibilityFuncT_WithClosures ->
    C_UnicodeDecomposeCompatibilityFuncT
wrap_UnicodeDecomposeCompatibilityFuncT gi'funptrptr gi'cb ufuncs u decomposed userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' u decomposed userData
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback UnicodeComposeFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` is @a,@b composed, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "a"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first code point to compose"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The second code point to compose"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "ab"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The composed code point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should compose a sequence of two input Unicode code\npoints by canonical equivalence, returning the composed code\npoint in a #hb_codepoint_t output parameter (if successful).\nThe method must return an #hb_bool_t indicating the success\nof the composition."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeComposeFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first code point to compose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The second code point to compose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ab"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The composed code point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeComposeFuncT :: FunPtr C_UnicodeComposeFuncT -> C_UnicodeComposeFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeComposeFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeComposeFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@a@/: The first code point to compose
    -> Word32
    -- ^ /@b@/: The second code point to compose
    -> Ptr ()
    -- ^ /@userData@/: user data pointer passed by the caller
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ is /@a@/,/@b@/ composed, @false@ otherwise
dynamic_UnicodeComposeFuncT __funPtr ufuncs a b userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    ab <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_UnicodeComposeFuncT __funPtr) ufuncs' a b ab userData
    ab' <- peek ab
    touchManagedPtr ufuncs
    freeMem ab
    return (result, ab')

-- | Generate a function pointer callable from C code, from a `C_UnicodeComposeFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeComposeFuncT :: C_UnicodeComposeFuncT -> IO (FunPtr C_UnicodeComposeFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should compose a sequence of two input Unicode code
-- points by canonical equivalence, returning the composed code
-- point in a @/hb_codepoint_t/@ output parameter (if successful).
-- The method must return an @/hb_bool_t/@ indicating the success
-- of the composition.
type UnicodeComposeFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@a@/: The first code point to compose
    -> Word32
    -- ^ /@b@/: The second code point to compose
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ is /@a@/,/@b@/ composed, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeComposeFuncT`@.
noUnicodeComposeFuncT :: Maybe UnicodeComposeFuncT
noUnicodeComposeFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should compose a sequence of two input Unicode code
-- points by canonical equivalence, returning the composed code
-- point in a @/hb_codepoint_t/@ output parameter (if successful).
-- The method must return an @/hb_bool_t/@ indicating the success
-- of the composition.
type UnicodeComposeFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@a@/: The first code point to compose
    -> Word32
    -- ^ /@b@/: The second code point to compose
    -> Ptr ()
    -- ^ /@userData@/: user data pointer passed by the caller
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ is /@a@/,/@b@/ composed, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeComposeFuncT_WithClosures`@.
noUnicodeComposeFuncT_WithClosures :: Maybe UnicodeComposeFuncT_WithClosures
noUnicodeComposeFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeComposeFuncT :: UnicodeComposeFuncT -> UnicodeComposeFuncT_WithClosures
drop_closures_UnicodeComposeFuncT _f ufuncs a b _ = _f ufuncs a b

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeComposeFuncT :: MonadIO m => UnicodeComposeFuncT -> m (GClosure C_UnicodeComposeFuncT)
genClosure_UnicodeComposeFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeComposeFuncT cb
    let cb'' = wrap_UnicodeComposeFuncT Nothing cb'
    mk_UnicodeComposeFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeComposeFuncT` into a `C_UnicodeComposeFuncT`.
wrap_UnicodeComposeFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeComposeFuncT)) ->
    UnicodeComposeFuncT_WithClosures ->
    C_UnicodeComposeFuncT
wrap_UnicodeComposeFuncT gi'funptrptr gi'cb ufuncs a b ab userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        (result, outab) <- gi'cb  ufuncs' a b userData
        poke ab outab
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback UnicodeCombiningClassFuncT
{- Callable
  { returnType =
      Just
        (TInterface
           Name
             { namespace = "HarfBuzz" , name = "unicode_combining_class_t" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "The #hb_unicode_combining_class_t of @unicode"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufuncs"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A Unicode-functions structure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_unicode_funcs_t structure.\n\nThis method should retrieve the Canonical Combining Class (ccc)\nproperty for a specified Unicode code point."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnicodeCombiningClassFuncT =
    Ptr HarfBuzz.UnicodeFuncsT.UnicodeFuncsT ->
    Word32 ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "ufuncs"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "unicode_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A Unicode-functions structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name
--                    { namespace = "HarfBuzz" , name = "unicode_combining_class_t" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnicodeCombiningClassFuncT :: FunPtr C_UnicodeCombiningClassFuncT -> C_UnicodeCombiningClassFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnicodeCombiningClassFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnicodeCombiningClassFuncT
    -> HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m HarfBuzz.Enums.UnicodeCombiningClassT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeCombiningClassT' of /@unicode@/
dynamic_UnicodeCombiningClassFuncT __funPtr ufuncs unicode userData = liftIO $ do
    ufuncs' <- unsafeManagedPtrGetPtr ufuncs
    result <- (__dynamic_C_UnicodeCombiningClassFuncT __funPtr) ufuncs' unicode userData
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr ufuncs
    return result'

-- | Generate a function pointer callable from C code, from a `C_UnicodeCombiningClassFuncT`.
foreign import ccall "wrapper"
    mk_UnicodeCombiningClassFuncT :: C_UnicodeCombiningClassFuncT -> IO (FunPtr C_UnicodeCombiningClassFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Canonical Combining Class (ccc)
-- property for a specified Unicode code point.
type UnicodeCombiningClassFuncT =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> IO HarfBuzz.Enums.UnicodeCombiningClassT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeCombiningClassT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeCombiningClassFuncT`@.
noUnicodeCombiningClassFuncT :: Maybe UnicodeCombiningClassFuncT
noUnicodeCombiningClassFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT' structure.
-- 
-- This method should retrieve the Canonical Combining Class (ccc)
-- property for a specified Unicode code point.
type UnicodeCombiningClassFuncT_WithClosures =
    HarfBuzz.UnicodeFuncsT.UnicodeFuncsT
    -- ^ /@ufuncs@/: A Unicode-functions structure
    -> Word32
    -- ^ /@unicode@/: The code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO HarfBuzz.Enums.UnicodeCombiningClassT
    -- ^ __Returns:__ The t'GI.HarfBuzz.Enums.UnicodeCombiningClassT' of /@unicode@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnicodeCombiningClassFuncT_WithClosures`@.
noUnicodeCombiningClassFuncT_WithClosures :: Maybe UnicodeCombiningClassFuncT_WithClosures
noUnicodeCombiningClassFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnicodeCombiningClassFuncT :: UnicodeCombiningClassFuncT -> UnicodeCombiningClassFuncT_WithClosures
drop_closures_UnicodeCombiningClassFuncT _f ufuncs unicode _ = _f ufuncs unicode

-- | Wrap the callback into a `GClosure`.
genClosure_UnicodeCombiningClassFuncT :: MonadIO m => UnicodeCombiningClassFuncT -> m (GClosure C_UnicodeCombiningClassFuncT)
genClosure_UnicodeCombiningClassFuncT cb = liftIO $ do
    let cb' = drop_closures_UnicodeCombiningClassFuncT cb
    let cb'' = wrap_UnicodeCombiningClassFuncT Nothing cb'
    mk_UnicodeCombiningClassFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnicodeCombiningClassFuncT` into a `C_UnicodeCombiningClassFuncT`.
wrap_UnicodeCombiningClassFuncT :: 
    Maybe (Ptr (FunPtr C_UnicodeCombiningClassFuncT)) ->
    UnicodeCombiningClassFuncT_WithClosures ->
    C_UnicodeCombiningClassFuncT
wrap_UnicodeCombiningClassFuncT gi'funptrptr gi'cb ufuncs unicode userData = do
    B.ManagedPtr.withTransient  ufuncs $ \ufuncs' -> do
        result <- gi'cb  ufuncs' unicode userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (fromIntegral . fromEnum) result
        return result'


-- callback ReferenceTableFuncT
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "HarfBuzz" , name = "blob_t" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A pointer to the @tag table within @face or\n`NULL` if the table is not found or cannot be referenced."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "face"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "face_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "an #hb_face_t to reference table for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "tag"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the tag of the table to reference"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Callback function for hb_face_create_for_tables(). The @tag is the tag of the\ntable to reference, and the special tag #HB_TAG_NONE is used to reference the\nblob of the face itself. If referencing the face blob is not possible, it is\nrecommended to set hb_get_table_tags_func_t on the @face to allow\nhb_face_reference_blob() to create a face blob out of individual table blobs."
        , sinceVersion = Just "0.9.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ReferenceTableFuncT =
    Ptr HarfBuzz.FaceT.FaceT ->
    Word32 ->
    Ptr () ->
    IO (Ptr HarfBuzz.BlobT.BlobT)

-- Args: [ Arg
--           { argCName = "face"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "face_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #hb_face_t to reference table for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tag"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tag of the table to reference"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "HarfBuzz" , name = "blob_t" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ReferenceTableFuncT :: FunPtr C_ReferenceTableFuncT -> C_ReferenceTableFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ReferenceTableFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ReferenceTableFuncT
    -> HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: an t'GI.HarfBuzz.Structs.FaceT.FaceT' to reference table for
    -> Word32
    -- ^ /@tag@/: the tag of the table to reference
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m HarfBuzz.BlobT.BlobT
    -- ^ __Returns:__ A pointer to the /@tag@/ table within /@face@/ or
    -- @NULL@ if the table is not found or cannot be referenced.
dynamic_ReferenceTableFuncT __funPtr face tag userData = liftIO $ do
    face' <- unsafeManagedPtrGetPtr face
    result <- (__dynamic_C_ReferenceTableFuncT __funPtr) face' tag userData
    checkUnexpectedReturnNULL "referenceTableFuncT" result
    result' <- (wrapBoxed HarfBuzz.BlobT.BlobT) result
    touchManagedPtr face
    return result'

-- | Generate a function pointer callable from C code, from a `C_ReferenceTableFuncT`.
foreign import ccall "wrapper"
    mk_ReferenceTableFuncT :: C_ReferenceTableFuncT -> IO (FunPtr C_ReferenceTableFuncT)

-- | Callback function for 'GI.HarfBuzz.Functions.faceCreateForTables'. The /@tag@/ is the tag of the
-- table to reference, and the special tag @/HB_TAG_NONE/@ is used to reference the
-- blob of the face itself. If referencing the face blob is not possible, it is
-- recommended to set hb_get_table_tags_func_t on the /@face@/ to allow
-- 'GI.HarfBuzz.Functions.faceReferenceBlob' to create a face blob out of individual table blobs.
-- 
-- /Since: 0.9.2/
type ReferenceTableFuncT =
    HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: an t'GI.HarfBuzz.Structs.FaceT.FaceT' to reference table for
    -> Word32
    -- ^ /@tag@/: the tag of the table to reference
    -> IO HarfBuzz.BlobT.BlobT
    -- ^ __Returns:__ A pointer to the /@tag@/ table within /@face@/ or
    -- @NULL@ if the table is not found or cannot be referenced.

-- | A convenience synonym for @`Nothing` :: `Maybe` `ReferenceTableFuncT`@.
noReferenceTableFuncT :: Maybe ReferenceTableFuncT
noReferenceTableFuncT = Nothing

-- | Callback function for 'GI.HarfBuzz.Functions.faceCreateForTables'. The /@tag@/ is the tag of the
-- table to reference, and the special tag @/HB_TAG_NONE/@ is used to reference the
-- blob of the face itself. If referencing the face blob is not possible, it is
-- recommended to set hb_get_table_tags_func_t on the /@face@/ to allow
-- 'GI.HarfBuzz.Functions.faceReferenceBlob' to create a face blob out of individual table blobs.
-- 
-- /Since: 0.9.2/
type ReferenceTableFuncT_WithClosures =
    HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: an t'GI.HarfBuzz.Structs.FaceT.FaceT' to reference table for
    -> Word32
    -- ^ /@tag@/: the tag of the table to reference
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO HarfBuzz.BlobT.BlobT
    -- ^ __Returns:__ A pointer to the /@tag@/ table within /@face@/ or
    -- @NULL@ if the table is not found or cannot be referenced.

-- | A convenience synonym for @`Nothing` :: `Maybe` `ReferenceTableFuncT_WithClosures`@.
noReferenceTableFuncT_WithClosures :: Maybe ReferenceTableFuncT_WithClosures
noReferenceTableFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ReferenceTableFuncT :: ReferenceTableFuncT -> ReferenceTableFuncT_WithClosures
drop_closures_ReferenceTableFuncT _f face tag _ = _f face tag

-- | Wrap the callback into a `GClosure`.
genClosure_ReferenceTableFuncT :: MonadIO m => ReferenceTableFuncT -> m (GClosure C_ReferenceTableFuncT)
genClosure_ReferenceTableFuncT cb = liftIO $ do
    let cb' = drop_closures_ReferenceTableFuncT cb
    let cb'' = wrap_ReferenceTableFuncT Nothing cb'
    mk_ReferenceTableFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ReferenceTableFuncT` into a `C_ReferenceTableFuncT`.
wrap_ReferenceTableFuncT :: 
    Maybe (Ptr (FunPtr C_ReferenceTableFuncT)) ->
    ReferenceTableFuncT_WithClosures ->
    C_ReferenceTableFuncT
wrap_ReferenceTableFuncT gi'funptrptr gi'cb face tag userData = do
    B.ManagedPtr.withTransient  face $ \face' -> do
        result <- gi'cb  face' tag userData
        maybeReleaseFunPtr gi'funptrptr
        result' <- B.ManagedPtr.disownBoxed result
        return result'


-- callback PaintSweepGradientFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_line"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Color information for the gradient"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "start_angle"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the start angle, in radians"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "end_angle"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the end angle, in radians"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_sweep_gradient_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to paint a sweep\ngradient everywhere within the current clip.\n\nThe @color_line object contains information about the colors of the gradients.\nIt is only valid for the duration of the callback, you cannot keep it around.\n\nThe coordinates of the points are interpreted according\nto the current transform.\n\nSee the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\nsection for details on how the points define the direction\nof the gradient, and how to interpret the @color_line."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintSweepGradientFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.ColorLineT.ColorLineT ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_line"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Color information for the gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_angle"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the start angle, in radians"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_angle"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the end angle, in radians"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_sweep_gradient_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintSweepGradientFuncT :: FunPtr C_PaintSweepGradientFuncT -> C_PaintSweepGradientFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintSweepGradientFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintSweepGradientFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the circle\'s center
    -> Float
    -- ^ /@startAngle@/: the start angle, in radians
    -> Float
    -- ^ /@endAngle@/: the end angle, in radians
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetSweepGradientFunc'
    -> m ()
dynamic_PaintSweepGradientFuncT __funPtr funcs paintData colorLine x0 y0 startAngle endAngle userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    colorLine' <- unsafeManagedPtrGetPtr colorLine
    let x0' = realToFrac x0
    let y0' = realToFrac y0
    let startAngle' = realToFrac startAngle
    let endAngle' = realToFrac endAngle
    (__dynamic_C_PaintSweepGradientFuncT __funPtr) funcs' paintData colorLine' x0' y0' startAngle' endAngle' userData
    touchManagedPtr funcs
    touchManagedPtr colorLine
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintSweepGradientFuncT`.
foreign import ccall "wrapper"
    mk_PaintSweepGradientFuncT :: C_PaintSweepGradientFuncT -> IO (FunPtr C_PaintSweepGradientFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a sweep
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintSweepGradientFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the circle\'s center
    -> Float
    -- ^ /@startAngle@/: the start angle, in radians
    -> Float
    -- ^ /@endAngle@/: the end angle, in radians
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintSweepGradientFuncT`@.
noPaintSweepGradientFuncT :: Maybe PaintSweepGradientFuncT
noPaintSweepGradientFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a sweep
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintSweepGradientFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the circle\'s center
    -> Float
    -- ^ /@startAngle@/: the start angle, in radians
    -> Float
    -- ^ /@endAngle@/: the end angle, in radians
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetSweepGradientFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintSweepGradientFuncT_WithClosures`@.
noPaintSweepGradientFuncT_WithClosures :: Maybe PaintSweepGradientFuncT_WithClosures
noPaintSweepGradientFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintSweepGradientFuncT :: PaintSweepGradientFuncT -> PaintSweepGradientFuncT_WithClosures
drop_closures_PaintSweepGradientFuncT _f funcs paintData colorLine x0 y0 startAngle endAngle _ = _f funcs paintData colorLine x0 y0 startAngle endAngle

-- | Wrap the callback into a `GClosure`.
genClosure_PaintSweepGradientFuncT :: MonadIO m => PaintSweepGradientFuncT -> m (GClosure C_PaintSweepGradientFuncT)
genClosure_PaintSweepGradientFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintSweepGradientFuncT cb
    let cb'' = wrap_PaintSweepGradientFuncT Nothing cb'
    mk_PaintSweepGradientFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintSweepGradientFuncT` into a `C_PaintSweepGradientFuncT`.
wrap_PaintSweepGradientFuncT :: 
    Maybe (Ptr (FunPtr C_PaintSweepGradientFuncT)) ->
    PaintSweepGradientFuncT_WithClosures ->
    C_PaintSweepGradientFuncT
wrap_PaintSweepGradientFuncT gi'funptrptr gi'cb funcs paintData colorLine x0 y0 startAngle endAngle userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  colorLine $ \colorLine' -> do
            let x0' = realToFrac x0
            let y0' = realToFrac y0
            let startAngle' = realToFrac startAngle
            let endAngle' = realToFrac endAngle
            gi'cb  funcs' paintData colorLine' x0' y0' startAngle' endAngle' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback PaintRadialGradientFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_line"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Color information for the gradient"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the first circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the first circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "r0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "radius of the first circle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x1"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the second circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y1"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the second circle's center"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "r1"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "radius of the second circle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_radial_gradient_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to paint a radial\ngradient everywhere within the current clip.\n\nThe @color_line object contains information about the colors of the gradients.\nIt is only valid for the duration of the callback, you cannot keep it around.\n\nThe coordinates of the points are interpreted according\nto the current transform.\n\nSee the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\nsection for details on how the points define the direction\nof the gradient, and how to interpret the @color_line."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintRadialGradientFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.ColorLineT.ColorLineT ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_line"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Color information for the gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the first circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the first circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "radius of the first circle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x1"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the second circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y1"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the second circle's center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r1"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "radius of the second circle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_radial_gradient_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintRadialGradientFuncT :: FunPtr C_PaintRadialGradientFuncT -> C_PaintRadialGradientFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintRadialGradientFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintRadialGradientFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the first circle\'s center
    -> Float
    -- ^ /@r0@/: radius of the first circle
    -> Float
    -- ^ /@x1@/: X coordinate of the second circle\'s center
    -> Float
    -- ^ /@y1@/: Y coordinate of the second circle\'s center
    -> Float
    -- ^ /@r1@/: radius of the second circle
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetRadialGradientFunc'
    -> m ()
dynamic_PaintRadialGradientFuncT __funPtr funcs paintData colorLine x0 y0 r0 x1 y1 r1 userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    colorLine' <- unsafeManagedPtrGetPtr colorLine
    let x0' = realToFrac x0
    let y0' = realToFrac y0
    let r0' = realToFrac r0
    let x1' = realToFrac x1
    let y1' = realToFrac y1
    let r1' = realToFrac r1
    (__dynamic_C_PaintRadialGradientFuncT __funPtr) funcs' paintData colorLine' x0' y0' r0' x1' y1' r1' userData
    touchManagedPtr funcs
    touchManagedPtr colorLine
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintRadialGradientFuncT`.
foreign import ccall "wrapper"
    mk_PaintRadialGradientFuncT :: C_PaintRadialGradientFuncT -> IO (FunPtr C_PaintRadialGradientFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a radial
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintRadialGradientFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the first circle\'s center
    -> Float
    -- ^ /@r0@/: radius of the first circle
    -> Float
    -- ^ /@x1@/: X coordinate of the second circle\'s center
    -> Float
    -- ^ /@y1@/: Y coordinate of the second circle\'s center
    -> Float
    -- ^ /@r1@/: radius of the second circle
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintRadialGradientFuncT`@.
noPaintRadialGradientFuncT :: Maybe PaintRadialGradientFuncT
noPaintRadialGradientFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a radial
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintRadialGradientFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first circle\'s center
    -> Float
    -- ^ /@y0@/: Y coordinate of the first circle\'s center
    -> Float
    -- ^ /@r0@/: radius of the first circle
    -> Float
    -- ^ /@x1@/: X coordinate of the second circle\'s center
    -> Float
    -- ^ /@y1@/: Y coordinate of the second circle\'s center
    -> Float
    -- ^ /@r1@/: radius of the second circle
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetRadialGradientFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintRadialGradientFuncT_WithClosures`@.
noPaintRadialGradientFuncT_WithClosures :: Maybe PaintRadialGradientFuncT_WithClosures
noPaintRadialGradientFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintRadialGradientFuncT :: PaintRadialGradientFuncT -> PaintRadialGradientFuncT_WithClosures
drop_closures_PaintRadialGradientFuncT _f funcs paintData colorLine x0 y0 r0 x1 y1 r1 _ = _f funcs paintData colorLine x0 y0 r0 x1 y1 r1

-- | Wrap the callback into a `GClosure`.
genClosure_PaintRadialGradientFuncT :: MonadIO m => PaintRadialGradientFuncT -> m (GClosure C_PaintRadialGradientFuncT)
genClosure_PaintRadialGradientFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintRadialGradientFuncT cb
    let cb'' = wrap_PaintRadialGradientFuncT Nothing cb'
    mk_PaintRadialGradientFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintRadialGradientFuncT` into a `C_PaintRadialGradientFuncT`.
wrap_PaintRadialGradientFuncT :: 
    Maybe (Ptr (FunPtr C_PaintRadialGradientFuncT)) ->
    PaintRadialGradientFuncT_WithClosures ->
    C_PaintRadialGradientFuncT
wrap_PaintRadialGradientFuncT gi'funptrptr gi'cb funcs paintData colorLine x0 y0 r0 x1 y1 r1 userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  colorLine $ \colorLine' -> do
            let x0' = realToFrac x0
            let y0' = realToFrac y0
            let r0' = realToFrac r0
            let x1' = realToFrac x1
            let y1' = realToFrac y1
            let r1' = realToFrac r1
            gi'cb  funcs' paintData colorLine' x0' y0' r0' x1' y1' r1' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback PaintPushTransformFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "xx"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "xx component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "yx"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "yx component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "xy"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "xy component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "yy"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "yy component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "dx"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "dx component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "dy"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "dy component of the transform matrix"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_push_transform_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to apply\na transform to subsequent paint calls.\n\nThis transform is applied after the current transform,\nand remains in effect until a matching call to\nthe #hb_paint_funcs_pop_transform_func_t vfunc."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPushTransformFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xx"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "xx component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yx"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "yx component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xy"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "xy component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yy"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "yy component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "dx component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "dy component of the transform matrix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_push_transform_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPushTransformFuncT :: FunPtr C_PaintPushTransformFuncT -> C_PaintPushTransformFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPushTransformFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPushTransformFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xx@/: xx component of the transform matrix
    -> Float
    -- ^ /@yx@/: yx component of the transform matrix
    -> Float
    -- ^ /@xy@/: xy component of the transform matrix
    -> Float
    -- ^ /@yy@/: yy component of the transform matrix
    -> Float
    -- ^ /@dx@/: dx component of the transform matrix
    -> Float
    -- ^ /@dy@/: dy component of the transform matrix
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushTransformFunc'
    -> m ()
dynamic_PaintPushTransformFuncT __funPtr funcs paintData xx yx xy yy dx dy userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    let xx' = realToFrac xx
    let yx' = realToFrac yx
    let xy' = realToFrac xy
    let yy' = realToFrac yy
    let dx' = realToFrac dx
    let dy' = realToFrac dy
    (__dynamic_C_PaintPushTransformFuncT __funPtr) funcs' paintData xx' yx' xy' yy' dx' dy' userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPushTransformFuncT`.
foreign import ccall "wrapper"
    mk_PaintPushTransformFuncT :: C_PaintPushTransformFuncT -> IO (FunPtr C_PaintPushTransformFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to apply
-- a transform to subsequent paint calls.
-- 
-- This transform is applied after the current transform,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_transform_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushTransformFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xx@/: xx component of the transform matrix
    -> Float
    -- ^ /@yx@/: yx component of the transform matrix
    -> Float
    -- ^ /@xy@/: xy component of the transform matrix
    -> Float
    -- ^ /@yy@/: yy component of the transform matrix
    -> Float
    -- ^ /@dx@/: dx component of the transform matrix
    -> Float
    -- ^ /@dy@/: dy component of the transform matrix
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushTransformFuncT`@.
noPaintPushTransformFuncT :: Maybe PaintPushTransformFuncT
noPaintPushTransformFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to apply
-- a transform to subsequent paint calls.
-- 
-- This transform is applied after the current transform,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_transform_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushTransformFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xx@/: xx component of the transform matrix
    -> Float
    -- ^ /@yx@/: yx component of the transform matrix
    -> Float
    -- ^ /@xy@/: xy component of the transform matrix
    -> Float
    -- ^ /@yy@/: yy component of the transform matrix
    -> Float
    -- ^ /@dx@/: dx component of the transform matrix
    -> Float
    -- ^ /@dy@/: dy component of the transform matrix
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushTransformFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushTransformFuncT_WithClosures`@.
noPaintPushTransformFuncT_WithClosures :: Maybe PaintPushTransformFuncT_WithClosures
noPaintPushTransformFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPushTransformFuncT :: PaintPushTransformFuncT -> PaintPushTransformFuncT_WithClosures
drop_closures_PaintPushTransformFuncT _f funcs paintData xx yx xy yy dx dy _ = _f funcs paintData xx yx xy yy dx dy

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPushTransformFuncT :: MonadIO m => PaintPushTransformFuncT -> m (GClosure C_PaintPushTransformFuncT)
genClosure_PaintPushTransformFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPushTransformFuncT cb
    let cb'' = wrap_PaintPushTransformFuncT Nothing cb'
    mk_PaintPushTransformFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPushTransformFuncT` into a `C_PaintPushTransformFuncT`.
wrap_PaintPushTransformFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPushTransformFuncT)) ->
    PaintPushTransformFuncT_WithClosures ->
    C_PaintPushTransformFuncT
wrap_PaintPushTransformFuncT gi'funptrptr gi'cb funcs paintData xx yx xy yy dx dy userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        let xx' = realToFrac xx
        let yx' = realToFrac yx
        let xy' = realToFrac xy
        let yy' = realToFrac yy
        let dx' = realToFrac dx
        let dy' = realToFrac dy
        gi'cb  funcs' paintData xx' yx' xy' yy' dx' dy' userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintPushGroupFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_push_group_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to use\nan intermediate surface for subsequent paint calls.\n\nThe drawing will be redirected to an intermediate surface\nuntil a matching call to the #hb_paint_funcs_pop_group_func_t\nvfunc."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPushGroupFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_push_group_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPushGroupFuncT :: FunPtr C_PaintPushGroupFuncT -> C_PaintPushGroupFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPushGroupFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPushGroupFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushGroupFunc'
    -> m ()
dynamic_PaintPushGroupFuncT __funPtr funcs paintData userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    (__dynamic_C_PaintPushGroupFuncT __funPtr) funcs' paintData userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPushGroupFuncT`.
foreign import ccall "wrapper"
    mk_PaintPushGroupFuncT :: C_PaintPushGroupFuncT -> IO (FunPtr C_PaintPushGroupFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to use
-- an intermediate surface for subsequent paint calls.
-- 
-- The drawing will be redirected to an intermediate surface
-- until a matching call to the @/hb_paint_funcs_pop_group_func_t/@
-- vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushGroupFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushGroupFuncT`@.
noPaintPushGroupFuncT :: Maybe PaintPushGroupFuncT
noPaintPushGroupFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to use
-- an intermediate surface for subsequent paint calls.
-- 
-- The drawing will be redirected to an intermediate surface
-- until a matching call to the @/hb_paint_funcs_pop_group_func_t/@
-- vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushGroupFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushGroupFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushGroupFuncT_WithClosures`@.
noPaintPushGroupFuncT_WithClosures :: Maybe PaintPushGroupFuncT_WithClosures
noPaintPushGroupFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPushGroupFuncT :: PaintPushGroupFuncT -> PaintPushGroupFuncT_WithClosures
drop_closures_PaintPushGroupFuncT _f funcs paintData _ = _f funcs paintData

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPushGroupFuncT :: MonadIO m => PaintPushGroupFuncT -> m (GClosure C_PaintPushGroupFuncT)
genClosure_PaintPushGroupFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPushGroupFuncT cb
    let cb'' = wrap_PaintPushGroupFuncT Nothing cb'
    mk_PaintPushGroupFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPushGroupFuncT` into a `C_PaintPushGroupFuncT`.
wrap_PaintPushGroupFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPushGroupFuncT)) ->
    PaintPushGroupFuncT_WithClosures ->
    C_PaintPushGroupFuncT
wrap_PaintPushGroupFuncT gi'funptrptr gi'cb funcs paintData userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        gi'cb  funcs' paintData userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintPushClipRectangleFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "xmin"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "min X for the rectangle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "ymin"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "min Y for the rectangle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "xmax"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "max X for the rectangle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "ymax"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "max Y for the rectangle"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_push_clip_rectangle_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to clip\nsubsequent paint calls to a rectangle.\n\nThe coordinates of the rectangle are interpreted according\nto the current transform.\n\nThis clip is applied in addition to the current clip,\nand remains in effect until a matching call to\nthe #hb_paint_funcs_pop_clip_func_t vfunc."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPushClipRectangleFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xmin"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "min X for the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ymin"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "min Y for the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xmax"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "max X for the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ymax"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "max Y for the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_push_clip_rectangle_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPushClipRectangleFuncT :: FunPtr C_PaintPushClipRectangleFuncT -> C_PaintPushClipRectangleFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPushClipRectangleFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPushClipRectangleFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xmin@/: min X for the rectangle
    -> Float
    -- ^ /@ymin@/: min Y for the rectangle
    -> Float
    -- ^ /@xmax@/: max X for the rectangle
    -> Float
    -- ^ /@ymax@/: max Y for the rectangle
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushClipRectangleFunc'
    -> m ()
dynamic_PaintPushClipRectangleFuncT __funPtr funcs paintData xmin ymin xmax ymax userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    let xmin' = realToFrac xmin
    let ymin' = realToFrac ymin
    let xmax' = realToFrac xmax
    let ymax' = realToFrac ymax
    (__dynamic_C_PaintPushClipRectangleFuncT __funPtr) funcs' paintData xmin' ymin' xmax' ymax' userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPushClipRectangleFuncT`.
foreign import ccall "wrapper"
    mk_PaintPushClipRectangleFuncT :: C_PaintPushClipRectangleFuncT -> IO (FunPtr C_PaintPushClipRectangleFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to clip
-- subsequent paint calls to a rectangle.
-- 
-- The coordinates of the rectangle are interpreted according
-- to the current transform.
-- 
-- This clip is applied in addition to the current clip,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_clip_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushClipRectangleFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xmin@/: min X for the rectangle
    -> Float
    -- ^ /@ymin@/: min Y for the rectangle
    -> Float
    -- ^ /@xmax@/: max X for the rectangle
    -> Float
    -- ^ /@ymax@/: max Y for the rectangle
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushClipRectangleFuncT`@.
noPaintPushClipRectangleFuncT :: Maybe PaintPushClipRectangleFuncT
noPaintPushClipRectangleFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to clip
-- subsequent paint calls to a rectangle.
-- 
-- The coordinates of the rectangle are interpreted according
-- to the current transform.
-- 
-- This clip is applied in addition to the current clip,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_clip_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushClipRectangleFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Float
    -- ^ /@xmin@/: min X for the rectangle
    -> Float
    -- ^ /@ymin@/: min Y for the rectangle
    -> Float
    -- ^ /@xmax@/: max X for the rectangle
    -> Float
    -- ^ /@ymax@/: max Y for the rectangle
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushClipRectangleFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushClipRectangleFuncT_WithClosures`@.
noPaintPushClipRectangleFuncT_WithClosures :: Maybe PaintPushClipRectangleFuncT_WithClosures
noPaintPushClipRectangleFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPushClipRectangleFuncT :: PaintPushClipRectangleFuncT -> PaintPushClipRectangleFuncT_WithClosures
drop_closures_PaintPushClipRectangleFuncT _f funcs paintData xmin ymin xmax ymax _ = _f funcs paintData xmin ymin xmax ymax

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPushClipRectangleFuncT :: MonadIO m => PaintPushClipRectangleFuncT -> m (GClosure C_PaintPushClipRectangleFuncT)
genClosure_PaintPushClipRectangleFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPushClipRectangleFuncT cb
    let cb'' = wrap_PaintPushClipRectangleFuncT Nothing cb'
    mk_PaintPushClipRectangleFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPushClipRectangleFuncT` into a `C_PaintPushClipRectangleFuncT`.
wrap_PaintPushClipRectangleFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPushClipRectangleFuncT)) ->
    PaintPushClipRectangleFuncT_WithClosures ->
    C_PaintPushClipRectangleFuncT
wrap_PaintPushClipRectangleFuncT gi'funptrptr gi'cb funcs paintData xmin ymin xmax ymax userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        let xmin' = realToFrac xmin
        let ymin' = realToFrac ymin
        let xmax' = realToFrac xmax
        let ymax' = realToFrac ymax
        gi'cb  funcs' paintData xmin' ymin' xmax' ymax' userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintPushClipGlyphFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the glyph ID" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the font" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_push_clip_glyph_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to clip\nsubsequent paint calls to the outline of a glyph.\n\nThe coordinates of the glyph outline are expected in the\ncurrent @font scale (ie. the results of calling\nhb_font_draw_glyph() with @font). The outline is\ntransformed by the current transform.\n\nThis clip is applied in addition to the current clip,\nand remains in effect until a matching call to\nthe #hb_paint_funcs_pop_clip_func_t vfunc."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPushClipGlyphFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the glyph ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the font" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_push_clip_glyph_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPushClipGlyphFuncT :: FunPtr C_PaintPushClipGlyphFuncT -> C_PaintPushClipGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPushClipGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPushClipGlyphFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushClipGlyphFunc'
    -> m ()
dynamic_PaintPushClipGlyphFuncT __funPtr funcs paintData glyph font userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    font' <- unsafeManagedPtrGetPtr font
    (__dynamic_C_PaintPushClipGlyphFuncT __funPtr) funcs' paintData glyph font' userData
    touchManagedPtr funcs
    touchManagedPtr font
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPushClipGlyphFuncT`.
foreign import ccall "wrapper"
    mk_PaintPushClipGlyphFuncT :: C_PaintPushClipGlyphFuncT -> IO (FunPtr C_PaintPushClipGlyphFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to clip
-- subsequent paint calls to the outline of a glyph.
-- 
-- The coordinates of the glyph outline are expected in the
-- current /@font@/ scale (ie. the results of calling
-- 'GI.HarfBuzz.Functions.fontDrawGlyph' with /@font@/). The outline is
-- transformed by the current transform.
-- 
-- This clip is applied in addition to the current clip,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_clip_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushClipGlyphFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushClipGlyphFuncT`@.
noPaintPushClipGlyphFuncT :: Maybe PaintPushClipGlyphFuncT
noPaintPushClipGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to clip
-- subsequent paint calls to the outline of a glyph.
-- 
-- The coordinates of the glyph outline are expected in the
-- current /@font@/ scale (ie. the results of calling
-- 'GI.HarfBuzz.Functions.fontDrawGlyph' with /@font@/). The outline is
-- transformed by the current transform.
-- 
-- This clip is applied in addition to the current clip,
-- and remains in effect until a matching call to
-- the @/hb_paint_funcs_pop_clip_func_t/@ vfunc.
-- 
-- /Since: 7.0.0/
type PaintPushClipGlyphFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPushClipGlyphFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPushClipGlyphFuncT_WithClosures`@.
noPaintPushClipGlyphFuncT_WithClosures :: Maybe PaintPushClipGlyphFuncT_WithClosures
noPaintPushClipGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPushClipGlyphFuncT :: PaintPushClipGlyphFuncT -> PaintPushClipGlyphFuncT_WithClosures
drop_closures_PaintPushClipGlyphFuncT _f funcs paintData glyph font _ = _f funcs paintData glyph font

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPushClipGlyphFuncT :: MonadIO m => PaintPushClipGlyphFuncT -> m (GClosure C_PaintPushClipGlyphFuncT)
genClosure_PaintPushClipGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPushClipGlyphFuncT cb
    let cb'' = wrap_PaintPushClipGlyphFuncT Nothing cb'
    mk_PaintPushClipGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPushClipGlyphFuncT` into a `C_PaintPushClipGlyphFuncT`.
wrap_PaintPushClipGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPushClipGlyphFuncT)) ->
    PaintPushClipGlyphFuncT_WithClosures ->
    C_PaintPushClipGlyphFuncT
wrap_PaintPushClipGlyphFuncT gi'funptrptr gi'cb funcs paintData glyph font userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  font $ \font' -> do
            gi'cb  funcs' paintData glyph font' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback PaintPopTransformFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_pop_transform_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to undo\nthe effect of a prior call to the #hb_paint_funcs_push_transform_func_t\nvfunc."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPopTransformFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_pop_transform_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPopTransformFuncT :: FunPtr C_PaintPopTransformFuncT -> C_PaintPopTransformFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPopTransformFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPopTransformFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopTransformFunc'
    -> m ()
dynamic_PaintPopTransformFuncT __funPtr funcs paintData userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    (__dynamic_C_PaintPopTransformFuncT __funPtr) funcs' paintData userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPopTransformFuncT`.
foreign import ccall "wrapper"
    mk_PaintPopTransformFuncT :: C_PaintPopTransformFuncT -> IO (FunPtr C_PaintPopTransformFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_transform_func_t/@
-- vfunc.
-- 
-- /Since: 7.0.0/
type PaintPopTransformFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopTransformFuncT`@.
noPaintPopTransformFuncT :: Maybe PaintPopTransformFuncT
noPaintPopTransformFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_transform_func_t/@
-- vfunc.
-- 
-- /Since: 7.0.0/
type PaintPopTransformFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopTransformFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopTransformFuncT_WithClosures`@.
noPaintPopTransformFuncT_WithClosures :: Maybe PaintPopTransformFuncT_WithClosures
noPaintPopTransformFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPopTransformFuncT :: PaintPopTransformFuncT -> PaintPopTransformFuncT_WithClosures
drop_closures_PaintPopTransformFuncT _f funcs paintData _ = _f funcs paintData

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPopTransformFuncT :: MonadIO m => PaintPopTransformFuncT -> m (GClosure C_PaintPopTransformFuncT)
genClosure_PaintPopTransformFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPopTransformFuncT cb
    let cb'' = wrap_PaintPopTransformFuncT Nothing cb'
    mk_PaintPopTransformFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPopTransformFuncT` into a `C_PaintPopTransformFuncT`.
wrap_PaintPopTransformFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPopTransformFuncT)) ->
    PaintPopTransformFuncT_WithClosures ->
    C_PaintPopTransformFuncT
wrap_PaintPopTransformFuncT gi'funptrptr gi'cb funcs paintData userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        gi'cb  funcs' paintData userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintPopGroupFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "mode"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "paint_composite_mode_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the compositing mode to use"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_pop_group_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to undo\nthe effect of a prior call to the #hb_paint_funcs_push_group_func_t\nvfunc.\n\nThis call stops the redirection to the intermediate surface,\nand then composites it on the previous surface, using the\ncompositing mode passed to this call."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPopGroupFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    CUInt ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "paint_composite_mode_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the compositing mode to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_pop_group_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPopGroupFuncT :: FunPtr C_PaintPopGroupFuncT -> C_PaintPopGroupFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPopGroupFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPopGroupFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.Enums.PaintCompositeModeT
    -- ^ /@mode@/: the compositing mode to use
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopGroupFunc'
    -> m ()
dynamic_PaintPopGroupFuncT __funPtr funcs paintData mode userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    let mode' = (fromIntegral . fromEnum) mode
    (__dynamic_C_PaintPopGroupFuncT __funPtr) funcs' paintData mode' userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPopGroupFuncT`.
foreign import ccall "wrapper"
    mk_PaintPopGroupFuncT :: C_PaintPopGroupFuncT -> IO (FunPtr C_PaintPopGroupFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_group_func_t/@
-- vfunc.
-- 
-- This call stops the redirection to the intermediate surface,
-- and then composites it on the previous surface, using the
-- compositing mode passed to this call.
-- 
-- /Since: 7.0.0/
type PaintPopGroupFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.Enums.PaintCompositeModeT
    -- ^ /@mode@/: the compositing mode to use
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopGroupFuncT`@.
noPaintPopGroupFuncT :: Maybe PaintPopGroupFuncT
noPaintPopGroupFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_group_func_t/@
-- vfunc.
-- 
-- This call stops the redirection to the intermediate surface,
-- and then composites it on the previous surface, using the
-- compositing mode passed to this call.
-- 
-- /Since: 7.0.0/
type PaintPopGroupFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.Enums.PaintCompositeModeT
    -- ^ /@mode@/: the compositing mode to use
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopGroupFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopGroupFuncT_WithClosures`@.
noPaintPopGroupFuncT_WithClosures :: Maybe PaintPopGroupFuncT_WithClosures
noPaintPopGroupFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPopGroupFuncT :: PaintPopGroupFuncT -> PaintPopGroupFuncT_WithClosures
drop_closures_PaintPopGroupFuncT _f funcs paintData mode _ = _f funcs paintData mode

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPopGroupFuncT :: MonadIO m => PaintPopGroupFuncT -> m (GClosure C_PaintPopGroupFuncT)
genClosure_PaintPopGroupFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPopGroupFuncT cb
    let cb'' = wrap_PaintPopGroupFuncT Nothing cb'
    mk_PaintPopGroupFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPopGroupFuncT` into a `C_PaintPopGroupFuncT`.
wrap_PaintPopGroupFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPopGroupFuncT)) ->
    PaintPopGroupFuncT_WithClosures ->
    C_PaintPopGroupFuncT
wrap_PaintPopGroupFuncT gi'funptrptr gi'cb funcs paintData mode userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        let mode' = (toEnum . fromIntegral) mode
        gi'cb  funcs' paintData mode' userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintPopClipFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_pop_clip_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to undo\nthe effect of a prior call to the #hb_paint_funcs_push_clip_glyph_func_t\nor #hb_paint_funcs_push_clip_rectangle_func_t vfuncs."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintPopClipFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_pop_clip_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintPopClipFuncT :: FunPtr C_PaintPopClipFuncT -> C_PaintPopClipFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintPopClipFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintPopClipFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopClipFunc'
    -> m ()
dynamic_PaintPopClipFuncT __funPtr funcs paintData userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    (__dynamic_C_PaintPopClipFuncT __funPtr) funcs' paintData userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintPopClipFuncT`.
foreign import ccall "wrapper"
    mk_PaintPopClipFuncT :: C_PaintPopClipFuncT -> IO (FunPtr C_PaintPopClipFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_clip_glyph_func_t/@
-- or @/hb_paint_funcs_push_clip_rectangle_func_t/@ vfuncs.
-- 
-- /Since: 7.0.0/
type PaintPopClipFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopClipFuncT`@.
noPaintPopClipFuncT :: Maybe PaintPopClipFuncT
noPaintPopClipFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to undo
-- the effect of a prior call to the @/hb_paint_funcs_push_clip_glyph_func_t/@
-- or @/hb_paint_funcs_push_clip_rectangle_func_t/@ vfuncs.
-- 
-- /Since: 7.0.0/
type PaintPopClipFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopClipFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintPopClipFuncT_WithClosures`@.
noPaintPopClipFuncT_WithClosures :: Maybe PaintPopClipFuncT_WithClosures
noPaintPopClipFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintPopClipFuncT :: PaintPopClipFuncT -> PaintPopClipFuncT_WithClosures
drop_closures_PaintPopClipFuncT _f funcs paintData _ = _f funcs paintData

-- | Wrap the callback into a `GClosure`.
genClosure_PaintPopClipFuncT :: MonadIO m => PaintPopClipFuncT -> m (GClosure C_PaintPopClipFuncT)
genClosure_PaintPopClipFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintPopClipFuncT cb
    let cb'' = wrap_PaintPopClipFuncT Nothing cb'
    mk_PaintPopClipFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintPopClipFuncT` into a `C_PaintPopClipFuncT`.
wrap_PaintPopClipFuncT :: 
    Maybe (Ptr (FunPtr C_PaintPopClipFuncT)) ->
    PaintPopClipFuncT_WithClosures ->
    C_PaintPopClipFuncT
wrap_PaintPopClipFuncT gi'funptrptr gi'cb funcs paintData userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        gi'cb  funcs' paintData userData
        maybeReleaseFunPtr gi'funptrptr


-- callback PaintLinearGradientFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_line"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Color information for the gradient"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the first point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y0"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the first point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x1"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the second point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y1"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the second point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x2"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X coordinate of the third point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y2"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y coordinate of the third point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_linear_gradient_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to paint a linear\ngradient everywhere within the current clip.\n\nThe @color_line object contains information about the colors of the gradients.\nIt is only valid for the duration of the callback, you cannot keep it around.\n\nThe coordinates of the points are interpreted according\nto the current transform.\n\nSee the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\nsection for details on how the points define the direction\nof the gradient, and how to interpret the @color_line."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintLinearGradientFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.ColorLineT.ColorLineT ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_line"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Color information for the gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the first point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y0"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the first point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x1"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the second point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y1"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the second point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x2"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the third point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y2"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the third point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_linear_gradient_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintLinearGradientFuncT :: FunPtr C_PaintLinearGradientFuncT -> C_PaintLinearGradientFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintLinearGradientFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintLinearGradientFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first point
    -> Float
    -- ^ /@y0@/: Y coordinate of the first point
    -> Float
    -- ^ /@x1@/: X coordinate of the second point
    -> Float
    -- ^ /@y1@/: Y coordinate of the second point
    -> Float
    -- ^ /@x2@/: X coordinate of the third point
    -> Float
    -- ^ /@y2@/: Y coordinate of the third point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetLinearGradientFunc'
    -> m ()
dynamic_PaintLinearGradientFuncT __funPtr funcs paintData colorLine x0 y0 x1 y1 x2 y2 userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    colorLine' <- unsafeManagedPtrGetPtr colorLine
    let x0' = realToFrac x0
    let y0' = realToFrac y0
    let x1' = realToFrac x1
    let y1' = realToFrac y1
    let x2' = realToFrac x2
    let y2' = realToFrac y2
    (__dynamic_C_PaintLinearGradientFuncT __funPtr) funcs' paintData colorLine' x0' y0' x1' y1' x2' y2' userData
    touchManagedPtr funcs
    touchManagedPtr colorLine
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintLinearGradientFuncT`.
foreign import ccall "wrapper"
    mk_PaintLinearGradientFuncT :: C_PaintLinearGradientFuncT -> IO (FunPtr C_PaintLinearGradientFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a linear
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintLinearGradientFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first point
    -> Float
    -- ^ /@y0@/: Y coordinate of the first point
    -> Float
    -- ^ /@x1@/: X coordinate of the second point
    -> Float
    -- ^ /@y1@/: Y coordinate of the second point
    -> Float
    -- ^ /@x2@/: X coordinate of the third point
    -> Float
    -- ^ /@y2@/: Y coordinate of the third point
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintLinearGradientFuncT`@.
noPaintLinearGradientFuncT :: Maybe PaintLinearGradientFuncT
noPaintLinearGradientFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a linear
-- gradient everywhere within the current clip.
-- 
-- The /@colorLine@/ object contains information about the colors of the gradients.
-- It is only valid for the duration of the callback, you cannot keep it around.
-- 
-- The coordinates of the points are interpreted according
-- to the current transform.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details on how the points define the direction
-- of the gradient, and how to interpret the /@colorLine@/.
-- 
-- /Since: 7.0.0/
type PaintLinearGradientFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: Color information for the gradient
    -> Float
    -- ^ /@x0@/: X coordinate of the first point
    -> Float
    -- ^ /@y0@/: Y coordinate of the first point
    -> Float
    -- ^ /@x1@/: X coordinate of the second point
    -> Float
    -- ^ /@y1@/: Y coordinate of the second point
    -> Float
    -- ^ /@x2@/: X coordinate of the third point
    -> Float
    -- ^ /@y2@/: Y coordinate of the third point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetLinearGradientFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintLinearGradientFuncT_WithClosures`@.
noPaintLinearGradientFuncT_WithClosures :: Maybe PaintLinearGradientFuncT_WithClosures
noPaintLinearGradientFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintLinearGradientFuncT :: PaintLinearGradientFuncT -> PaintLinearGradientFuncT_WithClosures
drop_closures_PaintLinearGradientFuncT _f funcs paintData colorLine x0 y0 x1 y1 x2 y2 _ = _f funcs paintData colorLine x0 y0 x1 y1 x2 y2

-- | Wrap the callback into a `GClosure`.
genClosure_PaintLinearGradientFuncT :: MonadIO m => PaintLinearGradientFuncT -> m (GClosure C_PaintLinearGradientFuncT)
genClosure_PaintLinearGradientFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintLinearGradientFuncT cb
    let cb'' = wrap_PaintLinearGradientFuncT Nothing cb'
    mk_PaintLinearGradientFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintLinearGradientFuncT` into a `C_PaintLinearGradientFuncT`.
wrap_PaintLinearGradientFuncT :: 
    Maybe (Ptr (FunPtr C_PaintLinearGradientFuncT)) ->
    PaintLinearGradientFuncT_WithClosures ->
    C_PaintLinearGradientFuncT
wrap_PaintLinearGradientFuncT gi'funptrptr gi'cb funcs paintData colorLine x0 y0 x1 y1 x2 y2 userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  colorLine $ \colorLine' -> do
            let x0' = realToFrac x0
            let y0' = realToFrac y0
            let x1' = realToFrac x1
            let y1' = realToFrac y1
            let x2' = realToFrac x2
            let y2' = realToFrac y2
            gi'cb  funcs' paintData colorLine' x0' y0' x1' y1' x2' y2' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback PaintImageFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "Whether the operation was successful."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "image"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "blob_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the image data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "width of the raster image in pixels, or 0"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "height of the raster image in pixels, or 0"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "format"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the image format as a tag"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "slant"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Deprecated. Always set to 0.0."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "extents"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "glyph_extents_t" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "glyph extents for desired rendering"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data pointer passed to hb_paint_funcs_set_image_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to paint a glyph image.\n\nThis method is called for glyphs with image blobs in the CBDT,\nsbix or SVG tables. The @format identifies the kind of data that\nis contained in @image. Possible values include #HB_PAINT_IMAGE_FORMAT_PNG,\n#HB_PAINT_IMAGE_FORMAT_SVG and #HB_PAINT_IMAGE_FORMAT_BGRA.\n\nThe image dimensions and glyph extents are provided if available,\nand should be used to size and position the image."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintImageFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.BlobT.BlobT ->
    Word32 ->
    Word32 ->
    Word32 ->
    CFloat ->
    Ptr HarfBuzz.GlyphExtentsT.GlyphExtentsT ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "image"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "blob_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the image data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width of the raster image in pixels, or 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height of the raster image in pixels, or 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the image format as a tag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "slant"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Deprecated. Always set to 0.0."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "extents"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "glyph_extents_t" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "glyph extents for desired rendering"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data pointer passed to hb_paint_funcs_set_image_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintImageFuncT :: FunPtr C_PaintImageFuncT -> C_PaintImageFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintImageFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintImageFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.BlobT.BlobT
    -- ^ /@image@/: the image data
    -> Word32
    -- ^ /@width@/: width of the raster image in pixels, or 0
    -> Word32
    -- ^ /@height@/: height of the raster image in pixels, or 0
    -> Word32
    -- ^ /@format@/: the image format as a tag
    -> Float
    -- ^ /@slant@/: Deprecated. Always set to 0.0.
    -> Maybe (HarfBuzz.GlyphExtentsT.GlyphExtentsT)
    -- ^ /@extents@/: glyph extents for desired rendering
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetImageFunc'
    -> m Int32
    -- ^ __Returns:__ Whether the operation was successful.
dynamic_PaintImageFuncT __funPtr funcs paintData image width height format slant extents userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    image' <- unsafeManagedPtrGetPtr image
    let slant' = realToFrac slant
    maybeExtents <- case extents of
        Nothing -> return FP.nullPtr
        Just jExtents -> do
            jExtents' <- unsafeManagedPtrGetPtr jExtents
            return jExtents'
    result <- (__dynamic_C_PaintImageFuncT __funPtr) funcs' paintData image' width height format slant' maybeExtents userData
    touchManagedPtr funcs
    touchManagedPtr image
    whenJust extents touchManagedPtr
    return result

-- | Generate a function pointer callable from C code, from a `C_PaintImageFuncT`.
foreign import ccall "wrapper"
    mk_PaintImageFuncT :: C_PaintImageFuncT -> IO (FunPtr C_PaintImageFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a glyph image.
-- 
-- This method is called for glyphs with image blobs in the CBDT,
-- sbix or SVG tables. The /@format@/ identifies the kind of data that
-- is contained in /@image@/. Possible values include @/HB_PAINT_IMAGE_FORMAT_PNG/@,
-- @/HB_PAINT_IMAGE_FORMAT_SVG/@ and @/HB_PAINT_IMAGE_FORMAT_BGRA/@.
-- 
-- The image dimensions and glyph extents are provided if available,
-- and should be used to size and position the image.
-- 
-- /Since: 7.0.0/
type PaintImageFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.BlobT.BlobT
    -- ^ /@image@/: the image data
    -> Word32
    -- ^ /@width@/: width of the raster image in pixels, or 0
    -> Word32
    -- ^ /@height@/: height of the raster image in pixels, or 0
    -> Word32
    -- ^ /@format@/: the image format as a tag
    -> Float
    -- ^ /@slant@/: Deprecated. Always set to 0.0.
    -> Maybe HarfBuzz.GlyphExtentsT.GlyphExtentsT
    -- ^ /@extents@/: glyph extents for desired rendering
    -> IO Int32
    -- ^ __Returns:__ Whether the operation was successful.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintImageFuncT`@.
noPaintImageFuncT :: Maybe PaintImageFuncT
noPaintImageFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a glyph image.
-- 
-- This method is called for glyphs with image blobs in the CBDT,
-- sbix or SVG tables. The /@format@/ identifies the kind of data that
-- is contained in /@image@/. Possible values include @/HB_PAINT_IMAGE_FORMAT_PNG/@,
-- @/HB_PAINT_IMAGE_FORMAT_SVG/@ and @/HB_PAINT_IMAGE_FORMAT_BGRA/@.
-- 
-- The image dimensions and glyph extents are provided if available,
-- and should be used to size and position the image.
-- 
-- /Since: 7.0.0/
type PaintImageFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> HarfBuzz.BlobT.BlobT
    -- ^ /@image@/: the image data
    -> Word32
    -- ^ /@width@/: width of the raster image in pixels, or 0
    -> Word32
    -- ^ /@height@/: height of the raster image in pixels, or 0
    -> Word32
    -- ^ /@format@/: the image format as a tag
    -> Float
    -- ^ /@slant@/: Deprecated. Always set to 0.0.
    -> Maybe HarfBuzz.GlyphExtentsT.GlyphExtentsT
    -- ^ /@extents@/: glyph extents for desired rendering
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetImageFunc'
    -> IO Int32
    -- ^ __Returns:__ Whether the operation was successful.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintImageFuncT_WithClosures`@.
noPaintImageFuncT_WithClosures :: Maybe PaintImageFuncT_WithClosures
noPaintImageFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintImageFuncT :: PaintImageFuncT -> PaintImageFuncT_WithClosures
drop_closures_PaintImageFuncT _f funcs paintData image width height format slant extents _ = _f funcs paintData image width height format slant extents

-- | Wrap the callback into a `GClosure`.
genClosure_PaintImageFuncT :: MonadIO m => PaintImageFuncT -> m (GClosure C_PaintImageFuncT)
genClosure_PaintImageFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintImageFuncT cb
    let cb'' = wrap_PaintImageFuncT Nothing cb'
    mk_PaintImageFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintImageFuncT` into a `C_PaintImageFuncT`.
wrap_PaintImageFuncT :: 
    Maybe (Ptr (FunPtr C_PaintImageFuncT)) ->
    PaintImageFuncT_WithClosures ->
    C_PaintImageFuncT
wrap_PaintImageFuncT gi'funptrptr gi'cb funcs paintData image width height format slant extents userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  image $ \image' -> do
            let slant' = realToFrac slant
            maybeExtents <-
                if extents == FP.nullPtr
                then return Nothing
                else do
                    extents' <- (newPtr HarfBuzz.GlyphExtentsT.GlyphExtentsT) extents
                    return $ Just extents'
            result <- gi'cb  funcs' paintData image' width height format slant' maybeExtents userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback PaintCustomPaletteColorFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_index"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the color index" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "fetched color" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_pop_group_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to fetch a color from the custom\ncolor palette.\n\nCustom palette colors override the colors from the fonts selected color\npalette. It is not necessary to override all palette entries; for entries\nthat should be taken from the font palette, return `false`.\n\nThis function might get called multiple times, but the custom palette is\nexpected to remain unchanged for duration of a hb_font_paint_glyph() call."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintCustomPaletteColorFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_index"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the color index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fetched color" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_pop_group_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintCustomPaletteColorFuncT :: FunPtr C_PaintCustomPaletteColorFuncT -> C_PaintCustomPaletteColorFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintCustomPaletteColorFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintCustomPaletteColorFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@colorIndex@/: the color index
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopGroupFunc'
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ if found, @false@ otherwise
dynamic_PaintCustomPaletteColorFuncT __funPtr funcs paintData colorIndex userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    color <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_PaintCustomPaletteColorFuncT __funPtr) funcs' paintData colorIndex color userData
    color' <- peek color
    touchManagedPtr funcs
    freeMem color
    return (result, color')

-- | Generate a function pointer callable from C code, from a `C_PaintCustomPaletteColorFuncT`.
foreign import ccall "wrapper"
    mk_PaintCustomPaletteColorFuncT :: C_PaintCustomPaletteColorFuncT -> IO (FunPtr C_PaintCustomPaletteColorFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to fetch a color from the custom
-- color palette.
-- 
-- Custom palette colors override the colors from the fonts selected color
-- palette. It is not necessary to override all palette entries; for entries
-- that should be taken from the font palette, return @false@.
-- 
-- This function might get called multiple times, but the custom palette is
-- expected to remain unchanged for duration of a 'GI.HarfBuzz.Functions.fontPaintGlyph' call.
-- 
-- /Since: 7.0.0/
type PaintCustomPaletteColorFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@colorIndex@/: the color index
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintCustomPaletteColorFuncT`@.
noPaintCustomPaletteColorFuncT :: Maybe PaintCustomPaletteColorFuncT
noPaintCustomPaletteColorFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to fetch a color from the custom
-- color palette.
-- 
-- Custom palette colors override the colors from the fonts selected color
-- palette. It is not necessary to override all palette entries; for entries
-- that should be taken from the font palette, return @false@.
-- 
-- This function might get called multiple times, but the custom palette is
-- expected to remain unchanged for duration of a 'GI.HarfBuzz.Functions.fontPaintGlyph' call.
-- 
-- /Since: 7.0.0/
type PaintCustomPaletteColorFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@colorIndex@/: the color index
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetPopGroupFunc'
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintCustomPaletteColorFuncT_WithClosures`@.
noPaintCustomPaletteColorFuncT_WithClosures :: Maybe PaintCustomPaletteColorFuncT_WithClosures
noPaintCustomPaletteColorFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintCustomPaletteColorFuncT :: PaintCustomPaletteColorFuncT -> PaintCustomPaletteColorFuncT_WithClosures
drop_closures_PaintCustomPaletteColorFuncT _f funcs paintData colorIndex _ = _f funcs paintData colorIndex

-- | Wrap the callback into a `GClosure`.
genClosure_PaintCustomPaletteColorFuncT :: MonadIO m => PaintCustomPaletteColorFuncT -> m (GClosure C_PaintCustomPaletteColorFuncT)
genClosure_PaintCustomPaletteColorFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintCustomPaletteColorFuncT cb
    let cb'' = wrap_PaintCustomPaletteColorFuncT Nothing cb'
    mk_PaintCustomPaletteColorFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintCustomPaletteColorFuncT` into a `C_PaintCustomPaletteColorFuncT`.
wrap_PaintCustomPaletteColorFuncT :: 
    Maybe (Ptr (FunPtr C_PaintCustomPaletteColorFuncT)) ->
    PaintCustomPaletteColorFuncT_WithClosures ->
    C_PaintCustomPaletteColorFuncT
wrap_PaintCustomPaletteColorFuncT gi'funptrptr gi'cb funcs paintData colorIndex color userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        (result, outcolor) <- gi'cb  funcs' paintData colorIndex userData
        poke color outcolor
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback PaintColorGlyphFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "`true` if the glyph was painted, `false` otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the glyph ID" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the font" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_paint_funcs_set_color_glyph_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to render a color glyph by glyph index."
        , sinceVersion = Just "8.2.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintColorGlyphFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the glyph ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the font" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_paint_funcs_set_color_glyph_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintColorGlyphFuncT :: FunPtr C_PaintColorGlyphFuncT -> C_PaintColorGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintColorGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintColorGlyphFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetColorGlyphFunc'
    -> m Int32
    -- ^ __Returns:__ @true@ if the glyph was painted, @false@ otherwise.
dynamic_PaintColorGlyphFuncT __funPtr funcs paintData glyph font userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    font' <- unsafeManagedPtrGetPtr font
    result <- (__dynamic_C_PaintColorGlyphFuncT __funPtr) funcs' paintData glyph font' userData
    touchManagedPtr funcs
    touchManagedPtr font
    return result

-- | Generate a function pointer callable from C code, from a `C_PaintColorGlyphFuncT`.
foreign import ccall "wrapper"
    mk_PaintColorGlyphFuncT :: C_PaintColorGlyphFuncT -> IO (FunPtr C_PaintColorGlyphFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to render a color glyph by glyph index.
-- 
-- /Since: 8.2.0/
type PaintColorGlyphFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> IO Int32
    -- ^ __Returns:__ @true@ if the glyph was painted, @false@ otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintColorGlyphFuncT`@.
noPaintColorGlyphFuncT :: Maybe PaintColorGlyphFuncT
noPaintColorGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to render a color glyph by glyph index.
-- 
-- /Since: 8.2.0/
type PaintColorGlyphFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Word32
    -- ^ /@glyph@/: the glyph ID
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: the font
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetColorGlyphFunc'
    -> IO Int32
    -- ^ __Returns:__ @true@ if the glyph was painted, @false@ otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintColorGlyphFuncT_WithClosures`@.
noPaintColorGlyphFuncT_WithClosures :: Maybe PaintColorGlyphFuncT_WithClosures
noPaintColorGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintColorGlyphFuncT :: PaintColorGlyphFuncT -> PaintColorGlyphFuncT_WithClosures
drop_closures_PaintColorGlyphFuncT _f funcs paintData glyph font _ = _f funcs paintData glyph font

-- | Wrap the callback into a `GClosure`.
genClosure_PaintColorGlyphFuncT :: MonadIO m => PaintColorGlyphFuncT -> m (GClosure C_PaintColorGlyphFuncT)
genClosure_PaintColorGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintColorGlyphFuncT cb
    let cb'' = wrap_PaintColorGlyphFuncT Nothing cb'
    mk_PaintColorGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintColorGlyphFuncT` into a `C_PaintColorGlyphFuncT`.
wrap_PaintColorGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_PaintColorGlyphFuncT)) ->
    PaintColorGlyphFuncT_WithClosures ->
    C_PaintColorGlyphFuncT
wrap_PaintColorGlyphFuncT gi'funptrptr gi'cb funcs paintData glyph font userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        B.ManagedPtr.withTransient  font $ \font' -> do
            result <- gi'cb  funcs' paintData glyph font' userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback PaintColorFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "paint functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the paint functions in hb_font_paint_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "is_foreground"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "whether the color is the foreground"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The color to use, unpremultiplied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data pointer passed to hb_paint_funcs_set_color_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_paint_funcs_t to paint a\ncolor everywhere within the current clip."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PaintColorFuncT =
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Int32 ->
    Word32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "paint functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the paint functions in hb_font_paint_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_foreground"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the color is the foreground"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The color to use, unpremultiplied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data pointer passed to hb_paint_funcs_set_color_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PaintColorFuncT :: FunPtr C_PaintColorFuncT -> C_PaintColorFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PaintColorFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PaintColorFuncT
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Int32
    -- ^ /@isForeground@/: whether the color is the foreground
    -> Word32
    -- ^ /@color@/: The color to use, unpremultiplied
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetColorFunc'
    -> m ()
dynamic_PaintColorFuncT __funPtr funcs paintData isForeground color userData = liftIO $ do
    funcs' <- unsafeManagedPtrGetPtr funcs
    (__dynamic_C_PaintColorFuncT __funPtr) funcs' paintData isForeground color userData
    touchManagedPtr funcs
    return ()

-- | Generate a function pointer callable from C code, from a `C_PaintColorFuncT`.
foreign import ccall "wrapper"
    mk_PaintColorFuncT :: C_PaintColorFuncT -> IO (FunPtr C_PaintColorFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a
-- color everywhere within the current clip.
-- 
-- /Since: 7.0.0/
type PaintColorFuncT =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Int32
    -- ^ /@isForeground@/: whether the color is the foreground
    -> Word32
    -- ^ /@color@/: The color to use, unpremultiplied
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintColorFuncT`@.
noPaintColorFuncT :: Maybe PaintColorFuncT
noPaintColorFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.PaintFuncsT.PaintFuncsT' to paint a
-- color everywhere within the current clip.
-- 
-- /Since: 7.0.0/
type PaintColorFuncT_WithClosures =
    HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@funcs@/: paint functions object
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions in 'GI.HarfBuzz.Functions.fontPaintGlyph'
    -> Int32
    -- ^ /@isForeground@/: whether the color is the foreground
    -> Word32
    -- ^ /@color@/: The color to use, unpremultiplied
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.paintFuncsSetColorFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PaintColorFuncT_WithClosures`@.
noPaintColorFuncT_WithClosures :: Maybe PaintColorFuncT_WithClosures
noPaintColorFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PaintColorFuncT :: PaintColorFuncT -> PaintColorFuncT_WithClosures
drop_closures_PaintColorFuncT _f funcs paintData isForeground color _ = _f funcs paintData isForeground color

-- | Wrap the callback into a `GClosure`.
genClosure_PaintColorFuncT :: MonadIO m => PaintColorFuncT -> m (GClosure C_PaintColorFuncT)
genClosure_PaintColorFuncT cb = liftIO $ do
    let cb' = drop_closures_PaintColorFuncT cb
    let cb'' = wrap_PaintColorFuncT Nothing cb'
    mk_PaintColorFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PaintColorFuncT` into a `C_PaintColorFuncT`.
wrap_PaintColorFuncT :: 
    Maybe (Ptr (FunPtr C_PaintColorFuncT)) ->
    PaintColorFuncT_WithClosures ->
    C_PaintColorFuncT
wrap_PaintColorFuncT gi'funptrptr gi'cb funcs paintData isForeground color userData = do
    B.ManagedPtr.withTransient  funcs $ \funcs' -> do
        gi'cb  funcs' paintData isForeground color userData
        maybeReleaseFunPtr gi'funptrptr


-- callback GetTableTagsFuncT
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "Total number of tables, or zero if it is not possible to list"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "face"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "face_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A face object" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "start_offset"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The index of first table tag to retrieve"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "table_count"
          , argType = TBasicType TUInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Input = the maximum number of table tags to return;\n               Output = the actual number of table tags returned (may be zero)"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "table_tags"
          , argType = TCArray False (-1) 2 (TBasicType TUInt32)
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The array of table tags found"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Callback function for hb_face_get_table_tags()."
        , sinceVersion = Just "10.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_GetTableTagsFuncT =
    Ptr HarfBuzz.FaceT.FaceT ->
    Word32 ->
    Ptr Word32 ->
    Ptr (Ptr Word32) ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "face"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "face_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A face object" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_offset"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The index of first table tag to retrieve"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "table_count"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Input = the maximum number of table tags to return;\n               Output = the actual number of table tags returned (may be zero)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "table_tags"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt32)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The array of table tags found"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "table_count"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "Input = the maximum number of table tags to return;\n               Output = the actual number of table tags returned (may be zero)"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_GetTableTagsFuncT :: FunPtr C_GetTableTagsFuncT -> C_GetTableTagsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_GetTableTagsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_GetTableTagsFuncT
    -> HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: A face object
    -> Word32
    -- ^ /@startOffset@/: The index of first table tag to retrieve
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Word32, [Word32]))
    -- ^ __Returns:__ Total number of tables, or zero if it is not possible to list
dynamic_GetTableTagsFuncT __funPtr face startOffset userData = liftIO $ do
    face' <- unsafeManagedPtrGetPtr face
    tableCount <- allocMem :: IO (Ptr Word32)
    tableTags <- callocMem :: IO (Ptr (Ptr Word32))
    result <- (__dynamic_C_GetTableTagsFuncT __funPtr) face' startOffset tableCount tableTags userData
    tableCount' <- peek tableCount
    tableTags' <- peek tableTags
    tableTags'' <- (unpackStorableArrayWithLength tableCount') tableTags'
    freeMem tableTags'
    touchManagedPtr face
    freeMem tableCount
    freeMem tableTags
    return (result, tableTags'')

-- | Generate a function pointer callable from C code, from a `C_GetTableTagsFuncT`.
foreign import ccall "wrapper"
    mk_GetTableTagsFuncT :: C_GetTableTagsFuncT -> IO (FunPtr C_GetTableTagsFuncT)

-- | Callback function for 'GI.HarfBuzz.Functions.faceGetTableTags'.
-- 
-- /Since: 10.0.0/
type GetTableTagsFuncT =
    HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: A face object
    -> Word32
    -- ^ /@startOffset@/: The index of first table tag to retrieve
    -> IO ((Word32, [Word32]))
    -- ^ __Returns:__ Total number of tables, or zero if it is not possible to list

-- | A convenience synonym for @`Nothing` :: `Maybe` `GetTableTagsFuncT`@.
noGetTableTagsFuncT :: Maybe GetTableTagsFuncT
noGetTableTagsFuncT = Nothing

-- | Callback function for 'GI.HarfBuzz.Functions.faceGetTableTags'.
-- 
-- /Since: 10.0.0/
type GetTableTagsFuncT_WithClosures =
    HarfBuzz.FaceT.FaceT
    -- ^ /@face@/: A face object
    -> Word32
    -- ^ /@startOffset@/: The index of first table tag to retrieve
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Word32, [Word32]))
    -- ^ __Returns:__ Total number of tables, or zero if it is not possible to list

-- | A convenience synonym for @`Nothing` :: `Maybe` `GetTableTagsFuncT_WithClosures`@.
noGetTableTagsFuncT_WithClosures :: Maybe GetTableTagsFuncT_WithClosures
noGetTableTagsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_GetTableTagsFuncT :: GetTableTagsFuncT -> GetTableTagsFuncT_WithClosures
drop_closures_GetTableTagsFuncT _f face startOffset _ = _f face startOffset

-- | Wrap the callback into a `GClosure`.
genClosure_GetTableTagsFuncT :: MonadIO m => GetTableTagsFuncT -> m (GClosure C_GetTableTagsFuncT)
genClosure_GetTableTagsFuncT cb = liftIO $ do
    let cb' = drop_closures_GetTableTagsFuncT cb
    let cb'' = wrap_GetTableTagsFuncT Nothing cb'
    mk_GetTableTagsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `GetTableTagsFuncT` into a `C_GetTableTagsFuncT`.
wrap_GetTableTagsFuncT :: 
    Maybe (Ptr (FunPtr C_GetTableTagsFuncT)) ->
    GetTableTagsFuncT_WithClosures ->
    C_GetTableTagsFuncT
wrap_GetTableTagsFuncT gi'funptrptr gi'cb face startOffset tableCount tableTags userData = do
    B.ManagedPtr.withTransient  face $ \face' -> do
        (result, outtableTags) <- gi'cb  face' startOffset userData
        outtableTags' <- packStorableArray outtableTags
        poke tableTags outtableTags'
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontPaintGlyphOrFailFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "`true` if glyph was painted, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The paint functions to use"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The data accompanying the paint functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "palette_index"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The color palette to use"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "foreground"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The foreground color"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object."
        , sinceVersion = Just "11.2.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontPaintGlyphOrFailFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The paint functions to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The data accompanying the paint functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "palette_index"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The color palette to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "foreground"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The foreground color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontPaintGlyphOrFailFuncT :: FunPtr C_FontPaintGlyphOrFailFuncT -> C_FontPaintGlyphOrFailFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontPaintGlyphOrFailFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontPaintGlyphOrFailFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
    -- ^ __Returns:__ @true@ if glyph was painted, @false@ otherwise
dynamic_FontPaintGlyphOrFailFuncT __funPtr font fontData glyph paintFuncs paintData paletteIndex foreground userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    paintFuncs' <- unsafeManagedPtrGetPtr paintFuncs
    result <- (__dynamic_C_FontPaintGlyphOrFailFuncT __funPtr) font' fontData glyph paintFuncs' paintData paletteIndex foreground userData
    touchManagedPtr font
    touchManagedPtr paintFuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_FontPaintGlyphOrFailFuncT`.
foreign import ccall "wrapper"
    mk_FontPaintGlyphOrFailFuncT :: C_FontPaintGlyphOrFailFuncT -> IO (FunPtr C_FontPaintGlyphOrFailFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 11.2.0/
type FontPaintGlyphOrFailFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> IO Int32
    -- ^ __Returns:__ @true@ if glyph was painted, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontPaintGlyphOrFailFuncT`@.
noFontPaintGlyphOrFailFuncT :: Maybe FontPaintGlyphOrFailFuncT
noFontPaintGlyphOrFailFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 11.2.0/
type FontPaintGlyphOrFailFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32
    -- ^ __Returns:__ @true@ if glyph was painted, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontPaintGlyphOrFailFuncT_WithClosures`@.
noFontPaintGlyphOrFailFuncT_WithClosures :: Maybe FontPaintGlyphOrFailFuncT_WithClosures
noFontPaintGlyphOrFailFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontPaintGlyphOrFailFuncT :: FontPaintGlyphOrFailFuncT -> FontPaintGlyphOrFailFuncT_WithClosures
drop_closures_FontPaintGlyphOrFailFuncT _f font fontData glyph paintFuncs paintData paletteIndex foreground _ = _f font fontData glyph paintFuncs paintData paletteIndex foreground

-- | Wrap the callback into a `GClosure`.
genClosure_FontPaintGlyphOrFailFuncT :: MonadIO m => FontPaintGlyphOrFailFuncT -> m (GClosure C_FontPaintGlyphOrFailFuncT)
genClosure_FontPaintGlyphOrFailFuncT cb = liftIO $ do
    let cb' = drop_closures_FontPaintGlyphOrFailFuncT cb
    let cb'' = wrap_FontPaintGlyphOrFailFuncT Nothing cb'
    mk_FontPaintGlyphOrFailFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontPaintGlyphOrFailFuncT` into a `C_FontPaintGlyphOrFailFuncT`.
wrap_FontPaintGlyphOrFailFuncT :: 
    Maybe (Ptr (FunPtr C_FontPaintGlyphOrFailFuncT)) ->
    FontPaintGlyphOrFailFuncT_WithClosures ->
    C_FontPaintGlyphOrFailFuncT
wrap_FontPaintGlyphOrFailFuncT gi'funptrptr gi'cb font fontData glyph paintFuncs paintData paletteIndex foreground userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        B.ManagedPtr.withTransient  paintFuncs $ \paintFuncs' -> do
            result <- gi'cb  font' fontData glyph paintFuncs' paintData paletteIndex foreground userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback FontPaintGlyphFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The paint functions to use"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "paint_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The data accompanying the paint functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "palette_index"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The color palette to use"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "foreground"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The foreground color"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "11.2.0"
          , deprecationMessage =
              Just "Use hb_font_paint_glyph_or_fail_func_t instead."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontPaintGlyphFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.PaintFuncsT.PaintFuncsT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "paint_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The paint functions to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paint_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The data accompanying the paint functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "palette_index"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The color palette to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "foreground"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The foreground color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontPaintGlyphFuncT :: FunPtr C_FontPaintGlyphFuncT -> C_FontPaintGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontPaintGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontPaintGlyphFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
dynamic_FontPaintGlyphFuncT __funPtr font fontData glyph paintFuncs paintData paletteIndex foreground userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    paintFuncs' <- unsafeManagedPtrGetPtr paintFuncs
    result <- (__dynamic_C_FontPaintGlyphFuncT __funPtr) font' fontData glyph paintFuncs' paintData paletteIndex foreground userData
    touchManagedPtr font
    touchManagedPtr paintFuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_FontPaintGlyphFuncT`.
foreign import ccall "wrapper"
    mk_FontPaintGlyphFuncT :: C_FontPaintGlyphFuncT -> IO (FunPtr C_FontPaintGlyphFuncT)

{-# DEPRECATED FontPaintGlyphFuncT ["(Since version 11.2.0)","Use hb_font_paint_glyph_or_fail_func_t instead."] #-}
-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 7.0.0/
type FontPaintGlyphFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> IO Int32

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontPaintGlyphFuncT`@.
noFontPaintGlyphFuncT :: Maybe FontPaintGlyphFuncT
noFontPaintGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 7.0.0/
type FontPaintGlyphFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.PaintFuncsT.PaintFuncsT
    -- ^ /@paintFuncs@/: The paint functions to use
    -> Ptr ()
    -- ^ /@paintData@/: The data accompanying the paint functions
    -> Word32
    -- ^ /@paletteIndex@/: The color palette to use
    -> Word32
    -- ^ /@foreground@/: The foreground color
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontPaintGlyphFuncT_WithClosures`@.
noFontPaintGlyphFuncT_WithClosures :: Maybe FontPaintGlyphFuncT_WithClosures
noFontPaintGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontPaintGlyphFuncT :: FontPaintGlyphFuncT -> FontPaintGlyphFuncT_WithClosures
drop_closures_FontPaintGlyphFuncT _f font fontData glyph paintFuncs paintData paletteIndex foreground _ = _f font fontData glyph paintFuncs paintData paletteIndex foreground

-- | Wrap the callback into a `GClosure`.
genClosure_FontPaintGlyphFuncT :: MonadIO m => FontPaintGlyphFuncT -> m (GClosure C_FontPaintGlyphFuncT)
genClosure_FontPaintGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_FontPaintGlyphFuncT cb
    let cb'' = wrap_FontPaintGlyphFuncT Nothing cb'
    mk_FontPaintGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontPaintGlyphFuncT` into a `C_FontPaintGlyphFuncT`.
wrap_FontPaintGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_FontPaintGlyphFuncT)) ->
    FontPaintGlyphFuncT_WithClosures ->
    C_FontPaintGlyphFuncT
wrap_FontPaintGlyphFuncT gi'funptrptr gi'cb font fontData glyph paintFuncs paintData paletteIndex foreground userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        B.ManagedPtr.withTransient  paintFuncs $ \paintFuncs' -> do
            result <- gi'cb  font' fontData glyph paintFuncs' paintData paletteIndex foreground userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback FontGetVariationGlyphFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The Unicode code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "variation_selector"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The  variation-selector code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the glyph ID for a specified Unicode code point\nfollowed by a specified Variation Selector code point. Glyph IDs must be\nreturned in a #hb_codepoint_t output parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetVariationGlyphFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The Unicode code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variation_selector"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The  variation-selector code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetVariationGlyphFuncT :: FunPtr C_FontGetVariationGlyphFuncT -> C_FontGetVariationGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetVariationGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetVariationGlyphFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetVariationGlyphFuncT __funPtr font fontData unicode variationSelector userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    glyph <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetVariationGlyphFuncT __funPtr) font' fontData unicode variationSelector glyph userData
    glyph' <- peek glyph
    touchManagedPtr font
    freeMem glyph
    return (result, glyph')

-- | Generate a function pointer callable from C code, from a `C_FontGetVariationGlyphFuncT`.
foreign import ccall "wrapper"
    mk_FontGetVariationGlyphFuncT :: C_FontGetVariationGlyphFuncT -> IO (FunPtr C_FontGetVariationGlyphFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID for a specified Unicode code point
-- followed by a specified Variation Selector code point. Glyph IDs must be
-- returned in a @/hb_codepoint_t/@ output parameter.
type FontGetVariationGlyphFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetVariationGlyphFuncT`@.
noFontGetVariationGlyphFuncT :: Maybe FontGetVariationGlyphFuncT
noFontGetVariationGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID for a specified Unicode code point
-- followed by a specified Variation Selector code point. Glyph IDs must be
-- returned in a @/hb_codepoint_t/@ output parameter.
type FontGetVariationGlyphFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetVariationGlyphFuncT_WithClosures`@.
noFontGetVariationGlyphFuncT_WithClosures :: Maybe FontGetVariationGlyphFuncT_WithClosures
noFontGetVariationGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetVariationGlyphFuncT :: FontGetVariationGlyphFuncT -> FontGetVariationGlyphFuncT_WithClosures
drop_closures_FontGetVariationGlyphFuncT _f font fontData unicode variationSelector _ = _f font fontData unicode variationSelector

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetVariationGlyphFuncT :: MonadIO m => FontGetVariationGlyphFuncT -> m (GClosure C_FontGetVariationGlyphFuncT)
genClosure_FontGetVariationGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetVariationGlyphFuncT cb
    let cb'' = wrap_FontGetVariationGlyphFuncT Nothing cb'
    mk_FontGetVariationGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetVariationGlyphFuncT` into a `C_FontGetVariationGlyphFuncT`.
wrap_FontGetVariationGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetVariationGlyphFuncT)) ->
    FontGetVariationGlyphFuncT_WithClosures ->
    C_FontGetVariationGlyphFuncT
wrap_FontGetVariationGlyphFuncT gi'funptrptr gi'cb font fontData unicode variationSelector glyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outglyph) <- gi'cb  font' fontData unicode variationSelector userData
        poke glyph outglyph
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetNominalGlyphsFuncT
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the number of code points processed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "number of code points to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first Unicode code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The stride between successive code points"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first glyph ID retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "glyph_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The stride between successive glyph IDs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the nominal glyph IDs for a sequence of\nUnicode code points. Glyph IDs must be returned in a #hb_codepoint_t\noutput parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetNominalGlyphsFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Word32 ->
    Ptr Word32 ->
    Word32 ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of code points to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first Unicode code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stride between successive code points"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first glyph ID retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "glyph_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stride between successive glyph IDs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetNominalGlyphsFuncT :: FunPtr C_FontGetNominalGlyphsFuncT -> C_FontGetNominalGlyphsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetNominalGlyphsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetNominalGlyphsFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of code points to query
    -> Word32
    -- ^ /@firstUnicode@/: The first Unicode code point to query
    -> Word32
    -- ^ /@unicodeStride@/: The stride between successive code points
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Word32, Word32))
    -- ^ __Returns:__ the number of code points processed
dynamic_FontGetNominalGlyphsFuncT __funPtr font fontData count firstUnicode unicodeStride glyphStride userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    firstGlyph <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetNominalGlyphsFuncT __funPtr) font' fontData count firstUnicode unicodeStride firstGlyph glyphStride userData
    firstGlyph' <- peek firstGlyph
    touchManagedPtr font
    freeMem firstGlyph
    return (result, firstGlyph')

-- | Generate a function pointer callable from C code, from a `C_FontGetNominalGlyphsFuncT`.
foreign import ccall "wrapper"
    mk_FontGetNominalGlyphsFuncT :: C_FontGetNominalGlyphsFuncT -> IO (FunPtr C_FontGetNominalGlyphsFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the nominal glyph IDs for a sequence of
-- Unicode code points. Glyph IDs must be returned in a @/hb_codepoint_t/@
-- output parameter.
type FontGetNominalGlyphsFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of code points to query
    -> Word32
    -- ^ /@firstUnicode@/: The first Unicode code point to query
    -> Word32
    -- ^ /@unicodeStride@/: The stride between successive code points
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> IO ((Word32, Word32))
    -- ^ __Returns:__ the number of code points processed

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetNominalGlyphsFuncT`@.
noFontGetNominalGlyphsFuncT :: Maybe FontGetNominalGlyphsFuncT
noFontGetNominalGlyphsFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the nominal glyph IDs for a sequence of
-- Unicode code points. Glyph IDs must be returned in a @/hb_codepoint_t/@
-- output parameter.
type FontGetNominalGlyphsFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of code points to query
    -> Word32
    -- ^ /@firstUnicode@/: The first Unicode code point to query
    -> Word32
    -- ^ /@unicodeStride@/: The stride between successive code points
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Word32, Word32))
    -- ^ __Returns:__ the number of code points processed

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetNominalGlyphsFuncT_WithClosures`@.
noFontGetNominalGlyphsFuncT_WithClosures :: Maybe FontGetNominalGlyphsFuncT_WithClosures
noFontGetNominalGlyphsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetNominalGlyphsFuncT :: FontGetNominalGlyphsFuncT -> FontGetNominalGlyphsFuncT_WithClosures
drop_closures_FontGetNominalGlyphsFuncT _f font fontData count firstUnicode unicodeStride glyphStride _ = _f font fontData count firstUnicode unicodeStride glyphStride

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetNominalGlyphsFuncT :: MonadIO m => FontGetNominalGlyphsFuncT -> m (GClosure C_FontGetNominalGlyphsFuncT)
genClosure_FontGetNominalGlyphsFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetNominalGlyphsFuncT cb
    let cb'' = wrap_FontGetNominalGlyphsFuncT Nothing cb'
    mk_FontGetNominalGlyphsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetNominalGlyphsFuncT` into a `C_FontGetNominalGlyphsFuncT`.
wrap_FontGetNominalGlyphsFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetNominalGlyphsFuncT)) ->
    FontGetNominalGlyphsFuncT_WithClosures ->
    C_FontGetNominalGlyphsFuncT
wrap_FontGetNominalGlyphsFuncT gi'funptrptr gi'cb font fontData count firstUnicode unicodeStride firstGlyph glyphStride userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outfirstGlyph) <- gi'cb  font' fontData count firstUnicode unicodeStride glyphStride userData
        poke firstGlyph outfirstGlyph
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetNominalGlyphFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The Unicode code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the nominal glyph ID for a specified Unicode code\npoint. Glyph IDs must be returned in a #hb_codepoint_t output parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetNominalGlyphFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The Unicode code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetNominalGlyphFuncT :: FunPtr C_FontGetNominalGlyphFuncT -> C_FontGetNominalGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetNominalGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetNominalGlyphFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetNominalGlyphFuncT __funPtr font fontData unicode userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    glyph <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetNominalGlyphFuncT __funPtr) font' fontData unicode glyph userData
    glyph' <- peek glyph
    touchManagedPtr font
    freeMem glyph
    return (result, glyph')

-- | Generate a function pointer callable from C code, from a `C_FontGetNominalGlyphFuncT`.
foreign import ccall "wrapper"
    mk_FontGetNominalGlyphFuncT :: C_FontGetNominalGlyphFuncT -> IO (FunPtr C_FontGetNominalGlyphFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the nominal glyph ID for a specified Unicode code
-- point. Glyph IDs must be returned in a @/hb_codepoint_t/@ output parameter.
type FontGetNominalGlyphFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetNominalGlyphFuncT`@.
noFontGetNominalGlyphFuncT :: Maybe FontGetNominalGlyphFuncT
noFontGetNominalGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the nominal glyph ID for a specified Unicode code
-- point. Glyph IDs must be returned in a @/hb_codepoint_t/@ output parameter.
type FontGetNominalGlyphFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetNominalGlyphFuncT_WithClosures`@.
noFontGetNominalGlyphFuncT_WithClosures :: Maybe FontGetNominalGlyphFuncT_WithClosures
noFontGetNominalGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetNominalGlyphFuncT :: FontGetNominalGlyphFuncT -> FontGetNominalGlyphFuncT_WithClosures
drop_closures_FontGetNominalGlyphFuncT _f font fontData unicode _ = _f font fontData unicode

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetNominalGlyphFuncT :: MonadIO m => FontGetNominalGlyphFuncT -> m (GClosure C_FontGetNominalGlyphFuncT)
genClosure_FontGetNominalGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetNominalGlyphFuncT cb
    let cb'' = wrap_FontGetNominalGlyphFuncT Nothing cb'
    mk_FontGetNominalGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetNominalGlyphFuncT` into a `C_FontGetNominalGlyphFuncT`.
wrap_FontGetNominalGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetNominalGlyphFuncT)) ->
    FontGetNominalGlyphFuncT_WithClosures ->
    C_FontGetNominalGlyphFuncT
wrap_FontGetNominalGlyphFuncT gi'funptrptr gi'cb font fontData unicode glyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outglyph) <- gi'cb  font' fontData unicode userData
        poke glyph outglyph
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphShapeFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The draw functions to send the shape data to"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The data accompanying the draw functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "7.0.0"
          , deprecationMessage =
              Just "Use #hb_font_draw_glyph_func_t instead"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphShapeFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The draw functions to send the shape data to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The data accompanying the draw functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphShapeFuncT :: FunPtr C_FontGetGlyphShapeFuncT -> C_FontGetGlyphShapeFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphShapeFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphShapeFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ()
dynamic_FontGetGlyphShapeFuncT __funPtr font fontData glyph drawFuncs drawData userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    drawFuncs' <- unsafeManagedPtrGetPtr drawFuncs
    (__dynamic_C_FontGetGlyphShapeFuncT __funPtr) font' fontData glyph drawFuncs' drawData userData
    touchManagedPtr font
    touchManagedPtr drawFuncs
    return ()

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphShapeFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphShapeFuncT :: C_FontGetGlyphShapeFuncT -> IO (FunPtr C_FontGetGlyphShapeFuncT)

{-# DEPRECATED FontGetGlyphShapeFuncT ["(Since version 7.0.0)","Use t'GI.HarfBuzz.Callbacks.FontDrawGlyphFuncT' instead"] #-}
-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 4.0.0/
type FontGetGlyphShapeFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphShapeFuncT`@.
noFontGetGlyphShapeFuncT :: Maybe FontGetGlyphShapeFuncT
noFontGetGlyphShapeFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 4.0.0/
type FontGetGlyphShapeFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphShapeFuncT_WithClosures`@.
noFontGetGlyphShapeFuncT_WithClosures :: Maybe FontGetGlyphShapeFuncT_WithClosures
noFontGetGlyphShapeFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphShapeFuncT :: FontGetGlyphShapeFuncT -> FontGetGlyphShapeFuncT_WithClosures
drop_closures_FontGetGlyphShapeFuncT _f font fontData glyph drawFuncs drawData _ = _f font fontData glyph drawFuncs drawData

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphShapeFuncT :: MonadIO m => FontGetGlyphShapeFuncT -> m (GClosure C_FontGetGlyphShapeFuncT)
genClosure_FontGetGlyphShapeFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphShapeFuncT cb
    let cb'' = wrap_FontGetGlyphShapeFuncT Nothing cb'
    mk_FontGetGlyphShapeFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphShapeFuncT` into a `C_FontGetGlyphShapeFuncT`.
wrap_FontGetGlyphShapeFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphShapeFuncT)) ->
    FontGetGlyphShapeFuncT_WithClosures ->
    C_FontGetGlyphShapeFuncT
wrap_FontGetGlyphShapeFuncT gi'funptrptr gi'cb font fontData glyph drawFuncs drawData userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        B.ManagedPtr.withTransient  drawFuncs $ \drawFuncs' -> do
            gi'cb  font' fontData glyph drawFuncs' drawData userData
            maybeReleaseFunPtr gi'funptrptr


-- callback FontGetGlyphOriginsFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "number of glyphs to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The stride between successive glyph IDs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_x"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first origin X coordinate retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "x_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The stride between successive origin X coordinates"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_y"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first origin Y coordinate retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "y_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The stride between successive origin Y coordinates"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the (X,Y) coordinates (in scaled units) of the\norigin for each requested glyph. Each coordinate value must be returned in\nan #hb_position_t in the two output parameters."
        , sinceVersion = Just "11.3.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphOriginsFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Word32 ->
    Ptr Int32 ->
    Word32 ->
    Ptr Int32 ->
    Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of glyphs to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stride between successive glyph IDs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_x"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first origin X coordinate retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "x_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The stride between successive origin X coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_y"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first origin Y coordinate retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The stride between successive origin Y coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphOriginsFuncT :: FunPtr C_FontGetGlyphOriginsFuncT -> C_FontGetGlyphOriginsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphOriginsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphOriginsFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of glyphs to query
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@xStride@/: The stride between successive origin X coordinates
    -> Word32
    -- ^ /@yStride@/: The stride between successive origin Y coordinates
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphOriginsFuncT __funPtr font fontData count firstGlyph glyphStride xStride yStride userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    firstX <- allocMem :: IO (Ptr Int32)
    firstY <- allocMem :: IO (Ptr Int32)
    result <- (__dynamic_C_FontGetGlyphOriginsFuncT __funPtr) font' fontData count firstGlyph glyphStride firstX xStride firstY yStride userData
    firstX' <- peek firstX
    firstY' <- peek firstY
    touchManagedPtr font
    freeMem firstX
    freeMem firstY
    return (result, firstX', firstY')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphOriginsFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphOriginsFuncT :: C_FontGetGlyphOriginsFuncT -> IO (FunPtr C_FontGetGlyphOriginsFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) of the
-- origin for each requested glyph. Each coordinate value must be returned in
-- an @/hb_position_t/@ in the two output parameters.
-- 
-- /Since: 11.3.0/
type FontGetGlyphOriginsFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of glyphs to query
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@xStride@/: The stride between successive origin X coordinates
    -> Word32
    -- ^ /@yStride@/: The stride between successive origin Y coordinates
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphOriginsFuncT`@.
noFontGetGlyphOriginsFuncT :: Maybe FontGetGlyphOriginsFuncT
noFontGetGlyphOriginsFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) of the
-- origin for each requested glyph. Each coordinate value must be returned in
-- an @/hb_position_t/@ in the two output parameters.
-- 
-- /Since: 11.3.0/
type FontGetGlyphOriginsFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: number of glyphs to query
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@xStride@/: The stride between successive origin X coordinates
    -> Word32
    -- ^ /@yStride@/: The stride between successive origin Y coordinates
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphOriginsFuncT_WithClosures`@.
noFontGetGlyphOriginsFuncT_WithClosures :: Maybe FontGetGlyphOriginsFuncT_WithClosures
noFontGetGlyphOriginsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphOriginsFuncT :: FontGetGlyphOriginsFuncT -> FontGetGlyphOriginsFuncT_WithClosures
drop_closures_FontGetGlyphOriginsFuncT _f font fontData count firstGlyph glyphStride xStride yStride _ = _f font fontData count firstGlyph glyphStride xStride yStride

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphOriginsFuncT :: MonadIO m => FontGetGlyphOriginsFuncT -> m (GClosure C_FontGetGlyphOriginsFuncT)
genClosure_FontGetGlyphOriginsFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphOriginsFuncT cb
    let cb'' = wrap_FontGetGlyphOriginsFuncT Nothing cb'
    mk_FontGetGlyphOriginsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphOriginsFuncT` into a `C_FontGetGlyphOriginsFuncT`.
wrap_FontGetGlyphOriginsFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphOriginsFuncT)) ->
    FontGetGlyphOriginsFuncT_WithClosures ->
    C_FontGetGlyphOriginsFuncT
wrap_FontGetGlyphOriginsFuncT gi'funptrptr gi'cb font fontData count firstGlyph glyphStride firstX xStride firstY yStride userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outfirstX, outfirstY) <- gi'cb  font' fontData count firstGlyph glyphStride xStride yStride userData
        poke firstX outfirstX
        poke firstY outfirstY
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphOriginFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The X coordinate of the origin"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "y"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The Y coordinate of the origin"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the (X,Y) coordinates (in scaled units) of the\norigin for a glyph. Each coordinate must be returned in an #hb_position_t\noutput parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphOriginFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The X coordinate of the origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The Y coordinate of the origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphOriginFuncT :: FunPtr C_FontGetGlyphOriginFuncT -> C_FontGetGlyphOriginFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphOriginFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphOriginFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphOriginFuncT __funPtr font fontData glyph userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    result <- (__dynamic_C_FontGetGlyphOriginFuncT __funPtr) font' fontData glyph x y userData
    x' <- peek x
    y' <- peek y
    touchManagedPtr font
    freeMem x
    freeMem y
    return (result, x', y')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphOriginFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphOriginFuncT :: C_FontGetGlyphOriginFuncT -> IO (FunPtr C_FontGetGlyphOriginFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) of the
-- origin for a glyph. Each coordinate must be returned in an @/hb_position_t/@
-- output parameter.
type FontGetGlyphOriginFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphOriginFuncT`@.
noFontGetGlyphOriginFuncT :: Maybe FontGetGlyphOriginFuncT
noFontGetGlyphOriginFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) of the
-- origin for a glyph. Each coordinate must be returned in an @/hb_position_t/@
-- output parameter.
type FontGetGlyphOriginFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphOriginFuncT_WithClosures`@.
noFontGetGlyphOriginFuncT_WithClosures :: Maybe FontGetGlyphOriginFuncT_WithClosures
noFontGetGlyphOriginFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphOriginFuncT :: FontGetGlyphOriginFuncT -> FontGetGlyphOriginFuncT_WithClosures
drop_closures_FontGetGlyphOriginFuncT _f font fontData glyph _ = _f font fontData glyph

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphOriginFuncT :: MonadIO m => FontGetGlyphOriginFuncT -> m (GClosure C_FontGetGlyphOriginFuncT)
genClosure_FontGetGlyphOriginFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphOriginFuncT cb
    let cb'' = wrap_FontGetGlyphOriginFuncT Nothing cb'
    mk_FontGetGlyphOriginFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphOriginFuncT` into a `C_FontGetGlyphOriginFuncT`.
wrap_FontGetGlyphOriginFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphOriginFuncT)) ->
    FontGetGlyphOriginFuncT_WithClosures ->
    C_FontGetGlyphOriginFuncT
wrap_FontGetGlyphOriginFuncT gi'funptrptr gi'cb font fontData glyph x y userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outx, outy) <- gi'cb  font' fontData glyph userData
        poke x outx
        poke y outy
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphNameFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TCArray False (-1) 4 (TBasicType TUTF8)
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Name string retrieved for the glyph ID"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "size"
          , argType = TBasicType TUInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Length of the glyph-name string retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the glyph name that corresponds to a\nglyph ID. The name should be returned in a string output parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphNameFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr (Ptr CString) ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TCArray False (-1) 4 (TBasicType TUTF8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name string retrieved for the glyph ID"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Length of the glyph-name string retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "size"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "Length of the glyph-name string retrieved"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphNameFuncT :: FunPtr C_FontGetGlyphNameFuncT -> C_FontGetGlyphNameFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphNameFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphNameFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, [T.Text]))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphNameFuncT __funPtr font fontData glyph userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    name <- callocMem :: IO (Ptr (Ptr CString))
    size <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetGlyphNameFuncT __funPtr) font' fontData glyph name size userData
    size' <- peek size
    name' <- peek name
    name'' <- (unpackUTF8CArrayWithLength size') name'
    (mapCArrayWithLength size') freeMem name'
    freeMem name'
    touchManagedPtr font
    freeMem name
    freeMem size
    return (result, name'')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphNameFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphNameFuncT :: C_FontGetGlyphNameFuncT -> IO (FunPtr C_FontGetGlyphNameFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph name that corresponds to a
-- glyph ID. The name should be returned in a string output parameter.
type FontGetGlyphNameFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> IO ((Int32, [T.Text]))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphNameFuncT`@.
noFontGetGlyphNameFuncT :: Maybe FontGetGlyphNameFuncT
noFontGetGlyphNameFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph name that corresponds to a
-- glyph ID. The name should be returned in a string output parameter.
type FontGetGlyphNameFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, [T.Text]))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphNameFuncT_WithClosures`@.
noFontGetGlyphNameFuncT_WithClosures :: Maybe FontGetGlyphNameFuncT_WithClosures
noFontGetGlyphNameFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphNameFuncT :: FontGetGlyphNameFuncT -> FontGetGlyphNameFuncT_WithClosures
drop_closures_FontGetGlyphNameFuncT _f font fontData glyph _ = _f font fontData glyph

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphNameFuncT :: MonadIO m => FontGetGlyphNameFuncT -> m (GClosure C_FontGetGlyphNameFuncT)
genClosure_FontGetGlyphNameFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphNameFuncT cb
    let cb'' = wrap_FontGetGlyphNameFuncT Nothing cb'
    mk_FontGetGlyphNameFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphNameFuncT` into a `C_FontGetGlyphNameFuncT`.
wrap_FontGetGlyphNameFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphNameFuncT)) ->
    FontGetGlyphNameFuncT_WithClosures ->
    C_FontGetGlyphNameFuncT
wrap_FontGetGlyphNameFuncT gi'funptrptr gi'cb font fontData glyph name size userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outname) <- gi'cb  font' fontData glyph userData
        outname' <- packUTF8CArray outname
        poke name outname'
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphKerningFuncT
{- Callable
  { returnType = Just (TBasicType TInt32)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The glyph ID of the first glyph in the glyph pair"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "second_glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The glyph ID of the second glyph in the glyph pair"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This method should retrieve the kerning-adjustment value for a glyph-pair in\nthe specified font, for horizontal text segments."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphKerningFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The glyph ID of the first glyph in the glyph pair"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "second_glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The glyph ID of the second glyph in the glyph pair"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphKerningFuncT :: FunPtr C_FontGetGlyphKerningFuncT -> C_FontGetGlyphKerningFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphKerningFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphKerningFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@firstGlyph@/: The glyph ID of the first glyph in the glyph pair
    -> Word32
    -- ^ /@secondGlyph@/: The glyph ID of the second glyph in the glyph pair
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
dynamic_FontGetGlyphKerningFuncT __funPtr font fontData firstGlyph secondGlyph userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    result <- (__dynamic_C_FontGetGlyphKerningFuncT __funPtr) font' fontData firstGlyph secondGlyph userData
    touchManagedPtr font
    return result

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphKerningFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphKerningFuncT :: C_FontGetGlyphKerningFuncT -> IO (FunPtr C_FontGetGlyphKerningFuncT)

-- | This method should retrieve the kerning-adjustment value for a glyph-pair in
-- the specified font, for horizontal text segments.
type FontGetGlyphKerningFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@firstGlyph@/: The glyph ID of the first glyph in the glyph pair
    -> Word32
    -- ^ /@secondGlyph@/: The glyph ID of the second glyph in the glyph pair
    -> IO Int32

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphKerningFuncT`@.
noFontGetGlyphKerningFuncT :: Maybe FontGetGlyphKerningFuncT
noFontGetGlyphKerningFuncT = Nothing

-- | This method should retrieve the kerning-adjustment value for a glyph-pair in
-- the specified font, for horizontal text segments.
type FontGetGlyphKerningFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@firstGlyph@/: The glyph ID of the first glyph in the glyph pair
    -> Word32
    -- ^ /@secondGlyph@/: The glyph ID of the second glyph in the glyph pair
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphKerningFuncT_WithClosures`@.
noFontGetGlyphKerningFuncT_WithClosures :: Maybe FontGetGlyphKerningFuncT_WithClosures
noFontGetGlyphKerningFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphKerningFuncT :: FontGetGlyphKerningFuncT -> FontGetGlyphKerningFuncT_WithClosures
drop_closures_FontGetGlyphKerningFuncT _f font fontData firstGlyph secondGlyph _ = _f font fontData firstGlyph secondGlyph

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphKerningFuncT :: MonadIO m => FontGetGlyphKerningFuncT -> m (GClosure C_FontGetGlyphKerningFuncT)
genClosure_FontGetGlyphKerningFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphKerningFuncT cb
    let cb'' = wrap_FontGetGlyphKerningFuncT Nothing cb'
    mk_FontGetGlyphKerningFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphKerningFuncT` into a `C_FontGetGlyphKerningFuncT`.
wrap_FontGetGlyphKerningFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphKerningFuncT)) ->
    FontGetGlyphKerningFuncT_WithClosures ->
    C_FontGetGlyphKerningFuncT
wrap_FontGetGlyphKerningFuncT gi'funptrptr gi'cb font fontData firstGlyph secondGlyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        result <- gi'cb  font' fontData firstGlyph secondGlyph userData
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "unicode"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The Unicode code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "variation_selector"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The  variation-selector code point to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "1.2.3"
          , deprecationMessage = Nothing
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the glyph ID for a specified Unicode code point\nfont, with an optional variation selector."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unicode"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The Unicode code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variation_selector"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The  variation-selector code point to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphFuncT :: FunPtr C_FontGetGlyphFuncT -> C_FontGetGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphFuncT __funPtr font fontData unicode variationSelector userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    glyph <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetGlyphFuncT __funPtr) font' fontData unicode variationSelector glyph userData
    glyph' <- peek glyph
    touchManagedPtr font
    freeMem glyph
    return (result, glyph')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphFuncT :: C_FontGetGlyphFuncT -> IO (FunPtr C_FontGetGlyphFuncT)

{-# DEPRECATED FontGetGlyphFuncT ["(Since version 1.2.3)"] #-}
-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID for a specified Unicode code point
-- font, with an optional variation selector.
type FontGetGlyphFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphFuncT`@.
noFontGetGlyphFuncT :: Maybe FontGetGlyphFuncT
noFontGetGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID for a specified Unicode code point
-- font, with an optional variation selector.
type FontGetGlyphFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@unicode@/: The Unicode code point to query
    -> Word32
    -- ^ /@variationSelector@/: The  variation-selector code point to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphFuncT_WithClosures`@.
noFontGetGlyphFuncT_WithClosures :: Maybe FontGetGlyphFuncT_WithClosures
noFontGetGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphFuncT :: FontGetGlyphFuncT -> FontGetGlyphFuncT_WithClosures
drop_closures_FontGetGlyphFuncT _f font fontData unicode variationSelector _ = _f font fontData unicode variationSelector

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphFuncT :: MonadIO m => FontGetGlyphFuncT -> m (GClosure C_FontGetGlyphFuncT)
genClosure_FontGetGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphFuncT cb
    let cb'' = wrap_FontGetGlyphFuncT Nothing cb'
    mk_FontGetGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphFuncT` into a `C_FontGetGlyphFuncT`.
wrap_FontGetGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphFuncT)) ->
    FontGetGlyphFuncT_WithClosures ->
    C_FontGetGlyphFuncT
wrap_FontGetGlyphFuncT gi'funptrptr gi'cb font fontData unicode variationSelector glyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outglyph) <- gi'cb  font' fontData unicode variationSelector userData
        poke glyph outglyph
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphFromNameFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TCArray False (-1) 3 (TBasicType TUTF8)
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name string to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "len"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The length of the name queried"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the glyph ID that corresponds to a glyph-name\nstring."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphFromNameFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Ptr CString ->
    Int32 ->
    Ptr Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TCArray False (-1) 3 (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name string to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the name queried"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "The length of the name queried"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphFromNameFuncT :: FunPtr C_FontGetGlyphFromNameFuncT -> C_FontGetGlyphFromNameFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphFromNameFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphFromNameFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> [T.Text]
    -- ^ /@name@/: The name string to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphFromNameFuncT __funPtr font fontData name userData = liftIO $ do
    let len = fromIntegral $ P.length name
    font' <- unsafeManagedPtrGetPtr font
    name' <- packUTF8CArray name
    glyph <- allocMem :: IO (Ptr Word32)
    result <- (__dynamic_C_FontGetGlyphFromNameFuncT __funPtr) font' fontData name' len glyph userData
    glyph' <- peek glyph
    touchManagedPtr font
    (mapCArrayWithLength len) freeMem name'
    freeMem name'
    freeMem glyph
    return (result, glyph')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphFromNameFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphFromNameFuncT :: C_FontGetGlyphFromNameFuncT -> IO (FunPtr C_FontGetGlyphFromNameFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID that corresponds to a glyph-name
-- string.
type FontGetGlyphFromNameFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> [T.Text]
    -- ^ /@name@/: The name string to query
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphFromNameFuncT`@.
noFontGetGlyphFromNameFuncT :: Maybe FontGetGlyphFromNameFuncT
noFontGetGlyphFromNameFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the glyph ID that corresponds to a glyph-name
-- string.
type FontGetGlyphFromNameFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> [T.Text]
    -- ^ /@name@/: The name string to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Word32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphFromNameFuncT_WithClosures`@.
noFontGetGlyphFromNameFuncT_WithClosures :: Maybe FontGetGlyphFromNameFuncT_WithClosures
noFontGetGlyphFromNameFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphFromNameFuncT :: FontGetGlyphFromNameFuncT -> FontGetGlyphFromNameFuncT_WithClosures
drop_closures_FontGetGlyphFromNameFuncT _f font fontData name _ = _f font fontData name

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphFromNameFuncT :: MonadIO m => FontGetGlyphFromNameFuncT -> m (GClosure C_FontGetGlyphFromNameFuncT)
genClosure_FontGetGlyphFromNameFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphFromNameFuncT cb
    let cb'' = wrap_FontGetGlyphFromNameFuncT Nothing cb'
    mk_FontGetGlyphFromNameFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphFromNameFuncT` into a `C_FontGetGlyphFromNameFuncT`.
wrap_FontGetGlyphFromNameFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphFromNameFuncT)) ->
    FontGetGlyphFromNameFuncT_WithClosures ->
    C_FontGetGlyphFromNameFuncT
wrap_FontGetGlyphFromNameFuncT gi'funptrptr gi'cb font fontData name len glyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        name' <- (unpackUTF8CArrayWithLength len) name
        (result, outglyph) <- gi'cb  font' fontData name' userData
        poke glyph outglyph
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphExtentsFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "extents"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "glyph_extents_t" }
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #hb_glyph_extents_t retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = True
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the extents for a specified glyph. Extents must be\nreturned in an #hb_glyph_extents output parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphExtentsFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.GlyphExtentsT.GlyphExtentsT ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "extents"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "glyph_extents_t" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #hb_glyph_extents_t retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphExtentsFuncT :: FunPtr C_FontGetGlyphExtentsFuncT -> C_FontGetGlyphExtentsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphExtentsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphExtentsFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, HarfBuzz.GlyphExtentsT.GlyphExtentsT))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphExtentsFuncT __funPtr font fontData glyph userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    extents <- SP.callocBytes 16 :: IO (Ptr HarfBuzz.GlyphExtentsT.GlyphExtentsT)
    result <- (__dynamic_C_FontGetGlyphExtentsFuncT __funPtr) font' fontData glyph extents userData
    extents' <- (wrapPtr HarfBuzz.GlyphExtentsT.GlyphExtentsT) extents
    touchManagedPtr font
    return (result, extents')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphExtentsFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphExtentsFuncT :: C_FontGetGlyphExtentsFuncT -> IO (FunPtr C_FontGetGlyphExtentsFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the extents for a specified glyph. Extents must be
-- returned in an @/hb_glyph_extents/@ output parameter.
type FontGetGlyphExtentsFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> IO ((Int32, HarfBuzz.GlyphExtentsT.GlyphExtentsT))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphExtentsFuncT`@.
noFontGetGlyphExtentsFuncT :: Maybe FontGetGlyphExtentsFuncT
noFontGetGlyphExtentsFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the extents for a specified glyph. Extents must be
-- returned in an @/hb_glyph_extents/@ output parameter.
type FontGetGlyphExtentsFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, HarfBuzz.GlyphExtentsT.GlyphExtentsT))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphExtentsFuncT_WithClosures`@.
noFontGetGlyphExtentsFuncT_WithClosures :: Maybe FontGetGlyphExtentsFuncT_WithClosures
noFontGetGlyphExtentsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphExtentsFuncT :: FontGetGlyphExtentsFuncT -> FontGetGlyphExtentsFuncT_WithClosures
drop_closures_FontGetGlyphExtentsFuncT _f font fontData glyph _ = _f font fontData glyph

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphExtentsFuncT :: MonadIO m => FontGetGlyphExtentsFuncT -> m (GClosure C_FontGetGlyphExtentsFuncT)
genClosure_FontGetGlyphExtentsFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphExtentsFuncT cb
    let cb'' = wrap_FontGetGlyphExtentsFuncT Nothing cb'
    mk_FontGetGlyphExtentsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphExtentsFuncT` into a `C_FontGetGlyphExtentsFuncT`.
wrap_FontGetGlyphExtentsFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphExtentsFuncT)) ->
    FontGetGlyphExtentsFuncT_WithClosures ->
    C_FontGetGlyphExtentsFuncT
wrap_FontGetGlyphExtentsFuncT gi'funptrptr gi'cb font fontData glyph extents userData = do
    -- XXX Could not generate callback wrapper for FontGetGlyphExtentsFuncT
    -- Not implemented: Unexpected transfer type for "extents"
    P.error "The bindings for wrap_FontGetGlyphExtentsFuncT could not be generated, function unsupported."


-- callback FontGetGlyphContourPointFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if data found, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "point_index"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The contour-point index to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The X value retrieved for the contour point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "y"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The Y value retrieved for the contour point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the (X,Y) coordinates (in scaled units) for a\nspecified contour point in a glyph. Each coordinate must be returned as\nan #hb_position_t output parameter."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphContourPointFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point_index"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The contour-point index to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The X value retrieved for the contour point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The Y value retrieved for the contour point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphContourPointFuncT :: FunPtr C_FontGetGlyphContourPointFuncT -> C_FontGetGlyphContourPointFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphContourPointFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphContourPointFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Word32
    -- ^ /@pointIndex@/: The contour-point index to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise
dynamic_FontGetGlyphContourPointFuncT __funPtr font fontData glyph pointIndex userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    result <- (__dynamic_C_FontGetGlyphContourPointFuncT __funPtr) font' fontData glyph pointIndex x y userData
    x' <- peek x
    y' <- peek y
    touchManagedPtr font
    freeMem x
    freeMem y
    return (result, x', y')

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphContourPointFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphContourPointFuncT :: C_FontGetGlyphContourPointFuncT -> IO (FunPtr C_FontGetGlyphContourPointFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) for a
-- specified contour point in a glyph. Each coordinate must be returned as
-- an @/hb_position_t/@ output parameter.
type FontGetGlyphContourPointFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Word32
    -- ^ /@pointIndex@/: The contour-point index to query
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphContourPointFuncT`@.
noFontGetGlyphContourPointFuncT :: Maybe FontGetGlyphContourPointFuncT
noFontGetGlyphContourPointFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the (X,Y) coordinates (in scaled units) for a
-- specified contour point in a glyph. Each coordinate must be returned as
-- an @/hb_position_t/@ output parameter.
type FontGetGlyphContourPointFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Word32
    -- ^ /@pointIndex@/: The contour-point index to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, Int32, Int32))
    -- ^ __Returns:__ @true@ if data found, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphContourPointFuncT_WithClosures`@.
noFontGetGlyphContourPointFuncT_WithClosures :: Maybe FontGetGlyphContourPointFuncT_WithClosures
noFontGetGlyphContourPointFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphContourPointFuncT :: FontGetGlyphContourPointFuncT -> FontGetGlyphContourPointFuncT_WithClosures
drop_closures_FontGetGlyphContourPointFuncT _f font fontData glyph pointIndex _ = _f font fontData glyph pointIndex

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphContourPointFuncT :: MonadIO m => FontGetGlyphContourPointFuncT -> m (GClosure C_FontGetGlyphContourPointFuncT)
genClosure_FontGetGlyphContourPointFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphContourPointFuncT cb
    let cb'' = wrap_FontGetGlyphContourPointFuncT Nothing cb'
    mk_FontGetGlyphContourPointFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphContourPointFuncT` into a `C_FontGetGlyphContourPointFuncT`.
wrap_FontGetGlyphContourPointFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphContourPointFuncT)) ->
    FontGetGlyphContourPointFuncT_WithClosures ->
    C_FontGetGlyphContourPointFuncT
wrap_FontGetGlyphContourPointFuncT gi'funptrptr gi'cb font fontData glyph pointIndex x y userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        (result, outx, outy) <- gi'cb  font' fontData glyph pointIndex userData
        poke x outx
        poke y outy
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetGlyphAdvancesFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The number of glyph IDs in the sequence queried"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The stride between successive glyph IDs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "first_advance"
          , argType = TBasicType TInt32
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The first advance retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "advance_stride"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The stride between successive advances"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the advances for a sequence of glyphs."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphAdvancesFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Word32 ->
    Ptr Int32 ->
    Word32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The number of glyph IDs in the sequence queried"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stride between successive glyph IDs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "first_advance"
--           , argType = TBasicType TInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first advance retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "advance_stride"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The stride between successive advances"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphAdvancesFuncT :: FunPtr C_FontGetGlyphAdvancesFuncT -> C_FontGetGlyphAdvancesFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphAdvancesFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphAdvancesFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: The number of glyph IDs in the sequence queried
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@advanceStride@/: The stride between successive advances
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m (Int32)
dynamic_FontGetGlyphAdvancesFuncT __funPtr font fontData count firstGlyph glyphStride advanceStride userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    firstAdvance <- allocMem :: IO (Ptr Int32)
    (__dynamic_C_FontGetGlyphAdvancesFuncT __funPtr) font' fontData count firstGlyph glyphStride firstAdvance advanceStride userData
    firstAdvance' <- peek firstAdvance
    touchManagedPtr font
    freeMem firstAdvance
    return firstAdvance'

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphAdvancesFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphAdvancesFuncT :: C_FontGetGlyphAdvancesFuncT -> IO (FunPtr C_FontGetGlyphAdvancesFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the advances for a sequence of glyphs.
type FontGetGlyphAdvancesFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: The number of glyph IDs in the sequence queried
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@advanceStride@/: The stride between successive advances
    -> IO (Int32)

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphAdvancesFuncT`@.
noFontGetGlyphAdvancesFuncT :: Maybe FontGetGlyphAdvancesFuncT
noFontGetGlyphAdvancesFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the advances for a sequence of glyphs.
type FontGetGlyphAdvancesFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@count@/: The number of glyph IDs in the sequence queried
    -> Word32
    -- ^ /@firstGlyph@/: The first glyph ID to query
    -> Word32
    -- ^ /@glyphStride@/: The stride between successive glyph IDs
    -> Word32
    -- ^ /@advanceStride@/: The stride between successive advances
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO (Int32)

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphAdvancesFuncT_WithClosures`@.
noFontGetGlyphAdvancesFuncT_WithClosures :: Maybe FontGetGlyphAdvancesFuncT_WithClosures
noFontGetGlyphAdvancesFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphAdvancesFuncT :: FontGetGlyphAdvancesFuncT -> FontGetGlyphAdvancesFuncT_WithClosures
drop_closures_FontGetGlyphAdvancesFuncT _f font fontData count firstGlyph glyphStride advanceStride _ = _f font fontData count firstGlyph glyphStride advanceStride

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphAdvancesFuncT :: MonadIO m => FontGetGlyphAdvancesFuncT -> m (GClosure C_FontGetGlyphAdvancesFuncT)
genClosure_FontGetGlyphAdvancesFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphAdvancesFuncT cb
    let cb'' = wrap_FontGetGlyphAdvancesFuncT Nothing cb'
    mk_FontGetGlyphAdvancesFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphAdvancesFuncT` into a `C_FontGetGlyphAdvancesFuncT`.
wrap_FontGetGlyphAdvancesFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphAdvancesFuncT)) ->
    FontGetGlyphAdvancesFuncT_WithClosures ->
    C_FontGetGlyphAdvancesFuncT
wrap_FontGetGlyphAdvancesFuncT gi'funptrptr gi'cb font fontData count firstGlyph glyphStride firstAdvance advanceStride userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        outfirstAdvance <- gi'cb  font' fontData count firstGlyph glyphStride advanceStride userData
        poke firstAdvance outfirstAdvance
        maybeReleaseFunPtr gi'funptrptr


-- callback FontGetGlyphAdvanceFuncT
{- Callable
  { returnType = Just (TBasicType TInt32)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "The advance of @glyph within @font"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\nThis method should retrieve the advance for a specified glyph. The\nmethod must return an #hb_position_t."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetGlyphAdvanceFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetGlyphAdvanceFuncT :: FunPtr C_FontGetGlyphAdvanceFuncT -> C_FontGetGlyphAdvanceFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetGlyphAdvanceFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetGlyphAdvanceFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
    -- ^ __Returns:__ The advance of /@glyph@/ within /@font@/
dynamic_FontGetGlyphAdvanceFuncT __funPtr font fontData glyph userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    result <- (__dynamic_C_FontGetGlyphAdvanceFuncT __funPtr) font' fontData glyph userData
    touchManagedPtr font
    return result

-- | Generate a function pointer callable from C code, from a `C_FontGetGlyphAdvanceFuncT`.
foreign import ccall "wrapper"
    mk_FontGetGlyphAdvanceFuncT :: C_FontGetGlyphAdvanceFuncT -> IO (FunPtr C_FontGetGlyphAdvanceFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the advance for a specified glyph. The
-- method must return an @/hb_position_t/@.
type FontGetGlyphAdvanceFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> IO Int32
    -- ^ __Returns:__ The advance of /@glyph@/ within /@font@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphAdvanceFuncT`@.
noFontGetGlyphAdvanceFuncT :: Maybe FontGetGlyphAdvanceFuncT
noFontGetGlyphAdvanceFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- This method should retrieve the advance for a specified glyph. The
-- method must return an @/hb_position_t/@.
type FontGetGlyphAdvanceFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32
    -- ^ __Returns:__ The advance of /@glyph@/ within /@font@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetGlyphAdvanceFuncT_WithClosures`@.
noFontGetGlyphAdvanceFuncT_WithClosures :: Maybe FontGetGlyphAdvanceFuncT_WithClosures
noFontGetGlyphAdvanceFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetGlyphAdvanceFuncT :: FontGetGlyphAdvanceFuncT -> FontGetGlyphAdvanceFuncT_WithClosures
drop_closures_FontGetGlyphAdvanceFuncT _f font fontData glyph _ = _f font fontData glyph

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetGlyphAdvanceFuncT :: MonadIO m => FontGetGlyphAdvanceFuncT -> m (GClosure C_FontGetGlyphAdvanceFuncT)
genClosure_FontGetGlyphAdvanceFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetGlyphAdvanceFuncT cb
    let cb'' = wrap_FontGetGlyphAdvanceFuncT Nothing cb'
    mk_FontGetGlyphAdvanceFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetGlyphAdvanceFuncT` into a `C_FontGetGlyphAdvanceFuncT`.
wrap_FontGetGlyphAdvanceFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetGlyphAdvanceFuncT)) ->
    FontGetGlyphAdvanceFuncT_WithClosures ->
    C_FontGetGlyphAdvanceFuncT
wrap_FontGetGlyphAdvanceFuncT gi'funptrptr gi'cb font fontData glyph userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        result <- gi'cb  font' fontData glyph userData
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback FontGetFontExtentsFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "extents"
          , argType =
              TInterface
                Name { namespace = "HarfBuzz" , name = "font_extents_t" }
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The font extents retrieved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = True
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "This method should retrieve the extents for a font."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontGetFontExtentsFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Ptr HarfBuzz.FontExtentsT.FontExtentsT ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "extents"
--           , argType =
--               TInterface
--                 Name { namespace = "HarfBuzz" , name = "font_extents_t" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The font extents retrieved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontGetFontExtentsFuncT :: FunPtr C_FontGetFontExtentsFuncT -> C_FontGetFontExtentsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontGetFontExtentsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontGetFontExtentsFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ((Int32, HarfBuzz.FontExtentsT.FontExtentsT))
dynamic_FontGetFontExtentsFuncT __funPtr font fontData userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    extents <- SP.callocBytes 48 :: IO (Ptr HarfBuzz.FontExtentsT.FontExtentsT)
    result <- (__dynamic_C_FontGetFontExtentsFuncT __funPtr) font' fontData extents userData
    extents' <- (wrapPtr HarfBuzz.FontExtentsT.FontExtentsT) extents
    touchManagedPtr font
    return (result, extents')

-- | Generate a function pointer callable from C code, from a `C_FontGetFontExtentsFuncT`.
foreign import ccall "wrapper"
    mk_FontGetFontExtentsFuncT :: C_FontGetFontExtentsFuncT -> IO (FunPtr C_FontGetFontExtentsFuncT)

-- | This method should retrieve the extents for a font.
type FontGetFontExtentsFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> IO ((Int32, HarfBuzz.FontExtentsT.FontExtentsT))

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetFontExtentsFuncT`@.
noFontGetFontExtentsFuncT :: Maybe FontGetFontExtentsFuncT
noFontGetFontExtentsFuncT = Nothing

-- | This method should retrieve the extents for a font.
type FontGetFontExtentsFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ((Int32, HarfBuzz.FontExtentsT.FontExtentsT))

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontGetFontExtentsFuncT_WithClosures`@.
noFontGetFontExtentsFuncT_WithClosures :: Maybe FontGetFontExtentsFuncT_WithClosures
noFontGetFontExtentsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontGetFontExtentsFuncT :: FontGetFontExtentsFuncT -> FontGetFontExtentsFuncT_WithClosures
drop_closures_FontGetFontExtentsFuncT _f font fontData _ = _f font fontData

-- | Wrap the callback into a `GClosure`.
genClosure_FontGetFontExtentsFuncT :: MonadIO m => FontGetFontExtentsFuncT -> m (GClosure C_FontGetFontExtentsFuncT)
genClosure_FontGetFontExtentsFuncT cb = liftIO $ do
    let cb' = drop_closures_FontGetFontExtentsFuncT cb
    let cb'' = wrap_FontGetFontExtentsFuncT Nothing cb'
    mk_FontGetFontExtentsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontGetFontExtentsFuncT` into a `C_FontGetFontExtentsFuncT`.
wrap_FontGetFontExtentsFuncT :: 
    Maybe (Ptr (FunPtr C_FontGetFontExtentsFuncT)) ->
    FontGetFontExtentsFuncT_WithClosures ->
    C_FontGetFontExtentsFuncT
wrap_FontGetFontExtentsFuncT gi'funptrptr gi'cb font fontData extents userData = do
    -- XXX Could not generate callback wrapper for FontGetFontExtentsFuncT
    -- Not implemented: Unexpected transfer type for "extents"
    P.error "The bindings for wrap_FontGetFontExtentsFuncT could not be generated, function unsupported."


-- callback FontDrawGlyphOrFailFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`true` if glyph was drawn, `false` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The draw functions to send the shape data to"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The data accompanying the draw functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object."
        , sinceVersion = Just "11.2.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontDrawGlyphOrFailFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The draw functions to send the shape data to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The data accompanying the draw functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontDrawGlyphOrFailFuncT :: FunPtr C_FontDrawGlyphOrFailFuncT -> C_FontDrawGlyphOrFailFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontDrawGlyphOrFailFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontDrawGlyphOrFailFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
    -- ^ __Returns:__ @true@ if glyph was drawn, @false@ otherwise
dynamic_FontDrawGlyphOrFailFuncT __funPtr font fontData glyph drawFuncs drawData userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    drawFuncs' <- unsafeManagedPtrGetPtr drawFuncs
    result <- (__dynamic_C_FontDrawGlyphOrFailFuncT __funPtr) font' fontData glyph drawFuncs' drawData userData
    touchManagedPtr font
    touchManagedPtr drawFuncs
    return result

-- | Generate a function pointer callable from C code, from a `C_FontDrawGlyphOrFailFuncT`.
foreign import ccall "wrapper"
    mk_FontDrawGlyphOrFailFuncT :: C_FontDrawGlyphOrFailFuncT -> IO (FunPtr C_FontDrawGlyphOrFailFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 11.2.0/
type FontDrawGlyphOrFailFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> IO Int32
    -- ^ __Returns:__ @true@ if glyph was drawn, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontDrawGlyphOrFailFuncT`@.
noFontDrawGlyphOrFailFuncT :: Maybe FontDrawGlyphOrFailFuncT
noFontDrawGlyphOrFailFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 11.2.0/
type FontDrawGlyphOrFailFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32
    -- ^ __Returns:__ @true@ if glyph was drawn, @false@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontDrawGlyphOrFailFuncT_WithClosures`@.
noFontDrawGlyphOrFailFuncT_WithClosures :: Maybe FontDrawGlyphOrFailFuncT_WithClosures
noFontDrawGlyphOrFailFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontDrawGlyphOrFailFuncT :: FontDrawGlyphOrFailFuncT -> FontDrawGlyphOrFailFuncT_WithClosures
drop_closures_FontDrawGlyphOrFailFuncT _f font fontData glyph drawFuncs drawData _ = _f font fontData glyph drawFuncs drawData

-- | Wrap the callback into a `GClosure`.
genClosure_FontDrawGlyphOrFailFuncT :: MonadIO m => FontDrawGlyphOrFailFuncT -> m (GClosure C_FontDrawGlyphOrFailFuncT)
genClosure_FontDrawGlyphOrFailFuncT cb = liftIO $ do
    let cb' = drop_closures_FontDrawGlyphOrFailFuncT cb
    let cb'' = wrap_FontDrawGlyphOrFailFuncT Nothing cb'
    mk_FontDrawGlyphOrFailFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontDrawGlyphOrFailFuncT` into a `C_FontDrawGlyphOrFailFuncT`.
wrap_FontDrawGlyphOrFailFuncT :: 
    Maybe (Ptr (FunPtr C_FontDrawGlyphOrFailFuncT)) ->
    FontDrawGlyphOrFailFuncT_WithClosures ->
    C_FontDrawGlyphOrFailFuncT
wrap_FontDrawGlyphOrFailFuncT gi'funptrptr gi'cb font fontData glyph drawFuncs drawData userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        B.ManagedPtr.withTransient  drawFuncs $ \drawFuncs' -> do
            result <- gi'cb  font' fontData glyph drawFuncs' drawData userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback FontDrawGlyphFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#hb_font_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@font user data pointer"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "glyph"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The glyph ID to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_funcs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The draw functions to send the shape data to"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The data accompanying the draw functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "11.2.0"
          , deprecationMessage =
              Just "Use hb_font_draw_glyph_func_or_fail_t instead."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_font_funcs_t of an #hb_font_t object."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontDrawGlyphFuncT =
    Ptr HarfBuzz.FontT.FontT ->
    Ptr () ->
    Word32 ->
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#hb_font_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@font user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "glyph"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The glyph ID to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_funcs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The draw functions to send the shape data to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The data accompanying the draw functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontDrawGlyphFuncT :: FunPtr C_FontDrawGlyphFuncT -> C_FontDrawGlyphFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontDrawGlyphFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FontDrawGlyphFuncT
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m ()
dynamic_FontDrawGlyphFuncT __funPtr font fontData glyph drawFuncs drawData userData = liftIO $ do
    font' <- unsafeManagedPtrGetPtr font
    drawFuncs' <- unsafeManagedPtrGetPtr drawFuncs
    (__dynamic_C_FontDrawGlyphFuncT __funPtr) font' fontData glyph drawFuncs' drawData userData
    touchManagedPtr font
    touchManagedPtr drawFuncs
    return ()

-- | Generate a function pointer callable from C code, from a `C_FontDrawGlyphFuncT`.
foreign import ccall "wrapper"
    mk_FontDrawGlyphFuncT :: C_FontDrawGlyphFuncT -> IO (FunPtr C_FontDrawGlyphFuncT)

{-# DEPRECATED FontDrawGlyphFuncT ["(Since version 11.2.0)","Use hb_font_draw_glyph_func_or_fail_t instead."] #-}
-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 7.0.0/
type FontDrawGlyphFuncT =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontDrawGlyphFuncT`@.
noFontDrawGlyphFuncT :: Maybe FontDrawGlyphFuncT
noFontDrawGlyphFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.FontFuncsT.FontFuncsT' of an t'GI.HarfBuzz.Structs.FontT.FontT' object.
-- 
-- /Since: 7.0.0/
type FontDrawGlyphFuncT_WithClosures =
    HarfBuzz.FontT.FontT
    -- ^ /@font@/: t'GI.HarfBuzz.Structs.FontT.FontT' to work upon
    -> Ptr ()
    -- ^ /@fontData@/: /@font@/ user data pointer
    -> Word32
    -- ^ /@glyph@/: The glyph ID to query
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@drawFuncs@/: The draw functions to send the shape data to
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontDrawGlyphFuncT_WithClosures`@.
noFontDrawGlyphFuncT_WithClosures :: Maybe FontDrawGlyphFuncT_WithClosures
noFontDrawGlyphFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontDrawGlyphFuncT :: FontDrawGlyphFuncT -> FontDrawGlyphFuncT_WithClosures
drop_closures_FontDrawGlyphFuncT _f font fontData glyph drawFuncs drawData _ = _f font fontData glyph drawFuncs drawData

-- | Wrap the callback into a `GClosure`.
genClosure_FontDrawGlyphFuncT :: MonadIO m => FontDrawGlyphFuncT -> m (GClosure C_FontDrawGlyphFuncT)
genClosure_FontDrawGlyphFuncT cb = liftIO $ do
    let cb' = drop_closures_FontDrawGlyphFuncT cb
    let cb'' = wrap_FontDrawGlyphFuncT Nothing cb'
    mk_FontDrawGlyphFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontDrawGlyphFuncT` into a `C_FontDrawGlyphFuncT`.
wrap_FontDrawGlyphFuncT :: 
    Maybe (Ptr (FunPtr C_FontDrawGlyphFuncT)) ->
    FontDrawGlyphFuncT_WithClosures ->
    C_FontDrawGlyphFuncT
wrap_FontDrawGlyphFuncT gi'funptrptr gi'cb font fontData glyph drawFuncs drawData userData = do
    B.ManagedPtr.withTransient  font $ \font' -> do
        B.ManagedPtr.withTransient  drawFuncs $ \drawFuncs' -> do
            gi'cb  font' fontData glyph drawFuncs' drawData userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DrawQuadraticToFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "dfuncs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "draw functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the draw functions in hb_font_draw_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "st"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "current draw state" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_draw_funcs_set_quadratic_to_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_draw_funcs_t to perform a \"quadratic-to\" draw\noperation."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawQuadraticToFuncT =
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.DrawStateT.DrawStateT ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "dfuncs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "draw functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the draw functions in hb_font_draw_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "st"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "current draw state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_draw_funcs_set_quadratic_to_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawQuadraticToFuncT :: FunPtr C_DrawQuadraticToFuncT -> C_DrawQuadraticToFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawQuadraticToFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DrawQuadraticToFuncT
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@controlX@/: X component of control point
    -> Float
    -- ^ /@controlY@/: Y component of control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetQuadraticToFunc'
    -> m ()
dynamic_DrawQuadraticToFuncT __funPtr dfuncs drawData st controlX controlY toX toY userData = liftIO $ do
    dfuncs' <- unsafeManagedPtrGetPtr dfuncs
    st' <- unsafeManagedPtrGetPtr st
    let controlX' = realToFrac controlX
    let controlY' = realToFrac controlY
    let toX' = realToFrac toX
    let toY' = realToFrac toY
    (__dynamic_C_DrawQuadraticToFuncT __funPtr) dfuncs' drawData st' controlX' controlY' toX' toY' userData
    touchManagedPtr dfuncs
    touchManagedPtr st
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawQuadraticToFuncT`.
foreign import ccall "wrapper"
    mk_DrawQuadraticToFuncT :: C_DrawQuadraticToFuncT -> IO (FunPtr C_DrawQuadraticToFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"quadratic-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawQuadraticToFuncT =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@controlX@/: X component of control point
    -> Float
    -- ^ /@controlY@/: Y component of control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawQuadraticToFuncT`@.
noDrawQuadraticToFuncT :: Maybe DrawQuadraticToFuncT
noDrawQuadraticToFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"quadratic-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawQuadraticToFuncT_WithClosures =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@controlX@/: X component of control point
    -> Float
    -- ^ /@controlY@/: Y component of control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetQuadraticToFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawQuadraticToFuncT_WithClosures`@.
noDrawQuadraticToFuncT_WithClosures :: Maybe DrawQuadraticToFuncT_WithClosures
noDrawQuadraticToFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawQuadraticToFuncT :: DrawQuadraticToFuncT -> DrawQuadraticToFuncT_WithClosures
drop_closures_DrawQuadraticToFuncT _f dfuncs drawData st controlX controlY toX toY _ = _f dfuncs drawData st controlX controlY toX toY

-- | Wrap the callback into a `GClosure`.
genClosure_DrawQuadraticToFuncT :: MonadIO m => DrawQuadraticToFuncT -> m (GClosure C_DrawQuadraticToFuncT)
genClosure_DrawQuadraticToFuncT cb = liftIO $ do
    let cb' = drop_closures_DrawQuadraticToFuncT cb
    let cb'' = wrap_DrawQuadraticToFuncT Nothing cb'
    mk_DrawQuadraticToFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawQuadraticToFuncT` into a `C_DrawQuadraticToFuncT`.
wrap_DrawQuadraticToFuncT :: 
    Maybe (Ptr (FunPtr C_DrawQuadraticToFuncT)) ->
    DrawQuadraticToFuncT_WithClosures ->
    C_DrawQuadraticToFuncT
wrap_DrawQuadraticToFuncT gi'funptrptr gi'cb dfuncs drawData st controlX controlY toX toY userData = do
    B.ManagedPtr.withTransient  dfuncs $ \dfuncs' -> do
        B.ManagedPtr.withTransient  st $ \st' -> do
            let controlX' = realToFrac controlX
            let controlY' = realToFrac controlY
            let toX' = realToFrac toX
            let toY' = realToFrac toY
            gi'cb  dfuncs' drawData st' controlX' controlY' toX' toY' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DrawMoveToFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "dfuncs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "draw functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the draw functions in hb_font_draw_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "st"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "current draw state" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data pointer passed to hb_draw_funcs_set_move_to_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_draw_funcs_t to perform a \"move-to\" draw\noperation."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawMoveToFuncT =
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.DrawStateT.DrawStateT ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "dfuncs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "draw functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the draw functions in hb_font_draw_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "st"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "current draw state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data pointer passed to hb_draw_funcs_set_move_to_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawMoveToFuncT :: FunPtr C_DrawMoveToFuncT -> C_DrawMoveToFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawMoveToFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DrawMoveToFuncT
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetMoveToFunc'
    -> m ()
dynamic_DrawMoveToFuncT __funPtr dfuncs drawData st toX toY userData = liftIO $ do
    dfuncs' <- unsafeManagedPtrGetPtr dfuncs
    st' <- unsafeManagedPtrGetPtr st
    let toX' = realToFrac toX
    let toY' = realToFrac toY
    (__dynamic_C_DrawMoveToFuncT __funPtr) dfuncs' drawData st' toX' toY' userData
    touchManagedPtr dfuncs
    touchManagedPtr st
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawMoveToFuncT`.
foreign import ccall "wrapper"
    mk_DrawMoveToFuncT :: C_DrawMoveToFuncT -> IO (FunPtr C_DrawMoveToFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"move-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawMoveToFuncT =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawMoveToFuncT`@.
noDrawMoveToFuncT :: Maybe DrawMoveToFuncT
noDrawMoveToFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"move-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawMoveToFuncT_WithClosures =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetMoveToFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawMoveToFuncT_WithClosures`@.
noDrawMoveToFuncT_WithClosures :: Maybe DrawMoveToFuncT_WithClosures
noDrawMoveToFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawMoveToFuncT :: DrawMoveToFuncT -> DrawMoveToFuncT_WithClosures
drop_closures_DrawMoveToFuncT _f dfuncs drawData st toX toY _ = _f dfuncs drawData st toX toY

-- | Wrap the callback into a `GClosure`.
genClosure_DrawMoveToFuncT :: MonadIO m => DrawMoveToFuncT -> m (GClosure C_DrawMoveToFuncT)
genClosure_DrawMoveToFuncT cb = liftIO $ do
    let cb' = drop_closures_DrawMoveToFuncT cb
    let cb'' = wrap_DrawMoveToFuncT Nothing cb'
    mk_DrawMoveToFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawMoveToFuncT` into a `C_DrawMoveToFuncT`.
wrap_DrawMoveToFuncT :: 
    Maybe (Ptr (FunPtr C_DrawMoveToFuncT)) ->
    DrawMoveToFuncT_WithClosures ->
    C_DrawMoveToFuncT
wrap_DrawMoveToFuncT gi'funptrptr gi'cb dfuncs drawData st toX toY userData = do
    B.ManagedPtr.withTransient  dfuncs $ \dfuncs' -> do
        B.ManagedPtr.withTransient  st $ \st' -> do
            let toX' = realToFrac toX
            let toY' = realToFrac toY
            gi'cb  dfuncs' drawData st' toX' toY' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DrawLineToFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "dfuncs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "draw functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the draw functions in hb_font_draw_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "st"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "current draw state" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data pointer passed to hb_draw_funcs_set_line_to_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_draw_funcs_t to perform a \"line-to\" draw\noperation."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawLineToFuncT =
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.DrawStateT.DrawStateT ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "dfuncs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "draw functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the draw functions in hb_font_draw_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "st"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "current draw state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data pointer passed to hb_draw_funcs_set_line_to_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawLineToFuncT :: FunPtr C_DrawLineToFuncT -> C_DrawLineToFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawLineToFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DrawLineToFuncT
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetLineToFunc'
    -> m ()
dynamic_DrawLineToFuncT __funPtr dfuncs drawData st toX toY userData = liftIO $ do
    dfuncs' <- unsafeManagedPtrGetPtr dfuncs
    st' <- unsafeManagedPtrGetPtr st
    let toX' = realToFrac toX
    let toY' = realToFrac toY
    (__dynamic_C_DrawLineToFuncT __funPtr) dfuncs' drawData st' toX' toY' userData
    touchManagedPtr dfuncs
    touchManagedPtr st
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawLineToFuncT`.
foreign import ccall "wrapper"
    mk_DrawLineToFuncT :: C_DrawLineToFuncT -> IO (FunPtr C_DrawLineToFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"line-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawLineToFuncT =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawLineToFuncT`@.
noDrawLineToFuncT :: Maybe DrawLineToFuncT
noDrawLineToFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"line-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawLineToFuncT_WithClosures =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetLineToFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawLineToFuncT_WithClosures`@.
noDrawLineToFuncT_WithClosures :: Maybe DrawLineToFuncT_WithClosures
noDrawLineToFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawLineToFuncT :: DrawLineToFuncT -> DrawLineToFuncT_WithClosures
drop_closures_DrawLineToFuncT _f dfuncs drawData st toX toY _ = _f dfuncs drawData st toX toY

-- | Wrap the callback into a `GClosure`.
genClosure_DrawLineToFuncT :: MonadIO m => DrawLineToFuncT -> m (GClosure C_DrawLineToFuncT)
genClosure_DrawLineToFuncT cb = liftIO $ do
    let cb' = drop_closures_DrawLineToFuncT cb
    let cb'' = wrap_DrawLineToFuncT Nothing cb'
    mk_DrawLineToFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawLineToFuncT` into a `C_DrawLineToFuncT`.
wrap_DrawLineToFuncT :: 
    Maybe (Ptr (FunPtr C_DrawLineToFuncT)) ->
    DrawLineToFuncT_WithClosures ->
    C_DrawLineToFuncT
wrap_DrawLineToFuncT gi'funptrptr gi'cb dfuncs drawData st toX toY userData = do
    B.ManagedPtr.withTransient  dfuncs $ \dfuncs' -> do
        B.ManagedPtr.withTransient  st $ \st' -> do
            let toX' = realToFrac toX
            let toY' = realToFrac toY
            gi'cb  dfuncs' drawData st' toX' toY' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DrawCubicToFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "dfuncs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "draw functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the draw functions in hb_font_draw_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "st"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "current draw state" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control1_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of first control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control1_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of first control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control2_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of second control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "control2_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of second control point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_x"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "X component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "to_y"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Y component of target point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_draw_funcs_set_cubic_to_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_draw_funcs_t to perform a \"cubic-to\" draw\noperation."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawCubicToFuncT =
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.DrawStateT.DrawStateT ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    CFloat ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "dfuncs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "draw functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the draw functions in hb_font_draw_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "st"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "current draw state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control1_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of first control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control1_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of first control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control2_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of second control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "control2_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of second control point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "to_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y component of target point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_draw_funcs_set_cubic_to_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawCubicToFuncT :: FunPtr C_DrawCubicToFuncT -> C_DrawCubicToFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawCubicToFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DrawCubicToFuncT
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@control1X@/: X component of first control point
    -> Float
    -- ^ /@control1Y@/: Y component of first control point
    -> Float
    -- ^ /@control2X@/: X component of second control point
    -> Float
    -- ^ /@control2Y@/: Y component of second control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetCubicToFunc'
    -> m ()
dynamic_DrawCubicToFuncT __funPtr dfuncs drawData st control1X control1Y control2X control2Y toX toY userData = liftIO $ do
    dfuncs' <- unsafeManagedPtrGetPtr dfuncs
    st' <- unsafeManagedPtrGetPtr st
    let control1X' = realToFrac control1X
    let control1Y' = realToFrac control1Y
    let control2X' = realToFrac control2X
    let control2Y' = realToFrac control2Y
    let toX' = realToFrac toX
    let toY' = realToFrac toY
    (__dynamic_C_DrawCubicToFuncT __funPtr) dfuncs' drawData st' control1X' control1Y' control2X' control2Y' toX' toY' userData
    touchManagedPtr dfuncs
    touchManagedPtr st
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawCubicToFuncT`.
foreign import ccall "wrapper"
    mk_DrawCubicToFuncT :: C_DrawCubicToFuncT -> IO (FunPtr C_DrawCubicToFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"cubic-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawCubicToFuncT =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@control1X@/: X component of first control point
    -> Float
    -- ^ /@control1Y@/: Y component of first control point
    -> Float
    -- ^ /@control2X@/: X component of second control point
    -> Float
    -- ^ /@control2Y@/: Y component of second control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawCubicToFuncT`@.
noDrawCubicToFuncT :: Maybe DrawCubicToFuncT
noDrawCubicToFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"cubic-to\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawCubicToFuncT_WithClosures =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Float
    -- ^ /@control1X@/: X component of first control point
    -> Float
    -- ^ /@control1Y@/: Y component of first control point
    -> Float
    -- ^ /@control2X@/: X component of second control point
    -> Float
    -- ^ /@control2Y@/: Y component of second control point
    -> Float
    -- ^ /@toX@/: X component of target point
    -> Float
    -- ^ /@toY@/: Y component of target point
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetCubicToFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawCubicToFuncT_WithClosures`@.
noDrawCubicToFuncT_WithClosures :: Maybe DrawCubicToFuncT_WithClosures
noDrawCubicToFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawCubicToFuncT :: DrawCubicToFuncT -> DrawCubicToFuncT_WithClosures
drop_closures_DrawCubicToFuncT _f dfuncs drawData st control1X control1Y control2X control2Y toX toY _ = _f dfuncs drawData st control1X control1Y control2X control2Y toX toY

-- | Wrap the callback into a `GClosure`.
genClosure_DrawCubicToFuncT :: MonadIO m => DrawCubicToFuncT -> m (GClosure C_DrawCubicToFuncT)
genClosure_DrawCubicToFuncT cb = liftIO $ do
    let cb' = drop_closures_DrawCubicToFuncT cb
    let cb'' = wrap_DrawCubicToFuncT Nothing cb'
    mk_DrawCubicToFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawCubicToFuncT` into a `C_DrawCubicToFuncT`.
wrap_DrawCubicToFuncT :: 
    Maybe (Ptr (FunPtr C_DrawCubicToFuncT)) ->
    DrawCubicToFuncT_WithClosures ->
    C_DrawCubicToFuncT
wrap_DrawCubicToFuncT gi'funptrptr gi'cb dfuncs drawData st control1X control1Y control2X control2Y toX toY userData = do
    B.ManagedPtr.withTransient  dfuncs $ \dfuncs' -> do
        B.ManagedPtr.withTransient  st $ \st' -> do
            let control1X' = realToFrac control1X
            let control1Y' = realToFrac control1Y
            let control2X' = realToFrac control2X
            let control2Y' = realToFrac control2Y
            let toX' = realToFrac toX
            let toY' = realToFrac toY
            gi'cb  dfuncs' drawData st' control1X' control1Y' control2X' control2Y' toX' toY' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DrawClosePathFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "dfuncs"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "draw functions object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "draw_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The data accompanying the draw functions in hb_font_draw_glyph()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "st"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "current draw state" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data pointer passed to hb_draw_funcs_set_close_path_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_draw_funcs_t to perform a \"close-path\" draw\noperation."
        , sinceVersion = Just "4.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawClosePathFuncT =
    Ptr HarfBuzz.DrawFuncsT.DrawFuncsT ->
    Ptr () ->
    Ptr HarfBuzz.DrawStateT.DrawStateT ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "dfuncs"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_funcs_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "draw functions object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The data accompanying the draw functions in hb_font_draw_glyph()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "st"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "draw_state_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "current draw state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data pointer passed to hb_draw_funcs_set_close_path_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawClosePathFuncT :: FunPtr C_DrawClosePathFuncT -> C_DrawClosePathFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawClosePathFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DrawClosePathFuncT
    -> HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetClosePathFunc'
    -> m ()
dynamic_DrawClosePathFuncT __funPtr dfuncs drawData st userData = liftIO $ do
    dfuncs' <- unsafeManagedPtrGetPtr dfuncs
    st' <- unsafeManagedPtrGetPtr st
    (__dynamic_C_DrawClosePathFuncT __funPtr) dfuncs' drawData st' userData
    touchManagedPtr dfuncs
    touchManagedPtr st
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawClosePathFuncT`.
foreign import ccall "wrapper"
    mk_DrawClosePathFuncT :: C_DrawClosePathFuncT -> IO (FunPtr C_DrawClosePathFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"close-path\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawClosePathFuncT =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawClosePathFuncT`@.
noDrawClosePathFuncT :: Maybe DrawClosePathFuncT
noDrawClosePathFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.DrawFuncsT.DrawFuncsT' to perform a \"close-path\" draw
-- operation.
-- 
-- /Since: 4.0.0/
type DrawClosePathFuncT_WithClosures =
    HarfBuzz.DrawFuncsT.DrawFuncsT
    -- ^ /@dfuncs@/: draw functions object
    -> Ptr ()
    -- ^ /@drawData@/: The data accompanying the draw functions in 'GI.HarfBuzz.Functions.fontDrawGlyph'
    -> HarfBuzz.DrawStateT.DrawStateT
    -- ^ /@st@/: current draw state
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed to 'GI.HarfBuzz.Functions.drawFuncsSetClosePathFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawClosePathFuncT_WithClosures`@.
noDrawClosePathFuncT_WithClosures :: Maybe DrawClosePathFuncT_WithClosures
noDrawClosePathFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawClosePathFuncT :: DrawClosePathFuncT -> DrawClosePathFuncT_WithClosures
drop_closures_DrawClosePathFuncT _f dfuncs drawData st _ = _f dfuncs drawData st

-- | Wrap the callback into a `GClosure`.
genClosure_DrawClosePathFuncT :: MonadIO m => DrawClosePathFuncT -> m (GClosure C_DrawClosePathFuncT)
genClosure_DrawClosePathFuncT cb = liftIO $ do
    let cb' = drop_closures_DrawClosePathFuncT cb
    let cb'' = wrap_DrawClosePathFuncT Nothing cb'
    mk_DrawClosePathFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawClosePathFuncT` into a `C_DrawClosePathFuncT`.
wrap_DrawClosePathFuncT :: 
    Maybe (Ptr (FunPtr C_DrawClosePathFuncT)) ->
    DrawClosePathFuncT_WithClosures ->
    C_DrawClosePathFuncT
wrap_DrawClosePathFuncT gi'funptrptr gi'cb dfuncs drawData st userData = do
    B.ManagedPtr.withTransient  dfuncs $ \dfuncs' -> do
        B.ManagedPtr.withTransient  st $ \st' -> do
            gi'cb  dfuncs' drawData st' userData
            maybeReleaseFunPtr gi'funptrptr


-- callback DestroyFuncT
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data to be destroyed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "A virtual method for destroy user-data callbacks."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DestroyFuncT =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to be destroyed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DestroyFuncT :: FunPtr C_DestroyFuncT -> C_DestroyFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DestroyFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DestroyFuncT
    -> Ptr ()
    -- ^ /@userData@/: the data to be destroyed
    -> m ()
dynamic_DestroyFuncT __funPtr userData = liftIO $ do
    (__dynamic_C_DestroyFuncT __funPtr) userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_DestroyFuncT`.
foreign import ccall "wrapper"
    mk_DestroyFuncT :: C_DestroyFuncT -> IO (FunPtr C_DestroyFuncT)

-- | A virtual method for destroy user-data callbacks.
type DestroyFuncT =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DestroyFuncT`@.
noDestroyFuncT :: Maybe DestroyFuncT
noDestroyFuncT = Nothing

-- | A virtual method for destroy user-data callbacks.
type DestroyFuncT_WithClosures =
    Ptr ()
    -- ^ /@userData@/: the data to be destroyed
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DestroyFuncT_WithClosures`@.
noDestroyFuncT_WithClosures :: Maybe DestroyFuncT_WithClosures
noDestroyFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DestroyFuncT :: DestroyFuncT -> DestroyFuncT_WithClosures
drop_closures_DestroyFuncT _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_DestroyFuncT :: MonadIO m => DestroyFuncT -> m (GClosure C_DestroyFuncT)
genClosure_DestroyFuncT cb = liftIO $ do
    let cb' = drop_closures_DestroyFuncT cb
    let cb'' = wrap_DestroyFuncT Nothing cb'
    mk_DestroyFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DestroyFuncT` into a `C_DestroyFuncT`.
wrap_DestroyFuncT :: 
    Maybe (Ptr (FunPtr C_DestroyFuncT)) ->
    DestroyFuncT_WithClosures ->
    C_DestroyFuncT
wrap_DestroyFuncT gi'funptrptr gi'cb userData = do
    gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr


-- callback ColorLineGetExtendFuncT
{- Callable
  { returnType =
      Just
        (TInterface
           Name { namespace = "HarfBuzz" , name = "paint_extend_t" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the extend mode of @color_line"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "color_line"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #hb_color_line_t object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_line_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data accompanying @color_line"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data accompanying this method"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the @hb_color_line_t to fetches the extend mode."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ColorLineGetExtendFuncT =
    Ptr HarfBuzz.ColorLineT.ColorLineT ->
    Ptr () ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "color_line"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #hb_color_line_t object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_line_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data accompanying @color_line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data accompanying this method"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "HarfBuzz" , name = "paint_extend_t" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ColorLineGetExtendFuncT :: FunPtr C_ColorLineGetExtendFuncT -> C_ColorLineGetExtendFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ColorLineGetExtendFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ColorLineGetExtendFuncT
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> Ptr ()
    -- ^ /@userData@/: the data accompanying this method
    -> m HarfBuzz.Enums.PaintExtendT
    -- ^ __Returns:__ the extend mode of /@colorLine@/
dynamic_ColorLineGetExtendFuncT __funPtr colorLine colorLineData userData = liftIO $ do
    colorLine' <- unsafeManagedPtrGetPtr colorLine
    result <- (__dynamic_C_ColorLineGetExtendFuncT __funPtr) colorLine' colorLineData userData
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr colorLine
    return result'

-- | Generate a function pointer callable from C code, from a `C_ColorLineGetExtendFuncT`.
foreign import ccall "wrapper"
    mk_ColorLineGetExtendFuncT :: C_ColorLineGetExtendFuncT -> IO (FunPtr C_ColorLineGetExtendFuncT)

-- | A virtual method for the /@hbColorLineT@/ to fetches the extend mode.
-- 
-- /Since: 7.0.0/
type ColorLineGetExtendFuncT =
    HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> IO HarfBuzz.Enums.PaintExtendT
    -- ^ __Returns:__ the extend mode of /@colorLine@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ColorLineGetExtendFuncT`@.
noColorLineGetExtendFuncT :: Maybe ColorLineGetExtendFuncT
noColorLineGetExtendFuncT = Nothing

-- | A virtual method for the /@hbColorLineT@/ to fetches the extend mode.
-- 
-- /Since: 7.0.0/
type ColorLineGetExtendFuncT_WithClosures =
    HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> Ptr ()
    -- ^ /@userData@/: the data accompanying this method
    -> IO HarfBuzz.Enums.PaintExtendT
    -- ^ __Returns:__ the extend mode of /@colorLine@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ColorLineGetExtendFuncT_WithClosures`@.
noColorLineGetExtendFuncT_WithClosures :: Maybe ColorLineGetExtendFuncT_WithClosures
noColorLineGetExtendFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ColorLineGetExtendFuncT :: ColorLineGetExtendFuncT -> ColorLineGetExtendFuncT_WithClosures
drop_closures_ColorLineGetExtendFuncT _f colorLine colorLineData _ = _f colorLine colorLineData

-- | Wrap the callback into a `GClosure`.
genClosure_ColorLineGetExtendFuncT :: MonadIO m => ColorLineGetExtendFuncT -> m (GClosure C_ColorLineGetExtendFuncT)
genClosure_ColorLineGetExtendFuncT cb = liftIO $ do
    let cb' = drop_closures_ColorLineGetExtendFuncT cb
    let cb'' = wrap_ColorLineGetExtendFuncT Nothing cb'
    mk_ColorLineGetExtendFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ColorLineGetExtendFuncT` into a `C_ColorLineGetExtendFuncT`.
wrap_ColorLineGetExtendFuncT :: 
    Maybe (Ptr (FunPtr C_ColorLineGetExtendFuncT)) ->
    ColorLineGetExtendFuncT_WithClosures ->
    C_ColorLineGetExtendFuncT
wrap_ColorLineGetExtendFuncT gi'funptrptr gi'cb colorLine colorLineData userData = do
    B.ManagedPtr.withTransient  colorLine $ \colorLine' -> do
        result <- gi'cb  colorLine' colorLineData userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (fromIntegral . fromEnum) result
        return result'


-- callback ColorLineGetColorStopsFuncT
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "the total number of color stops in @color_line"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "color_line"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #hb_color_line_t object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "color_line_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data accompanying @color_line"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "start"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the index of the first color stop to return"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Input = the maximum number of feature tags to return;\n    Output = the actual number of feature tags returned (may be zero)"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "color_stops"
          , argType =
              TCArray
                False
                (-1)
                3
                (TInterface
                   Name { namespace = "HarfBuzz" , name = "color_stop_t" })
          , direction = DirectionInout
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Array of #hb_color_stop_t to populate"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = True
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data accompanying this method"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A virtual method for the #hb_color_line_t to fetch color stops."
        , sinceVersion = Just "7.0.0"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ColorLineGetColorStopsFuncT =
    Ptr HarfBuzz.ColorLineT.ColorLineT ->
    Ptr () ->
    Word32 ->
    Word32 ->
    Ptr HarfBuzz.ColorStopT.ColorStopT ->
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "color_line"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "color_line_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #hb_color_line_t object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_line_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data accompanying @color_line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the first color stop to return"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Input = the maximum number of feature tags to return;\n    Output = the actual number of feature tags returned (may be zero)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "color_stops"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 3
--                 (TInterface
--                    Name { namespace = "HarfBuzz" , name = "color_stop_t" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Array of #hb_color_stop_t to populate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data accompanying this method"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "Input = the maximum number of feature tags to return;\n    Output = the actual number of feature tags returned (may be zero)"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ColorLineGetColorStopsFuncT :: FunPtr C_ColorLineGetColorStopsFuncT -> C_ColorLineGetColorStopsFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ColorLineGetColorStopsFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ColorLineGetColorStopsFuncT
    -> HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> Word32
    -- ^ /@start@/: the index of the first color stop to return
    -> [HarfBuzz.ColorStopT.ColorStopT]
    -- ^ /@colorStops@/: Array of t'GI.HarfBuzz.Structs.ColorStopT.ColorStopT' to populate
    -> Ptr ()
    -- ^ /@userData@/: the data accompanying this method
    -> m ((Word32, [HarfBuzz.ColorStopT.ColorStopT]))
    -- ^ __Returns:__ the total number of color stops in /@colorLine@/
dynamic_ColorLineGetColorStopsFuncT __funPtr colorLine colorLineData start colorStops userData = liftIO $ do
    let count = fromIntegral $ P.length colorStops
    colorLine' <- unsafeManagedPtrGetPtr colorLine
    colorStops' <- mapM B.ManagedPtr.disownBoxed colorStops
    colorStops'' <- packBlockArray 12 colorStops'
    result <- (__dynamic_C_ColorLineGetColorStopsFuncT __funPtr) colorLine' colorLineData start count colorStops'' userData
    colorStops''' <- (unpackBoxedArrayWithLength 12 count) colorStops''
    colorStops'''' <- mapM (wrapBoxed HarfBuzz.ColorStopT.ColorStopT) colorStops'''
    freeMem colorStops''
    touchManagedPtr colorLine
    mapM_ touchManagedPtr colorStops
    return (result, colorStops'''')

-- | Generate a function pointer callable from C code, from a `C_ColorLineGetColorStopsFuncT`.
foreign import ccall "wrapper"
    mk_ColorLineGetColorStopsFuncT :: C_ColorLineGetColorStopsFuncT -> IO (FunPtr C_ColorLineGetColorStopsFuncT)

-- | A virtual method for the t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' to fetch color stops.
-- 
-- /Since: 7.0.0/
type ColorLineGetColorStopsFuncT =
    HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> Word32
    -- ^ /@start@/: the index of the first color stop to return
    -> [HarfBuzz.ColorStopT.ColorStopT]
    -- ^ /@colorStops@/: Array of t'GI.HarfBuzz.Structs.ColorStopT.ColorStopT' to populate
    -> IO ((Word32, [HarfBuzz.ColorStopT.ColorStopT]))
    -- ^ __Returns:__ the total number of color stops in /@colorLine@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ColorLineGetColorStopsFuncT`@.
noColorLineGetColorStopsFuncT :: Maybe ColorLineGetColorStopsFuncT
noColorLineGetColorStopsFuncT = Nothing

-- | A virtual method for the t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' to fetch color stops.
-- 
-- /Since: 7.0.0/
type ColorLineGetColorStopsFuncT_WithClosures =
    HarfBuzz.ColorLineT.ColorLineT
    -- ^ /@colorLine@/: a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT' object
    -> Ptr ()
    -- ^ /@colorLineData@/: the data accompanying /@colorLine@/
    -> Word32
    -- ^ /@start@/: the index of the first color stop to return
    -> [HarfBuzz.ColorStopT.ColorStopT]
    -- ^ /@colorStops@/: Array of t'GI.HarfBuzz.Structs.ColorStopT.ColorStopT' to populate
    -> Ptr ()
    -- ^ /@userData@/: the data accompanying this method
    -> IO ((Word32, [HarfBuzz.ColorStopT.ColorStopT]))
    -- ^ __Returns:__ the total number of color stops in /@colorLine@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ColorLineGetColorStopsFuncT_WithClosures`@.
noColorLineGetColorStopsFuncT_WithClosures :: Maybe ColorLineGetColorStopsFuncT_WithClosures
noColorLineGetColorStopsFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ColorLineGetColorStopsFuncT :: ColorLineGetColorStopsFuncT -> ColorLineGetColorStopsFuncT_WithClosures
drop_closures_ColorLineGetColorStopsFuncT _f colorLine colorLineData start colorStops _ = _f colorLine colorLineData start colorStops

-- | Wrap the callback into a `GClosure`.
genClosure_ColorLineGetColorStopsFuncT :: MonadIO m => ColorLineGetColorStopsFuncT -> m (GClosure C_ColorLineGetColorStopsFuncT)
genClosure_ColorLineGetColorStopsFuncT cb = liftIO $ do
    let cb' = drop_closures_ColorLineGetColorStopsFuncT cb
    let cb'' = wrap_ColorLineGetColorStopsFuncT Nothing cb'
    mk_ColorLineGetColorStopsFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ColorLineGetColorStopsFuncT` into a `C_ColorLineGetColorStopsFuncT`.
wrap_ColorLineGetColorStopsFuncT :: 
    Maybe (Ptr (FunPtr C_ColorLineGetColorStopsFuncT)) ->
    ColorLineGetColorStopsFuncT_WithClosures ->
    C_ColorLineGetColorStopsFuncT
wrap_ColorLineGetColorStopsFuncT gi'funptrptr gi'cb colorLine colorLineData start count colorStops userData = do
    -- XXX Could not generate callback wrapper for ColorLineGetColorStopsFuncT
    -- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 3 (TInterface (Name {namespace = "HarfBuzz", name = "color_stop_t"}))
    P.error "The bindings for wrap_ColorLineGetColorStopsFuncT could not be generated, function unsupported."


-- callback BufferMessageFuncT
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "`true` to perform the shaping step, `false` to skip it."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "buffer"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "buffer_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "An #hb_buffer_t to work upon"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font"
          , argType =
              TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #hb_font_t the @buffer is shaped with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "message"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "`NULL`-terminated message passed to the function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data pointer passed by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A callback method for #hb_buffer_t. The method gets called with the\n#hb_buffer_t it was set on, the #hb_font_t the buffer is shaped with and a\nmessage describing what step of the shaping process will be performed.\nReturning `false` from this method will skip this shaping step and move to\nthe next one."
        , sinceVersion = Just "1.1.3"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BufferMessageFuncT =
    Ptr HarfBuzz.BufferT.BufferT ->
    Ptr HarfBuzz.FontT.FontT ->
    CString ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "buffer_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An #hb_buffer_t to work upon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType =
--               TInterface Name { namespace = "HarfBuzz" , name = "font_t" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #hb_font_t the @buffer is shaped with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "`NULL`-terminated message passed to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data pointer passed by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BufferMessageFuncT :: FunPtr C_BufferMessageFuncT -> C_BufferMessageFuncT

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BufferMessageFuncT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BufferMessageFuncT
    -> HarfBuzz.BufferT.BufferT
    -- ^ /@buffer@/: An t'GI.HarfBuzz.Structs.BufferT.BufferT' to work upon
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: The t'GI.HarfBuzz.Structs.FontT.FontT' the /@buffer@/ is shaped with
    -> T.Text
    -- ^ /@message@/: @NULL@-terminated message passed to the function
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> m Int32
    -- ^ __Returns:__ @true@ to perform the shaping step, @false@ to skip it.
dynamic_BufferMessageFuncT __funPtr buffer font message userData = liftIO $ do
    buffer' <- unsafeManagedPtrGetPtr buffer
    font' <- unsafeManagedPtrGetPtr font
    message' <- textToCString message
    result <- (__dynamic_C_BufferMessageFuncT __funPtr) buffer' font' message' userData
    touchManagedPtr buffer
    touchManagedPtr font
    freeMem message'
    return result

-- | Generate a function pointer callable from C code, from a `C_BufferMessageFuncT`.
foreign import ccall "wrapper"
    mk_BufferMessageFuncT :: C_BufferMessageFuncT -> IO (FunPtr C_BufferMessageFuncT)

-- | A callback method for t'GI.HarfBuzz.Structs.BufferT.BufferT'. The method gets called with the
-- t'GI.HarfBuzz.Structs.BufferT.BufferT' it was set on, the t'GI.HarfBuzz.Structs.FontT.FontT' the buffer is shaped with and a
-- message describing what step of the shaping process will be performed.
-- Returning @false@ from this method will skip this shaping step and move to
-- the next one.
-- 
-- /Since: 1.1.3/
type BufferMessageFuncT =
    HarfBuzz.BufferT.BufferT
    -- ^ /@buffer@/: An t'GI.HarfBuzz.Structs.BufferT.BufferT' to work upon
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: The t'GI.HarfBuzz.Structs.FontT.FontT' the /@buffer@/ is shaped with
    -> T.Text
    -- ^ /@message@/: @NULL@-terminated message passed to the function
    -> IO Int32
    -- ^ __Returns:__ @true@ to perform the shaping step, @false@ to skip it.

-- | A convenience synonym for @`Nothing` :: `Maybe` `BufferMessageFuncT`@.
noBufferMessageFuncT :: Maybe BufferMessageFuncT
noBufferMessageFuncT = Nothing

-- | A callback method for t'GI.HarfBuzz.Structs.BufferT.BufferT'. The method gets called with the
-- t'GI.HarfBuzz.Structs.BufferT.BufferT' it was set on, the t'GI.HarfBuzz.Structs.FontT.FontT' the buffer is shaped with and a
-- message describing what step of the shaping process will be performed.
-- Returning @false@ from this method will skip this shaping step and move to
-- the next one.
-- 
-- /Since: 1.1.3/
type BufferMessageFuncT_WithClosures =
    HarfBuzz.BufferT.BufferT
    -- ^ /@buffer@/: An t'GI.HarfBuzz.Structs.BufferT.BufferT' to work upon
    -> HarfBuzz.FontT.FontT
    -- ^ /@font@/: The t'GI.HarfBuzz.Structs.FontT.FontT' the /@buffer@/ is shaped with
    -> T.Text
    -- ^ /@message@/: @NULL@-terminated message passed to the function
    -> Ptr ()
    -- ^ /@userData@/: User data pointer passed by the caller
    -> IO Int32
    -- ^ __Returns:__ @true@ to perform the shaping step, @false@ to skip it.

-- | A convenience synonym for @`Nothing` :: `Maybe` `BufferMessageFuncT_WithClosures`@.
noBufferMessageFuncT_WithClosures :: Maybe BufferMessageFuncT_WithClosures
noBufferMessageFuncT_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BufferMessageFuncT :: BufferMessageFuncT -> BufferMessageFuncT_WithClosures
drop_closures_BufferMessageFuncT _f buffer font message _ = _f buffer font message

-- | Wrap the callback into a `GClosure`.
genClosure_BufferMessageFuncT :: MonadIO m => BufferMessageFuncT -> m (GClosure C_BufferMessageFuncT)
genClosure_BufferMessageFuncT cb = liftIO $ do
    let cb' = drop_closures_BufferMessageFuncT cb
    let cb'' = wrap_BufferMessageFuncT Nothing cb'
    mk_BufferMessageFuncT cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BufferMessageFuncT` into a `C_BufferMessageFuncT`.
wrap_BufferMessageFuncT :: 
    Maybe (Ptr (FunPtr C_BufferMessageFuncT)) ->
    BufferMessageFuncT_WithClosures ->
    C_BufferMessageFuncT
wrap_BufferMessageFuncT gi'funptrptr gi'cb buffer font message userData = do
    B.ManagedPtr.withTransient  buffer $ \buffer' -> do
        B.ManagedPtr.withTransient  font $ \font' -> do
            message' <- cstringToText message
            result <- gi'cb  buffer' font' message' userData
            maybeReleaseFunPtr gi'funptrptr
            return result



