{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkFileChooser@ is an interface that can be implemented by file
-- selection widgets.
-- 
-- In GTK, the main objects that implement this interface are
-- t'GI.Gtk.Objects.FileChooserWidget.FileChooserWidget' and t'GI.Gtk.Objects.FileChooserDialog.FileChooserDialog'.
-- 
-- You do not need to write an object that implements the @GtkFileChooser@
-- interface unless you are trying to adapt an existing file selector to
-- expose a standard programming interface.
-- 
-- @GtkFileChooser@ allows for shortcuts to various places in the filesystem.
-- In the default implementation these are displayed in the left pane. It
-- may be a bit confusing at first that these shortcuts come from various
-- sources and in various flavours, so lets explain the terminology here:
-- 
-- * Bookmarks: are created by the user, by dragging folders from the
--   right pane to the left pane, or by using the “Add”. Bookmarks
--   can be renamed and deleted by the user.
-- * Shortcuts: can be provided by the application. For example, a Paint
--   program may want to add a shortcut for a Clipart folder. Shortcuts
--   cannot be modified by the user.
-- * Volumes: are provided by the underlying filesystem abstraction. They are
--   the “roots” of the filesystem.
-- 
-- 
-- = File Names and Encodings
-- 
-- When the user is finished selecting files in a @GtkFileChooser@, your
-- program can get the selected filenames as @GFile@s.
-- 
-- = Adding options
-- 
-- You can add extra widgets to a file chooser to provide options
-- that are not present in the default design, by using
-- 'GI.Gtk.Interfaces.FileChooser.fileChooserAddChoice'. Each choice has an identifier and
-- a user visible label; additionally, each choice can have multiple
-- options. If a choice has no option, it will be rendered as a
-- check button with the given label; if a choice has options, it will
-- be rendered as a combo box.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.FileChooser
    ( 

-- * Exported types
    FileChooser(..)                         ,
    IsFileChooser                           ,
    toFileChooser                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addChoice]("GI.Gtk.Interfaces.FileChooser#g:method:addChoice"), [addFilter]("GI.Gtk.Interfaces.FileChooser#g:method:addFilter"), [addShortcutFolder]("GI.Gtk.Interfaces.FileChooser#g:method:addShortcutFolder"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeChoice]("GI.Gtk.Interfaces.FileChooser#g:method:removeChoice"), [removeFilter]("GI.Gtk.Interfaces.FileChooser#g:method:removeFilter"), [removeShortcutFolder]("GI.Gtk.Interfaces.FileChooser#g:method:removeShortcutFolder"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAction]("GI.Gtk.Interfaces.FileChooser#g:method:getAction"), [getChoice]("GI.Gtk.Interfaces.FileChooser#g:method:getChoice"), [getCreateFolders]("GI.Gtk.Interfaces.FileChooser#g:method:getCreateFolders"), [getCurrentFolder]("GI.Gtk.Interfaces.FileChooser#g:method:getCurrentFolder"), [getCurrentName]("GI.Gtk.Interfaces.FileChooser#g:method:getCurrentName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFile]("GI.Gtk.Interfaces.FileChooser#g:method:getFile"), [getFiles]("GI.Gtk.Interfaces.FileChooser#g:method:getFiles"), [getFilter]("GI.Gtk.Interfaces.FileChooser#g:method:getFilter"), [getFilters]("GI.Gtk.Interfaces.FileChooser#g:method:getFilters"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectMultiple]("GI.Gtk.Interfaces.FileChooser#g:method:getSelectMultiple"), [getShortcutFolders]("GI.Gtk.Interfaces.FileChooser#g:method:getShortcutFolders").
-- 
-- ==== Setters
-- [setAction]("GI.Gtk.Interfaces.FileChooser#g:method:setAction"), [setChoice]("GI.Gtk.Interfaces.FileChooser#g:method:setChoice"), [setCreateFolders]("GI.Gtk.Interfaces.FileChooser#g:method:setCreateFolders"), [setCurrentFolder]("GI.Gtk.Interfaces.FileChooser#g:method:setCurrentFolder"), [setCurrentName]("GI.Gtk.Interfaces.FileChooser#g:method:setCurrentName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFile]("GI.Gtk.Interfaces.FileChooser#g:method:setFile"), [setFilter]("GI.Gtk.Interfaces.FileChooser#g:method:setFilter"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSelectMultiple]("GI.Gtk.Interfaces.FileChooser#g:method:setSelectMultiple").

#if defined(ENABLE_OVERLOADING)
    ResolveFileChooserMethod                ,
#endif

-- ** addChoice #method:addChoice#

#if defined(ENABLE_OVERLOADING)
    FileChooserAddChoiceMethodInfo          ,
#endif
    fileChooserAddChoice                    ,


-- ** addFilter #method:addFilter#

#if defined(ENABLE_OVERLOADING)
    FileChooserAddFilterMethodInfo          ,
#endif
    fileChooserAddFilter                    ,


-- ** addShortcutFolder #method:addShortcutFolder#

#if defined(ENABLE_OVERLOADING)
    FileChooserAddShortcutFolderMethodInfo  ,
#endif
    fileChooserAddShortcutFolder            ,


-- ** getAction #method:getAction#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetActionMethodInfo          ,
#endif
    fileChooserGetAction                    ,


-- ** getChoice #method:getChoice#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetChoiceMethodInfo          ,
#endif
    fileChooserGetChoice                    ,


-- ** getCreateFolders #method:getCreateFolders#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetCreateFoldersMethodInfo   ,
#endif
    fileChooserGetCreateFolders             ,


-- ** getCurrentFolder #method:getCurrentFolder#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetCurrentFolderMethodInfo   ,
#endif
    fileChooserGetCurrentFolder             ,


-- ** getCurrentName #method:getCurrentName#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetCurrentNameMethodInfo     ,
#endif
    fileChooserGetCurrentName               ,


-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetFileMethodInfo            ,
#endif
    fileChooserGetFile                      ,


-- ** getFiles #method:getFiles#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetFilesMethodInfo           ,
#endif
    fileChooserGetFiles                     ,


-- ** getFilter #method:getFilter#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetFilterMethodInfo          ,
#endif
    fileChooserGetFilter                    ,


-- ** getFilters #method:getFilters#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetFiltersMethodInfo         ,
#endif
    fileChooserGetFilters                   ,


-- ** getSelectMultiple #method:getSelectMultiple#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetSelectMultipleMethodInfo  ,
#endif
    fileChooserGetSelectMultiple            ,


-- ** getShortcutFolders #method:getShortcutFolders#

#if defined(ENABLE_OVERLOADING)
    FileChooserGetShortcutFoldersMethodInfo ,
#endif
    fileChooserGetShortcutFolders           ,


-- ** removeChoice #method:removeChoice#

#if defined(ENABLE_OVERLOADING)
    FileChooserRemoveChoiceMethodInfo       ,
#endif
    fileChooserRemoveChoice                 ,


-- ** removeFilter #method:removeFilter#

#if defined(ENABLE_OVERLOADING)
    FileChooserRemoveFilterMethodInfo       ,
#endif
    fileChooserRemoveFilter                 ,


-- ** removeShortcutFolder #method:removeShortcutFolder#

#if defined(ENABLE_OVERLOADING)
    FileChooserRemoveShortcutFolderMethodInfo,
#endif
    fileChooserRemoveShortcutFolder         ,


-- ** setAction #method:setAction#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetActionMethodInfo          ,
#endif
    fileChooserSetAction                    ,


-- ** setChoice #method:setChoice#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetChoiceMethodInfo          ,
#endif
    fileChooserSetChoice                    ,


-- ** setCreateFolders #method:setCreateFolders#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetCreateFoldersMethodInfo   ,
#endif
    fileChooserSetCreateFolders             ,


-- ** setCurrentFolder #method:setCurrentFolder#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetCurrentFolderMethodInfo   ,
#endif
    fileChooserSetCurrentFolder             ,


-- ** setCurrentName #method:setCurrentName#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetCurrentNameMethodInfo     ,
#endif
    fileChooserSetCurrentName               ,


-- ** setFile #method:setFile#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetFileMethodInfo            ,
#endif
    fileChooserSetFile                      ,


-- ** setFilter #method:setFilter#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetFilterMethodInfo          ,
#endif
    fileChooserSetFilter                    ,


-- ** setSelectMultiple #method:setSelectMultiple#

#if defined(ENABLE_OVERLOADING)
    FileChooserSetSelectMultipleMethodInfo  ,
#endif
    fileChooserSetSelectMultiple            ,




 -- * Properties


-- ** action #attr:action#
-- | The type of operation that the file chooser is performing.

#if defined(ENABLE_OVERLOADING)
    FileChooserActionPropertyInfo           ,
#endif
    constructFileChooserAction              ,
#if defined(ENABLE_OVERLOADING)
    fileChooserAction                       ,
#endif
    getFileChooserAction                    ,
    setFileChooserAction                    ,


-- ** createFolders #attr:createFolders#
-- | Whether a file chooser not in 'GI.Gtk.Enums.FileChooserActionOpen' mode
-- will offer the user to create new folders.

#if defined(ENABLE_OVERLOADING)
    FileChooserCreateFoldersPropertyInfo    ,
#endif
    constructFileChooserCreateFolders       ,
#if defined(ENABLE_OVERLOADING)
    fileChooserCreateFolders                ,
#endif
    getFileChooserCreateFolders             ,
    setFileChooserCreateFolders             ,


-- ** filter #attr:filter#
-- | The current filter for selecting files that are displayed.

#if defined(ENABLE_OVERLOADING)
    FileChooserFilterPropertyInfo           ,
#endif
    constructFileChooserFilter              ,
#if defined(ENABLE_OVERLOADING)
    fileChooserFilter                       ,
#endif
    getFileChooserFilter                    ,
    setFileChooserFilter                    ,


-- ** filters #attr:filters#
-- | A @GListModel@ containing the filters that have been
-- added with 'GI.Gtk.Interfaces.FileChooser.fileChooserAddFilter'.
-- 
-- The returned object should not be modified. It may
-- or may not be updated for later changes.

#if defined(ENABLE_OVERLOADING)
    FileChooserFiltersPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    fileChooserFilters                      ,
#endif
    getFileChooserFilters                   ,


-- ** selectMultiple #attr:selectMultiple#
-- | Whether to allow multiple files to be selected.

#if defined(ENABLE_OVERLOADING)
    FileChooserSelectMultiplePropertyInfo   ,
#endif
    constructFileChooserSelectMultiple      ,
#if defined(ENABLE_OVERLOADING)
    fileChooserSelectMultiple               ,
#endif
    getFileChooserSelectMultiple            ,
    setFileChooserSelectMultiple            ,


-- ** shortcutFolders #attr:shortcutFolders#
-- | A @GListModel@ containing the shortcut folders that have been
-- added with 'GI.Gtk.Interfaces.FileChooser.fileChooserAddShortcutFolder'.
-- 
-- The returned object should not be modified. It may
-- or may not be updated for later changes.

#if defined(ENABLE_OVERLOADING)
    FileChooserShortcutFoldersPropertyInfo  ,
#endif
#if defined(ENABLE_OVERLOADING)
    fileChooserShortcutFolders              ,
#endif
    getFileChooserShortcutFolders           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.FileFilter as Gtk.FileFilter
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.FileFilter as Gtk.FileFilter

#endif

-- interface FileChooser 
-- | Memory-managed wrapper type.
{-# DEPRECATED FileChooser ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
newtype FileChooser = FileChooser (SP.ManagedPtr FileChooser)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileChooser where
    toManagedPtr (FileChooser p) = p

foreign import ccall "gtk_file_chooser_get_type"
    c_gtk_file_chooser_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileChooser where
    glibType = c_gtk_file_chooser_get_type

instance B.Types.GObject FileChooser

-- | Type class for types which can be safely cast to t'FileChooser', for instance with `toFileChooser`.
class (SP.GObject o, O.IsDescendantOf FileChooser o) => IsFileChooser o
instance (SP.GObject o, O.IsDescendantOf FileChooser o) => IsFileChooser o

instance O.HasParentTypes FileChooser
type instance O.ParentTypes FileChooser = '[GObject.Object.Object]

-- | Cast to t'FileChooser', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFileChooser :: (MIO.MonadIO m, IsFileChooser o) => o -> m FileChooser
toFileChooser = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileChooser

-- | Convert t'FileChooser' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileChooser) where
    gvalueGType_ = c_gtk_file_chooser_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileChooser)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileChooser)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileChooser ptr
        else return P.Nothing
        
    

-- VVV Prop "action"
   -- Type: TInterface (Name {namespace = "Gtk", name = "FileChooserAction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #action
-- @
getFileChooserAction :: (MonadIO m, IsFileChooser o) => o -> m Gtk.Enums.FileChooserAction
getFileChooserAction obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "action"

-- | Set the value of the “@action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileChooser [ #action 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileChooserAction :: (MonadIO m, IsFileChooser o) => o -> Gtk.Enums.FileChooserAction -> m ()
setFileChooserAction obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "action" val

-- | Construct a t'GValueConstruct' with valid value for the “@action@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileChooserAction :: (IsFileChooser o, MIO.MonadIO m) => Gtk.Enums.FileChooserAction -> m (GValueConstruct o)
constructFileChooserAction val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "action" val

#if defined(ENABLE_OVERLOADING)
data FileChooserActionPropertyInfo
instance AttrInfo FileChooserActionPropertyInfo where
    type AttrAllowedOps FileChooserActionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint FileChooserActionPropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserActionPropertyInfo = (~) Gtk.Enums.FileChooserAction
    type AttrTransferTypeConstraint FileChooserActionPropertyInfo = (~) Gtk.Enums.FileChooserAction
    type AttrTransferType FileChooserActionPropertyInfo = Gtk.Enums.FileChooserAction
    type AttrGetType FileChooserActionPropertyInfo = Gtk.Enums.FileChooserAction
    type AttrLabel FileChooserActionPropertyInfo = "action"
    type AttrOrigin FileChooserActionPropertyInfo = FileChooser
    attrGet = getFileChooserAction
    attrSet = setFileChooserAction
    attrPut = setFileChooserAction
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileChooserAction
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.action"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:action"
        })
#endif

-- VVV Prop "create-folders"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@create-folders@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #createFolders
-- @
getFileChooserCreateFolders :: (MonadIO m, IsFileChooser o) => o -> m Bool
getFileChooserCreateFolders obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "create-folders"

-- | Set the value of the “@create-folders@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileChooser [ #createFolders 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileChooserCreateFolders :: (MonadIO m, IsFileChooser o) => o -> Bool -> m ()
setFileChooserCreateFolders obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "create-folders" val

-- | Construct a t'GValueConstruct' with valid value for the “@create-folders@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileChooserCreateFolders :: (IsFileChooser o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFileChooserCreateFolders val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "create-folders" val

#if defined(ENABLE_OVERLOADING)
data FileChooserCreateFoldersPropertyInfo
instance AttrInfo FileChooserCreateFoldersPropertyInfo where
    type AttrAllowedOps FileChooserCreateFoldersPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint FileChooserCreateFoldersPropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserCreateFoldersPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FileChooserCreateFoldersPropertyInfo = (~) Bool
    type AttrTransferType FileChooserCreateFoldersPropertyInfo = Bool
    type AttrGetType FileChooserCreateFoldersPropertyInfo = Bool
    type AttrLabel FileChooserCreateFoldersPropertyInfo = "create-folders"
    type AttrOrigin FileChooserCreateFoldersPropertyInfo = FileChooser
    attrGet = getFileChooserCreateFolders
    attrSet = setFileChooserCreateFolders
    attrPut = setFileChooserCreateFolders
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileChooserCreateFolders
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.createFolders"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:createFolders"
        })
#endif

-- VVV Prop "filter"
   -- Type: TInterface (Name {namespace = "Gtk", name = "FileFilter"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@filter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #filter
-- @
getFileChooserFilter :: (MonadIO m, IsFileChooser o) => o -> m (Maybe Gtk.FileFilter.FileFilter)
getFileChooserFilter obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "filter" Gtk.FileFilter.FileFilter

-- | Set the value of the “@filter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileChooser [ #filter 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileChooserFilter :: (MonadIO m, IsFileChooser o, Gtk.FileFilter.IsFileFilter a) => o -> a -> m ()
setFileChooserFilter obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "filter" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@filter@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileChooserFilter :: (IsFileChooser o, MIO.MonadIO m, Gtk.FileFilter.IsFileFilter a) => a -> m (GValueConstruct o)
constructFileChooserFilter val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "filter" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FileChooserFilterPropertyInfo
instance AttrInfo FileChooserFilterPropertyInfo where
    type AttrAllowedOps FileChooserFilterPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FileChooserFilterPropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserFilterPropertyInfo = Gtk.FileFilter.IsFileFilter
    type AttrTransferTypeConstraint FileChooserFilterPropertyInfo = Gtk.FileFilter.IsFileFilter
    type AttrTransferType FileChooserFilterPropertyInfo = Gtk.FileFilter.FileFilter
    type AttrGetType FileChooserFilterPropertyInfo = (Maybe Gtk.FileFilter.FileFilter)
    type AttrLabel FileChooserFilterPropertyInfo = "filter"
    type AttrOrigin FileChooserFilterPropertyInfo = FileChooser
    attrGet = getFileChooserFilter
    attrSet = setFileChooserFilter
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.FileFilter.FileFilter v
    attrConstruct = constructFileChooserFilter
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.filter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:filter"
        })
#endif

-- VVV Prop "filters"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@filters@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #filters
-- @
getFileChooserFilters :: (MonadIO m, IsFileChooser o) => o -> m (Maybe Gio.ListModel.ListModel)
getFileChooserFilters obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "filters" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data FileChooserFiltersPropertyInfo
instance AttrInfo FileChooserFiltersPropertyInfo where
    type AttrAllowedOps FileChooserFiltersPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FileChooserFiltersPropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserFiltersPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FileChooserFiltersPropertyInfo = (~) ()
    type AttrTransferType FileChooserFiltersPropertyInfo = ()
    type AttrGetType FileChooserFiltersPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel FileChooserFiltersPropertyInfo = "filters"
    type AttrOrigin FileChooserFiltersPropertyInfo = FileChooser
    attrGet = getFileChooserFilters
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.filters"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:filters"
        })
#endif

-- VVV Prop "select-multiple"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@select-multiple@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #selectMultiple
-- @
getFileChooserSelectMultiple :: (MonadIO m, IsFileChooser o) => o -> m Bool
getFileChooserSelectMultiple obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "select-multiple"

-- | Set the value of the “@select-multiple@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileChooser [ #selectMultiple 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileChooserSelectMultiple :: (MonadIO m, IsFileChooser o) => o -> Bool -> m ()
setFileChooserSelectMultiple obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "select-multiple" val

-- | Construct a t'GValueConstruct' with valid value for the “@select-multiple@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileChooserSelectMultiple :: (IsFileChooser o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFileChooserSelectMultiple val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "select-multiple" val

#if defined(ENABLE_OVERLOADING)
data FileChooserSelectMultiplePropertyInfo
instance AttrInfo FileChooserSelectMultiplePropertyInfo where
    type AttrAllowedOps FileChooserSelectMultiplePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint FileChooserSelectMultiplePropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserSelectMultiplePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FileChooserSelectMultiplePropertyInfo = (~) Bool
    type AttrTransferType FileChooserSelectMultiplePropertyInfo = Bool
    type AttrGetType FileChooserSelectMultiplePropertyInfo = Bool
    type AttrLabel FileChooserSelectMultiplePropertyInfo = "select-multiple"
    type AttrOrigin FileChooserSelectMultiplePropertyInfo = FileChooser
    attrGet = getFileChooserSelectMultiple
    attrSet = setFileChooserSelectMultiple
    attrPut = setFileChooserSelectMultiple
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileChooserSelectMultiple
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.selectMultiple"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:selectMultiple"
        })
#endif

-- VVV Prop "shortcut-folders"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@shortcut-folders@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooser #shortcutFolders
-- @
getFileChooserShortcutFolders :: (MonadIO m, IsFileChooser o) => o -> m (Maybe Gio.ListModel.ListModel)
getFileChooserShortcutFolders obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "shortcut-folders" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data FileChooserShortcutFoldersPropertyInfo
instance AttrInfo FileChooserShortcutFoldersPropertyInfo where
    type AttrAllowedOps FileChooserShortcutFoldersPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FileChooserShortcutFoldersPropertyInfo = IsFileChooser
    type AttrSetTypeConstraint FileChooserShortcutFoldersPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FileChooserShortcutFoldersPropertyInfo = (~) ()
    type AttrTransferType FileChooserShortcutFoldersPropertyInfo = ()
    type AttrGetType FileChooserShortcutFoldersPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel FileChooserShortcutFoldersPropertyInfo = "shortcut-folders"
    type AttrOrigin FileChooserShortcutFoldersPropertyInfo = FileChooser
    attrGet = getFileChooserShortcutFolders
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.shortcutFolders"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#g:attr:shortcutFolders"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileChooser
type instance O.AttributeList FileChooser = FileChooserAttributeList
type FileChooserAttributeList = ('[ '("action", FileChooserActionPropertyInfo), '("createFolders", FileChooserCreateFoldersPropertyInfo), '("filter", FileChooserFilterPropertyInfo), '("filters", FileChooserFiltersPropertyInfo), '("selectMultiple", FileChooserSelectMultiplePropertyInfo), '("shortcutFolders", FileChooserShortcutFoldersPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileChooserAction :: AttrLabelProxy "action"
fileChooserAction = AttrLabelProxy

fileChooserCreateFolders :: AttrLabelProxy "createFolders"
fileChooserCreateFolders = AttrLabelProxy

fileChooserFilter :: AttrLabelProxy "filter"
fileChooserFilter = AttrLabelProxy

fileChooserFilters :: AttrLabelProxy "filters"
fileChooserFilters = AttrLabelProxy

fileChooserSelectMultiple :: AttrLabelProxy "selectMultiple"
fileChooserSelectMultiple = AttrLabelProxy

fileChooserShortcutFolders :: AttrLabelProxy "shortcutFolders"
fileChooserShortcutFolders = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFileChooserMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileChooserMethod "addChoice" o = FileChooserAddChoiceMethodInfo
    ResolveFileChooserMethod "addFilter" o = FileChooserAddFilterMethodInfo
    ResolveFileChooserMethod "addShortcutFolder" o = FileChooserAddShortcutFolderMethodInfo
    ResolveFileChooserMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileChooserMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileChooserMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileChooserMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileChooserMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileChooserMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileChooserMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileChooserMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileChooserMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileChooserMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileChooserMethod "removeChoice" o = FileChooserRemoveChoiceMethodInfo
    ResolveFileChooserMethod "removeFilter" o = FileChooserRemoveFilterMethodInfo
    ResolveFileChooserMethod "removeShortcutFolder" o = FileChooserRemoveShortcutFolderMethodInfo
    ResolveFileChooserMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileChooserMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileChooserMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileChooserMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileChooserMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileChooserMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileChooserMethod "getAction" o = FileChooserGetActionMethodInfo
    ResolveFileChooserMethod "getChoice" o = FileChooserGetChoiceMethodInfo
    ResolveFileChooserMethod "getCreateFolders" o = FileChooserGetCreateFoldersMethodInfo
    ResolveFileChooserMethod "getCurrentFolder" o = FileChooserGetCurrentFolderMethodInfo
    ResolveFileChooserMethod "getCurrentName" o = FileChooserGetCurrentNameMethodInfo
    ResolveFileChooserMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileChooserMethod "getFile" o = FileChooserGetFileMethodInfo
    ResolveFileChooserMethod "getFiles" o = FileChooserGetFilesMethodInfo
    ResolveFileChooserMethod "getFilter" o = FileChooserGetFilterMethodInfo
    ResolveFileChooserMethod "getFilters" o = FileChooserGetFiltersMethodInfo
    ResolveFileChooserMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileChooserMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileChooserMethod "getSelectMultiple" o = FileChooserGetSelectMultipleMethodInfo
    ResolveFileChooserMethod "getShortcutFolders" o = FileChooserGetShortcutFoldersMethodInfo
    ResolveFileChooserMethod "setAction" o = FileChooserSetActionMethodInfo
    ResolveFileChooserMethod "setChoice" o = FileChooserSetChoiceMethodInfo
    ResolveFileChooserMethod "setCreateFolders" o = FileChooserSetCreateFoldersMethodInfo
    ResolveFileChooserMethod "setCurrentFolder" o = FileChooserSetCurrentFolderMethodInfo
    ResolveFileChooserMethod "setCurrentName" o = FileChooserSetCurrentNameMethodInfo
    ResolveFileChooserMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileChooserMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileChooserMethod "setFile" o = FileChooserSetFileMethodInfo
    ResolveFileChooserMethod "setFilter" o = FileChooserSetFilterMethodInfo
    ResolveFileChooserMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileChooserMethod "setSelectMultiple" o = FileChooserSetSelectMultipleMethodInfo
    ResolveFileChooserMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileChooserMethod t FileChooser, O.OverloadedMethod info FileChooser p) => OL.IsLabel t (FileChooser -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileChooserMethod t FileChooser, O.OverloadedMethod info FileChooser p, R.HasField t FileChooser p) => R.HasField t FileChooser p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileChooserMethod t FileChooser, O.OverloadedMethodInfo info FileChooser) => OL.IsLabel t (O.MethodProxy info FileChooser) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method FileChooser::add_choice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "id for the added choice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user-visible label for the added choice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "options"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "ids for the options of the choice, or %NULL for a boolean choice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "option_labels"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user-visible labels for the options, must be the same length as @options"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_add_choice" gtk_file_chooser_add_choice :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CString ->                              -- id : TBasicType TUTF8
    CString ->                              -- label : TBasicType TUTF8
    Ptr CString ->                          -- options : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr CString ->                          -- option_labels : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

{-# DEPRECATED fileChooserAddChoice ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Adds a \'choice\' to the file chooser.
-- 
-- This is typically implemented as a combobox or, for boolean choices,
-- as a checkbutton. You can select a value using
-- 'GI.Gtk.Interfaces.FileChooser.fileChooserSetChoice' before the dialog is shown,
-- and you can obtain the user-selected value in the
-- [Dialog::response]("GI.Gtk.Objects.Dialog#g:signal:response") signal handler using
-- 'GI.Gtk.Interfaces.FileChooser.fileChooserGetChoice'.
fileChooserAddChoice ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> T.Text
    -- ^ /@id@/: id for the added choice
    -> T.Text
    -- ^ /@label@/: user-visible label for the added choice
    -> Maybe ([T.Text])
    -- ^ /@options@/: ids for the options of the choice, or 'P.Nothing' for a boolean choice
    -> Maybe ([T.Text])
    -- ^ /@optionLabels@/: user-visible labels for the options, must be the same length as /@options@/
    -> m ()
fileChooserAddChoice chooser id label options optionLabels = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    id' <- textToCString id
    label' <- textToCString label
    maybeOptions <- case options of
        Nothing -> return FP.nullPtr
        Just jOptions -> do
            jOptions' <- packZeroTerminatedUTF8CArray jOptions
            return jOptions'
    maybeOptionLabels <- case optionLabels of
        Nothing -> return FP.nullPtr
        Just jOptionLabels -> do
            jOptionLabels' <- packZeroTerminatedUTF8CArray jOptionLabels
            return jOptionLabels'
    gtk_file_chooser_add_choice chooser' id' label' maybeOptions maybeOptionLabels
    touchManagedPtr chooser
    freeMem id'
    freeMem label'
    mapZeroTerminatedCArray freeMem maybeOptions
    freeMem maybeOptions
    mapZeroTerminatedCArray freeMem maybeOptionLabels
    freeMem maybeOptionLabels
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserAddChoiceMethodInfo
instance (signature ~ (T.Text -> T.Text -> Maybe ([T.Text]) -> Maybe ([T.Text]) -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserAddChoiceMethodInfo a signature where
    overloadedMethod = fileChooserAddChoice

instance O.OverloadedMethodInfo FileChooserAddChoiceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserAddChoice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserAddChoice"
        })


#endif

-- method FileChooser::add_filter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileFilter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_add_filter" gtk_file_chooser_add_filter :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gtk.FileFilter.FileFilter ->        -- filter : TInterface (Name {namespace = "Gtk", name = "FileFilter"})
    IO ()

{-# DEPRECATED fileChooserAddFilter ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Adds /@filter@/ to the list of filters that the user can select between.
-- 
-- When a filter is selected, only files that are passed by that
-- filter are displayed.
-- 
-- Note that the /@chooser@/ takes ownership of the filter if it is floating,
-- so you have to ref and sink it if you want to keep a reference.
fileChooserAddFilter ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@filter@/: a @GtkFileFilter@
    -> m ()
fileChooserAddFilter chooser filter = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    filter' <- unsafeManagedPtrCastPtr filter
    gtk_file_chooser_add_filter chooser' filter'
    touchManagedPtr chooser
    touchManagedPtr filter
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserAddFilterMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) => O.OverloadedMethod FileChooserAddFilterMethodInfo a signature where
    overloadedMethod = fileChooserAddFilter

instance O.OverloadedMethodInfo FileChooserAddFilterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserAddFilter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserAddFilter"
        })


#endif

-- method FileChooser::add_shortcut_folder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "folder"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GFile` for the folder to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_chooser_add_shortcut_folder" gtk_file_chooser_add_shortcut_folder :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gio.File.File ->                    -- folder : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED fileChooserAddShortcutFolder ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Adds a folder to be displayed with the shortcut folders
-- in a file chooser.
fileChooserAddShortcutFolder ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gio.File.IsFile b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@folder@/: a @GFile@ for the folder to add
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileChooserAddShortcutFolder chooser folder = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    folder' <- unsafeManagedPtrCastPtr folder
    onException (do
        _ <- propagateGError $ gtk_file_chooser_add_shortcut_folder chooser' folder'
        touchManagedPtr chooser
        touchManagedPtr folder
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileChooserAddShortcutFolderMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gio.File.IsFile b) => O.OverloadedMethod FileChooserAddShortcutFolderMethodInfo a signature where
    overloadedMethod = fileChooserAddShortcutFolder

instance O.OverloadedMethodInfo FileChooserAddShortcutFolderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserAddShortcutFolder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserAddShortcutFolder"
        })


#endif

-- method FileChooser::get_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "FileChooserAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_action" gtk_file_chooser_get_action :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO CUInt

{-# DEPRECATED fileChooserGetAction ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the type of operation that the file chooser is performing.
fileChooserGetAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Gtk.Enums.FileChooserAction
    -- ^ __Returns:__ the action that the file selector is performing
fileChooserGetAction chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_action chooser'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetActionMethodInfo
instance (signature ~ (m Gtk.Enums.FileChooserAction), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetActionMethodInfo a signature where
    overloadedMethod = fileChooserGetAction

instance O.OverloadedMethodInfo FileChooserGetActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetAction"
        })


#endif

-- method FileChooser::get_choice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the choice to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_choice" gtk_file_chooser_get_choice :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CString ->                              -- id : TBasicType TUTF8
    IO CString

{-# DEPRECATED fileChooserGetChoice ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the currently selected option in the \'choice\' with the given ID.
fileChooserGetChoice ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> T.Text
    -- ^ /@id@/: the ID of the choice to get
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the ID of the currently selected option
fileChooserGetChoice chooser id = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    id' <- textToCString id
    result <- gtk_file_chooser_get_choice chooser' id'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr chooser
    freeMem id'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileChooserGetChoiceMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetChoiceMethodInfo a signature where
    overloadedMethod = fileChooserGetChoice

instance O.OverloadedMethodInfo FileChooserGetChoiceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetChoice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetChoice"
        })


#endif

-- method FileChooser::get_create_folders
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_create_folders" gtk_file_chooser_get_create_folders :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO CInt

{-# DEPRECATED fileChooserGetCreateFolders ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets whether file chooser will offer to create new folders.
fileChooserGetCreateFolders ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the Create Folder button should be displayed.
fileChooserGetCreateFolders chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_create_folders chooser'
    let result' = (/= 0) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetCreateFoldersMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetCreateFoldersMethodInfo a signature where
    overloadedMethod = fileChooserGetCreateFolders

instance O.OverloadedMethodInfo FileChooserGetCreateFoldersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetCreateFolders",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetCreateFolders"
        })


#endif

-- method FileChooser::get_current_folder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_current_folder" gtk_file_chooser_get_current_folder :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gio.File.File)

{-# DEPRECATED fileChooserGetCurrentFolder ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the current folder of /@chooser@/ as @GFile@.
fileChooserGetCurrentFolder ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ the @GFile@ for the current folder.
fileChooserGetCurrentFolder chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_current_folder chooser'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.File.File) result'
        return result''
    touchManagedPtr chooser
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileChooserGetCurrentFolderMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetCurrentFolderMethodInfo a signature where
    overloadedMethod = fileChooserGetCurrentFolder

instance O.OverloadedMethodInfo FileChooserGetCurrentFolderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetCurrentFolder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetCurrentFolder"
        })


#endif

-- method FileChooser::get_current_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_current_name" gtk_file_chooser_get_current_name :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO CString

{-# DEPRECATED fileChooserGetCurrentName ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the current name in the file selector, as entered by the user.
-- 
-- This is meant to be used in save dialogs, to get the currently typed
-- filename when the file itself does not exist yet.
fileChooserGetCurrentName ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The raw text from the file chooser’s “Name” entry. Free with
    --   'GI.GLib.Functions.free'. Note that this string is not a full pathname or URI; it is
    --   whatever the contents of the entry are. Note also that this string is
    --   in UTF-8 encoding, which is not necessarily the system’s encoding for
    --   filenames.
fileChooserGetCurrentName chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_current_name chooser'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr chooser
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileChooserGetCurrentNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetCurrentNameMethodInfo a signature where
    overloadedMethod = fileChooserGetCurrentName

instance O.OverloadedMethodInfo FileChooserGetCurrentNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetCurrentName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetCurrentName"
        })


#endif

-- method FileChooser::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_file" gtk_file_chooser_get_file :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gio.File.File)

{-# DEPRECATED fileChooserGetFile ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the @GFile@ for the currently selected file in
-- the file selector.
-- 
-- If multiple files are selected, one of the files will be
-- returned at random.
-- 
-- If the file chooser is in folder mode, this function returns
-- the selected folder.
fileChooserGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ a selected @GFile@. You own the
    --   returned file; use 'GI.GObject.Objects.Object.objectUnref' to release it.
fileChooserGetFile chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_file chooser'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.File.File) result'
        return result''
    touchManagedPtr chooser
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileChooserGetFileMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetFileMethodInfo a signature where
    overloadedMethod = fileChooserGetFile

instance O.OverloadedMethodInfo FileChooserGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetFile"
        })


#endif

-- method FileChooser::get_files
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_files" gtk_file_chooser_get_files :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gio.ListModel.ListModel)

{-# DEPRECATED fileChooserGetFiles ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Lists all the selected files and subfolders in the current folder
-- of /@chooser@/ as @GFile@.
fileChooserGetFiles ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ a list model containing a @GFile@ for each
    --   selected file and subfolder in the current folder. Free the returned
    --   list with 'GI.GObject.Objects.Object.objectUnref'.
fileChooserGetFiles chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_files chooser'
    checkUnexpectedReturnNULL "fileChooserGetFiles" result
    result' <- (wrapObject Gio.ListModel.ListModel) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetFilesMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetFilesMethodInfo a signature where
    overloadedMethod = fileChooserGetFiles

instance O.OverloadedMethodInfo FileChooserGetFilesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetFiles",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetFiles"
        })


#endif

-- method FileChooser::get_filter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FileFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_filter" gtk_file_chooser_get_filter :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gtk.FileFilter.FileFilter)

{-# DEPRECATED fileChooserGetFilter ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the current filter.
fileChooserGetFilter ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m (Maybe Gtk.FileFilter.FileFilter)
    -- ^ __Returns:__ the current filter
fileChooserGetFilter chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_filter chooser'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.FileFilter.FileFilter) result'
        return result''
    touchManagedPtr chooser
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileChooserGetFilterMethodInfo
instance (signature ~ (m (Maybe Gtk.FileFilter.FileFilter)), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetFilterMethodInfo a signature where
    overloadedMethod = fileChooserGetFilter

instance O.OverloadedMethodInfo FileChooserGetFilterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetFilter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetFilter"
        })


#endif

-- method FileChooser::get_filters
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_filters" gtk_file_chooser_get_filters :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gio.ListModel.ListModel)

{-# DEPRECATED fileChooserGetFilters ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets the current set of user-selectable filters, as a list model.
-- 
-- See 'GI.Gtk.Interfaces.FileChooser.fileChooserAddFilter' and
-- 'GI.Gtk.Interfaces.FileChooser.fileChooserRemoveFilter' for changing individual filters.
-- 
-- You should not modify the returned list model. Future changes to
-- /@chooser@/ may or may not affect the returned model.
fileChooserGetFilters ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ a @GListModel@ containing the current set
    --   of user-selectable filters.
fileChooserGetFilters chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_filters chooser'
    checkUnexpectedReturnNULL "fileChooserGetFilters" result
    result' <- (wrapObject Gio.ListModel.ListModel) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetFiltersMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetFiltersMethodInfo a signature where
    overloadedMethod = fileChooserGetFilters

instance O.OverloadedMethodInfo FileChooserGetFiltersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetFilters",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetFilters"
        })


#endif

-- method FileChooser::get_select_multiple
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_select_multiple" gtk_file_chooser_get_select_multiple :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO CInt

{-# DEPRECATED fileChooserGetSelectMultiple ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Gets whether multiple files can be selected in the file
-- chooser.
fileChooserGetSelectMultiple ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if multiple files can be selected.
fileChooserGetSelectMultiple chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_select_multiple chooser'
    let result' = (/= 0) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetSelectMultipleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetSelectMultipleMethodInfo a signature where
    overloadedMethod = fileChooserGetSelectMultiple

instance O.OverloadedMethodInfo FileChooserGetSelectMultipleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetSelectMultiple",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetSelectMultiple"
        })


#endif

-- method FileChooser::get_shortcut_folders
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_get_shortcut_folders" gtk_file_chooser_get_shortcut_folders :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    IO (Ptr Gio.ListModel.ListModel)

{-# DEPRECATED fileChooserGetShortcutFolders ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Queries the list of shortcut folders in the file chooser.
-- 
-- You should not modify the returned list model. Future changes to
-- /@chooser@/ may or may not affect the returned model.
fileChooserGetShortcutFolders ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ A list model of @GFile@s
fileChooserGetShortcutFolders chooser = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    result <- gtk_file_chooser_get_shortcut_folders chooser'
    checkUnexpectedReturnNULL "fileChooserGetShortcutFolders" result
    result' <- (wrapObject Gio.ListModel.ListModel) result
    touchManagedPtr chooser
    return result'

#if defined(ENABLE_OVERLOADING)
data FileChooserGetShortcutFoldersMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserGetShortcutFoldersMethodInfo a signature where
    overloadedMethod = fileChooserGetShortcutFolders

instance O.OverloadedMethodInfo FileChooserGetShortcutFoldersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserGetShortcutFolders",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserGetShortcutFolders"
        })


#endif

-- method FileChooser::remove_choice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the choice to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_remove_choice" gtk_file_chooser_remove_choice :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CString ->                              -- id : TBasicType TUTF8
    IO ()

{-# DEPRECATED fileChooserRemoveChoice ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Removes a \'choice\' that has been added with 'GI.Gtk.Interfaces.FileChooser.fileChooserAddChoice'.
fileChooserRemoveChoice ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> T.Text
    -- ^ /@id@/: the ID of the choice to remove
    -> m ()
fileChooserRemoveChoice chooser id = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    id' <- textToCString id
    gtk_file_chooser_remove_choice chooser' id'
    touchManagedPtr chooser
    freeMem id'
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserRemoveChoiceMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserRemoveChoiceMethodInfo a signature where
    overloadedMethod = fileChooserRemoveChoice

instance O.OverloadedMethodInfo FileChooserRemoveChoiceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserRemoveChoice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserRemoveChoice"
        })


#endif

-- method FileChooser::remove_filter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileFilter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_remove_filter" gtk_file_chooser_remove_filter :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gtk.FileFilter.FileFilter ->        -- filter : TInterface (Name {namespace = "Gtk", name = "FileFilter"})
    IO ()

{-# DEPRECATED fileChooserRemoveFilter ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Removes /@filter@/ from the list of filters that the user can select between.
fileChooserRemoveFilter ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@filter@/: a @GtkFileFilter@
    -> m ()
fileChooserRemoveFilter chooser filter = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    filter' <- unsafeManagedPtrCastPtr filter
    gtk_file_chooser_remove_filter chooser' filter'
    touchManagedPtr chooser
    touchManagedPtr filter
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserRemoveFilterMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) => O.OverloadedMethod FileChooserRemoveFilterMethodInfo a signature where
    overloadedMethod = fileChooserRemoveFilter

instance O.OverloadedMethodInfo FileChooserRemoveFilterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserRemoveFilter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserRemoveFilter"
        })


#endif

-- method FileChooser::remove_shortcut_folder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "folder"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GFile` for the folder to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_chooser_remove_shortcut_folder" gtk_file_chooser_remove_shortcut_folder :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gio.File.File ->                    -- folder : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED fileChooserRemoveShortcutFolder ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Removes a folder from the shortcut folders in a file chooser.
fileChooserRemoveShortcutFolder ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gio.File.IsFile b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@folder@/: a @GFile@ for the folder to remove
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileChooserRemoveShortcutFolder chooser folder = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    folder' <- unsafeManagedPtrCastPtr folder
    onException (do
        _ <- propagateGError $ gtk_file_chooser_remove_shortcut_folder chooser' folder'
        touchManagedPtr chooser
        touchManagedPtr folder
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileChooserRemoveShortcutFolderMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gio.File.IsFile b) => O.OverloadedMethod FileChooserRemoveShortcutFolderMethodInfo a signature where
    overloadedMethod = fileChooserRemoveShortcutFolder

instance O.OverloadedMethodInfo FileChooserRemoveShortcutFolderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserRemoveShortcutFolder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserRemoveShortcutFolder"
        })


#endif

-- method FileChooser::set_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooserAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the action that the file selector is performing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_action" gtk_file_chooser_set_action :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CUInt ->                                -- action : TInterface (Name {namespace = "Gtk", name = "FileChooserAction"})
    IO ()

{-# DEPRECATED fileChooserSetAction ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets the type of operation that the chooser is performing.
-- 
-- The user interface is adapted to suit the selected action.
-- 
-- For example, an option to create a new folder might be shown
-- if the action is 'GI.Gtk.Enums.FileChooserActionSave' but not if the
-- action is 'GI.Gtk.Enums.FileChooserActionOpen'.
fileChooserSetAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> Gtk.Enums.FileChooserAction
    -- ^ /@action@/: the action that the file selector is performing
    -> m ()
fileChooserSetAction chooser action = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    let action' = (fromIntegral . fromEnum) action
    gtk_file_chooser_set_action chooser' action'
    touchManagedPtr chooser
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetActionMethodInfo
instance (signature ~ (Gtk.Enums.FileChooserAction -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserSetActionMethodInfo a signature where
    overloadedMethod = fileChooserSetAction

instance O.OverloadedMethodInfo FileChooserSetActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetAction"
        })


#endif

-- method FileChooser::set_choice
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the choice to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "option"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID of the option to select"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_choice" gtk_file_chooser_set_choice :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CString ->                              -- id : TBasicType TUTF8
    CString ->                              -- option : TBasicType TUTF8
    IO ()

{-# DEPRECATED fileChooserSetChoice ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Selects an option in a \'choice\' that has been added with
-- 'GI.Gtk.Interfaces.FileChooser.fileChooserAddChoice'.
-- 
-- For a boolean choice, the possible options are \"true\" and \"false\".
fileChooserSetChoice ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> T.Text
    -- ^ /@id@/: the ID of the choice to set
    -> T.Text
    -- ^ /@option@/: the ID of the option to select
    -> m ()
fileChooserSetChoice chooser id option = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    id' <- textToCString id
    option' <- textToCString option
    gtk_file_chooser_set_choice chooser' id' option'
    touchManagedPtr chooser
    freeMem id'
    freeMem option'
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetChoiceMethodInfo
instance (signature ~ (T.Text -> T.Text -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserSetChoiceMethodInfo a signature where
    overloadedMethod = fileChooserSetChoice

instance O.OverloadedMethodInfo FileChooserSetChoiceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetChoice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetChoice"
        })


#endif

-- method FileChooser::set_create_folders
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "create_folders"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the Create Folder button should be displayed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_create_folders" gtk_file_chooser_set_create_folders :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CInt ->                                 -- create_folders : TBasicType TBoolean
    IO ()

{-# DEPRECATED fileChooserSetCreateFolders ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets whether file chooser will offer to create new folders.
-- 
-- This is only relevant if the action is not set to be
-- 'GI.Gtk.Enums.FileChooserActionOpen'.
fileChooserSetCreateFolders ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> Bool
    -- ^ /@createFolders@/: 'P.True' if the Create Folder button should be displayed
    -> m ()
fileChooserSetCreateFolders chooser createFolders = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    let createFolders' = (P.fromIntegral . P.fromEnum) createFolders
    gtk_file_chooser_set_create_folders chooser' createFolders'
    touchManagedPtr chooser
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetCreateFoldersMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserSetCreateFoldersMethodInfo a signature where
    overloadedMethod = fileChooserSetCreateFolders

instance O.OverloadedMethodInfo FileChooserSetCreateFoldersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetCreateFolders",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetCreateFolders"
        })


#endif

-- method FileChooser::set_current_folder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GFile` for the new folder"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_current_folder" gtk_file_chooser_set_current_folder :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED fileChooserSetCurrentFolder ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets the current folder for /@chooser@/ from a @GFile@.
fileChooserSetCurrentFolder ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gio.File.IsFile b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> Maybe (b)
    -- ^ /@file@/: the @GFile@ for the new folder
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileChooserSetCurrentFolder chooser file = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    onException (do
        _ <- propagateGError $ gtk_file_chooser_set_current_folder chooser' maybeFile
        touchManagedPtr chooser
        whenJust file touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileChooserSetCurrentFolderMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFileChooser a, Gio.File.IsFile b) => O.OverloadedMethod FileChooserSetCurrentFolderMethodInfo a signature where
    overloadedMethod = fileChooserSetCurrentFolder

instance O.OverloadedMethodInfo FileChooserSetCurrentFolderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetCurrentFolder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetCurrentFolder"
        })


#endif

-- method FileChooser::set_current_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename to use, as a UTF-8 string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_current_name" gtk_file_chooser_set_current_name :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

{-# DEPRECATED fileChooserSetCurrentName ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets the current name in the file selector, as if entered
-- by the user.
-- 
-- Note that the name passed in here is a UTF-8 string rather
-- than a filename. This function is meant for such uses as a
-- suggested name in a “Save As...” dialog.  You can pass
-- “Untitled.doc” or a similarly suitable suggestion for the /@name@/.
-- 
-- If you want to preselect a particular existing file, you should
-- use 'GI.Gtk.Interfaces.FileChooser.fileChooserSetFile' instead.
-- 
-- Please see the documentation for those functions for an example
-- of using 'GI.Gtk.Interfaces.FileChooser.fileChooserSetCurrentName' as well.
fileChooserSetCurrentName ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> T.Text
    -- ^ /@name@/: the filename to use, as a UTF-8 string
    -> m ()
fileChooserSetCurrentName chooser name = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    name' <- textToCString name
    gtk_file_chooser_set_current_name chooser' name'
    touchManagedPtr chooser
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetCurrentNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserSetCurrentNameMethodInfo a signature where
    overloadedMethod = fileChooserSetCurrentName

instance O.OverloadedMethodInfo FileChooserSetCurrentNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetCurrentName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetCurrentName"
        })


#endif

-- method FileChooser::set_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GFile` to set as current"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_file" gtk_file_chooser_set_file :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED fileChooserSetFile ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets /@file@/ as the current filename for the file chooser.
-- 
-- This includes changing to the file’s parent folder and actually selecting
-- the file in list. If the /@chooser@/ is in 'GI.Gtk.Enums.FileChooserActionSave' mode,
-- the file’s base name will also appear in the dialog’s file name entry.
-- 
-- If the file name isn’t in the current folder of /@chooser@/, then the current
-- folder of /@chooser@/ will be changed to the folder containing /@file@/.
-- 
-- Note that the file must exist, or nothing will be done except
-- for the directory change.
-- 
-- If you are implementing a save dialog, you should use this function if
-- you already have a file name to which the user may save; for example,
-- when the user opens an existing file and then does “Save As…”. If you
-- don’t have a file name already — for example, if the user just created
-- a new file and is saving it for the first time, do not call this function.
-- 
-- Instead, use something similar to this:
-- 
-- 
-- === /c code/
-- >static void
-- >prepare_file_chooser (GtkFileChooser *chooser,
-- >                      GFile          *existing_file)
-- >{
-- >  gboolean document_is_new = (existing_file == NULL);
-- >
-- >  if (document_is_new)
-- >    {
-- >      GFile *default_file_for_saving = g_file_new_for_path ("./out.txt");
-- >      // the user just created a new document
-- >      gtk_file_chooser_set_current_folder (chooser, default_file_for_saving, NULL);
-- >      gtk_file_chooser_set_current_name (chooser, "Untitled document");
-- >      g_object_unref (default_file_for_saving);
-- >    }
-- >  else
-- >    {
-- >      // the user edited an existing document
-- >      gtk_file_chooser_set_file (chooser, existing_file, NULL);
-- >    }
-- >}
fileChooserSetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gio.File.IsFile b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@file@/: the @GFile@ to set as current
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileChooserSetFile chooser file = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    file' <- unsafeManagedPtrCastPtr file
    onException (do
        _ <- propagateGError $ gtk_file_chooser_set_file chooser' file'
        touchManagedPtr chooser
        touchManagedPtr file
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileChooserSetFileMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gio.File.IsFile b) => O.OverloadedMethod FileChooserSetFileMethodInfo a signature where
    overloadedMethod = fileChooserSetFile

instance O.OverloadedMethodInfo FileChooserSetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetFile"
        })


#endif

-- method FileChooser::set_filter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileFilter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_filter" gtk_file_chooser_set_filter :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    Ptr Gtk.FileFilter.FileFilter ->        -- filter : TInterface (Name {namespace = "Gtk", name = "FileFilter"})
    IO ()

{-# DEPRECATED fileChooserSetFilter ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets the current filter.
-- 
-- Only the files that pass the filter will be displayed.
-- If the user-selectable list of filters is non-empty, then
-- the filter should be one of the filters in that list.
-- 
-- Setting the current filter when the list of filters is
-- empty is useful if you want to restrict the displayed
-- set of files without letting the user change it.
fileChooserSetFilter ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> b
    -- ^ /@filter@/: a @GtkFileFilter@
    -> m ()
fileChooserSetFilter chooser filter = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    filter' <- unsafeManagedPtrCastPtr filter
    gtk_file_chooser_set_filter chooser' filter'
    touchManagedPtr chooser
    touchManagedPtr filter
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetFilterMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileChooser a, Gtk.FileFilter.IsFileFilter b) => O.OverloadedMethod FileChooserSetFilterMethodInfo a signature where
    overloadedMethod = fileChooserSetFilter

instance O.OverloadedMethodInfo FileChooserSetFilterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetFilter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetFilter"
        })


#endif

-- method FileChooser::set_select_multiple
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "chooser"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFileChooser`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "select_multiple"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if multiple files can be selected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_set_select_multiple" gtk_file_chooser_set_select_multiple :: 
    Ptr FileChooser ->                      -- chooser : TInterface (Name {namespace = "Gtk", name = "FileChooser"})
    CInt ->                                 -- select_multiple : TBasicType TBoolean
    IO ()

{-# DEPRECATED fileChooserSetSelectMultiple ["(Since version 4.10)","Use t'GI.Gtk.Objects.FileDialog.FileDialog' instead"] #-}
-- | Sets whether multiple files can be selected in the file chooser.
-- 
-- This is only relevant if the action is set to be
-- 'GI.Gtk.Enums.FileChooserActionOpen' or
-- 'GI.Gtk.Enums.FileChooserActionSelectFolder'.
fileChooserSetSelectMultiple ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileChooser a) =>
    a
    -- ^ /@chooser@/: a @GtkFileChooser@
    -> Bool
    -- ^ /@selectMultiple@/: 'P.True' if multiple files can be selected.
    -> m ()
fileChooserSetSelectMultiple chooser selectMultiple = liftIO $ do
    chooser' <- unsafeManagedPtrCastPtr chooser
    let selectMultiple' = (P.fromIntegral . P.fromEnum) selectMultiple
    gtk_file_chooser_set_select_multiple chooser' selectMultiple'
    touchManagedPtr chooser
    return ()

#if defined(ENABLE_OVERLOADING)
data FileChooserSetSelectMultipleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFileChooser a) => O.OverloadedMethod FileChooserSetSelectMultipleMethodInfo a signature where
    overloadedMethod = fileChooserSetSelectMultiple

instance O.OverloadedMethodInfo FileChooserSetSelectMultipleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.FileChooser.fileChooserSetSelectMultiple",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-FileChooser.html#v:fileChooserSetSelectMultiple"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileChooser = FileChooserSignalList
type FileChooserSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


