{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkStyleContext@ stores styling information affecting a widget.
-- 
-- In order to construct the final style information, @GtkStyleContext@
-- queries information from all attached @GtkStyleProviders@. Style
-- providers can be either attached explicitly to the context through
-- 'GI.Gtk.Objects.StyleContext.styleContextAddProvider', or to the display through
-- 'GI.Gtk.Objects.StyleContext.styleContextAddProviderForDisplay'. The resulting
-- style is a combination of all providers’ information in priority order.
-- 
-- For GTK widgets, any @GtkStyleContext@ returned by
-- 'GI.Gtk.Objects.Widget.widgetGetStyleContext' will already have a @GdkDisplay@
-- and RTL\/LTR information set. The style context will also be updated
-- automatically if any of these settings change on the widget.
-- 
-- == Style Classes
-- 
-- Widgets can add style classes to their context, which can be used to associate
-- different styles by class. The documentation for individual widgets lists
-- which style classes it uses itself, and which style classes may be added by
-- applications to affect their appearance.
-- 
-- = Custom styling in UI libraries and applications
-- 
-- If you are developing a library with custom widgets that render differently
-- than standard components, you may need to add a @GtkStyleProvider@ yourself
-- with the 'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_FALLBACK' priority, either a
-- @GtkCssProvider@ or a custom object implementing the @GtkStyleProvider@
-- interface. This way themes may still attempt to style your UI elements in
-- a different way if needed so.
-- 
-- If you are using custom styling on an applications, you probably want then
-- to make your style information prevail to the theme’s, so you must use
-- a @GtkStyleProvider@ with the 'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_APPLICATION'
-- priority, keep in mind that the user settings in
-- @XDG_CONFIG_HOME\/gtk-4.0\/gtk.css@ will
-- still take precedence over your changes, as it uses the
-- 'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_USER' priority.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StyleContext
    ( 

-- * Exported types
    StyleContext(..)                        ,
    IsStyleContext                          ,
    toStyleContext                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addClass]("GI.Gtk.Objects.StyleContext#g:method:addClass"), [addProvider]("GI.Gtk.Objects.StyleContext#g:method:addProvider"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasClass]("GI.Gtk.Objects.StyleContext#g:method:hasClass"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lookupColor]("GI.Gtk.Objects.StyleContext#g:method:lookupColor"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeClass]("GI.Gtk.Objects.StyleContext#g:method:removeClass"), [removeProvider]("GI.Gtk.Objects.StyleContext#g:method:removeProvider"), [restore]("GI.Gtk.Objects.StyleContext#g:method:restore"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [save]("GI.Gtk.Objects.StyleContext#g:method:save"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gtk.Objects.StyleContext#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBorder]("GI.Gtk.Objects.StyleContext#g:method:getBorder"), [getColor]("GI.Gtk.Objects.StyleContext#g:method:getColor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gtk.Objects.StyleContext#g:method:getDisplay"), [getMargin]("GI.Gtk.Objects.StyleContext#g:method:getMargin"), [getPadding]("GI.Gtk.Objects.StyleContext#g:method:getPadding"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScale]("GI.Gtk.Objects.StyleContext#g:method:getScale"), [getState]("GI.Gtk.Objects.StyleContext#g:method:getState").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDisplay]("GI.Gtk.Objects.StyleContext#g:method:setDisplay"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setScale]("GI.Gtk.Objects.StyleContext#g:method:setScale"), [setState]("GI.Gtk.Objects.StyleContext#g:method:setState").

#if defined(ENABLE_OVERLOADING)
    ResolveStyleContextMethod               ,
#endif

-- ** addClass #method:addClass#

#if defined(ENABLE_OVERLOADING)
    StyleContextAddClassMethodInfo          ,
#endif
    styleContextAddClass                    ,


-- ** addProvider #method:addProvider#

#if defined(ENABLE_OVERLOADING)
    StyleContextAddProviderMethodInfo       ,
#endif
    styleContextAddProvider                 ,


-- ** addProviderForDisplay #method:addProviderForDisplay#

    styleContextAddProviderForDisplay       ,


-- ** getBorder #method:getBorder#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetBorderMethodInfo         ,
#endif
    styleContextGetBorder                   ,


-- ** getColor #method:getColor#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetColorMethodInfo          ,
#endif
    styleContextGetColor                    ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetDisplayMethodInfo        ,
#endif
    styleContextGetDisplay                  ,


-- ** getMargin #method:getMargin#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetMarginMethodInfo         ,
#endif
    styleContextGetMargin                   ,


-- ** getPadding #method:getPadding#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetPaddingMethodInfo        ,
#endif
    styleContextGetPadding                  ,


-- ** getScale #method:getScale#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetScaleMethodInfo          ,
#endif
    styleContextGetScale                    ,


-- ** getState #method:getState#

#if defined(ENABLE_OVERLOADING)
    StyleContextGetStateMethodInfo          ,
#endif
    styleContextGetState                    ,


-- ** hasClass #method:hasClass#

#if defined(ENABLE_OVERLOADING)
    StyleContextHasClassMethodInfo          ,
#endif
    styleContextHasClass                    ,


-- ** lookupColor #method:lookupColor#

#if defined(ENABLE_OVERLOADING)
    StyleContextLookupColorMethodInfo       ,
#endif
    styleContextLookupColor                 ,


-- ** removeClass #method:removeClass#

#if defined(ENABLE_OVERLOADING)
    StyleContextRemoveClassMethodInfo       ,
#endif
    styleContextRemoveClass                 ,


-- ** removeProvider #method:removeProvider#

#if defined(ENABLE_OVERLOADING)
    StyleContextRemoveProviderMethodInfo    ,
#endif
    styleContextRemoveProvider              ,


-- ** removeProviderForDisplay #method:removeProviderForDisplay#

    styleContextRemoveProviderForDisplay    ,


-- ** restore #method:restore#

#if defined(ENABLE_OVERLOADING)
    StyleContextRestoreMethodInfo           ,
#endif
    styleContextRestore                     ,


-- ** save #method:save#

#if defined(ENABLE_OVERLOADING)
    StyleContextSaveMethodInfo              ,
#endif
    styleContextSave                        ,


-- ** setDisplay #method:setDisplay#

#if defined(ENABLE_OVERLOADING)
    StyleContextSetDisplayMethodInfo        ,
#endif
    styleContextSetDisplay                  ,


-- ** setScale #method:setScale#

#if defined(ENABLE_OVERLOADING)
    StyleContextSetScaleMethodInfo          ,
#endif
    styleContextSetScale                    ,


-- ** setState #method:setState#

#if defined(ENABLE_OVERLOADING)
    StyleContextSetStateMethodInfo          ,
#endif
    styleContextSetState                    ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    StyleContextToStringMethodInfo          ,
#endif
    styleContextToString                    ,




 -- * Properties


-- ** display #attr:display#
-- | The display of the style context.

#if defined(ENABLE_OVERLOADING)
    StyleContextDisplayPropertyInfo         ,
#endif
    constructStyleContextDisplay            ,
    getStyleContextDisplay                  ,
    setStyleContextDisplay                  ,
#if defined(ENABLE_OVERLOADING)
    styleContextDisplay                     ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border

#endif

-- | Memory-managed wrapper type.
newtype StyleContext = StyleContext (SP.ManagedPtr StyleContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype StyleContext where
    toManagedPtr (StyleContext p) = p

foreign import ccall "gtk_style_context_get_type"
    c_gtk_style_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject StyleContext where
    glibType = c_gtk_style_context_get_type

instance B.Types.GObject StyleContext

-- | Type class for types which can be safely cast to t'StyleContext', for instance with `toStyleContext`.
class (SP.GObject o, O.IsDescendantOf StyleContext o) => IsStyleContext o
instance (SP.GObject o, O.IsDescendantOf StyleContext o) => IsStyleContext o

instance O.HasParentTypes StyleContext
type instance O.ParentTypes StyleContext = '[GObject.Object.Object]

-- | Cast to t'StyleContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStyleContext :: (MIO.MonadIO m, IsStyleContext o) => o -> m StyleContext
toStyleContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo StyleContext

-- | Convert t'StyleContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StyleContext) where
    gvalueGType_ = c_gtk_style_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StyleContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StyleContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StyleContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStyleContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStyleContextMethod "addClass" o = StyleContextAddClassMethodInfo
    ResolveStyleContextMethod "addProvider" o = StyleContextAddProviderMethodInfo
    ResolveStyleContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStyleContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStyleContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStyleContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStyleContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStyleContextMethod "hasClass" o = StyleContextHasClassMethodInfo
    ResolveStyleContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStyleContextMethod "lookupColor" o = StyleContextLookupColorMethodInfo
    ResolveStyleContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStyleContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStyleContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStyleContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStyleContextMethod "removeClass" o = StyleContextRemoveClassMethodInfo
    ResolveStyleContextMethod "removeProvider" o = StyleContextRemoveProviderMethodInfo
    ResolveStyleContextMethod "restore" o = StyleContextRestoreMethodInfo
    ResolveStyleContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStyleContextMethod "save" o = StyleContextSaveMethodInfo
    ResolveStyleContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStyleContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStyleContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStyleContextMethod "toString" o = StyleContextToStringMethodInfo
    ResolveStyleContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStyleContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStyleContextMethod "getBorder" o = StyleContextGetBorderMethodInfo
    ResolveStyleContextMethod "getColor" o = StyleContextGetColorMethodInfo
    ResolveStyleContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStyleContextMethod "getDisplay" o = StyleContextGetDisplayMethodInfo
    ResolveStyleContextMethod "getMargin" o = StyleContextGetMarginMethodInfo
    ResolveStyleContextMethod "getPadding" o = StyleContextGetPaddingMethodInfo
    ResolveStyleContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStyleContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStyleContextMethod "getScale" o = StyleContextGetScaleMethodInfo
    ResolveStyleContextMethod "getState" o = StyleContextGetStateMethodInfo
    ResolveStyleContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStyleContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStyleContextMethod "setDisplay" o = StyleContextSetDisplayMethodInfo
    ResolveStyleContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStyleContextMethod "setScale" o = StyleContextSetScaleMethodInfo
    ResolveStyleContextMethod "setState" o = StyleContextSetStateMethodInfo
    ResolveStyleContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStyleContextMethod t StyleContext, O.OverloadedMethod info StyleContext p) => OL.IsLabel t (StyleContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStyleContextMethod t StyleContext, O.OverloadedMethod info StyleContext p, R.HasField t StyleContext p) => R.HasField t StyleContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStyleContextMethod t StyleContext, O.OverloadedMethodInfo info StyleContext) => OL.IsLabel t (O.MethodProxy info StyleContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' styleContext #display
-- @
getStyleContextDisplay :: (MonadIO m, IsStyleContext o) => o -> m Gdk.Display.Display
getStyleContextDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getStyleContextDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Set the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' styleContext [ #display 'Data.GI.Base.Attributes.:=' value ]
-- @
setStyleContextDisplay :: (MonadIO m, IsStyleContext o, Gdk.Display.IsDisplay a) => o -> a -> m ()
setStyleContextDisplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "display" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStyleContextDisplay :: (IsStyleContext o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructStyleContextDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StyleContextDisplayPropertyInfo
instance AttrInfo StyleContextDisplayPropertyInfo where
    type AttrAllowedOps StyleContextDisplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StyleContextDisplayPropertyInfo = IsStyleContext
    type AttrSetTypeConstraint StyleContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint StyleContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType StyleContextDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType StyleContextDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel StyleContextDisplayPropertyInfo = "display"
    type AttrOrigin StyleContextDisplayPropertyInfo = StyleContext
    attrGet = getStyleContextDisplay
    attrSet = setStyleContextDisplay
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructStyleContextDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#g:attr:display"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StyleContext
type instance O.AttributeList StyleContext = StyleContextAttributeList
type StyleContextAttributeList = ('[ '("display", StyleContextDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
styleContextDisplay :: AttrLabelProxy "display"
styleContextDisplay = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StyleContext = StyleContextSignalList
type StyleContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StyleContext::add_class
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "class name to use in styling"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_add_class" gtk_style_context_add_class :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CString ->                              -- class_name : TBasicType TUTF8
    IO ()

{-# DEPRECATED styleContextAddClass ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetAddCssClass' instead"] #-}
-- | Adds a style class to /@context@/, so later uses of the
-- style context will make use of this new class for styling.
-- 
-- In the CSS file format, a @GtkEntry@ defining a “search”
-- class, would be matched by:
-- 
-- 
-- === /css code/
-- >entry.search { ... }
-- 
-- 
-- While any widget defining a “search” class would be
-- matched by:
-- 
-- === /css code/
-- >.search { ... }
styleContextAddClass ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> T.Text
    -- ^ /@className@/: class name to use in styling
    -> m ()
styleContextAddClass context className = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    className' <- textToCString className
    gtk_style_context_add_class context' className'
    touchManagedPtr context
    freeMem className'
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextAddClassMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextAddClassMethodInfo a signature where
    overloadedMethod = styleContextAddClass

instance O.OverloadedMethodInfo StyleContextAddClassMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextAddClass",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextAddClass"
        })


#endif

-- method StyleContext::add_provider
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the style provider. The lower\n  it is, the earlier it will be used in the style construction.\n  Typically this will be in the range between\n  %GTK_STYLE_PROVIDER_PRIORITY_FALLBACK and\n  %GTK_STYLE_PROVIDER_PRIORITY_USER"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_add_provider" gtk_style_context_add_provider :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gtk.StyleProvider.StyleProvider ->  -- provider : TInterface (Name {namespace = "Gtk", name = "StyleProvider"})
    Word32 ->                               -- priority : TBasicType TUInt
    IO ()

{-# DEPRECATED styleContextAddProvider ["(Since version 4.10)","Use style classes instead"] #-}
-- | Adds a style provider to /@context@/, to be used in style construction.
-- 
-- Note that a style provider added by this function only affects
-- the style of the widget to which /@context@/ belongs. If you want
-- to affect the style of all widgets, use
-- 'GI.Gtk.Objects.StyleContext.styleContextAddProviderForDisplay'.
-- 
-- Note: If both priorities are the same, a @GtkStyleProvider@
-- added through this function takes precedence over another added
-- through 'GI.Gtk.Objects.StyleContext.styleContextAddProviderForDisplay'.
styleContextAddProvider ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a, Gtk.StyleProvider.IsStyleProvider b) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> b
    -- ^ /@provider@/: a @GtkStyleProvider@
    -> Word32
    -- ^ /@priority@/: the priority of the style provider. The lower
    --   it is, the earlier it will be used in the style construction.
    --   Typically this will be in the range between
    --   'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_FALLBACK' and
    --   'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_USER'
    -> m ()
styleContextAddProvider context provider priority = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    provider' <- unsafeManagedPtrCastPtr provider
    gtk_style_context_add_provider context' provider' priority
    touchManagedPtr context
    touchManagedPtr provider
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextAddProviderMethodInfo
instance (signature ~ (b -> Word32 -> m ()), MonadIO m, IsStyleContext a, Gtk.StyleProvider.IsStyleProvider b) => O.OverloadedMethod StyleContextAddProviderMethodInfo a signature where
    overloadedMethod = styleContextAddProvider

instance O.OverloadedMethodInfo StyleContextAddProviderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextAddProvider",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextAddProvider"
        })


#endif

-- method StyleContext::get_border
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "border"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Border" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for the border settings"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_border" gtk_style_context_get_border :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gtk.Border.Border ->                -- border : TInterface (Name {namespace = "Gtk", name = "Border"})
    IO ()

{-# DEPRECATED styleContextGetBorder ["(Since version 4.10)","This api will be removed in GTK 5"] #-}
-- | Gets the border for a given state as a @GtkBorder@.
styleContextGetBorder ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m (Gtk.Border.Border)
styleContextGetBorder context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    border <- SP.callocBoxedBytes 8 :: IO (Ptr Gtk.Border.Border)
    gtk_style_context_get_border context' border
    border' <- (wrapBoxed Gtk.Border.Border) border
    touchManagedPtr context
    return border'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetBorderMethodInfo
instance (signature ~ (m (Gtk.Border.Border)), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetBorderMethodInfo a signature where
    overloadedMethod = styleContextGetBorder

instance O.OverloadedMethodInfo StyleContextGetBorderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetBorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetBorder"
        })


#endif

-- method StyleContext::get_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for the foreground color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_color" gtk_style_context_get_color :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gdk.RGBA.RGBA ->                    -- color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO ()

{-# DEPRECATED styleContextGetColor ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetGetColor' instead"] #-}
-- | Gets the foreground color for a given state.
styleContextGetColor ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m (Gdk.RGBA.RGBA)
styleContextGetColor context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    color <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.RGBA.RGBA)
    gtk_style_context_get_color context' color
    color' <- (wrapBoxed Gdk.RGBA.RGBA) color
    touchManagedPtr context
    return color'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetColorMethodInfo
instance (signature ~ (m (Gdk.RGBA.RGBA)), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetColorMethodInfo a signature where
    overloadedMethod = styleContextGetColor

instance O.OverloadedMethodInfo StyleContextGetColorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetColor"
        })


#endif

-- method StyleContext::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_display" gtk_style_context_get_display :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    IO (Ptr Gdk.Display.Display)

{-# DEPRECATED styleContextGetDisplay ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetGetDisplay' instead"] #-}
-- | Returns the @GdkDisplay@ to which /@context@/ is attached.
styleContextGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a @GdkDisplay@.
styleContextGetDisplay context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gtk_style_context_get_display context'
    checkUnexpectedReturnNULL "styleContextGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetDisplayMethodInfo a signature where
    overloadedMethod = styleContextGetDisplay

instance O.OverloadedMethodInfo StyleContextGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetDisplay"
        })


#endif

-- method StyleContext::get_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "margin"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Border" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for the margin settings"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_margin" gtk_style_context_get_margin :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gtk.Border.Border ->                -- margin : TInterface (Name {namespace = "Gtk", name = "Border"})
    IO ()

{-# DEPRECATED styleContextGetMargin ["(Since version 4.10)","This api will be removed in GTK 5"] #-}
-- | Gets the margin for a given state as a @GtkBorder@.
styleContextGetMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m (Gtk.Border.Border)
styleContextGetMargin context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    margin <- SP.callocBoxedBytes 8 :: IO (Ptr Gtk.Border.Border)
    gtk_style_context_get_margin context' margin
    margin' <- (wrapBoxed Gtk.Border.Border) margin
    touchManagedPtr context
    return margin'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetMarginMethodInfo
instance (signature ~ (m (Gtk.Border.Border)), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetMarginMethodInfo a signature where
    overloadedMethod = styleContextGetMargin

instance O.OverloadedMethodInfo StyleContextGetMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetMargin"
        })


#endif

-- method StyleContext::get_padding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "padding"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Border" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for the padding settings"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_padding" gtk_style_context_get_padding :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gtk.Border.Border ->                -- padding : TInterface (Name {namespace = "Gtk", name = "Border"})
    IO ()

{-# DEPRECATED styleContextGetPadding ["(Since version 4.10)","This api will be removed in GTK 5"] #-}
-- | Gets the padding for a given state as a @GtkBorder@.
styleContextGetPadding ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m (Gtk.Border.Border)
styleContextGetPadding context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    padding <- SP.callocBoxedBytes 8 :: IO (Ptr Gtk.Border.Border)
    gtk_style_context_get_padding context' padding
    padding' <- (wrapBoxed Gtk.Border.Border) padding
    touchManagedPtr context
    return padding'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetPaddingMethodInfo
instance (signature ~ (m (Gtk.Border.Border)), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetPaddingMethodInfo a signature where
    overloadedMethod = styleContextGetPadding

instance O.OverloadedMethodInfo StyleContextGetPaddingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetPadding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetPadding"
        })


#endif

-- method StyleContext::get_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_scale" gtk_style_context_get_scale :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    IO Int32

{-# DEPRECATED styleContextGetScale ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetGetScaleFactor' instead"] #-}
-- | Returns the scale used for assets.
styleContextGetScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m Int32
    -- ^ __Returns:__ the scale
styleContextGetScale context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gtk_style_context_get_scale context'
    touchManagedPtr context
    return result

#if defined(ENABLE_OVERLOADING)
data StyleContextGetScaleMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetScaleMethodInfo a signature where
    overloadedMethod = styleContextGetScale

instance O.OverloadedMethodInfo StyleContextGetScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetScale"
        })


#endif

-- method StyleContext::get_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_get_state" gtk_style_context_get_state :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    IO CUInt

{-# DEPRECATED styleContextGetState ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetGetStateFlags' instead"] #-}
-- | Returns the state used for style matching.
-- 
-- This method should only be used to retrieve the @GtkStateFlags@
-- to pass to @GtkStyleContext@ methods, like
-- 'GI.Gtk.Objects.StyleContext.styleContextGetPadding'.
-- If you need to retrieve the current state of a @GtkWidget@, use
-- 'GI.Gtk.Objects.Widget.widgetGetStateFlags'.
styleContextGetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m [Gtk.Flags.StateFlags]
    -- ^ __Returns:__ the state flags
styleContextGetState context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gtk_style_context_get_state context'
    let result' = wordToGFlags result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data StyleContextGetStateMethodInfo
instance (signature ~ (m [Gtk.Flags.StateFlags]), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextGetStateMethodInfo a signature where
    overloadedMethod = styleContextGetState

instance O.OverloadedMethodInfo StyleContextGetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextGetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextGetState"
        })


#endif

-- method StyleContext::has_class
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a class name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_has_class" gtk_style_context_has_class :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CString ->                              -- class_name : TBasicType TUTF8
    IO CInt

{-# DEPRECATED styleContextHasClass ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetHasCssClass' instead"] #-}
-- | Returns 'P.True' if /@context@/ currently has defined the
-- given class name.
styleContextHasClass ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> T.Text
    -- ^ /@className@/: a class name
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@context@/ has /@className@/ defined
styleContextHasClass context className = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    className' <- textToCString className
    result <- gtk_style_context_has_class context' className'
    let result' = (/= 0) result
    touchManagedPtr context
    freeMem className'
    return result'

#if defined(ENABLE_OVERLOADING)
data StyleContextHasClassMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextHasClassMethodInfo a signature where
    overloadedMethod = styleContextHasClass

instance O.OverloadedMethodInfo StyleContextHasClassMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextHasClass",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextHasClass"
        })


#endif

-- method StyleContext::lookup_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color name to lookup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for the looked up color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_lookup_color" gtk_style_context_lookup_color :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CString ->                              -- color_name : TBasicType TUTF8
    Ptr Gdk.RGBA.RGBA ->                    -- color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO CInt

{-# DEPRECATED styleContextLookupColor ["(Since version 4.10)","This api will be removed in GTK 5"] #-}
-- | Looks up and resolves a color name in the /@context@/ color map.
styleContextLookupColor ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> T.Text
    -- ^ /@colorName@/: color name to lookup
    -> m ((Bool, Gdk.RGBA.RGBA))
    -- ^ __Returns:__ 'P.True' if /@colorName@/ was found and resolved, 'P.False' otherwise
styleContextLookupColor context colorName = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    colorName' <- textToCString colorName
    color <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.RGBA.RGBA)
    result <- gtk_style_context_lookup_color context' colorName' color
    let result' = (/= 0) result
    color' <- (wrapBoxed Gdk.RGBA.RGBA) color
    touchManagedPtr context
    freeMem colorName'
    return (result', color')

#if defined(ENABLE_OVERLOADING)
data StyleContextLookupColorMethodInfo
instance (signature ~ (T.Text -> m ((Bool, Gdk.RGBA.RGBA))), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextLookupColorMethodInfo a signature where
    overloadedMethod = styleContextLookupColor

instance O.OverloadedMethodInfo StyleContextLookupColorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextLookupColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextLookupColor"
        })


#endif

-- method StyleContext::remove_class
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "class name to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_remove_class" gtk_style_context_remove_class :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CString ->                              -- class_name : TBasicType TUTF8
    IO ()

{-# DEPRECATED styleContextRemoveClass ["(Since version 4.10)","Use 'GI.Gtk.Objects.Widget.widgetRemoveCssClass' instead"] #-}
-- | Removes /@className@/ from /@context@/.
styleContextRemoveClass ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> T.Text
    -- ^ /@className@/: class name to remove
    -> m ()
styleContextRemoveClass context className = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    className' <- textToCString className
    gtk_style_context_remove_class context' className'
    touchManagedPtr context
    freeMem className'
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextRemoveClassMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextRemoveClassMethodInfo a signature where
    overloadedMethod = styleContextRemoveClass

instance O.OverloadedMethodInfo StyleContextRemoveClassMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextRemoveClass",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextRemoveClass"
        })


#endif

-- method StyleContext::remove_provider
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_remove_provider" gtk_style_context_remove_provider :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gtk.StyleProvider.StyleProvider ->  -- provider : TInterface (Name {namespace = "Gtk", name = "StyleProvider"})
    IO ()

{-# DEPRECATED styleContextRemoveProvider ["(Since version 4.10)"] #-}
-- | Removes /@provider@/ from the style providers list in /@context@/.
styleContextRemoveProvider ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a, Gtk.StyleProvider.IsStyleProvider b) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> b
    -- ^ /@provider@/: a @GtkStyleProvider@
    -> m ()
styleContextRemoveProvider context provider = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    provider' <- unsafeManagedPtrCastPtr provider
    gtk_style_context_remove_provider context' provider'
    touchManagedPtr context
    touchManagedPtr provider
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextRemoveProviderMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsStyleContext a, Gtk.StyleProvider.IsStyleProvider b) => O.OverloadedMethod StyleContextRemoveProviderMethodInfo a signature where
    overloadedMethod = styleContextRemoveProvider

instance O.OverloadedMethodInfo StyleContextRemoveProviderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextRemoveProvider",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextRemoveProvider"
        })


#endif

-- method StyleContext::restore
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_restore" gtk_style_context_restore :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    IO ()

{-# DEPRECATED styleContextRestore ["(Since version 4.10)","This API will be removed in GTK 5"] #-}
-- | Restores /@context@/ state to a previous stage.
-- 
-- See 'GI.Gtk.Objects.StyleContext.styleContextSave'.
styleContextRestore ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m ()
styleContextRestore context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_style_context_restore context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextRestoreMethodInfo
instance (signature ~ (m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextRestoreMethodInfo a signature where
    overloadedMethod = styleContextRestore

instance O.OverloadedMethodInfo StyleContextRestoreMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextRestore",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextRestore"
        })


#endif

-- method StyleContext::save
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_save" gtk_style_context_save :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    IO ()

{-# DEPRECATED styleContextSave ["(Since version 4.10)","This API will be removed in GTK 5"] #-}
-- | Saves the /@context@/ state.
-- 
-- This allows temporary modifications done through
-- 'GI.Gtk.Objects.StyleContext.styleContextAddClass',
-- 'GI.Gtk.Objects.StyleContext.styleContextRemoveClass',
-- 'GI.Gtk.Objects.StyleContext.styleContextSetState' to be quickly
-- reverted in one go through 'GI.Gtk.Objects.StyleContext.styleContextRestore'.
-- 
-- The matching call to 'GI.Gtk.Objects.StyleContext.styleContextRestore'
-- must be done before GTK returns to the main loop.
styleContextSave ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> m ()
styleContextSave context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_style_context_save context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextSaveMethodInfo
instance (signature ~ (m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextSaveMethodInfo a signature where
    overloadedMethod = styleContextSave

instance O.OverloadedMethodInfo StyleContextSaveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextSave",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextSave"
        })


#endif

-- method StyleContext::set_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_set_display" gtk_style_context_set_display :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

{-# DEPRECATED styleContextSetDisplay ["(Since version 4.10)","You should not use this api"] #-}
-- | Attaches /@context@/ to the given display.
-- 
-- The display is used to add style information from “global”
-- style providers, such as the display\'s @GtkSettings@ instance.
-- 
-- If you are using a @GtkStyleContext@ returned from
-- 'GI.Gtk.Objects.Widget.widgetGetStyleContext', you do not need to
-- call this yourself.
styleContextSetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a, Gdk.Display.IsDisplay b) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> b
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
styleContextSetDisplay context display = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    display' <- unsafeManagedPtrCastPtr display
    gtk_style_context_set_display context' display'
    touchManagedPtr context
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextSetDisplayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsStyleContext a, Gdk.Display.IsDisplay b) => O.OverloadedMethod StyleContextSetDisplayMethodInfo a signature where
    overloadedMethod = styleContextSetDisplay

instance O.OverloadedMethodInfo StyleContextSetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextSetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextSetDisplay"
        })


#endif

-- method StyleContext::set_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "scale" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_set_scale" gtk_style_context_set_scale :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Int32 ->                                -- scale : TBasicType TInt
    IO ()

{-# DEPRECATED styleContextSetScale ["(Since version 4.10)","You should not use this api"] #-}
-- | Sets the scale to use when getting image assets for the style.
styleContextSetScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Int32
    -- ^ /@scale@/: scale
    -> m ()
styleContextSetScale context scale = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_style_context_set_scale context' scale
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextSetScaleMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextSetScaleMethodInfo a signature where
    overloadedMethod = styleContextSetScale

instance O.OverloadedMethodInfo StyleContextSetScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextSetScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextSetScale"
        })


#endif

-- method StyleContext::set_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "state to represent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_set_state" gtk_style_context_set_state :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "StateFlags"})
    IO ()

{-# DEPRECATED styleContextSetState ["(Since version 4.10)","You should not use this api"] #-}
-- | Sets the state to be used for style matching.
styleContextSetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> [Gtk.Flags.StateFlags]
    -- ^ /@flags@/: state to represent
    -> m ()
styleContextSetState context flags = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let flags' = gflagsToWord flags
    gtk_style_context_set_state context' flags'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data StyleContextSetStateMethodInfo
instance (signature ~ ([Gtk.Flags.StateFlags] -> m ()), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextSetStateMethodInfo a signature where
    overloadedMethod = styleContextSetState

instance O.OverloadedMethodInfo StyleContextSetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextSetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextSetState"
        })


#endif

-- method StyleContext::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "StyleContextPrintFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Flags that determine what to print"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_to_string" gtk_style_context_to_string :: 
    Ptr StyleContext ->                     -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "StyleContextPrintFlags"})
    IO CString

{-# DEPRECATED styleContextToString ["(Since version 4.10)","This api will be removed in GTK 5"] #-}
-- | Converts the style context into a string representation.
-- 
-- The string representation always includes information about
-- the name, state, id, visibility and style classes of the CSS
-- node that is backing /@context@/. Depending on the flags, more
-- information may be included.
-- 
-- This function is intended for testing and debugging of the
-- CSS implementation in GTK. There are no guarantees about
-- the format of the returned string, it may change.
styleContextToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> [Gtk.Flags.StyleContextPrintFlags]
    -- ^ /@flags@/: Flags that determine what to print
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string representing /@context@/
styleContextToString context flags = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let flags' = gflagsToWord flags
    result <- gtk_style_context_to_string context' flags'
    checkUnexpectedReturnNULL "styleContextToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data StyleContextToStringMethodInfo
instance (signature ~ ([Gtk.Flags.StyleContextPrintFlags] -> m T.Text), MonadIO m, IsStyleContext a) => O.OverloadedMethod StyleContextToStringMethodInfo a signature where
    overloadedMethod = styleContextToString

instance O.OverloadedMethodInfo StyleContextToStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StyleContext.styleContextToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StyleContext.html#v:styleContextToString"
        })


#endif

-- method StyleContext::add_provider_for_display
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the style provider. The lower\n  it is, the earlier it will be used in the style construction.\n  Typically this will be in the range between\n  %GTK_STYLE_PROVIDER_PRIORITY_FALLBACK and\n  %GTK_STYLE_PROVIDER_PRIORITY_USER"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_add_provider_for_display" gtk_style_context_add_provider_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gtk.StyleProvider.StyleProvider ->  -- provider : TInterface (Name {namespace = "Gtk", name = "StyleProvider"})
    Word32 ->                               -- priority : TBasicType TUInt
    IO ()

-- | Adds a global style provider to /@display@/, which will be used
-- in style construction for all @GtkStyleContexts@ under /@display@/.
-- 
-- GTK uses this to make styling information from @GtkSettings@
-- available.
-- 
-- Note: If both priorities are the same, A @GtkStyleProvider@
-- added through 'GI.Gtk.Objects.StyleContext.styleContextAddProvider' takes
-- precedence over another added through this function.
styleContextAddProviderForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, Gtk.StyleProvider.IsStyleProvider b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@provider@/: a @GtkStyleProvider@
    -> Word32
    -- ^ /@priority@/: the priority of the style provider. The lower
    --   it is, the earlier it will be used in the style construction.
    --   Typically this will be in the range between
    --   'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_FALLBACK' and
    --   'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_USER'
    -> m ()
styleContextAddProviderForDisplay display provider priority = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    provider' <- unsafeManagedPtrCastPtr provider
    gtk_style_context_add_provider_for_display display' provider' priority
    touchManagedPtr display
    touchManagedPtr provider
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method StyleContext::remove_provider_for_display
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_style_context_remove_provider_for_display" gtk_style_context_remove_provider_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gtk.StyleProvider.StyleProvider ->  -- provider : TInterface (Name {namespace = "Gtk", name = "StyleProvider"})
    IO ()

-- | Removes /@provider@/ from the global style providers list in /@display@/.
styleContextRemoveProviderForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, Gtk.StyleProvider.IsStyleProvider b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@provider@/: a @GtkStyleProvider@
    -> m ()
styleContextRemoveProviderForDisplay display provider = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    provider' <- unsafeManagedPtrCastPtr provider
    gtk_style_context_remove_provider_for_display display' provider'
    touchManagedPtr display
    touchManagedPtr provider
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


