

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Callbacks
    ( 

 -- * Signals


-- ** ParseErrorFunc #signal:ParseErrorFunc#

    C_ParseErrorFunc                        ,
    ParseErrorFunc                          ,
    ParseErrorFunc_WithClosures             ,
    drop_closures_ParseErrorFunc            ,
    dynamic_ParseErrorFunc                  ,
    genClosure_ParseErrorFunc               ,
    mk_ParseErrorFunc                       ,
    noParseErrorFunc                        ,
    noParseErrorFunc_WithClosures           ,
    wrap_ParseErrorFunc                     ,


-- ** PathForeachFunc #signal:PathForeachFunc#

    C_PathForeachFunc                       ,
    PathForeachFunc                         ,
    PathForeachFunc_WithClosures            ,
    drop_closures_PathForeachFunc           ,
    dynamic_PathForeachFunc                 ,
    genClosure_PathForeachFunc              ,
    mk_PathForeachFunc                      ,
    noPathForeachFunc                       ,
    noPathForeachFunc_WithClosures          ,
    wrap_PathForeachFunc                    ,


-- ** PathIntersectionFunc #signal:PathIntersectionFunc#

    C_PathIntersectionFunc                  ,
    PathIntersectionFunc                    ,
    PathIntersectionFunc_WithClosures       ,
    drop_closures_PathIntersectionFunc      ,
    dynamic_PathIntersectionFunc            ,
    genClosure_PathIntersectionFunc         ,
    mk_PathIntersectionFunc                 ,
    noPathIntersectionFunc                  ,
    noPathIntersectionFunc_WithClosures     ,
    wrap_PathIntersectionFunc               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Flags as Gsk.Flags
import {-# SOURCE #-} qualified GI.Gsk.Structs.ParseLocation as Gsk.ParseLocation
import {-# SOURCE #-} qualified GI.Gsk.Structs.Path as Gsk.Path
import {-# SOURCE #-} qualified GI.Gsk.Structs.PathMeasure as Gsk.PathMeasure
import {-# SOURCE #-} qualified GI.Gsk.Structs.PathPoint as Gsk.PathPoint
import {-# SOURCE #-} qualified GI.Gsk.Structs.Stroke as Gsk.Stroke

#else
import qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Structs.ParseLocation as Gsk.ParseLocation
import {-# SOURCE #-} qualified GI.Gsk.Structs.Path as Gsk.Path
import {-# SOURCE #-} qualified GI.Gsk.Structs.PathPoint as Gsk.PathPoint

#endif

-- callback PathIntersectionFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "true to continue iterating, false to\n  stop the iteration and not call the function again"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "path1"
          , argType = TInterface Name { namespace = "Gsk" , name = "Path" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the first path" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "point1"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "PathPoint" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the intersection as point on @path1"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path2"
          , argType = TInterface Name { namespace = "Gsk" , name = "Path" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the second path" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "point2"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "PathPoint" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the intersection as point on @path2"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "kind"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "PathIntersection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the nature of the intersection"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Prototype of the callback to iterate through the\nintersections of two paths."
        , sinceVersion = Just "4.20"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PathIntersectionFunc =
    Ptr Gsk.Path.Path ->
    Ptr Gsk.PathPoint.PathPoint ->
    Ptr Gsk.Path.Path ->
    Ptr Gsk.PathPoint.PathPoint ->
    CUInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "path1"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Path" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point1"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "PathPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the intersection as point on @path1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path2"
--           , argType = TInterface Name { namespace = "Gsk" , name = "Path" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point2"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "PathPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the intersection as point on @path2"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "kind"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "PathIntersection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the nature of the intersection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PathIntersectionFunc :: FunPtr C_PathIntersectionFunc -> C_PathIntersectionFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PathIntersectionFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PathIntersectionFunc
    -> Gsk.Path.Path
    -- ^ /@path1@/: the first path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point1@/: the intersection as point on /@path1@/
    -> Gsk.Path.Path
    -- ^ /@path2@/: the second path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point2@/: the intersection as point on /@path2@/
    -> Gsk.Enums.PathIntersection
    -- ^ /@kind@/: the nature of the intersection
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Bool
    -- ^ __Returns:__ true to continue iterating, false to
    --   stop the iteration and not call the function again
dynamic_PathIntersectionFunc __funPtr path1 point1 path2 point2 kind userData = liftIO $ do
    path1' <- unsafeManagedPtrGetPtr path1
    point1' <- unsafeManagedPtrGetPtr point1
    path2' <- unsafeManagedPtrGetPtr path2
    point2' <- unsafeManagedPtrGetPtr point2
    let kind' = (fromIntegral . fromEnum) kind
    result <- (__dynamic_C_PathIntersectionFunc __funPtr) path1' point1' path2' point2' kind' userData
    let result' = (/= 0) result
    touchManagedPtr path1
    touchManagedPtr point1
    touchManagedPtr path2
    touchManagedPtr point2
    return result'

-- | Generate a function pointer callable from C code, from a `C_PathIntersectionFunc`.
foreign import ccall "wrapper"
    mk_PathIntersectionFunc :: C_PathIntersectionFunc -> IO (FunPtr C_PathIntersectionFunc)

-- | Prototype of the callback to iterate through the
-- intersections of two paths.
-- 
-- /Since: 4.20/
type PathIntersectionFunc =
    Gsk.Path.Path
    -- ^ /@path1@/: the first path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point1@/: the intersection as point on /@path1@/
    -> Gsk.Path.Path
    -- ^ /@path2@/: the second path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point2@/: the intersection as point on /@path2@/
    -> Gsk.Enums.PathIntersection
    -- ^ /@kind@/: the nature of the intersection
    -> IO Bool
    -- ^ __Returns:__ true to continue iterating, false to
    --   stop the iteration and not call the function again

-- | A convenience synonym for @`Nothing` :: `Maybe` `PathIntersectionFunc`@.
noPathIntersectionFunc :: Maybe PathIntersectionFunc
noPathIntersectionFunc = Nothing

-- | Prototype of the callback to iterate through the
-- intersections of two paths.
-- 
-- /Since: 4.20/
type PathIntersectionFunc_WithClosures =
    Gsk.Path.Path
    -- ^ /@path1@/: the first path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point1@/: the intersection as point on /@path1@/
    -> Gsk.Path.Path
    -- ^ /@path2@/: the second path
    -> Gsk.PathPoint.PathPoint
    -- ^ /@point2@/: the intersection as point on /@path2@/
    -> Gsk.Enums.PathIntersection
    -- ^ /@kind@/: the nature of the intersection
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Bool
    -- ^ __Returns:__ true to continue iterating, false to
    --   stop the iteration and not call the function again

-- | A convenience synonym for @`Nothing` :: `Maybe` `PathIntersectionFunc_WithClosures`@.
noPathIntersectionFunc_WithClosures :: Maybe PathIntersectionFunc_WithClosures
noPathIntersectionFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PathIntersectionFunc :: PathIntersectionFunc -> PathIntersectionFunc_WithClosures
drop_closures_PathIntersectionFunc _f path1 point1 path2 point2 kind _ = _f path1 point1 path2 point2 kind

-- | Wrap the callback into a `GClosure`.
genClosure_PathIntersectionFunc :: MonadIO m => PathIntersectionFunc -> m (GClosure C_PathIntersectionFunc)
genClosure_PathIntersectionFunc cb = liftIO $ do
    let cb' = drop_closures_PathIntersectionFunc cb
    let cb'' = wrap_PathIntersectionFunc Nothing cb'
    mk_PathIntersectionFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PathIntersectionFunc` into a `C_PathIntersectionFunc`.
wrap_PathIntersectionFunc :: 
    Maybe (Ptr (FunPtr C_PathIntersectionFunc)) ->
    PathIntersectionFunc_WithClosures ->
    C_PathIntersectionFunc
wrap_PathIntersectionFunc gi'funptrptr gi'cb path1 point1 path2 point2 kind userData = do
    B.ManagedPtr.withTransient  path1 $ \path1' -> do
        B.ManagedPtr.withTransient  point1 $ \point1' -> do
            B.ManagedPtr.withTransient  path2 $ \path2' -> do
                B.ManagedPtr.withTransient  point2 $ \point2' -> do
                    let kind' = (toEnum . fromIntegral) kind
                    result <- gi'cb  path1' point1' path2' point2' kind' userData
                    maybeReleaseFunPtr gi'funptrptr
                    let result' = (P.fromIntegral . P.fromEnum) result
                    return result'


-- callback PathForeachFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE to continue iterating the path, %FALSE to\n  immediately abort and not call the function again."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "op"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "PathOperation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The operation" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pts"
          , argType =
              TCArray
                False
                (-1)
                2
                (TInterface Name { namespace = "Graphene" , name = "Point" })
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The points of the operation"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_pts"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The number of points"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "weight"
          , argType = TBasicType TFloat
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The weight for conic curves, or unused if not a conic curve"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The user data provided with the function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of the callback to iterate through the operations of a path.\n\nFor each operation, the callback is given the @op itself, the points\nthat the operation is applied to in @pts, and a @weight for conic\ncurves. The @n_pts argument is somewhat redundant, since the number\nof points can be inferred from the operation.\n\nEach contour of the path starts with a @GSK_PATH_MOVE operation.\nClosed contours end with a @GSK_PATH_CLOSE operation."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PathForeachFunc =
    CUInt ->
    Ptr Graphene.Point.Point ->
    FCT.CSize ->
    CFloat ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "PathOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The operation" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pts"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Graphene" , name = "Point" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The points of the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_pts"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The number of points"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "weight"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The weight for conic curves, or unused if not a conic curve"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The user data provided with the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_pts"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "The number of points"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PathForeachFunc :: FunPtr C_PathForeachFunc -> C_PathForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PathForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PathForeachFunc
    -> Gsk.Enums.PathOperation
    -- ^ /@op@/: The operation
    -> [Graphene.Point.Point]
    -- ^ /@pts@/: The points of the operation
    -> Float
    -- ^ /@weight@/: The weight for conic curves, or unused if not a conic curve
    -> Ptr ()
    -- ^ /@userData@/: The user data provided with the function
    -> m Bool
    -- ^ __Returns:__ 'P.True' to continue iterating the path, 'P.False' to
    --   immediately abort and not call the function again.
dynamic_PathForeachFunc __funPtr op pts weight userData = liftIO $ do
    let nPts = fromIntegral $ P.length pts
    let op' = (fromIntegral . fromEnum) op
    pts' <- mapM unsafeManagedPtrGetPtr pts
    pts'' <- packBlockArray 8 pts'
    let weight' = realToFrac weight
    result <- (__dynamic_C_PathForeachFunc __funPtr) op' pts'' nPts weight' userData
    let result' = (/= 0) result
    mapM_ touchManagedPtr pts
    freeMem pts''
    return result'

-- | Generate a function pointer callable from C code, from a `C_PathForeachFunc`.
foreign import ccall "wrapper"
    mk_PathForeachFunc :: C_PathForeachFunc -> IO (FunPtr C_PathForeachFunc)

-- | Type of the callback to iterate through the operations of a path.
-- 
-- For each operation, the callback is given the /@op@/ itself, the points
-- that the operation is applied to in /@pts@/, and a /@weight@/ for conic
-- curves. The /@nPts@/ argument is somewhat redundant, since the number
-- of points can be inferred from the operation.
-- 
-- Each contour of the path starts with a /@gSKPATHMOVE@/ operation.
-- Closed contours end with a /@gSKPATHCLOSE@/ operation.
type PathForeachFunc =
    Gsk.Enums.PathOperation
    -- ^ /@op@/: The operation
    -> [Graphene.Point.Point]
    -- ^ /@pts@/: The points of the operation
    -> Float
    -- ^ /@weight@/: The weight for conic curves, or unused if not a conic curve
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to continue iterating the path, 'P.False' to
    --   immediately abort and not call the function again.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PathForeachFunc`@.
noPathForeachFunc :: Maybe PathForeachFunc
noPathForeachFunc = Nothing

-- | Type of the callback to iterate through the operations of a path.
-- 
-- For each operation, the callback is given the /@op@/ itself, the points
-- that the operation is applied to in /@pts@/, and a /@weight@/ for conic
-- curves. The /@nPts@/ argument is somewhat redundant, since the number
-- of points can be inferred from the operation.
-- 
-- Each contour of the path starts with a /@gSKPATHMOVE@/ operation.
-- Closed contours end with a /@gSKPATHCLOSE@/ operation.
type PathForeachFunc_WithClosures =
    Gsk.Enums.PathOperation
    -- ^ /@op@/: The operation
    -> [Graphene.Point.Point]
    -- ^ /@pts@/: The points of the operation
    -> Float
    -- ^ /@weight@/: The weight for conic curves, or unused if not a conic curve
    -> Ptr ()
    -- ^ /@userData@/: The user data provided with the function
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to continue iterating the path, 'P.False' to
    --   immediately abort and not call the function again.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PathForeachFunc_WithClosures`@.
noPathForeachFunc_WithClosures :: Maybe PathForeachFunc_WithClosures
noPathForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PathForeachFunc :: PathForeachFunc -> PathForeachFunc_WithClosures
drop_closures_PathForeachFunc _f op pts weight _ = _f op pts weight

-- | Wrap the callback into a `GClosure`.
genClosure_PathForeachFunc :: MonadIO m => PathForeachFunc -> m (GClosure C_PathForeachFunc)
genClosure_PathForeachFunc cb = liftIO $ do
    let cb' = drop_closures_PathForeachFunc cb
    let cb'' = wrap_PathForeachFunc Nothing cb'
    mk_PathForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PathForeachFunc` into a `C_PathForeachFunc`.
wrap_PathForeachFunc :: 
    Maybe (Ptr (FunPtr C_PathForeachFunc)) ->
    PathForeachFunc_WithClosures ->
    C_PathForeachFunc
wrap_PathForeachFunc gi'funptrptr gi'cb op pts nPts weight userData = do
    let op' = (toEnum . fromIntegral) op
    pts' <- (unpackBoxedArrayWithLength 8 nPts) pts
    pts'' <- mapM (newBoxed Graphene.Point.Point) pts'
    let weight' = realToFrac weight
    result <- gi'cb  op' pts'' weight' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ParseErrorFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "start"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "ParseLocation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "start of the error location"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "end"
          , argType =
              TInterface Name { namespace = "Gsk" , name = "ParseLocation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "end of the error location"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the error" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of callback that is called when an error occurs\nduring node deserialization."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ParseErrorFunc =
    Ptr Gsk.ParseLocation.ParseLocation ->
    Ptr Gsk.ParseLocation.ParseLocation ->
    Ptr GError ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ParseLocation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of the error location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ParseLocation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "end of the error location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the error" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ParseErrorFunc :: FunPtr C_ParseErrorFunc -> C_ParseErrorFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ParseErrorFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ParseErrorFunc
    -> Gsk.ParseLocation.ParseLocation
    -- ^ /@start@/: start of the error location
    -> Gsk.ParseLocation.ParseLocation
    -- ^ /@end@/: end of the error location
    -> GError
    -- ^ /@error@/: the error
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_ParseErrorFunc __funPtr start end error_ userData = liftIO $ do
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_ParseErrorFunc __funPtr) start' end' error_' userData
    touchManagedPtr start
    touchManagedPtr end
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_ParseErrorFunc`.
foreign import ccall "wrapper"
    mk_ParseErrorFunc :: C_ParseErrorFunc -> IO (FunPtr C_ParseErrorFunc)

-- | Type of callback that is called when an error occurs
-- during node deserialization.
type ParseErrorFunc =
    Gsk.ParseLocation.ParseLocation
    -- ^ /@start@/: start of the error location
    -> Gsk.ParseLocation.ParseLocation
    -- ^ /@end@/: end of the error location
    -> GError
    -- ^ /@error@/: the error
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParseErrorFunc`@.
noParseErrorFunc :: Maybe ParseErrorFunc
noParseErrorFunc = Nothing

-- | Type of callback that is called when an error occurs
-- during node deserialization.
type ParseErrorFunc_WithClosures =
    Gsk.ParseLocation.ParseLocation
    -- ^ /@start@/: start of the error location
    -> Gsk.ParseLocation.ParseLocation
    -- ^ /@end@/: end of the error location
    -> GError
    -- ^ /@error@/: the error
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ParseErrorFunc_WithClosures`@.
noParseErrorFunc_WithClosures :: Maybe ParseErrorFunc_WithClosures
noParseErrorFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ParseErrorFunc :: ParseErrorFunc -> ParseErrorFunc_WithClosures
drop_closures_ParseErrorFunc _f start end error_ _ = _f start end error_

-- | Wrap the callback into a `GClosure`.
genClosure_ParseErrorFunc :: MonadIO m => ParseErrorFunc -> m (GClosure C_ParseErrorFunc)
genClosure_ParseErrorFunc cb = liftIO $ do
    let cb' = drop_closures_ParseErrorFunc cb
    let cb'' = wrap_ParseErrorFunc Nothing cb'
    mk_ParseErrorFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ParseErrorFunc` into a `C_ParseErrorFunc`.
wrap_ParseErrorFunc :: 
    Maybe (Ptr (FunPtr C_ParseErrorFunc)) ->
    ParseErrorFunc_WithClosures ->
    C_ParseErrorFunc
wrap_ParseErrorFunc gi'funptrptr gi'cb start end error_ userData = do
    start' <- (newPtr Gsk.ParseLocation.ParseLocation) start
    end' <- (newPtr Gsk.ParseLocation.ParseLocation) end
    error_' <- (newBoxed GError) error_
    gi'cb  start' end' error_' userData
    maybeReleaseFunPtr gi'funptrptr



