

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Flags
    ( 

 -- * Flags


-- ** PixbufFormatFlags #flag:PixbufFormatFlags#

    PixbufFormatFlags(..)                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags PixbufFormatFlags
-- | Flags which allow a module to specify further details about the supported
-- operations.
-- 
-- /Since: 2.2/
data PixbufFormatFlags = 
      PixbufFormatFlagsWritable
    -- ^ the module can write out images in the format.
    | PixbufFormatFlagsScalable
    -- ^ the image format is scalable
    | PixbufFormatFlagsThreadsafe
    -- ^ the module is threadsafe. gdk-pixbuf
    --     ignores modules that are not marked as threadsafe. (Since 2.28).
    | AnotherPixbufFormatFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PixbufFormatFlags where
    fromEnum PixbufFormatFlagsWritable = 1
    fromEnum PixbufFormatFlagsScalable = 2
    fromEnum PixbufFormatFlagsThreadsafe = 4
    fromEnum (AnotherPixbufFormatFlags k) = k

    toEnum 1 = PixbufFormatFlagsWritable
    toEnum 2 = PixbufFormatFlagsScalable
    toEnum 4 = PixbufFormatFlagsThreadsafe
    toEnum k = AnotherPixbufFormatFlags k

instance P.Ord PixbufFormatFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag PixbufFormatFlags


