{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Structs.KeymapKey.KeymapKey' is a hardware key that can be mapped to a keyval.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.KeymapKey
    ( 

-- * Exported types
    KeymapKey(..)                           ,
    newZeroKeymapKey                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveKeymapKeyMethod                  ,
#endif



 -- * Properties


-- ** group #attr:group#
-- | indicates movement in a horizontal direction. Usually groups are used
--   for two different languages. In group 0, a key might have two English
--   characters, and in group 1 it might have two Hebrew characters. The Hebrew
--   characters will be printed on the key next to the English characters.

    getKeymapKeyGroup                       ,
#if defined(ENABLE_OVERLOADING)
    keymapKey_group                         ,
#endif
    setKeymapKeyGroup                       ,


-- ** keycode #attr:keycode#
-- | the hardware keycode. This is an identifying number for a
--   physical key.

    getKeymapKeyKeycode                     ,
#if defined(ENABLE_OVERLOADING)
    keymapKey_keycode                       ,
#endif
    setKeymapKeyKeycode                     ,


-- ** level #attr:level#
-- | indicates which symbol on the key will be used, in a vertical direction.
--   So on a standard US keyboard, the key with the number “1” on it also has the
--   exclamation point (\"!\") character on it. The level indicates whether to use
--   the “1” or the “!” symbol. The letter keys are considered to have a lowercase
--   letter at level 0, and an uppercase letter at level 1, though only the
--   uppercase letter is printed.

    getKeymapKeyLevel                       ,
#if defined(ENABLE_OVERLOADING)
    keymapKey_level                         ,
#endif
    setKeymapKeyLevel                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype KeymapKey = KeymapKey (SP.ManagedPtr KeymapKey)
    deriving (Eq)

instance SP.ManagedPtrNewtype KeymapKey where
    toManagedPtr (KeymapKey p) = p

instance BoxedPtr KeymapKey where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 12 >=> B.ManagedPtr.wrapPtr KeymapKey)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr KeymapKey where
    boxedPtrCalloc = callocBytes 12


-- | Construct a t'KeymapKey' struct initialized to zero.
newZeroKeymapKey :: MonadIO m => m KeymapKey
newZeroKeymapKey = liftIO $ boxedPtrCalloc >>= wrapPtr KeymapKey

instance tag ~ 'AttrSet => Constructible KeymapKey tag where
    new _ attrs = do
        o <- newZeroKeymapKey
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keymapKey #keycode
-- @
getKeymapKeyKeycode :: MonadIO m => KeymapKey -> m Word32
getKeymapKeyKeycode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keymapKey [ #keycode 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeymapKeyKeycode :: MonadIO m => KeymapKey -> Word32 -> m ()
setKeymapKeyKeycode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data KeymapKeyKeycodeFieldInfo
instance AttrInfo KeymapKeyKeycodeFieldInfo where
    type AttrBaseTypeConstraint KeymapKeyKeycodeFieldInfo = (~) KeymapKey
    type AttrAllowedOps KeymapKeyKeycodeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeymapKeyKeycodeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint KeymapKeyKeycodeFieldInfo = (~)Word32
    type AttrTransferType KeymapKeyKeycodeFieldInfo = Word32
    type AttrGetType KeymapKeyKeycodeFieldInfo = Word32
    type AttrLabel KeymapKeyKeycodeFieldInfo = "keycode"
    type AttrOrigin KeymapKeyKeycodeFieldInfo = KeymapKey
    attrGet = getKeymapKeyKeycode
    attrSet = setKeymapKeyKeycode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.KeymapKey.keycode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-KeymapKey.html#g:attr:keycode"
        })

keymapKey_keycode :: AttrLabelProxy "keycode"
keymapKey_keycode = AttrLabelProxy

#endif


-- | Get the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keymapKey #group
-- @
getKeymapKeyGroup :: MonadIO m => KeymapKey -> m Int32
getKeymapKeyGroup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keymapKey [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeymapKeyGroup :: MonadIO m => KeymapKey -> Int32 -> m ()
setKeymapKeyGroup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data KeymapKeyGroupFieldInfo
instance AttrInfo KeymapKeyGroupFieldInfo where
    type AttrBaseTypeConstraint KeymapKeyGroupFieldInfo = (~) KeymapKey
    type AttrAllowedOps KeymapKeyGroupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeymapKeyGroupFieldInfo = (~) Int32
    type AttrTransferTypeConstraint KeymapKeyGroupFieldInfo = (~)Int32
    type AttrTransferType KeymapKeyGroupFieldInfo = Int32
    type AttrGetType KeymapKeyGroupFieldInfo = Int32
    type AttrLabel KeymapKeyGroupFieldInfo = "group"
    type AttrOrigin KeymapKeyGroupFieldInfo = KeymapKey
    attrGet = getKeymapKeyGroup
    attrSet = setKeymapKeyGroup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.KeymapKey.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-KeymapKey.html#g:attr:group"
        })

keymapKey_group :: AttrLabelProxy "group"
keymapKey_group = AttrLabelProxy

#endif


-- | Get the value of the “@level@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keymapKey #level
-- @
getKeymapKeyLevel :: MonadIO m => KeymapKey -> m Int32
getKeymapKeyLevel s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@level@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keymapKey [ #level 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeymapKeyLevel :: MonadIO m => KeymapKey -> Int32 -> m ()
setKeymapKeyLevel s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data KeymapKeyLevelFieldInfo
instance AttrInfo KeymapKeyLevelFieldInfo where
    type AttrBaseTypeConstraint KeymapKeyLevelFieldInfo = (~) KeymapKey
    type AttrAllowedOps KeymapKeyLevelFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeymapKeyLevelFieldInfo = (~) Int32
    type AttrTransferTypeConstraint KeymapKeyLevelFieldInfo = (~)Int32
    type AttrTransferType KeymapKeyLevelFieldInfo = Int32
    type AttrGetType KeymapKeyLevelFieldInfo = Int32
    type AttrLabel KeymapKeyLevelFieldInfo = "level"
    type AttrOrigin KeymapKeyLevelFieldInfo = KeymapKey
    attrGet = getKeymapKeyLevel
    attrSet = setKeymapKeyLevel
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.KeymapKey.level"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-KeymapKey.html#g:attr:level"
        })

keymapKey_level :: AttrLabelProxy "level"
keymapKey_level = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList KeymapKey
type instance O.AttributeList KeymapKey = KeymapKeyAttributeList
type KeymapKeyAttributeList = ('[ '("keycode", KeymapKeyKeycodeFieldInfo), '("group", KeymapKeyGroupFieldInfo), '("level", KeymapKeyLevelFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveKeymapKeyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveKeymapKeyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveKeymapKeyMethod t KeymapKey, O.OverloadedMethod info KeymapKey p) => OL.IsLabel t (KeymapKey -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveKeymapKeyMethod t KeymapKey, O.OverloadedMethod info KeymapKey p, R.HasField t KeymapKey p) => R.HasField t KeymapKey p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveKeymapKeyMethod t KeymapKey, O.OverloadedMethodInfo info KeymapKey) => OL.IsLabel t (O.MethodProxy info KeymapKey) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


