{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Constructs t'GI.Gdk.Objects.Texture.Texture' objects from system memory provided
-- via t'GI.GLib.Structs.Bytes.Bytes'.
-- 
-- The operation is quite simple: Create a texture builder, set all the necessary
-- properties - keep in mind that the properties [MemoryTextureBuilder:bytes]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:bytes"),
-- [MemoryTextureBuilder:stride]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:stride"), [MemoryTextureBuilder:width]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:width"),
-- and [MemoryTextureBuilder:height]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:height") are mandatory - and then call
-- 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild' to create the new texture.
-- 
-- @GdkMemoryTextureBuilder@ can be used for quick one-shot construction of
-- textures as well as kept around and reused to construct multiple textures.
-- 
-- /Since: 4.16/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.MemoryTextureBuilder
    ( 

-- * Exported types
    MemoryTextureBuilder(..)                ,
    IsMemoryTextureBuilder                  ,
    toMemoryTextureBuilder                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [build]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:build"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBytes]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getBytes"), [getColorState]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getColorState"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFormat]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getFormat"), [getHeight]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getHeight"), [getOffset]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getOffset"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStride]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getStride"), [getStrideForPlane]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getStrideForPlane"), [getUpdateRegion]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getUpdateRegion"), [getUpdateTexture]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getUpdateTexture"), [getWidth]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:getWidth").
-- 
-- ==== Setters
-- [setBytes]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setBytes"), [setColorState]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setColorState"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFormat]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setFormat"), [setHeight]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setHeight"), [setOffset]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setOffset"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStride]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setStride"), [setStrideForPlane]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setStrideForPlane"), [setUpdateRegion]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setUpdateRegion"), [setUpdateTexture]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setUpdateTexture"), [setWidth]("GI.Gdk.Objects.MemoryTextureBuilder#g:method:setWidth").

#if defined(ENABLE_OVERLOADING)
    ResolveMemoryTextureBuilderMethod       ,
#endif

-- ** build #method:build#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderBuildMethodInfo     ,
#endif
    memoryTextureBuilderBuild               ,


-- ** getBytes #method:getBytes#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetBytesMethodInfo  ,
#endif
    memoryTextureBuilderGetBytes            ,


-- ** getColorState #method:getColorState#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetColorStateMethodInfo,
#endif
    memoryTextureBuilderGetColorState       ,


-- ** getFormat #method:getFormat#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetFormatMethodInfo ,
#endif
    memoryTextureBuilderGetFormat           ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetHeightMethodInfo ,
#endif
    memoryTextureBuilderGetHeight           ,


-- ** getOffset #method:getOffset#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetOffsetMethodInfo ,
#endif
    memoryTextureBuilderGetOffset           ,


-- ** getStride #method:getStride#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetStrideMethodInfo ,
#endif
    memoryTextureBuilderGetStride           ,


-- ** getStrideForPlane #method:getStrideForPlane#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetStrideForPlaneMethodInfo,
#endif
    memoryTextureBuilderGetStrideForPlane   ,


-- ** getUpdateRegion #method:getUpdateRegion#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetUpdateRegionMethodInfo,
#endif
    memoryTextureBuilderGetUpdateRegion     ,


-- ** getUpdateTexture #method:getUpdateTexture#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetUpdateTextureMethodInfo,
#endif
    memoryTextureBuilderGetUpdateTexture    ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderGetWidthMethodInfo  ,
#endif
    memoryTextureBuilderGetWidth            ,


-- ** new #method:new#

    memoryTextureBuilderNew                 ,


-- ** setBytes #method:setBytes#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetBytesMethodInfo  ,
#endif
    memoryTextureBuilderSetBytes            ,


-- ** setColorState #method:setColorState#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetColorStateMethodInfo,
#endif
    memoryTextureBuilderSetColorState       ,


-- ** setFormat #method:setFormat#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetFormatMethodInfo ,
#endif
    memoryTextureBuilderSetFormat           ,


-- ** setHeight #method:setHeight#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetHeightMethodInfo ,
#endif
    memoryTextureBuilderSetHeight           ,


-- ** setOffset #method:setOffset#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetOffsetMethodInfo ,
#endif
    memoryTextureBuilderSetOffset           ,


-- ** setStride #method:setStride#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetStrideMethodInfo ,
#endif
    memoryTextureBuilderSetStride           ,


-- ** setStrideForPlane #method:setStrideForPlane#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetStrideForPlaneMethodInfo,
#endif
    memoryTextureBuilderSetStrideForPlane   ,


-- ** setUpdateRegion #method:setUpdateRegion#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetUpdateRegionMethodInfo,
#endif
    memoryTextureBuilderSetUpdateRegion     ,


-- ** setUpdateTexture #method:setUpdateTexture#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetUpdateTextureMethodInfo,
#endif
    memoryTextureBuilderSetUpdateTexture    ,


-- ** setWidth #method:setWidth#

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderSetWidthMethodInfo  ,
#endif
    memoryTextureBuilderSetWidth            ,




 -- * Properties


-- ** bytes #attr:bytes#
-- | The bytes holding the data.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderBytesPropertyInfo   ,
#endif
    clearMemoryTextureBuilderBytes          ,
    constructMemoryTextureBuilderBytes      ,
    getMemoryTextureBuilderBytes            ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderBytes               ,
#endif
    setMemoryTextureBuilderBytes            ,


-- ** colorState #attr:colorState#
-- | The colorstate describing the data.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderColorStatePropertyInfo,
#endif
    constructMemoryTextureBuilderColorState ,
    getMemoryTextureBuilderColorState       ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderColorState          ,
#endif
    setMemoryTextureBuilderColorState       ,


-- ** format #attr:format#
-- | The format of the data.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderFormatPropertyInfo  ,
#endif
    constructMemoryTextureBuilderFormat     ,
    getMemoryTextureBuilderFormat           ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderFormat              ,
#endif
    setMemoryTextureBuilderFormat           ,


-- ** height #attr:height#
-- | The height of the texture.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderHeightPropertyInfo  ,
#endif
    constructMemoryTextureBuilderHeight     ,
    getMemoryTextureBuilderHeight           ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderHeight              ,
#endif
    setMemoryTextureBuilderHeight           ,


-- ** stride #attr:stride#
-- | The rowstride of the texture.
-- 
-- The rowstride is the number of bytes between the first pixel
-- in a row of image data, and the first pixel in the next row.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderStridePropertyInfo  ,
#endif
    constructMemoryTextureBuilderStride     ,
    getMemoryTextureBuilderStride           ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderStride              ,
#endif
    setMemoryTextureBuilderStride           ,


-- ** updateRegion #attr:updateRegion#
-- | The update region for [MemoryTextureBuilder:updateTexture]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:updateTexture").
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderUpdateRegionPropertyInfo,
#endif
    clearMemoryTextureBuilderUpdateRegion   ,
    constructMemoryTextureBuilderUpdateRegion,
    getMemoryTextureBuilderUpdateRegion     ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderUpdateRegion        ,
#endif
    setMemoryTextureBuilderUpdateRegion     ,


-- ** updateTexture #attr:updateTexture#
-- | The texture [MemoryTextureBuilder:updateRegion]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:updateRegion") is an update for.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderUpdateTexturePropertyInfo,
#endif
    clearMemoryTextureBuilderUpdateTexture  ,
    constructMemoryTextureBuilderUpdateTexture,
    getMemoryTextureBuilderUpdateTexture    ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderUpdateTexture       ,
#endif
    setMemoryTextureBuilderUpdateTexture    ,


-- ** width #attr:width#
-- | The width of the texture.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    MemoryTextureBuilderWidthPropertyInfo   ,
#endif
    constructMemoryTextureBuilderWidth      ,
    getMemoryTextureBuilderWidth            ,
#if defined(ENABLE_OVERLOADING)
    memoryTextureBuilderWidth               ,
#endif
    setMemoryTextureBuilderWidth            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState

#endif

-- | Memory-managed wrapper type.
newtype MemoryTextureBuilder = MemoryTextureBuilder (SP.ManagedPtr MemoryTextureBuilder)
    deriving (Eq)

instance SP.ManagedPtrNewtype MemoryTextureBuilder where
    toManagedPtr (MemoryTextureBuilder p) = p

foreign import ccall "gdk_memory_texture_builder_get_type"
    c_gdk_memory_texture_builder_get_type :: IO B.Types.GType

instance B.Types.TypedObject MemoryTextureBuilder where
    glibType = c_gdk_memory_texture_builder_get_type

instance B.Types.GObject MemoryTextureBuilder

-- | Type class for types which can be safely cast to t'MemoryTextureBuilder', for instance with `toMemoryTextureBuilder`.
class (SP.GObject o, O.IsDescendantOf MemoryTextureBuilder o) => IsMemoryTextureBuilder o
instance (SP.GObject o, O.IsDescendantOf MemoryTextureBuilder o) => IsMemoryTextureBuilder o

instance O.HasParentTypes MemoryTextureBuilder
type instance O.ParentTypes MemoryTextureBuilder = '[GObject.Object.Object]

-- | Cast to t'MemoryTextureBuilder', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMemoryTextureBuilder :: (MIO.MonadIO m, IsMemoryTextureBuilder o) => o -> m MemoryTextureBuilder
toMemoryTextureBuilder = MIO.liftIO . B.ManagedPtr.unsafeCastTo MemoryTextureBuilder

-- | Convert t'MemoryTextureBuilder' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MemoryTextureBuilder) where
    gvalueGType_ = c_gdk_memory_texture_builder_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MemoryTextureBuilder)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MemoryTextureBuilder)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MemoryTextureBuilder ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMemoryTextureBuilderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMemoryTextureBuilderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMemoryTextureBuilderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMemoryTextureBuilderMethod "build" o = MemoryTextureBuilderBuildMethodInfo
    ResolveMemoryTextureBuilderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMemoryTextureBuilderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMemoryTextureBuilderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMemoryTextureBuilderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMemoryTextureBuilderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMemoryTextureBuilderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMemoryTextureBuilderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMemoryTextureBuilderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMemoryTextureBuilderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMemoryTextureBuilderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMemoryTextureBuilderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMemoryTextureBuilderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMemoryTextureBuilderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMemoryTextureBuilderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMemoryTextureBuilderMethod "getBytes" o = MemoryTextureBuilderGetBytesMethodInfo
    ResolveMemoryTextureBuilderMethod "getColorState" o = MemoryTextureBuilderGetColorStateMethodInfo
    ResolveMemoryTextureBuilderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMemoryTextureBuilderMethod "getFormat" o = MemoryTextureBuilderGetFormatMethodInfo
    ResolveMemoryTextureBuilderMethod "getHeight" o = MemoryTextureBuilderGetHeightMethodInfo
    ResolveMemoryTextureBuilderMethod "getOffset" o = MemoryTextureBuilderGetOffsetMethodInfo
    ResolveMemoryTextureBuilderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMemoryTextureBuilderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMemoryTextureBuilderMethod "getStride" o = MemoryTextureBuilderGetStrideMethodInfo
    ResolveMemoryTextureBuilderMethod "getStrideForPlane" o = MemoryTextureBuilderGetStrideForPlaneMethodInfo
    ResolveMemoryTextureBuilderMethod "getUpdateRegion" o = MemoryTextureBuilderGetUpdateRegionMethodInfo
    ResolveMemoryTextureBuilderMethod "getUpdateTexture" o = MemoryTextureBuilderGetUpdateTextureMethodInfo
    ResolveMemoryTextureBuilderMethod "getWidth" o = MemoryTextureBuilderGetWidthMethodInfo
    ResolveMemoryTextureBuilderMethod "setBytes" o = MemoryTextureBuilderSetBytesMethodInfo
    ResolveMemoryTextureBuilderMethod "setColorState" o = MemoryTextureBuilderSetColorStateMethodInfo
    ResolveMemoryTextureBuilderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMemoryTextureBuilderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMemoryTextureBuilderMethod "setFormat" o = MemoryTextureBuilderSetFormatMethodInfo
    ResolveMemoryTextureBuilderMethod "setHeight" o = MemoryTextureBuilderSetHeightMethodInfo
    ResolveMemoryTextureBuilderMethod "setOffset" o = MemoryTextureBuilderSetOffsetMethodInfo
    ResolveMemoryTextureBuilderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMemoryTextureBuilderMethod "setStride" o = MemoryTextureBuilderSetStrideMethodInfo
    ResolveMemoryTextureBuilderMethod "setStrideForPlane" o = MemoryTextureBuilderSetStrideForPlaneMethodInfo
    ResolveMemoryTextureBuilderMethod "setUpdateRegion" o = MemoryTextureBuilderSetUpdateRegionMethodInfo
    ResolveMemoryTextureBuilderMethod "setUpdateTexture" o = MemoryTextureBuilderSetUpdateTextureMethodInfo
    ResolveMemoryTextureBuilderMethod "setWidth" o = MemoryTextureBuilderSetWidthMethodInfo
    ResolveMemoryTextureBuilderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMemoryTextureBuilderMethod t MemoryTextureBuilder, O.OverloadedMethod info MemoryTextureBuilder p) => OL.IsLabel t (MemoryTextureBuilder -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMemoryTextureBuilderMethod t MemoryTextureBuilder, O.OverloadedMethod info MemoryTextureBuilder p, R.HasField t MemoryTextureBuilder p) => R.HasField t MemoryTextureBuilder p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMemoryTextureBuilderMethod t MemoryTextureBuilder, O.OverloadedMethodInfo info MemoryTextureBuilder) => OL.IsLabel t (O.MethodProxy info MemoryTextureBuilder) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "bytes"
   -- Type: TInterface (Name {namespace = "GLib", name = "Bytes"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@bytes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #bytes
-- @
getMemoryTextureBuilderBytes :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m (Maybe GLib.Bytes.Bytes)
getMemoryTextureBuilderBytes obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "bytes" GLib.Bytes.Bytes

-- | Set the value of the “@bytes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #bytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderBytes :: (MonadIO m, IsMemoryTextureBuilder o) => o -> GLib.Bytes.Bytes -> m ()
setMemoryTextureBuilderBytes obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "bytes" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@bytes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderBytes :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => GLib.Bytes.Bytes -> m (GValueConstruct o)
constructMemoryTextureBuilderBytes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "bytes" (P.Just val)

-- | Set the value of the “@bytes@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #bytes
-- @
clearMemoryTextureBuilderBytes :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m ()
clearMemoryTextureBuilderBytes obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "bytes" (Nothing :: Maybe GLib.Bytes.Bytes)

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderBytesPropertyInfo
instance AttrInfo MemoryTextureBuilderBytesPropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderBytesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MemoryTextureBuilderBytesPropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderBytesPropertyInfo = (~) GLib.Bytes.Bytes
    type AttrTransferTypeConstraint MemoryTextureBuilderBytesPropertyInfo = (~) GLib.Bytes.Bytes
    type AttrTransferType MemoryTextureBuilderBytesPropertyInfo = GLib.Bytes.Bytes
    type AttrGetType MemoryTextureBuilderBytesPropertyInfo = (Maybe GLib.Bytes.Bytes)
    type AttrLabel MemoryTextureBuilderBytesPropertyInfo = "bytes"
    type AttrOrigin MemoryTextureBuilderBytesPropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderBytes
    attrSet = setMemoryTextureBuilderBytes
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderBytes
    attrClear = clearMemoryTextureBuilderBytes
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.bytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:bytes"
        })
#endif

-- VVV Prop "color-state"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ColorState"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@color-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #colorState
-- @
getMemoryTextureBuilderColorState :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m Gdk.ColorState.ColorState
getMemoryTextureBuilderColorState obj = MIO.liftIO $ checkUnexpectedNothing "getMemoryTextureBuilderColorState" $ B.Properties.getObjectPropertyBoxed obj "color-state" Gdk.ColorState.ColorState

-- | Set the value of the “@color-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #colorState 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderColorState :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Gdk.ColorState.ColorState -> m ()
setMemoryTextureBuilderColorState obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "color-state" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@color-state@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderColorState :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Gdk.ColorState.ColorState -> m (GValueConstruct o)
constructMemoryTextureBuilderColorState val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "color-state" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderColorStatePropertyInfo
instance AttrInfo MemoryTextureBuilderColorStatePropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderColorStatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryTextureBuilderColorStatePropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderColorStatePropertyInfo = (~) Gdk.ColorState.ColorState
    type AttrTransferTypeConstraint MemoryTextureBuilderColorStatePropertyInfo = (~) Gdk.ColorState.ColorState
    type AttrTransferType MemoryTextureBuilderColorStatePropertyInfo = Gdk.ColorState.ColorState
    type AttrGetType MemoryTextureBuilderColorStatePropertyInfo = Gdk.ColorState.ColorState
    type AttrLabel MemoryTextureBuilderColorStatePropertyInfo = "color-state"
    type AttrOrigin MemoryTextureBuilderColorStatePropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderColorState
    attrSet = setMemoryTextureBuilderColorState
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderColorState
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.colorState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:colorState"
        })
#endif

-- VVV Prop "format"
   -- Type: TInterface (Name {namespace = "Gdk", name = "MemoryFormat"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #format
-- @
getMemoryTextureBuilderFormat :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m Gdk.Enums.MemoryFormat
getMemoryTextureBuilderFormat obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "format"

-- | Set the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #format 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderFormat :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Gdk.Enums.MemoryFormat -> m ()
setMemoryTextureBuilderFormat obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "format" val

-- | Construct a t'GValueConstruct' with valid value for the “@format@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderFormat :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Gdk.Enums.MemoryFormat -> m (GValueConstruct o)
constructMemoryTextureBuilderFormat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "format" val

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderFormatPropertyInfo
instance AttrInfo MemoryTextureBuilderFormatPropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderFormatPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryTextureBuilderFormatPropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderFormatPropertyInfo = (~) Gdk.Enums.MemoryFormat
    type AttrTransferTypeConstraint MemoryTextureBuilderFormatPropertyInfo = (~) Gdk.Enums.MemoryFormat
    type AttrTransferType MemoryTextureBuilderFormatPropertyInfo = Gdk.Enums.MemoryFormat
    type AttrGetType MemoryTextureBuilderFormatPropertyInfo = Gdk.Enums.MemoryFormat
    type AttrLabel MemoryTextureBuilderFormatPropertyInfo = "format"
    type AttrOrigin MemoryTextureBuilderFormatPropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderFormat
    attrSet = setMemoryTextureBuilderFormat
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderFormat
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.format"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:format"
        })
#endif

-- VVV Prop "height"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #height
-- @
getMemoryTextureBuilderHeight :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m Int32
getMemoryTextureBuilderHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "height"

-- | Set the value of the “@height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderHeight :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Int32 -> m ()
setMemoryTextureBuilderHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "height" val

-- | Construct a t'GValueConstruct' with valid value for the “@height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderHeight :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructMemoryTextureBuilderHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "height" val

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderHeightPropertyInfo
instance AttrInfo MemoryTextureBuilderHeightPropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryTextureBuilderHeightPropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderHeightPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint MemoryTextureBuilderHeightPropertyInfo = (~) Int32
    type AttrTransferType MemoryTextureBuilderHeightPropertyInfo = Int32
    type AttrGetType MemoryTextureBuilderHeightPropertyInfo = Int32
    type AttrLabel MemoryTextureBuilderHeightPropertyInfo = "height"
    type AttrOrigin MemoryTextureBuilderHeightPropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderHeight
    attrSet = setMemoryTextureBuilderHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:height"
        })
#endif

-- VVV Prop "stride"
   -- Type: TBasicType TUInt64
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@stride@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #stride
-- @
getMemoryTextureBuilderStride :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m Word64
getMemoryTextureBuilderStride obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt64 obj "stride"

-- | Set the value of the “@stride@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #stride 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderStride :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Word64 -> m ()
setMemoryTextureBuilderStride obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt64 obj "stride" val

-- | Construct a t'GValueConstruct' with valid value for the “@stride@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderStride :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Word64 -> m (GValueConstruct o)
constructMemoryTextureBuilderStride val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt64 "stride" val

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderStridePropertyInfo
instance AttrInfo MemoryTextureBuilderStridePropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderStridePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryTextureBuilderStridePropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderStridePropertyInfo = (~) Word64
    type AttrTransferTypeConstraint MemoryTextureBuilderStridePropertyInfo = (~) Word64
    type AttrTransferType MemoryTextureBuilderStridePropertyInfo = Word64
    type AttrGetType MemoryTextureBuilderStridePropertyInfo = Word64
    type AttrLabel MemoryTextureBuilderStridePropertyInfo = "stride"
    type AttrOrigin MemoryTextureBuilderStridePropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderStride
    attrSet = setMemoryTextureBuilderStride
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderStride
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.stride"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:stride"
        })
#endif

-- VVV Prop "update-region"
   -- Type: TInterface (Name {namespace = "cairo", name = "Region"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@update-region@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #updateRegion
-- @
getMemoryTextureBuilderUpdateRegion :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m (Maybe Cairo.Region.Region)
getMemoryTextureBuilderUpdateRegion obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "update-region" Cairo.Region.Region

-- | Set the value of the “@update-region@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #updateRegion 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderUpdateRegion :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Cairo.Region.Region -> m ()
setMemoryTextureBuilderUpdateRegion obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "update-region" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@update-region@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderUpdateRegion :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Cairo.Region.Region -> m (GValueConstruct o)
constructMemoryTextureBuilderUpdateRegion val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "update-region" (P.Just val)

-- | Set the value of the “@update-region@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #updateRegion
-- @
clearMemoryTextureBuilderUpdateRegion :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m ()
clearMemoryTextureBuilderUpdateRegion obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "update-region" (Nothing :: Maybe Cairo.Region.Region)

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderUpdateRegionPropertyInfo
instance AttrInfo MemoryTextureBuilderUpdateRegionPropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderUpdateRegionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MemoryTextureBuilderUpdateRegionPropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderUpdateRegionPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferTypeConstraint MemoryTextureBuilderUpdateRegionPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferType MemoryTextureBuilderUpdateRegionPropertyInfo = Cairo.Region.Region
    type AttrGetType MemoryTextureBuilderUpdateRegionPropertyInfo = (Maybe Cairo.Region.Region)
    type AttrLabel MemoryTextureBuilderUpdateRegionPropertyInfo = "update-region"
    type AttrOrigin MemoryTextureBuilderUpdateRegionPropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderUpdateRegion
    attrSet = setMemoryTextureBuilderUpdateRegion
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderUpdateRegion
    attrClear = clearMemoryTextureBuilderUpdateRegion
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.updateRegion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:updateRegion"
        })
#endif

-- VVV Prop "update-texture"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Texture"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@update-texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #updateTexture
-- @
getMemoryTextureBuilderUpdateTexture :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m (Maybe Gdk.Texture.Texture)
getMemoryTextureBuilderUpdateTexture obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "update-texture" Gdk.Texture.Texture

-- | Set the value of the “@update-texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #updateTexture 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderUpdateTexture :: (MonadIO m, IsMemoryTextureBuilder o, Gdk.Texture.IsTexture a) => o -> a -> m ()
setMemoryTextureBuilderUpdateTexture obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "update-texture" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@update-texture@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderUpdateTexture :: (IsMemoryTextureBuilder o, MIO.MonadIO m, Gdk.Texture.IsTexture a) => a -> m (GValueConstruct o)
constructMemoryTextureBuilderUpdateTexture val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "update-texture" (P.Just val)

-- | Set the value of the “@update-texture@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #updateTexture
-- @
clearMemoryTextureBuilderUpdateTexture :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m ()
clearMemoryTextureBuilderUpdateTexture obj = liftIO $ B.Properties.setObjectPropertyObject obj "update-texture" (Nothing :: Maybe Gdk.Texture.Texture)

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderUpdateTexturePropertyInfo
instance AttrInfo MemoryTextureBuilderUpdateTexturePropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderUpdateTexturePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MemoryTextureBuilderUpdateTexturePropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferTypeConstraint MemoryTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferType MemoryTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.Texture
    type AttrGetType MemoryTextureBuilderUpdateTexturePropertyInfo = (Maybe Gdk.Texture.Texture)
    type AttrLabel MemoryTextureBuilderUpdateTexturePropertyInfo = "update-texture"
    type AttrOrigin MemoryTextureBuilderUpdateTexturePropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderUpdateTexture
    attrSet = setMemoryTextureBuilderUpdateTexture
    attrTransfer _ v = do
        unsafeCastTo Gdk.Texture.Texture v
    attrConstruct = constructMemoryTextureBuilderUpdateTexture
    attrClear = clearMemoryTextureBuilderUpdateTexture
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.updateTexture"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:updateTexture"
        })
#endif

-- VVV Prop "width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryTextureBuilder #width
-- @
getMemoryTextureBuilderWidth :: (MonadIO m, IsMemoryTextureBuilder o) => o -> m Int32
getMemoryTextureBuilderWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "width"

-- | Set the value of the “@width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memoryTextureBuilder [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemoryTextureBuilderWidth :: (MonadIO m, IsMemoryTextureBuilder o) => o -> Int32 -> m ()
setMemoryTextureBuilderWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "width" val

-- | Construct a t'GValueConstruct' with valid value for the “@width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryTextureBuilderWidth :: (IsMemoryTextureBuilder o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructMemoryTextureBuilderWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "width" val

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderWidthPropertyInfo
instance AttrInfo MemoryTextureBuilderWidthPropertyInfo where
    type AttrAllowedOps MemoryTextureBuilderWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryTextureBuilderWidthPropertyInfo = IsMemoryTextureBuilder
    type AttrSetTypeConstraint MemoryTextureBuilderWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint MemoryTextureBuilderWidthPropertyInfo = (~) Int32
    type AttrTransferType MemoryTextureBuilderWidthPropertyInfo = Int32
    type AttrGetType MemoryTextureBuilderWidthPropertyInfo = Int32
    type AttrLabel MemoryTextureBuilderWidthPropertyInfo = "width"
    type AttrOrigin MemoryTextureBuilderWidthPropertyInfo = MemoryTextureBuilder
    attrGet = getMemoryTextureBuilderWidth
    attrSet = setMemoryTextureBuilderWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryTextureBuilderWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#g:attr:width"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MemoryTextureBuilder
type instance O.AttributeList MemoryTextureBuilder = MemoryTextureBuilderAttributeList
type MemoryTextureBuilderAttributeList = ('[ '("bytes", MemoryTextureBuilderBytesPropertyInfo), '("colorState", MemoryTextureBuilderColorStatePropertyInfo), '("format", MemoryTextureBuilderFormatPropertyInfo), '("height", MemoryTextureBuilderHeightPropertyInfo), '("stride", MemoryTextureBuilderStridePropertyInfo), '("updateRegion", MemoryTextureBuilderUpdateRegionPropertyInfo), '("updateTexture", MemoryTextureBuilderUpdateTexturePropertyInfo), '("width", MemoryTextureBuilderWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
memoryTextureBuilderBytes :: AttrLabelProxy "bytes"
memoryTextureBuilderBytes = AttrLabelProxy

memoryTextureBuilderColorState :: AttrLabelProxy "colorState"
memoryTextureBuilderColorState = AttrLabelProxy

memoryTextureBuilderFormat :: AttrLabelProxy "format"
memoryTextureBuilderFormat = AttrLabelProxy

memoryTextureBuilderHeight :: AttrLabelProxy "height"
memoryTextureBuilderHeight = AttrLabelProxy

memoryTextureBuilderStride :: AttrLabelProxy "stride"
memoryTextureBuilderStride = AttrLabelProxy

memoryTextureBuilderUpdateRegion :: AttrLabelProxy "updateRegion"
memoryTextureBuilderUpdateRegion = AttrLabelProxy

memoryTextureBuilderUpdateTexture :: AttrLabelProxy "updateTexture"
memoryTextureBuilderUpdateTexture = AttrLabelProxy

memoryTextureBuilderWidth :: AttrLabelProxy "width"
memoryTextureBuilderWidth = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MemoryTextureBuilder = MemoryTextureBuilderSignalList
type MemoryTextureBuilderSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MemoryTextureBuilder::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gdk" , name = "MemoryTextureBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_new" gdk_memory_texture_builder_new :: 
    IO (Ptr MemoryTextureBuilder)

-- | Creates a new texture builder.
-- 
-- /Since: 4.16/
memoryTextureBuilderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MemoryTextureBuilder
    -- ^ __Returns:__ the new @GdkTextureBuilder@
memoryTextureBuilderNew  = liftIO $ do
    result <- gdk_memory_texture_builder_new
    checkUnexpectedReturnNULL "memoryTextureBuilderNew" result
    result' <- (wrapObject MemoryTextureBuilder) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MemoryTextureBuilder::build
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_build" gdk_memory_texture_builder_build :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO (Ptr Gdk.Texture.Texture)

-- | Builds a new @GdkTexture@ with the values set up in the builder.
-- 
-- Note that it is a programming error to call this function if any mandatory
-- property has not been set.
-- 
-- It is possible to call this function multiple times to create multiple textures,
-- possibly with changing properties in between.
-- 
-- /Since: 4.16/
memoryTextureBuilderBuild ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m Gdk.Texture.Texture
    -- ^ __Returns:__ a newly built @GdkTexture@
memoryTextureBuilderBuild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_build self'
    checkUnexpectedReturnNULL "memoryTextureBuilderBuild" result
    result' <- (wrapObject Gdk.Texture.Texture) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderBuildMethodInfo
instance (signature ~ (m Gdk.Texture.Texture), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderBuildMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderBuild

instance O.OverloadedMethodInfo MemoryTextureBuilderBuildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderBuild"
        })


#endif

-- method MemoryTextureBuilder::get_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_bytes" gdk_memory_texture_builder_get_bytes :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO (Ptr GLib.Bytes.Bytes)

-- | Gets the bytes previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetBytes'
-- or 'P.Nothing' if none was set.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m (Maybe GLib.Bytes.Bytes)
    -- ^ __Returns:__ The bytes
memoryTextureBuilderGetBytes self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_bytes self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed GLib.Bytes.Bytes) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetBytesMethodInfo
instance (signature ~ (m (Maybe GLib.Bytes.Bytes)), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetBytesMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetBytes

instance O.OverloadedMethodInfo MemoryTextureBuilderGetBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetBytes"
        })


#endif

-- method MemoryTextureBuilder::get_color_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_color_state" gdk_memory_texture_builder_get_color_state :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO (Ptr Gdk.ColorState.ColorState)

-- | Gets the colorstate previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetColorState'.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetColorState ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m Gdk.ColorState.ColorState
    -- ^ __Returns:__ The colorstate
memoryTextureBuilderGetColorState self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_color_state self'
    checkUnexpectedReturnNULL "memoryTextureBuilderGetColorState" result
    result' <- (newBoxed Gdk.ColorState.ColorState) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetColorStateMethodInfo
instance (signature ~ (m Gdk.ColorState.ColorState), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetColorStateMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetColorState

instance O.OverloadedMethodInfo MemoryTextureBuilderGetColorStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetColorState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetColorState"
        })


#endif

-- method MemoryTextureBuilder::get_format
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "MemoryFormat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_format" gdk_memory_texture_builder_get_format :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO CUInt

-- | Gets the format previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetFormat'.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetFormat ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m Gdk.Enums.MemoryFormat
    -- ^ __Returns:__ The format
memoryTextureBuilderGetFormat self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_format self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetFormatMethodInfo
instance (signature ~ (m Gdk.Enums.MemoryFormat), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetFormatMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetFormat

instance O.OverloadedMethodInfo MemoryTextureBuilderGetFormatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetFormat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetFormat"
        })


#endif

-- method MemoryTextureBuilder::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_height" gdk_memory_texture_builder_get_height :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO Int32

-- | Gets the height previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetHeight'
-- or 0 if the height wasn\'t set.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m Int32
    -- ^ __Returns:__ The height
memoryTextureBuilderGetHeight self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_height self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetHeightMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetHeight

instance O.OverloadedMethodInfo MemoryTextureBuilderGetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetHeight"
        })


#endif

-- method MemoryTextureBuilder::get_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plane"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a plane" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_offset" gdk_memory_texture_builder_get_offset :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Word32 ->                               -- plane : TBasicType TUInt
    IO FCT.CSize

-- | Gets the offset previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetOffset'.
-- 
-- /Since: 4.20/
memoryTextureBuilderGetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Word32
    -- ^ /@plane@/: a plane
    -> m FCT.CSize
    -- ^ __Returns:__ The offset associated to a /@plane@/
memoryTextureBuilderGetOffset self plane = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_offset self' plane
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetOffsetMethodInfo
instance (signature ~ (Word32 -> m FCT.CSize), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetOffsetMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetOffset

instance O.OverloadedMethodInfo MemoryTextureBuilderGetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetOffset"
        })


#endif

-- method MemoryTextureBuilder::get_stride
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_stride" gdk_memory_texture_builder_get_stride :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO FCT.CSize

-- | Gets the stride previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetStride'.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetStride ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m FCT.CSize
    -- ^ __Returns:__ the stride
memoryTextureBuilderGetStride self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_stride self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetStrideMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetStrideMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetStride

instance O.OverloadedMethodInfo MemoryTextureBuilderGetStrideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetStride",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetStride"
        })


#endif

-- method MemoryTextureBuilder::get_stride_for_plane
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plane"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a plane" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_stride_for_plane" gdk_memory_texture_builder_get_stride_for_plane :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Word32 ->                               -- plane : TBasicType TUInt
    IO FCT.CSize

-- | Gets the stride previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetStrideForPlane'.
-- 
-- /Since: 4.20/
memoryTextureBuilderGetStrideForPlane ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Word32
    -- ^ /@plane@/: a plane
    -> m FCT.CSize
    -- ^ __Returns:__ The stride associated to a /@plane@/
memoryTextureBuilderGetStrideForPlane self plane = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_stride_for_plane self' plane
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetStrideForPlaneMethodInfo
instance (signature ~ (Word32 -> m FCT.CSize), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetStrideForPlaneMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetStrideForPlane

instance O.OverloadedMethodInfo MemoryTextureBuilderGetStrideForPlaneMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetStrideForPlane",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetStrideForPlane"
        })


#endif

-- method MemoryTextureBuilder::get_update_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_update_region" gdk_memory_texture_builder_get_update_region :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO (Ptr Cairo.Region.Region)

-- | Gets the region previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetUpdateRegion'
-- or 'P.Nothing' if none was set.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetUpdateRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m (Maybe Cairo.Region.Region)
    -- ^ __Returns:__ The update region
memoryTextureBuilderGetUpdateRegion self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_update_region self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.Region.Region) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetUpdateRegionMethodInfo
instance (signature ~ (m (Maybe Cairo.Region.Region)), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetUpdateRegionMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetUpdateRegion

instance O.OverloadedMethodInfo MemoryTextureBuilderGetUpdateRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetUpdateRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetUpdateRegion"
        })


#endif

-- method MemoryTextureBuilder::get_update_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_update_texture" gdk_memory_texture_builder_get_update_texture :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO (Ptr Gdk.Texture.Texture)

-- | Gets the texture previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetUpdateTexture'
-- or 'P.Nothing' if none was set.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetUpdateTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m (Maybe Gdk.Texture.Texture)
    -- ^ __Returns:__ The update texture
memoryTextureBuilderGetUpdateTexture self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_update_texture self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Texture.Texture) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetUpdateTextureMethodInfo
instance (signature ~ (m (Maybe Gdk.Texture.Texture)), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetUpdateTextureMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetUpdateTexture

instance O.OverloadedMethodInfo MemoryTextureBuilderGetUpdateTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetUpdateTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetUpdateTexture"
        })


#endif

-- method MemoryTextureBuilder::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_get_width" gdk_memory_texture_builder_get_width :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    IO Int32

-- | Gets the width previously set via 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetWidth'
-- or 0 if the width wasn\'t set.
-- 
-- /Since: 4.16/
memoryTextureBuilderGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> m Int32
    -- ^ __Returns:__ The width
memoryTextureBuilderGetWidth self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_memory_texture_builder_get_width self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderGetWidthMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderGetWidth

instance O.OverloadedMethodInfo MemoryTextureBuilderGetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderGetWidth"
        })


#endif

-- method MemoryTextureBuilder::set_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The bytes the texture shows or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_bytes" gdk_memory_texture_builder_set_bytes :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO ()

-- | Sets the data to be shown but the texture.
-- 
-- The bytes must be set before calling 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild'.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Maybe (GLib.Bytes.Bytes)
    -- ^ /@bytes@/: The bytes the texture shows or 'P.Nothing' to unset
    -> m ()
memoryTextureBuilderSetBytes self bytes = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeBytes <- case bytes of
        Nothing -> return FP.nullPtr
        Just jBytes -> do
            jBytes' <- unsafeManagedPtrGetPtr jBytes
            return jBytes'
    gdk_memory_texture_builder_set_bytes self' maybeBytes
    touchManagedPtr self
    whenJust bytes touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetBytesMethodInfo
instance (signature ~ (Maybe (GLib.Bytes.Bytes) -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetBytesMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetBytes

instance O.OverloadedMethodInfo MemoryTextureBuilderSetBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetBytes"
        })


#endif

-- method MemoryTextureBuilder::set_color_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The colorstate describing the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_color_state" gdk_memory_texture_builder_set_color_state :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Ptr Gdk.ColorState.ColorState ->        -- color_state : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO ()

-- | Sets the colorstate describing the data.
-- 
-- By default, the sRGB colorstate is used. If you don\'t know
-- what colorstates are, this is probably the right thing.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetColorState ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Gdk.ColorState.ColorState
    -- ^ /@colorState@/: The colorstate describing the data
    -> m ()
memoryTextureBuilderSetColorState self colorState = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    colorState' <- unsafeManagedPtrGetPtr colorState
    gdk_memory_texture_builder_set_color_state self' colorState'
    touchManagedPtr self
    touchManagedPtr colorState
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetColorStateMethodInfo
instance (signature ~ (Gdk.ColorState.ColorState -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetColorStateMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetColorState

instance O.OverloadedMethodInfo MemoryTextureBuilderSetColorStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetColorState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetColorState"
        })


#endif

-- method MemoryTextureBuilder::set_format
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "MemoryFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_format" gdk_memory_texture_builder_set_format :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    CUInt ->                                -- format : TInterface (Name {namespace = "Gdk", name = "MemoryFormat"})
    IO ()

-- | Sets the format of the bytes.
-- 
-- The default is @GDK_MEMORY_R8G8B8A8_PREMULTIPLIED@.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetFormat ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Gdk.Enums.MemoryFormat
    -- ^ /@format@/: The texture\'s format
    -> m ()
memoryTextureBuilderSetFormat self format = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let format' = (fromIntegral . fromEnum) format
    gdk_memory_texture_builder_set_format self' format'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetFormatMethodInfo
instance (signature ~ (Gdk.Enums.MemoryFormat -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetFormatMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetFormat

instance O.OverloadedMethodInfo MemoryTextureBuilderSetFormatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetFormat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetFormat"
        })


#endif

-- method MemoryTextureBuilder::set_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's height or 0 to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_height" gdk_memory_texture_builder_set_height :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the height of the texture.
-- 
-- The height must be set before calling 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild'
-- and conform to size requirements of the provided format.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Int32
    -- ^ /@height@/: The texture\'s height or 0 to unset
    -> m ()
memoryTextureBuilderSetHeight self height = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_memory_texture_builder_set_height self' height
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetHeightMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetHeightMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetHeight

instance O.OverloadedMethodInfo MemoryTextureBuilderSetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetHeight"
        })


#endif

-- method MemoryTextureBuilder::set_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plane"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a plane" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the texture's offset for @plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_offset" gdk_memory_texture_builder_set_offset :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Word32 ->                               -- plane : TBasicType TUInt
    FCT.CSize ->                            -- offset : TBasicType TSize
    IO ()

-- | Sets the offset of the texture for /@plane@/.
-- 
-- /Since: 4.20/
memoryTextureBuilderSetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Word32
    -- ^ /@plane@/: a plane
    -> FCT.CSize
    -- ^ /@offset@/: the texture\'s offset for /@plane@/
    -> m ()
memoryTextureBuilderSetOffset self plane offset = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_memory_texture_builder_set_offset self' plane offset
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetOffsetMethodInfo
instance (signature ~ (Word32 -> FCT.CSize -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetOffsetMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetOffset

instance O.OverloadedMethodInfo MemoryTextureBuilderSetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetOffset"
        })


#endif

-- method MemoryTextureBuilder::set_stride
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stride"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stride or 0 to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_stride" gdk_memory_texture_builder_set_stride :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    FCT.CSize ->                            -- stride : TBasicType TSize
    IO ()

-- | Sets the rowstride of the bytes used.
-- 
-- The rowstride must be set before calling 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild'.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetStride ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> FCT.CSize
    -- ^ /@stride@/: the stride or 0 to unset
    -> m ()
memoryTextureBuilderSetStride self stride = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_memory_texture_builder_set_stride self' stride
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetStrideMethodInfo
instance (signature ~ (FCT.CSize -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetStrideMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetStride

instance O.OverloadedMethodInfo MemoryTextureBuilderSetStrideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetStride",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetStride"
        })


#endif

-- method MemoryTextureBuilder::set_stride_for_plane
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plane"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a plane" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stride"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the texture's stride for @plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_stride_for_plane" gdk_memory_texture_builder_set_stride_for_plane :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Word32 ->                               -- plane : TBasicType TUInt
    FCT.CSize ->                            -- stride : TBasicType TSize
    IO ()

-- | Sets the stride of the texture for /@plane@/.
-- 
-- /Since: 4.20/
memoryTextureBuilderSetStrideForPlane ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Word32
    -- ^ /@plane@/: a plane
    -> FCT.CSize
    -- ^ /@stride@/: the texture\'s stride for /@plane@/
    -> m ()
memoryTextureBuilderSetStrideForPlane self plane stride = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_memory_texture_builder_set_stride_for_plane self' plane stride
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetStrideForPlaneMethodInfo
instance (signature ~ (Word32 -> FCT.CSize -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetStrideForPlaneMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetStrideForPlane

instance O.OverloadedMethodInfo MemoryTextureBuilderSetStrideForPlaneMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetStrideForPlane",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetStrideForPlane"
        })


#endif

-- method MemoryTextureBuilder::set_update_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the region to update"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_update_region" gdk_memory_texture_builder_set_update_region :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | Sets the region to be updated by this texture.
-- 
-- Together with [MemoryTextureBuilder:updateTexture]("GI.Gdk.Objects.MemoryTextureBuilder#g:attr:updateTexture"),
-- this describes an update of a previous texture.
-- 
-- When rendering animations of large textures, it is possible that
-- consecutive textures are only updating contents in parts of the texture.
-- It is then possible to describe this update via these two properties,
-- so that GTK can avoid rerendering parts that did not change.
-- 
-- An example would be a screen recording where only the mouse pointer moves.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetUpdateRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Maybe (Cairo.Region.Region)
    -- ^ /@region@/: the region to update
    -> m ()
memoryTextureBuilderSetUpdateRegion self region = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeRegion <- case region of
        Nothing -> return FP.nullPtr
        Just jRegion -> do
            jRegion' <- unsafeManagedPtrGetPtr jRegion
            return jRegion'
    gdk_memory_texture_builder_set_update_region self' maybeRegion
    touchManagedPtr self
    whenJust region touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetUpdateRegionMethodInfo
instance (signature ~ (Maybe (Cairo.Region.Region) -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetUpdateRegionMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetUpdateRegion

instance O.OverloadedMethodInfo MemoryTextureBuilderSetUpdateRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetUpdateRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetUpdateRegion"
        })


#endif

-- method MemoryTextureBuilder::set_update_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "texture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Texture" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the texture to update"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_update_texture" gdk_memory_texture_builder_set_update_texture :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Ptr Gdk.Texture.Texture ->              -- texture : TInterface (Name {namespace = "Gdk", name = "Texture"})
    IO ()

-- | Sets the texture to be updated by this texture.
-- 
-- See 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetUpdateRegion' for an explanation.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetUpdateTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a, Gdk.Texture.IsTexture b) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Maybe (b)
    -- ^ /@texture@/: the texture to update
    -> m ()
memoryTextureBuilderSetUpdateTexture self texture = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeTexture <- case texture of
        Nothing -> return FP.nullPtr
        Just jTexture -> do
            jTexture' <- unsafeManagedPtrCastPtr jTexture
            return jTexture'
    gdk_memory_texture_builder_set_update_texture self' maybeTexture
    touchManagedPtr self
    whenJust texture touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetUpdateTextureMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMemoryTextureBuilder a, Gdk.Texture.IsTexture b) => O.OverloadedMethod MemoryTextureBuilderSetUpdateTextureMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetUpdateTexture

instance O.OverloadedMethodInfo MemoryTextureBuilderSetUpdateTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetUpdateTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetUpdateTexture"
        })


#endif

-- method MemoryTextureBuilder::set_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gdk" , name = "MemoryTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkMemoryTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's width or 0 to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_memory_texture_builder_set_width" gdk_memory_texture_builder_set_width :: 
    Ptr MemoryTextureBuilder ->             -- self : TInterface (Name {namespace = "Gdk", name = "MemoryTextureBuilder"})
    Int32 ->                                -- width : TBasicType TInt
    IO ()

-- | Sets the width of the texture.
-- 
-- The width must be set before calling 'GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderBuild'
-- and conform to size requirements of the provided format.
-- 
-- /Since: 4.16/
memoryTextureBuilderSetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkMemoryTextureBuilder@
    -> Int32
    -- ^ /@width@/: The texture\'s width or 0 to unset
    -> m ()
memoryTextureBuilderSetWidth self width = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_memory_texture_builder_set_width self' width
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryTextureBuilderSetWidthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsMemoryTextureBuilder a) => O.OverloadedMethod MemoryTextureBuilderSetWidthMethodInfo a signature where
    overloadedMethod = memoryTextureBuilderSetWidth

instance O.OverloadedMethodInfo MemoryTextureBuilderSetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.MemoryTextureBuilder.memoryTextureBuilderSetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-MemoryTextureBuilder.html#v:memoryTextureBuilderSetWidth"
        })


#endif


