// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ResourceLogs is a collection of logs from a Resource.
type ResourceLogs struct {
	Resource            Resource
	ScopeLogs           []*ScopeLogs
	SchemaUrl           string
	DeprecatedScopeLogs []*ScopeLogs
}

var (
	protoPoolResourceLogs = sync.Pool{
		New: func() any {
			return &ResourceLogs{}
		},
	}
)

func NewResourceLogs() *ResourceLogs {
	if !UseProtoPooling.IsEnabled() {
		return &ResourceLogs{}
	}
	return protoPoolResourceLogs.Get().(*ResourceLogs)
}

func DeleteResourceLogs(orig *ResourceLogs, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteResource(&orig.Resource, false)
	for i := range orig.ScopeLogs {
		DeleteScopeLogs(orig.ScopeLogs[i], true)
	}

	for i := range orig.DeprecatedScopeLogs {
		DeleteScopeLogs(orig.DeprecatedScopeLogs[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolResourceLogs.Put(orig)
	}
}

func CopyResourceLogs(dest, src *ResourceLogs) *ResourceLogs {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewResourceLogs()
	}
	CopyResource(&dest.Resource, &src.Resource)

	dest.ScopeLogs = CopyScopeLogsPtrSlice(dest.ScopeLogs, src.ScopeLogs)

	dest.SchemaUrl = src.SchemaUrl
	dest.DeprecatedScopeLogs = CopyScopeLogsPtrSlice(dest.DeprecatedScopeLogs, src.DeprecatedScopeLogs)

	return dest
}

func CopyResourceLogsSlice(dest, src []ResourceLogs) []ResourceLogs {
	var newDest []ResourceLogs
	if cap(dest) < len(src) {
		newDest = make([]ResourceLogs, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceLogs(&dest[i], false)
		}
	}
	for i := range src {
		CopyResourceLogs(&newDest[i], &src[i])
	}
	return newDest
}

func CopyResourceLogsPtrSlice(dest, src []*ResourceLogs) []*ResourceLogs {
	var newDest []*ResourceLogs
	if cap(dest) < len(src) {
		newDest = make([]*ResourceLogs, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceLogs()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceLogs(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceLogs()
		}
	}
	for i := range src {
		CopyResourceLogs(newDest[i], src[i])
	}
	return newDest
}

func (orig *ResourceLogs) Reset() {
	*orig = ResourceLogs{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ResourceLogs) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	orig.Resource.MarshalJSON(dest)
	if len(orig.ScopeLogs) > 0 {
		dest.WriteObjectField("scopeLogs")
		dest.WriteArrayStart()
		orig.ScopeLogs[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ScopeLogs); i++ {
			dest.WriteMore()
			orig.ScopeLogs[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	if len(orig.DeprecatedScopeLogs) > 0 {
		dest.WriteObjectField("deprecatedScopeLogs")
		dest.WriteArrayStart()
		orig.DeprecatedScopeLogs[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DeprecatedScopeLogs); i++ {
			dest.WriteMore()
			orig.DeprecatedScopeLogs[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ResourceLogs) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resource":

			orig.Resource.UnmarshalJSON(iter)
		case "scopeLogs", "scope_logs":
			for iter.ReadArray() {
				orig.ScopeLogs = append(orig.ScopeLogs, NewScopeLogs())
				orig.ScopeLogs[len(orig.ScopeLogs)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		case "deprecatedScopeLogs", "deprecated_scope_logs":
			for iter.ReadArray() {
				orig.DeprecatedScopeLogs = append(orig.DeprecatedScopeLogs, NewScopeLogs())
				orig.DeprecatedScopeLogs[len(orig.DeprecatedScopeLogs)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ResourceLogs) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Resource.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeLogs {
		l = orig.ScopeLogs[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}

	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.DeprecatedScopeLogs {
		l = orig.DeprecatedScopeLogs[i].SizeProto()
		n += 2 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ResourceLogs) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Resource.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.ScopeLogs) - 1; i >= 0; i-- {
		l = orig.ScopeLogs[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.DeprecatedScopeLogs) - 1; i >= 0; i-- {
		l = orig.DeprecatedScopeLogs[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3e
		pos--
		buf[pos] = 0xc2
	}
	return len(buf) - pos
}

func (orig *ResourceLogs) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Resource.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeLogs", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ScopeLogs = append(orig.ScopeLogs, NewScopeLogs())
			err = orig.ScopeLogs[len(orig.ScopeLogs)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])

		case 1000:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedScopeLogs", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DeprecatedScopeLogs = append(orig.DeprecatedScopeLogs, NewScopeLogs())
			err = orig.DeprecatedScopeLogs[len(orig.DeprecatedScopeLogs)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestResourceLogs() *ResourceLogs {
	orig := NewResourceLogs()
	orig.Resource = *GenTestResource()
	orig.ScopeLogs = []*ScopeLogs{{}, GenTestScopeLogs()}
	orig.SchemaUrl = "test_schemaurl"
	orig.DeprecatedScopeLogs = []*ScopeLogs{{}, GenTestScopeLogs()}
	return orig
}

func GenTestResourceLogsPtrSlice() []*ResourceLogs {
	orig := make([]*ResourceLogs, 5)
	orig[0] = NewResourceLogs()
	orig[1] = GenTestResourceLogs()
	orig[2] = NewResourceLogs()
	orig[3] = GenTestResourceLogs()
	orig[4] = NewResourceLogs()
	return orig
}

func GenTestResourceLogsSlice() []ResourceLogs {
	orig := make([]ResourceLogs, 5)
	orig[1] = *GenTestResourceLogs()
	orig[3] = *GenTestResourceLogs()
	return orig
}
