/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_file_source = R"doc(Read stream from file.

Constructor Specific Documentation:

Create a file source.

Opens  as a source of items into a flowgraph. The data is expected to be in binary format, item after item. The  of the block determines the conversion from bits to items. The first  items (default 0) will be skipped.


If  is turned on, the file will repeat the file after it's reached the end.


If  is non-zero, only items (offset, offset+len) will be produced.

Args:
    itemsize : the size of each item in the file, in bytes
    filename : name of the file to source from
    repeat : repeat file from start
    offset : begin this many items into file
    len : produce only items (offset, offset+len))doc";


static const char* __doc_gr_blocks_file_source_file_source_0 = R"doc()doc";


static const char* __doc_gr_blocks_file_source_file_source_1 = R"doc()doc";


static const char* __doc_gr_blocks_file_source_make = R"doc(Read stream from file.

Constructor Specific Documentation:

Create a file source.

Opens  as a source of items into a flowgraph. The data is expected to be in binary format, item after item. The  of the block determines the conversion from bits to items. The first  items (default 0) will be skipped.


If  is turned on, the file will repeat the file after it's reached the end.


If  is non-zero, only items (offset, offset+len) will be produced.

Args:
    itemsize : the size of each item in the file, in bytes
    filename : name of the file to source from
    repeat : repeat file from start
    offset : begin this many items into file
    len : produce only items (offset, offset+len))doc";


static const char* __doc_gr_blocks_file_source_seek = R"doc(seek file to  relative to)doc";


static const char* __doc_gr_blocks_file_source_open = R"doc(Opens a new file.)doc";


static const char* __doc_gr_blocks_file_source_close = R"doc(Close the file handle.)doc";


static const char* __doc_gr_blocks_file_source_set_begin_tag = R"doc(Add a stream tag to the first sample of the file if true.)doc";
