/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_test_tag_variable_rate_ff = R"doc(Used for testing tag propagation.

This block resamples the stream by a factor that starts at 0.5 but varies around by some random walk. The relative rate of the block is initialized to 0.5 and the random number generator is seeded based on the time. For each input, if the random number is >= 0.5, the relative rate is increased by ; otherwise, it is decreased by .


The rate of the change of the resampling factor is set by the flag . If this is set to true, then the rate is only updated once per work function. If it is set to false (default), then the rate is changed with every input sample.


The block's ctor sets the propagation policy to TPP_DONT to stop tags from automatically propagating. Instead, we handle the tag propagation ourselves from within the work function. Because the relative_rate changes so fast, the tag placement cannot be based on a single factor after the call to work and must be handled when the samples are and based on the current resampling rate.

Constructor Specific Documentation:

Build a test_tag_variable_rate_ff block.

Args:
    update_once : Update the resampling rate once per call to work (default=false).
    update_step : How much to adjust the resampling rate by when the update occurs (default=0.001).)doc";


static const char* __doc_gr_blocks_test_tag_variable_rate_ff_test_tag_variable_rate_ff =
    R"doc()doc";


static const char* __doc_gr_blocks_test_tag_variable_rate_ff_make = R"doc(Used for testing tag propagation.

This block resamples the stream by a factor that starts at 0.5 but varies around by some random walk. The relative rate of the block is initialized to 0.5 and the random number generator is seeded based on the time. For each input, if the random number is >= 0.5, the relative rate is increased by ; otherwise, it is decreased by .


The rate of the change of the resampling factor is set by the flag . If this is set to true, then the rate is only updated once per work function. If it is set to false (default), then the rate is changed with every input sample.


The block's ctor sets the propagation policy to TPP_DONT to stop tags from automatically propagating. Instead, we handle the tag propagation ourselves from within the work function. Because the relative_rate changes so fast, the tag placement cannot be based on a single factor after the call to work and must be handled when the samples are and based on the current resampling rate.

Constructor Specific Documentation:

Build a test_tag_variable_rate_ff block.

Args:
    update_once : Update the resampling rate once per call to work (default=false).
    update_step : How much to adjust the resampling rate by when the update occurs (default=0.001).)doc";
