/* game-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of a GNOME game

   Copyright (C) 2015-2019 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   This application is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this application.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define TAQUIN_PROGRAM_NAME _ ("Taquin")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GAME_WINDOW_FLAGS_HAS_SOUND = 1 << 0,
	GAME_WINDOW_FLAGS_SHORTCUTS = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HELP = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;
typedef struct _BaseWindowPrivate BaseWindowPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_NIGHT_TIME_AWARE_HEADER_BAR (night_time_aware_header_bar_get_type ())
#define NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar))
#define NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define NIGHT_TIME_AWARE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))

typedef struct _NightTimeAwareHeaderBar NightTimeAwareHeaderBar;
typedef struct _NightTimeAwareHeaderBarClass NightTimeAwareHeaderBarClass;

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;

#define TYPE_GAME_HEADER_BAR (game_header_bar_get_type ())
#define GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBar))
#define GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))
#define IS_GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_HEADER_BAR))
#define IS_GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_HEADER_BAR))
#define GAME_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))

typedef struct _GameHeaderBar GameHeaderBar;
typedef struct _GameHeaderBarClass GameHeaderBarClass;

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_GAME_ACTION_BAR (game_action_bar_get_type ())
#define GAME_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_ACTION_BAR, GameActionBar))
#define GAME_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_ACTION_BAR, GameActionBarClass))
#define IS_GAME_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_ACTION_BAR))
#define IS_GAME_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_ACTION_BAR))
#define GAME_ACTION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_ACTION_BAR, GameActionBarClass))

typedef struct _GameActionBar GameActionBar;
typedef struct _GameActionBarClass GameActionBarClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NIGHT_LIGHT_MONITOR (night_light_monitor_get_type ())
#define NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor))
#define NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))
#define IS_NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_LIGHT_MONITOR))
#define IS_NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_LIGHT_MONITOR))
#define NIGHT_LIGHT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))

typedef struct _NightLightMonitor NightLightMonitor;
typedef struct _NightLightMonitorClass NightLightMonitorClass;

#define TYPE_GAME_ACTION_BAR_PLACE_HOLDER (game_action_bar_place_holder_get_type ())
#define GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolder))
#define GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define GAME_ACTION_BAR_PLACE_HOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))

typedef struct _GameActionBarPlaceHolder GameActionBarPlaceHolder;
typedef struct _GameActionBarPlaceHolderClass GameActionBarPlaceHolderClass;
enum  {
	GAME_WINDOW_PLAY_SIGNAL,
	GAME_WINDOW_WAIT_SIGNAL,
	GAME_WINDOW_BACK_SIGNAL,
	GAME_WINDOW_RESTART_SIGNAL,
	GAME_WINDOW_UNDO_SIGNAL,
	GAME_WINDOW_REDO_SIGNAL,
	GAME_WINDOW_HINT_SIGNAL,
	GAME_WINDOW_NUM_SIGNALS
};
static guint game_window_signals[GAME_WINDOW_NUM_SIGNALS] = {0};

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*on_fullscreen) (AdaptativeWindow* self);
	void (*on_unfullscreen) (AdaptativeWindow* self);
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseWindow {
	AdaptativeWindow parent_instance;
	BaseWindowPrivate * priv;
	GSimpleAction* escape_action;
};

struct _BaseWindowClass {
	AdaptativeWindowClass parent_class;
	gboolean (*handle_copy_text) (BaseWindow* self, gchar** copy_text);
	gboolean (*get_alt_copy_text) (BaseWindow* self, gchar** copy_text);
	void (*paste_text) (BaseWindow* self, const gchar* text);
	void (*menu_pressed) (BaseWindow* self);
	void (*set_window_size) (BaseWindow* self, AdaptativeWidgetWindowSize new_size);
	void (*close_in_window_panels) (BaseWindow* self);
	gboolean (*escape_pressed) (BaseWindow* self);
	void (*show_default_view) (BaseWindow* self);
};

struct _GameWindow {
	BaseWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	BaseWindowClass parent_class;
};

struct _GameWindowPrivate {
	gboolean game_finished;
	GameHeaderBar* headerbar;
	GameView* game_view;
	GameActionBar* actionbar;
	gboolean is_quite_thin;
	GSimpleAction* restart_action;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	gboolean back_action_disabled;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;
static AdaptativeWidgetIface * game_window_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType night_time_aware_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightTimeAwareHeaderBar, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType game_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHeaderBar, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType game_action_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameActionBar, g_object_unref)
VALA_EXTERN void base_window_set_window_size (BaseWindow* self,
                                  AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean base_window_escape_pressed (BaseWindow* self);
static void game_window_start_or_restart_cb (GameWindow* self);
static void _game_window_start_or_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void game_window_restart_cb (GameWindow* self);
static void _game_window_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_redo_cb (GameWindow* self);
static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_hint_cb (GameWindow* self);
static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
VALA_EXTERN GType night_light_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightLightMonitor, g_object_unref)
VALA_EXTERN GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             const gchar* about_action_label,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* view_content,
                             GMenu* appearance_menu,
                             GtkWidget* game_widget_1,
                             GtkWidget* game_widget_2,
                             NightLightMonitor* night_light_monitor);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   const gchar* about_action_label,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* view_content,
                                   GMenu* appearance_menu,
                                   GtkWidget* game_widget_1,
                                   GtkWidget* game_widget_2,
                                   NightLightMonitor* night_light_monitor);
VALA_EXTERN GameActionBar* game_action_bar_new (const gchar* _game_name,
                                    GtkWidget* _game_widget,
                                    gboolean _show_actionbar);
VALA_EXTERN GameActionBar* game_action_bar_construct (GType object_type,
                                          const gchar* _game_name,
                                          GtkWidget* _game_widget,
                                          gboolean _show_actionbar);
VALA_EXTERN GType game_action_bar_place_holder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameActionBarPlaceHolder, g_object_unref)
VALA_EXTERN GameActionBarPlaceHolder* game_action_bar_place_holder_new (GameActionBar* _actionbar);
VALA_EXTERN GameActionBarPlaceHolder* game_action_bar_place_holder_construct (GType object_type,
                                                                  GameActionBar* _actionbar);
VALA_EXTERN GameHeaderBar* game_header_bar_new (const gchar* _window_name,
                                    const gchar* _about_action_label,
                                    GameWindowFlags flags,
                                    GMenu* _appearance_menu,
                                    GtkWidget* _game_widget,
                                    NightLightMonitor* _night_light_monitor);
VALA_EXTERN GameHeaderBar* game_header_bar_construct (GType object_type,
                                          const gchar* _window_name,
                                          const gchar* _about_action_label,
                                          GameWindowFlags flags,
                                          GMenu* _appearance_menu,
                                          GtkWidget* _game_widget,
                                          NightLightMonitor* _night_light_monitor);
VALA_EXTERN GameView* game_view_new (GameWindowFlags flags,
                         GtkBox* new_game_screen,
                         GtkWidget* content,
                         GameActionBarPlaceHolder* actionbar_placeholder);
VALA_EXTERN GameView* game_view_construct (GType object_type,
                               GameWindowFlags flags,
                               GtkBox* new_game_screen,
                               GtkWidget* content,
                               GameActionBarPlaceHolder* actionbar_placeholder);
VALA_EXTERN void base_window_add_to_main_overlay (BaseWindow* self,
                                      GtkWidget* widget);
VALA_EXTERN void adaptative_window_add_adaptative_child (AdaptativeWindow* self,
                                             AdaptativeWidget* child);
static void game_window_install_ui_action_entries (GameWindow* self);
static void game_window_show_view (GameWindow* self);
static void game_window_show_new_game_screen (GameWindow* self);
static void game_window_real_set_window_size (AdaptativeWidget* base,
                                       AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void game_window_move_done (GameWindow* self,
                            guint moves_count);
VALA_EXTERN void base_window_hide_notification (BaseWindow* self);
VALA_EXTERN void game_view_show_game_content (GameView* self,
                                  gboolean grab_focus);
VALA_EXTERN void game_window_finish_game (GameWindow* self);
VALA_EXTERN void game_header_bar_new_game_button_grab_focus (GameHeaderBar* self);
static gboolean game_window_real_escape_pressed (BaseWindow* base);
static void game_window_back_cb (GameWindow* self);
VALA_EXTERN gboolean game_view_game_content_visible_if_true (GameView* self);
VALA_EXTERN void game_view_configure_transition (GameView* self,
                                     GtkStackTransitionType transition_type,
                                     guint transition_duration);
VALA_EXTERN void game_window_update_title (GameWindow* self,
                               const gchar* game_name);
VALA_EXTERN void game_header_bar_update_title (GameHeaderBar* self,
                                   const gchar* new_title);
VALA_EXTERN void game_action_bar_update_title (GameActionBar* self,
                                   const gchar* new_title);
VALA_EXTERN void game_action_bar_set_visibility (GameActionBar* self,
                                     gboolean new_visibility);
VALA_EXTERN gboolean game_header_bar_show_new_game_screen (GameHeaderBar* self,
                                               gboolean game_finished);
VALA_EXTERN void game_view_show_new_game_box (GameView* self,
                                  gboolean grab_focus);
VALA_EXTERN gboolean game_header_bar_show_view (GameHeaderBar* self,
                                    gboolean game_finished);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
static void game_window_start_game (GameWindow* self);
static void game_window_restart_game (GameWindow* self);
VALA_EXTERN void base_window_show_notification (BaseWindow* self,
                                    const gchar* notification);
static void game_window_new_game (GameWindow* self);
VALA_EXTERN void game_header_bar_new_game (GameHeaderBar* self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);

static const GActionEntry GAME_WINDOW_ui_action_entries[6] = {{"start-or-restart", _game_window_start_or_restart_cb_gsimple_action_activate_callback}, {"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"restart", _game_window_restart_cb_gsimple_action_activate_callback}, {"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"redo", _game_window_redo_cb_gsimple_action_activate_callback}, {"hint", _game_window_hint_cb_gsimple_action_activate_callback}};

static GType
game_window_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GAME_WINDOW_FLAGS_HAS_SOUND, "GAME_WINDOW_FLAGS_HAS_SOUND", "has-sound"}, {GAME_WINDOW_FLAGS_SHORTCUTS, "GAME_WINDOW_FLAGS_SHORTCUTS", "shortcuts"}, {GAME_WINDOW_FLAGS_SHOW_HELP, "GAME_WINDOW_FLAGS_SHOW_HELP", "show-help"}, {GAME_WINDOW_FLAGS_SHOW_START_BUTTON, "GAME_WINDOW_FLAGS_SHOW_START_BUTTON", "show-start-button"}, {0, NULL, NULL}};
	GType game_window_flags_type_id;
	game_window_flags_type_id = g_flags_register_static ("GameWindowFlags", values);
	return game_window_flags_type_id;
}

GType
game_window_flags_get_type (void)
{
	static volatile gsize game_window_flags_type_id__once = 0;
	if (g_once_init_enter (&game_window_flags_type_id__once)) {
		GType game_window_flags_type_id;
		game_window_flags_type_id = game_window_flags_get_type_once ();
		g_once_init_leave (&game_window_flags_type_id__once, game_window_flags_type_id);
	}
	return game_window_flags_type_id__once;
}

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static void
_game_window_start_or_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	game_window_start_or_restart_cb ((GameWindow*) self);
}

static void
_game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_new_game_cb ((GameWindow*) self);
}

static void
_game_window_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	game_window_restart_cb ((GameWindow*) self);
}

static void
_game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_undo_cb ((GameWindow*) self);
}

static void
_game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_redo_cb ((GameWindow*) self);
}

static void
_game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_hint_cb ((GameWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GameWindow*
game_window_construct (GType object_type,
                       const gchar* css_resource,
                       const gchar* name,
                       const gchar* about_action_label,
                       gboolean start_now,
                       GameWindowFlags flags,
                       GtkBox* new_game_screen,
                       GtkWidget* view_content,
                       GMenu* appearance_menu,
                       GtkWidget* game_widget_1,
                       GtkWidget* game_widget_2,
                       NightLightMonitor* night_light_monitor)
{
	GameWindow * self = NULL;
	GameActionBar* _actionbar = NULL;
	GameActionBar* _tmp0_;
	GameActionBarPlaceHolder* actionbar_placeholder = NULL;
	GameActionBar* _tmp1_;
	GameActionBarPlaceHolder* _tmp2_;
	GameHeaderBar* _headerbar = NULL;
	GameHeaderBar* _tmp3_;
	GameView* _game_view = NULL;
	GameActionBarPlaceHolder* _tmp4_;
	GameView* _tmp5_;
	GameHeaderBar* _tmp6_;
	GameView* _tmp7_;
	GameHeaderBar* _tmp8_;
	GameHeaderBar* _tmp9_;
	GameView* _tmp10_;
	GameView* _tmp11_;
	GameActionBar* _tmp12_;
	GameActionBar* _tmp13_;
	GameActionBar* _tmp14_;
	GameActionBar* _tmp15_;
	GameView* _tmp16_;
	GameActionBar* _tmp17_;
	GameActionBarPlaceHolder* _tmp18_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (about_action_label != NULL, NULL);
	g_return_val_if_fail (new_game_screen != NULL, NULL);
	g_return_val_if_fail (view_content != NULL, NULL);
	g_return_val_if_fail (night_light_monitor != NULL, NULL);
	_tmp0_ = game_action_bar_new (name, game_widget_2, start_now);
	g_object_ref_sink (_tmp0_);
	_actionbar = _tmp0_;
	_tmp1_ = _actionbar;
	_tmp2_ = game_action_bar_place_holder_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	actionbar_placeholder = _tmp2_;
	_tmp3_ = game_header_bar_new (name, about_action_label, flags, appearance_menu, game_widget_1, night_light_monitor);
	g_object_ref_sink (_tmp3_);
	_headerbar = _tmp3_;
	_tmp4_ = actionbar_placeholder;
	_tmp5_ = game_view_new (flags, new_game_screen, view_content, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_game_view = _tmp5_;
	_tmp6_ = _headerbar;
	_tmp7_ = _game_view;
	self = (GameWindow*) g_object_new (object_type, "nta-headerbar", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar), "base-view", G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_BASE_VIEW, BaseView), "window-title", TAQUIN_PROGRAM_NAME, "specific-css-class-or-empty", "", "help-string-or-empty", "help:gnome-taquin", "schema-path", "/org/gnome/taquin/", NULL);
	_tmp8_ = _headerbar;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp9_;
	_tmp10_ = _game_view;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp11_;
	_tmp12_ = _actionbar;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->actionbar);
	self->priv->actionbar = _tmp13_;
	_tmp14_ = self->priv->actionbar;
	base_window_add_to_main_overlay ((BaseWindow*) self, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->actionbar;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_END);
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (new_game_screen, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	_tmp16_ = self->priv->game_view;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	_tmp17_ = self->priv->actionbar;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	_tmp18_ = actionbar_placeholder;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	if (css_resource != NULL) {
		GtkCssProvider* css_provider = NULL;
		GtkCssProvider* _tmp19_;
		GtkCssProvider* _tmp20_;
		GdkScreen* gdk_screen = NULL;
		GdkScreen* _tmp21_;
		GdkScreen* _tmp22_;
		GdkScreen* _tmp23_;
		_tmp19_ = gtk_css_provider_new ();
		css_provider = _tmp19_;
		_tmp20_ = css_provider;
		gtk_css_provider_load_from_resource (_tmp20_, (const gchar*) css_resource);
		_tmp21_ = gdk_screen_get_default ();
		_tmp22_ = _g_object_ref0 (_tmp21_);
		gdk_screen = _tmp22_;
		_tmp23_ = gdk_screen;
		if (_tmp23_ != NULL) {
			GdkScreen* _tmp24_;
			GtkCssProvider* _tmp25_;
			_tmp24_ = gdk_screen;
			_tmp25_ = css_provider;
			gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp25_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		}
		_g_object_unref0 (gdk_screen);
		_g_object_unref0 (css_provider);
	}
	game_window_install_ui_action_entries (self);
	gtk_window_set_title ((GtkWindow*) self, name);
	if (start_now) {
		game_window_show_view (self);
	} else {
		game_window_show_new_game_screen (self);
	}
	_g_object_unref0 (_game_view);
	_g_object_unref0 (_headerbar);
	_g_object_unref0 (actionbar_placeholder);
	_g_object_unref0 (_actionbar);
	return self;
}

GameWindow*
game_window_new (const gchar* css_resource,
                 const gchar* name,
                 const gchar* about_action_label,
                 gboolean start_now,
                 GameWindowFlags flags,
                 GtkBox* new_game_screen,
                 GtkWidget* view_content,
                 GMenu* appearance_menu,
                 GtkWidget* game_widget_1,
                 GtkWidget* game_widget_2,
                 NightLightMonitor* night_light_monitor)
{
	return game_window_construct (TYPE_GAME_WINDOW, css_resource, name, about_action_label, start_now, flags, new_game_screen, view_content, appearance_menu, game_widget_1, game_widget_2, night_light_monitor);
}

static void
game_window_real_set_window_size (AdaptativeWidget* base,
                                  AdaptativeWidgetWindowSize new_size)
{
	GameWindow * self;
	self = (GameWindow*) base;
	BASE_WINDOW_CLASS (game_window_parent_class)->set_window_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow), new_size);
	self->priv->is_quite_thin = adaptative_widget_window_size_is_quite_thin (new_size);
}

void
game_window_move_done (GameWindow* self,
                       guint moves_count)
{
	gboolean undo_possible = FALSE;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	base_window_hide_notification ((BaseWindow*) self);
	undo_possible = moves_count != ((guint) 0);
	_tmp0_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp0_, undo_possible);
	_tmp1_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp1_, undo_possible);
	if (!undo_possible) {
		GameView* _tmp2_;
		_tmp2_ = self->priv->game_view;
		game_view_show_game_content (_tmp2_, TRUE);
	}
}

void
game_window_finish_game (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->game_finished = TRUE;
	_tmp0_ = self->priv->headerbar;
	game_header_bar_new_game_button_grab_focus (_tmp0_);
}

static gboolean
game_window_real_escape_pressed (BaseWindow* base)
{
	GameWindow * self;
	gboolean result;
	self = (GameWindow*) base;
	if (BASE_WINDOW_CLASS (game_window_parent_class)->escape_pressed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_WINDOW, BaseWindow))) {
		result = TRUE;
		return result;
	}
	if (self->priv->back_action_disabled) {
		result = TRUE;
		return result;
	}
	game_window_back_cb (self);
	result = TRUE;
	return result;
}

static void
game_window_back_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (game_view_game_content_visible_if_true (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	game_view_configure_transition (_tmp1_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT, (guint) 800);
	game_window_show_view (self);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_BACK_SIGNAL], 0);
}

void
game_window_update_title (GameWindow* self,
                          const gchar* game_name)
{
	GameHeaderBar* _tmp0_;
	GameActionBar* _tmp1_;
	GameActionBar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game_name != NULL);
	_tmp0_ = self->priv->headerbar;
	game_header_bar_update_title (_tmp0_, game_name);
	_tmp1_ = self->priv->actionbar;
	game_action_bar_update_title (_tmp1_, game_name);
	_tmp2_ = self->priv->actionbar;
	game_action_bar_set_visibility (_tmp2_, TRUE);
}

static void
game_window_show_new_game_screen (GameWindow* self)
{
	GameHeaderBar* _tmp0_;
	GameActionBar* _tmp1_;
	gboolean grabs_focus = FALSE;
	GameHeaderBar* _tmp2_;
	GameView* _tmp3_;
	g_return_if_fail (self != NULL);
	base_window_hide_notification ((BaseWindow*) self);
	_tmp0_ = self->priv->headerbar;
	game_header_bar_update_title (_tmp0_, TAQUIN_PROGRAM_NAME);
	_tmp1_ = self->priv->actionbar;
	game_action_bar_set_visibility (_tmp1_, FALSE);
	_tmp2_ = self->priv->headerbar;
	grabs_focus = game_header_bar_show_new_game_screen (_tmp2_, self->priv->game_finished);
	_tmp3_ = self->priv->game_view;
	game_view_show_new_game_box (_tmp3_, !grabs_focus);
}

static void
game_window_show_view (GameWindow* self)
{
	gboolean grabs_focus = FALSE;
	GameHeaderBar* _tmp0_;
	GameView* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	grabs_focus = game_header_bar_show_view (_tmp0_, self->priv->game_finished);
	_tmp1_ = self->priv->game_view;
	game_view_show_game_content (_tmp1_, !grabs_focus);
	_tmp2_ = ((BaseWindow*) self)->escape_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
}

static void
game_window_install_ui_action_entries (GameWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, GAME_WINDOW_ui_action_entries, (gint) G_N_ELEMENTS (GAME_WINDOW_ui_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "ui", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "restart");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->restart_action);
	self->priv->restart_action = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) action_group, "undo");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp4_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) action_group, "redo");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp6_;
	_tmp7_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_g_object_unref0 (action_group);
}

static void
game_window_start_or_restart_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		game_window_start_game (self);
	} else {
		GSimpleAction* _tmp2_;
		_tmp2_ = self->priv->restart_action;
		if (g_action_get_enabled ((GAction*) _tmp2_)) {
			game_window_restart_game (self);
		} else {
			base_window_show_notification ((BaseWindow*) self, _ ("Already on initial position."));
		}
	}
}

static void
game_window_new_game_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		return;
	}
	game_window_new_game (self);
}

static void
game_window_restart_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		return;
	}
	game_window_restart_game (self);
}

static void
game_window_undo_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	GameView* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		if (!self->priv->back_action_disabled) {
			game_window_back_cb (self);
		}
		return;
	}
	self->priv->game_finished = FALSE;
	_tmp2_ = self->priv->game_view;
	game_view_show_game_content (_tmp2_, TRUE);
	_tmp3_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_UNDO_SIGNAL], 0);
}

static void
game_window_redo_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	GameView* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		return;
	}
	_tmp2_ = self->priv->game_view;
	game_view_show_game_content (_tmp2_, TRUE);
	_tmp3_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	_tmp4_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_REDO_SIGNAL], 0);
}

static void
game_window_hint_cb (GameWindow* self)
{
	GameView* _tmp0_;
	GameView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	if (base_view_is_in_in_window_mode ((BaseView*) _tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game_view;
	if (!game_view_game_content_visible_if_true (_tmp1_)) {
		return;
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_HINT_SIGNAL], 0);
}

static void
game_window_start_game (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->game_finished = FALSE;
	_tmp0_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	if (self->priv->is_quite_thin) {
		GameView* _tmp3_;
		_tmp3_ = self->priv->game_view;
		game_view_configure_transition (_tmp3_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN, (guint) 1000);
	} else {
		GameView* _tmp4_;
		_tmp4_ = self->priv->game_view;
		game_view_configure_transition (_tmp4_, GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP, (guint) 1000);
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_PLAY_SIGNAL], 0);
	game_window_show_view (self);
}

static void
game_window_restart_game (GameWindow* self)
{
	GameView* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->game_finished = FALSE;
	base_window_hide_notification ((BaseWindow*) self);
	_tmp0_ = self->priv->game_view;
	game_view_show_game_content (_tmp0_, TRUE);
	_tmp1_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_RESTART_SIGNAL], 0);
}

static void
game_window_new_game (GameWindow* self)
{
	GameView* _tmp0_;
	GameHeaderBar* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_WAIT_SIGNAL], 0);
	_tmp0_ = self->priv->game_view;
	game_view_configure_transition (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT, (guint) 800);
	_tmp1_ = self->priv->headerbar;
	game_header_bar_new_game (_tmp1_);
	self->priv->back_action_disabled = FALSE;
	_tmp2_ = ((BaseWindow*) self)->escape_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
	game_window_show_new_game_screen (self);
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	((BaseWindowClass *) klass)->set_window_size = (void (*) (BaseWindow*, AdaptativeWidgetWindowSize)) game_window_real_set_window_size;
	((BaseWindowClass *) klass)->escape_pressed = (gboolean (*) (BaseWindow*)) game_window_real_escape_pressed;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	game_window_signals[GAME_WINDOW_PLAY_SIGNAL] = g_signal_new ("play", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_WAIT_SIGNAL] = g_signal_new ("wait", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_BACK_SIGNAL] = g_signal_new ("back", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_RESTART_SIGNAL] = g_signal_new ("restart", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_UNDO_SIGNAL] = g_signal_new ("undo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_REDO_SIGNAL] = g_signal_new ("redo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_HINT_SIGNAL] = g_signal_new ("hint", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
game_window_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                              gpointer iface_data)
{
	game_window_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) game_window_real_set_window_size;
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	self->priv = game_window_get_instance_private (self);
	self->priv->game_finished = FALSE;
	self->priv->is_quite_thin = FALSE;
	self->priv->back_action_disabled = TRUE;
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->actionbar);
	_g_object_unref0 (self->priv->restart_action);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) game_window_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (TYPE_BASE_WINDOW, "GameWindow", &g_define_type_info, 0);
	g_type_add_interface_static (game_window_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

