/* pieManager.c generated by valac 0.56.18, the Vala compiler
 * generated from pieManager.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_PIE_MANAGER (gnome_pie_pie_manager_get_type ())
#define GNOME_PIE_PIE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManager))
#define GNOME_PIE_PIE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManagerClass))
#define GNOME_PIE_IS_PIE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE_MANAGER))
#define GNOME_PIE_IS_PIE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE_MANAGER))
#define GNOME_PIE_PIE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManagerClass))

typedef struct _GnomePiePieManager GnomePiePieManager;
typedef struct _GnomePiePieManagerClass GnomePiePieManagerClass;
typedef struct _GnomePiePieManagerPrivate GnomePiePieManagerPrivate;
enum  {
	GNOME_PIE_PIE_MANAGER_0_PROPERTY,
	GNOME_PIE_PIE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_pie_manager_properties[GNOME_PIE_PIE_MANAGER_NUM_PROPERTIES];

#define GNOME_PIE_TYPE_PIE (gnome_pie_pie_get_type ())
#define GNOME_PIE_PIE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE, GnomePiePie))
#define GNOME_PIE_PIE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE, GnomePiePieClass))
#define GNOME_PIE_IS_PIE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE))
#define GNOME_PIE_IS_PIE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE))
#define GNOME_PIE_PIE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE, GnomePiePieClass))

typedef struct _GnomePiePie GnomePiePie;
typedef struct _GnomePiePieClass GnomePiePieClass;

#define GNOME_PIE_TYPE_PIE_WINDOW (gnome_pie_pie_window_get_type ())
#define GNOME_PIE_PIE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindow))
#define GNOME_PIE_PIE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindowClass))
#define GNOME_PIE_IS_PIE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE_WINDOW))
#define GNOME_PIE_IS_PIE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE_WINDOW))
#define GNOME_PIE_PIE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE_WINDOW, GnomePiePieWindowClass))

typedef struct _GnomePiePieWindow GnomePiePieWindow;
typedef struct _GnomePiePieWindowClass GnomePiePieWindowClass;

#define GNOME_PIE_TYPE_BINDING_MANAGER (gnome_pie_binding_manager_get_type ())
#define GNOME_PIE_BINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManager))
#define GNOME_PIE_BINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManagerClass))
#define GNOME_PIE_IS_BINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_BINDING_MANAGER))
#define GNOME_PIE_IS_BINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_BINDING_MANAGER))
#define GNOME_PIE_BINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_BINDING_MANAGER, GnomePieBindingManagerClass))

typedef struct _GnomePieBindingManager GnomePieBindingManager;
typedef struct _GnomePieBindingManagerClass GnomePieBindingManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GNOME_PIE_TYPE_TRIGGER (gnome_pie_trigger_get_type ())
#define GNOME_PIE_TRIGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_TRIGGER, GnomePieTrigger))
#define GNOME_PIE_TRIGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_TRIGGER, GnomePieTriggerClass))
#define GNOME_PIE_IS_TRIGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_TRIGGER))
#define GNOME_PIE_IS_TRIGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_TRIGGER))
#define GNOME_PIE_TRIGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_TRIGGER, GnomePieTriggerClass))

typedef struct _GnomePieTrigger GnomePieTrigger;
typedef struct _GnomePieTriggerClass GnomePieTriggerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GnomePiePieManager {
	GObject parent_instance;
	GnomePiePieManagerPrivate * priv;
};

struct _GnomePiePieManagerClass {
	GObjectClass parent_class;
};

struct _Block17Data {
	int _ref_count_;
	GnomePiePieWindow* window;
};

static gpointer gnome_pie_pie_manager_parent_class = NULL;
static GeeHashMap* gnome_pie_pie_manager__all_pies;
static GeeHashMap* gnome_pie_pie_manager__all_pies = NULL;
static GeeHashSet* gnome_pie_pie_manager__opened_windows;
static GeeHashSet* gnome_pie_pie_manager__opened_windows = NULL;
VALA_EXTERN GnomePieBindingManager* gnome_pie_pie_manager_bindings;
GnomePieBindingManager* gnome_pie_pie_manager_bindings = NULL;
static gboolean gnome_pie_pie_manager_a_pie_is_active;
static gboolean gnome_pie_pie_manager_a_pie_is_active = FALSE;
static gint gnome_pie_pie_manager_last_x;
static gint gnome_pie_pie_manager_last_x = 0;
static gint gnome_pie_pie_manager_last_y;
static gint gnome_pie_pie_manager_last_y = 0;

VALA_EXTERN GType gnome_pie_pie_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePieManager, g_object_unref)
VALA_EXTERN GType gnome_pie_pie_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePie, g_object_unref)
VALA_EXTERN GType gnome_pie_pie_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePieWindow, g_object_unref)
VALA_EXTERN GType gnome_pie_binding_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieBindingManager, g_object_unref)
VALA_EXTERN void gnome_pie_pie_manager_init (void);
static void gnome_pie_pie_manager_set_all_pies (GeeHashMap* value);
static void gnome_pie_pie_manager_set_opened_windows (GeeHashSet* value);
VALA_EXTERN GnomePieBindingManager* gnome_pie_binding_manager_new (void);
VALA_EXTERN GnomePieBindingManager* gnome_pie_binding_manager_construct (GType object_type);
VALA_EXTERN void gnome_pie_pies_load (void);
static void __lambda28_ (const gchar* id);
VALA_EXTERN void gnome_pie_pie_manager_open_pie (const gchar* id);
static void ___lambda28__gnome_pie_binding_manager_on_press (GnomePieBindingManager* _sender,
                                                      const gchar* id,
                                                      gpointer self);
VALA_EXTERN GeeHashMap* gnome_pie_pie_manager_get_all_pies (void);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
VALA_EXTERN GnomePiePieWindow* gnome_pie_pie_window_new (void);
VALA_EXTERN GnomePiePieWindow* gnome_pie_pie_window_construct (GType object_type);
VALA_EXTERN void gnome_pie_pie_window_load_pie (GnomePiePieWindow* self,
                                    GnomePiePie* pie);
static void ____lambda29_ (Block17Data* _data17_);
VALA_EXTERN GeeHashSet* gnome_pie_pie_manager_get_opened_windows (void);
VALA_EXTERN void gnome_pie_icon_clear_cache (void);
static void _____lambda29__gnome_pie_pie_window_on_closed (GnomePiePieWindow* _sender,
                                                    gpointer self);
static void ____lambda30_ (Block17Data* _data17_);
VALA_EXTERN void gnome_pie_pie_window_get_center_pos (GnomePiePieWindow* self,
                                          gint* out_x,
                                          gint* out_y);
static void _____lambda30__gnome_pie_pie_window_on_closing (GnomePiePieWindow* _sender,
                                                     gpointer self);
VALA_EXTERN void gnome_pie_pie_window_open (GnomePiePieWindow* self);
VALA_EXTERN void gnome_pie_pie_manager_print_ids (void);
VALA_EXTERN const gchar* gnome_pie_pie_get_id (GnomePiePie* self);
VALA_EXTERN const gchar* gnome_pie_pie_get_name (GnomePiePie* self);
VALA_EXTERN gchar* gnome_pie_pie_manager_get_accelerator_of (const gchar* id);
VALA_EXTERN gchar* gnome_pie_binding_manager_get_accelerator_of (GnomePieBindingManager* self,
                                                     const gchar* id);
VALA_EXTERN gchar* gnome_pie_pie_manager_get_accelerator_label_of (const gchar* id);
VALA_EXTERN gchar* gnome_pie_binding_manager_get_accelerator_label_of (GnomePieBindingManager* self,
                                                           const gchar* id);
VALA_EXTERN GType gnome_pie_trigger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieTrigger, g_object_unref)
VALA_EXTERN void gnome_pie_pie_manager_bind_trigger (GnomePieTrigger* trigger,
                                         const gchar* id);
VALA_EXTERN void gnome_pie_binding_manager_unbind (GnomePieBindingManager* self,
                                       const gchar* id);
VALA_EXTERN void gnome_pie_binding_manager_bind (GnomePieBindingManager* self,
                                     GnomePieTrigger* trigger,
                                     const gchar* id);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_turbo (const gchar* id);
VALA_EXTERN gboolean gnome_pie_binding_manager_get_is_turbo (GnomePieBindingManager* self,
                                                 const gchar* id);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_centered (const gchar* id);
VALA_EXTERN gboolean gnome_pie_binding_manager_get_is_centered (GnomePieBindingManager* self,
                                                    const gchar* id);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_warp (const gchar* id);
VALA_EXTERN gboolean gnome_pie_binding_manager_get_is_warp (GnomePieBindingManager* self,
                                                const gchar* id);
VALA_EXTERN gboolean gnome_pie_pie_manager_get_is_auto_shape (const gchar* id);
VALA_EXTERN gboolean gnome_pie_binding_manager_get_is_auto_shape (GnomePieBindingManager* self,
                                                      const gchar* id);
VALA_EXTERN gint gnome_pie_pie_manager_get_shape_number (const gchar* id);
VALA_EXTERN gint gnome_pie_binding_manager_get_shape_number (GnomePieBindingManager* self,
                                                 const gchar* id);
VALA_EXTERN gchar* gnome_pie_pie_manager_get_name_of (const gchar* id);
VALA_EXTERN gchar* gnome_pie_pie_manager_get_assigned_id (GnomePieTrigger* trigger);
VALA_EXTERN gchar* gnome_pie_binding_manager_get_assigned_id (GnomePieBindingManager* self,
                                                  GnomePieTrigger* trigger);
VALA_EXTERN GnomePiePie* gnome_pie_pie_manager_create_persistent_pie (const gchar* name,
                                                          const gchar* icon_name,
                                                          GnomePieTrigger* hotkey,
                                                          const gchar* desired_id);
static GnomePiePie* gnome_pie_pie_manager_create_pie (const gchar* name,
                                               const gchar* icon_name,
                                               gint min_id,
                                               gint max_id,
                                               const gchar* desired_id);
VALA_EXTERN void gnome_pie_pie_manager_create_launcher (const gchar* id);
VALA_EXTERN GnomePiePie* gnome_pie_pie_manager_create_dynamic_pie (const gchar* name,
                                                       const gchar* icon_name,
                                                       const gchar* desired_id);
VALA_EXTERN GnomePiePie* gnome_pie_pie_new (const gchar* id,
                                const gchar* name,
                                const gchar* icon);
VALA_EXTERN GnomePiePie* gnome_pie_pie_construct (GType object_type,
                                      const gchar* id,
                                      const gchar* name,
                                      const gchar* icon);
VALA_EXTERN void gnome_pie_pie_manager_remove_pie (const gchar* id);
VALA_EXTERN void gnome_pie_pie_on_remove (GnomePiePie* self);
static void gnome_pie_pie_manager_remove_launcher (const gchar* id);
VALA_EXTERN const gchar* gnome_pie_paths_get_executable (void);
VALA_EXTERN const gchar* gnome_pie_pie_get_icon (GnomePiePie* self);
VALA_EXTERN const gchar* gnome_pie_paths_get_launchers (void);
VALA_EXTERN GnomePiePieManager* gnome_pie_pie_manager_new (void);
VALA_EXTERN GnomePiePieManager* gnome_pie_pie_manager_construct (GType object_type);
static void gnome_pie_pie_manager_finalize (GObject * obj);
static GType gnome_pie_pie_manager_get_type_once (void);
static void _vala_gnome_pie_pie_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gnome_pie_pie_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static void
__lambda28_ (const gchar* id)
{
	g_return_if_fail (id != NULL);
	gnome_pie_pie_manager_open_pie (id);
}

static void
___lambda28__gnome_pie_binding_manager_on_press (GnomePieBindingManager* _sender,
                                                 const gchar* id,
                                                 gpointer self)
{
	__lambda28_ (id);
}

void
gnome_pie_pie_manager_init (void)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GnomePieBindingManager* _tmp4_;
	GnomePieBindingManager* _tmp5_;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GNOME_PIE_TYPE_PIE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	gnome_pie_pie_manager_set_all_pies (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_hash_set_new (GNOME_PIE_TYPE_PIE_WINDOW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	gnome_pie_pie_manager_set_opened_windows (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gnome_pie_binding_manager_new ();
	_g_object_unref0 (gnome_pie_pie_manager_bindings);
	gnome_pie_pie_manager_bindings = _tmp4_;
	gnome_pie_pies_load ();
	_tmp5_ = gnome_pie_pie_manager_bindings;
	g_signal_connect (_tmp5_, "on-press", (GCallback) ___lambda28__gnome_pie_binding_manager_on_press, NULL);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		_g_object_unref0 (_data17_->window);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
____lambda29_ (Block17Data* _data17_)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GnomePiePieWindow* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = gnome_pie_pie_manager_get_opened_windows ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _data17_->window;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	_tmp3_ = gnome_pie_pie_manager_get_opened_windows ();
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		gnome_pie_icon_clear_cache ();
	}
}

static void
_____lambda29__gnome_pie_pie_window_on_closed (GnomePiePieWindow* _sender,
                                               gpointer self)
{
	____lambda29_ (self);
}

static void
____lambda30_ (Block17Data* _data17_)
{
	GnomePiePieWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	_tmp0_ = _data17_->window;
	gnome_pie_pie_window_get_center_pos (_tmp0_, &_tmp1_, &_tmp2_);
	gnome_pie_pie_manager_last_x = _tmp1_;
	gnome_pie_pie_manager_last_y = _tmp2_;
	gnome_pie_pie_manager_a_pie_is_active = FALSE;
}

static void
_____lambda30__gnome_pie_pie_window_on_closing (GnomePiePieWindow* _sender,
                                                gpointer self)
{
	____lambda30_ (self);
}

void
gnome_pie_pie_manager_open_pie (const gchar* id)
{
	g_return_if_fail (id != NULL);
	if (!gnome_pie_pie_manager_a_pie_is_active) {
		GnomePiePie* pie = NULL;
		GeeHashMap* _tmp0_;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		GnomePiePie* _tmp3_;
		_tmp0_ = gnome_pie_pie_manager_get_all_pies ();
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, id);
		pie = (GnomePiePie*) _tmp2_;
		_tmp3_ = pie;
		if (_tmp3_ != NULL) {
			Block17Data* _data17_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GnomePiePieWindow* _tmp6_;
			GnomePiePieWindow* _tmp7_;
			GnomePiePie* _tmp8_;
			GnomePiePieWindow* _tmp9_;
			GnomePiePieWindow* _tmp10_;
			GeeHashSet* _tmp11_;
			GeeHashSet* _tmp12_;
			GnomePiePieWindow* _tmp13_;
			GnomePiePieWindow* _tmp14_;
			_data17_ = g_slice_new0 (Block17Data);
			_data17_->_ref_count_ = 1;
			gnome_pie_pie_manager_a_pie_is_active = TRUE;
			_tmp4_ = g_strconcat ("gnome-pie-", id, NULL);
			_tmp5_ = _tmp4_;
			gdk_set_program_class (_tmp5_);
			_g_free0 (_tmp5_);
			_tmp6_ = gnome_pie_pie_window_new ();
			g_object_ref_sink (_tmp6_);
			_data17_->window = _tmp6_;
			_tmp7_ = _data17_->window;
			_tmp8_ = pie;
			gnome_pie_pie_window_load_pie (_tmp7_, _tmp8_);
			_tmp9_ = _data17_->window;
			g_signal_connect_data (_tmp9_, "on-closed", (GCallback) _____lambda29__gnome_pie_pie_window_on_closed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
			_tmp10_ = _data17_->window;
			g_signal_connect_data (_tmp10_, "on-closing", (GCallback) _____lambda30__gnome_pie_pie_window_on_closing, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
			_tmp11_ = gnome_pie_pie_manager_get_opened_windows ();
			_tmp12_ = _tmp11_;
			_tmp13_ = _data17_->window;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			_tmp14_ = _data17_->window;
			gnome_pie_pie_window_open (_tmp14_);
			gdk_set_program_class ("Gnome-pie");
			block17_data_unref (_data17_);
			_data17_ = NULL;
		} else {
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = g_strconcat ("Failed to open pie with ID \"", id, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp16_, "\": ID does not exist!", NULL);
			_tmp18_ = _tmp17_;
			g_warning ("pieManager.vala:124: %s", _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
		}
		_g_object_unref0 (pie);
	}
}

void
gnome_pie_pie_manager_print_ids (void)
{
	{
		GeeIterator* _pie_it = NULL;
		GeeHashMap* _tmp0_;
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = gnome_pie_pie_manager_get_all_pies ();
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_pie_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GeeMapEntry* pie = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			gconstpointer _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp7_ = _pie_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _pie_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			pie = (GeeMapEntry*) _tmp9_;
			_tmp10_ = pie;
			_tmp11_ = gee_map_entry_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = gnome_pie_pie_get_id ((GnomePiePie*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ == 3) {
				GeeMapEntry* _tmp17_;
				gconstpointer _tmp18_;
				gconstpointer _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GeeMapEntry* _tmp24_;
				gconstpointer _tmp25_;
				gconstpointer _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp17_ = pie;
				_tmp18_ = gee_map_entry_get_value (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = gnome_pie_pie_get_id ((GnomePiePie*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp21_, " ", NULL);
				_tmp23_ = _tmp22_;
				_tmp24_ = pie;
				_tmp25_ = gee_map_entry_get_value (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = gnome_pie_pie_get_name ((GnomePiePie*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
				_tmp30_ = _tmp29_;
				g_message ("pieManager.vala:136: %s", _tmp30_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp23_);
			}
			_g_object_unref0 (pie);
		}
		_g_object_unref0 (_pie_it);
	}
}

gchar*
gnome_pie_pie_manager_get_accelerator_of (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	_tmp1_ = gnome_pie_binding_manager_get_accelerator_of (_tmp0_, id);
	result = _tmp1_;
	return result;
}

gchar*
gnome_pie_pie_manager_get_accelerator_label_of (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	_tmp1_ = gnome_pie_binding_manager_get_accelerator_label_of (_tmp0_, id);
	result = _tmp1_;
	return result;
}

void
gnome_pie_pie_manager_bind_trigger (GnomePieTrigger* trigger,
                                    const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	GnomePieBindingManager* _tmp1_;
	g_return_if_fail (trigger != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	gnome_pie_binding_manager_unbind (_tmp0_, id);
	_tmp1_ = gnome_pie_pie_manager_bindings;
	gnome_pie_binding_manager_bind (_tmp1_, trigger, id);
}

gboolean
gnome_pie_pie_manager_get_is_turbo (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	result = gnome_pie_binding_manager_get_is_turbo (_tmp0_, id);
	return result;
}

gboolean
gnome_pie_pie_manager_get_is_centered (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	result = gnome_pie_binding_manager_get_is_centered (_tmp0_, id);
	return result;
}

gboolean
gnome_pie_pie_manager_get_is_warp (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	result = gnome_pie_binding_manager_get_is_warp (_tmp0_, id);
	return result;
}

gboolean
gnome_pie_pie_manager_get_is_auto_shape (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	result = gnome_pie_binding_manager_get_is_auto_shape (_tmp0_, id);
	return result;
}

gint
gnome_pie_pie_manager_get_shape_number (const gchar* id)
{
	GnomePieBindingManager* _tmp0_;
	gint result;
	g_return_val_if_fail (id != NULL, 0);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	result = gnome_pie_binding_manager_get_shape_number (_tmp0_, id);
	return result;
}

gchar*
gnome_pie_pie_manager_get_name_of (const gchar* id)
{
	GnomePiePie* pie = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GnomePiePie* _tmp3_;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_get_all_pies ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, id);
	pie = (GnomePiePie*) _tmp2_;
	_tmp3_ = pie;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_object_unref0 (pie);
		return result;
	} else {
		GnomePiePie* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = pie;
		_tmp6_ = gnome_pie_pie_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		_g_object_unref0 (pie);
		return result;
	}
}

gchar*
gnome_pie_pie_manager_get_assigned_id (GnomePieTrigger* trigger)
{
	GnomePieBindingManager* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (trigger != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_bindings;
	_tmp1_ = gnome_pie_binding_manager_get_assigned_id (_tmp0_, trigger);
	result = _tmp1_;
	return result;
}

GnomePiePie*
gnome_pie_pie_manager_create_persistent_pie (const gchar* name,
                                             const gchar* icon_name,
                                             GnomePieTrigger* hotkey,
                                             const gchar* desired_id)
{
	GnomePiePie* pie = NULL;
	GnomePiePie* _tmp0_;
	GnomePiePie* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GnomePiePie* result;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_create_pie (name, icon_name, 100, 999, desired_id);
	pie = _tmp0_;
	if (hotkey != NULL) {
		GnomePieBindingManager* _tmp1_;
		GnomePiePie* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = gnome_pie_pie_manager_bindings;
		_tmp2_ = pie;
		_tmp3_ = gnome_pie_pie_get_id (_tmp2_);
		_tmp4_ = _tmp3_;
		gnome_pie_binding_manager_bind (_tmp1_, hotkey, _tmp4_);
	}
	_tmp5_ = pie;
	_tmp6_ = gnome_pie_pie_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	gnome_pie_pie_manager_create_launcher (_tmp7_);
	result = pie;
	return result;
}

GnomePiePie*
gnome_pie_pie_manager_create_dynamic_pie (const gchar* name,
                                          const gchar* icon_name,
                                          const gchar* desired_id)
{
	GnomePiePie* _tmp0_;
	GnomePiePie* result;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = gnome_pie_pie_manager_create_pie (name, icon_name, 1000, 9999, desired_id);
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GnomePiePie*
gnome_pie_pie_manager_create_pie (const gchar* name,
                                  const gchar* icon_name,
                                  gint min_id,
                                  gint max_id,
                                  const gchar* desired_id)
{
	GRand* random = NULL;
	GRand* _tmp0_;
	gchar* final_id = NULL;
	GeeHashMap* _tmp24_;
	GeeHashMap* _tmp25_;
	const gchar* _tmp26_;
	GnomePiePie* pie = NULL;
	const gchar* _tmp47_;
	GnomePiePie* _tmp48_;
	GeeHashMap* _tmp49_;
	GeeHashMap* _tmp50_;
	const gchar* _tmp51_;
	GnomePiePie* _tmp52_;
	GnomePiePie* result;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = g_rand_new ();
	random = _tmp0_;
	if (desired_id == NULL) {
		GRand* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = random;
		_tmp2_ = g_strdup_printf ("%i", g_rand_int_range (_tmp1_, (gint32) min_id, (gint32) max_id));
		_g_free0 (final_id);
		final_id = _tmp2_;
	} else {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gint id = 0;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = g_strdup (desired_id);
		_g_free0 (final_id);
		final_id = _tmp3_;
		_tmp4_ = final_id;
		g_strcanon (_tmp4_, "0123456789", '_');
		_tmp5_ = final_id;
		_tmp6_ = string_replace (_tmp5_, "_", "");
		_g_free0 (final_id);
		final_id = _tmp6_;
		_tmp7_ = final_id;
		id = atoi (_tmp7_);
		if (id < min_id) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = id > max_id;
		}
		if (_tmp8_) {
			GRand* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp9_ = random;
			_tmp10_ = g_strdup_printf ("%i", g_rand_int_range (_tmp9_, (gint32) min_id, (gint32) max_id));
			_g_free0 (final_id);
			final_id = _tmp10_;
			_tmp11_ = g_strconcat ("The ID for pie \"", name, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp12_, "\" should be in range %u - %u! Using \"", NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = final_id;
			_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp17_, "\" instead of \"", NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp19_, desired_id, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp21_, "\"...", NULL);
			_tmp23_ = _tmp22_;
			g_warning (_tmp23_, min_id, max_id);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
		}
	}
	_tmp24_ = gnome_pie_pie_manager_get_all_pies ();
	_tmp25_ = _tmp24_;
	_tmp26_ = final_id;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp25_, _tmp26_)) {
		gchar* tmp = NULL;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gint id_number = 0;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		GnomePiePie* _tmp46_;
		_tmp27_ = final_id;
		_tmp28_ = g_strdup (_tmp27_);
		tmp = _tmp28_;
		_tmp29_ = final_id;
		id_number = atoi (_tmp29_) + 1;
		if (id_number == (max_id + 1)) {
			id_number = min_id;
		}
		_tmp30_ = g_strdup_printf ("%i", id_number);
		_g_free0 (final_id);
		final_id = _tmp30_;
		_tmp31_ = g_strconcat ("Trying to add pie \"", name, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "\": ID \"", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = tmp;
		_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\" already exists! Using \"", NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = final_id;
		_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp42_, "\" instead...", NULL);
		_tmp44_ = _tmp43_;
		g_warning ("pieManager.vala:282: %s", _tmp44_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp45_ = final_id;
		_tmp46_ = gnome_pie_pie_manager_create_pie (name, icon_name, min_id, max_id, _tmp45_);
		result = _tmp46_;
		_g_free0 (tmp);
		_g_free0 (final_id);
		_g_rand_free0 (random);
		return result;
	}
	_tmp47_ = final_id;
	_tmp48_ = gnome_pie_pie_new (_tmp47_, name, icon_name);
	pie = _tmp48_;
	_tmp49_ = gnome_pie_pie_manager_get_all_pies ();
	_tmp50_ = _tmp49_;
	_tmp51_ = final_id;
	_tmp52_ = pie;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp50_, _tmp51_, _tmp52_);
	result = pie;
	_g_free0 (final_id);
	_g_rand_free0 (random);
	return result;
}

void
gnome_pie_pie_manager_remove_pie (const gchar* id)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (id != NULL);
	_tmp0_ = gnome_pie_pie_manager_get_all_pies ();
	_tmp1_ = _tmp0_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, id)) {
		GeeHashMap* _tmp2_;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		GnomePiePie* _tmp5_;
		GeeHashMap* _tmp6_;
		GeeHashMap* _tmp7_;
		GnomePieBindingManager* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = gnome_pie_pie_manager_get_all_pies ();
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, id);
		_tmp5_ = (GnomePiePie*) _tmp4_;
		gnome_pie_pie_on_remove (_tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = gnome_pie_pie_manager_get_all_pies ();
		_tmp7_ = _tmp6_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, id, NULL);
		_tmp8_ = gnome_pie_pie_manager_bindings;
		gnome_pie_binding_manager_unbind (_tmp8_, id);
		_tmp9_ = strlen (id);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == 3) {
			gnome_pie_pie_manager_remove_launcher (id);
		}
	} else {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = g_strconcat ("Failed to remove pie with ID \"", id, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, "\": ID does not exist!", NULL);
		_tmp14_ = _tmp13_;
		g_warning ("pieManager.vala:307: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	}
}

void
gnome_pie_pie_manager_create_launcher (const gchar* id)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (id != NULL);
	_tmp0_ = gnome_pie_pie_manager_get_all_pies ();
	_tmp1_ = _tmp0_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, id)) {
		GnomePiePie* pie = NULL;
		GeeHashMap* _tmp2_;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		gchar* launcher_entry = NULL;
		GnomePiePie* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GnomePiePie* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GnomePiePie* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GnomePiePie* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* launcher = NULL;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		GnomePiePie* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp2_ = gnome_pie_pie_manager_get_all_pies ();
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, id);
		pie = (GnomePiePie*) _tmp4_;
		_tmp5_ = pie;
		_tmp6_ = gnome_pie_pie_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("Name=%s\n", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("#!/usr/bin/env xdg-open\n" "[Desktop Entry]\n", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = gnome_pie_paths_get_executable ();
		_tmp13_ = _tmp12_;
		_tmp14_ = pie;
		_tmp15_ = gnome_pie_pie_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("Exec=%s -o %s\n", _tmp13_, _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp11_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "Encoding=UTF-8\n", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "Type=Application\n", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = pie;
		_tmp26_ = gnome_pie_pie_get_icon (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("Icon=%s\n", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp24_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = pie;
		_tmp33_ = gnome_pie_pie_get_id (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup_printf ("StartupWMClass=gnome-pie-%s\n", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp31_, _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp36_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		launcher_entry = _tmp38_;
		_tmp39_ = gnome_pie_paths_get_launchers ();
		_tmp40_ = _tmp39_;
		_tmp41_ = pie;
		_tmp42_ = gnome_pie_pie_get_id (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("/%s.desktop", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp40_, _tmp45_, NULL);
		_tmp47_ = _tmp46_;
		_g_free0 (_tmp45_);
		launcher = _tmp47_;
		{
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp48_ = launcher;
			_tmp49_ = launcher_entry;
			g_file_set_contents (_tmp48_, _tmp49_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp50_ = launcher;
			g_chmod (_tmp50_, 0755);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp51_;
			const gchar* _tmp52_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			g_warning ("pieManager.vala:336: %s", _tmp52_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (launcher);
			_g_free0 (launcher_entry);
			_g_object_unref0 (pie);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (launcher);
		_g_free0 (launcher_entry);
		_g_object_unref0 (pie);
	}
}

static void
gnome_pie_pie_manager_remove_launcher (const gchar* id)
{
	gchar* launcher = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (id != NULL);
	_tmp0_ = gnome_pie_paths_get_launchers ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("/%s.desktop", id);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	launcher = _tmp5_;
	_tmp6_ = launcher;
	if (g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp7_;
		_tmp7_ = launcher;
		g_remove (_tmp7_);
	}
	_g_free0 (launcher);
}

GnomePiePieManager*
gnome_pie_pie_manager_construct (GType object_type)
{
	GnomePiePieManager * self = NULL;
	self = (GnomePiePieManager*) g_object_new (object_type, NULL);
	return self;
}

GnomePiePieManager*
gnome_pie_pie_manager_new (void)
{
	return gnome_pie_pie_manager_construct (GNOME_PIE_TYPE_PIE_MANAGER);
}

GeeHashMap*
gnome_pie_pie_manager_get_all_pies (void)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	_tmp0_ = gnome_pie_pie_manager__all_pies;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gnome_pie_pie_manager_set_all_pies (GeeHashMap* value)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (gnome_pie_pie_manager__all_pies);
	gnome_pie_pie_manager__all_pies = _tmp0_;
}

GeeHashSet*
gnome_pie_pie_manager_get_opened_windows (void)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	_tmp0_ = gnome_pie_pie_manager__opened_windows;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_pie_manager_set_opened_windows (GeeHashSet* value)
{
	GeeHashSet* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (gnome_pie_pie_manager__opened_windows);
	gnome_pie_pie_manager__opened_windows = _tmp0_;
}

static void
gnome_pie_pie_manager_class_init (GnomePiePieManagerClass * klass,
                                  gpointer klass_data)
{
	gnome_pie_pie_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_pie_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_pie_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_pie_manager_finalize;
}

static void
gnome_pie_pie_manager_instance_init (GnomePiePieManager * self,
                                     gpointer klass)
{
}

static void
gnome_pie_pie_manager_finalize (GObject * obj)
{
	GnomePiePieManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManager);
	G_OBJECT_CLASS (gnome_pie_pie_manager_parent_class)->finalize (obj);
}

static GType
gnome_pie_pie_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePiePieManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_pie_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePiePieManager), 0, (GInstanceInitFunc) gnome_pie_pie_manager_instance_init, NULL };
	GType gnome_pie_pie_manager_type_id;
	gnome_pie_pie_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePiePieManager", &g_define_type_info, 0);
	return gnome_pie_pie_manager_type_id;
}

GType
gnome_pie_pie_manager_get_type (void)
{
	static volatile gsize gnome_pie_pie_manager_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_pie_manager_type_id__once)) {
		GType gnome_pie_pie_manager_type_id;
		gnome_pie_pie_manager_type_id = gnome_pie_pie_manager_get_type_once ();
		g_once_init_leave (&gnome_pie_pie_manager_type_id__once, gnome_pie_pie_manager_type_id);
	}
	return gnome_pie_pie_manager_type_id__once;
}

static void
_vala_gnome_pie_pie_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GnomePiePieManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManager);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_pie_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GnomePiePieManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_PIE_MANAGER, GnomePiePieManager);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

