/* BreakManager.c generated by valac 0.56.17, the Vala compiler
 * generated from BreakManager.vala, do not modify */

/* BreakManager.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
/* TODO: This intentionally resembles BreakManager from the daemon application.*/
/* Ideally, it should be common code in the future.*/

#include "settings.h"
#include "common.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "config.h"
#include <glib/gstdio.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_0_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_BREAK_STATUS_AVAILABLE_SIGNAL,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_STATUS_CHANGED_SIGNAL,
	BREAK_TIMER_SETTINGS_BREAK_MANAGER_NUM_SIGNALS
};
static guint break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_NUM_SIGNALS] = {0};

struct _BreakTimerSettingsBreakManagerPrivate {
	BreakTimerCommonIBreakTimer* break_daemon;
	GList* breaks;
	GSettings* settings;
	gint _autostart_version;
	gboolean _master_enabled;
	gchar** _selected_break_ids;
	gint _selected_break_ids_length1;
	gint __selected_break_ids_size_;
	BreakTimerSettingsBreakBreakType* _foreground_break;
	BreakTimerSettingsBreakManagerPermissionsError _permissions_error;
	GDBusConnection* dbus_connection;
	BreakTimerCommonIPortalBackground* background_portal;
	BreakTimerCommonIPortalRequest* background_request;
	char* background_request_path;
};

static gint BreakTimerSettingsBreakManager_private_offset;
static gpointer break_timer_settings_break_manager_parent_class = NULL;
gint break_timer_settings_break_manager_CURRENT_AUTOSTART_VERSION = 2;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void break_timer_settings_break_manager_set_permissions_error (BreakTimerSettingsBreakManager* self,
                                                               BreakTimerSettingsBreakManagerPermissionsError value);
static void break_timer_settings_break_manager_on_master_enabled_changed (BreakTimerSettingsBreakManager* self);
static void _break_timer_settings_break_manager_on_master_enabled_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static gboolean break_timer_settings_break_manager_get_is_in_flatpak (BreakTimerSettingsBreakManager* self);
static void break_timer_settings_break_manager_break_daemon_appeared (BreakTimerSettingsBreakManager* self);
static void _break_timer_settings_break_manager_break_daemon_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                            const gchar* name,
                                                                                            const gchar* name_owner,
                                                                                            gpointer self);
static void break_timer_settings_break_manager_break_daemon_disappeared (BreakTimerSettingsBreakManager* self);
static void _break_timer_settings_break_manager_break_daemon_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                               const gchar* name,
                                                                                               gpointer self);
static void break_timer_settings_break_manager_break_status_changed (BreakTimerSettingsBreakManager* self,
                                                              BreakTimerSettingsBreakBreakType* break_type,
                                                              BreakTimerCommonBreakStatus* break_status);
static void _break_timer_settings_break_manager_break_status_changed_break_timer_settings_break_break_type_status_changed (BreakTimerSettingsBreakBreakType* _sender,
                                                                                                                    BreakTimerCommonBreakStatus* status,
                                                                                                                    gpointer self);
static void break_timer_settings_break_manager_launch_break_timer_service (BreakTimerSettingsBreakManager* self);
static gboolean break_timer_settings_break_manager_request_background (BreakTimerSettingsBreakManager* self,
                                                                gboolean autostart);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (gboolean value);
static GVariant* _variant_new3 (gboolean value);
static gboolean break_timer_settings_break_manager_watch_background_request (BreakTimerSettingsBreakManager* self,
                                                                      const char* request_path);
static void break_timer_settings_break_manager_on_background_request_response (BreakTimerSettingsBreakManager* self,
                                                                        guint32 response,
                                                                        GHashTable* results);
static void _break_timer_settings_break_manager_on_background_request_response_break_timer_common_iportal_request_response (BreakTimerCommonIPortalRequest* _sender,
                                                                                                                     guint32 response,
                                                                                                                     GHashTable* results,
                                                                                                                     gpointer self);
static gboolean _variant_get1 (GVariant* value);
static gboolean _variant_get2 (GVariant* value);
static void break_timer_settings_break_manager_set_foreground_break (BreakTimerSettingsBreakManager* self,
                                                              BreakTimerSettingsBreakBreakType* value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void break_timer_settings_break_manager_finalize (GObject * obj);
static GType break_timer_settings_break_manager_get_type_once (void);
static void _vala_break_timer_settings_break_manager_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_break_timer_settings_break_manager_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
break_timer_settings_break_manager_get_instance_private (BreakTimerSettingsBreakManager* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerSettingsBreakManager_private_offset);
}

static GType
break_timer_settings_break_manager_permissions_error_get_type_once (void)
{
	static const GFlagsValue values[] = {{BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_NONE, "BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_NONE", "none"}, {BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_AUTOSTART_NOT_ALLOWED, "BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_AUTOSTART_NOT_ALLOWED", "autostart-not-allowed"}, {BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_BACKGROUND_NOT_ALLOWED, "BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_BACKGROUND_NOT_ALLOWED", "background-not-allowed"}, {0, NULL, NULL}};
	GType break_timer_settings_break_manager_permissions_error_type_id;
	break_timer_settings_break_manager_permissions_error_type_id = g_flags_register_static ("BreakTimerSettingsBreakManagerPermissionsError", values);
	return break_timer_settings_break_manager_permissions_error_type_id;
}

GType
break_timer_settings_break_manager_permissions_error_get_type (void)
{
	static volatile gsize break_timer_settings_break_manager_permissions_error_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_break_manager_permissions_error_type_id__once)) {
		GType break_timer_settings_break_manager_permissions_error_type_id;
		break_timer_settings_break_manager_permissions_error_type_id = break_timer_settings_break_manager_permissions_error_get_type_once ();
		g_once_init_leave (&break_timer_settings_break_manager_permissions_error_type_id__once, break_timer_settings_break_manager_permissions_error_type_id);
	}
	return break_timer_settings_break_manager_permissions_error_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_break_timer_settings_break_manager_on_master_enabled_changed_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	break_timer_settings_break_manager_on_master_enabled_changed ((BreakTimerSettingsBreakManager*) self);
}

BreakTimerSettingsBreakManager*
break_timer_settings_break_manager_construct (GType object_type)
{
	BreakTimerSettingsBreakManager * self = NULL;
	GSettings* _tmp0_;
	BreakTimerSettingsMicroBreakMicroBreakType* _tmp1_;
	BreakTimerSettingsRestBreakRestBreakType* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	self = (BreakTimerSettingsBreakManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new (APPLICATION_ID);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	(self->priv->breaks == NULL) ? NULL : (self->priv->breaks = (_g_list_free__g_object_unref0_ (self->priv->breaks), NULL));
	self->priv->breaks = NULL;
	_tmp1_ = break_timer_settings_micro_break_micro_break_type_new ();
	self->priv->breaks = g_list_append (self->priv->breaks, (BreakTimerSettingsBreakBreakType*) _tmp1_);
	_tmp2_ = break_timer_settings_rest_break_rest_break_type_new ();
	self->priv->breaks = g_list_append (self->priv->breaks, (BreakTimerSettingsBreakBreakType*) _tmp2_);
	break_timer_settings_break_manager_set_permissions_error (self, BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_NONE);
	_tmp3_ = self->priv->settings;
	g_settings_bind (_tmp3_, "autostart-version", (GObject*) self, "autostart-version", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->settings;
	g_settings_bind (_tmp4_, "enabled", (GObject*) self, "master-enabled", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->settings;
	g_settings_bind (_tmp5_, "selected-breaks", (GObject*) self, "selected-break-ids", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GObject*) self, "notify::master-enabled", (GCallback) _break_timer_settings_break_manager_on_master_enabled_changed_g_object_notify, self, 0);
	return self;
}

BreakTimerSettingsBreakManager*
break_timer_settings_break_manager_new (void)
{
	return break_timer_settings_break_manager_construct (BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER);
}

static void
_break_timer_settings_break_manager_break_daemon_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                       const gchar* name,
                                                                                       const gchar* name_owner,
                                                                                       gpointer self)
{
	break_timer_settings_break_manager_break_daemon_appeared ((BreakTimerSettingsBreakManager*) self);
}

static void
_break_timer_settings_break_manager_break_daemon_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                          const gchar* name,
                                                                                          gpointer self)
{
	break_timer_settings_break_manager_break_daemon_disappeared ((BreakTimerSettingsBreakManager*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_break_timer_settings_break_manager_break_status_changed_break_timer_settings_break_break_type_status_changed (BreakTimerSettingsBreakBreakType* _sender,
                                                                                                               BreakTimerCommonBreakStatus* status,
                                                                                                               gpointer self)
{
	break_timer_settings_break_manager_break_status_changed ((BreakTimerSettingsBreakManager*) self, _sender, status);
}

gboolean
break_timer_settings_break_manager_init (BreakTimerSettingsBreakManager* self,
                                         GCancellable* cancellable,
                                         GError** error)
{
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp9_;
	GList* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, cancellable, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->dbus_connection);
	self->priv->dbus_connection = _tmp3_;
	if (break_timer_settings_break_manager_get_is_in_flatpak (self)) {
		BreakTimerCommonIPortalBackground* _tmp4_ = NULL;
		GDBusConnection* _tmp5_;
		BreakTimerCommonIPortalBackground* _tmp6_;
		BreakTimerCommonIPortalBackground* _tmp8_;
		_tmp5_ = self->priv->dbus_connection;
		_tmp6_ = (BreakTimerCommonIPortalBackground*) g_initable_new (BREAK_TIMER_COMMON_TYPE_IPORTAL_BACKGROUND_PROXY, cancellable, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.portal.Desktop", "g-connection", _tmp5_, "g-object-path", "/org/freedesktop/portal/desktop", "g-interface-name", "org.freedesktop.portal.Background", NULL);
		_tmp4_ = (BreakTimerCommonIPortalBackground*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return _tmp7_;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->background_portal);
		self->priv->background_portal = _tmp8_;
		_g_object_unref0 (_tmp4_);
	}
	_tmp9_ = self->priv->dbus_connection;
	g_bus_watch_name_on_connection_with_closures (_tmp9_, DAEMON_APPLICATION_ID, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_break_timer_settings_break_manager_break_daemon_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _break_timer_settings_break_manager_break_daemon_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_break_timer_settings_break_manager_break_daemon_disappeared_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _break_timer_settings_break_manager_break_daemon_disappeared_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp10_ = break_timer_settings_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp10_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerSettingsBreakBreakType* _tmp11_;
			BreakTimerSettingsBreakBreakType* break_type = NULL;
			_tmp11_ = _g_object_ref0 ((BreakTimerSettingsBreakBreakType*) break_type_it->data);
			break_type = _tmp11_;
			{
				BreakTimerSettingsBreakBreakType* _tmp12_;
				BreakTimerSettingsBreakBreakType* _tmp13_;
				_tmp12_ = break_type;
				g_signal_connect_object (_tmp12_, "status-changed", (GCallback) _break_timer_settings_break_manager_break_status_changed_break_timer_settings_break_break_type_status_changed, self, 0);
				_tmp13_ = break_type;
				break_timer_settings_break_break_type_init (_tmp13_, cancellable, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp14_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (break_type);
					_g_object_unref0 (_tmp0_);
					return _tmp14_;
				}
				_g_object_unref0 (break_type);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
break_timer_settings_break_manager_on_master_enabled_changed (BreakTimerSettingsBreakManager* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_master_enabled;
	if (_tmp0_) {
		break_timer_settings_break_manager_launch_break_timer_service (self);
	}
	_tmp1_ = self->priv->_master_enabled;
	break_timer_settings_break_manager_request_background (self, _tmp1_);
}

void
break_timer_settings_break_manager_refresh_permissions (BreakTimerSettingsBreakManager* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_master_enabled;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_master_enabled;
		break_timer_settings_break_manager_request_background (self, _tmp1_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
break_timer_settings_break_manager_request_background (BreakTimerSettingsBreakManager* self,
                                                       gboolean autostart)
{
	BreakTimerCommonIPortalBackground* _tmp0_;
	gchar* sender_name = NULL;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* handle_token = NULL;
	gchar* _tmp10_;
	GHashTable* options = NULL;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GVariant* commandline = NULL;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GHashTable* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GVariant* _tmp22_;
	GHashTable* _tmp23_;
	gchar* _tmp24_;
	GVariant* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	GVariant* _tmp32_;
	char* request_path = NULL;
	char* expected_request_path = NULL;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	char* _tmp37_;
	char* _tmp38_;
	const char* _tmp39_;
	const char* _tmp51_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->background_portal;
	if (_tmp0_ == NULL) {
		break_timer_settings_break_manager_set_permissions_error (self, BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_NONE);
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->dbus_connection;
	_tmp2_ = g_dbus_connection_get_unique_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, ".", "_");
	sender_name = _tmp4_;
	_tmp5_ = sender_name;
	_tmp6_ = sender_name;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_slice (_tmp5_, (glong) 1, (glong) _tmp8_);
	_g_free0 (sender_name);
	sender_name = _tmp9_;
	_tmp10_ = g_strdup_printf ("org_gnome_breaktimer%d", (gint) g_random_int_range ((gint32) 0, (gint32) G_MAXINT));
	handle_token = _tmp10_;
	_tmp11_ = g_str_hash;
	_tmp12_ = g_str_equal;
	_tmp13_ = g_hash_table_new_full (_tmp11_, _tmp12_, _g_free0_, _g_variant_unref0_);
	options = _tmp13_;
	_tmp14_ = g_strdup ("gnome-break-timer-daemon");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	_tmp17_ = g_variant_new_strv (_tmp16_, 1);
	g_variant_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	commandline = _tmp18_;
	_tmp19_ = options;
	_tmp20_ = g_strdup ("handle_token");
	_tmp21_ = handle_token;
	_tmp22_ = _variant_new1 (_tmp21_);
	g_hash_table_insert (_tmp19_, _tmp20_, _tmp22_);
	_tmp23_ = options;
	_tmp24_ = g_strdup ("autostart");
	_tmp25_ = _variant_new2 (autostart);
	g_hash_table_insert (_tmp23_, _tmp24_, _tmp25_);
	_tmp26_ = options;
	_tmp27_ = g_strdup ("commandline");
	_tmp28_ = commandline;
	_tmp29_ = _g_variant_ref0 (_tmp28_);
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp29_);
	_tmp30_ = options;
	_tmp31_ = g_strdup ("dbus-activatable");
	_tmp32_ = _variant_new3 (FALSE);
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	request_path = NULL;
	_tmp33_ = sender_name;
	_tmp34_ = handle_token;
	_tmp35_ = g_strdup_printf ("/org/freedesktop/portal/desktop/request/%s/%s", _tmp33_, _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	_tmp38_ = _tmp37_;
	_g_free0 (_tmp36_);
	expected_request_path = _tmp38_;
	_tmp39_ = expected_request_path;
	break_timer_settings_break_manager_watch_background_request (self, _tmp39_);
	{
		char* _tmp40_ = NULL;
		BreakTimerCommonIPortalBackground* _tmp41_;
		GHashTable* _tmp42_;
		char* _tmp43_;
		char* _tmp45_;
		_tmp41_ = self->priv->background_portal;
		_tmp42_ = options;
		_tmp43_ = break_timer_common_iportal_background_request_background (_tmp41_, "", _tmp42_, &_inner_error0_);
		_tmp40_ = _tmp43_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp44_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			_g_free0 (expected_request_path);
			_g_free0 (request_path);
			_g_variant_unref0 (commandline);
			_g_hash_table_unref0 (options);
			_g_free0 (handle_token);
			_g_free0 (sender_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp44_;
		}
		_tmp45_ = _tmp40_;
		_tmp40_ = NULL;
		_g_free0 (request_path);
		request_path = _tmp45_;
		_g_free0 (_tmp40_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp46_ = _error_;
		_tmp47_ = _tmp46_->message;
		g_warning ("BreakManager.vala:162: Error connecting to desktop portal: %s", _tmp47_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (expected_request_path);
		_g_free0 (request_path);
		_g_variant_unref0 (commandline);
		_g_hash_table_unref0 (options);
		_g_free0 (handle_token);
		_g_free0 (sender_name);
		return result;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* _error_ = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp48_ = _error_;
		_tmp49_ = _tmp48_->message;
		g_warning ("BreakManager.vala:165: Error enabling autostart: %s", _tmp49_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (expected_request_path);
		_g_free0 (request_path);
		_g_variant_unref0 (commandline);
		_g_hash_table_unref0 (options);
		_g_free0 (handle_token);
		_g_free0 (sender_name);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp50_ = FALSE;
		_g_free0 (expected_request_path);
		_g_free0 (request_path);
		_g_variant_unref0 (commandline);
		_g_hash_table_unref0 (options);
		_g_free0 (handle_token);
		_g_free0 (sender_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp50_;
	}
	_tmp51_ = request_path;
	break_timer_settings_break_manager_watch_background_request (self, _tmp51_);
	result = TRUE;
	_g_free0 (expected_request_path);
	_g_free0 (request_path);
	_g_variant_unref0 (commandline);
	_g_hash_table_unref0 (options);
	_g_free0 (handle_token);
	_g_free0 (sender_name);
	return result;
}

static void
_break_timer_settings_break_manager_on_background_request_response_break_timer_common_iportal_request_response (BreakTimerCommonIPortalRequest* _sender,
                                                                                                                guint32 response,
                                                                                                                GHashTable* results,
                                                                                                                gpointer self)
{
	break_timer_settings_break_manager_on_background_request_response ((BreakTimerSettingsBreakManager*) self, response, results);
}

static gboolean
break_timer_settings_break_manager_watch_background_request (BreakTimerSettingsBreakManager* self,
                                                             const char* request_path)
{
	const char* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (request_path != NULL, FALSE);
	_tmp0_ = self->priv->background_request_path;
	if (g_strcmp0 (request_path, _tmp0_) == 0) {
		result = TRUE;
		return result;
	}
	{
		BreakTimerCommonIPortalRequest* _tmp1_ = NULL;
		GDBusConnection* _tmp2_;
		BreakTimerCommonIPortalRequest* _tmp3_;
		BreakTimerCommonIPortalRequest* _tmp5_;
		char* _tmp6_;
		BreakTimerCommonIPortalRequest* _tmp7_;
		_tmp2_ = self->priv->dbus_connection;
		_tmp3_ = (BreakTimerCommonIPortalRequest*) g_initable_new (BREAK_TIMER_COMMON_TYPE_IPORTAL_REQUEST_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.portal.Desktop", "g-connection", _tmp2_, "g-object-path", (const gchar*) request_path, "g-interface-name", "org.freedesktop.portal.Request", NULL);
		_tmp1_ = (BreakTimerCommonIPortalRequest*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->background_request);
		self->priv->background_request = _tmp5_;
		_tmp6_ = g_strdup (request_path);
		_g_free0 (self->priv->background_request_path);
		self->priv->background_request_path = _tmp6_;
		_tmp7_ = self->priv->background_request;
		g_signal_connect_object (_tmp7_, "response", (GCallback) _break_timer_settings_break_manager_on_background_request_response_break_timer_common_iportal_request_response, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("BreakManager.vala:187: Error connecting to desktop portal: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = TRUE;
	return result;
}

static gboolean
_variant_get1 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gboolean
_variant_get2 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static void
break_timer_settings_break_manager_on_background_request_response (BreakTimerSettingsBreakManager* self,
                                                                   guint32 response,
                                                                   GHashTable* results)
{
	gboolean background_allowed = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_;
	gboolean autostart_allowed = FALSE;
	gconstpointer _tmp2_;
	gboolean _tmp3_;
	BreakTimerSettingsBreakManagerPermissionsError new_permissions_error = 0U;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = g_hash_table_lookup (results, "background");
	_tmp1_ = _variant_get1 ((GVariant*) _tmp0_);
	background_allowed = _tmp1_;
	_tmp2_ = g_hash_table_lookup (results, "autostart");
	_tmp3_ = _variant_get2 ((GVariant*) _tmp2_);
	autostart_allowed = _tmp3_;
	new_permissions_error = BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_NONE;
	_tmp5_ = self->priv->_master_enabled;
	if (_tmp5_) {
		_tmp4_ = !autostart_allowed;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		new_permissions_error |= BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_AUTOSTART_NOT_ALLOWED;
	}
	_tmp7_ = self->priv->_master_enabled;
	if (_tmp7_) {
		_tmp6_ = !background_allowed;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		new_permissions_error |= BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_BACKGROUND_NOT_ALLOWED;
	}
	break_timer_settings_break_manager_set_permissions_error (self, new_permissions_error);
	if (autostart_allowed) {
		break_timer_settings_break_manager_set_autostart_version (self, break_timer_settings_break_manager_CURRENT_AUTOSTART_VERSION);
	} else {
		break_timer_settings_break_manager_set_autostart_version (self, 0);
	}
	_g_object_unref0 (self->priv->background_request);
	self->priv->background_request = NULL;
}

static gboolean
break_timer_settings_break_manager_get_is_in_flatpak (BreakTimerSettingsBreakManager* self)
{
	gchar* flatpak_info_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_get_user_runtime_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "flatpak-info", NULL);
	flatpak_info_path = _tmp1_;
	result = g_file_test (flatpak_info_path, G_FILE_TEST_EXISTS);
	_g_free0 (flatpak_info_path);
	return result;
}

GList*
break_timer_settings_break_manager_all_breaks (BreakTimerSettingsBreakManager* self)
{
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->breaks;
	result = _tmp0_;
	return result;
}

/**
     * @returns true if the break daemon is working correctly.
     */
gboolean
break_timer_settings_break_manager_is_working (BreakTimerSettingsBreakManager* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_master_enabled;
	if (_tmp1_ == FALSE) {
		_tmp0_ = TRUE;
	} else {
		BreakTimerCommonIBreakTimer* _tmp2_;
		_tmp2_ = self->priv->break_daemon;
		_tmp0_ = _tmp2_ != NULL;
	}
	result = _tmp0_;
	return result;
}

static void
break_timer_settings_break_manager_break_status_changed (BreakTimerSettingsBreakManager* self,
                                                         BreakTimerSettingsBreakBreakType* break_type,
                                                         BreakTimerCommonBreakStatus* break_status)
{
	BreakTimerSettingsBreakBreakType* new_foreground_break = NULL;
	BreakTimerSettingsBreakBreakType* _tmp0_;
	BreakTimerSettingsBreakBreakType* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	BreakTimerSettingsBreakBreakType* _tmp6_;
	BreakTimerSettingsBreakBreakType* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (break_type != NULL);
	_tmp0_ = self->priv->_foreground_break;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	new_foreground_break = _tmp1_;
	if (break_status != NULL) {
		_tmp3_ = (*break_status).is_focused;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = (*break_status).is_active;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		BreakTimerSettingsBreakBreakType* _tmp4_;
		_tmp4_ = _g_object_ref0 (break_type);
		_g_object_unref0 (new_foreground_break);
		new_foreground_break = _tmp4_;
	} else {
		BreakTimerSettingsBreakBreakType* _tmp5_;
		_tmp5_ = self->priv->_foreground_break;
		if (_tmp5_ == break_type) {
			_g_object_unref0 (new_foreground_break);
			new_foreground_break = NULL;
		}
	}
	_tmp6_ = self->priv->_foreground_break;
	_tmp7_ = new_foreground_break;
	if (_tmp6_ != _tmp7_) {
		BreakTimerSettingsBreakBreakType* _tmp8_;
		_tmp8_ = new_foreground_break;
		break_timer_settings_break_manager_set_foreground_break (self, _tmp8_);
	}
	g_signal_emit (self, break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_STATUS_CHANGED_SIGNAL], 0);
	_g_object_unref0 (new_foreground_break);
}

static void
break_timer_settings_break_manager_break_daemon_appeared (BreakTimerSettingsBreakManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BreakTimerCommonIBreakTimer* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		BreakTimerCommonIBreakTimer* _tmp2_;
		BreakTimerCommonIBreakTimer* _tmp3_;
		_tmp1_ = self->priv->dbus_connection;
		_tmp2_ = (BreakTimerCommonIBreakTimer*) g_initable_new (BREAK_TIMER_COMMON_TYPE_IBREAK_TIMER_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", DAEMON_APPLICATION_ID, "g-connection", _tmp1_, "g-object-path", DAEMON_OBJECT_PATH, "g-interface-name", "org.gnome.BreakTimer", NULL);
		_tmp0_ = (BreakTimerCommonIBreakTimer*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->break_daemon);
		self->priv->break_daemon = _tmp3_;
		g_signal_emit (self, break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_BREAK_STATUS_AVAILABLE_SIGNAL], 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->break_daemon);
		self->priv->break_daemon = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("BreakManager.vala:264: Error connecting to break daemon service: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
break_timer_settings_break_manager_break_daemon_disappeared (BreakTimerSettingsBreakManager* self)
{
	gboolean _tmp0_ = FALSE;
	BreakTimerCommonIBreakTimer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->break_daemon;
	if (_tmp1_ == NULL) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_master_enabled;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		break_timer_settings_break_manager_launch_break_timer_service (self);
	}
	_g_object_unref0 (self->priv->break_daemon);
	self->priv->break_daemon = NULL;
	g_signal_emit (self, break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_STATUS_CHANGED_SIGNAL], 0);
}

static void
break_timer_settings_break_manager_launch_break_timer_service (BreakTimerSettingsBreakManager* self)
{
	GAppInfo* daemon_app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GAppLaunchContext* app_launch_context = NULL;
	GAppLaunchContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new (DAEMON_APPLICATION_ID ".desktop");
	daemon_app_info = (GAppInfo*) _tmp0_;
	_tmp1_ = g_app_launch_context_new ();
	app_launch_context = _tmp1_;
	{
		g_app_info_launch (daemon_app_info, NULL, app_launch_context, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("BreakManager.vala:286: Error launching daemon application: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_launch_context);
		_g_object_unref0 (daemon_app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_launch_context);
	_g_object_unref0 (daemon_app_info);
}

gint
break_timer_settings_break_manager_get_autostart_version (BreakTimerSettingsBreakManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_autostart_version;
	return result;
}

void
break_timer_settings_break_manager_set_autostart_version (BreakTimerSettingsBreakManager* self,
                                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_break_manager_get_autostart_version (self);
	if (old_value != value) {
		self->priv->_autostart_version = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY]);
	}
}

gboolean
break_timer_settings_break_manager_get_master_enabled (BreakTimerSettingsBreakManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_master_enabled;
	return result;
}

void
break_timer_settings_break_manager_set_master_enabled (BreakTimerSettingsBreakManager* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_break_manager_get_master_enabled (self);
	if (old_value != value) {
		self->priv->_master_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY]);
	}
}

gchar**
break_timer_settings_break_manager_get_selected_break_ids (BreakTimerSettingsBreakManager* self,
                                                           gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_break_ids;
	_tmp0__length1 = self->priv->_selected_break_ids_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
break_timer_settings_break_manager_set_selected_break_ids (BreakTimerSettingsBreakManager* self,
                                                           gchar** value,
                                                           gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_break_manager_get_selected_break_ids (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_selected_break_ids = (_vala_array_free (self->priv->_selected_break_ids, self->priv->_selected_break_ids_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_selected_break_ids = _tmp0_;
		self->priv->_selected_break_ids_length1 = _tmp0__length1;
		self->priv->__selected_break_ids_size_ = self->priv->_selected_break_ids_length1;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY]);
	}
}

BreakTimerSettingsBreakBreakType*
break_timer_settings_break_manager_get_foreground_break (BreakTimerSettingsBreakManager* self)
{
	BreakTimerSettingsBreakBreakType* result;
	BreakTimerSettingsBreakBreakType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_foreground_break;
	result = _tmp0_;
	return result;
}

static void
break_timer_settings_break_manager_set_foreground_break (BreakTimerSettingsBreakManager* self,
                                                         BreakTimerSettingsBreakBreakType* value)
{
	BreakTimerSettingsBreakBreakType* old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_break_manager_get_foreground_break (self);
	if (old_value != value) {
		BreakTimerSettingsBreakBreakType* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_foreground_break);
		self->priv->_foreground_break = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY]);
	}
}

BreakTimerSettingsBreakManagerPermissionsError
break_timer_settings_break_manager_get_permissions_error (BreakTimerSettingsBreakManager* self)
{
	BreakTimerSettingsBreakManagerPermissionsError result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_permissions_error;
	return result;
}

static void
break_timer_settings_break_manager_set_permissions_error (BreakTimerSettingsBreakManager* self,
                                                          BreakTimerSettingsBreakManagerPermissionsError value)
{
	BreakTimerSettingsBreakManagerPermissionsError old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_break_manager_get_permissions_error (self);
	if (old_value != value) {
		self->priv->_permissions_error = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY]);
	}
}

static void
break_timer_settings_break_manager_class_init (BreakTimerSettingsBreakManagerClass * klass,
                                               gpointer klass_data)
{
	break_timer_settings_break_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerSettingsBreakManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_settings_break_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_settings_break_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_settings_break_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY] = g_param_spec_int ("autostart-version", "autostart-version", "autostart-version", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY] = g_param_spec_boolean ("master-enabled", "master-enabled", "master-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY] = g_param_spec_boxed ("selected-break-ids", "selected-break-ids", "selected-break-ids", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY] = g_param_spec_object ("foreground-break", "foreground-break", "foreground-break", BREAK_TIMER_SETTINGS_BREAK_TYPE_BREAK_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY, break_timer_settings_break_manager_properties[BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY] = g_param_spec_flags ("permissions-error", "permissions-error", "permissions-error", BREAK_TIMER_SETTINGS_BREAK_MANAGER_TYPE_PERMISSIONS_ERROR, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_BREAK_STATUS_AVAILABLE_SIGNAL] = g_signal_new ("break-status-available", BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	break_timer_settings_break_manager_signals[BREAK_TIMER_SETTINGS_BREAK_MANAGER_STATUS_CHANGED_SIGNAL] = g_signal_new ("status-changed", BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
break_timer_settings_break_manager_instance_init (BreakTimerSettingsBreakManager * self,
                                                  gpointer klass)
{
	self->priv = break_timer_settings_break_manager_get_instance_private (self);
	self->priv->background_portal = NULL;
	self->priv->background_request = NULL;
	self->priv->background_request_path = NULL;
}

static void
break_timer_settings_break_manager_finalize (GObject * obj)
{
	BreakTimerSettingsBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER, BreakTimerSettingsBreakManager);
	_g_object_unref0 (self->priv->break_daemon);
	(self->priv->breaks == NULL) ? NULL : (self->priv->breaks = (_g_list_free__g_object_unref0_ (self->priv->breaks), NULL));
	_g_object_unref0 (self->priv->settings);
	self->priv->_selected_break_ids = (_vala_array_free (self->priv->_selected_break_ids, self->priv->_selected_break_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_foreground_break);
	_g_object_unref0 (self->priv->dbus_connection);
	_g_object_unref0 (self->priv->background_portal);
	_g_object_unref0 (self->priv->background_request);
	_g_free0 (self->priv->background_request_path);
	G_OBJECT_CLASS (break_timer_settings_break_manager_parent_class)->finalize (obj);
}

static GType
break_timer_settings_break_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerSettingsBreakManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_settings_break_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerSettingsBreakManager), 0, (GInstanceInitFunc) break_timer_settings_break_manager_instance_init, NULL };
	GType break_timer_settings_break_manager_type_id;
	break_timer_settings_break_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerSettingsBreakManager", &g_define_type_info, 0);
	BreakTimerSettingsBreakManager_private_offset = g_type_add_instance_private (break_timer_settings_break_manager_type_id, sizeof (BreakTimerSettingsBreakManagerPrivate));
	return break_timer_settings_break_manager_type_id;
}

GType
break_timer_settings_break_manager_get_type (void)
{
	static volatile gsize break_timer_settings_break_manager_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_break_manager_type_id__once)) {
		GType break_timer_settings_break_manager_type_id;
		break_timer_settings_break_manager_type_id = break_timer_settings_break_manager_get_type_once ();
		g_once_init_leave (&break_timer_settings_break_manager_type_id__once, break_timer_settings_break_manager_type_id);
	}
	return break_timer_settings_break_manager_type_id__once;
}

static void
_vala_break_timer_settings_break_manager_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	BreakTimerSettingsBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER, BreakTimerSettingsBreakManager);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY:
		g_value_set_int (value, break_timer_settings_break_manager_get_autostart_version (self));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY:
		g_value_set_boolean (value, break_timer_settings_break_manager_get_master_enabled (self));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, break_timer_settings_break_manager_get_selected_break_ids (self, &length));
		}
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY:
		g_value_set_object (value, break_timer_settings_break_manager_get_foreground_break (self));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY:
		g_value_set_flags (value, break_timer_settings_break_manager_get_permissions_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_settings_break_manager_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	BreakTimerSettingsBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_TYPE_BREAK_MANAGER, BreakTimerSettingsBreakManager);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY:
		break_timer_settings_break_manager_set_autostart_version (self, g_value_get_int (value));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_MASTER_ENABLED_PROPERTY:
		break_timer_settings_break_manager_set_master_enabled (self, g_value_get_boolean (value));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			break_timer_settings_break_manager_set_selected_break_ids (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_FOREGROUND_BREAK_PROPERTY:
		break_timer_settings_break_manager_set_foreground_break (self, g_value_get_object (value));
		break;
		case BREAK_TIMER_SETTINGS_BREAK_MANAGER_PERMISSIONS_ERROR_PROPERTY:
		break_timer_settings_break_manager_set_permissions_error (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

