/* BreakManager.c generated by valac 0.56.17, the Vala compiler
 * generated from BreakManager.vala, do not modify */

/* BreakManager.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "common.h"
#include <glib-object.h>
#include "config.h"
#include <json-glib/json-glib.h>
#include <glib/gstdio.h>

#define BREAK_TIMER_DAEMON_BREAK_MANAGER_BACKGROUND_STATUS_UPDATE_INTERVAL_SECONDS ((guint) 5)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_BREAK_MANAGER_0_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY,
	BREAK_TIMER_DAEMON_BREAK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BreakTimerDaemonBreakManagerPrivate {
	gint _autostart_version;
	gboolean _master_enabled;
	gchar** _selected_break_ids;
	gint _selected_break_ids_length1;
	gint __selected_break_ids_size_;
	GDBusConnection* dbus_connection;
	GSettings* settings;
	GHashTable* breaks;
	BreakTimerCommonIPortalBackground* background_portal;
	guint background_status_update_timeout_id;
	gchar* background_status_message;
};

static gint BreakTimerDaemonBreakManager_private_offset;
static gpointer break_timer_daemon_break_manager_parent_class = NULL;
static GInitableIface * break_timer_daemon_break_manager_g_initable_parent_iface = NULL;

static void break_timer_daemon_break_manager_stop_background_status_update_timeout (BreakTimerDaemonBreakManager* self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void break_timer_daemon_break_manager_update_enabled_breaks (BreakTimerDaemonBreakManager* self);
static void _break_timer_daemon_break_manager_update_enabled_breaks_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self);
static gboolean break_timer_daemon_break_manager_real_init (GInitable* base,
                                                     GCancellable* cancellable,
                                                     GError** error);
static gboolean break_timer_daemon_break_manager_get_is_in_flatpak (BreakTimerDaemonBreakManager* self);
static void break_timer_daemon_break_manager_start_background_status_update_timeout (BreakTimerDaemonBreakManager* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean break_timer_daemon_break_manager_background_status_update_cb (BreakTimerDaemonBreakManager* self);
static gboolean _break_timer_daemon_break_manager_background_status_update_cb_gsource_func (gpointer self);
static BreakTimerDaemonBreakBreakView* break_timer_daemon_break_manager_get_next_break_view (BreakTimerDaemonBreakManager* self);
static gchar* break_timer_daemon_break_manager_get_next_break_message (BreakTimerDaemonBreakManager* self);
static gboolean break_timer_daemon_break_manager_set_background_status_message (BreakTimerDaemonBreakManager* self,
                                                                         const gchar* message);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void break_timer_daemon_break_manager_finalize (GObject * obj);
static GType break_timer_daemon_break_manager_get_type_once (void);
static void _vala_break_timer_daemon_break_manager_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_break_timer_daemon_break_manager_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
break_timer_daemon_break_manager_get_instance_private (BreakTimerDaemonBreakManager* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonBreakManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_break_timer_daemon_break_manager_update_enabled_breaks_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self)
{
	break_timer_daemon_break_manager_update_enabled_breaks ((BreakTimerDaemonBreakManager*) self);
}

BreakTimerDaemonBreakManager*
break_timer_daemon_break_manager_construct (GType object_type,
                                            BreakTimerDaemonUIManager* ui_manager,
                                            BreakTimerDaemonActivityActivityMonitor* activity_monitor)
{
	BreakTimerDaemonBreakManager * self = NULL;
	GSettings* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	BreakTimerDaemonMicroBreakMicroBreakType* _tmp6_;
	GHashTable* _tmp7_;
	gchar* _tmp8_;
	BreakTimerDaemonRestBreakRestBreakType* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	g_return_val_if_fail (ui_manager != NULL, NULL);
	g_return_val_if_fail (activity_monitor != NULL, NULL);
	self = (BreakTimerDaemonBreakManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new (APPLICATION_ID);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->breaks);
	self->priv->breaks = _tmp3_;
	_tmp4_ = self->priv->breaks;
	_tmp5_ = g_strdup ("microbreak");
	_tmp6_ = break_timer_daemon_micro_break_micro_break_type_new (activity_monitor, ui_manager);
	g_hash_table_insert (_tmp4_, _tmp5_, (BreakTimerDaemonBreakBreakType*) _tmp6_);
	_tmp7_ = self->priv->breaks;
	_tmp8_ = g_strdup ("restbreak");
	_tmp9_ = break_timer_daemon_rest_break_rest_break_type_new (activity_monitor, ui_manager);
	g_hash_table_insert (_tmp7_, _tmp8_, (BreakTimerDaemonBreakBreakType*) _tmp9_);
	_tmp10_ = self->priv->settings;
	g_settings_bind (_tmp10_, "autostart-version", (GObject*) self, "autostart-version", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = self->priv->settings;
	g_settings_bind (_tmp11_, "enabled", (GObject*) self, "master-enabled", G_SETTINGS_BIND_DEFAULT);
	_tmp12_ = self->priv->settings;
	g_settings_bind (_tmp12_, "selected-breaks", (GObject*) self, "selected-break-ids", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GObject*) self, "notify::master-enabled", (GCallback) _break_timer_daemon_break_manager_update_enabled_breaks_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::selected-break-ids", (GCallback) _break_timer_daemon_break_manager_update_enabled_breaks_g_object_notify, self, 0);
	break_timer_daemon_break_manager_update_enabled_breaks (self);
	return self;
}

BreakTimerDaemonBreakManager*
break_timer_daemon_break_manager_new (BreakTimerDaemonUIManager* ui_manager,
                                      BreakTimerDaemonActivityActivityMonitor* activity_monitor)
{
	return break_timer_daemon_break_manager_construct (BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER, ui_manager, activity_monitor);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
break_timer_daemon_break_manager_real_init (GInitable* base,
                                            GCancellable* cancellable,
                                            GError** error)
{
	BreakTimerDaemonBreakManager * self;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp9_;
	BreakTimerDaemonBreakManagerDBusObject* _tmp10_;
	BreakTimerDaemonBreakManagerDBusObject* _tmp11_;
	GList* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (BreakTimerDaemonBreakManager*) base;
	_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, cancellable, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->dbus_connection);
	self->priv->dbus_connection = _tmp3_;
	if (break_timer_daemon_break_manager_get_is_in_flatpak (self)) {
		BreakTimerCommonIPortalBackground* _tmp4_ = NULL;
		GDBusConnection* _tmp5_;
		BreakTimerCommonIPortalBackground* _tmp6_;
		BreakTimerCommonIPortalBackground* _tmp8_;
		_tmp5_ = self->priv->dbus_connection;
		_tmp6_ = (BreakTimerCommonIPortalBackground*) g_initable_new (BREAK_TIMER_COMMON_TYPE_IPORTAL_BACKGROUND_PROXY, cancellable, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.portal.Desktop", "g-connection", _tmp5_, "g-object-path", "/org/freedesktop/portal/desktop", "g-interface-name", "org.freedesktop.portal.Background", NULL);
		_tmp4_ = (BreakTimerCommonIPortalBackground*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return _tmp7_;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->background_portal);
		self->priv->background_portal = _tmp8_;
		break_timer_daemon_break_manager_start_background_status_update_timeout (self);
		_g_object_unref0 (_tmp4_);
	}
	_tmp9_ = self->priv->dbus_connection;
	_tmp10_ = break_timer_daemon_break_manager_dbus_object_new (self);
	_tmp11_ = _tmp10_;
	break_timer_daemon_break_manager_dbus_object_register_object (_tmp11_, _tmp9_, DAEMON_OBJECT_PATH, &_inner_error0_);
	_g_object_unref0 (_tmp11_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp12_;
	}
	_tmp13_ = break_timer_daemon_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp13_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp14_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp14_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp14_;
			{
				BreakTimerDaemonBreakBreakType* _tmp15_;
				_tmp15_ = break_type;
				break_timer_daemon_break_break_type_init (_tmp15_, cancellable, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp16_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (break_type);
					(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
					_g_object_unref0 (_tmp0_);
					return _tmp16_;
				}
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	result = TRUE;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

JsonObject*
break_timer_daemon_break_manager_serialize (BreakTimerDaemonBreakManager* self)
{
	JsonObject* json_root = NULL;
	JsonObject* _tmp0_;
	GList* _tmp1_;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_object_new ();
	json_root = _tmp0_;
	_tmp1_ = break_timer_daemon_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp1_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp2_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp2_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp2_;
			{
				JsonObject* break_json = NULL;
				BreakTimerDaemonBreakBreakType* _tmp3_;
				BreakTimerDaemonBreakBreakController* _tmp4_;
				BreakTimerDaemonBreakBreakController* _tmp5_;
				JsonObject* _tmp6_;
				JsonObject* _tmp7_;
				BreakTimerDaemonBreakBreakType* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				JsonObject* _tmp11_;
				JsonObject* _tmp12_;
				_tmp3_ = break_type;
				_tmp4_ = break_timer_daemon_break_break_type_get_break_controller (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = break_timer_daemon_break_break_controller_serialize (_tmp5_);
				break_json = _tmp6_;
				_tmp7_ = json_root;
				_tmp8_ = break_type;
				_tmp9_ = break_timer_daemon_break_break_type_get_id (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = break_json;
				_tmp12_ = _json_object_ref0 (_tmp11_);
				json_object_set_object_member (_tmp7_, _tmp10_, _tmp12_);
				_json_object_unref0 (break_json);
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	result = json_root;
	return result;
}

void
break_timer_daemon_break_manager_deserialize (BreakTimerDaemonBreakManager* self,
                                              JsonObject** json_root)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*json_root != NULL);
	_tmp0_ = break_timer_daemon_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp0_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp1_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp1_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp1_;
			{
				JsonObject* break_json = NULL;
				BreakTimerDaemonBreakBreakType* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				JsonObject* _tmp5_;
				JsonObject* _tmp6_;
				JsonObject* _tmp7_;
				_tmp2_ = break_type;
				_tmp3_ = break_timer_daemon_break_break_type_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = json_object_get_object_member (*json_root, _tmp4_);
				_tmp6_ = _json_object_ref0 (_tmp5_);
				break_json = _tmp6_;
				_tmp7_ = break_json;
				if (_tmp7_ != NULL) {
					BreakTimerDaemonBreakBreakType* _tmp8_;
					BreakTimerDaemonBreakBreakController* _tmp9_;
					BreakTimerDaemonBreakBreakController* _tmp10_;
					_tmp8_ = break_type;
					_tmp9_ = break_timer_daemon_break_break_type_get_break_controller (_tmp8_);
					_tmp10_ = _tmp9_;
					break_timer_daemon_break_break_controller_deserialize (_tmp10_, &break_json);
				}
				_json_object_unref0 (break_json);
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
}

GList*
break_timer_daemon_break_manager_all_break_ids (BreakTimerDaemonBreakManager* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->breaks;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	result = _tmp1_;
	return result;
}

GList*
break_timer_daemon_break_manager_all_breaks (BreakTimerDaemonBreakManager* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->breaks;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

BreakTimerDaemonBreakBreakType*
break_timer_daemon_break_manager_get_break_type_for_name (BreakTimerDaemonBreakManager* self,
                                                          const gchar* name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BreakTimerDaemonBreakBreakType* _tmp2_;
	BreakTimerDaemonBreakBreakType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->breaks;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) _tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
break_timer_daemon_break_manager_get_is_in_flatpak (BreakTimerDaemonBreakManager* self)
{
	gchar* flatpak_info_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_get_user_runtime_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "flatpak-info", NULL);
	flatpak_info_path = _tmp1_;
	result = g_file_test (flatpak_info_path, G_FILE_TEST_EXISTS);
	_g_free0 (flatpak_info_path);
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
break_timer_daemon_break_manager_update_enabled_breaks (BreakTimerDaemonBreakManager* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp0_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp1_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp1_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_;
				gboolean is_enabled = FALSE;
				BreakTimerDaemonBreakBreakType* _tmp10_;
				BreakTimerDaemonBreakBreakController* _tmp11_;
				BreakTimerDaemonBreakBreakController* _tmp12_;
				_tmp3_ = self->priv->_master_enabled;
				if (_tmp3_) {
					BreakTimerDaemonBreakBreakType* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_ = 0;
					gchar** _tmp9_;
					gint _tmp9__length1;
					_tmp4_ = break_type;
					_tmp5_ = break_timer_daemon_break_break_type_get_id (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = break_timer_daemon_break_manager_get_selected_break_ids (self, &_tmp8_);
					_tmp7__length1 = _tmp8_;
					_tmp9_ = _tmp7_;
					_tmp9__length1 = _tmp7__length1;
					_tmp2_ = _vala_string_array_contains (_tmp9_, _tmp9__length1, _tmp6_);
				} else {
					_tmp2_ = FALSE;
				}
				is_enabled = _tmp2_;
				_tmp10_ = break_type;
				_tmp11_ = break_timer_daemon_break_break_type_get_break_controller (_tmp10_);
				_tmp12_ = _tmp11_;
				break_timer_daemon_break_break_controller_set_enabled (_tmp12_, is_enabled);
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
}

static gboolean
_break_timer_daemon_break_manager_background_status_update_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = break_timer_daemon_break_manager_background_status_update_cb ((BreakTimerDaemonBreakManager*) self);
	return result;
}

static void
break_timer_daemon_break_manager_start_background_status_update_timeout (BreakTimerDaemonBreakManager* self)
{
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->background_status_update_timeout_id == ((guint) 0), "this.background_status_update_timeout_id == 0");
	self->priv->background_status_update_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, BREAK_TIMER_DAEMON_BREAK_MANAGER_BACKGROUND_STATUS_UPDATE_INTERVAL_SECONDS, _break_timer_daemon_break_manager_background_status_update_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
break_timer_daemon_break_manager_stop_background_status_update_timeout (BreakTimerDaemonBreakManager* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->background_status_update_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->background_status_update_timeout_id);
		self->priv->background_status_update_timeout_id = (guint) 0;
	}
}

static BreakTimerDaemonBreakBreakView*
break_timer_daemon_break_manager_get_next_break_view (BreakTimerDaemonBreakManager* self)
{
	BreakTimerDaemonBreakBreakView* next_break_view = NULL;
	GList* _tmp0_;
	BreakTimerDaemonBreakBreakView* result;
	g_return_val_if_fail (self != NULL, NULL);
	next_break_view = NULL;
	_tmp0_ = break_timer_daemon_break_manager_all_breaks (self);
	{
		GList* break_type_collection = NULL;
		GList* break_type_it = NULL;
		break_type_collection = _tmp0_;
		for (break_type_it = break_type_collection; break_type_it != NULL; break_type_it = break_type_it->next) {
			BreakTimerDaemonBreakBreakType* _tmp1_;
			BreakTimerDaemonBreakBreakType* break_type = NULL;
			_tmp1_ = _g_object_ref0 ((BreakTimerDaemonBreakBreakType*) break_type_it->data);
			break_type = _tmp1_;
			{
				BreakTimerDaemonBreakBreakType* _tmp2_;
				BreakTimerDaemonBreakBreakController* _tmp3_;
				BreakTimerDaemonBreakBreakController* _tmp4_;
				BreakTimerDaemonBreakBreakView* _tmp5_;
				_tmp2_ = break_type;
				_tmp3_ = break_timer_daemon_break_break_type_get_break_controller (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!break_timer_daemon_break_break_controller_is_enabled (_tmp4_)) {
					_g_object_unref0 (break_type);
					continue;
				}
				_tmp5_ = next_break_view;
				if (_tmp5_ == NULL) {
					BreakTimerDaemonBreakBreakType* _tmp6_;
					BreakTimerDaemonBreakBreakView* _tmp7_;
					BreakTimerDaemonBreakBreakView* _tmp8_;
					BreakTimerDaemonBreakBreakView* _tmp9_;
					_tmp6_ = break_type;
					_tmp7_ = break_timer_daemon_break_break_type_get_break_view (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (next_break_view);
					next_break_view = _tmp9_;
				} else {
					BreakTimerDaemonBreakBreakType* _tmp10_;
					BreakTimerDaemonBreakBreakView* _tmp11_;
					BreakTimerDaemonBreakBreakView* _tmp12_;
					BreakTimerDaemonBreakBreakView* _tmp13_;
					_tmp10_ = break_type;
					_tmp11_ = break_timer_daemon_break_break_type_get_break_view (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = next_break_view;
					if (break_timer_daemon_ui_fragment_has_higher_focus_priority ((BreakTimerDaemonUIFragment*) _tmp12_, (BreakTimerDaemonUIFragment*) _tmp13_)) {
						BreakTimerDaemonBreakBreakType* _tmp14_;
						BreakTimerDaemonBreakBreakView* _tmp15_;
						BreakTimerDaemonBreakBreakView* _tmp16_;
						BreakTimerDaemonBreakBreakView* _tmp17_;
						_tmp14_ = break_type;
						_tmp15_ = break_timer_daemon_break_break_type_get_break_view (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = _g_object_ref0 (_tmp16_);
						_g_object_unref0 (next_break_view);
						next_break_view = _tmp17_;
					}
				}
				_g_object_unref0 (break_type);
			}
		}
		(break_type_collection == NULL) ? NULL : (break_type_collection = (g_list_free (break_type_collection), NULL));
	}
	result = next_break_view;
	return result;
}

static gchar*
break_timer_daemon_break_manager_get_next_break_message (BreakTimerDaemonBreakManager* self)
{
	BreakTimerDaemonBreakBreakView* next_break_view = NULL;
	BreakTimerDaemonBreakBreakView* _tmp0_;
	BreakTimerDaemonBreakBreakView* _tmp1_;
	BreakTimerDaemonBreakBreakView* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = break_timer_daemon_break_manager_get_next_break_view (self);
	next_break_view = _tmp0_;
	_tmp1_ = next_break_view;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (next_break_view);
		return result;
	}
	_tmp2_ = next_break_view;
	_tmp3_ = break_timer_daemon_break_break_view_get_status_message (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (next_break_view);
	return result;
}

static gboolean
break_timer_daemon_break_manager_background_status_update_cb (BreakTimerDaemonBreakManager* self)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* message = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = break_timer_daemon_break_manager_get_next_break_message (self);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	message = _tmp3_;
	_tmp4_ = message;
	if (!break_timer_daemon_break_manager_set_background_status_message (self, _tmp4_)) {
		self->priv->background_status_update_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		_g_free0 (message);
		_g_free0 (_tmp0_);
		return result;
	}
	result = G_SOURCE_CONTINUE;
	_g_free0 (message);
	_g_free0 (_tmp0_);
	return result;
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gboolean
break_timer_daemon_break_manager_set_background_status_message (BreakTimerDaemonBreakManager* self,
                                                                const gchar* message)
{
	BreakTimerCommonIPortalBackground* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* options = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	GVariant* _tmp7_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->priv->background_portal;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->background_status_message;
	if (g_strcmp0 (_tmp1_, message) == 0) {
		result = TRUE;
		return result;
	}
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_variant_unref0_);
	options = _tmp4_;
	_tmp5_ = options;
	_tmp6_ = g_strdup ("message");
	_tmp7_ = _variant_new1 (message);
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
	{
		BreakTimerCommonIPortalBackground* _tmp8_;
		GHashTable* _tmp9_;
		_tmp8_ = self->priv->background_portal;
		_tmp9_ = options;
		break_timer_common_iportal_background_set_status (_tmp8_, _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			_g_hash_table_unref0 (options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning ("BreakManager.vala:208: Error connecting to desktop portal: %s", _tmp12_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_hash_table_unref0 (options);
		return result;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning ("BreakManager.vala:211: Error setting status message: %s", _tmp14_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_hash_table_unref0 (options);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		_g_hash_table_unref0 (options);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = g_strdup (message);
	_g_free0 (self->priv->background_status_message);
	self->priv->background_status_message = _tmp16_;
	result = TRUE;
	_g_hash_table_unref0 (options);
	return result;
}

gint
break_timer_daemon_break_manager_get_autostart_version (BreakTimerDaemonBreakManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_autostart_version;
	return result;
}

void
break_timer_daemon_break_manager_set_autostart_version (BreakTimerDaemonBreakManager* self,
                                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_break_manager_get_autostart_version (self);
	if (old_value != value) {
		self->priv->_autostart_version = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY]);
	}
}

gboolean
break_timer_daemon_break_manager_get_master_enabled (BreakTimerDaemonBreakManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_master_enabled;
	return result;
}

void
break_timer_daemon_break_manager_set_master_enabled (BreakTimerDaemonBreakManager* self,
                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_break_manager_get_master_enabled (self);
	if (old_value != value) {
		self->priv->_master_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY]);
	}
}

gchar**
break_timer_daemon_break_manager_get_selected_break_ids (BreakTimerDaemonBreakManager* self,
                                                         gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_break_ids;
	_tmp0__length1 = self->priv->_selected_break_ids_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
break_timer_daemon_break_manager_set_selected_break_ids (BreakTimerDaemonBreakManager* self,
                                                         gchar** value,
                                                         gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_break_manager_get_selected_break_ids (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_selected_break_ids = (_vala_array_free (self->priv->_selected_break_ids, self->priv->_selected_break_ids_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_selected_break_ids = _tmp0_;
		self->priv->_selected_break_ids_length1 = _tmp0__length1;
		self->priv->__selected_break_ids_size_ = self->priv->_selected_break_ids_length1;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY]);
	}
}

static void
break_timer_daemon_break_manager_class_init (BreakTimerDaemonBreakManagerClass * klass,
                                             gpointer klass_data)
{
	break_timer_daemon_break_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonBreakManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_break_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_daemon_break_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_break_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY] = g_param_spec_int ("autostart-version", "autostart-version", "autostart-version", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY] = g_param_spec_boolean ("master-enabled", "master-enabled", "master-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY, break_timer_daemon_break_manager_properties[BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY] = g_param_spec_boxed ("selected-break-ids", "selected-break-ids", "selected-break-ids", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
break_timer_daemon_break_manager_g_initable_interface_init (GInitableIface * iface,
                                                            gpointer iface_data)
{
	break_timer_daemon_break_manager_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) break_timer_daemon_break_manager_real_init;
}

static void
break_timer_daemon_break_manager_instance_init (BreakTimerDaemonBreakManager * self,
                                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = break_timer_daemon_break_manager_get_instance_private (self);
	self->priv->background_portal = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->background_status_message = _tmp0_;
}

static void
break_timer_daemon_break_manager_finalize (GObject * obj)
{
	BreakTimerDaemonBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER, BreakTimerDaemonBreakManager);
	break_timer_daemon_break_manager_stop_background_status_update_timeout (self);
	self->priv->_selected_break_ids = (_vala_array_free (self->priv->_selected_break_ids, self->priv->_selected_break_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->dbus_connection);
	_g_object_unref0 (self->priv->settings);
	_g_hash_table_unref0 (self->priv->breaks);
	_g_object_unref0 (self->priv->background_portal);
	_g_free0 (self->priv->background_status_message);
	G_OBJECT_CLASS (break_timer_daemon_break_manager_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_break_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonBreakManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_break_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonBreakManager), 0, (GInstanceInitFunc) break_timer_daemon_break_manager_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) break_timer_daemon_break_manager_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_break_manager_type_id;
	break_timer_daemon_break_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonBreakManager", &g_define_type_info, 0);
	g_type_add_interface_static (break_timer_daemon_break_manager_type_id, g_initable_get_type (), &g_initable_info);
	BreakTimerDaemonBreakManager_private_offset = g_type_add_instance_private (break_timer_daemon_break_manager_type_id, sizeof (BreakTimerDaemonBreakManagerPrivate));
	return break_timer_daemon_break_manager_type_id;
}

GType
break_timer_daemon_break_manager_get_type (void)
{
	static volatile gsize break_timer_daemon_break_manager_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_break_manager_type_id__once)) {
		GType break_timer_daemon_break_manager_type_id;
		break_timer_daemon_break_manager_type_id = break_timer_daemon_break_manager_get_type_once ();
		g_once_init_leave (&break_timer_daemon_break_manager_type_id__once, break_timer_daemon_break_manager_type_id);
	}
	return break_timer_daemon_break_manager_type_id__once;
}

static void
_vala_break_timer_daemon_break_manager_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	BreakTimerDaemonBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER, BreakTimerDaemonBreakManager);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY:
		g_value_set_int (value, break_timer_daemon_break_manager_get_autostart_version (self));
		break;
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY:
		g_value_set_boolean (value, break_timer_daemon_break_manager_get_master_enabled (self));
		break;
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, break_timer_daemon_break_manager_get_selected_break_ids (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_daemon_break_manager_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	BreakTimerDaemonBreakManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_TYPE_BREAK_MANAGER, BreakTimerDaemonBreakManager);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_AUTOSTART_VERSION_PROPERTY:
		break_timer_daemon_break_manager_set_autostart_version (self, g_value_get_int (value));
		break;
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_MASTER_ENABLED_PROPERTY:
		break_timer_daemon_break_manager_set_master_enabled (self, g_value_get_boolean (value));
		break;
		case BREAK_TIMER_DAEMON_BREAK_MANAGER_SELECTED_BREAK_IDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			break_timer_daemon_break_manager_set_selected_break_ids (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

